/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemVersion
extends AbstractPSystem {
    private final List<String> strings = new ArrayList<String>();
    private BufferedImage image;
    private static BufferedImage transparentIcon;

    PSystemVersion(boolean bl, List<String> list) {
        this.strings.addAll(list);
        if (bl) {
            this.image = PSystemVersion.getPlantumlImage();
        }
    }

    public static BufferedImage getPlantumlImage() {
        try {
            InputStream inputStream = PSystemVersion.class.getResourceAsStream("logo.png");
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            return bufferedImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getPlantumlSmallIcon() {
        try {
            InputStream inputStream = PSystemVersion.class.getResourceAsStream("favicon.png");
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            return bufferedImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getPlantumlSmallIcon2() {
        if (transparentIcon != null) {
            return transparentIcon;
        }
        BufferedImage bufferedImage = PSystemVersion.getPlantumlSmallIcon();
        if (bufferedImage == null) {
            return null;
        }
        transparentIcon = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n = bufferedImage.getRGB(i, j);
                if (n == bufferedImage.getRGB(0, 0)) continue;
                transparentIcon.setRGB(i, j, n);
            }
        }
        return transparentIcon;
    }

    @Override
    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        return this.getGraphicStrings().exportDiagram(outputStream, fileFormatOption);
    }

    public static PSystemVersion createShowVersion() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<b>PlantUML version " + Version.versionString() + "</b> (" + new Date(Version.compileTime()) + ")");
        arrayList.add("(" + (Object)((Object)License.getCurrent()) + " source distribution)");
        arrayList.add(" ");
        arrayList.addAll(GraphvizUtils.getTestDotStrings(true));
        arrayList.add(" ");
        Properties properties = System.getProperties();
        arrayList.add(properties.getProperty("java.runtime.name"));
        arrayList.add(properties.getProperty("java.vm.name"));
        arrayList.add(properties.getProperty("java.runtime.version"));
        arrayList.add(properties.getProperty("os.name"));
        arrayList.add("Processors: " + Runtime.getRuntime().availableProcessors());
        return new PSystemVersion(true, arrayList);
    }

    public static PSystemVersion createShowAuthors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<b>PlantUML version " + Version.versionString() + "</b> (" + new Date(Version.compileTime()) + ")");
        arrayList.add("(" + (Object)((Object)License.getCurrent()) + " source distribution)");
        arrayList.add(" ");
        arrayList.add("<u>Original idea</u>: Arnaud Roques");
        arrayList.add("<u>Word Macro</u>: Alain Bertucat & Matthieu Sabatier");
        arrayList.add("<u>Word Add-in</u>: Adriaan van den Brand");
        arrayList.add("<u>Eclipse Plugin</u>: Claude Durif & Anne Pecoil");
        arrayList.add("<u>Servlet & XWiki</u>: Maxime Sinclair");
        arrayList.add("<u>Site design</u>: Raphael Cotisson");
        arrayList.add("<u>Logo</u>: Benjamin Croizet");
        arrayList.add(" ");
        arrayList.add("http://plantuml.sourceforge.net");
        arrayList.add(" ");
        return new PSystemVersion(true, arrayList);
    }

    public static PSystemVersion createCheckVersions(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<b>PlantUML version " + Version.versionString() + "</b> (" + new Date(Version.compileTime()) + ")");
        int n = PSystemVersion.extractDownloadableVersion(string, string2);
        int n2 = 7;
        if (n == -1) {
            arrayList.add("<b><color:red>Error</b>");
            arrayList.add("<color:red>Cannot connect to http://plantuml.sourceforge.net/</b>");
            arrayList.add("Maybe you should set your proxy ?");
            arrayList.add("@startuml");
            arrayList.add("checkversion(proxy=myproxy.com,port=8080)");
            arrayList.add("@enduml");
            n2 = 9;
        } else if (n == 0) {
            arrayList.add("<b><color:red>Error</b>");
            arrayList.add("Cannot retrieve last version from http://plantuml.sourceforge.net/</b>");
        } else {
            arrayList.add("<b>Last available version for download</b> : " + n);
            arrayList.add(" ");
            if (Version.version() >= n) {
                arrayList.add("<b><color:green>Your version is up to date.</b>");
            } else {
                arrayList.add("<b><color:red>A newer version is available for download.</b>");
            }
        }
        while (arrayList.size() < n2) {
            arrayList.add(" ");
        }
        return new PSystemVersion(true, arrayList);
    }

    public static int extractDownloadableVersion(String string, String string2) {
        if (string != null && string2 != null) {
            System.setProperty("http.proxyHost", string);
            System.setProperty("http.proxyPort", string2);
        }
        try {
            URL uRL = new URL("http://plantuml.sourceforge.net/download.html");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setUseCaches(false);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                int n = PSystemVersion.extractVersion(bufferedReader);
                bufferedReader.close();
                httpURLConnection.disconnect();
                return n;
            }
        }
        catch (IOException iOException) {
            Log.error(iOException.toString());
        }
        return -1;
    }

    private static int extractVersion(BufferedReader bufferedReader) throws IOException {
        String string;
        Pattern pattern = Pattern.compile(".*\\.(\\d{4,5})\\..*");
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            String string2 = matcher.group(1);
            return Integer.parseInt(string2);
        }
        return 0;
    }

    public static PSystemVersion createTestDot() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(GraphvizUtils.getTestDotStrings(true));
        return new PSystemVersion(false, arrayList);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        UFont uFont = new UFont("SansSerif", 0, 12);
        return new GraphicStrings(this.strings, uFont, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, this.image, GraphicPosition.BACKGROUND_CORNER);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Version)", this.getClass());
    }

    public List<String> getLines() {
        return Collections.unmodifiableList(this.strings);
    }
}

