/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUGraphic<O>
extends AbstractCommonUGraphic {
    private final O g2d;
    private final Map<Class<? extends UShape>, UDriver<O>> drivers = new HashMap<Class<? extends UShape>, UDriver<O>>();

    public AbstractUGraphic(ColorMapper colorMapper, O o) {
        super(colorMapper);
        this.g2d = o;
    }

    protected AbstractUGraphic(AbstractUGraphic<O> abstractUGraphic) {
        super(abstractUGraphic);
        this.g2d = abstractUGraphic.g2d;
    }

    protected final O getGraphicObject() {
        return this.g2d;
    }

    protected boolean manageHiddenAutomatically() {
        return true;
    }

    protected final void registerDriver(Class<? extends UShape> clazz, UDriver<O> uDriver) {
        this.drivers.put(clazz, uDriver);
    }

    @Override
    public final void draw(UShape uShape) {
        if (uShape instanceof UEmpty) {
            return;
        }
        UDriver<O> uDriver = this.drivers.get(uShape.getClass());
        if (uDriver == null) {
            throw new UnsupportedOperationException(uShape.getClass().toString() + " " + this.getClass());
        }
        if (this.getParam().isHidden() && this.manageHiddenAutomatically()) {
            return;
        }
        this.beforeDraw();
        uDriver.draw(uShape, this.getTranslateX(), this.getTranslateY(), this.getColorMapper(), this.getParam(), this.g2d);
        this.afterDraw();
    }

    protected void beforeDraw() {
    }

    protected void afterDraw() {
    }
}

