/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.syntax;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.syntax.SyntaxResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxChecker {
    public static SyntaxResult checkSyntax(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        return SyntaxChecker.checkSyntax(stringBuilder.toString());
    }

    public static SyntaxResult checkSyntax(String string) {
        OptionFlags.getInstance().setQuiet(true);
        SyntaxResult syntaxResult = new SyntaxResult();
        if (!string.startsWith("@startuml\n")) {
            syntaxResult.setError(true);
            syntaxResult.setErrorLinePosition(0);
            syntaxResult.addErrorText("No @startuml found");
            syntaxResult.setSuggest(Arrays.asList("Did you mean:", "@startuml"));
            return syntaxResult;
        }
        if (!string.endsWith("@enduml\n") && !string.endsWith("@enduml")) {
            syntaxResult.setError(true);
            syntaxResult.setErrorLinePosition(SyntaxChecker.lastLineNumber(string));
            syntaxResult.addErrorText("No @enduml found");
            syntaxResult.setSuggest(Arrays.asList("Did you mean:", "@enduml"));
            return syntaxResult;
        }
        SourceStringReader sourceStringReader = new SourceStringReader(new Defines(), string, Collections.<String>emptyList());
        Diagram diagram = sourceStringReader.getBlocks().get(0).getDiagram();
        if (diagram instanceof UmlDiagram) {
            syntaxResult.setUmlDiagramType(((UmlDiagram)diagram).getUmlDiagramType());
            syntaxResult.setDescription(diagram.getDescription().getDescription());
        } else if (diagram instanceof PSystemError) {
            syntaxResult.setError(true);
            PSystemError pSystemError = (PSystemError)diagram;
            syntaxResult.setErrorLinePosition(pSystemError.getHigherErrorPosition());
            for (ErrorUml errorUml : pSystemError.getErrorsUml()) {
                syntaxResult.addErrorText(errorUml.getError());
            }
            syntaxResult.setSuggest(pSystemError.getSuggest());
        } else {
            syntaxResult.setDescription(diagram.getDescription().getDescription());
        }
        return syntaxResult;
    }

    private static int lastLineNumber(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }
}

