/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageObject
extends AbstractEntityImage
implements Stencil {
    private final TextBlock name;
    private final TextBlock stereo;
    private final TextBlock fields;
    private final Url url;
    private final double roundCorner;
    private int marginEmptyFieldsOrMethod = 13;
    private int xMarginCircle = 5;

    public EntityImageObject(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.roundCorner = iSkinParam.getRoundCorner();
        this.name = TextBlockUtils.withMargin(TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.OBJECT, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.OBJECT, stereotype)), HorizontalAlignment.CENTER, iSkinParam), 2.0, 2.0);
        this.stereo = stereotype == null || stereotype.getLabel() == null ? null : TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.OBJECT_STEREOTYPE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.OBJECT_STEREOTYPE, stereotype)), HorizontalAlignment.CENTER, iSkinParam);
        this.fields = iLeaf.getFieldsToDisplay().size() == 0 ? new TextBlockLineBefore(new TextBlockEmpty(10.0, 16.0)) : iLeaf.getBody(new PortionShower(){

            public boolean showPortion(EntityPortion entityPortion, ILeaf iLeaf) {
                return true;
            }
        }).asTextBlock(FontParam.OBJECT_ATTRIBUTE, iSkinParam);
        this.url = iLeaf.getUrl99();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getTitleDimension(stringBounder);
        Dimension2D dimension2D2 = this.fields.calculateDimension(stringBounder);
        double d = Math.max(dimension2D2.getWidth(), dimension2D.getWidth() + (double)(2 * this.xMarginCircle));
        double d2 = this.getMethodOrFieldHeight(dimension2D2) + dimension2D.getHeight();
        return new Dimension2DDouble(d, d2);
    }

    public final void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.getTitleDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d, d2, this.roundCorner, this.roundCorner);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.objectBorder, this.getStereo())));
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.objectBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor));
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        UStroke uStroke = new UStroke(1.5);
        uGraphic.apply(uStroke).draw(uRectangle);
        ULayoutGroup uLayoutGroup = new ULayoutGroup(new PlacementStrategyY1Y2(uGraphic.getStringBounder()));
        if (this.stereo != null) {
            uLayoutGroup.add(this.stereo);
        }
        uLayoutGroup.add(this.name);
        uLayoutGroup.drawU(uGraphic, 0.0, 0.0, dimension2D.getWidth(), dimension2D2.getHeight());
        UGraphicStencil uGraphicStencil = new UGraphicStencil(uGraphic, this, uStroke);
        this.fields.drawU(uGraphicStencil.apply(new UTranslate(0.0, dimension2D2.getHeight())));
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    private double getMethodOrFieldHeight(Dimension2D dimension2D) {
        double d = dimension2D.getHeight();
        if (d == 0.0) {
            return this.marginEmptyFieldsOrMethod;
        }
        return d;
    }

    private Dimension2D getTitleDimension(StringBounder stringBounder) {
        return this.getNameAndSteretypeDimension(stringBounder);
    }

    private Dimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.stereo == null ? new Dimension2DDouble(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(Math.max(dimension2D.getWidth(), dimension2D2.getWidth()), dimension2D.getHeight() + dimension2D2.getHeight());
        return dimension2DDouble;
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }

    public double getStartingX(StringBounder stringBounder, double d) {
        return 0.0;
    }

    public double getEndingX(StringBounder stringBounder, double d) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

