/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.InnerActivity;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupPngMakerActivity {
    private final CucaDiagram diagram;
    private final IGroup group;
    private final Rose rose = new Rose();

    public GroupPngMakerActivity(CucaDiagram cucaDiagram, IGroup iGroup) {
        this.diagram = cucaDiagram;
        this.group = iGroup;
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            IEntity iEntity = link.getEntity1();
            IEntity iEntity2 = link.getEntity2();
            if (iEntity.getParentContainer() != this.group || iEntity.isGroup() || iEntity2.getParentContainer() != this.group || iEntity2.isGroup()) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    public IEntityImage getImage() throws IOException, InterruptedException {
        if (this.group.size() == 0) {
            return new EntityImageState(this.group, this.diagram.getSkinParam());
        }
        List<Link> list = this.getPureInnerLinks();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        DotData dotData = new DotData(this.group, list, this.group.getLeafsDirect(), this.diagram.getUmlDiagramType(), iSkinParam, this.group.getRankdir(), new InnerGroupHierarchy(), this.diagram.getColorMapper(), this.diagram.getEntityFactory(), false, DotMode.NORMAL);
        CucaDiagramFileMakerSvek2 cucaDiagramFileMakerSvek2 = new CucaDiagramFileMakerSvek2(dotData, this.diagram.getEntityFactory(), false, this.diagram.getSource(), this.diagram.getPragma());
        if (this.group.getGroupType() == GroupType.INNER_ACTIVITY) {
            Stereotype stereotype = this.group.getStereotype();
            HtmlColor htmlColor = this.getColor(ColorParam.activityBorder, stereotype);
            HtmlColor htmlColor2 = this.group.getSpecificBackColor() == null ? this.getColor(ColorParam.background, stereotype) : this.group.getSpecificBackColor();
            return new InnerActivity(cucaDiagramFileMakerSvek2.createFile(new String[0]), htmlColor, htmlColor2, iSkinParam.shadowing());
        }
        throw new UnsupportedOperationException(this.group.getGroupType().toString());
    }

    private UFont getFont(FontParam fontParam) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFont(fontParam, null);
    }

    protected final HtmlColor getColor(ColorParam colorParam, Stereotype stereotype) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return this.rose.getHtmlColor(iSkinParam, colorParam, stereotype);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Collection<IGroup> getChildrenGroups(IGroup iGroup) {
            if (EntityUtils.groupRoot(iGroup)) {
                return GroupPngMakerActivity.this.diagram.getChildrenGroups(GroupPngMakerActivity.this.group);
            }
            return GroupPngMakerActivity.this.diagram.getChildrenGroups(iGroup);
        }

        @Override
        public boolean isEmpty(IGroup iGroup) {
            return GroupPngMakerActivity.this.diagram.isEmpty(iGroup);
        }
    }
}

