/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.statediagram.StateDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateState2
extends SingleLineCommand2<StateDiagram> {
    public CommandCreateState2() {
        super(CommandCreateState2.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("(?:state[%s]+)"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("DISPLAY", "[%g]([^%g]+)[%g]"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*"), new RegexLeaf("LINECOLOR", "(?:##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?)?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram stateDiagram, RegexResult regexResult) {
        String string;
        Code code = Code.of(regexResult.get("CODE", 0));
        String string2 = regexResult.get("DISPLAY", 0);
        IEntity iEntity = stateDiagram.getOrCreateLeaf(code, null, null);
        if (!stateDiagram.checkConcurrentStateOk(code)) {
            return CommandExecutionResult.error("The state " + code + " has been created in a concurrent state : it cannot be used here.");
        }
        iEntity.setDisplay(Display.getWithNewlines(string2));
        String string3 = regexResult.get("STEREOTYPE", 0);
        if (string3 != null) {
            iEntity.setStereotype(new Stereotype(string3));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(stateDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(string);
            iEntity.addUrl(url);
        }
        iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("COLOR", 0)));
        iEntity.setSpecificLineColor(HtmlColorUtils.getColorIfValid(regexResult.get("LINECOLOR", 1)));
        CommandCreateClassMultilines.applyStroke(iEntity, regexResult.get("LINECOLOR", 0));
        return CommandExecutionResult.ok();
    }
}

