/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.command.CommandArrow;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CommandExoArrowAny
extends SingleLineCommand2<SequenceDiagram> {
    public CommandExoArrowAny(RegexConcat regexConcat) {
        super(regexConcat);
    }

    @Override
    protected final CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
        ArrowConfiguration arrowConfiguration;
        String string = regexResult.getLazzy("ARROW_BODYA", 0) + regexResult.getLazzy("ARROW_BODYB", 0);
        String string2 = regexResult.getLazzy("ARROW_DRESSING", 0);
        Participant participant = sequenceDiagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("PARTICIPANT", 0)));
        boolean bl = string2.length() == 2;
        boolean bl2 = string.contains("--");
        Display display = regexResult.get("LABEL", 0) == null ? Display.create("") : Display.getWithNewlines(regexResult.get("LABEL", 0));
        boolean bl3 = regexResult.get("ARROW_BOTHDRESSING", 0) != null;
        ArrowConfiguration arrowConfiguration2 = arrowConfiguration = bl3 ? ArrowConfiguration.withDirectionBoth() : ArrowConfiguration.withDirectionNormal();
        if (bl2) {
            arrowConfiguration = arrowConfiguration.withDotted();
        }
        if (bl) {
            arrowConfiguration = arrowConfiguration.withHead(ArrowHead.ASYNC);
        }
        arrowConfiguration = arrowConfiguration.withPart(this.getArrowPart(string2));
        arrowConfiguration = CommandArrow.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), arrowConfiguration);
        String string3 = sequenceDiagram.addMessage(new MessageExo(participant, this.getMessageExoType(regexResult), display, arrowConfiguration, sequenceDiagram.getNextMessageNumber(), this.isShortArrow(regexResult)));
        if (string3 != null) {
            return CommandExecutionResult.error(string3);
        }
        return CommandExecutionResult.ok();
    }

    private ArrowPart getArrowPart(String string) {
        if (string.contains("/")) {
            return ArrowPart.BOTTOM_PART;
        }
        if (string.contains("\\")) {
            return ArrowPart.TOP_PART;
        }
        return ArrowPart.FULL;
    }

    abstract MessageExoType getMessageExoType(RegexResult var1);

    private boolean isShortArrow(RegexResult regexResult) {
        String string = regexResult.getLazzy("SHORT", 0);
        return string != null && string.contains("?");
    }
}

