/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementTreeEntry
implements Element {
    private final TextBlock block;
    private final String text;
    private final int level;

    public ElementTreeEntry(int n, String string, UFont uFont, ISkinSimple iSkinSimple) {
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.block = TextBlockUtils.create(Display.create(string), fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple);
        this.text = string;
        this.level = n;
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        return Dimension2DDouble.delta(this.block.calculateDimension(stringBounder), this.getXDelta(), 0.0);
    }

    public double getXDelta() {
        return this.level * 10;
    }

    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        this.block.drawU(uGraphic.apply(new UTranslate(d + this.getXDelta(), d2)));
    }

    public String getText() {
        return this.text;
    }
}

