/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.Position;
import net.sourceforge.plantuml.salt.Positionner;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementEmpty;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementPyramid
implements Element {
    private final Element[][] elements;
    private final int rows;
    private final int cols;
    private final TableStrategy tableStrategy;

    public ElementPyramid(Positionner positionner, TableStrategy tableStrategy) {
        this.rows = positionner.getNbRows();
        this.cols = positionner.getNbCols();
        this.tableStrategy = tableStrategy;
        if (this.rows == 0) {
            throw new IllegalArgumentException("rows=0");
        }
        if (this.cols == 0) {
            throw new IllegalArgumentException("cols=0");
        }
        this.elements = new Element[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.getElements()[i][j] = new ElementEmpty();
            }
        }
        for (Map.Entry<Element, Position> entry : positionner.getAll().entrySet()) {
            int n = entry.getValue().getRow();
            int n2 = entry.getValue().getCol();
            this.getElements()[n][n2] = entry.getKey();
        }
    }

    private double getRowHeight(StringBounder stringBounder, int n) {
        double d = 0.0;
        for (int i = 0; i < this.cols; ++i) {
            Dimension2D dimension2D = this.elements[n][i].getPreferredDimension(stringBounder, 0.0, 0.0);
            if (!(dimension2D.getHeight() > d)) continue;
            d = dimension2D.getHeight();
        }
        return d;
    }

    private double getColWidth(StringBounder stringBounder, int n) {
        double d = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            Dimension2D dimension2D = this.elements[i][n].getPreferredDimension(stringBounder, 0.0, 0.0);
            if (!(dimension2D.getWidth() > d)) continue;
            d = dimension2D.getWidth();
        }
        return d;
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        double d3 = 1.0;
        for (int i = 0; i < this.cols; ++i) {
            d3 += this.getColWidth(stringBounder, i) + 3.0;
        }
        double d4 = 1.0;
        for (int i = 0; i < this.rows; ++i) {
            d4 += this.getRowHeight(stringBounder, i) + 3.0;
        }
        return new Dimension2DDouble(d3, d4);
    }

    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        double d3 = d2 + 2.0;
        Dimension2D dimension2D2 = this.getPreferredDimension(uGraphic.getStringBounder(), 0.0, 0.0);
        if (this.tableStrategy == TableStrategy.DRAW_OUTSIDE || this.tableStrategy == TableStrategy.DRAW_ALL) {
            uGraphic.apply(new UTranslate(d, d2)).draw(new URectangle(dimension2D2.getWidth() - 1.0, dimension2D2.getHeight() - 1.0));
        }
        for (int i = 0; i < this.rows; ++i) {
            double d4 = d + 2.0;
            double d5 = this.getRowHeight(uGraphic.getStringBounder(), i);
            for (int j = 0; j < this.cols; ++j) {
                double d6 = this.getColWidth(uGraphic.getStringBounder(), j);
                this.elements[i][j].drawU(uGraphic, d4, d3, n, new Dimension2DDouble(d6, d5));
                if (this.tableStrategy == TableStrategy.DRAW_ALL || this.tableStrategy == TableStrategy.DRAW_VERTICAL) {
                    uGraphic.apply(new UTranslate(d4 - 2.0, d2)).draw(new ULine(0.0, dimension2D2.getHeight() - 1.0));
                }
                d4 += d6 + 3.0;
            }
            if (this.tableStrategy == TableStrategy.DRAW_VERTICAL) {
                uGraphic.apply(new UTranslate(d4 - 2.0, d2)).draw(new ULine(0.0, dimension2D2.getHeight() - 1.0));
            }
            if (this.tableStrategy == TableStrategy.DRAW_ALL || this.tableStrategy == TableStrategy.DRAW_HORIZONTAL) {
                uGraphic.apply(new UTranslate(d, d3 - 2.0)).draw(new ULine(dimension2D2.getWidth() - 1.0, 0.0));
            }
            d3 += d5 + 3.0;
        }
        if (this.tableStrategy == TableStrategy.DRAW_HORIZONTAL) {
            uGraphic.apply(new UTranslate(d, d3 - 2.0)).draw(new ULine(dimension2D2.getWidth() - 1.0, 0.0));
        }
    }

    protected final Element[][] getElements() {
        return this.elements;
    }
}

