/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementMenuEntry;
import net.sourceforge.plantuml.salt.element.ElementMenuPopup;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementMenuBar
implements Element {
    private final Collection<ElementMenuEntry> entries = new ArrayList<ElementMenuEntry>();
    private final Map<ElementMenuEntry, ElementMenuPopup> popups = new HashMap<ElementMenuEntry, ElementMenuPopup>();
    private final UFont font;
    private final ISkinSimple spriteContainer;

    public ElementMenuBar(UFont uFont, ISkinSimple iSkinSimple) {
        this.font = uFont;
        this.spriteContainer = iSkinSimple;
    }

    public void addEntry(String string) {
        this.entries.add(new ElementMenuEntry(string, this.font, this.spriteContainer));
    }

    public void addSubEntry(String string, String string2) {
        ElementMenuPopup elementMenuPopup = this.getPopup(this.getElementMenuEntry(string));
        elementMenuPopup.addEntry(string2);
    }

    private ElementMenuPopup getPopup(ElementMenuEntry elementMenuEntry) {
        ElementMenuPopup elementMenuPopup = this.popups.get(elementMenuEntry);
        if (elementMenuPopup == null) {
            elementMenuPopup = new ElementMenuPopup(this.font, this.spriteContainer);
            this.popups.put(elementMenuEntry, elementMenuPopup);
        }
        return elementMenuPopup;
    }

    private ElementMenuEntry getElementMenuEntry(String string) {
        for (ElementMenuEntry elementMenuEntry : this.entries) {
            if (!elementMenuEntry.getText().equals(string)) continue;
            return elementMenuEntry;
        }
        throw new IllegalArgumentException();
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (ElementMenuEntry elementMenuEntry : this.entries) {
            Dimension2D dimension2D = elementMenuEntry.getPreferredDimension(stringBounder, d, d2);
            d3 += dimension2D.getWidth() + 10.0;
            d4 = Math.max(d4, dimension2D.getHeight());
        }
        return new Dimension2DDouble(d3, d4);
    }

    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        Dimension2D dimension2D2 = this.getPreferredDimension(uGraphic.getStringBounder(), d, d2);
        double d3 = d;
        if (n == 0) {
            uGraphic.apply(new UChangeBackColor(HtmlColorUtils.getColorIfValid("#DDDDDD"))).apply(new UTranslate(d, d2)).draw(new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
            for (ElementMenuEntry elementMenuEntry : this.entries) {
                elementMenuEntry.drawU(uGraphic, d3, d2, n, dimension2D);
                double d4 = elementMenuEntry.getPreferredDimension(uGraphic.getStringBounder(), d3, d2).getWidth();
                elementMenuEntry.setX(d3);
                d3 += d4 + 10.0;
            }
            return;
        }
        if (n == 1) {
            for (ElementMenuEntry elementMenuEntry : this.popups.keySet()) {
                elementMenuEntry.setBackground(HtmlColorUtils.getColorIfValid("#BBBBBB"));
            }
            double d5 = d2 + dimension2D2.getHeight();
            for (Map.Entry<ElementMenuEntry, ElementMenuPopup> entry : this.popups.entrySet()) {
                ElementMenuPopup elementMenuPopup = entry.getValue();
                double d6 = entry.getKey().getX();
                elementMenuPopup.drawU(uGraphic, d6, d5, n, elementMenuPopup.getPreferredDimension(uGraphic.getStringBounder(), d6, d5));
            }
        }
    }
}

