/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.salt.element.AbstractElementText;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementDroplist
extends AbstractElementText
implements Element {
    private final int box = 12;
    private final TextBlock openDrop;

    public ElementDroplist(String string, UFont uFont, ISkinSimple iSkinSimple) {
        super(ElementDroplist.extract(string), uFont, true, iSkinSimple);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "^");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() > 0) {
            arrayList.remove(0);
        }
        this.openDrop = arrayList.size() == 0 ? null : TextBlockUtils.create(Display.create(arrayList), this.getConfig(), HorizontalAlignment.LEFT, iSkinSimple);
    }

    private static String extract(String string) {
        int n = string.indexOf(94);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        Dimension2D dimension2D = this.getTextDimensionAt(stringBounder, d + 2.0);
        return Dimension2DDouble.delta(dimension2D, 16.0, 4.0);
    }

    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        Dimension2D dimension2D2 = this.getPreferredDimension(uGraphic.getStringBounder(), 0.0, 0.0);
        if (n == 0) {
            uGraphic.apply(new UChangeBackColor(HtmlColorUtils.getColorIfValid("#EEEEEE"))).apply(new UTranslate(d, d2)).draw(new URectangle(dimension2D2.getWidth() - 1.0, dimension2D2.getHeight() - 1.0));
            this.drawText(uGraphic, d + 2.0, d2 + 2.0);
            double d3 = dimension2D2.getWidth() - 12.0;
            uGraphic.apply(new UTranslate(d + d3, d2)).draw(new ULine(0.0, dimension2D2.getHeight() - 1.0));
            UPolygon uPolygon = new UPolygon();
            uPolygon.addPoint(0.0, 0.0);
            uPolygon.addPoint(6.0, 0.0);
            Dimension2D dimension2D3 = this.getPureTextDimension(uGraphic.getStringBounder());
            uPolygon.addPoint(3.0, dimension2D3.getHeight() - 8.0);
            uGraphic.apply(new UChangeBackColor(uGraphic.getParam().getColor())).apply(new UTranslate(d + d3 + 3.0, d2 + 6.0)).draw(uPolygon);
        }
        if (this.openDrop != null) {
            Dimension2D dimension2D4 = Dimension2DDouble.atLeast(this.openDrop.calculateDimension(uGraphic.getStringBounder()), dimension2D2.getWidth() - 1.0, 0.0);
            uGraphic.apply(new UChangeBackColor(HtmlColorUtils.getColorIfValid("#EEEEEE"))).apply(new UTranslate(d, d2 + dimension2D2.getHeight() - 1.0)).draw(new URectangle(dimension2D4.getWidth() - 1.0, dimension2D4.getHeight() - 1.0));
            this.openDrop.drawU(uGraphic.apply(new UTranslate(d, d2 + dimension2D2.getHeight() - 1.0)));
        }
    }
}

