/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.USymbol;

public class DescriptionDiagram
extends AbstractEntityDiagram {
    public ILeaf getOrCreateLeaf(Code code, LeafType leafType, USymbol uSymbol) {
        if (leafType == null) {
            String string = code.getCode();
            if (string.startsWith("[") && string.endsWith("]")) {
                USymbol uSymbol2 = this.getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1;
                return this.getOrCreateLeafDefault(code.eventuallyRemoveStartingAndEndingDoubleQuote(), LeafType.DESCRIPTION, uSymbol2);
            }
            if (string.startsWith(":") && string.endsWith(":")) {
                return this.getOrCreateLeafDefault(code.eventuallyRemoveStartingAndEndingDoubleQuote(), LeafType.DESCRIPTION, USymbol.ACTOR);
            }
            if (string.startsWith("()")) {
                string = string.substring(2).trim();
                string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
                return this.getOrCreateLeafDefault(Code.of(string), LeafType.DESCRIPTION, USymbol.INTERFACE);
            }
            code = code.eventuallyRemoveStartingAndEndingDoubleQuote();
            return this.getOrCreateLeafDefault(code, LeafType.STILL_UNKNOWN, uSymbol);
        }
        return this.getOrCreateLeafDefault(code, leafType, uSymbol);
    }

    private boolean isUsecase() {
        for (ILeaf iLeaf : this.getLeafs().values()) {
            LeafType leafType = iLeaf.getEntityType();
            USymbol uSymbol = iLeaf.getUSymbol();
            if (leafType != LeafType.USECASE && uSymbol != USymbol.ACTOR) continue;
            return true;
        }
        return false;
    }

    public void makeDiagramReady() {
        super.makeDiagramReady();
        LeafType leafType = this.isUsecase() ? LeafType.DESCRIPTION : LeafType.DESCRIPTION;
        USymbol uSymbol = this.isUsecase() ? USymbol.ACTOR : USymbol.INTERFACE;
        for (ILeaf iLeaf : this.getLeafs().values()) {
            if (iLeaf.getEntityType() != LeafType.STILL_UNKNOWN) continue;
            iLeaf.muteToType(leafType, uSymbol);
        }
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.DESCRIPTION;
    }
}

