/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.Position;
import net.sourceforge.plantuml.creole.Sea;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class SheetBlock1
implements TextBlock,
Atom,
Stencil {
    private final Sheet sheet;
    private Map<Stripe, Double> heights;
    private Map<Stripe, Double> widths;
    private Map<Atom, Position> positions;
    private MinMax minMax;

    public SheetBlock1(Sheet sheet) {
        this.sheet = sheet;
    }

    private void initMap(StringBounder stringBounder) {
        double d;
        if (this.positions != null) {
            return;
        }
        this.positions = new LinkedHashMap<Atom, Position>();
        this.widths = new LinkedHashMap<Stripe, Double>();
        this.heights = new LinkedHashMap<Stripe, Double>();
        this.minMax = MinMax.getEmpty(true);
        double d2 = 0.0;
        for (Stripe stripe : this.sheet) {
            if (stripe.getAtoms().size() == 0) continue;
            Sea sea = new Sea(stringBounder);
            for (Atom object : stripe.getAtoms()) {
                sea.add(object);
            }
            sea.doAlign();
            sea.translateMinYto(d2);
            sea.exportAllPositions(this.positions);
            double d3 = sea.getWidth();
            this.widths.put(stripe, d3);
            this.minMax = sea.update(this.minMax);
            d = sea.getHeight();
            this.heights.put(stripe, d);
            d2 += d;
        }
        int n = this.sheet.getHorizontalAlignment() == HorizontalAlignment.CENTER ? 2 : (this.sheet.getHorizontalAlignment() == HorizontalAlignment.RIGHT ? 1 : 0);
        if (n != 0) {
            double d4 = 0.0;
            for (Double d3 : this.widths.values()) {
                if (!(d3 > d4)) continue;
                d4 = d3;
            }
            for (Map.Entry entry : this.widths.entrySet()) {
                d = d4 - (Double)entry.getValue();
                if (!(d > 0.0)) continue;
                for (Atom atom : ((Stripe)entry.getKey()).getAtoms()) {
                    Position position = this.positions.get(atom);
                    this.positions.put(atom, position.translateX(d / (double)n));
                }
            }
        }
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        this.initMap(stringBounder);
        return this.minMax.getDimension();
    }

    public void drawU(UGraphic uGraphic) {
        this.initMap(uGraphic.getStringBounder());
        for (Stripe stripe : this.sheet) {
            for (Atom atom : stripe.getAtoms()) {
                Position position = this.positions.get(atom);
                atom.drawU(position.translate(uGraphic));
            }
        }
    }

    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    public double getStartingX(StringBounder stringBounder, double d) {
        return 0.0;
    }

    public double getEndingX(StringBounder stringBounder, double d) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

