/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.StripeStyle;
import net.sourceforge.plantuml.creole.StripeStyleType;
import net.sourceforge.plantuml.graphic.FontConfiguration;

public class CreoleStripeSimpleParser {
    private final String line;
    private final StripeStyle style;
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;

    public CreoleStripeSimpleParser(String string, FontConfiguration fontConfiguration, ISkinSimple iSkinSimple) {
        this.fontConfiguration = fontConfiguration;
        this.skinParam = iSkinSimple;
        Pattern pattern = MyPattern.cmpile("^--([^-]*)--$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.line = matcher.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '-');
            return;
        }
        Pattern pattern2 = MyPattern.cmpile("^==([^=]*)==$");
        Matcher matcher2 = pattern2.matcher(string);
        if (matcher2.find()) {
            this.line = matcher2.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '=');
            return;
        }
        Pattern pattern3 = MyPattern.cmpile("^===*==$");
        Matcher matcher3 = pattern3.matcher(string);
        if (matcher3.find()) {
            this.line = "";
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '=');
            return;
        }
        Pattern pattern4 = MyPattern.cmpile("^__([^_]*)__$");
        Matcher matcher4 = pattern4.matcher(string);
        if (matcher4.find()) {
            this.line = matcher4.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '_');
            return;
        }
        Pattern pattern5 = MyPattern.cmpile("^\\.\\.([^\\.]*)\\.\\.$");
        Matcher matcher5 = pattern5.matcher(string);
        if (matcher5.find()) {
            this.line = matcher5.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '.');
            return;
        }
        Pattern pattern6 = MyPattern.cmpile("^(\\*+)([^*]+)$");
        Matcher matcher6 = pattern6.matcher(string);
        if (matcher6.find()) {
            this.line = matcher6.group(2).trim();
            int n = matcher6.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITHOUT_NUMBER, n, '\u0000');
            return;
        }
        Pattern pattern7 = MyPattern.cmpile("^(#+)([^*]+)$");
        Matcher matcher7 = pattern7.matcher(string);
        if (matcher7.find()) {
            this.line = matcher7.group(2).trim();
            int n = matcher7.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITH_NUMBER, n, '\u0000');
            return;
        }
        Pattern pattern8 = MyPattern.cmpile("^(=+)([^*]+)$");
        Matcher matcher8 = pattern8.matcher(string);
        if (matcher8.find()) {
            this.line = matcher8.group(2).trim();
            int n = matcher8.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.HEADING, n, '\u0000');
            return;
        }
        this.line = string;
        this.style = new StripeStyle(StripeStyleType.NORMAL, 0, '\u0000');
    }

    public Stripe createStripe(CreoleContext creoleContext) {
        StripeSimple stripeSimple = new StripeSimple(this.fontConfiguration, this.style, creoleContext, this.skinParam);
        stripeSimple.analyzeAndAdd(this.line);
        return stripeSimple;
    }
}

