/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.font.LineMetrics;
import java.awt.geom.Dimension2D;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class AtomText
implements Atom {
    private static DelayedDouble ZERO = new DelayedDouble(){

        public double getDouble(StringBounder stringBounder) {
            return 0.0;
        }
    };
    private final FontConfiguration fontConfiguration;
    private final String text;
    private final DelayedDouble marginLeft;
    private final DelayedDouble marginRight;
    private final Url url;

    public static Atom create(String string, FontConfiguration fontConfiguration) {
        return new AtomText(string, fontConfiguration, null, ZERO, ZERO);
    }

    public static Atom createUrl(Url url, FontConfiguration fontConfiguration) {
        return new AtomText(url.getLabel(), fontConfiguration, url, ZERO, ZERO);
    }

    public static AtomText createHeading(String string, FontConfiguration fontConfiguration, int n) {
        fontConfiguration = n == 0 ? fontConfiguration.bigger(4.0).bold() : (n == 1 ? fontConfiguration.bigger(2.0).bold() : (n == 2 ? fontConfiguration.bigger(1.0).bold() : fontConfiguration.italic()));
        return new AtomText(string, fontConfiguration, null, ZERO, ZERO);
    }

    public static Atom createListNumber(final FontConfiguration fontConfiguration, final int n, int n2) {
        DelayedDouble delayedDouble = new DelayedDouble(){

            public double getDouble(StringBounder stringBounder) {
                Dimension2D dimension2D = stringBounder.calculateDimension(fontConfiguration.getFont(), "9. ");
                return dimension2D.getWidth() * (double)n;
            }
        };
        DelayedDouble delayedDouble2 = new DelayedDouble(){

            public double getDouble(StringBounder stringBounder) {
                Dimension2D dimension2D = stringBounder.calculateDimension(fontConfiguration.getFont(), ".");
                return dimension2D.getWidth();
            }
        };
        return new AtomText("" + (n2 + 1) + ".", fontConfiguration, null, delayedDouble, delayedDouble2);
    }

    public String toString() {
        return this.text + " " + this.fontConfiguration;
    }

    private AtomText(String string, FontConfiguration fontConfiguration, Url url, DelayedDouble delayedDouble, DelayedDouble delayedDouble2) {
        this.marginLeft = delayedDouble;
        this.marginRight = delayedDouble2;
        this.text = StringUtils.showComparatorCharacters(string);
        this.fontConfiguration = fontConfiguration;
        this.url = url;
    }

    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        Log.debug("g2d=" + dimension2D);
        Log.debug("Size for " + this.text + " is " + dimension2D);
        double d = dimension2D.getHeight();
        if (d < 10.0) {
            d = 10.0;
        }
        double d2 = this.text.indexOf(9) == -1 ? dimension2D.getWidth() : this.getWidth(stringBounder);
        double d3 = this.marginLeft.getDouble(stringBounder);
        double d4 = this.marginRight.getDouble(stringBounder);
        return new Dimension2DDouble(d2 + d3 + d4, d);
    }

    private double getDescent() {
        LineMetrics lineMetrics = TextBlockUtils.getLineMetrics(this.fontConfiguration.getFont(), this.text);
        double d = lineMetrics.getDescent();
        return d;
    }

    public double getFontSize2D() {
        return this.fontConfiguration.getFont().getSize2D();
    }

    public double getStartingAltitude(StringBounder stringBounder) {
        return this.fontConfiguration.getSpace();
    }

    private double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), "        ").getWidth();
    }

    public void drawU(UGraphic uGraphic) {
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        uGraphic = uGraphic.apply(new UChangeColor(this.fontConfiguration.getColor()));
        if (this.marginLeft != ZERO) {
            uGraphic = uGraphic.apply(new UTranslate(this.marginLeft.getDouble(uGraphic.getStringBounder()), 0.0));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\t", true);
        double d = 0.0;
        Dimension2D dimension2D = uGraphic.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), this.text);
        double d2 = this.getDescent();
        double d3 = dimension2D.getHeight() - d2;
        if (stringTokenizer.hasMoreTokens()) {
            double d4 = this.getTabSize(uGraphic.getStringBounder());
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("\t")) {
                    double d5 = d % d4;
                    d += d4 - d5;
                    continue;
                }
                UText uText = new UText(string, this.fontConfiguration);
                Dimension2D dimension2D2 = uGraphic.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), string);
                uGraphic.apply(new UTranslate(d, d3)).draw(uText);
                d += dimension2D2.getWidth();
            }
        }
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    private double getWidth(StringBounder stringBounder) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\t", true);
        double d = this.getTabSize(stringBounder);
        double d2 = 0.0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("\t")) {
                double d3 = d2 % d;
                d2 += d - d3;
                continue;
            }
            Dimension2D dimension2D = stringBounder.calculateDimension(this.fontConfiguration.getFont(), string);
            d2 += dimension2D.getWidth();
        }
        return d2;
    }

    static interface DelayedDouble {
        public double getDouble(StringBounder var1);
    }
}

