/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextArrow
implements Component {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;
    private final ArrowConfiguration config;

    public ComponentTextArrow(ComponentType componentType, ArrowConfiguration arrowConfiguration, Display display, FileFormat fileFormat) {
        this.type = componentType;
        this.config = arrowConfiguration;
        this.stringsToDisplay = ComponentTextArrow.clean(display);
        this.fileFormat = fileFormat;
    }

    private static Display clean(Display display) {
        if (display.size() == 0 || !(display.get(0) instanceof MessageNumber)) {
            return display;
        }
        Display display2 = Display.empty();
        for (int i = 0; i < display.size(); ++i) {
            CharSequence charSequence = display.get(i);
            if (i == 1) {
                charSequence = ComponentTextArrow.removeTag(((Object)display.get(0)).toString()) + " " + charSequence;
            }
            if (i == 0) continue;
            display2 = display2.add(charSequence);
        }
        return display2;
    }

    private static String removeTag(String string) {
        return string.replaceAll("\\<[^<>]+\\>", "");
    }

    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        int n3 = StringUtils.getWidth(this.stringsToDisplay);
        int n4 = n2 - 2;
        umlCharArea.drawHLine(this.fileFormat == FileFormat.UTXT ? (char)'\u2500' : '-', n4, 1, n);
        if (this.config.isDotted()) {
            for (int i = 1; i < n; i += 2) {
                umlCharArea.drawChar(' ', i, n4);
            }
        }
        if (this.config.getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            umlCharArea.drawChar('>', n - 1, n4);
        } else if (this.config.getArrowDirection() == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
            umlCharArea.drawChar('<', 1, n4);
        } else {
            throw new UnsupportedOperationException();
        }
        umlCharArea.drawStringsLR(this.stringsToDisplay.as(), (n - n3) / 2, 0);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 2;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 2;
    }
}

