/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextActor
implements Component {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextActor(ComponentType componentType, Display display, FileFormat fileFormat) {
        this.type = componentType;
        this.stringsToDisplay = display;
        this.fileFormat = fileFormat;
    }

    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        umlCharArea.fillRect(' ', 0, 0, n, n2);
        int n3 = n / 2 - 1;
        if (this.type == ComponentType.ACTOR_HEAD) {
            umlCharArea.drawStringsLR(this.stringsToDisplay.as(), 1, this.getStickManHeight());
            if (this.fileFormat == FileFormat.UTXT) {
                umlCharArea.drawStickManUnicode(n3, 0);
            } else {
                umlCharArea.drawStickMan(n3, 0);
            }
        } else if (this.type == ComponentType.ACTOR_TAIL) {
            umlCharArea.drawStringsLR(this.stringsToDisplay.as(), 1, 0);
            if (this.fileFormat == FileFormat.UTXT) {
                umlCharArea.drawStickManUnicode(n3, 1);
            } else {
                umlCharArea.drawStickMan(n3, 1);
            }
        } else assert (false);
    }

    private int getStickManHeight() {
        if (this.fileFormat == FileFormat.UTXT) {
            return 6;
        }
        return 5;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + this.getStickManHeight();
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 2;
    }
}

