/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextActiveLine
implements Component {
    private final FileFormat fileFormat;

    public ComponentTextActiveLine(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        if (this.fileFormat == FileFormat.UTXT) {
            umlCharArea.fillRect(' ', 0, 0, n, n2);
            umlCharArea.drawBoxSimpleUnicode(0, 0, n, n2);
            umlCharArea.drawChar('\u2534', n / 2, 0);
            umlCharArea.drawChar('\u252c', n / 2, n2 - 1);
        } else {
            umlCharArea.fillRect('X', 0, 0, n, n2);
            umlCharArea.drawBoxSimple(0, 0, n, n2);
        }
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return 0.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return 3.0;
    }
}

