// https://github.com/microsoft/TypeScript/issues/45612
declare global {
    interface Navigator {
        msSaveOrOpenBlob: (blob: Blob) => void
      }
}

import { APP_BASE_HREF } from "@angular/common";
import { Injectable, Inject } from "@angular/core";

import { HttpClient } from "@angular/common/http";

import { ServiceHelpers } from "./service.helpers";

@Injectable()
export class FileDownloadService extends ServiceHelpers {
    constructor(http: HttpClient, @Inject(APP_BASE_HREF) href:string) {
        super(http, "/api/v2/system/", href);
    }

    downloadFile(url: string, contentType: string): void {
        this.http.get(url).subscribe((response: any) => {

          // It is necessary to create a new blob object with mime-type explicitly set
          // otherwise only Chrome works like it should
          const newBlob = new Blob([(response)], { type: contentType });

          // IE doesn't allow using a blob object directly as link href
          // instead it is necessary to use msSaveOrOpenBlob
          if (window.navigator && window.navigator.msSaveOrOpenBlob) {
              window.navigator.msSaveOrOpenBlob(newBlob);
              return;
          }

          // For other browsers:
          // Create a link pointing to the ObjectURL containing the blob.
          const downloadURL = URL.createObjectURL(response);
            window.open(downloadURL);
        });
      } 
}
