# Suggested Reading

## Whitepapers

- [The Economic Impacts of Inadequate Infrastructure for Software Testing](https://www.nist.gov/system/files/documents/director/planning/report02-3.pdf)
- [Improving Web Application Security: Threats and Countermeasures](https://www.microsoft.com/en-ca/download/details.aspx?id=1330)
- [NIST Publications](https://csrc.nist.gov/publications/sp)
- [Fundamental Practices for Secure Software Development](https://safecode.org/wp-content/uploads/2018/03/SAFECode_Fundamental_Practices_for_Secure_Software_Development_March_2018.pdf)
- [The OWASP Guide Project](https://wiki.owasp.org/index.php/OWASP_Guide_Project)
- [Use Cases: Just the FAQs and Answers](https://www.ibm.com/developerworks/rational/library/content/RationalEdge/jan03/UseCaseFAQS_TheRationalEdge_Jan2003.pdf)

## Books

- The Art of Software Security Testing: Identifying Software Security Flaws, by Chris Wysopal, Lucas Nelson, Dino Dai Zovi, Elfriede Dustin, published by Addison-Wesley, ISBN 0321304861 (2006)
- Building Secure Software: How to Avoid Security Problems the Right Way, by Gary McGraw and John Viega, published by Addison-Wesley Pub Co, ISBN 020172152X (2002)
- [The Ethical Hack: A Framework for Business Value Penetration Testing, By James S. Tiller, Auerbach Publications, ISBN 084931609X (2005)](https://books.google.com/books?id=fwASXKXOolEC&printsec=frontcover&source=gbs_ge_summary_r&redir_esc=y#v=onepage&q&f=false)
- [The Hacker's Handbook: The Strategy behind Breaking into and Defending Networks, By Susan Young, Dave Aitel, Auerbach Publications, ISBN: 0849308887 (2005)](https://books.google.com/books?id=AO2fsAPVC34C&printsec=frontcover&source=gbs_ge_summary_r&redir_esc=y#v=onepage&q&f=false)
- [Hacking Exposed: Web Applications 3, by Joel Scambray, Vinvent Liu, Caleb Sima, published by McGraw-Hill Osborne Media, ISBN 007222438X (2010)](https://www.webhackingexposed.com/)
- The Web Application Hacker's Handbook: Finding and Exploiting Security Flaws, 2nd Edition - [published by Dafydd Stuttard, Marcus Pinto, ISBN 9781118026472 (2011)]
- How to Break Software Security, by James Whittaker, Herbert H. Thompson, published by Addison Wesley, ISBN 0321194330 (2003)
- How to Break Software: Functional and Security Testing of Web Applications and Web Services, by Make Andrews, James A. Whittaker, published by Pearson Education Inc., ISBN 0321369440 (2006)
- Secure Coding: Principles and Practices, by Mark Graff and Kenneth R. Van Wyk, published by O’Reilly, ISBN 0596002424 (2003)
- Secure Programming HOWTO, David Wheeler (2015)
    - [Online version available here](https://dwheeler.com/secure-programs/Secure-Programs-HOWTO/index.html)
- Software Security: Building Security In, by Gary McGraw, published by Addison-Wesley Professional, ISBN 0321356705 (2006)
- Software Testing In The Real World (Acm Press Books) by Edward Kit, published by Addison-Wesley Professional, ISBN 0201877562 (1995)
- Software Testing Techniques, 2nd Edition, By Boris Beizer, International Thomson Computer Press, ISBN 0442206720 (1990)
- The Tangled Web: A Guide to Securing Modern Web Applications, by Michael Zalewski, published by No Starch Press Inc., ISBN 047131952X (2011)
- The Unified Modeling Language – A User Guide – by Grady Booch, James Rumbaugh, Ivar Jacobson, published by Addison-Wesley Professional, ISBN 0321267974 (2005)
- The Unified Modeling Language User Guide, by Grady Booch, James Rumbaugh, Ivar Jacobson, Ivar published by Addison-Wesley Professional, ISBN 0-201-57168-4 (1998)
- Web Security Testing Cookbook: Systematic Techniques to Find Problems Fast, by Paco Hope, Ben Walther, published by O’Reilly, ISBN 0596514832 (2008)
- Writing Secure Code, by Mike Howard and David LeBlanc, published by Microsoft Press, ISBN 0735617228 (2004)

## Useful Sites

- [Build Security In](https://www.us-cert.gov/bsi)
- [CERT Secure Coding Standards](https://wiki.sei.cmu.edu/confluence/display/seccode/SEI+CERT+Coding+Standards)
- [McAfee Foundstone Publications](https://www.mcafee.com/enterprise/en-us/search.html?q=Foundstone)
- [McAfee Free Tools](https://www.mcafee.com/enterprise/en-us/downloads/free-tools.html)
- [OASIS Web Application Security (WAS) TC](https://www.oasis-open.org/committees/tc_home.php?wg_abbrev=was)
- [SANS Internet Storm Center (ISC)](https://isc.sans.edu/)
- [The Open Web Application Application Security Project (OWASP)](https://owasp.org)
- [Pentestmonkey - Pen Testing Cheat Sheets](https://pentestmonkey.net/cheat-sheet)
- [Secure Coding Guidelines for the .NET Framework 4.5](https://docs.microsoft.com/en-us/dotnet/standard/security/secure-coding-guidelines)
- [Security in the Java platform](https://docs.oracle.com/javase/6/docs/technotes/guides/security/overview/jsoverview.html)
- [System Administration, Networking, and Security Institute (SANS)](https://www.sans.org)
- [Web Security – Articles](https://www.acunetix.com/blog/category/web-security-zone/)
- [Testing Client-Side Security issues](http://www.domxss.com/domxss/)

## Videos

- [PentesterAcademy](https://www.pentesteracademy.com/)

## Deliberately Insecure Web Applications

- [OWASP Vulnerable Web Applications Directory Project](https://owasp.org/www-project-vulnerable-web-applications-directory/)
- [OWASP Juice Shop](https://owasp-juice.shop)
- [OWASP WebGoat](https://owasp.org/www-project-webgoat/)
- [Damn Vulnerable Web App](https://github.com/digininja/DVWA)
- [Xtreme Vulnerable Web Application](https://github.com/s4n7h0/xvwa)
- [Mutillidae](https://www.irongeek.com/i.php?page=mutillidae/mutillidae-deliberately-vulnerable-php-owasp-top-10)
