# Task Pro

Task Pro is an intuitive web application crafted to streamline project and task management.

It empowers users of all proficiency levels to enhance their time management and organizational abilities with its user-friendly interface.

Whether you opt for private usage or collaboration, Task Pro offers a comprehensive solution for creating, organizing, and sharing projects seamlessly.

## Technologies

![React](https://img.shields.io/badge/react-%2320232a.svg?style=for-the-badge&logo=react&logoColor=%2361DAFB) ![TypeScript](https://img.shields.io/badge/typescript-%23007ACC.svg?style=for-the-badge&logo=typescript&logoColor=white) ![JavaScript](https://img.shields.io/badge/javascript-%23323330.svg?style=for-the-badge&logo=javascript&logoColor=%23F7DF1E) ![React Router](https://img.shields.io/badge/React_Router-CA4245?style=for-the-badge&logo=react-router&logoColor=white) ![SASS](https://img.shields.io/badge/SASS-hotpink.svg?style=for-the-badge&logo=SASS&logoColor=white) ![Vite](https://img.shields.io/badge/vite-%23646CFF.svg?style=for-the-badge&logo=vite&logoColor=white) ![MongoDB](https://img.shields.io/badge/MongoDB-%234ea94b.svg?style=for-the-badge&logo=mongodb&logoColor=white) ![NodeJS](https://img.shields.io/badge/node.js-6DA55F?style=for-the-badge&logo=node.js&logoColor=white) ![Express.js](https://img.shields.io/badge/express.js-%23404d59.svg?style=for-the-badge&logo=express&logoColor=%2361DAFB)

## Project Frames

![Project Frame](src/assets/projectFrame.png)

## Features

### User Sign-Up and Login

- Easily create a user profile to personalize user experience.
- Secure authentication ensures your private boards are only accessible to you.

![Authentication](src/assets/authPage.png)

### Board Management

- Create, edit and delete boards with ease.
- Instantly swap between boards to display their corresponding tasks.
- All changes to boards and tasks are maintained on the frontend and backend.

![Dashboard](src/assets/Dashboard.png)

### Task Management

- Create any number of new task cards with name, notes and status.
- Edit and delete task cards as needed.
- Move cards from one status column to another.

![taskCreation](src/assets/taskCreation.png)

## Front End

- Developed using **React** for a responsive and dynamic user interface.
- Utilizes **React Router** for smooth navigation between pages.
- Stylish and customizable design with **SASS** for a modern look and organized styling.

## Back End

- Powered by **Node.js** and **Express** for robust server-side functionality.
- Data storage and retrieval are handled by **MongoDB**, ensuring data persistence and flexibility.

## Stretch Features

In the future, we plan to introduce the following features:

- Keep your project sets private for personal use or collaborate them with others.
- Share sets can be accessed together with multiple method of invites, keeping team on the same page.
- Enhance the Project-sharing system with comments for better communication.
- Drag and drop to improve user experiences.
- Light and Dark mode.
- OTP/Email 2 step authentication.

## To Launch the Application

**Step 1**. Clone repo to code editor

**Step 2**. Run npm install to install all dependencies

**Step 3**. Make sure node version is 18.17.1 or older, can use nvm to install the needed version.

**Step 4**. Create env file and make sure to have `PORT = 3000` and `MONGO_URI = (Mongodb connection URI)`

**Step 5**. start the project with `npm start` or `npm run dev` (for dev mode)

## Authors

- Nam Ha: [Github](https://github.com/namos2502)

- John Costello: [Github](https://github.com/johnlcos)
