﻿Public NotInheritable Class 御魂图鉴

    Private Shared ReadOnly s_data As New Dictionary(Of 御魂种类, 御魂图鉴条目) From {
        {御魂种类.雪幽魂, New 御魂图鉴条目(300002, (御魂属性类型英文名.防御加成, 0.3), "造成伤害时，有15%（若目标带有减速效果则为30%）基础概率冰冻1回合；受到攻击时，使攻击者减速30点，持续1回合。", False)},
        {御魂种类.地藏像, New 御魂图鉴条目(300003, (御魂属性类型英文名.生命加成, 0.15), "受到暴击时，自身100%、友方30%概率获得1回合护盾，能吸收10% 生命上限的伤害；对被嘲讽目标降低60%触发概率。", False)},
        {御魂种类.蝠翼, New 御魂图鉴条目(300004, (御魂属性类型英文名.攻击加成, 0.15), "造成伤害时，附带20%吸血。", False)},
        {御魂种类.涅槃之火, New 御魂图鉴条目(300006, (御魂属性类型英文名.生命加成, 0.15), "回合结束时，若生命比例低于30%，治疗生命上限15%的生命。", False)},
        {御魂种类.三味, New 御魂图鉴条目(300007, (御魂属性类型英文名.暴击, 0.15), "任一友方承受控制效果时，使其提升30点速度，持续2回合，此增 益效果不可驱散，可叠加2层。", False)},
        {御魂种类.魍魉之匣, New 御魂图鉴条目(300008, (御魂属性类型英文名.效果抵抗, 0.15), "造成伤害时，有25%基础概率随机附加眩晕、沉默、 减疗40%、混乱，持续1回合。", False)},
        {御魂种类.被服, New 御魂图鉴条目(300009, (御魂属性类型英文名.生命加成, 0.15), "30%减伤。", False)},
        {御魂种类.招财猫, New 御魂图鉴条目(300010, (御魂属性类型英文名.防御加成, 0.3), "回合开始时，有50%的概率获得2点鬼火。", False)},
        {御魂种类.反枕, New 御魂图鉴条目(300011, (御魂属性类型英文名.防御加成, 0.3), "造成伤害时，有23%基础概率使目标沉睡1回合。", False)},
        {御魂种类.轮入道, New 御魂图鉴条目(300012, (御魂属性类型英文名.攻击加成, 0.15), "回合结束时，有20%概率获得新的回合。", False)},
        {御魂种类.日女巳时, New 御魂图鉴条目(300013, (御魂属性类型英文名.防御加成, 0.3), "造成伤害时，有20%概率击退目标30%行动条，若其带有增益状态、印记，触发概率提升10%。", False)},
        {御魂种类.镜姬, New 御魂图鉴条目(300014, (御魂属性类型英文名.生命加成, 0.15), "受到伤害时，有30%概率造成100%反伤；对被嘲讽目标降低60%触发概率。", False)},
        {御魂种类.钟灵, New 御魂图鉴条目(300015, (御魂属性类型英文名.生命加成, 0.15), "造成伤害时，有10%基础概率使目标眩晕1回合。若敌方无人处于眩晕中，则基础概率改为20%。", False)},
        {御魂种类.狰, New 御魂图鉴条目(300018, (御魂属性类型英文名.攻击加成, 0.15), "受到敌方伤害时，有35%概率反击；对被嘲讽目标降低60%触发概率。", False)},
        {御魂种类.火灵, New 御魂图鉴条目(300019, (御魂属性类型英文名.效果命中, 0.15), "战斗开始时，获得3点鬼火。", False)},
        {御魂种类.鸣屋, New 御魂图鉴条目(300020, (御魂属性类型英文名.攻击加成, 0.15), "攻击时，若目标带有控制效果，提升45%伤害。", False)},
        {御魂种类.薙魂, New 御魂图鉴条目(300021, (御魂属性类型英文名.生命加成, 0.15), "唯一效果。友方被攻击时50%概率守护，使其中的单体伤害降低20%，再分担50%，直到攻击结束。每次攻击最多触发一次。", False)},
        {御魂种类.心眼, New 御魂图鉴条目(300022, (御魂属性类型英文名.攻击加成, 0.15), "造成伤害时，目标生命比例每降低15%，提升10%伤害。", False)},
        {御魂种类.木魅, New 御魂图鉴条目(300023, (御魂属性类型英文名.防御加成, 0.3), "任何友方受到伤害时，有25%概率削减伤害者1点鬼火，单次攻击内最多触发1次；对被嘲讽目标降低60%触发概率。", False)},
        {御魂种类.树妖, New 御魂图鉴条目(300024, (御魂属性类型英文名.生命加成, 0.15), "治疗时，增加20%（若目标生命低于20%，改为增加50%）基础治疗。", False)},
        {御魂种类.网切, New 御魂图鉴条目(300026, (御魂属性类型英文名.暴击, 0.15), "攻击时，50%概率无视45%防御。", False)},
        {御魂种类.阴摩罗, New 御魂图鉴条目(300027, (御魂属性类型英文名.攻击加成, 0.15), "击杀目标时，获得3点鬼火。", False)},
        {御魂种类.伤魂鸟, New 御魂图鉴条目(300029, (御魂属性类型英文名.暴击, 0.15), "任一非怪物目标阵亡时，治疗生命上限20%的生命，并提升20%伤害（上限120%）直到战斗结束。", False)},
        {御魂种类.破势, New 御魂图鉴条目(300030, (御魂属性类型英文名.暴击, 0.15), "造成伤害时，若目标生命比例高于70%，提升40%伤害。", False)},
        {御魂种类.镇墓兽, New 御魂图鉴条目(300031, (御魂属性类型英文名.暴击, 0.15), "生命比例每降低1%，提升0.5%暴击伤害。", False)},
        {御魂种类.珍珠, New 御魂图鉴条目(300032, (御魂属性类型英文名.防御加成, 0.3), "治疗时，目标获得不可驱散的护盾2回合，能吸收等同基础治疗30%的伤害。", False)},
        {御魂种类.骰子鬼, New 御魂图鉴条目(300033, (御魂属性类型英文名.效果抵抗, 0.15), "抵抗时，反击来源目标，该次反击提升50%伤害。未被 控制时承受控制效果，增加25%行动条。", False)},
        {御魂种类.蚌精, New 御魂图鉴条目(300034, (御魂属性类型英文名.效果命中, 0.15), "战斗开始时，友方全体获得无法驱散的护盾1回合，能吸收等同生命上限10%的伤害。", False)},
        {御魂种类.魅妖, New 御魂图鉴条目(300035, (御魂属性类型英文名.防御加成, 0.3), "造成伤害时，有25%基础概率使目标混乱1回合。", False)},
        {御魂种类.针女, New 御魂图鉴条目(300036, (御魂属性类型英文名.暴击, 0.15), "暴击时，有40%概率对目标造成其生命上限10%的无视防御伤害，最高不超过攻击120%。", False)},
        {御魂种类.返魂香, New 御魂图鉴条目(300039, (御魂属性类型英文名.效果抵抗, 0.15), "受到伤害时，有25%基础概率使伤害者眩晕1回合；对被嘲讽目标降低60%触发概率。", False)},
        {御魂种类.狂骨, New 御魂图鉴条目(300048, (御魂属性类型英文名.攻击加成, 0.15), "造成伤害时，每拥有1点鬼火，提升8%伤害。", False)},
        {御魂种类.幽谷响, New 御魂图鉴条目(300049, (御魂属性类型英文名.效果抵抗, 0.15), "抵抗控制效果时，有50%概率将该效果反弹给来源目标 ，且必定命中。", False)},
        {御魂种类.土蜘蛛, New 御魂图鉴条目(300050, Nothing, "唯一被动，对怪物造成伤害时，为其附加1层土蜘蛛印记，降低10%速度，并 造成10%间接伤害，持续1回合。上限3层。", True)},
        {御魂种类.胧车, New 御魂图鉴条目(300051, Nothing, "唯一被动，受到怪物伤害时，有50%概率增加30%行动条，单次攻击内最多触发1次。", True)},
        {御魂种类.荒骷髅, New 御魂图鉴条目(300052, Nothing, "唯一被动，提升10%对怪物伤害，若受到怪物伤害，提升伤害效果改为25%， 持续1回合。", True)},
        {御魂种类.地震鲶, New 御魂图鉴条目(300053, Nothing, "唯一被动，与怪物的战斗开始时，获得60%减伤；每次受到伤害，将6%减伤转化为提升1.5%伤害，单次攻击内最多触发1次。", True)},
        {御魂种类.蜃气楼, New 御魂图鉴条目(300054, Nothing, "唯一被动，与怪物的战斗开始时，获得庇护。庇护会在消失后5回合重新获得。", True)},
        {御魂种类.飞缘魔, New 御魂图鉴条目(300073, (御魂属性类型英文名.效果命中, 0.15), "附加负面状态时，无视30%总效果抵抗。", False)},
        {御魂种类.兵主部, New 御魂图鉴条目(300074, (御魂属性类型英文名.攻击加成, 0.15), "回合结束后，获得1层兵刃（增益，状态）。每层将在造成伤 害时无视目标75点防御，上限3层。", False)},
        {御魂种类.青女房, New 御魂图鉴条目(300075, (御魂属性类型英文名.暴击, 0.15), "首次受到致命伤害时，移除所有增益和减益，恢复100%生命并使自身冰封1回合，期间提升100%防御、免疫所有减益。若冰封结束时仍存活，则再次恢复100%生命。每回目仅触发一次。", False)},
        {御魂种类.涂佛, New 御魂图鉴条目(300076, (御魂属性类型英文名.生命加成, 0.15), "唯一效果。回合结束时，若本回合普攻或无法动作，使友方全体提升15%效果抵抗、伤害，维持2回合，自身提升双倍。", False)},
        {御魂种类.鬼灵歌伎, New 御魂图鉴条目(300077, Nothing, "唯一被动，每对怪物造成5次伤害后，下一次对怪物造成伤害将会对其造成生命上限20%的无视防御伤害，最高不超过攻击的255%", True)}
    }

    Public Shared Function 按类型查找(类型 As 御魂种类) As 御魂图鉴条目
        Return s_data(类型)
    End Function

    Public Shared Iterator Function 按套装属性英文名查找(属性类型 As String) As IEnumerable(Of 御魂图鉴条目)
        For Each v In s_data.Values
            If v.属性类型 = 属性类型 Then
                Yield v
            End If
        Next
    End Function

    Public Shared Iterator Function 按套装属性英文名查找(属性类型 As IEnumerable(Of String)) As IEnumerable(Of 御魂图鉴条目)
        For Each v In s_data.Values
            ' 这样写包含会使用 String.Equals, 脱离 Option Compare 的控制。
            ' If 属性类型.Contains(v.属性类型) Then
            ' 改成下面的写法
            For Each propType In 属性类型
                If v.属性类型 = propType Then
                    Yield v
                End If
            Next
        Next
    End Function

    Public Shared Function 按英文名查找种类(属性类型 As String) As 御魂种类()
        Return Aggregate s In 按套装属性英文名查找(属性类型) Select CType(s.Id, 御魂种类) Into ToArray
    End Function

    Public Shared Function 查找种类(属性类型 As 御魂属性类型) As 御魂种类()
        Return 按英文名查找种类(属性类型.英文名)
    End Function

    Public Shared Function 查找种类(属性类型 As IEnumerable(Of 御魂属性类型)) As IEnumerable(Of 御魂种类)
        Dim 御魂条目 = 按套装属性英文名查找(From itm In 属性类型 Select itm.英文名)
        Dim 种类 = From e In 御魂条目 Select CType(e.Id, 御魂种类)
        Return 种类
    End Function

    Public Shared Function 收录了此类型的御魂(类型 As 御魂种类) As Boolean
        Return s_data.ContainsKey(类型)
    End Function

    Public Shared ReadOnly Property 所有条目 As 御魂图鉴条目()
        Get
            Return s_data.Values.ToArray
        End Get
    End Property
End Class
