﻿namespace BanchoNET.Packets;

public enum ClientPacketId : short
{
	ChangeAction = 0,
	SendPublicMessage = 1,
	Logout = 2,
	RequestStatusUpdate = 3,
	Ping = 4,
	StartSpectating = 16,
	StopSpectating = 17,
	SpectateFrames = 18,
	ErrorReport = 20,
	CantSpectate = 21,
	SendPrivateMessage = 25,
	PartLobby = 29,
	JoinLobby = 30,
	CreateMatch = 31,
	JoinMatch = 32,
	PartMatch = 33,
	MatchChangeSlot = 38,
	MatchReady = 39,
	MatchLock = 40,
	MatchChangeSettings = 41,
	MatchStart = 44,
	MatchScoreUpdate = 47,
	MatchComplete = 49,
	MatchChangeMods = 51,
	MatchLoadComplete = 52,
	MatchNoBeatmap = 54,
	MatchNotReady = 55,
	MatchFailed = 56,
	MatchHasBeatmap = 59,
	MatchSkipRequest = 60,
	ChannelJoin = 63,
	BeatmapInfoRequest = 68,
	MatchTransferHost = 70,
	FriendAdd = 73,
	FriendRemove = 74,
	MatchChangeTeam = 77,
	ChannelPart = 78,
	ReceiveUpdates = 79,
	SetAwayMessage = 82,
	IrcOnly = 84, //TODO
	UserStatsRequest = 85,
	MatchInvite = 87,
	MatchChangePassword = 90,
	TournamentMatchInfoRequest = 93,
	UserPresenceRequest = 97,
	UserPresenceRequestAll = 98,
	ToggleBlockNonFriendDms = 99,
	TournamentJoinMatchChannel = 108,
	TournamentLeaveMatchChannel = 109,
}