# .NET Deobfuscator
## Lists of .NET Deobfuscator / Unpacker (Open Source)
- [Agile](#agile)
- [ArchangelCloak](#archangelcloak)
- [Atomic](#atomic)
- [AutoIt](#autoit)
- [Autori Obfuscator](#autori-obfuscator)
- [Babel](#babel)
- [BoxedAppPacker](#boxedapppacker)
- [BytePress](#bytepress)
- [Beebyte](#beebyte)
- [Confuser 1.9](#confuser-19)
- [ConfuserEx](#confuserex)
- [Crypto Obfuscator](#crypto-obfuscator)
- [Cypher](#cypher)
- [DCNETProtector](#dcnetprotector)
- [De4dot](#de4dot)
- [DNGuard](#dnguard)
- [DotnetPatcher](#dotnetpatcher)
- [DotNetCompressor](#dotnetcompressor)
- [DotRefiner](#dotrefiner)
- [DotWall](#dotwall)
- [Dumper](#dumper)
- [Eazfuscator](#eazfuscator)
- [Habib](#habib)
- [Fixer / Replacer / Simplifier / Remover / Decompressor](#fixer-replacer-simplifier-remover-decompressor)
- [ILProtector](#ilprotector)
- [KoiVM](#koivm)
- [Logic.NET](#logicnet)
- [MemeVM](#memevm)
- [MindLated](#mindlated)
- [NashaVM](#nashavm)
- [Noisette Obfuscator](#noisette-obfuscator)
- [NETReactor](#netreactor)
- [NetShield Protector](#netshield-protector)
- [Obfuscar](#obfuscar)
- [OrangeHeap](#orangeheap)
- [Obfuscar](#obfuscar)
- [Origami](#origami)
- [Patcher](#patcher)
- [Renamer](#renamer)
- [Panda](#panda)
- [Phoenix Obfuscator](#phoenix-obfuscator)
- [Protect.NET](#protectnet)
- [SaintFuscator](#saintfuscator)
- [String Decryptor](#string-decryptor)
- [Skater.Net Obfuscator](#skaternet-obfuscator)
- [SpecterObfuscator](#specterobfuscator)
- [Spices.Net](#spicesnet)
- [VMP.NET](#vmpnet)
- [Themida .NET](#themida-net)
- [Yano](#yano)


## General Lists
- ### Agile
  - [AgileStringDecryptor](https://github.com/NotPrab/AgileStringDecryptor) - A dynamic agile string decryptor that relies on invoke.
  - [Agile.NET-Deobfuscator](https://github.com/ribthegreat99OrN0P/Agile.NET-Deobfuscator) - Deobfuscates Agile.NET controlflow, strings, and proxy delegates. Please let me know for new updates or any other problems. Throughout the full source on every line it contains comments so you can easily understand the process behind it. Enjoy!
  - [AgileDotNet-StringDeobfuscator](https://github.com/waynebonc/AgileDotNet-StringDeobfuscator) - Quickly decrypts strings from Agile.NET (aka AgileDotNet, CliSecure) packed assemblies. Supports multiple modules.
  - [AgileDotNetSlayer](https://github.com/SychicBoy/AgileDotNetSlayer) - A simple and open source (GPLv3) deobfuscator for Agile.NET 

- ### ArchangelCloak
  - [ArchangeIUncloaker](https://github.com/TobitoFatitoNulled/ArchangelUnCloaker) - Public ArchangelCloak Deobfuscator

- ### Atomic
  - [Atomic-Deobfuscator](https://github.com/CursedSheep/Atomic-Deobfuscator) - A deobfuscator for Atomic obfuscator
  
- ### AutoIt
  - [DeobHellper](https://github.com/InforgeNet/DeobHellper) - Yeat Another AutoIt Deobfuscator  
  
- ### Autori Obfuscator
  - [NeonFuscatorDeobfuscator](https://github.com/Mighty00/NeonFuscatorDeobfuscator) - .NET Deobfuscator for Autori Obfuscator (NeonFuscator)

- ### Babel
  - [BabelDeobfuscator](https://github.com/n017/BabelDeobfuscator) - BabelDeobfuscator is an open-source deobfuscator for BabelObfuscator
  - [DeBabelVM](https://github.com/Panthere/DeBabelVM) - DeBabelVM is a restorer for the Babel Obfuscator - This will restore 'msil encrypt' methods for Babel
  - [Babel-Deobfuscator](https://github.com/Melanie-LEB/Babel-Deobfuscator) - Babel-Deobfuscator is an open-source deobfuscator for Babel Obfuscator.
  - [BabelTrialRemover](https://github.com/miso-xyz/BabelTrialRemover) - Remove/Disable Babel Obfuscator 30 Day limit from apps (tested on 9.7.5.0) 

- ### BoxedAppPacker
  - [BoxedAppUnpacked](https://github.com/MindSystemm/BoxedAppUnpacked) - Tool to unpack .net assemblies packed by BoxedAppPacker
  
- ### BytePress
  - [BytePressDecompressor](https://github.com/ribthegreat99OrN0P/BytePressDecompressor) - Unpacks files compressed by BytePress(https://github.com/roachadam/bytepress)
  
- ### Beebyte 
  - [beeless](https://github.com/ioncodes/beeless) - BeeByte Deobfuscator. Used it to deobfuscate an Unity3D Game. Alternatively, de4dot works aswell. 
  - [Beebyte-Deobfuscator](https://github.com/OsOmE1/Beebyte-Deobfuscator) - A plugin for Il2CppInspector that performs quasi deobfuscation 
  - [BB-Deob](https://github.com/KadeDev/BB-Deob) - BeeByte Deobfuscator (RENAME) 
  - [proshine-cleaner](https://github.com/Silv3rPRO/proshine-cleaner) - A small tool to clean an assembly obfuscated with Beebyte's obfuscator. 
  
- ### Confuser 1.9
  - [ConfuserDeobfuscator](https://github.com/maddnias/ConfuserDeobfuscator) - Deobfuscator for Confuser 1.9.0.0 release
  - [DeConfuser](https://github.com/mbonacci/DeConfuser) - This is a deobfuscator for protected confuser assemblies
  - [Confuser-Methods-Decryptor](https://github.com/CodeCracker-Tools/Confuser-Methods-Decryptor) - Confuser-Methods-Decryptor
  
- ### ConfuserEx
  - [NoFuserEx](https://github.com/CodeShark-Dev/NoFuserEx) - Free deobfuscator for ConfuserEx.
  - [Netguard-Unpacker-Public](https://github.com/Tanasittx/NetGuard-Unpacker-Public) - Public NetGuard Deobfuscator
  - [ClarifierEx](https://github.com/chaplin89/ClarifierEx) - Deobfuscator for ConfuserEx
  - [Rzy-Protector-V2-Unpacker](https://github.com/illuZion9999/Rzy-Protector-V2-unpacker) - An unpacker (deobfuscator) for the protector (obfuscator) Rzy Protector V2.
  - [ConfuserEx-Dynamic-Unpacker](https://github.com/hadehadehade/deobfuscator) - A dynamic confuserex unpacker that relies on invoke for most things
  - [ConfuserEx-Unpacker-Mod-By-Bed](https://github.com/BedTheGod/ConfuserEx-Unpacker-Mod-by-Bed) - Edited copy of cawks confuserex unpacker, support more than your averageprogram
  - [ConfuserEx-Unpacker-2](https://github.com/hackovh/ConfuserEx-Unpacker-2) - An Updated ConfuserEx Unpacker Based On Emulation to be more reliable
  - [Krawk-Unpacker](https://github.com/cristlxrd/Krawk-Unpacker) - Krawk Unpacker
  - [EasyPredicateKiller](https://github.com/ZeroPlusBlog/EasyPredicateKiller) - Replacing and Calling ConfuserEx x86 Predicates
  - [ConfuserExSwitchKiller](https://github.com/VAllens/ConfuserExSwitchKiller) - ConfuserExSwitchKiller
  - [ConfuserEx-Anti-Debug-Remover](https://github.com/ALEHACKsp/ConfuserEx-Anti-Debug-Remover) - ConfuserEx-Anti-Debug-Remover
  - [ConfuserEx-Static-String-Decryptor](https://github.com/Loksie/ConfuserEx-Static-String-Decryptor) - A static String Decryptor Based Off Instruction Emulator
  - [ConfuserEx-Static-String-Decryptor](https://github.com/Kinimiwar/ConfuserEx-Static-String-Decryptor) - it will decrypt strings statically from a non modded confuserex with or without cflow doesnt really matter
  - [ConfuserEx-Resources-Decryptor](https://github.com/MindSystemm/ConfuserEx-Resources-Decryptor) - This tool can decrypt encrypted resources from ConfuserEx and replace them
  - [ConfuserExResourceReplace](https://github.com/YuqseLx/ConfuserExResourceReplace) - ConfuserExResourceReplace
  - [ConfuserExTools](https://github.com/wwh1004/ConfuserExTools) - ConfuserEx unpacking tools basic support for ConfuserEx (AntiTamper, ReferenceProxy, Constants)
  - [FinGu-Cfex-Cleaner](https://github.com/CursedLand/FinGu-Cfex-Cleaner) - Removing/Cleaning FinGu Cfex Mutations 
  - [Unscrambler](https://github.com/dr4k0nia/Unscrambler) - Universal unpacker and fixer for a number of modded ConfuserEx protections
  - [Cursed-Auto-Decryptor](https://github.com/CursedLand/Cursed-Auto-Decryptor) - Program Decrypt Cfex / Modded Cfex Constants By Auto Detecting Params 
  - [cfxc-deobf](https://github.com/wildcardc/cfxc-deobf) - A ConfuserEx-custom deobfuscation toolchain  
 
- ### Crypto Obfuscator
  - [Crypto-Deobfuscator](https://github.com/Rhotav/Crypto-Deobfuscator) - A Deobfuscator for Crypto Obfuscator
 
- ### Cypher
  - [Cyphor-Pointer-Remover](https://github.com/CursedLand/Cyphor-Pointer-Remover) - Removes Cyphor Pointer Mutations | Cyphor : cyphor.net

- ### DCNETProtector
  - [DCNetStringDecryptor](https://github.com/miso-xyz/DCNetStringDecryptor) - String Decryptor for DC.NET Protector (tested on v1.1.0.1) 
- ### De4dot
  - [de4dot](https://github.com/0xd4d/de4dot) - .NET deobfuscator and unpacker.
  - [de4dot-cex](https://github.com/ViRb3/de4dot-cex) -  de4dot deobfuscator with full support for vanilla ConfuserEx 

- ### DNGuard
  - [DNGuard-InvalidMD](https://github.com/nelpats/DNGuard-InvalidMD) - The easiest way to remove DNGuard Invalid-MD

- ### DotnetPatcher
  - [DNPDeobfuscator](https://github.com/XenocodeRCE/DNPDeobfuscator) - Open-source deobfuscator for dotnetpatcher (https://bitbucket.org/3dotdev/dotnet-patcher/src/)
  - [Deobf-DotNetPathcer](https://github.com/CodeOfDark/Deobf-DotNetPatcher) - an basic deobfuscator for last version (at the moment) dotnetpatcher (v4.5.9.0) https://bitbucket.org/3DotDev/dotnet-patcher

- ### DotNetCompressor
  - [DotNetCompressorDecompressor](https://github.com/ribthegreat99OrN0P/DotNetCompressorDecompressor) - 
Decompresses files compressed with https://github.com/TotalTechGeek/DotNetCompressor

- ### DotRefiner
  - [DotRefiner-Deobfuscator](https://github.com/DarkObb/DotRefiner-Deobfuscator) - Static DotRefiner Deobfuscator

- ### DotWall
  - [DotWall-Deobfuscator](https://github.com/MindSystemm/DotWall-Deobfuscator) - Deobfuscator for DotWall
  - [Dotwall-deobfuscator](https://github.com/n017/Dotwall-deobfuscator) - A very simple deobfuscator for DotWall Obfuscator

- ### Dumper
  - [ExtremeDumper](https://github.com/wwh1004/ExtremeDumper) - 
.NET Assembly Dumper
  - [Nemesis](https://github.com/not-matthias/Nemesis) - 
A customizable process dumper.
  - [MegaDumper](https://github.com/CodeCracker-Tools/MegaDumper) - 
Dump native and .NET assemblies
  - [KsDumper](https://github.com/EquiFox/KsDumper) - 
Dumping processes using the power of kernel space !

- ### Eazfuscator
  - [EazFixer](https://github.com/HoLLy-HaCKeR/EazFixer) - A deobfuscation tool for Eazfuscator.
  - [eazdevirt](https://github.com/saneki/eazdevirt) -Devirtualizer for Eazfuscator.NET

- ### Habib
  - [habib-deobfuscator-1](https://github.com/sn-0w/habib-deobfuscator-1) - This is part One of my Habib Deobfuscator which will decrypt the actual stub from the packer/security 

- ### Fixer Replacer Simplifier Remover Decompressor
  - [AssemblyRebuilderOld](https://github.com/wwh1004/AssemblyRebuilderOld) - [Obsolete] Fixup .Net Assembly dumped, if it can't work.
  - [AssemblyFixer](https://github.com/wwh1004/AssemblyFixer) - 
Fix assembly pe header and metadata errors
  - [RzyFixer](https://github.com/Riziebtw/RzyFixer) - A .NET Unpacker tool, with many features. Using dnlib assembly & cui for the design.
  - [CalliFixer](https://github.com/Riziebtw/CalliFixer) - Here is a little program that remove calli protection from files, easy to use & easy to understand. Using the dnlib assembly.
  - [Base64Encoding-Fixer](https://github.com/Riziebtw/Base64Encoding-Fixer) - Little tool that i made cuse i'm bored rn, fix the string encryption protection (the one which encrypt strings to base64 made by **forgothisname**). Using dnlib assembly. 
  - [DoubleParseFixer](https://github.com/Riziebtw/DoubleParseFixer) - Little program that i made to fix Double Parse obfuscation. Using dnlib assembly.
  - [Dumpy](https://github.com/nelpats/Dumpy) -  Simple .NET Assembly deobfuscator. 
  - [IntToString-Deobfuscator](https://github.com/epic6969/IntToString-Deobfuscator) - deobfuscator for int to string mutation (C#) supports negative values
  - [Local2FieldFixer](https://github.com/CursedLand/Local2FieldFixer) - Remove Fields From GlobalType<cctor> To Locals
  - [SizeOf-Fixer](https://github.com/RivaTesu/SizeOf-Fixer) -Fix the sizeof of assembly
  - [SuperCalculator](https://github.com/MindSystemm/SuperCalculator) - Helpful tool which handle most operations used in obfuscation
  - [Mathematical-Operation-Simplifier](https://github.com/Rhotav/Mathematical-Operation-Simplifier) -Mathematical Operation Simplifier for .NET Applications
  - [SizeOf-Replacer](https://github.com/Rhotav/SizeOf-Replacer) - SizeOf Replacer for .NET Applications
  - [Junk-Remover](https://github.com/DevT02/Junk-Remover) - .NET attributes cleaner/Junk remover (nops).
  - [ProxyCall-Remover](https://github.com/Kaidoz/ProxyCall-Remover) - Deobfuscator for remove proxy calls methods 
  - [PointMutationRemover](https://github.com/DevT02/PointMutationRemover) - 
Does exactly what the title says, removes Point Mutations. Only supported with 2D points at the moment.
  - [Universal-Math-Fixer](https://github.com/Alxs009/Universal-Math-Fixer) - 
This calculator load all methods from mscorlib.dll and checks equivalence with the method from the instruction
  - [SimpleMathCleaner](https://github.com/Mageland29/SimpleMathCleaner) - 
Simple Math Cleaner with invoke method for generic use
  - [AntiDecompiler-Cleaner](https://github.com/NotPrab/AntiDecompiler-Cleaner) - An exception occurred when decompiling this method 
  - [AntiInvokeDetection](https://github.com/obfuscators-2019/AntiInvokeDetection) - most string deobfuscators use Invoke to pick up the strings, however some obfuscators are using "GetCallingAssembly" to check if the method is being executed by another assembly 
  - [Excess-Nop-Remover](https://github.com/RivaTesu/Excess-Nop-Remover) - Remove excess nop opcodes
  - [Universal-Proxy-Remover](https://github.com/Jomtek/Universal-Proxy-Remover) - A simple and universal .NET proxy remover
  - [ProxyCall-Remover](https://github.com/Kaidoz/ProxyCall-Remover) - Deobfuscator for remove proxy calls methods
  - [UnSealer](https://github.com/CursedLand/UnSealer) - A Deobfuscator Base Which Uses Plugins And Multi-Platform Of Assembly Lib's | Its Easy To Build On Download Now Make Ur Own Plugin !                 
  - [Simple-Costura-Decompressor](https://github.com/dr4k0nia/Simple-Costura-Decompressor) - Simple tool to extract and decompress embedded resources processed by Fody Costura 
  - [Fody-Costura-Decompress](https://github.com/G4224T/Fody-Costura-Decompress) -  Fody-Costura Decompress           
  - [netshrinkTrialRemover](https://github.com/miso-xyz/netshrinkTrialRemover) - Removes Trial Restrication from .netshrink Applications (tested on v2.9)        
  - [PEXTUnion](https://github.com/miso-xyz/PEXTUnion) - Cleaner & Extractor for PEUnion (tested on PEunion 3.1.5) 
  - [NETz_Unpacker](https://github.com/miso-xyz/NETz_Unpacker) - Unpacker for NETz Compressor  
  - [MutationCleaner](https://github.com/miso-xyz/MutationCleaner) - Mod of DevT02's Point Mutation Remover. Now supports TimeSpan Mutations & Now has Better CUI    
  - [CCFlow](https://github.com/miso-xyz/CCFlow) - a control flow (cflow) cleaner       
  - [GruMinion](https://github.com/miso-xyz/GruMinion) - Full Deobfuscator for PEUnion 4.0.0 (.NET & PE32) 
  - [EazRemoveTrial](https://github.com/M4doT/EazRemoveTrial) - After protected with Eazfuscator trial version then drag your protected file into EazRemoveTrial.exe, So you can use it forever not for 7 days, Working with lastest version
  - [DotNetReactorTrialRemover](https://github.com/CabboShiba/DotNetReactorTrialRemover) - Remove 14-Days Trial with this tool. Made with Harmony by Cabbo. 
  - [EazFuscatorTrialRemover](https://github.com/CabboShiba/EazFuscatorTrialRemover) - Remove 7-Days EazFuscator Trial with this tool. Made with Harmony.  


- ### ILProtector
  - [ILProtectorUnpacker](https://github.com/RexProg/ILProtectorUnpacker) - ILProtector Unpacker Script
  - [ILUnpacker](https://github.com/Michidu/ILUnpacker) - A simple unpacker for ILProtector. Supported versions <= 2.0.21.4.
  - [ILUnpacker](https://github.com/TobitoFatitoNulled/ILPUnpacker) - Different approach on unpacking ILProtector (Latest)

- ### KoiVM
  - [OldRod](https://github.com/Washi1337/OldRod) - An automated KoiVM devirtualisation utility
  - [Rhydon](https://github.com/TobitoFatitoRE/Rhydon) - Rhydon

- ### Logic.NET
    - [LoGeek](https://github.com/miso-xyz/LoGeek) - LoGiC.NET Deobfuscator, supports all protections except proxy calls, currently getting updated to work with LoGiC.NET v1.5     
    - [DuckiKov](https://github.com/miso-xyz/DuckiKov) - Cleaner for kov.NET (Modded LoGiC.NET) 
    - [LoGiC.NET-Deobfuscator](https://github.com/dinhle85/LoGiC.NET-Deobfuscator) - Deobfuscator for LoGiC.NET Obfuscator. 

- ### MemeVM
  - [MemeDevirtualizer](https://github.com/MindSystemm/MemeDevirtualizer) - Devirtualizer for MemeVM (MindSystem)
  - [MemeVM-Devirt](https://github.com/CursedSheep/MemeVM-Devirt) - A devirtualizer for MemeVM (CursedSheep)
  - [MemeVMDevirt](https://github.com/congviet/MemeVMDevirt) - devirtualizer for memevm (MageLand29)

- ### MindLated
  - [LostMyMisoSoup](https://github.com/miso-xyz/LostMyMisoSoup) - a stable & effective deobfuscator for MindLated

- ### NashaVM
  - [Deoxys](https://github.com/StackUnderflowRE/Deoxys) - Deoxys is a Devirtualization utility for NashaVM, a Virtual Machine which runtime was made in C++/CLI 
  - [TheBear](https://github.com/GabTeix/TheBear) - .NET Devirtualizer for NashaVM that Gabtiex made for nothing.

- ### Noisette Obfuscator
  - [Noisette-Deobfuscator](https://github.com/Rhotav/Noisette-Deobfuscator) - A Deobfuscator for Noisette Obfuscator

- ### NETReactor
  - [Krypton](https://github.com/TobitoFatitoRE/Krypton) - .Net Reactor Devirtualizer
  - [.NET-Reactor-String-Decryptor](https://github.com/robert169/.NET-Reactor-String-Decryptor) - .NET-Reactor-String-Decryptor
  - [.NetReactorCfCleaner](https://github.com/SychicBoy/.NetReactorCfCleaner) - A control flow cleaner for .net reactor 6x
  - [.NETReactor_6.3.0.0_Only_Strings](https://github.com/DarkBullNull/.NETReactor_6.3.0.0_Only_Strings) - Example deobfuscate .NET Reactor 6.3.0.0 strings(ONLY STRINGS)
  - [Cursed.Reactor](https://github.com/CursedLand/Cursed.Reactor) - Full .Net Reactor UnPacker 🙂 Except VM & NecroBit 
  - [NET-Reactor-Cflow-Cleaner-6.7.0.0](https://github.com/Hussaryn/NET-Reactor-Cflow-Cleaner-6.7.0.0) - Simple Controlflow Deobfuscator for .NET Reactor 6.7.0.0
  - [NET-Reactor-String-Cleaner-6.7.0.0](https://github.com/Hussaryn/NET-Reactor-String-Cleaner-6.7.0.0) - Simple String Cleaner for .NET Reactor 6.7.0.0
  - [.NETReactorSlayer](https://github.com/SychicBoy/NETReactorSlayer) - A GUI and CLI deobfuscator for .NET Reactor which also decrypts tokens, cleans, flow deobfuscator, and many more. 

- ### NetShield Protector
  - [UniShield](https://github.com/miso-xyz/UniShield) - Deobfuscator for NetShield Protector 
                                                                                                                           
- ### Obfuscar
  - [DeObfuscar](https://github.com/XenocodeRCE/DEObfuscar) - An open source deobfuscator for 'Obfuscar'
  - [DeObfuscar-Static](https://github.com/DarkObb/DeObfuscar-Static) - Static Obfuscar Deobfuscator 

- ### OrangeHeap
  - [OrangeHeap-Deobfuscator](https://github.com/netlool/OrangeHeap-Deobfuscator) - Deobfuscates an Assembly protected with Orangeheap

- ### Origami
  - [Unfold](https://github.com/nelpats/Unfold) - Unfold is a simple tool that extract Assmebly packed with Origami.
  - [PaperPlane](https://github.com/miso-xyz/PaperPlane) - Yet Another Origami Unpacker but this one has amogus jokes and support XOR encryption 

- ### Patcher
  - [.NET-Virtualized-App-Patcher](https://github.com/ForlaxPy/.NET-Virtualized-Apps-Patcher) - This is a universal Patcher that I coded for Virtualized Applications. Protected by KoiVM/EazVM/AgileVM. The project idea wasn't mine at all it was by xsilent and Tobito and they released a txt that contains the tracer, uh I asked time for some infos and ended up coding my version.
  - [JIT-Freezer](https://github.com/ZrCulillo/JIT-Freezer) - This program is used to suspend applications with a native layer in order to dump them (Only .NET)
  - [Venturi77CallHijacker](https://github.com/TobitoFatitoNulled/Venturi77CallHijacker) - KoiVM,EazVM,AgileVM Patcher.
  - [Harmony](https://github.com/pardeike/Harmony) - A library for patching, replacing and decorating .NET and Mono methods during runtime
  - [JitUnpacker-Framework](https://github.com/wwh1004/JitUnpacker-Framework) - A jit hook and unpacker framework
  - [dnpatch](https://github.com/ioncodes/dnpatch) - dnpatch is the ultimate library for all your .NET patching needs. It offers automated assembly patching, signature scanning and last but but not least bypassing of obfuscators by its ability to find methods in renamed/obfuscated types. Since the stars on GitHub exploded in a few days, dnpatch has been extended by a couple of projects. The most important one is dnpatch.deobfuscation which integrates de4dot directly into dnpatch. Also there is dnpatch.script, which gives you the ability to write patchers with pure JSON! The library itself uses dnlib (see next part).



- ### Renamer
  - [simple-deobfuscator](https://github.com/SLenik/simple-deobfuscator) - simple-deobfuscator
  - [BB-Deob](https://github.com/KadeDev/BB-Deob) - BeeByte Deobfuscator simply renames all the classes/fields/methods/params to readable strings that can be understood. AS I know BB Obfuscator only renames classes and etc, so it should be fully reversable at that point.

- ### Panda
  - [Panda-Deobfuscator](https://github.com/Alxs009/Panda-Deobfuscator) - Panda Deobfuscator

- ### Phoenix Obfuscator
  - [PhoenixDeobfuscator](https://github.com/n017/PhoenixDeobfuscator) - PhoenixDeobfuscator is an open-source deobfuscator for PhoenixObfuscator
  - [Phoenix-Protector-Strings-Decryptor](https://github.com/illuZion9999/Phoenix-Protector-Strings-Decryptor) - A strings decryptor for Phoenix Protector (Illuzion9999)
  - [Phoenix-String-Decryptor](https://github.com/Jomtek/Phoenix-String-Decryptor) - A simple tool which decrypts strings protected with Phoenix Protector (Jomtek)
 
- ### Protect.NET
  - [ProtectNotNet](https://github.com/netlool/ProtectNotNet) - Decrypts Protect.NET encrypted strings 

- ### SaintFuscator
  - [SinUnfuscator](https://github.com/miso-xyz/SinUnfuscator) - Basic Deobfuscator for SaintFuscator   

- ### String Decryptor
  - [StackYenoDeobfuscator](https://github.com/MindSystemm/StackYenoDeobfuscator) - String decryptor relying on the stack. Made for teach
  - [StringDecryptorBase](https://github.com/MindSystemm/StringDecryptorBase) - Complete basic string decryptor to help new reversers. The code is commented
  - [Deobfuscation-Tutorials](https://github.com/TheProxyRE/Deobfuscation-Tutorials) - String Deobfuscation Tutorials by TheProxy
  - [DynamicStringDecrypter](https://github.com/ribthegreat99OrN0P/DynamicStringDecrypter) - Decrypts strings dynamically, using https://github.com/Washi1337/AsmResolver
  - [OutStringDecrypter](https://github.com/Virility/OutStringDecrypter) - OutStringDecrypter

- ### Skater.Net Obfuscator
  - [Skater.NetDeobfuscator](https://github.com/MindSystemm/Skater.NetDeobfuscator) - Deobfuscator for RustemSoft Skater.Net Obfuscator
 
- ### SpecterObfuscator
  - [SpecterObfuscator-Deobfuscator](https://github.com/XenocodeRCE/SpecterObfuscator-Deobfuscator) - a deobfuscator for https://github.com/NepErwin/SpecterObfuscator

- ### Spices.Net
  - [CajunSpice](https://github.com/miso-xyz/CajunSpice) - Strings & Proxy Fixer for Spices.net 5.22.29.3   

- ### VMP.NET
  - [VMP.NET-Kill](https://github.com/DarkBullNull/VMP.NET-Kill) - This program allows you to bypass CRC checking, anti-debugging and anti-VM. Doesn't work when the app is packaged. 
  - [VMUnprotect.Dumper](https://github.com/void-stack/VMUnprotect.Dumper) - VMUnprotect.Dumper can dynamically untamper VMProtected Assembly. 
- ### Themida .NET
  - [Themida-Unpacker-for-.NET](https://github.com/cg10036/Themida-Unpacker-for-.NET) - Themida Unpacker for .NET
  - [ThemidaStringDecryptor](https://github.com/oSumAtrIX/ThemidaStringDecryptor) - Decrypt strings from a themida .net module dump 
  
- ### Yano
  - [YanoDeobfuscator](https://github.com/n017/YanoDeobfuscator) - YanoDeobfuscator is an open-source deobfuscator for YanoObfuscator
 
## Contributing
Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.
