#[rustfmt::skip]
static BITMAP_HEX: [[u8; 10]; 16] = [
	[
		0b00000000,
		0b00111110,
		0b01000001,
		0b01000001,
		0b01000001,
		0b01000001,
		0b01000001,
		0b01000001,
		0b01000001,
		0b00111110,
	],
	[
		0b00000000,
		0b00000100,
		0b00001100,
		0b00010100,
		0b00100100,
		0b00000100,
		0b00000100,
		0b00000100,
		0b00000100,
		0b00000000,
	],
	[
		0b00000000,
		0b00111100,
		0b01000010,
		0b00000010,
		0b00000100,
		0b00001000,
		0b00010000,
		0b00100000,
		0b01000000,
		0b11111111,
	],
	[
		0b00000000,
		0b00111110,
		0b00000001,
		0b00000001,
		0b00000001,
		0b00111110,
		0b00000001,
		0b00000001,
		0b00000001,
		0b00111110,
	],
	[
		0b00000000,
		0b00000000,
		0b01000001,
		0b01000001,
		0b01000001,
		0b00111111,
		0b00000001,
		0b00000001,
		0b00000001,
		0b00000000,
	],
	[
		0b00000000,
		0b00111110,
		0b01000000,
		0b01000000,
		0b01000000,
		0b00111110,
		0b00000001,
		0b00000001,
		0b00000001,
		0b00111110,
	],
	[
		0b00000000,
		0b00111110,
		0b01000000,
		0b01000000,
		0b01000000,
		0b00111110,
		0b01000001,
		0b01000001,
		0b01000001,
		0b00111110,
	],
	[
		0b00000000,
		0b01111111,
		0b00000010,
		0b00000010,
		0b00000100,
		0b00000100,
		0b00001000,
		0b00001000,
		0b00010000,
		0b00010000,
	],
	[
		0b00000000,
		0b00111110,
		0b01000001,
		0b01000001,
		0b01000001,
		0b00111110,
		0b01000001,
		0b01000001,
		0b01000001,
		0b00111110,
	],
	[
		0b00000000,
		0b00111110,
		0b01000001,
		0b01000001,
		0b01000001,
		0b00111110,
		0b00000001,
		0b00000001,
		0b00000001,
		0b00111110,
	],
	[
		0b00000000,
		0b00111110,
		0b01000001,
		0b01000001,
		0b01000001,
		0b00111110,
		0b01000001,
		0b01000001,
		0b01000001,
		0b00000000,
	],
	[
		0b00000000,
		0b00000000,
		0b01000000,
		0b01000000,
		0b01000000,
		0b01111110,
		0b01000001,
		0b01000001,
		0b01000001,
		0b00111110,
	],
	[
		0b00000000,
		0b00111110,
		0b01000000,
		0b01000000,
		0b01000000,
		0b01000000,
		0b01000000,
		0b01000000,
		0b01000000,
		0b00111110,
	],
	[
		0b00000000,
		0b00000000,
		0b00000001,
		0b00000001,
		0b00000001,
		0b00111111,
		0b01000001,
		0b01000001,
		0b01000001,
		0b00111110,
	],
	[
		0b00000000,
		0b01111110,
		0b01000000,
		0b01000000,
		0b01000000,
		0b01111110,
		0b01000000,
		0b01000000,
		0b01000000,
		0b01111110,
	],
	[
		0b00000000,
		0b01111110,
		0b01000000,
		0b01000000,
		0b01000000,
		0b01111100,
		0b01000000,
		0b01000000,
		0b01000000,
		0b01000000,
	],
];

pub fn bitify_u32_hex(num: u32) -> [[u8; 8]; 10] {
	let mut b = [[0; 8]; 10];
	for i in 0..8 {
		for k in 0..10 {
			b[k][i] = BITMAP_HEX[((num >> 28 - i * 4) & 0xf) as usize][k];
		}
	}
	b
}
