function OneTextLib(list, onRefresh = function () {}) {
    this.list = list;
    this.onRefresh = onRefresh;
    this.step = 0;
    this.refresh();
}
OneTextLib.init = function (lists) {
    libs = [];
    for (let i in lists) {
        libs.push(new OneTextLib(lists[i]));
    }
    return libs;
}
OneTextLib.prototype.get = function () {
    return (this.step < this.order.length) ?
        this.list[this.order[this.step++]] :
        this.refresh().get();
}
OneTextLib.prototype.refresh = function () {
    this.order = [];
    this.step = 0;
    for (let i in this.list) {
        this.order.push(i);
    }
    OneTextLib.shuffle(this.order);
    this.onRefresh && this.onRefresh();
    return this;
}
OneTextLib.shuffle = function (array) {
    var m = array.length,
        t, i;
    while (m) {
        i = Math.floor(Math.random() * m--);
        t = array[m];
        array[m] = array[i];
        array[i] = t;
    }
    return array;
}
OneTextLib.randint = function (array) {
    return array[Math.floor(Math.random() * array.length)];
}

function OneText(selector, config = {}) {
    this.tag = $(selector);
    this.detail = Boolean(this.tag.find('.text').length);
    this.config = config;
    config.libs = (config.libs === undefined) ?
        this.detail ? ['official', 'april'] : ['official', 'netease', 'april', 'ext'] :
        config.libs;
    this.libs = [];
    for (let i in config.libs) {
        OneText.libs[config.libs[i]] && this.libs.push(OneText.libs[config.libs[i]]);
    }
    this.config.interval = (this.config.interval === undefined) ?
        20 : this.config.interval;
    this.config.dash = (this.config.dash === undefined) ?
        true : this.config.dash;
    this.config.quote = (this.config.quote === undefined) ?
        false : this.config.quote;
    this.textTag = (this.detail) ?
        this.tag.find('.text') :
        this.tag;
    this.byTag = (this.tag.find('.by').length) ?
        this.tag.find('.by') :
        null;
    this.fromTag = (this.tag.find('.from').length) ?
        this.tag.find('.from') :
        null;
    this.timeTag = (this.tag.find('.time').length) ?
        this.tag.find('.time') :
        null;
    this.setInterval(this.config.interval);
    this.set(true);
}
OneText.jsons = {
    official: [
        {
            "text": "黑夜给了我黑色眼睛，我却用它寻找光明",
            "by": "顾城",
            "from": "《一代人·巨星》\n《顾城的诗》2010年版，人民文学出版社",
            "time": [
			"2018.12.7",
			"1976.4"
		]
	},
        {
            "text": "一路上樱花照眼，她静静看着窗外流荡过去的风景，窗玻璃映出她自己的容颜，和窗外的粉色樱花明灭掩映；她的眼神迷离，时空飘忽。",
            "by": "龙应台",
            "from": "《雨儿》\n《目送》2014年版，广西师范大学出版社",
            "time": [
			"2018.12.7"
		]
	},
        {
            "text": "我慢慢地，慢慢地了解到，所谓父女母子一场只不过意味着，你和他的缘分就是今生今世不断地在目送他的背影渐行渐远。",
            "by": "龙应台",
            "from": "《目送》2014年版，广西师范大学出版社",
            "time": [
			"2018.12.7"
		]
	},
        {
            "text": "有些事，只能一个人做。有些关，只能一个人过。有些路啊，只能一个人走。",
            "by": "龙应台",
            "from": "《山路》\n《目送》2014年版，广西师范大学出版社",
            "time": [
			"2018.12.7"
		]
	},
        {
            "text": "我是没学过",
            "by": "龙应台",
            "from": "《海伦》\n《目送》2014年版，广西师范大学出版社",
            "time": [
			"2018.12.7"
		]
	},
        {
            "text": "尚未决定清与浊的心，是否能成为自己的眼睛？",
            "by": "河南省郑州市第二中学 赵文琦",
            "from": "《清雨·浊雨》\n语文老师下发的作业纸，原来源不明",
            "time": [
			"2018.12.7"
		]
	},
        {
            "text": "致理想国：\n离别的车站\n见证了比婚礼殿堂更挚爱的拥抱。\n医院的墙壁\n上有比教堂更真诚的祈祷。",
            "from": "咱在2018中考复习时期的一个夜里，在咱就读中学的专用教室二中捡到了这张明信片。",
            "time": [
			"2018.12.7",
			"2018.6.3"
		]
	},
        {
            "text": "心向花开，何不朝夕。",
            "by": "浙江省新昌中学 安则成",
            "from": "《百年浅吟》\n《中学生天地》2018年10月A刊 总第838期",
            "time": [
			"2018.12.8"
		]
	},
        {
            "text": "孤身一人，去往一个陌生地方，开启一段未知旅程。",
            "by": "宁波市镇海中学 钭兰朵",
            "from": "《转学路？不，青春纪！》\n《中学生天地》2018年9月A刊 总第835期",
            "time": [
			"2018.12.8"
		]
	},
        {
            "text": "盛夏的那张数学卷子，一笔一画，我都写得极认真。卷子交上去，被塞进档案袋里，我的七年级结束了。",
            "by": "浙江省开化县第三初级中学 黄婵宁",
            "from": "《周大伯你好，周大伯再见》\n《中学生天地》2018年9月A刊 总第835期",
            "time": [
			"2018.12.8"
		]
	},
        {
            "text": "呐，我对你的沉沦，就像樱花落入大地~",
            "by": "卡古",
            "from": "《你看樱花我看你》\n《知音漫客》2016.17 VOL.406",
            "time": [
			"2018.12.8",
			"2016.4"
		]
	},
        {
            "text": "嗨！要溢出粉色泡泡的香草女孩，\n跨越三角尺的制服鞋，干净清爽的三角巾，\n放课后的绿荫小巷，蓝色把天空染成了炫目的晴朗。",
            "by": "乱码",
            "from": "《春色の空》\n《知音漫客》2016.15 VOL.404",
            "time": [
			"2018.12.8",
			"2016.3"
		]
	},
        {
            "text": "青春把记忆印成彩色的相片，\n镶嵌在少女如云柔软的裙摆里！",
            "by": "乱码",
            "from": "《春色の空》\n《知音漫客》2016.15 VOL.404",
            "time": [
			"2018.12.8",
			"2016.3"
		]
	},
        {
            "text": "那涂涂画画的字句，幼圆的字体，\n只有一句，我喜欢你。",
            "by": "乱码",
            "from": "《春色の空》\n《知音漫客》2016.15 VOL.404",
            "time": [
			"2018.12.8",
			"2016.3"
		]
	},
        {
            "text": "我也喜欢哦，那种追求温柔的，暖暖的，互相吸引着的，用力生活的心情。",
            "from": "《知音漫客》2016.17 VOL.406 P31",
            "time": [
			"2018.12.8"
		]
	},
        {
            "text": "还有问题想知道答案……但我已经是看过最多星星的一只兔子了！",
            "by": "玉兔号",
            "from": "新浪微博 月球车玉兔",
            "time": [
			"2018.12.9",
			"2016.7.31"
		]
	},
        {
            "text": "我感谢一切我有权奉承的神明，让我在这个不唯一的世界遇见唯一的你。",
            "by": "金华市磐安县实验初中 金超",
            "from": "《Vitamin少女》\n《中学生天地》2016年10月A刊 总第766期",
            "time": [
			"2018.12.9"
		]
	},
        {
            "text": "我站在路口，哈出的气可以把那些六角形的雪融化。",
            "by": "萧萍",
            "from": "《嗨，STORM GLASS》\n《中学生天地》2018年4月A刊 总第820期",
            "time": [
			"2018.12.9"
		]
	},
        {
            "text": "太阳离开了\n星星就会来\n而你离开我\n还会有谁呢",
            "by": "河南省长葛市第一高级中学 黄荣荣",
            "from": "《离歌》\n《校园第一阅读》2016年7月刊 总第63期",
            "time": [
			"2018.12.12"
		]
	},
        {
            "text": "歪歪斜斜的影子\n悄悄",
            "by": "顾城",
            "from": "《星岛的夜》\n《顾城的诗》2010年版，人民文学出版社",
            "time": [
			"2018.12.4",
			"1981.2"
		]
	},
        {
            "text": "一草一千秋，一花一世界",
            "by": "龙应台",
            "from": "《杜甫》\n《目送》2014年版，广西师范大学出版社",
            "time": [
			"2018.12.30"
		]
	},
        {
            "text": "身不得，男儿列，心却比，男儿烈。",
            "by": "秋瑾",
            "from": "《满江红》\n教育部统编《语文》九年级下册 2018年12月第1版",
            "time": [
			"2019.3.30",
			"1903"
		]
	},
        {
            "text": "但是我，我没有眼泪。宇宙，宇宙也没有眼泪呀！眼泪有什么用啊？",
            "by": "郭沫若",
            "from": "《屈原》\n教育部统编《语文》九年级下册 2018年12月第1版",
            "time": [
			"2019.3.30",
			"1942"
		]
	},
        {
            "text": "我是那么喜欢夏日的花影。每每走在路上，耳朵里灌着人声、车声、蝉鸣声，我仍不觉得聒噪，因为路上总有花树，总有花影，清清凉凉，被风抚着，清幽解暑。",
            "by": "白音格力",
            "from": "《最美是花影不扫》\n语文老师在中考复习期间下发的一张练习纸",
            "time": [
			"2019.5.20"
		]
	},
        {
            "text": "亭边总有花影，与我消遣一段旖旎的小时光。",
            "by": "白音格力",
            "from": "《最美是花影不扫》\n语文老师在中考复习期间下发的一张练习纸",
            "time": [
			"2019.5.20"
		]
	},
        {
            "text": "周日，午后的阳光总是那么慵懒，樱花树上缀满了粉色的小花，远远望去像一团浅粉色的烟花。",
            "by": "浙江省德清县第一中学 姚佳英",
            "from": "《野蛮生长》\n《中学生天地》2019年4月A刊 总第859期",
            "time": [
			"2019.6.11"
		]
	},
        {
            "text": "樱花落在赤裸的土壤上再也不会绽放，教室的窗外响起了蝉鸣，夏天到了。",
            "by": "浙江省德清县第一中学 姚佳英",
            "from": "《野蛮生长》\n《中学生天地》2019年4月A刊 总第859期",
            "time": [
			"2019.6.11"
		]
	},
        {
            "text": "这座城又到了一年的毕业季。\n这座城再没有了我们的南池路100号",
            "by": "浙江省绍兴市稽山中学 朱涵冰",
            "from": "《也不是很久之前的南池路100号》\n《中学生天地》2019年6月A刊 总第862期",
            "time": [
			"2019.6.11"
		]
	},
        {
            "text": "白天四处回响的学生们的喧嚣声全无踪迹。\n连虫鸣声，都像是从别的世界传来的。",
            "from": "《駄作》",
            "time": [
			"2019.7.28"
		]
	},
        {
            "text": "向天空拼命伸出的双手，发射那么巨大的东西，只是为了寻找超出想象的彼岸所存在的东西。",
            "from": "《秒速五厘米》",
            "time": [
			"2019.7.28"
		]
	},
        {
            "text": "是男还是女，没有关系呢。",
            "from": "《駄作》",
            "time": [
			"2019.7.28"
		]
	},
        {
            "text": "原来，天上的星，都是曾被人惦念而又遗忘的梦啊。",
            "from": "《小荷》\n初中时学校的一本杂志",
            "time": [
			"2019.8.1"
		]
	},
        {
            "text": "至此以后，杀死幻想。",
            "by": "Gamer",
            "from": "咱的一位朋友",
            "time": [
			"2019.8.3"
		]
	},
        {
            "text": "既然决定成为一个女孩子，既然决定走上这条忤逆‘上帝’的路，那在最开始的时候就已经决定和命运抗争到底了。",
            "by": "乱世银娘",
            "from": "《想要变成鹰的鱼》",
            "time": [
			"2019.8.12"
		]
	},
        {
            "text": "她更期待夏日午后痛快炽烈的阳光。\n正如他们那痛快炽烈的青春和爱情。",
            "by": "苏小懒",
            "from": "《如果你曾奋不顾身爱上一个人》",
            "time": [
			"2019.9.8"
		]
	},
        {
            "text": "这些悄悄抽出小绿芽的幼苗，终将有一天会长成参天大树吧。",
            "by": "苏小懒",
            "from": "《如果你曾奋不顾身爱上一个人》",
            "time": [
			"2019.9.8"
		]
	},
        {
            "text": "一只飞鸟以零点三倍马赫的速度划过天空，留下两道白色的翼痕。",
            "by": "爱吃鱼的小肥羊",
            "from": "高中篇（一） 翼痕\n《想要成为女孩子》",
            "time": [
			"2019.10.7"
		]
	},
        {
            "text": "死并非生的对立面，而作为生的一部分永存。",
            "by": "村上春树",
            "from": "《挪威的森林》 第二章",
            "time": [
			"2019.10.24"
		]
	},
        {
            "text": "树梢间泻下的秋日阳光，在她肩部一闪一闪地跳跃着。",
            "by": "村上春树",
            "from": "《挪威的森林》 第一章",
            "time": [
			"2019.10.31"
		]
	},
        {
            "text": "生在此侧，死在彼侧。我在此侧，不在彼侧。",
            "by": "村上春树",
            "from": "《挪威的森林》 第二章",
            "time": [
			"2019.10.31"
		]
	},
        {
            "text": "我一边注视沉默的空间里闪闪浮动的光粒子，一边力图确定心的坐标。",
            "by": "村上春树",
            "from": "《挪威的森林》 第二章",
            "time": [
			"2019.10.31"
		]
	},
        {
            "text": "我从壁橱里取出被褥，让她躺好，一边吸烟一边看着窗外的绵绵春雨。",
            "by": "村上春树",
            "from": "《挪威的森林》 第三章",
            "time": [
			"2019.10.31"
		]
	},
        {
            "text": "当两颗卫星的轨道偶尔交叉时，我们便这样相会了。",
            "by": "村上春树",
            "from": "第九章\n《斯普特尼克恋人》 2008年7月第1版，上海译文出版社",
            "time": [
			"2019.12.15"
		]
	},
        {
            "text": "现在我们也都还各自活着，我想。",
            "by": "村上春树",
            "from": "第十六章\n《斯普特尼克恋人》 2008年7月第1版，上海译文出版社",
            "time": [
			"2019.12.15"
		]
	},
        {
            "text": "我把人生看成是无常的，把人的无可奈何、与生俱来的轻薄看成是虚无的。",
            "by": "夏目漱石",
            "from": "《心》 上 先生和我\n陕西师范大学出版总社 2013年8月第1版",
            "time": [
			"2020.1.16"
		]
	},
        {
            "text": "我还没找到。\n我还不知道。",
            "by": "新海 诚",
            "from": "《天气之子》 终章 不要紧\n百花洲文艺出版社 2019年10月第1版",
            "time": [
			"2020.1.16"
		]
	},
        {
            "text": "在东京的天空上，我们决定性的改变了世界的模样。",
            "by": "新海 诚",
            "from": "《天气之子》 序章 听你说过的故事\n百花洲文艺出版社 2019年10月第1版",
            "time": [
			"2020.1.16"
		]
	},
        {
            "text": "自古以来，天空上就是另一个世界。",
            "by": "新海 诚",
            "from": "《天气之子》 第六章，天空的彼岸\n百花洲文艺出版社 2019年10月第1版",
            "time": [
			"2020.1.16"
		]
	},
        {
            "text": "神啊，求求你。\n已经足够了。\n已经没事了。\n我们都会熬过去的。",
            "by": "新海 诚",
            "from": "《天气之子》 第八章 最后的夜晚\n百花洲文艺出版社 2019年10月第1版",
            "time": [
			"2020.1.16"
		]
	},
        {
            "text": "影响大众想象力的，并不是事实本身，而是它扩散和传播的方式。",
            "by": "古斯塔夫·勒庞",
            "from": "《乌合之众》",
            "time": [
			"2020.1.28",
			"1895"
		]
	},
        {
            "text": "人死后会成为什么?\n夜空中的一座孤岛。",
            "by": "著小生zoki",
            "from": "«一封孤岛的信»",
            "time": [
			"2020.2.6"
		]
	},
        {
            "text": "我想告诉你，这个世界是为了你幸福才存在的。",
            "by": "猫薄荷制作组",
            "from": "《关于我被小学女生绑架这件事》",
            "time": [
			"2020.2.7"
		]
	},
        {
            "text": "当你想要放弃的时候，想想是什么让你当初坚持走到了这里。",
            "by": "科比",
            "time": [
			"2020.2.7"
		]
	},
        {
            "text": "当脑子里很乱的时候，做爱是最好的选择。\n要是烦恼和痛苦也都能被快感冲走的话就好了。",
            "from": "《駄作》 爱丽丝与克罗艾连结之日",
            "time": [
			"2020.2.9"
		]
	},
        {
            "text": "这世上，有所谓的普通人类吗……\n任何人身上都有一定的不健全。完美的人是不存在的。\n这即是说人类为拙作——\n绝对正确的选择是做不到的——\n所以……肯定……无论是怎样的人类……\n最后都……会变成这样——？",
            "from": "《駄作》 爱丽丝与克罗艾连结之日",
            "time": [
			"2020.2.9"
		]
	},
        {
            "text": "每个人都在自己的生命中频繁地抛弃着自己的过去。",
            "by": "米哈游",
            "from": "视觉小说《幽兰黛尔》 第29话",
            "time": [
			"2020.2.9"
		]
	},
        {
            "text": "梦如同黎明的泡沫一样渐渐消失。",
            "by": "米哈游",
            "from": "视觉小说《幽兰黛尔》 第30话",
            "time": [
			"2020.2.9"
		]
	},
        {
            "text": "即使这些回忆使我感到悲伤，我也必须前进，相信未来。\n即使是在我感到了我的孤单，即将失去所有的希望，这份回忆，也使我更加坚强。",
            "by": "Porter Robinson",
            "from": "《Shelter》\nShort Film with A-1 Pictures & Crunchyroll",
            "time": [
			"2020.2.18"
		]
	},
        {
            "text": "每个人每一天的价值都是完全相等的，无论做什么，都不会改变我今天活着的价值。",
            "from": "《我想吃掉你的胰脏》",
            "time": [
			"2020.2.23"
		]
	},
        {
            "text": "我这个人呀，能过着这样平凡普通的日子就很开心了。",
            "from": "《我想吃掉你的胰脏》",
            "time": [
			"2020.2.23"
		]
	},
        {
            "text": "每个人能走到现在，都是自己选择的结果。",
            "from": "《我想吃掉你的胰脏》",
            "time": [
			"2020.2.23"
		]
	},
        {
            "text": "只要人活在这世上就一定是有意义的，怎么活是自己选的。",
            "from": "《我想吃掉你的胰脏》",
            "time": [
			"2020.2.23"
		]
	},
        {
            "text": "都说樱花飘落时让人伤感，而我看到樱花盛开也觉得伤感，因为我会计算，我还能再看几次樱花盛开呢。",
            "from": "《我想吃掉你的胰脏》",
            "time": [
			"2020.2.23"
		]
	},
        {
            "text": "你的温暖照亮我的心怀，\n夏天的花正在身边盛开。",
            "by": "逻辑",
            "from": "《Summer Flower》",
            "time": [
			"2020.4.7"
		]
	},
        {
            "text": "秋日的虫鸣，\n夏夜的星野，\n那天夕阳下，\n与她的身影。\n每一个孤独的夜里，\n你是否在追忆着什么？",
            "by": "千本y",
            "from": "酷安提问《你在怀念着什么？》",
            "time": [
			"2020.4.10"
		]
	},
        {
            "text": "曾经的灯塔上面\n他为她放的烟火 倒映在江面",
            "by": "Z新豪",
            "from": "《幹物女(WeiWei)》",
            "time": [
			"2020.4.11"
		]
	},
        {
            "text": "在冷酷和粗暴的世界里，用自己温柔的方式生存下去的人，是了不起的人，我想做一个了不起的人。",
            "by": "水木丁",
            "from": "《只愿你曾被这世界温柔相待》\n2012年9月第1版，广西师范大学出版社",
            "time": [
			"2020.4.26"
		]
	},
        {
            "text": "是什么性别都没关系了。\n不想被性别定义。",
            "by": "lz差不多是条咸鱼了",
            "time": [
			"2020.5.3", "2020.5.3"
		]
	},
        {
            "text": "比起蓝天，我更想要你在我身边。\n就算世界就此不再放晴也无所谓。",
            "by": "新海 诚",
            "from": "《天气之子》",
            "time": [
			"2020.5.5"
		]
	},
        {
            "text": "我的小小内脏，没法背负拯救你的重大任务啦。",
            "by": "住野 夜",
            "from": "《我想吃掉你的胰脏》 第一章",
            "time": [
			"2020.5.8"
		]
	},
        {
            "text": "面对死亡的好处只有一个，那就是每天都真实地感觉自己活着了。",
            "by": "住野 夜",
            "from": "《我想吃掉你的胰脏》 第三章",
            "time": [
			"2020.5.8"
		]
	},
        {
            "text": "啊——，要是大家都马上就要死了该多好。",
            "by": "住野 夜",
            "from": "《我想吃掉你的胰脏》 第三章",
            "time": [
			"2020.5.8"
		]
	},
        {
            "text": "我并没有讨厌的人，所以人人都喜欢。",
            "by": "住野 夜",
            "from": "《我想吃掉你的胰脏》 第三章",
            "time": [
			"2020.5.8"
		]
	},
        {
            "text": "既然活着就该谈恋爱。",
            "by": "住野 夜",
            "from": "《我想吃掉你的胰脏》 第三章",
            "time": [
			"2020.5.8"
		]
	},
        {
            "text": "不管发生什么事，人和人之间一定可以和睦相处的，就像你和我一样。",
            "by": "住野 夜",
            "from": "《我想吃掉你的胰脏》 第八章",
            "time": [
			"2020.5.12"
		]
	}
],
    netease: [
        {
            "text": "人在无端微笑时，不是百无聊赖，就是痛苦难当。"
  }, {
            "text": "过去的事情可以不忘记，但一定要放下"
  }, {
            "text": "世味年来薄似纱，\n谁令骑马客京华。\n小楼一夜听春雨，\n深巷明朝卖杏花。\n矮纸斜行闲作草，\n晴窗细乳戏分茶。\n素衣莫起风尘叹，\n犹及清明可到家。\n——《临安春雨初霁》"
  }, {
            "text": "夜晚，一个人在路上走着。正因为周围没人，才更能思考一下自己。"
  }, {
            "text": "芦花深处泊孤舟，笛在月明楼。"
  }, {
            "text": "“你和萤火虫有两个共同点，在我的眼里都会发光，\n同时，都已经很多年没见了。”"
  }, {
            "text": "盛夏的晴夜，我躺在操场。数完最後一片星空，缓缓地闭上眼。\n风温柔地摩挲我的脸颊，我想起了你的笑容。\n突然闻到熟悉的香味，猛然睁开眼，你在我眼前，容光昳丽。"
  }, {
            "text": "(转)不是蝙蝠侠赢了，而是小丑不想玩了"
  }, {
            "text": "有人说，林深时见鹿，海蓝时见鲸，梦醒时见你。\n可我，树深时雾起，海深时浪涌，梦醒时夜续，\n不见鹿，不见鲸，也不见你."
  }, {
            "text": "有时候人就是这样 遇到再大的事自己扛忍忍就过去了 听到身旁的人一句安慰就瞬间完败 \n后来才明白 \n怕的不是冷漠怕的是突然的温柔 怕的不是自己吃苦怕的是身边的人为你难过 怕的不是孤独怕的是辜负”"
  }, {
            "text": "我知道 \n我写的情书你从来不看 总能在垃圾桶看见我的爱 \n我为你写的歌你从来不会听 总能看见你礼貌的说谢谢 却连文件都没接收 \n反正你不爱我，这些都是理所当然。"
  }, {
            "text": "只希望长路漫漫 我们都别回头 别再见"
  }, {
            "text": "他满身都是黑暗 却想给别人带来一丝阳光"
  }, {
            "text": "我伪装成骗子，人们就说我是个骗子。\n我充阔，人人以为我是阔佬。\n我故作冷淡，人人说我是个无情的家伙。\n然而，当我真的痛苦万分，不由得呻吟时，人人却认为我在无病呻吟。 \n————太宰治《斜阳》"
  }, {
            "text": "“你这个人，从一开始就太理性。\n你把自己层层包裹起来拒人于千里之外，哪怕付出也是适可而止。\n为了避免所有的结束，你避免了所有的开始，\n但是我还是希望有个人。”\n --“什么？” \n“有个人可以看穿你怕受伤的心，坚定地站在你身边。\n你知道，听歌时发现没谁可想，空空落落的，也不是件好事。”"
  }, {
            "text": "青涩烟雨， 纠缠生梦里。 \n如你， 江南冬雪已褪去的春色。 \n红胭脂， 淡抹绯红印记。 \n轻柔， 把一江寒水柔进风里。"
  }, {
            "text": "如果有来生 怎么过都随便吧 我只在乎这一生"
  }, {
            "text": "我住长江头，君住长江尾。日日思君不见君，共饮长江水。\n此水几时休，此恨何时已。只愿君心似我心，定不负相思意。"
  }, {
            "text": "我爱你啊，但是你已经有了喜欢的人。我还能怎么办呢。在理智残存的情况下，我知道我不能破坏你们，我只能向自己发泄，我只能恨我自己。只是你，你一定要好好过着幸幸福福的生活呀～"
  }, {
            "text": "我不会全扔旧东西， 因为我总是会觉得这些事物会给未来的我带来来自回忆的慰籍。 \n我也知道那些被我珍重的旧东西终究还是会被我放在心的角落，然后蒙尘，然后遗忘。 \n但我依然放不下。\n 我知道那些来自情感的寄托会将我越缠越紧，寸步难移。 \n可至少，我还能记得那些事物，那些曾经让我所珍视的事物。"
  }, {
            "text": "“天空总是悲伤的颜色，即使如此，云仍然美得如同幻觉。”"
  }, {
            "text": "“世界是美好的”“真的吗？”“真的” \n可我们都知道，这只是大人欺骗小孩子的话。"
  }, {
            "text": "我只有100块了 可是还是会花30块打车来见你 60块买两张电影票 8块钱给你买一杯奶茶 之后掏掏口袋两个硬币 ​​​​ 自己坐公交车去附近的银行 取100万自己花"
  }, {
            "text": "有的人十几岁就死了，直到七十岁才埋"
  }, {
            "text": "黑夜给了我黑色的双眼，我却用它寻找光明。"
  }, {
            "text": "黑夜给了黑夜的人一耳光"
  }, {
            "text": "我亲手将你埋葬，\n又在深夜为你吟诗，\n睡去的你再看不见黑夜的美好，\n星辰编制的翅翼消散，\n容我在这无息的黑夜中向你祝安。\n也容那黎明的曙光烧却我最后的思念。"
  }, {
            "text": "我问你个问题，你说为什么那些小孩，进了游乐场之后，就算他们摔倒了，他们也不会哭。\n因为他们来不及哭，他们要马上站起来，接着去玩，对吧？如果你，可以把你的人生当做是这个游乐场，那你以后，就算跌倒了，都不会哭。"
  }, {
            "text": "一年琴，三年箫，一把二胡拉断腰。\n千年琵琶万年筝，一把二胡拉一生。"
  }, {
            "text": "二胡只有两根弦 \n彼此是彼此的彼此..."
  }, {
            "text": "如果有来生~"
  }, {
            "text": "我喜欢的她不喜欢 她喜欢的我不喜欢 可我可以喜欢她 她却不能喜欢我"
  }, {
            "text": "以前觉得，如果悲伤，哭出来就好了。如今却满满的明白，原来，有些悲伤，可以连眼泪都流不出来，甚至连眼眶都无法再一次湿润。"
  }, {
            "text": "朋友十二画， 恋人十二画，爱人十二画， 家人十二画，所以， 十二的名字叫难忘， 我给你的备注是十一，因为朋友差一点，恋人差一点，爱人差一点，家人差一点，而我也成为了你的十三，所以，十一的名字叫遗憾，十三的名字叫多余。"
  }, {
            "text": "我害怕到最后，仅存的一丝善意都被自己的意志力毁灭殆尽。"
  }, {
            "text": "我本可以忍受黑暗，如果我不曾看见太阳"
  }, {
            "text": "我听过一个笑话。 说一个男人去看医生，说他很沮丧，人生看起来很 无情、很残酷，说他在这个充满威胁的世界上觉得 很孤独。 医生说疗法很简单，“伟大的小丑帕格里亚齐来 了，去看他的表演吧。他能让你振作起来的。” 那男人突然大哭，“但是医生”，他说，“我就是帕 格里亚齐”。"
  }, {
            "text": "他们都欢笑着离开了，他们从我这里得到了想要的，聚光灯下却自始至终只有我一个人，我只能从镜子里看到另一个令人振作的笑容。我可能是个自私的人，我不愿一生只为别人活着，尽管那个理由冠冕堂皇。"
  }, {
            "text": "林深鹿不见，海蓝偶见鲸。 \n人生不重来，何苦寻忧愁。 \n红尘劫难度，情缘自纷扰。 \n浮世不留痕，独守轻衣归。"
  }, {
            "text": "看清自己的弱点，找到你不安的情绪的来源，原来啊，还是想的多，看书少"
  }, {
            "text": "其实有些人，你已经见过这辈子最后一面了 只是你没有发觉,"
  }, {
            "text": "“他不过随手给了朵花，你却红了脸想用余生做代价”"
  }, {
            "text": "我是田野间唯一的树，看着一个孩子赤着脚，无忧无虑的在我面前飞奔。正午的太阳穿透了我的树叶，刺进了他的眼，那孩子叼着看起来就不贵的冰棍，在我树荫底下寻找着什么，他用耳朵凑近我的枝干。我这才发觉，那个蝉邻居早已不在了啊。"
  }, {
            "text": "少年听雨歌楼上。红烛昏罗帐。壮年听雨客舟中。江阔云低、断雁叫西风。 而今听雨僧庐下。鬓已星星也。悲欢离合总无情。一任阶前、点滴到天明。"
  }, {
            "text": "对我来说，有比心脏更重要的器官，它虽然看不见，但我能感觉到它贯穿于我的脑袋和双腿之间，的的确确的存在于我的身体里，因为有它的存在 我才能挺直腰杆的站在这里，就算摇摇晃晃也能笔直向前走，在这里止步的话 它也会蒙受屈辱的，灵魂会受辱的，对我来说比起心脏停止那东西更重要"
  }, {
            "text": "山间行，红烛晕，千路千灯引 \n坛上舞，足铃磬，一步一声惊"
  }, {
            "text": "错过了长安古意，失约了洛阳花期，我在姑苏马蹄莲里，瞥见你兰舟涉水而去"
  }, {
            "text": "“路漫漫其修远兮,吾将上下而求索”"
  }, {
            "text": "如梦如生，似梦非梦，真亦假时假亦真，玲玲清风吹拂了衣角，带飞了执子之心"
  }, {
            "text": "你知道什么时候最难熬吗？从学校过度到社会的时候 看到喜欢的人和异性甜蜜的时候 身边没人相信你的时候 一个人难过需要亲朋好友陪伴却不在身边的时候 看到家人朋友有困难自己无能为力的时候 迫不得已对最重要的人撒谎的时候 当你累的时候 大概当你把这些事都熬过去的时候 你就会变成另一个人"
  }, {
            "text": "我们重新开始认识吧，在明月的注视下，昏黄的灯光也睡着了。我要从你的右耳开始认识，仔细摩挲耳廓三粒小小的痣，或许能从中探索出繁星排列的规律。再者是一眉一目，探究着眉毛生长的方向，指腹一点点覆盖，直到划至末梢，繁星散落的眼尾，看那如潭明眸被睫毛抖落的星辰点亮，似近而实远。"
  }, {
            "text": "为什么看到星星会有幸福感？ 也许是因为每颗星星都是属于每个人不同的归属。"
  }, {
            "text": "笑那浮华落尽月色如洗，笑那悄然而逝飞花万盏"
  }, {
            "text": "不成天地主宰，便化宇宙尘埃!"
  }, {
            "text": "白日何短短， 百年苦易满。 苍穹浩茫茫， 万劫太极长。"
  }, {
            "text": "我本可以忍受黑暗，如果我不曾见过太阳"
  }, {
            "text": "长夜漫漫，何时能待吾归。 繁星点点，怎又指引迷茫。 寒风飘飘，送谁坠断崖边。 此后若是长夜散去， 黎明破晓。 繁星闪烁， 汇聚散落。 吾定乘风起， 抚肩上尘， 便再也没牵肠挂肚， 日夜思念。"
  }, {
            "text": "不要在我的墓碑前哭泣， 我不在那里，我没有长眠。 我是凛冽的寒风， 掠过诺森德的雪原。 我是温柔的春雨， 滋润着西部荒野的麦田。 我是清幽的黎明， 弥漫在荆棘谷的林间。 我是雄浑的鼓声， 飞越纳格兰的云端。 我是温暖的群星， 点缀达纳苏斯的夜晚。 我是高歌的飞鸟， 留存于美好的人间"
  }, {
            "text": "据说，同时拥有极致的抑郁和绝对的理性，就是神"
  }, {
            "text": "人们相互蔑视，又相互奉承，人们各自希望自己高于别人，又各自匍匐在别人面前。\n——《沉思录》"
  }, {
            "text": "在中国，任何超脱飞扬的思想都会砰然坠地——现实的引力实在是太沉重了。 \n——刘慈欣《三体》"
  }, {
            "text": "飞舞回旋 是夜的篇章"
  }, {
            "text": "别人都是装难过 因为有人疼 而我是真难过 可我没发说 我怕被人说矫情"
  }, {
            "text": "星河滚烫，你是人间理想。"
  }, {
            "text": "一个人习惯久了，别人的陪伴竟觉得麻烦。"
  }, {
            "text": "晚安，黑夜。"
  }, {
            "text": "世界不过一场白日梦 可我愿温柔伴你 自始而终"
  }, {
            "text": "“一块准备跳楼的玻璃你猜他会说什么” “什么呢” “晚安，我碎咯”"
  }, {
            "text": "可惜你 不说实话 不经诱惑 不懂珍惜 不值一提"
  }, {
            "text": "男生被女生夸“你真可爱”，应当懂得这是对方在发好人卡，或是觉得自己太娘；女生被男夸“你真可爱”，应当明白这是对方起了色心，或是觉得自己太蠢；女生被女生夸“你真可爱”，应当条件反射立即回夸对方，不然就混不下去了；而男生被男生夸“你真可爱”，应当二话不说拔腿就跑，否则会有生命危险。。"
  }, {
            "text": "开头在吃薯片么 写黑板么 转发条娃娃么 你画的什么 为什么撕掉了"
  }, {
            "text": "我心里有阴暗面 而我不能说。我在意的有很多 而我不能说。 我很难过很难过 而我不能说。"
  }, {
            "text": "后来，我坐着防弹车去贫民窟，独自住在亚马孙雨林深处的木屋里，在一场盛大的狂欢节里痛哭，在牙买加混着酒精和荷尔蒙的雷鬼乐里对自己说生日快乐。那些美妙的时刻，如同里约热内卢升腾而起的烟火一样，照亮了我的二十几岁……可我的十九岁是死在旋转公寓里的"
  }, {
            "text": "东野圭吾比喻明知不可能的爱：就像故意去按发炎的智齿，从疼痛中获得莫名的快感。"
  }, {
            "text": "我从不要求什么，你也不用向我解释什么。"
  }, {
            "text": "从隐生宙太古代到元古代震旦纪四十亿年，再从显生宙古生代的寒武纪到二叠纪三亿年，中生代的三叠纪到白垩纪一亿年，新生代的第三纪到第四纪六千七百万年，直至最后的两百五十万年才出现人类。"
  }, {
            "text": "有人说 林深时见鹿 海蓝时见鲸 梦醒时见你 可实际 林深时雾起 海蓝时浪涌 梦醒时夜续。 不见鹿，不见鲸，也不见你。 但终究 鹿踏雾而来，鲸随浪而涌 你没回头又怎知我不在 可我看来 鹿见人而惊 消失于林深 鲸踏浪而上 搁浅于浅滩 亦如我见你 如碌如惊 终究 鹿惧人前 潮退鲸落 雾气藏你心 不见你 不见我"
  }, {
            "text": "人太理智 岂不无聊？"
  }, {
            "text": "养了13年的乌龟从不在我房间过夜，它喜欢潮湿黑暗的角落。但这几天它一直呆在我房间，我上床睡觉它便爬过来紧挨床沿。夜里它来回走动像极人走路，我起身把它抱出去，清晨醒来见它又爬回来。我开玩笑低头说：你找我有事啊？今天它安静的死去了，我难过是因为它一直在和我说，再见了。"
  }, {
            "text": "大学是一个人的大学，烦心事很多，可能倾诉的人却很少，六个人的宿舍，每个人追求着自己的利益"
  }, {
            "text": "真心怀念高中了。每天穿着校服到处乱蹭。男生上课用手机看文字直播的NBA。下课走廊里闹哄哄的。厕所也要排队。最恨老师抱着卷子进班。有总是第一的书呆子也有隐藏在最后一排的神吐槽的大神。我也怀念那时候的我。因为一切都看起来那么有希望。好像只要努力，什么都能改变。"
  }, {
            "text": "“万物皆有裂痕，那是光照进来的地方。”（莱昂纳德·科恩 《颂歌》）"
  }, {
            "text": "多久努力都不晚，多少努力都不多。"
  }, {
            "text": "一人问，什么叫悲哀？ 另一个：从楼顶摔下来了。 \n什么叫幸运？ 下面有个草堆。 \n那什么叫倒霉？ 草堆上有个叉子。 \n…...那，什么又叫希望呢 你没掉叉子上， \n那什么叫绝望呢 你也没掉草堆上 …………"
  }, {
            "text": "如果天空是黑暗的，那就摸黑生存。如果发出声音是危险的，那就保持沉默。如果自觉无力发光，那就蜷伏于墙角。但不要习惯了黑暗就为黑暗辩护，不要为自己的苟且而得意，不要嘲讽那些比自己更勇敢热情的人。我们可以卑微如尘土，不可扭曲如蛆虫。"
  }, {
            "text": "喜欢你也只是他的一时兴起啦 你真笨 还期待着以后呢"
  }, {
            "text": "我不知道凌晨五点该说早安还是晚安 更不知道这个年龄该说爱还喜欢."
  }, {
            "text": "而你我却相隔百万光年"
  }, {
            "text": "月色雪色之间，你是第三种绝色 \n日月星辉之中，你是第四种难得"
  }, {
            "text": "古人认为“三光者，日月星”，这是地球上的三种光源。 “你是第四种难得”意为，你的出现，于我而言，是人生中的一束光。"
  }, {
            "text": "我只要你一个完整的朝夕。"
  }, {
            "text": "你看这日月星辉 山川海河 全都不如你"
  }, {
            "text": "若逢新雪初霁 \n满月当空 \n下面平铺着皓影 \n上面流转着亮银 \n而你带笑地向我步来 \n月色与雪色之间 \n你是第三种绝色"
  }, {
            "text": "“你可以选择停留在痛苦中，也可以由此脱胎换骨，重新做人。” \n“人的灵魂里都有一团火，却没有人去那儿取暖，路过的人只能看到烟囱上的淡淡薄烟，然后继续赶他们的路。” \n“只要活着的人还活着，死去的人就不会死去。”"
  }, {
            "text": "初中的时候，班里有个很漂亮的女生，属于班花的那种，有次下课我往她脸上亲一口就跑，其实我一点也不喜欢她，她男朋友是学校外面的那种小混混，我就喜欢那种被追着打一星期的感觉，死亡如风，常伴吾身。"
  }, {
            "text": "当你觉得孤独无助时，想一想还有几十万亿的细胞只为了你一个人而活。"
  }, {
            "text": "第一次來人間，和地獄沒兩樣"
  }, {
            "text": "“生不对 死不起”"
  }, {
            "text": "我希望你历经山河，也觉得人间值得"
  }, {
            "text": "如今的我，谈不上幸福，也谈不上不幸。 一切都会过去的。 在所谓“人世间”摸爬打滚至今，我唯一愿意视为真理的，就只有这一句话。 一切都会过去的。 "
  }, {
            "text": "为什么别人的脸上都有笑容啊？"
  }, {
            "text": "多希望有一天突然惊醒，发现自己在高三的一节课上睡着了，现在经历的一切都是一场梦，同桌叫醒你说老师来了。你告诉同桌，说做了个好长的梦。你看着窗外的球场，一切都那么熟悉，一切还充满希望..."
  }, {
            "text": "在银河系猎户旋臂的漫漫长夜中，有两颗文明的流星划过，宇宙记住了他们的光芒。"
  }, {
            "text": "那是希望的微光，救赎的微光，信仰的微光。当士官长挣扎着从沉沦在黑暗宇宙中的战舰残骸爬出时，他相信，自已永远不会忘记眼前的这一抹微光——自所有恒星熄灭起两百年，人类第一次看见的，来自人造天体外的光芒。"
  }, {
            "text": "我会找到你的。"
  }, {
            "text": "““你是怎么把生活弄的一团糟的？” “正常发挥” “那接下来怎么过？” “熬”“"
  }, {
            "text": "“你们的孩子居然不害怕黑暗？”“因为他们知道明天的太阳还会照常升起。“"
  }, {
            "text": "“极致疯狂是一瞬的 长久的话就是死亡“"
  }, {
            "text": "一个人往往要死两次： 不再爱 不再被爱 ——伏尔泰"
  }, {
            "text": "“亲手把你推开的人 或许更渴望让你留下来。”"
  }, {
            "text": "“月遇从云 花遇和风 今晚上的夜空很美 我又想你” ——太宰治"
  }, {
            "text": "“亲手把你推开的人 或许更渴望让你留下来。”"
  }, {
            "text": "“付出一定會有回報的，你看，你付出了真心，這不收到了傷害嘛。”"
  }, {
            "text": "“不要把你的负情绪带给别人好吗？” “没有啦，我仅剩的一点东西怎么舍得给别人。”"
  }, {
            "text": "每个人都有一个死角， 自己走不出来， 别人也闯不进去。 我把最深沉的秘密放在那里。 你不懂我，我不怪你。 每个人都有一道伤口， 或深或浅，盖上布，以为不存在。 我把最殷红的鲜血涂在那里。 从阴雨走到艳阳，我路过泥泞、路过风。 一路走来，你若懂我，该有多好。"
  }, {
            "text": "一个战友迟到了，长官很生气：“你怎么迟到了！”战友回答：“报告长官！我睡过头了。”长官问：“如果世界上每一个士兵都像你这样睡过头怎么办？！”战友继续淡定的回答：“报告长官！那这个世界就不会有战争！”"
  }, {
            "text": "在星空中，我找到了你的影子...... 星空真的很美，你说的没错 它像你一样美 可惜它还在，可你却走了"
  }, {
            "text": "我于夜空中照见流星，宛如翩跹在天穹上的童话精灵，她涉过人世间的光阴荏苒，终究回归了你的梦境"
  }, {
            "text": "“当代年轻人的现状： 洗澡放歌 睡觉戴耳机 起床找手机 喜欢侧身睡 乘坐汽车靠窗 喜欢一个人在家 白天朋友面前嘻嘻哈哈 晚上却喜欢自己一个人胡思乱想。” "
  }, {
            "text": "“请成为永远疯狂永远浪漫永远清澈的存在.”"
  }, {
            "text": "“北野，你最想要的是什么？” “我喜欢一个人，想给她一个好的结局。” 仅此而已。"
  }, {
            "text": "天空迷上了山野 有雾有灯 也有归人."
  }, {
            "text": "若能避开猛烈的欢喜，自然也不会有悲痛的来袭 ——《人间失格》"
  }, {
            "text": "“人生本來就孤獨，卻渴望擁抱相似的靈魂”"
  }, {
            "text": "“我是造物者难辞其咎的败笔.”"
  }, {
            "text": "沉默是一种让人感到无法呼吸的绝望"
  }, {
            "text": " 有一天“我”字丢了一撇，成了“找”字，为找回那一撇，“我”问了很多人，那一撇是什么?现在我终于明白了, 那一撇原本是个”一” ，这段话的意思应该是这样的:” 一” 旦丢了，你就再也”找”不到“我”了。"
  }, {
            "text": "“奶奶，我谈恋爱了” “那太好了，哪天叫来家里吃饭吧”​ “可是，她也是女孩子”​ “女孩子也是要吃饭的啊” “喂，妈，我今天带对象回来了。” “好，那我去买菜。” “可…他也是男孩子…” “…” “那我多买点，男孩子饭量大。”"
  }, {
            "text": "我去往无尽的深渊，只为寻找迷失的自己。"
  }, {
            "text": "如果一个人在家，千万不要在下午时睡午觉，一觉睡到六七点等你一睁开眼，看着朦胧黑黑的天空，看着空荡的房间，会有一种被全世界遗弃的感觉，孤独在那一刻体现的淋漓尽致。"
  }, {
            "text": "放心，睡吧，把这个世界忘了吧。"
  }, {
            "text": "这个世界是美丽的， 就算充满了悲伤和泪水， 也请你睁开双眼， 去做你想做的事，成为你想成为的人， 去爱你想爱的人，找你想要的朋友。 不必焦躁，不必迷惘， 请慢慢地长大， 无论发生什么事情，请不要后悔与这个世界相遇。"
  }, {
            "text": "半城烟沙，血泪落下，残戟裂甲，铺红天涯，转世燕还故榻，为你衔来二月的花 ——许嵩《半城烟沙》"
  }, {
            "text": "岐凤鸣，八百年，春风吹。过春秋，风雨雷尽七国战。\n 昔争鼓，戮中原，长门都上西潼关。赢王侯，八荒看破埋骨砖。\n 扫南国，合六天。跨九州，卧龙潭。 \n君王坐，塞上边将白骨添。\n望平原，多悲欢，千古恨。\n 泪流满，送行客。晚钟惊断长天。"
  }, {
            "text": "斑驳疏影醉马墙，摇叶婆娑诉过往"
  }, {
            "text": "重楼徽院，云竹秀，花千树。\n棹水送兰舟，踏露依花路。\n长槛清闲在，蛙鼓烟荷处。\n木栏桥，青石庑。\n乱花香里，云雀山前渡。 \n丝弦雨巷，街渐静，人闲步。\n落日展余晖，碧柳迎飞羽。\n斗艳花留醉，兴尽云归去。\n阑珊夜，弯月妩。\n游人依旧，灯影知无数。"
  }, {
            "text": "环游遍了整个星系，找不到比你更亮的星星"
  }, {
            "text": "“世界很暗 然后你来了 带着星星和月亮。” ​​​"
  }, {
            "text": "“我说喜欢你，不是要得到你的回馈”\n “只是希望你在绝望的时候能够想到我” \n“会觉得自己没那么糟，至少还有人喜欢”\n ——《你是这世界上写给我的情书》"
  }, {
            "text": "“他用氰化物的烟雾使自己从记忆的长河中解脱。”\n-------《霍乱时期的爱情》"
  }, {
            "text": "青春的奢侈，便在于能够有足够清澈的心情，用七百多个夜晚去写一封言不由衷的信，给一个并不属于将来的人。"
  }, {
            "text": "曾经做过一个梦，跌落到一片海域中。海域似乎很大。海域似乎很小。 大到不知时间天地，小到跌落的瞬间能看见所有的涟漪。 在这片海域之中，不断回忆起梦中的过往。梦中的梦中梦，梦中的遗憾，梦中的爱恋。 情感恍惚如潮水涌来，灌入耳鼻口中。 层层叠叠，无法呼吸。"
  }, {
            "text": "如果一直想见谁 迟早肯定见得到"
  }, {
            "text": "同学哭的很伤心，大家都去逗她笑，笑的很开心地对我说:你懂那种又想哭又想笑吗？ 我沉默。其实我根本不懂，因为没有人在我哭时在乎我"
  }, {
            "text": "记得那集汤姆为了抓杰瑞把自己弄死了 上了天堂 那个人说要得到杰瑞的原谅才能去天堂 否则只能下地狱 虽然杰瑞之前不肯签字原谅 可是到最后还是不忍自己的老友下地狱签字了 后来汤姆醒了 发现是一场梦 哦对啊还好是一场梦 不然以后都见不到你了"
  }, {
            "text": "我在去杀你的路上买了你最爱的葱油饼"
  }, {
            "text": "我挺想你的，但看在面子的份上就不找你了"
  }, {
            "text": "只要十美元就可以买到一颗星星的命名权，还有一张像模像样NASA的证书。中文的外文的平庸的奇特的，只要花钱的人愿意，给哪颗倒霉的星星取名叫 二狗子都行。可是花再多的钱，我都没有办法在你的名字前面，加上“我的”两个字。原来对我来说，你比星星更遥不可及。"
  }, {
            "text": "这世界原本轻描淡写所谓悲喜，错过，遗憾，失落都是恰好的正确何必只盼望一片妖娆"
  }, {
            "text": "“你怕蛇，却没被蛇咬过 你喜欢一个人，却被这个人伤过 这对蛇不公平”"
  }, {
            "text": "来世做冬风，冷冽又清狂。"
  }, {
            "text": "“是啊，我也喜欢温柔，温暖，以及寻找着相互吸引的东西，努力活下去的心，很喜欢。” ——夏目贵志《夏目友人帐》"
  }, {
            "text": "“how are you”  ̶“s̶a̶d̶,̶ ̶b̶r̶o̶k̶e̶n̶,̶ ̶d̶e̶f̶e̶a̶t̶e̶d̶,̶ ̶c̶r̶u̶s̶h̶e̶d̶,̶ ̶l̶o̶n̶e̶l̶y̶,̶ ̶f̶a̶l̶l̶i̶n̶g̶ ̶a̶p̶a̶r̶t̶ i'm fine. ”"
  }, {
            "text": "都怪我 偏偏要爱 偏偏要等待 偏偏幻想我是例外 不知好歹"
  }, {
            "text": "困难的日子真的挺困难的 心烦起来也是真的心烦"
  }, {
            "text": "“我在和時間賽跑 看誰先離開你”"
  }, {
            "text": "“少和生命無關的人和事耗著”"
  }, {
            "text": "六月经半，下了场小雨。 沁人心脾，又行色匆匆。 想起《星星上的人》里面的那句：“人生值得欣慰之处便是，每一天都有结束的时候。今天也不例外。” 今天的雨，来日也就归于尘土，润养山河。 而我却像是在奔赴一场没有尽头的自我救赎。"
  }, {
            "text": "阶前雨是无根雨，心上人是无望人。 天上雨是人间雨，天涯人是所念人。 ​​​"
  }, {
            "text": "我喜欢雨，因为它带来天空的味道 ——《言叶之庭》"
  }, {
            "text": "淅沥中，犹闻细雨倾诉 朦胧间，又见清澈双眸 伸手间，泪在雨中流 人不在，晨看花落知雨骤。 ——余光中 《等你，在雨中》"
  }, {
            "text": "已经不记得我们分别时那天有没有下雨 大抵好像有的 你转身时 我看着你的背影渐渐走远 后来我的视线模糊一片 应该不是我哭了 而是那天雨太大了"
  }, {
            "text": "雨会停 天会晴 没有什么会永远糟糕透顶 渐渐的喜欢上了现在的生活 没有惊喜也没有意外."
  }, {
            "text": "少年听雨歌楼上。红烛昏罗帐。壮年听雨客舟中。江阔云低、断雁叫西风。而今听雨僧庐下。鬓已星星也。悲欢离合总无情。一任阶前、点滴到天明。 一一虞美人·听雨 宋 · 蒋捷"
  }, {
            "text": "你落在湖面晕出一圈圈涟漪，落于土壤唤醒了久睡的种子，万物皆因你而生长。 我是行走于荒漠的旅人， 有幸遇见你， 滋润我心中的梦想，让它发芽，肆意生长。 我从不让伞面隔绝我们的联系，我珍惜每一次的亲密无间。"
  }, {
            "text": "把喜欢的东西分享给不懂的人 是一种自取其辱式的孤独。"
  }, {
            "text": "寂静中， 想把繁星摘下当灯笼， 想把银河拽走当围巾。 想把小船翻转， 把黑夜转成白天， 把月亮变成太阳。 等看淡了世间， 再把白天睡成黑夜， 把太阳睡成月亮。"
  }
],
    april: [
        {
            "text": "或许前路永夜，即便如此我也要前进，因为星光即使微弱也会为我照亮前路",
            "from": "《四月是你的谎言》",
            "by": "宫园薰",
            "time": ["2019.8.27"]
},
        {
            "text": "你的所言所行，全都闪烁着光芒，太过刺目，于是我闭上双眼，但内心还是无法停止对你的憧憬",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "莫扎特曾经说过大胆地踏上旅途吧，我不知道路途的前方究竟有什么，但是，我们还是迈出了步伐，我们仍在旅途之中",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "你驻足于春色中，于那独一无二的春色之中",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "每当心情郁闷的时候，用手托腮就好，手臂会因为帮上忙而开心的",
            "from": "《四月是你的谎言》",
            "by": "查理·布朗",
            "time": ["2019.8.27"]
},
        {
            "text": "和他相遇的瞬间，我的人生就改变了。所见所闻所感，目之所及全都开始变得多姿多彩起来，全世界，都开始发光发亮！",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "干燥的空气，尘埃的味道，我在其中…踏上旅途",
            "from": "《四月是你的谎言》",
            "by": "宫园薰",
            "time": ["2019.8.27"]
},
        {
            "text": "看吧，星星只有在夜里才璀璨夺目啊。",
            "from": "《四月是你的谎言》",
            "by": "阿渡",
            "time": ["2019.8.27"]
},
        {
            "text": "在美丽的谎言中，一个走出了深渊，一个走向了天堂",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "苦恼着，歇斯底里着，痛苦着，不断挣扎的数月时间，这一切会在未来的某一瞬间得到回报。我们或许就是被那个瞬间迷住的，一种无可救药的生物吧",
            "from": "《四月是你的谎言》",
            "by": "濑户紘子",
            "time": ["2019.8.27"]
},
        {
            "text": "喜欢的人喜欢别人不是很正常吗",
            "from": "《四月是你的谎言》",
            "time": ["2019.8.27"]
},
        {
            "text": "春天的最后一场雪，你我的最后一次相聚，能遇见你是最幸福的事了，就此分别吧！请继续向前，迎接樱花漫溢的四月，但请不要忘记我，友人A……",
            "from": "《四月是你的谎言》",
            "by": "宫园薰",
            "time": ["2019.8.27"]
},
        {
            "text": "你这样，在不在都一样啊,在和不在都一个样的话，那就永远在一起吧，一直留在你身边",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "别迷惘，别烦恼，加速吧，只要行动就好，别停下，迷惘什么的一点都不像你，像那样纵身轻跃，拾级而上，就像那一天一样，让我再次追逐你的身影，我的英雄",
            "from": "《四月是你的谎言》",
            "by": "相座凪",
            "time": ["2019.8.27"]
},
        {
            "text": "星星在你的头顶上闪耀着，与你交互诉说的话语，一句一句地，如同星点般翩然落至眼前",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "仿佛要消失般的羸弱，但是，仍旧拼命绽放着光芒。怦怦，怦怦，如同心跳一般，这就是生命之灯",
            "from": "《四月是你的谎言》",
            "by": "宫园薰",
            "time": ["2019.8.27"]
},
        {
            "text": "四月是你的谎言，我知道...是谎言就一定会有被揭穿的时候。",
            "from": "《四月是你的谎言》",
            "by": "宫园熏",
            "time": ["2019.8.27"]
},
        {
            "text": "我能想起来的一直都是你的背影",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "人啊，总是盲目地去爱啊……",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "正因为有了音乐，才有了相遇的瞬间，有了相会的感动，有了相逢的人们，有了邂逅的思念。",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "或许前方只有...伸手不见五指的夜路，即使如此，我还是要充满信心、继续向前，相信星星的光芒...多少会照亮前方的道路，走吧！我们踏上旅程吧！",
            "from": "《四月是你的谎言》",
            "by": "宫园熏",
            "time": ["2019.8.27"]
},
        {
            "text": "是你的错，这一切全都是你的错。我像这样苟延残喘地挣扎着，执着于活下去也好，全都是你的错，是你让我对和你共同度过的时间产生了留恋",
            "from": "《四月是你的谎言》",
            "by": "宫园熏",
            "time": ["2019.8.27"]
},
        {
            "text": "Eloim Essaim Eloim Essaim 请聆听我的请求",
            "from": "《四月是你的谎言》",
            "by": "宫园薰",
            "time": ["2019.8.27"]
},
        {
            "text": "为我拭去那层灰尘的人，可是你喔。我看起来很痛苦吗，真是伤脑筋呐。痛苦是当然的，因为我航行在没有海图的海面上啊。挑战和创造都是很痛苦的啊，但是很充实，所以，谢谢你",
            "from": "《四月是你的谎言》",
            "by": "阿渡",
            "time": ["2019.8.27"]
},
        {
            "text": "有粉笔的气味，各处布满参差裂痕的玻璃窗，远处传来的运动部的声音，夕阳投出的片片樱瓣倩影，静谧安逸的睡息，风景开始变迁",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "我并不能一直在你身边帮助你",
            "from": "《四月是你的谎言》",
            "by": "查理·布朗",
            "time": ["2019.8.27"]
},
        {
            "text": "能互相支撑的不仅仅是同伴，向敌人学习更多，从敌人那里获得更多，直到再次重逢那日为止…仅是那个人的存在，就足以使自己忍受孤独。竞技者之间，是连敌人都能互相支撑的",
            "from": "《四月是你的谎言》",
            "time": ["2019.8.27"]
},
        {
            "text": "飞机穿梭于茫茫星海中逐渐远去，你如猫般，无声靠近，从意想不到的角度玩弄他人，而我只能呆愣在原地，永远只能跟随你的步伐",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "就好像看透了我的心思一般，你总是突然出现……",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "肌肤冰凉，寂静而干燥的空气，洗过的床单让气氛变得格外柔和，那个残忍的男子，说要让我再做一次美梦",
            "from": "《四月是你的谎言》",
            "by": "宫园薰",
            "time": ["2019.8.27"]
},
        {
            "text": "但是在喜欢和不讨厌之间，可是相隔了数亿光年都不止的距离啊！",
            "from": "《四月是你的谎言》",
            "by": "泽部椿",
            "time": ["2019.8.27"]
},
        {
            "text": "用心去听的话便能感受得到渐渐涌出的伤感，安逸的睡息萦绕耳畔，宛如小猫一般，我的心中有你停驻，你在那里?",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "从头发中传来音乐室的味道，能听到些许急促的呼吸声，被泪水润湿的肩头很温暖，我就在他的身边。要是时间能就此停住就好了",
            "from": "《四月是你的谎言》",
            "by": "泽部椿",
            "time": ["2019.8.27"]
},
        {
            "text": "你会忘记吗？和你一起在学校探险的女孩子，和你一起帮助迷路的小孩子的女孩子，从医院跑出来，等在那里的女孩子，你会忘记吗？",
            "from": "《四月是你的谎言》",
            "by": "宫园薰",
            "time": ["2019.8.27"]
},
        {
            "text": "英雄意味着强大，英雄意味着孤独，最后一幕一定是英雄渐行渐远，我的英雄也是那样的存在",
            "from": "《四月是你的谎言》",
            "time": ["2019.8.27"]
},
        {
            "text": "你的言行举止，都是那么璀璨夺目，对我而言实在是太耀眼，让我不得不闭上眼睛。不过，我却无可自拔地憧憬着你！",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "和你相遇的春天,没有你的春天",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "车轮的金属音，不规则的足音，舌尖上面残留的淡淡红茶苦涩。平凡而无谓的对话，随处可见的风景。即使如此，却还是记得那么明晰。这一定，一定，是身处夏夜的错",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "就算悲伤难抑，遍体鳞伤地处于谷底，也不能停止演奏！",
            "from": "《四月是你的谎言》",
            "by": "宫园薰",
            "time": ["2019.8.27"]
},
        {
            "text": "和她相遇的那瞬间，我的人生改变了",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "要和我一起殉情吗？骗你的…我就是想说说看",
            "from": "《四月是你的谎言》",
            "by": "宫园薰",
            "time": ["2019.8.27"]
},
        {
            "text": "继续踏上旅途，在没有你的春天",
            "from": "《四月是你的谎言》",
            "time": ["2019.8.27"]
},
        {
            "text": "我很蠢，所以一点也不了解自己，想装作一无所知地一直呆在他身边，想着能一直这样就可以了",
            "from": "《四月是你的谎言》",
            "by": "泽部椿",
            "time": ["2019.8.27"]
},
        {
            "text": "星星只有在夜里才璀璨夺目啊",
            "from": "《四月是你的谎言》",
            "by": "阿渡",
            "time": ["2019.8.27"]
},
        {
            "text": "你就像是小猫一般，一旦我靠近的话就会忽然跑到很远的地方去，受伤了的话，就像能相互理解那份痛苦一样，开始玩闹起来，所以是...那样的惹人怜爱...",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "既然在与不在都一样的话，那就永远在一起吧",
            "from": "《四月是你的谎言》",
            "time": ["2019.8.27"]
},
        {
            "text": "只要一和你说话就一会儿难过，一会儿安心，像这样阴晴不定的我，就像个笨蛋似的",
            "from": "《四月是你的谎言》",
            "by": "泽部椿",
            "time": ["2019.8.27"]
},
        {
            "text": "现在我多少能明白了，一直以来都是如此，将我的世界不断扩大的人是你。我所追求的风景，和你想看到的风景，是不同的",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "春天就要来了，遇见你的春天，再也没有你的春天",
            "from": "《四月是你的谎言》",
            "by": "有马公生",
            "time": ["2019.8.27"]
},
        {
            "text": "为了能永存那些人心中，为了让在座的所有人，永远铭记我们，我不会忘记的",
            "from": "《四月是你的谎言》",
            "by": "宫园薰",
            "time": ["2019.8.27"]
},
        {
            "text": "男人只要去行动就好，做得到或做不到，女孩子会来告诉你的",
            "from": "《四月是你的谎言》",
            "by": "渡亮太",
            "time": ["2019.8.27"]
}
],
}
OneText.extLib = {
    get: function () {
        $.ajax({
            url: 'https://v1.hitokoto.cn/',
            dataType: 'jsonp',
            success: (data) => {
                data = JSON.parse(data);
                result = {};
                result.text = data.hitokoto;
                result.by = data.from_who || data.from;
                result.from = data.from;
                this.next = result;
            }
        });
        return this.next;
    },
}
OneText.extLib.get();
OneText.libs = {
    official: new OneTextLib(OneText.jsons['official']),
    netease: new OneTextLib(OneText.jsons['netease']),
    april: new OneTextLib(OneText.jsons['april']),
    ext: OneText.extLib,
}
OneText.prototype.set = function (first = false) {
    var lib = OneTextLib.randint(this.libs);
    var one = (first) ?
        OneText.libs['official'].get() :
        lib.get();
    this.tag.animate({
        opacity: 0
    }, (first) ? 0 : 500, () => {
        var dash = (this.config.dash) ? '—— ' : '';
        var quote = (this.config.quote) ? '"' : '';
        this.textTag.text(quote + one.text + quote).html(this.textTag.html().replace(/\n/g, '<br>'));
        this.fromTag && this.fromTag.text((one.from) ? (dash + one.from) : '');
        this.byTag && this.byTag.text((one.by) ? (dash + one.by) : '');
        this.timeTag && this.timeTag.text((one.time) ? one.time[one.time.length - 1] : '');
        this.tag.animate({
            opacity: 1
        }, 500);
    });
}
OneText.prototype.setInterval = function (interval) {
    if (interval) {
        this.intervalId && clearInterval(this.intervalId);
        this.intervalId = setInterval(() => {
            this.set();
        }, interval * 1000);
    }
}
var oneTexts = [];
$(document).ready(function () {
    var tags = $('.one-text');
    for (let i = 0; i < tags.length; i++) {
        oneTexts.push(new OneText(tags[i]));
    }
})
