# How to contribute
First of all, thank you for taking the time to contribute to this project. We've tried to make a stable project and try to fix bugs and add new features continuously. You can help us do more.

## Getting started

### Check out the roadmap

We have some functionalities in mind and we have issued them and there is a *milestone* label available on the issue. If there is a bug or a feature that is not listed in the **issues** page or there is no one assigned to the issue, feel free to fix/add it! Although it's better to discuss it in the issue or create a new issue for it so there is no conflicting code.

### Writing some code!

Contributing to a project on Github is pretty straight forward. If this is you're first time, these are the steps you should take.

**1. Fork the repository to your account and make clone of it.**
<img width="1904" alt="Screenshot 2022-10-02 at 11 16 14 PM" src="https://user-images.githubusercontent.com/1752156/193474636-98493ae7-4fd6-4c6c-91b5-b5c4f1aabc36.png">
<img width="1904" alt="Screenshot 2022-10-02 at 11 17 17 PM" src="https://user-images.githubusercontent.com/1752156/193474660-68e19399-07e1-43e4-8bff-7b48c5d6874b.png">
<img width="898" alt="Screenshot 2022-10-02 at 11 19 11 PM" src="https://user-images.githubusercontent.com/1752156/193474673-00e61c05-ec7b-4f55-9010-5479939be515.png">

   - to fork the repository follow this [tutorial.](https://www.freecodecamp.org/news/how-to-fork-a-github-repository/)
   - to clone the repository follow this [tutorial.](https://docs.github.com/en/repositories/creating-and-managing-repositories/cloning-a-repository)
2. add this repository to upstream and run git pull on main branch.
3. create a new branch from main and add your changes to it, commit them with meaningful commit message and open a pull request on this repo.
   - if you don't know all of this, don't worry, follow this [tutorial](https://www.youtube.com/watch?v=c6b6B9oN4Vg) to know all these things.

And that's it! Read the code available and change the part you don't like! You're change should not break the existing code.

If you're adding a new functionality, start from the branch **master**. It would be a better practice to create a new branch and work in there.

When you're done, submit a pull request and for one of the maintainers to check it out. We would let you know if there is any problem or any changes that should be considered.

