﻿using Domain.Models;
using Microsoft.AspNetCore.Mvc;
using Nethereum.Contracts;
using Nethereum.Hex.HexTypes;
using Nethereum.RPC.Eth.DTOs;
using Nethereum.Signer;
using Nethereum.Util;
using Nethereum.Web3;
using Nethereum.Web3.Accounts;
using System.Numerics;
using WebApi.GraphQL;
using WebApi.Utilities;

namespace WebApi.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class UniswapV3Controller : ControllerBase
    {
        private readonly WalletOwner _user = new();

        private readonly string _uniswapV3FactoryAddress = "0x1F98431c8aD98523631AE4a59f267346ea31F984";
        private readonly string _uniswapV3FactoryAbi = @" [{""inputs"":[],""stateMutability"":""nonpayable"",""type"":""constructor""},{""anonymous"":false,""inputs"":[{""indexed"":true,""internalType"":""uint24"",""name"":""fee"",""type"":""uint24""},{""indexed"":true,""internalType"":""int24"",""name"":""tickSpacing"",""type"":""int24""}],""name"":""FeeAmountEnabled"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":true,""internalType"":""address"",""name"":""oldOwner"",""type"":""address""},{""indexed"":true,""internalType"":""address"",""name"":""newOwner"",""type"":""address""}],""name"":""OwnerChanged"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":true,""internalType"":""address"",""name"":""token0"",""type"":""address""},{""indexed"":true,""internalType"":""address"",""name"":""token1"",""type"":""address""},{""indexed"":true,""internalType"":""uint24"",""name"":""fee"",""type"":""uint24""},{""indexed"":false,""internalType"":""int24"",""name"":""tickSpacing"",""type"":""int24""},{""indexed"":false,""internalType"":""address"",""name"":""pool"",""type"":""address""}],""name"":""PoolCreated"",""type"":""event""},{""inputs"":[{""internalType"":""address"",""name"":""tokenA"",""type"":""address""},{""internalType"":""address"",""name"":""tokenB"",""type"":""address""},{""internalType"":""uint24"",""name"":""fee"",""type"":""uint24""}],""name"":""createPool"",""outputs"":[{""internalType"":""address"",""name"":""pool"",""type"":""address""}],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[{""internalType"":""uint24"",""name"":""fee"",""type"":""uint24""},{""internalType"":""int24"",""name"":""tickSpacing"",""type"":""int24""}],""name"":""enableFeeAmount"",""outputs"":[],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[{""internalType"":""uint24"",""name"":"""",""type"":""uint24""}],""name"":""feeAmountTickSpacing"",""outputs"":[{""internalType"":""int24"",""name"":"""",""type"":""int24""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""},{""internalType"":""address"",""name"":"""",""type"":""address""},{""internalType"":""uint24"",""name"":"""",""type"":""uint24""}],""name"":""getPool"",""outputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""owner"",""outputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""parameters"",""outputs"":[{""internalType"":""address"",""name"":""factory"",""type"":""address""},{""internalType"":""address"",""name"":""token0"",""type"":""address""},{""internalType"":""address"",""name"":""token1"",""type"":""address""},{""internalType"":""uint24"",""name"":""fee"",""type"":""uint24""},{""internalType"":""int24"",""name"":""tickSpacing"",""type"":""int24""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""_owner"",""type"":""address""}],""name"":""setOwner"",""outputs"":[],""stateMutability"":""nonpayable"",""type"":""function""}] ";

        private readonly string _uniswapV3SwapRouter02Address = "0x68b3465833fb72A70ecDF485E0e4C7bD8665Fc45";
        private readonly string _uniswapV3SwapRouter02Abi = @" [{""inputs"":[{""internalType"":""address"",""name"":""_factoryV2"",""type"":""address""},{""internalType"":""address"",""name"":""factoryV3"",""type"":""address""},{""internalType"":""address"",""name"":""_positionManager"",""type"":""address""},{""internalType"":""address"",""name"":""_WETH9"",""type"":""address""}],""stateMutability"":""nonpayable"",""type"":""constructor""},{""inputs"":[],""name"":""WETH9"",""outputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""}],""name"":""approveMax"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""}],""name"":""approveMaxMinusOne"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""}],""name"":""approveZeroThenMax"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""}],""name"":""approveZeroThenMaxMinusOne"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""bytes"",""name"":""data"",""type"":""bytes""}],""name"":""callPositionManager"",""outputs"":[{""internalType"":""bytes"",""name"":""result"",""type"":""bytes""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""bytes[]"",""name"":""paths"",""type"":""bytes[]""},{""internalType"":""uint128[]"",""name"":""amounts"",""type"":""uint128[]""},{""internalType"":""uint24"",""name"":""maximumTickDivergence"",""type"":""uint24""},{""internalType"":""uint32"",""name"":""secondsAgo"",""type"":""uint32""}],""name"":""checkOracleSlippage"",""outputs"":[],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""bytes"",""name"":""path"",""type"":""bytes""},{""internalType"":""uint24"",""name"":""maximumTickDivergence"",""type"":""uint24""},{""internalType"":""uint32"",""name"":""secondsAgo"",""type"":""uint32""}],""name"":""checkOracleSlippage"",""outputs"":[],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""components"":[{""internalType"":""bytes"",""name"":""path"",""type"":""bytes""},{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""uint256"",""name"":""amountIn"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amountOutMinimum"",""type"":""uint256""}],""internalType"":""struct IV3SwapRouter.ExactInputParams"",""name"":""params"",""type"":""tuple""}],""name"":""exactInput"",""outputs"":[{""internalType"":""uint256"",""name"":""amountOut"",""type"":""uint256""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""components"":[{""internalType"":""address"",""name"":""tokenIn"",""type"":""address""},{""internalType"":""address"",""name"":""tokenOut"",""type"":""address""},{""internalType"":""uint24"",""name"":""fee"",""type"":""uint24""},{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""uint256"",""name"":""amountIn"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amountOutMinimum"",""type"":""uint256""},{""internalType"":""uint160"",""name"":""sqrtPriceLimitX96"",""type"":""uint160""}],""internalType"":""struct IV3SwapRouter.ExactInputSingleParams"",""name"":""params"",""type"":""tuple""}],""name"":""exactInputSingle"",""outputs"":[{""internalType"":""uint256"",""name"":""amountOut"",""type"":""uint256""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""components"":[{""internalType"":""bytes"",""name"":""path"",""type"":""bytes""},{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""uint256"",""name"":""amountOut"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amountInMaximum"",""type"":""uint256""}],""internalType"":""struct IV3SwapRouter.ExactOutputParams"",""name"":""params"",""type"":""tuple""}],""name"":""exactOutput"",""outputs"":[{""internalType"":""uint256"",""name"":""amountIn"",""type"":""uint256""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""components"":[{""internalType"":""address"",""name"":""tokenIn"",""type"":""address""},{""internalType"":""address"",""name"":""tokenOut"",""type"":""address""},{""internalType"":""uint24"",""name"":""fee"",""type"":""uint24""},{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""uint256"",""name"":""amountOut"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amountInMaximum"",""type"":""uint256""},{""internalType"":""uint160"",""name"":""sqrtPriceLimitX96"",""type"":""uint160""}],""internalType"":""struct IV3SwapRouter.ExactOutputSingleParams"",""name"":""params"",""type"":""tuple""}],""name"":""exactOutputSingle"",""outputs"":[{""internalType"":""uint256"",""name"":""amountIn"",""type"":""uint256""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[],""name"":""factory"",""outputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""factoryV2"",""outputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""},{""internalType"":""uint256"",""name"":""amount"",""type"":""uint256""}],""name"":""getApprovalType"",""outputs"":[{""internalType"":""enum IApproveAndCall.ApprovalType"",""name"":"""",""type"":""uint8""}],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[{""components"":[{""internalType"":""address"",""name"":""token0"",""type"":""address""},{""internalType"":""address"",""name"":""token1"",""type"":""address""},{""internalType"":""uint256"",""name"":""tokenId"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amount0Min"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amount1Min"",""type"":""uint256""}],""internalType"":""struct IApproveAndCall.IncreaseLiquidityParams"",""name"":""params"",""type"":""tuple""}],""name"":""increaseLiquidity"",""outputs"":[{""internalType"":""bytes"",""name"":""result"",""type"":""bytes""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""components"":[{""internalType"":""address"",""name"":""token0"",""type"":""address""},{""internalType"":""address"",""name"":""token1"",""type"":""address""},{""internalType"":""uint24"",""name"":""fee"",""type"":""uint24""},{""internalType"":""int24"",""name"":""tickLower"",""type"":""int24""},{""internalType"":""int24"",""name"":""tickUpper"",""type"":""int24""},{""internalType"":""uint256"",""name"":""amount0Min"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amount1Min"",""type"":""uint256""},{""internalType"":""address"",""name"":""recipient"",""type"":""address""}],""internalType"":""struct IApproveAndCall.MintParams"",""name"":""params"",""type"":""tuple""}],""name"":""mint"",""outputs"":[{""internalType"":""bytes"",""name"":""result"",""type"":""bytes""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""bytes32"",""name"":""previousBlockhash"",""type"":""bytes32""},{""internalType"":""bytes[]"",""name"":""data"",""type"":""bytes[]""}],""name"":""multicall"",""outputs"":[{""internalType"":""bytes[]"",""name"":"""",""type"":""bytes[]""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""uint256"",""name"":""deadline"",""type"":""uint256""},{""internalType"":""bytes[]"",""name"":""data"",""type"":""bytes[]""}],""name"":""multicall"",""outputs"":[{""internalType"":""bytes[]"",""name"":"""",""type"":""bytes[]""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""bytes[]"",""name"":""data"",""type"":""bytes[]""}],""name"":""multicall"",""outputs"":[{""internalType"":""bytes[]"",""name"":""results"",""type"":""bytes[]""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[],""name"":""positionManager"",""outputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""},{""internalType"":""uint256"",""name"":""value"",""type"":""uint256""}],""name"":""pull"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[],""name"":""refundETH"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""},{""internalType"":""uint256"",""name"":""value"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""deadline"",""type"":""uint256""},{""internalType"":""uint8"",""name"":""v"",""type"":""uint8""},{""internalType"":""bytes32"",""name"":""r"",""type"":""bytes32""},{""internalType"":""bytes32"",""name"":""s"",""type"":""bytes32""}],""name"":""selfPermit"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""},{""internalType"":""uint256"",""name"":""nonce"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""expiry"",""type"":""uint256""},{""internalType"":""uint8"",""name"":""v"",""type"":""uint8""},{""internalType"":""bytes32"",""name"":""r"",""type"":""bytes32""},{""internalType"":""bytes32"",""name"":""s"",""type"":""bytes32""}],""name"":""selfPermitAllowed"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""},{""internalType"":""uint256"",""name"":""nonce"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""expiry"",""type"":""uint256""},{""internalType"":""uint8"",""name"":""v"",""type"":""uint8""},{""internalType"":""bytes32"",""name"":""r"",""type"":""bytes32""},{""internalType"":""bytes32"",""name"":""s"",""type"":""bytes32""}],""name"":""selfPermitAllowedIfNecessary"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""},{""internalType"":""uint256"",""name"":""value"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""deadline"",""type"":""uint256""},{""internalType"":""uint8"",""name"":""v"",""type"":""uint8""},{""internalType"":""bytes32"",""name"":""r"",""type"":""bytes32""},{""internalType"":""bytes32"",""name"":""s"",""type"":""bytes32""}],""name"":""selfPermitIfNecessary"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""uint256"",""name"":""amountIn"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amountOutMin"",""type"":""uint256""},{""internalType"":""address[]"",""name"":""path"",""type"":""address[]""},{""internalType"":""address"",""name"":""to"",""type"":""address""}],""name"":""swapExactTokensForTokens"",""outputs"":[{""internalType"":""uint256"",""name"":""amountOut"",""type"":""uint256""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""uint256"",""name"":""amountOut"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amountInMax"",""type"":""uint256""},{""internalType"":""address[]"",""name"":""path"",""type"":""address[]""},{""internalType"":""address"",""name"":""to"",""type"":""address""}],""name"":""swapTokensForExactTokens"",""outputs"":[{""internalType"":""uint256"",""name"":""amountIn"",""type"":""uint256""}],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""},{""internalType"":""uint256"",""name"":""amountMinimum"",""type"":""uint256""},{""internalType"":""address"",""name"":""recipient"",""type"":""address""}],""name"":""sweepToken"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""},{""internalType"":""uint256"",""name"":""amountMinimum"",""type"":""uint256""}],""name"":""sweepToken"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""},{""internalType"":""uint256"",""name"":""amountMinimum"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""feeBips"",""type"":""uint256""},{""internalType"":""address"",""name"":""feeRecipient"",""type"":""address""}],""name"":""sweepTokenWithFee"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""token"",""type"":""address""},{""internalType"":""uint256"",""name"":""amountMinimum"",""type"":""uint256""},{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""uint256"",""name"":""feeBips"",""type"":""uint256""},{""internalType"":""address"",""name"":""feeRecipient"",""type"":""address""}],""name"":""sweepTokenWithFee"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""int256"",""name"":""amount0Delta"",""type"":""int256""},{""internalType"":""int256"",""name"":""amount1Delta"",""type"":""int256""},{""internalType"":""bytes"",""name"":""_data"",""type"":""bytes""}],""name"":""uniswapV3SwapCallback"",""outputs"":[],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[{""internalType"":""uint256"",""name"":""amountMinimum"",""type"":""uint256""},{""internalType"":""address"",""name"":""recipient"",""type"":""address""}],""name"":""unwrapWETH9"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""uint256"",""name"":""amountMinimum"",""type"":""uint256""}],""name"":""unwrapWETH9"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""uint256"",""name"":""amountMinimum"",""type"":""uint256""},{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""uint256"",""name"":""feeBips"",""type"":""uint256""},{""internalType"":""address"",""name"":""feeRecipient"",""type"":""address""}],""name"":""unwrapWETH9WithFee"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""uint256"",""name"":""amountMinimum"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""feeBips"",""type"":""uint256""},{""internalType"":""address"",""name"":""feeRecipient"",""type"":""address""}],""name"":""unwrapWETH9WithFee"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""inputs"":[{""internalType"":""uint256"",""name"":""value"",""type"":""uint256""}],""name"":""wrapETH"",""outputs"":[],""stateMutability"":""payable"",""type"":""function""},{""stateMutability"":""payable"",""type"":""receive""}] ";

        private readonly string _tokenERC20Abi = @" [{""inputs"":[{""internalType"":""uint256"",""name"":""chainId_"",""type"":""uint256""}],""payable"":false,""stateMutability"":""nonpayable"",""type"":""constructor""},{""anonymous"":false,""inputs"":[{""indexed"":true,""internalType"":""address"",""name"":""src"",""type"":""address""},{""indexed"":true,""internalType"":""address"",""name"":""guy"",""type"":""address""},{""indexed"":false,""internalType"":""uint256"",""name"":""wad"",""type"":""uint256""}],""name"":""Approval"",""type"":""event""},{""anonymous"":true,""inputs"":[{""indexed"":true,""internalType"":""bytes4"",""name"":""sig"",""type"":""bytes4""},{""indexed"":true,""internalType"":""address"",""name"":""usr"",""type"":""address""},{""indexed"":true,""internalType"":""bytes32"",""name"":""arg1"",""type"":""bytes32""},{""indexed"":true,""internalType"":""bytes32"",""name"":""arg2"",""type"":""bytes32""},{""indexed"":false,""internalType"":""bytes"",""name"":""data"",""type"":""bytes""}],""name"":""LogNote"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":true,""internalType"":""address"",""name"":""src"",""type"":""address""},{""indexed"":true,""internalType"":""address"",""name"":""dst"",""type"":""address""},{""indexed"":false,""internalType"":""uint256"",""name"":""wad"",""type"":""uint256""}],""name"":""Transfer"",""type"":""event""},{""constant"":true,""inputs"":[],""name"":""DOMAIN_SEPARATOR"",""outputs"":[{""internalType"":""bytes32"",""name"":"""",""type"":""bytes32""}],""payable"":false,""stateMutability"":""view"",""type"":""function""},{""constant"":true,""inputs"":[],""name"":""PERMIT_TYPEHASH"",""outputs"":[{""internalType"":""bytes32"",""name"":"""",""type"":""bytes32""}],""payable"":false,""stateMutability"":""view"",""type"":""function""},{""constant"":true,""inputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""},{""internalType"":""address"",""name"":"""",""type"":""address""}],""name"":""allowance"",""outputs"":[{""internalType"":""uint256"",""name"":"""",""type"":""uint256""}],""payable"":false,""stateMutability"":""view"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""usr"",""type"":""address""},{""internalType"":""uint256"",""name"":""wad"",""type"":""uint256""}],""name"":""approve"",""outputs"":[{""internalType"":""bool"",""name"":"""",""type"":""bool""}],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":true,""inputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""name"":""balanceOf"",""outputs"":[{""internalType"":""uint256"",""name"":"""",""type"":""uint256""}],""payable"":false,""stateMutability"":""view"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""usr"",""type"":""address""},{""internalType"":""uint256"",""name"":""wad"",""type"":""uint256""}],""name"":""burn"",""outputs"":[],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":true,""inputs"":[],""name"":""decimals"",""outputs"":[{""internalType"":""uint8"",""name"":"""",""type"":""uint8""}],""payable"":false,""stateMutability"":""view"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""guy"",""type"":""address""}],""name"":""deny"",""outputs"":[],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""usr"",""type"":""address""},{""internalType"":""uint256"",""name"":""wad"",""type"":""uint256""}],""name"":""mint"",""outputs"":[],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""src"",""type"":""address""},{""internalType"":""address"",""name"":""dst"",""type"":""address""},{""internalType"":""uint256"",""name"":""wad"",""type"":""uint256""}],""name"":""move"",""outputs"":[],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":true,""inputs"":[],""name"":""name"",""outputs"":[{""internalType"":""string"",""name"":"""",""type"":""string""}],""payable"":false,""stateMutability"":""view"",""type"":""function""},{""constant"":true,""inputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""name"":""nonces"",""outputs"":[{""internalType"":""uint256"",""name"":"""",""type"":""uint256""}],""payable"":false,""stateMutability"":""view"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""holder"",""type"":""address""},{""internalType"":""address"",""name"":""spender"",""type"":""address""},{""internalType"":""uint256"",""name"":""nonce"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""expiry"",""type"":""uint256""},{""internalType"":""bool"",""name"":""allowed"",""type"":""bool""},{""internalType"":""uint8"",""name"":""v"",""type"":""uint8""},{""internalType"":""bytes32"",""name"":""r"",""type"":""bytes32""},{""internalType"":""bytes32"",""name"":""s"",""type"":""bytes32""}],""name"":""permit"",""outputs"":[],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""usr"",""type"":""address""},{""internalType"":""uint256"",""name"":""wad"",""type"":""uint256""}],""name"":""pull"",""outputs"":[],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""usr"",""type"":""address""},{""internalType"":""uint256"",""name"":""wad"",""type"":""uint256""}],""name"":""push"",""outputs"":[],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""guy"",""type"":""address""}],""name"":""rely"",""outputs"":[],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":true,""inputs"":[],""name"":""symbol"",""outputs"":[{""internalType"":""string"",""name"":"""",""type"":""string""}],""payable"":false,""stateMutability"":""view"",""type"":""function""},{""constant"":true,""inputs"":[],""name"":""totalSupply"",""outputs"":[{""internalType"":""uint256"",""name"":"""",""type"":""uint256""}],""payable"":false,""stateMutability"":""view"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""dst"",""type"":""address""},{""internalType"":""uint256"",""name"":""wad"",""type"":""uint256""}],""name"":""transfer"",""outputs"":[{""internalType"":""bool"",""name"":"""",""type"":""bool""}],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":false,""inputs"":[{""internalType"":""address"",""name"":""src"",""type"":""address""},{""internalType"":""address"",""name"":""dst"",""type"":""address""},{""internalType"":""uint256"",""name"":""wad"",""type"":""uint256""}],""name"":""transferFrom"",""outputs"":[{""internalType"":""bool"",""name"":"""",""type"":""bool""}],""payable"":false,""stateMutability"":""nonpayable"",""type"":""function""},{""constant"":true,""inputs"":[],""name"":""version"",""outputs"":[{""internalType"":""string"",""name"":"""",""type"":""string""}],""payable"":false,""stateMutability"":""view"",""type"":""function""},{""constant"":true,""inputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""name"":""wards"",""outputs"":[{""internalType"":""uint256"",""name"":"""",""type"":""uint256""}],""payable"":false,""stateMutability"":""view"",""type"":""function""}] ";

        private readonly string _uniswapV3PoolAbi = @" [{""inputs"":[],""stateMutability"":""nonpayable"",""type"":""constructor""},{""anonymous"":false,""inputs"":[{""indexed"":true,""internalType"":""address"",""name"":""owner"",""type"":""address""},{""indexed"":true,""internalType"":""int24"",""name"":""tickLower"",""type"":""int24""},{""indexed"":true,""internalType"":""int24"",""name"":""tickUpper"",""type"":""int24""},{""indexed"":false,""internalType"":""uint128"",""name"":""amount"",""type"":""uint128""},{""indexed"":false,""internalType"":""uint256"",""name"":""amount0"",""type"":""uint256""},{""indexed"":false,""internalType"":""uint256"",""name"":""amount1"",""type"":""uint256""}],""name"":""Burn"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":true,""internalType"":""address"",""name"":""owner"",""type"":""address""},{""indexed"":false,""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""indexed"":true,""internalType"":""int24"",""name"":""tickLower"",""type"":""int24""},{""indexed"":true,""internalType"":""int24"",""name"":""tickUpper"",""type"":""int24""},{""indexed"":false,""internalType"":""uint128"",""name"":""amount0"",""type"":""uint128""},{""indexed"":false,""internalType"":""uint128"",""name"":""amount1"",""type"":""uint128""}],""name"":""Collect"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":true,""internalType"":""address"",""name"":""sender"",""type"":""address""},{""indexed"":true,""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""indexed"":false,""internalType"":""uint128"",""name"":""amount0"",""type"":""uint128""},{""indexed"":false,""internalType"":""uint128"",""name"":""amount1"",""type"":""uint128""}],""name"":""CollectProtocol"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":true,""internalType"":""address"",""name"":""sender"",""type"":""address""},{""indexed"":true,""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""indexed"":false,""internalType"":""uint256"",""name"":""amount0"",""type"":""uint256""},{""indexed"":false,""internalType"":""uint256"",""name"":""amount1"",""type"":""uint256""},{""indexed"":false,""internalType"":""uint256"",""name"":""paid0"",""type"":""uint256""},{""indexed"":false,""internalType"":""uint256"",""name"":""paid1"",""type"":""uint256""}],""name"":""Flash"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":false,""internalType"":""uint16"",""name"":""observationCardinalityNextOld"",""type"":""uint16""},{""indexed"":false,""internalType"":""uint16"",""name"":""observationCardinalityNextNew"",""type"":""uint16""}],""name"":""IncreaseObservationCardinalityNext"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":false,""internalType"":""uint160"",""name"":""sqrtPriceX96"",""type"":""uint160""},{""indexed"":false,""internalType"":""int24"",""name"":""tick"",""type"":""int24""}],""name"":""Initialize"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":false,""internalType"":""address"",""name"":""sender"",""type"":""address""},{""indexed"":true,""internalType"":""address"",""name"":""owner"",""type"":""address""},{""indexed"":true,""internalType"":""int24"",""name"":""tickLower"",""type"":""int24""},{""indexed"":true,""internalType"":""int24"",""name"":""tickUpper"",""type"":""int24""},{""indexed"":false,""internalType"":""uint128"",""name"":""amount"",""type"":""uint128""},{""indexed"":false,""internalType"":""uint256"",""name"":""amount0"",""type"":""uint256""},{""indexed"":false,""internalType"":""uint256"",""name"":""amount1"",""type"":""uint256""}],""name"":""Mint"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":false,""internalType"":""uint8"",""name"":""feeProtocol0Old"",""type"":""uint8""},{""indexed"":false,""internalType"":""uint8"",""name"":""feeProtocol1Old"",""type"":""uint8""},{""indexed"":false,""internalType"":""uint8"",""name"":""feeProtocol0New"",""type"":""uint8""},{""indexed"":false,""internalType"":""uint8"",""name"":""feeProtocol1New"",""type"":""uint8""}],""name"":""SetFeeProtocol"",""type"":""event""},{""anonymous"":false,""inputs"":[{""indexed"":true,""internalType"":""address"",""name"":""sender"",""type"":""address""},{""indexed"":true,""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""indexed"":false,""internalType"":""int256"",""name"":""amount0"",""type"":""int256""},{""indexed"":false,""internalType"":""int256"",""name"":""amount1"",""type"":""int256""},{""indexed"":false,""internalType"":""uint160"",""name"":""sqrtPriceX96"",""type"":""uint160""},{""indexed"":false,""internalType"":""uint128"",""name"":""liquidity"",""type"":""uint128""},{""indexed"":false,""internalType"":""int24"",""name"":""tick"",""type"":""int24""}],""name"":""Swap"",""type"":""event""},{""inputs"":[{""internalType"":""int24"",""name"":""tickLower"",""type"":""int24""},{""internalType"":""int24"",""name"":""tickUpper"",""type"":""int24""},{""internalType"":""uint128"",""name"":""amount"",""type"":""uint128""}],""name"":""burn"",""outputs"":[{""internalType"":""uint256"",""name"":""amount0"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amount1"",""type"":""uint256""}],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""int24"",""name"":""tickLower"",""type"":""int24""},{""internalType"":""int24"",""name"":""tickUpper"",""type"":""int24""},{""internalType"":""uint128"",""name"":""amount0Requested"",""type"":""uint128""},{""internalType"":""uint128"",""name"":""amount1Requested"",""type"":""uint128""}],""name"":""collect"",""outputs"":[{""internalType"":""uint128"",""name"":""amount0"",""type"":""uint128""},{""internalType"":""uint128"",""name"":""amount1"",""type"":""uint128""}],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""uint128"",""name"":""amount0Requested"",""type"":""uint128""},{""internalType"":""uint128"",""name"":""amount1Requested"",""type"":""uint128""}],""name"":""collectProtocol"",""outputs"":[{""internalType"":""uint128"",""name"":""amount0"",""type"":""uint128""},{""internalType"":""uint128"",""name"":""amount1"",""type"":""uint128""}],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[],""name"":""factory"",""outputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""fee"",""outputs"":[{""internalType"":""uint24"",""name"":"""",""type"":""uint24""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""feeGrowthGlobal0X128"",""outputs"":[{""internalType"":""uint256"",""name"":"""",""type"":""uint256""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""feeGrowthGlobal1X128"",""outputs"":[{""internalType"":""uint256"",""name"":"""",""type"":""uint256""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""uint256"",""name"":""amount0"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amount1"",""type"":""uint256""},{""internalType"":""bytes"",""name"":""data"",""type"":""bytes""}],""name"":""flash"",""outputs"":[],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[{""internalType"":""uint16"",""name"":""observationCardinalityNext"",""type"":""uint16""}],""name"":""increaseObservationCardinalityNext"",""outputs"":[],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[{""internalType"":""uint160"",""name"":""sqrtPriceX96"",""type"":""uint160""}],""name"":""initialize"",""outputs"":[],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[],""name"":""liquidity"",""outputs"":[{""internalType"":""uint128"",""name"":"""",""type"":""uint128""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""maxLiquidityPerTick"",""outputs"":[{""internalType"":""uint128"",""name"":"""",""type"":""uint128""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""int24"",""name"":""tickLower"",""type"":""int24""},{""internalType"":""int24"",""name"":""tickUpper"",""type"":""int24""},{""internalType"":""uint128"",""name"":""amount"",""type"":""uint128""},{""internalType"":""bytes"",""name"":""data"",""type"":""bytes""}],""name"":""mint"",""outputs"":[{""internalType"":""uint256"",""name"":""amount0"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""amount1"",""type"":""uint256""}],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[{""internalType"":""uint256"",""name"":"""",""type"":""uint256""}],""name"":""observations"",""outputs"":[{""internalType"":""uint32"",""name"":""blockTimestamp"",""type"":""uint32""},{""internalType"":""int56"",""name"":""tickCumulative"",""type"":""int56""},{""internalType"":""uint160"",""name"":""secondsPerLiquidityCumulativeX128"",""type"":""uint160""},{""internalType"":""bool"",""name"":""initialized"",""type"":""bool""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""uint32[]"",""name"":""secondsAgos"",""type"":""uint32[]""}],""name"":""observe"",""outputs"":[{""internalType"":""int56[]"",""name"":""tickCumulatives"",""type"":""int56[]""},{""internalType"":""uint160[]"",""name"":""secondsPerLiquidityCumulativeX128s"",""type"":""uint160[]""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""bytes32"",""name"":"""",""type"":""bytes32""}],""name"":""positions"",""outputs"":[{""internalType"":""uint128"",""name"":""liquidity"",""type"":""uint128""},{""internalType"":""uint256"",""name"":""feeGrowthInside0LastX128"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""feeGrowthInside1LastX128"",""type"":""uint256""},{""internalType"":""uint128"",""name"":""tokensOwed0"",""type"":""uint128""},{""internalType"":""uint128"",""name"":""tokensOwed1"",""type"":""uint128""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""protocolFees"",""outputs"":[{""internalType"":""uint128"",""name"":""token0"",""type"":""uint128""},{""internalType"":""uint128"",""name"":""token1"",""type"":""uint128""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""uint8"",""name"":""feeProtocol0"",""type"":""uint8""},{""internalType"":""uint8"",""name"":""feeProtocol1"",""type"":""uint8""}],""name"":""setFeeProtocol"",""outputs"":[],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[],""name"":""slot0"",""outputs"":[{""internalType"":""uint160"",""name"":""sqrtPriceX96"",""type"":""uint160""},{""internalType"":""int24"",""name"":""tick"",""type"":""int24""},{""internalType"":""uint16"",""name"":""observationIndex"",""type"":""uint16""},{""internalType"":""uint16"",""name"":""observationCardinality"",""type"":""uint16""},{""internalType"":""uint16"",""name"":""observationCardinalityNext"",""type"":""uint16""},{""internalType"":""uint8"",""name"":""feeProtocol"",""type"":""uint8""},{""internalType"":""bool"",""name"":""unlocked"",""type"":""bool""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""int24"",""name"":""tickLower"",""type"":""int24""},{""internalType"":""int24"",""name"":""tickUpper"",""type"":""int24""}],""name"":""snapshotCumulativesInside"",""outputs"":[{""internalType"":""int56"",""name"":""tickCumulativeInside"",""type"":""int56""},{""internalType"":""uint160"",""name"":""secondsPerLiquidityInsideX128"",""type"":""uint160""},{""internalType"":""uint32"",""name"":""secondsInside"",""type"":""uint32""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""address"",""name"":""recipient"",""type"":""address""},{""internalType"":""bool"",""name"":""zeroForOne"",""type"":""bool""},{""internalType"":""int256"",""name"":""amountSpecified"",""type"":""int256""},{""internalType"":""uint160"",""name"":""sqrtPriceLimitX96"",""type"":""uint160""},{""internalType"":""bytes"",""name"":""data"",""type"":""bytes""}],""name"":""swap"",""outputs"":[{""internalType"":""int256"",""name"":""amount0"",""type"":""int256""},{""internalType"":""int256"",""name"":""amount1"",""type"":""int256""}],""stateMutability"":""nonpayable"",""type"":""function""},{""inputs"":[{""internalType"":""int16"",""name"":"""",""type"":""int16""}],""name"":""tickBitmap"",""outputs"":[{""internalType"":""uint256"",""name"":"""",""type"":""uint256""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""tickSpacing"",""outputs"":[{""internalType"":""int24"",""name"":"""",""type"":""int24""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[{""internalType"":""int24"",""name"":"""",""type"":""int24""}],""name"":""ticks"",""outputs"":[{""internalType"":""uint128"",""name"":""liquidityGross"",""type"":""uint128""},{""internalType"":""int128"",""name"":""liquidityNet"",""type"":""int128""},{""internalType"":""uint256"",""name"":""feeGrowthOutside0X128"",""type"":""uint256""},{""internalType"":""uint256"",""name"":""feeGrowthOutside1X128"",""type"":""uint256""},{""internalType"":""int56"",""name"":""tickCumulativeOutside"",""type"":""int56""},{""internalType"":""uint160"",""name"":""secondsPerLiquidityOutsideX128"",""type"":""uint160""},{""internalType"":""uint32"",""name"":""secondsOutside"",""type"":""uint32""},{""internalType"":""bool"",""name"":""initialized"",""type"":""bool""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""token0"",""outputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""stateMutability"":""view"",""type"":""function""},{""inputs"":[],""name"":""token1"",""outputs"":[{""internalType"":""address"",""name"":"""",""type"":""address""}],""stateMutability"":""view"",""type"":""function""}] ";

        public EnumHelper EnumHelper { get; set; }

        private readonly UniswapV3GraphQL _uniswapGraphQL;

        public UniswapV3Controller(IConfiguration configuration, UniswapV3GraphQL uniswapGraphQL)
        {
            EnumHelper = new EnumHelper(configuration);
            _user = configuration.GetSection("User").Get<WalletOwner>();
            _uniswapGraphQL = uniswapGraphQL;
        }

        [HttpGet("Reserves")]
        public async Task<ActionResult> GetUniswapV3GetReserves(Chain chain, string addressToken0, string addressToken1, long fee)
        {
            if (fee != 100 && fee != 500 && fee != 3000 && fee != 10000)
            {
                throw new ArgumentOutOfRangeException(nameof(fee), "Fee must be 100 or 500 or 3000 or 10000");
            }

            Account? account = new(_user.PrivateKey, chain);
            Web3? web3 = new(account, EnumHelper.GetStringBasedOnEnum(chain));

            Contract? smartContract = web3.Eth.GetContract(_uniswapV3FactoryAbi, _uniswapV3FactoryAddress);
            Function? getPool = smartContract.GetFunction("getPool");

            object[] parameters = new object[3] { addressToken0, addressToken1, fee };
            string poolAddress = await getPool.CallAsync<string>(parameters);

            if (poolAddress == "0x0000000000000000000000000000000000000000")
            {
                return NotFound();
            }

            Contract? smartContractPool = web3.Eth.GetContract(_uniswapV3PoolAbi, poolAddress);
            Function? getToken0FromPool = smartContractPool.GetFunction("token0");
            string token0 = await getToken0FromPool.CallAsync<string>();

            Function? getToken1FromPool = smartContractPool.GetFunction("token1");
            string token1 = await getToken1FromPool.CallAsync<string>();

            Contract? smartContractToken0 = web3.Eth.GetContract(_tokenERC20Abi, token0);
            Function? balanceOfToken0 = smartContractToken0.GetFunction("balanceOf");
            BigInteger balanceOfToken0Result = await balanceOfToken0.CallAsync<BigInteger>(poolAddress);

            Contract? smartContractToken1 = web3.Eth.GetContract(_tokenERC20Abi, token1);
            Function? balanceOfToken1 = smartContractToken1.GetFunction("balanceOf");
            BigInteger balanceOfToken1Result = await balanceOfToken1.CallAsync<BigInteger>(poolAddress);

            BigDecimal balanceInEthToken0 = Web3.Convert.FromWeiToBigDecimal(balanceOfToken0Result);
            BigDecimal balanceInEthToken1 = Web3.Convert.FromWeiToBigDecimal(balanceOfToken1Result);

            //balanceInEthToken1 has 6 decimals and not 18
            BigDecimal adjusted_price = balanceInEthToken1 / (10 ^ 18 - 6);
            BigDecimal inverted_price = 1 / adjusted_price;

            BigDecimal price = balanceInEthToken0 / inverted_price;

            return Ok($"Token 1 balance {balanceInEthToken0} and balance of token 2 {inverted_price}");
        }

        [HttpPost("UniswapV3SwapRouter02/SwapExactTokensForTokens")]
        public async Task<ActionResult> UniswapV3SwapRouter02SwapExactTokensForTokens(Chain chain, double amountToSwap, long amountIn, long amountOutMin, [FromBody] List<string> path, string recipientAddress)
        {
            Account? account = new(_user.PrivateKey, chain);
            Web3? web3 = new(account, EnumHelper.GetStringBasedOnEnum(chain));

            Contract? smartContract = web3.Eth.GetContract(_uniswapV3SwapRouter02Abi, _uniswapV3SwapRouter02Address);
            Function? swapExactTokensForTokensFunction = smartContract.GetFunction("swapExactTokensForTokens");

            object[] parametersForSwap = new object[4] { amountIn, amountOutMin, path, recipientAddress };

            BigInteger wei = Web3.Convert.ToWei(amountToSwap);
            HexBigInteger value = new(wei);

            HexBigInteger? estimatedGas = await swapExactTokensForTokensFunction.EstimateGasAsync(account.Address, null, value, parametersForSwap);
            TransactionReceipt? transactionReceiptForSwap = await swapExactTokensForTokensFunction.SendTransactionAndWaitForReceiptAsync(account.Address, estimatedGas, value, null, parametersForSwap);

            return Ok($"Transaction Hash for swap {transactionReceiptForSwap.TransactionHash}");
        }

        [HttpPost("TokenData")]
        public async Task<IActionResult> GetTokenData(string tokenId)
        {
            Token? token = await _uniswapGraphQL.GetTokenData(tokenId);
            return Ok(token);
        }

        [HttpPost("MostLiquidPools")]
        public async Task<IActionResult> GetMostLiquidPools(int numberOfPools)
        {
            dynamic? data = await _uniswapGraphQL.GetMostLiquidPools(numberOfPools);
            return Ok(data);
        }

        [HttpPost("PoolData")]
        public async Task<IActionResult> GetPoolData(string poolAddress)
        {
            dynamic? data = await _uniswapGraphQL.GetPoolData(poolAddress);
            return Ok(data);
        }

        [HttpPost("GetRecentSwapsWithinAPool")]
        public async Task<IActionResult> GetRecentSwapsWithinAPool(string poolAddress)
        {
            dynamic? data = await _uniswapGraphQL.GetRecentSwapsWithinAPool(poolAddress);
            return Ok(data);
        }

        [HttpPost("PositionData")]
        public async Task<IActionResult> GetPositionData(int positionId)
        {
            dynamic? data = await _uniswapGraphQL.GetPositionData(positionId);
            return Ok(data);
        }
    }
}
