import "dart:convert";
import "dart:io";

import 'package:recase/recase.dart';

void main(List<String> args) {
  List<String> generatedOutput = [
    "import 'package:flutter/material.dart';\n",
    "import 'package:flutter_brand_icons/flutter_brand_icons.dart';\n\n",
    "// THIS FILE IS AUTOMATICALLY GENERATED!\n\n",
    "List<Map<String, IconData>> iconsDataList = [\n"
  ];

  File output = File('./example/lib/icons_list.dart');

  File fontsConfigFile = File(args[0]);

  if (!fontsConfigFile.existsSync()) {
    print('config file not found');
    exit(0);
  }

  String content = fontsConfigFile.readAsStringSync();
  List<dynamic> icons = json.decode(content);

  for (Map<String, dynamic> icon in icons) {
    icon.forEach((String iconName, dynamic iconUnicode) => generatedOutput.add(
        "{ \"${ReCase(iconName).camelCase}\" : BrandIcons.${ReCase(iconName).camelCase} },"));
  }

  generatedOutput.add("];\n");
  output.writeAsStringSync(generatedOutput.join());
}
