import thunk from "redux-thunk";
import { createStore, applyMiddleware, compose, combineReducers } from 'redux';
import { routerMiddleware, LOCATION_CHANGE } from "connected-react-router";
import { reducers } from "@Store/index";

export default function configureStore(history, initialState = {}) {

    // Build middleware. These are functions that can process the actions before they reach the store.
    const windowIfDefined = typeof window === "undefined" ? null : window;

    // If devTools is installed, connect to it.
    const devToolsExtension = windowIfDefined && windowIfDefined.__REDUX_DEVTOOLS_EXTENSION__;
    const createStoreWithMiddleware = compose(
        applyMiddleware(thunk, routerMiddleware(history)),
        devToolsExtension ? devToolsExtension() : next => next
    )(createStore);

    // Combine all reducers and instantiate the app-wide store instance.
    const allReducers = buildRootReducer(reducers, history);
    const store = createStoreWithMiddleware(allReducers, initialState);

    // Enable Webpack hot module replacement for reducers.
    if (module.hot) {
        module.hot.accept("@Store/index", () => {
            const nextRootReducer = require("@Store/index");
            store.replaceReducer(buildRootReducer(nextRootReducer.reducers, history));
        });
    }

    return store;
}

const routerReducer = (history) => {
    const initialState = {
        location: history.location,
        action: history.action,
    };
    return (state = initialState, arg = {}) => {
        if (arg.type === LOCATION_CHANGE) {
            return { ...state, ...arg.payload };
        }
        return state;
    }
};

function buildRootReducer(allReducers, history) {
    return combineReducers({...allReducers, ...{ router: routerReducer(history) }});
}