/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font iv8x16u.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char vga_block1[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0000 (ESC)
	{ 0x00, 0x00, 0x7e, 0x81, 0xa5, 0x81, 0x81, 0xbd, 0x99, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0001 (ESC)
	{ 0x00, 0x00, 0x7e, 0xff, 0xdb, 0xff, 0xff, 0xc3, 0xe7, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0002 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x7f, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+0003 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0004 (ESC)
	{ 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0xe7, 0xe7, 0xe7, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0005 (ESC)
	{ 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0006 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0007 (ESC)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+0008 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0009 (ESC)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+000A (ESC)
	{ 0x00, 0x00, 0x78, 0x70, 0x58, 0x4c, 0x1e, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+000B (ESC)
	{ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+000C (ESC)
	{ 0x00, 0x00, 0xfc, 0xcc, 0xfc, 0x0c, 0x0c, 0x0c, 0x0c, 0x0e, 0x0f, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+000D (ESC)
	{ 0x00, 0x00, 0xfe, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xe6, 0xe7, 0x67, 0x03, 0x00, 0x00, 0x00 },	// U+000E (ESC)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0xdb, 0x3c, 0xe7, 0x3c, 0xdb, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+000F (ESC)
	{ 0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x7f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+0010 (ESC)
	{ 0x00, 0x40, 0x60, 0x70, 0x78, 0x7c, 0x7f, 0x7c, 0x78, 0x70, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+0011 (ESC)
	{ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0012 (ESC)
	{ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+0013 (ESC)
	{ 0x00, 0x00, 0xfe, 0xdb, 0xdb, 0xdb, 0xde, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00 },	// U+0014 (ESC)
	{ 0x00, 0x3e, 0x63, 0x06, 0x1c, 0x36, 0x63, 0x63, 0x36, 0x1c, 0x30, 0x63, 0x3e, 0x00, 0x00, 0x00 },	// U+0015 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0016 (ESC)
	{ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0017 (ESC)
	{ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0018 (ESC)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0019 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x7f, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001A (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0x7f, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001B (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001C (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x36, 0x7f, 0x36, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001D (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001E (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001F (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x66, 0x66, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x00, 0x36, 0x36, 0x7f, 0x36, 0x36, 0x36, 0x7f, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+0023 (#)
	{ 0x18, 0x18, 0x3e, 0x63, 0x43, 0x03, 0x3e, 0x60, 0x60, 0x61, 0x63, 0x3e, 0x18, 0x18, 0x00, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x00, 0x43, 0x63, 0x30, 0x18, 0x0c, 0x06, 0x63, 0x61, 0x00, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x6e, 0x3b, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x0c, 0x0c, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+0028 (()
	{ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x6b, 0x6b, 0x63, 0x63, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x18, 0x1c, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x3e, 0x63, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x3e, 0x63, 0x60, 0x60, 0x3c, 0x60, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x30, 0x38, 0x3c, 0x36, 0x33, 0x7f, 0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x3f, 0x60, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x1c, 0x06, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x7f, 0x63, 0x60, 0x60, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x30, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x30, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x7b, 0x7b, 0x7b, 0x3b, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x03, 0x03, 0x43, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x1f, 0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x36, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x06, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x7b, 0x63, 0x63, 0x66, 0x5c, 0x00, 0x00, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x67, 0x66, 0x66, 0x36, 0x1e, 0x1e, 0x36, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x0f, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x63, 0x77, 0x7f, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x63, 0x67, 0x6f, 0x7f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6b, 0x7b, 0x3e, 0x30, 0x70, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x3e, 0x36, 0x66, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x06, 0x1c, 0x30, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x77, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x63, 0x63, 0x36, 0x3e, 0x1c, 0x1c, 0x3e, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x7f, 0x63, 0x61, 0x30, 0x18, 0x0c, 0x06, 0x43, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+005B ([)
	{ 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x0e, 0x1c, 0x38, 0x70, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+005C (\)
	{ 0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+005D (])
	{ 0x08, 0x1c, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00 },	// U+005F (_)
	{ 0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x07, 0x06, 0x06, 0x1e, 0x36, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x38, 0x30, 0x30, 0x3c, 0x36, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x1c, 0x36, 0x26, 0x06, 0x0f, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3e, 0x30, 0x33, 0x1e, 0x00 },	// U+0067 (g)
	{ 0x00, 0x00, 0x07, 0x06, 0x06, 0x36, 0x6e, 0x66, 0x66, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x00 },	// U+006A (j)
	{ 0x00, 0x00, 0x07, 0x06, 0x06, 0x66, 0x36, 0x1e, 0x1e, 0x36, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x7f, 0x6b, 0x6b, 0x6b, 0x6b, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x0f, 0x00 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3e, 0x30, 0x30, 0x78, 0x00 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x6e, 0x66, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x06, 0x1c, 0x30, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x08, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x36, 0x1c, 0x1c, 0x1c, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x30, 0x1f, 0x00 },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x33, 0x18, 0x0c, 0x06, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00 },	// U+007B ({)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+007C (|)
	{ 0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x70, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+007D (})
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007F ()
}; // 128

static const unsigned char vga_block2[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x18, 0x18, 0x3c, 0x66, 0x06, 0x06, 0x06, 0x66, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x1c, 0x36, 0x26, 0x06, 0x0f, 0x06, 0x06, 0x06, 0x06, 0x67, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x63, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x3e, 0x63, 0x06, 0x1c, 0x36, 0x63, 0x63, 0x36, 0x1c, 0x30, 0x63, 0x3e, 0x00, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x00, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x3e, 0x41, 0x59, 0x45, 0x45, 0x45, 0x59, 0x41, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x3c, 0x36, 0x36, 0x7c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x36, 0x1b, 0x36, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x00, 0x00, 0x3e, 0x41, 0x4d, 0x55, 0x4d, 0x55, 0x55, 0x41, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x00, 0x0e, 0x1b, 0x0c, 0x06, 0x13, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x00, 0x0f, 0x18, 0x0e, 0x18, 0x18, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x03, 0x00, 0x00, 0x00 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0xfe, 0xdb, 0xdb, 0xdb, 0xde, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x1e, 0x00, 0x00 },	// U+00B8 (¸)
	{ 0x00, 0x0c, 0x0e, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x36, 0x6c, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x00, 0x03, 0x03, 0x43, 0x63, 0x33, 0x18, 0x0c, 0x66, 0x73, 0x79, 0x7c, 0x60, 0x60, 0x00, 0x00 },	// U+00BC (¼)
	{ 0x00, 0x03, 0x03, 0x43, 0x63, 0x33, 0x18, 0x0c, 0x06, 0x3b, 0x61, 0x30, 0x18, 0x7c, 0x00, 0x00 },	// U+00BD (½)
	{ 0x00, 0x07, 0x0c, 0x46, 0x6c, 0x37, 0x18, 0x0c, 0x66, 0x73, 0x69, 0x7c, 0x60, 0x60, 0x00, 0x00 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x06, 0x03, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00BF (¿)
	{ 0x30, 0x60, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x06, 0x03, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x3e, 0x63, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x6e, 0x3b, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x00, 0x63, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x1c, 0x36, 0x1c, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x7c, 0x36, 0x33, 0x33, 0x7f, 0x33, 0x33, 0x33, 0x33, 0x73, 0x00, 0x00, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x03, 0x43, 0x66, 0x3c, 0x30, 0x60, 0x3e, 0x00, 0x00 },	// U+00C7 (Ç)
	{ 0x0c, 0x18, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x18, 0x0c, 0x06, 0x00, 0x7f, 0x66, 0x06, 0x3e, 0x06, 0x06, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x1c, 0x36, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x00, 0x63, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x0c, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x30, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x3c, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x00, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x1f, 0x36, 0x66, 0x66, 0x6f, 0x66, 0x66, 0x66, 0x36, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x6e, 0x3b, 0x00, 0x63, 0x67, 0x6f, 0x7f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x0c, 0x18, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x6e, 0x3b, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x00, 0x63, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x36, 0x1c, 0x1c, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x20, 0x3e, 0x73, 0x73, 0x6b, 0x6b, 0x6b, 0x6b, 0x67, 0x67, 0x3e, 0x02, 0x00, 0x00, 0x00 },	// U+00D8 (Ø)
	{ 0x0c, 0x18, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x18, 0x0c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x1c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x00, 0x63, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x30, 0x18, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x0f, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x1e, 0x33, 0x33, 0x33, 0x1b, 0x33, 0x63, 0x63, 0x63, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x06, 0x0c, 0x18, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x18, 0x0c, 0x06, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x33, 0x00, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x1c, 0x36, 0x1c, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x6e, 0x6c, 0x7e, 0x1b, 0x1b, 0x76, 0x00, 0x00, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x06, 0x06, 0x66, 0x3c, 0x30, 0x60, 0x3c, 0x00, 0x00, 0x00 },	// U+00E7 (ç)
	{ 0x00, 0x06, 0x0c, 0x18, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x63, 0x00, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x06, 0x0c, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x18, 0x3c, 0x66, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x66, 0x00, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x00, 0x2c, 0x18, 0x34, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x06, 0x0c, 0x18, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x18, 0x0c, 0x06, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x63, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x06, 0x0c, 0x18, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x18, 0x0c, 0x06, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x33, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x30, 0x1f, 0x00 },	// U+00FD (ý)
	{ 0x00, 0x00, 0x07, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x0f, 0x00 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x30, 0x1e, 0x00 },	// U+00FF (ÿ)
	{ 0x3e, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x3e, 0x00, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0101 (ā)
	{ 0x63, 0x3e, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x00, 0x63, 0x3e, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x18, 0x0c, 0x78, 0x00 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x18, 0x0c, 0x78, 0x00 },	// U+0105 (ą)
	{ 0x30, 0x18, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x03, 0x43, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x38, 0x6c, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x03, 0x43, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x18, 0x18, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x03, 0x43, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+010B (ċ)
	{ 0x66, 0x3c, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x03, 0x43, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+010D (č)
	{ 0x36, 0x1c, 0x00, 0x1f, 0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x36, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x36, 0x1c, 0x00, 0x38, 0x30, 0x30, 0x3c, 0x36, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x1f, 0x36, 0x66, 0x66, 0x6f, 0x66, 0x66, 0x66, 0x36, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x00, 0x30, 0x30, 0x7e, 0x30, 0x3c, 0x36, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x3e, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x06, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x3e, 0x00, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0113 (ē)
	{ 0x63, 0x3e, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0114 (Ĕ)
	{ 0x00, 0x00, 0x63, 0x3e, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0115 (ĕ)
	{ 0x18, 0x18, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x06, 0x46, 0x66, 0x7f, 0x18, 0x0c, 0x78, 0x00 },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x0c, 0x06, 0x3c, 0x00 },	// U+0119 (ę)
	{ 0x36, 0x1c, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0x00, 0x66, 0x3c, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+011B (ě)
	{ 0x38, 0x6c, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x7b, 0x63, 0x66, 0x5c, 0x00, 0x00, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x6e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3e, 0x30, 0x33, 0x1e, 0x00 },	// U+011D (ĝ)
	{ 0x66, 0x3c, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x7b, 0x63, 0x66, 0x5c, 0x00, 0x00, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x00, 0x63, 0x3e, 0x00, 0x6e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3e, 0x30, 0x33, 0x1e, 0x00 },	// U+011F (ğ)
	{ 0x18, 0x18, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x7b, 0x63, 0x66, 0x5c, 0x00, 0x00, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x6e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3e, 0x30, 0x33, 0x1e, 0x00 },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x7b, 0x63, 0x63, 0x66, 0x5c, 0x18, 0x30, 0x1e, 0x00 },	// U+0122 (Ģ)
	{ 0x00, 0x78, 0x0c, 0x18, 0x00, 0x6e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3e, 0x30, 0x33, 0x1e, 0x00 },	// U+0123 (ģ)
	{ 0x1c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x1c, 0x36, 0x00, 0x07, 0x06, 0x06, 0x36, 0x6e, 0x66, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x66, 0x66, 0xff, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x00, 0x07, 0x06, 0x1f, 0x06, 0x36, 0x6e, 0x66, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0x6e, 0x3b, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x7e, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x3e, 0x00, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+012B (ī)
	{ 0x66, 0x3c, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+012C (Ĭ)
	{ 0x00, 0x00, 0x66, 0x3c, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+012D (ĭ)
	{ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x0c, 0x78, 0x00 },	// U+012E (Į)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x0c, 0x78, 0x00 },	// U+012F (į)
	{ 0x18, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0131 (ı)
	{ 0x00, 0x00, 0x73, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+0132 (Ĳ)
	{ 0x00, 0x00, 0x63, 0x63, 0x00, 0x73, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6c, 0x6c, 0x38, 0x00 },	// U+0133 (ĳ)
	{ 0x38, 0x6c, 0x00, 0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x10, 0x38, 0x6c, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1e, 0x00 },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x67, 0x66, 0x66, 0x36, 0x1e, 0x1e, 0x36, 0x66, 0x66, 0x67, 0x18, 0x30, 0x1e, 0x00 },	// U+0136 (Ķ)
	{ 0x00, 0x00, 0x07, 0x06, 0x06, 0x66, 0x36, 0x1e, 0x1e, 0x36, 0x66, 0x67, 0x18, 0x30, 0x1e, 0x00 },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x66, 0x36, 0x1e, 0x36, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x00, 0x00, 0x6f, 0x36, 0x06, 0x06, 0x06, 0x06, 0x06, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x00, 0x00, 0x67, 0x36, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x0f, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x46, 0x66, 0x7f, 0x18, 0x30, 0x1e, 0x00 },	// U+013B (Ļ)
	{ 0x00, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x30, 0x1e, 0x00 },	// U+013C (ļ)
	{ 0x00, 0xd8, 0x77, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x00, 0xd8, 0x77, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+013E (ľ)
	{ 0x00, 0x00, 0x0f, 0x06, 0x06, 0x66, 0x66, 0x06, 0x06, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+013F (Ŀ)
	{ 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x6c, 0x6c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0140 (ŀ)
	{ 0x00, 0x00, 0x0f, 0x26, 0x36, 0x1e, 0x0e, 0x07, 0x07, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x00, 0x1c, 0x58, 0x78, 0x38, 0x18, 0x1c, 0x1e, 0x1a, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x30, 0x18, 0x00, 0x63, 0x67, 0x6f, 0x7f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x63, 0x67, 0x6f, 0x7f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x63, 0x18, 0x30, 0x1e, 0x00 },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x18, 0x30, 0x1e, 0x00 },	// U+0146 (ņ)
	{ 0x36, 0x1c, 0x00, 0x63, 0x67, 0x6f, 0x7f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+0148 (ň)
	{ 0x06, 0x06, 0x06, 0x03, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+0149 (ŉ)
	{ 0x00, 0x00, 0x63, 0x67, 0x6f, 0x7f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x63, 0x60, 0x60, 0x38, 0x00 },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x38, 0x00 },	// U+014B (ŋ)
	{ 0x3e, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x3e, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+014D (ō)
	{ 0x63, 0x3e, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+014E (Ŏ)
	{ 0x00, 0x00, 0x63, 0x3e, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+014F (ŏ)
	{ 0x6c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x00, 0x6c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x7e, 0x33, 0x33, 0x33, 0x73, 0x33, 0x33, 0x33, 0x33, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6b, 0x6b, 0x7b, 0x1b, 0x1b, 0x76, 0x00, 0x00, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x18, 0x0c, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x3e, 0x36, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x3b, 0x6e, 0x66, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x3e, 0x36, 0x66, 0x66, 0x66, 0x67, 0x18, 0x30, 0x1e, 0x00 },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x6e, 0x66, 0x06, 0x06, 0x06, 0x0f, 0x18, 0x30, 0x1e, 0x00 },	// U+0157 (ŗ)
	{ 0x36, 0x1c, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x3e, 0x36, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3b, 0x6e, 0x66, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x63, 0x06, 0x1c, 0x30, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x3e, 0x63, 0x06, 0x1c, 0x30, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+015B (ś)
	{ 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x06, 0x1c, 0x30, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x06, 0x1c, 0x30, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x06, 0x1c, 0x30, 0x60, 0x63, 0x63, 0x3e, 0x18, 0x30, 0x1e, 0x00 },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x06, 0x1c, 0x30, 0x63, 0x3e, 0x18, 0x30, 0x1e, 0x00 },	// U+015F (ş)
	{ 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x03, 0x06, 0x1c, 0x30, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x06, 0x1c, 0x30, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x30, 0x1e, 0x00 },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x08, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x6c, 0x38, 0x18, 0x30, 0x1e, 0x00 },	// U+0163 (ţ)
	{ 0x66, 0x3c, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x36, 0x1c, 0x00, 0x08, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x08, 0x0c, 0x0c, 0x3f, 0x0c, 0x3f, 0x0c, 0x0c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0x6e, 0x3b, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x7f, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x3f, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+016B (ū)
	{ 0x63, 0x3e, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x00, 0x63, 0x3e, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x1c, 0x36, 0x1c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x00, 0x1e, 0x33, 0x1e, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+016F (ů)
	{ 0x6c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x00, 0x6c, 0x36, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x18, 0x0c, 0x78, 0x00 },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x18, 0x0c, 0x78, 0x00 },	// U+0173 (ų)
	{ 0x1c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x77, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x3c, 0x66, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x30, 0x1f, 0x00 },	// U+0177 (ŷ)
	{ 0x00, 0x66, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x18, 0x0c, 0x00, 0x7f, 0x63, 0x31, 0x18, 0x0c, 0x06, 0x43, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x7f, 0x33, 0x18, 0x0c, 0x06, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+017A (ź)
	{ 0x18, 0x18, 0x00, 0x7f, 0x63, 0x31, 0x18, 0x0c, 0x06, 0x43, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x7f, 0x33, 0x18, 0x0c, 0x06, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+017C (ż)
	{ 0x36, 0x1c, 0x00, 0x7f, 0x63, 0x31, 0x18, 0x0c, 0x06, 0x43, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x7f, 0x33, 0x18, 0x0c, 0x06, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+017E (ž)
	{ 0x00, 0x00, 0x38, 0x6c, 0x4c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+017F (ſ)
}; // 224

static const unsigned char vga_block3[][16] = {
	{ 0x00, 0x70, 0xd8, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x0e, 0x00, 0x00 },	// U+0192 (ƒ)
}; // 1

static const unsigned char vga_block4[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+01A1 (ơ)
}; // 1

static const unsigned char vga_block5[][16] = {
	{ 0x00, 0x00, 0x7f, 0x63, 0x30, 0x18, 0x3c, 0x60, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01B7 (Ʒ)
}; // 1

static const unsigned char vga_block6[][16] = {
	{ 0x5c, 0x36, 0x1c, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+01FA (Ǻ)
	{ 0x30, 0x1c, 0x36, 0x1c, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+01FB (ǻ)
	{ 0x30, 0x18, 0x00, 0x7c, 0x36, 0x33, 0x33, 0x7f, 0x33, 0x33, 0x33, 0x73, 0x00, 0x00, 0x00, 0x00 },	// U+01FC (Ǽ)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x33, 0x6e, 0x6c, 0x7e, 0x1b, 0x1b, 0x76, 0x00, 0x00, 0x00, 0x00 },	// U+01FD (ǽ)
	{ 0x18, 0x0c, 0x20, 0x3e, 0x73, 0x73, 0x6b, 0x6b, 0x6b, 0x67, 0x67, 0x3e, 0x02, 0x00, 0x00, 0x00 },	// U+01FE (Ǿ)
	{ 0x00, 0x18, 0x0c, 0x06, 0x00, 0x3e, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01FF (ǿ)
}; // 6

static const unsigned char vga_block7[][16] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x06, 0x1c, 0x30, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x18, 0x0c, 0x00 },	// U+0218 (Ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x06, 0x1c, 0x30, 0x63, 0x3e, 0x00, 0x18, 0x0c, 0x00 },	// U+0219 (ș)
	{ 0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x0c, 0x00 },	// U+021A (Ț)
	{ 0x00, 0x00, 0x08, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x6c, 0x38, 0x00, 0x18, 0x0c, 0x00 },	// U+021B (ț)
}; // 4

static const unsigned char vga_block8[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x1b, 0x1b, 0x1b, 0x3b, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0251 (ɑ)
}; // 1

static const unsigned char vga_block9[][16] = {
	{ 0x00, 0x00, 0x00, 0x7e, 0x18, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0278 (ɸ)
}; // 1

static const unsigned char vga_block10[][16] = {
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C6 (ˆ)
	{ 0x00, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C7 (ˇ)
}; // 2

static const unsigned char vga_block11[][16] = {
	{ 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C9 (ˉ)
}; // 1

static const unsigned char vga_block12[][16] = {
	{ 0x00, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D8 (˘)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D9 (˙)
	{ 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DA (˚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0x3c, 0x00 },	// U+02DB (˛)
	{ 0x00, 0x6e, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DC (˜)
	{ 0x00, 0x6c, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DD (˝)
}; // 6

static const unsigned char vga_block13[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+037E (;)
}; // 1

static const unsigned char vga_block14[][16] = {
	{ 0x30, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0384 (΄)
	{ 0x18, 0x0c, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0385 (΅)
	{ 0x06, 0x03, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0386 (Ά)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0387 (·)
	{ 0x06, 0x03, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0388 (Έ)
	{ 0x06, 0x03, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0389 (Ή)
	{ 0x06, 0x03, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+038A (Ί)
}; // 7

static const unsigned char vga_block15[][16] = {
	{ 0x06, 0x03, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+038C (Ό)
}; // 1

static const unsigned char vga_block16[][16] = {
	{ 0x06, 0x03, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+038E (Ύ)
	{ 0x06, 0x03, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x63, 0x36, 0x36, 0x77, 0x00, 0x00, 0x00, 0x00 },	// U+038F (Ώ)
	{ 0x18, 0x0c, 0x00, 0x33, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x2c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0390 (ΐ)
	{ 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0391 (Α)
	{ 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0392 (Β)
	{ 0x00, 0x00, 0x7f, 0x66, 0x46, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0393 (Γ)
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0394 (Δ)
	{ 0x00, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x06, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0395 (Ε)
	{ 0x00, 0x00, 0x7f, 0x63, 0x61, 0x30, 0x18, 0x0c, 0x06, 0x43, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0396 (Ζ)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0397 (Η)
	{ 0x00, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+0398 (Θ)
	{ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0399 (Ι)
	{ 0x00, 0x00, 0x67, 0x66, 0x66, 0x36, 0x1e, 0x1e, 0x36, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+039A (Κ)
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+039B (Λ)
	{ 0x00, 0x00, 0x63, 0x77, 0x7f, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+039C (Μ)
	{ 0x00, 0x00, 0x63, 0x67, 0x6f, 0x7f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+039D (Ν)
	{ 0x00, 0x00, 0x7f, 0x63, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+039E (Ξ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+039F (Ο)
	{ 0x00, 0x00, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+03A0 (Π)
	{ 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+03A1 (Ρ)
}; // 20

static const unsigned char vga_block17[][16] = {
	{ 0x00, 0x00, 0x7f, 0x63, 0x46, 0x0c, 0x18, 0x18, 0x0c, 0x46, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+03A3 (Σ)
	{ 0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+03A4 (Τ)
	{ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+03A5 (Υ)
	{ 0x00, 0x00, 0x1c, 0x08, 0x3e, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+03A6 (Φ)
	{ 0x00, 0x00, 0x63, 0x63, 0x36, 0x3e, 0x1c, 0x1c, 0x3e, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+03A7 (Χ)
	{ 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+03A8 (Ψ)
	{ 0x00, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x63, 0x36, 0x36, 0x36, 0x77, 0x00, 0x00, 0x00, 0x00 },	// U+03A9 (Ω)
	{ 0x00, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+03AA (Ϊ)
	{ 0x00, 0x66, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+03AB (Ϋ)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x2e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+03AC (ά)
	{ 0x00, 0x00, 0x60, 0x30, 0x00, 0x7c, 0x06, 0x06, 0x1c, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+03AD (έ)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x60, 0x00 },	// U+03AE (ή)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x2c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+03AF (ί)
	{ 0x18, 0x0c, 0x00, 0x33, 0x00, 0x73, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+03B0 (ΰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+03B1 (α)
	{ 0x00, 0x00, 0x1e, 0x33, 0x33, 0x1b, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x01, 0x00 },	// U+03B2 (β)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x1c, 0x36, 0x36, 0x36, 0x1c, 0x00 },	// U+03B3 (γ)
	{ 0x00, 0x00, 0x78, 0x0c, 0x18, 0x30, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+03B4 (δ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x06, 0x06, 0x1c, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+03B5 (ε)
	{ 0x00, 0x00, 0x03, 0x3e, 0x0c, 0x06, 0x03, 0x03, 0x03, 0x03, 0x06, 0x3c, 0x60, 0x38, 0x00, 0x00 },	// U+03B6 (ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x60, 0x00 },	// U+03B7 (η)
	{ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x6c, 0x78, 0x63, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+03B8 (θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x2c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+03B9 (ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x33, 0x1b, 0x1f, 0x37, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+03BA (κ)
	{ 0x00, 0x00, 0x3c, 0x66, 0x60, 0x60, 0x70, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+03BB (λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x37, 0x5b, 0x03, 0x03, 0x03, 0x00 },	// U+03BC (μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x66, 0x66, 0x66, 0x36, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+03BD (ν)
	{ 0x00, 0x00, 0x03, 0x3e, 0x06, 0x03, 0x03, 0x3e, 0x06, 0x03, 0x03, 0x3e, 0x60, 0x38, 0x00, 0x00 },	// U+03BE (ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03BF (ο)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+03C0 (π)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x67, 0x3b, 0x03, 0x03, 0x03, 0x00 },	// U+03C1 (ρ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x06, 0x3c, 0x60, 0x60, 0x3e, 0x00, 0x00 },	// U+03C2 (ς)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x13, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+03C3 (σ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x58, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+03C4 (τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+03C5 (υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6a, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x08, 0x08, 0x00 },	// U+03C6 (φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x36, 0x1c, 0x1c, 0x1c, 0x36, 0x61, 0x00, 0x00, 0x00, 0x00 },	// U+03C7 (χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x08, 0x08, 0x00 },	// U+03C8 (ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+03C9 (ω)
	{ 0x00, 0x00, 0x33, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x2c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+03CA (ϊ)
	{ 0x00, 0x00, 0x33, 0x00, 0x00, 0x73, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+03CB (ϋ)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03CC (ό)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x73, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+03CD (ύ)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x22, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+03CE (ώ)
}; // 44

static const unsigned char vga_block18[][16] = {
	{ 0x00, 0x00, 0x1e, 0x33, 0x33, 0x33, 0x1b, 0x33, 0x63, 0x63, 0x63, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+03D0 (ϐ)
}; // 1

static const unsigned char vga_block19[][16] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+03F4 (ϴ)
}; // 1

static const unsigned char vga_block20[][16] = {
	{ 0x0c, 0x18, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0400 (Ѐ)
	{ 0x00, 0x63, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0401 (Ё)
	{ 0x00, 0x00, 0x3f, 0x26, 0x06, 0x36, 0x6e, 0x66, 0x66, 0x66, 0x66, 0x67, 0x30, 0x00, 0x00, 0x00 },	// U+0402 (Ђ)
	{ 0x30, 0x18, 0x00, 0x7f, 0x66, 0x46, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0403 (Ѓ)
	{ 0x00, 0x00, 0x3c, 0x66, 0x43, 0x13, 0x1f, 0x13, 0x03, 0x43, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0404 (Є)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x06, 0x1c, 0x30, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0405 (Ѕ)
	{ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0406 (І)
	{ 0x00, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0407 (Ї)
	{ 0x00, 0x00, 0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0408 (Ј)
	{ 0x00, 0x00, 0x3f, 0x1b, 0x1b, 0x1b, 0x3b, 0x5b, 0x5b, 0x5b, 0x5b, 0x3b, 0x00, 0x00, 0x00, 0x00 },	// U+0409 (Љ)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x3f, 0x5b, 0x5b, 0x5b, 0x5b, 0x3b, 0x00, 0x00, 0x00, 0x00 },	// U+040A (Њ)
	{ 0x00, 0x00, 0x3f, 0x26, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+040B (Ћ)
	{ 0x30, 0x18, 0x00, 0x67, 0x66, 0x66, 0x36, 0x1e, 0x36, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+040C (Ќ)
	{ 0x0c, 0x18, 0x00, 0x63, 0x63, 0x63, 0x73, 0x7b, 0x7f, 0x6f, 0x67, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+040D (Ѝ)
	{ 0x36, 0x1c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+040E (Ў)
	{ 0x00, 0x00, 0x77, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x7f, 0x08, 0x08, 0x00, 0x00 },	// U+040F (Џ)
	{ 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0410 (А)
	{ 0x00, 0x00, 0x7f, 0x66, 0x46, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0411 (Б)
	{ 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0412 (В)
	{ 0x00, 0x00, 0x7f, 0x66, 0x46, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0413 (Г)
	{ 0x00, 0x00, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0xc3, 0x81, 0x00, 0x00 },	// U+0414 (Д)
	{ 0x00, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x06, 0x46, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0415 (Е)
	{ 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x3e, 0x1c, 0x3e, 0x6b, 0x6b, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+0416 (Ж)
	{ 0x00, 0x00, 0x3e, 0x63, 0x61, 0x60, 0x3c, 0x60, 0x60, 0x61, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0417 (З)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x73, 0x7b, 0x7f, 0x6f, 0x67, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0418 (И)
	{ 0x36, 0x1c, 0x00, 0x63, 0x63, 0x63, 0x73, 0x7b, 0x7f, 0x6f, 0x67, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0419 (Й)
	{ 0x00, 0x00, 0x67, 0x66, 0x66, 0x36, 0x1e, 0x1e, 0x36, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+041A (К)
	{ 0x00, 0x00, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+041B (Л)
	{ 0x00, 0x00, 0x63, 0x77, 0x7f, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+041C (М)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+041D (Н)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+041E (О)
	{ 0x00, 0x00, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+041F (П)
	{ 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0420 (Р)
	{ 0x00, 0x00, 0x3c, 0x66, 0x43, 0x03, 0x03, 0x03, 0x03, 0x43, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0421 (С)
	{ 0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0422 (Т)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0423 (У)
	{ 0x00, 0x00, 0x1c, 0x08, 0x3e, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+0424 (Ф)
	{ 0x00, 0x00, 0x63, 0x63, 0x36, 0x3e, 0x1c, 0x1c, 0x3e, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0425 (Х)
	{ 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x7f, 0x60, 0x40, 0x00, 0x00 },	// U+0426 (Ц)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+0427 (Ч)
	{ 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0428 (Ш)
	{ 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0xff, 0xc0, 0x80, 0x00, 0x00 },	// U+0429 (Щ)
	{ 0x00, 0x00, 0x0f, 0x0d, 0x0d, 0x0c, 0x3c, 0x6c, 0x6c, 0x6c, 0x6c, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+042A (Ъ)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x67, 0x6b, 0x6b, 0x6b, 0x6b, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+042B (Ы)
	{ 0x00, 0x00, 0x0f, 0x06, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+042C (Ь)
	{ 0x00, 0x00, 0x1e, 0x33, 0x61, 0x64, 0x7c, 0x64, 0x60, 0x61, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+042D (Э)
	{ 0x00, 0x00, 0x33, 0x6b, 0x6b, 0x6b, 0x6f, 0x6b, 0x6b, 0x6b, 0x6b, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+042E (Ю)
	{ 0x00, 0x00, 0x7e, 0x33, 0x33, 0x33, 0x3e, 0x36, 0x33, 0x33, 0x33, 0x73, 0x00, 0x00, 0x00, 0x00 },	// U+042F (Я)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0430 (а)
	{ 0x00, 0x00, 0x00, 0x30, 0x1e, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0431 (б)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x66, 0x66, 0x3e, 0x66, 0x66, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0432 (в)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x66, 0x46, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0433 (г)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x36, 0x33, 0x33, 0x33, 0x7f, 0x63, 0x41, 0x00, 0x00 },	// U+0434 (д)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0435 (е)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x3e, 0x6b, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+0436 (ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x60, 0x38, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0437 (з)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0438 (и)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x63, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0439 (й)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x66, 0x36, 0x1e, 0x36, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+043A (к)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+043B (л)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x77, 0x7f, 0x6b, 0x6b, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+043C (м)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+043D (н)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+043E (о)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+043F (п)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x0f, 0x00 },	// U+0440 (р)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0441 (с)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0442 (т)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x30, 0x1f, 0x00 },	// U+0443 (у)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x08, 0x08, 0x00 },	// U+0444 (ф)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x36, 0x1c, 0x1c, 0x1c, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0445 (х)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x7f, 0x60, 0x40, 0x00, 0x00 },	// U+0446 (ц)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+0447 (ч)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0448 (ш)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0xff, 0xc0, 0x80, 0x00, 0x00 },	// U+0449 (щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0d, 0x0c, 0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+044A (ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x67, 0x6b, 0x6b, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+044B (ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+044C (ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x78, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+044D (э)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x6b, 0x6b, 0x6f, 0x6b, 0x6b, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+044E (ю)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x36, 0x36, 0x3c, 0x36, 0x36, 0x77, 0x00, 0x00, 0x00, 0x00 },	// U+044F (я)
	{ 0x00, 0x06, 0x0c, 0x18, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0450 (ѐ)
	{ 0x00, 0x00, 0x63, 0x00, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0451 (ё)
	{ 0x00, 0x00, 0x06, 0x1f, 0x06, 0x36, 0x6e, 0x66, 0x66, 0x66, 0x66, 0x67, 0x60, 0x60, 0x30, 0x00 },	// U+0452 (ђ)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x7f, 0x66, 0x46, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0453 (ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x1f, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0454 (є)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x06, 0x1c, 0x30, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0455 (ѕ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0456 (і)
	{ 0x00, 0x00, 0x66, 0x00, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0457 (ї)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1e, 0x00 },	// U+0458 (ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x1b, 0x1b, 0x3b, 0x5b, 0x5b, 0x3b, 0x00, 0x00, 0x00, 0x00 },	// U+0459 (љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x3f, 0x5b, 0x5b, 0x3b, 0x00, 0x00, 0x00, 0x00 },	// U+045A (њ)
	{ 0x00, 0x00, 0x06, 0x1f, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+045B (ћ)
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x67, 0x66, 0x36, 0x1e, 0x36, 0x66, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+045C (ќ)
	{ 0x00, 0x06, 0x0c, 0x18, 0x00, 0x63, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+045D (ѝ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x30, 0x1f, 0x00 },	// U+045E (ў)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x36, 0x36, 0x36, 0x36, 0x36, 0x7f, 0x08, 0x08, 0x00, 0x00 },	// U+045F (џ)
}; // 96

static const unsigned char vga_block21[][16] = {
	{ 0x40, 0x60, 0x7f, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0490 (Ґ)
	{ 0x00, 0x00, 0x00, 0x40, 0x60, 0x7f, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+0491 (ґ)
}; // 2

static const unsigned char vga_block22[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05BE (־)
}; // 1

static const unsigned char vga_block23[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x66, 0x6e, 0x3b, 0x33, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+05D0 (א)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+05D1 (ב)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x30, 0x30, 0x30, 0x30, 0x38, 0x6c, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+05D2 (ג)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+05D3 (ד)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x60, 0x60, 0x60, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+05D4 (ה)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+05D5 (ו)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x0c, 0x0c, 0x0c, 0x18, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+05D6 (ז)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x66, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+05D7 (ח)
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x6b, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+05D8 (ט)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05D9 (י)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x60, 0x60, 0x60, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x70, 0x00 },	// U+05DA (ך)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+05DB (כ)
	{ 0x00, 0x00, 0x03, 0x03, 0x3f, 0x60, 0x60, 0x60, 0x60, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+05DC (ל)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x66, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+05DD (ם)
	{ 0x00, 0x00, 0x00, 0x00, 0x3b, 0x6e, 0x66, 0x63, 0x63, 0x63, 0x63, 0x7b, 0x00, 0x00, 0x00, 0x00 },	// U+05DE (מ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x30, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x00 },	// U+05DF (ן)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+05E0 (נ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x66, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+05E1 (ס)
	{ 0x00, 0x00, 0x00, 0x00, 0x77, 0x66, 0x66, 0x66, 0x66, 0x66, 0x34, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+05E2 (ע)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x32, 0x33, 0x33, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x70, 0x00 },	// U+05E3 (ף)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x62, 0x63, 0x63, 0x67, 0x60, 0x60, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+05E4 (פ)
	{ 0x00, 0x00, 0x00, 0x00, 0x77, 0x66, 0x66, 0x36, 0x1e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0e, 0x00 },	// U+05E5 (ץ)
	{ 0x00, 0x00, 0x00, 0x00, 0x77, 0x66, 0x66, 0x2c, 0x18, 0x30, 0x60, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+05E6 (צ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x60, 0x60, 0x66, 0x26, 0x36, 0x76, 0x06, 0x06, 0x06, 0x06, 0x00 },	// U+05E7 (ק)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+05E8 (ר)
	{ 0x00, 0x00, 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6f, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+05E9 (ש)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+05EA (ת)
}; // 27

static const unsigned char vga_block24[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+05F0 (װ)
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x66, 0x66, 0x66, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+05F1 (ױ)
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05F2 (ײ)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05F3 (׳)
	{ 0x00, 0x00, 0x00, 0x66, 0x66, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05F4 (״)
}; // 5

static const unsigned char vga_block25[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+1D1B (ᴛ)
}; // 1

static const unsigned char vga_block26[][16] = {
	{ 0x00, 0x00, 0x7f, 0x63, 0x63, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+1D26 (ᴦ)
}; // 1

static const unsigned char vga_block27[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+1D28 (ᴨ)
}; // 1

static const unsigned char vga_block28[][16] = {
	{ 0x0c, 0x18, 0x00, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x77, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+1E80 (Ẁ)
	{ 0x00, 0x06, 0x0c, 0x18, 0x00, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+1E81 (ẁ)
	{ 0x18, 0x0c, 0x00, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x77, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+1E82 (Ẃ)
	{ 0x00, 0x18, 0x0c, 0x06, 0x00, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+1E83 (ẃ)
	{ 0x00, 0x63, 0x00, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x77, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+1E84 (Ẅ)
	{ 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+1E85 (ẅ)
}; // 6

static const unsigned char vga_block29[][16] = {
	{ 0x00, 0x00, 0x78, 0x0c, 0x18, 0x30, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+1E9F (ẟ)
}; // 1

static const unsigned char vga_block30[][16] = {
	{ 0x0c, 0x18, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+1EF2 (Ỳ)
	{ 0x00, 0x06, 0x0c, 0x18, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x30, 0x1f, 0x00 },	// U+1EF3 (ỳ)
}; // 2

static const unsigned char vga_block31[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2010 (‐)
}; // 1

static const unsigned char vga_block32[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2012 (‒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2013 (–)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2014 (—)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2015 (―)
}; // 4

static const unsigned char vga_block33[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00 },	// U+2017 (‗)
	{ 0x00, 0x18, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2018 (‘)
	{ 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2019 (’)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x00 },	// U+201A (‚)
	{ 0x00, 0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201B (‛)
	{ 0x00, 0x66, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201C (“)
	{ 0x00, 0x66, 0x66, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201D (”)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x33, 0x00 },	// U+201E („)
	{ 0x00, 0x33, 0x33, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201F (‟)
	{ 0x00, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+2020 (†)
	{ 0x00, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+2021 (‡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2022 (•)
}; // 12

static const unsigned char vga_block34[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00 },	// U+2026 (…)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2027 (‧)
}; // 2

static const unsigned char vga_block35[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x33, 0x18, 0x0c, 0x06, 0xdb, 0xd8, 0x00, 0x00, 0x00, 0x00 },	// U+2030 (‰)
}; // 1

static const unsigned char vga_block36[][16] = {
	{ 0x00, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2032 (′)
	{ 0x00, 0x6c, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2033 (″)
}; // 2

static const unsigned char vga_block37[][16] = {
	{ 0x00, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2035 (‵)
}; // 1

static const unsigned char vga_block38[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2039 (‹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+203A (›)
}; // 2

static const unsigned char vga_block39[][16] = {
	{ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+203C (‼)
}; // 1

static const unsigned char vga_block40[][16] = {
	{ 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+203E (‾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x3e, 0x00 },	// U+203F (‿)
	{ 0x00, 0x3e, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2040 (⁀)
}; // 3

static const unsigned char vga_block41[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+2044 (⁄)
}; // 1

static const unsigned char vga_block42[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x00 },	// U+2054 (⁔)
}; // 1

static const unsigned char vga_block43[][16] = {
	{ 0x00, 0x18, 0x1c, 0x1a, 0x1f, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2074 (⁴)
	{ 0x00, 0x1f, 0x03, 0x0f, 0x18, 0x18, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2075 (⁵)
	{ 0x00, 0x0e, 0x03, 0x0f, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2076 (⁶)
	{ 0x00, 0x1f, 0x19, 0x0c, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2077 (⁷)
	{ 0x00, 0x0e, 0x1b, 0x0e, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2078 (⁸)
	{ 0x00, 0x0e, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2079 (⁹)
	{ 0x00, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207A (⁺)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207B (⁻)
}; // 8

static const unsigned char vga_block44[][16] = {
	{ 0x00, 0x1b, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207F (ⁿ)
}; // 1

static const unsigned char vga_block45[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0e, 0x0c, 0x0c, 0x0c, 0x1e, 0x00 },	// U+2081 (₁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x0c, 0x06, 0x13, 0x1f, 0x00 },	// U+2082 (₂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x18, 0x0e, 0x18, 0x18, 0x0f, 0x00 },	// U+2083 (₃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1c, 0x1a, 0x1f, 0x18, 0x18, 0x00 },	// U+2084 (₄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x03, 0x0f, 0x18, 0x18, 0x0f, 0x00 },	// U+2085 (₅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x03, 0x0f, 0x1b, 0x1b, 0x0e, 0x00 },	// U+2086 (₆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x19, 0x0c, 0x06, 0x06, 0x06, 0x00 },	// U+2087 (₇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x0e, 0x1b, 0x1b, 0x0e, 0x00 },	// U+2088 (₈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00 },	// U+2089 (₉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x00 },	// U+208A (₊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+208B (₋)
}; // 11

static const unsigned char vga_block46[][16] = {
	{ 0x00, 0x00, 0x7f, 0x66, 0x46, 0x16, 0x1e, 0x16, 0x06, 0x0f, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+20A3 (₣)
	{ 0x00, 0x1c, 0x36, 0x26, 0x06, 0x0f, 0x06, 0x0f, 0x06, 0x06, 0x67, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+20A4 (₤)
}; // 2

static const unsigned char vga_block47[][16] = {
	{ 0x00, 0x1f, 0x33, 0x33, 0x1f, 0x23, 0x33, 0x7b, 0x33, 0x33, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+20A7 (₧)
}; // 1

static const unsigned char vga_block48[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x5f, 0x51, 0x55, 0x55, 0x55, 0x45, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20AA (₪)
}; // 1

static const unsigned char vga_block49[][16] = {
	{ 0x00, 0x00, 0x00, 0x38, 0x6c, 0x06, 0x3f, 0x06, 0x1f, 0x06, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+20AC (€)
}; // 1

static const unsigned char vga_block50[][16] = {
	{ 0x00, 0x06, 0x0b, 0x43, 0x6b, 0x36, 0x18, 0x0c, 0x06, 0x3b, 0x6d, 0x6c, 0x6c, 0x38, 0x00, 0x00 },	// U+2105 (℅)
}; // 1

static const unsigned char vga_block51[][16] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x36, 0x36, 0x36, 0x36, 0x1c, 0x0c, 0x5a, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2113 (ℓ)
}; // 1

static const unsigned char vga_block52[][16] = {
	{ 0x00, 0x00, 0xf1, 0xb3, 0xb7, 0xff, 0x3f, 0xfb, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+2116 (№)
}; // 1

static const unsigned char vga_block53[][16] = {
	{ 0x00, 0x8f, 0xda, 0xaa, 0x8a, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2122 (™)
}; // 1

static const unsigned char vga_block54[][16] = {
	{ 0x00, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x36, 0x36, 0x36, 0x36, 0x77, 0x00, 0x00, 0x00, 0x00 },	// U+2126 (Ω)
}; // 1

static const unsigned char vga_block55[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x7f, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+212E (℮)
}; // 1

static const unsigned char vga_block56[][16] = {
	{ 0x00, 0x03, 0x03, 0x43, 0x63, 0x33, 0x18, 0x0c, 0x06, 0x7b, 0x61, 0x30, 0x18, 0x18, 0x00, 0x00 },	// U+2150 (⅐)
	{ 0x00, 0x03, 0x03, 0x43, 0x63, 0x33, 0x18, 0x0c, 0x06, 0x3b, 0x6d, 0x78, 0x60, 0x38, 0x00, 0x00 },	// U+2151 (⅑)
}; // 2

static const unsigned char vga_block57[][16] = {
	{ 0x00, 0x03, 0x03, 0x43, 0x63, 0x33, 0x18, 0x0c, 0x06, 0x3b, 0x61, 0x38, 0x60, 0x38, 0x00, 0x00 },	// U+2153 (⅓)
	{ 0x00, 0x07, 0x0c, 0x46, 0x63, 0x3f, 0x18, 0x0c, 0x06, 0x3b, 0x61, 0x38, 0x60, 0x38, 0x00, 0x00 },	// U+2154 (⅔)
	{ 0x00, 0x03, 0x03, 0x43, 0x63, 0x33, 0x18, 0x0c, 0x06, 0x7b, 0x19, 0x38, 0x60, 0x38, 0x00, 0x00 },	// U+2155 (⅕)
	{ 0x00, 0x07, 0x0c, 0x46, 0x63, 0x3f, 0x18, 0x0c, 0x06, 0x7b, 0x19, 0x38, 0x60, 0x38, 0x00, 0x00 },	// U+2156 (⅖)
	{ 0x00, 0x07, 0x0c, 0x47, 0x6c, 0x37, 0x18, 0x0c, 0x06, 0x7b, 0x19, 0x38, 0x60, 0x38, 0x00, 0x00 },	// U+2157 (⅗)
	{ 0x00, 0x0c, 0x0e, 0x4d, 0x6f, 0x3c, 0x18, 0x0c, 0x06, 0x7b, 0x19, 0x38, 0x60, 0x38, 0x00, 0x00 },	// U+2158 (⅘)
	{ 0x00, 0x03, 0x03, 0x43, 0x63, 0x33, 0x18, 0x0c, 0x06, 0x3b, 0x0d, 0x3c, 0x6c, 0x38, 0x00, 0x00 },	// U+2159 (⅙)
	{ 0x00, 0x0f, 0x03, 0x47, 0x6c, 0x37, 0x18, 0x0c, 0x06, 0x3b, 0x0d, 0x3c, 0x6c, 0x38, 0x00, 0x00 },	// U+215A (⅚)
	{ 0x00, 0x03, 0x03, 0x43, 0x63, 0x33, 0x18, 0x0c, 0x06, 0x3b, 0x6d, 0x38, 0x6c, 0x38, 0x00, 0x00 },	// U+215B (⅛)
	{ 0x00, 0x07, 0x0c, 0x47, 0x6c, 0x37, 0x18, 0x0c, 0x06, 0x3b, 0x6d, 0x38, 0x6c, 0x38, 0x00, 0x00 },	// U+215C (⅜)
	{ 0x00, 0x0f, 0x03, 0x47, 0x6c, 0x37, 0x18, 0x0c, 0x06, 0x3b, 0x6d, 0x38, 0x6c, 0x38, 0x00, 0x00 },	// U+215D (⅝)
	{ 0x00, 0x0f, 0x0c, 0x46, 0x63, 0x33, 0x18, 0x0c, 0x06, 0x3b, 0x6d, 0x38, 0x6c, 0x38, 0x00, 0x00 },	// U+215E (⅞)
}; // 12

static const unsigned char vga_block58[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0x7f, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2190 (←)
	{ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2191 (↑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x7f, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2192 (→)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2193 (↓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x36, 0x7f, 0x36, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2194 (↔)
	{ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2195 (↕)
}; // 6

static const unsigned char vga_block59[][16] = {
	{ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+21A8 (↨)
}; // 1

static const unsigned char vga_block60[][16] = {
	{ 0x00, 0x00, 0x1c, 0x36, 0x60, 0x60, 0x7c, 0x66, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2202 (∂)
}; // 1

static const unsigned char vga_block61[][16] = {
	{ 0x00, 0x00, 0x00, 0xc0, 0x60, 0x7e, 0xdb, 0xdb, 0xcf, 0x7e, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2205 (∅)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2206 (∆)
}; // 2

static const unsigned char vga_block62[][16] = {
	{ 0x00, 0x00, 0x38, 0x0c, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+2208 (∈)
}; // 1

static const unsigned char vga_block63[][16] = {
	{ 0x00, 0x00, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00 },	// U+220F (∏)
}; // 1

static const unsigned char vga_block64[][16] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x63, 0x06, 0x0c, 0x18, 0x0c, 0x06, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+2211 (∑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2212 (−)
}; // 2

static const unsigned char vga_block65[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+2215 (∕)
}; // 1

static const unsigned char vga_block66[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2219 (∙)
	{ 0x00, 0xf0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x37, 0x36, 0x36, 0x3c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+221A (√)
}; // 2

static const unsigned char vga_block67[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xdb, 0xdb, 0xdb, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+221E (∞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+221F (∟)
}; // 2

static const unsigned char vga_block68[][16] = {
	{ 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+2229 (∩)
}; // 1

static const unsigned char vga_block69[][16] = {
	{ 0x70, 0xd8, 0xd8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x1b, 0x1b, 0x0e },	// U+222B (∫)
}; // 1

static const unsigned char vga_block70[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x6e, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2248 (≈)
}; // 1

static const unsigned char vga_block71[][16] = {
	{ 0x00, 0x00, 0x00, 0x60, 0x30, 0x7f, 0x18, 0x0c, 0x7f, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2260 (≠)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2261 (≡)
}; // 2

static const unsigned char vga_block72[][16] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2264 (≤)
	{ 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2265 (≥)
}; // 2

static const unsigned char vga_block73[][16] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2299 (⊙)
}; // 1

static const unsigned char vga_block74[][16] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2300 (⌀)
}; // 1

static const unsigned char vga_block75[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2302 (⌂)
}; // 1

static const unsigned char vga_block76[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2310 (⌐)
}; // 1

static const unsigned char vga_block77[][16] = {
	{ 0x00, 0x00, 0x70, 0xd8, 0xd8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2320 (⌠)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2321 (⌡)
}; // 2

static const unsigned char vga_block78[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2500 (─)
}; // 1

static const unsigned char vga_block79[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2502 (│)
}; // 1

static const unsigned char vga_block80[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+250C (┌)
}; // 1

static const unsigned char vga_block81[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2510 (┐)
}; // 1

static const unsigned char vga_block82[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2514 (└)
}; // 1

static const unsigned char vga_block83[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2518 (┘)
}; // 1

static const unsigned char vga_block84[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+251C (├)
}; // 1

static const unsigned char vga_block85[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2524 (┤)
}; // 1

static const unsigned char vga_block86[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+252C (┬)
}; // 1

static const unsigned char vga_block87[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2534 (┴)
}; // 1

static const unsigned char vga_block88[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+253C (┼)
}; // 1

static const unsigned char vga_block89[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2550 (═)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2551 (║)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2552 (╒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2553 (╓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x0c, 0xec, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2554 (╔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2555 (╕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2556 (╖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x60, 0x6f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2557 (╗)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2558 (╘)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2559 (╙)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xec, 0x0c, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255A (╚)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255B (╛)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255C (╜)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6f, 0x60, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255D (╝)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+255E (╞)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xec, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+255F (╟)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xec, 0x0c, 0xec, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2560 (╠)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2561 (╡)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2562 (╢)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6f, 0x60, 0x6f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2563 (╣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2564 (╤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2565 (╥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xef, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2566 (╦)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2567 (╧)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2568 (╨)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xef, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2569 (╩)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+256A (╪)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xff, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+256B (╫)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xef, 0x00, 0xef, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+256C (╬)
}; // 29

static const unsigned char vga_block90[][16] = {
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2580 (▀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff },	// U+2581 (▁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff },	// U+2582 (▂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2583 (▃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2584 (▄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2585 (▅)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2586 (▆)
	{ 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2587 (▇)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2588 (█)
	{ 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f },	// U+2589 (▉)
	{ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+258A (▊)
	{ 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f },	// U+258B (▋)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+258C (▌)
	{ 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+258D (▍)
	{ 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 },	// U+258E (▎)
	{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+258F (▏)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+2590 (▐)
	{ 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22 },	// U+2591 (░)
	{ 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55 },	// U+2592 (▒)
	{ 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee },	// U+2593 (▓)
	{ 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2594 (▔)
	{ 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },	// U+2595 (▕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00 },	// U+2596 (▖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00 },	// U+2597 (▗)
	{ 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2598 (▘)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2599 (▙)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+259A (▚)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+259B (▛)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+259C (▜)
	{ 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+259D (▝)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+259E (▞)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+259F (▟)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25A0 (■)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25A1 (□)
}; // 34

static const unsigned char vga_block91[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25AA (▪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x36, 0x36, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25AB (▫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+25AC (▬)
}; // 3

static const unsigned char vga_block92[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B2 (▲)
}; // 1

static const unsigned char vga_block93[][16] = {
	{ 0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x7f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+25BA (►)
}; // 1

static const unsigned char vga_block94[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25BC (▼)
}; // 1

static const unsigned char vga_block95[][16] = {
	{ 0x00, 0x40, 0x60, 0x70, 0x78, 0x7c, 0x7f, 0x7c, 0x78, 0x70, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+25C4 (◄)
}; // 1

static const unsigned char vga_block96[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x36, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25CA (◊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25CB (○)
}; // 2

static const unsigned char vga_block97[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25CF (●)
}; // 1

static const unsigned char vga_block98[][16] = {
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25D8 (◘)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25D9 (◙)
}; // 2

static const unsigned char vga_block99[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25E6 (◦)
}; // 1

static const unsigned char vga_block100[][16] = {
	{ 0x00, 0x00, 0x7e, 0x81, 0xa5, 0x81, 0x81, 0xbd, 0x99, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+263A (☺)
	{ 0x00, 0x00, 0x7e, 0xff, 0xdb, 0xff, 0xff, 0xc3, 0xe7, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+263B (☻)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0xdb, 0x3c, 0xe7, 0x3c, 0xdb, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+263C (☼)
}; // 3

static const unsigned char vga_block101[][16] = {
	{ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2640 (♀)
}; // 1

static const unsigned char vga_block102[][16] = {
	{ 0x00, 0x00, 0x78, 0x70, 0x58, 0x4c, 0x1e, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2642 (♂)
}; // 1

static const unsigned char vga_block103[][16] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2660 (♠)
}; // 1

static const unsigned char vga_block104[][16] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0xe7, 0xe7, 0xe7, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2663 (♣)
}; // 1

static const unsigned char vga_block105[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x7f, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2665 (♥)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2666 (♦)
}; // 2

static const unsigned char vga_block106[][16] = {
	{ 0x00, 0x00, 0xfc, 0xcc, 0xfc, 0x0c, 0x0c, 0x0c, 0x0c, 0x0e, 0x0f, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+266A (♪)
	{ 0x00, 0x00, 0xfe, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xe6, 0xe7, 0x67, 0x03, 0x00, 0x00, 0x00 },	// U+266B (♫)
}; // 2

static const unsigned char vga_block107[][16] = {
	{ 0x00, 0x60, 0x60, 0x60, 0x30, 0x30, 0x30, 0x30, 0x19, 0x1b, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2713 (✓)
}; // 1

static const unsigned char vga_block108[][16] = {
	{ 0x00, 0x00, 0x7c, 0x66, 0x06, 0x06, 0x7f, 0x66, 0x66, 0x66, 0x66, 0xef, 0x00, 0x00, 0x00, 0x00 },	// U+FB01 (ﬁ)
	{ 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x6f, 0x66, 0x66, 0x66, 0x66, 0xef, 0x00, 0x00, 0x00, 0x00 },	// U+FB02 (ﬂ)
}; // 2

static const unsigned char vga_block109[][16] = {
	{ 0xff, 0xff, 0xc1, 0x9c, 0x9c, 0xcf, 0xe7, 0xe7, 0xe7, 0xff, 0xe7, 0xe7, 0xff, 0xff, 0xff, 0xff },	// U+FFFD (�)
}; // 1

