/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font leggie-8x16v.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char veggie_block1[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0xfe, 0x6c, 0xfe, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x00, 0x30, 0x30, 0xfc, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0xc0, 0x7e, 0x18, 0x18, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x5b, 0x6e, 0x30, 0x18, 0x0c, 0x76, 0xda, 0x70, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x86, 0xc6, 0x76, 0xdc, 0x00, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x60, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x60 },	// U+0028 (()
	{ 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0c },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0xfe, 0x38, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0xfe, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x0c, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xce, 0xd6, 0xe6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x70, 0x78, 0x6c, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0xfe, 0x00, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0x78, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xe0, 0xf0, 0xd8, 0xcc, 0xfe, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x7e, 0xc0, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0x60, 0x30, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0x60, 0x30, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xf6, 0xfe, 0xce, 0xfe, 0x76, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0xe6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0x66, 0x36, 0x1e, 0x0e, 0x1e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xa6, 0x66, 0xdc, 0x00, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x78, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78 },	// U+005B ([)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0xc0, 0xc0, 0x00 },	// U+005C (\)
	{ 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c },	// U+005D (])
	{ 0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00 },	// U+005F (_)
	{ 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x78, 0x0c, 0x0c, 0x0c, 0x1c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+0067 (g)
	{ 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18 },	// U+006A (j)
	{ 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0xc6, 0x66, 0x36, 0x1e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xc6, 0x00, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x1e, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x60, 0x30, 0x18, 0x0c, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x60, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x60 },	// U+007B ({)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+007C (|)
	{ 0x00, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x70, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0c },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xd6, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
}; // 95

static const unsigned char veggie_block2[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x18, 0x18, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x0c, 0x0c, 0x3e, 0x0c, 0x0c, 0x0c, 0xfe, 0x00, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0xc6, 0x00, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0xfe, 0x38, 0xfe, 0x38, 0x00, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00A6 (¦)
	{ 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0xc0, 0xc0, 0xc0, 0x7e, 0x00 },	// U+00A7 (§)
	{ 0x00, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc3, 0xfb, 0xcf, 0xcf, 0xcf, 0xcf, 0xfb, 0xc3, 0x7e, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x6c, 0x36, 0x6c, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x00, 0x7e, 0xc3, 0xdf, 0xf7, 0xf7, 0xdf, 0xdf, 0xf7, 0xc3, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0xfe, 0x38, 0x38, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0x78, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x06 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0xde, 0xde, 0xde, 0xde, 0xdc, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x60, 0x3c },	// U+00B8 (¸)
	{ 0x00, 0x00, 0x40, 0x60, 0x70, 0x78, 0x6c, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x10, 0x18, 0x1c, 0x1e, 0x1b, 0x18, 0x18, 0x18, 0x80, 0xc0, 0xe0, 0xf0, 0xd8, 0xfc, 0xc0, 0xc0 },	// U+00BC (¼)
	{ 0x10, 0x18, 0x1c, 0x1e, 0x1b, 0x18, 0x18, 0x18, 0x7c, 0xc0, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0xfc },	// U+00BD (½)
	{ 0x1f, 0x30, 0x30, 0x1c, 0x30, 0x30, 0x30, 0x1f, 0x80, 0xc0, 0xe0, 0xf0, 0xd8, 0xfc, 0xc0, 0xc0 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x06, 0xfc, 0x00 },	// U+00BF (¿)
	{ 0x0c, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x38, 0x6c, 0xc6, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0xcc, 0xd6, 0x66, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x38, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x33, 0x33, 0x33, 0x73, 0x3f, 0x33, 0x33, 0xf3, 0x00, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x30, 0x60, 0x3c },	// U+00C7 (Ç)
	{ 0x0c, 0x18, 0x30, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x60, 0x30, 0x18, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x38, 0x6c, 0xc6, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x00, 0x6c, 0x6c, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x06, 0x0c, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x60, 0x30, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x18, 0x3c, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x00, 0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xdf, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0xcc, 0xd6, 0x66, 0x00, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x0c, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x38, 0x6c, 0xc6, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0xcc, 0xd6, 0x66, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+00D8 (Ø)
	{ 0x0c, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x60, 0x30, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x38, 0x6c, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x60, 0x30, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x78, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3e, 0x66, 0xc6, 0xc6, 0xc6, 0xce, 0x76, 0x00, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0xcc, 0xd6, 0x66, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x00, 0x38, 0x6c, 0x38, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd8, 0xd8, 0xfe, 0x1b, 0x1b, 0x7e, 0x00, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x30, 0x60, 0x3c },	// U+00E7 (ç)
	{ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x00, 0x58, 0x30, 0x68, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0xcc, 0xd6, 0x66, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0xcc, 0xd6, 0x66, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x00, 0xfe, 0x00, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xe6, 0xf6, 0xd6, 0xde, 0xce, 0x7e, 0x00, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+00FD (ý)
	{ 0x00, 0x00, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+00FF (ÿ)
	{ 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0101 (ā)
	{ 0xc6, 0xc6, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x00, 0xc6, 0xc6, 0x7c, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x60, 0x60, 0xc0 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x60, 0x60, 0xc0 },	// U+0105 (ą)
	{ 0x60, 0x30, 0x18, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x38, 0x6c, 0xc6, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x00, 0x30, 0x30, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+010B (ċ)
	{ 0xc6, 0x6c, 0x38, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+010D (č)
	{ 0xc6, 0x6c, 0x38, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x00, 0xc0, 0xf0, 0xf0, 0x70, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3e, 0x00, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xdf, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x00, 0xc0, 0xf8, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x00, 0x00, 0x7c, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+0113 (ē)
}; // 116

static const unsigned char veggie_block3[][16] = {
	{ 0x00, 0x30, 0x30, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x60, 0x60, 0xc0 },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x60, 0x60, 0xc0 },	// U+0119 (ę)
	{ 0xc6, 0x6c, 0x38, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+011B (ě)
	{ 0x38, 0x6c, 0xc6, 0x00, 0xfc, 0x06, 0x06, 0x06, 0xe6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+011D (ĝ)
	{ 0xc6, 0xc6, 0x7c, 0x00, 0xfc, 0x06, 0x06, 0x06, 0xe6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x00, 0xc6, 0xc6, 0x7c, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+011F (ğ)
	{ 0x00, 0x30, 0x30, 0x00, 0xfc, 0x06, 0x06, 0x06, 0xe6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0xe6, 0xc6, 0xc6, 0xc6, 0xfc, 0x30, 0x60, 0x3c },	// U+0122 (Ģ)
	{ 0x00, 0x00, 0x60, 0x30, 0x30, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+0123 (ģ)
	{ 0x38, 0x6c, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x38, 0x6c, 0xc6, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xfe, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x00, 0x06, 0x3f, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0xcc, 0xd6, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x00, 0xcc, 0xd6, 0x66, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x00, 0x00, 0x7e, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+012B (ī)
}; // 22

static const unsigned char veggie_block4[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x18, 0x30 },	// U+012E (Į)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x60 },	// U+012F (į)
	{ 0x00, 0x18, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+0131 (ı)
}; // 4

static const unsigned char veggie_block5[][16] = {
	{ 0x30, 0x78, 0xcc, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18 },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0x66, 0x36, 0x1e, 0x0e, 0x1e, 0x36, 0x66, 0xd6, 0x30, 0x60, 0x3c },	// U+0136 (Ķ)
	{ 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0xc6, 0x66, 0x36, 0x1e, 0x36, 0x66, 0xd6, 0x30, 0x60, 0x3c },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x66, 0x36, 0x1e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x18, 0x0c, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x30, 0x18, 0x0c, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfe, 0x38, 0x60, 0x3c },	// U+013B (Ļ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x78, 0x38, 0x60, 0x3c },	// U+013C (ļ)
	{ 0x00, 0x00, 0x60, 0x60, 0x66, 0x36, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x00, 0xc0, 0xcc, 0xcc, 0x6c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00 },	// U+013E (ľ)
}; // 11

static const unsigned char veggie_block6[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x36, 0x1e, 0x0e, 0x06, 0x07, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x6c, 0x3c, 0x1c, 0x0c, 0x0e, 0x0f, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x60, 0x30, 0x18, 0x00, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xd6, 0x30, 0x60, 0x3c },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0x30, 0x60, 0x3c },	// U+0146 (ņ)
	{ 0xc6, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0148 (ň)
}; // 8

static const unsigned char veggie_block7[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0xc0, 0xc0, 0x60 },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc0, 0xc0, 0x60 },	// U+014B (ŋ)
	{ 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+014D (ō)
}; // 4

static const unsigned char veggie_block8[][16] = {
	{ 0xd8, 0x6c, 0x36, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x00, 0xd8, 0x6c, 0x36, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x33, 0x33, 0x33, 0x73, 0x33, 0x33, 0x33, 0xfe, 0x00, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xdb, 0xdb, 0xfb, 0x1b, 0x1b, 0x7e, 0x00, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x60, 0x30, 0x18, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xf6, 0x1e, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x36, 0x66, 0xd6, 0x30, 0x60, 0x3c },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x1e, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x18, 0x0f },	// U+0157 (ŗ)
	{ 0xc6, 0x6c, 0x38, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0xf6, 0x1e, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x60, 0x30, 0x18, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xfc, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+015B (ś)
	{ 0x38, 0x6c, 0xc6, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x00, 0x38, 0x6c, 0xc6, 0x00, 0xfc, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0xc0, 0x7e, 0x30, 0x60, 0x3c },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x7e, 0x30, 0x60, 0x3c },	// U+015F (ş)
	{ 0xc6, 0x6c, 0x38, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0xfc, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x60, 0x3c },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x70, 0x30, 0x60, 0x3c },	// U+0163 (ţ)
	{ 0x66, 0x3c, 0x18, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x00, 0xc0, 0xcc, 0xcc, 0x6c, 0x0c, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x3c, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0xcc, 0xd6, 0x66, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x00, 0xcc, 0xd6, 0x66, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+016B (ū)
	{ 0xc6, 0xc6, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x00, 0xc6, 0xc6, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x38, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x00, 0x00, 0x38, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+016F (ů)
	{ 0xd8, 0x6c, 0x36, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x00, 0xd8, 0x6c, 0x36, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x30, 0x30, 0x60 },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x30, 0x30, 0x60 },	// U+0173 (ų)
	{ 0x38, 0x6c, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x38, 0x6c, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x78, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+0177 (ŷ)
	{ 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x78, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x60, 0x30, 0x18, 0x00, 0xfe, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xfe, 0x60, 0x30, 0x18, 0x0c, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+017A (ź)
	{ 0x00, 0x30, 0x30, 0x00, 0xfe, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0xfe, 0x60, 0x30, 0x18, 0x0c, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+017C (ż)
	{ 0xc6, 0x6c, 0x38, 0x00, 0xfe, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0xfe, 0x60, 0x30, 0x18, 0x0c, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+017E (ž)
}; // 47

static const unsigned char veggie_block9[][16] = {
	{ 0x00, 0x00, 0x78, 0x0c, 0x0c, 0x0c, 0x1c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x07, 0x00 },	// U+0192 (ƒ)
}; // 1

static const unsigned char veggie_block10[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0xc0, 0x7e, 0x18, 0x18, 0x0c },	// U+0218 (Ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x7e, 0x18, 0x18, 0x0c },	// U+0219 (ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0c },	// U+021A (Ț)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x70, 0x30, 0x30, 0x18 },	// U+021B (ț)
}; // 4

static const unsigned char veggie_block11[][16] = {
	{ 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C7 (ˇ)
}; // 1

static const unsigned char veggie_block12[][16] = {
	{ 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D8 (˘)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D9 (˙)
}; // 2

static const unsigned char veggie_block13[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x60 },	// U+02DB (˛)
}; // 1

static const unsigned char veggie_block14[][16] = {
	{ 0xd8, 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DD (˝)
}; // 1

static const unsigned char veggie_block15[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18 },	// U+037A (ͺ)
}; // 1

static const unsigned char veggie_block16[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00 },	// U+037E (;)
}; // 1

static const unsigned char veggie_block17[][16] = {
	{ 0x60, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0384 (΄)
	{ 0x18, 0x18, 0xdb, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0385 (΅)
	{ 0x00, 0x00, 0x03, 0x03, 0x7b, 0xcc, 0xcc, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00 },	// U+0386 (Ά)
}; // 3

static const unsigned char veggie_block18[][16] = {
	{ 0x00, 0x00, 0x03, 0x03, 0xff, 0x0c, 0x0c, 0x0c, 0x3c, 0x0c, 0x0c, 0x0c, 0xfc, 0x00, 0x00, 0x00 },	// U+0388 (Έ)
	{ 0x00, 0x00, 0x03, 0x03, 0xcf, 0xcc, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00 },	// U+0389 (Ή)
	{ 0x00, 0x00, 0x03, 0x03, 0x7b, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00 },	// U+038A (Ί)
}; // 3

static const unsigned char veggie_block19[][16] = {
	{ 0x00, 0x00, 0x03, 0x03, 0x7b, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00 },	// U+038C (Ό)
}; // 1

static const unsigned char veggie_block20[][16] = {
	{ 0x00, 0x00, 0x03, 0x03, 0xcf, 0xcc, 0xcc, 0x78, 0x70, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+038E (Ύ)
	{ 0x00, 0x00, 0x03, 0x03, 0x7b, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0xcc, 0x00, 0x00, 0x00 },	// U+038F (Ώ)
	{ 0x60, 0x30, 0x18, 0x66, 0x66, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00 },	// U+0390 (ΐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0391 (Α)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+0392 (Β)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0393 (Γ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00 },	// U+0394 (Δ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+0395 (Ε)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+0396 (Ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0397 (Η)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0398 (Θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+0399 (Ι)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0x66, 0x36, 0x1e, 0x0e, 0x1e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+039A (Κ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0x6c, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+039B (Λ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+039C (Μ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+039D (Ν)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x7c, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+039E (Ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+039F (Ο)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+03A0 (Π)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+03A1 (Ρ)
}; // 20

static const unsigned char veggie_block21[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x30, 0x18, 0x0c, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+03A3 (Σ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+03A4 (Τ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x78, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+03A5 (Υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x00, 0x00, 0x00 },	// U+03A6 (Φ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+03A7 (Χ)
	{ 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00 },	// U+03A8 (Ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0xee, 0x00, 0x00, 0x00 },	// U+03A9 (Ω)
	{ 0x00, 0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+03AA (Ϊ)
	{ 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x78, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+03AB (Ϋ)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0xdc, 0x00, 0x00, 0x00 },	// U+03AC (ά)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xfc, 0x06, 0x06, 0x3c, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+03AD (έ)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0 },	// U+03AE (ή)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00 },	// U+03AF (ί)
	{ 0x60, 0x30, 0x18, 0xc6, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+03B0 (ΰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0xdc, 0x00, 0x00, 0x00 },	// U+03B1 (α)
	{ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3e, 0x66, 0xc6, 0xc6, 0xc6, 0xc6, 0x76, 0x06, 0x06, 0x06 },	// U+03B2 (β)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0x38, 0x38, 0x38, 0x38 },	// U+03B3 (γ)
	{ 0x00, 0x00, 0xfc, 0x06, 0x06, 0x0c, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+03B4 (δ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x3c, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+03B5 (ε)
	{ 0x00, 0x00, 0xfe, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x00 },	// U+03B6 (ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0 },	// U+03B7 (η)
	{ 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+03B8 (θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00 },	// U+03B9 (ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x66, 0x36, 0x1e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+03BA (κ)
	{ 0x00, 0x00, 0x1c, 0x30, 0x30, 0x30, 0x38, 0x78, 0x6c, 0x6c, 0xcc, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+03BB (λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x06 },	// U+03BC (μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xcc, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00 },	// U+03BD (ν)
	{ 0x00, 0x00, 0xfc, 0x18, 0x0c, 0x0c, 0x78, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x00 },	// U+03BE (ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+03BF (ο)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xe6, 0x00, 0x00, 0x00 },	// U+03C0 (π)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06 },	// U+03C1 (ρ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x00 },	// U+03C2 (ς)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x66, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+03C3 (σ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00 },	// U+03C4 (τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+03C5 (υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10 },	// U+03C6 (φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xd8, 0xd8, 0xd8, 0x78, 0x3c, 0x36, 0x36, 0x36, 0xe6 },	// U+03C7 (χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10 },	// U+03C8 (ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0x6c, 0x00, 0x00, 0x00 },	// U+03C9 (ω)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00 },	// U+03CA (ϊ)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+03CB (ϋ)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+03CC (ό)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+03CD (ύ)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0x6c, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0x6c, 0x00, 0x00, 0x00 },	// U+03CE (ώ)
}; // 44

static const unsigned char veggie_block22[][16] = {
	{ 0x00, 0x6c, 0x6c, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+0401 (Ё)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x70, 0x00, 0x00 },	// U+0402 (Ђ)
	{ 0x60, 0x30, 0x18, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0403 (Ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+0404 (Є)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+0405 (Ѕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+0406 (І)
	{ 0x00, 0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+0407 (Ї)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0408 (Ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x7b, 0xdb, 0xdb, 0xdb, 0x79, 0x00, 0x00, 0x00 },	// U+0409 (Љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x7f, 0xdb, 0xdb, 0xdb, 0x7b, 0x00, 0x00, 0x00 },	// U+040A (Њ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+040B (Ћ)
	{ 0x60, 0x30, 0x18, 0x00, 0xc6, 0x66, 0x36, 0x1e, 0x0e, 0x1e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+040C (Ќ)
	{ 0x0c, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+040D (Ѝ)
	{ 0x00, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x78, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+040E (Ў)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x10, 0x10, 0x10 },	// U+040F (Џ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0410 (А)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+0411 (Б)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+0412 (В)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0413 (Г)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xfe, 0xc6, 0xc6, 0x00 },	// U+0414 (Д)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+0415 (Е)
	{ 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00 },	// U+0416 (Ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0x78, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+0417 (З)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0418 (И)
	{ 0x00, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0419 (Й)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0x66, 0x36, 0x1e, 0x0e, 0x1e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+041A (К)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xc6, 0x00, 0x00, 0x00 },	// U+041B (Л)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+041C (М)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+041D (Н)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+041E (О)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+041F (П)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0420 (Р)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+0421 (С)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0422 (Т)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x78, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0423 (У)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x00, 0x00, 0x00 },	// U+0424 (Ф)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0425 (Х)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x00 },	// U+0426 (Ц)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00 },	// U+0427 (Ч)
	{ 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x00, 0x00, 0x00 },	// U+0428 (Ш)
	{ 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0xc0, 0xc0, 0x00 },	// U+0429 (Щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0c, 0x0c, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x7c, 0x00, 0x00, 0x00 },	// U+042A (Ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xde, 0xf6, 0xf6, 0xf6, 0xde, 0x00, 0x00, 0x00 },	// U+042B (Ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+042C (Ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+042D (Э)
	{ 0x00, 0x00, 0x00, 0x00, 0x76, 0xde, 0xde, 0xde, 0xde, 0xde, 0xde, 0xde, 0x76, 0x00, 0x00, 0x00 },	// U+042E (Ю)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00 },	// U+042F (Я)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+0430 (а)
	{ 0x00, 0x00, 0x60, 0x3c, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+0431 (б)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0x7e, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+0432 (в)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0433 (г)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xfe, 0xc6, 0xc6, 0x00 },	// U+0434 (д)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+0435 (е)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00 },	// U+0436 (ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0x78, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+0437 (з)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0x00, 0x00, 0x00 },	// U+0438 (и)
	{ 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0x00, 0x00, 0x00 },	// U+0439 (й)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x66, 0x36, 0x1e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00 },	// U+043A (к)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xc6, 0x00, 0x00, 0x00 },	// U+043B (л)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+043C (м)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+043D (н)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+043E (о)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+043F (п)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06 },	// U+0440 (р)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+0441 (с)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0442 (т)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+0443 (у)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10 },	// U+0444 (ф)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+0445 (х)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xfe, 0xc0, 0xc0, 0x00 },	// U+0446 (ц)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00 },	// U+0447 (ч)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x00, 0x00, 0x00 },	// U+0448 (ш)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0xc0, 0xc0, 0x00 },	// U+0449 (щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0c, 0x0c, 0x7c, 0xcc, 0xcc, 0x7c, 0x00, 0x00, 0x00 },	// U+044A (ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xde, 0xf6, 0xf6, 0xde, 0x00, 0x00, 0x00 },	// U+044B (ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+044C (ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+044D (э)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xde, 0xde, 0xde, 0xde, 0xde, 0x76, 0x00, 0x00, 0x00 },	// U+044E (ю)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xfc, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00 },	// U+044F (я)
}; // 79

static const unsigned char veggie_block23[][16] = {
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00 },	// U+0451 (ё)
	{ 0x00, 0x00, 0x06, 0x3f, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc0, 0xc0, 0x60 },	// U+0452 (ђ)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0453 (ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x3e, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00 },	// U+0454 (є)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+0455 (ѕ)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+0456 (і)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+0457 (ї)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18 },	// U+0458 (ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1b, 0x1b, 0x7b, 0xdb, 0xdb, 0x79, 0x00, 0x00, 0x00 },	// U+0459 (љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x7f, 0xdb, 0xdb, 0x7b, 0x00, 0x00, 0x00 },	// U+045A (њ)
	{ 0x00, 0x00, 0x06, 0x3f, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+045B (ћ)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0x66, 0x36, 0x1e, 0x0e, 0x1e, 0x36, 0x66, 0x00, 0x00, 0x00 },	// U+045C (ќ)
	{ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0x00, 0x00, 0x00 },	// U+045D (ѝ)
	{ 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+045E (ў)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x10, 0x10, 0x10 },	// U+045F (џ)
}; // 15

static const unsigned char veggie_block24[][16] = {
	{ 0x00, 0x00, 0xc0, 0xc0, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0490 (Ґ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0491 (ґ)
}; // 2

static const unsigned char veggie_block25[][16] = {
	{ 0x00, 0x18, 0x18, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+1E02 (Ḃ)
	{ 0x06, 0x06, 0x00, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+1E03 (ḃ)
}; // 2

static const unsigned char veggie_block26[][16] = {
	{ 0x00, 0x18, 0x18, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00 },	// U+1E0A (Ḋ)
	{ 0xc0, 0xc0, 0x00, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00 },	// U+1E0B (ḋ)
}; // 2

static const unsigned char veggie_block27[][16] = {
	{ 0x00, 0x18, 0x18, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+1E1E (Ḟ)
	{ 0x30, 0x30, 0x00, 0x78, 0x0c, 0x0c, 0x1c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+1E1F (ḟ)
}; // 2

static const unsigned char veggie_block28[][16] = {
	{ 0x00, 0x30, 0x30, 0x00, 0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+1E40 (Ṁ)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x6e, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xc6, 0x00, 0x00, 0x00 },	// U+1E41 (ṁ)
}; // 2

static const unsigned char veggie_block29[][16] = {
	{ 0x00, 0x18, 0x18, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+1E56 (Ṗ)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06 },	// U+1E57 (ṗ)
}; // 2

static const unsigned char veggie_block30[][16] = {
	{ 0x00, 0x30, 0x30, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+1E60 (Ṡ)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0xfc, 0x06, 0x06, 0x7c, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00 },	// U+1E61 (ṡ)
}; // 2

static const unsigned char veggie_block31[][16] = {
	{ 0x00, 0x18, 0x18, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+1E6A (Ṫ)
	{ 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00 },	// U+1E6B (ṫ)
}; // 2

static const unsigned char veggie_block32[][16] = {
	{ 0x0c, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 0x00, 0x00 },	// U+1E80 (Ẁ)
	{ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 0x00, 0x00 },	// U+1E81 (ẁ)
	{ 0x60, 0x30, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 0x00, 0x00 },	// U+1E82 (Ẃ)
	{ 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 0x00, 0x00 },	// U+1E83 (ẃ)
	{ 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 0x00, 0x00 },	// U+1E84 (Ẅ)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 0x00, 0x00 },	// U+1E85 (ẅ)
}; // 6

static const unsigned char veggie_block33[][16] = {
	{ 0x0c, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x78, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+1EF2 (Ỳ)
	{ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x78 },	// U+1EF3 (ỳ)
}; // 2

static const unsigned char veggie_block34[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2015 (―)
}; // 1

static const unsigned char veggie_block35[][16] = {
	{ 0x00, 0x00, 0x30, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2018 (‘)
	{ 0x00, 0x00, 0x30, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2019 (’)
}; // 2

static const unsigned char veggie_block36[][16] = {
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201B (‛)
	{ 0x00, 0x00, 0x6c, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201C (“)
	{ 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201D (”)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x36, 0x00 },	// U+201E („)
	{ 0x00, 0x00, 0x36, 0x36, 0x36, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201F (‟)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00 },	// U+2020 (†)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x00 },	// U+2021 (‡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2022 (•)
}; // 8

static const unsigned char veggie_block37[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xdb, 0x00, 0x00, 0x00 },	// U+2026 (…)
}; // 1

static const unsigned char veggie_block38[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0xee, 0x78, 0x1e, 0x07, 0x6c, 0xd6, 0x6c, 0x00, 0x00, 0x00 },	// U+2030 (‰)
}; // 1

static const unsigned char veggie_block39[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00, 0x00 },	// U+203C (‼)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd8, 0xd8, 0x78, 0x38, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+203D (‽)
}; // 2

static const unsigned char veggie_block40[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207F (ⁿ)
}; // 1

static const unsigned char veggie_block41[][16] = {
	{ 0x00, 0x00, 0x60, 0x60, 0x6f, 0x7b, 0xfb, 0x7b, 0x7b, 0x6f, 0x63, 0x63, 0xc3, 0x00, 0x00, 0x00 },	// U+20A7 (₧)
}; // 1

static const unsigned char veggie_block42[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x0c, 0x0c, 0x7e, 0x0c, 0x3e, 0x0c, 0x0c, 0xf8, 0x00, 0x00, 0x00 },	// U+20AC (€)
}; // 1

static const unsigned char veggie_block43[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x7b, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x7f, 0x18, 0x18, 0x18 },	// U+20AF (₯)
}; // 1

static const unsigned char veggie_block44[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x19, 0x1b, 0x7b, 0xdf, 0xdf, 0xdf, 0x7b, 0x1b, 0xf3, 0x00, 0x00, 0x00 },	// U+2116 (№)
}; // 1

static const unsigned char veggie_block45[][16] = {
	{ 0x00, 0x9f, 0xf6, 0xf6, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2122 (™)
}; // 1

static const unsigned char veggie_block46[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0e, 0xff, 0xff, 0x0e, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2190 (←)
	{ 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00 },	// U+2191 (↑)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x70, 0xff, 0xff, 0x70, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2192 (→)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00 },	// U+2193 (↓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0xff, 0xff, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2194 (↔)
	{ 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0x38, 0x38, 0x38, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00 },	// U+2195 (↕)
}; // 6

static const unsigned char veggie_block47[][16] = {
	{ 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0x38, 0x38, 0x38, 0xfe, 0x7c, 0x38, 0xfe, 0x00, 0x00 },	// U+21A8 (↨)
}; // 1

static const unsigned char veggie_block48[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc8, 0xcc, 0xce, 0x7f, 0x0e, 0x0c, 0x08, 0x00, 0x00, 0x00 },	// U+21B5 (↵)
}; // 1

static const unsigned char veggie_block49[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2219 (∙)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x60, 0x60, 0x30, 0x30, 0x1b, 0x1e, 0x0c, 0x00, 0x00, 0x00 },	// U+221A (√)
}; // 2

static const unsigned char veggie_block50[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xdb, 0xdb, 0xdb, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+221E (∞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00 },	// U+221F (∟)
}; // 2

static const unsigned char veggie_block51[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00 },	// U+2229 (∩)
}; // 1

static const unsigned char veggie_block52[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x92, 0x6c, 0x92, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2248 (≈)
}; // 1

static const unsigned char veggie_block53[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x60, 0xfe, 0x38, 0xfe, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2260 (≠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2261 (≡)
}; // 2

static const unsigned char veggie_block54[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+2264 (≤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+2265 (≥)
}; // 2

static const unsigned char veggie_block55[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00 },	// U+2302 (⌂)
}; // 1

static const unsigned char veggie_block56[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2310 (⌐)
}; // 1

static const unsigned char veggie_block57[][16] = {
	{ 0x00, 0xf0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2320 (⌠)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0f, 0x00 },	// U+2321 (⌡)
}; // 2

static const unsigned char veggie_block58[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2500 (─)
}; // 1

static const unsigned char veggie_block59[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2502 (│)
}; // 1

static const unsigned char veggie_block60[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+250C (┌)
}; // 1

static const unsigned char veggie_block61[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2510 (┐)
}; // 1

static const unsigned char veggie_block62[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2514 (└)
}; // 1

static const unsigned char veggie_block63[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2518 (┘)
}; // 1

static const unsigned char veggie_block64[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+251C (├)
}; // 1

static const unsigned char veggie_block65[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2524 (┤)
}; // 1

static const unsigned char veggie_block66[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+252C (┬)
}; // 1

static const unsigned char veggie_block67[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2534 (┴)
}; // 1

static const unsigned char veggie_block68[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+253C (┼)
}; // 1

static const unsigned char veggie_block69[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2550 (═)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2551 (║)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2552 (╒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2553 (╓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x0c, 0xcc, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2554 (╔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2555 (╕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2556 (╖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x60, 0x67, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2557 (╗)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2558 (╘)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2559 (╙)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xcc, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255A (╚)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255B (╛)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255C (╜)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x67, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255D (╝)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+255E (╞)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xec, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+255F (╟)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xcc, 0x0c, 0xcc, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2560 (╠)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2561 (╡)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2562 (╢)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x67, 0x60, 0x67, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2563 (╣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2564 (╤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2565 (╥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xc7, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+2566 (╦)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2567 (╧)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2568 (╨)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xc7, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2569 (╩)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+256A (╪)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xef, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+256B (╫)
	{ 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xc7, 0x00, 0xc7, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c },	// U+256C (╬)
}; // 29

static const unsigned char veggie_block70[][16] = {
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2580 (▀)
}; // 1

static const unsigned char veggie_block71[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2584 (▄)
}; // 1

static const unsigned char veggie_block72[][16] = {
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2588 (█)
}; // 1

static const unsigned char veggie_block73[][16] = {
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+258C (▌)
}; // 1

static const unsigned char veggie_block74[][16] = {
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+2590 (▐)
	{ 0x00, 0x49, 0x00, 0x92, 0x00, 0x24, 0x00, 0x49, 0x00, 0x92, 0x00, 0x24, 0x00, 0x49, 0x00, 0x92 },	// U+2591 (░)
	{ 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa },	// U+2592 (▒)
	{ 0xff, 0xb6, 0xff, 0x6d, 0xff, 0xdb, 0xff, 0xb6, 0xff, 0x6d, 0xff, 0xdb, 0xff, 0xb6, 0xff, 0x6d },	// U+2593 (▓)
}; // 4

static const unsigned char veggie_block75[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25A0 (■)
}; // 1

static const unsigned char veggie_block76[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+25AC (▬)
}; // 1

static const unsigned char veggie_block77[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x3c, 0x3c, 0x7e, 0x7e, 0x7e, 0x7e, 0xff, 0xff, 0xff, 0xff },	// U+25B2 (▲)
}; // 1

static const unsigned char veggie_block78[][16] = {
	{ 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff, 0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01 },	// U+25B6 (▶)
}; // 1

static const unsigned char veggie_block79[][16] = {
	{ 0xff, 0xff, 0xff, 0xff, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18 },	// U+25BC (▼)
}; // 1

static const unsigned char veggie_block80[][16] = {
	{ 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff, 0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80 },	// U+25C0 (◀)
}; // 1

static const unsigned char veggie_block81[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25CB (○)
}; // 1

static const unsigned char veggie_block82[][16] = {
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25D8 (◘)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdb, 0xbd, 0xbd, 0xdb, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25D9 (◙)
}; // 2

static const unsigned char veggie_block83[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+263A (☺)
	{ 0x00, 0x00, 0x7c, 0xfe, 0x92, 0x92, 0xfe, 0xfe, 0xfe, 0xfe, 0x38, 0x38, 0x82, 0xfe, 0x7c, 0x00 },	// U+263B (☻)
	{ 0x00, 0x00, 0x00, 0x00, 0x48, 0x29, 0x1a, 0xe4, 0x27, 0x58, 0x94, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+263C (☼)
}; // 3

static const unsigned char veggie_block84[][16] = {
	{ 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2640 (♀)
}; // 1

static const unsigned char veggie_block85[][16] = {
	{ 0x00, 0x00, 0x00, 0xf8, 0xe0, 0xf0, 0xd8, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00 },	// U+2642 (♂)
}; // 1

static const unsigned char veggie_block86[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0xfe, 0x6c, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+2660 (♠)
}; // 1

static const unsigned char veggie_block87[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x6c, 0xfe, 0x6c, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+2663 (♣)
}; // 1

static const unsigned char veggie_block88[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+2665 (♥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+2666 (♦)
}; // 2

static const unsigned char veggie_block89[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x38, 0x78, 0xd8, 0xd8, 0x78, 0x1c, 0x1e, 0x0c, 0x00, 0x00, 0x00 },	// U+266A (♪)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0xfc, 0xcc, 0xcc, 0xcc, 0xcc, 0xce, 0xef, 0xf6, 0xe0, 0x00, 0x00 },	// U+266B (♫)
}; // 2

static const unsigned char veggie_block90[][16] = {
	{ 0x06, 0x06, 0x06, 0x06, 0x06, 0x30, 0x78, 0xfc, 0x30, 0x30, 0x18, 0x0c, 0x06, 0x06, 0x06, 0x06 },	// U+E0A0 ()
	{ 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7e, 0xcc, 0xcc, 0xdc, 0xdc, 0xec, 0xec, 0xcc, 0xcc },	// U+E0A1 ()
	{ 0x00, 0x38, 0x6c, 0x6c, 0x6c, 0x6c, 0xfe, 0xfe, 0xee, 0xee, 0xee, 0xfe, 0xfe, 0xfe, 0x7c, 0x00 },	// U+E0A2 ()
}; // 3

static const unsigned char veggie_block91[][16] = {
	{ 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff, 0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01 },	// U+E0B0 ()
	{ 0x01, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x01 },	// U+E0B1 ()
	{ 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff, 0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80 },	// U+E0B2 ()
	{ 0x80, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80 },	// U+E0B3 ()
}; // 4

static const unsigned char veggie_block92[][16] = {
	{ 0x00, 0x00, 0x10, 0x38, 0x7c, 0xc2, 0x9e, 0x9e, 0xce, 0xfe, 0xe6, 0xe6, 0x7c, 0x38, 0x10, 0x00 },	// U+FFFD (�)
}; // 1

static const unsigned char veggie_block93[][16] = {
	{ 0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xee, 0xee, 0xd6, 0xee, 0xee, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00 },	// U+FFFF (￿)
}; // 1

