/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font unifont-16x16.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const uint16_t unifontdw_block1[][16] = {
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8a52, 0x0a57, 0x8a5a, 0x7993, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0000 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xc99c, 0x4a43, 0xfa4c, 0x4a51, 0xc98e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0001 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xa5dc, 0x2483, 0x988c, 0x2491, 0xa48e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0002 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xa5de, 0x2483, 0x989e, 0x2483, 0xa49e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0003 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xfd9e, 0x1243, 0x925e, 0x1243, 0x919e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0004 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb25e, 0x4a43, 0xcade, 0x6b43, 0xf25e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0005 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xa58c, 0x1453, 0x8c5e, 0x1453, 0xa592, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0006 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8bce, 0x0853, 0x8bce, 0x0853, 0xfbce, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0007 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9c78, 0x0289, 0x8c78, 0x1089, 0x8e78, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0008 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9f44, 0x0445, 0x847c, 0x0445, 0x8444, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0009 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9f04, 0x0105, 0x9f04, 0x0105, 0x817c, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+000A (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9f44, 0x0445, 0x8444, 0x0429, 0x8410, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+000B (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9f7c, 0x0105, 0x9f7c, 0x0105, 0x8104, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+000C (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8f78, 0x1105, 0x8f04, 0x0905, 0x9178, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+000D (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8e78, 0x1105, 0x9138, 0x1141, 0x8e3c, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+000E (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9f78, 0x0405, 0x8438, 0x0441, 0x9f3c, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+000F (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb89c, 0x08a5, 0xb8a4, 0x08a5, 0xbb9c, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0010 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x918e, 0x1853, 0x9052, 0x1053, 0xb98e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0011 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x998e, 0x2053, 0x9052, 0x0853, 0xb98e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0012 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x998e, 0x2053, 0x9852, 0x2053, 0x998e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0013 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xa18e, 0x3053, 0xa852, 0x3853, 0xa18e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0014 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xc992, 0x2a57, 0x9a56, 0x2bdb, 0xca52, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0015 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xca2c, 0x5943, 0xe88c, 0x4891, 0xc88e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0016 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9dde, 0x2483, 0x9c9e, 0x2483, 0x9c9e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0017 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xa4cc, 0x2d23, 0xb5e2, 0x2523, 0xa52c, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0018 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x917c, 0x1b05, 0x957c, 0x1105, 0x917c, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0019 (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xba5c, 0x4a43, 0xba4c, 0x4a51, 0xb98e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+001A (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xf39e, 0x0843, 0x899e, 0x0a03, 0xf1de, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+001B (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8e78, 0x0109, 0x8678, 0x0809, 0x8708, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+001C (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8e70, 0x0109, 0x8668, 0x0849, 0x8770, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+001D (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8e38, 0x0149, 0x8638, 0x0829, 0x8748, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+001E (ESC)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8e48, 0x0149, 0x8648, 0x0849, 0x8730, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+001F (ESC)
}; // 32

static const uint16_t unifontdw_block2[][16] = {
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8bce, 0x0853, 0x8bd2, 0x0853, 0xfbce, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+007F ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb98e, 0x4a53, 0xcbce, 0x4a43, 0xba42, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0080 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb992, 0x4a53, 0xba5e, 0x0a53, 0x8992, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0081 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xc9ce, 0x4a53, 0xf9ce, 0x4853, 0xc84e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0082 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xc9d2, 0x4a57, 0xf9da, 0x4a53, 0xc9d2, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0083 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9d2e, 0x2565, 0xa5a4, 0x2525, 0x9d2e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0084 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8bd2, 0x0857, 0x8bda, 0x0853, 0xfbd2, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0085 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb39c, 0x4843, 0xf98c, 0x4a11, 0xc9ce, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0086 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb39e, 0x4843, 0xf99e, 0x4a03, 0xc9de, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0087 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb9d2, 0x0493, 0x989e, 0x2093, 0x9c92, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0088 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xbba4, 0x2125, 0xa13c, 0x2125, 0x9924, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0089 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb3a2, 0x0923, 0x9122, 0x2115, 0x9908, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+008A ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb84e, 0x4853, 0xc84e, 0x4843, 0xbbc2, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+008B ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xc84e, 0x4853, 0xc84e, 0x4843, 0xb3c2, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+008C ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8470, 0x0491, 0x8470, 0x0451, 0x8490, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+008D ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xbb9c, 0x4043, 0xb18c, 0x0a11, 0xf9ce, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+008E ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xbb9c, 0x4043, 0xb18c, 0x4211, 0xb9ce, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+008F ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xf38e, 0x0853, 0xb052, 0x4053, 0xbb8e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0090 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xa24e, 0x3253, 0xa24e, 0x2243, 0xf182, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0091 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xba4e, 0x4253, 0xb24e, 0x0a43, 0xf982, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0092 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb9dc, 0x0483, 0x988c, 0x2091, 0x9c8e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0093 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xcb9c, 0x4843, 0xf842, 0x4843, 0xcb9c, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0094 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9144, 0x116d, 0x9554, 0x1b45, 0x9144, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0095 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb1dc, 0x4a43, 0xf9cc, 0x4851, 0xc84e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0096 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xb1de, 0x4a43, 0xf9de, 0x4843, 0xc85e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0097 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xf19c, 0x0a43, 0xb24c, 0x4251, 0xb98e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0098 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xd9cc, 0x4423, 0xc5a4, 0x4529, 0xd9c6, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0099 ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xbb9c, 0x1043, 0x904c, 0x1051, 0xbb8e, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+009A ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xbb9c, 0x1043, 0x9182, 0x1203, 0xb9dc, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+009B ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9f70, 0x0409, 0x8430, 0x0441, 0x8438, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+009C ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xf38c, 0x0853, 0x8992, 0x0a13, 0xf1cc, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+009D ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x9138, 0x1b49, 0x9538, 0x1109, 0x9108, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+009E ()
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0xf1cc, 0x0a53, 0x89de, 0x0853, 0xf052, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+009F ()
}; // 33

static const uint16_t unifontdw_block3[][16] = {
	{ 0x5555, 0x8000, 0x0001, 0xc65c, 0x2a43, 0x93cc, 0x1251, 0x924e, 0x0001, 0x8000, 0x0001, 0x83c0, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+00AD (­)
}; // 1

static const uint16_t unifontdw_block4[][16] = {
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x439d, 0xc042, 0x4743, 0xd442, 0x239d, 0x8000, 0x0241, 0x8000, 0x0421, 0x8000, 0x0241, 0xaaaa },	// U+034F (͏)
}; // 1

static const uint16_t unifontdw_block5[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x300c, 0x0ff0 },	// U+035C (͜)
	{ 0x0000, 0x4002, 0x300c, 0x0ff0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+035D (͝)
	{ 0x0000, 0x0000, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+035E (͞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8 },	// U+035F (͟)
	{ 0x0000, 0x4078, 0x2184, 0x1e02, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0360 (͠)
	{ 0x0000, 0x0ff0, 0x300c, 0x4002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0361 (͡)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x3000, 0x7ffe, 0x3000, 0x1000 },	// U+0362 (͢)
}; // 7

static const uint16_t unifontdw_block6[][16] = {
	{ 0x0000, 0x7ffe, 0x71ce, 0x6fb6, 0x63b6, 0x6fb6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x73de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0378 (͸)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6fb6, 0x63b6, 0x6fb6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x63de, 0x6fee, 0x73ee, 0x7ffe, 0x0000 },	// U+0379 (͹)
}; // 2

static const uint16_t unifontdw_block7[][16] = {
	{ 0x0000, 0x7ffe, 0x71ce, 0x6fb6, 0x63b6, 0x6fb6, 0x71ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6dce, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0380 (΀)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6fb6, 0x63b6, 0x6fb6, 0x71ce, 0x7ffe, 0x7ffe, 0x77ce, 0x73b6, 0x77ce, 0x77b6, 0x63ce, 0x7ffe, 0x0000 },	// U+0381 (΁)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6fb6, 0x63b6, 0x6fb6, 0x71ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x61ce, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+0382 (΂)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6fb6, 0x63b6, 0x6fb6, 0x71ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6fb6, 0x63ce, 0x6fb6, 0x71ce, 0x7ffe, 0x0000 },	// U+0383 (΃)
}; // 4

static const uint16_t unifontdw_block8[][16] = {
	{ 0x0000, 0x7ffe, 0x71ce, 0x6fb6, 0x63b6, 0x6fb6, 0x71ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x71ce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+038B (΋)
}; // 1

static const uint16_t unifontdw_block9[][16] = {
	{ 0x0000, 0x7ffe, 0x71ce, 0x6fb6, 0x63b6, 0x6fb6, 0x71ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6dce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+038D (΍)
}; // 1

static const uint16_t unifontdw_block10[][16] = {
	{ 0x0000, 0x7ffe, 0x71ce, 0x6fb6, 0x63b6, 0x6fb6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6fb6, 0x6186, 0x7db6, 0x61b6, 0x7ffe, 0x0000 },	// U+03A2 (΢)
}; // 1

static const uint16_t unifontdw_block11[][16] = {
	{ 0x0000, 0x0000, 0x0080, 0x0140, 0x0808, 0x1414, 0x0000, 0x0000, 0x1002, 0x2805, 0x0000, 0x0000, 0x0000, 0x0808, 0x1494, 0x0140 },	// U+0488 (҈)
	{ 0x0000, 0x0000, 0x0100, 0x2108, 0x1190, 0x0c30, 0x0000, 0x0000, 0x1000, 0x700e, 0x0008, 0x0000, 0x0000, 0x1b30, 0x1110, 0x2108 },	// U+0489 (҉)
}; // 2

static const uint16_t unifontdw_block12[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x6230, 0x1228, 0x1228, 0x0a28, 0x07e4, 0x0624, 0x0a24, 0x1222, 0x2222, 0x427f, 0x0041, 0x0041 },	// U+052A (Ԫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6238, 0x1228, 0x0a24, 0x07e4, 0x0a22, 0x1222, 0x2222, 0x427e, 0x0042, 0x0000 },	// U+052B (ԫ)
}; // 2

static const uint16_t unifontdw_block13[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x73c6, 0x6dbe, 0x6d8e, 0x6dbe, 0x73c6, 0x7ffe, 0x0000 },	// U+0530 (԰)
}; // 1

static const uint16_t unifontdw_block14[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x7786, 0x7bbe, 0x7b86, 0x7ffe, 0x0000 },	// U+0557 (՗)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x7386, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+0558 (՘)
}; // 2

static const uint16_t unifontdw_block15[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x71ce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+058B (֋)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7dce, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+058C (֌)
	{ 0x0000, 0x0000, 0x0000, 0x03b0, 0x0c48, 0x1248, 0x1194, 0x0de4, 0x13e4, 0x13d8, 0x14c4, 0x0924, 0x0918, 0x06e0, 0x0000, 0x0000 },	// U+058D (֍)
	{ 0x0000, 0x0000, 0x0000, 0x06e0, 0x0918, 0x0924, 0x14c4, 0x13d8, 0x13e4, 0x0de4, 0x1194, 0x1248, 0x0c48, 0x03b0, 0x0000, 0x0000 },	// U+058E (֎)
}; // 4

static const uint16_t unifontdw_block16[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6d8e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+0590 (֐)
}; // 1

static const uint16_t unifontdw_block17[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x73f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+05C8 (׈)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x63f6, 0x6ff6, 0x738e, 0x7ffe, 0x0000 },	// U+05C9 (׉)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x618e, 0x6df6, 0x61f6, 0x6df6, 0x6d8e, 0x7ffe, 0x0000 },	// U+05CA (׊)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x71f6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+05CB (׋)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x638e, 0x7df6, 0x7df6, 0x7df6, 0x638e, 0x7ffe, 0x0000 },	// U+05CC (׌)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x6df6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+05CD (׍)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+05CE (׎)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+05CF (׏)
}; // 8

static const uint16_t unifontdw_block18[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+05EB (׫)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x6386, 0x7ffe, 0x0000 },	// U+05EC (׬)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+05ED (׭)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+05EE (׮)
}; // 4

static const uint16_t unifontdw_block19[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+05F5 (׵)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+05F6 (׶)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+05F7 (׷)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+05F8 (׸)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+05F9 (׹)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+05FA (׺)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+05FB (׻)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+05FC (׼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+05FD (׽)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+05FE (׾)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x61b6, 0x6fb6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+05FF (׿)
	{ 0xaaaa, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x2001, 0x9000, 0x1001, 0xbffc, 0x0001, 0x8000, 0x5555 },	// U+0600 (؀)
	{ 0xaaaa, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x2001, 0xb054, 0x3055, 0xafac, 0x0001, 0x8000, 0x5555 },	// U+0601 (؁)
	{ 0xaaaa, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0071, 0x9870, 0x07e1, 0x8000, 0x0001, 0x8000, 0x5555 },	// U+0602 (؂)
	{ 0xaaaa, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x9800, 0x2401, 0xa200, 0x2281, 0x9280, 0x0f79, 0x8000, 0x0001, 0x8000, 0x5555 },	// U+0603 (؃)
	{ 0xaaaa, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xa980, 0x3e41, 0x8040, 0x00fd, 0x8000, 0x5555 },	// U+0604 (؄)
	{ 0xaaaa, 0x0001, 0x8000, 0x2011, 0x9868, 0x0785, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x5555 },	// U+0605 (؅)
	{ 0x0000, 0x1500, 0x150e, 0x0b08, 0x0110, 0x0110, 0x0120, 0x0020, 0x0e40, 0x0240, 0x0280, 0x0180, 0x0180, 0x0080, 0x0080, 0x0000 },	// U+0606 (؆)
	{ 0x0400, 0x0200, 0x010e, 0x0508, 0x0210, 0x0910, 0x0620, 0x0020, 0x0e40, 0x0240, 0x0280, 0x0180, 0x0180, 0x0080, 0x0080, 0x0000 },	// U+0607 (؇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2600, 0x1970, 0x0d4c, 0x0a20, 0x0820, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0608 (؈)
}; // 20

static const uint16_t unifontdw_block20[][16] = {
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0300, 0x0480, 0x0700, 0x0400, 0x0380, 0x0878, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+060B (؋)
}; // 1

static const uint16_t unifontdw_block21[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0088, 0x6088, 0x1ff0, 0x0000, 0x0000, 0x0000 },	// U+060E (؎)
	{ 0x0000, 0x0000, 0x0000, 0x0060, 0x0010, 0x0010, 0x0060, 0x0010, 0x00c8, 0x0128, 0x0118, 0x0090, 0x0068, 0x0004, 0x0000, 0x0000 },	// U+060F (؏)
}; // 2

static const uint16_t unifontdw_block22[][16] = {
	{ 0x0000, 0x0c00, 0x0200, 0x1e40, 0x01c0, 0x0020, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0611 (ؑ)
	{ 0x0000, 0x11f8, 0x1040, 0x0820, 0x0710, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0612 (ؒ)
	{ 0x0000, 0x1060, 0x1090, 0x089c, 0x0668, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0613 (ؓ)
	{ 0x0000, 0x0000, 0x1000, 0x13f8, 0x1400, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0614 (ؔ)
	{ 0x0000, 0x0020, 0x03a0, 0x0460, 0x03f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0615 (ؕ)
	{ 0x00a0, 0x00a0, 0x00a0, 0x00b0, 0x0008, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0616 (ؖ)
	{ 0x0000, 0x0100, 0x0000, 0x0100, 0x0100, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0617 (ؗ)
}; // 7

static const uint16_t unifontdw_block23[][16] = {
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x444d, 0xec52, 0x545f, 0xc452, 0x45d3, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+061C (؜)
	{ 0x0000, 0x7ffe, 0x73ce, 0x7db6, 0x71b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x71de, 0x6dce, 0x6dde, 0x6dde, 0x718e, 0x7ffe, 0x0000 },	// U+061D (؝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0000, 0x0280, 0x0000, 0x0000 },	// U+061E (؞)
}; // 3

static const uint16_t unifontdw_block24[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0400, 0x0400 },	// U+0656 (ٖ)
}; // 1

static const uint16_t unifontdw_block25[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x1800, 0x0600, 0x0180, 0x0060, 0x0010, 0x3fe0, 0x4002, 0x3ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06AA (ڪ)
}; // 1

static const uint16_t unifontdw_block26[][16] = {
	{ 0x1040, 0x3a40, 0x3ff0, 0x0008, 0x03f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06D6 (ۖ)
	{ 0x1240, 0x0440, 0x07f0, 0x0008, 0x03f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06D7 (ۗ)
	{ 0x0000, 0x0200, 0x0500, 0x0780, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06D8 (ۘ)
	{ 0x0110, 0x0120, 0x00c0, 0x0080, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06D9 (ۙ)
	{ 0x01f8, 0x0020, 0x0090, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06DA (ۚ)
}; // 5

static const uint16_t unifontdw_block27[][16] = {
	{ 0x0000, 0x1480, 0x1f90, 0x0090, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06DC (ۜ)
	{ 0x0000, 0x0000, 0x0380, 0x0c60, 0x17d0, 0x1830, 0x2008, 0x2008, 0x2008, 0x1830, 0x17d0, 0x0c60, 0x0380, 0x0000, 0x0000, 0x0000 },	// U+06DD (۝)
	{ 0x0000, 0x0100, 0x0280, 0x3ff8, 0x2828, 0x3018, 0x2388, 0x644c, 0xa44a, 0x644c, 0x2388, 0x3018, 0x2828, 0x3ff8, 0x0280, 0x0100 },	// U+06DE (۞)
}; // 3

static const uint16_t unifontdw_block28[][16] = {
	{ 0x0180, 0x01c0, 0x0040, 0x0040, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06E2 (ۢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1480, 0x1f90, 0x0090, 0x0060 },	// U+06E3 (ۣ)
}; // 2

static const uint16_t unifontdw_block29[][16] = {
	{ 0x0000, 0x0100, 0x0420, 0x0420, 0x07c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06E8 (ۨ)
	{ 0x0000, 0x0100, 0x0280, 0x0540, 0x0aa0, 0x1550, 0x2aa8, 0x5454, 0x2aa8, 0x2aa8, 0x2aa8, 0x2ba8, 0x2828, 0x2fe8, 0x600c, 0xfffe },	// U+06E9 (۩)
	{ 0x0080, 0x0140, 0x0220, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06EA (۪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0220, 0x0140, 0x0080 },	// U+06EB (۫)
	{ 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+06EC (۬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0080, 0x0080, 0x0100 },	// U+06ED (ۭ)
}; // 6

static const uint16_t unifontdw_block30[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x0080, 0x0410, 0x0e38, 0x0410, 0x0080, 0x01c0, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+0700 (܀)
	{ 0x0000, 0x0000, 0x0000, 0x0018, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0701 (܁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0702 (܂)
	{ 0x0000, 0x0000, 0x0000, 0x0018, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0703 (܃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0018 },	// U+0704 (܄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0066, 0x0066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0705 (܅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0006, 0x0000, 0x0000, 0x0060, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0706 (܆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0060, 0x0000, 0x0000, 0x0000, 0x0006, 0x0006, 0x0000, 0x0000, 0x0000 },	// U+0707 (܇)
	{ 0x0000, 0x0000, 0x0006, 0x0006, 0x0000, 0x0000, 0x0060, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0708 (܈)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0006, 0x0000, 0x0000, 0x0060, 0x0060 },	// U+0709 (܉)
	{ 0x0000, 0x0024, 0x0024, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0018 },	// U+070A (܊)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+070B (܋)
	{ 0x0000, 0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x2400, 0x3800, 0x3800, 0x3c00, 0x0000, 0x0000 },	// U+070C (܌)
	{ 0x0000, 0x0180, 0x0180, 0x1998, 0x1998, 0x0180, 0x0180, 0x7ffe, 0x7ffe, 0x0180, 0x0180, 0x1998, 0x1998, 0x0180, 0x0180, 0x0000 },	// U+070D (܍)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+070E (܎)
	{ 0x5555, 0x8000, 0x318d, 0xbffc, 0x318d, 0x8000, 0x0001, 0x8000, 0x44cd, 0xed22, 0x55e5, 0xc528, 0x4527, 0x8000, 0x0001, 0xaaaa },	// U+070F (܏)
	{ 0x0000, 0x0000, 0xe000, 0xe000, 0x7000, 0x3c00, 0x1ffe, 0x03ff, 0x0063, 0x00c3, 0x0383, 0x0f03, 0x0e02, 0x0000, 0x0000, 0x0000 },	// U+0710 (ܐ)
	{ 0x0040, 0x0030, 0x001e, 0x000a, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0711 (ܑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0ff0, 0x1fe0, 0x1000, 0x1006, 0x1006, 0x1ffe, 0x0ffc, 0x0000, 0x0000, 0x0000 },	// U+0712 (ܒ)
	{ 0x0000, 0x0060, 0x00e0, 0x00c0, 0x0180, 0x0180, 0x030e, 0x063e, 0x0cf0, 0x0fc0, 0x1f00, 0x3800, 0x6000, 0x0000, 0x0000, 0x0000 },	// U+0713 (ܓ)
	{ 0x0000, 0x0060, 0x00e0, 0x00c0, 0x0180, 0x0180, 0x03ce, 0x067e, 0x0cf0, 0x0fc0, 0x1f00, 0x3800, 0x6000, 0x0000, 0x0000, 0x0000 },	// U+0714 (ܔ)
	{ 0x0000, 0x0000, 0x0000, 0x00fc, 0x007c, 0x0070, 0x0060, 0x0060, 0x0060, 0x0060, 0x0064, 0x0060, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+0715 (ܕ)
	{ 0x0000, 0x0000, 0x0000, 0x00fc, 0x007c, 0x0070, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+0716 (ܖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ef8, 0x3ffc, 0x2106, 0x4102, 0x4102, 0x4082, 0x6086, 0x304c, 0x0000, 0x0000, 0x0000 },	// U+0717 (ܗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0330, 0x0618, 0x0408, 0x0c08, 0x0808, 0x1998, 0x19f0, 0x0000, 0x0000, 0x0000 },	// U+0718 (ܘ)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x0070, 0x0070, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+0719 (ܙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x30c0, 0x30c0, 0x6080, 0x4080, 0x4100, 0x4102, 0x2106, 0x3ffc, 0x1ef8, 0x0000, 0x0000 },	// U+071A (ܚ)
	{ 0x0000, 0x0030, 0x0070, 0x0060, 0x00c0, 0x0080, 0x0180, 0x0106, 0x1ffe, 0x3ffc, 0x4200, 0x4200, 0x4200, 0x2400, 0x1800, 0x0000 },	// U+071B (ܛ)
	{ 0x0000, 0x0030, 0x0070, 0x0060, 0x00c0, 0x0080, 0x0180, 0x0106, 0x1ffe, 0x3ffc, 0x4200, 0x5a00, 0x5a00, 0x2400, 0x1800, 0x0000 },	// U+071C (ܜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0018, 0x0030, 0x0030, 0x0030, 0x0018, 0x000c },	// U+071D (ܝ)
	{ 0x0000, 0x0040, 0x0000, 0x00a0, 0x0000, 0x03b8, 0x07fc, 0x0446, 0x2442, 0x4442, 0x4822, 0x4826, 0x3024, 0x0100, 0x0000, 0x0000 },	// U+071E (ܞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0618, 0x0e18, 0x1938, 0x1920, 0x11e0, 0x30c0, 0x2000, 0x2000, 0x4000, 0x4000, 0x8000 },	// U+071F (ܟ)
	{ 0x0000, 0x0000, 0x0070, 0x0070, 0x0060, 0x00c0, 0x0180, 0x0300, 0x0600, 0x0c0c, 0x0c0c, 0x0ffc, 0x0ff8, 0x0000, 0x0000, 0x0000 },	// U+0720 (ܠ)
	{ 0x0000, 0x0000, 0x0000, 0x000e, 0x007e, 0x1ff8, 0x3fc0, 0x20c0, 0x20c0, 0x20c0, 0x3fc0, 0x1f60, 0x0030, 0x0018, 0x0008, 0x0000 },	// U+0721 (ܡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0038, 0x007c, 0x01fc, 0x03e0, 0x0f00, 0x1800, 0x2000, 0x4000, 0x0000 },	// U+0722 (ܢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x003c, 0x1e66, 0x33c2, 0x2182, 0x2186, 0x118c, 0x0ff8, 0x07f0, 0x0000, 0x0000, 0x0000 },	// U+0723 (ܣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x003c, 0x1e66, 0x33c2, 0x2182, 0x2186, 0x118c, 0x0ff8, 0x07f0, 0x0180, 0x0180, 0x0000 },	// U+0724 (ܤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0180, 0x0306, 0x0606, 0x7ffe, 0x7ffc, 0x0000, 0x0000, 0x0000 },	// U+0725 (ܥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0c40, 0x0840, 0x1840, 0x1780, 0x3006, 0x2006, 0x7ffe, 0x7ffc, 0x0000, 0x0000, 0x0000 },	// U+0726 (ܦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x0118, 0x0108, 0x010c, 0x00f4, 0x3006, 0x3002, 0x3fff, 0x1fff, 0x0000, 0x0000, 0x0000 },	// U+0727 (ܧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1c00, 0x3ff0, 0x3ff8, 0x0008, 0x0030, 0x03c0, 0x0c00, 0x1800, 0x1c00, 0x0fff, 0x0000 },	// U+0728 (ܨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f80, 0x1fc0, 0x1040, 0x2040, 0x2040, 0x3fc8, 0x3fe8, 0x0030, 0x0000, 0x0000 },	// U+0729 (ܩ)
	{ 0x0040, 0x0000, 0x0000, 0x00fc, 0x007c, 0x0070, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+072A (ܪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0660, 0x0ff0, 0x0ff0, 0x07e0, 0x03c0, 0x6186, 0x7ffe, 0x7ffc, 0x0000, 0x0000, 0x0000 },	// U+072B (ܫ)
	{ 0x0000, 0x0006, 0x000e, 0x000c, 0x0310, 0x07a0, 0x0860, 0x0860, 0x1050, 0x1088, 0x3104, 0x31fc, 0x30f8, 0x0000, 0x0000, 0x0000 },	// U+072C (ܬ)
	{ 0x0000, 0x0000, 0x0400, 0x0600, 0x0300, 0x0180, 0x3fc0, 0x7fc0, 0x4000, 0x4000, 0x4006, 0x7ffe, 0x3ffc, 0x0000, 0x0000, 0x0000 },	// U+072D (ܭ)
	{ 0x0000, 0x00c0, 0x0180, 0x0198, 0x00f8, 0x0030, 0x0040, 0x0080, 0x0106, 0x023e, 0x07fc, 0x1fe0, 0x3800, 0x6000, 0x4000, 0x0000 },	// U+072E (ܮ)
	{ 0x0000, 0x0000, 0x0000, 0x00fc, 0x007c, 0x0070, 0x0060, 0x0060, 0x0060, 0x0060, 0x0062, 0x0060, 0x0048, 0x0000, 0x0000, 0x0000 },	// U+072F (ܯ)
	{ 0x007c, 0x0024, 0x0014, 0x000c, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0730 (ܰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0030, 0x0028, 0x0024, 0x003e },	// U+0731 (ܱ)
	{ 0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x0000 },	// U+0732 (ܲ)
	{ 0x0018, 0x0024, 0x0024, 0x0018, 0x0008, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0733 (ܳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0010, 0x0018, 0x0024, 0x0024, 0x0018 },	// U+0734 (ܴ)
	{ 0x0000, 0x0010, 0x0000, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0735 (ܵ)
	{ 0x0018, 0x0020, 0x0050, 0x0048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0736 (ܶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0024, 0x0014, 0x0008, 0x0030 },	// U+0737 (ܷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0024 },	// U+0738 (ܸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0004 },	// U+0739 (ܹ)
	{ 0x003e, 0x0008, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+073A (ܺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x007c, 0x0010, 0x007c },	// U+073B (ܻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008 },	// U+073C (ܼ)
	{ 0x0080, 0x0040, 0x00a0, 0x0110, 0x0248, 0x04a0, 0x0840, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+073D (ܽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0108, 0x0290, 0x0920, 0x0440, 0x0280, 0x0100, 0x0080 },	// U+073E (ܾ)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+073F (ܿ)
	{ 0x0000, 0x0000, 0x0000, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0740 (݀)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0741 (݁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0000 },	// U+0742 (݂)
	{ 0x0000, 0x0008, 0x0000, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0743 (݃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0000, 0x0008 },	// U+0744 (݄)
	{ 0x0000, 0x0008, 0x0000, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0745 (݅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014, 0x0000, 0x0008 },	// U+0746 (݆)
	{ 0x0000, 0x0000, 0x0010, 0x0008, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0747 (݇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x0008, 0x0010 },	// U+0748 (݈)
	{ 0x0480, 0x0b00, 0x1700, 0x2e80, 0x5d00, 0x3a00, 0x3400, 0x4800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0749 (݉)
	{ 0x002a, 0x0008, 0x003e, 0x0008, 0x002a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+074A (݊)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x71b6, 0x6db6, 0x7186, 0x6dbe, 0x71be, 0x7ffe, 0x0000 },	// U+074B (݋)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x63b6, 0x7db6, 0x7d86, 0x7dbe, 0x63be, 0x7ffe, 0x0000 },	// U+074C (݌)
	{ 0x0000, 0x1818, 0x1818, 0x1818, 0x0c30, 0x0c30, 0x0420, 0x0620, 0x0660, 0x0660, 0x0340, 0x0340, 0x03c0, 0x0180, 0x0180, 0x0000 },	// U+074D (ݍ)
	{ 0x0000, 0x0000, 0x3000, 0x6000, 0x6700, 0x3f00, 0x0c00, 0x0800, 0x1000, 0x1000, 0x2006, 0x7ffe, 0x7ffc, 0x0000, 0x0000, 0x0000 },	// U+074E (ݎ)
	{ 0x0000, 0x0180, 0x0180, 0x0300, 0x3400, 0x4c00, 0x4800, 0x3800, 0x1000, 0x1000, 0x2006, 0x7ffe, 0x7ffc, 0x0000, 0x0000, 0x0000 },	// U+074F (ݏ)
}; // 80

static const uint16_t unifontdw_block31[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1018, 0x0ff8, 0x0004, 0x0000, 0x0000, 0x0000 },	// U+0790 (ސ)
}; // 1

static const uint16_t unifontdw_block32[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0000, 0x0280, 0x1018, 0x0ff8, 0x0004, 0x0000, 0x0000, 0x0000 },	// U+079D (ޝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1018, 0x0ff8, 0x0004, 0x0080, 0x0000, 0x0000 },	// U+079E (ޞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x1018, 0x0ff8, 0x0004, 0x0000, 0x0000, 0x0000 },	// U+079F (ޟ)
}; // 3

static const uint16_t unifontdw_block33[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x61c6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+07B2 (޲)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x71c6, 0x6fb6, 0x63c6, 0x6fb6, 0x71c6, 0x7ffe, 0x0000 },	// U+07B3 (޳)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x6dc6, 0x6db6, 0x61c6, 0x6fb6, 0x6fc6, 0x7ffe, 0x0000 },	// U+07B4 (޴)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x61c6, 0x6fb6, 0x61c6, 0x7ffe, 0x0000 },	// U+07B5 (޵)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x73c6, 0x7db6, 0x71c6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+07B6 (޶)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x77c6, 0x7bb6, 0x7bc6, 0x7ffe, 0x0000 },	// U+07B7 (޷)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x73c6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+07B8 (޸)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x63c6, 0x6fb6, 0x73c6, 0x7ffe, 0x0000 },	// U+07B9 (޹)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61c6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+07BA (޺)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71c6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+07BB (޻)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7dc6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+07BC (޼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x6dc6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+07BD (޽)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71c6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+07BE (޾)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71c6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+07BF (޿)
}; // 14

static const uint16_t unifontdw_block34[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+07FB (߻)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6fb6, 0x77b6, 0x7bb6, 0x7bce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+07FC (߼)
}; // 2

static const uint16_t unifontdw_block35[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x0880, 0x0540, 0x0220, 0x2410, 0x1410, 0x0c08, 0x0408, 0x0230, 0x0000, 0x0000 },	// U+0800 (ࠀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0410, 0x07f0, 0x0800, 0x0800, 0x1000, 0x1ffc, 0x0000, 0x0000 },	// U+0801 (ࠁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x03e0, 0x0220, 0x0210, 0x0400, 0x0800, 0x0400, 0x0300, 0x0000, 0x0000 },	// U+0802 (ࠂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fc0, 0x0420, 0x0810, 0x0ff0, 0x1000, 0x1000, 0x0800, 0x0400, 0x0000, 0x0000 },	// U+0803 (ࠃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x03e0, 0x0320, 0x0290, 0x0640, 0x0920, 0x04a0, 0x0200, 0x0000, 0x0000 },	// U+0804 (ࠄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x05e0, 0x0920, 0x0090, 0x00c0, 0x0720, 0x0800, 0x0400, 0x0000, 0x0000 },	// U+0805 (ࠅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0638, 0x09c8, 0x0808, 0x0808, 0x0408, 0x0338, 0x0000, 0x0000 },	// U+0806 (ࠆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x03e0, 0x0320, 0x0290, 0x064c, 0x0930, 0x08a0, 0x0440, 0x0000, 0x0000 },	// U+0807 (ࠇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0020, 0x0f90, 0x0888, 0x0510, 0x0520, 0x0240, 0x0280, 0x0100, 0x0000, 0x0000 },	// U+0808 (ࠈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x09c0, 0x0920, 0x0920, 0x0490, 0x0490, 0x0490, 0x0000, 0x0000 },	// U+0809 (ࠉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1010, 0x1030, 0x0ff8, 0x0800, 0x0800, 0x0800, 0x0840, 0x09e0, 0x0ff0, 0x0000, 0x0000 },	// U+080A (ࠊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x00c0, 0x0020, 0x0010, 0x0810, 0x0c18, 0x0ff8, 0x0000, 0x0000 },	// U+080B (ࠋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1110, 0x1bb8, 0x1ff8, 0x1004, 0x1000, 0x0810, 0x0878, 0x0ffc, 0x0000, 0x0000 },	// U+080C (ࠌ)
	{ 0x0000, 0x0000, 0x0020, 0x0020, 0x0020, 0x0010, 0x0010, 0x0ff0, 0x0800, 0x0800, 0x0800, 0x0840, 0x09e0, 0x0ff0, 0x0000, 0x0000 },	// U+080D (ࠍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0050, 0x0398, 0x1e00, 0x0900, 0x0510, 0x06f8, 0x0080, 0x0040, 0x01e0, 0x0000 },	// U+080E (ࠎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0210, 0x0220, 0x0140, 0x0180, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+080F (ࠏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0800, 0x0800, 0x0800, 0x0840, 0x09e0, 0x0ff0, 0x0000, 0x0000 },	// U+0810 (ࠐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fc0, 0x0928, 0x0938, 0x0928, 0x04a0, 0x0498, 0x0490, 0x0000, 0x0000 },	// U+0811 (ࠑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x07e0, 0x0860, 0x0890, 0x0500, 0x0200, 0x0180, 0x0040, 0x0180, 0x0000 },	// U+0812 (ࠒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0ff0, 0x1000, 0x1000, 0x0800, 0x0400, 0x0000, 0x0000 },	// U+0813 (ࠓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1110, 0x1bb8, 0x1ff8, 0x2004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0814 (ࠔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0220, 0x2410, 0x1410, 0x0c08, 0x0408, 0x0230, 0x0000, 0x0000 },	// U+0815 (ࠕ)
	{ 0x0000, 0x0800, 0x0400, 0x1400, 0x4800, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0816 (ࠖ)
	{ 0x0000, 0x0800, 0x0800, 0x4800, 0x2800, 0x6800, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0817 (ࠗ)
	{ 0x0000, 0x3ff0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0818 (࠘)
	{ 0x0100, 0x0200, 0x0400, 0x0200, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0819 (࠙)
	{ 0x0000, 0x08e0, 0x0710, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+081A (ࠚ)
	{ 0x0000, 0x08e0, 0x0710, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+081B (ࠛ)
	{ 0x0000, 0x0022, 0x0022, 0x0014, 0x0014, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+081C (ࠜ)
	{ 0x0000, 0x0022, 0x0014, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+081D (ࠝ)
	{ 0x0000, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+081E (ࠞ)
	{ 0x0000, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+081F (ࠟ)
	{ 0x0000, 0x0008, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0820 (ࠠ)
	{ 0x0000, 0x01fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0821 (ࠡ)
	{ 0x0000, 0x00f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0822 (ࠢ)
	{ 0x0000, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0823 (ࠣ)
	{ 0x0000, 0x0100, 0x0100, 0x0080, 0x0080, 0x0040, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0824 (ࠤ)
	{ 0x0000, 0x0010, 0x0010, 0x0008, 0x0008, 0x0004, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0825 (ࠥ)
	{ 0x0000, 0x0008, 0x0008, 0x0014, 0x0014, 0x0022, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0826 (ࠦ)
	{ 0x0000, 0x0008, 0x0014, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0827 (ࠧ)
	{ 0x0000, 0x0100, 0x0080, 0x0040, 0x0080, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0828 (ࠨ)
	{ 0x0000, 0x00c0, 0x0030, 0x000c, 0x0030, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0829 (ࠩ)
	{ 0x0000, 0x0040, 0x0020, 0x0010, 0x0020, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+082A (ࠪ)
	{ 0x0000, 0x0008, 0x0008, 0x0014, 0x0014, 0x0022, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+082B (ࠫ)
	{ 0x0000, 0x0300, 0x0480, 0x0480, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+082C (ࠬ)
	{ 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+082D (࠭)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+082E (࠮)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x0000 },	// U+082F (࠯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0830 (࠰)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0831 (࠱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0832 (࠲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18fc, 0x180c, 0x0008, 0x0010, 0x0020, 0x0040, 0x0040, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+0833 (࠳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18fc, 0x180c, 0x0008, 0x0010, 0x0020, 0x1840, 0x1840, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+0834 (࠴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0000, 0x03c0, 0x0020, 0x0020, 0x00c0, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0835 (࠵)
	{ 0x0000, 0x0000, 0x0c00, 0x0c00, 0x0000, 0x0100, 0x0200, 0x0200, 0x0100, 0x0080, 0x0040, 0x0060, 0x07e0, 0x0000, 0x0000, 0x0000 },	// U+0836 (࠶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7e00, 0x0600, 0x0400, 0x09fe, 0x1000, 0x2000, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+0837 (࠷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x67fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0838 (࠸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x6000, 0x0000, 0x07fe, 0x0000, 0x6000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0839 (࠹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x67fe, 0x0000, 0x0000, 0x0000, 0x6000, 0x67fe, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+083A (࠺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0620, 0x0620, 0x0020, 0x0020, 0x0020, 0x0620, 0x0620, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+083B (࠻)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x0004, 0x0000, 0x0000, 0x0000 },	// U+083C (࠼)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0200, 0x0100, 0x1880, 0x1840, 0x0020, 0x0010, 0x1988, 0x1984, 0x0000, 0x0000, 0x0000 },	// U+083D (࠽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+083E (࠾)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7dbe, 0x718e, 0x7dbe, 0x7dc6, 0x7ffe, 0x0000 },	// U+083F (࠿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0410, 0x0410, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+0840 (ࡀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2100, 0x2080, 0x2040, 0x1fc0, 0x0200, 0x0400, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0841 (ࡁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0900, 0x0680, 0x0080, 0x0100, 0x0200, 0x0c00, 0x3ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0842 (ࡂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2800, 0x2400, 0x2200, 0x3e00, 0x2000, 0x2000, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0843 (ࡃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2a00, 0x2a00, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0844 (ࡄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x2000, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0845 (ࡅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0846 (ࡆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1020, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0847 (ࡇ)
	{ 0x0000, 0x0000, 0x0000, 0x0700, 0x0480, 0x0280, 0x0280, 0x0500, 0x0ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0848 (ࡈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0080, 0x0040, 0x0fc0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0849 (ࡉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0108, 0x0090, 0x0090, 0x0720, 0x0420, 0x0220, 0x0120, 0x0090, 0x0070, 0x0000, 0x0000 },	// U+084A (ࡊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1f80, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+084B (ࡋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2100, 0x2080, 0x2040, 0x3fc0, 0x2200, 0x2400, 0x23fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+084C (ࡌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0410, 0x0410, 0x0420, 0x0220, 0x0220, 0x0120, 0x0090, 0x0070, 0x0000, 0x0000 },	// U+084D (ࡍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x2100, 0x2200, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+084E (ࡎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0100, 0x0080, 0x1f80, 0x2000, 0x2000, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+084F (ࡏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0488, 0x0690, 0x0510, 0x0420, 0x0220, 0x0220, 0x0120, 0x0090, 0x0070, 0x0000, 0x0000 },	// U+0850 (ࡐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x5400, 0x5408, 0x7c10, 0x0410, 0x0420, 0x0220, 0x0220, 0x0120, 0x0090, 0x0070, 0x0000, 0x0000 },	// U+0851 (ࡑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2100, 0x2080, 0x2040, 0x3fc0, 0x2200, 0x2400, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0852 (ࡒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2100, 0x2080, 0x2040, 0x3fc0, 0x2000, 0x2000, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0853 (ࡓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1830, 0x2448, 0x2448, 0x1ab0, 0x0280, 0x0280, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+0854 (ࡔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2100, 0x3e00, 0x2400, 0x2400, 0x23f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0855 (ࡕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0840, 0x0420, 0x0210, 0x0ff0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0856 (ࡖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x0888, 0x0504, 0x0504, 0x39f8, 0x2100, 0x1100, 0x0900, 0x0480, 0x0380, 0x0000, 0x0000 },	// U+0857 (ࡗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0080, 0x0040, 0x0040, 0x0380, 0x0040, 0x0040, 0x0040, 0x0380, 0x0000, 0x0000, 0x0000 },	// U+0858 (ࡘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0240, 0x0000 },	// U+0859 (࡙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0000, 0x0000 },	// U+085A (࡚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0000 },	// U+085B (࡛)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7d86, 0x7dbe, 0x6386, 0x7ffe, 0x0000 },	// U+085C (࡜)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6d86, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+085D (࡝)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0660, 0x0810, 0x0990, 0x1248, 0x1248, 0x0990, 0x0810, 0x0660, 0x0180, 0x0000, 0x0000, 0x0000 },	// U+085E (࡞)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x7d86, 0x7ffe, 0x0000 },	// U+085F (࡟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0850, 0x0860, 0x0800, 0x0700, 0x0400, 0x0804, 0x0808, 0x0ff0, 0x0000, 0x0000 },	// U+0860 (ࡠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1094, 0x1094, 0x1008, 0x1000, 0x10f8, 0x1104, 0x0e02, 0x0002, 0x1ffc, 0x2400, 0x1800 },	// U+0861 (ࡡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0064, 0x2194, 0x5608, 0x4800, 0x3580, 0x0240, 0x0584, 0x0808, 0x0ff0, 0x0000, 0x0000 },	// U+0862 (ࡢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x7080, 0x2100, 0x2200, 0x1c00, 0x0000, 0x0000 },	// U+0863 (ࡣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0850, 0x0860, 0x0b00, 0x0480, 0x0700, 0x0804, 0x0808, 0x0ff0, 0x0000, 0x0000 },	// U+0864 (ࡤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0810, 0x0820, 0x0800, 0x0700, 0x0400, 0x0804, 0x0808, 0x0ff0, 0x0000, 0x0000 },	// U+0865 (ࡥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x1018, 0x1004, 0x0fc0, 0x0020, 0x0020, 0x0fc0, 0x1000, 0x1010, 0x0fe0, 0x0000, 0x0000 },	// U+0866 (ࡦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0100, 0x0200, 0x0200, 0x0200, 0x0100, 0x0080, 0x0060, 0x0018, 0x0000, 0x0000 },	// U+0867 (ࡧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0048, 0x0044, 0x0024, 0x0014, 0x000c, 0x1804, 0x2484, 0x2484, 0x1f78, 0x0000, 0x0000 },	// U+0868 (ࡨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x0008, 0x0010, 0x0010, 0x0010, 0x0010, 0x0c10, 0x1210, 0x1210, 0x1ff0, 0x0200, 0x0180 },	// U+0869 (ࡩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x1220, 0x1210, 0x0a08, 0x0408, 0x0a08, 0x0908, 0x1090, 0x1050, 0x0fe0, 0x0000, 0x0000 },	// U+086A (ࡪ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6df6, 0x71c6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+086B (࡫)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x63ce, 0x7df6, 0x7dc6, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+086C (࡬)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6df6, 0x6dc6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+086D (࡭)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+086E (࡮)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+086F (࡯)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x6dde, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0870 (ࡰ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x7786, 0x73be, 0x77de, 0x77ee, 0x63ee, 0x7ffe, 0x0000 },	// U+0871 (ࡱ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x61de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+0872 (ࡲ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x7186, 0x6fbe, 0x63de, 0x6fee, 0x71ee, 0x7ffe, 0x0000 },	// U+0873 (ࡳ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6dbe, 0x61de, 0x6fee, 0x6fee, 0x7ffe, 0x0000 },	// U+0874 (ࡴ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x61de, 0x6fee, 0x61ee, 0x7ffe, 0x0000 },	// U+0875 (ࡵ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x7386, 0x7dbe, 0x71de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0876 (ࡶ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x77de, 0x7bee, 0x7bee, 0x7ffe, 0x0000 },	// U+0877 (ࡷ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x73de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0878 (ࡸ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x63de, 0x6fee, 0x73ee, 0x7ffe, 0x0000 },	// U+0879 (ࡹ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x61de, 0x6dee, 0x6dee, 0x7ffe, 0x0000 },	// U+087A (ࡺ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x71de, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+087B (ࡻ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7dde, 0x7dee, 0x63ee, 0x7ffe, 0x0000 },	// U+087C (ࡼ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+087D (ࡽ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+087E (ࡾ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+087F (ࡿ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6dce, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0880 (ࢀ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x77ce, 0x73b6, 0x77ce, 0x77b6, 0x63ce, 0x7ffe, 0x0000 },	// U+0881 (ࢁ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x61ce, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+0882 (ࢂ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6fb6, 0x63ce, 0x6fb6, 0x71ce, 0x7ffe, 0x0000 },	// U+0883 (ࢃ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6dce, 0x6db6, 0x61ce, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0884 (ࢄ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x61ce, 0x6fb6, 0x61ce, 0x7ffe, 0x0000 },	// U+0885 (ࢅ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x73ce, 0x7db6, 0x71ce, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0886 (ࢆ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x77ce, 0x7bb6, 0x7bce, 0x7ffe, 0x0000 },	// U+0887 (ࢇ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x73ce, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0888 (࢈)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x63ce, 0x6fb6, 0x73ce, 0x7ffe, 0x0000 },	// U+0889 (ࢉ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6db6, 0x61ce, 0x6db6, 0x6dce, 0x7ffe, 0x0000 },	// U+088A (ࢊ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x71ce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+088B (ࢋ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7dce, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+088C (ࢌ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6dce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+088D (ࢍ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+088E (ࢎ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+088F (࢏)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6d8e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+0890 (࢐)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x77ce, 0x73b6, 0x778e, 0x77be, 0x63ce, 0x7ffe, 0x0000 },	// U+0891 (࢑)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x618e, 0x7dbe, 0x61ce, 0x7ffe, 0x0000 },	// U+0892 (࢒)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6fb6, 0x638e, 0x6fbe, 0x71ce, 0x7ffe, 0x0000 },	// U+0893 (࢓)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x6dce, 0x6db6, 0x618e, 0x6fbe, 0x6fce, 0x7ffe, 0x0000 },	// U+0894 (࢔)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x618e, 0x6fbe, 0x61ce, 0x7ffe, 0x0000 },	// U+0895 (࢕)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x73ce, 0x7db6, 0x718e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+0896 (࢖)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x778e, 0x7bbe, 0x7bce, 0x7ffe, 0x0000 },	// U+0897 (ࢗ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x738e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+0898 (࢘)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x638e, 0x6fbe, 0x73ce, 0x7ffe, 0x0000 },	// U+0899 (࢙)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6db6, 0x618e, 0x6dbe, 0x6dce, 0x7ffe, 0x0000 },	// U+089A (࢚)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x718e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+089B (࢛)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7d8e, 0x7dbe, 0x63ce, 0x7ffe, 0x0000 },	// U+089C (࢜)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6d8e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+089D (࢝)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x61ce, 0x7ffe, 0x0000 },	// U+089E (࢞)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x7dce, 0x7ffe, 0x0000 },	// U+089F (࢟)
}; // 160

static const uint16_t unifontdw_block36[][16] = {
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x61c6, 0x6fb6, 0x61c6, 0x7ffe, 0x0000 },	// U+08B5 (ࢵ)
}; // 1

static const uint16_t unifontdw_block37[][16] = {
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x73f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+08C8 (ࣈ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x63f6, 0x6ff6, 0x738e, 0x7ffe, 0x0000 },	// U+08C9 (ࣉ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x618e, 0x6df6, 0x61f6, 0x6df6, 0x6d8e, 0x7ffe, 0x0000 },	// U+08CA (࣊)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x71f6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+08CB (࣋)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x638e, 0x7df6, 0x7df6, 0x7df6, 0x638e, 0x7ffe, 0x0000 },	// U+08CC (࣌)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x6df6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+08CD (࣍)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+08CE (࣎)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+08CF (࣏)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x6db6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+08D0 (࣐)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x77c6, 0x73b6, 0x77b6, 0x77b6, 0x63c6, 0x7ffe, 0x0000 },	// U+08D1 (࣑)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x73b6, 0x6db6, 0x73ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x61b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+08D2 (࣒)
}; // 11

static const uint16_t unifontdw_block38[][16] = {
	{ 0x5040, 0x54d0, 0x56b6, 0x5080, 0x52a8, 0x4d74, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+08DA (ࣚ)
	{ 0xa015, 0xa010, 0xa052, 0xaa95, 0x966a, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+08DB (ࣛ)
	{ 0xa000, 0xa812, 0xa328, 0xaad1, 0x97ae, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+08DC (ࣜ)
	{ 0x0300, 0x00c0, 0x0029, 0x0052, 0x4080, 0x5592, 0x2b6d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+08DD (ࣝ)
	{ 0x0800, 0x0200, 0x0800, 0x1440, 0x1900, 0x1288, 0x0df0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+08DE (ࣞ)
	{ 0x0200, 0x0080, 0x0214, 0x2542, 0x56a0, 0x6444, 0x43ba, 0x3800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+08DF (ࣟ)
}; // 6

static const uint16_t unifontdw_block39[][16] = {
	{ 0x0380, 0x0440, 0x0120, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0900 (ऀ)
	{ 0x0120, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0901 (ँ)
	{ 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0902 (ं)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000 },	// U+0903 (ः)
	{ 0x0080, 0x3f00, 0x4000, 0xf380, 0x4440, 0x4800, 0x4800, 0x4600, 0x4820, 0x7820, 0x4840, 0x4440, 0x4380, 0x0000, 0x0000, 0x0000 },	// U+0904 (ऄ)
	{ 0x0000, 0x0000, 0x0000, 0xf380, 0x4440, 0x4800, 0x4800, 0x4600, 0x4820, 0x7820, 0x4840, 0x4440, 0x4380, 0x0000, 0x0000, 0x0000 },	// U+0905 (अ)
	{ 0x0000, 0x0000, 0x0000, 0xfe70, 0x2888, 0x2900, 0x2900, 0x28c0, 0x2904, 0x2f04, 0x2908, 0x2888, 0x2870, 0x0000, 0x0000, 0x0000 },	// U+0906 (आ)
	{ 0x0000, 0x0000, 0x0000, 0xfffc, 0x0200, 0x03c0, 0x0020, 0x0020, 0x03c0, 0x0400, 0x0800, 0x0980, 0x0780, 0x0200, 0x0400, 0x0800 },	// U+0907 (इ)
	{ 0x0700, 0x0880, 0x0100, 0xfffc, 0x0200, 0x03c0, 0x0020, 0x0020, 0x03c0, 0x0400, 0x0800, 0x0980, 0x0780, 0x0200, 0x0400, 0x0800 },	// U+0908 (ई)
	{ 0x0000, 0x0000, 0x0000, 0xfff8, 0x0800, 0x1000, 0x1020, 0x0c20, 0x1040, 0x1040, 0x1080, 0x0880, 0x0700, 0x0000, 0x0000, 0x0000 },	// U+0909 (उ)
	{ 0x0000, 0x0000, 0x0000, 0xfffc, 0x0200, 0x0400, 0x0408, 0x3308, 0x4c10, 0x4410, 0x4420, 0x4220, 0x21c0, 0x0000, 0x0000, 0x0000 },	// U+090A (ऊ)
	{ 0x0000, 0x0000, 0x0000, 0xfffe, 0x0100, 0x1978, 0x1f84, 0x0960, 0x1118, 0x0900, 0x0500, 0x2500, 0x1900, 0x0000, 0x0000, 0x0000 },	// U+090B (ऋ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0400, 0x0400, 0x0e38, 0x1144, 0x1084, 0x0804, 0x0408, 0x0410, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+090C (ऌ)
	{ 0x0880, 0x0700, 0x0000, 0xfff8, 0x0840, 0x0840, 0x0840, 0x0840, 0x0840, 0x0080, 0x0100, 0x0200, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+090D (ऍ)
	{ 0x0020, 0x07c0, 0x0800, 0xfff8, 0x0840, 0x0840, 0x0840, 0x0840, 0x0840, 0x0080, 0x0100, 0x0200, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+090E (ऎ)
	{ 0x0000, 0x0000, 0x0000, 0xfff8, 0x0840, 0x0840, 0x0840, 0x0840, 0x0840, 0x0080, 0x0100, 0x0200, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+090F (ए)
	{ 0x03e0, 0x0400, 0x0800, 0xfff8, 0x0840, 0x0840, 0x0840, 0x0840, 0x0840, 0x0080, 0x0100, 0x0200, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+0910 (ऐ)
	{ 0x0880, 0x0700, 0x0000, 0xfe70, 0x2888, 0x2900, 0x2900, 0x28c0, 0x2904, 0x2f04, 0x2908, 0x2888, 0x2870, 0x0000, 0x0000, 0x0000 },	// U+0911 (ऑ)
	{ 0x0010, 0x1fe0, 0x2000, 0xfe70, 0x2888, 0x2900, 0x2900, 0x28c0, 0x2904, 0x2f04, 0x2908, 0x2888, 0x2870, 0x0000, 0x0000, 0x0000 },	// U+0912 (ऒ)
	{ 0x0fe0, 0x1000, 0x2000, 0xfe70, 0x2888, 0x2900, 0x2900, 0x28c0, 0x2904, 0x2f04, 0x2908, 0x2888, 0x2870, 0x0000, 0x0000, 0x0000 },	// U+0913 (ओ)
	{ 0x1f80, 0x2000, 0x3f00, 0xfc70, 0x2888, 0x2900, 0x2900, 0x28c0, 0x2904, 0x2f04, 0x2908, 0x2888, 0x2870, 0x0000, 0x0000, 0x0000 },	// U+0914 (औ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0100, 0x0100, 0x0d70, 0x1388, 0x1188, 0x1170, 0x0900, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+0915 (क)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0810, 0x0810, 0x0b90, 0x0c58, 0x0c58, 0x0b88, 0x0810, 0x0c20, 0x0bc0, 0x0000, 0x0000, 0x0000 },	// U+0916 (ख)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0840, 0x0840, 0x0840, 0x0850, 0x0860, 0x0840, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+0917 (ग)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1010, 0x1060, 0x1180, 0x1040, 0x1020, 0x1820, 0x17c0, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+0918 (घ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0100, 0x01c0, 0x0020, 0x1820, 0x19c8, 0x0208, 0x0210, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000 },	// U+0919 (ङ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x1ff0, 0x1840, 0x1640, 0x1180, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+091A (च)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0200, 0x0660, 0x0910, 0x0a10, 0x0460, 0x0c10, 0x1210, 0x1220, 0x11c0, 0x0800, 0x0000, 0x0000 },	// U+091B (छ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x1e10, 0x1210, 0x1220, 0x11c0, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+091C (ज)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1080, 0x10e0, 0x1010, 0x1010, 0x1fe0, 0x1080, 0x1080, 0x1070, 0x1030, 0x0040, 0x0080, 0x0000 },	// U+091D (झ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x13c0, 0x14c8, 0x1408, 0x1c10, 0x1410, 0x1220, 0x11c0, 0x0000, 0x0000, 0x0000 },	// U+091E (ञ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0100, 0x0100, 0x01c0, 0x0020, 0x0010, 0x0010, 0x1010, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+091F (ट)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0100, 0x0100, 0x07c0, 0x0820, 0x1010, 0x1010, 0x1010, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+0920 (ठ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0400, 0x0700, 0x0080, 0x0080, 0x0720, 0x0820, 0x0840, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000 },	// U+0921 (ड)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0100, 0x0100, 0x01c0, 0x0020, 0x0610, 0x0910, 0x0910, 0x0a20, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+0922 (ढ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0920, 0x0920, 0x0920, 0x0920, 0x08c0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+0923 (ण)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0fc0, 0x0820, 0x0810, 0x0810, 0x0810, 0x0820, 0x0840, 0x0000, 0x0000, 0x0000 },	// U+0924 (त)
	{ 0x0000, 0x0000, 0x0000, 0xfc30, 0x1048, 0x1088, 0x1090, 0x1080, 0x1040, 0x1830, 0x1410, 0x1220, 0x11c0, 0x0000, 0x0000, 0x0000 },	// U+0925 (थ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0100, 0x0100, 0x01c0, 0x0020, 0x0010, 0x0010, 0x0c10, 0x0c20, 0x07c0, 0x0800, 0x1000, 0x0000 },	// U+0926 (द)
	{ 0x0000, 0x0000, 0x0000, 0xff30, 0x1048, 0x1028, 0x1010, 0x1030, 0x10e0, 0x1010, 0x1810, 0x17e0, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+0927 (ध)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x1fc0, 0x1060, 0x1060, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+0928 (न)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x1fc0, 0x1060, 0x1060, 0x1000, 0x1000, 0x1000, 0x1300, 0x0300, 0x0000, 0x0000 },	// U+0929 (ऩ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0810, 0x0810, 0x0810, 0x0c10, 0x0a20, 0x09c0, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+092A (प)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0208, 0x0208, 0x0208, 0x0e08, 0x1310, 0x12e0, 0x1200, 0x1200, 0x0a00, 0x0000, 0x0000, 0x0000 },	// U+092B (फ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0be0, 0x0c30, 0x0c50, 0x0a90, 0x09e0, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+092C (ब)
	{ 0x0000, 0x0000, 0x0000, 0xfe30, 0x1048, 0x1070, 0x1040, 0x1040, 0x1fe0, 0x1060, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+092D (भ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0820, 0x0820, 0x0820, 0x0820, 0x0ff0, 0x0830, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+092E (म)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0840, 0x0840, 0x0840, 0x0830, 0x0810, 0x0c10, 0x0be0, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+092F (य)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0040, 0x0040, 0x0040, 0x0060, 0x0060, 0x0080, 0x0100, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0930 (र)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0040, 0x0040, 0x0040, 0x0060, 0x0060, 0x0080, 0x0100, 0x0200, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+0931 (ऱ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x1c60, 0x1290, 0x1110, 0x1010, 0x1020, 0x10c0, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+0932 (ल)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0400, 0x0400, 0x0e30, 0x1148, 0x1108, 0x1088, 0x1148, 0x1248, 0x0c30, 0x0000, 0x0000, 0x0000 },	// U+0933 (ळ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0400, 0x0400, 0x0e30, 0x1148, 0x1108, 0x1088, 0x1148, 0x1248, 0x0c30, 0x0180, 0x0180, 0x0000 },	// U+0934 (ऴ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0be0, 0x0c10, 0x0c10, 0x0a10, 0x09e0, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+0935 (व)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0860, 0x0890, 0x0890, 0x08e0, 0x0880, 0x0880, 0x0870, 0x08b0, 0x0900, 0x0000, 0x0000, 0x0000 },	// U+0936 (श)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0830, 0x0850, 0x0890, 0x0d10, 0x0a20, 0x09c0, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+0937 (ष)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0820, 0x0820, 0x0820, 0x0820, 0x0ff0, 0x0830, 0x0820, 0x0840, 0x0880, 0x0000, 0x0000, 0x0000 },	// U+0938 (स)
	{ 0x0000, 0x0000, 0x0000, 0xfffc, 0x0200, 0x03c0, 0x0020, 0x0020, 0x01c0, 0x0220, 0x0220, 0x0040, 0x0080, 0x0100, 0x0000, 0x0000 },	// U+0939 (ह)
	{ 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+093A (ऺ)
	{ 0x0000, 0x4000, 0x4000, 0xf000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+093B (ऻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180 },	// U+093C (़)
	{ 0x0000, 0x0000, 0x0000, 0x0fc0, 0x0020, 0x0020, 0x00c0, 0x0300, 0x0400, 0x0400, 0x0408, 0x0230, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+093D (ऽ)
	{ 0x0000, 0x0000, 0x0000, 0xf000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+093E (ा)
	{ 0x03fc, 0x0402, 0x0002, 0x000f, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000 },	// U+093F (ि)
	{ 0x3fc0, 0x4020, 0x4000, 0xf000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+0940 (ी)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x0840, 0x0780 },	// U+0941 (ु)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x0820 },	// U+0942 (ू)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e00, 0x0100, 0x0e00 },	// U+0943 (ृ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0080, 0x0e80, 0x0100, 0x1e00 },	// U+0944 (ॄ)
	{ 0x0020, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0945 (ॅ)
	{ 0x0008, 0x00f0, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0946 (ॆ)
	{ 0x0078, 0x0080, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0947 (े)
	{ 0x01e0, 0x02f8, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0948 (ै)
	{ 0x8800, 0x9000, 0x6000, 0xf000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+0949 (ॉ)
	{ 0x0080, 0x3f00, 0x4000, 0xf000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+094A (ॊ)
	{ 0x1f80, 0x2000, 0x4000, 0xf000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+094B (ो)
	{ 0x3e00, 0x5f80, 0x6000, 0xf000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+094C (ौ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0800, 0x1000 },	// U+094D (्)
	{ 0x0000, 0x0000, 0x0000, 0x000f, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000 },	// U+094E (ॎ)
	{ 0x3e40, 0x5f80, 0x6000, 0xf000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+094F (ॏ)
	{ 0x0000, 0x1800, 0x1800, 0x4238, 0x3c44, 0x0080, 0x0080, 0x3060, 0x4882, 0x4982, 0x3684, 0x0044, 0x0038, 0x0000, 0x0000, 0x0000 },	// U+0950 (ॐ)
	{ 0x0180, 0x0180, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0951 (॑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0000 },	// U+0952 (॒)
	{ 0x0040, 0x0080, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0953 (॓)
	{ 0x0200, 0x0100, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0954 (॔)
	{ 0x0240, 0x0180, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0955 (ॕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x0420, 0x03c0 },	// U+0956 (ॖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1248, 0x0990, 0x07e0 },	// U+0957 (ॗ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0100, 0x0100, 0x0d70, 0x1388, 0x1188, 0x1170, 0x0900, 0x0130, 0x0130, 0x0000, 0x0000, 0x0000 },	// U+0958 (क़)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0810, 0x0810, 0x0b90, 0x0c58, 0x0c58, 0x0b88, 0x0810, 0x0c20, 0x0bc0, 0x0000, 0x00c0, 0x00c0 },	// U+0959 (ख़)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0840, 0x0840, 0x0840, 0x0850, 0x0860, 0x0840, 0x0800, 0x0800, 0x0980, 0x0180, 0x0000, 0x0000 },	// U+095A (ग़)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x1e10, 0x1210, 0x1220, 0x11c0, 0x1000, 0x1000, 0x1180, 0x0180, 0x0000, 0x0000 },	// U+095B (ज़)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0400, 0x0700, 0x0080, 0x0080, 0x0720, 0x0820, 0x0840, 0x0840, 0x0780, 0x0000, 0x0300, 0x0300 },	// U+095C (ड़)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0100, 0x0100, 0x01c0, 0x0020, 0x0610, 0x0910, 0x0910, 0x0a20, 0x07c0, 0x0000, 0x0180, 0x0180 },	// U+095D (ढ़)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0208, 0x0208, 0x0208, 0x0e08, 0x1310, 0x12e0, 0x1200, 0x1260, 0x0a60, 0x0000, 0x0000, 0x0000 },	// U+095E (फ़)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0840, 0x0840, 0x0840, 0x0830, 0x0810, 0x0c10, 0x0be0, 0x0800, 0x08c0, 0x00c0, 0x0000, 0x0000 },	// U+095F (य़)
	{ 0x0000, 0x0000, 0x0000, 0xfffe, 0x0100, 0x3178, 0x3f84, 0x1160, 0x1918, 0x0500, 0x1900, 0x4500, 0x3900, 0x0000, 0x0000, 0x0000 },	// U+0960 (ॠ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0400, 0x0400, 0x0e38, 0x1144, 0x1084, 0x0c04, 0x0208, 0x0c10, 0x2200, 0x1c00, 0x0000, 0x0000 },	// U+0961 (ॡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0770, 0x0488, 0x1810 },	// U+0962 (ॢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x0e30, 0x2948, 0x1888, 0x7010 },	// U+0963 (ॣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+0964 (।)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0000, 0x0000, 0x0000 },	// U+0965 (॥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+0966 (०)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0440, 0x0280, 0x0100, 0x0080, 0x0040, 0x0080, 0x0100, 0x0200, 0x0000, 0x0000 },	// U+0967 (१)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0800, 0x0800, 0x0800, 0x04c0, 0x03c0, 0x0080, 0x0100, 0x0200, 0x0400, 0x0000 },	// U+0968 (२)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0400, 0x0400, 0x0380, 0x0400, 0x0400, 0x0460, 0x03e0, 0x0080, 0x0100, 0x0000 },	// U+0969 (३)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0808, 0x0410, 0x0220, 0x0140, 0x0080, 0x0140, 0x0220, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+096A (४)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x0310, 0x0310, 0x01e0, 0x0200, 0x0200, 0x0400, 0x0400, 0x0800, 0x0800, 0x0000 },	// U+096B (५)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0020, 0x0020, 0x01c0, 0x0020, 0x0020, 0x0620, 0x07c0, 0x0100, 0x0080, 0x0000 },	// U+096C (६)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0880, 0x0890, 0x0c90, 0x0b10, 0x0820, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000 },	// U+096D (७)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0010, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+096E (८)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x01c0, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+096F (९)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0970 (॰)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0971 (ॱ)
	{ 0x4200, 0x4400, 0x3800, 0xf380, 0x4440, 0x4800, 0x4800, 0x4600, 0x4820, 0x7820, 0x4840, 0x4440, 0x4380, 0x0000, 0x0000, 0x0000 },	// U+0972 (ॲ)
	{ 0x0000, 0x4000, 0x4000, 0xf380, 0x4440, 0x4800, 0x4800, 0x4600, 0x4820, 0x7820, 0x4840, 0x4440, 0x4380, 0x0000, 0x0000, 0x0000 },	// U+0973 (ॳ)
	{ 0x0000, 0x4000, 0x4000, 0xfce0, 0x5110, 0x5200, 0x5200, 0x5180, 0x5208, 0x5e08, 0x5210, 0x5110, 0x50e0, 0x0000, 0x0000, 0x0000 },	// U+0974 (ॴ)
	{ 0x0480, 0x3900, 0x4e00, 0xf0e0, 0x5110, 0x5200, 0x5200, 0x5180, 0x5208, 0x5e08, 0x5210, 0x5110, 0x50e0, 0x0000, 0x0000, 0x0000 },	// U+0975 (ॵ)
	{ 0x0000, 0x0000, 0x0000, 0xf380, 0x4440, 0x4800, 0x4800, 0x4600, 0x4820, 0x7820, 0x4840, 0x4440, 0x4380, 0x0000, 0x2100, 0x1e00 },	// U+0976 (ॶ)
	{ 0x0000, 0x0000, 0x0000, 0xf380, 0x4440, 0x4800, 0x4800, 0x4600, 0x4820, 0x7820, 0x4840, 0x4440, 0x4380, 0x0900, 0x2640, 0x1f80 },	// U+0977 (ॷ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0020, 0x0020, 0x0020, 0x03f0, 0x0430, 0x0400, 0x0400, 0x0200, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+0978 (ॸ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x1e10, 0x1210, 0x1220, 0x11c0, 0x1000, 0x1618, 0x1618, 0x00c0, 0x00c0, 0x0000 },	// U+0979 (ॹ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0840, 0x0840, 0x08c0, 0x0930, 0x0a10, 0x0c10, 0x0be0, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+097A (ॺ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0840, 0x0840, 0x0840, 0x0850, 0x0860, 0x0840, 0x0800, 0x0800, 0x0ff0, 0x0000, 0x0000, 0x0000 },	// U+097B (ॻ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x1e10, 0x1210, 0x1220, 0x11c0, 0x1000, 0x1000, 0x1ff0, 0x0000, 0x0000, 0x0000 },	// U+097C (ॼ)
	{ 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1010, 0x1000, 0x1000, 0x0800, 0x0700, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+097D (ॽ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0400, 0x0700, 0x0080, 0x0080, 0x0720, 0x0820, 0x0840, 0x0780, 0x1fe0, 0x0000, 0x0000, 0x0000 },	// U+097E (ॾ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0be0, 0x0c30, 0x0c50, 0x0a90, 0x09e0, 0x0800, 0x0ff0, 0x0000, 0x0000, 0x0000 },	// U+097F (ॿ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0410, 0x0490, 0x0460, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x2400, 0x1800, 0x0000 },	// U+0980 (ঀ)
	{ 0x0100, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0981 (ঁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x2000, 0x4000, 0x8000, 0x8000, 0x0000, 0x0000 },	// U+0982 (ং)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x0000 },	// U+0983 (ঃ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x6dce, 0x6db6, 0x61ce, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0984 (঄)
	{ 0x0000, 0x0000, 0x0000, 0xfffc, 0x1000, 0x1188, 0x1248, 0x1448, 0x1408, 0x1410, 0x1410, 0x1a20, 0x11c0, 0x0000, 0x0000, 0x0000 },	// U+0985 (অ)
	{ 0x0000, 0x0000, 0x0000, 0xfffc, 0x5000, 0x5188, 0x5248, 0x5448, 0x5408, 0x5410, 0x5410, 0x5a20, 0x51c0, 0x0000, 0x0000, 0x0000 },	// U+0986 (আ)
	{ 0x0040, 0x0f80, 0x1000, 0xfffc, 0x0000, 0x03c0, 0x0420, 0x0820, 0x0800, 0x0600, 0x01e0, 0x00c0, 0x0300, 0x0c00, 0x0000, 0x0000 },	// U+0987 (ই)
	{ 0x0040, 0x0f80, 0x1000, 0xfffc, 0x0000, 0x1860, 0x0490, 0x0710, 0x0280, 0x0240, 0x0230, 0x0400, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+0988 (ঈ)
	{ 0x0040, 0x0f80, 0x1000, 0xfffc, 0x0200, 0x0200, 0x1a10, 0x1610, 0x1010, 0x1020, 0x1020, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000 },	// U+0989 (উ)
	{ 0x0040, 0x0f80, 0x1000, 0xfffc, 0x0200, 0x0200, 0x1a50, 0x1650, 0x1050, 0x1090, 0x10a0, 0x0f20, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+098A (ঊ)
	{ 0x0000, 0x0000, 0x0000, 0xf400, 0x1408, 0x1424, 0x1658, 0x1580, 0x1670, 0x1c0c, 0x1470, 0x1580, 0x1600, 0x0000, 0x0000, 0x0000 },	// U+098B (ঋ)
	{ 0x0000, 0x0000, 0x0000, 0x00c0, 0x0020, 0x0040, 0x0380, 0x0400, 0x08e0, 0x0910, 0x0a10, 0x0a20, 0x0600, 0x0100, 0x0000, 0x0000 },	// U+098C (ঌ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6dce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+098D (঍)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+098E (঎)
	{ 0x0000, 0x0000, 0x0000, 0x0700, 0x0880, 0x0840, 0x0848, 0x0888, 0x0808, 0x0808, 0x0b08, 0x0c90, 0x0860, 0x0000, 0x0000, 0x0000 },	// U+098F (এ)
	{ 0x0040, 0x0f80, 0x1000, 0x2700, 0x2880, 0x2840, 0x1848, 0x0888, 0x0808, 0x0808, 0x0b08, 0x0c90, 0x0860, 0x0000, 0x0000, 0x0000 },	// U+0990 (ঐ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x77ce, 0x73b6, 0x778e, 0x77be, 0x63ce, 0x7ffe, 0x0000 },	// U+0991 (঑)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x618e, 0x7dbe, 0x61ce, 0x7ffe, 0x0000 },	// U+0992 (঒)
	{ 0x0000, 0x0000, 0x0000, 0x0600, 0x0900, 0x1020, 0x1020, 0x0c20, 0x1040, 0x1040, 0x1080, 0x0880, 0x0700, 0x0000, 0x0000, 0x0000 },	// U+0993 (ও)
	{ 0x0000, 0x0780, 0x0800, 0x1180, 0x1240, 0x1408, 0x1408, 0x1308, 0x0c10, 0x0410, 0x0420, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+0994 (ঔ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0700, 0x0a80, 0x1240, 0x1230, 0x1208, 0x0a30, 0x0240, 0x0280, 0x0300, 0x0000, 0x0000, 0x0000 },	// U+0995 (ক)
	{ 0x0000, 0x0000, 0x0000, 0xf110, 0x12e0, 0x1200, 0x1200, 0x1180, 0x1060, 0x10f0, 0x1300, 0x1400, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+0996 (খ)
	{ 0x0000, 0x0000, 0x0000, 0xf3c0, 0x1420, 0x1810, 0x10f0, 0x1100, 0x1100, 0x1080, 0x1060, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+0997 (গ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1020, 0x1010, 0x1010, 0x1060, 0x1080, 0x1060, 0x1030, 0x17c0, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+0998 (ঘ)
	{ 0x0000, 0x0000, 0x0000, 0x0620, 0x0920, 0x0940, 0x0780, 0x0088, 0x0c88, 0x1710, 0x1010, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+0999 (ঙ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0010, 0x0030, 0x0030, 0x00d0, 0x0710, 0x0810, 0x0410, 0x0310, 0x00f0, 0x0000, 0x0000, 0x0000 },	// U+099A (চ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0010, 0x0070, 0x0390, 0x0490, 0x0460, 0x0200, 0x01f0, 0x0060, 0x0380, 0x0c00, 0x0000, 0x0000 },	// U+099B (ছ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0180, 0x0288, 0x0488, 0x1888, 0x1310, 0x0a10, 0x0a10, 0x0a20, 0x11c0, 0x0000, 0x0000, 0x0000 },	// U+099C (জ)
	{ 0x0000, 0x0000, 0x0000, 0xf7ff, 0x1600, 0x1500, 0x1480, 0x1460, 0x1418, 0x1460, 0x1480, 0x1d00, 0x1600, 0x0000, 0x0000, 0x0000 },	// U+099D (ঝ)
	{ 0x0000, 0x0000, 0x0000, 0x00c0, 0x0120, 0x0d10, 0x1310, 0x1120, 0x0900, 0x1108, 0x1308, 0x0d90, 0x0160, 0x0000, 0x0000, 0x0000 },	// U+099E (ঞ)
	{ 0x0040, 0x0f80, 0x1000, 0xffff, 0x0020, 0x0020, 0x0020, 0x0020, 0x0c20, 0x0c20, 0x0420, 0x0320, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+099F (ট)
	{ 0x0180, 0x0040, 0x0080, 0xffff, 0x0300, 0x0500, 0x0880, 0x0890, 0x0868, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+09A0 (ঠ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0200, 0x0200, 0x1a10, 0x1610, 0x1010, 0x1020, 0x1020, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000 },	// U+09A1 (ড)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0020, 0x0020, 0x0020, 0x0020, 0x0c20, 0x0c20, 0x0420, 0x0320, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+09A2 (ঢ)
	{ 0x0000, 0x0000, 0x0000, 0xf000, 0x13c0, 0x1420, 0x1810, 0x1070, 0x1060, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+09A3 (ণ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0000, 0x0710, 0x0890, 0x1090, 0x1010, 0x1020, 0x1020, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000 },	// U+09A4 (ত)
	{ 0x0000, 0x0000, 0x0000, 0xf1e0, 0x1210, 0x1210, 0x1200, 0x1180, 0x1060, 0x10f0, 0x1300, 0x1400, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+09A5 (থ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0010, 0x0010, 0x0c10, 0x0b10, 0x08d0, 0x0430, 0x0400, 0x0400, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+09A6 (দ)
	{ 0x0000, 0x0000, 0x0000, 0xf040, 0x1820, 0x1620, 0x11c0, 0x1060, 0x1018, 0x1060, 0x1180, 0x1600, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+09A7 (ধ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x1000, 0x13c0, 0x1420, 0x1810, 0x1070, 0x1060, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+09A8 (ন)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x7386, 0x6db6, 0x6386, 0x6fb6, 0x73b6, 0x7ffe, 0x0000 },	// U+09A9 (঩)
	{ 0x0000, 0x0000, 0x0000, 0xf3e0, 0x1410, 0x1818, 0x1820, 0x1640, 0x11e0, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+09AA (প)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0010, 0x0820, 0x1440, 0x1480, 0x0440, 0x0430, 0x0418, 0x05e0, 0x0600, 0x0000, 0x0000, 0x0000 },	// U+09AB (ফ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1800, 0x1600, 0x1180, 0x1060, 0x1018, 0x1060, 0x1180, 0x1600, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+09AC (ব)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0000, 0x0180, 0x09d0, 0x1450, 0x1390, 0x1020, 0x1020, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000 },	// U+09AD (ভ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1030, 0x1040, 0x1080, 0x1080, 0x10c0, 0x11a0, 0x1640, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+09AE (ম)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1010, 0x1020, 0x1040, 0x1080, 0x1040, 0x1030, 0x11c0, 0x1600, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+09AF (য)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1800, 0x1600, 0x1180, 0x1060, 0x1018, 0x1060, 0x1180, 0x1600, 0x18c0, 0x00c0, 0x0000, 0x0000 },	// U+09B0 (র)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x77c6, 0x73b6, 0x77c6, 0x77b6, 0x63c6, 0x7ffe, 0x0000 },	// U+09B1 (঱)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x1c60, 0x1290, 0x1110, 0x1010, 0x1010, 0x1060, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+09B2 (ল)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6fb6, 0x63c6, 0x6fb6, 0x71c6, 0x7ffe, 0x0000 },	// U+09B3 (঳)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x6dc6, 0x6db6, 0x61c6, 0x6fb6, 0x6fc6, 0x7ffe, 0x0000 },	// U+09B4 (঴)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x61c6, 0x6fb6, 0x61c6, 0x7ffe, 0x0000 },	// U+09B5 (঵)
	{ 0x0000, 0x0000, 0x0000, 0xf60f, 0x1950, 0x10a0, 0x11b0, 0x11b0, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+09B6 (শ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1010, 0x1020, 0x1040, 0x1180, 0x1640, 0x1830, 0x11c0, 0x1600, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+09B7 (ষ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1060, 0x1090, 0x1100, 0x1d00, 0x1200, 0x1110, 0x10e0, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+09B8 (স)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0000, 0x03e0, 0x0470, 0x0860, 0x0800, 0x0600, 0x01e0, 0x00c0, 0x0300, 0x0c00, 0x0000, 0x0000 },	// U+09B9 (হ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61c6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+09BA (঺)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71c6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+09BB (঻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000 },	// U+09BC (়)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x03c0, 0x04c0, 0x08c0, 0x0800, 0x0800, 0x0600, 0x01e0, 0x00c0, 0x0300, 0x0c00, 0x0000, 0x0000 },	// U+09BD (ঽ)
	{ 0x0000, 0x0000, 0x0000, 0xd000, 0x6000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+09BE (া)
	{ 0x0ffc, 0x1002, 0x0002, 0x0007, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000 },	// U+09BF (ি)
	{ 0x3ff0, 0x4008, 0x5ff0, 0xe000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+09C0 (ী)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1700, 0x0880, 0x1700 },	// U+09C1 (ু)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x3100, 0xce00 },	// U+09C2 (ূ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x1000, 0x0800, 0x1000 },	// U+09C3 (ৃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8000, 0x4000, 0x2000, 0x4000, 0x8000, 0x2000, 0x1000, 0x0800, 0x1000 },	// U+09C4 (ৄ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x61f6, 0x6ff6, 0x618e, 0x7ffe, 0x0000 },	// U+09C5 (৅)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x738e, 0x7df6, 0x71f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+09C6 (৆)
	{ 0x0000, 0x0000, 0x0000, 0x000f, 0x0004, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0007, 0x0006, 0x0000, 0x0000, 0x0000 },	// U+09C7 (ে)
	{ 0x0001, 0x0006, 0x0008, 0x000f, 0x0004, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0007, 0x0006, 0x0000, 0x0000, 0x0000 },	// U+09C8 (ৈ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x63f6, 0x6ff6, 0x738e, 0x7ffe, 0x0000 },	// U+09C9 (৉)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x618e, 0x6df6, 0x61f6, 0x6df6, 0x6d8e, 0x7ffe, 0x0000 },	// U+09CA (৊)
	{ 0x0000, 0x0000, 0x0000, 0xd00f, 0x6004, 0x4002, 0x4002, 0x4001, 0x4001, 0x4001, 0x4001, 0x4007, 0x4006, 0x0000, 0x0000, 0x0000 },	// U+09CB (ো)
	{ 0x0080, 0x3f00, 0x4000, 0xd00f, 0x6004, 0x4002, 0x4002, 0x4001, 0x4001, 0x4001, 0x4001, 0x4007, 0x4006, 0x0000, 0x0000, 0x0000 },	// U+09CC (ৌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0800, 0x1000 },	// U+09CD (্)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x01a0, 0x0020, 0x00c0, 0x0700, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+09CE (ৎ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+09CF (৏)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x6db6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+09D0 (৐)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x77c6, 0x73b6, 0x77b6, 0x77b6, 0x63c6, 0x7ffe, 0x0000 },	// U+09D1 (৑)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x61b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+09D2 (৒)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6fb6, 0x63b6, 0x6fb6, 0x71c6, 0x7ffe, 0x0000 },	// U+09D3 (৓)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x6dc6, 0x6db6, 0x61b6, 0x6fb6, 0x6fc6, 0x7ffe, 0x0000 },	// U+09D4 (৔)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x61b6, 0x6fb6, 0x61c6, 0x7ffe, 0x0000 },	// U+09D5 (৕)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x73c6, 0x7db6, 0x71b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+09D6 (৖)
	{ 0x0080, 0x3f00, 0x4000, 0xd000, 0x6000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+09D7 (ৗ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x73b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+09D8 (৘)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x63b6, 0x6fb6, 0x73c6, 0x7ffe, 0x0000 },	// U+09D9 (৙)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61b6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+09DA (৚)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71b6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+09DB (৛)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0200, 0x0200, 0x1a10, 0x1610, 0x1010, 0x1020, 0x1020, 0x0840, 0x0780, 0x0000, 0x0300, 0x0300 },	// U+09DC (ড়)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x0020, 0x0020, 0x0020, 0x0020, 0x0c20, 0x0c20, 0x0420, 0x0320, 0x00e0, 0x0600, 0x0600, 0x0000 },	// U+09DD (ঢ়)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+09DE (৞)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1010, 0x1020, 0x1040, 0x1080, 0x1040, 0x1030, 0x11c0, 0x1600, 0x18c0, 0x00c0, 0x0000, 0x0000 },	// U+09DF (য়)
	{ 0x0000, 0x0000, 0x0000, 0xf400, 0x1408, 0x1424, 0x1658, 0x1580, 0x1660, 0x1c18, 0x1460, 0x1580, 0x1640, 0x0020, 0x0040, 0x0080 },	// U+09E0 (ৠ)
	{ 0x0000, 0x0000, 0x0000, 0x00c0, 0x0020, 0x0040, 0x0380, 0x0400, 0x08e0, 0x0910, 0x0a10, 0x0620, 0x0900, 0x1000, 0x1600, 0x1900 },	// U+09E1 (ৡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x2c00, 0x3200 },	// U+09E2 (ৢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x8000, 0xc000, 0xa000, 0x0000, 0x1000, 0x2000, 0x2c00, 0x3200 },	// U+09E3 (ৣ)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6f86, 0x7ffe, 0x0000 },	// U+09E4 (৤)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x6186, 0x7ffe, 0x0000 },	// U+09E5 (৥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+09E6 (০)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0060, 0x0180, 0x0600, 0x0800, 0x1000, 0x1000, 0x0e60, 0x01e0, 0x0000, 0x0000, 0x0000 },	// U+09E7 (১)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x0300, 0x0400, 0x0800, 0x0800, 0x0600, 0x01e0, 0x00c0, 0x0300, 0x0400, 0x0800, 0x0000 },	// U+09E8 (২)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0888, 0x1048, 0x1348, 0x1388, 0x1010, 0x1010, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+09E9 (৩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0420, 0x0420, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000 },	// U+09EA (৪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x0120, 0x0210, 0x0110, 0x0110, 0x0110, 0x0a10, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+09EB (৫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0200, 0x0210, 0x1a10, 0x1610, 0x1020, 0x1020, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000 },	// U+09EC (৬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0410, 0x0610, 0x05e0, 0x0400, 0x0400, 0x0400, 0x0400, 0x0000, 0x0000, 0x0000 },	// U+09ED (৭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x0810, 0x07d0, 0x0130, 0x0110, 0x0110, 0x0090, 0x0060, 0x0000, 0x0000, 0x0000 },	// U+09EE (৮)
	{ 0x0000, 0x0000, 0x0000, 0x0040, 0x0020, 0x0020, 0x0040, 0x0380, 0x0400, 0x08e0, 0x0910, 0x0a10, 0x0620, 0x0000, 0x0000, 0x0000 },	// U+09EF (৯)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1800, 0x1600, 0x1180, 0x1360, 0x1418, 0x1860, 0x1180, 0x1600, 0x1800, 0x0000, 0x0000, 0x0000 },	// U+09F0 (ৰ)
	{ 0x0000, 0x0000, 0x0000, 0xffff, 0x1800, 0x1600, 0x1180, 0x1060, 0x1018, 0x1060, 0x1180, 0x1630, 0x1840, 0x0080, 0x0000, 0x0000 },	// U+09F1 (ৱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0180, 0x0200, 0x0400, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+09F2 (৲)
	{ 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0080, 0x0fc0, 0x0080, 0x0680, 0x0a80, 0x0880, 0x0480, 0x0300, 0x0000, 0x0000, 0x0000 },	// U+09F3 (৳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0200, 0x0180, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+09F4 (৴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x10e0, 0x0910, 0x0530, 0x0280, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+09F5 (৵)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x10f0, 0x1130, 0x0900, 0x0900, 0x0880, 0x0470, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000 },	// U+09F6 (৶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+09F7 (৷)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x0810, 0x0c10, 0x0a10, 0x0910, 0x0890, 0x0850, 0x0830, 0x0810, 0x0800, 0x1000, 0x0000 },	// U+09F8 (৸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0820, 0x0820, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000 },	// U+09F9 (৹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x0990, 0x0990, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+09FA (৺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0040, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0000, 0x0000, 0x0000 },	// U+09FB (৻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0980, 0x0580, 0x0410, 0x0220, 0x01c0, 0x0400, 0x0800, 0x1000, 0x0000 },	// U+09FC (ৼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+09FD (৽)
	{ 0x00c0, 0x0100, 0x03c0, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+09FE (৾)
	{ 0x0000, 0x7ffe, 0x73ce, 0x6db6, 0x63b6, 0x6fb6, 0x73ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+09FF (৿)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6db6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0A00 (਀)
	{ 0x0540, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A01 (ਁ)
	{ 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A02 (ਂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0xa000, 0x4000, 0x0000, 0x4000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+0A03 (ਃ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6dce, 0x6db6, 0x61b6, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0A04 (਄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xe003, 0x2004, 0x20c8, 0x3928, 0x261c, 0x230c, 0x2304, 0x2100, 0x2000, 0x0000, 0x0000, 0x0000 },	// U+0A05 (ਅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xfc03, 0x2404, 0x2408, 0x2668, 0x059c, 0x04cc, 0x04c4, 0x0440, 0x0400, 0x0000, 0x0000, 0x0000 },	// U+0A06 (ਆ)
	{ 0x003c, 0x0042, 0x0042, 0x0002, 0xffff, 0x2022, 0x2022, 0x2042, 0x3f82, 0x0042, 0x0022, 0x2042, 0x1f82, 0x0000, 0x0000, 0x0000 },	// U+0A07 (ਇ)
	{ 0x1e00, 0x2100, 0x2100, 0x2000, 0x7fff, 0x2202, 0x2202, 0x2204, 0x23f8, 0x2004, 0x2002, 0x2204, 0x21f8, 0x0000, 0x0000, 0x0000 },	// U+0A08 (ਈ)
	{ 0x03e0, 0x0410, 0x0808, 0x1004, 0xffff, 0x1004, 0x1004, 0x0804, 0x07fc, 0x0808, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0810, 0x07e0 },	// U+0A09 (ਉ)
	{ 0x03e0, 0x0410, 0x0808, 0x1004, 0xffff, 0x1004, 0x0804, 0x07fc, 0x0808, 0x0810, 0x0420, 0x03c0, 0x0810, 0x07e0, 0x0810, 0x07e0 },	// U+0A0A (ਊ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0A0B (਋)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+0A0C (਌)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0A0D (਍)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+0A0E (਎)
	{ 0x0300, 0x0400, 0x0800, 0x0800, 0xffff, 0x0808, 0x0808, 0x0810, 0x0fe0, 0x0010, 0x0008, 0x0010, 0x0fe0, 0x0000, 0x0000, 0x0000 },	// U+0A0F (ਏ)
	{ 0x0f00, 0x1000, 0x2f00, 0x3000, 0xf803, 0x2004, 0x20c8, 0x3928, 0x261c, 0x230c, 0x2304, 0x2100, 0x2000, 0x2000, 0x0000, 0x0000 },	// U+0A10 (ਐ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x77de, 0x73ce, 0x77de, 0x77de, 0x638e, 0x7ffe, 0x0000 },	// U+0A11 (਑)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x0000 },	// U+0A12 (਒)
	{ 0x0fe0, 0x0010, 0x0008, 0x0004, 0xffff, 0x1004, 0x1004, 0x0804, 0x07fc, 0x0808, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+0A13 (ਓ)
	{ 0x0040, 0x0f80, 0x1200, 0x1200, 0xf803, 0x2004, 0x20c8, 0x3928, 0x261c, 0x230c, 0x2304, 0x2100, 0x2000, 0x2000, 0x0000, 0x0000 },	// U+0A14 (ਔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x08f0, 0x0508, 0x0604, 0x0604, 0x0904, 0x0888, 0x0870, 0x0000, 0x0000 },	// U+0A15 (ਕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf80f, 0x0808, 0x0810, 0x0ff0, 0x0808, 0x0804, 0x0c08, 0x0bf0, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+0A16 (ਖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0900, 0x0900, 0x0900, 0x09f8, 0x0904, 0x0904, 0x0908, 0x0890, 0x0860, 0x0000, 0x0000 },	// U+0A17 (ਗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf88f, 0x0888, 0x0890, 0x0890, 0x0888, 0x0884, 0x0c88, 0x0b70, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+0A18 (ਘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0008, 0x0008, 0x03f8, 0x0400, 0x05c0, 0x0220, 0x0520, 0x08c0, 0x0000, 0x0000, 0x0000 },	// U+0A19 (ਙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0400, 0x0400, 0x0418, 0x07f8, 0x0410, 0x0410, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+0A1A (ਚ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0ff8, 0x0004, 0x0ff8, 0x1084, 0x1084, 0x0ff8, 0x0000, 0x0000, 0x0000 },	// U+0A1B (ਛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0818, 0x0ff8, 0x0810, 0x0810, 0x0810, 0x0810, 0x0000, 0x0000, 0x0000 },	// U+0A1C (ਜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0c30, 0x0240, 0x07f0, 0x0808, 0x1064, 0x0fe0, 0x0080, 0x0100, 0x0200, 0x0000, 0x0000 },	// U+0A1D (ਝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0804, 0x0804, 0x0ff8, 0x0004, 0x0004, 0x0ff8, 0x0020, 0x0fc0, 0x0000, 0x0000, 0x0000 },	// U+0A1E (ਞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0200, 0x0200, 0x0380, 0x0040, 0x0020, 0x0010, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+0A1F (ਟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0080, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+0A20 (ਠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x1000, 0x1000, 0x0fc0, 0x0800, 0x0800, 0x10f8, 0x1104, 0x0e08, 0x03f0, 0x0000, 0x0000 },	// U+0A21 (ਡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0818, 0x0ff8, 0x0010, 0x0010, 0x0790, 0x0850, 0x0420, 0x03c0, 0x0000 },	// U+0A22 (ਢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0080, 0x0300, 0x0600, 0x0af0, 0x0308, 0x0004, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+0A23 (ਣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x05e0, 0x07e0, 0x0c00, 0x0804, 0x080c, 0x0430, 0x03c0, 0x0000, 0x0000 },	// U+0A24 (ਤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0808, 0x0810, 0x0ff0, 0x0808, 0x080c, 0x0c30, 0x0bc0, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+0A25 (ਥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0400, 0x0400, 0x040c, 0x07fc, 0x0008, 0x0008, 0x0010, 0x0820, 0x07c0, 0x0000, 0x0000 },	// U+0A26 (ਦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0810, 0x0820, 0x0820, 0x0810, 0x0808, 0x0810, 0x0e60, 0x0980, 0x0800, 0x0000, 0x0000 },	// U+0A27 (ਧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0080, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x0808, 0x0410, 0x0000, 0x0000, 0x0000 },	// U+0A28 (ਨ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x6386, 0x6ff6, 0x7386, 0x7ffe, 0x0000 },	// U+0A29 (਩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf81f, 0x0810, 0x0820, 0x0820, 0x0810, 0x0808, 0x0810, 0x0e60, 0x0980, 0x0800, 0x0000, 0x0000 },	// U+0A2A (ਪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0ff8, 0x0004, 0x0004, 0x0784, 0x0848, 0x0430, 0x03c0, 0x0000, 0x0000 },	// U+0A2B (ਫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0810, 0x0820, 0x0fe0, 0x0810, 0x0808, 0x0810, 0x0e60, 0x0980, 0x0800, 0x0000, 0x0000 },	// U+0A2C (ਬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0bc0, 0x0c20, 0x13c0, 0x1000, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+0A2D (ਭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf80f, 0x0810, 0x0810, 0x0810, 0x0ff0, 0x0818, 0x0818, 0x0800, 0x0980, 0x0980, 0x0000, 0x0000 },	// U+0A2E (ਮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0810, 0x0820, 0x0820, 0x0f10, 0x0908, 0x0910, 0x0920, 0x09c0, 0x0800, 0x0000, 0x0000 },	// U+0A2F (ਯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0fe0, 0x0810, 0x0810, 0x0810, 0x0820, 0x0840, 0x0780, 0x0000, 0x0000 },	// U+0A30 (ਰ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x77c6, 0x73be, 0x778e, 0x77be, 0x63c6, 0x7ffe, 0x0000 },	// U+0A31 (਱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0410, 0x0410, 0x0220, 0x0550, 0x0888, 0x0808, 0x0410, 0x0220, 0x0000, 0x0000, 0x0000 },	// U+0A32 (ਲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0410, 0x0410, 0x0220, 0x0550, 0x0888, 0x0808, 0x0410, 0x3220, 0x3000, 0x0000, 0x0000 },	// U+0A33 (ਲ਼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6dc6, 0x6dbe, 0x618e, 0x6fbe, 0x6fc6, 0x7ffe, 0x0000 },	// U+0A34 (਴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0ff8, 0x0004, 0x000c, 0x0ff0, 0x0020, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+0A35 (ਵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0810, 0x0810, 0x0810, 0x0ff0, 0x0818, 0x0818, 0x0800, 0x0980, 0x0980, 0x0000, 0x0000 },	// U+0A36 (ਸ਼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fbe, 0x778e, 0x7bbe, 0x7bc6, 0x7ffe, 0x0000 },	// U+0A37 (਷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0810, 0x0810, 0x0810, 0x0ff0, 0x0818, 0x0818, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+0A38 (ਸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x08e0, 0x0810, 0x0810, 0x0810, 0x0820, 0x0840, 0x0780, 0x0000, 0x0000 },	// U+0A39 (ਹ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61c6, 0x6dbe, 0x618e, 0x6dbe, 0x6dc6, 0x7ffe, 0x0000 },	// U+0A3A (਺)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x718e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+0A3B (਻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180 },	// U+0A3C (਼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x6d8e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+0A3D (਽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A3E (ਾ)
	{ 0x001e, 0x0021, 0x0021, 0x0021, 0x0007, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000 },	// U+0A3F (ਿ)
	{ 0x1e00, 0x2100, 0x2100, 0x2100, 0xf800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x0000 },	// U+0A40 (ੀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0410, 0x03e0, 0x0000 },	// U+0A41 (ੁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0410, 0x03e0, 0x0410, 0x03e0 },	// U+0A42 (ੂ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x71b6, 0x6fb6, 0x6386, 0x6fbe, 0x71be, 0x7ffe, 0x0000 },	// U+0A43 (੃)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6db6, 0x6db6, 0x6186, 0x6fbe, 0x6fbe, 0x7ffe, 0x0000 },	// U+0A44 (੄)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x6186, 0x6fbe, 0x61be, 0x7ffe, 0x0000 },	// U+0A45 (੅)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x73b6, 0x7db6, 0x7186, 0x6dbe, 0x73be, 0x7ffe, 0x0000 },	// U+0A46 (੆)
	{ 0x0000, 0x0700, 0x0800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A47 (ੇ)
	{ 0x0780, 0x0800, 0x1f00, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A48 (ੈ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x73b6, 0x6db6, 0x6386, 0x6fbe, 0x73be, 0x7ffe, 0x0000 },	// U+0A49 (੉)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61b6, 0x6db6, 0x6186, 0x6dbe, 0x6dbe, 0x7ffe, 0x0000 },	// U+0A4A (੊)
	{ 0x0040, 0x0f80, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A4B (ੋ)
	{ 0x0040, 0x0f80, 0x1200, 0x1200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A4C (ੌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x2000, 0x4000 },	// U+0A4D (੍)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x61be, 0x7ffe, 0x0000 },	// U+0A4E (੎)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x7dbe, 0x7ffe, 0x0000 },	// U+0A4F (੏)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6d86, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+0A50 (੐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0060, 0x0180 },	// U+0A51 (ੑ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x6186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+0A52 (੒)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x6386, 0x6fbe, 0x7186, 0x7ffe, 0x0000 },	// U+0A53 (੓)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x6186, 0x6fbe, 0x6f86, 0x7ffe, 0x0000 },	// U+0A54 (੔)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x6186, 0x6fbe, 0x6186, 0x7ffe, 0x0000 },	// U+0A55 (੕)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x7186, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+0A56 (੖)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x7786, 0x7bbe, 0x7b86, 0x7ffe, 0x0000 },	// U+0A57 (੗)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x7386, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+0A58 (੘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf81f, 0x0810, 0x0820, 0x0fe0, 0x0810, 0x0808, 0x0810, 0x0e60, 0x0980, 0x0818, 0x0018, 0x0000 },	// U+0A59 (ਖ਼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0900, 0x0900, 0x09f0, 0x0908, 0x0908, 0x0908, 0x0910, 0x0920, 0x08c0, 0x0018, 0x0018 },	// U+0A5A (ਗ਼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0818, 0x0ff8, 0x0810, 0x0810, 0x0810, 0x0810, 0x0990, 0x0180, 0x0000 },	// U+0A5B (ਜ਼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0400, 0x0400, 0x0400, 0x07e0, 0x0800, 0x0800, 0x0408, 0x0210, 0x03e0, 0x0420, 0x0840 },	// U+0A5C (ੜ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6d86, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+0A5D (੝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0800, 0x0800, 0x0ff8, 0x0004, 0x0004, 0x0784, 0x0848, 0x0430, 0x03c6, 0x0006, 0x0000 },	// U+0A5E (ਫ਼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x7d86, 0x7ffe, 0x0000 },	// U+0A5F (੟)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x73ce, 0x6df6, 0x6dc6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0A60 (੠)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x77ce, 0x73f6, 0x77c6, 0x77b6, 0x63ce, 0x7ffe, 0x0000 },	// U+0A61 (੡)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61ce, 0x6ff6, 0x61c6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+0A62 (੢)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x71ce, 0x6ff6, 0x63c6, 0x6fb6, 0x71ce, 0x7ffe, 0x0000 },	// U+0A63 (੣)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6dce, 0x6df6, 0x61c6, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0A64 (੤)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x61c6, 0x6fb6, 0x61ce, 0x7ffe, 0x0000 },	// U+0A65 (੥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0408, 0x0804, 0x0804, 0x0804, 0x0408, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000 },	// U+0A66 (੦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0110, 0x0210, 0x0310, 0x02e0, 0x0200, 0x0200, 0x0200, 0x0200, 0x0c00, 0x0000, 0x0000 },	// U+0A67 (੧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0400, 0x0800, 0x0800, 0x0400, 0x03f0, 0x0200, 0x0400, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+0A68 (੨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x0200, 0x0400, 0x0200, 0x01f8, 0x0200, 0x0400, 0x020c, 0x01fc, 0x0010, 0x0020, 0x0040 },	// U+0A69 (੩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0220, 0x0410, 0x0410, 0x0220, 0x01c0, 0x0220, 0x0410, 0x0410, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+0A6A (੪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3c08, 0x0408, 0x0410, 0x0410, 0x0408, 0x0404, 0x0408, 0x0730, 0x04c0, 0x0400, 0x0000, 0x0000 },	// U+0A6B (੫)
	{ 0x0700, 0x0080, 0x0080, 0x0300, 0x0fc0, 0x0c20, 0x0010, 0x0020, 0x0fc0, 0x0020, 0x0010, 0x1020, 0x0fc0, 0x0000, 0x0000, 0x0000 },	// U+0A6C (੬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0860, 0x0400, 0x0200, 0x0100, 0x00c0, 0x0020, 0x0000, 0x0000 },	// U+0A6D (੭)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x0ffc, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0010, 0x0020, 0x0fc0, 0x0000, 0x0000, 0x0000 },	// U+0A6E (੮)
	{ 0x0600, 0x0100, 0x0100, 0x060c, 0x0ffc, 0x0c08, 0x0008, 0x0008, 0x0008, 0x0008, 0x0010, 0x0020, 0x0fc0, 0x0000, 0x0000, 0x0000 },	// U+0A6F (੯)
	{ 0x03c0, 0x0420, 0x0240, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A70 (ੰ)
	{ 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A71 (ੱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0808, 0x0808, 0x0810, 0x0fe0, 0x0010, 0x0008, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000 },	// U+0A72 (ੲ)
	{ 0x07e0, 0x0810, 0x1008, 0x1004, 0xffff, 0x1004, 0x1004, 0x0804, 0x07fc, 0x0808, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+0A73 (ੳ)
	{ 0x0000, 0x0000, 0x2018, 0x1f24, 0x30a4, 0x49b8, 0x42d0, 0x4128, 0x3014, 0x4014, 0x4014, 0x2024, 0x1048, 0x0f90, 0x0000, 0x0000 },	// U+0A74 (ੴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0040, 0x0240, 0x0180 },	// U+0A75 (ੵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x01c0, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A76 (੶)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x77de, 0x7bee, 0x7bee, 0x7ffe, 0x0000 },	// U+0A77 (੷)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x73de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0A78 (੸)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x63de, 0x6fee, 0x73ee, 0x7ffe, 0x0000 },	// U+0A79 (੹)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x61de, 0x6dee, 0x6dee, 0x7ffe, 0x0000 },	// U+0A7A (੺)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x71de, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+0A7B (੻)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7dde, 0x7dee, 0x63ee, 0x7ffe, 0x0000 },	// U+0A7C (੼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+0A7D (੽)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+0A7E (੾)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+0A7F (੿)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6dce, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0A80 (઀)
	{ 0x0540, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A81 (ઁ)
	{ 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A82 (ં)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc000, 0xc000, 0x0000, 0x0000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A83 (ઃ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6dce, 0x6db6, 0x61ce, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0A84 (઄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x101e, 0x1020, 0x1120, 0x1f1c, 0x1208, 0x1110, 0x50e0, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A85 (અ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x440f, 0x4410, 0x4490, 0x478e, 0x4504, 0x4488, 0x5470, 0x8800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A86 (આ)
	{ 0x0000, 0x1800, 0x0400, 0x0400, 0x05c0, 0x0420, 0x0420, 0x0420, 0x04c0, 0x0420, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A87 (ઇ)
	{ 0x0000, 0x0c00, 0x1200, 0x1200, 0x02e0, 0x0210, 0x0210, 0x0210, 0x0260, 0x0210, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A88 (ઈ)
	{ 0x0000, 0x03c0, 0x0420, 0x0810, 0x0390, 0x0410, 0x0410, 0x0410, 0x0310, 0x0420, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A89 (ઉ)
	{ 0x0000, 0x00f0, 0x0108, 0x0204, 0x04e4, 0x0904, 0x0904, 0x0904, 0x08c4, 0x0908, 0x2910, 0x10e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A8A (ઊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x089c, 0x14a0, 0x14c0, 0x1880, 0x27c0, 0x40a0, 0x4290, 0x2108, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A8B (ઋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0ef0, 0x1108, 0x2104, 0x1804, 0x0408, 0x0430, 0x3800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A8C (ઌ)
	{ 0x0200, 0x0400, 0x1800, 0x0000, 0x101e, 0x1020, 0x1120, 0x1f1c, 0x1208, 0x1110, 0x50e0, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A8D (ઍ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+0A8E (઎)
	{ 0x0000, 0x0600, 0x0800, 0x1000, 0x101e, 0x1020, 0x1120, 0x1f1c, 0x1208, 0x1110, 0x50e0, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A8F (એ)
	{ 0x0700, 0x1800, 0x1f00, 0x1000, 0x101e, 0x1020, 0x1120, 0x1f1c, 0x1208, 0x1110, 0x50e0, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A90 (ઐ)
	{ 0x0800, 0x1000, 0x6000, 0x0000, 0x440f, 0x4410, 0x4490, 0x478e, 0x4504, 0x4488, 0x5470, 0x8800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A91 (ઑ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x618e, 0x7dbe, 0x61ce, 0x7ffe, 0x0000 },	// U+0A92 (઒)
	{ 0x0000, 0x1800, 0x2000, 0x4000, 0x440f, 0x4410, 0x4490, 0x478e, 0x4504, 0x4488, 0x5470, 0x8800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A93 (ઓ)
	{ 0x1c00, 0x6000, 0x7c00, 0x4000, 0x440f, 0x4410, 0x4490, 0x478e, 0x4504, 0x4488, 0x5470, 0x8800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A94 (ઔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0040, 0x0240, 0x0180, 0x0180, 0x0240, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A95 (ક)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0204, 0x020a, 0x0248, 0x03c8, 0x0230, 0x0200, 0x0a00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A96 (ખ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0430, 0x0448, 0x0480, 0x0480, 0x0448, 0x0430, 0x1400, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A97 (ગ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09c0, 0x0820, 0x0820, 0x0820, 0x08c0, 0x0c20, 0x2a20, 0x11c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A98 (ઘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0640, 0x0620, 0x0040, 0x0084, 0x0088, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A99 (ઙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x083c, 0x0840, 0x0840, 0x0838, 0x0c10, 0x0a20, 0x29c0, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A9A (ચ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0338, 0x0484, 0x0484, 0x0484, 0x0518, 0x0204, 0x0104, 0x00f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A9B (છ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0870, 0x0488, 0x0314, 0x0112, 0x0292, 0x048c, 0x0480, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A9C (જ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0230, 0x0248, 0x0280, 0x0780, 0x0848, 0x0830, 0x0800, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A9D (ઝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0430, 0x0448, 0x0480, 0x0780, 0x0448, 0x0430, 0x1400, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A9E (ઞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x001c, 0x0020, 0x0020, 0x0018, 0x0004, 0x0002, 0x0022, 0x001c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0A9F (ટ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0040, 0x0040, 0x0080, 0x00e0, 0x0110, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AA0 (ઠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0040, 0x0020, 0x0040, 0x0084, 0x0088, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AA1 (ડ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0038, 0x0040, 0x0030, 0x0308, 0x0484, 0x0484, 0x0308, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AA2 (ઢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0232, 0x024a, 0x0282, 0x0282, 0x024a, 0x0232, 0x0a02, 0x0402, 0x0004, 0x0008, 0x0010, 0x0008 },	// U+0AA3 (ણ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0200, 0x03c0, 0x0220, 0x0210, 0x0210, 0x0a20, 0x0440, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AA4 (ત)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0230, 0x0248, 0x0250, 0x0220, 0x0310, 0x02e0, 0x0a00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AA5 (થ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0020, 0x0020, 0x0020, 0x00c0, 0x0020, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AA6 (દ)
	{ 0x0000, 0x0060, 0x0010, 0x0010, 0x0260, 0x0210, 0x0310, 0x02e0, 0x0200, 0x0200, 0x0a00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AA7 (ધ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x01f8, 0x0118, 0x0100, 0x0500, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AA8 (ન)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7386, 0x6db6, 0x6386, 0x6fb6, 0x73b6, 0x7ffe, 0x0000 },	// U+0AA9 (઩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0214, 0x0210, 0x0310, 0x02e0, 0x0200, 0x0a00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AAA (પ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0040, 0x0240, 0x0180, 0x0180, 0x0240, 0x0218, 0x01f8, 0x0020, 0x0040, 0x0180, 0x0000 },	// U+0AAB (ફ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1010, 0x1008, 0x1104, 0x1f04, 0x1088, 0x1070, 0x5000, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AAC (બ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x10e0, 0x1110, 0x1108, 0x1f08, 0x1008, 0x1010, 0x5020, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AAD (ભ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0430, 0x0440, 0x0440, 0x07c0, 0x0400, 0x0400, 0x1400, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AAE (મ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0430, 0x0440, 0x0420, 0x0410, 0x0620, 0x05c0, 0x1400, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AAF (ય)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0078, 0x0080, 0x0080, 0x0070, 0x0020, 0x0040, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AB0 (ર)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x77c6, 0x73b6, 0x77c6, 0x77b6, 0x63c6, 0x7ffe, 0x0000 },	// U+0AB1 (઱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0130, 0x0108, 0x0104, 0x01e4, 0x0104, 0x0108, 0x0530, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AB2 (લ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0184, 0x0244, 0x0244, 0x0244, 0x0238, 0x0200, 0x0a00, 0x0400, 0x0000, 0x0000, 0x0000 },	// U+0AB3 (ળ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6dc6, 0x6db6, 0x61c6, 0x6fb6, 0x6fc6, 0x7ffe, 0x0000 },	// U+0AB4 (઴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02e0, 0x0310, 0x0210, 0x0310, 0x02e0, 0x0200, 0x0a00, 0x0400, 0x0000, 0x0000, 0x0000 },	// U+0AB5 (વ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0430, 0x0448, 0x0448, 0x0430, 0x0420, 0x0418, 0x1410, 0x08e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AB6 (શ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0230, 0x0250, 0x0290, 0x0310, 0x02e0, 0x0200, 0x0a00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AB7 (ષ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x043c, 0x0440, 0x07c0, 0x0438, 0x0410, 0x0420, 0x14c0, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AB8 (સ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0084, 0x0044, 0x0084, 0x0104, 0x0124, 0x04c4, 0x0408, 0x03f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AB9 (હ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61c6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+0ABA (઺)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71c6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0ABB (઻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180 },	// U+0ABC (઼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x001c, 0x0002, 0x0002, 0x000c, 0x0010, 0x0020, 0x0022, 0x001c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0ABD (ઽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0ABE (ા)
	{ 0x0006, 0x0009, 0x0011, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0005, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0ABF (િ)
	{ 0x1800, 0x2400, 0x2400, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AC0 (ી)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0640, 0x0880, 0x0700 },	// U+0AC1 (ુ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0980 },	// U+0AC2 (ૂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0040, 0x0380 },	// U+0AC3 (ૃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0040, 0x0180, 0x0040, 0x0380 },	// U+0AC4 (ૄ)
	{ 0x0800, 0x1000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AC5 (ૅ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x738e, 0x7df6, 0x71f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+0AC6 (૆)
	{ 0x0000, 0x1800, 0x2000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AC7 (ે)
	{ 0x1c00, 0x6000, 0x7c00, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AC8 (ૈ)
	{ 0x0400, 0x0800, 0x3000, 0x0000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AC9 (ૉ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x618e, 0x6df6, 0x61f6, 0x6df6, 0x6d8e, 0x7ffe, 0x0000 },	// U+0ACA (૊)
	{ 0x0c00, 0x1000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0ACB (ો)
	{ 0x1c00, 0x2000, 0x2c00, 0x3000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0ACC (ૌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0400, 0x0800 },	// U+0ACD (્)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+0ACE (૎)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+0ACF (૏)
	{ 0x0c00, 0x0c00, 0x0000, 0x2100, 0x1e3c, 0x0040, 0x3040, 0x4830, 0x4c18, 0x3220, 0x01c2, 0x0042, 0x003c, 0x0000, 0x0000, 0x0000 },	// U+0AD0 (ૐ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x77c6, 0x73b6, 0x77b6, 0x77b6, 0x63c6, 0x7ffe, 0x0000 },	// U+0AD1 (૑)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x61b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+0AD2 (૒)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x71c6, 0x6fb6, 0x63b6, 0x6fb6, 0x71c6, 0x7ffe, 0x0000 },	// U+0AD3 (૓)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6dc6, 0x6db6, 0x61b6, 0x6fb6, 0x6fc6, 0x7ffe, 0x0000 },	// U+0AD4 (૔)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x61b6, 0x6fb6, 0x61c6, 0x7ffe, 0x0000 },	// U+0AD5 (૕)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x73c6, 0x7db6, 0x71b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+0AD6 (૖)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x77b6, 0x7bb6, 0x7bc6, 0x7ffe, 0x0000 },	// U+0AD7 (૗)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x73b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+0AD8 (૘)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x63b6, 0x6fb6, 0x73c6, 0x7ffe, 0x0000 },	// U+0AD9 (૙)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61b6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+0ADA (૚)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71b6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0ADB (૛)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7db6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+0ADC (૜)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x6db6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0ADD (૝)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+0ADE (૞)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+0ADF (૟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x044e, 0x0a50, 0x0a60, 0x0c40, 0x3be0, 0x0850, 0x4948, 0x3084, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AE0 (ૠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0ef0, 0x1108, 0x2104, 0x1804, 0x0408, 0x0430, 0x3800, 0x0400, 0x0400, 0x3800, 0x0000 },	// U+0AE1 (ૡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06c0, 0x0920, 0x0420, 0x1800 },	// U+0AE2 (ૢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06c0, 0x0920, 0x2420, 0x5800, 0x3000 },	// U+0AE3 (ૣ)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6f86, 0x7ffe, 0x0000 },	// U+0AE4 (૤)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x6186, 0x7ffe, 0x0000 },	// U+0AE5 (૥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0408, 0x0804, 0x0804, 0x0804, 0x0408, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000 },	// U+0AE6 (૦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0110, 0x0210, 0x0310, 0x02e0, 0x0200, 0x0200, 0x0200, 0x0200, 0x0c00, 0x0000, 0x0000 },	// U+0AE7 (૧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0400, 0x0800, 0x0800, 0x0430, 0x03f0, 0x0040, 0x0080, 0x0300, 0x0000, 0x0000, 0x0000 },	// U+0AE8 (૨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0400, 0x0800, 0x0400, 0x03c0, 0x0408, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+0AE9 (૩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1038, 0x0840, 0x0480, 0x0300, 0x0300, 0x0480, 0x0440, 0x0440, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+0AEA (૪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0214, 0x0210, 0x0310, 0x02e0, 0x0200, 0x0a00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AEB (૫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0010, 0x0008, 0x0010, 0x07e0, 0x0020, 0x0010, 0x0020, 0x0fc0, 0x1000, 0x1000, 0x0e00 },	// U+0AEC (૬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0620, 0x0910, 0x0890, 0x0860, 0x0804, 0x0804, 0x0404, 0x0208, 0x01f0, 0x0000, 0x0000 },	// U+0AED (૭)
	{ 0x0000, 0x0000, 0x0000, 0x0100, 0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x0008, 0x0008, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000 },	// U+0AEE (૮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0208, 0x0104, 0x0084, 0x0044, 0x0004, 0x0008, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AEF (૯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0024, 0x0024, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AF0 (૰)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0040, 0x0080, 0x0040, 0x3838, 0x4440, 0x4480, 0x444c, 0x383c, 0x0010, 0x0020, 0x00c0 },	// U+0AF1 (૱)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+0AF2 (૲)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x71f6, 0x7ffe, 0x0000 },	// U+0AF3 (૳)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6ff6, 0x7ffe, 0x0000 },	// U+0AF4 (૴)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+0AF5 (૵)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0AF6 (૶)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+0AF7 (૷)
	{ 0x0000, 0x7ffe, 0x61ce, 0x6db6, 0x61b6, 0x6db6, 0x6dce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0AF8 (૸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x41f8, 0x2214, 0x1424, 0x0c24, 0x0a18, 0x0900, 0x08a0, 0x0488, 0x0320, 0x0000, 0x0000, 0x0000 },	// U+0AF9 (ૹ)
	{ 0x0300, 0x0400, 0x0400, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AFA (ૺ)
	{ 0x1110, 0x1110, 0x0ee0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AFB (ૻ)
	{ 0x3000, 0x0c80, 0x0380, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AFC (ૼ)
	{ 0x0180, 0x0180, 0x0c30, 0x0c30, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AFD (૽)
	{ 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AFE (૾)
	{ 0x0c60, 0x1290, 0x1290, 0x0c60, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0AFF (૿)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6db6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0B00 (଀)
	{ 0x0540, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B01 (ଁ)
	{ 0x4000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B02 (ଂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B03 (ଃ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6dce, 0x6db6, 0x61b6, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0B04 (଄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x086c, 0x0892, 0x0892, 0x0844, 0x0820, 0x0810, 0x0c10, 0x0be0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B05 (ଅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x286c, 0x2892, 0x2892, 0x2844, 0x2820, 0x2820, 0x2c40, 0x2b80, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B06 (ଆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x020c, 0x0402, 0x0402, 0x0452, 0x02ac, 0x02a8, 0x0450, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B07 (ଇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x047c, 0x0402, 0x0452, 0x02ac, 0x02a8, 0x0450, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B08 (ଈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x020c, 0x0402, 0x0482, 0x044a, 0x0264, 0x0244, 0x0438, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B09 (ଉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x020c, 0x0202, 0x0282, 0x044a, 0x0864, 0x0444, 0x0838, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B0A (ଊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0118, 0x0104, 0x0104, 0x0234, 0x0448, 0x0248, 0x0430, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B0B (ଋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0180, 0x0040, 0x0320, 0x04a0, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B0C (ଌ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0B0D (଍)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+0B0E (଎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0060, 0x0050, 0x0042, 0x0044, 0x0048, 0x0050, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B0F (ଏ)
	{ 0x0000, 0x0780, 0x0840, 0x0800, 0x0480, 0x04c0, 0x04a0, 0x0784, 0x0488, 0x0490, 0x04a0, 0x04c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B10 (ଐ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x77de, 0x73ce, 0x77de, 0x77de, 0x638e, 0x7ffe, 0x0000 },	// U+0B11 (଑)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x0000 },	// U+0B12 (଒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0320, 0x0490, 0x0410, 0x0410, 0x0310, 0x0420, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B13 (ଓ)
	{ 0x0000, 0x0f00, 0x1080, 0x1000, 0x08c8, 0x0924, 0x0904, 0x0f04, 0x08c4, 0x0908, 0x0910, 0x08e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B14 (ଔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x040c, 0x0802, 0x0802, 0x0192, 0x026c, 0x0268, 0x0250, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B15 (କ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09c0, 0x08a0, 0x0c90, 0x0b10, 0x0810, 0x08e0, 0x0920, 0x08c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B16 (ଖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09c0, 0x0a20, 0x0c10, 0x0810, 0x0810, 0x08e0, 0x0920, 0x08c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B17 (ଗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09c0, 0x0a20, 0x0c10, 0x0850, 0x0830, 0x0888, 0x0c88, 0x0b70, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B18 (ଘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x010c, 0x0e02, 0x1282, 0x0c4a, 0x0064, 0x0044, 0x0038, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B19 (ଙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x04e0, 0x0120, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B1A (ଚ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x08d0, 0x0120, 0x00e8, 0x0150, 0x00a0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B1B (ଛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0010, 0x0650, 0x0520, 0x0520, 0x04c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B1C (ଜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x05c0, 0x0920, 0x0890, 0x0708, 0x0068, 0x0090, 0x0190, 0x0260, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B1D (ଝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06c8, 0x0924, 0x0804, 0x07f8, 0x06c8, 0x0924, 0x0804, 0x07f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B1E (ଞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09c0, 0x0a20, 0x0c10, 0x0810, 0x0010, 0x00e0, 0x0120, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B1F (ଟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0110, 0x0208, 0x0208, 0x0208, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B20 (ଠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0430, 0x0808, 0x0a08, 0x0928, 0x0590, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B21 (ଡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0430, 0x0808, 0x0808, 0x0828, 0x0490, 0x0150, 0x00e0, 0x0040, 0x0080, 0x0000, 0x0000 },	// U+0B22 (ଢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09c0, 0x0a20, 0x0c50, 0x0888, 0x0838, 0x0840, 0x0840, 0x0830, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B23 (ଣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x020c, 0x0402, 0x0402, 0x02ca, 0x00c4, 0x00c4, 0x0038, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B24 (ତ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0860, 0x0890, 0x0880, 0x0870, 0x0808, 0x0808, 0x0c10, 0x0be0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B25 (ଥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x020c, 0x0402, 0x0482, 0x00ca, 0x00c4, 0x00c4, 0x00b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B26 (ଦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0820, 0x0840, 0x08c0, 0x0920, 0x0820, 0x0c20, 0x0bc0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B27 (ଧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x0208, 0x0404, 0x0404, 0x04e4, 0x0298, 0x00b0, 0x00b0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B28 (ନ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x6386, 0x6ff6, 0x7386, 0x7ffe, 0x0000 },	// U+0B29 (଩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09e0, 0x0a10, 0x0c08, 0x0848, 0x0830, 0x0810, 0x0c10, 0x0be0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B2A (ପ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0d38, 0x1344, 0x1382, 0x0d12, 0x010c, 0x0104, 0x0184, 0x0178, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B2B (ଫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0218, 0x0404, 0x0474, 0x048c, 0x0088, 0x0188, 0x0170, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B2C (ବ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x020c, 0x0402, 0x04a2, 0x04aa, 0x02c4, 0x0284, 0x0478, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B2D (ଭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09e0, 0x0a10, 0x0c08, 0x0848, 0x0830, 0x0808, 0x0806, 0x0806, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+0B2E (ମ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09e0, 0x0a10, 0x0c08, 0x0848, 0x0830, 0x0818, 0x0c16, 0x0be6, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B2F (ଯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x04e0, 0x0520, 0x08c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B30 (ର)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x77c6, 0x73be, 0x778e, 0x77be, 0x63c6, 0x7ffe, 0x0000 },	// U+0B31 (଱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0404, 0x0802, 0x0802, 0x08da, 0x0524, 0x0524, 0x0924, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B32 (ଲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0404, 0x0802, 0x0802, 0x04da, 0x0124, 0x0124, 0x0124, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B33 (ଳ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6dc6, 0x6dbe, 0x618e, 0x6fbe, 0x6fc6, 0x7ffe, 0x0000 },	// U+0B34 (଴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0218, 0x0404, 0x0474, 0x048c, 0x00a8, 0x0188, 0x0170, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B35 (ଵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09e0, 0x0a10, 0x0c30, 0x0848, 0x0808, 0x0870, 0x0890, 0x0860, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B36 (ଶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09e0, 0x0a30, 0x0c48, 0x08c8, 0x0930, 0x0a10, 0x0c10, 0x0be0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B37 (ଷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09f0, 0x0a08, 0x0c04, 0x0884, 0x0864, 0x0878, 0x0980, 0x0e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B38 (ସ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x020c, 0x0402, 0x0482, 0x00ca, 0x00c4, 0x00c4, 0x00b8, 0x0010, 0x0060, 0x0180, 0x0000 },	// U+0B39 (ହ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6dbe, 0x618e, 0x6dbe, 0x6dc6, 0x7ffe, 0x0000 },	// U+0B3A (଺)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x718e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+0B3B (଻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180 },	// U+0B3C (଼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x000c, 0x0002, 0x000c, 0x0030, 0x000c, 0x0002, 0x000c, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+0B3D (ଽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+0B3E (ା)
	{ 0x0fe0, 0x1010, 0x1010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B3F (ି)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1800, 0x1400, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+0B40 (ୀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x05e0, 0x0310, 0x0de0 },	// U+0B41 (ୁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x0020, 0x0220, 0x0dc0 },	// U+0B42 (ୂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0520, 0x0420, 0x03c0 },	// U+0B43 (ୃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0210, 0x0560, 0x0410, 0x03e0 },	// U+0B44 (ୄ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x6186, 0x6fbe, 0x61be, 0x7ffe, 0x0000 },	// U+0B45 (୅)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73b6, 0x7db6, 0x7186, 0x6dbe, 0x73be, 0x7ffe, 0x0000 },	// U+0B46 (୆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0001, 0x0001, 0x0001, 0x0007, 0x0009, 0x0009, 0x0009, 0x0006, 0x0000, 0x0000, 0x0000 },	// U+0B47 (େ)
	{ 0x0080, 0x1f00, 0x2000, 0x2000, 0x0006, 0x0001, 0x0001, 0x0001, 0x0007, 0x0009, 0x0009, 0x0009, 0x0006, 0x0000, 0x0000, 0x0000 },	// U+0B48 (ୈ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73b6, 0x6db6, 0x6386, 0x6fbe, 0x73be, 0x7ffe, 0x0000 },	// U+0B49 (୉)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61b6, 0x6db6, 0x6186, 0x6dbe, 0x6dbe, 0x7ffe, 0x0000 },	// U+0B4A (୊)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1006, 0x1001, 0x1001, 0x1001, 0x1007, 0x1009, 0x1009, 0x1009, 0x1006, 0x0000, 0x0000, 0x0000 },	// U+0B4B (ୋ)
	{ 0x0000, 0x1e00, 0x2100, 0x2000, 0x1006, 0x1001, 0x1001, 0x1001, 0x1007, 0x1009, 0x1009, 0x1009, 0x1006, 0x0000, 0x0000, 0x0000 },	// U+0B4C (ୌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0200, 0x0400 },	// U+0B4D (୍)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x61be, 0x7ffe, 0x0000 },	// U+0B4E (୎)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x7dbe, 0x7ffe, 0x0000 },	// U+0B4F (୏)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6d86, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+0B50 (୐)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x7786, 0x77be, 0x6386, 0x7ffe, 0x0000 },	// U+0B51 (୑)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x6186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+0B52 (୒)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x6386, 0x6fbe, 0x7186, 0x7ffe, 0x0000 },	// U+0B53 (୓)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x6186, 0x6fbe, 0x6f86, 0x7ffe, 0x0000 },	// U+0B54 (୔)
	{ 0x0000, 0x0ff0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B55 (୕)
	{ 0x0080, 0x1f00, 0x2000, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B56 (ୖ)
	{ 0x0000, 0x1e00, 0x2100, 0x2000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+0B57 (ୗ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x7386, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+0B58 (୘)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6386, 0x6fbe, 0x7386, 0x7ffe, 0x0000 },	// U+0B59 (୙)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x6186, 0x6dbe, 0x6d86, 0x7ffe, 0x0000 },	// U+0B5A (୚)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x7186, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+0B5B (୛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0430, 0x0808, 0x0a08, 0x0928, 0x0590, 0x0110, 0x00e0, 0x0000, 0x00c0, 0x00c0, 0x0000 },	// U+0B5C (ଡ଼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0430, 0x0808, 0x0808, 0x0828, 0x0490, 0x0150, 0x00e0, 0x0040, 0x0080, 0x0030, 0x0030 },	// U+0B5D (ଢ଼)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+0B5E (୞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09e0, 0x0a10, 0x0c08, 0x0848, 0x0830, 0x0c18, 0x1216, 0x39e6, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B5F (ୟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0218, 0x0304, 0x0404, 0x0334, 0x0448, 0x0348, 0x0430, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+0B60 (ୠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0180, 0x0040, 0x0320, 0x04a0, 0x03c0, 0x0100, 0x0200, 0x0400, 0x0000 },	// U+0B61 (ୡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0280, 0x0280, 0x1900, 0x2480, 0x1f00 },	// U+0B62 (ୢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0280, 0x1a80, 0x2500, 0x1c80, 0x0b00 },	// U+0B63 (ୣ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6dce, 0x6df6, 0x61c6, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0B64 (୤)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x61c6, 0x6fb6, 0x61ce, 0x7ffe, 0x0000 },	// U+0B65 (୥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0808, 0x0808, 0x0808, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+0B66 (୦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0850, 0x0850, 0x0790, 0x0020, 0x0040, 0x0080, 0x0300, 0x0400, 0x0000, 0x0000 },	// U+0B67 (୧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0a10, 0x0a10, 0x09e0, 0x0400, 0x0200, 0x0100, 0x00c0, 0x0020, 0x0000, 0x0000 },	// U+0B68 (୨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0770, 0x0888, 0x0884, 0x0894, 0x08a4, 0x0898, 0x0880, 0x0880, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B69 (୩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1020, 0x0840, 0x0480, 0x0300, 0x0300, 0x0480, 0x0440, 0x0440, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+0B6A (୪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0448, 0x0450, 0x0260, 0x0180, 0x0640, 0x0a20, 0x1220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+0B6B (୫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x08c0, 0x0900, 0x0910, 0x04e0, 0x0200, 0x0100, 0x00c0, 0x0020, 0x0000, 0x0000 },	// U+0B6C (୬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0890, 0x0950, 0x0950, 0x04e0, 0x0200, 0x0100, 0x00c0, 0x0020, 0x0000, 0x0000 },	// U+0B6D (୭)
	{ 0x0000, 0x0000, 0x0000, 0x07f0, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0000, 0x0000, 0x0000 },	// U+0B6E (୮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x04e0, 0x0510, 0x0610, 0x0010, 0x0010, 0x0010, 0x0020, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B6F (୯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0230, 0x0130, 0x0082, 0x0044, 0x0028, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B70 (୰)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0790, 0x0848, 0x0708, 0x0810, 0x0fe0, 0x0810, 0x0c10, 0x0be0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B71 (ୱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B72 (୲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0110, 0x0110, 0x0110, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B73 (୳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0444, 0x0444, 0x0444, 0x0664, 0x0598, 0x0400, 0x0400, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B74 (୴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B75 (୵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0238, 0x0154, 0x00d4, 0x0048, 0x0020, 0x0010, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B76 (୶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x2000, 0x1000, 0x0800, 0x046c, 0x0292, 0x0192, 0x0092, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B77 (୷)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x73de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0B78 (୸)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x63de, 0x6fee, 0x73ee, 0x7ffe, 0x0000 },	// U+0B79 (୹)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x61de, 0x6dee, 0x6dee, 0x7ffe, 0x0000 },	// U+0B7A (୺)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x71de, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+0B7B (୻)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7dde, 0x7dee, 0x63ee, 0x7ffe, 0x0000 },	// U+0B7C (୼)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+0B7D (୽)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+0B7E (୾)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+0B7F (୿)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6dce, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0B80 (஀)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x77ce, 0x73b6, 0x77ce, 0x77b6, 0x63ce, 0x7ffe, 0x0000 },	// U+0B81 (஁)
	{ 0x0080, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B82 (ஂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x0180, 0x1818, 0x2424, 0x2424, 0x1818, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B83 (ஃ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6dce, 0x6db6, 0x61ce, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0B84 (஄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0860, 0x0890, 0x0990, 0x0960, 0x0900, 0x0ff8, 0x0904, 0x08f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B85 (அ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0218, 0x0224, 0x0264, 0x0258, 0x0240, 0x07fe, 0x0a41, 0x0a3e, 0x0a80, 0x0840, 0x0780, 0x0000 },	// U+0B86 (ஆ)
	{ 0x0000, 0x0000, 0x01f0, 0x0208, 0x04c4, 0x0924, 0x0924, 0x0ac8, 0x0210, 0x01f8, 0x0244, 0x01b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B87 (இ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x0108, 0x0108, 0x0d68, 0x0d68, 0x0108, 0x0108, 0x0108, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B88 (ஈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x003c, 0x0052, 0x0092, 0x008c, 0x0040, 0x003c, 0x0002, 0x0ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B89 (உ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x000e, 0x0019, 0x1f99, 0x0b56, 0x0a90, 0x0a0e, 0x0001, 0x1ffe, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B8A (ஊ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x71ce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0B8B (஋)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7dce, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+0B8C (஌)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6dce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0B8D (஍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3fe0, 0x0810, 0x0808, 0x0838, 0x0844, 0x0844, 0x0844, 0x0838, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B8E (எ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3fe0, 0x0810, 0x0808, 0x0838, 0x0844, 0x0844, 0x0844, 0x0838, 0x0400, 0x0200, 0x0100, 0x0000 },	// U+0B8F (ஏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x077c, 0x088e, 0x0892, 0x0892, 0x088c, 0x0800, 0x07fc, 0x0002, 0x0002, 0x0842, 0x0842, 0x07bc },	// U+0B90 (ஐ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x77ce, 0x73b6, 0x778e, 0x77be, 0x63ce, 0x7ffe, 0x0000 },	// U+0B91 (஑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0404, 0x0802, 0x0802, 0x0b8e, 0x0a52, 0x0952, 0x064c, 0x0040, 0x0788, 0x0208, 0x01f0 },	// U+0B92 (ஒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0404, 0x0802, 0x0802, 0x0b8e, 0x0a52, 0x0952, 0x064c, 0x0040, 0x078c, 0x0212, 0x01fc },	// U+0B93 (ஓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x003c, 0x0042, 0x0081, 0x3e81, 0x15b3, 0x16ad, 0x149d, 0x006a, 0x0008, 0x00f1, 0x0041, 0x003e },	// U+0B94 (ஔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0110, 0x0110, 0x0110, 0x07fc, 0x0902, 0x0902, 0x04fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B95 (க)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73ce, 0x7db6, 0x718e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+0B96 (஖)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x778e, 0x7bbe, 0x7bce, 0x7ffe, 0x0000 },	// U+0B97 (஗)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x738e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+0B98 (஘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x087e, 0x0812, 0x08f2, 0x0912, 0x0912, 0x0882, 0x0842, 0x0ff2, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B99 (ங)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0110, 0x0110, 0x0110, 0x07fc, 0x0102, 0x0102, 0x00fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B9A (ச)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x718e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+0B9B (஛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x077c, 0x088e, 0x0892, 0x0892, 0x088c, 0x0800, 0x07fc, 0x0002, 0x0702, 0x0882, 0x0842, 0x063c },	// U+0B9C (ஜ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6d8e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+0B9D (஝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e4, 0x0112, 0x0109, 0x0539, 0x0b45, 0x0945, 0x0945, 0x0939, 0x0801, 0x0402, 0x03fc, 0x0000 },	// U+0B9E (ஞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0B9F (ட)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6db6, 0x6d86, 0x6db6, 0x73b6, 0x7ffe, 0x0000 },	// U+0BA0 (஠)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7786, 0x73b6, 0x7786, 0x77b6, 0x63b6, 0x7ffe, 0x0000 },	// U+0BA1 (஡)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6fb6, 0x6186, 0x7db6, 0x61b6, 0x7ffe, 0x0000 },	// U+0BA2 (஢)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xfddc, 0x1222, 0x1551, 0x1553, 0x1555, 0x1555, 0x1222, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BA3 (ண)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0110, 0x0110, 0x0110, 0x07fc, 0x0902, 0x0902, 0x08fc, 0x0800, 0x0400, 0x03fc, 0x0002 },	// U+0BA4 (த)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7db6, 0x6186, 0x6fb6, 0x61b6, 0x7ffe, 0x0000 },	// U+0BA5 (஥)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x7db6, 0x7186, 0x6db6, 0x73b6, 0x7ffe, 0x0000 },	// U+0BA6 (஦)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6fb6, 0x7786, 0x7bb6, 0x7bb6, 0x7ffe, 0x0000 },	// U+0BA7 (஧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0110, 0x0110, 0x0110, 0x0110, 0x0710, 0x0910, 0x0910, 0x0800, 0x0400, 0x03fc, 0x0002 },	// U+0BA8 (ந)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3f78, 0x0884, 0x0942, 0x094e, 0x0952, 0x0952, 0x088c, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BA9 (ன)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x07f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BAA (ப)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6db6, 0x7186, 0x6db6, 0x71b6, 0x7ffe, 0x0000 },	// U+0BAB (஫)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6386, 0x7db6, 0x7d86, 0x7db6, 0x63b6, 0x7ffe, 0x0000 },	// U+0BAC (஬)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6db6, 0x6d86, 0x6db6, 0x71b6, 0x7ffe, 0x0000 },	// U+0BAD (஭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0384, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x03fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BAE (ம)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0848, 0x0848, 0x0848, 0x0848, 0x0848, 0x0848, 0x0868, 0x0fd8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BAF (ய)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0200, 0x0100, 0x0080, 0x0040 },	// U+0BB0 (ர)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ee0, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x0800, 0x0800, 0x07f0, 0x0008 },	// U+0BB1 (ற)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0438, 0x0844, 0x0882, 0x0882, 0x088e, 0x0892, 0x0892, 0x070c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BB2 (ல)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3f38, 0x08c4, 0x0882, 0x0882, 0x088e, 0x0892, 0x0892, 0x088c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BB3 (ள)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0384, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x03fc, 0x0040, 0x03c4, 0x0104, 0x00f8 },	// U+0BB4 (ழ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0838, 0x08c4, 0x0902, 0x0902, 0x090e, 0x0912, 0x0892, 0x0fcc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BB5 (வ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3fe2, 0x2222, 0x2222, 0x2222, 0x2222, 0x2222, 0x2222, 0x1c1c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BB6 (ஶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0838, 0x1444, 0x1482, 0x1482, 0x088e, 0x1492, 0x1252, 0x0fcc, 0x0100, 0x0080, 0x0000, 0x0000 },	// U+0BB7 (ஷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x09b8, 0x1244, 0x1242, 0x1242, 0x124e, 0x1252, 0x1252, 0x0c4c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BB8 (ஸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x361c, 0x4922, 0x4941, 0x4941, 0x4947, 0x4949, 0x4929, 0x49e6, 0x2000, 0x2000, 0x1ffc, 0x0002 },	// U+0BB9 (ஹ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61c6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+0BBA (஺)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71c6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0BBB (஻)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7dc6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+0BBC (஼)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x6dc6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0BBD (஽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf800, 0x4800, 0x4800, 0x4800, 0x4800, 0x4800, 0x4800, 0x4800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BBE (ா)
	{ 0x3800, 0x4400, 0x4400, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BBF (ி)
	{ 0x0380, 0x0440, 0x0340, 0x0080, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BC0 (ீ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7800, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BC1 (ு)
	{ 0x0000, 0x0000, 0x6000, 0x9000, 0xb800, 0xd000, 0xa000, 0x8000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BC2 (ூ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x718e, 0x6ff6, 0x63f6, 0x6ff6, 0x718e, 0x7ffe, 0x0000 },	// U+0BC3 (௃)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6d8e, 0x6df6, 0x61f6, 0x6ff6, 0x6f8e, 0x7ffe, 0x0000 },	// U+0BC4 (௄)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x61f6, 0x6ff6, 0x618e, 0x7ffe, 0x0000 },	// U+0BC5 (௅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0012, 0x0021, 0x0021, 0x0027, 0x0029, 0x0029, 0x0026, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BC6 (ெ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0012, 0x000d, 0x0001, 0x0001, 0x000d, 0x0012, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BC7 (ே)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01bc, 0x0242, 0x02e1, 0x02a1, 0x02a7, 0x02a9, 0x0249, 0x0006, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BC8 (ை)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x63f6, 0x6ff6, 0x738e, 0x7ffe, 0x0000 },	// U+0BC9 (௉)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf80c, 0x4812, 0x4821, 0x4821, 0x4827, 0x4829, 0x4829, 0x4826, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BCA (ொ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf80c, 0x4812, 0x480d, 0x4801, 0x4801, 0x480d, 0x4812, 0x480c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BCB (ோ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf80c, 0x5412, 0x5221, 0x5321, 0x5527, 0x5529, 0x5529, 0x5226, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BCC (ௌ)
	{ 0x00c0, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BCD (்)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+0BCE (௎)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+0BCF (௏)
	{ 0x0000, 0x0000, 0x0000, 0x0ff0, 0x300c, 0x4002, 0x8001, 0x8001, 0xb807, 0xa409, 0x9429, 0x6486, 0x0558, 0x79e4, 0x2004, 0x1ff8 },	// U+0BD0 (ௐ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x77c6, 0x73b6, 0x77b6, 0x77b6, 0x63c6, 0x7ffe, 0x0000 },	// U+0BD1 (௑)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x61b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+0BD2 (௒)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6fb6, 0x63b6, 0x6fb6, 0x71c6, 0x7ffe, 0x0000 },	// U+0BD3 (௓)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6dc6, 0x6db6, 0x61b6, 0x6fb6, 0x6fc6, 0x7ffe, 0x0000 },	// U+0BD4 (௔)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x61b6, 0x6fb6, 0x61c6, 0x7ffe, 0x0000 },	// U+0BD5 (௕)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73c6, 0x7db6, 0x71b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+0BD6 (௖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf800, 0x5400, 0x5200, 0x5300, 0x5500, 0x5500, 0x5500, 0x5200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BD7 (ௗ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x73b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+0BD8 (௘)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x63b6, 0x6fb6, 0x73c6, 0x7ffe, 0x0000 },	// U+0BD9 (௙)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61b6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+0BDA (௚)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71b6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0BDB (௛)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7db6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+0BDC (௜)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x6db6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0BDD (௝)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+0BDE (௞)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+0BDF (௟)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+0BE0 (௠)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x6386, 0x7ffe, 0x0000 },	// U+0BE1 (௡)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+0BE2 (௢)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x7186, 0x7ffe, 0x0000 },	// U+0BE3 (௣)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6f86, 0x7ffe, 0x0000 },	// U+0BE4 (௤)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x6186, 0x7ffe, 0x0000 },	// U+0BE5 (௥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0420, 0x0420, 0x0420, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BE6 (௦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0110, 0x0110, 0x0110, 0x07fc, 0x0902, 0x0902, 0x04fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BE7 (௧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0038, 0x0044, 0x0082, 0x0082, 0x0044, 0x003c, 0x0002, 0x0ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BE8 (௨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01fc, 0x0044, 0x0044, 0x0344, 0x04c4, 0x0444, 0x0204, 0x3fc4, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BE9 (௩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x27f0, 0x2110, 0x2110, 0x2110, 0x3ffc, 0x0102, 0x0102, 0x00fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BEA (௪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1fc8, 0x0444, 0x0442, 0x0442, 0x0442, 0x1c42, 0x2442, 0x2442, 0x2002, 0x1004, 0x0ff8, 0x0000 },	// U+0BEB (௫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0110, 0x0110, 0x0110, 0x7ffc, 0x2502, 0x2502, 0x24fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BEC (௬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3fe0, 0x0810, 0x0808, 0x0838, 0x0844, 0x0844, 0x0844, 0x0838, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BED (௭)
	{ 0x0000, 0x0000, 0x0000, 0x0070, 0x0888, 0x0908, 0x0a10, 0x0a60, 0x0ffc, 0x0a02, 0x0904, 0x08f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BEE (௮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0090, 0x0090, 0x3890, 0x47fc, 0x4c82, 0x5482, 0x487c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BEF (௯)
	{ 0x0000, 0x01c0, 0x0200, 0x0400, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x03b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BF0 (௰)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1fd8, 0x0464, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BF1 (௱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0110, 0x0110, 0x0110, 0x3ffc, 0x0902, 0x0902, 0x1efc, 0x2a00, 0x2c00, 0x2000, 0x1e00 },	// U+0BF2 (௲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0038, 0x00c4, 0x0102, 0x0102, 0x010e, 0x0112, 0x0092, 0x0fcc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BF3 (௳)
	{ 0x0e00, 0x1300, 0x7500, 0x0300, 0x0384, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x0444, 0x03fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BF4 (௴)
	{ 0x0000, 0x0000, 0x3ffc, 0x4002, 0x5c39, 0x4a45, 0x2a85, 0xaa85, 0x4a8d, 0x1a95, 0x2a55, 0x2bc9, 0x2001, 0x1002, 0x0ffc, 0x0000 },	// U+0BF5 (௵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0110, 0x0110, 0x0110, 0x0910, 0x0910, 0x0910, 0x0910, 0x09e0, 0x0900, 0x0fe0, 0x0110, 0x00e0 },	// U+0BF6 (௶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x0024, 0x0022, 0x2326, 0x24a9, 0x29e9, 0x2aa9, 0x3926, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0BF7 (௷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x407c, 0xa082, 0xa101, 0xa3c1, 0x4527, 0xa929, 0xa529, 0x7cc6, 0x1000, 0x0800, 0x0000, 0x0000 },	// U+0BF8 (௸)
	{ 0x0070, 0x0088, 0x013c, 0x0f4a, 0x0032, 0x07e2, 0x0212, 0x0212, 0x0212, 0x0e12, 0x1212, 0x1212, 0x1002, 0x0804, 0x07f8, 0x0000 },	// U+0BF9 (௹)
	{ 0x1c00, 0x2200, 0x4f00, 0xd280, 0x0c80, 0x01f0, 0x0088, 0x0088, 0x0088, 0x0388, 0x0488, 0x0488, 0x0400, 0x0200, 0x01f8, 0x0004 },	// U+0BFA (௺)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+0BFB (௻)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+0BFC (௼)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+0BFD (௽)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+0BFE (௾)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x71b6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+0BFF (௿)
	{ 0x0000, 0x0180, 0x0990, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C00 (ఀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8000, 0x4000, 0x2000, 0x2000, 0x2000, 0x4000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C01 (ఁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C02 (ం)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+0C03 (ః)
	{ 0x0000, 0x0180, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C04 (ఄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x124c, 0x1334, 0x1004, 0x1004, 0x0808, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C05 (అ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0830, 0x1448, 0x144c, 0x0f34, 0x0804, 0x0804, 0x0408, 0x03f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C06 (ఆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01dc, 0x0222, 0x0222, 0x0200, 0x0178, 0x0084, 0x0178, 0x0200, 0x0200, 0x0200, 0x0000, 0x0000 },	// U+0C07 (ఇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x0024, 0x0618, 0x093c, 0x0442, 0x07fe, 0x0942, 0x063c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C08 (ఈ)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x07f0, 0x0808, 0x0004, 0x1ffe, 0x0002, 0x0602, 0x0944, 0x07b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C09 (ఉ)
	{ 0x0000, 0x0000, 0x00a0, 0x00a0, 0x11f8, 0x2204, 0x1002, 0x1fff, 0x2801, 0x1101, 0x02a2, 0x01dc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C0A (ఊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0926, 0x1249, 0x1248, 0x1244, 0x1242, 0x1241, 0x1249, 0x0db6, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C0B (ఋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00d8, 0x0124, 0x0124, 0x0880, 0x0840, 0x0840, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C0C (ఌ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0C0D (఍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0800, 0x1000, 0x1000, 0x1000, 0x1070, 0x08c8, 0x0730, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C0E (ఎ)
	{ 0x0000, 0x0000, 0x0000, 0x0040, 0x0720, 0x0810, 0x1010, 0x1000, 0x1000, 0x1070, 0x08c8, 0x0730, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C0F (ఏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0770, 0x0888, 0x1088, 0x1000, 0x1000, 0x1070, 0x08c8, 0x0730, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C10 (ఐ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x77de, 0x73ce, 0x77de, 0x77de, 0x638e, 0x7ffe, 0x0000 },	// U+0C11 (఑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0048, 0x0048, 0x0020, 0x0010, 0x0008, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C12 (ఒ)
	{ 0x0000, 0x0060, 0x0090, 0x0020, 0x0030, 0x0048, 0x0048, 0x0020, 0x0010, 0x0008, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C13 (ఓ)
	{ 0x0000, 0x07fc, 0x0a80, 0x047c, 0x0030, 0x0048, 0x0048, 0x0020, 0x0010, 0x0008, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C14 (ఔ)
	{ 0x0000, 0x0400, 0x0240, 0x0180, 0x0180, 0x0240, 0x0040, 0x0180, 0x0200, 0x0400, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C15 (క)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0012, 0x012c, 0x0220, 0x0420, 0x042c, 0x0232, 0x01ec, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+0C16 (ఖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0110, 0x00a0, 0x0040, 0x00a0, 0x00a0, 0x0110, 0x0110, 0x0110, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C17 (గ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0c92, 0x110c, 0x1200, 0x120c, 0x0932, 0x06ec, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+0C18 (ఘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0230, 0x0248, 0x0fc8, 0x0020, 0x0010, 0x0008, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C19 (ఙ)
	{ 0x0000, 0x0000, 0x0800, 0x0400, 0x0380, 0x0580, 0x0800, 0x1000, 0x101e, 0x1090, 0x09c8, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C1A (చ)
	{ 0x0000, 0x0000, 0x0800, 0x0400, 0x0380, 0x0580, 0x0800, 0x1000, 0x101e, 0x1090, 0x09c8, 0x06b0, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+0C1B (ఛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0230, 0x04c8, 0x0348, 0x0020, 0x0010, 0x0008, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C1C (జ)
	{ 0x0000, 0x0100, 0x0084, 0x0048, 0x0930, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1748, 0x0ab0, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+0C1D (ఝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00d8, 0x0124, 0x0524, 0x0f00, 0x0100, 0x00b8, 0x0044, 0x00b8, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+0C1E (ఞ)
	{ 0x0000, 0x0000, 0x0008, 0x0008, 0x0318, 0x0424, 0x041a, 0x0802, 0x0802, 0x0802, 0x0844, 0x07b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C1F (ట)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0110, 0x00e0, 0x0110, 0x0208, 0x0248, 0x0208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C20 (ఠ)
	{ 0x0000, 0x0400, 0x0210, 0x0120, 0x00f0, 0x0048, 0x0084, 0x0102, 0x0002, 0x0602, 0x0944, 0x07b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C21 (డ)
	{ 0x0000, 0x0400, 0x0210, 0x0120, 0x00f0, 0x0048, 0x0084, 0x0102, 0x0002, 0x0602, 0x0944, 0x07f8, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+0C22 (ఢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x1084, 0x1004, 0x1018, 0x1c04, 0x1244, 0x0c38, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C23 (ణ)
	{ 0x1000, 0x0880, 0x0500, 0x0200, 0x0630, 0x0948, 0x1634, 0x1004, 0x1004, 0x1004, 0x0808, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C24 (త)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0110, 0x00e0, 0x0110, 0x0248, 0x0208, 0x0248, 0x01f0, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+0C25 (థ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0110, 0x00e0, 0x0110, 0x0208, 0x0208, 0x0248, 0x01b0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C26 (ద)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0110, 0x00e0, 0x0110, 0x0208, 0x0208, 0x0248, 0x01f0, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+0C27 (ధ)
	{ 0x0100, 0x0080, 0x0058, 0x0038, 0x01c0, 0x0200, 0x0400, 0x0800, 0x0818, 0x0824, 0x0444, 0x0388, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C28 (న)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x6386, 0x6ff6, 0x7386, 0x7ffe, 0x0000 },	// U+0C29 (఩)
	{ 0x0200, 0x0100, 0x0090, 0x0060, 0x0700, 0x0800, 0x1000, 0x1000, 0x1000, 0x1070, 0x08c8, 0x0730, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C2A (ప)
	{ 0x0200, 0x0100, 0x0090, 0x0060, 0x0700, 0x0800, 0x1000, 0x1000, 0x1000, 0x1070, 0x08c8, 0x07b0, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+0C2B (ఫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x030c, 0x0412, 0x0810, 0x1008, 0x1004, 0x1084, 0x0948, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C2C (బ)
	{ 0x0000, 0x2000, 0x1000, 0x0b00, 0x070c, 0x0412, 0x0810, 0x1008, 0x1004, 0x1084, 0x0948, 0x0630, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+0C2D (భ)
	{ 0x0200, 0x0100, 0x0080, 0x0060, 0x0ce0, 0x1100, 0x1200, 0x1200, 0x1200, 0x121c, 0x1332, 0x0ccc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C2E (మ)
	{ 0x0200, 0x0100, 0x00b0, 0x0040, 0x0c80, 0x1100, 0x120c, 0x1212, 0x1212, 0x1212, 0x1332, 0x0ccc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C2F (య)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0110, 0x00e0, 0x0110, 0x0208, 0x0208, 0x0208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C30 (ర)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x114c, 0x13f4, 0x1004, 0x1004, 0x0808, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C31 (ఱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0318, 0x0424, 0x0826, 0x081a, 0x0802, 0x0402, 0x0204, 0x01f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C32 (ల)
	{ 0x1000, 0x0800, 0x0580, 0x0380, 0x0200, 0x0418, 0x0824, 0x0834, 0x0408, 0x03f0, 0x0090, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C33 (ళ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0318, 0x04a4, 0x0ca6, 0x0b1a, 0x0802, 0x0842, 0x0444, 0x03b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C34 (ఴ)
	{ 0x0000, 0x0800, 0x0400, 0x0200, 0x0780, 0x0980, 0x1000, 0x1000, 0x1000, 0x1070, 0x08c8, 0x0730, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C35 (వ)
	{ 0x0000, 0x0200, 0x0100, 0x0080, 0x01e0, 0x0260, 0x0400, 0x0470, 0x0288, 0x01c8, 0x0120, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C36 (శ)
	{ 0x0200, 0x0100, 0x0090, 0x0060, 0x0700, 0x0800, 0x1000, 0x1000, 0x1000, 0x1070, 0x08c8, 0x0730, 0x0800, 0x1000, 0x2000, 0x0000 },	// U+0C37 (ష)
	{ 0x0200, 0x0100, 0x00a0, 0x0040, 0x0700, 0x0800, 0x1000, 0x1000, 0x1000, 0x1070, 0x08c8, 0x0708, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C38 (స)
	{ 0x0020, 0x0010, 0x000a, 0x0004, 0x1fe0, 0x1440, 0x0880, 0x0100, 0x0100, 0x011c, 0x0132, 0x00cc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C39 (హ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6dbe, 0x618e, 0x6dbe, 0x6dc6, 0x7ffe, 0x0000 },	// U+0C3A (఺)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x718e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+0C3B (఻)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x63c6, 0x7dbe, 0x7d8e, 0x7dbe, 0x63c6, 0x7ffe, 0x0000 },	// U+0C3C (఼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0100, 0x0100, 0x00c0, 0x0020, 0x0020, 0x1fc0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C3D (ఽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xff00, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C3E (ా)
	{ 0x0180, 0x0240, 0x0380, 0x01e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C3F (ి)
	{ 0x0020, 0x0190, 0x0260, 0x0380, 0x01e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C40 (ీ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x8000, 0x8000, 0x8000, 0x8000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C41 (ు)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xff00, 0xa400, 0x4800, 0x1000, 0x2000, 0x4000, 0x4800, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C42 (ూ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x8000, 0x8000, 0x8000, 0xa000, 0xd000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C43 (ృ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf800, 0x8800, 0x1000, 0x2000, 0x4000, 0x5000, 0x6800, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C44 (ౄ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x6186, 0x6fbe, 0x61be, 0x7ffe, 0x0000 },	// U+0C45 (౅)
	{ 0x03f0, 0x0400, 0x0400, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C46 (ె)
	{ 0x0600, 0x0100, 0x03f0, 0x0400, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C47 (ే)
	{ 0x03f0, 0x0400, 0x0400, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0050, 0x0ff0 },	// U+0C48 (ై)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x73b6, 0x6db6, 0x6386, 0x6fbe, 0x73be, 0x7ffe, 0x0000 },	// U+0C49 (౉)
	{ 0x0000, 0x07ec, 0x0910, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C4A (ొ)
	{ 0x0c00, 0x1200, 0x07ec, 0x0a12, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C4B (ో)
	{ 0x0000, 0x07fc, 0x0920, 0x061c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C4C (ౌ)
	{ 0x00f0, 0x0008, 0x0030, 0x0008, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C4D (్)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x61be, 0x7ffe, 0x0000 },	// U+0C4E (౎)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x7dbe, 0x7ffe, 0x0000 },	// U+0C4F (౏)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6d86, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+0C50 (౐)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x7786, 0x77be, 0x6386, 0x7ffe, 0x0000 },	// U+0C51 (౑)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x6186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+0C52 (౒)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x6386, 0x6fbe, 0x7186, 0x7ffe, 0x0000 },	// U+0C53 (౓)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x6186, 0x6fbe, 0x6f86, 0x7ffe, 0x0000 },	// U+0C54 (౔)
	{ 0x0600, 0x0900, 0x1200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C55 (ౕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0050, 0x0ff0 },	// U+0C56 (ౖ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x7786, 0x7bbe, 0x7b86, 0x7ffe, 0x0000 },	// U+0C57 (౗)
	{ 0x0080, 0x0140, 0x09fe, 0x0400, 0x0380, 0x0580, 0x0800, 0x1000, 0x101e, 0x1090, 0x09c8, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C58 (ౘ)
	{ 0x0200, 0x0500, 0x07f8, 0x0000, 0x0230, 0x04c8, 0x0348, 0x0020, 0x0010, 0x0008, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C59 (ౙ)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0808, 0x0808, 0x0ff8, 0x0888, 0x0888, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C5A (ౚ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x7186, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+0C5B (౛)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7d86, 0x7dbe, 0x6386, 0x7ffe, 0x0000 },	// U+0C5C (౜)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6d86, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+0C5D (ౝ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+0C5E (౞)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x7d86, 0x7ffe, 0x0000 },	// U+0C5F (౟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7c92, 0xa925, 0x4924, 0x0924, 0x0922, 0x0921, 0x0925, 0x06da, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C60 (ౠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7cd8, 0xa524, 0x4524, 0x0880, 0x0840, 0x0840, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C61 (ౡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0360, 0x1490, 0x1400, 0x0800 },	// U+0C62 (ౢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1cd8, 0x2d24, 0x1500, 0x0200 },	// U+0C63 (ౣ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6dce, 0x6df6, 0x61c6, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0C64 (౤)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x61c6, 0x6fb6, 0x61ce, 0x7ffe, 0x0000 },	// U+0C65 (౥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0420, 0x0420, 0x0420, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C66 (౦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x0810, 0x0420, 0x0240, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C67 (౧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0880, 0x1280, 0x1100, 0x1000, 0x0800, 0x07fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C68 (౨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x0840, 0x0700, 0x0800, 0x0840, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C69 (౩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0420, 0x0810, 0x0810, 0x0420, 0x03c0, 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C6A (౪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x20c0, 0x1300, 0x0c00, 0x0c00, 0x1200, 0x1100, 0x08e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C6B (౫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x001c, 0x0002, 0x0002, 0x00fc, 0x0002, 0x0002, 0x0004, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C6C (౬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0420, 0x0200, 0x11c0, 0x1020, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C6D (౭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3f08, 0x0104, 0x0202, 0x0202, 0x0202, 0x0202, 0x0104, 0x00f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C6E (౮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x0004, 0x0002, 0x0002, 0x00fc, 0x0002, 0x0002, 0x001c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C6F (౯)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x6dde, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0C70 (౰)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7786, 0x73be, 0x77de, 0x77ee, 0x63ee, 0x7ffe, 0x0000 },	// U+0C71 (౱)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x61de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+0C72 (౲)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7186, 0x6fbe, 0x63de, 0x6fee, 0x71ee, 0x7ffe, 0x0000 },	// U+0C73 (౳)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6dbe, 0x61de, 0x6fee, 0x6fee, 0x7ffe, 0x0000 },	// U+0C74 (౴)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x61de, 0x6fee, 0x61ee, 0x7ffe, 0x0000 },	// U+0C75 (౵)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7386, 0x7dbe, 0x71de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0C76 (౶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x1324, 0x14a4, 0x1428, 0x1248, 0x0990, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+0C77 (౷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0420, 0x0420, 0x0420, 0x03c0, 0x0400, 0x0800, 0x0600, 0x0180, 0x0000, 0x0000 },	// U+0C78 (౸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C79 (౹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x0440, 0x0440, 0x0440, 0x0780, 0x0400, 0x0400, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C7A (౺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0490, 0x0490, 0x0490, 0x0490, 0x0760, 0x0400, 0x0400, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C7B (౻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C7C (౼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0400, 0x0400, 0x0380, 0x0040, 0x0020, 0x0020, 0x1fc0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C7D (౽)
	{ 0x0000, 0x0000, 0x0000, 0x00e0, 0x0100, 0x00c0, 0x0020, 0x00c0, 0x0100, 0x00c0, 0x0020, 0x1fc0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C7E (౾)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x1068, 0x1008, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C7F (౿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0990, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C80 (ಀ)
	{ 0x0990, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C81 (ಁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C82 (ಂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+0C83 (ಃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fc0, 0x1020, 0x1310, 0x2492, 0x2412, 0x2224, 0x11c4, 0x0808, 0x07f0, 0x0000, 0x0000 },	// U+0C84 (಄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x124c, 0x1734, 0x1004, 0x1004, 0x0808, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C85 (ಅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c30, 0x1248, 0x144c, 0x0f34, 0x1004, 0x1004, 0x0808, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C86 (ಆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01dc, 0x0222, 0x0222, 0x0200, 0x0178, 0x0084, 0x0178, 0x0200, 0x0200, 0x0200, 0x0000, 0x0000 },	// U+0C87 (ಇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0040, 0x067f, 0x093c, 0x0642, 0x07fe, 0x0442, 0x023c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C88 (ಈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0462, 0x0895, 0x0895, 0x0893, 0x0891, 0x0891, 0x0492, 0x030c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C89 (ಉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3862, 0x4495, 0x4495, 0x4493, 0x6491, 0x5491, 0x5492, 0x230c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C8A (ಊ)
	{ 0x0000, 0x0000, 0x0100, 0x0100, 0x09e6, 0x1109, 0x2216, 0x2210, 0x2210, 0x2216, 0x2529, 0x18c6, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C8B (ಋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00d8, 0x0124, 0x0124, 0x0100, 0x0080, 0x0880, 0x0880, 0x0700, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C8C (ಌ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6dce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0C8D (಍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x007c, 0x0180, 0x0200, 0x0400, 0x0804, 0x108a, 0x1142, 0x0e3c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C8E (ಎ)
	{ 0x0000, 0x0000, 0x0000, 0x0004, 0x0008, 0x0190, 0x0260, 0x0400, 0x0804, 0x108a, 0x1142, 0x0e3c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C8F (ಏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0638, 0x0944, 0x1082, 0x1000, 0x1004, 0x108a, 0x1142, 0x0e3c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C90 (ಐ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x77ce, 0x73b6, 0x778e, 0x77be, 0x63ce, 0x7ffe, 0x0000 },	// U+0C91 (಑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0012, 0x0012, 0x0408, 0x0804, 0x1082, 0x1142, 0x0e3c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C92 (ಒ)
	{ 0x0000, 0x0000, 0x0018, 0x0004, 0x000c, 0x0012, 0x0012, 0x0408, 0x0804, 0x1082, 0x1142, 0x0e3c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C93 (ಓ)
	{ 0x07fe, 0x0840, 0x0840, 0x093e, 0x048c, 0x0312, 0x0012, 0x0408, 0x0804, 0x1082, 0x1142, 0x0e3c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C94 (ಔ)
	{ 0x0000, 0x0000, 0x0300, 0x0400, 0x03f8, 0x0040, 0x0040, 0x03f8, 0x0110, 0x0208, 0x0208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C95 (ಕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0470, 0x0888, 0x1104, 0x2104, 0x2080, 0x20f0, 0x2148, 0x1e30, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C96 (ಖ)
	{ 0x0000, 0x0700, 0x0800, 0x0800, 0x07fc, 0x0220, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C97 (ಗ)
	{ 0x0000, 0x0000, 0x00e0, 0x0100, 0x04ff, 0x0800, 0x1040, 0x1406, 0x0c09, 0x0446, 0x04e4, 0x0358, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+0C98 (ಘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fcc, 0x1032, 0x0c12, 0x0088, 0x0804, 0x1082, 0x1142, 0x0e3c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C99 (ಙ)
	{ 0x0000, 0x0000, 0x0c00, 0x1000, 0x0f06, 0x0109, 0x0209, 0x0704, 0x0202, 0x0221, 0x0251, 0x018e, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C9A (ಚ)
	{ 0x0000, 0x0000, 0x0c00, 0x1000, 0x0f06, 0x0109, 0x0209, 0x0207, 0x0201, 0x0221, 0x0271, 0x01ae, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+0C9B (ಛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x018c, 0x0212, 0x01f2, 0x0008, 0x0204, 0x0442, 0x04a2, 0x031c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C9C (ಜ)
	{ 0x0000, 0x0070, 0x0080, 0x007c, 0x0938, 0x1244, 0x1244, 0x1244, 0x1244, 0x1244, 0x1744, 0x0ab8, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+0C9D (ಝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06d8, 0x0924, 0x0924, 0x0100, 0x0100, 0x00b8, 0x0044, 0x00b8, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+0C9E (ಞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0408, 0x0318, 0x0424, 0x081a, 0x0802, 0x0802, 0x0844, 0x07b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0C9F (ಟ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0200, 0x01f8, 0x00e0, 0x0110, 0x0208, 0x0248, 0x0208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CA0 (ಠ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0200, 0x03fe, 0x0484, 0x0702, 0x0802, 0x0842, 0x08a4, 0x0718, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CA1 (ಡ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0200, 0x03fe, 0x0484, 0x0702, 0x0802, 0x0842, 0x08e4, 0x0758, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+0CA2 (ಢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0718, 0x08a4, 0x1042, 0x1002, 0x1104, 0x1282, 0x0a82, 0x070c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CA3 (ಣ)
	{ 0x0000, 0x0000, 0x0380, 0x0400, 0x03f0, 0x0400, 0x0800, 0x0b08, 0x0488, 0x0b10, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CA4 (ತ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0200, 0x01f8, 0x00e0, 0x0110, 0x0248, 0x0208, 0x0248, 0x01f0, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+0CA5 (ಥ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0200, 0x01f8, 0x00e0, 0x0110, 0x0208, 0x0208, 0x0248, 0x01b0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CA6 (ದ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0200, 0x01f8, 0x00e0, 0x0110, 0x0208, 0x0208, 0x0248, 0x01f0, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+0CA7 (ಧ)
	{ 0x0000, 0x0000, 0x0700, 0x0800, 0x07e0, 0x0200, 0x0400, 0x0800, 0x0818, 0x0824, 0x0444, 0x0388, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CA8 (ನ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7386, 0x6db6, 0x6386, 0x6fb6, 0x73b6, 0x7ffe, 0x0000 },	// U+0CA9 (಩)
	{ 0x0000, 0x0000, 0x0700, 0x0800, 0x07f8, 0x0000, 0x0404, 0x088a, 0x100a, 0x1086, 0x1142, 0x0e3c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CAA (ಪ)
	{ 0x0000, 0x0000, 0x0700, 0x0800, 0x07f8, 0x0000, 0x0404, 0x088a, 0x100a, 0x1086, 0x1142, 0x0ebc, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+0CAB (ಫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x030c, 0x0412, 0x0810, 0x1008, 0x1004, 0x1084, 0x0948, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CAC (ಬ)
	{ 0x0000, 0x0000, 0x0e00, 0x1000, 0x0f8c, 0x0212, 0x0410, 0x0808, 0x1004, 0x1084, 0x0948, 0x06b0, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+0CAD (ಭ)
	{ 0x0000, 0x0000, 0x01c0, 0x0200, 0x01fc, 0x0000, 0x0902, 0x1205, 0x1205, 0x1223, 0x1251, 0x0d8e, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CAE (ಮ)
	{ 0x0000, 0x0000, 0x0000, 0x0300, 0x0400, 0x03cc, 0x0912, 0x1221, 0x1221, 0x1221, 0x1251, 0x0d8e, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CAF (ಯ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0200, 0x01f8, 0x00e0, 0x0110, 0x0208, 0x0208, 0x0208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CB0 (ರ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x194c, 0x1ffc, 0x1004, 0x1084, 0x0948, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CB1 (ಱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x010c, 0x0212, 0x040e, 0x0402, 0x0402, 0x0204, 0x01f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CB2 (ಲ)
	{ 0x0000, 0x0000, 0x0600, 0x0800, 0x0780, 0x010c, 0x0212, 0x040e, 0x0402, 0x0402, 0x0204, 0x01f8, 0x0090, 0x0060, 0x0000, 0x0000 },	// U+0CB3 (ಳ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6dc6, 0x6db6, 0x61c6, 0x6fb6, 0x6fc6, 0x7ffe, 0x0000 },	// U+0CB4 (಴)
	{ 0x0000, 0x0000, 0x0000, 0x0c00, 0x1000, 0x0fc0, 0x0404, 0x080a, 0x100a, 0x1086, 0x1142, 0x0e3c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CB5 (ವ)
	{ 0x0000, 0x0000, 0x0380, 0x0400, 0x03fe, 0x010c, 0x0212, 0x0422, 0x0424, 0x0420, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CB6 (ಶ)
	{ 0x0000, 0x0000, 0x0300, 0x0400, 0x03f0, 0x0000, 0x0404, 0x088a, 0x100a, 0x1486, 0x1942, 0x2e3c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CB7 (ಷ)
	{ 0x0000, 0x0000, 0x0180, 0x0200, 0x01f0, 0x0000, 0x0420, 0x0800, 0x0870, 0x0888, 0x0904, 0x0604, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CB8 (ಸ)
	{ 0x0000, 0x0000, 0x0700, 0x0800, 0x07e0, 0x0100, 0x0540, 0x0ba0, 0x1110, 0x1110, 0x0920, 0x06c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CB9 (ಹ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61c6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+0CBA (಺)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71c6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0CBB (಻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0000 },	// U+0CBC (಼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0020, 0x0010, 0x0020, 0x00c0, 0x0100, 0x0108, 0x00f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CBD (ಽ)
	{ 0x0000, 0x0000, 0x0000, 0x3800, 0x4000, 0x8000, 0x8000, 0xa000, 0x9000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CBE (ಾ)
	{ 0x1800, 0x2400, 0x3800, 0x1000, 0x0c00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CBF (ಿ)
	{ 0x1800, 0x2400, 0x3800, 0x1000, 0x4c00, 0xa000, 0xa000, 0x6000, 0x2000, 0x2000, 0x2000, 0x2000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+0CC0 (ೀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x4000, 0x8000, 0x8000, 0x8000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CC1 (ು)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x9000, 0xd000, 0xd000, 0xd000, 0x1000, 0x1000, 0x0c00, 0x0000, 0x0000 },	// U+0CC2 (ೂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4000, 0x8000, 0x8000, 0xb000, 0xb000, 0x6000 },	// U+0CC3 (ೃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7e00, 0x8400, 0xa800, 0x6800, 0x0800, 0x3000, 0x4000, 0x8000, 0xb000, 0xb000, 0x6000 },	// U+0CC4 (ೄ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x61f6, 0x6ff6, 0x618e, 0x7ffe, 0x0000 },	// U+0CC5 (೅)
	{ 0x1800, 0x2400, 0x2000, 0x1ff0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CC6 (ೆ)
	{ 0x1800, 0x2400, 0x2000, 0x1ff0, 0x4000, 0xa000, 0xa000, 0x6000, 0x2000, 0x2000, 0x2000, 0x2000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+0CC7 (ೇ)
	{ 0x1800, 0x2400, 0x2000, 0x1ff0, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x4000, 0x2000, 0x4000, 0x8000, 0xb000, 0xb000, 0x6000 },	// U+0CC8 (ೈ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x63f6, 0x6ff6, 0x738e, 0x7ffe, 0x0000 },	// U+0CC9 (೉)
	{ 0x1800, 0x2400, 0x2000, 0x1ff0, 0x0000, 0x6000, 0x9000, 0x9000, 0xd000, 0xd000, 0xd000, 0x1000, 0x1000, 0x0c00, 0x0000, 0x0000 },	// U+0CCA (ೊ)
	{ 0xc600, 0xc900, 0x4800, 0x47f0, 0x8000, 0xe000, 0x9000, 0x9000, 0xd000, 0xd000, 0xd000, 0x1000, 0x1000, 0x0c00, 0x0000, 0x0000 },	// U+0CCB (ೋ)
	{ 0x3f00, 0x4800, 0x4700, 0x8000, 0x8000, 0x8000, 0x8000, 0xa000, 0x9000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CCC (ೌ)
	{ 0x0000, 0xc000, 0x2000, 0x7f00, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CCD (್)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+0CCE (೎)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+0CCF (೏)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x6db6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+0CD0 (೐)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x77c6, 0x73b6, 0x77b6, 0x77b6, 0x63c6, 0x7ffe, 0x0000 },	// U+0CD1 (೑)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x61b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+0CD2 (೒)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6fb6, 0x63b6, 0x6fb6, 0x71c6, 0x7ffe, 0x0000 },	// U+0CD3 (೓)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6dc6, 0x6db6, 0x61b6, 0x6fb6, 0x6fc6, 0x7ffe, 0x0000 },	// U+0CD4 (೔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0xa000, 0xa000, 0x6000, 0x2000, 0x2000, 0x2000, 0x2000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+0CD5 (ೕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x4000, 0x2000, 0x4000, 0x8000, 0xb000, 0xb000, 0x6000 },	// U+0CD6 (ೖ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x77b6, 0x7bb6, 0x7bc6, 0x7ffe, 0x0000 },	// U+0CD7 (೗)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x73b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+0CD8 (೘)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x63b6, 0x6fb6, 0x73c6, 0x7ffe, 0x0000 },	// U+0CD9 (೙)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61b6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+0CDA (೚)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71b6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0CDB (೛)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7db6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+0CDC (೜)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x6db6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0CDD (ೝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x194c, 0x1634, 0x1004, 0x1004, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CDE (ೞ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+0CDF (೟)
	{ 0x0000, 0x0000, 0x0200, 0x0200, 0x01f0, 0x7046, 0x8889, 0x888e, 0xc888, 0xa88e, 0xa999, 0x4666, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CE0 (ೠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00d8, 0x0124, 0x0124, 0x0080, 0x0280, 0x1100, 0x0900, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CE1 (ೡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0360, 0x0490, 0x0410, 0x1820 },	// U+0CE2 (ೢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01b0, 0x3248, 0x0a08, 0x3c10 },	// U+0CE3 (ೣ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6f86, 0x7ffe, 0x0000 },	// U+0CE4 (೤)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x6186, 0x7ffe, 0x0000 },	// U+0CE5 (೥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0420, 0x0420, 0x0420, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CE6 (೦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x0810, 0x0420, 0x0240, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CE7 (೧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0880, 0x0c80, 0x0b00, 0x0800, 0x0800, 0x0800, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CE8 (೨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x0148, 0x0248, 0x0230, 0x0270, 0x1288, 0x0908, 0x06f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CE9 (೩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0460, 0x0890, 0x0870, 0x0420, 0x03c0, 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CEA (೪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x2438, 0x24c4, 0x1f08, 0x07e0, 0x0898, 0x0844, 0x0638, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CEB (೫)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x0010, 0x007c, 0x0092, 0x0092, 0x0062, 0x0002, 0x0004, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CEC (೬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0280, 0x0100, 0x00e0, 0x0010, 0x0010, 0x0fe0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CED (೭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0860, 0x0490, 0x0488, 0x0878, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CEE (೮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7fe0, 0x0010, 0x0008, 0x0008, 0x03f0, 0x0008, 0x0008, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0CEF (೯)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0CF0 (೰)
	{ 0x5555, 0x8000, 0x0001, 0x8ff8, 0x0411, 0x8220, 0x0141, 0x8080, 0x0141, 0x8220, 0x0411, 0x8ff8, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0CF1 (ೱ)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0e39, 0x9144, 0x1145, 0x9144, 0x0e39, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+0CF2 (ೲ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x71f6, 0x7ffe, 0x0000 },	// U+0CF3 (ೳ)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6ff6, 0x7ffe, 0x0000 },	// U+0CF4 (೴)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+0CF5 (೵)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0CF6 (೶)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+0CF7 (೷)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0CF8 (೸)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+0CF9 (೹)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+0CFA (೺)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+0CFB (೻)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+0CFC (೼)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+0CFD (೽)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+0CFE (೾)
	{ 0x0000, 0x7ffe, 0x63ce, 0x7db6, 0x7db6, 0x7db6, 0x63ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+0CFF (೿)
	{ 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D00 (ഀ)
	{ 0x0000, 0x0180, 0x0990, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D01 (ഁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D02 (ം)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+0D03 (ഃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0490, 0x0888, 0x0888, 0x0888, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D04 (ഄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c78, 0x1284, 0x213e, 0x2145, 0x393d, 0x2545, 0x2545, 0x1938, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D05 (അ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4c78, 0xb284, 0xb13e, 0xa945, 0xa53d, 0xa545, 0xa545, 0x9938, 0x8000, 0x7c00, 0x0000, 0x0000 },	// U+0D06 (ആ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0318, 0x04a4, 0x0842, 0x0842, 0x084e, 0x0852, 0x0852, 0x084c, 0x0800, 0x07fc, 0x0002, 0x07fc },	// U+0D07 (ഇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0a2e, 0x1551, 0x1551, 0x1551, 0x1053, 0x1255, 0x0c55, 0x0042, 0x0040, 0x003e, 0x0001, 0x003e },	// U+0D08 (ഈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x0148, 0x0248, 0x0230, 0x0200, 0x01f0, 0x0008, 0x03f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D09 (ഉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0a38, 0x1554, 0x1554, 0x1548, 0x1040, 0x1238, 0x0c04, 0x007c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D0A (ഊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x0e38, 0x0808, 0x0410, 0x03e0, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D0B (ഋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x1484, 0x1284, 0x129c, 0x12a4, 0x12a4, 0x0c98, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D0C (ഌ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0D0D (഍)
	{ 0x0000, 0x0000, 0x0f00, 0x1080, 0x148e, 0x1491, 0x1491, 0x17fa, 0x1480, 0x1480, 0x1480, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D0E (എ)
	{ 0x0000, 0x0000, 0x0780, 0x0840, 0x114e, 0x1151, 0x1151, 0x09fa, 0x1140, 0x1140, 0x1140, 0x0c80, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D0F (ഏ)
	{ 0x0000, 0x0000, 0x7000, 0x8800, 0xa9ce, 0xaa35, 0xaa35, 0xbf52, 0xa810, 0xa800, 0xa800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D10 (ഐ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x77de, 0x73ce, 0x77de, 0x77de, 0x638e, 0x7ffe, 0x0000 },	// U+0D11 (഑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0408, 0x0804, 0x0804, 0x043c, 0x0844, 0x0638, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D12 (ഒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1870, 0x2488, 0x2084, 0x2104, 0x2104, 0x208c, 0x2514, 0x18c8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D13 (ഓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1438, 0x2a44, 0x2a42, 0x2a82, 0x2082, 0x2446, 0x188a, 0x0064, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D14 (ഔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0220, 0x0ff8, 0x1224, 0x1224, 0x1224, 0x09d8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D15 (ക)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2078, 0x2084, 0x2102, 0x2202, 0x220e, 0x2212, 0x2112, 0x3f8c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D16 (ഖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e18, 0x1104, 0x2082, 0x2082, 0x1044, 0x0e38, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D17 (ഗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4e00, 0x5100, 0x511c, 0x5122, 0x5122, 0x5ff4, 0x4100, 0x7f00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D18 (ഘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0718, 0x08a4, 0x1042, 0x1042, 0x0e4e, 0x1052, 0x1052, 0x0e4c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D19 (ങ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x1060, 0x1090, 0x1080, 0x1040, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D1A (ച)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x1200, 0x2100, 0x2130, 0x3148, 0x2940, 0x2a20, 0x13fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D1B (ഛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x077c, 0x0882, 0x088e, 0x0892, 0x040c, 0x0ffc, 0x1302, 0x0cfc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D1C (ജ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x243c, 0x447a, 0x44a5, 0x44a5, 0x4499, 0x4481, 0x2482, 0x1b00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D1D (ഝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0318, 0x1ca4, 0x2a42, 0x2942, 0x294e, 0x2952, 0x2952, 0x064c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D1E (ഞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0010, 0x0010, 0x03e0, 0x0400, 0x0400, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D1F (ട)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0808, 0x0808, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D20 (ഠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1230, 0x2248, 0x2244, 0x2244, 0x2244, 0x2248, 0x1240, 0x0d80, 0x0000, 0x0000, 0x0000 },	// U+0D21 (ഡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0918, 0x1524, 0x1524, 0x1524, 0x1524, 0x1920, 0x0920, 0x06c0, 0x0000, 0x0000, 0x0000 },	// U+0D22 (ഢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0d98, 0x1264, 0x1242, 0x1242, 0x1242, 0x124e, 0x1252, 0x0a4c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D23 (ണ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f30, 0x10c8, 0x2144, 0x2224, 0x2424, 0x2424, 0x2244, 0x1188, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D24 (ത)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f02, 0x1082, 0x1082, 0x1082, 0x1082, 0x1082, 0x1082, 0x1ffe, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D25 (ഥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0408, 0x0388, 0x0408, 0x0408, 0x0448, 0x0390, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D26 (ദ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0490, 0x0888, 0x1084, 0x1084, 0x1084, 0x1084, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D27 (ധ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0770, 0x0888, 0x1084, 0x1084, 0x1084, 0x1084, 0x0888, 0x0490, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D28 (ന)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0730, 0x08c8, 0x1084, 0x109c, 0x10a4, 0x10a4, 0x08a4, 0x0498, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D29 (ഩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x1000, 0x101c, 0x1022, 0x1022, 0x1ff4, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D2A (പ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e00, 0x1100, 0x1100, 0x1100, 0x111c, 0x1122, 0x1122, 0x1ff4, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D2B (ഫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1198, 0x1264, 0x1242, 0x1242, 0x1242, 0x124e, 0x1252, 0x1e4c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D2C (ബ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0408, 0x0388, 0x0048, 0x0388, 0x0408, 0x03d0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D2D (ഭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0890, 0x1108, 0x1108, 0x1088, 0x1048, 0x1038, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D2E (മ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1188, 0x2254, 0x2424, 0x2424, 0x2224, 0x2144, 0x10c8, 0x0f30, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D2F (യ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x0308, 0x0504, 0x0884, 0x1084, 0x1084, 0x0904, 0x0608, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D30 (ര)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0410, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D31 (റ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1030, 0x1048, 0x1084, 0x1084, 0x10fc, 0x1004, 0x1004, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D32 (ല)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0408, 0x0404, 0x031c, 0x0424, 0x0418, 0x0400, 0x03f0, 0x0008, 0x0ff0, 0x0000, 0x0000 },	// U+0D33 (ള)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0708, 0x0888, 0x0888, 0x0490, 0x03e0, 0x0080, 0x0088, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D34 (ഴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1078, 0x1084, 0x1102, 0x1102, 0x1102, 0x1102, 0x1082, 0x1fc4, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D35 (വ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e10, 0x1108, 0x2084, 0x2084, 0x3884, 0x2484, 0x2448, 0x1830, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D36 (ശ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x18c0, 0x1520, 0x1320, 0x11c0, 0x111c, 0x1122, 0x1122, 0x1ff4, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D37 (ഷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x086c, 0x1092, 0x1111, 0x1111, 0x1111, 0x1111, 0x0911, 0x0712, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D38 (സ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0880, 0x1040, 0x1040, 0x104e, 0x1051, 0x0891, 0x04fa, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D39 (ഹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x1ff8, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+0D3A (ഺ)
	{ 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D3B (഻)
	{ 0x3000, 0x4800, 0x4800, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D3C (഼)
	{ 0x0000, 0x0800, 0x1400, 0x1400, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0140, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+0D3D (ഽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x8000, 0x8000, 0x8000, 0x8000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D3E (ാ)
	{ 0x0000, 0x6000, 0x9000, 0x9000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D3F (ി)
	{ 0x6000, 0x9000, 0xe000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D40 (ീ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x8000, 0x4000, 0x2000, 0x2000, 0x5000, 0x2000, 0x0000, 0x0000, 0x0000 },	// U+0D41 (ു)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x8000, 0x4000, 0x2000, 0x2000, 0x5000, 0xa800, 0x8800, 0x7000, 0x0000 },	// U+0D42 (ൂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x8000, 0x4000, 0x2000, 0x2000, 0x2000, 0x4000, 0x8000, 0x8000, 0x8000, 0xf800, 0x8400, 0x7800 },	// U+0D43 (ൃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x8000, 0x4000, 0x2000, 0x2000, 0x2000, 0x4000, 0x8000, 0x8000, 0x8000, 0xbb00, 0xa480, 0x7f00 },	// U+0D44 (ൄ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x6186, 0x6fbe, 0x61be, 0x7ffe, 0x0000 },	// U+0D45 (൅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x000e, 0x0011, 0x0011, 0x0011, 0x0013, 0x0015, 0x0015, 0x0012, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+0D46 (െ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0009, 0x0007, 0x0001, 0x0001, 0x0007, 0x0009, 0x0006, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D47 (േ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x001b, 0x002d, 0x002d, 0x002d, 0x0009, 0x0009, 0x001b, 0x001b, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D48 (ൈ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73b6, 0x6db6, 0x6386, 0x6fbe, 0x73be, 0x7ffe, 0x0000 },	// U+0D49 (൉)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x600e, 0x9011, 0x8011, 0x8011, 0x8013, 0x8015, 0x9015, 0x6012, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+0D4A (ൊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x6006, 0x9009, 0x8007, 0x8001, 0x8001, 0x8007, 0x9009, 0x6006, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D4B (ോ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x500e, 0xa811, 0xa811, 0x8011, 0x4013, 0x2015, 0x0015, 0x0012, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+0D4C (ൌ)
	{ 0x4800, 0x8400, 0x8400, 0x7800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D4D (്)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D4E (ൎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0664, 0x0992, 0x110a, 0x113a, 0x114a, 0x114a, 0x114a, 0x1132, 0x0804, 0x07f8, 0x0000, 0x0000 },	// U+0D4F (൏)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6d86, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+0D50 (൐)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x7786, 0x77be, 0x6386, 0x7ffe, 0x0000 },	// U+0D51 (൑)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x6186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+0D52 (൒)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x6386, 0x6fbe, 0x7186, 0x7ffe, 0x0000 },	// U+0D53 (൓)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x0068, 0x0090, 0x0128, 0x0148, 0x0088, 0x0348, 0x0c38, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D54 (ൔ)
	{ 0x0000, 0x0000, 0x0800, 0x1488, 0x0554, 0x0524, 0x0524, 0x0524, 0x0544, 0x04c8, 0x0330, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D55 (ൕ)
	{ 0x0000, 0x0000, 0x0018, 0x0024, 0x0720, 0x08a2, 0x0892, 0x049c, 0x03f0, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D56 (ൖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x5000, 0xa800, 0xa800, 0x8000, 0x4000, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D57 (ൗ)
	{ 0x0000, 0x0000, 0x0700, 0x0800, 0x1250, 0x1248, 0x1244, 0x1244, 0x1244, 0x1244, 0x0a48, 0x05b0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D58 (൘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0038, 0x0c44, 0x1282, 0x1282, 0x0fe2, 0x0092, 0x0092, 0x0064, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D59 (൙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fb0, 0x1248, 0x1444, 0x1444, 0x1444, 0x1444, 0x1248, 0x1f50, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D5A (൚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x08fe, 0x1042, 0x1022, 0x1022, 0x1022, 0x1022, 0x0842, 0x0782, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D5B (൛)
	{ 0x0000, 0x0000, 0x0000, 0x0200, 0x0488, 0x0554, 0x0554, 0x0554, 0x0554, 0x0554, 0x0554, 0x0224, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+0D5C (൜)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x1220, 0x1554, 0x1554, 0x1554, 0x1554, 0x1554, 0x1554, 0x088a, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D5D (൝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0324, 0x1542, 0x1542, 0x08f2, 0x004a, 0x004a, 0x0032, 0x0004, 0x0000, 0x0000, 0x0000 },	// U+0D5E (൞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x0120, 0x0290, 0x2452, 0x5455, 0x5455, 0x2492, 0x0320, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D5F (ൟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0618, 0x0924, 0x161a, 0x1002, 0x0804, 0x07f8, 0x0804, 0x0924, 0x0804, 0x07f8, 0x0000, 0x0000 },	// U+0D60 (ൠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0318, 0x1ca4, 0x2a42, 0x2942, 0x294e, 0x2952, 0x2952, 0x264c, 0x2000, 0x1200, 0x0c00, 0x0000 },	// U+0D61 (ൡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1c9c, 0x12a4, 0x0c98 },	// U+0D62 (ൢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1c9c, 0x12a4, 0x1c18, 0x0f00 },	// U+0D63 (ൣ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6dce, 0x6df6, 0x61c6, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0D64 (൤)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x61c6, 0x6fb6, 0x61ce, 0x7ffe, 0x0000 },	// U+0D65 (൥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D66 (൦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x1080, 0x1080, 0x1080, 0x1080, 0x1080, 0x1080, 0x1ff8, 0x0004, 0x00f8, 0x0000, 0x0000 },	// U+0D67 (൧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0078, 0x0084, 0x0102, 0x0102, 0x0102, 0x0102, 0x0082, 0x1fc4, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D68 (൨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00d8, 0x0124, 0x0222, 0x0222, 0x0222, 0x0222, 0x0222, 0x3e24, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D69 (൩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0080, 0x0080, 0x03e0, 0x0490, 0x0488, 0x0488, 0x0308, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D6A (൪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1188, 0x1248, 0x1148, 0x1248, 0x1248, 0x0a10, 0x01e0, 0x0000, 0x0000, 0x0000 },	// U+0D6B (൫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x18d8, 0x2524, 0x4222, 0x4222, 0x4222, 0x4222, 0x4222, 0x4224, 0x2000, 0x1000, 0x0800, 0x0000 },	// U+0D6C (൬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x1008, 0x1008, 0x1078, 0x1088, 0x1070, 0x0800, 0x0400, 0x0380, 0x0000 },	// U+0D6D (൭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1078, 0x1084, 0x1102, 0x1102, 0x1102, 0x1102, 0x1082, 0x1fc4, 0x1000, 0x1000, 0x0e00, 0x0000 },	// U+0D6E (൮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0100, 0x0100, 0x07d8, 0x0924, 0x0922, 0x0922, 0x0624, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D6F (൯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1240, 0x2240, 0x2240, 0x2240, 0x2240, 0x2240, 0x1240, 0x0dc0, 0x0040, 0x003c, 0x0000 },	// U+0D70 (൰)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0770, 0x0888, 0x1084, 0x1084, 0x1084, 0x1088, 0x0800, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000 },	// U+0D71 (൱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x21d8, 0x5224, 0x5422, 0x7f22, 0x04a2, 0x04a2, 0x0522, 0x0224, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D72 (൲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff0, 0x0008, 0x0038, 0x0048, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D73 (൳)
	{ 0x0000, 0x0380, 0x0400, 0x0800, 0x0bf0, 0x0408, 0x0a04, 0x0904, 0x091c, 0x0924, 0x0924, 0x0618, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D74 (൴)
	{ 0x0000, 0x0700, 0x0800, 0x1000, 0x1630, 0x0948, 0x1484, 0x1284, 0x129c, 0x12a4, 0x12a4, 0x0c98, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D75 (൵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x1280, 0x1440, 0x1440, 0x144e, 0x1251, 0x11d1, 0x1ffa, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D76 (൶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0cc0, 0x5320, 0x5120, 0x3920, 0x1526, 0x1529, 0x1529, 0x0979, 0x0002, 0x0000, 0x0000, 0x0000 },	// U+0D77 (൷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7d10, 0x92aa, 0xa2aa, 0xa2aa, 0xa2aa, 0xa2aa, 0x92aa, 0xfa45, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D78 (൸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01d8, 0x0224, 0x0422, 0x7f22, 0x04a2, 0x04a2, 0x0522, 0x0224, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D79 (൹)
	{ 0x0000, 0x0c00, 0x1200, 0x2000, 0x2ed8, 0x1124, 0x1922, 0x1522, 0x1526, 0x152a, 0x152a, 0x0924, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D7A (ൺ)
	{ 0x0000, 0x0700, 0x0800, 0x1000, 0x1630, 0x0948, 0x1484, 0x1284, 0x1284, 0x1284, 0x1288, 0x0c90, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D7B (ൻ)
	{ 0x0000, 0x0300, 0x0400, 0x0800, 0x0be0, 0x0410, 0x0a08, 0x0908, 0x0908, 0x0908, 0x0910, 0x0620, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D7C (ർ)
	{ 0x0000, 0x0700, 0x0800, 0x1000, 0x1738, 0x08c4, 0x14a2, 0x1292, 0x1292, 0x1292, 0x1292, 0x0c64, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D7D (ൽ)
	{ 0x0000, 0x0700, 0x0800, 0x1000, 0x1600, 0x0908, 0x1484, 0x1284, 0x1284, 0x1284, 0x1248, 0x0c30, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D7E (ൾ)
	{ 0x0000, 0x01c0, 0x0220, 0x0400, 0x04e0, 0x0510, 0x0510, 0x1ffc, 0x2512, 0x2512, 0x1912, 0x00ec, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D7F (ൿ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6dce, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0D80 (඀)
	{ 0x0000, 0x0990, 0x0990, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D81 (ඁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D82 (ං)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x9000, 0x6000, 0x0000, 0x6000, 0x9000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000 },	// U+0D83 (ඃ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6dce, 0x6db6, 0x61ce, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0D84 (඄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x18c0, 0x1520, 0x1600, 0x0ff0, 0x0408, 0x0408, 0x0410, 0x07e0, 0x0400, 0x0400, 0x0400, 0x0400 },	// U+0D85 (අ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1b18, 0x26a4, 0x42c0, 0x41fe, 0x4081, 0x4081, 0x2482, 0x18fc, 0x0080, 0x0080, 0x0080, 0x0080 },	// U+0D86 (ආ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0230, 0x0548, 0x7d80, 0x43fc, 0x2102, 0x2102, 0x2104, 0x21f8, 0x2100, 0x2100, 0x2100, 0xc100 },	// U+0D87 (ඇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0230, 0x0548, 0x7d80, 0x23fc, 0x1102, 0x7902, 0x4104, 0x21f8, 0x2100, 0x2100, 0x2100, 0xc100 },	// U+0D88 (ඈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0888, 0x0948, 0x0888, 0x0670, 0x0800, 0x0700, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D89 (ඉ)
	{ 0x0010, 0x00a8, 0x0490, 0x0a40, 0x0420, 0x00e0, 0x0110, 0x0208, 0x0208, 0x0208, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D8A (ඊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0400, 0x07f0, 0x0008, 0x0808, 0x0408, 0x03f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D8B (උ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3460, 0x5490, 0x4900, 0x41fc, 0x4802, 0x3202, 0x0102, 0x00fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D8C (ඌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0186, 0x0249, 0x6450, 0x97de, 0x8401, 0xe421, 0x9251, 0x618e, 0x8001, 0x0000, 0x0000, 0x0000 },	// U+0D8D (ඍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0042, 0x00a5, 0x4928, 0xb5ee, 0x9101, 0xd911, 0xb4a9, 0x4846, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D8E (ඎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c38, 0x2a54, 0x4242, 0x4e72, 0x500a, 0x4812, 0x27e4, 0x1008, 0x0ff0, 0x0000, 0x0000, 0x0000 },	// U+0D8F (ඏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x038e, 0x0555, 0x6c51, 0xaddd, 0x9505, 0x8505, 0x94f9, 0x6202, 0x01fc, 0x0000, 0x0000, 0x0000 },	// U+0D90 (ඐ)
	{ 0x01c0, 0x0120, 0x01c0, 0x0100, 0x0130, 0x0240, 0x047c, 0x0408, 0x0404, 0x0404, 0x0208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D91 (එ)
	{ 0x1dc0, 0x2520, 0x1dc0, 0x0500, 0x0530, 0x0640, 0x047c, 0x0408, 0x0404, 0x0404, 0x0208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D92 (ඒ)
	{ 0x3800, 0x2400, 0x3800, 0x2000, 0x2600, 0x480e, 0x8f91, 0x8121, 0x80cd, 0x809d, 0x4111, 0x3e0e, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D93 (ඓ)
	{ 0x0000, 0x0000, 0x0000, 0x07fc, 0x0802, 0x1380, 0x2586, 0x240a, 0x23f2, 0x2002, 0x1084, 0x0f78, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D94 (ඔ)
	{ 0x0000, 0x03fe, 0x0404, 0x0ffc, 0x0802, 0x1380, 0x2586, 0x240a, 0x23f2, 0x2002, 0x1084, 0x0f78, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D95 (ඕ)
	{ 0x0000, 0x0000, 0x0000, 0x00fe, 0x0101, 0x0270, 0x36b0, 0x5683, 0x4a7d, 0x4201, 0x4911, 0x30ee, 0xe000, 0x0000, 0x0000, 0x0000 },	// U+0D96 (ඖ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x778e, 0x7bbe, 0x7bce, 0x7ffe, 0x0000 },	// U+0D97 (඗)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x738e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+0D98 (඘)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x638e, 0x6fbe, 0x73ce, 0x7ffe, 0x0000 },	// U+0D99 (඙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x07c9, 0x0831, 0x13f0, 0x1408, 0x1404, 0x1222, 0x09dd, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D9A (ක)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0804, 0x10f0, 0x1108, 0x1204, 0x1204, 0x0934, 0x0738, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+0D9B (ඛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e4, 0x0212, 0x0471, 0x0441, 0x0222, 0x011c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D9C (ග)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x010c, 0x0292, 0x02a0, 0x01be, 0x0208, 0x0404, 0x04e4, 0x0318, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D9D (ඝ)
	{ 0x0000, 0x0000, 0x01fc, 0x0202, 0x0438, 0x0858, 0x0840, 0x087c, 0x0802, 0x0802, 0x0444, 0x03b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D9E (ඞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c38, 0x2254, 0x4242, 0x4e72, 0x480a, 0x4412, 0x23e4, 0x11f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0D9F (ඟ)
	{ 0x0000, 0x0000, 0x00f8, 0x0104, 0x0230, 0x0440, 0x047c, 0x0408, 0x0404, 0x0404, 0x0208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DA0 (ච)
	{ 0x0000, 0x0400, 0x0200, 0x0100, 0x0d30, 0x1340, 0x1e7c, 0x3208, 0x4c04, 0x4004, 0x2008, 0x1ff0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DA1 (ඡ)
	{ 0x0000, 0x1000, 0x0800, 0x0400, 0x0430, 0x0e40, 0x157c, 0x1508, 0x0e04, 0x0404, 0x0208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DA2 (ජ)
	{ 0x0000, 0x0000, 0x0000, 0x0e00, 0x1107, 0x2009, 0x43e4, 0x441e, 0x4261, 0x4181, 0x4993, 0x366d, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DA3 (ඣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f9c, 0x146a, 0x2021, 0x3e19, 0x0165, 0x0183, 0x2293, 0x1c6d, 0x1000, 0x0800, 0x0800, 0x3000 },	// U+0DA4 (ඤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c1c, 0x2a2a, 0x4121, 0x7d99, 0x0785, 0x0243, 0x3223, 0x2c1c, 0x2000, 0x1000, 0x1000, 0x6000 },	// U+0DA5 (ඥ)
	{ 0x0000, 0x2000, 0x1000, 0x0800, 0x09b8, 0x1c54, 0x2a42, 0x2a32, 0x1c0a, 0x0806, 0x0406, 0x03f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DA6 (ඦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x0204, 0x0400, 0x0438, 0x0404, 0x0404, 0x0208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DA7 (ට)
	{ 0x0380, 0x0240, 0x0380, 0x0200, 0x0200, 0x0400, 0x0800, 0x0804, 0x0802, 0x0802, 0x0444, 0x03b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DA8 (ඨ)
	{ 0x0000, 0x0000, 0x03f8, 0x0404, 0x0830, 0x1040, 0x107c, 0x1008, 0x1004, 0x1004, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DA9 (ඩ)
	{ 0x0380, 0x0240, 0x0380, 0x0200, 0x0218, 0x0420, 0x083e, 0x0804, 0x0802, 0x0802, 0x0444, 0x03b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DAA (ඪ)
	{ 0x0000, 0x0000, 0x1f00, 0x0080, 0x0078, 0x0064, 0x309c, 0x4aac, 0x4d9c, 0x4a82, 0x3041, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DAB (ණ)
	{ 0x0000, 0x0000, 0x03f8, 0x0404, 0x08e0, 0x1150, 0x1108, 0x10c8, 0x1028, 0x1018, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DAC (ඬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x07c9, 0x0831, 0x13f0, 0x1408, 0x1404, 0x1202, 0x09fd, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DAD (ත)
	{ 0x0380, 0x0240, 0x0380, 0x0200, 0x0208, 0x0404, 0x0802, 0x0802, 0x0802, 0x0802, 0x0404, 0x03f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DAE (ථ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0480, 0x0400, 0x07e0, 0x0020, 0x0c20, 0x0bc0, 0x0800, 0x0400, 0x0400, 0x1800 },	// U+0DAF (ද)
	{ 0x0000, 0x0000, 0x03f0, 0x0408, 0x0804, 0x1000, 0x1030, 0x1008, 0x1004, 0x1004, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DB0 (ධ)
	{ 0x0000, 0x0000, 0x0000, 0x0700, 0x0886, 0x1049, 0x2031, 0x20f0, 0x2108, 0x2104, 0x2482, 0x187d, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DB1 (න)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x61c6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+0DB2 (඲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x02a0, 0x0410, 0x07d0, 0x0030, 0x0030, 0x0440, 0x0380, 0x0200, 0x0100, 0x0100, 0x0600 },	// U+0DB3 (ඳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0860, 0x1480, 0x16c0, 0x1830, 0x2008, 0x1830, 0x07c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DB4 (ප)
	{ 0x0000, 0x0700, 0x0480, 0x0700, 0x0400, 0x0460, 0x0880, 0x10c0, 0x1030, 0x2008, 0x1830, 0x07c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DB5 (ඵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0804, 0x10f0, 0x1108, 0x1204, 0x1204, 0x0934, 0x0638, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DB6 (බ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e0c, 0x1112, 0x20a0, 0x23be, 0x2208, 0x2104, 0x1084, 0x0878, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DB7 (භ)
	{ 0x0000, 0x0000, 0x0000, 0x07f8, 0x0804, 0x1380, 0x1458, 0x1558, 0x1468, 0x13c8, 0x0810, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DB8 (ම)
	{ 0x0000, 0x0000, 0x0000, 0x07f8, 0x0804, 0x1380, 0x14d8, 0x17d8, 0x17e8, 0x1008, 0x0990, 0x0660, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DB9 (ඹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0280, 0x0380, 0x0208, 0x0404, 0x0444, 0x03b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DBA (ය)
	{ 0x0000, 0x0080, 0x0080, 0x0040, 0x0020, 0x00e0, 0x0110, 0x0208, 0x0208, 0x0208, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DBB (ර)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7dc6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+0DBC (඼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x0208, 0x04e4, 0x1244, 0x1184, 0x0804, 0x0408, 0x03f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DBD (ල)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71c6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+0DBE (඾)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71c6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+0DBF (඿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0404, 0x0862, 0x0882, 0x08f0, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DC0 (ව)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e4, 0x0412, 0x0871, 0x0a41, 0x0522, 0x021c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DC1 (ශ)
	{ 0x0000, 0x0000, 0x0000, 0x0230, 0x0540, 0x0770, 0x0408, 0x0ac4, 0x0924, 0x08c4, 0x0408, 0x03f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DC2 (ෂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x010c, 0x0292, 0x02a0, 0x01be, 0x0208, 0x0404, 0x0444, 0x03b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DC3 (ස)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e0c, 0x1112, 0x20a0, 0x23b8, 0x2208, 0x2104, 0x1084, 0x0878, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DC4 (හ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0360, 0x0490, 0x0410, 0x07f8, 0x5018, 0x4fe8, 0x2008, 0x1ff0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DC5 (ළ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0770, 0x0888, 0x1004, 0x1004, 0x0808, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DC6 (ෆ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x618e, 0x6ff6, 0x77f6, 0x7bf6, 0x7b8e, 0x7ffe, 0x0000 },	// U+0DC7 (෇)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x73f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+0DC8 (෈)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x63f6, 0x6ff6, 0x738e, 0x7ffe, 0x0000 },	// U+0DC9 (෉)
	{ 0x7000, 0x9000, 0x7000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DCA (්)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x71f6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+0DCB (෋)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x638e, 0x7df6, 0x7df6, 0x7df6, 0x638e, 0x7ffe, 0x0000 },	// U+0DCC (෌)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x6df6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+0DCD (෍)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+0DCE (෎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x8000, 0x8000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DCF (ා)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7c00, 0x4000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0xc000, 0x0000, 0x0000 },	// U+0DD0 (ැ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7000, 0x4000, 0x2000, 0x4000, 0x2000, 0x2000, 0x2000, 0xc000, 0x0000, 0x0000 },	// U+0DD1 (ෑ)
	{ 0x0fe0, 0x1010, 0x1010, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DD2 (ි)
	{ 0x0fe0, 0x1210, 0x1210, 0x0c20, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DD3 (ී)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0830, 0x0808, 0x0ff0 },	// U+0DD4 (ු)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x61b6, 0x6fb6, 0x61c6, 0x7ffe, 0x0000 },	// U+0DD5 (෕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0830, 0x0b08, 0x0cf0 },	// U+0DD6 (ූ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x77b6, 0x7bb6, 0x7bc6, 0x7ffe, 0x0000 },	// U+0DD7 (෗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x8000, 0xe000, 0x9000, 0x6000, 0x8000, 0x0000, 0x0000, 0x0000 },	// U+0DD8 (ෘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0005, 0x0009, 0x0009, 0x0001, 0x0007, 0x0007, 0x0007, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DD9 (ෙ)
	{ 0x7000, 0x9000, 0x7000, 0x1000, 0x1002, 0x1005, 0x1009, 0x0009, 0x0001, 0x0007, 0x0007, 0x0007, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DDA (ේ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x002d, 0x0009, 0x0009, 0x0009, 0x003f, 0x003f, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DDB (ෛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0005, 0x6009, 0x9009, 0x8001, 0x8007, 0x9007, 0x6007, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DDC (ො)
	{ 0x7000, 0x9000, 0x7000, 0x1000, 0x1002, 0x1005, 0x7009, 0x9009, 0x8001, 0x8007, 0x9007, 0x6007, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DDD (ෝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2002, 0x1005, 0x5009, 0xb009, 0x8001, 0x8007, 0x9007, 0x6007, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DDE (ෞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x1000, 0x5000, 0xb000, 0x8000, 0x8000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DDF (ෟ)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+0DE0 (෠)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x6386, 0x7ffe, 0x0000 },	// U+0DE1 (෡)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+0DE2 (෢)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x7186, 0x7ffe, 0x0000 },	// U+0DE3 (෣)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6f86, 0x7ffe, 0x0000 },	// U+0DE4 (෤)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x6186, 0x7ffe, 0x0000 },	// U+0DE5 (෥)
	{ 0x0000, 0x0000, 0x00e0, 0x0110, 0x0108, 0x0108, 0x07f0, 0x0900, 0x0900, 0x0780, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100 },	// U+0DE6 (෦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0404, 0x09e2, 0x0a92, 0x0a92, 0x0a62, 0x0904, 0x08f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DE7 (෧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x31f8, 0x4a04, 0x44f2, 0x454a, 0x454a, 0x4532, 0x2484, 0x1478, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DE8 (෨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x347c, 0x4a82, 0x4939, 0x4955, 0x4955, 0x4949, 0x4522, 0x351c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DE9 (෩)
	{ 0x1000, 0x0800, 0x0410, 0x0e38, 0x1554, 0x194c, 0x0220, 0x0c18, 0x1004, 0x1004, 0x0808, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DEA (෪)
	{ 0x0000, 0x0080, 0x01c0, 0x02a0, 0x0260, 0x0100, 0x00c0, 0x0020, 0x0820, 0x0640, 0x0180, 0x0100, 0x0100, 0x0e00, 0x0000, 0x0000 },	// U+0DEB (෫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0770, 0x0888, 0x3e34, 0x5144, 0x4948, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DEC (෬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0408, 0x0248, 0x0230, 0x0200, 0x0100, 0x0100, 0x2100, 0x2100, 0x1e00, 0x0000, 0x0000 },	// U+0DED (෭)
	{ 0x0000, 0x0200, 0x0100, 0x0080, 0x0040, 0x0320, 0x0490, 0x0848, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DEE (෮)
	{ 0x07e0, 0x0910, 0x0610, 0x0020, 0x31f8, 0x4a04, 0x44f2, 0x454a, 0x454a, 0x4532, 0x2484, 0x1478, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DEF (෯)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0DF0 (෰)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x63f6, 0x7ffe, 0x0000 },	// U+0DF1 (෱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4800, 0xb400, 0x9000, 0xd800, 0xb400, 0x4800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DF2 (ෲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x1000, 0x5000, 0xb000, 0x8000, 0xa000, 0xd000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DF3 (ෳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0550, 0x2552, 0x2aaa, 0x12a4, 0x280a, 0x6003, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0DF4 (෴)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+0DF5 (෵)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0DF6 (෶)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+0DF7 (෷)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0DF8 (෸)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+0DF9 (෹)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+0DFA (෺)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+0DFB (෻)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+0DFC (෼)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+0DFD (෽)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+0DFE (෾)
	{ 0x0000, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+0DFF (෿)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6db6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0E00 (฀)
}; // 1281

static const uint16_t unifontdw_block40[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x718e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+0E3B (฻)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x63c6, 0x7dbe, 0x7d8e, 0x7dbe, 0x63c6, 0x7ffe, 0x0000 },	// U+0E3C (฼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x6d8e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+0E3D (฽)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7dbe, 0x718e, 0x7dbe, 0x61c6, 0x7ffe, 0x0000 },	// U+0E3E (฾)
}; // 4

static const uint16_t unifontdw_block41[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0024, 0x0002, 0x0002, 0x4002, 0x4542, 0x4aa4, 0x3018, 0x0000, 0x0000 },	// U+0E5B (๛)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7d86, 0x7dbe, 0x6386, 0x7ffe, 0x0000 },	// U+0E5C (๜)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6d86, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+0E5D (๝)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+0E5E (๞)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x7d86, 0x7ffe, 0x0000 },	// U+0E5F (๟)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6df6, 0x6dc6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0E60 (๠)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x77ce, 0x73f6, 0x77c6, 0x77b6, 0x63ce, 0x7ffe, 0x0000 },	// U+0E61 (๡)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6ff6, 0x61c6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+0E62 (๢)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6ff6, 0x63c6, 0x6fb6, 0x71ce, 0x7ffe, 0x0000 },	// U+0E63 (๣)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6dce, 0x6df6, 0x61c6, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+0E64 (๤)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x61c6, 0x6fb6, 0x61ce, 0x7ffe, 0x0000 },	// U+0E65 (๥)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x73ce, 0x7df6, 0x71c6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0E66 (๦)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6ff6, 0x77c6, 0x7bb6, 0x7bce, 0x7ffe, 0x0000 },	// U+0E67 (๧)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6df6, 0x73c6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0E68 (๨)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6df6, 0x63c6, 0x6fb6, 0x73ce, 0x7ffe, 0x0000 },	// U+0E69 (๩)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61ce, 0x6df6, 0x61c6, 0x6db6, 0x6dce, 0x7ffe, 0x0000 },	// U+0E6A (๪)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6df6, 0x71c6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0E6B (๫)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x63ce, 0x7df6, 0x7dc6, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+0E6C (๬)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6df6, 0x6dc6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0E6D (๭)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+0E6E (๮)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+0E6F (๯)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x6dde, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0E70 (๰)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7786, 0x73be, 0x77de, 0x77ee, 0x63ee, 0x7ffe, 0x0000 },	// U+0E71 (๱)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x61de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+0E72 (๲)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6fbe, 0x63de, 0x6fee, 0x71ee, 0x7ffe, 0x0000 },	// U+0E73 (๳)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6dbe, 0x61de, 0x6fee, 0x6fee, 0x7ffe, 0x0000 },	// U+0E74 (๴)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x61de, 0x6fee, 0x61ee, 0x7ffe, 0x0000 },	// U+0E75 (๵)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x7dbe, 0x71de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0E76 (๶)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x77de, 0x7bee, 0x7bee, 0x7ffe, 0x0000 },	// U+0E77 (๷)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x73de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0E78 (๸)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x63de, 0x6fee, 0x73ee, 0x7ffe, 0x0000 },	// U+0E79 (๹)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x61de, 0x6dee, 0x6dee, 0x7ffe, 0x0000 },	// U+0E7A (๺)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x71de, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+0E7B (๻)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7dde, 0x7dee, 0x63ee, 0x7ffe, 0x0000 },	// U+0E7C (๼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+0E7D (๽)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+0E7E (๾)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+0E7F (๿)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x6dce, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+0E80 (຀)
}; // 38

static const uint16_t unifontdw_block42[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6fb6, 0x63ce, 0x6fb6, 0x71ce, 0x7ffe, 0x0000 },	// U+0E83 (຃)
}; // 1

static const uint16_t unifontdw_block43[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x61ce, 0x6fb6, 0x61ce, 0x7ffe, 0x0000 },	// U+0E85 (຅)
}; // 1

static const uint16_t unifontdw_block44[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x71ce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0E8B (຋)
}; // 1

static const uint16_t unifontdw_block45[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6db6, 0x6186, 0x6fb6, 0x6fb6, 0x7ffe, 0x0000 },	// U+0EA4 (຤)
}; // 1

static const uint16_t unifontdw_block46[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x7db6, 0x7186, 0x6db6, 0x73b6, 0x7ffe, 0x0000 },	// U+0EA6 (຦)
}; // 1

static const uint16_t unifontdw_block47[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71c6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+0EBE (຾)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71c6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+0EBF (຿)
}; // 2

static const uint16_t unifontdw_block48[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x61f6, 0x6ff6, 0x618e, 0x7ffe, 0x0000 },	// U+0EC5 (໅)
}; // 1

static const uint16_t unifontdw_block49[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x618e, 0x6ff6, 0x77f6, 0x7bf6, 0x7b8e, 0x7ffe, 0x0000 },	// U+0EC7 (໇)
}; // 1

static const uint16_t unifontdw_block50[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+0ECE (໎)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+0ECF (໏)
}; // 2

static const uint16_t unifontdw_block51[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61b6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+0EDA (໚)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71b6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0EDB (໛)
}; // 2

static const uint16_t unifontdw_block52[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+0EE0 (໠)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x6386, 0x7ffe, 0x0000 },	// U+0EE1 (໡)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+0EE2 (໢)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x7186, 0x7ffe, 0x0000 },	// U+0EE3 (໣)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6f86, 0x7ffe, 0x0000 },	// U+0EE4 (໤)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x6186, 0x7ffe, 0x0000 },	// U+0EE5 (໥)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+0EE6 (໦)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7b86, 0x7ffe, 0x0000 },	// U+0EE7 (໧)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+0EE8 (໨)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x7386, 0x7ffe, 0x0000 },	// U+0EE9 (໩)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6d86, 0x7ffe, 0x0000 },	// U+0EEA (໪)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+0EEB (໫)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x6386, 0x7ffe, 0x0000 },	// U+0EEC (໬)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+0EED (໭)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+0EEE (໮)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7d86, 0x7ffe, 0x0000 },	// U+0EEF (໯)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0EF0 (໰)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x63f6, 0x7ffe, 0x0000 },	// U+0EF1 (໱)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+0EF2 (໲)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x71f6, 0x7ffe, 0x0000 },	// U+0EF3 (໳)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6ff6, 0x7ffe, 0x0000 },	// U+0EF4 (໴)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+0EF5 (໵)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0EF6 (໶)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+0EF7 (໷)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0EF8 (໸)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+0EF9 (໹)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+0EFA (໺)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+0EFB (໻)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+0EFC (໼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+0EFD (໽)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+0EFE (໾)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x61ce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+0EFF (໿)
}; // 32

static const uint16_t unifontdw_block53[][16] = {
	{ 0x0008, 0x0008, 0x0018, 0x0c22, 0x125d, 0x123e, 0x0c1e, 0x0021, 0x0c11, 0x1239, 0x1244, 0x0c40, 0x0060, 0x0086, 0x0048, 0x0030 },	// U+0F02 (༂)
	{ 0x0008, 0x0008, 0x0018, 0x0c22, 0x125d, 0x123e, 0x0c1e, 0x0021, 0x1e11, 0x0039, 0x0c44, 0x1240, 0x1260, 0x0c86, 0x0048, 0x0030 },	// U+0F03 (༃)
}; // 2

static const uint16_t unifontdw_block54[][16] = {
	{ 0x4000, 0x41fe, 0x41fe, 0x4006, 0x7ffe, 0x7ffe, 0x4180, 0x41fe, 0x41fe, 0x4000, 0x7ffe, 0x4100, 0x7ffe, 0x4002, 0x7ffe, 0x4000 },	// U+0F16 (༖)
	{ 0x8800, 0x9100, 0x9220, 0x5244, 0x4a48, 0x2948, 0x3fc8, 0x28ea, 0x281a, 0x241a, 0x23ea, 0x100a, 0x0fec, 0x0018, 0x0008, 0x0000 },	// U+0F17 (༗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x8000, 0x9800, 0xa400, 0x6400, 0x1800, 0x0980, 0x0640, 0x0240, 0x0180, 0x0090, 0x0060 },	// U+0F18 (༘)
}; // 3

static const uint16_t unifontdw_block55[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0100, 0x0290, 0x0928, 0x1423, 0x091c, 0x0280, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0F3A (༺)
	{ 0x0000, 0x0000, 0x0000, 0x0040, 0x04a0, 0x0a48, 0x6214, 0x1c48, 0x00a0, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0F3B (༻)
}; // 2

static const uint16_t unifontdw_block56[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x73b6, 0x6db6, 0x7386, 0x6dbe, 0x73be, 0x7ffe, 0x0000 },	// U+0F48 (཈)
}; // 1

static const uint16_t unifontdw_block57[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x71ce, 0x6df6, 0x6dc6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+0F6D (཭)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+0F6E (཮)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+0F6F (཯)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x6dde, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+0F70 (཰)
}; // 4

static const uint16_t unifontdw_block58[][16] = {
	{ 0x0000, 0x01fc, 0x0050, 0x0020, 0x0050, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0F88 (ྈ)
}; // 1

static const uint16_t unifontdw_block59[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x738e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+0F98 (྘)
}; // 1

static const uint16_t unifontdw_block60[][16] = {
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x6dc6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0FBD (྽)
}; // 1

static const uint16_t unifontdw_block61[][16] = {
	{ 0x06b0, 0x0140, 0x0080, 0x01c0, 0x0630, 0x0c98, 0x0a28, 0x1144, 0x1084, 0x0aa8, 0x0888, 0x06b0, 0x01c0, 0x0080, 0x0140, 0x06b0 },	// U+0FC5 (࿅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x22a2, 0x1554, 0x1554, 0x0948, 0x07f0, 0x0aa8, 0x12a4 },	// U+0FC6 (࿆)
	{ 0x06b0, 0x0140, 0x0080, 0x01c0, 0x4631, 0x4c99, 0x2a2a, 0x5145, 0x5085, 0x2aaa, 0x4889, 0x46b1, 0x01c0, 0x0080, 0x0140, 0x06b0 },	// U+0FC7 (࿇)
	{ 0x0000, 0x06b0, 0x0140, 0x0080, 0x1ffc, 0x1224, 0x0948, 0x0948, 0x0490, 0x0490, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080, 0x0000 },	// U+0FC8 (࿈)
	{ 0x0000, 0x0000, 0x01c0, 0x0220, 0x0490, 0x0a28, 0x09c8, 0x1414, 0x13e4, 0x1004, 0x1004, 0x0808, 0x0c18, 0x03e0, 0x0000, 0x0000 },	// U+0FC9 (࿉)
	{ 0x0000, 0x03e0, 0x0410, 0x180c, 0x1004, 0x2002, 0x6079, 0x6485, 0x6083, 0x5093, 0x4f03, 0x2002, 0x1004, 0x180c, 0x0410, 0x03e0 },	// U+0FCA (࿊)
	{ 0x0000, 0x03e0, 0x0410, 0x180c, 0x303c, 0x3242, 0x5081, 0x4889, 0x4781, 0x4081, 0x4041, 0x2242, 0x1044, 0x184c, 0x0490, 0x03e0 },	// U+0FCB (࿋)
	{ 0x0000, 0x03e0, 0x0410, 0x1c0c, 0x1484, 0x243e, 0x4241, 0x4181, 0x4491, 0x40c1, 0x4121, 0x3e12, 0x1094, 0x181c, 0x0410, 0x03e0 },	// U+0FCC (࿌)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x6df6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+0FCD (࿍)
}; // 9

static const uint16_t unifontdw_block62[][16] = {
	{ 0x0000, 0x0000, 0x00f8, 0x0104, 0x2202, 0x1cf0, 0x0108, 0x0100, 0x0080, 0x00e0, 0x0110, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+0FD0 (࿐)
}; // 1

static const uint16_t unifontdw_block63[][16] = {
	{ 0x0000, 0x0000, 0x3f82, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x3ffe, 0x2080, 0x2080, 0x2080, 0x2080, 0x2080, 0x20fe, 0x0000 },	// U+0FD5 (࿕)
	{ 0x0000, 0x0000, 0x20fe, 0x2080, 0x2080, 0x2080, 0x2080, 0x2080, 0x3ffe, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x3f82, 0x0000 },	// U+0FD6 (࿖)
	{ 0x0000, 0x0000, 0x3f82, 0x0082, 0x0082, 0x0492, 0x0082, 0x0082, 0x3ffe, 0x2080, 0x2080, 0x2490, 0x2080, 0x2080, 0x20fe, 0x0000 },	// U+0FD7 (࿗)
	{ 0x0000, 0x0000, 0x20fe, 0x2080, 0x2080, 0x2490, 0x2080, 0x2080, 0x3ffe, 0x0082, 0x0082, 0x0492, 0x0082, 0x0082, 0x3f82, 0x0000 },	// U+0FD8 (࿘)
	{ 0x0000, 0x0000, 0x0000, 0x0002, 0x0006, 0x0002, 0x0000, 0x4008, 0x6018, 0x4008, 0x0000, 0x0840, 0x1ce0, 0x0000, 0x0000, 0x0000 },	// U+0FD9 (࿙)
	{ 0x0000, 0x0000, 0x0000, 0x4000, 0x6000, 0x4000, 0x0000, 0x1002, 0x1806, 0x1002, 0x0000, 0x0210, 0x0738, 0x0000, 0x0000, 0x0000 },	// U+0FDA (࿚)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71b6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0FDB (࿛)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7db6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+0FDC (࿜)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x6db6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+0FDD (࿝)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+0FDE (࿞)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+0FDF (࿟)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+0FE0 (࿠)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x6386, 0x7ffe, 0x0000 },	// U+0FE1 (࿡)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+0FE2 (࿢)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x7186, 0x7ffe, 0x0000 },	// U+0FE3 (࿣)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6f86, 0x7ffe, 0x0000 },	// U+0FE4 (࿤)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x6186, 0x7ffe, 0x0000 },	// U+0FE5 (࿥)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+0FE6 (࿦)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7b86, 0x7ffe, 0x0000 },	// U+0FE7 (࿧)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+0FE8 (࿨)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x7386, 0x7ffe, 0x0000 },	// U+0FE9 (࿩)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6d86, 0x7ffe, 0x0000 },	// U+0FEA (࿪)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+0FEB (࿫)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x6386, 0x7ffe, 0x0000 },	// U+0FEC (࿬)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+0FED (࿭)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+0FEE (࿮)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7d86, 0x7ffe, 0x0000 },	// U+0FEF (࿯)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0FF0 (࿰)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x63f6, 0x7ffe, 0x0000 },	// U+0FF1 (࿱)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+0FF2 (࿲)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x71f6, 0x7ffe, 0x0000 },	// U+0FF3 (࿳)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6ff6, 0x7ffe, 0x0000 },	// U+0FF4 (࿴)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+0FF5 (࿵)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0FF6 (࿶)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+0FF7 (࿷)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+0FF8 (࿸)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+0FF9 (࿹)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+0FFA (࿺)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+0FFB (࿻)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+0FFC (࿼)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+0FFD (࿽)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+0FFE (࿾)
	{ 0x0000, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+0FFF (࿿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0x8420, 0x8420, 0x8420, 0x4240, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1000 (က)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4000, 0x4f80, 0x5080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1001 (ခ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4080, 0x4080, 0x4080, 0x2100, 0x1200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1002 (ဂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3060, 0x4280, 0x8440, 0x8420, 0x8420, 0x4a40, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1003 (ဃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x0080, 0x0080, 0x0080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1004 (င)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4280, 0x4280, 0x4280, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1005 (စ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0x8400, 0x8400, 0x85c0, 0x4a40, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1006 (ဆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x1080, 0x2840, 0x5040, 0x0040, 0x1080, 0x0f00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1007 (ဇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8e00, 0x9100, 0xa280, 0xa280, 0xa280, 0x9100, 0x9e00, 0x9000, 0x9000, 0xa000, 0x4000 },	// U+1008 (ဈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0880, 0x1000, 0x1000, 0x1000, 0x0880, 0x0780, 0x0080, 0x8080, 0x8080, 0x7f00 },	// U+1009 (ဉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4240, 0x8400, 0x8400, 0x8400, 0x4a40, 0x31c0, 0x0040, 0x8040, 0x8040, 0x7f80 },	// U+100A (ည)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x0080, 0x0080, 0x2100, 0x3e00, 0x2000, 0x1f00, 0x0100, 0x1e00, 0x7000 },	// U+100B (ဋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x0080, 0x0080, 0x0080, 0x2100, 0x3e00, 0x2000, 0x2300, 0x2080, 0x1f00 },	// U+100C (ဌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4000, 0x4000, 0x2100, 0x1f00, 0x0100, 0x3e00, 0x2000, 0x2000, 0x6000 },	// U+100D (ဍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1180, 0x2200, 0x4100, 0x4080, 0x4080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+100E (ဎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6ec0, 0x9120, 0x8a20, 0x8a20, 0x8a20, 0x5140, 0x1f00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+100F (ဏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0x8420, 0x8420, 0x8420, 0x4240, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1010 (တ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0x8420, 0x8420, 0x8420, 0x4a40, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1011 (ထ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x1080, 0x1000, 0x0c00, 0x1000, 0x1080, 0x0f00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1012 (ဒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4080, 0x4080, 0x5e80, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1013 (ဓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3800, 0x0400, 0x0400, 0x3800, 0x4300, 0x4480, 0x3f00, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+1014 (န)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1200, 0x2100, 0x4080, 0x4080, 0x4080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1015 (ပ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a00, 0x2900, 0x4880, 0x4880, 0x5080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1016 (ဖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2100, 0x5e80, 0x4080, 0x4080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1017 (ဗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0x8400, 0x8400, 0x8400, 0x4240, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1018 (ဘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1200, 0x2100, 0x4080, 0x4080, 0x5e80, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1019 (မ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4240, 0x8420, 0x8420, 0x8420, 0x4a40, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+101A (ယ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x1080, 0x2040, 0x23c0, 0x2440, 0x2880, 0x2f00, 0x2000, 0x2000, 0x2000, 0xe000 },	// U+101B (ရ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4240, 0x8420, 0x8420, 0x8420, 0x4840, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+101C (လ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4080, 0x4080, 0x4080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+101D (ဝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4240, 0x8400, 0x8400, 0x8400, 0x4a40, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+101E (သ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4a40, 0x8420, 0x8420, 0x8420, 0x4240, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+101F (ဟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x0080, 0x0080, 0x2100, 0x3e00, 0x2000, 0x1f00, 0x0100, 0x2100, 0x1e00 },	// U+1020 (ဠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3980, 0x4640, 0xc200, 0xa100, 0x9200, 0x5240, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1021 (အ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0x8420, 0x8420, 0x8440, 0x4280, 0x3060, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1022 (ဢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0x8420, 0x8420, 0x8420, 0x4040, 0x0000, 0x3b80, 0x4440, 0x2440, 0xe080 },	// U+1023 (ဣ)
	{ 0x6000, 0x9000, 0x1000, 0x2000, 0x4000, 0x9980, 0xa640, 0xa420, 0xa420, 0xa420, 0xa240, 0xa000, 0xa000, 0xa7e0, 0xa010, 0x9fe0 },	// U+1024 (ဤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x1080, 0x2000, 0x2000, 0x2000, 0x1080, 0x0f80, 0x0080, 0x0080, 0x2080, 0x1f00 },	// U+1025 (ဥ)
	{ 0x0e00, 0x1100, 0x1500, 0x1b00, 0x0e00, 0x0000, 0x1f00, 0x1080, 0x2000, 0x2000, 0x1080, 0x0f80, 0x0080, 0x0080, 0x2080, 0x1f00 },	// U+1026 (ဦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x1e80, 0x0080, 0x1e80, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1027 (ဧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4c80, 0x5280, 0x5080, 0x4880, 0x3080, 0x0080, 0x4080, 0x4080, 0x2100, 0x1e00 },	// U+1028 (ဨ)
	{ 0x7ffc, 0x8002, 0x8002, 0x0002, 0x0002, 0x38e2, 0x4112, 0x8202, 0x8202, 0x8202, 0xc512, 0xb8e2, 0x8002, 0x8002, 0x8002, 0x7ffc },	// U+1029 (ဩ)
	{ 0x63e0, 0x9410, 0x1410, 0x2010, 0x0010, 0x6cd0, 0x9114, 0x9112, 0x9111, 0x911d, 0x591b, 0x16d6, 0x1010, 0x1010, 0x1010, 0x0fe0 },	// U+102A (ဪ)
	{ 0x00f0, 0x0108, 0x0108, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+102B (ါ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1000, 0x1000, 0x1000, 0x0800, 0x0780, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+102C (ာ)
	{ 0x0c00, 0x1200, 0x1200, 0x0c00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+102D (ိ)
	{ 0x0e00, 0x1100, 0x1500, 0x1100, 0x0e00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+102E (ီ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x01c0 },	// U+102F (ု)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x03a0 },	// U+1030 (ူ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0002, 0x0002, 0x000e, 0x000a, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1031 (ေ)
	{ 0x0080, 0x0100, 0x0200, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1032 (ဲ)
	{ 0x0e00, 0x1500, 0x1b00, 0x1500, 0x0e00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1033 (ဳ)
	{ 0x1000, 0x0800, 0x0400, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1034 (ဴ)
	{ 0x0e00, 0x0100, 0x1d00, 0x1300, 0x0e00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1035 (ဵ)
	{ 0x0000, 0x4000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1036 (ံ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1400, 0x0800 },	// U+1037 (့)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1038 (း)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0e00, 0x0400 },	// U+1039 (္)
	{ 0x3000, 0x4800, 0x0800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+103A (်)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0021, 0x0021, 0x0021, 0x0026, 0x0038 },	// U+103B (ျ)
	{ 0x3fe0, 0x4010, 0x4010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x2010, 0x1fe0 },	// U+103C (ြ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x4400, 0x3800 },	// U+103D (ွ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0400, 0x0400, 0x0600, 0x0000 },	// U+103E (ှ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2480, 0x4940, 0x9200, 0x9200, 0x9200, 0x5b40, 0x2480, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+103F (ဿ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06c0, 0x0820, 0x1010, 0x1010, 0x1010, 0x0820, 0x06c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1040 (၀)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0800, 0x0800, 0x0800, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1041 (၁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0210, 0x01e0 },	// U+1042 (၂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0800, 0x0800, 0x0800, 0x0420, 0x03c0, 0x0080, 0x0100, 0x0200, 0x0400 },	// U+1043 (၃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0010, 0x0010, 0x0010, 0x0420, 0x03c0, 0x0100, 0x0080, 0x0040, 0x0020 },	// U+1044 (၄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0450, 0x0850, 0x0820, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0420, 0x03c0 },	// U+1045 (၅)
	{ 0x0000, 0x0780, 0x0840, 0x0020, 0x0020, 0x0620, 0x0120, 0x0120, 0x0e20, 0x0820, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1046 (၆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0400, 0x0400, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0040, 0x0180 },	// U+1047 (၇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0850, 0x0890, 0x0890, 0x04a0, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1048 (၈)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x0820, 0x0e20, 0x0120, 0x0120, 0x0620, 0x0020, 0x0020, 0x0840, 0x0780 },	// U+1049 (၉)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+104A (၊)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+104B (။)
	{ 0x0180, 0x0240, 0x0040, 0x0080, 0x0000, 0x03c0, 0x0420, 0x0800, 0x0800, 0x0420, 0x03e0, 0x0020, 0x07c0, 0x0400, 0x0420, 0x03c0 },	// U+104C (၌)
	{ 0x0000, 0x1800, 0x2400, 0x0400, 0x0800, 0x11e0, 0x1210, 0x1408, 0x1478, 0x1488, 0x1510, 0x15e0, 0x1400, 0x1460, 0x1010, 0x0fe0 },	// U+104D (၍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x0080, 0x0080, 0x0080, 0x2100, 0x3e00, 0x2000, 0x2000, 0x2000, 0x2000 },	// U+104E (၎)
	{ 0x1800, 0x2400, 0x0400, 0x0800, 0x1000, 0x26f0, 0x2908, 0x28f4, 0x2804, 0x28f4, 0x2908, 0x28f0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+104F (၏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4080, 0x4c80, 0x4080, 0x2100, 0x1200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1050 (ၐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1200, 0x2100, 0x4080, 0x4c80, 0x4080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1051 (ၑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x1100, 0x2080, 0x4080, 0x4080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1052 (ၒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6180, 0x1200, 0x2100, 0x4080, 0x4080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1053 (ၓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4280, 0x7c80, 0x0080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1054 (ၔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4280, 0x7c80, 0x0080, 0x4900, 0x3600, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1055 (ၕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0100, 0x0200, 0x0400, 0x0400, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1056 (ၖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x0200, 0x0400, 0x0800, 0x0800, 0x0490, 0x0360, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1057 (ၗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x0a00, 0x2600, 0x1c00 },	// U+1058 (ၘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0500, 0x5300, 0x2e00 },	// U+1059 (ၙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x0080, 0x0080, 0x2100, 0x1e00, 0x0400, 0x0a00, 0x0800, 0x0400, 0x0800 },	// U+105A (ၚ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4700, 0x4880, 0x5440, 0x6840, 0x4040, 0x4880, 0x4f00, 0x4800, 0x4800, 0x5000, 0x2000 },	// U+105B (ၛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4c80, 0x5280, 0x4c80, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+105C (ၜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1200, 0x2100, 0x4080, 0x4080, 0x5e80, 0x6100, 0x5e00, 0x4000, 0x4300, 0x4080, 0x3f00 },	// U+105D (ၝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1c00, 0x2a00, 0x0c00 },	// U+105E (ၞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0c00, 0x2200, 0x1c00 },	// U+105F (ၟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0200, 0x1e00 },	// U+1060 (ၠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4080, 0x4780, 0x4880, 0x5100, 0x5e00, 0x4000, 0x5000, 0x5000, 0x5800 },	// U+1061 (ၡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1062 (ၢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0400, 0x0400, 0x0400, 0x0220, 0x01e0, 0x0020, 0x0020, 0x0020, 0x0020 },	// U+1063 (ၣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1064 (ၤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4000, 0x4000, 0x4000, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1065 (ၥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1200, 0x2100, 0x4080, 0x4080, 0x4080, 0x2100, 0x1e00, 0x0000, 0x0800, 0x0800, 0x0c00 },	// U+1066 (ၦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x0180, 0x0140, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1067 (ၧ)
	{ 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1068 (ၨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0200, 0x0180, 0x0040, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1069 (ၩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+106A (ၪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+106B (ၫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0280, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+106C (ၬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0040, 0x0180, 0x0200, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+106D (ၭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6d80, 0x9240, 0x9440, 0x9440, 0x9240, 0x4a80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+106E (ၮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4a40, 0x8420, 0x8420, 0x8420, 0x4240, 0x3180, 0x0000, 0x1000, 0x1000, 0x1800 },	// U+106F (ၯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3060, 0x4280, 0x8440, 0x8420, 0x8420, 0x4a40, 0x3180, 0x0000, 0x1000, 0x1000, 0x1800 },	// U+1070 (ၰ)
	{ 0x0000, 0x1100, 0x2a80, 0x1100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1071 (ၱ)
	{ 0x0c00, 0x1200, 0x0200, 0x0c00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1072 (ၲ)
	{ 0x0400, 0x0a00, 0x1100, 0x2080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1073 (ၳ)
	{ 0x0000, 0x1200, 0x1200, 0x0c00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1074 (ၴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4080, 0x4080, 0x4100, 0x2200, 0x1180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1075 (ၵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c80, 0x2280, 0x4100, 0x4000, 0x5f00, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1076 (ၶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x5080, 0x5080, 0x5100, 0x2200, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1077 (ၷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0x8420, 0x8420, 0x8420, 0x4840, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1078 (ၸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0x8460, 0x84a0, 0x8520, 0x4940, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1079 (ၹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4240, 0x8420, 0x8420, 0x8420, 0x4c40, 0x3580, 0x0400, 0x0400, 0x0400, 0x1c00 },	// U+107A (ၺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0xc420, 0xa420, 0x9420, 0x5240, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+107B (ၻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4a40, 0x0400, 0x0400, 0x3f80, 0x4a40, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+107C (ၼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3060, 0x4a80, 0x0440, 0x0420, 0x7420, 0x4a40, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+107D (ၽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3060, 0x4a80, 0x0440, 0x0420, 0x7420, 0x4a40, 0x3180, 0x0000, 0x1000, 0x1000, 0x1800 },	// U+107E (ၾ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1600, 0x2500, 0x4480, 0x4480, 0x4280, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+107F (ၿ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x4240, 0x8400, 0x8400, 0x85c0, 0x4a40, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1080 (ႀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x4080, 0x4080, 0x4480, 0x2500, 0x0600, 0x0400, 0x0400, 0x0400, 0x0700 },	// U+1081 (ႁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0200, 0x1200, 0x0c00 },	// U+1082 (ႂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0380 },	// U+1083 (ႃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0012, 0x0002, 0x000c, 0x0002, 0x0012, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1084 (ႄ)
	{ 0x0e00, 0x1100, 0x0200, 0x1100, 0x0e00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1085 (ႅ)
	{ 0x0400, 0x0a00, 0x0c00, 0x0800, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1086 (ႆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0180, 0x0100, 0x0080, 0x0000, 0x0000 },	// U+1087 (ႇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x0080, 0x0140, 0x0180, 0x0100, 0x0080, 0x0000, 0x0000 },	// U+1088 (ႈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1089 (ႉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x02a0, 0x01c0, 0x0000, 0x0040, 0x02a0, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+108A (ႊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+108B (ႋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x0aa0, 0x0440, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+108C (ႌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7f80, 0x0000, 0x0000 },	// U+108D (ႍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x2100, 0x5e80, 0x4080, 0x4080, 0x2100, 0x1e00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+108E (ႎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x0080, 0x0140, 0x00c0, 0x0040, 0x0080, 0x0000, 0x0000 },	// U+108F (ႏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1090 (႐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x00a0, 0x0080, 0x0080, 0x0080, 0x0280, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1091 (႑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03a0, 0x0460, 0x0400, 0x0200, 0x0100, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1092 (႒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0080, 0x0080, 0x0040, 0x01c0, 0x0220, 0x0220, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1093 (႓)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0180, 0x0180, 0x0140, 0x0140, 0x0520, 0x0320, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1094 (႔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0200, 0x0200, 0x07e0, 0x0210, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1095 (႕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0210, 0x07e0, 0x0200, 0x0200, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1096 (႖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1097 (႗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0420, 0x0420, 0x0240, 0x03c0, 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1098 (႘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0420, 0x03c0, 0x0240, 0x0420, 0x0420, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1099 (႙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+109A (ႚ)
	{ 0x0000, 0x0080, 0x0140, 0x0180, 0x0100, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+109B (ႛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x02a0, 0x0040, 0x0000, 0x01c0, 0x02a0, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+109C (ႜ)
	{ 0x0000, 0x3800, 0x4400, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+109D (ႝ)
	{ 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x00e0, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0380 },	// U+109E (႞)
	{ 0x1800, 0x2400, 0x0400, 0x0800, 0x1000, 0x20f0, 0x2108, 0x2204, 0x2204, 0x2204, 0x2208, 0x2200, 0x2200, 0x2200, 0x2200, 0x1c00 },	// U+109F (႟)
}; // 203

static const uint16_t unifontdw_block64[][16] = {
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x6dde, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x738e, 0x7df6, 0x71f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+10C6 (჆)
}; // 1

static const uint16_t unifontdw_block65[][16] = {
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x6dde, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x73f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+10C8 (჈)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x6dde, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x63f6, 0x6ff6, 0x738e, 0x7ffe, 0x0000 },	// U+10C9 (჉)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x6dde, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x618e, 0x6df6, 0x61f6, 0x6df6, 0x6d8e, 0x7ffe, 0x0000 },	// U+10CA (჊)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x6dde, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x71f6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+10CB (჋)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x6dde, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x638e, 0x7df6, 0x7df6, 0x7df6, 0x638e, 0x7ffe, 0x0000 },	// U+10CC (჌)
}; // 5

static const uint16_t unifontdw_block66[][16] = {
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x6dde, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+10CE (჎)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x6dde, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+10CF (჏)
}; // 2

static const uint16_t unifontdw_block67[][16] = {
	{ 0x0000, 0x0000, 0x01fe, 0x0100, 0x0100, 0x0100, 0x0100, 0x0080, 0x0080, 0x0040, 0x0020, 0x0018, 0x0006, 0x0000, 0x0000, 0x0000 },	// U+1100 (ᄀ)
	{ 0x0000, 0x0000, 0x0000, 0x01de, 0x0110, 0x0110, 0x0110, 0x0110, 0x0088, 0x0088, 0x0044, 0x0022, 0x0010, 0x0000, 0x0000, 0x0000 },	// U+1101 (ᄁ)
	{ 0x0000, 0x0004, 0x0004, 0x0004, 0x0004, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1102 (ᄂ)
	{ 0x0000, 0x01fc, 0x0004, 0x0004, 0x0004, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1103 (ᄃ)
	{ 0x0000, 0x01dc, 0x0044, 0x0044, 0x0044, 0x01dc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1104 (ᄄ)
	{ 0x0000, 0x0000, 0x01fc, 0x0100, 0x01fc, 0x0004, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1105 (ᄅ)
	{ 0x0000, 0x01fc, 0x0104, 0x0104, 0x0104, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1106 (ᄆ)
	{ 0x0000, 0x0104, 0x0104, 0x01fc, 0x0104, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1107 (ᄇ)
	{ 0x0000, 0x0154, 0x0154, 0x01dc, 0x0154, 0x01dc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1108 (ᄈ)
	{ 0x0000, 0x0020, 0x0020, 0x0020, 0x0050, 0x0088, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1109 (ᄉ)
	{ 0x0000, 0x0088, 0x0088, 0x0088, 0x0154, 0x0222, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+110A (ᄊ)
	{ 0x0000, 0x0070, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+110B (ᄋ)
	{ 0x0000, 0x01fc, 0x0080, 0x0040, 0x00b0, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+110C (ᄌ)
	{ 0x0000, 0x0000, 0x03dc, 0x0110, 0x00a8, 0x0144, 0x0220, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+110D (ᄍ)
	{ 0x0070, 0x0000, 0x01fc, 0x0040, 0x00b0, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+110E (ᄎ)
	{ 0x0000, 0x01fc, 0x0100, 0x01fc, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+110F (ᄏ)
	{ 0x0000, 0x01fc, 0x0004, 0x01fc, 0x0004, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1110 (ᄐ)
	{ 0x0000, 0x01fe, 0x0048, 0x0048, 0x0048, 0x01fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1111 (ᄑ)
	{ 0x0000, 0x0070, 0x0000, 0x01fc, 0x0000, 0x00f8, 0x0104, 0x0104, 0x0104, 0x00f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1112 (ᄒ)
	{ 0x0000, 0x3f84, 0x2004, 0x2004, 0x2004, 0x21fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1113 (ᄓ)
	{ 0x0000, 0x0204, 0x0204, 0x0204, 0x0204, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1114 (ᄔ)
	{ 0x0000, 0x3e04, 0x0204, 0x0204, 0x0204, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1115 (ᄕ)
	{ 0x0000, 0x2204, 0x2204, 0x3e04, 0x2204, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1116 (ᄖ)
	{ 0x0000, 0x3e7c, 0x2004, 0x2004, 0x2004, 0x207c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1117 (ᄗ)
	{ 0x0000, 0x0000, 0x027c, 0x0240, 0x027c, 0x0204, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1118 (ᄘ)
	{ 0x0000, 0x0000, 0x3e7c, 0x2040, 0x3e7c, 0x0204, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1119 (ᄙ)
	{ 0x0000, 0x0000, 0x0c7c, 0x3f40, 0x0c7c, 0x1204, 0x0c7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+111A (ᄚ)
	{ 0x0000, 0x0000, 0x1ff8, 0x1000, 0x1ff8, 0x0008, 0x1ff8, 0x03c0, 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+111B (ᄛ)
	{ 0x0000, 0x227c, 0x2244, 0x3e44, 0x2244, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+111C (ᄜ)
	{ 0x0000, 0x3ff8, 0x2008, 0x2008, 0x2008, 0x3ff8, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x0820, 0x0820, 0x07c0, 0x0000, 0x0000 },	// U+111D (ᄝ)
	{ 0x0000, 0x3e44, 0x2044, 0x207c, 0x2044, 0x207c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+111E (ᄞ)
	{ 0x0000, 0x0244, 0x0244, 0x027c, 0x0244, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+111F (ᄟ)
	{ 0x0000, 0x3e44, 0x0244, 0x027c, 0x0244, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1120 (ᄠ)
	{ 0x0000, 0x0844, 0x0844, 0x087c, 0x1444, 0x227c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1121 (ᄡ)
	{ 0x0000, 0x7912, 0x4112, 0x411e, 0x4292, 0x445e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1122 (ᄢ)
	{ 0x0000, 0x7112, 0x1112, 0x111e, 0x1292, 0x745e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1123 (ᄣ)
	{ 0x0000, 0x2492, 0x2492, 0x3c9e, 0x2552, 0x3e3e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1124 (ᄤ)
	{ 0x0000, 0x1112, 0x1112, 0x111e, 0x2a92, 0x445e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1125 (ᄥ)
	{ 0x0000, 0x7c92, 0x2092, 0x109e, 0x2952, 0x463e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1126 (ᄦ)
	{ 0x0000, 0x3e44, 0x1044, 0x087c, 0x1444, 0x227c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1127 (ᄧ)
	{ 0x1c00, 0x0044, 0x3e44, 0x087c, 0x1444, 0x227c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1128 (ᄨ)
	{ 0x0000, 0x3e44, 0x0244, 0x3e7c, 0x0244, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1129 (ᄩ)
	{ 0x0000, 0x3e44, 0x1444, 0x147c, 0x1444, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+112A (ᄪ)
	{ 0x0000, 0x1010, 0x1ff0, 0x1010, 0x1ff0, 0x0380, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+112B (ᄫ)
	{ 0x0000, 0x2244, 0x3e7c, 0x2244, 0x3e7c, 0x03c0, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+112C (ᄬ)
	{ 0x0000, 0x3e20, 0x2020, 0x2020, 0x2050, 0x2088, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+112D (ᄭ)
	{ 0x0000, 0x0220, 0x0220, 0x0220, 0x0250, 0x3e88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+112E (ᄮ)
	{ 0x0000, 0x3e20, 0x0220, 0x0220, 0x0250, 0x3e88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+112F (ᄯ)
	{ 0x0000, 0x3e20, 0x2020, 0x3e20, 0x0250, 0x3e88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1130 (ᄰ)
	{ 0x0000, 0x3e20, 0x2220, 0x2220, 0x2250, 0x3e88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1131 (ᄱ)
	{ 0x0000, 0x2220, 0x2220, 0x3e20, 0x2250, 0x3e88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1132 (ᄲ)
	{ 0x0000, 0x7488, 0x4488, 0x4788, 0x4494, 0x47a2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1133 (ᄳ)
	{ 0x0000, 0x1110, 0x1110, 0x1110, 0x2aa8, 0x4444, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1134 (ᄴ)
	{ 0x0000, 0x1c20, 0x2220, 0x2220, 0x2250, 0x1c88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1135 (ᄵ)
	{ 0x0000, 0x3e20, 0x1020, 0x0820, 0x1450, 0x2288, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1136 (ᄶ)
	{ 0x1c00, 0x0020, 0x3e20, 0x0820, 0x1450, 0x2288, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1137 (ᄷ)
	{ 0x0000, 0x3e20, 0x2020, 0x3e20, 0x2050, 0x2088, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1138 (ᄸ)
	{ 0x0000, 0x3e20, 0x0220, 0x3e20, 0x0250, 0x3e88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1139 (ᄹ)
	{ 0x0000, 0x3e20, 0x1420, 0x1420, 0x1450, 0x3e88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+113A (ᄺ)
	{ 0x0000, 0x0c20, 0x3f20, 0x0c20, 0x1250, 0x0c88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+113B (ᄻ)
	{ 0x0000, 0x0200, 0x0200, 0x0180, 0x0160, 0x0218, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+113C (ᄼ)
	{ 0x0000, 0x0480, 0x0480, 0x0540, 0x0a20, 0x1198, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+113D (ᄽ)
	{ 0x0000, 0x0100, 0x0100, 0x0080, 0x0160, 0x0218, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+113E (ᄾ)
	{ 0x0000, 0x0120, 0x0120, 0x02a0, 0x0c50, 0x3188, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+113F (ᄿ)
	{ 0x0000, 0x0040, 0x00a0, 0x0110, 0x0208, 0x07fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1140 (ᅀ)
	{ 0x0000, 0x3e70, 0x2088, 0x2088, 0x2088, 0x2070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1141 (ᅁ)
	{ 0x0000, 0x3c70, 0x0488, 0x0488, 0x0488, 0x3c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1142 (ᅂ)
	{ 0x0000, 0x7c70, 0x4488, 0x4488, 0x4488, 0x7c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1143 (ᅃ)
	{ 0x0000, 0x2470, 0x2488, 0x3c88, 0x2488, 0x3c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1144 (ᅄ)
	{ 0x0000, 0x1070, 0x1088, 0x1088, 0x2888, 0x4470, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1145 (ᅅ)
	{ 0x0000, 0x041c, 0x0a22, 0x1122, 0x20a2, 0x3f9c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1146 (ᅆ)
	{ 0x0000, 0x1c70, 0x2288, 0x2288, 0x2288, 0x1c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1147 (ᅇ)
	{ 0x0000, 0x3e70, 0x1088, 0x0888, 0x1488, 0x2270, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1148 (ᅈ)
	{ 0x1c00, 0x0070, 0x3e88, 0x0888, 0x1488, 0x2270, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1149 (ᅉ)
	{ 0x0000, 0x3c70, 0x0488, 0x3c88, 0x0488, 0x3c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+114A (ᅊ)
	{ 0x0000, 0x3e70, 0x1488, 0x1488, 0x1488, 0x3e70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+114B (ᅋ)
	{ 0x0000, 0x0070, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+114C (ᅌ)
	{ 0x0000, 0x1c7c, 0x2220, 0x2210, 0x2228, 0x1c44, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+114D (ᅍ)
	{ 0x0000, 0x07fc, 0x0300, 0x01c0, 0x0230, 0x040c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+114E (ᅎ)
	{ 0x0000, 0x0000, 0x0ff8, 0x0480, 0x0540, 0x0a30, 0x118c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+114F (ᅏ)
	{ 0x0000, 0x0ff8, 0x0600, 0x0380, 0x0460, 0x0818, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1150 (ᅐ)
	{ 0x0000, 0x0000, 0x07fc, 0x0210, 0x0528, 0x08c4, 0x3180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1151 (ᅑ)
	{ 0x0038, 0x3e00, 0x207c, 0x3e10, 0x2028, 0x2044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1152 (ᅒ)
	{ 0x0018, 0x0c00, 0x3f7c, 0x0c10, 0x1228, 0x0c44, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1153 (ᅓ)
	{ 0x01e0, 0x0000, 0x03f8, 0x0180, 0x0260, 0x041c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1154 (ᅔ)
	{ 0x0070, 0x0000, 0x00fc, 0x0040, 0x01b0, 0x0e0c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1155 (ᅕ)
	{ 0x0000, 0x227c, 0x2228, 0x3e28, 0x2228, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1156 (ᅖ)
	{ 0x0000, 0x1ff8, 0x0420, 0x1ff8, 0x03c0, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1157 (ᅗ)
	{ 0x0000, 0x0c18, 0x3f7e, 0x0e38, 0x1144, 0x1144, 0x0e38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1158 (ᅘ)
	{ 0x0ff8, 0x0080, 0x03e0, 0x0410, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1159 (ᅙ)
	{ 0x0000, 0x3e7c, 0x0240, 0x0240, 0x0240, 0x3e40, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+115A (ᅚ)
	{ 0x0000, 0x0808, 0x0808, 0x0808, 0x1408, 0x22f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+115B (ᅛ)
	{ 0x0000, 0x3e08, 0x1008, 0x0808, 0x1408, 0x22f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+115C (ᅜ)
	{ 0x0000, 0x0e08, 0x3f88, 0x0e08, 0x1108, 0x0e78, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+115D (ᅝ)
	{ 0x0000, 0x0000, 0x3e7c, 0x2004, 0x3e04, 0x0204, 0x3e7c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+115E (ᅞ)
	{ 0x5555, 0x8000, 0x0001, 0x9c44, 0x0245, 0x827c, 0x0245, 0x9c44, 0x0001, 0x87c0, 0x0041, 0x81c0, 0x0041, 0x8040, 0x0001, 0xaaaa },	// U+115F (ᅟ)
	{ 0x5555, 0x8000, 0x0001, 0x9e44, 0x0845, 0x887c, 0x0a45, 0x8444, 0x0001, 0x87c0, 0x0041, 0x81c0, 0x0041, 0x8040, 0x0001, 0xaaaa },	// U+1160 (ᅠ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x7800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1161 (ᅡ)
	{ 0x0000, 0x4800, 0x4800, 0x4800, 0x7800, 0x4800, 0x4800, 0x4800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1162 (ᅢ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x7800, 0x0800, 0x7800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1163 (ᅣ)
	{ 0x0000, 0x4800, 0x4800, 0x4800, 0x7800, 0x4800, 0x7800, 0x4800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1164 (ᅤ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x0e00, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1165 (ᅥ)
	{ 0x0000, 0x4800, 0x4800, 0x4800, 0x4e00, 0x4800, 0x4800, 0x4800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1166 (ᅦ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x0e00, 0x0800, 0x0e00, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1167 (ᅧ)
	{ 0x0000, 0x4800, 0x4800, 0x4800, 0x4e00, 0x4800, 0x4e00, 0x4800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1168 (ᅨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1169 (ᅩ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x7800, 0x0820, 0x0820, 0x0ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+116A (ᅪ)
	{ 0x0000, 0x4800, 0x4800, 0x4800, 0x7800, 0x4820, 0x4820, 0x4ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+116B (ᅫ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0820, 0x0820, 0x0ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+116C (ᅬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0240, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+116D (ᅭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffc, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+116E (ᅮ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x09fc, 0x0820, 0x0f20, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+116F (ᅯ)
	{ 0x0000, 0x4800, 0x4800, 0x4800, 0x4800, 0x4800, 0x4800, 0x49fc, 0x4820, 0x4f20, 0x4820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1170 (ᅰ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0ffc, 0x0820, 0x0820, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1171 (ᅱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffc, 0x0440, 0x0440, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1172 (ᅲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1173 (ᅳ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0ffc, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+1174 (ᅴ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1175 (ᅵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0400, 0x0400, 0x1c00, 0x0500, 0x0500, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1176 (ᅶ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x3800, 0x0800, 0x0800, 0x7ffc, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1177 (ᅷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x7000, 0x1000, 0x7000, 0x1100, 0x1100, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1178 (ᅸ)
	{ 0x1000, 0x1000, 0x7000, 0x1000, 0x7000, 0x1240, 0x1240, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1179 (ᅹ)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x1c00, 0x1000, 0x1000, 0x1100, 0x1100, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+117A (ᅺ)
	{ 0x0000, 0x0000, 0x2000, 0x2000, 0x2000, 0x3800, 0x2000, 0x2000, 0x2000, 0x7ffc, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+117B (ᅻ)
	{ 0x0400, 0x0400, 0x0400, 0x0700, 0x0400, 0x0400, 0x0400, 0x0400, 0x0ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+117C (ᅼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x1c00, 0x1000, 0x1c00, 0x1100, 0x1100, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+117D (ᅽ)
	{ 0x1000, 0x1000, 0x1000, 0x1c00, 0x1000, 0x1c00, 0x1000, 0x7ffc, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+117E (ᅾ)
	{ 0x0000, 0x0000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x7ffc, 0x4100, 0x7100, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+117F (ᅿ)
	{ 0x0000, 0x0000, 0x0000, 0x4800, 0x4800, 0x4800, 0x4e00, 0x4800, 0x4800, 0x4880, 0x4880, 0x4ffc, 0x4800, 0x0000, 0x0000, 0x0000 },	// U+1180 (ᆀ)
	{ 0x0000, 0x0000, 0x0000, 0x4800, 0x4800, 0x4800, 0x4e00, 0x4800, 0x4800, 0x4e80, 0x4880, 0x4ffc, 0x4800, 0x0000, 0x0000, 0x0000 },	// U+1181 (ᆁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x7ffc, 0x0100, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1182 (ᆂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x7ffc, 0x0000, 0x7ffc, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+1183 (ᆃ)
	{ 0x0000, 0x0000, 0x0800, 0x0800, 0x7800, 0x0890, 0x0890, 0x7ffc, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1184 (ᆄ)
	{ 0x0000, 0x2500, 0x2500, 0x2500, 0x3d20, 0x2520, 0x3f20, 0x25fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1185 (ᆅ)
	{ 0x4000, 0x4000, 0x7000, 0x4000, 0x7000, 0x4120, 0x4120, 0x7ffc, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1186 (ᆆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x7ffc, 0x0100, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1187 (ᆇ)
	{ 0x0000, 0x0000, 0x4000, 0x4000, 0x4000, 0x4240, 0x4240, 0x7ffc, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1188 (ᆈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x7ffc, 0x1040, 0x1040, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1189 (ᆉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4800, 0x4800, 0x4800, 0x7ffc, 0x4840, 0x4840, 0x4800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+118A (ᆊ)
	{ 0x0000, 0x1000, 0x1000, 0x1000, 0x1000, 0x13f8, 0x1040, 0x1e40, 0x1040, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+118B (ᆋ)
	{ 0x0000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5000, 0x57fc, 0x5040, 0x5c40, 0x5000, 0x5c00, 0x5000, 0x0000, 0x0000, 0x0000 },	// U+118C (ᆌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffc, 0x0100, 0x7ffc, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+118D (ᆍ)
	{ 0x0000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x7ffc, 0x1240, 0x1240, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+118E (ᆎ)
	{ 0x0000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfffc, 0x8440, 0xf440, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+118F (ᆏ)
	{ 0x0000, 0x0000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5ffc, 0x5120, 0x5d20, 0x5000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1190 (ᆐ)
	{ 0x0000, 0x0000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x7ffc, 0x4240, 0x7240, 0x4000, 0x7000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+1191 (ᆑ)
	{ 0x0000, 0x0000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5ffc, 0x5120, 0x5d20, 0x5000, 0x5c00, 0x5000, 0x0000, 0x0000, 0x0000 },	// U+1192 (ᆒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffc, 0x0440, 0x7ffc, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1193 (ᆓ)
	{ 0x0000, 0x0000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfffc, 0x8440, 0x8440, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1194 (ᆔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffc, 0x0000, 0x7ffc, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1195 (ᆕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffc, 0x0000, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1196 (ᆖ)
	{ 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x3ff0, 0x2000, 0x7ffc, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1197 (ᆗ)
	{ 0x0000, 0x1200, 0x1200, 0x1200, 0x7200, 0x1200, 0x1200, 0x1200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1198 (ᆘ)
	{ 0x0000, 0x1200, 0x1200, 0x7200, 0x1200, 0x7200, 0x1200, 0x1200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1199 (ᆙ)
	{ 0x0000, 0x0000, 0x0000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2100, 0x2100, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+119A (ᆚ)
	{ 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x7ffc, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+119B (ᆛ)
	{ 0x0000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+119C (ᆜ)
	{ 0x0000, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0000, 0x0300, 0x0400, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+119D (ᆝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0400, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+119E (ᆞ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x0e00, 0x0830, 0x0840, 0x0880, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+119F (ᆟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0800, 0x1000, 0x7ffc, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+11A0 (ᆠ)
	{ 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0818, 0x0820, 0x0840, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+11A1 (ᆡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0618, 0x0820, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+11A2 (ᆢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0400, 0x0400, 0x1c00, 0x0400, 0x0400, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+11A3 (ᆣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x7000, 0x1000, 0x7000, 0x1000, 0x1000, 0x7ffc, 0x0100, 0x0100, 0x0000, 0x0000 },	// U+11A4 (ᆤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1400, 0x1400, 0x7400, 0x1700, 0x1400, 0x7700, 0x1400, 0x1400, 0x1400, 0x0000, 0x0000, 0x0000 },	// U+11A5 (ᆥ)
	{ 0x0000, 0x0000, 0x0800, 0x0800, 0x7800, 0x0880, 0x0880, 0x7ffc, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+11A6 (ᆦ)
	{ 0x0000, 0x2400, 0x2400, 0x2400, 0x3c00, 0x2420, 0x3f20, 0x24fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+11A7 (ᆧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+11A8 (ᆨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ef0, 0x1080, 0x1080, 0x1080, 0x1080, 0x0000, 0x0000 },	// U+11A9 (ᆩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08f0, 0x0880, 0x0880, 0x1480, 0x2280, 0x0000, 0x0000 },	// U+11AA (ᆪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0020, 0x0020, 0x0020, 0x0fe0, 0x0000, 0x0000 },	// U+11AB (ᆫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f10, 0x0410, 0x0410, 0x0a10, 0x11f0, 0x0000, 0x0000 },	// U+11AC (ᆬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c10, 0x3f10, 0x0c10, 0x1210, 0x0cf0, 0x0000, 0x0000 },	// U+11AD (ᆭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0020, 0x0020, 0x0020, 0x0fe0, 0x0000, 0x0000 },	// U+11AE (ᆮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0800, 0x0fe0, 0x0020, 0x0fe0, 0x0000, 0x0000 },	// U+11AF (ᆯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ef0, 0x1080, 0x10f0, 0x1010, 0x10f0, 0x0000, 0x0000 },	// U+11B0 (ᆰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x0940, 0x0978, 0x0908, 0x0f78, 0x0000, 0x0000 },	// U+11B1 (ᆱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0978, 0x0940, 0x0f78, 0x0908, 0x0f78, 0x0000, 0x0000 },	// U+11B2 (ᆲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0478, 0x0440, 0x0478, 0x0a08, 0x1178, 0x0000, 0x0000 },	// U+11B3 (ᆳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x0140, 0x0f78, 0x0108, 0x0f78, 0x0000, 0x0000 },	// U+11B4 (ᆴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f78, 0x0a40, 0x0a78, 0x0a08, 0x1f78, 0x0000, 0x0000 },	// U+11B5 (ᆵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0678, 0x1fc0, 0x0678, 0x0908, 0x0678, 0x0000, 0x0000 },	// U+11B6 (ᆶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0820, 0x0820, 0x0820, 0x0fe0, 0x0000, 0x0000 },	// U+11B7 (ᆷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x0820, 0x0fe0, 0x0820, 0x0fe0, 0x0000, 0x0000 },	// U+11B8 (ᆸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0448, 0x0448, 0x0478, 0x0a48, 0x1178, 0x0000, 0x0000 },	// U+11B9 (ᆹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0200, 0x0300, 0x04c0, 0x0838, 0x0000, 0x0000 },	// U+11BA (ᆺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0480, 0x0480, 0x05c0, 0x0a30, 0x118c, 0x0000, 0x0000 },	// U+11BB (ᆻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0440, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+11BC (ᆼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0100, 0x0100, 0x0280, 0x0440, 0x0000, 0x0000 },	// U+11BD (ᆽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0000, 0x1fe0, 0x0200, 0x05c0, 0x1830, 0x0000 },	// U+11BE (ᆾ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0800, 0x0fe0, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+11BF (ᆿ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0020, 0x0fe0, 0x0020, 0x0fe0, 0x0000, 0x0000 },	// U+11C0 (ᇀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0240, 0x0240, 0x0240, 0x0ff0, 0x0000, 0x0000 },	// U+11C1 (ᇁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0000, 0x0fe0, 0x0000, 0x0380, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+11C2 (ᇂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e7e, 0x2040, 0x3e40, 0x0240, 0x3e40, 0x0000, 0x0000 },	// U+11C3 (ᇃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x791e, 0x4110, 0x4110, 0x4290, 0x4450, 0x0000, 0x0000, 0x0000 },	// U+11C4 (ᇄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3f84, 0x2004, 0x2004, 0x2004, 0x21fc, 0x0000, 0x0000 },	// U+11C5 (ᇅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e04, 0x0204, 0x0204, 0x0204, 0x3e7c, 0x0000, 0x0000 },	// U+11C6 (ᇆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0404, 0x0404, 0x0404, 0x0a04, 0x117c, 0x0000, 0x0000 },	// U+11C7 (ᇇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0802, 0x1402, 0x2202, 0x4102, 0x7f3e, 0x0000, 0x0000 },	// U+11C8 (ᇈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e04, 0x0204, 0x3e04, 0x0204, 0x3e7c, 0x0000, 0x0000 },	// U+11C9 (ᇉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e7c, 0x2004, 0x2004, 0x2004, 0x207c, 0x0000, 0x0000 },	// U+11CA (ᇊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e7c, 0x2004, 0x3e04, 0x0204, 0x3e7c, 0x0000, 0x0000 },	// U+11CB (ᇋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x23de, 0x2210, 0x221e, 0x5202, 0x8a1e, 0x0000, 0x0000 },	// U+11CC (ᇌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x027c, 0x0240, 0x027c, 0x0204, 0x3e7c, 0x0000, 0x0000 },	// U+11CD (ᇍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e7c, 0x0240, 0x027c, 0x0204, 0x3e7c, 0x0000, 0x0000 },	// U+11CE (ᇎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x31ef, 0xfc28, 0x302f, 0x4821, 0x31ef, 0x0000, 0x0000 },	// U+11CF (ᇏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e7c, 0x2040, 0x3e7c, 0x0204, 0x3e7c, 0x0000, 0x0000 },	// U+11D0 (ᇐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7bde, 0x4250, 0x425e, 0x4242, 0x43de, 0x0000, 0x0000 },	// U+11D1 (ᇑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x23de, 0x2250, 0x225e, 0x5242, 0x8bde, 0x0000, 0x0000 },	// U+11D2 (ᇒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x225e, 0x2250, 0x23de, 0x5242, 0x8bde, 0x0000, 0x0000 },	// U+11D3 (ᇓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x312f, 0xfd28, 0x31ef, 0x4921, 0x31ef, 0x0000, 0x0000 },	// U+11D4 (ᇔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1200, 0x1e00, 0x127c, 0x1e40, 0x0c7c, 0x1204, 0x0c7c, 0x0000, 0x0000 },	// U+11D5 (ᇕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x111e, 0x1110, 0x111e, 0x2a82, 0x445e, 0x0000, 0x0000 },	// U+11D6 (ᇖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x043c, 0x0a20, 0x113c, 0x2084, 0x3fbc, 0x0000, 0x0000 },	// U+11D7 (ᇗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e7c, 0x2040, 0x3e7c, 0x2004, 0x207c, 0x0000, 0x0000 },	// U+11D8 (ᇘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c7c, 0x7f40, 0x1c7c, 0x2204, 0x1c7c, 0x0000, 0x0000 },	// U+11D9 (ᇙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e7c, 0x2044, 0x2044, 0x2044, 0x207c, 0x0000, 0x0000 },	// U+11DA (ᇚ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e7c, 0x2044, 0x3e44, 0x0244, 0x3e7c, 0x0000, 0x0000 },	// U+11DB (ᇛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x227c, 0x2244, 0x3e44, 0x2244, 0x3e7c, 0x0000, 0x0000 },	// U+11DC (ᇜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08f8, 0x0888, 0x0888, 0x1488, 0x22f8, 0x0000, 0x0000 },	// U+11DD (ᇝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x223e, 0x2222, 0x2222, 0x5522, 0x88be, 0x0000, 0x0000 },	// U+11DE (ᇞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x087c, 0x1444, 0x2244, 0x4144, 0x7f7c, 0x0000, 0x0000 },	// U+11DF (ᇟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c00, 0x007c, 0x7f44, 0x1044, 0x2c44, 0x437c, 0x0000, 0x0000 },	// U+11E0 (ᇠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c7c, 0x7f44, 0x1c44, 0x2244, 0x1c7c, 0x0000, 0x0000 },	// U+11E1 (ᇡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0410, 0x07f0, 0x0000, 0x01c0, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+11E2 (ᇢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e44, 0x2044, 0x3e7c, 0x0244, 0x3e7c, 0x0000, 0x0000 },	// U+11E3 (ᇣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e44, 0x1444, 0x147c, 0x1444, 0x3e7c, 0x0000, 0x0000 },	// U+11E4 (ᇤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c44, 0x7f44, 0x1c7c, 0x2244, 0x1c7c, 0x0000, 0x0000 },	// U+11E5 (ᇥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x0fe0, 0x0820, 0x0fe0, 0x0380, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+11E6 (ᇦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f20, 0x1020, 0x1020, 0x1050, 0x1088, 0x0000, 0x0000 },	// U+11E7 (ᇧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e20, 0x0220, 0x0220, 0x0250, 0x3e88, 0x0000, 0x0000 },	// U+11E8 (ᇨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f10, 0x1010, 0x1f10, 0x0128, 0x1f44, 0x0000, 0x0000 },	// U+11E9 (ᇩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2220, 0x2220, 0x3e20, 0x2250, 0x3e88, 0x0000, 0x0000 },	// U+11EA (ᇪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0220, 0x0410, 0x0ff8, 0x0000, 0x0000 },	// U+11EB (ᇫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e70, 0x2088, 0x2088, 0x2088, 0x2070, 0x0000, 0x0000 },	// U+11EC (ᇬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b9c, 0x2222, 0x2222, 0x2222, 0x221c, 0x0000, 0x0000 },	// U+11ED (ᇭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c38, 0x2244, 0x2244, 0x2244, 0x1c38, 0x0000, 0x0000 },	// U+11EE (ᇮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e38, 0x2044, 0x3e44, 0x2044, 0x2038, 0x0000, 0x0000 },	// U+11EF (ᇯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x01c0, 0x0220, 0x0220, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+11F0 (ᇰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0438, 0x0444, 0x0444, 0x0a44, 0x1138, 0x0000, 0x0000 },	// U+11F1 (ᇱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x041c, 0x0a22, 0x1122, 0x20a2, 0x3f9c, 0x0000, 0x0000 },	// U+11F2 (ᇲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x227c, 0x2228, 0x3e28, 0x2228, 0x3e7c, 0x0000, 0x0000 },	// U+11F3 (ᇳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0240, 0x0ff0, 0x03c0, 0x0420, 0x03c0, 0x0000, 0x0000 },	// U+11F4 (ᇴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0238, 0x02fe, 0x0238, 0x0244, 0x3e38, 0x0000, 0x0000 },	// U+11F5 (ᇵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e38, 0x20fe, 0x3e38, 0x0244, 0x3e38, 0x0000, 0x0000 },	// U+11F6 (ᇶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e38, 0x22fe, 0x2238, 0x2244, 0x3e38, 0x0000, 0x0000 },	// U+11F7 (ᇷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2238, 0x22fe, 0x3e38, 0x2244, 0x3e38, 0x0000, 0x0000 },	// U+11F8 (ᇸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x07f0, 0x01c0, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+11F9 (ᇹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x027c, 0x0240, 0x0240, 0x0240, 0x3e40, 0x0000, 0x0000 },	// U+11FA (ᇺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x227c, 0x2240, 0x3e40, 0x2240, 0x3e40, 0x0000, 0x0000 },	// U+11FB (ᇻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c00, 0x007c, 0x7f40, 0x1040, 0x2c40, 0x4340, 0x0000, 0x0000 },	// U+11FC (ᇼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e7c, 0x2040, 0x3e40, 0x2040, 0x2040, 0x0000, 0x0000 },	// U+11FD (ᇽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c7c, 0x7f40, 0x1c40, 0x2240, 0x1c40, 0x0000, 0x0000 },	// U+11FE (ᇾ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0204, 0x0204, 0x0204, 0x0204, 0x3e7c, 0x0000, 0x0000 },	// U+11FF (ᇿ)
	{ 0x0000, 0x0000, 0x0000, 0x0380, 0x030c, 0x030c, 0x030c, 0x030c, 0x030c, 0x030c, 0x018c, 0x018c, 0x00f8, 0x0070, 0x0000, 0x0000 },	// U+1200 (ሀ)
	{ 0x0000, 0x0000, 0x0000, 0x0380, 0x030c, 0x030c, 0x030c, 0x3f0c, 0x330c, 0x030c, 0x018c, 0x018c, 0x00f8, 0x0070, 0x0000, 0x0000 },	// U+1201 (ሁ)
	{ 0x0000, 0x0000, 0x0660, 0x0630, 0x0630, 0x0630, 0x0630, 0x03e0, 0x03c0, 0x0300, 0x0180, 0x00c0, 0x0cc0, 0x0fc0, 0x0000, 0x0000 },	// U+1202 (ሂ)
	{ 0x0000, 0x0000, 0x0660, 0x0630, 0x0630, 0x0630, 0x0630, 0x03e0, 0x03c0, 0x0300, 0x0180, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1203 (ሃ)
	{ 0x0000, 0x0000, 0x0660, 0x0630, 0x0630, 0x0630, 0x0630, 0x03e0, 0x03c0, 0x0300, 0x0380, 0x02c0, 0x04c0, 0x07c0, 0x0000, 0x0000 },	// U+1204 (ሄ)
	{ 0x0000, 0x0000, 0x0000, 0x0e18, 0x0c18, 0x0c38, 0x0c70, 0x0c60, 0x0c30, 0x0c30, 0x0c30, 0x0630, 0x07e0, 0x03c0, 0x0000, 0x0000 },	// U+1205 (ህ)
	{ 0x0000, 0x0000, 0x0000, 0x0f00, 0x130c, 0x1b0c, 0x070c, 0x030c, 0x030c, 0x030c, 0x018c, 0x018c, 0x00f8, 0x0070, 0x0000, 0x0000 },	// U+1206 (ሆ)
	{ 0x0000, 0x0000, 0x0000, 0x3c00, 0x4c30, 0x6c30, 0x1c30, 0x0c36, 0x0c3e, 0x0c36, 0x0630, 0x0630, 0x03e0, 0x01c0, 0x0000, 0x0000 },	// U+1207 (ሇ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x01e0, 0x03e0, 0x0730, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+1208 (ለ)
	{ 0x0000, 0x0000, 0x0030, 0x0030, 0x0030, 0x0078, 0x00f8, 0x01cc, 0x018c, 0x018c, 0x1f8c, 0x198c, 0x018c, 0x018c, 0x0000, 0x0000 },	// U+1209 (ሉ)
	{ 0x0000, 0x0000, 0x0030, 0x0030, 0x0030, 0x0078, 0x00f8, 0x01cc, 0x018c, 0x018c, 0x018c, 0x018c, 0x198c, 0x1f8c, 0x0000, 0x0000 },	// U+120A (ሊ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x01e0, 0x03e0, 0x0730, 0x0630, 0x0630, 0x0630, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+120B (ላ)
	{ 0x0000, 0x0000, 0x0030, 0x0030, 0x0030, 0x0078, 0x00f8, 0x01cc, 0x018c, 0x018c, 0x018c, 0x0f8c, 0x198c, 0x0f8c, 0x0000, 0x0000 },	// U+120C (ሌ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x01e0, 0x03e0, 0x0730, 0x0630, 0x0618, 0x0618, 0x0678, 0x06d8, 0x0678, 0x0000, 0x0000 },	// U+120D (ል)
	{ 0x0000, 0x0000, 0x0030, 0x0030, 0x0030, 0x0078, 0x00f8, 0x01cc, 0x018c, 0x1f8c, 0x358c, 0x1d8c, 0x018c, 0x018c, 0x0000, 0x0000 },	// U+120E (ሎ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x01e0, 0x03e0, 0x0730, 0x0630, 0x0630, 0x0630, 0x0600, 0x0600, 0x0600, 0x3fc0, 0x70e0 },	// U+120F (ሏ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x07e0, 0x0db0, 0x0db0, 0x1998, 0x1998, 0x1998, 0x1998, 0x0000, 0x0000 },	// U+1210 (ሐ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x01f8, 0x036c, 0x036c, 0x7e66, 0x6666, 0x0666, 0x0666, 0x0000, 0x0000 },	// U+1211 (ሑ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x01f8, 0x036c, 0x036c, 0x0666, 0x0666, 0x6666, 0x7e66, 0x0000, 0x0000 },	// U+1212 (ሒ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x07e0, 0x0db0, 0x0db0, 0x1998, 0x1800, 0x1800, 0x1800, 0x0000, 0x0000 },	// U+1213 (ሓ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x01f8, 0x036c, 0x036c, 0x0266, 0x1e66, 0x3266, 0x1e66, 0x0000, 0x0000 },	// U+1214 (ሔ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x01e0, 0x0180, 0x07e0, 0x0db0, 0x0db0, 0x1998, 0x1998, 0x1998, 0x1998, 0x0000, 0x0000 },	// U+1215 (ሕ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x07e0, 0x0db0, 0x0db0, 0x1998, 0x0018, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+1216 (ሖ)
	{ 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x03f0, 0x06d8, 0x06d8, 0x0ccc, 0x0c00, 0x0c00, 0x0c00, 0x7f80, 0xe1c0, 0x0000 },	// U+1217 (ሗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ff0, 0x3ff8, 0x2488, 0x268c, 0x22c4, 0x3264, 0x1e3c, 0x0e3c, 0x0000, 0x0000, 0x0000 },	// U+1218 (መ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ffc, 0x0ffe, 0x0922, 0x79a3, 0x48b1, 0x4c99, 0x078f, 0x038f, 0x0000, 0x0000, 0x0000 },	// U+1219 (ሙ)
	{ 0x0000, 0x0000, 0x1ff8, 0x1ffc, 0x1146, 0x1142, 0x10a2, 0x1fbe, 0x1f1c, 0x0800, 0x0800, 0x0400, 0x6400, 0x7c00, 0x0000, 0x0000 },	// U+121A (ሚ)
	{ 0x0000, 0x0000, 0x3ff0, 0x3ff8, 0x228c, 0x2284, 0x2144, 0x3f7c, 0x3e38, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+121B (ማ)
	{ 0x0000, 0x0000, 0x1ff8, 0x1ffc, 0x1146, 0x1142, 0x10a2, 0x1fbe, 0x1f1c, 0x0800, 0x0800, 0x3c00, 0x6400, 0x3c00, 0x0000, 0x0000 },	// U+121C (ሜ)
	{ 0x0000, 0x0000, 0x0ff8, 0x1ff8, 0x114c, 0x1144, 0x1144, 0x1f44, 0x0e7c, 0x0078, 0x0040, 0x0060, 0x0030, 0x0018, 0x0000, 0x0000 },	// U+121D (ም)
	{ 0x0000, 0x0000, 0x0ff8, 0x1ff8, 0x114c, 0x1144, 0x1144, 0x1f44, 0x0e7c, 0x0078, 0x0040, 0x0040, 0x0040, 0x00c0, 0x0000, 0x0000 },	// U+121E (ሞ)
	{ 0x0000, 0x0000, 0x1ff8, 0x1ffc, 0x1146, 0x1142, 0x10a2, 0x1fbe, 0x1f1c, 0x0800, 0x0800, 0x0c00, 0x0400, 0x0400, 0x1f80, 0x30c0 },	// U+121F (ሟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1990, 0x1998, 0x1998, 0x1998, 0x1998, 0x0d98, 0x0f98, 0x01b0, 0x01e0, 0x0000, 0x0000, 0x0000 },	// U+1220 (ሠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0364, 0x0366, 0x3f66, 0x3366, 0x0366, 0x0366, 0x03e6, 0x006c, 0x0078, 0x0000, 0x0000, 0x0000 },	// U+1221 (ሡ)
	{ 0x0000, 0x0000, 0x0266, 0x0666, 0x0666, 0x0666, 0x0666, 0x076e, 0x07fc, 0x0600, 0x0600, 0x0600, 0x6600, 0x7e00, 0x0000, 0x0000 },	// U+1222 (ሢ)
	{ 0x0000, 0x0000, 0x0998, 0x1998, 0x1998, 0x1998, 0x1998, 0x1db8, 0x1ff0, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x0000, 0x0000 },	// U+1223 (ሣ)
	{ 0x0000, 0x0000, 0x04cc, 0x0ccc, 0x0ccc, 0x0ccc, 0x0ccc, 0x0edc, 0x0ff8, 0x0c00, 0x0c00, 0x1c00, 0x2600, 0x1e00, 0x0000, 0x0000 },	// U+1224 (ሤ)
	{ 0x0000, 0x0000, 0x0998, 0x1998, 0x1998, 0x1998, 0x1998, 0x1db8, 0x0ff8, 0x0038, 0x0018, 0x0018, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+1225 (ሥ)
	{ 0x0000, 0x0000, 0x1998, 0x1998, 0x1998, 0x1998, 0x1998, 0x1db8, 0x0ff0, 0x01c0, 0x00c0, 0x00e0, 0x0070, 0x0030, 0x0000, 0x0000 },	// U+1226 (ሦ)
	{ 0x0000, 0x0266, 0x0666, 0x0666, 0x0666, 0x0666, 0x076e, 0x07fc, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x3fc0, 0x70e0, 0x0000 },	// U+1227 (ሧ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x00c0, 0x00e0, 0x0070, 0x0038, 0x0018, 0x0018, 0x0638, 0x07f0, 0x07e0, 0x0000, 0x0000 },	// U+1228 (ረ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00e0, 0x0070, 0x0038, 0x0018, 0x000c, 0x001c, 0x0ff8, 0x0ff0, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1229 (ሩ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x00c0, 0x00e0, 0x0070, 0x0038, 0x0618, 0x0e18, 0x0c38, 0x07f0, 0x03e0, 0x0000, 0x0000 },	// U+122A (ሪ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x0060, 0x0070, 0x0038, 0x001c, 0x1e0c, 0x1f0c, 0x199c, 0x01f8, 0x00f0, 0x0000, 0x0000 },	// U+122B (ራ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x00c0, 0x00e0, 0x0070, 0x0038, 0x0018, 0x0018, 0x0f38, 0x19f0, 0x0fe0, 0x0000, 0x0000 },	// U+122C (ሬ)
	{ 0x0000, 0x0000, 0x0000, 0x07e0, 0x07f0, 0x0618, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0618, 0x07f8, 0x03f0, 0x0000, 0x0000 },	// U+122D (ር)
	{ 0x0000, 0x0000, 0x0000, 0x0fe0, 0x19f0, 0x0f18, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0618, 0x07f8, 0x03f0, 0x0000, 0x0000 },	// U+122E (ሮ)
	{ 0x0000, 0x0000, 0x0c0c, 0x0738, 0x00c0, 0x00c0, 0x0060, 0x0070, 0x0038, 0x001c, 0x1e0c, 0x1f0c, 0x199c, 0x01f8, 0x00f0, 0x0000 },	// U+122F (ሯ)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+1230 (ሰ)
	{ 0x0000, 0x0000, 0x0020, 0x0020, 0x0070, 0x00f8, 0x018c, 0x018c, 0x018c, 0x1f8c, 0x198c, 0x018c, 0x018c, 0x018c, 0x0000, 0x0000 },	// U+1231 (ሱ)
	{ 0x0000, 0x0000, 0x0020, 0x0020, 0x0070, 0x00f8, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x198c, 0x1f8c, 0x0000, 0x0000 },	// U+1232 (ሲ)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+1233 (ሳ)
	{ 0x0000, 0x0000, 0x0040, 0x0040, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x0718, 0x0b18, 0x1318, 0x1f18, 0x0000, 0x0000 },	// U+1234 (ሴ)
	{ 0x0000, 0x0000, 0x0000, 0x00c0, 0x0180, 0x0380, 0x07c0, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+1235 (ስ)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0030, 0x0030, 0x0030, 0x0000, 0x0000 },	// U+1236 (ሶ)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0600, 0x0600, 0x0600, 0x1f80, 0x30c0 },	// U+1237 (ሷ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0040, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0000, 0x0000 },	// U+1238 (ሸ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0040, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x3f18, 0x3318, 0x3318, 0x0318, 0x0318, 0x0000, 0x0000 },	// U+1239 (ሹ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0040, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x3318, 0x3f18, 0x0000, 0x0000 },	// U+123A (ሺ)
	{ 0x0000, 0x0000, 0x0c18, 0x07f0, 0x0080, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+123B (ሻ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0040, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x1f18, 0x3318, 0x1f18, 0x0000, 0x0000 },	// U+123C (ሼ)
	{ 0x0000, 0x0000, 0x0618, 0x03f0, 0x0180, 0x0380, 0x07c0, 0x0cc0, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+123D (ሽ)
	{ 0x0000, 0x0000, 0x0c18, 0x07f0, 0x0080, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0030, 0x0030, 0x0030, 0x0000, 0x0000 },	// U+123E (ሾ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0040, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0300, 0x0300, 0x0fc0, 0x1860 },	// U+123F (ሿ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1240 (ቀ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x07e0, 0x0cd8, 0x0ccc, 0x06cc, 0x01f8, 0x00c0, 0x0fc0, 0x0cc0, 0x00c0, 0x0000, 0x0000 },	// U+1241 (ቁ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x07e0, 0x0cd8, 0x0ccc, 0x06cc, 0x01f8, 0x00c0, 0x00c0, 0x0cc0, 0x0fc0, 0x0000, 0x0000 },	// U+1242 (ቂ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x00c0, 0x0060, 0x0030, 0x0000, 0x0000 },	// U+1243 (ቃ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x07e0, 0x0cd8, 0x0ccc, 0x06cc, 0x01f8, 0x00c0, 0x07c0, 0x0cc0, 0x07c0, 0x0000, 0x0000 },	// U+1244 (ቄ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x01e0, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1245 (ቅ)
	{ 0x0000, 0x0000, 0x0380, 0x0640, 0x0340, 0x00c0, 0x07e0, 0x0cd8, 0x0ccc, 0x06cc, 0x01f8, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1246 (ቆ)
	{ 0x0000, 0x0000, 0x0380, 0x0640, 0x0340, 0x00c0, 0x07e0, 0x0cd8, 0x0ccc, 0x06cc, 0x01f8, 0x00c0, 0x00cc, 0x00fc, 0x000c, 0x0000 },	// U+1247 (ቇ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x1f80, 0x3580, 0x1d80, 0x0180, 0x0000, 0x0000 },	// U+1248 (ቈ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x73b6, 0x6db6, 0x6386, 0x6fbe, 0x73be, 0x7ffe, 0x0000 },	// U+1249 (቉)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x03f0, 0x366c, 0x3666, 0x3f66, 0xe0fc, 0xc060, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+124A (ቊ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0180, 0x0180, 0x07e0, 0x0c30 },	// U+124B (ቋ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0f80, 0x1980, 0x0fe0, 0x0030 },	// U+124C (ቌ)
	{ 0x0000, 0x0000, 0x0060, 0x1860, 0x1860, 0x7ff0, 0x666c, 0x0666, 0x0366, 0x00fc, 0x0060, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+124D (ቍ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x61be, 0x7ffe, 0x0000 },	// U+124E (቎)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x7dbe, 0x7ffe, 0x0000 },	// U+124F (቏)
	{ 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1250 (ቐ)
	{ 0x0000, 0x0000, 0x0618, 0x03f0, 0x00c0, 0x00c0, 0x07e0, 0x0cd8, 0x0ccc, 0x06cc, 0x01f8, 0x00c0, 0x0fc0, 0x0cc0, 0x0000, 0x0000 },	// U+1251 (ቑ)
	{ 0x0000, 0x0000, 0x0618, 0x03f0, 0x00c0, 0x00c0, 0x07e0, 0x0cd8, 0x0ccc, 0x06cc, 0x01f8, 0x00c0, 0x0cc0, 0x0fc0, 0x0000, 0x0000 },	// U+1252 (ቒ)
	{ 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x00c0, 0x0060, 0x0000, 0x0000 },	// U+1253 (ቓ)
	{ 0x0000, 0x0000, 0x0618, 0x03f0, 0x00c0, 0x07e0, 0x0cd8, 0x0ccc, 0x06cc, 0x01f8, 0x00c0, 0x07c0, 0x0cc0, 0x07c0, 0x0000, 0x0000 },	// U+1254 (ቔ)
	{ 0x0000, 0x0000, 0x030c, 0x01f8, 0x0060, 0x01e0, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1255 (ቕ)
	{ 0x0000, 0x0000, 0x1830, 0x0fe0, 0x0480, 0x0680, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1256 (ቖ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x7786, 0x7bbe, 0x7b86, 0x7ffe, 0x0000 },	// U+1257 (቗)
	{ 0x0000, 0x0000, 0x0618, 0x03f0, 0x00c0, 0x07e0, 0x0cd8, 0x0ccc, 0x06cc, 0x01f8, 0x0fc0, 0x1ac0, 0x0ec0, 0x00c0, 0x0000, 0x0000 },	// U+1258 (ቘ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6386, 0x6fbe, 0x7386, 0x7ffe, 0x0000 },	// U+1259 (቙)
	{ 0x0000, 0x0000, 0x030c, 0x01f8, 0x0060, 0x0060, 0x03f0, 0x366c, 0x3666, 0x3f66, 0xe0fc, 0xc060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+125A (ቚ)
	{ 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0180, 0x07e0, 0x0c30 },	// U+125B (ቛ)
	{ 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0f80, 0x1980, 0x0fe0, 0x0030 },	// U+125C (ቜ)
	{ 0x0000, 0x0000, 0x030c, 0x01f8, 0x1860, 0x1860, 0x7ff0, 0x666c, 0x0666, 0x0366, 0x00fc, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+125D (ቝ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+125E (቞)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x7d86, 0x7ffe, 0x0000 },	// U+125F (቟)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+1260 (በ)
	{ 0x0000, 0x0000, 0x0000, 0x0070, 0x00f8, 0x018c, 0x018c, 0x018c, 0x1f8c, 0x198c, 0x198c, 0x018c, 0x018c, 0x018c, 0x0000, 0x0000 },	// U+1261 (ቡ)
	{ 0x0000, 0x0000, 0x0000, 0x0070, 0x00f8, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x198c, 0x1f8c, 0x0000, 0x0000 },	// U+1262 (ቢ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0600, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+1263 (ባ)
	{ 0x0000, 0x0000, 0x0000, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x1f18, 0x3318, 0x1f18, 0x0000, 0x0000 },	// U+1264 (ቤ)
	{ 0x0000, 0x0000, 0x0000, 0x0700, 0x0f80, 0x18c0, 0x18c0, 0x18c0, 0x18fc, 0x18cc, 0x18cc, 0x18c0, 0x18c0, 0x18c0, 0x0000, 0x0000 },	// U+1265 (ብ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0030, 0x0030, 0x0030, 0x0030, 0x0000, 0x0000 },	// U+1266 (ቦ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0600, 0x0600, 0x0600, 0x0600, 0x1f80, 0x30c0 },	// U+1267 (ቧ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0000, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0000, 0x0000 },	// U+1268 (ቨ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0000, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x3f18, 0x3318, 0x3318, 0x0318, 0x0318, 0x0000, 0x0000 },	// U+1269 (ቩ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0000, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x3318, 0x3f18, 0x0000, 0x0000 },	// U+126A (ቪ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0000, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0300, 0x0300, 0x0000, 0x0000 },	// U+126B (ቫ)
	{ 0x0000, 0x0000, 0x0306, 0x01fc, 0x0000, 0x0070, 0x00f8, 0x018c, 0x018c, 0x018c, 0x018c, 0x0f8c, 0x198c, 0x0f8c, 0x0000, 0x0000 },	// U+126C (ቬ)
	{ 0x0000, 0x0000, 0x1830, 0x0fe0, 0x0000, 0x0380, 0x07c0, 0x0c60, 0x0c60, 0x0c7e, 0x0c66, 0x0c66, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+126D (ቭ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0000, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+126E (ቮ)
	{ 0x0000, 0x0000, 0x060c, 0x03f8, 0x0000, 0x00e0, 0x01f0, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x0300, 0x0300, 0x0fc0, 0x1860 },	// U+126F (ቯ)
	{ 0x0000, 0x0000, 0x00e0, 0x00c0, 0x00c0, 0x00c0, 0x0ffc, 0x1ffe, 0x18c6, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1270 (ተ)
	{ 0x0000, 0x0000, 0x00e0, 0x00c0, 0x00c0, 0x00c0, 0x0ffc, 0x1ffe, 0x18c6, 0x00c0, 0x0fc0, 0x0cc0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1271 (ቱ)
	{ 0x0000, 0x0000, 0x00e0, 0x00c0, 0x00c0, 0x00c0, 0x0ffc, 0x1ffe, 0x18c6, 0x00c0, 0x00c0, 0x00c0, 0x0cc0, 0x0fc0, 0x0000, 0x0000 },	// U+1272 (ቲ)
	{ 0x0000, 0x0000, 0x00e0, 0x00c0, 0x00c0, 0x00c0, 0x0ffc, 0x1ffe, 0x18c6, 0x00c0, 0x00c0, 0x00e0, 0x0070, 0x0038, 0x0000, 0x0000 },	// U+1273 (ታ)
	{ 0x0000, 0x0000, 0x00e0, 0x00c0, 0x00c0, 0x00c0, 0x0ffc, 0x1ffe, 0x18c6, 0x00c0, 0x00c0, 0x07c0, 0x0cc0, 0x07c0, 0x0000, 0x0000 },	// U+1274 (ቴ)
	{ 0x0000, 0x0000, 0x0060, 0x00e0, 0x01c0, 0x0180, 0x0180, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1275 (ት)
	{ 0x0000, 0x0000, 0x07c0, 0x04c0, 0x0680, 0x0180, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1276 (ቶ)
	{ 0x0000, 0x0000, 0x01c0, 0x0180, 0x0180, 0x0180, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x07e0, 0x0c30 },	// U+1277 (ቷ)
	{ 0x0000, 0x0000, 0x1818, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1278 (ቸ)
	{ 0x0000, 0x0000, 0x1818, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x1f80, 0x1980, 0x0180, 0x0000, 0x0000 },	// U+1279 (ቹ)
	{ 0x0000, 0x0000, 0x1818, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x0180, 0x1980, 0x1f80, 0x0000, 0x0000 },	// U+127A (ቺ)
	{ 0x0000, 0x0000, 0x0c0c, 0x0ffc, 0x1ffe, 0x18c6, 0x00c0, 0x0ffc, 0x1ffe, 0x18c6, 0x00c0, 0x00e0, 0x0070, 0x0038, 0x0000, 0x0000 },	// U+127B (ቻ)
	{ 0x0000, 0x0000, 0x0c0c, 0x0ffc, 0x1ffe, 0x18c6, 0x00c0, 0x0ffc, 0x1ffe, 0x18c6, 0x00c0, 0x07c0, 0x0cc0, 0x07c0, 0x0000, 0x0000 },	// U+127C (ቼ)
	{ 0x0000, 0x0000, 0x030c, 0x03fc, 0x07fe, 0x0666, 0x00e0, 0x0180, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+127D (ች)
	{ 0x0000, 0x0000, 0x0c30, 0x1ff8, 0x1a58, 0x0240, 0x0180, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+127E (ቾ)
	{ 0x0000, 0x0000, 0x1818, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x1ff8, 0x3ffc, 0x318c, 0x0180, 0x0180, 0x0180, 0x0180, 0x07e0, 0x0c30 },	// U+127F (ቿ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x01f8, 0x0798, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+1280 (ኀ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x00fc, 0x03cc, 0x0300, 0x0300, 0x3f00, 0x3300, 0x0300, 0x0300, 0x0300, 0x0000, 0x0000 },	// U+1281 (ኁ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x00fc, 0x03cc, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x3300, 0x3f00, 0x0000, 0x0000 },	// U+1282 (ኂ)
	{ 0x0000, 0x0000, 0x0300, 0x0300, 0x0300, 0x03f0, 0x0f30, 0x0c00, 0x0c00, 0x0c00, 0x0700, 0x0180, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1283 (ኃ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x00fc, 0x03cc, 0x0300, 0x0300, 0x0300, 0x0300, 0x1f00, 0x3300, 0x1f00, 0x0000, 0x0000 },	// U+1284 (ኄ)
	{ 0x0000, 0x0000, 0x0300, 0x0300, 0x0300, 0x03c0, 0x0f60, 0x0c30, 0x0c30, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0000, 0x0000 },	// U+1285 (ኅ)
	{ 0x0000, 0x0000, 0x1f80, 0x27c0, 0x1c60, 0x007c, 0x006c, 0x0060, 0x07e0, 0x07c0, 0x0600, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+1286 (ኆ)
	{ 0x0000, 0x0000, 0x1f80, 0x27c0, 0x1c60, 0x007c, 0x006c, 0x0060, 0x07e0, 0x07c0, 0x0600, 0x0600, 0x0660, 0x07e0, 0x0060, 0x0000 },	// U+1287 (ኇ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x007e, 0x01e6, 0x0180, 0x1f80, 0x3580, 0x1d80, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1288 (ኈ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x63ce, 0x6fb6, 0x73ce, 0x7ffe, 0x0000 },	// U+1289 (኉)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x007e, 0x01e6, 0x1980, 0x1980, 0x1f80, 0x7180, 0x6180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+128A (ኊ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x01f8, 0x0798, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x1f80, 0x30c0 },	// U+128B (ኋ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x00fc, 0x03cc, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x1f00, 0x3300, 0x1fc0, 0x0060 },	// U+128C (ኌ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x0c7e, 0x0de6, 0x3f80, 0x3180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+128D (ኍ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+128E (኎)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+128F (኏)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x01e0, 0x0380, 0x0180, 0x0180, 0x0180, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1290 (ነ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x01e0, 0x0380, 0x0180, 0x0180, 0x0f80, 0x0cc0, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1291 (ኑ)
	{ 0x0000, 0x0000, 0x0030, 0x0030, 0x0030, 0x00f0, 0x01c0, 0x00c0, 0x00c0, 0x00c0, 0x0060, 0x0060, 0x0660, 0x07e0, 0x0000, 0x0000 },	// U+1292 (ኒ)
	{ 0x0000, 0x0000, 0x03e0, 0x07f0, 0x0618, 0x000c, 0x001c, 0x00f8, 0x01c0, 0x0180, 0x0080, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1293 (ና)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x01e0, 0x0380, 0x0180, 0x0180, 0x0180, 0x03c0, 0x04c0, 0x06c0, 0x03c0, 0x0000, 0x0000 },	// U+1294 (ኔ)
	{ 0x0000, 0x0000, 0x03fc, 0x01fc, 0x018c, 0x00c0, 0x03e0, 0x0300, 0x0180, 0x00c0, 0x00c0, 0x0060, 0x0060, 0x0030, 0x0000, 0x0000 },	// U+1295 (ን)
	{ 0x0000, 0x0000, 0x0fe0, 0x13f0, 0x1a18, 0x0c0c, 0x001c, 0x00f8, 0x01c0, 0x0180, 0x0080, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1296 (ኖ)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x07f0, 0x0618, 0x000c, 0x001c, 0x00f8, 0x01c0, 0x0180, 0x0080, 0x00c0, 0x00c0, 0x03f0, 0x0618 },	// U+1297 (ኗ)
	{ 0x0000, 0x0000, 0x0c30, 0x1ff8, 0x1188, 0x0180, 0x0780, 0x0e00, 0x0600, 0x0600, 0x0300, 0x0300, 0x0300, 0x0300, 0x0000, 0x0000 },	// U+1298 (ኘ)
	{ 0x0000, 0x0000, 0x0618, 0x0ffc, 0x08c4, 0x00c0, 0x03c0, 0x0700, 0x0300, 0x1f00, 0x1980, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1299 (ኙ)
	{ 0x0000, 0x0000, 0x0618, 0x0ffc, 0x08c4, 0x00c0, 0x03c0, 0x0700, 0x0300, 0x0300, 0x0180, 0x0180, 0x1980, 0x1f80, 0x0000, 0x0000 },	// U+129A (ኚ)
	{ 0x0000, 0x0c30, 0x1ff8, 0x1188, 0x03e0, 0x07f0, 0x0618, 0x000c, 0x001c, 0x00f8, 0x01c0, 0x0180, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+129B (ኛ)
	{ 0x0000, 0x0000, 0x0618, 0x0ffc, 0x08c4, 0x00c0, 0x03c0, 0x0700, 0x0300, 0x0300, 0x0780, 0x0980, 0x0d80, 0x0780, 0x0000, 0x0000 },	// U+129C (ኜ)
	{ 0x0000, 0x030c, 0x07fe, 0x0462, 0x03f8, 0x01fc, 0x018c, 0x00c0, 0x03e0, 0x0300, 0x0180, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+129D (ኝ)
	{ 0x0000, 0x0630, 0x0ff8, 0x0888, 0x0fe0, 0x13f0, 0x1a18, 0x0c0c, 0x001c, 0x00f8, 0x01c0, 0x0180, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+129E (ኞ)
	{ 0x0000, 0x0c30, 0x1ff8, 0x1188, 0x03e0, 0x07f0, 0x0618, 0x000c, 0x001c, 0x00f8, 0x01c0, 0x0180, 0x00c0, 0x00c0, 0x03f0, 0x0618 },	// U+129F (ኟ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x01e0, 0x0180, 0x01c0, 0x03c0, 0x0760, 0x0670, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+12A0 (አ)
	{ 0x0000, 0x0000, 0x0018, 0x0018, 0x0018, 0x0078, 0x0060, 0x0070, 0x00f0, 0x01d8, 0x1f9c, 0x198c, 0x018c, 0x018c, 0x0000, 0x0000 },	// U+12A1 (ኡ)
	{ 0x0000, 0x0000, 0x0018, 0x0018, 0x0018, 0x0078, 0x0060, 0x0070, 0x00f0, 0x01d8, 0x019c, 0x018c, 0x198c, 0x1f8c, 0x0000, 0x0000 },	// U+12A2 (ኢ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x01e0, 0x0180, 0x03c0, 0x0760, 0x0630, 0x0630, 0x0630, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+12A3 (ኣ)
	{ 0x0000, 0x0000, 0x0018, 0x0018, 0x0018, 0x0078, 0x0060, 0x0070, 0x00f0, 0x01d8, 0x019c, 0x0f8c, 0x198c, 0x0f8c, 0x0000, 0x0000 },	// U+12A4 (ኤ)
	{ 0x0000, 0x0000, 0x0030, 0x0030, 0x0070, 0x0060, 0x00c0, 0x01c0, 0x03e0, 0x0770, 0x0630, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+12A5 (እ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x01e0, 0x0180, 0x03c0, 0x0760, 0x0630, 0x0630, 0x0630, 0x0030, 0x0030, 0x0000, 0x0000 },	// U+12A6 (ኦ)
	{ 0x0000, 0x0318, 0x03f8, 0x066c, 0x0060, 0x01e0, 0x0180, 0x01c0, 0x03c0, 0x0760, 0x0670, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+12A7 (ኧ)
	{ 0x0000, 0x0000, 0x0000, 0x0018, 0x0398, 0x07f8, 0x0c78, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+12A8 (ከ)
	{ 0x0000, 0x0000, 0x0000, 0x0006, 0x00e6, 0x01fe, 0x031e, 0x0318, 0x0318, 0x3f18, 0x3318, 0x0318, 0x0318, 0x0318, 0x0000, 0x0000 },	// U+12A9 (ኩ)
	{ 0x0000, 0x0000, 0x0000, 0x0006, 0x00e6, 0x01fe, 0x031e, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x3318, 0x3f18, 0x0000, 0x0000 },	// U+12AA (ኪ)
	{ 0x0000, 0x0000, 0x0000, 0x0018, 0x0398, 0x07f8, 0x0c78, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c00, 0x0c00, 0x0c00, 0x0000, 0x0000 },	// U+12AB (ካ)
	{ 0x0000, 0x0000, 0x0000, 0x0006, 0x00e6, 0x01fe, 0x031e, 0x0318, 0x0318, 0x0318, 0x0318, 0x1f18, 0x3318, 0x1f18, 0x0000, 0x0000 },	// U+12AC (ኬ)
	{ 0x0000, 0x0000, 0x0000, 0x0018, 0x0398, 0x07d8, 0x0c78, 0x0c30, 0x0c70, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+12AD (ክ)
	{ 0x0000, 0x0000, 0x0000, 0x0018, 0x0398, 0x07f8, 0x0c78, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+12AE (ኮ)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x0730, 0x0ff0, 0x18f0, 0x18c0, 0x18cc, 0x18fc, 0x18cc, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+12AF (ኯ)
	{ 0x0000, 0x0000, 0x0000, 0x0006, 0x0066, 0x00fe, 0x019e, 0x0198, 0x1f98, 0x3598, 0x1d98, 0x0198, 0x0198, 0x0198, 0x0000, 0x0000 },	// U+12B0 (ኰ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x77c6, 0x73b6, 0x77c6, 0x77b6, 0x63c6, 0x7ffe, 0x0000 },	// U+12B1 (኱)
	{ 0x0000, 0x0000, 0x0000, 0x0006, 0x0066, 0x00fe, 0x019e, 0x1998, 0x1998, 0x1f98, 0x7198, 0x6198, 0x0198, 0x0198, 0x0000, 0x0000 },	// U+12B2 (ኲ)
	{ 0x0000, 0x0000, 0x0000, 0x0018, 0x0398, 0x07f8, 0x0c78, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c00, 0x0c00, 0x0c00, 0x3f00, 0x6180 },	// U+12B3 (ኳ)
	{ 0x0000, 0x0000, 0x0000, 0x0006, 0x00e6, 0x01fe, 0x031e, 0x0318, 0x0318, 0x0318, 0x0318, 0x0300, 0x1f00, 0x3300, 0x1fc0, 0x0060 },	// U+12B4 (ኴ)
	{ 0x0000, 0x0000, 0x0000, 0x0006, 0x0c66, 0x0cfe, 0x3f9e, 0x3198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0000, 0x0000 },	// U+12B5 (ኵ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x73c6, 0x7db6, 0x71c6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+12B6 (኶)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x77c6, 0x7bb6, 0x7bc6, 0x7ffe, 0x0000 },	// U+12B7 (኷)
	{ 0x0000, 0x0000, 0x0186, 0x00fc, 0x0030, 0x03b0, 0x07f0, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+12B8 (ኸ)
	{ 0x0000, 0x0000, 0x00c3, 0x007e, 0x0018, 0x01d8, 0x03f8, 0x0630, 0x0630, 0x7e30, 0x6630, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+12B9 (ኹ)
	{ 0x0000, 0x0000, 0x00c3, 0x007e, 0x0018, 0x01d8, 0x03f8, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x6630, 0x7e30, 0x0000, 0x0000 },	// U+12BA (ኺ)
	{ 0x0000, 0x0000, 0x0186, 0x00fc, 0x0030, 0x03b0, 0x07f0, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c00, 0x0c00, 0x0c00, 0x0000, 0x0000 },	// U+12BB (ኻ)
	{ 0x0000, 0x0000, 0x0186, 0x00fc, 0x0030, 0x03b0, 0x07f0, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x7c60, 0xcc60, 0x7c60, 0x0000, 0x0000 },	// U+12BC (ኼ)
	{ 0x0000, 0x0000, 0x0186, 0x00fc, 0x0030, 0x0770, 0x0ff0, 0x18c0, 0x19c0, 0x1980, 0x1980, 0x1980, 0x1980, 0x1980, 0x0000, 0x0000 },	// U+12BD (ኽ)
	{ 0x0000, 0x0000, 0x0186, 0x00fc, 0x0030, 0x03b0, 0x07f0, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+12BE (ኾ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71c6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+12BF (኿)
	{ 0x0000, 0x0000, 0x00c3, 0x007e, 0x0018, 0x01d8, 0x03f8, 0x0630, 0x7e30, 0xd630, 0x7630, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+12C0 (ዀ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x778e, 0x73f6, 0x77f6, 0x77f6, 0x638e, 0x7ffe, 0x0000 },	// U+12C1 (዁)
	{ 0x0000, 0x0000, 0x00c3, 0x007e, 0x0018, 0x00d8, 0x01f8, 0x3330, 0x3330, 0x3f30, 0xe330, 0xc330, 0x0330, 0x0330, 0x0000, 0x0000 },	// U+12C2 (ዂ)
	{ 0x0000, 0x0000, 0x0186, 0x00fc, 0x0030, 0x03b0, 0x07f0, 0x0e60, 0x0c60, 0x0c60, 0x0c60, 0x0c00, 0x0c00, 0x0c00, 0x3f00, 0x6180 },	// U+12C3 (ዃ)
	{ 0x0000, 0x0000, 0x0186, 0x00fc, 0x0030, 0x03b0, 0x07f0, 0x0e60, 0x0c60, 0x0c60, 0x0c60, 0x0c00, 0x7c00, 0xcc00, 0x7f00, 0x0180 },	// U+12C4 (ዄ)
	{ 0x0000, 0x0000, 0x00c3, 0x007e, 0x3018, 0x31d8, 0xfff8, 0xc630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+12C5 (ዅ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x738e, 0x7df6, 0x71f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+12C6 (዆)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x618e, 0x6ff6, 0x77f6, 0x7bf6, 0x7b8e, 0x7ffe, 0x0000 },	// U+12C7 (዇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x1db8, 0x198c, 0x198c, 0x18cc, 0x0ccc, 0x0edc, 0x03f8, 0x0000, 0x0000, 0x0000 },	// U+12C8 (ወ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03fc, 0x076e, 0x0663, 0x0663, 0x0633, 0x0733, 0x63b7, 0x3ffe, 0x3000, 0x0000, 0x0000 },	// U+12C9 (ዉ)
	{ 0x0000, 0x0000, 0x0ff0, 0x1db8, 0x198c, 0x198c, 0x18cc, 0x0ddc, 0x07f8, 0x00c0, 0x00c0, 0x00e0, 0x0660, 0x07e0, 0x0000, 0x0000 },	// U+12CA (ዊ)
	{ 0x0000, 0x0000, 0x0ff0, 0x1db8, 0x198c, 0x198c, 0x18cc, 0x0ddc, 0x07f8, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00e0, 0x0000, 0x0000 },	// U+12CB (ዋ)
	{ 0x0000, 0x0000, 0x0ff0, 0x1db8, 0x198c, 0x198c, 0x18cc, 0x0ddc, 0x07f8, 0x00c0, 0x00c0, 0x01e0, 0x0660, 0x03e0, 0x0000, 0x0000 },	// U+12CC (ዌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03fc, 0x076e, 0x0663, 0x7e63, 0x6633, 0x4333, 0x03b7, 0x00fe, 0x0000, 0x0000, 0x0000 },	// U+12CD (ው)
	{ 0x0000, 0x0000, 0x0ff0, 0x1db8, 0x198c, 0x198c, 0x18cc, 0x0ddc, 0x07f8, 0x00c0, 0x0060, 0x0030, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+12CE (ዎ)
	{ 0x0000, 0x0000, 0x3fc0, 0x76e0, 0x6636, 0x663e, 0x6336, 0x3770, 0x1fe0, 0x0300, 0x0180, 0x00c0, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+12CF (ዏ)
	{ 0x0000, 0x0000, 0x0000, 0x0780, 0x0c60, 0x0c30, 0x0c30, 0x0c30, 0x0c30, 0x0c30, 0x0c30, 0x0c30, 0x0fe0, 0x0060, 0x0000, 0x0000 },	// U+12D0 (ዐ)
	{ 0x0000, 0x0000, 0x0000, 0x01e0, 0x0318, 0x030c, 0x030c, 0x030c, 0x030c, 0x3f0c, 0x330c, 0x030c, 0x03f8, 0x0018, 0x0000, 0x0000 },	// U+12D1 (ዑ)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x018c, 0x0186, 0x0186, 0x0186, 0x03fc, 0x0300, 0x0300, 0x0180, 0x1980, 0x1f80, 0x0000, 0x0000 },	// U+12D2 (ዒ)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x0630, 0x0618, 0x0618, 0x0618, 0x0ff0, 0x0c00, 0x0c00, 0x0c00, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+12D3 (ዓ)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x018c, 0x0186, 0x0186, 0x0186, 0x03fc, 0x0300, 0x0300, 0x0f80, 0x1980, 0x0f80, 0x0000, 0x0000 },	// U+12D4 (ዔ)
	{ 0x0000, 0x0180, 0x0180, 0x0180, 0x07e0, 0x0c70, 0x0c30, 0x0c30, 0x0c30, 0x0c30, 0x0c30, 0x0c30, 0x0fe0, 0x0060, 0x0000, 0x0000 },	// U+12D5 (ዕ)
	{ 0x0000, 0x0000, 0x03c0, 0x0660, 0x0c30, 0x0c30, 0x0c30, 0x0e70, 0x07e0, 0x03c0, 0x00e0, 0x0030, 0x0030, 0x0030, 0x0000, 0x0000 },	// U+12D6 (ዖ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x61de, 0x7dde, 0x618e, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x77b6, 0x7bb6, 0x7bc6, 0x7ffe, 0x0000 },	// U+12D7 (዗)
	{ 0x0000, 0x0000, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x07f0, 0x07f0, 0x0630, 0x0630, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+12D8 (ዘ)
	{ 0x0000, 0x0000, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x01fc, 0x01fc, 0x1f8c, 0x198c, 0x198c, 0x018c, 0x018c, 0x0000, 0x0000 },	// U+12D9 (ዙ)
	{ 0x0000, 0x0000, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x01fc, 0x01fc, 0x018c, 0x018c, 0x018c, 0x198c, 0x1f8c, 0x0000, 0x0000 },	// U+12DA (ዚ)
	{ 0x0000, 0x0000, 0x0630, 0x0630, 0x0630, 0x0630, 0x07f0, 0x07f0, 0x0630, 0x0630, 0x0630, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+12DB (ዛ)
	{ 0x0000, 0x0000, 0x0318, 0x0318, 0x0318, 0x0318, 0x0318, 0x03f8, 0x03f8, 0x0318, 0x0318, 0x1f18, 0x3318, 0x1f18, 0x0000, 0x0000 },	// U+12DC (ዜ)
	{ 0x0000, 0x0000, 0x0c38, 0x0c6c, 0x0c6c, 0x0c60, 0x0c60, 0x0fe0, 0x0fe0, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+12DD (ዝ)
	{ 0x0000, 0x0000, 0x0630, 0x0630, 0x0630, 0x0630, 0x07f0, 0x07f0, 0x0630, 0x0630, 0x0630, 0x0030, 0x0030, 0x0030, 0x0000, 0x0000 },	// U+12DE (ዞ)
	{ 0x0000, 0x0000, 0x0630, 0x0630, 0x0630, 0x0630, 0x07f0, 0x07f0, 0x0630, 0x0630, 0x0630, 0x0600, 0x0600, 0x0600, 0x1f80, 0x30c0 },	// U+12DF (ዟ)
	{ 0x0000, 0x0000, 0x1c38, 0x366c, 0x366c, 0x0660, 0x0660, 0x07e0, 0x07e0, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0000, 0x0000 },	// U+12E0 (ዠ)
	{ 0x0000, 0x0000, 0x0e1c, 0x1b36, 0x1b36, 0x0330, 0x0330, 0x03f0, 0x03f0, 0x3f30, 0x3330, 0x3330, 0x0330, 0x0330, 0x0000, 0x0000 },	// U+12E1 (ዡ)
	{ 0x0000, 0x0000, 0x0e1c, 0x1b36, 0x1b36, 0x0330, 0x0330, 0x03f0, 0x03f0, 0x0330, 0x0330, 0x0330, 0x3330, 0x3f30, 0x0000, 0x0000 },	// U+12E2 (ዢ)
	{ 0x0000, 0x0000, 0x1c38, 0x366c, 0x366c, 0x0660, 0x07e0, 0x07e0, 0x0660, 0x0660, 0x0660, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+12E3 (ዣ)
	{ 0x0000, 0x0000, 0x0e1c, 0x1b36, 0x1b36, 0x0330, 0x0330, 0x03f0, 0x03f0, 0x0330, 0x0330, 0x1f30, 0x3330, 0x1f30, 0x0000, 0x0000 },	// U+12E4 (ዤ)
	{ 0x0000, 0x0186, 0x00fc, 0x0030, 0x1c38, 0x366c, 0x366c, 0x0660, 0x07e0, 0x07e0, 0x0660, 0x0660, 0x0660, 0x0660, 0x0000, 0x0000 },	// U+12E5 (ዥ)
	{ 0x0000, 0x0000, 0x1c38, 0x366c, 0x366c, 0x0660, 0x07e0, 0x07e0, 0x0660, 0x0660, 0x0660, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+12E6 (ዦ)
	{ 0x0000, 0x0000, 0x1c38, 0x366c, 0x366c, 0x0660, 0x07e0, 0x07e0, 0x0660, 0x0660, 0x0660, 0x0600, 0x0600, 0x0600, 0x1f80, 0x30c0 },	// U+12E7 (ዧ)
	{ 0x0000, 0x0000, 0x01c0, 0x0360, 0x0630, 0x0630, 0x0630, 0x0630, 0x0370, 0x01e0, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+12E8 (የ)
	{ 0x0000, 0x0000, 0x01c0, 0x0360, 0x0630, 0x0630, 0x0630, 0x0630, 0x0370, 0x01e0, 0x00c0, 0x0fc0, 0x0cc0, 0x00c0, 0x0000, 0x0000 },	// U+12E9 (ዩ)
	{ 0x0000, 0x0000, 0x00e0, 0x01b0, 0x0318, 0x0318, 0x0318, 0x0318, 0x01b8, 0x00f0, 0x0660, 0x1fe0, 0x1860, 0x0060, 0x0000, 0x0000 },	// U+12EA (ዪ)
	{ 0x0000, 0x0000, 0x0380, 0x06c0, 0x0c60, 0x0c60, 0x0c60, 0x0660, 0x03e0, 0x01c0, 0x0380, 0x0600, 0x0380, 0x01c0, 0x0000, 0x0000 },	// U+12EB (ያ)
	{ 0x0000, 0x0000, 0x00e0, 0x01b0, 0x0318, 0x0318, 0x0318, 0x0318, 0x01b8, 0x00f0, 0x0f60, 0x19e0, 0x0f60, 0x0060, 0x0000, 0x0000 },	// U+12EC (ዬ)
	{ 0x0000, 0x0000, 0x0000, 0x01e0, 0x0330, 0x0318, 0x0318, 0x0318, 0x01b0, 0x0cf0, 0x0ce0, 0x07c0, 0x007c, 0x000e, 0x0006, 0x0000 },	// U+12ED (ይ)
	{ 0x0000, 0x0000, 0x0070, 0x00d8, 0x018c, 0x1f8c, 0x198c, 0x018c, 0x00dc, 0x0078, 0x0030, 0x0030, 0x0030, 0x0030, 0x0000, 0x0000 },	// U+12EE (ዮ)
	{ 0x0000, 0x0000, 0x01c0, 0x0360, 0x0630, 0x7e30, 0x6630, 0x0630, 0x0376, 0x01fe, 0x00c6, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+12EF (ዯ)
	{ 0x0000, 0x0000, 0x01c0, 0x03e0, 0x0230, 0x0230, 0x0330, 0x01f0, 0x0060, 0x00c0, 0x00c0, 0x0180, 0x1ff8, 0x1818, 0x0000, 0x0000 },	// U+12F0 (ደ)
	{ 0x0000, 0x0000, 0x00e0, 0x01f0, 0x0118, 0x0198, 0x00f8, 0x0030, 0x0060, 0x03f8, 0x030c, 0x3f0c, 0x3180, 0x0180, 0x0000, 0x0000 },	// U+12F1 (ዱ)
	{ 0x0000, 0x0000, 0x00e0, 0x01f0, 0x0118, 0x0198, 0x00f8, 0x0030, 0x0060, 0x03f8, 0x030c, 0x030c, 0x1980, 0x1f80, 0x0000, 0x0000 },	// U+12F2 (ዲ)
	{ 0x0000, 0x0000, 0x0380, 0x07c0, 0x0460, 0x0660, 0x03e0, 0x00c0, 0x0180, 0x0ff0, 0x0c30, 0x0c30, 0x0c00, 0x0c00, 0x0000, 0x0000 },	// U+12F3 (ዳ)
	{ 0x0000, 0x0000, 0x00e0, 0x01f0, 0x0118, 0x0118, 0x0198, 0x00f8, 0x0030, 0x0060, 0x0060, 0x0fc0, 0x19fc, 0x0f0c, 0x0000, 0x0000 },	// U+12F4 (ዴ)
	{ 0x0000, 0x0000, 0x00e0, 0x01f0, 0x1f18, 0x1918, 0x0198, 0x00f8, 0x0030, 0x0060, 0x0060, 0x00c0, 0x0ffc, 0x0c0c, 0x0000, 0x0000 },	// U+12F5 (ድ)
	{ 0x0000, 0x0000, 0x0380, 0x07c0, 0x0460, 0x0660, 0x03e0, 0x01c0, 0x0fe0, 0x0c30, 0x0018, 0x0018, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+12F6 (ዶ)
	{ 0x0000, 0x0000, 0x0380, 0x07c0, 0x0460, 0x0660, 0x03e0, 0x00c0, 0x0180, 0x0ff0, 0x0c30, 0x0c30, 0x0c00, 0x0c00, 0x3f00, 0x6180 },	// U+12F7 (ዷ)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x01c0, 0x03e0, 0x0230, 0x0330, 0x01f0, 0x0060, 0x00c0, 0x0180, 0x0ff0, 0x0c30, 0x0000, 0x0000 },	// U+12F8 (ዸ)
	{ 0x0000, 0x0000, 0x0040, 0x0040, 0x00e0, 0x01f0, 0x0118, 0x0198, 0x00f8, 0x0030, 0x03f8, 0x3f0c, 0x318c, 0x0180, 0x0000, 0x0000 },	// U+12F9 (ዹ)
	{ 0x0000, 0x0000, 0x0040, 0x0040, 0x00e0, 0x01f0, 0x0118, 0x0198, 0x00f8, 0x0030, 0x03f8, 0x030c, 0x198c, 0x1f80, 0x0000, 0x0000 },	// U+12FA (ዺ)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x01c0, 0x03e0, 0x0230, 0x0330, 0x01f0, 0x0060, 0x07f8, 0x0618, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+12FB (ዻ)
	{ 0x0000, 0x0000, 0x0020, 0x0020, 0x0070, 0x00f8, 0x008c, 0x00cc, 0x007c, 0x0018, 0x0030, 0x0f60, 0x19fc, 0x0f0c, 0x0000, 0x0000 },	// U+12FC (ዼ)
	{ 0x0000, 0x0000, 0x0040, 0x0040, 0x00e0, 0x01f0, 0x1f18, 0x1998, 0x00f8, 0x0030, 0x0060, 0x00c0, 0x07f8, 0x0618, 0x0000, 0x0000 },	// U+12FD (ዽ)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x01c0, 0x03e0, 0x0230, 0x0330, 0x01f0, 0x0fe0, 0x0c30, 0x0018, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+12FE (ዾ)
	{ 0x0100, 0x0100, 0x0380, 0x07c0, 0x0460, 0x0660, 0x03e0, 0x00c0, 0x0180, 0x0ff0, 0x0c30, 0x0c30, 0x0c00, 0x0c00, 0x3f00, 0x6180 },	// U+12FF (ዿ)
	{ 0x0000, 0x0c0c, 0x07f8, 0x00c0, 0x01e0, 0x0330, 0x0230, 0x0330, 0x01e0, 0x0060, 0x00e0, 0x00c0, 0x07f8, 0x0618, 0x0000, 0x0000 },	// U+1300 (ጀ)
	{ 0x0000, 0x0606, 0x03fc, 0x0060, 0x00f0, 0x0198, 0x0198, 0x00f0, 0x0060, 0x03f8, 0x030c, 0x3f0c, 0x3180, 0x0180, 0x0000, 0x0000 },	// U+1301 (ጁ)
	{ 0x0000, 0x0606, 0x03fc, 0x0060, 0x00f0, 0x0198, 0x0198, 0x00f0, 0x0060, 0x03f8, 0x030c, 0x030c, 0x1980, 0x1f80, 0x0000, 0x0000 },	// U+1302 (ጂ)
	{ 0x0000, 0x0c0c, 0x07f8, 0x00c0, 0x01e0, 0x0330, 0x0330, 0x01e0, 0x00c0, 0x07f8, 0x0618, 0x0618, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+1303 (ጃ)
	{ 0x0000, 0x0606, 0x03fc, 0x0060, 0x00f0, 0x0198, 0x0118, 0x0198, 0x00f0, 0x0030, 0x0070, 0x0fe0, 0x19fc, 0x0f0c, 0x0000, 0x0000 },	// U+1304 (ጄ)
	{ 0x0000, 0x0c0c, 0x07f8, 0x00c0, 0x01e0, 0x0330, 0x3e30, 0x3330, 0x01e0, 0x0060, 0x00e0, 0x00c0, 0x07f8, 0x0618, 0x0000, 0x0000 },	// U+1305 (ጅ)
	{ 0x0000, 0x0c0c, 0x07f8, 0x00c0, 0x01e0, 0x0330, 0x0330, 0x01e0, 0x0fe0, 0x0c30, 0x0018, 0x0018, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+1306 (ጆ)
	{ 0x0000, 0x0c0c, 0x07f8, 0x00c0, 0x01e0, 0x0330, 0x0330, 0x01e0, 0x00c0, 0x07f8, 0x0618, 0x0618, 0x0600, 0x0600, 0x3fc0, 0x70e0 },	// U+1307 (ጇ)
	{ 0x0000, 0x0000, 0x0000, 0x01f0, 0x0318, 0x0318, 0x0300, 0x0300, 0x0300, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1308 (ገ)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x018c, 0x018c, 0x0180, 0x0180, 0x0180, 0x1fc0, 0x18c0, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1309 (ጉ)
	{ 0x0000, 0x0000, 0x0000, 0x01f0, 0x0318, 0x0318, 0x0300, 0x0300, 0x0300, 0x0180, 0x0180, 0x0180, 0x1980, 0x1f80, 0x0000, 0x0000 },	// U+130A (ጊ)
	{ 0x0000, 0x0000, 0x0000, 0x01e0, 0x07f0, 0x0630, 0x0600, 0x0600, 0x0600, 0x0300, 0x0380, 0x01e0, 0x0070, 0x0030, 0x0000, 0x0000 },	// U+130B (ጋ)
	{ 0x0000, 0x0000, 0x0000, 0x01f0, 0x0318, 0x0318, 0x0300, 0x0300, 0x0300, 0x0180, 0x0180, 0x0f80, 0x1980, 0x0f80, 0x0000, 0x0000 },	// U+130C (ጌ)
	{ 0x0000, 0x0000, 0x0000, 0x07f0, 0x0d98, 0x0cf0, 0x0c00, 0x0c00, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+130D (ግ)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x03e0, 0x0630, 0x0630, 0x0600, 0x0200, 0x0300, 0x0300, 0x0300, 0x0300, 0x0000, 0x0000 },	// U+130E (ጎ)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x03e0, 0x0630, 0x0630, 0x0600, 0x0200, 0x0300, 0x0300, 0x0330, 0x03f0, 0x0030, 0x0000 },	// U+130F (ጏ)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x018c, 0x018c, 0x0180, 0x0180, 0x1f80, 0x35c0, 0x1cc0, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1310 (ጐ)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x77de, 0x73ce, 0x77de, 0x77de, 0x638e, 0x7ffe, 0x0000 },	// U+1311 (጑)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x018c, 0x018c, 0x0180, 0x0d80, 0x0d80, 0x0fc0, 0x38c0, 0x30c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1312 (ጒ)
	{ 0x0000, 0x0000, 0x0000, 0x01e0, 0x0330, 0x0330, 0x0300, 0x07e0, 0x0660, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+1313 (ጓ)
	{ 0x0000, 0x0000, 0x0000, 0x01f0, 0x0318, 0x0318, 0x0300, 0x0300, 0x0300, 0x0180, 0x0180, 0x0180, 0x0f80, 0x1980, 0x0fe0, 0x0030 },	// U+1314 (ጔ)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x0d8c, 0x0d8c, 0x3f80, 0x3180, 0x0180, 0x01c0, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1315 (ጕ)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x0000 },	// U+1316 (጖)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x0000 },	// U+1317 (጗)
	{ 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0000, 0x03e0, 0x0630, 0x0630, 0x0600, 0x0200, 0x0300, 0x0300, 0x0300, 0x0300, 0x0000, 0x0000 },	// U+1318 (ጘ)
	{ 0x0000, 0x0000, 0x030c, 0x01f8, 0x0000, 0x00f8, 0x018c, 0x018c, 0x0180, 0x0180, 0x1fc0, 0x18c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+1319 (ጙ)
	{ 0x0000, 0x0000, 0x0618, 0x03f0, 0x0000, 0x01f0, 0x0318, 0x0318, 0x0300, 0x0100, 0x0180, 0x0180, 0x1980, 0x1f80, 0x0000, 0x0000 },	// U+131A (ጚ)
	{ 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0000, 0x03c0, 0x0fe0, 0x0c20, 0x0c00, 0x0c00, 0x0700, 0x03c0, 0x00e0, 0x0070, 0x0000, 0x0000 },	// U+131B (ጛ)
	{ 0x0000, 0x0000, 0x0618, 0x03f0, 0x0000, 0x01f0, 0x0318, 0x0318, 0x0300, 0x0100, 0x0180, 0x0f80, 0x1980, 0x0f80, 0x0000, 0x0000 },	// U+131C (ጜ)
	{ 0x0000, 0x0000, 0x0618, 0x03f0, 0x0000, 0x07f0, 0x0d98, 0x0cf0, 0x0c00, 0x0400, 0x0600, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+131D (ጝ)
	{ 0x0000, 0x0000, 0x0630, 0x03e0, 0x0080, 0x03e0, 0x0630, 0x0630, 0x0600, 0x0200, 0x0300, 0x0300, 0x0300, 0x0300, 0x0000, 0x0000 },	// U+131E (ጞ)
	{ 0x0000, 0x0000, 0x0618, 0x03f0, 0x0040, 0x01f0, 0x0318, 0x0318, 0x0300, 0x0100, 0x0180, 0x0180, 0x0180, 0x0ff0, 0x0c30, 0x0000 },	// U+131F (ጟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x06b0, 0x06b0, 0x0c98, 0x0c98, 0x0c98, 0x0c98, 0x0c98, 0x0c98, 0x0c98, 0x0000, 0x0000 },	// U+1320 (ጠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x01ac, 0x01ac, 0x0326, 0x0326, 0x3f26, 0x3326, 0x0326, 0x0326, 0x0326, 0x0000, 0x0000 },	// U+1321 (ጡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x01ac, 0x01ac, 0x0326, 0x0326, 0x0326, 0x0326, 0x0326, 0x3326, 0x3f26, 0x0000, 0x0000 },	// U+1322 (ጢ)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x06b0, 0x06b0, 0x0c98, 0x0c98, 0x0c98, 0x0c98, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0000, 0x0000 },	// U+1323 (ጣ)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x01ac, 0x01ac, 0x0326, 0x0326, 0x0326, 0x0326, 0x0326, 0x1f26, 0x3326, 0x1f26, 0x0000, 0x0000 },	// U+1324 (ጤ)
	{ 0x0000, 0x0000, 0x0000, 0x07f0, 0x0ff8, 0x0cc8, 0x18cc, 0x19cc, 0x198c, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1325 (ጥ)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x06b0, 0x06b0, 0x0c98, 0x0c98, 0x0c98, 0x0c98, 0x0018, 0x0018, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+1326 (ጦ)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x06b0, 0x06b0, 0x0c98, 0x0c98, 0x0c98, 0x0c98, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x3f00, 0x6180 },	// U+1327 (ጧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x03fc, 0x0646, 0x0c43, 0x0c43, 0x0c43, 0x1ccf, 0x6d5b, 0x4d53, 0x7ddf, 0x0000, 0x0000 },	// U+1328 (ጨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x03fc, 0x0646, 0x0c43, 0xfc43, 0xcc43, 0x1ccf, 0x2d5b, 0x4d53, 0x7ddf, 0x0000, 0x0000 },	// U+1329 (ጩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x03fc, 0x0646, 0x0c43, 0x0c43, 0x0c43, 0x0ccf, 0x0d5b, 0xcd53, 0xfddf, 0x0000, 0x0000 },	// U+132A (ጪ)
	{ 0x0000, 0x0000, 0x07f0, 0x0ff8, 0x188c, 0x1886, 0x198e, 0x1a96, 0x1aa6, 0x1bbe, 0x1800, 0x2c00, 0x4c00, 0x7c00, 0x0000, 0x0000 },	// U+132B (ጫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x03fc, 0x0646, 0xfc43, 0x9c43, 0xec43, 0x0ccf, 0x3d5b, 0x4d53, 0x7ddf, 0x0000, 0x0000 },	// U+132C (ጬ)
	{ 0x0000, 0x0000, 0x0000, 0x03f8, 0x07fe, 0x0c63, 0x1c67, 0x24e9, 0x3ccf, 0x00c0, 0x01c0, 0x02c0, 0x04c0, 0x07c0, 0x0000, 0x0000 },	// U+132D (ጭ)
	{ 0x0000, 0x0000, 0x07f0, 0x0ff8, 0x1858, 0x184c, 0x18c4, 0x2946, 0x4a46, 0x39c6, 0x000e, 0x0016, 0x0026, 0x003e, 0x0000, 0x0000 },	// U+132E (ጮ)
	{ 0x0000, 0x0000, 0x0000, 0x07f0, 0x0ff8, 0x188c, 0x1886, 0x198e, 0x1a96, 0x1aa6, 0x1bbe, 0x1800, 0x0c00, 0x0c00, 0x3f00, 0x6180 },	// U+132F (ጯ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x03c0, 0x0660, 0x0660, 0x03c0, 0x07e0, 0x0e70, 0x0c30, 0x0c30, 0x0c30, 0x0000, 0x0000 },	// U+1330 (ጰ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x00f0, 0x0198, 0x0198, 0x00f0, 0x01f8, 0x039c, 0x3f0c, 0x330c, 0x030c, 0x0000, 0x0000 },	// U+1331 (ጱ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x00f0, 0x0198, 0x0198, 0x00f0, 0x01f8, 0x039c, 0x030c, 0x330c, 0x3f0c, 0x0000, 0x0000 },	// U+1332 (ጲ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x03c0, 0x0660, 0x03c0, 0x07e0, 0x0e70, 0x0e30, 0x0c30, 0x0c00, 0x0c00, 0x0000, 0x0000 },	// U+1333 (ጳ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x00f0, 0x0198, 0x0198, 0x00f0, 0x01f8, 0x039c, 0x1f0c, 0x330c, 0x1f0c, 0x0000, 0x0000 },	// U+1334 (ጴ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x00f0, 0x1f98, 0x1998, 0x00f0, 0x01f8, 0x039c, 0x030c, 0x030c, 0x030c, 0x0000, 0x0000 },	// U+1335 (ጵ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x03c0, 0x0660, 0x03c0, 0x07e0, 0x0e70, 0x0c30, 0x0c30, 0x0030, 0x0030, 0x0000, 0x0000 },	// U+1336 (ጶ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x01e0, 0x0330, 0x01e0, 0x03f0, 0x0338, 0x0718, 0x0618, 0x0600, 0x0600, 0x1f80, 0x30c0 },	// U+1337 (ጷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x03c0, 0x0660, 0x0660, 0x03c0, 0x07e0, 0x0e70, 0x0c30, 0x0c30, 0x0c30, 0x0000, 0x0000 },	// U+1338 (ጸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x00f0, 0x0198, 0x0198, 0x00f0, 0x01f8, 0x039c, 0x3f0c, 0x330c, 0x030c, 0x0000, 0x0000 },	// U+1339 (ጹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x00f0, 0x0198, 0x0198, 0x00f0, 0x01f8, 0x039c, 0x030c, 0x330c, 0x3f0c, 0x0000, 0x0000 },	// U+133A (ጺ)
	{ 0x0000, 0x0000, 0x0000, 0x00c0, 0x01e0, 0x0330, 0x0330, 0x01e0, 0x03f0, 0x0338, 0x0718, 0x0618, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+133B (ጻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x00f0, 0x0198, 0x0198, 0x00f0, 0x01f8, 0x039c, 0x0f0c, 0x1b0c, 0x0f0c, 0x0000, 0x0000 },	// U+133C (ጼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x00f0, 0x1f98, 0x1998, 0x00f0, 0x01f8, 0x039c, 0x030c, 0x030c, 0x030c, 0x0000, 0x0000 },	// U+133D (ጽ)
	{ 0x0000, 0x0000, 0x0000, 0x00c0, 0x01e0, 0x0330, 0x0330, 0x01e0, 0x03f0, 0x0738, 0x0618, 0x0618, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+133E (ጾ)
	{ 0x0000, 0x0000, 0x0000, 0x00c0, 0x01e0, 0x0330, 0x0330, 0x01e0, 0x03f0, 0x0338, 0x0718, 0x0618, 0x0600, 0x0600, 0x1f80, 0x30c0 },	// U+133F (ጿ)
	{ 0x0000, 0x0000, 0x0000, 0x0780, 0x0c60, 0x0c30, 0x0c30, 0x0c30, 0x0ff0, 0x0c30, 0x0c30, 0x0c30, 0x0fe0, 0x0060, 0x0000, 0x0000 },	// U+1340 (ፀ)
	{ 0x0000, 0x0000, 0x0000, 0x01e0, 0x0318, 0x030c, 0x030c, 0x030c, 0x03fc, 0x3f0c, 0x330c, 0x030c, 0x03f8, 0x0018, 0x0000, 0x0000 },	// U+1341 (ፁ)
	{ 0x0000, 0x0000, 0x007e, 0x00c3, 0x00c3, 0x00ff, 0x00c3, 0x00c3, 0x00fe, 0x00c0, 0x00c0, 0x00c0, 0x0cc0, 0x0fc0, 0x0000, 0x0000 },	// U+1342 (ፂ)
}; // 579

static const uint16_t unifontdw_block68[][16] = {
	{ 0x0000, 0x0000, 0x007e, 0x00c3, 0x00c3, 0x00ff, 0x00c3, 0x00c3, 0x00fe, 0x00c0, 0x00c0, 0x07c0, 0x0cc0, 0x07c0, 0x0000, 0x0000 },	// U+1344 (ፄ)
	{ 0x0000, 0x0180, 0x0180, 0x0180, 0x07e0, 0x0c70, 0x0c30, 0x0c30, 0x0ff0, 0x0c30, 0x0c30, 0x0c30, 0x0fe0, 0x0060, 0x0000, 0x0000 },	// U+1345 (ፅ)
	{ 0x0000, 0x0000, 0x03c0, 0x0660, 0x0c30, 0x0ff0, 0x0c30, 0x0e70, 0x07e0, 0x03c0, 0x00e0, 0x0030, 0x0030, 0x0030, 0x0000, 0x0000 },	// U+1346 (ፆ)
	{ 0x0000, 0x0000, 0x0780, 0x0cc0, 0x186c, 0x1ffc, 0x186c, 0x1ce0, 0x0fc0, 0x0780, 0x01c0, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+1347 (ፇ)
	{ 0x0000, 0x0000, 0x0000, 0x0300, 0x0200, 0x0300, 0x0180, 0x00c0, 0x0060, 0x00f0, 0x0198, 0x1118, 0x1ff0, 0x17c0, 0x0000, 0x0000 },	// U+1348 (ፈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0180, 0x00c0, 0x0060, 0x0030, 0x00f8, 0x0898, 0x0f98, 0x03f8, 0x00c0, 0x0060, 0x0060 },	// U+1349 (ፉ)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0100, 0x0180, 0x00c0, 0x0060, 0x0030, 0x0c78, 0x08cc, 0x0c8c, 0x07f8, 0x01f0, 0x0000, 0x0000 },	// U+134A (ፊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x00c0, 0x0060, 0x0020, 0x0030, 0x0038, 0x006c, 0x04cc, 0x0ff8, 0x08c0, 0x00c0, 0x00c0 },	// U+134B (ፋ)
	{ 0x0000, 0x0000, 0x0180, 0x0100, 0x0180, 0x00c0, 0x0060, 0x0030, 0x0078, 0x00cc, 0x0c8c, 0x17f8, 0x13e0, 0x0e00, 0x0000, 0x0000 },	// U+134C (ፌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x0398, 0x0308, 0x000c, 0x000c, 0x007c, 0x03cc, 0x02ec, 0x00d8, 0x00c0, 0x00c0, 0x00c0 },	// U+134D (ፍ)
	{ 0x0000, 0x0000, 0x0000, 0x07e0, 0x09f0, 0x0f18, 0x000c, 0x000c, 0x000c, 0x003c, 0x005c, 0x0c8c, 0x06d8, 0x07f0, 0x0000, 0x0000 },	// U+134E (ፎ)
	{ 0x0000, 0x0000, 0x0000, 0x0040, 0x00c0, 0x0060, 0x0020, 0x0030, 0x0038, 0x006c, 0x04cc, 0x0ff8, 0x08c0, 0x00c0, 0x03f0, 0x0618 },	// U+134F (ፏ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1350 (ፐ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x0180, 0x1f80, 0x1980, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+1351 (ፑ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x1980, 0x1f80, 0x0000, 0x0000 },	// U+1352 (ፒ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x0180, 0x0180, 0x00c0, 0x0060, 0x0030, 0x0010, 0x0000, 0x0000 },	// U+1353 (ፓ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0f80, 0x1980, 0x0f80, 0x0000, 0x0000 },	// U+1354 (ፔ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0780, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+1355 (ፕ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x00c0, 0x00c0, 0x0060, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+1356 (ፖ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0ff0, 0x1c38 },	// U+1357 (ፗ)
	{ 0x0000, 0x1818, 0x0ff0, 0x0180, 0x0180, 0x0180, 0x00c0, 0x00e0, 0x0070, 0x0038, 0x0618, 0x0e18, 0x0c38, 0x07f0, 0x03e0, 0x0000 },	// U+1358 (ፘ)
	{ 0x3838, 0x0fe0, 0x0380, 0x3ff0, 0x3ff8, 0x228c, 0x2284, 0x2144, 0x3f7c, 0x3e38, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x0000 },	// U+1359 (ፙ)
	{ 0x0000, 0x1818, 0x0ff0, 0x0180, 0x0100, 0x0180, 0x00c0, 0x0060, 0x0030, 0x0c78, 0x08cc, 0x0c8c, 0x07f8, 0x01f0, 0x0000, 0x0000 },	// U+135A (ፚ)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x7186, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+135B (፛)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7d86, 0x7dbe, 0x6386, 0x7ffe, 0x0000 },	// U+135C (፜)
	{ 0x1998, 0x1998, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+135D (፝)
	{ 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+135E (፞)
	{ 0x0c30, 0x0c30, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+135F (፟)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0990, 0x0420, 0x0240, 0x1998, 0x1998, 0x0240, 0x0420, 0x0990, 0x0180, 0x0000, 0x0000, 0x0000 },	// U+1360 (፠)
}; // 29

static const uint16_t unifontdw_block69[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0660, 0x0660, 0x0000, 0x0000, 0x0660, 0x0660, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1362 (።)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0000, 0x0180, 0x0180, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1363 (፣)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0000, 0x0180, 0x0180, 0x0000, 0x0180, 0x0180, 0x0000, 0x07e0, 0x0000, 0x0000, 0x0000 },	// U+1364 (፤)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0060, 0x0000, 0x01f8, 0x0000, 0x0060, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1365 (፥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0060, 0x0000, 0x03c0, 0x0000, 0x0060, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1366 (፦)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000 },	// U+1367 (፧)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0c30, 0x0c30, 0x0180, 0x0180, 0x0c30, 0x0c30, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000 },	// U+1368 (፨)
	{ 0x0000, 0x0000, 0x0c18, 0x07f0, 0x0000, 0x0180, 0x0180, 0x00c0, 0x03e0, 0x0630, 0x0630, 0x03e0, 0x0000, 0x07f0, 0x0c18, 0x0000 },	// U+1369 (፩)
	{ 0x0000, 0x0000, 0x1830, 0x0fe0, 0x0000, 0x0380, 0x06c0, 0x0660, 0x03e0, 0x0060, 0x03e0, 0x06c0, 0x0380, 0x0fe0, 0x1830, 0x0000 },	// U+136A (፪)
	{ 0x0000, 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0000, 0x07e0, 0x0660, 0x0060, 0x0060, 0x0060, 0x0060, 0x0000, 0x07e0, 0x0c30, 0x0000 },	// U+136B (፫)
	{ 0x0000, 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0000, 0x03c0, 0x0660, 0x0660, 0x0660, 0x0660, 0x03c0, 0x0000, 0x07e0, 0x0c30, 0x0000 },	// U+136C (፬)
	{ 0x0000, 0x0000, 0x0c18, 0x07f0, 0x0000, 0x00c0, 0x00c0, 0x07e0, 0x0670, 0x0030, 0x0630, 0x07e0, 0x0000, 0x07f0, 0x0c18, 0x0000 },	// U+136D (፭)
	{ 0x0000, 0x0c18, 0x07f0, 0x0000, 0x01e0, 0x03f0, 0x0330, 0x0300, 0x0180, 0x0380, 0x06c0, 0x03c0, 0x0000, 0x07f0, 0x0c18, 0x0000 },	// U+136E (፮)
	{ 0x0000, 0x0c18, 0x07f0, 0x0000, 0x01e0, 0x03f0, 0x0330, 0x0300, 0x0180, 0x0080, 0x04c0, 0x07c0, 0x0000, 0x07f0, 0x0c18, 0x0000 },	// U+136F (፯)
	{ 0x0000, 0x0000, 0x1818, 0x0ff0, 0x0000, 0x0ff0, 0x0db0, 0x0180, 0x0180, 0x0180, 0x0ff0, 0x0c30, 0x0000, 0x0ff0, 0x1818, 0x0000 },	// U+1370 (፰)
	{ 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0000, 0x0000, 0x0660, 0x0660, 0x07e0, 0x0660, 0x0260, 0x01c0, 0x0000, 0x07e0, 0x0c30, 0x0000 },	// U+1371 (፱)
	{ 0x0000, 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0000, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x07e0, 0x0c30, 0x0000 },	// U+1372 (፲)
	{ 0x0000, 0x0000, 0x0000, 0x1818, 0x0ff0, 0x0000, 0x07e0, 0x05a0, 0x0180, 0x03c0, 0x0660, 0x0660, 0x0000, 0x0ff0, 0x1818, 0x0000 },	// U+1373 (፳)
	{ 0x0000, 0x0000, 0x0000, 0x1818, 0x0ff0, 0x0000, 0x07a0, 0x0db0, 0x0db0, 0x0db0, 0x0db0, 0x0ce0, 0x0000, 0x0ff0, 0x1818, 0x0000 },	// U+1374 (፴)
	{ 0x0000, 0x0000, 0x1818, 0x0ff0, 0x0000, 0x0db0, 0x0db0, 0x0db0, 0x0fe0, 0x0c00, 0x0c00, 0x0c00, 0x0000, 0x0ff0, 0x1818, 0x0000 },	// U+1375 (፵)
	{ 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0000, 0x07c0, 0x0660, 0x07c0, 0x0600, 0x0300, 0x0300, 0x0300, 0x0000, 0x07e0, 0x0c30, 0x0000 },	// U+1376 (፶)
	{ 0x0000, 0x0000, 0x1818, 0x0ff0, 0x0000, 0x0ff0, 0x0db0, 0x0180, 0x0380, 0x0300, 0x0ff0, 0x0c30, 0x0000, 0x0ff0, 0x1818, 0x0000 },	// U+1377 (፷)
	{ 0x0000, 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0000, 0x07c0, 0x0d60, 0x0760, 0x0060, 0x0660, 0x07c0, 0x0000, 0x07e0, 0x0c30, 0x0000 },	// U+1378 (፸)
	{ 0x0000, 0x0000, 0x0000, 0x180c, 0x0ff8, 0x0000, 0x0ff8, 0x0b68, 0x0360, 0x0360, 0x0360, 0x0360, 0x0000, 0x0ff8, 0x180c, 0x0000 },	// U+1379 (፹)
	{ 0x0000, 0x0c18, 0x07f0, 0x0000, 0x03e0, 0x0360, 0x0180, 0x0380, 0x0300, 0x0180, 0x0180, 0x0180, 0x0000, 0x07f0, 0x0c18, 0x0000 },	// U+137A (፺)
	{ 0x0000, 0x0000, 0x0c30, 0x07e0, 0x0000, 0x03c0, 0x0660, 0x03e0, 0x0060, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x07e0, 0x0c30, 0x0000 },	// U+137B (፻)
	{ 0x0000, 0x0000, 0x300c, 0x1ff8, 0x0000, 0x1e78, 0x33cc, 0x1f7c, 0x030c, 0x0618, 0x0618, 0x0618, 0x0000, 0x1ff8, 0x300c, 0x0000 },	// U+137C (፼)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+137D (፽)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+137E (፾)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+137F (፿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ffc, 0x0ffe, 0x0922, 0xf9a3, 0xa8b1, 0xec99, 0x078f, 0x038f, 0x0000, 0x0000, 0x0000 },	// U+1380 (ᎀ)
	{ 0x0000, 0x0000, 0x07fc, 0x07fe, 0x34a3, 0x3ca1, 0xf451, 0xc7df, 0x078e, 0x0200, 0x0200, 0x0100, 0x1900, 0x1f00, 0x0000, 0x0000 },	// U+1381 (ᎁ)
	{ 0x0000, 0x0000, 0x1ff8, 0x1ffc, 0x1146, 0x1142, 0x10a2, 0x1fbe, 0x1f1c, 0x0800, 0x0800, 0x3c00, 0x2400, 0x3fc0, 0x00c0, 0x0000 },	// U+1382 (ᎂ)
	{ 0x0000, 0x0000, 0x07fc, 0x07fe, 0x7ca3, 0x54a1, 0x7451, 0x07df, 0x078e, 0x0008, 0x0008, 0x000c, 0x0004, 0x0004, 0x0000, 0x0000 },	// U+1383 (ᎃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x00f8, 0x018c, 0x018c, 0x1f8c, 0x158c, 0x1d8c, 0x018c, 0x018c, 0x018c, 0x0000, 0x0000 },	// U+1384 (ᎄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x00f8, 0x0d8c, 0x0d8c, 0x3f8c, 0x318c, 0x018c, 0x018c, 0x018c, 0x018c, 0x0000, 0x0000 },	// U+1385 (ᎅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x00f8, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x078c, 0x058c, 0x078c, 0x0060, 0x0060 },	// U+1386 (ᎆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x03e0, 0x0630, 0x0630, 0x7e3e, 0x5636, 0x7630, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+1387 (ᎇ)
	{ 0x0000, 0x0000, 0x0000, 0x0300, 0x0200, 0x3f00, 0x2980, 0x38c0, 0x0060, 0x00f0, 0x0d98, 0x0f18, 0x0cf0, 0x0000, 0x0000, 0x0000 },	// U+1388 (ᎈ)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0d00, 0x0f80, 0x3cc0, 0x3060, 0x0030, 0x0078, 0x06cc, 0x078c, 0x0678, 0x0000, 0x0000, 0x0000 },	// U+1389 (ᎉ)
	{ 0x0000, 0x0000, 0x0000, 0x00c0, 0x0080, 0x00c0, 0x0060, 0x0030, 0x0078, 0x1f88, 0x15c8, 0x1cf0, 0x0060, 0x0030, 0x0010, 0x0030 },	// U+138A (ᎊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x0398, 0x0308, 0x000c, 0x0fec, 0x0acc, 0x0ecc, 0x00cc, 0x07f8, 0x06c0, 0x00c0, 0x00c0 },	// U+138B (ᎋ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x1f80, 0x3580, 0x1d80, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+138C (ᎌ)
	{ 0x0000, 0x0000, 0x0618, 0x07f8, 0x0ffc, 0x0ccc, 0x00c0, 0x00c0, 0x06c0, 0x07c0, 0x18c0, 0x18c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+138D (ᎍ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0f80, 0x1980, 0x0ff0, 0x0030, 0x0030 },	// U+138E (ᎎ)
	{ 0x0000, 0x0000, 0x0618, 0x07f8, 0x0ffc, 0x0ccc, 0x00c0, 0x00c0, 0x1f80, 0x3580, 0x1d80, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+138F (ᎏ)
}; // 46

static const uint16_t unifontdw_block70[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x1800, 0x1800, 0x1c00, 0x0fe0, 0x001e, 0x0000, 0x0000 },	// U+1395 (᎕)
}; // 1

static const uint16_t unifontdw_block71[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x0000, 0x0000 },	// U+1397 (᎗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0012, 0x7ffe, 0x0000, 0x0000 },	// U+1398 (᎘)
}; // 2

static const uint16_t unifontdw_block72[][16] = {
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x61ce, 0x6db6, 0x618e, 0x6dbe, 0x6dce, 0x7ffe, 0x0000 },	// U+139A (᎚)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x718e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+139B (᎛)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7d8e, 0x7dbe, 0x63ce, 0x7ffe, 0x0000 },	// U+139C (᎜)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6d8e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+139D (᎝)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x61ce, 0x7ffe, 0x0000 },	// U+139E (᎞)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x7dce, 0x7ffe, 0x0000 },	// U+139F (᎟)
}; // 6

static const uint16_t unifontdw_block73[][16] = {
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+13F6 (᏶)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+13F7 (᏷)
}; // 2

static const uint16_t unifontdw_block74[][16] = {
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+13FE (᏾)
	{ 0x0000, 0x7ffe, 0x71de, 0x6fce, 0x63de, 0x6fde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+13FF (᏿)
}; // 2

static const uint16_t unifontdw_block75[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x4002, 0x2004, 0x1008, 0x0810, 0x0420, 0x0240, 0x0180, 0x0000, 0x0000 },	// U+1401 (ᐁ)
	{ 0x0000, 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x2004, 0x4002, 0x7ffe, 0x0000, 0x0000 },	// U+1402 (ᐂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x2004, 0x4002, 0x7ffe, 0x0000, 0x0000 },	// U+1403 (ᐃ)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x2004, 0x4002, 0x7ffe, 0x0000, 0x0000 },	// U+1404 (ᐄ)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x0050, 0x0090, 0x0110, 0x0210, 0x0410, 0x0410, 0x0210, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000 },	// U+1405 (ᐅ)
	{ 0x0030, 0x0030, 0x0000, 0x0030, 0x0050, 0x0090, 0x0110, 0x0210, 0x0410, 0x0410, 0x0210, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000 },	// U+1406 (ᐆ)
	{ 0x0330, 0x0330, 0x0000, 0x0030, 0x0050, 0x0090, 0x0110, 0x0210, 0x0410, 0x0410, 0x0210, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000 },	// U+1407 (ᐇ)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x0050, 0x0090, 0x0110, 0x0250, 0x0450, 0x0450, 0x0250, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000 },	// U+1408 (ᐈ)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x0050, 0x0090, 0x0110, 0x0210, 0x04d0, 0x04d0, 0x0210, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000 },	// U+1409 (ᐉ)
	{ 0x0000, 0x0000, 0x0000, 0x0600, 0x0500, 0x0480, 0x0440, 0x0420, 0x0410, 0x0410, 0x0420, 0x0440, 0x0480, 0x0500, 0x0600, 0x0000 },	// U+140A (ᐊ)
	{ 0x0600, 0x0600, 0x0000, 0x0600, 0x0500, 0x0480, 0x0440, 0x0420, 0x0410, 0x0410, 0x0420, 0x0440, 0x0480, 0x0500, 0x0600, 0x0000 },	// U+140B (ᐋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x4002, 0x2004, 0x1008, 0x0810, 0x0426, 0x0246, 0x0180, 0x0000, 0x0000 },	// U+140C (ᐌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x4002, 0x2004, 0x1008, 0x0810, 0x6420, 0x6240, 0x0180, 0x0000, 0x0000 },	// U+140D (ᐍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0246, 0x0426, 0x0810, 0x1008, 0x2004, 0x4002, 0x7ffe, 0x0000, 0x0000 },	// U+140E (ᐎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x6240, 0x6420, 0x0810, 0x1008, 0x2004, 0x4002, 0x7ffe, 0x0000, 0x0000 },	// U+140F (ᐏ)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0180, 0x0246, 0x0426, 0x0810, 0x1008, 0x2004, 0x4002, 0x7ffe, 0x0000, 0x0000 },	// U+1410 (ᐐ)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0180, 0x6240, 0x6420, 0x0810, 0x1008, 0x2004, 0x4002, 0x7ffe, 0x0000, 0x0000 },	// U+1411 (ᐑ)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x0050, 0x0090, 0x0110, 0x0210, 0x0416, 0x0416, 0x0210, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000 },	// U+1412 (ᐒ)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x0050, 0x0090, 0x0110, 0x0210, 0x3410, 0x3410, 0x0210, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000 },	// U+1413 (ᐓ)
	{ 0x0030, 0x0030, 0x0000, 0x0030, 0x0050, 0x0090, 0x0110, 0x0210, 0x0416, 0x0416, 0x0210, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000 },	// U+1414 (ᐔ)
	{ 0x0030, 0x0030, 0x0000, 0x0030, 0x0050, 0x0090, 0x0110, 0x0210, 0x3410, 0x3410, 0x0210, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000 },	// U+1415 (ᐕ)
	{ 0x0000, 0x0180, 0x0180, 0x0030, 0x0c50, 0x0c90, 0x0110, 0x0210, 0x0410, 0x0410, 0x0210, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000 },	// U+1416 (ᐖ)
	{ 0x0000, 0x0000, 0x0000, 0x0600, 0x0500, 0x0480, 0x0440, 0x0420, 0x0416, 0x0416, 0x0420, 0x0440, 0x0480, 0x0500, 0x0600, 0x0000 },	// U+1417 (ᐗ)
	{ 0x0000, 0x0000, 0x0000, 0x0600, 0x0500, 0x0480, 0x0440, 0x0420, 0x3410, 0x3410, 0x0420, 0x0440, 0x0480, 0x0500, 0x0600, 0x0000 },	// U+1418 (ᐘ)
	{ 0x0600, 0x0600, 0x0000, 0x0600, 0x0500, 0x0480, 0x0440, 0x0420, 0x0416, 0x0416, 0x0420, 0x0440, 0x0480, 0x0500, 0x0600, 0x0000 },	// U+1419 (ᐙ)
	{ 0x0600, 0x0600, 0x0000, 0x0600, 0x0500, 0x0480, 0x0440, 0x0420, 0x3410, 0x3410, 0x0420, 0x0440, 0x0480, 0x0500, 0x0600, 0x0000 },	// U+141A (ᐚ)
	{ 0x0000, 0x00c0, 0x00c0, 0x0600, 0x0518, 0x0498, 0x0440, 0x0420, 0x0410, 0x0410, 0x0420, 0x0440, 0x0480, 0x0500, 0x0600, 0x0000 },	// U+141B (ᐛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0888, 0x0888, 0x0888, 0x0888, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+141C (ᐜ)
	{ 0x0000, 0x0c00, 0x1200, 0x1200, 0x0c00, 0x0060, 0x0090, 0x0090, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+141D (ᐝ)
}; // 29

static const uint16_t unifontdw_block76[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x2000, 0x2fff, 0x4801, 0x4402, 0x0204, 0x0108, 0x0090, 0x0060, 0x0000, 0x0000 },	// U+142B (ᐫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x10c0, 0x2120, 0x2210, 0x0408, 0x0804, 0x1002, 0x1ffe, 0x0000, 0x0000 },	// U+142C (ᐬ)
	{ 0x0000, 0x0000, 0x0000, 0x0418, 0x0428, 0x0848, 0x0888, 0x1108, 0x1208, 0x0208, 0x0108, 0x0088, 0x0048, 0x0028, 0x0018, 0x0000 },	// U+142D (ᐭ)
	{ 0x0000, 0x0000, 0x0000, 0x0580, 0x0540, 0x0920, 0x0910, 0x1108, 0x1104, 0x0104, 0x0108, 0x0110, 0x0120, 0x0140, 0x0180, 0x0000 },	// U+142E (ᐮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x2004, 0x1008, 0x0810, 0x0420, 0x0240, 0x0180, 0x0000, 0x0000 },	// U+142F (ᐯ)
	{ 0x0000, 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x2004, 0x4002, 0x0000, 0x0000, 0x0000 },	// U+1430 (ᐰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x2004, 0x4002, 0x0000, 0x0000, 0x0000 },	// U+1431 (ᐱ)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x2004, 0x4002, 0x0000, 0x0000, 0x0000 },	// U+1432 (ᐲ)
}; // 8

static const uint16_t unifontdw_block77[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x2004, 0x1008, 0x0810, 0x0426, 0x0246, 0x0180, 0x0000, 0x0000 },	// U+143A (ᐺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x2004, 0x1008, 0x0810, 0x6420, 0x6240, 0x0180, 0x0000, 0x0000 },	// U+143B (ᐻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0246, 0x0426, 0x0810, 0x1008, 0x2004, 0x4002, 0x0000, 0x0000 },	// U+143C (ᐼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x6240, 0x6420, 0x0810, 0x1008, 0x2004, 0x4002, 0x0000, 0x0000 },	// U+143D (ᐽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0180, 0x0246, 0x0426, 0x0810, 0x1008, 0x2004, 0x4002, 0x0000, 0x0000 },	// U+143E (ᐾ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0180, 0x6240, 0x6420, 0x0810, 0x1008, 0x2004, 0x4002, 0x0000, 0x0000 },	// U+143F (ᐿ)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800, 0x1030, 0x1030, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0000 },	// U+1440 (ᑀ)
	{ 0x0000, 0x0000, 0x0000, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x3400, 0x3400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+1441 (ᑁ)
	{ 0x0180, 0x0180, 0x0000, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800, 0x1030, 0x1030, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0000 },	// U+1442 (ᑂ)
	{ 0x0060, 0x0060, 0x0000, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x3400, 0x3400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+1443 (ᑃ)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0058, 0x0058, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800, 0x0000 },	// U+1444 (ᑄ)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x3020, 0x3020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0000 },	// U+1445 (ᑅ)
	{ 0x0c00, 0x0c00, 0x0000, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0058, 0x0058, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800, 0x0000 },	// U+1446 (ᑆ)
	{ 0x0600, 0x0600, 0x0000, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x3020, 0x3020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0000 },	// U+1447 (ᑇ)
	{ 0x0000, 0x0180, 0x0180, 0x0400, 0x0230, 0x0130, 0x0080, 0x0040, 0x0020, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0000 },	// U+1448 (ᑈ)
}; // 15

static const uint16_t unifontdw_block78[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+144C (ᑌ)
	{ 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x0000, 0x0000 },	// U+144D (ᑍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x0000, 0x0000 },	// U+144E (ᑎ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x0000, 0x0000 },	// U+144F (ᑏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+1450 (ᑐ)
	{ 0x0000, 0x00c0, 0x00c0, 0x0000, 0x07f0, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+1451 (ᑑ)
	{ 0x0000, 0x0330, 0x0330, 0x0000, 0x07f0, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+1452 (ᑒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0800, 0x1000, 0x1100, 0x1100, 0x1100, 0x1100, 0x1000, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+1453 (ᑓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0800, 0x1000, 0x1000, 0x1180, 0x1180, 0x1000, 0x1000, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+1454 (ᑔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1fc0, 0x0020, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0020, 0x1fc0, 0x0000, 0x0000 },	// U+1455 (ᑕ)
	{ 0x0000, 0x0600, 0x0600, 0x0000, 0x1fc0, 0x0020, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0020, 0x1fc0, 0x0000, 0x0000 },	// U+1456 (ᑖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2010, 0x2010, 0x2010, 0x2016, 0x2016, 0x2010, 0x2010, 0x1020, 0x0fc0, 0x0000, 0x0000 },	// U+1457 (ᑗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0402, 0x0402, 0x0402, 0x3402, 0x3402, 0x0402, 0x0402, 0x0204, 0x01f8, 0x0000, 0x0000 },	// U+1458 (ᑘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fc0, 0x1020, 0x2010, 0x2010, 0x2016, 0x2016, 0x2010, 0x2010, 0x2010, 0x0000, 0x0000 },	// U+1459 (ᑙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x0204, 0x0402, 0x0402, 0x3402, 0x3402, 0x0402, 0x0402, 0x0402, 0x0000, 0x0000 },	// U+145A (ᑚ)
	{ 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0fc0, 0x1020, 0x2010, 0x2010, 0x2016, 0x2016, 0x2010, 0x2010, 0x2010, 0x0000, 0x0000 },	// U+145B (ᑛ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0000, 0x01f8, 0x0204, 0x0402, 0x0402, 0x3402, 0x3402, 0x0402, 0x0402, 0x0402, 0x0000, 0x0000 },	// U+145C (ᑜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x1000, 0x2000, 0x2000, 0x2006, 0x2006, 0x2000, 0x2000, 0x1000, 0x0fe0, 0x0000 },	// U+145D (ᑝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01fc, 0x0200, 0x0400, 0x0400, 0x3400, 0x3400, 0x0400, 0x0400, 0x0200, 0x01fc, 0x0000 },	// U+145E (ᑞ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0fe0, 0x1000, 0x2000, 0x2000, 0x200c, 0x200c, 0x2000, 0x2000, 0x1000, 0x0fe0, 0x0000 },	// U+145F (ᑟ)
	{ 0x0000, 0x0000, 0x0030, 0x0030, 0x0000, 0x01fc, 0x0200, 0x0400, 0x0400, 0x3400, 0x3400, 0x0400, 0x0400, 0x0200, 0x01fc, 0x0000 },	// U+1460 (ᑠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3f80, 0x0040, 0x0020, 0x0020, 0x002c, 0x002c, 0x0020, 0x0020, 0x0040, 0x3f80, 0x0000 },	// U+1461 (ᑡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0008, 0x0004, 0x0004, 0x1804, 0x1804, 0x0004, 0x0004, 0x0008, 0x07f0, 0x0000 },	// U+1462 (ᑢ)
	{ 0x0000, 0x0000, 0x0600, 0x0600, 0x0000, 0x1fc0, 0x0020, 0x0010, 0x0010, 0x0016, 0x0016, 0x0010, 0x0010, 0x0020, 0x1fc0, 0x0000 },	// U+1463 (ᑣ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x03f8, 0x0004, 0x0002, 0x0002, 0x1802, 0x1802, 0x0002, 0x0002, 0x0004, 0x03f8, 0x0000 },	// U+1464 (ᑤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fc0, 0x0020, 0x0016, 0x0016, 0x0010, 0x0010, 0x0016, 0x0016, 0x0020, 0x1fc0, 0x0000 },	// U+1465 (ᑥ)
}; // 26

static const uint16_t unifontdw_block79[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2010, 0x2010, 0x2014, 0x2014, 0x2014, 0x2014, 0x2010, 0x1020, 0x0fc0, 0x0000, 0x0000 },	// U+1467 (ᑧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x0204, 0x1402, 0x1402, 0x1402, 0x1402, 0x0402, 0x0402, 0x0402, 0x0000, 0x0000 },	// U+1468 (ᑨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01fc, 0x0200, 0x0400, 0x1400, 0x1400, 0x1400, 0x1400, 0x0400, 0x0200, 0x01fc, 0x0000, 0x0000 },	// U+1469 (ᑩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0008, 0x0004, 0x1004, 0x1004, 0x1004, 0x1004, 0x0004, 0x0008, 0x07f0, 0x0000, 0x0000 },	// U+146A (ᑪ)
}; // 4

static const uint16_t unifontdw_block80[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0880, 0x0880, 0x0880, 0x0700, 0x0000, 0x0000 },	// U+14C0 (ᓀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x0120, 0x0120, 0x00c0, 0x0000, 0x0ff0, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+14C1 (ᓁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+14C2 (ᓂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x0ff0, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+14C3 (ᓃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0880, 0x0880, 0x0880, 0x07f8, 0x0000, 0x0000 },	// U+14C4 (ᓄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0700, 0x0880, 0x0880, 0x0880, 0x07f8, 0x0000, 0x0000 },	// U+14C5 (ᓅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0660, 0x0660, 0x0000, 0x0700, 0x0880, 0x0880, 0x0880, 0x07f8, 0x0000, 0x0000 },	// U+14C6 (ᓆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0088, 0x0088, 0x0088, 0x0ff0, 0x0000, 0x0000 },	// U+14C7 (ᓇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x00e0, 0x0110, 0x0110, 0x0110, 0x1fe0, 0x0000, 0x0000 },	// U+14C8 (ᓈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fe0, 0x220c, 0x220c, 0x2200, 0x1c00, 0x0000, 0x0000 },	// U+14C9 (ᓉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03fc, 0x3440, 0x3440, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+14CA (ᓊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x022c, 0x022c, 0x3fc0, 0x0000, 0x0000 },	// U+14CB (ᓋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c70, 0x0c88, 0x0088, 0x0088, 0x0ff0, 0x0000, 0x0000 },	// U+14CC (ᓌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x01c0, 0x0220, 0x022c, 0x022c, 0x3fc0, 0x0000, 0x0000 },	// U+14CD (ᓍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0030, 0x0000, 0x0c70, 0x0c88, 0x0088, 0x0088, 0x0ff0, 0x0000, 0x0000 },	// U+14CE (ᓎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0198, 0x0198, 0x0000, 0x0070, 0x0088, 0x0088, 0x0088, 0x0ff0, 0x0000, 0x0000 },	// U+14CF (ᓏ)
}; // 16

static const uint16_t unifontdw_block81[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0800, 0x0800, 0x0800, 0x0700, 0x0000, 0x0000 },	// U+14D3 (ᓓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0090, 0x0060, 0x0000, 0x0ff0, 0x0008, 0x0008, 0x0008, 0x0070, 0x0000, 0x0000 },	// U+14D4 (ᓔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0008, 0x0008, 0x0008, 0x0070, 0x0000, 0x0000 },	// U+14D5 (ᓕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0060, 0x0000, 0x0ff0, 0x0008, 0x0008, 0x0008, 0x0070, 0x0000, 0x0000 },	// U+14D6 (ᓖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0800, 0x0800, 0x0800, 0x07f8, 0x0000, 0x0000 },	// U+14D7 (ᓗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0700, 0x0800, 0x0800, 0x0800, 0x07f8, 0x0000, 0x0000 },	// U+14D8 (ᓘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cc0, 0x0cc0, 0x0000, 0x0700, 0x0800, 0x0800, 0x0800, 0x07f8, 0x0000, 0x0000 },	// U+14D9 (ᓙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0008, 0x0008, 0x0008, 0x0ff0, 0x0000, 0x0000 },	// U+14DA (ᓚ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x00e0, 0x0010, 0x0010, 0x0010, 0x1fe0, 0x0000, 0x0000 },	// U+14DB (ᓛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fe0, 0x200c, 0x200c, 0x2000, 0x1c00, 0x0000, 0x0000 },	// U+14DC (ᓜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03fc, 0x3400, 0x3400, 0x0400, 0x0380, 0x0000, 0x0000 },	// U+14DD (ᓝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fc0, 0x002c, 0x002c, 0x0020, 0x01c0, 0x0000, 0x0000 },	// U+14DE (ᓞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x3004, 0x3004, 0x0004, 0x0038, 0x0000, 0x0000 },	// U+14DF (ᓟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x3fc0, 0x002c, 0x002c, 0x0020, 0x01c0, 0x0000, 0x0000 },	// U+14E0 (ᓠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0030, 0x0000, 0x07f8, 0x3004, 0x3004, 0x0004, 0x0038, 0x0000, 0x0000 },	// U+14E1 (ᓡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0718, 0x0818, 0x0800, 0x0800, 0x07f8, 0x0000, 0x0000 },	// U+14E2 (ᓢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x3400, 0x3400, 0x0400, 0x03fc, 0x0000, 0x0000 },	// U+14E3 (ᓣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0600, 0x0000, 0x0718, 0x0818, 0x0800, 0x0800, 0x07f8, 0x0000, 0x0000 },	// U+14E4 (ᓤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0380, 0x3400, 0x3400, 0x0400, 0x03fc, 0x0000, 0x0000 },	// U+14E5 (ᓥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x002c, 0x002c, 0x0020, 0x3fc0, 0x0000, 0x0000 },	// U+14E6 (ᓦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18e0, 0x1810, 0x0010, 0x0010, 0x1fe0, 0x0000, 0x0000 },	// U+14E7 (ᓧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x01c0, 0x002c, 0x002c, 0x0020, 0x3fc0, 0x0000, 0x0000 },	// U+14E8 (ᓨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0030, 0x0000, 0x0c70, 0x0c08, 0x0008, 0x0008, 0x0ff0, 0x0000, 0x0000 },	// U+14E9 (ᓩ)
}; // 23

static const uint16_t unifontdw_block82[][16] = {
	{ 0x0000, 0x0018, 0x0018, 0x2000, 0x1008, 0x0808, 0x0418, 0x0220, 0x0120, 0x0120, 0x0200, 0x0430, 0x0830, 0x1000, 0x2000, 0x0000 },	// U+150C (ᔌ)
	{ 0x0000, 0x0006, 0x0006, 0x0000, 0x7f02, 0x0082, 0x0046, 0x0048, 0x0048, 0x0048, 0x0040, 0x004c, 0x008c, 0x7f00, 0x0000, 0x0000 },	// U+150D (ᔍ)
	{ 0x0000, 0x0000, 0x0018, 0x0018, 0x0000, 0x0108, 0x0108, 0x0118, 0x0120, 0x0f20, 0x1120, 0x1100, 0x1130, 0x0e30, 0x0000, 0x0000 },	// U+150E (ᔎ)
	{ 0x0000, 0x0000, 0x0018, 0x0018, 0x0000, 0x0108, 0x0108, 0x0118, 0x0120, 0x0120, 0x1120, 0x1100, 0x1130, 0x0e30, 0x0000, 0x0000 },	// U+150F (ᔏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0088, 0x0088, 0x0088, 0x0080, 0x0880, 0x0880, 0x0880, 0x0700, 0x0000, 0x0000 },	// U+1510 (ᔐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0880, 0x0880, 0x0880, 0x0080, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+1511 (ᔑ)
	{ 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0700, 0x0880, 0x0880, 0x0880, 0x0080, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+1512 (ᔒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0848, 0x0888, 0x0908, 0x0630, 0x0000, 0x0000 },	// U+1513 (ᔓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0630, 0x0848, 0x0888, 0x0908, 0x0630, 0x0000, 0x0000 },	// U+1514 (ᔔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0908, 0x0888, 0x0848, 0x0630, 0x0000, 0x0000 },	// U+1515 (ᔕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0630, 0x0908, 0x0888, 0x0848, 0x0630, 0x0000, 0x0000 },	// U+1516 (ᔖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0110, 0x0110, 0x0110, 0x0100, 0x110c, 0x110c, 0x1100, 0x0e00, 0x0000, 0x0000 },	// U+1517 (ᔗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0038, 0x0044, 0x1844, 0x1844, 0x0040, 0x0440, 0x0440, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+1518 (ᔘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e00, 0x1100, 0x110c, 0x110c, 0x0100, 0x0110, 0x0110, 0x0110, 0x00e0, 0x0000, 0x0000 },	// U+1519 (ᔙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0440, 0x0440, 0x0040, 0x1844, 0x1844, 0x0044, 0x0038, 0x0000, 0x0000 },	// U+151A (ᔚ)
	{ 0x0000, 0x0000, 0x0600, 0x0600, 0x0000, 0x0e00, 0x1100, 0x110c, 0x110c, 0x0100, 0x0110, 0x0110, 0x0110, 0x00e0, 0x0000, 0x0000 },	// U+151B (ᔛ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0380, 0x0440, 0x0440, 0x0440, 0x0040, 0x1844, 0x1844, 0x0044, 0x0038, 0x0000, 0x0000 },	// U+151C (ᔜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18cc, 0x212c, 0x2220, 0x2420, 0x18c0, 0x0000, 0x0000 },	// U+151D (ᔝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3318, 0x3424, 0x0444, 0x0484, 0x0318, 0x0000, 0x0000 },	// U+151E (ᔞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0000, 0x18cc, 0x212c, 0x2220, 0x2420, 0x18c0, 0x0000, 0x0000 },	// U+151F (ᔟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x0000, 0x3318, 0x3424, 0x0444, 0x0484, 0x0318, 0x0000, 0x0000 },	// U+1520 (ᔠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18cc, 0x212c, 0x2220, 0x2420, 0x18c0, 0x0000, 0x0000 },	// U+1521 (ᔡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3318, 0x3484, 0x0444, 0x0424, 0x0318, 0x0000, 0x0000 },	// U+1522 (ᔢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0000, 0x18cc, 0x242c, 0x2220, 0x2120, 0x18c0, 0x0000, 0x0000 },	// U+1523 (ᔣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x0000, 0x6630, 0x6908, 0x0888, 0x0848, 0x0630, 0x0000, 0x0000 },	// U+1524 (ᔤ)
}; // 25

static const uint16_t unifontdw_block83[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f08, 0x0108, 0x0108, 0x0108, 0x0108, 0x00f0, 0x0000, 0x0000 },	// U+1542 (ᕂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0878, 0x0840, 0x0840, 0x0840, 0x0840, 0x0780, 0x0000, 0x0000 },	// U+1543 (ᕃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x0840, 0x0840, 0x0840, 0x0878, 0x0000, 0x0000 },	// U+1544 (ᕄ)
	{ 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0090, 0x0060, 0x0000, 0x00f0, 0x0108, 0x0108, 0x0108, 0x0108, 0x0f08, 0x0000, 0x0000 },	// U+1545 (ᕅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x0108, 0x0108, 0x0108, 0x0108, 0x0f08, 0x0000, 0x0000 },	// U+1546 (ᕆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0060, 0x0000, 0x00f0, 0x0108, 0x0108, 0x0108, 0x0108, 0x0f08, 0x0000, 0x0000 },	// U+1547 (ᕇ)
}; // 6

static const uint16_t unifontdw_block84[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x4024, 0x2024, 0x1018, 0x0810, 0x0420, 0x0240, 0x0180, 0x0000, 0x0000 },	// U+1553 (ᕓ)
	{ 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1018, 0x2024, 0x4024, 0x0018, 0x0000 },	// U+1554 (ᕔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1018, 0x2024, 0x4024, 0x0018, 0x0000 },	// U+1555 (ᕕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1018, 0x2024, 0x4024, 0x0018, 0x0000 },	// U+1556 (ᕖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0190, 0x0260, 0x0400, 0x0800, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040 },	// U+1557 (ᕗ)
	{ 0x0000, 0x0060, 0x0060, 0x0000, 0x0060, 0x0090, 0x0190, 0x0260, 0x0400, 0x0800, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040 },	// U+1558 (ᕘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0900, 0x0980, 0x0640, 0x0020, 0x0010, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200 },	// U+1559 (ᕙ)
	{ 0x0000, 0x0600, 0x0600, 0x0000, 0x0600, 0x0900, 0x0980, 0x0640, 0x0020, 0x0010, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200 },	// U+155A (ᕚ)
	{ 0x0000, 0x1800, 0x1800, 0x0000, 0x1800, 0x2400, 0x2600, 0x1900, 0x0080, 0x004c, 0x004c, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800 },	// U+155B (ᕛ)
	{ 0x0000, 0x0180, 0x0180, 0x0000, 0x0180, 0x0240, 0x0260, 0x0190, 0x0008, 0x1804, 0x1804, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080 },	// U+155C (ᕜ)
}; // 10

static const uint16_t unifontdw_block85[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1030, 0x1048, 0x1048, 0x1038, 0x1008, 0x1008, 0x1008, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+155E (ᕞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c08, 0x1208, 0x1208, 0x1c08, 0x1008, 0x1008, 0x1008, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+155F (ᕟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x1038, 0x1048, 0x1048, 0x1030, 0x0000, 0x0000 },	// U+1560 (ᕠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x1c08, 0x1208, 0x1208, 0x0c08, 0x0000, 0x0000 },	// U+1561 (ᕡ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x1038, 0x1048, 0x1048, 0x1030, 0x0000, 0x0000 },	// U+1562 (ᕢ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x1c08, 0x1208, 0x1208, 0x0c08, 0x0000, 0x0000 },	// U+1563 (ᕣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0890, 0x1090, 0x1060, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+1564 (ᕤ)
	{ 0x0000, 0x0180, 0x0180, 0x0000, 0x07e0, 0x0890, 0x1090, 0x1060, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+1565 (ᕥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fc0, 0x1220, 0x1210, 0x0c10, 0x0010, 0x0010, 0x0010, 0x0010, 0x0020, 0x1fc0, 0x0000, 0x0000 },	// U+1566 (ᕦ)
	{ 0x0000, 0x0300, 0x0300, 0x0000, 0x0fc0, 0x1220, 0x1210, 0x0c10, 0x0010, 0x0010, 0x0010, 0x0010, 0x0020, 0x1fc0, 0x0000, 0x0000 },	// U+1567 (ᕧ)
	{ 0x0000, 0x0600, 0x0600, 0x0000, 0x1f80, 0x2440, 0x2420, 0x1820, 0x002c, 0x002c, 0x0020, 0x0020, 0x0040, 0x3f80, 0x0000, 0x0000 },	// U+1568 (ᕨ)
	{ 0x0000, 0x00c0, 0x00c0, 0x0000, 0x03f0, 0x0488, 0x0484, 0x0304, 0x3004, 0x3004, 0x0004, 0x0004, 0x0008, 0x07f0, 0x0000, 0x0000 },	// U+1569 (ᕩ)
}; // 12

static const uint16_t unifontdw_block86[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+156B (ᕫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0808, 0x0808, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0000, 0x0000 },	// U+156C (ᕬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0400, 0x0800, 0x0800, 0x08f8, 0x0800, 0x0800, 0x0400, 0x03f8, 0x0000, 0x0000 },	// U+156D (ᕭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fc0, 0x0020, 0x0010, 0x0010, 0x1f10, 0x0010, 0x0010, 0x0020, 0x1fc0, 0x0000, 0x0000 },	// U+156E (ᕮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x2a54, 0x1c38, 0x0810, 0x1c38, 0x2a54, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+156F (ᕯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x09c8, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+1570 (ᕰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0808, 0x0808, 0x09c8, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0000, 0x0000 },	// U+1571 (ᕱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0400, 0x0878, 0x0880, 0x0880, 0x0880, 0x0878, 0x0400, 0x03f8, 0x0000, 0x0000 },	// U+1572 (ᕲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fc0, 0x0020, 0x1e10, 0x0110, 0x0110, 0x0110, 0x1e10, 0x0020, 0x1fc0, 0x0000, 0x0000 },	// U+1573 (ᕳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0088, 0x0088, 0x0088, 0x00f0, 0x0480, 0x0280, 0x0180, 0x0080, 0x0000, 0x0000 },	// U+1574 (ᕴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0440, 0x0440, 0x03c0, 0x0048, 0x0050, 0x0060, 0x0040, 0x0000, 0x0000 },	// U+1575 (ᕵ)
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0380, 0x0440, 0x0440, 0x0440, 0x03c0, 0x0048, 0x0050, 0x0060, 0x0040, 0x0000, 0x0000 },	// U+1576 (ᕶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0180, 0x0280, 0x0480, 0x00f0, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+1577 (ᕷ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x0080, 0x0180, 0x0280, 0x0480, 0x00f0, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+1578 (ᕸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0060, 0x0050, 0x0048, 0x03c0, 0x0440, 0x0440, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+1579 (ᕹ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x0040, 0x0060, 0x0050, 0x0048, 0x03c0, 0x0440, 0x0440, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+157A (ᕺ)
}; // 16

static const uint16_t unifontdw_block87[][16] = {
	{ 0x0c00, 0x1200, 0x1200, 0x0c00, 0x0000, 0x0e38, 0x1104, 0x1104, 0x1138, 0x0f20, 0x0120, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000 },	// U+157E (ᕾ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1104, 0x1104, 0x1138, 0x0f20, 0x0120, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000 },	// U+157F (ᕿ)
	{ 0x0000, 0x0000, 0x0600, 0x0600, 0x0000, 0x0e38, 0x1104, 0x1104, 0x1138, 0x0f20, 0x0120, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000 },	// U+1580 (ᖀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1038, 0x1004, 0x1004, 0x1038, 0x1e20, 0x1120, 0x1100, 0x1100, 0x0e00, 0x0000, 0x0000 },	// U+1581 (ᖁ)
	{ 0x0000, 0x0000, 0x1800, 0x1800, 0x0000, 0x1038, 0x1004, 0x1004, 0x1038, 0x1e20, 0x1120, 0x1100, 0x1100, 0x0e00, 0x0000, 0x0000 },	// U+1582 (ᖂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0138, 0x0104, 0x0104, 0x0138, 0x0f20, 0x1120, 0x1100, 0x1100, 0x0e00, 0x0000, 0x0000 },	// U+1583 (ᖃ)
	{ 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0138, 0x0104, 0x0104, 0x0138, 0x0f20, 0x1120, 0x1100, 0x1100, 0x0e00, 0x0000, 0x0000 },	// U+1584 (ᖄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0260, 0x0210, 0x0e10, 0x1260, 0x1240, 0x0c40, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1585 (ᖅ)
}; // 8

static const uint16_t unifontdw_block88[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0088, 0x0088, 0x0088, 0x0080, 0x0480, 0x0280, 0x0180, 0x0080, 0x0000, 0x0000 },	// U+158A (ᖊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0440, 0x0440, 0x0040, 0x0048, 0x0050, 0x0060, 0x0040, 0x0000, 0x0000 },	// U+158B (ᖋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0180, 0x0280, 0x0480, 0x0080, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+158C (ᖌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0060, 0x0050, 0x0048, 0x0040, 0x0440, 0x0440, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+158D (ᖍ)
	{ 0x3000, 0x4800, 0x4800, 0x3000, 0x0000, 0x380c, 0x4412, 0x4412, 0x443c, 0x3d20, 0x0520, 0x04c0, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+158E (ᖎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x380c, 0x4412, 0x4412, 0x443c, 0x3d20, 0x0520, 0x04c0, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+158F (ᖏ)
	{ 0x0000, 0x0000, 0x1800, 0x1800, 0x0000, 0x380c, 0x4412, 0x4412, 0x443c, 0x0520, 0x0520, 0x04c0, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+1590 (ᖐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x400c, 0x4012, 0x4012, 0x403c, 0x4120, 0x4520, 0x44c0, 0x4400, 0x3800, 0x0000, 0x0000 },	// U+1591 (ᖑ)
	{ 0x0000, 0x0000, 0x6000, 0x6000, 0x0000, 0x400c, 0x4012, 0x4012, 0x403c, 0x4120, 0x4520, 0x44c0, 0x4400, 0x3800, 0x0000, 0x0000 },	// U+1592 (ᖒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x040c, 0x0412, 0x0412, 0x043c, 0x0520, 0x4520, 0x44c0, 0x4400, 0x3800, 0x0000, 0x0000 },	// U+1593 (ᖓ)
	{ 0x0000, 0x0000, 0x0c00, 0x0c00, 0x0000, 0x040c, 0x0412, 0x0412, 0x043c, 0x0520, 0x4520, 0x44c0, 0x4400, 0x3800, 0x0000, 0x0000 },	// U+1594 (ᖔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0090, 0x01e0, 0x0900, 0x0900, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1595 (ᖕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x018c, 0x0252, 0x0252, 0x07fc, 0x2400, 0x2400, 0x1800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1596 (ᖖ)
}; // 13

static const uint16_t unifontdw_block89[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0000, 0x07f8, 0x0880, 0x0880, 0x0880, 0x0700, 0x0000, 0x0000 },	// U+159B (ᖛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0000, 0x0ff0, 0x0088, 0x0088, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+159C (ᖜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0000, 0x0700, 0x0880, 0x0880, 0x0880, 0x07f8, 0x0000, 0x0000 },	// U+159D (ᖝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0000, 0x0070, 0x0088, 0x0088, 0x0088, 0x0ff0, 0x0000, 0x0000 },	// U+159E (ᖞ)
}; // 4

static const uint16_t unifontdw_block90[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0200, 0x0400, 0x0ff0, 0x0008, 0x0008, 0x0008, 0x0070, 0x0000, 0x0000 },	// U+15A0 (ᖠ)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0100, 0x0200, 0x0400, 0x0ff0, 0x0008, 0x0008, 0x0008, 0x0070, 0x0000, 0x0000 },	// U+15A1 (ᖡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0800, 0x0800, 0x0800, 0x07f8, 0x0010, 0x0020, 0x0040, 0x0000, 0x0000 },	// U+15A2 (ᖢ)
	{ 0x0000, 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0700, 0x0800, 0x0800, 0x0800, 0x07f8, 0x0010, 0x0020, 0x0040, 0x0000, 0x0000 },	// U+15A3 (ᖣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0008, 0x0008, 0x0008, 0x0ff0, 0x0400, 0x0200, 0x0100, 0x0000, 0x0000 },	// U+15A4 (ᖤ)
	{ 0x0000, 0x0000, 0x0000, 0x0060, 0x0060, 0x0000, 0x0070, 0x0008, 0x0008, 0x0008, 0x0ff0, 0x0400, 0x0200, 0x0100, 0x0000, 0x0000 },	// U+15A5 (ᖥ)
}; // 6

static const uint16_t unifontdw_block91[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0870, 0x0850, 0x0850, 0x0790, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0000, 0x0000 },	// U+15B8 (ᖸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x09e0, 0x0a10, 0x0a10, 0x0e10, 0x0000, 0x0000 },	// U+15B9 (ᖹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0790, 0x0850, 0x0850, 0x0870, 0x0000, 0x0000 },	// U+15BA (ᖺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e10, 0x0a10, 0x0a10, 0x09e0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+15BB (ᖻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0830, 0x0450, 0x0290, 0x0110, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0000, 0x0000 },	// U+15BC (ᖼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0880, 0x0940, 0x0a20, 0x0c10, 0x0000, 0x0000 },	// U+15BD (ᖽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0110, 0x0290, 0x0450, 0x0830, 0x0000, 0x0000 },	// U+15BE (ᖾ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c10, 0x0a20, 0x0940, 0x0880, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+15BF (ᖿ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x08e0, 0x0910, 0x0910, 0x0a00, 0x0a00, 0x0c00, 0x0000, 0x0000 },	// U+15C0 (ᗀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x0010, 0x0710, 0x0890, 0x0890, 0x0050, 0x0050, 0x0030, 0x0000, 0x0000 },	// U+15C1 (ᗁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x0a00, 0x0a00, 0x0910, 0x0910, 0x08e0, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+15C2 (ᗂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0050, 0x0050, 0x0890, 0x0890, 0x0710, 0x0010, 0x0010, 0x0010, 0x0000, 0x0000 },	// U+15C3 (ᗃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x2004, 0x1008, 0x0ff0, 0x0420, 0x0240, 0x0180, 0x0000, 0x0000 },	// U+15C4 (ᗄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0ff0, 0x1008, 0x2004, 0x4002, 0x0000, 0x0000 },	// U+15C5 (ᗅ)
	{ 0x0000, 0x0000, 0x0010, 0x0020, 0x0040, 0x0080, 0x0180, 0x0280, 0x0480, 0x0480, 0x0280, 0x0180, 0x0080, 0x0040, 0x0020, 0x0010 },	// U+15C6 (ᗆ)
	{ 0x0000, 0x0000, 0x0010, 0x0020, 0x0040, 0x0080, 0x0180, 0x02a0, 0x04a0, 0x04a0, 0x02a0, 0x0180, 0x0080, 0x0040, 0x0020, 0x0010 },	// U+15C7 (ᗇ)
	{ 0x0000, 0x0000, 0x0010, 0x0020, 0x0040, 0x0080, 0x0180, 0x0280, 0x04b0, 0x04b0, 0x0280, 0x0180, 0x0080, 0x0040, 0x0020, 0x0010 },	// U+15C8 (ᗈ)
	{ 0x0000, 0x0000, 0x0200, 0x0100, 0x0080, 0x0040, 0x0060, 0x0050, 0x0048, 0x0048, 0x0050, 0x0060, 0x0040, 0x0080, 0x0100, 0x0200 },	// U+15C9 (ᗉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x3ffc, 0x1008, 0x0810, 0x0420, 0x0240, 0x0180, 0x0000, 0x0000 },	// U+15CA (ᗊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x3ffc, 0x4002, 0x0000, 0x0000 },	// U+15CB (ᗋ)
	{ 0x0000, 0x0000, 0x0010, 0x0020, 0x0060, 0x00a0, 0x0120, 0x0220, 0x0420, 0x0420, 0x0220, 0x0120, 0x00a0, 0x0060, 0x0020, 0x0010 },	// U+15CC (ᗌ)
	{ 0x0000, 0x0000, 0x0010, 0x0020, 0x0060, 0x00a0, 0x0120, 0x02a0, 0x04a0, 0x04a0, 0x02a0, 0x0120, 0x00a0, 0x0060, 0x0020, 0x0010 },	// U+15CD (ᗍ)
	{ 0x0000, 0x0000, 0x0010, 0x0020, 0x0060, 0x00a0, 0x0120, 0x0220, 0x05a0, 0x05a0, 0x0220, 0x0120, 0x00a0, 0x0060, 0x0020, 0x0010 },	// U+15CE (ᗎ)
	{ 0x0000, 0x0000, 0x0200, 0x0100, 0x0180, 0x0140, 0x0120, 0x0110, 0x0108, 0x0108, 0x0110, 0x0120, 0x0140, 0x0180, 0x0100, 0x0200 },	// U+15CF (ᗏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2082, 0x1084, 0x0888, 0x0490, 0x02a0, 0x01c0, 0x0080, 0x0000, 0x0000 },	// U+15D0 (ᗐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x02a0, 0x0490, 0x0888, 0x1084, 0x2082, 0x0000, 0x0000 },	// U+15D1 (ᗑ)
	{ 0x0000, 0x0000, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0fe0, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+15D2 (ᗒ)
	{ 0x0000, 0x0000, 0x0020, 0x0040, 0x0080, 0x0100, 0x0220, 0x0420, 0x0ff0, 0x0420, 0x0220, 0x0100, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+15D3 (ᗓ)
	{ 0x0000, 0x0000, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0460, 0x0ff0, 0x0460, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+15D4 (ᗔ)
	{ 0x0000, 0x0000, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x07f0, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0000 },	// U+15D5 (ᗕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2082, 0x1084, 0x0ff8, 0x0490, 0x02a0, 0x01c0, 0x0080, 0x0000, 0x0000 },	// U+15D6 (ᗖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x02a0, 0x0490, 0x0ff8, 0x1084, 0x2082, 0x0000, 0x0000 },	// U+15D7 (ᗗ)
	{ 0x0000, 0x0000, 0x0020, 0x0040, 0x0080, 0x0180, 0x0280, 0x0480, 0x0fe0, 0x0480, 0x0280, 0x0180, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+15D8 (ᗘ)
	{ 0x0000, 0x0000, 0x0020, 0x0040, 0x0080, 0x0180, 0x02a0, 0x04a0, 0x0ff0, 0x04a0, 0x02a0, 0x0180, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+15D9 (ᗙ)
	{ 0x0000, 0x0000, 0x0020, 0x0040, 0x0080, 0x0180, 0x0280, 0x04b0, 0x0ff8, 0x04b0, 0x0280, 0x0180, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+15DA (ᗚ)
	{ 0x0000, 0x0000, 0x0800, 0x0400, 0x0200, 0x0300, 0x0280, 0x0240, 0x0fe0, 0x0240, 0x0280, 0x0300, 0x0200, 0x0400, 0x0800, 0x0000 },	// U+15DB (ᗛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+15DC (ᗜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1ff8, 0x0000, 0x0000 },	// U+15DD (ᗝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0408, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0408, 0x03f8, 0x0000, 0x0000 },	// U+15DE (ᗞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0408, 0x0808, 0x0888, 0x0888, 0x0888, 0x0888, 0x0808, 0x0408, 0x03f8, 0x0000, 0x0000 },	// U+15DF (ᗟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0408, 0x0808, 0x0808, 0x08c8, 0x08c8, 0x0808, 0x0808, 0x0408, 0x03f8, 0x0000, 0x0000 },	// U+15E0 (ᗠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0810, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0810, 0x0fe0, 0x0000, 0x0000 },	// U+15E1 (ᗡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1818, 0x1428, 0x1248, 0x1188, 0x1008, 0x1008, 0x1008, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+15E2 (ᗢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x1188, 0x1248, 0x1428, 0x1818, 0x0000, 0x0000 },	// U+15E3 (ᗣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0808, 0x1010, 0x1020, 0x1040, 0x1040, 0x1020, 0x1010, 0x0808, 0x07f8, 0x0000, 0x0000 },	// U+15E4 (ᗤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0808, 0x1010, 0x1220, 0x1240, 0x1240, 0x1220, 0x1010, 0x0808, 0x07f8, 0x0000, 0x0000 },	// U+15E5 (ᗥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0808, 0x1010, 0x1020, 0x1340, 0x1340, 0x1020, 0x1010, 0x0808, 0x07f8, 0x0000, 0x0000 },	// U+15E6 (ᗦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1fe0, 0x1010, 0x0808, 0x0408, 0x0208, 0x0208, 0x0408, 0x0808, 0x1010, 0x1fe0, 0x0000, 0x0000 },	// U+15E7 (ᗧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1008, 0x1008, 0x1008, 0x1008, 0x1ff8, 0x1008, 0x1008, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+15E8 (ᗨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1ff8, 0x1008, 0x1008, 0x1008, 0x1008, 0x0000, 0x0000 },	// U+15E9 (ᗩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0420, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x0420, 0x03f8, 0x0000, 0x0000 },	// U+15EA (ᗪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0420, 0x0820, 0x0920, 0x0920, 0x0920, 0x0920, 0x0820, 0x0420, 0x03f8, 0x0000, 0x0000 },	// U+15EB (ᗫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0420, 0x0820, 0x0820, 0x09a0, 0x09a0, 0x0820, 0x0820, 0x0420, 0x03f8, 0x0000, 0x0000 },	// U+15EC (ᗬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0210, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0210, 0x0fe0, 0x0000, 0x0000 },	// U+15ED (ᗭ)
}; // 54

static const uint16_t unifontdw_block92[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x1144, 0x0e38, 0x0000, 0x0000 },	// U+15EF (ᗯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1144, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x0000, 0x0000 },	// U+15F0 (ᗰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0800, 0x0800, 0x0800, 0x07f0, 0x0800, 0x0800, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+15F1 (ᗱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0800, 0x0800, 0x0840, 0x07f0, 0x0840, 0x0800, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+15F2 (ᗲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0800, 0x0800, 0x0860, 0x07f0, 0x0860, 0x0800, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+15F3 (ᗳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0010, 0x0010, 0x0010, 0x0fe0, 0x0010, 0x0010, 0x0010, 0x0fe0, 0x0000, 0x0000 },	// U+15F4 (ᗴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x1144, 0x0e38, 0x0000, 0x0000 },	// U+15F5 (ᗵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1144, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x3ffe, 0x0000, 0x0000 },	// U+15F6 (ᗶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0810, 0x0810, 0x0810, 0x07f0, 0x0810, 0x0810, 0x0810, 0x07f0, 0x0000, 0x0000 },	// U+15F7 (ᗷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0810, 0x0810, 0x0910, 0x07f0, 0x0910, 0x0810, 0x0810, 0x07f0, 0x0000, 0x0000 },	// U+15F8 (ᗸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0810, 0x0810, 0x0990, 0x07f0, 0x0990, 0x0810, 0x0810, 0x07f0, 0x0000, 0x0000 },	// U+15F9 (ᗹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0810, 0x0810, 0x0810, 0x0fe0, 0x0810, 0x0810, 0x0810, 0x0fe0, 0x0000, 0x0000 },	// U+15FA (ᗺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3086, 0x2c9a, 0x23e2, 0x2082, 0x2082, 0x2082, 0x2082, 0x1144, 0x0e38, 0x0000, 0x0000 },	// U+15FB (ᗻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1144, 0x2082, 0x2082, 0x2082, 0x2082, 0x23e2, 0x2c9a, 0x3086, 0x0000, 0x0000 },	// U+15FC (ᗼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0810, 0x0820, 0x0840, 0x07f0, 0x0840, 0x0820, 0x0810, 0x07f0, 0x0000, 0x0000 },	// U+15FD (ᗽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0810, 0x0820, 0x0a40, 0x07f0, 0x0a40, 0x0820, 0x0810, 0x07f0, 0x0000, 0x0000 },	// U+15FE (ᗾ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0810, 0x0820, 0x0b40, 0x07f0, 0x0b40, 0x0820, 0x0810, 0x07f0, 0x0000, 0x0000 },	// U+15FF (ᗿ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0810, 0x0410, 0x0210, 0x0fe0, 0x0210, 0x0410, 0x0810, 0x0fe0, 0x0000, 0x0000 },	// U+1600 (ᘀ)
}; // 18

static const uint16_t unifontdw_block93[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x1000, 0x1000, 0x1000, 0x0e00, 0x0000, 0x0000 },	// U+1604 (ᘄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x1000, 0x1200, 0x1200, 0x1000, 0x0e00, 0x0000 },	// U+1605 (ᘅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x1000, 0x1600, 0x1600, 0x1000, 0x0e00, 0x0000 },	// U+1606 (ᘆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0010, 0x0010, 0x0010, 0x1fe0, 0x0000, 0x0000 },	// U+1607 (ᘇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0002, 0x0082, 0x0082, 0x2082, 0x2082, 0x2082, 0x1144, 0x0e38, 0x0000, 0x0000 },	// U+1608 (ᘈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1144, 0x2082, 0x2082, 0x2082, 0x2080, 0x2080, 0x2000, 0x2000, 0x0000, 0x0000 },	// U+1609 (ᘉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0800, 0x0800, 0x0800, 0x07e0, 0x0800, 0x0800, 0x0800, 0x0780, 0x0000, 0x0000 },	// U+160A (ᘊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0800, 0x0820, 0x0820, 0x07e0, 0x0820, 0x0820, 0x0800, 0x0780, 0x0000, 0x0000 },	// U+160B (ᘋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0800, 0x0800, 0x08c0, 0x07e0, 0x08c0, 0x0800, 0x0800, 0x0780, 0x0000, 0x0000 },	// U+160C (ᘌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x0008, 0x0008, 0x0008, 0x03f0, 0x0008, 0x0008, 0x0008, 0x0ff0, 0x0000, 0x0000 },	// U+160D (ᘍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e08, 0x1108, 0x1108, 0x1108, 0x1208, 0x1008, 0x1008, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+160E (ᘎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1048, 0x1088, 0x1088, 0x1088, 0x1070, 0x0000, 0x0000 },	// U+160F (ᘏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0800, 0x1000, 0x1000, 0x1000, 0x10e0, 0x1110, 0x1010, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+1610 (ᘐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0800, 0x1000, 0x1000, 0x1100, 0x11e0, 0x1110, 0x1010, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+1611 (ᘑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0800, 0x1000, 0x1000, 0x1180, 0x13e0, 0x1190, 0x1010, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+1612 (ᘒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fc0, 0x1020, 0x1010, 0x1110, 0x0e10, 0x0010, 0x0010, 0x0010, 0x0020, 0x1fc0, 0x0000, 0x0000 },	// U+1613 (ᘓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1fe0, 0x0c00, 0x0300, 0x0080, 0x0040, 0x0720, 0x08a0, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+1614 (ᘔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0060, 0x0180, 0x0200, 0x0400, 0x09c0, 0x0a20, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+1615 (ᘕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0820, 0x0a20, 0x09c0, 0x0400, 0x0200, 0x0180, 0x0060, 0x0ff0, 0x0000, 0x0000 },	// U+1616 (ᘖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0708, 0x0888, 0x1248, 0x1128, 0x1128, 0x0918, 0x0618, 0x0008, 0x0000, 0x0000 },	// U+1617 (ᘗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0784, 0x0844, 0x1224, 0x1314, 0x1294, 0x108c, 0x088c, 0x0704, 0x0000, 0x0000 },	// U+1618 (ᘘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f84, 0x1044, 0x2624, 0x2f14, 0x2694, 0x208c, 0x108c, 0x0f04, 0x0000, 0x0000 },	// U+1619 (ᘙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0618, 0x0918, 0x1128, 0x1128, 0x1248, 0x0888, 0x0708, 0x0000, 0x0000 },	// U+161A (ᘚ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1860, 0x1890, 0x1488, 0x1488, 0x1248, 0x1110, 0x10e0, 0x0000, 0x0000 },	// U+161B (ᘛ)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x1e10, 0x01a0, 0x0040, 0x0040, 0x0020, 0x0e20, 0x1120, 0x1020, 0x1040, 0x0f80, 0x0000, 0x0000 },	// U+161C (ᘜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x0208, 0x0408, 0x0488, 0x0470, 0x0400, 0x0200, 0x0200, 0x0580, 0x0878, 0x1000, 0x0000 },	// U+161D (ᘝ)
	{ 0x0000, 0x0000, 0x0000, 0x0004, 0x0f88, 0x1050, 0x2020, 0x2320, 0x2090, 0x1090, 0x0f10, 0x0008, 0x0008, 0x0008, 0x0000, 0x0000 },	// U+161E (ᘞ)
	{ 0x0000, 0x0000, 0x0000, 0x0004, 0x0f88, 0x1050, 0x2220, 0x2320, 0x2290, 0x1090, 0x0f10, 0x0008, 0x0008, 0x0008, 0x0000, 0x0000 },	// U+161F (ᘟ)
	{ 0x0000, 0x0000, 0x0000, 0x0004, 0x0f88, 0x1050, 0x2620, 0x2720, 0x2690, 0x1090, 0x0f10, 0x0008, 0x0008, 0x0008, 0x0000, 0x0000 },	// U+1620 (ᘠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1070, 0x1088, 0x1088, 0x1088, 0x0848, 0x0808, 0x0610, 0x09e0, 0x1000, 0x2000, 0x0000 },	// U+1621 (ᘡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x203c, 0x2020, 0x2020, 0x2020, 0x1040, 0x0f80, 0x0000, 0x0000 },	// U+1622 (ᘢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x0208, 0x0404, 0x0404, 0x0404, 0x3c04, 0x0000, 0x0000 },	// U+1623 (ᘣ)
	{ 0x0000, 0x0000, 0x0000, 0x0020, 0x0020, 0x0020, 0x01e0, 0x0200, 0x0400, 0x0400, 0x0400, 0x0400, 0x0200, 0x01e0, 0x0000, 0x0000 },	// U+1624 (ᘤ)
	{ 0x0000, 0x0000, 0x0000, 0x0020, 0x0020, 0x0020, 0x01e0, 0x0200, 0x0480, 0x0480, 0x0480, 0x0480, 0x0200, 0x01e0, 0x0000, 0x0000 },	// U+1625 (ᘥ)
	{ 0x0000, 0x0000, 0x0000, 0x0020, 0x0020, 0x0020, 0x01e0, 0x0200, 0x0400, 0x04c0, 0x04c0, 0x0400, 0x0200, 0x01e0, 0x0000, 0x0000 },	// U+1626 (ᘦ)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0400, 0x0400, 0x0780, 0x0040, 0x0020, 0x0020, 0x0020, 0x0020, 0x0040, 0x0780, 0x0000, 0x0000 },	// U+1627 (ᘧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x203c, 0x2024, 0x2020, 0x2020, 0x1040, 0x0f80, 0x0000, 0x0000 },	// U+1628 (ᘨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x0208, 0x0404, 0x0404, 0x2404, 0x3c04, 0x2000, 0x0000 },	// U+1629 (ᘩ)
	{ 0x0000, 0x0000, 0x0000, 0x0070, 0x0020, 0x0020, 0x01e0, 0x0200, 0x0400, 0x0400, 0x0400, 0x0400, 0x0200, 0x01e0, 0x0000, 0x0000 },	// U+162A (ᘪ)
	{ 0x0000, 0x0000, 0x0000, 0x0070, 0x0020, 0x0020, 0x01e0, 0x0200, 0x0480, 0x0480, 0x0480, 0x0480, 0x0200, 0x01e0, 0x0000, 0x0000 },	// U+162B (ᘫ)
	{ 0x0000, 0x0000, 0x0000, 0x0070, 0x0020, 0x0020, 0x01e0, 0x0200, 0x0400, 0x04c0, 0x04c0, 0x0400, 0x0200, 0x01e0, 0x0000, 0x0000 },	// U+162C (ᘬ)
	{ 0x0000, 0x0000, 0x0000, 0x0700, 0x0200, 0x0200, 0x03c0, 0x0020, 0x0010, 0x0010, 0x0010, 0x0010, 0x0020, 0x03c0, 0x0000, 0x0000 },	// U+162D (ᘭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e78, 0x0420, 0x0810, 0x1008, 0x1008, 0x1008, 0x1008, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+162E (ᘮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x1008, 0x0810, 0x0420, 0x1e78, 0x0000, 0x0000 },	// U+162F (ᘯ)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x07f0, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x07f0, 0x0010, 0x0010, 0x0000 },	// U+1630 (ᘰ)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x07f0, 0x0800, 0x1100, 0x1100, 0x1100, 0x1100, 0x0800, 0x07f0, 0x0010, 0x0010, 0x0000 },	// U+1631 (ᘱ)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x07f0, 0x0800, 0x1000, 0x1180, 0x1180, 0x1000, 0x0800, 0x07f0, 0x0010, 0x0010, 0x0000 },	// U+1632 (ᘲ)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x1fc0, 0x0020, 0x0010, 0x0010, 0x0010, 0x0010, 0x0020, 0x1fc0, 0x1000, 0x1000, 0x0000 },	// U+1633 (ᘳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x780e, 0x4808, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+1634 (ᘴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1010, 0x1010, 0x1012, 0x701e, 0x0002, 0x0000 },	// U+1635 (ᘵ)
	{ 0x0000, 0x0000, 0x0038, 0x0010, 0x0010, 0x07f0, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x07f0, 0x0010, 0x0010, 0x0000 },	// U+1636 (ᘶ)
	{ 0x0000, 0x0000, 0x0038, 0x0010, 0x0010, 0x07f0, 0x0800, 0x1100, 0x1100, 0x1100, 0x1100, 0x0800, 0x07f0, 0x0010, 0x0010, 0x0000 },	// U+1637 (ᘷ)
	{ 0x0000, 0x0000, 0x0038, 0x0010, 0x0010, 0x07f0, 0x0800, 0x1000, 0x1180, 0x1180, 0x1000, 0x0800, 0x07f0, 0x0010, 0x0010, 0x0000 },	// U+1638 (ᘸ)
	{ 0x0000, 0x0000, 0x1c00, 0x0800, 0x0800, 0x0fe0, 0x0010, 0x0008, 0x0008, 0x0008, 0x0008, 0x0010, 0x0fe0, 0x0800, 0x0800, 0x0000 },	// U+1639 (ᘹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x7086, 0x5084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x0f78, 0x0000, 0x0000 },	// U+163A (ᘺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ef0, 0x2108, 0x2108, 0x2108, 0x2108, 0x2108, 0x210a, 0x610e, 0x0002, 0x0000 },	// U+163B (ᘻ)
	{ 0x0000, 0x0000, 0x0000, 0x0038, 0x0010, 0x07f0, 0x0800, 0x0800, 0x0800, 0x07f0, 0x0800, 0x0800, 0x0800, 0x07f0, 0x0010, 0x0000 },	// U+163C (ᘼ)
	{ 0x0000, 0x0000, 0x0000, 0x0038, 0x0010, 0x07f0, 0x0800, 0x0800, 0x0810, 0x07f0, 0x0810, 0x0800, 0x0800, 0x07f0, 0x0010, 0x0000 },	// U+163D (ᘽ)
	{ 0x0000, 0x0000, 0x0000, 0x0038, 0x0010, 0x07f0, 0x0800, 0x0800, 0x0830, 0x07f0, 0x0830, 0x0800, 0x0800, 0x07f0, 0x0010, 0x0000 },	// U+163E (ᘾ)
	{ 0x0000, 0x0000, 0x0000, 0x0e00, 0x0400, 0x07f0, 0x0008, 0x0008, 0x0008, 0x07f0, 0x0008, 0x0008, 0x0008, 0x07f0, 0x0400, 0x0000 },	// U+163F (ᘿ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1818, 0x0420, 0x0420, 0x0810, 0x1008, 0x1008, 0x1008, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+1640 (ᙀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x1008, 0x1008, 0x0810, 0x0420, 0x0420, 0x1818, 0x0000, 0x0000 },	// U+1641 (ᙁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c4, 0x0824, 0x1018, 0x1000, 0x1000, 0x1000, 0x1000, 0x1018, 0x0824, 0x07c4, 0x0000, 0x0000 },	// U+1642 (ᙂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c4, 0x0824, 0x1018, 0x1100, 0x1100, 0x1100, 0x1100, 0x1018, 0x0824, 0x07c4, 0x0000, 0x0000 },	// U+1643 (ᙃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c4, 0x0824, 0x1018, 0x1000, 0x1180, 0x1180, 0x1000, 0x1018, 0x0824, 0x07c4, 0x0000, 0x0000 },	// U+1644 (ᙄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x11f0, 0x1208, 0x0c04, 0x0004, 0x0004, 0x0004, 0x0004, 0x0c04, 0x1208, 0x11f0, 0x0000, 0x0000 },	// U+1645 (ᙅ)
}; // 66

static const uint16_t unifontdw_block94[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x19cc, 0x0490, 0x0490, 0x0808, 0x1004, 0x1004, 0x1004, 0x0808, 0x07f0, 0x0000, 0x0000 },	// U+1648 (ᙈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0808, 0x1004, 0x1004, 0x1004, 0x0808, 0x0490, 0x0490, 0x19cc, 0x0000, 0x0000 },	// U+1649 (ᙉ)
	{ 0x0000, 0x0000, 0x0000, 0x07c4, 0x0824, 0x1018, 0x1000, 0x1004, 0x101c, 0x1004, 0x1000, 0x1018, 0x0824, 0x07c4, 0x0000, 0x0000 },	// U+164A (ᙊ)
	{ 0x0000, 0x0000, 0x0000, 0x07c4, 0x0824, 0x1018, 0x1100, 0x1104, 0x111c, 0x1104, 0x1100, 0x1018, 0x0824, 0x07c4, 0x0000, 0x0000 },	// U+164B (ᙋ)
	{ 0x0000, 0x0000, 0x0000, 0x07c4, 0x0824, 0x1018, 0x1000, 0x1304, 0x179c, 0x1304, 0x1000, 0x1018, 0x0824, 0x07c4, 0x0000, 0x0000 },	// U+164C (ᙌ)
	{ 0x0000, 0x0000, 0x0000, 0x11f0, 0x1208, 0x0c04, 0x0004, 0x1004, 0x1c04, 0x1004, 0x0004, 0x0c04, 0x1208, 0x11f0, 0x0000, 0x0000 },	// U+164D (ᙍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1084, 0x0888, 0x0888, 0x1084, 0x1084, 0x1084, 0x1084, 0x0f78, 0x0000, 0x0000 },	// U+164E (ᙎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1084, 0x1084, 0x1084, 0x1084, 0x0888, 0x0888, 0x1084, 0x0000, 0x0000 },	// U+164F (ᙏ)
	{ 0x0000, 0x0000, 0x0000, 0x0790, 0x0860, 0x0800, 0x0800, 0x0800, 0x07f0, 0x0800, 0x0800, 0x0800, 0x0860, 0x0790, 0x0000, 0x0000 },	// U+1650 (ᙐ)
	{ 0x0000, 0x0000, 0x0000, 0x0790, 0x0860, 0x0800, 0x0800, 0x0840, 0x07f0, 0x0840, 0x0800, 0x0800, 0x0860, 0x0790, 0x0000, 0x0000 },	// U+1651 (ᙑ)
	{ 0x0000, 0x0000, 0x0000, 0x0790, 0x0860, 0x0800, 0x0800, 0x08c0, 0x07f0, 0x08c0, 0x0800, 0x0800, 0x0860, 0x0790, 0x0000, 0x0000 },	// U+1652 (ᙒ)
	{ 0x0000, 0x0000, 0x0000, 0x09e0, 0x0610, 0x0010, 0x0010, 0x0010, 0x0fe0, 0x0010, 0x0010, 0x0010, 0x0610, 0x09e0, 0x0000, 0x0000 },	// U+1653 (ᙓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1084, 0x0888, 0x0ff8, 0x1084, 0x1084, 0x1084, 0x1084, 0x0f78, 0x0000, 0x0000 },	// U+1654 (ᙔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1084, 0x1084, 0x1084, 0x1084, 0x0ff8, 0x0888, 0x1084, 0x0000, 0x0000 },	// U+1655 (ᙕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c8, 0x0830, 0x1020, 0x1020, 0x1020, 0x0ff8, 0x1020, 0x1020, 0x1020, 0x0830, 0x07c8 },	// U+1656 (ᙖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c8, 0x0830, 0x1020, 0x1120, 0x1120, 0x0ff8, 0x1120, 0x1120, 0x1020, 0x0830, 0x07c8 },	// U+1657 (ᙗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c8, 0x0830, 0x1020, 0x1020, 0x1320, 0x0ff8, 0x1320, 0x1020, 0x1020, 0x0830, 0x07c8 },	// U+1658 (ᙘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13e0, 0x0c10, 0x0408, 0x0408, 0x0408, 0x1ff0, 0x0408, 0x0408, 0x0408, 0x0c10, 0x13e0 },	// U+1659 (ᙙ)
}; // 18

static const uint16_t unifontdw_block95[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x11c4, 0x0888, 0x0ff8, 0x1084, 0x1084, 0x1084, 0x1084, 0x0f78, 0x0000, 0x0000 },	// U+165B (ᙛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1084, 0x1084, 0x1084, 0x1084, 0x0ff8, 0x0888, 0x11c4, 0x0000, 0x0000 },	// U+165C (ᙜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c8, 0x0830, 0x1020, 0x1020, 0x1028, 0x0ff8, 0x1028, 0x1020, 0x1020, 0x0830, 0x07c8 },	// U+165D (ᙝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c8, 0x0830, 0x1020, 0x1120, 0x1128, 0x0ff8, 0x1128, 0x1120, 0x1020, 0x0830, 0x07c8 },	// U+165E (ᙞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c8, 0x0830, 0x1020, 0x1020, 0x1328, 0x0ff8, 0x1328, 0x1020, 0x1020, 0x0830, 0x07c8 },	// U+165F (ᙟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c8, 0x0830, 0x1020, 0x1020, 0x1028, 0x0ff8, 0x1028, 0x1020, 0x1020, 0x0830, 0x07c8 },	// U+1660 (ᙠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x11c4, 0x0888, 0x0888, 0x1084, 0x1084, 0x1084, 0x1084, 0x0f78, 0x0000, 0x0000 },	// U+1661 (ᙡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1084, 0x1084, 0x1084, 0x1084, 0x0888, 0x0888, 0x11c4, 0x0000, 0x0000 },	// U+1662 (ᙢ)
	{ 0x0000, 0x0000, 0x0000, 0x0790, 0x0860, 0x0800, 0x0800, 0x0810, 0x07f0, 0x0810, 0x0800, 0x0800, 0x0860, 0x0790, 0x0000, 0x0000 },	// U+1663 (ᙣ)
	{ 0x0000, 0x0000, 0x0000, 0x0790, 0x0860, 0x0800, 0x0800, 0x0850, 0x07f0, 0x0850, 0x0800, 0x0800, 0x0860, 0x0790, 0x0000, 0x0000 },	// U+1664 (ᙤ)
	{ 0x0000, 0x0000, 0x0000, 0x0790, 0x0860, 0x0800, 0x0800, 0x08d0, 0x07f0, 0x08d0, 0x0800, 0x0800, 0x0860, 0x0790, 0x0000, 0x0000 },	// U+1665 (ᙥ)
	{ 0x0000, 0x0000, 0x0000, 0x09e0, 0x0610, 0x0010, 0x0010, 0x0810, 0x0fe0, 0x0810, 0x0010, 0x0010, 0x0610, 0x09e0, 0x0000, 0x0000 },	// U+1666 (ᙦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x11c4, 0x0888, 0x0c98, 0x12a4, 0x11c4, 0x1084, 0x1084, 0x0f78, 0x0000, 0x0000 },	// U+1667 (ᙧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1084, 0x1084, 0x11c4, 0x12a4, 0x0c98, 0x0888, 0x11c4, 0x0000, 0x0000 },	// U+1668 (ᙨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e4, 0x0818, 0x1010, 0x1020, 0x1044, 0x0ffc, 0x1044, 0x1020, 0x1010, 0x0818, 0x07e4 },	// U+1669 (ᙩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e4, 0x0818, 0x1010, 0x1220, 0x1244, 0x0ffc, 0x1244, 0x1220, 0x1010, 0x0818, 0x07e4 },	// U+166A (ᙪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e4, 0x0818, 0x1010, 0x1020, 0x1644, 0x0ffc, 0x1644, 0x1020, 0x1010, 0x0818, 0x07e4 },	// U+166B (ᙫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13f0, 0x0c08, 0x0404, 0x0204, 0x1104, 0x1ff8, 0x1104, 0x0204, 0x0404, 0x0c08, 0x13f0 },	// U+166C (ᙬ)
}; // 18

static const uint16_t unifontdw_block96[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1104, 0x1104, 0x1138, 0x1e20, 0x1020, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000 },	// U+166F (ᙯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x380c, 0x4412, 0x4412, 0x443c, 0x4120, 0x4120, 0x40c0, 0x4000, 0x4000, 0x0000, 0x0000 },	// U+1670 (ᙰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3814, 0x442a, 0x442a, 0x447c, 0x0540, 0x0540, 0x0480, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+1671 (ᙱ)
	{ 0x0000, 0x0000, 0x1800, 0x1800, 0x0000, 0x3814, 0x442a, 0x442a, 0x447c, 0x0540, 0x0540, 0x0480, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+1672 (ᙲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4014, 0x402a, 0x402a, 0x407c, 0x4140, 0x4540, 0x4480, 0x4400, 0x3800, 0x0000, 0x0000 },	// U+1673 (ᙳ)
	{ 0x0000, 0x0000, 0x6000, 0x6000, 0x0000, 0x4014, 0x402a, 0x402a, 0x407c, 0x4140, 0x4540, 0x4480, 0x4400, 0x3800, 0x0000, 0x0000 },	// U+1674 (ᙴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0414, 0x042a, 0x042a, 0x047c, 0x0540, 0x4540, 0x4480, 0x4400, 0x3800, 0x0000, 0x0000 },	// U+1675 (ᙵ)
	{ 0x0000, 0x0000, 0x0c00, 0x0c00, 0x0000, 0x0414, 0x042a, 0x042a, 0x047c, 0x0540, 0x4540, 0x4480, 0x4400, 0x3800, 0x0000, 0x0000 },	// U+1676 (ᙶ)
}; // 8

static const uint16_t unifontdw_block97[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1680 ( )
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+1681 (ᚁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0000, 0x0000 },	// U+1682 (ᚂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x0000, 0x0000 },	// U+1683 (ᚃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0000, 0x0000 },	// U+1684 (ᚄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0aa8, 0x0aa8, 0x0aa8, 0x0aa8, 0x0aa8, 0x0aa8, 0x0000, 0x0000 },	// U+1685 (ᚅ)
	{ 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1686 (ᚆ)
	{ 0x0000, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1687 (ᚇ)
	{ 0x0000, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1688 (ᚈ)
	{ 0x0000, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1689 (ᚉ)
	{ 0x0000, 0x0aa8, 0x0aa8, 0x0aa8, 0x0aa8, 0x0aa8, 0x0aa8, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+168A (ᚊ)
	{ 0x0000, 0x0000, 0x0200, 0x0200, 0x0100, 0x0100, 0x0080, 0xffff, 0x0080, 0x0040, 0x0040, 0x0020, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+168B (ᚋ)
	{ 0x0000, 0x0000, 0x0500, 0x0500, 0x0280, 0x0280, 0x0140, 0xffff, 0x0140, 0x00a0, 0x00a0, 0x0050, 0x0050, 0x0000, 0x0000, 0x0000 },	// U+168C (ᚌ)
	{ 0x0000, 0x0000, 0x0a80, 0x0a80, 0x0540, 0x0540, 0x02a0, 0xffff, 0x02a0, 0x0150, 0x0150, 0x00a8, 0x00a8, 0x0000, 0x0000, 0x0000 },	// U+168D (ᚍ)
	{ 0x0000, 0x0000, 0x1540, 0x1540, 0x0aa0, 0x0aa0, 0x0550, 0xffff, 0x0550, 0x02a8, 0x02a8, 0x0154, 0x0154, 0x0000, 0x0000, 0x0000 },	// U+168E (ᚎ)
	{ 0x0000, 0x0000, 0x2aa0, 0x2aa0, 0x1550, 0x1550, 0x0aa8, 0xffff, 0x0aa8, 0x0554, 0x0554, 0x02aa, 0x02aa, 0x0000, 0x0000, 0x0000 },	// U+168F (ᚏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0xffff, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1690 (ᚐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x0140, 0xffff, 0x0140, 0x0140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1691 (ᚑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02a0, 0x02a0, 0xffff, 0x02a0, 0x02a0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1692 (ᚒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0550, 0x0550, 0xffff, 0x0550, 0x0550, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1693 (ᚓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0aa8, 0x0aa8, 0xffff, 0x0aa8, 0x0aa8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1694 (ᚔ)
	{ 0x0000, 0x0000, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080, 0xffff, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0000, 0x0000, 0x0000 },	// U+1695 (ᚕ)
	{ 0x0000, 0x0080, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0xffff, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+1696 (ᚖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0010, 0x0010, 0x0390, 0x0210, 0x0210, 0x03f0, 0x0000, 0x0000 },	// U+1697 (ᚗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0948, 0x0490, 0x0360, 0x0360, 0x0490, 0x0948, 0x1224, 0x0000 },	// U+1698 (ᚘ)
	{ 0x0aa0, 0x1ff0, 0x0aa0, 0x1ff0, 0x0aa0, 0x1ff0, 0x0aa0, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1699 (ᚙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0x0000, 0x0ff0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+169A (ᚚ)
	{ 0x0000, 0x0000, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0xff80, 0x0040, 0x0020, 0x0010, 0x0008, 0x0004, 0x0000, 0x0000, 0x0000 },	// U+169B (᚛)
	{ 0x0000, 0x0000, 0x2000, 0x1000, 0x0800, 0x0400, 0x0200, 0x01ff, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000, 0x0000, 0x0000, 0x0000 },	// U+169C (᚜)
	{ 0x0000, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6d8e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+169D (᚝)
	{ 0x0000, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x61ce, 0x7ffe, 0x0000 },	// U+169E (᚞)
	{ 0x0000, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x7dce, 0x7ffe, 0x0000 },	// U+169F (᚟)
}; // 32

static const uint16_t unifontdw_block98[][16] = {
	{ 0x0000, 0x1041, 0x08e2, 0x0554, 0x0248, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0000 },	// U+16E0 (ᛠ)
}; // 1

static const uint16_t unifontdw_block99[][16] = {
	{ 0x0000, 0x1040, 0x08c0, 0x0540, 0x0240, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0048, 0x0054, 0x0062, 0x0041, 0x0000 },	// U+16E2 (ᛢ)
}; // 1

static const uint16_t unifontdw_block100[][16] = {
	{ 0x0000, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+16F9 (᛹)
	{ 0x0000, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+16FA (᛺)
	{ 0x0000, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+16FB (᛻)
	{ 0x0000, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+16FC (᛼)
	{ 0x0000, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+16FD (᛽)
	{ 0x0000, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+16FE (᛾)
	{ 0x0000, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+16FF (᛿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2006, 0x5008, 0x101e, 0x0810, 0x0810, 0x0410, 0x0210, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+1700 (ᜀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x000c, 0x3ff0, 0x4020, 0x0150, 0x02ce, 0x4440, 0x3800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1701 (ᜁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x0800, 0x0400, 0x0a00, 0x0800, 0x0800, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+1702 (ᜂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x4004, 0x3ff8, 0x0080, 0x0080, 0x3fc2, 0x403c, 0x4000, 0x2000, 0x0000, 0x0000, 0x0000 },	// U+1703 (ᜃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06f8, 0x0904, 0x0900, 0x0880, 0x0940, 0x0900, 0x0900, 0x0880, 0x307c, 0x0000, 0x0000, 0x0000 },	// U+1704 (ᜄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3072, 0x488a, 0x4784, 0x4080, 0x307c, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1705 (ᜅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3802, 0x4402, 0x4202, 0x0104, 0x00f8, 0x0010, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1706 (ᜆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3f02, 0x40c2, 0x4034, 0x0c0c, 0x1208, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1707 (ᜇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0490, 0x0888, 0x0848, 0x0080, 0x0100, 0x0080, 0x0040, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1708 (ᜈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x301e, 0x4810, 0x4810, 0x0808, 0x1808, 0x2404, 0x0204, 0x0108, 0x00f0, 0x0000, 0x0000, 0x0000 },	// U+1709 (ᜉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0408, 0x0804, 0x1002, 0x1002, 0x1002, 0x1082, 0x0944, 0x0638, 0x0000, 0x0000, 0x0000 },	// U+170A (ᜊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x1000, 0x100e, 0x0bd0, 0x0c30, 0x0410, 0x0210, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+170B (ᜋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x5000, 0x500c, 0x3812, 0x0810, 0x0410, 0x0210, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+170C (ᜌ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6db6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+170D (ᜍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3e02, 0x41c2, 0x413c, 0x0080, 0x0100, 0x0080, 0x0080, 0x0100, 0x00c0, 0x0000, 0x0000, 0x0000 },	// U+170E (ᜎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0820, 0x1000, 0x1000, 0x1080, 0x10c0, 0x0930, 0x0600, 0x0000, 0x0000, 0x0000 },	// U+170F (ᜏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4800, 0x441c, 0x2410, 0x5210, 0x4220, 0x4120, 0x2140, 0x18c0, 0x0000, 0x0000, 0x0000 },	// U+1710 (ᜐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3800, 0x4608, 0x4184, 0x4064, 0x3018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1711 (ᜑ)
	{ 0x0000, 0x3000, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1712 (ᜒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x1800, 0x0000 },	// U+1713 (ᜓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x0080 },	// U+1714 (᜔)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61de, 0x7dce, 0x61de, 0x6fde, 0x618e, 0x7ffe, 0x0000 },	// U+1715 (᜕)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x0000 },	// U+1716 (᜖)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x0000 },	// U+1717 (᜗)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x0000 },	// U+1718 (᜘)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x0000 },	// U+1719 (᜙)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x0000 },	// U+171A (᜚)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x0000 },	// U+171B (᜛)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x0000 },	// U+171C (᜜)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x71de, 0x6dce, 0x6dde, 0x6dde, 0x718e, 0x7ffe, 0x0000 },	// U+171D (᜝)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x618e, 0x7ffe, 0x0000 },	// U+171E (᜞)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x0000 },	// U+171F (ᜟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x1000, 0x0818, 0x0416, 0x0210, 0x0110, 0x0090, 0x0050, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+1720 (ᜠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x1000, 0x0818, 0x0416, 0x1210, 0x0910, 0x0490, 0x0050, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+1721 (ᜡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0200, 0x0100, 0x0080, 0x0fe0, 0x0400, 0x0200, 0x0100, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1722 (ᜢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0708, 0x0888, 0x0850, 0x0460, 0x03a0, 0x0010, 0x0010, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1723 (ᜣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0808, 0x0c08, 0x0a08, 0x0908, 0x0888, 0x0848, 0x0828, 0x0818, 0x0808, 0x0000, 0x0000, 0x0000 },	// U+1724 (ᜤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0808, 0x0408, 0x0208, 0x0108, 0x0288, 0x0448, 0x0028, 0x0018, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+1725 (ᜥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0108, 0x1188, 0x1188, 0x0948, 0x0948, 0x0528, 0x0528, 0x0318, 0x0108, 0x0000, 0x0000, 0x0000 },	// U+1726 (ᜦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1010, 0x0810, 0x0410, 0x0200, 0x011c, 0x0090, 0x0050, 0x0030, 0x0010, 0x0000, 0x0000, 0x0000 },	// U+1727 (ᜧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x18e2, 0x175c, 0x1040, 0x1040, 0x1040, 0x1040, 0x1040, 0x1040, 0x1040, 0x0000, 0x0000, 0x0000 },	// U+1728 (ᜨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x101e, 0x1010, 0x0810, 0x1810, 0x2410, 0x0210, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+1729 (ᜩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03fc, 0x0200, 0x0100, 0x0100, 0x0080, 0x0080, 0x0040, 0x0040, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+172A (ᜪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2030, 0x106c, 0x10a0, 0x0910, 0x0a10, 0x0410, 0x0a10, 0x1110, 0x00f0, 0x0000, 0x0000, 0x0000 },	// U+172B (ᜫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1008, 0x1814, 0x1412, 0x1210, 0x1110, 0x1090, 0x1050, 0x1030, 0x1010, 0x0000, 0x0000, 0x0000 },	// U+172C (ᜬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+172D (ᜭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0084, 0x00c4, 0x00c4, 0x00a4, 0x00a4, 0x0694, 0x0994, 0x088c, 0x0404, 0x0000, 0x0000, 0x0000 },	// U+172E (ᜮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x020c, 0x4312, 0x2510, 0x1890, 0x0088, 0x0048, 0x0048, 0x0028, 0x0018, 0x0000, 0x0000, 0x0000 },	// U+172F (ᜯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0600, 0x0618, 0x0516, 0x0510, 0x2490, 0x3290, 0x2e50, 0x4030, 0x0000, 0x0000, 0x0000 },	// U+1730 (ᜰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1008, 0x0810, 0x0410, 0x0210, 0x0110, 0x0090, 0x0048, 0x0028, 0x0018, 0x0000, 0x0000, 0x0000 },	// U+1731 (ᜱ)
	{ 0x0000, 0x0000, 0x3c00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1732 (ᜲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x0000 },	// U+1733 (ᜳ)
	{ 0x0000, 0x0000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2000, 0x2000, 0x1000, 0x0c00, 0x03f8 },	// U+1734 (᜴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0100, 0x0100, 0x0080, 0x0080, 0x0040, 0x0040, 0x0020, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+1735 (᜵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1080, 0x0840, 0x0840, 0x0420, 0x0420, 0x0210, 0x0210, 0x0108, 0x0108, 0x0000, 0x0000, 0x0000 },	// U+1736 (᜶)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61c6, 0x6fbe, 0x778e, 0x7bbe, 0x7bc6, 0x7ffe, 0x0000 },	// U+1737 (᜷)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x73c6, 0x6dbe, 0x738e, 0x6dbe, 0x73c6, 0x7ffe, 0x0000 },	// U+1738 (᜸)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x73c6, 0x6dbe, 0x638e, 0x6fbe, 0x73c6, 0x7ffe, 0x0000 },	// U+1739 (᜹)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61c6, 0x6dbe, 0x618e, 0x6dbe, 0x6dc6, 0x7ffe, 0x0000 },	// U+173A (᜺)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x718e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+173B (᜻)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x63c6, 0x7dbe, 0x7d8e, 0x7dbe, 0x63c6, 0x7ffe, 0x0000 },	// U+173C (᜼)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x6d8e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+173D (᜽)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61c6, 0x7dbe, 0x718e, 0x7dbe, 0x61c6, 0x7ffe, 0x0000 },	// U+173E (᜾)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61c6, 0x7dbe, 0x718e, 0x7dbe, 0x7dc6, 0x7ffe, 0x0000 },	// U+173F (᜿)
	{ 0x0000, 0x1000, 0x1000, 0x0800, 0x081c, 0x041c, 0x0410, 0x0210, 0x03f0, 0x01f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1740 (ᝀ)
	{ 0x0000, 0x1000, 0x1000, 0x0800, 0x081c, 0x041c, 0x0410, 0x0210, 0x03f0, 0x01f0, 0x0000, 0x00f8, 0x00f8, 0x0000, 0x0000, 0x0000 },	// U+1741 (ᝁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x01f0, 0x0100, 0x0f00, 0x0780, 0x0200, 0x0200, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+1742 (ᝂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fc0, 0x0fc0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x01f8, 0x0000, 0x0000, 0x0000 },	// U+1743 (ᝃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0040, 0x0020, 0x0fe0, 0x0fe0, 0x0800, 0x0400, 0x0400, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+1744 (ᝄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0fe0, 0x0400, 0x0400, 0x3e00, 0x3e00, 0x0100, 0x01f8, 0x01f8, 0x0000, 0x0000, 0x0000 },	// U+1745 (ᝅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4788, 0x4788, 0x4488, 0x2244, 0x2244, 0x2244, 0x1122, 0x1f3e, 0x1f3e, 0x0000, 0x0000, 0x0000 },	// U+1746 (ᝆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1080, 0x1080, 0x1080, 0x087c, 0x087c, 0x0840, 0x0420, 0x07e0, 0x07e0, 0x0000, 0x0000, 0x0000 },	// U+1747 (ᝇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1fe0, 0x1fe0, 0x0200, 0x0100, 0x0100, 0x0100, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1748 (ᝈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3c3c, 0x3c3c, 0x0420, 0x0210, 0x0210, 0x0210, 0x0108, 0x01f8, 0x01f8, 0x0000, 0x0000, 0x0000 },	// U+1749 (ᝉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x07f0, 0x0400, 0x0400, 0x0200, 0x0200, 0x03f0, 0x03f0, 0x0000, 0x0000, 0x0000 },	// U+174A (ᝊ)
	{ 0x0000, 0x0000, 0x1000, 0x1000, 0x0800, 0x0820, 0x0fe0, 0x0fe0, 0x0410, 0x0410, 0x0410, 0x07f8, 0x03f8, 0x0000, 0x0000, 0x0000 },	// U+174B (ᝋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3e7c, 0x3e7c, 0x2240, 0x1120, 0x1120, 0x1120, 0x0890, 0x08f0, 0x08f0, 0x0000, 0x0000, 0x0000 },	// U+174C (ᝌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+174D (ᝍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f80, 0x0f80, 0x0880, 0x0844, 0x0444, 0x07fc, 0x07fc, 0x0020, 0x0020, 0x0010, 0x0010, 0x0000 },	// U+174E (ᝎ)
	{ 0x0000, 0x0000, 0x0020, 0x0020, 0x1f10, 0x1f10, 0x1110, 0x1088, 0x0808, 0x0ff8, 0x0ff8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+174F (ᝏ)
	{ 0x0000, 0x0000, 0x007c, 0x007c, 0x0040, 0x0020, 0x03e0, 0x03e0, 0x0200, 0x0100, 0x1f00, 0x1f00, 0x1000, 0x0800, 0x0800, 0x0400 },	// U+1750 (ᝐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0040, 0x0040, 0x0020, 0x0020, 0x0020, 0x0010, 0x07f0, 0x07f0, 0x0000, 0x0000, 0x0000 },	// U+1751 (ᝑ)
	{ 0x0000, 0x3e00, 0x3e00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1752 (ᝒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f00, 0x1f00, 0x0000 },	// U+1753 (ᝓ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x6186, 0x6fbe, 0x6f86, 0x7ffe, 0x0000 },	// U+1754 (᝔)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x6186, 0x6fbe, 0x6186, 0x7ffe, 0x0000 },	// U+1755 (᝕)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x7186, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+1756 (᝖)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x7786, 0x7bbe, 0x7b86, 0x7ffe, 0x0000 },	// U+1757 (᝗)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x7386, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+1758 (᝘)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6386, 0x6fbe, 0x7386, 0x7ffe, 0x0000 },	// U+1759 (᝙)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x6186, 0x6dbe, 0x6d86, 0x7ffe, 0x0000 },	// U+175A (᝚)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x7186, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+175B (᝛)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7d86, 0x7dbe, 0x6386, 0x7ffe, 0x0000 },	// U+175C (᝜)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6d86, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+175D (᝝)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+175E (᝞)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x7d86, 0x7ffe, 0x0000 },	// U+175F (᝟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x5000, 0x100c, 0x0812, 0x0810, 0x0410, 0x0210, 0x0110, 0x00e8, 0x0004, 0x0004, 0x0008 },	// U+1760 (ᝠ)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x6400, 0x1200, 0x100c, 0x0812, 0x0810, 0x0410, 0x0210, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+1761 (ᝡ)
}; // 105

static const uint16_t unifontdw_block101[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x180c, 0x0410, 0x0220, 0x0140, 0x0080, 0x0140, 0x0220, 0x0410, 0x1808, 0x0000, 0x0000, 0x0000 },	// U+1763 (ᝣ)
	{ 0x0000, 0x0000, 0x0000, 0x07f0, 0x188c, 0x2102, 0x0080, 0x0040, 0x0080, 0x0100, 0x0080, 0x0040, 0x0080, 0x0100, 0x0080, 0x0000 },	// U+1764 (ᝤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3802, 0x4404, 0x43f8, 0x2004, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1765 (ᝥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0004, 0x0002, 0x1c01, 0x2202, 0x21fc, 0x1002, 0x0001, 0x0002, 0x0004, 0x0002, 0x0000 },	// U+1766 (ᝦ)
	{ 0x0000, 0x0000, 0x0700, 0x0080, 0x6040, 0x1020, 0x102c, 0x0812, 0x0810, 0x0410, 0x0210, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+1767 (ᝧ)
	{ 0x0000, 0x0000, 0x0000, 0x07f0, 0x188c, 0x2082, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+1768 (ᝨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x1000, 0x100c, 0x0812, 0x0810, 0x1410, 0x2210, 0x4110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+1769 (ᝩ)
	{ 0x0000, 0x0000, 0x0000, 0x0fe0, 0x1010, 0x2008, 0x2004, 0x2004, 0x2004, 0x2004, 0x1004, 0x0808, 0x07f0, 0x0000, 0x0000, 0x0000 },	// U+176A (ᝪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x1000, 0x13cc, 0x0c32, 0x0810, 0x0410, 0x0210, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+176B (ᝫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4800, 0x480c, 0x2412, 0x0410, 0x0210, 0x0210, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+176C (ᝬ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x71ce, 0x6df6, 0x6dc6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+176D (᝭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7000, 0x0800, 0x080c, 0x0412, 0x0410, 0x2a10, 0x5a10, 0x3510, 0x68e0, 0x1000, 0x0000, 0x0000 },	// U+176E (ᝮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0430, 0x0408, 0x0004, 0x0002, 0x0002, 0x3f82, 0x4062, 0x401c, 0x0000, 0x0000, 0x0000 },	// U+176F (ᝯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0a00, 0x0a0c, 0x0912, 0x0510, 0x1890, 0x0890, 0x3090, 0x1060, 0x0000, 0x0000, 0x0000 },	// U+1770 (ᝰ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7786, 0x73be, 0x77de, 0x77ee, 0x63ee, 0x7ffe, 0x0000 },	// U+1771 (᝱)
	{ 0x0000, 0x1000, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1772 (ᝲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x0000 },	// U+1773 (ᝳ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6d86, 0x6dbe, 0x61de, 0x6fee, 0x6fee, 0x7ffe, 0x0000 },	// U+1774 (᝴)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x61de, 0x6fee, 0x61ee, 0x7ffe, 0x0000 },	// U+1775 (᝵)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7386, 0x7dbe, 0x71de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+1776 (᝶)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x77de, 0x7bee, 0x7bee, 0x7ffe, 0x0000 },	// U+1777 (᝷)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x73de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+1778 (᝸)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x63de, 0x6fee, 0x73ee, 0x7ffe, 0x0000 },	// U+1779 (᝹)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x61de, 0x6dee, 0x6dee, 0x7ffe, 0x0000 },	// U+177A (᝺)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x71de, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+177B (᝻)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7dde, 0x7dee, 0x63ee, 0x7ffe, 0x0000 },	// U+177C (᝼)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+177D (᝽)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+177E (᝾)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+177F (᝿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06e0, 0x0910, 0x0020, 0x0ff0, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0000, 0x0000, 0x0000 },	// U+1780 (ក)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0420, 0x0440, 0x0200, 0x01c0, 0x0420, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+1781 (ខ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06e0, 0x0910, 0x0020, 0x0ff0, 0x0810, 0x0810, 0x0990, 0x0950, 0x0830, 0x0000, 0x0000, 0x0000 },	// U+1782 (គ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1998, 0x0454, 0x0cd4, 0x0890, 0x0890, 0x0890, 0x0890, 0x0890, 0x0760, 0x0000, 0x0000, 0x0000 },	// U+1783 (ឃ)
	{ 0x0000, 0x0000, 0x0020, 0x0040, 0x0140, 0x02c0, 0x0180, 0x0200, 0x0460, 0x0450, 0x0550, 0x06c0, 0x0440, 0x0000, 0x0000, 0x0000 },	// U+1784 (ង)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0370, 0x0488, 0x0008, 0x0c18, 0x0a10, 0x0a10, 0x0c10, 0x0810, 0x0ff0, 0x0000, 0x0000, 0x0000 },	// U+1785 (ច)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06e0, 0x0910, 0x0008, 0x0e10, 0x0910, 0x0e78, 0x0894, 0x0894, 0x0708, 0x0000, 0x0000, 0x0000 },	// U+1786 (ឆ)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x08c0, 0x0920, 0x0610, 0x0030, 0x0220, 0x0220, 0x02a0, 0x0360, 0x0220, 0x0000, 0x0000, 0x0000 },	// U+1787 (ជ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x6638, 0x1144, 0x3344, 0x2244, 0x2244, 0x224c, 0x2254, 0x2254, 0x1d8c, 0x0000, 0x0000, 0x0000 },	// U+1788 (ឈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1db0, 0x2248, 0x2208, 0x2208, 0x2208, 0x2218, 0x2228, 0x2228, 0x2218, 0x0800, 0x10e0, 0x0f10 },	// U+1789 (ញ)
	{ 0x0000, 0x0000, 0x01c0, 0x0200, 0x04c0, 0x0420, 0x03c0, 0x0000, 0x0440, 0x0440, 0x0540, 0x06c0, 0x0440, 0x0000, 0x0000, 0x0000 },	// U+178A (ដ)
	{ 0x0000, 0x0800, 0x1400, 0x1000, 0x1830, 0x0428, 0x0c28, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+178B (ឋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0770, 0x0888, 0x0808, 0x0410, 0x0300, 0x08c0, 0x0c30, 0x0c08, 0x0bf0, 0x0000, 0x0000, 0x0000 },	// U+178C (ឌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x60d8, 0x1124, 0x3104, 0x2104, 0x2104, 0x238c, 0x2554, 0x2554, 0x198c, 0x0000, 0x0000, 0x0000 },	// U+178D (ឍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c38, 0x2244, 0x2644, 0x2444, 0x2444, 0x244c, 0x2554, 0x26d4, 0x244c, 0x0000, 0x0000, 0x0000 },	// U+178E (ណ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06e0, 0x0910, 0x0020, 0x07f0, 0x0410, 0x0430, 0x0450, 0x0450, 0x0430, 0x0000, 0x0000, 0x0000 },	// U+178F (ត)
	{ 0x0000, 0x0000, 0x0400, 0x0800, 0x08c0, 0x0720, 0x0010, 0x0630, 0x0520, 0x0520, 0x0620, 0x0420, 0x07e0, 0x0000, 0x0000, 0x0000 },	// U+1790 (ថ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1fc0, 0x2020, 0x1010, 0x0610, 0x0920, 0x07c0, 0x0100, 0x0110, 0x01f0, 0x0000, 0x0000, 0x0000 },	// U+1791 (ទ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0370, 0x0488, 0x0008, 0x0c18, 0x0a10, 0x0a10, 0x0c90, 0x0950, 0x0e30, 0x0000, 0x0000, 0x0000 },	// U+1792 (ធ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0220, 0x0020, 0x03c0, 0x0200, 0x02a0, 0x0360, 0x0220, 0x0000, 0x0000, 0x0000 },	// U+1793 (ន)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1860, 0x0410, 0x0c30, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+1794 (ប)
	{ 0x0000, 0x0000, 0x0400, 0x08c0, 0x0920, 0x0610, 0x0010, 0x0c10, 0x0a10, 0x0a10, 0x0c90, 0x0950, 0x0e30, 0x0000, 0x0000, 0x0000 },	// U+1795 (ផ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ee0, 0x1110, 0x1010, 0x1010, 0x1010, 0x1030, 0x1050, 0x1050, 0x1030, 0x0000, 0x0000, 0x0000 },	// U+1796 (ព)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06e0, 0x0910, 0x0020, 0x0000, 0x0fc0, 0x0840, 0x0850, 0x0848, 0x0870, 0x0000, 0x0000, 0x0000 },	// U+1797 (ភ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c30, 0x0208, 0x0618, 0x0410, 0x0410, 0x07f0, 0x0410, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+1798 (ម)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3310, 0x08a8, 0x19a8, 0x1118, 0x1108, 0x1108, 0x1108, 0x1108, 0x0ef8, 0x0000, 0x0000, 0x0000 },	// U+1799 (យ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0080, 0x0180, 0x0100, 0x0100, 0x0100, 0x0140, 0x0120, 0x00c0, 0x0000, 0x0000, 0x0000 },	// U+179A (រ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x30f0, 0x0908, 0x1908, 0x1108, 0x1108, 0x1118, 0x1128, 0x1128, 0x0e18, 0x0000, 0x0000, 0x0000 },	// U+179B (ល)
	{ 0x0000, 0x0200, 0x0500, 0x0400, 0x0700, 0x0480, 0x0180, 0x0100, 0x0100, 0x0100, 0x0140, 0x0120, 0x00c0, 0x0000, 0x0000, 0x0000 },	// U+179C (វ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06e0, 0x0910, 0x0020, 0x07f0, 0x0410, 0x1510, 0x0e50, 0x04b0, 0x0430, 0x0000, 0x0000, 0x0000 },	// U+179D (ឝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c30, 0x0208, 0x0618, 0x0410, 0x1510, 0x0e10, 0x0410, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+179E (ឞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1830, 0x0408, 0x0c18, 0x08f0, 0x0888, 0x0898, 0x08a8, 0x08a8, 0x0718, 0x0000, 0x0000, 0x0000 },	// U+179F (ស)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1e30, 0x2108, 0x2318, 0x2210, 0x2210, 0x2210, 0x2210, 0x2210, 0x21e0, 0x0000, 0x0000, 0x0000 },	// U+17A0 (ហ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x63f8, 0x1404, 0x3202, 0x20c2, 0x2124, 0x20f8, 0x2022, 0x203e, 0x2380, 0x2a40, 0x3680, 0x2200 },	// U+17A1 (ឡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1860, 0x0410, 0x0c30, 0x0820, 0x0fe0, 0x0820, 0x0a28, 0x0924, 0x0e38, 0x0000, 0x0000, 0x0000 },	// U+17A2 (អ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1860, 0x0410, 0x0c30, 0x0820, 0x0fe0, 0x0820, 0x0a28, 0x0924, 0x0e38, 0x0000, 0x0000, 0x0000 },	// U+17A3 (ឣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1e30, 0x2108, 0x2318, 0x2210, 0x23f0, 0x2210, 0x2294, 0x2252, 0x239c, 0x0000, 0x0000, 0x0000 },	// U+17A4 (ឤ)
	{ 0x0000, 0x0000, 0x0400, 0x08c0, 0x0920, 0x0640, 0x0000, 0x0fe0, 0x0820, 0x0860, 0x08a0, 0x08a0, 0x0860, 0x0000, 0x0000, 0x0000 },	// U+17A5 (ឥ)
	{ 0x0000, 0x2000, 0x5000, 0x4000, 0x7000, 0x4800, 0x19f8, 0x1108, 0x1138, 0x1148, 0x1138, 0x1000, 0x11f8, 0x1118, 0x1128, 0x1f18 },	// U+17A6 (ឦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0420, 0x0440, 0x0200, 0x09c0, 0x0c20, 0x0a20, 0x09c0, 0x0000, 0x0000, 0x0000 },	// U+17A7 (ឧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06e0, 0x0910, 0x0020, 0x03c0, 0x0420, 0x0200, 0x09c0, 0x0c20, 0x0bc0, 0x0000, 0x0000, 0x0000 },	// U+17A8 (ឨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0088, 0x0108, 0x0910, 0x0880, 0x0a70, 0x0b08, 0x0a88, 0x0a70, 0x0000, 0x0000, 0x0000 },	// U+17A9 (ឩ)
	{ 0x0080, 0x0100, 0x0200, 0x02e0, 0x0310, 0x0260, 0x0080, 0x03c0, 0x0420, 0x0200, 0x09c0, 0x0c20, 0x0bc0, 0x0000, 0x0000, 0x0000 },	// U+17AA (ឪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1860, 0x0410, 0x0c30, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x07c0, 0x0c00, 0x10e0, 0x0f10 },	// U+17AB (ឫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1860, 0x0410, 0x0c30, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x07c0, 0x0c00, 0x10e0, 0x6f10 },	// U+17AC (ឬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ee0, 0x1110, 0x1010, 0x1010, 0x1010, 0x1030, 0x1050, 0x1050, 0x1030, 0x0600, 0x08e0, 0x0710 },	// U+17AD (ឭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ee0, 0x1110, 0x1010, 0x1010, 0x1010, 0x1030, 0x1050, 0x1050, 0x1030, 0x0600, 0x08e0, 0x3710 },	// U+17AE (ឮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x0080, 0x0e80, 0x0980, 0x0800, 0x08e0, 0x0a90, 0x0da0, 0x0880, 0x0000, 0x0000, 0x0000 },	// U+17AF (ឯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ee0, 0x1110, 0x1010, 0x1010, 0x1030, 0x1050, 0x1050, 0x1030, 0x0000, 0x1fc0, 0x0920, 0x06c0 },	// U+17B0 (ឰ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0460, 0x0080, 0x03c0, 0x0420, 0x0200, 0x09c0, 0x0c20, 0x0bc0, 0x0000, 0x0000, 0x0000 },	// U+17B1 (ឱ)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x07e0, 0x0010, 0x0710, 0x0890, 0x0890, 0x0410, 0x0810, 0x0810, 0x07e0, 0x0000, 0x0000, 0x0000 },	// U+17B2 (ឲ)
	{ 0x0000, 0x0000, 0x0000, 0x11c0, 0x0a20, 0x0460, 0x0080, 0x03c0, 0x0420, 0x0200, 0x09c0, 0x0c20, 0x0bc0, 0x0000, 0x0000, 0x0000 },	// U+17B3 (ឳ)
	{ 0x5555, 0x8000, 0x22a5, 0xa294, 0x148d, 0x9494, 0x08a5, 0x8000, 0x0001, 0x8e10, 0x1129, 0x9544, 0x197d, 0x9e44, 0x2001, 0xaaaa },	// U+17B4 (឴)
	{ 0x5555, 0x8000, 0x22a5, 0xa294, 0x148d, 0x9494, 0x08a5, 0x8000, 0x0001, 0x8810, 0x1429, 0xa244, 0x3e7d, 0xa244, 0x0001, 0xaaaa },	// U+17B5 (឵)
	{ 0x0000, 0x0000, 0x0000, 0x7800, 0x4400, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+17B6 (ា)
	{ 0x0000, 0x01c0, 0x0220, 0x1fc0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17B7 (ិ)
	{ 0x0000, 0x09c0, 0x0a20, 0x0fc0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17B8 (ី)
	{ 0x0000, 0x09c0, 0x1620, 0x1fc0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17B9 (ឹ)
	{ 0x0a00, 0x0bc0, 0x0e20, 0x1fc0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17BA (ឺ)
}; // 88

static const uint16_t unifontdw_block102[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0240, 0x03c0 },	// U+17BC (ូ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x0540, 0x06c0 },	// U+17BD (ួ)
	{ 0x0000, 0x09c0, 0x0a20, 0x0fc0, 0x0003, 0x0005, 0x0001, 0x0001, 0x0001, 0x0003, 0x0005, 0x0005, 0x0003, 0x0000, 0x0000, 0x0000 },	// U+17BE (ើ)
	{ 0x0a00, 0x0bc0, 0x0e20, 0x7fc0, 0x8003, 0x8005, 0x8001, 0x8001, 0x8001, 0x8003, 0x8005, 0x8005, 0x8003, 0xe008, 0x8010, 0x7fe0 },	// U+17BF (ឿ)
	{ 0x1800, 0x1000, 0x0800, 0x7c00, 0x8003, 0x8005, 0x8001, 0x8001, 0x8001, 0x8003, 0x8005, 0x8005, 0x8003, 0xe008, 0x8010, 0x7fe0 },	// U+17C0 (ៀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0005, 0x0001, 0x0001, 0x0001, 0x0003, 0x0005, 0x0005, 0x0003, 0x0000, 0x0000, 0x0000 },	// U+17C1 (េ)
	{ 0x0018, 0x0011, 0x000e, 0x0000, 0x0003, 0x0005, 0x0001, 0x0001, 0x0001, 0x0003, 0x0005, 0x0005, 0x0003, 0x0000, 0x0000, 0x0000 },	// U+17C2 (ែ)
	{ 0x0019, 0x0026, 0x0022, 0x0018, 0x0003, 0x0005, 0x0001, 0x0001, 0x0001, 0x0003, 0x0005, 0x0005, 0x0003, 0x0000, 0x0000, 0x0000 },	// U+17C3 (ៃ)
	{ 0x0000, 0x0000, 0x0000, 0x7800, 0x4403, 0x4005, 0x4001, 0x4001, 0x4001, 0x4003, 0x4005, 0x4005, 0x4003, 0x0000, 0x0000, 0x0000 },	// U+17C4 (ោ)
	{ 0x2000, 0x4000, 0x4000, 0x7800, 0x4403, 0x4005, 0x4001, 0x4001, 0x4001, 0x4003, 0x4005, 0x4005, 0x4003, 0x0000, 0x0000, 0x0000 },	// U+17C5 (ៅ)
	{ 0x0180, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17C6 (ំ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x4000, 0xa000, 0xa000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+17C7 (ះ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x0000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17C8 (ៈ)
	{ 0x0000, 0x0280, 0x0280, 0x0280, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17C9 (៉)
	{ 0x06e0, 0x0910, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17CA (៊)
}; // 15

static const uint16_t unifontdw_block103[][16] = {
	{ 0x11c0, 0x0a20, 0x0440, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17CC (៌)
	{ 0x11c0, 0x0a20, 0x0440, 0x0580, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17CD (៍)
	{ 0x0100, 0x07c0, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17CE (៎)
	{ 0x6780, 0x3840, 0x0540, 0x06c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17CF (៏)
	{ 0x3000, 0x2200, 0x1c00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17D0 (័)
	{ 0x0000, 0x0ff0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17D1 (៑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x0080, 0x0000 },	// U+17D2 (្)
	{ 0x01c0, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17D3 (៓)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0190, 0x0148, 0x0130, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+17D4 (។)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0160, 0x0164, 0x0152, 0x014c, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0000, 0x0000, 0x0000 },	// U+17D5 (៕)
}; // 10

static const uint16_t unifontdw_block104[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1084, 0x101c, 0x1024, 0x101c, 0x1000, 0x1000, 0x1004, 0x1004, 0x0ff8, 0x0000, 0x0000 },	// U+17D7 (ៗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xd8cc, 0xd52d, 0xa52a, 0x8928, 0x8928, 0x8a68, 0x8aa8, 0x8aa8, 0x8c68, 0x0000, 0x0000, 0x0000 },	// U+17D8 (៘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0490, 0x0550, 0x0550, 0x0550, 0x0490, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+17D9 (៙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x008e, 0x1151, 0xa955, 0x4a49, 0x0a22, 0x041c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17DA (៚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0080, 0x0180, 0x0100, 0x07c0, 0x0100, 0x0140, 0x0120, 0x00c0, 0x0000, 0x0000, 0x0000 },	// U+17DB (៛)
}; // 5

static const uint16_t unifontdw_block105[][16] = {
	{ 0x0000, 0x03c0, 0x0420, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+17DD (៝)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+17DE (៞)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+17DF (៟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+17E0 (០)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0890, 0x0860, 0x0800, 0x0800, 0x0800, 0x0870, 0x0788, 0x0000, 0x0000, 0x0000 },	// U+17E1 (១)
	{ 0x0000, 0x0004, 0x0004, 0x0004, 0x0ee4, 0x1114, 0x1034, 0x1054, 0x1054, 0x1034, 0x1004, 0x1004, 0x0ff8, 0x0000, 0x0000, 0x0000 },	// U+17E2 (២)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1084, 0x1084, 0x1084, 0x1084, 0x108c, 0x1094, 0x1094, 0x108c, 0x0000, 0x0000, 0x0000 },	// U+17E3 (៣)
	{ 0x0000, 0x0000, 0x0000, 0x2000, 0x1000, 0x17c0, 0x1820, 0x0310, 0x0490, 0x0110, 0x0210, 0x0410, 0x07e0, 0x0000, 0x0000, 0x0000 },	// U+17E4 (៤)
	{ 0x0000, 0x0060, 0x0890, 0x0490, 0x0450, 0x07e0, 0x0020, 0x0310, 0x0490, 0x0110, 0x0210, 0x0410, 0x07e0, 0x0000, 0x0000, 0x0000 },	// U+17E5 (៥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0010, 0x07d0, 0x0830, 0x0800, 0x0860, 0x0890, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+17E6 (៦)
	{ 0x0000, 0x4000, 0x2000, 0x2000, 0x23b8, 0x2444, 0x2404, 0x2404, 0x2404, 0x240c, 0x2414, 0x2414, 0x180c, 0x0000, 0x0000, 0x0000 },	// U+17E7 (៧)
	{ 0x0000, 0x1000, 0x0800, 0x0be0, 0x0c10, 0x0008, 0x0c08, 0x0a08, 0x0908, 0x0a08, 0x0808, 0x0bc8, 0x0c30, 0x0000, 0x0000, 0x0000 },	// U+17E8 (៨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x08f0, 0x0b08, 0x0c08, 0x0010, 0x00f8, 0x0104, 0x0224, 0x0c18, 0x0000, 0x0000, 0x0000 },	// U+17E9 (៩)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6d86, 0x7ffe, 0x0000 },	// U+17EA (៪)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+17EB (៫)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x6386, 0x7ffe, 0x0000 },	// U+17EC (៬)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+17ED (៭)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+17EE (៮)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7d86, 0x7ffe, 0x0000 },	// U+17EF (៯)
}; // 19

static const uint16_t unifontdw_block106[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+17FA (៺)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+17FB (៻)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+17FC (៼)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+17FD (៽)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+17FE (៾)
	{ 0x0000, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+17FF (៿)
	{ 0x0000, 0x0000, 0x01c0, 0x0220, 0x0420, 0x0420, 0x0420, 0x04c0, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0040, 0x0040, 0x0000 },	// U+1800 (᠀)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6666, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1801 (᠁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0380, 0x07c0, 0x0380, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1802 (᠂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x0810, 0x1c38, 0x3e7c, 0x1c38, 0x0810, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1803 (᠃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1804 (᠄)
	{ 0x0000, 0x0100, 0x0100, 0x0380, 0x07c0, 0x1388, 0x1108, 0x391c, 0x7c3e, 0x391c, 0x1108, 0x1388, 0x07c0, 0x0380, 0x0100, 0x0100 },	// U+1805 (᠅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1806 (᠆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x07e0, 0x0180, 0x0180, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1807 (᠇)
	{ 0x0000, 0x0000, 0x0000, 0x0020, 0x0040, 0x0080, 0x0180, 0x0180, 0x0180, 0x0180, 0x0080, 0x0040, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+1808 (᠈)
	{ 0x0000, 0x0000, 0x0000, 0x0208, 0x0410, 0x0820, 0x1860, 0x1860, 0x1860, 0x1860, 0x0820, 0x0410, 0x0208, 0x0000, 0x0000, 0x0000 },	// U+1809 (᠉)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+180A (᠊)
	{ 0x5555, 0x8000, 0x223d, 0xa204, 0x141d, 0x9404, 0x0805, 0x8000, 0x0001, 0x8838, 0x0c05, 0x8818, 0x0821, 0xbe1c, 0x0001, 0xaaaa },	// U+180B (᠋)
	{ 0x5555, 0x8000, 0x223d, 0xa204, 0x141d, 0x9404, 0x0805, 0x8000, 0x0001, 0x9e38, 0x2005, 0x9c18, 0x0221, 0xbe1c, 0x0001, 0xaaaa },	// U+180C (᠌)
	{ 0x5555, 0x8000, 0x223d, 0xa204, 0x141d, 0x9404, 0x0805, 0x8000, 0x0001, 0x9e38, 0x2005, 0x9c18, 0x2021, 0x9e1c, 0x0001, 0xaaaa },	// U+180D (᠍)
	{ 0x5555, 0x8000, 0x2245, 0xa26c, 0x1455, 0x9444, 0x0845, 0x8000, 0x0001, 0x8780, 0x0041, 0x8380, 0x0401, 0x83c0, 0x0001, 0xaaaa },	// U+180E (᠎)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71b6, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+180F (᠏)
	{ 0x0000, 0x0000, 0x03c0, 0x0420, 0x0420, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000 },	// U+1810 (᠐)
	{ 0x0000, 0x0000, 0x03c0, 0x0420, 0x0420, 0x0810, 0x0810, 0x0810, 0x0820, 0x0820, 0x0800, 0x0410, 0x0420, 0x03c0, 0x0000, 0x0000 },	// U+1811 (᠑)
	{ 0x0000, 0x0000, 0x03c0, 0x0420, 0x0420, 0x0810, 0x0810, 0x0810, 0x0810, 0x4810, 0x4810, 0x2420, 0x1c20, 0x0040, 0x0000, 0x0000 },	// U+1812 (᠒)
	{ 0x0000, 0x0000, 0x02c0, 0x0520, 0x0520, 0x0910, 0x0910, 0x0910, 0x0910, 0x4810, 0x4810, 0x2420, 0x1c20, 0x0040, 0x0000, 0x0000 },	// U+1813 (᠓)
	{ 0x0000, 0x0000, 0x03c0, 0x0420, 0x0400, 0x0840, 0x0820, 0x0820, 0x0810, 0x0810, 0x0810, 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000 },	// U+1814 (᠔)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0400, 0x0a00, 0x0a00, 0x1200, 0x1210, 0x2210, 0x2210, 0x4220, 0x4120, 0x00c0, 0x0000, 0x0000 },	// U+1815 (᠕)
	{ 0x0000, 0x0000, 0x03c0, 0x0020, 0x0020, 0x0110, 0x0110, 0x0710, 0x0910, 0x0910, 0x0810, 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000 },	// U+1816 (᠖)
	{ 0x0000, 0x0000, 0x07e0, 0x0810, 0x08c0, 0x1120, 0x1120, 0x1110, 0x1110, 0x1110, 0x1110, 0x0920, 0x0920, 0x0600, 0x0000, 0x0000 },	// U+1817 (᠗)
	{ 0x0000, 0x0000, 0x0000, 0x0200, 0x0200, 0x0100, 0x0100, 0x0080, 0x0080, 0x0840, 0x0840, 0x0420, 0x0420, 0x03e0, 0x0000, 0x0000 },	// U+1818 (᠘)
	{ 0x0000, 0x0000, 0x03c0, 0x0420, 0x0420, 0x0410, 0x0210, 0x0210, 0x0610, 0x0010, 0x0010, 0x0420, 0x0420, 0x03c0, 0x0000, 0x0000 },	// U+1819 (᠙)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x0000 },	// U+181A (᠚)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x0000 },	// U+181B (᠛)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x0000 },	// U+181C (᠜)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x71de, 0x6dce, 0x6dde, 0x6dde, 0x718e, 0x7ffe, 0x0000 },	// U+181D (᠝)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x618e, 0x7ffe, 0x0000 },	// U+181E (᠞)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x0000 },	// U+181F (᠟)
	{ 0x0000, 0x0000, 0x0000, 0x040c, 0x080a, 0x0808, 0x0808, 0x0478, 0x0478, 0x0448, 0x0248, 0x0288, 0x0300, 0x0000, 0x0000, 0x0000 },	// U+1820 (ᠠ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x01f8, 0x03f8, 0x0208, 0x0208, 0x0208, 0x0200, 0x0180, 0x0080, 0x0000 },	// U+1821 (ᠡ)
	{ 0x0000, 0x0000, 0x0000, 0x038c, 0x044a, 0x0448, 0x0448, 0x0078, 0x0078, 0x0048, 0x0048, 0x0088, 0x0100, 0x0200, 0x0000, 0x0000 },	// U+1822 (ᠢ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x07f8, 0x07f8, 0x0488, 0x0488, 0x0488, 0x0300, 0x0000, 0x0000, 0x0000 },	// U+1823 (ᠣ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x1ff8, 0x1ff8, 0x0488, 0x0488, 0x0488, 0x0300, 0x0000, 0x0000, 0x0000 },	// U+1824 (ᠤ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x3ff8, 0x7ff8, 0x6488, 0x4488, 0x4488, 0x0300, 0x0000, 0x0000, 0x0000 },	// U+1825 (ᠥ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x7ff8, 0x7ff8, 0x1488, 0x2488, 0x4488, 0x0300, 0x0000, 0x0000, 0x0000 },	// U+1826 (ᠦ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x3ff8, 0x7ff8, 0x6088, 0x4088, 0x4488, 0x0300, 0x0000, 0x0000, 0x0000 },	// U+1827 (ᠧ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x0038, 0x0038, 0x0008, 0x0008, 0x0008, 0x0000, 0x0008, 0x0008, 0x0000 },	// U+1828 (ᠨ)
	{ 0x0000, 0x0000, 0x0e00, 0x1100, 0x1080, 0x1080, 0x1080, 0x00f8, 0x00f8, 0x0098, 0x0088, 0x0108, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+1829 (ᠩ)
	{ 0x0000, 0x0000, 0x0000, 0x01f0, 0x0208, 0x0208, 0x0208, 0x0278, 0x0278, 0x0048, 0x0048, 0x0048, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+182A (ᠪ)
	{ 0x0000, 0x0000, 0x0000, 0x01f0, 0x0208, 0x0208, 0x0208, 0x0278, 0x0278, 0x0240, 0x0040, 0x0040, 0x0078, 0x0038, 0x0000, 0x0000 },	// U+182B (ᠫ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0220, 0x0220, 0x0ff8, 0x0ff8, 0x0220, 0x0240, 0x0260, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+182C (ᠬ)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0220, 0x0220, 0x0ff8, 0x0ff8, 0x0220, 0x0240, 0x0260, 0x0200, 0x0060, 0x0000, 0x0060 },	// U+182D (ᠭ)
	{ 0x0000, 0x0020, 0x0020, 0x0018, 0x0008, 0x000c, 0x000a, 0x0038, 0x0038, 0x0008, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+182E (ᠮ)
	{ 0x0000, 0x0002, 0x0002, 0x000c, 0x0008, 0x000c, 0x000a, 0x0038, 0x0038, 0x0008, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+182F (ᠯ)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x0028, 0x0028, 0x002a, 0x00e4, 0x00e0, 0x0020, 0x0020, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1830 (ᠰ)
	{ 0x0000, 0x00d8, 0x00d8, 0x0000, 0x0030, 0x0028, 0x0028, 0x00ea, 0x00e4, 0x0020, 0x0020, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1831 (ᠱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0014, 0x0022, 0x01e1, 0x01e2, 0x0074, 0x0028, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1832 (ᠲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x0008, 0x03f8, 0x03f8, 0x0008, 0x0048, 0x00a8, 0x0090, 0x0060, 0x0000, 0x0000 },	// U+1833 (ᠳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0ff8, 0x0200, 0x0200, 0x03c0, 0x03e0, 0x0020, 0x0000, 0x0000 },	// U+1834 (ᠴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x00f8, 0x0008, 0x0008, 0x0010, 0x0010, 0x0020, 0x0020, 0x0000 },	// U+1835 (ᠵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x00f8, 0x0008, 0x0008, 0x0010, 0x0020, 0x0010, 0x0000, 0x0000 },	// U+1836 (ᠶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x00f8, 0x0008, 0x0008, 0x0010, 0x0010, 0x0028, 0x0024, 0x0000 },	// U+1837 (ᠷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x00f8, 0x0008, 0x0008, 0x0048, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+1838 (ᠸ)
	{ 0x0000, 0x0000, 0x0000, 0x01f0, 0x0208, 0x0208, 0x0208, 0x0278, 0x0278, 0x0048, 0x0048, 0x0048, 0x0030, 0x0008, 0x0008, 0x0000 },	// U+1839 (ᠹ)
	{ 0x0000, 0x0000, 0x0000, 0x00f0, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0008, 0x0008, 0x0018, 0x0028, 0x0028, 0x0000, 0x0000 },	// U+183A (ᠺ)
	{ 0x0000, 0x0000, 0x0000, 0x00f0, 0x0108, 0x0108, 0x0108, 0x0138, 0x0138, 0x0008, 0x0008, 0x0018, 0x0028, 0x0028, 0x0000, 0x0000 },	// U+183B (ᠻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0ff8, 0x0080, 0x0080, 0x0380, 0x04e0, 0x0370, 0x0000, 0x0000 },	// U+183C (ᠼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0ff8, 0x0080, 0x0080, 0x0080, 0x04e0, 0x0370, 0x0000, 0x0000 },	// U+183D (ᠽ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x1e78, 0x1e78, 0x0248, 0x0248, 0x0448, 0x0280, 0x0100, 0x0000, 0x0000 },	// U+183E (ᠾ)
	{ 0x0000, 0x0000, 0x0018, 0x0024, 0x0022, 0x0032, 0x002a, 0x00e2, 0x00e2, 0x0022, 0x0022, 0x000a, 0x0012, 0x000c, 0x0000, 0x0000 },	// U+183F (ᠿ)
	{ 0x0000, 0x0000, 0x0002, 0x000c, 0x0008, 0x000c, 0x000a, 0x1e78, 0x1e78, 0x0248, 0x0248, 0x0448, 0x0280, 0x0100, 0x0000, 0x0000 },	// U+1840 (ᡀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c8, 0x03c8, 0x0048, 0x0048, 0x0088, 0x0050, 0x0020, 0x0000, 0x0000 },	// U+1841 (ᡁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ff8, 0x3ff8, 0x0948, 0x0948, 0x0948, 0x0630, 0x0000, 0x0000, 0x0000 },	// U+1842 (ᡂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x0008, 0x0038, 0x0038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1843 (ᡃ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x03f8, 0x03f8, 0x0048, 0x0048, 0x0048, 0x0188, 0x0000, 0x0000, 0x0000 },	// U+1844 (ᡄ)
	{ 0x0000, 0x0000, 0x00c0, 0x014c, 0x024a, 0x0248, 0x0448, 0x0478, 0x0478, 0x0448, 0x0248, 0x0248, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1845 (ᡅ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x03f8, 0x03f8, 0x0248, 0x0248, 0x0248, 0x0388, 0x0000, 0x0000, 0x0000 },	// U+1846 (ᡆ)
	{ 0x0000, 0x0000, 0x0000, 0x078c, 0x084a, 0x1048, 0x1048, 0x13f8, 0x13f8, 0x0248, 0x0248, 0x0248, 0x0188, 0x0100, 0x0600, 0x0000 },	// U+1847 (ᡇ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x008a, 0x0108, 0x0108, 0x03f8, 0x03f8, 0x0248, 0x0248, 0x0248, 0x0388, 0x0000, 0x0000, 0x0000 },	// U+1848 (ᡈ)
	{ 0x0000, 0x0000, 0x0000, 0x078c, 0x084a, 0x1048, 0x1048, 0x13f8, 0x13f8, 0x0248, 0x0248, 0x0248, 0x0188, 0x0000, 0x0000, 0x0000 },	// U+1849 (ᡉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x3ff8, 0x2058, 0x2048, 0x2048, 0x1180, 0x0c00, 0x0400, 0x0000 },	// U+184A (ᡊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x07f8, 0x0448, 0x0448, 0x0448, 0x0230, 0x0180, 0x0080, 0x0000 },	// U+184B (ᡋ)
	{ 0x0000, 0x0000, 0x0000, 0x0188, 0x0248, 0x0428, 0x0428, 0x043e, 0x043e, 0x0028, 0x0028, 0x0048, 0x0078, 0x0000, 0x0000, 0x0000 },	// U+184C (ᡌ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x03f8, 0x03f8, 0x00d8, 0x0048, 0x0048, 0x0000, 0x0048, 0x0048, 0x0000 },	// U+184D (ᡍ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x03f8, 0x03f8, 0x00d8, 0x0048, 0x0000, 0x0030, 0x0048, 0x0030, 0x0000 },	// U+184E (ᡎ)
	{ 0x0000, 0x0000, 0x0180, 0x0110, 0x0128, 0x00c8, 0x0088, 0x008c, 0x008c, 0x0090, 0x00a0, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+184F (ᡏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0048, 0x0048, 0x01c8, 0x01c8, 0x0048, 0x0050, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1850 (ᡐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x00f8, 0x0028, 0x0048, 0x0050, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+1851 (ᡑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x03f8, 0x0080, 0x0080, 0x0080, 0x0070, 0x0048, 0x0030, 0x0000 },	// U+1852 (ᡒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x03f8, 0x0080, 0x0080, 0x0080, 0x0060, 0x0010, 0x00e0, 0x0000 },	// U+1853 (ᡓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x03f8, 0x0080, 0x0080, 0x0080, 0x0060, 0x0010, 0x0000, 0x0000 },	// U+1854 (ᡔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0078, 0x0078, 0x0008, 0x0008, 0x0010, 0x0010, 0x0000, 0x0000, 0x0000 },	// U+1855 (ᡕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x01f8, 0x0008, 0x0008, 0x0070, 0x0090, 0x0060, 0x0000, 0x0000 },	// U+1856 (ᡖ)
	{ 0x0000, 0x00e0, 0x0110, 0x0210, 0x0210, 0x0210, 0x0010, 0x0010, 0x0010, 0x0010, 0x0020, 0x0040, 0x0060, 0x0000, 0x0000, 0x0000 },	// U+1857 (ᡗ)
	{ 0x0000, 0x00e0, 0x0110, 0x0210, 0x0210, 0x0210, 0x0010, 0x0018, 0x0018, 0x0010, 0x0020, 0x0050, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1858 (ᡘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e78, 0x3e78, 0x3258, 0x2248, 0x2448, 0x0280, 0x0100, 0x0000, 0x0000 },	// U+1859 (ᡙ)
	{ 0x0000, 0x0000, 0x00e0, 0x0110, 0x0208, 0x0208, 0x0208, 0x0e78, 0x0e78, 0x0248, 0x0248, 0x0248, 0x0130, 0x0080, 0x03c0, 0x0000 },	// U+185A (ᡚ)
	{ 0x0000, 0x0000, 0x0000, 0x0040, 0x0078, 0x0048, 0x0048, 0x01f8, 0x01f8, 0x0008, 0x0008, 0x0008, 0x0048, 0x0030, 0x0000, 0x0000 },	// U+185B (ᡛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x03f8, 0x0080, 0x00f0, 0x00f0, 0x0090, 0x00c0, 0x0020, 0x0000 },	// U+185C (ᡜ)
	{ 0x0000, 0x0100, 0x0200, 0x0108, 0x0088, 0x0080, 0x0040, 0x0048, 0x0048, 0x0048, 0x0048, 0x0050, 0x0050, 0x0060, 0x0000, 0x0000 },	// U+185D (ᡝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x03f8, 0x0058, 0x0048, 0x0088, 0x0080, 0x0100, 0x0000, 0x0000 },	// U+185E (ᡞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0044, 0x0028, 0x0010, 0x01fc, 0x01fc, 0x0018, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+185F (ᡟ)
	{ 0x0000, 0x0000, 0x0100, 0x008c, 0x008a, 0x0008, 0x0008, 0x03f8, 0x03f8, 0x0248, 0x0248, 0x0248, 0x0188, 0x0000, 0x0000, 0x0000 },	// U+1860 (ᡠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0ff8, 0x0148, 0x0248, 0x0448, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+1861 (ᡡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0ff8, 0x08d8, 0x0848, 0x0848, 0x0400, 0x0200, 0x0200, 0x0000 },	// U+1862 (ᡢ)
	{ 0x0000, 0x0080, 0x0100, 0x0080, 0x0080, 0x0040, 0x0040, 0x0048, 0x0048, 0x0048, 0x0248, 0x0150, 0x0060, 0x0200, 0x0100, 0x0000 },	// U+1863 (ᡣ)
	{ 0x0000, 0x0000, 0x08c0, 0x0520, 0x0120, 0x0210, 0x0210, 0x0e1c, 0x0e1c, 0x0210, 0x0210, 0x0120, 0x0138, 0x0000, 0x0000, 0x0000 },	// U+1864 (ᡤ)
	{ 0x0000, 0x0600, 0x09c0, 0x0720, 0x0120, 0x0210, 0x0210, 0x1e1c, 0x1e1c, 0x0210, 0x0210, 0x0120, 0x0138, 0x0000, 0x0000, 0x0000 },	// U+1865 (ᡥ)
	{ 0x0000, 0x0000, 0x0000, 0x01b0, 0x0248, 0x0248, 0x0208, 0x0278, 0x0278, 0x0048, 0x0048, 0x0048, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+1866 (ᡦ)
	{ 0x0000, 0x0000, 0x0000, 0x00c0, 0x00a0, 0x00a8, 0x0090, 0x0380, 0x0380, 0x0080, 0x0088, 0x0090, 0x00a0, 0x0000, 0x0000, 0x0000 },	// U+1867 (ᡧ)
	{ 0x0000, 0x0000, 0x0380, 0x0440, 0x0420, 0x0440, 0x0480, 0x1ff0, 0x1ff0, 0x0400, 0x0400, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1868 (ᡨ)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0048, 0x0014, 0x0022, 0x01e1, 0x01e2, 0x0074, 0x0028, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1869 (ᡩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00fc, 0x00fc, 0x0008, 0x0010, 0x0020, 0x0020, 0x0020, 0x0018, 0x0000 },	// U+186A (ᡪ)
	{ 0x0000, 0x0000, 0x0030, 0x0048, 0x0040, 0x0080, 0x0080, 0x1f80, 0x1f80, 0x0080, 0x0080, 0x0100, 0x0900, 0x0600, 0x0000, 0x0000 },	// U+186B (ᡫ)
	{ 0x0000, 0x0080, 0x0040, 0x0000, 0x0070, 0x0088, 0x0108, 0x0108, 0x0108, 0x0008, 0x0018, 0x0028, 0x0028, 0x0000, 0x0000, 0x0000 },	// U+186C (ᡬ)
	{ 0x0000, 0x0060, 0x0090, 0x0060, 0x0000, 0x0070, 0x0088, 0x0108, 0x0108, 0x0008, 0x0018, 0x0028, 0x0028, 0x0000, 0x0000, 0x0000 },	// U+186D (ᡭ)
	{ 0x0000, 0x0020, 0x0020, 0x00f8, 0x0020, 0x0030, 0x0028, 0x01e8, 0x01ea, 0x0024, 0x0020, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+186E (ᡮ)
	{ 0x0000, 0x0000, 0x00f8, 0x0020, 0x0020, 0x0030, 0x0028, 0x01e8, 0x01ea, 0x0024, 0x0020, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+186F (ᡯ)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x0008, 0x0008, 0x0038, 0x0038, 0x0008, 0x0008, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+1870 (ᡰ)
	{ 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0060, 0x0000, 0x03f8, 0x03f8, 0x0080, 0x0080, 0x0080, 0x0060, 0x0010, 0x0000, 0x0000 },	// U+1871 (ᡱ)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x0048, 0x0030, 0x0000, 0x00fc, 0x00fc, 0x0008, 0x0010, 0x0020, 0x0020, 0x0020, 0x0018, 0x0000 },	// U+1872 (ᡲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x07f8, 0x0088, 0x0088, 0x0110, 0x0110, 0x0220, 0x0220, 0x0000 },	// U+1873 (ᡳ)
	{ 0x0000, 0x1000, 0x2000, 0x1000, 0x0800, 0x0800, 0x0400, 0x04f8, 0x04f8, 0x0498, 0x0488, 0x0508, 0x0500, 0x0600, 0x1080, 0x0840 },	// U+1874 (ᡴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x01f8, 0x0188, 0x0108, 0x0110, 0x0028, 0x0028, 0x0000, 0x0000 },	// U+1875 (ᡵ)
	{ 0x0000, 0x0000, 0x0030, 0x0048, 0x0040, 0x0080, 0x0080, 0x1ffc, 0x1ffc, 0x0080, 0x0080, 0x0100, 0x0900, 0x0600, 0x0000, 0x0000 },	// U+1876 (ᡶ)
	{ 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0060, 0x0000, 0x01f8, 0x01f8, 0x0008, 0x0008, 0x0010, 0x0010, 0x0000, 0x0000, 0x0000 },	// U+1877 (ᡷ)
	{ 0x0000, 0x0000, 0x0000, 0x01b0, 0x01b0, 0x0000, 0x0000, 0x03f8, 0x03f8, 0x0080, 0x0080, 0x0080, 0x0060, 0x0010, 0x0000, 0x0000 },	// U+1878 (ᡸ)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x63de, 0x6fee, 0x73ee, 0x7ffe, 0x0000 },	// U+1879 (᡹)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x61de, 0x6dee, 0x6dee, 0x7ffe, 0x0000 },	// U+187A (᡺)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x71de, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+187B (᡻)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7dde, 0x7dee, 0x63ee, 0x7ffe, 0x0000 },	// U+187C (᡼)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+187D (᡽)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+187E (᡾)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+187F (᡿)
	{ 0x0000, 0x0000, 0x0000, 0x0040, 0x0080, 0x0130, 0x0348, 0x0348, 0x0348, 0x0348, 0x0130, 0x0080, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+1880 (ᢀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0330, 0x04c8, 0x04c8, 0x0330, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1881 (ᢁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0318, 0x02a8, 0x0248, 0x0248, 0x02a8, 0x0318, 0x0208, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1882 (ᢂ)
	{ 0x0000, 0x0000, 0x0000, 0x0070, 0x0088, 0x0080, 0x0080, 0x0040, 0x0038, 0x0040, 0x0080, 0x0080, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+1883 (ᢃ)
	{ 0x0000, 0x0000, 0x0000, 0x0070, 0x0088, 0x0008, 0x0008, 0x0010, 0x00e0, 0x0010, 0x0008, 0x0008, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+1884 (ᢄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4630, 0x2948, 0x1084, 0x1084, 0x14a4, 0x1318, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1885 (ᢅ)
	{ 0x0000, 0x2000, 0x1770, 0x0888, 0x0aa8, 0x0910, 0x2000, 0x1770, 0x0888, 0x0aa8, 0x0910, 0x2000, 0x1770, 0x0888, 0x0aa8, 0x0910 },	// U+1886 (ᢆ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x1ff8, 0x3ff8, 0x2008, 0x1008, 0x0808, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+1887 (ᢇ)
	{ 0x0000, 0x0000, 0x0300, 0x048c, 0x044a, 0x0028, 0x0028, 0x0038, 0x0038, 0x0028, 0x0028, 0x0248, 0x0188, 0x0000, 0x0000, 0x0000 },	// U+1888 (ᢈ)
	{ 0x0000, 0x0000, 0x0060, 0x0090, 0x0110, 0x0108, 0x0108, 0x0f08, 0x0f08, 0x0008, 0x0008, 0x0010, 0x0010, 0x0020, 0x0000, 0x0000 },	// U+1889 (ᢉ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x018a, 0x0248, 0x0448, 0x0478, 0x0078, 0x0048, 0x0048, 0x0048, 0x0080, 0x0008, 0x0004, 0x0000 },	// U+188A (ᢊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0ff8, 0x0080, 0x0080, 0x03e0, 0x0410, 0x0410, 0x0300, 0x0000 },	// U+188B (ᢋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00fc, 0x00fc, 0x0010, 0x0020, 0x0048, 0x0050, 0x0060, 0x0000, 0x0000 },	// U+188C (ᢌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ff8, 0x3ff8, 0x08c8, 0x0548, 0x0248, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+188D (ᢍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0ff8, 0x0008, 0x0188, 0x0290, 0x0290, 0x0060, 0x0000, 0x0000 },	// U+188E (ᢎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0ff8, 0x0008, 0x0008, 0x0010, 0x0070, 0x0060, 0x0000, 0x0000 },	// U+188F (ᢏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x03f8, 0x0028, 0x0048, 0x0090, 0x0090, 0x0060, 0x0000, 0x0000 },	// U+1890 (ᢐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x01f8, 0x0008, 0x0048, 0x0090, 0x0050, 0x0020, 0x0000, 0x0000 },	// U+1891 (ᢑ)
	{ 0x0000, 0x0000, 0x0060, 0x0090, 0x0110, 0x0208, 0x0208, 0x02f8, 0x00f8, 0x0080, 0x0080, 0x0090, 0x0060, 0x0000, 0x0000, 0x0000 },	// U+1892 (ᢒ)
	{ 0x0000, 0x0000, 0x0060, 0x0090, 0x0110, 0x0208, 0x0208, 0x02f8, 0x00f8, 0x0080, 0x0080, 0x0070, 0x0008, 0x0048, 0x0030, 0x0000 },	// U+1893 (ᢓ)
	{ 0x0000, 0x00e0, 0x0110, 0x0210, 0x0210, 0x0210, 0x0208, 0x0e08, 0x0e08, 0x0208, 0x0208, 0x0010, 0x0000, 0x0140, 0x0140, 0x0000 },	// U+1894 (ᢔ)
	{ 0x0000, 0x00e0, 0x0110, 0x0210, 0x0210, 0x0210, 0x0210, 0x0e10, 0x0e10, 0x0210, 0x0210, 0x0010, 0x0110, 0x00e0, 0x0000, 0x0000 },	// U+1895 (ᢕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x03e0, 0x0200, 0x0200, 0x01c0, 0x0200, 0x0180, 0x0000, 0x0000 },	// U+1896 (ᢖ)
	{ 0x0000, 0x0000, 0x0000, 0x00e0, 0x0110, 0x0210, 0x0210, 0x0210, 0x0010, 0x0010, 0x0110, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+1897 (ᢗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x03f8, 0x0028, 0x0048, 0x01d0, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+1898 (ᢘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x0108, 0x0108, 0x07c8, 0x07e8, 0x0128, 0x0128, 0x00c8, 0x0010, 0x01e0, 0x0000, 0x0000 },	// U+1899 (ᢙ)
	{ 0x0000, 0x1200, 0x2a00, 0x1260, 0x0090, 0x0110, 0x0110, 0x7f1e, 0x7f1e, 0x0110, 0x0110, 0x0010, 0x001c, 0x0000, 0x0000, 0x0000 },	// U+189A (ᢚ)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x000a, 0x0008, 0x0008, 0x03f8, 0x03f8, 0x0008, 0x00c8, 0x0128, 0x00c8, 0x0000, 0x0000, 0x0000 },	// U+189B (ᢛ)
	{ 0x0000, 0x0070, 0x0088, 0x0070, 0x00f8, 0x0030, 0x0030, 0x01e8, 0x01e8, 0x002a, 0x0024, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+189C (ᢜ)
	{ 0x0000, 0x0000, 0x0000, 0x0600, 0x0978, 0x0630, 0x0030, 0x1fe8, 0x1fe8, 0x002a, 0x0024, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+189D (ᢝ)
	{ 0x0000, 0x0000, 0x0008, 0x0188, 0x0250, 0x0190, 0x0020, 0x1fe0, 0x1fe0, 0x0020, 0x0040, 0x0040, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+189E (ᢞ)
	{ 0x0000, 0x0000, 0x0000, 0x0220, 0x0550, 0x0220, 0x0000, 0x1ff8, 0x1ff8, 0x0008, 0x0010, 0x0010, 0x0020, 0x0020, 0x0000, 0x0000 },	// U+189F (ᢟ)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0040, 0x0040, 0x0000, 0x01f8, 0x01f8, 0x0028, 0x0048, 0x0090, 0x0050, 0x0020, 0x0000, 0x0000 },	// U+18A0 (ᢠ)
	{ 0x0000, 0x0000, 0x0240, 0x0540, 0x0248, 0x0014, 0x0022, 0x0fe1, 0x0fe2, 0x0074, 0x0028, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+18A1 (ᢡ)
	{ 0x0000, 0x0000, 0x0000, 0x00c0, 0x00a0, 0x00a8, 0x0090, 0x0380, 0x0380, 0x0080, 0x0080, 0x0000, 0x0000, 0x00a0, 0x00a0, 0x0000 },	// U+18A2 (ᢢ)
	{ 0x0000, 0x0000, 0x0008, 0x0008, 0x0010, 0x0010, 0x0020, 0x1fe0, 0x1fe0, 0x0020, 0x0040, 0x0040, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+18A3 (ᢣ)
	{ 0x0000, 0x00c0, 0x0120, 0x00c0, 0x0000, 0x00c0, 0x00a0, 0x03a8, 0x0390, 0x0080, 0x0088, 0x0090, 0x00a0, 0x0000, 0x0000, 0x0000 },	// U+18A4 (ᢤ)
	{ 0x0000, 0x00c0, 0x0120, 0x00c0, 0x0000, 0x00c0, 0x00a0, 0x03a8, 0x0390, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+18A5 (ᢥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x00f8, 0x0088, 0x0050, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+18A6 (ᢦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e8, 0x01e8, 0x0048, 0x0050, 0x0090, 0x00a0, 0x00a0, 0x0070, 0x0000 },	// U+18A7 (ᢧ)
	{ 0x0000, 0x0000, 0x0c00, 0x1270, 0x0c88, 0x0108, 0x0108, 0x3f78, 0x3f78, 0x0048, 0x0048, 0x0048, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+18A8 (ᢨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0008, 0x0010 },	// U+18A9 (ᢩ)
	{ 0x0000, 0x0002, 0x0002, 0x00cc, 0x0128, 0x00cc, 0x000a, 0x03f8, 0x03f8, 0x0008, 0x0008, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+18AA (ᢪ)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6db6, 0x7186, 0x6db6, 0x71b6, 0x7ffe, 0x0000 },	// U+18AB (᢫)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6386, 0x7db6, 0x7d86, 0x7db6, 0x63b6, 0x7ffe, 0x0000 },	// U+18AC (᢬)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6db6, 0x6d86, 0x6db6, 0x71b6, 0x7ffe, 0x0000 },	// U+18AD (᢭)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7db6, 0x7186, 0x7db6, 0x61b6, 0x7ffe, 0x0000 },	// U+18AE (᢮)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7db6, 0x7186, 0x7db6, 0x7db6, 0x7ffe, 0x0000 },	// U+18AF (᢯)
	{ 0x00c0, 0x0120, 0x0120, 0x00d8, 0x0028, 0x0048, 0x0088, 0x0108, 0x0208, 0x0208, 0x0108, 0x0088, 0x0048, 0x0028, 0x0018, 0x0000 },	// U+18B0 (ᢰ)
	{ 0x0060, 0x0090, 0x0090, 0x0360, 0x0280, 0x0240, 0x0220, 0x0210, 0x0208, 0x0208, 0x0210, 0x0220, 0x0240, 0x0280, 0x0300, 0x0000 },	// U+18B1 (ᢱ)
	{ 0x0318, 0x0324, 0x0024, 0x0318, 0x0280, 0x0240, 0x0220, 0x0210, 0x0208, 0x0208, 0x0210, 0x0220, 0x0240, 0x0280, 0x0300, 0x0000 },	// U+18B2 (ᢲ)
	{ 0x0180, 0x0240, 0x0240, 0x0d80, 0x0a00, 0x0900, 0x0880, 0x0840, 0x0826, 0x0826, 0x0840, 0x0880, 0x0900, 0x0a00, 0x0c00, 0x0000 },	// U+18B3 (ᢳ)
}; // 186

static const uint16_t unifontdw_block107[][16] = {
	{ 0x0240, 0x0240, 0x0180, 0x0000, 0x0fe0, 0x0010, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0010, 0x0fe0, 0x0000, 0x0000 },	// U+18B7 (ᢷ)
}; // 1

static const uint16_t unifontdw_block108[][16] = {
	{ 0x00c0, 0x0120, 0x0120, 0x00c0, 0x0000, 0x0020, 0x0020, 0x0020, 0x07a0, 0x0866, 0x0826, 0x0820, 0x0860, 0x07a0, 0x0000, 0x0000 },	// U+18B9 (ᢹ)
}; // 1

static const uint16_t unifontdw_block109[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0480, 0x0480, 0x0300, 0x0000, 0x0700, 0x0880, 0x0880, 0x0880, 0x07f8, 0x0000, 0x0000 },	// U+18BB (ᢻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0090, 0x0060, 0x0000, 0x0070, 0x0088, 0x0088, 0x0088, 0x0ff0, 0x0000, 0x0000 },	// U+18BC (ᢼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0090, 0x0060, 0x0000, 0x0070, 0x0008, 0x0008, 0x0008, 0x0ff0, 0x0000, 0x0000 },	// U+18BD (ᢽ)
}; // 3

static const uint16_t unifontdw_block110[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0000, 0x0630, 0x0848, 0x0888, 0x0908, 0x0630, 0x0000, 0x0000 },	// U+18C0 (ᣀ)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0000, 0x0630, 0x0908, 0x0888, 0x0848, 0x0630, 0x0000, 0x0000 },	// U+18C1 (ᣁ)
	{ 0x0000, 0x0000, 0x0000, 0x0600, 0x0900, 0x0900, 0x0600, 0x0000, 0x0000, 0x18c0, 0x212c, 0x222c, 0x2420, 0x18c0, 0x0000, 0x0000 },	// U+18C2 (ᣂ)
}; // 3

static const uint16_t unifontdw_block111[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fc0, 0x022c, 0x022c, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+18C6 (ᣆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x3044, 0x3044, 0x0044, 0x0038, 0x0000, 0x0000 },	// U+18C7 (ᣇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x3fc0, 0x022c, 0x022c, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+18C8 (ᣈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0030, 0x0000, 0x07f8, 0x3044, 0x3044, 0x0044, 0x0038, 0x0000, 0x0000 },	// U+18C9 (ᣉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c00, 0x220c, 0x220c, 0x2200, 0x1fe0, 0x0000, 0x0000 },	// U+18CA (ᣊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x3440, 0x3440, 0x0440, 0x03fc, 0x0000, 0x0000 },	// U+18CB (ᣋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x0c00, 0x0000, 0x1c00, 0x220c, 0x220c, 0x2200, 0x1fe0, 0x0000, 0x0000 },	// U+18CC (ᣌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0380, 0x3440, 0x3440, 0x0440, 0x03fc, 0x0000, 0x0000 },	// U+18CD (ᣍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2078, 0x2040, 0x2046, 0x2046, 0x1080, 0x0f00, 0x0000, 0x0000 },	// U+18CE (ᣎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0816, 0x0816, 0x0810, 0x7810, 0x0000, 0x0000 },	// U+18CF (ᣏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x03c0, 0x0420, 0x0816, 0x0816, 0x0810, 0x7810, 0x0000, 0x0000 },	// U+18D0 (ᣐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0400, 0x0800, 0x0800, 0x0818, 0x0418, 0x03c0, 0x0040, 0x0040, 0x0040, 0x0000, 0x0000 },	// U+18D1 (ᣑ)
	{ 0x0000, 0x0180, 0x0180, 0x0000, 0x03c0, 0x0400, 0x0800, 0x0800, 0x0818, 0x0418, 0x03c0, 0x0040, 0x0040, 0x0040, 0x0000, 0x0000 },	// U+18D2 (ᣒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x0080, 0x0040, 0x0040, 0x0058, 0x0098, 0x0f00, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+18D3 (ᣓ)
}; // 14

static const uint16_t unifontdw_block112[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x681e, 0x6810, 0x0810, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000 },	// U+18E0 (ᣠ)
	{ 0x0000, 0x0060, 0x0060, 0x0000, 0x0020, 0x0020, 0x0020, 0x01e0, 0x0200, 0x0400, 0x0400, 0x0400, 0x0200, 0x01e0, 0x0000, 0x0000 },	// U+18E1 (ᣡ)
	{ 0x0000, 0x0600, 0x0600, 0x0000, 0x0400, 0x0400, 0x0400, 0x0780, 0x0040, 0x0020, 0x0020, 0x0020, 0x0040, 0x0780, 0x0000, 0x0000 },	// U+18E2 (ᣢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0470, 0x0488, 0x3488, 0x3488, 0x0448, 0x0408, 0x0408, 0x0210, 0x01e0, 0x0000, 0x0000 },	// U+18E3 (ᣣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0408, 0x3404, 0x3444, 0x0384, 0x0004, 0x0008, 0x07f0, 0x0000, 0x0000 },	// U+18E4 (ᣤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0444, 0x0444, 0x3444, 0x3444, 0x0444, 0x0404, 0x0404, 0x0208, 0x01f0, 0x0000, 0x0000 },	// U+18E5 (ᣥ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0000, 0x03f8, 0x0400, 0x0800, 0x0800, 0x08f8, 0x0800, 0x0800, 0x0400, 0x03f8, 0x0000, 0x0000 },	// U+18E6 (ᣦ)
	{ 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0fe0, 0x0010, 0x0008, 0x0008, 0x0f88, 0x0008, 0x0008, 0x0010, 0x0fe0, 0x0000, 0x0000 },	// U+18E7 (ᣧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0088, 0x0088, 0x0088, 0x0cf0, 0x0ca0, 0x00a0, 0x0090, 0x0090, 0x0000, 0x0000 },	// U+18E8 (ᣨ)
}; // 9

static const uint16_t unifontdw_block113[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x0108, 0x0148, 0x0148, 0x1930, 0x1900, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000 },	// U+18EA (ᣪ)
}; // 1

static const uint16_t unifontdw_block114[][16] = {
	{ 0x0000, 0x0000, 0x0c00, 0x0c00, 0x0000, 0x0c00, 0x0a00, 0x0a00, 0x0910, 0x0910, 0x08e0, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+18EC (ᣬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0842, 0x0842, 0x6842, 0x6842, 0x0842, 0x0842, 0x0842, 0x07bc, 0x0000, 0x0000 },	// U+18ED (ᣭ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x0000, 0x07f0, 0x0800, 0x0800, 0x0800, 0x07f0, 0x0800, 0x0800, 0x0800, 0x07f0, 0x0000, 0x0000 },	// U+18EE (ᣮ)
	{ 0x0000, 0x0000, 0x0300, 0x0300, 0x0000, 0x0fe0, 0x0010, 0x0010, 0x0010, 0x0fe0, 0x0010, 0x0010, 0x0010, 0x0fe0, 0x0000, 0x0000 },	// U+18EF (ᣯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0004, 0x0004, 0x3004, 0x33f8, 0x0004, 0x0004, 0x0004, 0x03f8, 0x0000, 0x0000 },	// U+18F0 (ᣰ)
	{ 0x0000, 0x0180, 0x0180, 0x0000, 0x0ff0, 0x0060, 0x0180, 0x0200, 0x0400, 0x09c0, 0x0a20, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+18F1 (ᣱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0618, 0x3624, 0x3522, 0x0522, 0x0492, 0x0444, 0x0438, 0x0000, 0x0000 },	// U+18F2 (ᣲ)
}; // 7

static const uint16_t unifontdw_block115[][16] = {
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+18F6 (᣶)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+18F7 (᣷)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+18F8 (᣸)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+18F9 (᣹)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+18FA (᣺)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+18FB (᣻)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+18FC (᣼)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+18FD (᣽)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+18FE (᣾)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x73de, 0x6dde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+18FF (᣿)
	{ 0x0000, 0x0000, 0x0000, 0x01ff, 0x0108, 0x0104, 0x0102, 0x013e, 0x0110, 0x0108, 0x0104, 0x0172, 0x018e, 0x0000, 0x0000, 0x0000 },	// U+1900 (ᤀ)
	{ 0x0000, 0x0000, 0x0000, 0x007c, 0x0040, 0x0040, 0x0020, 0x0020, 0x0010, 0x0010, 0x0008, 0x0008, 0x00f8, 0x0000, 0x0000, 0x0000 },	// U+1901 (ᤁ)
	{ 0x0000, 0x0000, 0x0000, 0x01fc, 0x0042, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0252, 0x018c, 0x0000, 0x0000, 0x0000 },	// U+1902 (ᤂ)
	{ 0x0000, 0x0000, 0x0000, 0x011e, 0x0090, 0x0048, 0x0024, 0x001e, 0x0028, 0x0044, 0x0044, 0x0044, 0x0038, 0x0000, 0x0000, 0x0000 },	// U+1903 (ᤃ)
	{ 0x0000, 0x0000, 0x0000, 0x01ff, 0x0104, 0x0104, 0x0104, 0x0104, 0x0188, 0x0170, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+1904 (ᤄ)
	{ 0x0000, 0x0000, 0x0000, 0x007a, 0x0122, 0x0292, 0x010a, 0x003a, 0x0042, 0x0082, 0x0084, 0x0044, 0x0038, 0x0000, 0x0000, 0x0000 },	// U+1905 (ᤅ)
	{ 0x0000, 0x0000, 0x0000, 0x010e, 0x0110, 0x0120, 0x0140, 0x0140, 0x0140, 0x0144, 0x014a, 0x012a, 0x011c, 0x0000, 0x0000, 0x0000 },	// U+1906 (ᤆ)
	{ 0x0000, 0x0000, 0x0000, 0x01fe, 0x0010, 0x0008, 0x0004, 0x001e, 0x0072, 0x0002, 0x0102, 0x0084, 0x0078, 0x0000, 0x0000, 0x0000 },	// U+1907 (ᤇ)
	{ 0x0000, 0x0000, 0x0000, 0x01fe, 0x0100, 0x011e, 0x0120, 0x0120, 0x011e, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+1908 (ᤈ)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x0004, 0x0004, 0x0004, 0x00f8, 0x0004, 0x0004, 0x0004, 0x0004, 0x00f8, 0x0040, 0x0020, 0x0010 },	// U+1909 (ᤉ)
	{ 0x0000, 0x0000, 0x0000, 0x01fe, 0x0020, 0x0020, 0x002c, 0x0032, 0x0062, 0x0292, 0x010c, 0x0280, 0x0240, 0x0000, 0x0000, 0x0000 },	// U+190A (ᤊ)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x0104, 0x0102, 0x0080, 0x0060, 0x0080, 0x0100, 0x0102, 0x0104, 0x00f8, 0x0000, 0x0000, 0x0000 },	// U+190B (ᤋ)
	{ 0x0000, 0x0000, 0x0000, 0x003e, 0x0020, 0x0020, 0x0020, 0x0020, 0x01fc, 0x0222, 0x0222, 0x0222, 0x011c, 0x0000, 0x0000, 0x0000 },	// U+190C (ᤌ)
	{ 0x0000, 0x0000, 0x0000, 0x0306, 0x00f8, 0x0020, 0x0020, 0x00e0, 0x0100, 0x0200, 0x0202, 0x0104, 0x00f8, 0x0000, 0x0000, 0x0000 },	// U+190D (ᤍ)
	{ 0x0000, 0x0000, 0x0000, 0x013e, 0x0118, 0x0104, 0x0104, 0x0118, 0x0104, 0x0104, 0x0104, 0x0088, 0x0070, 0x0000, 0x0000, 0x0000 },	// U+190E (ᤎ)
	{ 0x0000, 0x0000, 0x0000, 0x003e, 0x0020, 0x0020, 0x0010, 0x0010, 0x0078, 0x0008, 0x0004, 0x0004, 0x007c, 0x0000, 0x0000, 0x0000 },	// U+190F (ᤏ)
	{ 0x0000, 0x0000, 0x0000, 0x0044, 0x0082, 0x0082, 0x0101, 0x0101, 0x0101, 0x0101, 0x0092, 0x0092, 0x006c, 0x0000, 0x0000, 0x0000 },	// U+1910 (ᤐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00ee, 0x0111, 0x0110, 0x0110, 0x0110, 0x0110, 0x0111, 0x0111, 0x00ee, 0x0000, 0x0000, 0x0000 },	// U+1911 (ᤑ)
	{ 0x0000, 0x0000, 0x0000, 0x0306, 0x00f8, 0x0020, 0x0020, 0x0038, 0x0004, 0x0182, 0x0242, 0x0144, 0x00f8, 0x0000, 0x0000, 0x0000 },	// U+1912 (ᤒ)
	{ 0x0000, 0x0000, 0x0000, 0x011c, 0x0122, 0x0122, 0x0112, 0x010a, 0x018a, 0x0174, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+1913 (ᤓ)
	{ 0x0000, 0x0000, 0x0000, 0x01fe, 0x0110, 0x0110, 0x0108, 0x0108, 0x0104, 0x0102, 0x011e, 0x0160, 0x0180, 0x0000, 0x0000, 0x0000 },	// U+1914 (ᤔ)
	{ 0x0000, 0x0000, 0x0000, 0x007e, 0x0020, 0x0010, 0x0038, 0x0040, 0x004c, 0x0052, 0x003c, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1915 (ᤕ)
	{ 0x0000, 0x0000, 0x0000, 0x003e, 0x0020, 0x0020, 0x0010, 0x0010, 0x0018, 0x0018, 0x0024, 0x0044, 0x0082, 0x0000, 0x0000, 0x0000 },	// U+1916 (ᤖ)
	{ 0x0000, 0x0000, 0x0000, 0x018c, 0x0174, 0x0104, 0x0108, 0x0170, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+1917 (ᤗ)
	{ 0x0000, 0x0000, 0x0000, 0x0108, 0x010c, 0x010a, 0x0109, 0x0108, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+1918 (ᤘ)
	{ 0x0000, 0x0000, 0x0000, 0x03c2, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x003c, 0x0000, 0x0000, 0x0000 },	// U+1919 (ᤙ)
	{ 0x0000, 0x0000, 0x0000, 0x00b8, 0x00c4, 0x0084, 0x0084, 0x0084, 0x0084, 0x00c4, 0x00b8, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+191A (ᤚ)
	{ 0x0000, 0x0000, 0x0000, 0x01fc, 0x0122, 0x0122, 0x0122, 0x0122, 0x0122, 0x011c, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+191B (ᤛ)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x0084, 0x0042, 0x0022, 0x00f2, 0x0102, 0x0002, 0x0004, 0x0108, 0x00f0, 0x0000, 0x0000, 0x0000 },	// U+191C (ᤜ)
	{ 0x0000, 0x0000, 0x0000, 0x01fe, 0x0008, 0x0008, 0x0078, 0x0088, 0x0088, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+191D (ᤝ)
	{ 0x0000, 0x0000, 0x0000, 0x01fe, 0x0008, 0x0008, 0x00f8, 0x0080, 0x0080, 0x0088, 0x0094, 0x00a4, 0x0078, 0x0080, 0x0000, 0x0000 },	// U+191E (ᤞ)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x0000 },	// U+191F (᤟)
	{ 0x000c, 0x0012, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1920 (ᤠ)
	{ 0x0000, 0x3c00, 0x4200, 0x2000, 0xe000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1921 (ᤡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x010c, 0x00d2, 0x003c },	// U+1922 (ᤢ)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x2800, 0x3000, 0x2000, 0x2000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+1923 (ᤣ)
	{ 0x0000, 0x0000, 0x0000, 0x4800, 0xb400, 0xb400, 0xd800, 0x9000, 0x9000, 0x4800, 0x4800, 0x2400, 0x2400, 0x0000, 0x0000, 0x0000 },	// U+1924 (ᤤ)
	{ 0x000c, 0x0012, 0x01fc, 0x1000, 0x2800, 0x2800, 0x3000, 0x2000, 0x2000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+1925 (ᤥ)
	{ 0x000c, 0x0012, 0x01fc, 0x4800, 0xb400, 0xb400, 0xd800, 0x9000, 0x9000, 0x4800, 0x4800, 0x2400, 0x2400, 0x0000, 0x0000, 0x0000 },	// U+1926 (ᤦ)
	{ 0x0006, 0x0018, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1927 (ᤧ)
	{ 0x0100, 0x008c, 0x0050, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1928 (ᤨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8000, 0x4400, 0x4a00, 0x3000, 0x0000, 0x0000 },	// U+1929 (ᤩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0500, 0x0880 },	// U+192A (ᤪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e00, 0x5000, 0x4c00, 0x6200, 0x5c00, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+192B (ᤫ)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7d86, 0x7df6, 0x6386, 0x7ffe, 0x0000 },	// U+192C (᤬)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+192D (᤭)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+192E (᤮)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x0000 },	// U+192F (᤯)
	{ 0x0000, 0x0000, 0x0000, 0x7c00, 0x0800, 0x0400, 0x4400, 0x3800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1930 (ᤰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4800, 0x4800, 0x3000, 0x0000, 0x0000, 0x0000 },	// U+1931 (ᤱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0048, 0x0030 },	// U+1932 (ᤲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c00, 0x2200, 0x0000 },	// U+1933 (ᤳ)
	{ 0x0000, 0x0000, 0x0000, 0x0100, 0x0200, 0x0200, 0x2200, 0x5400, 0x5400, 0x3800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1934 (ᤴ)
	{ 0x0000, 0x0000, 0x0000, 0x4200, 0x4400, 0x4400, 0x6400, 0x5800, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1935 (ᤵ)
	{ 0x0000, 0x0000, 0x0000, 0x2200, 0x5400, 0x5400, 0x3800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+1936 (ᤶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0800, 0x1000, 0x0000 },	// U+1937 (ᤷ)
	{ 0x0000, 0x0000, 0x0000, 0x2400, 0x2400, 0x2400, 0x1800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1938 (ᤸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0200, 0x0000 },	// U+1939 (᤹)
	{ 0x0140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+193A (᤺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01fe, 0x0000 },	// U+193B (᤻)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x63c6, 0x7dbe, 0x7d8e, 0x7dbe, 0x63c6, 0x7ffe, 0x0000 },	// U+193C (᤼)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x6d8e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+193D (᤽)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x61c6, 0x7dbe, 0x718e, 0x7dbe, 0x61c6, 0x7ffe, 0x0000 },	// U+193E (᤾)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x61c6, 0x7dbe, 0x718e, 0x7dbe, 0x7dc6, 0x7ffe, 0x0000 },	// U+193F (᤿)
	{ 0x0000, 0x0000, 0x0000, 0x0040, 0x0020, 0x0010, 0x0010, 0x0c10, 0x1210, 0x1210, 0x1420, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000 },	// U+1940 (᥀)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x77b6, 0x73b6, 0x7786, 0x77be, 0x63be, 0x7ffe, 0x0000 },	// U+1941 (᥁)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x61b6, 0x6fb6, 0x6186, 0x7dbe, 0x61be, 0x7ffe, 0x0000 },	// U+1942 (᥂)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x71b6, 0x6fb6, 0x6386, 0x6fbe, 0x71be, 0x7ffe, 0x0000 },	// U+1943 (᥃)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x0280, 0x0200, 0x0200, 0x0200, 0x0200, 0x0000, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+1944 (᥄)
	{ 0x0000, 0x0000, 0x0000, 0x0620, 0x0940, 0x0480, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1945 (᥅)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+1946 (᥆)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x0010, 0x0010, 0x0610, 0x0910, 0x0910, 0x0a10, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+1947 (᥇)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0410, 0x0808, 0x0808, 0x0808, 0x0000, 0x0000, 0x0000 },	// U+1948 (᥈)
	{ 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0010, 0x0020, 0x01c0, 0x0200, 0x0400, 0x0400, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+1949 (᥉)
	{ 0x0000, 0x0000, 0x0000, 0x0c18, 0x0220, 0x0140, 0x0140, 0x0080, 0x0140, 0x0140, 0x0220, 0x0410, 0x180c, 0x0000, 0x0000, 0x0000 },	// U+194A (᥊)
	{ 0x0000, 0x0000, 0x0000, 0x03c0, 0x0520, 0x0510, 0x0210, 0x0010, 0x0010, 0x0210, 0x0510, 0x0520, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+194B (᥋)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0410, 0x0010, 0x0010, 0x0010, 0x0210, 0x0510, 0x0520, 0x03c0, 0x0100, 0x0200, 0x0400 },	// U+194C (᥌)
	{ 0x0000, 0x0000, 0x0000, 0x0230, 0x0508, 0x0088, 0x0090, 0x0060, 0x00c0, 0x0120, 0x0220, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+194D (᥍)
	{ 0x0000, 0x0000, 0x0000, 0x0808, 0x0808, 0x0808, 0x0410, 0x0410, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+194E (᥎)
	{ 0x0000, 0x0000, 0x0000, 0x07f8, 0x0448, 0x0450, 0x0260, 0x0240, 0x0100, 0x0100, 0x0080, 0x0040, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+194F (᥏)
}; // 90

static const uint16_t unifontdw_block116[][16] = {
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+196E (᥮)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+196F (᥯)
}; // 2

static const uint16_t unifontdw_block117[][16] = {
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x61de, 0x6fee, 0x61ee, 0x7ffe, 0x0000 },	// U+1975 (᥵)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x7386, 0x7dbe, 0x71de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+1976 (᥶)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x77de, 0x7bee, 0x7bee, 0x7ffe, 0x0000 },	// U+1977 (᥷)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x73de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+1978 (᥸)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x63de, 0x6fee, 0x73ee, 0x7ffe, 0x0000 },	// U+1979 (᥹)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x61de, 0x6dee, 0x6dee, 0x7ffe, 0x0000 },	// U+197A (᥺)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x71de, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+197B (᥻)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7dde, 0x7dee, 0x63ee, 0x7ffe, 0x0000 },	// U+197C (᥼)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+197D (᥽)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+197E (᥾)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+197F (᥿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1144, 0x2080, 0x2080, 0x2080, 0x1044, 0x0c38, 0x1000, 0x2000, 0x2100, 0x1e00, 0x0000 },	// U+1980 (ᦀ)
	{ 0x0000, 0x0180, 0x0240, 0x0000, 0x0e38, 0x1144, 0x2080, 0x2080, 0x2080, 0x1044, 0x0c38, 0x1000, 0x2000, 0x2100, 0x1e00, 0x0000 },	// U+1981 (ᦁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2288, 0x4104, 0x4004, 0x4004, 0x2008, 0x1c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1982 (ᦂ)
}; // 14

static const uint16_t unifontdw_block118[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2208, 0x4104, 0x4104, 0x2088, 0x1c70, 0x0000, 0x1f00, 0x2080, 0x2700, 0x2840, 0x1f80 },	// U+1984 (ᦄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x0420, 0x0240, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1985 (ᦅ)
	{ 0x03c0, 0x0420, 0x0810, 0x0010, 0x03d0, 0x0430, 0x0810, 0x0810, 0x0810, 0x0420, 0x0240, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1986 (ᦆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x08d0, 0x0930, 0x0800, 0x0800, 0x0420, 0x03c0, 0x0000 },	// U+1987 (ᦇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0810, 0x0860, 0x0810, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1988 (ᦈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1044, 0x2080, 0x2080, 0x2080, 0x1144, 0x0e38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1989 (ᦉ)
	{ 0x0c00, 0x1200, 0x0200, 0x0200, 0x0270, 0x0288, 0x0208, 0x0230, 0x0208, 0x0108, 0x00f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+198A (ᦊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x0420, 0x0240, 0x0400, 0x0800, 0x0820, 0x07c0, 0x0000 },	// U+198B (ᦋ)
	{ 0x03c0, 0x0420, 0x0810, 0x0010, 0x03d0, 0x0430, 0x0810, 0x0810, 0x0810, 0x0420, 0x0240, 0x0400, 0x0800, 0x0820, 0x07c0, 0x0000 },	// U+198C (ᦌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2008, 0x4004, 0x4004, 0x4104, 0x2288, 0x1c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+198D (ᦍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2288, 0x4104, 0x4104, 0x4104, 0x2088, 0x1c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+198E (ᦎ)
}; // 11

static const uint16_t unifontdw_block119[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2208, 0x4104, 0x4104, 0x4104, 0x2088, 0x1c70, 0x0400, 0x0c00, 0x1040, 0x1080, 0x0f00 },	// U+1990 (ᦐ)
}; // 1

static const uint16_t unifontdw_block120[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x1010, 0x2008, 0x2008, 0x2108, 0x1110, 0x0ee0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1992 (ᦒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0010, 0x0010, 0x0010, 0x0010, 0x03e0, 0x0400, 0x0800, 0x0410, 0x03e0, 0x0000 },	// U+1993 (ᦓ)
	{ 0x1800, 0x2400, 0x0400, 0x0400, 0x0460, 0x0410, 0x0408, 0x0408, 0x0408, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1994 (ᦔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1144, 0x1104, 0x0a18, 0x0404, 0x4a04, 0x31f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1995 (ᦕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2208, 0x4104, 0x4104, 0x4104, 0x2088, 0x1c70, 0x0400, 0x0780, 0x2040, 0x1040, 0x0f80 },	// U+1996 (ᦖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2288, 0x4104, 0x4004, 0x6008, 0x5c70, 0x4000, 0x47c0, 0x4820, 0x47a0, 0x2020, 0x1fc0 },	// U+1997 (ᦗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1144, 0x2080, 0x2080, 0x2080, 0x1044, 0x0e38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1998 (ᦘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0420, 0x0810, 0x0810, 0x0bd0, 0x0420, 0x0bc0, 0x0800, 0x0800, 0x0820, 0x07c0, 0x0000 },	// U+1999 (ᦙ)
}; // 8

static const uint16_t unifontdw_block121[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2208, 0x4104, 0x4104, 0x4104, 0x2088, 0x1c70, 0x0000, 0x07c0, 0x0820, 0x0820, 0x07c0 },	// U+199B (ᦛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2208, 0x4104, 0x4104, 0x4104, 0x2088, 0x1c70, 0x1000, 0x10c0, 0x1120, 0x1220, 0x0c40 },	// U+199C (ᦜ)
	{ 0x00f0, 0x0108, 0x0204, 0x0004, 0x1c74, 0x228c, 0x4104, 0x4004, 0x4004, 0x2008, 0x1c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+199D (ᦝ)
}; // 3

static const uint16_t unifontdw_block122[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2088, 0x4104, 0x4104, 0x4104, 0x2208, 0x1c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+199F (ᦟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2208, 0x4104, 0x4104, 0x4104, 0x2088, 0x1c70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+19A0 (ᦠ)
}; // 2

static const uint16_t unifontdw_block123[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0420, 0x0810, 0x0810, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+19A2 (ᦢ)
}; // 1

static const uint16_t unifontdw_block124[][16] = {
	{ 0x0000, 0x0180, 0x0240, 0x0000, 0x0240, 0x0420, 0x0810, 0x0810, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+19A5 (ᦥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2288, 0x4104, 0x4004, 0x4004, 0x2008, 0x1c70, 0x0000, 0x07c0, 0x0820, 0x0820, 0x07c0 },	// U+19A6 (ᦦ)
}; // 2

static const uint16_t unifontdw_block125[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x0420, 0x0240, 0x0000, 0x03c0, 0x0420, 0x0420, 0x03c0 },	// U+19A8 (ᦨ)
	{ 0x03c0, 0x0420, 0x0810, 0x0010, 0x03d0, 0x0430, 0x0810, 0x0810, 0x0810, 0x0420, 0x0240, 0x0000, 0x03c0, 0x0420, 0x0420, 0x03c0 },	// U+19A9 (ᦩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1044, 0x2080, 0x2080, 0x2080, 0x1144, 0x0e38, 0x0000, 0x03e0, 0x0410, 0x0410, 0x03e0 },	// U+19AA (ᦪ)
	{ 0x03c0, 0x0420, 0x0810, 0x0010, 0x03d0, 0x0430, 0x0810, 0x0810, 0x0810, 0x0420, 0x0240, 0x0400, 0x09c0, 0x0620, 0x0220, 0x01c0 },	// U+19AB (ᦫ)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6386, 0x7db6, 0x7d86, 0x7db6, 0x63b6, 0x7ffe, 0x0000 },	// U+19AC (᦬)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x7186, 0x6db6, 0x6d86, 0x6db6, 0x71b6, 0x7ffe, 0x0000 },	// U+19AD (᦭)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7db6, 0x7186, 0x7db6, 0x61b6, 0x7ffe, 0x0000 },	// U+19AE (᦮)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x6186, 0x7db6, 0x7186, 0x7db6, 0x7db6, 0x7ffe, 0x0000 },	// U+19AF (᦯)
}; // 8

static const uint16_t unifontdw_block126[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0310, 0x02e0, 0x0200, 0x0200, 0x1200, 0x0c00, 0x0000 },	// U+19B4 (ᦴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x0420, 0x0c40, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+19B5 (ᦵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3838, 0x4444, 0x8282, 0x8282, 0x8282, 0x4444, 0xc8c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+19B6 (ᦶ)
}; // 3

static const uint16_t unifontdw_block127[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x10f0, 0x1108, 0x1200, 0x1200, 0x1200, 0x1308, 0x12f0, 0x1200, 0x1200, 0x1200, 0x0c00, 0x0000 },	// U+19BB (ᦻ)
	{ 0x00e0, 0x0110, 0x0208, 0x0208, 0x1208, 0x12e8, 0x1318, 0x1208, 0x1208, 0x1310, 0x12e0, 0x1200, 0x1200, 0x1200, 0x0c00, 0x0000 },	// U+19BC (ᦼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x21e0, 0x2210, 0x2408, 0x2408, 0x2408, 0x2610, 0x25e0, 0x2400, 0x2400, 0x2400, 0x1800, 0x0000 },	// U+19BD (ᦽ)
	{ 0x1800, 0x2400, 0x0400, 0x0400, 0x0438, 0x0444, 0x0444, 0x0428, 0x0410, 0x0228, 0x01c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+19BE (ᦾ)
	{ 0x00e0, 0x0150, 0x0248, 0x0248, 0x1248, 0x12e8, 0x1318, 0x1208, 0x1208, 0x1310, 0x12e0, 0x1200, 0x1200, 0x1200, 0x0c00, 0x0000 },	// U+19BF (ᦿ)
	{ 0x00e0, 0x0110, 0x0208, 0x0208, 0x1208, 0x12e8, 0x1318, 0x1208, 0x1208, 0x1310, 0x12e0, 0x1200, 0x1200, 0x1200, 0x0c00, 0x0000 },	// U+19C0 (ᧀ)
}; // 6

static const uint16_t unifontdw_block128[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x08d0, 0x0930, 0x0800, 0x0b00, 0x0480, 0x0300, 0x0000 },	// U+19C2 (ᧂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0010, 0x0010, 0x0010, 0x0010, 0x03e0, 0x0400, 0x0860, 0x0490, 0x03e0, 0x0000 },	// U+19C3 (ᧃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0420, 0x0810, 0x0810, 0x0bd0, 0x0420, 0x0bc0, 0x0800, 0x08c0, 0x0920, 0x07c0, 0x0000 },	// U+19C4 (ᧄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2288, 0x4104, 0x4004, 0x4004, 0x6008, 0x5c70, 0x4000, 0x5800, 0x2400, 0x1800, 0x0000 },	// U+19C5 (ᧅ)
}; // 4

static const uint16_t unifontdw_block129[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0420, 0x0810, 0x0810, 0x0810, 0x0c20, 0x0bc0, 0x0800, 0x0b00, 0x0480, 0x0300, 0x0000 },	// U+19C7 (ᧇ)
}; // 1

static const uint16_t unifontdw_block130[][16] = {
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x618e, 0x6df6, 0x61f6, 0x6df6, 0x6d8e, 0x7ffe, 0x0000 },	// U+19CA (᧊)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x71f6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+19CB (᧋)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x638e, 0x7df6, 0x7df6, 0x7df6, 0x638e, 0x7ffe, 0x0000 },	// U+19CC (᧌)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x6df6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+19CD (᧍)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+19CE (᧎)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+19CF (᧏)
}; // 6

static const uint16_t unifontdw_block131[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c70, 0x2288, 0x2104, 0x2004, 0x2004, 0x2008, 0x2030, 0x2000, 0x2400, 0x2400, 0x1800, 0x0000 },	// U+19D5 (᧕)
}; // 1

static const uint16_t unifontdw_block132[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1144, 0x1082, 0x1002, 0x1002, 0x1004, 0x1018, 0x1000, 0x9000, 0x9000, 0x6000, 0x0000 },	// U+19D7 (᧗)
}; // 1

static const uint16_t unifontdw_block133[][16] = {
	{ 0x0000, 0x0000, 0x1000, 0x1000, 0x0bc0, 0x0420, 0x0010, 0x0010, 0x0010, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+19DA (᧚)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71b6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+19DB (᧛)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7db6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+19DC (᧜)
	{ 0x0000, 0x7ffe, 0x73de, 0x6dce, 0x63de, 0x6fde, 0x738e, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x6db6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+19DD (᧝)
	{ 0x0000, 0x3000, 0x4800, 0x0800, 0x0830, 0x0848, 0x0884, 0x0884, 0x0884, 0x0908, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+19DE (᧞)
	{ 0x0000, 0x3000, 0x4800, 0x0800, 0x0830, 0x0848, 0x0884, 0x0884, 0x0884, 0x0908, 0x0630, 0x0000, 0x03e0, 0x0410, 0x0410, 0x03e0 },	// U+19DF (᧟)
	{ 0x0000, 0x0000, 0x0380, 0x0440, 0x0440, 0x0440, 0x0440, 0x0380, 0x1000, 0x1fc0, 0x0020, 0x0710, 0x0490, 0x0510, 0x0450, 0x07b0 },	// U+19E0 (᧠)
	{ 0x0000, 0x01c0, 0x0220, 0x02a0, 0x0240, 0x0200, 0x0220, 0x01c0, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19E1 (᧡)
	{ 0x0000, 0x0008, 0x06c8, 0x0928, 0x0828, 0x08c8, 0x0808, 0x07f0, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19E2 (᧢)
	{ 0x0000, 0x0000, 0x0770, 0x0888, 0x0888, 0x0898, 0x08a8, 0x0898, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19E3 (᧣)
	{ 0x0000, 0x0040, 0x0020, 0x0090, 0x0150, 0x0050, 0x0090, 0x01e0, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19E4 (᧤)
	{ 0x0120, 0x01d0, 0x0020, 0x0090, 0x0150, 0x0050, 0x0090, 0x01e0, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19E5 (᧥)
	{ 0x0020, 0x01a0, 0x0260, 0x0200, 0x0240, 0x02a0, 0x0220, 0x01c0, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19E6 (᧦)
	{ 0x0000, 0x0800, 0x1360, 0x1490, 0x1410, 0x1430, 0x1450, 0x0830, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19E7 (᧧)
	{ 0x0400, 0x07c0, 0x0020, 0x0710, 0x0490, 0x0510, 0x0450, 0x03b0, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19E8 (᧨)
	{ 0x0000, 0x0200, 0x0200, 0x03c0, 0x0020, 0x00c0, 0x0220, 0x01c0, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19E9 (᧩)
	{ 0x0000, 0x1c38, 0x2244, 0x2254, 0x2248, 0x2240, 0x2244, 0x1c38, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19EA (᧪)
	{ 0x0000, 0x1c38, 0x2244, 0x2a54, 0x2448, 0x2040, 0x2244, 0x1c38, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19EB (᧫)
	{ 0x0000, 0x009c, 0x34a2, 0x4aaa, 0x42a4, 0x44a0, 0x40a2, 0x3f1c, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19EC (᧬)
	{ 0x0000, 0x371c, 0x48a2, 0x48aa, 0x48a4, 0x49a0, 0x4aa2, 0x499c, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19ED (᧭)
	{ 0x0000, 0x0838, 0x0444, 0x1254, 0x2a48, 0x0a40, 0x1244, 0x3c38, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19EE (᧮)
	{ 0x2400, 0x3a38, 0x0444, 0x1254, 0x2a48, 0x0a40, 0x1244, 0x3c38, 0x0000, 0x0240, 0x0320, 0x02c0, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+19EF (᧯)
	{ 0x0400, 0x07c0, 0x0020, 0x0710, 0x0490, 0x0510, 0x0450, 0x03b0, 0x0400, 0x07c0, 0x0020, 0x0710, 0x0490, 0x0510, 0x0450, 0x03b0 },	// U+19F0 (᧰)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x01c0, 0x0220, 0x02a0, 0x0240, 0x0200, 0x0220, 0x01c0, 0x0000 },	// U+19F1 (᧱)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x0008, 0x06c8, 0x0928, 0x0828, 0x08c8, 0x0808, 0x07f0, 0x0000 },	// U+19F2 (᧲)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0770, 0x0888, 0x0888, 0x0898, 0x08a8, 0x0898, 0x0000 },	// U+19F3 (᧳)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x0040, 0x0020, 0x0090, 0x0150, 0x0050, 0x0090, 0x01e0, 0x0000 },	// U+19F4 (᧴)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0420, 0x07d0, 0x0020, 0x0090, 0x0150, 0x0050, 0x0090, 0x01e0, 0x0000 },	// U+19F5 (᧵)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0020, 0x01a0, 0x0260, 0x0200, 0x0240, 0x02a0, 0x0220, 0x01c0, 0x0000 },	// U+19F6 (᧶)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x0800, 0x1360, 0x1490, 0x1410, 0x1430, 0x1450, 0x0830, 0x0000 },	// U+19F7 (᧷)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0400, 0x07c0, 0x0020, 0x0710, 0x0490, 0x0510, 0x0450, 0x03b0, 0x0000 },	// U+19F8 (᧸)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x0200, 0x0200, 0x03c0, 0x0020, 0x00c0, 0x0220, 0x01c0, 0x0000 },	// U+19F9 (᧹)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x1c38, 0x2244, 0x2254, 0x2248, 0x2240, 0x2244, 0x1c38, 0x0000 },	// U+19FA (᧺)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x1c38, 0x2244, 0x2a54, 0x2448, 0x2040, 0x2244, 0x1c38, 0x0000 },	// U+19FB (᧻)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x009c, 0x34a2, 0x4aaa, 0x42a4, 0x44a0, 0x40a2, 0x3f1c, 0x0000 },	// U+19FC (᧼)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x371c, 0x48a2, 0x48aa, 0x48a4, 0x49a0, 0x4aa2, 0x499c, 0x0000 },	// U+19FD (᧽)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x0000, 0x0838, 0x0444, 0x1254, 0x2a48, 0x0a40, 0x1244, 0x3c38, 0x0000 },	// U+19FE (᧾)
	{ 0x0000, 0x0120, 0x0190, 0x0160, 0x0100, 0x0100, 0x0100, 0x2400, 0x3a38, 0x0444, 0x1254, 0x2a48, 0x0a40, 0x1244, 0x3c38, 0x0000 },	// U+19FF (᧿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0880, 0x0440, 0x0220, 0x0110, 0x0080, 0x0000, 0x0000 },	// U+1A00 (ᨀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0480, 0x0480, 0x0940, 0x0940, 0x0620, 0x06a0, 0x0000, 0x0000 },	// U+1A01 (ᨁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0080, 0x0100, 0x0300, 0x0480, 0x0840, 0x0000, 0x0000 },	// U+1A02 (ᨂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0500, 0x0880, 0x1140, 0x0220, 0x0410, 0x0000, 0x0000 },	// U+1A03 (ᨃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0480, 0x0480, 0x0940, 0x0940, 0x0620, 0x0620, 0x0000, 0x0000 },	// U+1A04 (ᨄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0220, 0x0440, 0x0080, 0x0180, 0x0240, 0x0420, 0x0000, 0x0000 },	// U+1A05 (ᨅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+1A06 (ᨆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0210, 0x0420, 0x0840, 0x08c0, 0x0520, 0x0210, 0x0000, 0x0000 },	// U+1A07 (ᨇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0280, 0x0280, 0x0440, 0x0440, 0x0000, 0x0000 },	// U+1A08 (ᨈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02a0, 0x0220, 0x0140, 0x0140, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+1A09 (ᨉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0280, 0x0280, 0x0440, 0x0540, 0x0000, 0x0000 },	// U+1A0A (ᨊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0880, 0x0940, 0x1140, 0x1220, 0x0a20, 0x0490, 0x0140, 0x0000 },	// U+1A0B (ᨋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0480, 0x0480, 0x0940, 0x0840, 0x0520, 0x0220, 0x0000, 0x0000 },	// U+1A0C (ᨌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0500, 0x0880, 0x08c0, 0x0520, 0x0210, 0x0000, 0x0000 },	// U+1A0D (ᨍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x0440, 0x0aa0, 0x0920, 0x1010, 0x1290, 0x0100, 0x0000 },	// U+1A0E (ᨎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x0440, 0x0aa0, 0x0920, 0x1290, 0x1290, 0x0000, 0x0000 },	// U+1A0F (ᨏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0420, 0x0420, 0x0a50, 0x0a50, 0x1188, 0x15a8, 0x0000, 0x0000 },	// U+1A10 (ᨐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0180, 0x0240, 0x0420, 0x0000, 0x0000 },	// U+1A11 (ᨑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0420, 0x0420, 0x0a50, 0x0850, 0x1288, 0x1188, 0x0000, 0x0000 },	// U+1A12 (ᨒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0420, 0x0420, 0x0a50, 0x0a50, 0x1188, 0x1188, 0x0000, 0x0000 },	// U+1A13 (ᨓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0660, 0x0810, 0x1020, 0x0cc0, 0x0300, 0x0000, 0x0000 },	// U+1A14 (ᨔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0420, 0x0420, 0x0a50, 0x0a50, 0x1188, 0x1588, 0x0000, 0x0000 },	// U+1A15 (ᨕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0420, 0x0a50, 0x1188, 0x1188, 0x0a50, 0x0420, 0x0000, 0x0000 },	// U+1A16 (ᨖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A17 (ᨗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800 },	// U+1A18 (ᨘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0002, 0x0004, 0x0000, 0x0000 },	// U+1A19 (ᨙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x4000, 0x4000, 0x8000, 0x8000, 0x0000, 0x0000 },	// U+1A1A (ᨚ)
	{ 0x0000, 0x0000, 0x0008, 0x0010, 0x0020, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A1B (ᨛ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x0000 },	// U+1A1C (᨜)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x71de, 0x6dce, 0x6dde, 0x6dde, 0x718e, 0x7ffe, 0x0000 },	// U+1A1D (᨝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x000c, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x3000, 0x3000, 0x0000 },	// U+1A1E (᨞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x001c, 0x0022, 0x0000, 0x0022, 0x001c, 0x0008, 0x0008 },	// U+1A1F (᨟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ec0, 0x1120, 0x2210, 0x2210, 0x2210, 0x1120, 0x0c00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A20 (ᨠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0800, 0x0bc0, 0x0c20, 0x0c20, 0x13c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A21 (ᨡ)
	{ 0x07c0, 0x0020, 0x0020, 0x0020, 0x0020, 0x03a0, 0x0460, 0x0800, 0x0bc0, 0x0c20, 0x0c20, 0x13c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A22 (ᨢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x1020, 0x1020, 0x1020, 0x0840, 0x0480, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A23 (ᨣ)
	{ 0x03c0, 0x0020, 0x0020, 0x0020, 0x0020, 0x07a0, 0x0860, 0x1020, 0x1020, 0x1020, 0x0840, 0x0480, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A24 (ᨤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a0, 0x1550, 0x2500, 0x2480, 0x2440, 0x2540, 0x1a80, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A25 (ᨥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x1020, 0x1040, 0x1020, 0x1320, 0x14c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A26 (ᨦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0880, 0x0900, 0x0880, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A27 (ᨧ)
	{ 0x0000, 0x0000, 0x0100, 0x0100, 0x0200, 0x0cc0, 0x1120, 0x2200, 0x2200, 0x2200, 0x1120, 0x0ec0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A28 (ᨨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x1080, 0x1040, 0x0840, 0x1040, 0x1080, 0x1300, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A29 (ᨩ)
	{ 0x07c0, 0x0020, 0x0020, 0x0020, 0x0020, 0x07a0, 0x0860, 0x0820, 0x0420, 0x0820, 0x0840, 0x0980, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A2A (ᨪ)
	{ 0x0000, 0x0000, 0x0100, 0x0100, 0x0200, 0x0cc0, 0x1120, 0x2220, 0x2240, 0x2220, 0x1120, 0x0ec0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A2B (ᨫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cc0, 0x1120, 0x2200, 0x2200, 0x2200, 0x1120, 0x0ee0, 0x0020, 0x2020, 0x2020, 0x1fc0 },	// U+1A2C (ᨬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x08a0, 0x1020, 0x1040, 0x1020, 0x0920, 0x06c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A2D (ᨭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x08a0, 0x1020, 0x1040, 0x1020, 0x1820, 0x17c0, 0x1000, 0x13c0, 0x0820, 0x07c0 },	// U+1A2E (ᨮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0800, 0x0800, 0x0400, 0x0300, 0x0c80, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+1A2F (ᨯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x0aa0, 0x1200, 0x1100, 0x1080, 0x0a80, 0x0500, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A30 (ᨰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0880, 0x1540, 0x2520, 0x2520, 0x2520, 0x1240, 0x0880, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A31 (ᨱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ec0, 0x1120, 0x2210, 0x2210, 0x2210, 0x1120, 0x0cc0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A32 (ᨲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1040, 0x1280, 0x1440, 0x1520, 0x12c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A33 (ᨳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e40, 0x1120, 0x0820, 0x0420, 0x0820, 0x1040, 0x0f80, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A34 (ᨴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x1020, 0x1020, 0x1020, 0x0b40, 0x0480, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A35 (ᨵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0020, 0x0020, 0x0020, 0x0740, 0x0880, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+1A36 (ᨶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0480, 0x0840, 0x1020, 0x1020, 0x1020, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A37 (ᨷ)
	{ 0x0000, 0x6000, 0x1000, 0x0800, 0x0800, 0x0800, 0x0840, 0x0820, 0x0820, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A38 (ᨸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0840, 0x14a0, 0x1420, 0x1440, 0x1420, 0x0920, 0x16c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A39 (ᨹ)
	{ 0x0fc0, 0x1020, 0x0020, 0x0020, 0x1fc0, 0x1000, 0x1040, 0x1020, 0x1040, 0x1020, 0x0940, 0x0680, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A3A (ᨺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0480, 0x0b40, 0x1020, 0x1020, 0x1020, 0x0840, 0x0480, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A3B (ᨻ)
	{ 0x07c0, 0x0020, 0x0020, 0x0020, 0x0020, 0x04a0, 0x0b60, 0x1020, 0x1020, 0x1020, 0x0840, 0x0480, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A3C (ᨼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ec0, 0x1120, 0x2200, 0x2200, 0x2200, 0x1120, 0x0cc0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A3D (ᨽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0480, 0x0840, 0x1020, 0x1020, 0x1720, 0x0840, 0x1780, 0x2000, 0x0000, 0x0000, 0x0000 },	// U+1A3E (ᨾ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x1120, 0x2210, 0x2210, 0x2210, 0x1120, 0x0ec0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A3F (ᨿ)
	{ 0x6000, 0x1000, 0x1000, 0x1000, 0x1000, 0x11c0, 0x1020, 0x1020, 0x10c0, 0x1020, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A40 (ᩀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0440, 0x0880, 0x0920, 0x1220, 0x11c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A41 (ᩁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x0aa0, 0x1120, 0x1040, 0x1000, 0x1000, 0x17c0, 0x1820, 0x1120, 0x2fc0, 0x0400 },	// U+1A42 (ᩂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cc0, 0x1120, 0x2110, 0x2110, 0x2210, 0x1220, 0x0cc0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A43 (ᩃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0800, 0x0800, 0x07c0, 0x0800, 0x0bc0, 0x0c20, 0x0920, 0x17c0, 0x0400 },	// U+1A44 (ᩄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x1020, 0x1020, 0x1020, 0x0840, 0x0780, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A45 (ᩅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x1780, 0x0840, 0x1720, 0x1020, 0x1020, 0x0840, 0x0480, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A46 (ᩆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cc0, 0x1120, 0x2200, 0x2200, 0x2a00, 0x1120, 0x2ec0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A47 (ᩇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cc0, 0x1120, 0x2200, 0x2200, 0x2200, 0x1120, 0x0ec0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A48 (ᩈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cc0, 0x1220, 0x2210, 0x2110, 0x2110, 0x1120, 0x0cc0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A49 (ᩉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x1020, 0x1040, 0x1020, 0x1320, 0x14c0, 0x0040, 0x0e40, 0x1040, 0x0f80 },	// U+1A4A (ᩊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ec0, 0x1120, 0x2200, 0x2200, 0x2200, 0x1120, 0x0cc0, 0x1000, 0x2000, 0x0000, 0x0000 },	// U+1A4B (ᩋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cc0, 0x1220, 0x2210, 0x2110, 0x2110, 0x1120, 0x0cc0, 0x0800, 0x0980, 0x0840, 0x0780 },	// U+1A4C (ᩌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cc0, 0x1320, 0x1020, 0x1020, 0x0840, 0x0000, 0x07c0, 0x0820, 0x1320, 0x12a0, 0x1040 },	// U+1A4D (ᩍ)
	{ 0x3f00, 0x4080, 0x0080, 0x7f00, 0x4000, 0x4cc0, 0x5320, 0x5020, 0x5020, 0x4840, 0x4000, 0x47c0, 0x4820, 0x5320, 0x52a0, 0x3040 },	// U+1A4E (ᩎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x1000, 0x1000, 0x1020, 0x0860, 0x07a0, 0x0020, 0x0020, 0x0840, 0x0780 },	// U+1A4F (ᩏ)
	{ 0x03c0, 0x0020, 0x0020, 0x0020, 0x0020, 0x07a0, 0x0860, 0x1000, 0x1000, 0x1020, 0x0860, 0x07a0, 0x0020, 0x0020, 0x0840, 0x0780 },	// U+1A50 (ᩐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x1020, 0x1020, 0x1020, 0x0820, 0x0720, 0x0020, 0x0020, 0x0840, 0x0780 },	// U+1A51 (ᩑ)
	{ 0x0010, 0x0008, 0x0008, 0x0008, 0x0008, 0x0ec8, 0x1128, 0x2208, 0x2208, 0x2208, 0x1128, 0x0cc8, 0x1008, 0x2008, 0x0008, 0x0010 },	// U+1A52 (ᩒ)
	{ 0x6000, 0x1000, 0x1000, 0x1000, 0x1000, 0x10c0, 0x1120, 0x1110, 0x1110, 0x1210, 0x1220, 0x0cc0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A53 (ᩓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1240, 0x24a0, 0x4900, 0x4900, 0x4900, 0x2da0, 0x1240, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A54 (ᩔ)
	{ 0x0010, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0010 },	// U+1A55 (ᩕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0130, 0x0248, 0x0190 },	// U+1A56 (ᩖ)
	{ 0x0000, 0x0000, 0x0000, 0x6000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xa600, 0x4900, 0xb200 },	// U+1A57 (ᩗ)
	{ 0x3000, 0x0800, 0x3000, 0x0800, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A58 (ᩘ)
	{ 0x0780, 0x0840, 0x0b40, 0x0a80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A59 (ᩙ)
	{ 0x0500, 0x0a80, 0x0880, 0x0500, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A5A (ᩚ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x02f0, 0x0208, 0x01f0 },	// U+1A5B (ᩛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0290, 0x0310, 0x05e0 },	// U+1A5C (ᩜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0210, 0x0210, 0x01e0 },	// U+1A5D (ᩝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0130, 0x0240, 0x01b0 },	// U+1A5E (ᩞ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x7d86, 0x7ffe, 0x0000 },	// U+1A5F (᩟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x3800, 0x1000 },	// U+1A60 (᩠)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc000, 0x0000, 0x0000, 0x0000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A61 (ᩡ)
	{ 0x0000, 0x0800, 0x0400, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A62 (ᩢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A63 (ᩣ)
	{ 0x0000, 0x0000, 0x7000, 0x8800, 0x8800, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A64 (ᩤ)
	{ 0x0780, 0x0840, 0x0840, 0x0480, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A65 (ᩥ)
	{ 0x0780, 0x0840, 0x0440, 0x0880, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A66 (ᩦ)
	{ 0x0f80, 0x1040, 0x1240, 0x0880, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A67 (ᩧ)
	{ 0x0dc0, 0x1220, 0x1220, 0x0940, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A68 (ᩨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1800, 0x0000 },	// U+1A69 (ᩩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1400, 0x1400, 0x3400, 0x0000 },	// U+1A6A (ᩪ)
	{ 0x0000, 0x0000, 0x1e00, 0x2600, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A6B (ᩫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x1200, 0x6c00 },	// U+1A6C (ᩬ)
	{ 0x0000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xa000, 0x9000, 0x9000, 0x6000 },	// U+1A6D (ᩭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A6E (ᩮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A6F (ᩯ)
	{ 0x0000, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A70 (ᩰ)
	{ 0x0000, 0x0000, 0x0001, 0x0002, 0x0004, 0x0006, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A71 (ᩱ)
	{ 0x0000, 0x0002, 0x0005, 0x0004, 0x0004, 0x0006, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A72 (ᩲ)
	{ 0x0200, 0x0200, 0x0500, 0x18c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A73 (ᩳ)
	{ 0x0040, 0x00a0, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A74 (ᩴ)
	{ 0x0000, 0x0010, 0x0010, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A75 (᩵)
	{ 0x0000, 0x0040, 0x0028, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A76 (᩶)
	{ 0x0000, 0x0800, 0x1400, 0x2200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A77 (᩷)
	{ 0x4000, 0x4000, 0x4000, 0x4800, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A78 (᩸)
	{ 0x1800, 0x2000, 0x1800, 0x0800, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A79 (᩹)
	{ 0x0e00, 0x1200, 0x2480, 0x2700, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A7A (᩺)
	{ 0x3000, 0x6800, 0x2800, 0x2800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A7B (᩻)
	{ 0x2c00, 0x1200, 0x0480, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A7C (᩼)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+1A7D (᩽)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+1A7E (᩾)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0090, 0x0060 },	// U+1A7F (᩿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0820, 0x0820, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A80 (᪀)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0400, 0x0400, 0x0400, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A81 (᪁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0820, 0x0820, 0x0440, 0x0380 },	// U+1A82 (᪂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0400, 0x0400, 0x0400, 0x0220, 0x01c0, 0x0040, 0x0080, 0x0080, 0x0100, 0x0200 },	// U+1A83 (᪃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0020, 0x0020, 0x0020, 0x0440, 0x0380, 0x0200, 0x0100, 0x0100, 0x0080, 0x0040 },	// U+1A84 (᪄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0820, 0x08e0, 0x0920, 0x08c0, 0x0800, 0x0820, 0x0820, 0x0440, 0x0380 },	// U+1A85 (᪅)
	{ 0x0380, 0x0440, 0x0820, 0x0020, 0x0620, 0x0920, 0x0720, 0x0120, 0x0e20, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A86 (᪆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0220, 0x0220, 0x0220, 0x0220, 0x0240, 0x0200, 0x0200, 0x0200, 0x0c00 },	// U+1A87 (᪇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0820, 0x0820, 0x08a0, 0x0940, 0x0480, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A88 (᪈)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0820, 0x0e20, 0x0120, 0x0720, 0x0920, 0x0620, 0x0020, 0x0820, 0x0440, 0x0380 },	// U+1A89 (᪉)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61ce, 0x6db6, 0x61ce, 0x6db6, 0x6dce, 0x7ffe, 0x0000 },	// U+1A8A (᪊)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x71ce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+1A8B (᪋)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7dce, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+1A8C (᪌)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6dce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+1A8D (᪍)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+1A8E (᪎)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+1A8F (᪏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0820, 0x0820, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A90 (᪐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0580, 0x0640, 0x0020, 0x0020, 0x00a0, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A91 (᪑)
	{ 0x0380, 0x0440, 0x0820, 0x0820, 0x0820, 0x0020, 0x0020, 0x0020, 0x0020, 0x0060, 0x00a0, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A92 (᪒)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x0100, 0x0e38, 0x1044, 0x2080, 0x2080, 0x2080, 0x1144, 0x0e38, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A93 (᪓)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0640, 0x0920, 0x0420, 0x0220, 0x0420, 0x0840, 0x07c0, 0x0040, 0x0740, 0x0840, 0x0780 },	// U+1A94 (᪔)
	{ 0x0400, 0x0400, 0x0200, 0x0180, 0x0040, 0x0620, 0x0920, 0x0420, 0x0220, 0x0420, 0x0840, 0x07c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A95 (᪕)
	{ 0x0800, 0x0400, 0x0400, 0x0400, 0x0400, 0x0440, 0x04a0, 0x0420, 0x0440, 0x0420, 0x04a0, 0x0340, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A96 (᪖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x04a0, 0x0820, 0x0840, 0x0820, 0x04a0, 0x0340, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A97 (᪗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0318, 0x04a4, 0x0842, 0x0802, 0x0604, 0x0200, 0x1fc0, 0x2220, 0x4f90, 0x9250, 0x8c20 },	// U+1A98 (᪘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1870, 0x2088, 0x4104, 0x4104, 0x4114, 0x2228, 0x1c10, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1A99 (᪙)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61ce, 0x6db6, 0x618e, 0x6dbe, 0x6dce, 0x7ffe, 0x0000 },	// U+1A9A (᪚)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x718e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+1A9B (᪛)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7d8e, 0x7dbe, 0x63ce, 0x7ffe, 0x0000 },	// U+1A9C (᪜)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6d8e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+1A9D (᪝)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x61ce, 0x7ffe, 0x0000 },	// U+1A9E (᪞)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x7dce, 0x7ffe, 0x0000 },	// U+1A9F (᪟)
	{ 0x0000, 0x0000, 0x07c0, 0x0920, 0x1110, 0x2108, 0x2108, 0x3ff8, 0x2108, 0x2108, 0x1110, 0x0920, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+1AA0 (᪠)
	{ 0x0000, 0x0000, 0x01c0, 0x0120, 0x0110, 0x0108, 0x0108, 0x3ff8, 0x2108, 0x2108, 0x1110, 0x0920, 0x07c0, 0x0000, 0x0000, 0x0000 },	// U+1AA1 (᪡)
	{ 0x4800, 0x3200, 0x1c00, 0x0b00, 0x0400, 0x0338, 0x0444, 0x0880, 0x0880, 0x0880, 0x0444, 0x03b8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1AA2 (᪢)
	{ 0x0000, 0x0000, 0x0100, 0x0280, 0x0380, 0x0440, 0x1930, 0x2aa8, 0x1930, 0x0440, 0x0380, 0x0280, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+1AA3 (᪣)
	{ 0x0000, 0x0000, 0x0000, 0x07f0, 0x0808, 0x13e4, 0x1414, 0x1394, 0x0814, 0x07e4, 0x3008, 0x0ff0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1AA4 (᪤)
	{ 0x0000, 0x07c0, 0x0440, 0x1290, 0x2aa8, 0x1550, 0xcaa6, 0xb45a, 0x8822, 0xb45a, 0xcaa6, 0x1550, 0x2aa8, 0x1290, 0x0440, 0x07c0 },	// U+1AA5 (᪥)
	{ 0x0000, 0x0380, 0x0440, 0x0820, 0x0820, 0x0980, 0x0640, 0x0040, 0x0640, 0x0980, 0x0820, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000 },	// U+1AA6 (᪦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0dc0, 0x1220, 0x1250, 0x1020, 0x1000, 0x0800, 0x0600, 0x0180, 0x0040, 0x0020, 0x0020, 0x0020 },	// U+1AA7 (ᪧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1AA8 (᪨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1AA9 (᪩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0010, 0x0090, 0x00e0, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1AAA (᪪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0110, 0x0108, 0x0148, 0x0170, 0x0140, 0x0140, 0x0140, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1AAB (᪫)
	{ 0x0000, 0x1c00, 0x2000, 0x2000, 0x2380, 0x1440, 0x0c00, 0x0470, 0x0288, 0x0180, 0x0088, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1AAC (᪬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x00a0, 0x0220, 0x0440, 0x0820, 0x0820, 0x0820, 0x0820, 0x0440, 0x0380 },	// U+1AAD (᪭)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7db6, 0x7186, 0x7db6, 0x61b6, 0x7ffe, 0x0000 },	// U+1AAE (᪮)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7db6, 0x7186, 0x7db6, 0x7db6, 0x7ffe, 0x0000 },	// U+1AAF (᪯)
}; // 214

static const uint16_t unifontdw_block134[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x778e, 0x73f6, 0x77f6, 0x77f6, 0x638e, 0x7ffe, 0x0000 },	// U+1AC1 (᫁)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x618e, 0x6ff6, 0x61f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+1AC2 (᫂)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x718e, 0x6ff6, 0x63f6, 0x6ff6, 0x718e, 0x7ffe, 0x0000 },	// U+1AC3 (᫃)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6d8e, 0x6df6, 0x61f6, 0x6ff6, 0x6f8e, 0x7ffe, 0x0000 },	// U+1AC4 (᫄)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x61f6, 0x6ff6, 0x618e, 0x7ffe, 0x0000 },	// U+1AC5 (᫅)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x738e, 0x7df6, 0x71f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+1AC6 (᫆)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x618e, 0x6ff6, 0x77f6, 0x7bf6, 0x7b8e, 0x7ffe, 0x0000 },	// U+1AC7 (᫇)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x73f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+1AC8 (᫈)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x63f6, 0x6ff6, 0x738e, 0x7ffe, 0x0000 },	// U+1AC9 (᫉)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x618e, 0x6df6, 0x61f6, 0x6df6, 0x6d8e, 0x7ffe, 0x0000 },	// U+1ACA (᫊)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x71f6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+1ACB (᫋)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x638e, 0x7df6, 0x7df6, 0x7df6, 0x638e, 0x7ffe, 0x0000 },	// U+1ACC (ᫌ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x6df6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+1ACD (ᫍ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+1ACE (ᫎ)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+1ACF (᫏)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x6db6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+1AD0 (᫐)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x77c6, 0x73b6, 0x77b6, 0x77b6, 0x63c6, 0x7ffe, 0x0000 },	// U+1AD1 (᫑)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x61b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+1AD2 (᫒)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x71c6, 0x6fb6, 0x63b6, 0x6fb6, 0x71c6, 0x7ffe, 0x0000 },	// U+1AD3 (᫓)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6dc6, 0x6db6, 0x61b6, 0x6fb6, 0x6fc6, 0x7ffe, 0x0000 },	// U+1AD4 (᫔)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x61b6, 0x6fb6, 0x61c6, 0x7ffe, 0x0000 },	// U+1AD5 (᫕)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x73c6, 0x7db6, 0x71b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+1AD6 (᫖)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x77b6, 0x7bb6, 0x7bc6, 0x7ffe, 0x0000 },	// U+1AD7 (᫗)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x73b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+1AD8 (᫘)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x63b6, 0x6fb6, 0x73c6, 0x7ffe, 0x0000 },	// U+1AD9 (᫙)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61b6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+1ADA (᫚)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71b6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+1ADB (᫛)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7db6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+1ADC (᫜)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x6db6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+1ADD (᫝)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+1ADE (᫞)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+1ADF (᫟)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+1AE0 (᫠)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x6386, 0x7ffe, 0x0000 },	// U+1AE1 (᫡)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+1AE2 (᫢)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x7186, 0x7ffe, 0x0000 },	// U+1AE3 (᫣)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6f86, 0x7ffe, 0x0000 },	// U+1AE4 (᫤)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x6186, 0x7ffe, 0x0000 },	// U+1AE5 (᫥)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+1AE6 (᫦)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7b86, 0x7ffe, 0x0000 },	// U+1AE7 (᫧)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+1AE8 (᫨)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x7386, 0x7ffe, 0x0000 },	// U+1AE9 (᫩)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6d86, 0x7ffe, 0x0000 },	// U+1AEA (᫪)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+1AEB (᫫)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x6386, 0x7ffe, 0x0000 },	// U+1AEC (᫬)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+1AED (᫭)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+1AEE (᫮)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7d86, 0x7ffe, 0x0000 },	// U+1AEF (᫯)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+1AF0 (᫰)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x63f6, 0x7ffe, 0x0000 },	// U+1AF1 (᫱)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+1AF2 (᫲)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x71f6, 0x7ffe, 0x0000 },	// U+1AF3 (᫳)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6ff6, 0x7ffe, 0x0000 },	// U+1AF4 (᫴)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+1AF5 (᫵)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+1AF6 (᫶)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+1AF7 (᫷)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+1AF8 (᫸)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+1AF9 (᫹)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+1AFA (᫺)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+1AFB (᫻)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+1AFC (᫼)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+1AFD (᫽)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+1AFE (᫾)
	{ 0x0000, 0x7ffe, 0x61de, 0x6dce, 0x61de, 0x6dde, 0x6d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+1AFF (᫿)
	{ 0x07f0, 0x0888, 0x0948, 0x0490, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B00 (ᬀ)
	{ 0x0080, 0x0550, 0x0550, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B01 (ᬁ)
	{ 0x0080, 0x0140, 0x0200, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B02 (ᬂ)
	{ 0x0000, 0x0040, 0x0080, 0x0f00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B03 (ᬃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0xa000, 0x8000, 0x4000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000 },	// U+1B04 (ᬄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e70, 0x1488, 0x2524, 0x2454, 0x3f44, 0x2524, 0x2448, 0x2330, 0x0000, 0x0000, 0x0000 },	// U+1B05 (ᬅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001c, 0x1c22, 0x2249, 0x4115, 0x4111, 0x4149, 0x2292, 0x146c, 0x0000, 0x0000, 0x0000 },	// U+1B06 (ᬆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0d88, 0x1254, 0x1050, 0x1050, 0x1320, 0x0080, 0x0300, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000 },	// U+1B07 (ᬇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3362, 0x4495, 0x8414, 0x8414, 0x64c8, 0x0020, 0x00c0, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+1B08 (ᬈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01d0, 0x0220, 0x0200, 0x0100, 0x00c0, 0x0020, 0x0390, 0x0450, 0x0820, 0x0000, 0x0000, 0x0000 },	// U+1B09 (ᬉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ce8, 0x1110, 0x2100, 0x2080, 0x1860, 0x0010, 0x01c8, 0x0228, 0x0410, 0x0000, 0x0000, 0x0000 },	// U+1B0A (ᬊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x1428, 0x1420, 0x13c0, 0x0180, 0x0040, 0x0180, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+1B0B (ᬋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1902, 0x2285, 0x4284, 0x4278, 0x3030, 0x0008, 0x0030, 0x0044, 0x0038, 0x0000, 0x0000, 0x0000 },	// U+1B0C (ᬌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0d88, 0x1254, 0x5050, 0x3e50, 0x1120, 0x0880, 0x0900, 0x0600, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+1B0D (ᬍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0362, 0x0495, 0x7414, 0x8f94, 0x8448, 0x4220, 0x9240, 0x9180, 0x6080, 0x0000, 0x0000, 0x0000 },	// U+1B0E (ᬎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0030, 0x0008, 0x01c8, 0x0228, 0x0430, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B0F (ᬏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xa362, 0xd495, 0x7414, 0x4414, 0x4208, 0x41e0, 0x4010, 0x4308, 0x3cf0, 0x0000, 0x0000, 0x0000 },	// U+1B10 (ᬐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0362, 0x0495, 0x0414, 0x0414, 0x0208, 0x01e0, 0x0010, 0x0388, 0x0470, 0x0000, 0x0000, 0x0000 },	// U+1B11 (ᬑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3362, 0x4495, 0x8414, 0x8414, 0x6208, 0x01e0, 0x0010, 0x0388, 0x0470, 0x0000, 0x0000, 0x0000 },	// U+1B12 (ᬒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x33c4, 0x542a, 0x5428, 0x54fc, 0x552a, 0x48c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B13 (ᬓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c4, 0x042a, 0x0428, 0x04fc, 0x052a, 0x38c4, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B14 (ᬔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x19c4, 0x2a2a, 0x2a28, 0x2a28, 0x2948, 0x2770, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B15 (ᬕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1cc4, 0x28aa, 0x28a8, 0x28a8, 0x2aa8, 0x2510, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B16 (ᬖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06c4, 0x092a, 0x0828, 0x0828, 0x0828, 0x0830, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B17 (ᬗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e10, 0x1228, 0x1420, 0x1470, 0x14a8, 0x1310, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B18 (ᬘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c3c, 0x1442, 0x1442, 0x1452, 0x1452, 0x138c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B19 (ᬙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0788, 0x0854, 0x0850, 0x0650, 0x0850, 0x1060, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B1A (ᬚ)
	{ 0x0000, 0x3000, 0x4800, 0xf000, 0x4362, 0x4495, 0x4414, 0x4414, 0x4208, 0x41e0, 0x4010, 0x4308, 0x3cf0, 0x0000, 0x0000, 0x0000 },	// U+1B1B (ᬛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x6362, 0x9495, 0x9414, 0x9414, 0x9414, 0x4c18, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B1C (ᬜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06c4, 0x092a, 0x0808, 0x081c, 0x082a, 0x0012, 0x0084, 0x0044, 0x0038, 0x0000, 0x0000, 0x0000 },	// U+1B1D (ᬝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06c4, 0x092a, 0x0808, 0x0888, 0x0888, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B1E (ᬞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c04, 0x140a, 0x1408, 0x1408, 0x14c8, 0x1330, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B1F (ᬟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0808, 0x0814, 0x0810, 0x0810, 0x0990, 0x0660, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B20 (ᬠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4739, 0xa8c5, 0xa802, 0xa800, 0xa800, 0x9800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B21 (ᬡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x33c4, 0x542a, 0x54e8, 0x5508, 0x5508, 0x48f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B22 (ᬢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0788, 0x0914, 0x0a10, 0x0a50, 0x0a90, 0x09e0, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B23 (ᬣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e10, 0x1128, 0x1120, 0x1390, 0x1548, 0x1230, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B24 (ᬤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1e08, 0x2414, 0x2810, 0x2810, 0x2990, 0x2660, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B25 (ᬥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f10, 0x10a8, 0x10a0, 0x13f0, 0x14a8, 0x1310, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B26 (ᬦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0608, 0x0a14, 0x0a10, 0x0a10, 0x0a10, 0x09e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B27 (ᬧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1108, 0x0a94, 0x0710, 0x0210, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B28 (ᬨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3362, 0x5495, 0x5414, 0x5414, 0x5414, 0x4c18, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B29 (ᬩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f04, 0x108a, 0x1090, 0x13c0, 0x14a8, 0x1310, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B2A (ᬪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0df8, 0x1424, 0x1424, 0x14c0, 0x1420, 0x1220, 0x11c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B2B (ᬫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1004, 0x280a, 0x2888, 0x2888, 0x2948, 0x2630, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B2C (ᬬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0708, 0x0894, 0x08a0, 0x08a0, 0x08a0, 0x0860, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B2D (ᬭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3062, 0x5095, 0x5094, 0x5094, 0x5094, 0x4f08, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B2E (ᬮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f10, 0x1228, 0x1420, 0x1420, 0x1420, 0x13c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B2F (ᬯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x67e2, 0xa895, 0xa954, 0xa914, 0xa524, 0x9c38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B30 (ᬰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0604, 0x0a0a, 0x0a48, 0x0aa8, 0x0a88, 0x0bf0, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B31 (ᬱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0608, 0x0a14, 0x0a10, 0x0a38, 0x0a54, 0x0988, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B32 (ᬲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3302, 0x5485, 0x5484, 0x5484, 0x5484, 0x4878, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B33 (ᬳ)
	{ 0x0000, 0x0080, 0x0000, 0x0220, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B34 (᬴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4000, 0x8000, 0x8000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B35 (ᬵ)
	{ 0x03c0, 0x0428, 0x0430, 0x0240, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B36 (ᬶ)
	{ 0x03c0, 0x04a8, 0x0570, 0x0620, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B37 (ᬷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8000, 0xc000, 0xc000, 0xc000, 0xa000, 0x9000, 0x8800, 0x4800, 0x3000 },	// U+1B38 (ᬸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8000, 0x4000, 0x2000, 0x2000, 0x4000, 0x8000, 0x8000, 0x4000, 0x2000 },	// U+1B39 (ᬹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0800, 0x0820, 0x0990, 0x0510, 0x03e0, 0x0100 },	// U+1B3A (ᬺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4000, 0x8000, 0x8000, 0x9000, 0x6400, 0x0800, 0x0820, 0x0990, 0x0510, 0x03e0, 0x0100 },	// U+1B3B (ᬻ)
	{ 0x0700, 0x0480, 0x0248, 0x0150, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x10c4, 0x112a, 0x1128, 0x0e10 },	// U+1B3C (ᬼ)
	{ 0x0700, 0x0480, 0x0248, 0x0150, 0x3000, 0x4000, 0x8000, 0x8000, 0x9000, 0x6000, 0x0000, 0x0000, 0x10c4, 0x112a, 0x1128, 0x0e10 },	// U+1B3D (ᬽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0012, 0x0010, 0x0008, 0x0008, 0x0004, 0x0004, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+1B3E (ᬾ)
	{ 0x001c, 0x0002, 0x000c, 0x0010, 0x000c, 0x000d, 0x0013, 0x0009, 0x0008, 0x0004, 0x0004, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+1B3F (ᬿ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x300c, 0x4012, 0x8010, 0x8008, 0x9008, 0x6004, 0x0004, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+1B40 (ᭀ)
	{ 0x001c, 0x0002, 0x000c, 0x0010, 0x300c, 0x400d, 0x8013, 0x8009, 0x9008, 0x6004, 0x0004, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+1B41 (ᭁ)
	{ 0x0700, 0x0480, 0x0248, 0x0150, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B42 (ᭂ)
	{ 0x0700, 0x0480, 0x0248, 0x0150, 0x3000, 0x4000, 0x8000, 0x8000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B43 (ᭃ)
	{ 0x7000, 0x8800, 0x8800, 0x8000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000 },	// U+1B44 (᭄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x33c4, 0x542a, 0x5438, 0x54fc, 0x553a, 0x48d4, 0x0010, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+1B45 (ᭅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x68e2, 0xb515, 0xb514, 0xb53e, 0xb555, 0x2222, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B46 (ᭆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x33c4, 0x542a, 0x54e8, 0x5508, 0x5528, 0x48f0, 0x0020, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+1B47 (ᭇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c10, 0x1428, 0x1420, 0x14a0, 0x14a0, 0x13c0, 0x0080, 0x0880, 0x0700, 0x0000, 0x0000, 0x0000 },	// U+1B48 (ᭈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f10, 0x1228, 0x1420, 0x14a0, 0x14a0, 0x13c0, 0x0080, 0x0880, 0x0700, 0x0000, 0x0000, 0x0000 },	// U+1B49 (ᭉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0608, 0x0a14, 0x0a10, 0x0ab8, 0x0ad4, 0x0988, 0x0080, 0x0880, 0x0700, 0x0000, 0x0000, 0x0000 },	// U+1B4A (ᭊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x40c2, 0xa545, 0xa544, 0xad4e, 0xad55, 0xad22, 0xb200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B4B (ᭋ)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x63b6, 0x7db6, 0x7d86, 0x7dbe, 0x63be, 0x7ffe, 0x0000 },	// U+1B4C (ᭌ)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x71b6, 0x6db6, 0x6d86, 0x6dbe, 0x71be, 0x7ffe, 0x0000 },	// U+1B4D (᭍)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x61be, 0x7ffe, 0x0000 },	// U+1B4E (᭎)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x7dbe, 0x7ffe, 0x0000 },	// U+1B4F (᭏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B50 (᭐)
	{ 0x0000, 0x2000, 0x5000, 0xe000, 0x46c4, 0x492a, 0x4828, 0x4828, 0x2828, 0x1c30, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B51 (᭑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0d88, 0x1254, 0x5050, 0x3e50, 0x1120, 0x0880, 0x0900, 0x0600, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+1B52 (᭒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0362, 0x0495, 0x0414, 0x0414, 0x0208, 0x01e0, 0x0010, 0x0388, 0x0470, 0x0000, 0x0000, 0x0000 },	// U+1B53 (᭓)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00d0, 0x0110, 0x0090, 0x0110, 0x0120, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B54 (᭔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x04d0, 0x0510, 0x0490, 0x0510, 0x0520, 0x04c0, 0x0400, 0x0400, 0x0800, 0x0000 },	// U+1B55 (᭕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0030, 0x0008, 0x01c8, 0x0228, 0x0430, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B56 (᭖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4462, 0x2a95, 0x1c94, 0x0894, 0x0894, 0x0718, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B57 (᭗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1108, 0x0a94, 0x0710, 0x0210, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B58 (᭘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4404, 0x2a0a, 0x1c88, 0x0888, 0x0948, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B59 (᭙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c30, 0x1248, 0x1248, 0x1249, 0x1249, 0x9186, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B5A (᭚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3362, 0x5495, 0x5414, 0x5414, 0x5414, 0x5018, 0xfc40, 0x5248, 0x5188, 0x5008, 0x5188, 0x4e70 },	// U+1B5B (᭛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B5C (᭜)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x08c0, 0x0520, 0x03c0, 0x0000, 0x08c0, 0x0520, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B5D (᭝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x00a0, 0x0100, 0x0100, 0x0200, 0x0200, 0x0400, 0x0400, 0x0400, 0x0000, 0x0000, 0x0000 },	// U+1B5E (᭞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0514, 0x0820, 0x0820, 0x1040, 0x1040, 0x2080, 0x2080, 0x2080, 0x0000, 0x0000, 0x0000 },	// U+1B5F (᭟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0200, 0x0180, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B60 (᭠)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4000, 0x8000, 0x8000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B61 (᭡)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01a0, 0x0260, 0x0220, 0x0100, 0x0100, 0x0080, 0x0080, 0x0080, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+1B62 (᭢)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0300, 0x0300, 0x0300, 0x0280, 0x0240, 0x0220, 0x0120, 0x00c0, 0x0000, 0x0000, 0x0000 },	// U+1B63 (᭣)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x00a0, 0x0100, 0x0100, 0x0200, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B64 (᭤)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0040, 0x0080, 0x0f00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B65 (᭥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0428, 0x0430, 0x0240, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B66 (᭦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e00, 0x0900, 0x0490, 0x02a0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B67 (᭧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0008, 0x0004, 0x0004, 0x0008, 0x0010, 0x0010, 0x0008, 0x0004, 0x0000, 0x0000, 0x0000 },	// U+1B68 (᭨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3362, 0x5495, 0x5414, 0x5414, 0x5208, 0x51e0, 0x5010, 0x5188, 0x4e70, 0x0000, 0x0000, 0x0000 },	// U+1B69 (᭩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0028, 0x0020, 0x0010, 0x0020, 0x0020, 0x0020, 0x0010, 0x0010, 0x0010, 0x0020, 0x0020 },	// U+1B6A (᭪)
	{ 0x0100, 0x0080, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B6B (᭫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0080, 0x0100 },	// U+1B6C (᭬)
	{ 0x00c0, 0x0080, 0x03e0, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B6D (᭭)
	{ 0x0000, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B6E (᭮)
	{ 0x0080, 0x0140, 0x0220, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B6F (᭯)
	{ 0x00e0, 0x0080, 0x07f0, 0x01c0, 0x02a0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B70 (᭰)
	{ 0x0fe0, 0x0280, 0x0440, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B71 (᭱)
	{ 0x0220, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B72 (᭲)
	{ 0x01c0, 0x0220, 0x02a0, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B73 (᭳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0014, 0x0014, 0x0022, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B74 (᭴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0012, 0x0012, 0x0012, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B75 (᭵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0016, 0x0014, 0x002a, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B76 (᭶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001d, 0x0022, 0x0026, 0x002a, 0x001c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B77 (᭷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B78 (᭸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x0004, 0x0004, 0x0002, 0x001e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B79 (᭹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0004, 0x001e, 0x0008, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B7A (᭺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x000a, 0x0004, 0x000c, 0x0012, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B7B (᭻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B7C (᭼)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+1B7D (᭽)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+1B7E (᭾)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+1B7F (᭿)
	{ 0x0400, 0x0a00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B80 (ᮀ)
	{ 0x4400, 0x2a00, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B81 (ᮁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x4800, 0x5000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B82 (ᮂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fa0, 0x0410, 0x0210, 0x0710, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B83 (ᮃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0080, 0x0080, 0x0040, 0x0040, 0x0420, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B84 (ᮄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0080, 0x0080, 0x0c40, 0x0240, 0x0420, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B85 (ᮅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07d0, 0x0208, 0x0f08, 0x1388, 0x0408, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B86 (ᮆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x00a0, 0x00c0, 0x0040, 0x0440, 0x0a20, 0x0be0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B87 (ᮇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x0080, 0x0080, 0x0f10, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B88 (ᮈ)
	{ 0x0000, 0x0000, 0x0000, 0x0a00, 0x0420, 0x0010, 0x0f10, 0x0410, 0x0e10, 0x0820, 0x07c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B89 (ᮉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ee0, 0x0880, 0x0880, 0x0440, 0x0440, 0x0220, 0x0220, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B8A (ᮊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1f80, 0x1240, 0x1240, 0x0920, 0x0920, 0x0490, 0x0490, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B8B (ᮋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0080, 0x0080, 0x0e40, 0x0840, 0x0420, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B8C (ᮌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0080, 0x0080, 0x0240, 0x0440, 0x0820, 0x0fe0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B8D (ᮍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x20e0, 0x1080, 0x1080, 0x0840, 0x0860, 0x04d0, 0x0720, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B8E (ᮎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0040, 0x0040, 0x0020, 0x04a0, 0x0990, 0x12f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B8F (ᮏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0080, 0x0080, 0x0040, 0x0240, 0x0520, 0x05e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B90 (ᮐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7c70, 0x4240, 0x4040, 0x2320, 0x2520, 0x1490, 0x18f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B91 (ᮑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0200, 0x0e30, 0x0920, 0x0920, 0x0490, 0x04f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B92 (ᮒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0040, 0x0040, 0x0220, 0x0520, 0x0910, 0x11f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B93 (ᮓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x0080, 0x0080, 0x0040, 0x0040, 0x0020, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B94 (ᮔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ee0, 0x0880, 0x0880, 0x0440, 0x0440, 0x0220, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B95 (ᮕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x10e0, 0x0880, 0x0880, 0x0440, 0x0440, 0x0220, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B96 (ᮖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1100, 0x0880, 0x0880, 0x0440, 0x0440, 0x0220, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B97 (ᮗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xf980, 0x8440, 0x8040, 0x4620, 0x4a20, 0x2910, 0x31f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B98 (ᮘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0800, 0x0870, 0x0440, 0x0440, 0x0220, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B99 (ᮙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0200, 0x2230, 0x2520, 0x1520, 0x1490, 0x08f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B9A (ᮚ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0000, 0x03e0, 0x0200, 0x07c0, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B9B (ᮛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4380, 0x2240, 0x2240, 0x1120, 0x1120, 0x0890, 0x0f90, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B9C (ᮜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0040, 0x0040, 0x0e20, 0x0820, 0x0410, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B9D (ᮝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1ef0, 0x1080, 0x1080, 0x3de0, 0x0840, 0x0420, 0x0420, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B9E (ᮞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0880, 0x0880, 0x07e0, 0x0440, 0x0220, 0x0220, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1B9F (ᮟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3c00, 0x2400, 0x2470, 0x1240, 0x1240, 0x0920, 0x09e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BA0 (ᮠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe000, 0xa000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0820, 0x07e0 },	// U+1BA1 (ᮡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x1050, 0x0f80 },	// U+1BA2 (ᮢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0028, 0x0068, 0x0000 },	// U+1BA3 (ᮣ)
	{ 0x00e0, 0x0080, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BA4 (ᮤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0200, 0x0100, 0x0000 },	// U+1BA5 (ᮥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0004, 0x000e, 0x0001, 0x0007, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BA6 (ᮦ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe000, 0x8000, 0x4000, 0x3800, 0xe000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BA7 (ᮧ)
	{ 0x0088, 0x0050, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BA8 (ᮨ)
	{ 0x0094, 0x0058, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BA9 (ᮩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf800, 0x8000, 0x4000, 0x2000, 0xe000, 0x8000, 0x4000, 0x2000, 0x2000, 0x2000, 0xc000 },	// U+1BAA (᮪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x0080, 0x0000 },	// U+1BAB (᮫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0058, 0x0044, 0x0038, 0x0000 },	// U+1BAC (ᮬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00d8, 0x0090, 0x01b0, 0x0000 },	// U+1BAD (ᮭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xfbf0, 0x8a40, 0x8a40, 0x4920, 0x4920, 0x2890, 0x2f90, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BAE (ᮮ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x13f0, 0x1240, 0x9240, 0x93f0, 0xab20, 0xaa90, 0x4e90, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BAF (ᮯ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0810, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BB0 (᮰)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0890, 0x0080, 0x0e40, 0x0840, 0x0420, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BB1 (᮱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0090, 0x0080, 0x0040, 0x09c0, 0x0420, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BB2 (᮲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0090, 0x0080, 0x0c40, 0x0240, 0x0420, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BB3 (᮳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0240, 0x0a00, 0x07c0, 0x0120, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BB4 (᮴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0360, 0x0550, 0x0140, 0x0220, 0x0220, 0x0410, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BB5 (᮵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x0480, 0x0080, 0x0c40, 0x0240, 0x0420, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BB6 (᮶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x31c0, 0x0920, 0x0920, 0x0490, 0x0490, 0x0248, 0x03cc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BB7 (᮷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1838, 0x2424, 0x0420, 0x0210, 0x0218, 0x0134, 0x01c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BB8 (᮸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x04a0, 0x0080, 0x0c40, 0x0240, 0x0420, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BB9 (᮹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0400, 0x0400, 0x03e0, 0x0200, 0x0100, 0x0100, 0x0080, 0x0080, 0x0040, 0x0040 },	// U+1BBA (ᮺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ee0, 0x0880, 0x0880, 0x0440, 0x0440, 0x0220, 0x03e0, 0x0000, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+1BBB (ᮻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7030, 0x4008, 0x4008, 0x20c4, 0x2144, 0x1122, 0x923e, 0x8800, 0x4e00, 0x4900, 0x3600, 0x0000 },	// U+1BBC (ᮼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7cf0, 0x4488, 0x6498, 0x0240, 0x0240, 0x0240, 0x1ff0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BBD (ᮽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3ef8, 0x2080, 0x2698, 0x1450, 0x1248, 0x0820, 0x3ff8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BBE (ᮾ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0400, 0x04f0, 0x0200, 0x0270, 0x0100, 0x0130, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BBF (ᮿ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0442, 0x0424, 0x0718, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BC0 (ᯀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0442, 0x0024, 0x0718, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BC1 (ᯁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01dc, 0x0222, 0x0210, 0x0108, 0x0084, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BC2 (ᯂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x0000, 0x0000, 0x0330, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BC3 (ᯃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x0110, 0x0088, 0x0044, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BC4 (ᯄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x0222, 0x0252, 0x018c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BC5 (ᯅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x0204, 0x0402, 0x0402, 0x0204, 0x01f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BC6 (ᯆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BC7 (ᯇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0222, 0x001c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BC8 (ᯈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x007e, 0x0000, 0x03e0, 0x0410, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BC9 (ᯉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x007e, 0x0000, 0x0738, 0x00c0, 0x0120, 0x0210, 0x01e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BCA (ᯊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x0202, 0x038e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BCB (ᯋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x0000, 0x038e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BCC (ᯌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x0008, 0x0008, 0x00f0, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BCD (ᯍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x0100, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BCE (ᯎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x0000, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BCF (ᯏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0060, 0x0018, 0x0706, 0x0030, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BD0 (ᯐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0060, 0x0018, 0x0006, 0x0030, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BD1 (ᯑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x00f8, 0x0104, 0x0202, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BD2 (ᯒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x003e, 0x0000, 0x03fe, 0x0000, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BD3 (ᯓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x073e, 0x0088, 0x0048, 0x00c8, 0x0330, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BD4 (ᯔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001c, 0x0322, 0x00c0, 0x0030, 0x000c, 0x0060, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BD5 (ᯕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03fc, 0x0108, 0x0090, 0x0060, 0x0090, 0x030c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BD6 (ᯖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x018e, 0x0244, 0x0224, 0x0398, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BD7 (ᯗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03dc, 0x0422, 0x0010, 0x0030, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BD8 (ᯘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x0000, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BD9 (ᯙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0212, 0x0020, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BDA (ᯚ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x018e, 0x0244, 0x0224, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BDB (ᯛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001c, 0x0322, 0x0488, 0x0448, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BDC (ᯜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0060, 0x0018, 0x0006, 0x0018, 0x0060, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BDD (ᯝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x0318, 0x0404, 0x0008, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BDE (ᯞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BDF (ᯟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0218, 0x0004, 0x0032, 0x00c6, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BE0 (ᯠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0052, 0x04b2, 0x0312, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BE1 (ᯡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0030, 0x00c0, 0x0300, 0x0060, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BE2 (ᯢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x0204, 0x0462, 0x0462, 0x0204, 0x01f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BE3 (ᯣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x018c, 0x0202, 0x0070, 0x0088, 0x0000, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BE4 (ᯤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0000, 0x0088, 0x0070, 0x0202, 0x018c, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BE5 (ᯥ)
	{ 0x00e0, 0x0000, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BE6 (᯦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x4000, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BE7 (ᯧ)
	{ 0x0200, 0x0400, 0x0800, 0x0400, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BE8 (ᯨ)
	{ 0x0000, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BE9 (ᯩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x4800, 0x4800, 0x4800, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BEA (ᯪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3000, 0x0000, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BEB (ᯫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8800, 0x5000, 0x2000, 0x5000, 0x8800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BEC (ᯬ)
	{ 0x0200, 0x0400, 0x08e0, 0x0400, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BED (ᯭ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0800, 0x1000, 0x0800, 0x0400, 0x0000 },	// U+1BEE (ᯮ)
	{ 0x0000, 0x0000, 0x0040, 0x0020, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BEF (ᯯ)
	{ 0x0000, 0x0000, 0xe000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BF0 (ᯰ)
	{ 0xe000, 0x0000, 0xe000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BF1 (ᯱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BF2 (᯲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1BF3 (᯳)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6ff6, 0x7ffe, 0x0000 },	// U+1BF4 (᯴)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+1BF5 (᯵)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+1BF6 (᯶)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+1BF7 (᯷)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+1BF8 (᯸)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+1BF9 (᯹)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+1BFA (᯺)
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x71de, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+1BFB (᯻)
	{ 0x0000, 0x0808, 0x1004, 0x11c4, 0x0a28, 0x0410, 0x0a28, 0x1144, 0x1084, 0x1144, 0x0a28, 0x0410, 0x0a28, 0x11c4, 0x1004, 0x0808 },	// U+1BFC (᯼)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0d58, 0x1084, 0x0d58, 0x0220, 0x0140, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+1BFD (᯽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0888, 0x0444, 0x0444, 0x0444, 0x0888, 0x1110, 0x1110, 0x1110, 0x0888, 0x0000, 0x0000, 0x0000 },	// U+1BFE (᯾)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0080, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0080, 0x0070, 0x0000, 0x0000, 0x0000 },	// U+1BFF (᯿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0020, 0x0020, 0x07f0, 0x0020, 0x0020, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+1C00 (ᰀ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0020, 0x01a0, 0x0260, 0x0210, 0x0100, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1C01 (ᰁ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0640, 0x0120, 0x0110, 0x0210, 0x0410, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+1C02 (ᰂ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0210, 0x0248, 0x0448, 0x0488, 0x02d0, 0x0120, 0x0000, 0x0000, 0x0000 },	// U+1C03 (ᰃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0210, 0x0248, 0x0ffc, 0x0488, 0x02d0, 0x0120, 0x0000, 0x0000, 0x0000 },	// U+1C04 (ᰄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x03e0, 0x0100, 0x0100, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1C05 (ᰅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0240, 0x0438, 0x0240, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000 },	// U+1C06 (ᰆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0100, 0x01e0, 0x0190, 0x0240, 0x0420, 0x07f0, 0x0000, 0x0000, 0x0000 },	// U+1C07 (ᰇ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06c0, 0x0120, 0x0290, 0x0290, 0x0110, 0x0020, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+1C08 (ᰈ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0410, 0x03e0, 0x0040, 0x04a0, 0x0310, 0x0020, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+1C09 (ᰉ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0080, 0x0120, 0x0250, 0x0190, 0x0020, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+1C0A (ᰊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x03a0, 0x0440, 0x03a0, 0x0010, 0x0010, 0x0000, 0x0000, 0x0000 },	// U+1C0B (ᰋ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0248, 0x01f0, 0x0040, 0x01f0, 0x0248, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1C0C (ᰌ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0220, 0x0410, 0x0490, 0x0490, 0x0310, 0x0000, 0x0000, 0x0000 },	// U+1C0D (ᰍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0100, 0x0100, 0x0200, 0x0200, 0x0230, 0x01c8, 0x0000, 0x0000, 0x0000 },	// U+1C0E (ᰎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0460, 0x0390, 0x0010, 0x0020, 0x07f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C0F (ᰏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0210, 0x0208, 0x0408, 0x0410, 0x0470, 0x0388, 0x0000, 0x0000, 0x0000 },	// U+1C10 (ᰐ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0008, 0x0008, 0x03f8, 0x0108, 0x0230, 0x01c8, 0x0000, 0x0000, 0x0000 },	// U+1C11 (ᰑ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0420, 0x0a50, 0x0a48, 0x0c88, 0x0888, 0x0510, 0x0320, 0x0000, 0x0000, 0x0000 },	// U+1C12 (ᰒ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x0120, 0x0210, 0x0410, 0x0410, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+1C13 (ᰓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x05a0, 0x0910, 0x0810, 0x0810, 0x0420, 0x0240, 0x0000, 0x0000, 0x0000 },	// U+1C14 (ᰔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0180, 0x0040, 0x01f0, 0x0248, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000 },	// U+1C15 (ᰕ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0080, 0x0100, 0x07e0, 0x0110, 0x0090, 0x0060, 0x0000, 0x0000, 0x0000 },	// U+1C16 (ᰖ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0420, 0x0210, 0x0210, 0x0410, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+1C17 (ᰗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0110, 0x0288, 0x02a8, 0x0128, 0x06c8, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+1C18 (ᰘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0120, 0x0720, 0x01e0, 0x0138, 0x0240, 0x0480, 0x0000, 0x0000, 0x0000 },	// U+1C19 (ᰙ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x0020, 0x0110, 0x00e0, 0x0210, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000 },	// U+1C1A (ᰚ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x01f0, 0x0010, 0x0020, 0x0020, 0x0010, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+1C1B (ᰛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0220, 0x0450, 0x0848, 0x0888, 0x0888, 0x0510, 0x0320, 0x0000, 0x0000, 0x0000 },	// U+1C1C (ᰜ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x0210, 0x0220, 0x07f0, 0x0220, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+1C1D (ᰝ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0110, 0x00a0, 0x0040, 0x00a0, 0x0110, 0x0208, 0x0000, 0x0000, 0x0000 },	// U+1C1E (ᰞ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x0120, 0x0210, 0x07f0, 0x0410, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+1C1F (ᰟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0210, 0x0288, 0x02a8, 0x0128, 0x00c8, 0x0030, 0x0000, 0x0000, 0x0000 },	// U+1C20 (ᰠ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0010, 0x0290, 0x0290, 0x0150, 0x0420, 0x03c0, 0x0000, 0x0000, 0x0000 },	// U+1C21 (ᰡ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0bb0, 0x0448, 0x0aa8, 0x0aa8, 0x0448, 0x0010, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+1C22 (ᰢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0490, 0x0280, 0x01c0, 0x0520, 0x0220, 0x05c0, 0x0000, 0x0000, 0x0000 },	// U+1C23 (ᰣ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x5000, 0x5000, 0x2000, 0x0000, 0x0000, 0x0000 },	// U+1C24 (ᰤ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+1C25 (ᰥ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x8000, 0x0000, 0x0000, 0x0000 },	// U+1C26 (ᰦ)
	{ 0x0000, 0x0000, 0x0002, 0x0005, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0000, 0x0000 },	// U+1C27 (ᰧ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0004, 0x0000, 0x0000, 0x0000 },	// U+1C28 (ᰨ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03fc, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0004, 0x0000, 0x0000, 0x0000 },	// U+1C29 (ᰩ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x4800, 0x3000 },	// U+1C2A (ᰪ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x8000, 0x4000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x4800, 0x3000 },	// U+1C2B (ᰫ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0020, 0x00f0 },	// U+1C2C (ᰬ)
	{ 0x0000, 0x0080, 0x0040, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C2D (ᰭ)
	{ 0x0000, 0x0000, 0x0140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C2E (ᰮ)
	{ 0x0000, 0x0080, 0x0220, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C2F (ᰯ)
	{ 0x0000, 0x03c0, 0x0420, 0x0300, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C30 (ᰰ)
	{ 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C31 (ᰱ)
	{ 0x0000, 0x04c0, 0x0320, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C32 (ᰲ)
	{ 0x0000, 0x0000, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C33 (ᰳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0002, 0x0005, 0x0005, 0x0005, 0x0002, 0x0001, 0x0000, 0x0000, 0x0000 },	// U+1C34 (ᰴ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0001, 0x0001, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C35 (ᰵ)
	{ 0x07f0, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C36 (ᰶ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0000 },	// U+1C37 (᰷)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x73c6, 0x6dbe, 0x738e, 0x6dbe, 0x73c6, 0x7ffe, 0x0000 },	// U+1C38 (᰸)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x73c6, 0x6dbe, 0x638e, 0x6fbe, 0x73c6, 0x7ffe, 0x0000 },	// U+1C39 (᰹)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x61c6, 0x6dbe, 0x618e, 0x6dbe, 0x6dc6, 0x7ffe, 0x0000 },	// U+1C3A (᰺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+1C3B (᰻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0000, 0x0000, 0x0000 },	// U+1C3C (᰼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x0280, 0x0100, 0x0280, 0x0440, 0x0000, 0x0000, 0x0000 },	// U+1C3D (᰽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x0280, 0x0920, 0x0280, 0x0440, 0x0000, 0x0000, 0x0000 },	// U+1C3E (᰾)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1108, 0x0890, 0x0520, 0x0420, 0x0520, 0x0890, 0x1108, 0x0000, 0x0000, 0x0000 },	// U+1C3F (᰿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0220, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C40 (᱀)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0340, 0x0280, 0x0200, 0x0100, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1C41 (᱁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0300, 0x00c0, 0x0020, 0x00c0, 0x0300, 0x0000, 0x0000, 0x0000 },	// U+1C42 (᱂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x0208, 0x07e0, 0x0810, 0x0400, 0x03e0, 0x0400, 0x0000, 0x0000, 0x0000 },	// U+1C43 (᱃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x03a0, 0x0020, 0x0010, 0x0c10, 0x03e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1C44 (᱄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x0420, 0x0620, 0x0520, 0x04a0, 0x0460, 0x0810, 0x0000, 0x0000, 0x0000 },	// U+1C45 (᱅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0a00, 0x0100, 0x0200, 0x0410, 0x0860, 0x0780, 0x0000, 0x0000, 0x0000 },	// U+1C46 (᱆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0220, 0x0240, 0x0240, 0x0280, 0x0180, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+1C47 (᱇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0040, 0x0020, 0x0020, 0x01c0, 0x0600, 0x0000, 0x0000, 0x0000 },	// U+1C48 (᱈)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0140, 0x0640, 0x0040, 0x0040, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1C49 (᱉)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x61b6, 0x6db6, 0x6186, 0x6dbe, 0x6dbe, 0x7ffe, 0x0000 },	// U+1C4A (᱊)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x71b6, 0x6db6, 0x7186, 0x6dbe, 0x71be, 0x7ffe, 0x0000 },	// U+1C4B (᱋)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x63b6, 0x7db6, 0x7d86, 0x7dbe, 0x63be, 0x7ffe, 0x0000 },	// U+1C4C (᱌)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x0100, 0x07c0, 0x0100, 0x0100, 0x0100, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1C4D (ᱍ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f8, 0x0100, 0x07c0, 0x0100, 0x07c0, 0x0100, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+1C4E (ᱎ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x04b0, 0x07c8, 0x0480, 0x0480, 0x0480, 0x04f0, 0x0208, 0x0000, 0x0000, 0x0000 },	// U+1C4F (ᱏ)
}; // 399

static const uint16_t unifontdw_block135[][16] = {
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x63ce, 0x6fb6, 0x73ce, 0x7ffe, 0x0000 },	// U+1C89 (Ᲊ)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x61ce, 0x6db6, 0x61ce, 0x6db6, 0x6dce, 0x7ffe, 0x0000 },	// U+1C8A (ᲊ)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x71ce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+1C8B (᲋)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7dce, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+1C8C (᲌)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6dce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+1C8D (᲍)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+1C8E (᲎)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+1C8F (᲏)
}; // 7

static const uint16_t unifontdw_block136[][16] = {
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71c6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+1CBB (᲻)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7dc6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+1CBC (᲼)
}; // 2

static const uint16_t unifontdw_block137[][16] = {
	{ 0x0000, 0x0000, 0x0140, 0x0080, 0x01c0, 0x0220, 0x1494, 0x0d58, 0x1494, 0x0220, 0x01c0, 0x0080, 0x0140, 0x0000, 0x0000, 0x0000 },	// U+1CC0 (᳀)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0aa0, 0x0920, 0x0aa0, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CC1 (᳁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0ba0, 0x0820, 0x0ba0, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CC2 (᳂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0820, 0x0820, 0x0820, 0x0440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CC3 (᳃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xddd8, 0x1004, 0xd3c4, 0x0812, 0x69aa, 0x0429, 0x354f, 0x0400, 0x1380, 0x1240, 0x0d80, 0x0000 },	// U+1CC4 (᳄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1f38, 0x0020, 0x0f20, 0x0010, 0x0790, 0x0008, 0x03c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CC5 (᳅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xff70, 0x0008, 0x7f08, 0x0044, 0x3ca4, 0x0122, 0x1a3e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CC6 (᳆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xbe66, 0x2110, 0xa013, 0x1188, 0xd289, 0x0a44, 0x6c7d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CC7 (᳇)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x73f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+1CC8 (᳈)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x63f6, 0x6ff6, 0x738e, 0x7ffe, 0x0000 },	// U+1CC9 (᳉)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x618e, 0x6df6, 0x61f6, 0x6df6, 0x6d8e, 0x7ffe, 0x0000 },	// U+1CCA (᳊)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x71f6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+1CCB (᳋)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x638e, 0x7df6, 0x7df6, 0x7df6, 0x638e, 0x7ffe, 0x0000 },	// U+1CCC (᳌)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x6df6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+1CCD (᳍)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+1CCE (᳎)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+1CCF (᳏)
	{ 0x0100, 0x0280, 0x0440, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CD0 (᳐)
	{ 0x0100, 0x0380, 0x0540, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CD1 (᳑)
	{ 0x0000, 0x07c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CD2 (᳒)
	{ 0x0000, 0x0480, 0x0240, 0x0120, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CD3 (᳓)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CD4 (᳔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0910, 0x0920, 0x06c0 },	// U+1CD5 (᳕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x07e0 },	// U+1CD6 (᳖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c0, 0x0020, 0x07c0 },	// U+1CD7 (᳗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0420, 0x0440, 0x0380 },	// U+1CD8 (᳘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0280, 0x0440 },	// U+1CD9 (᳙)
	{ 0x0280, 0x0280, 0x0280, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CDA (᳚)
	{ 0x0540, 0x0540, 0x0540, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CDB (᳛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100, 0x0100 },	// U+1CDC (᳜)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0000 },	// U+1CDD (᳝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0480, 0x0000 },	// U+1CDE (᳞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0920, 0x0000 },	// U+1CDF (᳟)
	{ 0x3e00, 0x0100, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CE0 (᳠)
	{ 0x3000, 0x4800, 0x8800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0f00 },	// U+1CE1 (᳡)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0000, 0x07e0, 0x0000, 0x0240, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CE2 (᳢)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0800, 0x1000, 0x1000, 0x0e00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CE3 (᳣)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0010, 0x0008, 0x0008, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CE4 (᳤)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0008, 0x0008, 0x0010, 0x0020, 0x0000, 0x0000, 0x0000 },	// U+1CE5 (᳥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e00, 0x1000, 0x1000, 0x0800, 0x0400, 0x0000, 0x0000, 0x0000 },	// U+1CE6 (᳦)
	{ 0x0000, 0x0000, 0x1800, 0x2400, 0x0400, 0x0800, 0x1000, 0x1000, 0x0e00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CE7 (᳧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0008, 0x0008, 0x0010, 0x0020, 0x0024, 0x0018, 0x0000 },	// U+1CE8 (᳨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x1634, 0x1004, 0x1004, 0x1004, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+1CE9 (ᳩ)
	{ 0x0000, 0x0000, 0x0000, 0x0220, 0x0550, 0x0550, 0x0220, 0x0410, 0x0808, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+1CEA (ᳪ)
	{ 0x0000, 0x0000, 0x0000, 0x0620, 0x0950, 0x0e50, 0x0820, 0x0810, 0x0808, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000, 0x0000 },	// U+1CEB (ᳫ)
	{ 0x0000, 0x0000, 0x0000, 0x0020, 0x0450, 0x0a50, 0x0a20, 0x0c10, 0x1808, 0x2808, 0x2408, 0x1210, 0x01e0, 0x0000, 0x0000, 0x0000 },	// U+1CEC (ᳬ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0100, 0x0200, 0x0400 },	// U+1CED (᳭)
	{ 0x0000, 0x0000, 0x0000, 0x01e0, 0x0010, 0x0010, 0x0010, 0x04e0, 0x0020, 0x0020, 0x0220, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CEE (ᳮ)
	{ 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0090, 0x0020, 0x03c0, 0x0020, 0x00a0, 0x0120, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CEF (ᳯ)
	{ 0x0000, 0x0180, 0x0240, 0x0040, 0x0880, 0x0180, 0x0240, 0x0420, 0x0420, 0x0420, 0x0240, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CF0 (ᳰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0020, 0x0210, 0x0010, 0x07e0, 0x0800, 0x0840, 0x0400, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+1CF1 (ᳱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x0420, 0x03c0, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CF2 (ᳲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x0420, 0x0240, 0x0240, 0x0240, 0x0240, 0x0420, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CF3 (ᳳ)
	{ 0x0000, 0x0108, 0x0110, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CF4 (᳴)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0809, 0x8410, 0x0221, 0x8140, 0x0081, 0x8140, 0x0221, 0x8410, 0x0809, 0x8000, 0x0001, 0xaaaa },	// U+1CF5 (ᳵ)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8888, 0x0889, 0x8770, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+1CF6 (ᳶ)
	{ 0xc000, 0x2000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x0000 },	// U+1CF7 (᳷)
	{ 0x0000, 0x00c0, 0x0120, 0x0120, 0x00c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CF8 (᳸)
	{ 0x0000, 0x0c18, 0x1224, 0x1224, 0x0c18, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1CF9 (᳹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x0e38, 0x07f0, 0x0000, 0x0630, 0x0948, 0x0e38, 0x07f0, 0x0000, 0x0000, 0x0000 },	// U+1CFA (ᳺ)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+1CFB (᳻)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+1CFC (᳼)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+1CFD (᳽)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+1CFE (᳾)
	{ 0x0000, 0x7ffe, 0x63de, 0x7dce, 0x7dde, 0x7dde, 0x638e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+1CFF (᳿)
}; // 64

static const uint16_t unifontdw_block138[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x1200, 0x0a08, 0x0608, 0x3a08, 0x473e, 0x4288, 0x4248, 0x4228, 0x4218, 0x4208, 0x4234, 0x0000, 0x0000 },	// U+1D7A (ᵺ)
}; // 1

static const uint16_t unifontdw_block139[][16] = {
	{ 0x0000, 0x0180, 0x0660, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+1DCD (᷍)
}; // 1

static const uint16_t unifontdw_block140[][16] = {
	{ 0x0000, 0x7ffe, 0x71de, 0x6dce, 0x6dde, 0x6dde, 0x718e, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+1DFA (᷺)
}; // 1

static const uint16_t unifontdw_block141[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x1818, 0x2004 },	// U+1DFC (᷼)
}; // 1

static const uint16_t unifontdw_block142[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x73de, 0x7dce, 0x71de, 0x6dde, 0x738e, 0x7ffe, 0x0000 },	// U+1F16 (἖)
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x61de, 0x6fce, 0x77de, 0x7bde, 0x7b8e, 0x7ffe, 0x0000 },	// U+1F17 (἗)
}; // 2

static const uint16_t unifontdw_block143[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x618e, 0x7ffe, 0x0000 },	// U+1F1E (἞)
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x0000 },	// U+1F1F (἟)
}; // 2

static const uint16_t unifontdw_block144[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x73b6, 0x7db6, 0x7186, 0x6dbe, 0x73be, 0x7ffe, 0x0000 },	// U+1F46 (὆)
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x61b6, 0x6fb6, 0x7786, 0x7bbe, 0x7bbe, 0x7ffe, 0x0000 },	// U+1F47 (὇)
}; // 2

static const uint16_t unifontdw_block145[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x61be, 0x7ffe, 0x0000 },	// U+1F4E (὎)
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x7dbe, 0x7ffe, 0x0000 },	// U+1F4F (὏)
}; // 2

static const uint16_t unifontdw_block146[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x7386, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+1F58 (὘)
}; // 1

static const uint16_t unifontdw_block147[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x6186, 0x6dbe, 0x6d86, 0x7ffe, 0x0000 },	// U+1F5A (὚)
}; // 1

static const uint16_t unifontdw_block148[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7d86, 0x7dbe, 0x6386, 0x7ffe, 0x0000 },	// U+1F5C (὜)
}; // 1

static const uint16_t unifontdw_block149[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+1F5E (὞)
}; // 1

static const uint16_t unifontdw_block150[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+1F7E (὾)
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+1F7F (὿)
}; // 2

static const uint16_t unifontdw_block151[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x61c6, 0x6fb6, 0x61c6, 0x7ffe, 0x0000 },	// U+1FB5 (᾵)
}; // 1

static const uint16_t unifontdw_block152[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x61f6, 0x6ff6, 0x618e, 0x7ffe, 0x0000 },	// U+1FC5 (῅)
}; // 1

static const uint16_t unifontdw_block153[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x6dc6, 0x6db6, 0x61b6, 0x6fb6, 0x6fc6, 0x7ffe, 0x0000 },	// U+1FD4 (῔)
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x61b6, 0x6fb6, 0x61c6, 0x7ffe, 0x0000 },	// U+1FD5 (῕)
}; // 2

static const uint16_t unifontdw_block154[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7db6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+1FDC (῜)
}; // 1

static const uint16_t unifontdw_block155[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+1FF0 (῰)
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x63f6, 0x7ffe, 0x0000 },	// U+1FF1 (῱)
}; // 2

static const uint16_t unifontdw_block156[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+1FF5 (῵)
}; // 1

static const uint16_t unifontdw_block157[][16] = {
	{ 0x0000, 0x7ffe, 0x61de, 0x7dce, 0x71de, 0x7dde, 0x7d8e, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+1FFF (῿)
}; // 1

static const uint16_t unifontdw_block158[][16] = {
	{ 0x5555, 0x8000, 0x2279, 0xa240, 0x2a21, 0xaa10, 0x3609, 0xa278, 0x0001, 0x9c70, 0x2409, 0x9c30, 0x0441, 0x8438, 0x0001, 0xaaaa },	// U+200B (​)
	{ 0x5555, 0x8000, 0x2279, 0xa240, 0x2a21, 0xaa10, 0x3609, 0xa278, 0x0001, 0x9048, 0x1059, 0x9268, 0x1249, 0x8c48, 0x0001, 0xaaaa },	// U+200C (‌)
	{ 0x5555, 0x8000, 0x2279, 0xa240, 0x2a21, 0xaa10, 0x3609, 0xa278, 0x0001, 0x8200, 0x0201, 0x8240, 0x0241, 0x8180, 0x0001, 0xaaaa },	// U+200D (‍)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x44e3, 0xed22, 0x54e3, 0xc4a2, 0x452f, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+200E (‎)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x444f, 0xec52, 0x544f, 0xc44a, 0x45d3, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+200F (‏)
}; // 5

static const uint16_t unifontdw_block159[][16] = {
	{ 0x5555, 0x8000, 0x0001, 0x8040, 0x0041, 0x8040, 0x0041, 0x83c0, 0x0001, 0xbbdc, 0x4843, 0xbbcc, 0x0851, 0x8bce, 0x0001, 0xaaaa },	// U+2028 ( )
	{ 0x5555, 0x8000, 0x0001, 0x81c0, 0x0241, 0x81c0, 0x0041, 0x8040, 0x0001, 0xbbdc, 0x4843, 0xbbcc, 0x0851, 0x8bce, 0x0001, 0xaaaa },	// U+2029 ( )
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x79c3, 0x8a42, 0x79c3, 0x8942, 0x7a5f, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+202A (‪)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x784f, 0x8852, 0x784f, 0x884a, 0x7bd3, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+202B (‫)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x79cf, 0x8a52, 0x7a4f, 0x8a42, 0x09c3, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+202C (‬)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x31c3, 0xca42, 0x49c3, 0xc942, 0x325f, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+202D (‭)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x304f, 0xc852, 0x484f, 0xc84a, 0x33d3, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+202E (‮)
}; // 7

static const uint16_t unifontdw_block160[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0xcccc, 0x6666, 0x2222, 0x1111, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2057 (⁗)
}; // 1

static const uint16_t unifontdw_block161[][16] = {
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x1045, 0x9044, 0x1055, 0x916c, 0x0e45, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+2060 (⁠)
	{ 0x5555, 0x8000, 0x0031, 0x8008, 0x1109, 0x9108, 0x2089, 0xa088, 0x2089, 0xa0be, 0x2089, 0xa088, 0x1109, 0x9106, 0x0001, 0xaaaa },	// U+2061 (⁡)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8420, 0x0241, 0x8180, 0x0241, 0x8420, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+2062 (⁢)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0x8018, 0x0011, 0x8010, 0x0009, 0xaaaa },	// U+2063 (⁣)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x0001, 0x8080, 0x0081, 0x8080, 0x07f1, 0x8080, 0x0081, 0x8080, 0x0081, 0x8000, 0x0001, 0xaaaa },	// U+2064 (⁤)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x61c6, 0x6fb6, 0x61ce, 0x7ffe, 0x0000 },	// U+2065 (⁥)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x39c5, 0x9244, 0x11c5, 0x9144, 0x3a5d, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+2066 (⁦)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x389d, 0x90a4, 0x109d, 0x9094, 0x3ba5, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+2067 (⁧)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x3b9d, 0x9044, 0x119d, 0x9204, 0x39c5, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+2068 (⁨)
	{ 0x5555, 0x8000, 0x0001, 0x8000, 0x39cf, 0x9252, 0x124f, 0x9242, 0x39c3, 0x8000, 0x0001, 0x8000, 0x0001, 0x8000, 0x0001, 0xaaaa },	// U+2069 (⁩)
	{ 0x5555, 0x8000, 0x0001, 0x83e0, 0x0081, 0x8080, 0x0081, 0x83e0, 0x0001, 0x9e78, 0x0105, 0x8e38, 0x1041, 0x8f3c, 0x0001, 0xaaaa },	// U+206A (⁪)
	{ 0x5555, 0x8000, 0x0001, 0x81c0, 0x0221, 0x83e0, 0x0221, 0x8220, 0x0001, 0x9e78, 0x0105, 0x8e38, 0x1041, 0x8f3c, 0x0001, 0xaaaa },	// U+206B (⁫)
	{ 0x5555, 0x8000, 0x0001, 0x87c0, 0x0101, 0x8100, 0x0101, 0x87c0, 0x0001, 0x6f9c, 0x10a3, 0xe7be, 0x80a3, 0xf0a2, 0x0001, 0xaaaa },	// U+206C (⁬)
	{ 0x5555, 0x8000, 0x0001, 0x8380, 0x0441, 0x87c0, 0x0441, 0x8440, 0x0001, 0x6f9c, 0x10a3, 0xe7be, 0x80a3, 0xf0a2, 0x0001, 0xaaaa },	// U+206D (⁭)
	{ 0x5555, 0x8000, 0x0001, 0x8e44, 0x114d, 0x9f54, 0x1165, 0x9144, 0x0001, 0x9e3c, 0x0145, 0x8e44, 0x1045, 0x8f3c, 0x0001, 0xaaaa },	// U+206E (⁮)
	{ 0x5555, 0x8000, 0x0001, 0x8e44, 0x114d, 0x9154, 0x1165, 0x8e44, 0x0001, 0x9e3c, 0x0145, 0x8e44, 0x1045, 0x8f3c, 0x0001, 0xaaaa },	// U+206F (⁯)
}; // 16

static const uint16_t unifontdw_block162[][16] = {
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x61de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+2072 (⁲)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x7186, 0x6fbe, 0x63de, 0x6fee, 0x71ee, 0x7ffe, 0x0000 },	// U+2073 (⁳)
}; // 2

static const uint16_t unifontdw_block163[][16] = {
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+208F (₏)
}; // 1

static const uint16_t unifontdw_block164[][16] = {
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6d8e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+209D (₝)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x61ce, 0x7ffe, 0x0000 },	// U+209E (₞)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x7dce, 0x7ffe, 0x0000 },	// U+209F (₟)
}; // 3

static const uint16_t unifontdw_block165[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0180, 0x0200, 0x0ff0, 0x0200, 0x0100, 0x00f0, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0000 },	// U+20B9 (₹)
}; // 1

static const uint16_t unifontdw_block166[][16] = {
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x6df6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+20C0 (⃀)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x778e, 0x73f6, 0x77f6, 0x77f6, 0x638e, 0x7ffe, 0x0000 },	// U+20C1 (⃁)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x618e, 0x6ff6, 0x61f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+20C2 (⃂)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x718e, 0x6ff6, 0x63f6, 0x6ff6, 0x718e, 0x7ffe, 0x0000 },	// U+20C3 (⃃)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x6d8e, 0x6df6, 0x61f6, 0x6ff6, 0x6f8e, 0x7ffe, 0x0000 },	// U+20C4 (⃄)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x61f6, 0x6ff6, 0x618e, 0x7ffe, 0x0000 },	// U+20C5 (⃅)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x738e, 0x7df6, 0x71f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+20C6 (⃆)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x618e, 0x6ff6, 0x77f6, 0x7bf6, 0x7b8e, 0x7ffe, 0x0000 },	// U+20C7 (⃇)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x73f6, 0x6df6, 0x738e, 0x7ffe, 0x0000 },	// U+20C8 (⃈)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x738e, 0x6df6, 0x63f6, 0x6ff6, 0x738e, 0x7ffe, 0x0000 },	// U+20C9 (⃉)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x618e, 0x6df6, 0x61f6, 0x6df6, 0x6d8e, 0x7ffe, 0x0000 },	// U+20CA (⃊)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x71f6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+20CB (⃋)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x638e, 0x7df6, 0x7df6, 0x7df6, 0x638e, 0x7ffe, 0x0000 },	// U+20CC (⃌)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x718e, 0x6df6, 0x6df6, 0x6df6, 0x718e, 0x7ffe, 0x0000 },	// U+20CD (⃍)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x618e, 0x7ffe, 0x0000 },	// U+20CE (⃎)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+20CF (⃏)
}; // 16

static const uint16_t unifontdw_block167[][16] = {
	{ 0x0000, 0x01c0, 0x0630, 0x180c, 0x1004, 0x2002, 0x2002, 0x4001, 0x4001, 0x4001, 0x2002, 0x2002, 0x1004, 0x180c, 0x0630, 0x01c0 },	// U+20DD (⃝)
	{ 0x0000, 0x7ffe, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x7ffe, 0x0000 },	// U+20DE (⃞)
	{ 0x0000, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x1004, 0x2002, 0x4001, 0x2002, 0x1004, 0x0808, 0x0410, 0x0220, 0x0140, 0x0080 },	// U+20DF (⃟)
	{ 0x0000, 0x01c0, 0x0630, 0x180c, 0x100c, 0x201a, 0x2032, 0x4061, 0x40c1, 0x4181, 0x2302, 0x2602, 0x1c04, 0x180c, 0x0630, 0x01c0 },	// U+20E0 (⃠)
}; // 4

static const uint16_t unifontdw_block168[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x3ffc, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x3ffc, 0x7ffe, 0x0000 },	// U+20E2 (⃢)
	{ 0x0000, 0x3ffc, 0x6006, 0x5ffa, 0x500a, 0x500a, 0x500a, 0x500a, 0x500a, 0x500a, 0x500a, 0x500a, 0x5ffa, 0x6006, 0x3ffc, 0x0000 },	// U+20E3 (⃣)
	{ 0x0100, 0x0380, 0x0280, 0x06c0, 0x0440, 0x0820, 0x0820, 0x1010, 0x1010, 0x3018, 0x2008, 0x2008, 0x4004, 0x4004, 0x7ffc, 0x0000 },	// U+20E4 (⃤)
}; // 3

static const uint16_t unifontdw_block169[][16] = {
	{ 0x0000, 0xfff8, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0000 },	// U+20E7 (⃧)
}; // 1

static const uint16_t unifontdw_block170[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0010, 0x3ff8, 0x0010, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+20EA (⃪)
}; // 1

static const uint16_t unifontdw_block171[][16] = {
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x63f6, 0x7ffe, 0x0000 },	// U+20F1 (⃱)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+20F2 (⃲)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x71f6, 0x7ffe, 0x0000 },	// U+20F3 (⃳)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6ff6, 0x7ffe, 0x0000 },	// U+20F4 (⃴)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+20F5 (⃵)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+20F6 (⃶)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+20F7 (⃷)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+20F8 (⃸)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+20F9 (⃹)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+20FA (⃺)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+20FB (⃻)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+20FC (⃼)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+20FD (⃽)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+20FE (⃾)
	{ 0x0000, 0x7ffe, 0x7386, 0x6dbe, 0x6d86, 0x6df6, 0x7386, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+20FF (⃿)
}; // 15

static const uint16_t unifontdw_block172[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0200, 0x0100, 0x0100, 0x0f00, 0x1180, 0x1080, 0x1080, 0x0840, 0x0840, 0x0840, 0x0420, 0x0000, 0x0000 },	// U+210E (ℎ)
	{ 0x0000, 0x0000, 0x0000, 0x0a00, 0x0700, 0x01c0, 0x0f20, 0x1180, 0x1080, 0x1080, 0x0840, 0x0840, 0x0840, 0x0420, 0x0000, 0x0000 },	// U+210F (ℏ)
}; // 2

static const uint16_t unifontdw_block173[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1818, 0x1818, 0x1ff8, 0x0018, 0x0018, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+212E (℮)
}; // 1

static const uint16_t unifontdw_block174[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x17f8, 0x0c04, 0x0a04, 0x0a04, 0x0c04, 0x07f8, 0x0000, 0x0000 },	// U+213A (℺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x003e, 0x0002, 0x0002, 0x0002, 0x444e, 0x28a2, 0x1112, 0x11f2, 0x2912, 0x4512, 0x0000, 0x0000 },	// U+213B (℻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x0a50, 0x0a50, 0x0a50, 0x0a50, 0x1250, 0x2450, 0x3870, 0x0000, 0x0000 },	// U+213C (ℼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2030, 0x1050, 0x0890, 0x0520, 0x0240, 0x0240, 0x0120, 0x0090, 0x0048, 0x0038 },	// U+213D (ℽ)
}; // 4

static const uint16_t unifontdw_block175[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1ffc, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0e38, 0x0000, 0x0000 },	// U+213F (ℿ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1448, 0x1890, 0x1120, 0x0240, 0x0240, 0x0120, 0x1090, 0x1848, 0x1428, 0x1ff8, 0x0000 },	// U+2140 (⅀)
}; // 2

static const uint16_t unifontdw_block176[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0ca0, 0x14a0, 0x1490, 0x1450, 0x1250, 0x0a48, 0x0a28, 0x0628, 0x03f8, 0x0000, 0x0000 },	// U+2145 (ⅅ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c00, 0x1400, 0x1400, 0x1200, 0x0be0, 0x0a50, 0x0948, 0x0528, 0x0528, 0x07f0, 0x0000, 0x0000 },	// U+2146 (ⅆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x08a0, 0x0890, 0x0fc8, 0x0028, 0x0028, 0x0428, 0x03f0, 0x0000, 0x0000 },	// U+2147 (ⅇ)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0200, 0x0000, 0x0700, 0x0280, 0x0280, 0x0280, 0x0140, 0x0140, 0x0140, 0x07f0, 0x0000, 0x0000 },	// U+2148 (ⅈ)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x0800, 0x0000, 0x1c00, 0x0a00, 0x0a00, 0x0a00, 0x0500, 0x0500, 0x0500, 0x0500, 0x0310, 0x00e0 },	// U+2149 (ⅉ)
}; // 5

static const uint16_t unifontdw_block177[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x032c, 0x04b2, 0x04a4, 0x04a0, 0x1ff8, 0x24a4, 0x23f8, 0x10a0, 0x00a0, 0x0040, 0x0000, 0x0000 },	// U+214C (⅌)
}; // 1

static const uint16_t unifontdw_block178[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0888, 0x1554, 0x1554, 0x1554, 0x0888, 0x3776, 0x0000, 0x0000 },	// U+214F (⅏)
}; // 1

static const uint16_t unifontdw_block179[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0490, 0x09c8, 0x0aa8, 0x0aa8, 0x0aa8, 0x0aa8, 0x09c8, 0x0490, 0x03e0, 0x0000, 0x0000 },	// U+2182 (ↂ)
}; // 1

static const uint16_t unifontdw_block180[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x07f0, 0x188c, 0x23e2, 0x2492, 0x29ca, 0x2aaa, 0x29ca, 0x2492, 0x23e2, 0x188c, 0x07f0, 0x0000, 0x0000 },	// U+2188 (ↈ)
}; // 1

static const uint16_t unifontdw_block181[][16] = {
	{ 0x0000, 0x7ffe, 0x7786, 0x73be, 0x7786, 0x77f6, 0x6386, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7dce, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+218C (↌)
	{ 0x0000, 0x7ffe, 0x7786, 0x73be, 0x7786, 0x77f6, 0x6386, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6dce, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+218D (↍)
	{ 0x0000, 0x7ffe, 0x7786, 0x73be, 0x7786, 0x77f6, 0x6386, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+218E (↎)
	{ 0x0000, 0x7ffe, 0x7786, 0x73be, 0x7786, 0x77f6, 0x6386, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x71ce, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+218F (↏)
}; // 4

static const uint16_t unifontdw_block182[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x001c, 0x380c, 0x4414, 0x8220, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+219C (↜)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3800, 0x301c, 0x2822, 0x0441, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+219D (↝)
}; // 2

static const uint16_t unifontdw_block183[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x10e0, 0x2110, 0x7fff, 0x2110, 0x10e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+21F4 (⇴)
}; // 1

static const uint16_t unifontdw_block184[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0490, 0x0888, 0x1ffc, 0x0888, 0x0490, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+21F9 (⇹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0288, 0x0284, 0xfffe, 0x0284, 0x0288, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+21FA (⇺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1140, 0x2140, 0x7fff, 0x2140, 0x1140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+21FB (⇻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0948, 0x1144, 0x3ffe, 0x1144, 0x0948, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+21FC (⇼)
}; // 4

static const uint16_t unifontdw_block185[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x1818, 0x2ff4, 0x1818, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+21FF (⇿)
}; // 1

static const uint16_t unifontdw_block186[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x300c, 0x7812, 0x7ff2, 0x7812, 0x300c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22B6 (⊶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x300c, 0x481e, 0x4ffe, 0x481e, 0x300c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22B7 (⊷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c00, 0x2200, 0x23fc, 0x2200, 0x1c00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22B8 (⊸)
}; // 3

static const uint16_t unifontdw_block187[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4440, 0x2220, 0x1110, 0x0888, 0x0444, 0x0888, 0x1110, 0x2220, 0x4440, 0x0000, 0x0000 },	// U+22D8 (⋘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0222, 0x0444, 0x0888, 0x1110, 0x2220, 0x1110, 0x0888, 0x0444, 0x0222, 0x0000, 0x0000 },	// U+22D9 (⋙)
}; // 2

static const uint16_t unifontdw_block188[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0010, 0x0008, 0x0008, 0x0ffe, 0x0008, 0x0008, 0x0010, 0x0fe0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22F2 (⋲)
	{ 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0010, 0x0008, 0x0808, 0x0ff8, 0x0808, 0x0008, 0x0010, 0x0fe0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22F3 (⋳)
}; // 2

static const uint16_t unifontdw_block189[][16] = {
	{ 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0fe0, 0x0010, 0x0008, 0x0008, 0x0ff8, 0x0008, 0x0008, 0x0010, 0x0fe0, 0x0000, 0x0000 },	// U+22F5 (⋵)
	{ 0x0000, 0x0ff8, 0x0000, 0x0fe0, 0x0010, 0x0008, 0x0008, 0x0ff8, 0x0008, 0x0008, 0x0010, 0x0fe0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22F6 (⋶)
}; // 2

static const uint16_t unifontdw_block190[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x03f8, 0x0004, 0x0002, 0x03fe, 0x0002, 0x03fe, 0x0002, 0x0004, 0x03f8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22F9 (⋹)
	{ 0x0000, 0x0000, 0x0000, 0x01fc, 0x0200, 0x0400, 0x0400, 0x1ffc, 0x0400, 0x0400, 0x0200, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22FA (⋺)
	{ 0x0000, 0x0000, 0x0000, 0x01fc, 0x0200, 0x0400, 0x0404, 0x07fc, 0x0404, 0x0400, 0x0200, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22FB (⋻)
}; // 3

static const uint16_t unifontdw_block191[][16] = {
	{ 0x0000, 0x07fc, 0x0000, 0x01fc, 0x0200, 0x0400, 0x0400, 0x07fc, 0x0400, 0x0400, 0x0200, 0x01fc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22FD (⋽)
}; // 1

static const uint16_t unifontdw_block192[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x1ff0, 0x0010, 0x0010, 0x0010, 0x1ff0, 0x0010, 0x0010, 0x0010, 0x1ff0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+22FF (⋿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x0be0, 0x0410, 0x0a08, 0x0908, 0x0888, 0x0848, 0x0828, 0x0410, 0x03e8, 0x0004, 0x0000 },	// U+2300 (⌀)
}; // 2

static const uint16_t unifontdw_block193[][16] = {
	{ 0x0000, 0x0100, 0x0100, 0x07c0, 0x0920, 0x1110, 0x2108, 0x2108, 0xfffe, 0x2108, 0x2108, 0x1110, 0x0920, 0x07c0, 0x0100, 0x0100 },	// U+2316 (⌖)
}; // 1

static const uint16_t unifontdw_block194[][16] = {
	{ 0x1000, 0x1000, 0x0800, 0x0800, 0x0400, 0x0400, 0x0200, 0x0200, 0x0200, 0x0400, 0x0400, 0x0800, 0x0800, 0x1000, 0x1000, 0x0000 },	// U+2329 (〈)
	{ 0x0004, 0x0004, 0x0008, 0x0008, 0x0010, 0x0010, 0x0020, 0x0020, 0x0020, 0x0010, 0x0010, 0x0008, 0x0008, 0x0004, 0x0004, 0x0000 },	// U+232A (〉)
}; // 2

static const uint16_t unifontdw_block195[][16] = {
	{ 0x0000, 0x0100, 0x0280, 0x0440, 0x0920, 0x1210, 0x1450, 0x1050, 0x1450, 0x1210, 0x0920, 0x0440, 0x0280, 0x0100, 0x0000, 0x0000 },	// U+232C (⌬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x8100, 0x4080, 0x2380, 0x2440, 0x1820, 0x0820, 0x0830, 0x0448, 0x0388, 0x0204, 0x0102, 0x0000 },	// U+232D (⌭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x1008, 0x7f08, 0x1088, 0x1048, 0x0850, 0x0420, 0x03d4, 0x000c, 0x001c },	// U+232E (⌮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x0000, 0x0000, 0x7ffe, 0x0000, 0x0000, 0x0ff0, 0x0000, 0x0000, 0x0000 },	// U+232F (⌯)
	{ 0x0000, 0x4020, 0x6030, 0xf078, 0x2010, 0x1008, 0x1008, 0x0804, 0x0804, 0x0402, 0x0402, 0x0201, 0x0201, 0x03ff, 0x0000, 0x0000 },	// U+2330 (⌰)
	{ 0x0000, 0x0000, 0x0000, 0x00f8, 0x0124, 0x0222, 0x0421, 0x2421, 0xffe1, 0x2421, 0x0421, 0x0222, 0x0124, 0x00f8, 0x0000, 0x0000 },	// U+2331 (⌱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x003c, 0x01c4, 0x0e04, 0x3004, 0x7ffe, 0x3004, 0x0e04, 0x01c4, 0x003c, 0x0000, 0x0000 },	// U+2332 (⌲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x003a, 0x01c2, 0x0e02, 0x3002, 0x7ffe, 0x0000, 0x0000 },	// U+2333 (⌳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x7ffe, 0x0000, 0x0000 },	// U+2334 (⌴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8002, 0x4004, 0x2008, 0x1010, 0x0820, 0x0440, 0x0280, 0x0100, 0x0000, 0x0000 },	// U+2335 (⌵)
}; // 10

static const uint16_t unifontdw_block196[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x4000, 0x2000, 0x1000, 0x0800, 0x3f80, 0x0200, 0x0100, 0x0082, 0x0044, 0x0028, 0x0010, 0x0000, 0x0000 },	// U+237B (⍻)
	{ 0x0000, 0x0000, 0x0050, 0x0030, 0x0010, 0x0018, 0x0014, 0x0018, 0x0010, 0x0030, 0x0050, 0x0030, 0x7ff2, 0x000a, 0x0006, 0x001e },	// U+237C (⍼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c1e, 0x0410, 0x0410, 0x07f0, 0x0000, 0x0000 },	// U+237D (⍽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x1008, 0x1008, 0x1ff8, 0x0420, 0x0420, 0x0420, 0x1c38, 0x0000, 0x0000 },	// U+237E (⍾)
}; // 4

static const uint16_t unifontdw_block197[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001c, 0x0020, 0x003c, 0x0022, 0x0022, 0x2a5c, 0x0000, 0x3ffe, 0x0000, 0x0000 },	// U+2381 (⎁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e1c, 0x1020, 0x1e3c, 0x1122, 0x1122, 0x2e5c, 0x0000, 0x3f7e, 0x0000, 0x0000 },	// U+2382 (⎂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2002, 0x1004, 0x09c8, 0x0200, 0x3bce, 0x0220, 0x0a28, 0x15c4, 0x2002, 0x0000, 0x0000, 0x0000 },	// U+2383 (⎃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ffc, 0x1084, 0x2044, 0x2044, 0x2044, 0x2044, 0x1084, 0x0ffc, 0x0000, 0x0000 },	// U+2384 (⎄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0eb8, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0eb8, 0x0080, 0x0080 },	// U+2385 (⎅)
	{ 0x0000, 0x0080, 0x0140, 0x0220, 0x0410, 0x0848, 0x10c0, 0x217e, 0x4202, 0x217e, 0x10c0, 0x0848, 0x0410, 0x0220, 0x0140, 0x0080 },	// U+2386 (⎆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0c00, 0x1700, 0x0c80, 0x0440, 0x0020, 0x7f1e, 0x0000, 0x0000 },	// U+2387 (⎇)
	{ 0x0000, 0x0080, 0x0080, 0x11c4, 0x0eb8, 0x0c98, 0x0aa8, 0x11c4, 0x11c4, 0x0aa8, 0x0c98, 0x0eb8, 0x11c4, 0x0080, 0x0080, 0x0000 },	// U+2388 (⎈)
	{ 0x0000, 0x0000, 0x01f0, 0x060c, 0x0802, 0x0802, 0x1001, 0x1001, 0x1e0f, 0x1111, 0x1111, 0x08a2, 0x08a2, 0x064c, 0x01f0, 0x0000 },	// U+2389 (⎉)
	{ 0x0000, 0x0000, 0x01f0, 0x060c, 0x0802, 0x0ffe, 0x1405, 0x1209, 0x1209, 0x1111, 0x1111, 0x08a2, 0x08a2, 0x064c, 0x01f0, 0x0000 },	// U+238A (⎊)
	{ 0x0000, 0x0000, 0x0180, 0x063e, 0x0812, 0x080a, 0x1016, 0x1022, 0x1040, 0x1081, 0x1101, 0x0a02, 0x0802, 0x060c, 0x01f0, 0x0000 },	// U+238B (⎋)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x103e, 0x1014, 0x1008, 0x381c, 0x4422, 0x4422, 0x381c, 0x0000, 0x0000 },	// U+238C (⎌)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x3c3c, 0x0000, 0x0000 },	// U+238D (⎍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3f80, 0x0840, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0210, 0x01fc, 0x0000, 0x0000 },	// U+238E (⎎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0140, 0x0220, 0x0410, 0x0808, 0x0410, 0x0220, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+238F (⎏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x0410, 0x0220, 0x0140, 0x0ff8, 0x0000, 0x0000 },	// U+2390 (⎐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0140, 0x0220, 0x0410, 0x0ff8, 0x0410, 0x0220, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+2391 (⎑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0220, 0x0410, 0x0ff8, 0x0410, 0x0220, 0x0140, 0x0ff8, 0x0000, 0x0000 },	// U+2392 (⎒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x0000, 0x39ce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2393 (⎓)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0810, 0x1008, 0x2004, 0x4002, 0x2004, 0x1008, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+2394 (⎔)
}; // 20

static const uint16_t unifontdw_block198[][16] = {
	{ 0x0000, 0x0db6, 0x0802, 0x3ff2, 0x2012, 0x2052, 0x2072, 0x27d2, 0x240a, 0x27d2, 0x2072, 0x205e, 0x2010, 0x3ff0, 0x0000, 0x0000 },	// U+2397 (⎗)
	{ 0x0000, 0x0ffe, 0x0802, 0x3b72, 0x2012, 0x2092, 0x2192, 0x02fa, 0x240a, 0x22fa, 0x0192, 0x209e, 0x2010, 0x3b30, 0x0000, 0x0000 },	// U+2398 (⎘)
	{ 0x0000, 0x0780, 0x04c0, 0x04a0, 0x04f0, 0x0410, 0x1c1c, 0x2412, 0x4411, 0x4411, 0x47f1, 0x4001, 0x2002, 0x1ffc, 0x0000, 0x0000 },	// U+2399 (⎙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x1404, 0x2242, 0x2922, 0x2492, 0x224a, 0x2122, 0x1014, 0x0ff8, 0x0000, 0x0000 },	// U+239A (⎚)
}; // 4

static const uint16_t unifontdw_block199[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x700c, 0x600c, 0x4018, 0x0018, 0x0030, 0x0030, 0x0060, 0x0060, 0x00c0, 0x00c0, 0x0180 },	// U+23B2 (⎲)
	{ 0x0180, 0x00c0, 0x00c0, 0x0060, 0x0060, 0x0030, 0x0030, 0x0018, 0x4018, 0x600c, 0x700c, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23B3 (⎳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x4002, 0x4002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23B4 (⎴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x4002, 0x7ffe },	// U+23B5 (⎵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x4002, 0x7ffe, 0x0000, 0x7ffe, 0x4002, 0x4002, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23B6 (⎶)
}; // 5

static const uint16_t unifontdw_block200[][16] = {
	{ 0x0000, 0x0080, 0x0080, 0x01c0, 0x06b0, 0x0888, 0x0888, 0x1084, 0x1084, 0x0888, 0x0888, 0x06b0, 0x01c0, 0x0080, 0x0080, 0x0000 },	// U+23C0 (⏀)
	{ 0x0000, 0xffff, 0x0080, 0x01c0, 0x06b0, 0x0888, 0x0888, 0x1084, 0x1084, 0x0888, 0x0888, 0x06b0, 0x01c0, 0x0080, 0x0080, 0x0000 },	// U+23C1 (⏁)
	{ 0x0000, 0x0080, 0x0080, 0x01c0, 0x06b0, 0x0888, 0x0888, 0x1084, 0x1084, 0x0888, 0x0888, 0x06b0, 0x01c0, 0x0080, 0xffff, 0x0000 },	// U+23C2 (⏂)
	{ 0x0000, 0x0080, 0x0080, 0x01c0, 0x01c0, 0x02a0, 0x02a0, 0x0490, 0x0490, 0x0888, 0x0888, 0x1084, 0x1ffc, 0x0080, 0x0080, 0x0000 },	// U+23C3 (⏃)
	{ 0x0000, 0xffff, 0x0080, 0x01c0, 0x01c0, 0x02a0, 0x02a0, 0x0490, 0x0490, 0x0888, 0x0888, 0x1084, 0x1ffc, 0x0080, 0x0080, 0x0000 },	// U+23C4 (⏄)
	{ 0x0000, 0x0080, 0x0080, 0x01c0, 0x01c0, 0x02a0, 0x02a0, 0x0490, 0x0490, 0x0888, 0x0888, 0x1084, 0x1ffc, 0x0080, 0xffff, 0x0000 },	// U+23C5 (⏅)
	{ 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x00b8, 0x00c4, 0x1180, 0x0e80, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+23C6 (⏆)
	{ 0x0000, 0xffff, 0x0080, 0x0080, 0x0080, 0x0080, 0x00b8, 0x00c4, 0x1180, 0x0e80, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+23C7 (⏇)
	{ 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x00b8, 0x00c4, 0x1180, 0x0e80, 0x0080, 0x0080, 0x0080, 0x0080, 0xffff, 0x0000 },	// U+23C8 (⏈)
	{ 0x0000, 0xffff, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+23C9 (⏉)
	{ 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0xffff, 0x0000 },	// U+23CA (⏊)
}; // 11

static const uint16_t unifontdw_block201[][16] = {
	{ 0x0000, 0x0100, 0x3c9e, 0x2042, 0x2022, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x3ffe, 0x0000, 0x0000 },	// U+23CD (⏍)
	{ 0x0000, 0x0000, 0x7c00, 0x4400, 0x4400, 0x4400, 0x4420, 0x4230, 0x41e8, 0x4004, 0x2002, 0x1004, 0x0fe8, 0x0030, 0x0020, 0x0000 },	// U+23CE (⏎)
}; // 2

static const uint16_t unifontdw_block202[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7fff, 0x0000, 0x4141, 0x2222, 0x1c1c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23D4 (⏔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4141, 0x2222, 0x1c1c, 0x0000, 0x7fff, 0x0000, 0x0000, 0x0000 },	// U+23D5 (⏕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4182, 0x2244, 0x1c38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23D6 (⏖)
	{ 0x0000, 0x0000, 0x0000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23D7 (⏗)
	{ 0x0000, 0x0000, 0x0000, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23D8 (⏘)
	{ 0x0000, 0x0000, 0x0000, 0x4082, 0x4082, 0x4082, 0x4082, 0x4082, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23D9 (⏙)
}; // 6

static const uint16_t unifontdw_block203[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1008, 0x1008, 0xffff, 0x1008, 0x1008, 0x1ff8, 0x0000, 0x0000, 0x0000 },	// U+23DB (⏛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x381c, 0x4002, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23DC (⏜)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x8001, 0x4002, 0x381c, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23DD (⏝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x1e3c, 0x2002, 0x4001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23DE (⏞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4001, 0x2002, 0x1e3c, 0x0140, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23DF (⏟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x1008, 0x2004, 0x4002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23E0 (⏠)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x2004, 0x1008, 0x0ff0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23E1 (⏡)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03fe, 0x0402, 0x0402, 0x0802, 0x0802, 0x1002, 0x1002, 0x2002, 0x3ffe, 0x0000, 0x0000 },	// U+23E2 (⏢)
	{ 0x0000, 0x0100, 0x0280, 0x0440, 0x0820, 0x1390, 0x1450, 0x1450, 0x1450, 0x1390, 0x0820, 0x0440, 0x0280, 0x0100, 0x0000, 0x0000 },	// U+23E3 (⏣)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23E4 (⏤)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ff0, 0x1008, 0x1008, 0x0804, 0x0804, 0x07fe, 0x0000, 0x0000 },	// U+23E5 (⏥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0024, 0x0042, 0x3ffe, 0x2100, 0x1200, 0x0c00, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23E6 (⏦)
	{ 0x0000, 0x0024, 0x0024, 0x0044, 0x6044, 0x1895, 0x058e, 0x0384, 0x07c0, 0x0380, 0x0540, 0x0820, 0x1010, 0x2008, 0x0000, 0x0000 },	// U+23E7 (⏧)
}; // 13

static const uint16_t unifontdw_block204[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0104, 0x030c, 0x071c, 0x0f3c, 0x1f7c, 0x0f3c, 0x071c, 0x030c, 0x0104, 0x0000, 0x0000 },	// U+23E9 (⏩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1040, 0x1860, 0x1c70, 0x1e78, 0x1f7c, 0x1e78, 0x1c70, 0x1860, 0x1040, 0x0000, 0x0000 },	// U+23EA (⏪)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x07f0, 0x0ff8, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x07f0, 0x0ff8, 0x0000, 0x0000 },	// U+23EB (⏫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x07f0, 0x03e0, 0x01c0, 0x0080, 0x0000, 0x0ff8, 0x07f0, 0x03e0, 0x01c0, 0x0080, 0x0000 },	// U+23EC (⏬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2082, 0x2186, 0x238e, 0x279e, 0x2fbe, 0x279e, 0x238e, 0x2186, 0x2082, 0x0000, 0x0000 },	// U+23ED (⏭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2082, 0x30c2, 0x38e2, 0x3cf2, 0x3efa, 0x3cf2, 0x38e2, 0x30c2, 0x2082, 0x0000, 0x0000 },	// U+23EE (⏮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1208, 0x1218, 0x1238, 0x1278, 0x12f8, 0x1278, 0x1238, 0x1218, 0x1208, 0x0000, 0x0000 },	// U+23EF (⏯)
	{ 0x0000, 0x0080, 0x0c98, 0x1bec, 0x1414, 0x0888, 0x1084, 0x1084, 0x1084, 0x1044, 0x1024, 0x0808, 0x0410, 0x07f0, 0x0e38, 0x0000 },	// U+23F0 (⏰)
	{ 0x0000, 0x00c0, 0x00c0, 0x1be0, 0x1c10, 0x0888, 0x1084, 0x1084, 0x1084, 0x1004, 0x1004, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+23F1 (⏱)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0808, 0x1024, 0x1044, 0x1084, 0x1004, 0x1004, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+23F2 (⏲)
	{ 0x0000, 0x3ffe, 0x0808, 0x0808, 0x0948, 0x06b0, 0x0360, 0x0140, 0x0360, 0x0410, 0x0888, 0x0d58, 0x0aa8, 0x3ffe, 0x0000, 0x0000 },	// U+23F3 (⏳)
	{ 0x0000, 0x0000, 0x0000, 0x0200, 0x0300, 0x0380, 0x03c0, 0x03e0, 0x03f0, 0x03e0, 0x03c0, 0x0380, 0x0300, 0x0200, 0x0000, 0x0000 },	// U+23F4 (⏴)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0030, 0x0070, 0x00f0, 0x01f0, 0x03f0, 0x01f0, 0x00f0, 0x0070, 0x0030, 0x0010, 0x0000, 0x0000 },	// U+23F5 (⏵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x07f0, 0x0ff8, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23F6 (⏶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ffc, 0x0ff8, 0x07f0, 0x03e0, 0x01c0, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+23F7 (⏷)
	{ 0x0000, 0x0000, 0x0000, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0000, 0x0000 },	// U+23F8 (⏸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x0000, 0x0000 },	// U+23F9 (⏹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0ff0, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x0ff0, 0x07e0, 0x0000, 0x0000 },	// U+23FA (⏺)
	{ 0x0180, 0x0180, 0x0180, 0x0180, 0x1998, 0x399c, 0x318c, 0x718e, 0x6186, 0x6186, 0x700e, 0x300c, 0x381c, 0x1ff8, 0x0ff0, 0x03c0 },	// U+23FB (⏻)
	{ 0x0000, 0x07e0, 0x1ff8, 0x3c3c, 0x781e, 0x718e, 0x6186, 0x6186, 0x6186, 0x6186, 0x6186, 0x718e, 0x381c, 0x1ff8, 0x0ff0, 0x03c0 },	// U+23FC (⏼)
	{ 0x0180, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x0180 },	// U+23FD (⏽)
	{ 0x0020, 0x0010, 0x0018, 0x001c, 0x001c, 0x001e, 0x001e, 0x001e, 0x001e, 0x003e, 0x003c, 0x007c, 0x00f8, 0x01f0, 0x07e0, 0x0f80 },	// U+23FE (⏾)
	{ 0x0000, 0x0000, 0x0000, 0x3800, 0x1e00, 0x2980, 0x2460, 0x4418, 0x4406, 0x4418, 0x2460, 0x2980, 0x1e00, 0x3800, 0x0000, 0x0000 },	// U+23FF (⏿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a52, 0x0a56, 0x0a5a, 0x7992, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2400 (␀)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x499c, 0x4a42, 0x7a4c, 0x4a50, 0x498e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2401 (␁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x25dc, 0x2482, 0x188c, 0x2490, 0x248e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2402 (␂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x25de, 0x2482, 0x189e, 0x2482, 0x249e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2403 (␃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7d9e, 0x1242, 0x125e, 0x1242, 0x119e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2404 (␄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x325e, 0x4a42, 0x4ade, 0x6b42, 0x725e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2405 (␅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x258c, 0x1452, 0x0c5e, 0x1452, 0x2592, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2406 (␆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0bce, 0x0852, 0x0bce, 0x0852, 0x7bce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2407 (␇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c78, 0x0288, 0x0c78, 0x1088, 0x0e78, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2408 (␈)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f44, 0x0444, 0x047c, 0x0444, 0x0444, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2409 (␉)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f04, 0x0104, 0x1f04, 0x0104, 0x017c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+240A (␊)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f44, 0x0444, 0x0444, 0x0428, 0x0410, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+240B (␋)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f7c, 0x0104, 0x1f7c, 0x0104, 0x0104, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+240C (␌)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f78, 0x1104, 0x0f04, 0x0904, 0x1178, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+240D (␍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e78, 0x1104, 0x1138, 0x1140, 0x0e3c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+240E (␎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f78, 0x0404, 0x0438, 0x0440, 0x1f3c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+240F (␏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x389c, 0x08a4, 0x38a4, 0x08a4, 0x3b9c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2410 (␐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x118e, 0x1852, 0x1052, 0x1052, 0x398e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2411 (␑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x198e, 0x2052, 0x1052, 0x0852, 0x398e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2412 (␒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x198e, 0x2052, 0x1852, 0x2052, 0x198e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2413 (␓)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x218e, 0x3052, 0x2852, 0x3852, 0x218e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2414 (␔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4992, 0x2a56, 0x1a56, 0x2bda, 0x4a52, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2415 (␕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4a2c, 0x5942, 0x688c, 0x4890, 0x488e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2416 (␖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1dde, 0x2482, 0x1c9e, 0x2482, 0x1c9e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2417 (␗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x24cc, 0x2d22, 0x35e2, 0x2522, 0x252c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2418 (␘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x117c, 0x1b04, 0x157c, 0x1104, 0x117c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2419 (␙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3a5c, 0x4a42, 0x3a4c, 0x4a50, 0x398e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+241A (␚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x739e, 0x0842, 0x099e, 0x0a02, 0x71de, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+241B (␛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e78, 0x0108, 0x0678, 0x0808, 0x0708, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+241C (␜)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e70, 0x0108, 0x0668, 0x0848, 0x0770, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+241D (␝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x0148, 0x0638, 0x0828, 0x0748, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+241E (␞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e48, 0x0148, 0x0648, 0x0848, 0x0730, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+241F (␟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01dc, 0x0242, 0x01cc, 0x0050, 0x004e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2420 (␠)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0bce, 0x0852, 0x0bd2, 0x0852, 0x7bce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2421 (␡)
}; // 57

static const uint16_t unifontdw_block205[][16] = {
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x7786, 0x7bf6, 0x7b86, 0x7ffe, 0x0000 },	// U+2427 (␧)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x7386, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+2428 (␨)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x6386, 0x6ff6, 0x7386, 0x7ffe, 0x0000 },	// U+2429 (␩)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x6186, 0x6df6, 0x6d86, 0x7ffe, 0x0000 },	// U+242A (␪)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x7186, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+242B (␫)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7d86, 0x7df6, 0x6386, 0x7ffe, 0x0000 },	// U+242C (␬)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+242D (␭)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+242E (␮)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x0000 },	// U+242F (␯)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x73c6, 0x6dbe, 0x6d8e, 0x6dbe, 0x73c6, 0x7ffe, 0x0000 },	// U+2430 (␰)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x77c6, 0x73be, 0x778e, 0x77be, 0x63c6, 0x7ffe, 0x0000 },	// U+2431 (␱)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x61c6, 0x6fbe, 0x618e, 0x7dbe, 0x61c6, 0x7ffe, 0x0000 },	// U+2432 (␲)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x71c6, 0x6fbe, 0x638e, 0x6fbe, 0x71c6, 0x7ffe, 0x0000 },	// U+2433 (␳)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6dc6, 0x6dbe, 0x618e, 0x6fbe, 0x6fc6, 0x7ffe, 0x0000 },	// U+2434 (␴)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x61c6, 0x7dbe, 0x618e, 0x6fbe, 0x61c6, 0x7ffe, 0x0000 },	// U+2435 (␵)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x73c6, 0x7dbe, 0x718e, 0x6dbe, 0x73c6, 0x7ffe, 0x0000 },	// U+2436 (␶)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x61c6, 0x6fbe, 0x778e, 0x7bbe, 0x7bc6, 0x7ffe, 0x0000 },	// U+2437 (␷)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x73c6, 0x6dbe, 0x738e, 0x6dbe, 0x73c6, 0x7ffe, 0x0000 },	// U+2438 (␸)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x73c6, 0x6dbe, 0x638e, 0x6fbe, 0x73c6, 0x7ffe, 0x0000 },	// U+2439 (␹)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x61c6, 0x6dbe, 0x618e, 0x6dbe, 0x6dc6, 0x7ffe, 0x0000 },	// U+243A (␺)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x718e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+243B (␻)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x63c6, 0x7dbe, 0x7d8e, 0x7dbe, 0x63c6, 0x7ffe, 0x0000 },	// U+243C (␼)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x71c6, 0x6dbe, 0x6d8e, 0x6dbe, 0x71c6, 0x7ffe, 0x0000 },	// U+243D (␽)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x61c6, 0x7dbe, 0x718e, 0x7dbe, 0x61c6, 0x7ffe, 0x0000 },	// U+243E (␾)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x61c6, 0x7dbe, 0x718e, 0x7dbe, 0x7dc6, 0x7ffe, 0x0000 },	// U+243F (␿)
}; // 25

static const uint16_t unifontdw_block206[][16] = {
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x71b6, 0x6db6, 0x7186, 0x6dbe, 0x71be, 0x7ffe, 0x0000 },	// U+244B (⑋)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x63b6, 0x7db6, 0x7d86, 0x7dbe, 0x63be, 0x7ffe, 0x0000 },	// U+244C (⑌)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x71b6, 0x6db6, 0x6d86, 0x6dbe, 0x71be, 0x7ffe, 0x0000 },	// U+244D (⑍)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x61be, 0x7ffe, 0x0000 },	// U+244E (⑎)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x61b6, 0x7db6, 0x7186, 0x7dbe, 0x7dbe, 0x7ffe, 0x0000 },	// U+244F (⑏)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6d86, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+2450 (⑐)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x7786, 0x77be, 0x6386, 0x7ffe, 0x0000 },	// U+2451 (⑑)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x6186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+2452 (⑒)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x6386, 0x6fbe, 0x7186, 0x7ffe, 0x0000 },	// U+2453 (⑓)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x6186, 0x6fbe, 0x6f86, 0x7ffe, 0x0000 },	// U+2454 (⑔)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x6186, 0x6fbe, 0x6186, 0x7ffe, 0x0000 },	// U+2455 (⑕)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x7186, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+2456 (⑖)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x7786, 0x7bbe, 0x7b86, 0x7ffe, 0x0000 },	// U+2457 (⑗)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x7386, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+2458 (⑘)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6386, 0x6fbe, 0x7386, 0x7ffe, 0x0000 },	// U+2459 (⑙)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x6186, 0x6dbe, 0x6d86, 0x7ffe, 0x0000 },	// U+245A (⑚)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x7186, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+245B (⑛)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7d86, 0x7dbe, 0x6386, 0x7ffe, 0x0000 },	// U+245C (⑜)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6d86, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+245D (⑝)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+245E (⑞)
	{ 0x0000, 0x7ffe, 0x6d86, 0x6dbe, 0x6186, 0x6ff6, 0x6f86, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x7d86, 0x7ffe, 0x0000 },	// U+245F (⑟)
	{ 0x03e0, 0x0c18, 0x1004, 0x2082, 0x20c2, 0x40a1, 0x4081, 0x4081, 0x4081, 0x4081, 0x2082, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2460 (①)
	{ 0x03e0, 0x0c18, 0x1004, 0x21c2, 0x2222, 0x4221, 0x4201, 0x4101, 0x4081, 0x4041, 0x2022, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2461 (②)
	{ 0x03e0, 0x0c18, 0x1004, 0x21c2, 0x2222, 0x4221, 0x4201, 0x4181, 0x4201, 0x4221, 0x2222, 0x21c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2462 (③)
	{ 0x03e0, 0x0c18, 0x1004, 0x2102, 0x2182, 0x4141, 0x4121, 0x4111, 0x43f1, 0x4101, 0x2102, 0x2102, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2463 (④)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x2022, 0x4021, 0x4021, 0x41e1, 0x4201, 0x4201, 0x2222, 0x21c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2464 (⑤)
	{ 0x03e0, 0x0c18, 0x1004, 0x2182, 0x2042, 0x4021, 0x4021, 0x41e1, 0x4221, 0x4221, 0x2222, 0x21c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2465 (⑥)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x2202, 0x4201, 0x4101, 0x4101, 0x4101, 0x4081, 0x2082, 0x2082, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2466 (⑦)
	{ 0x03e0, 0x0c18, 0x1004, 0x21c2, 0x2222, 0x4221, 0x4221, 0x41c1, 0x4221, 0x4221, 0x2222, 0x21c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2467 (⑧)
	{ 0x03e0, 0x0c18, 0x1004, 0x21c2, 0x2222, 0x4221, 0x4221, 0x43c1, 0x4201, 0x4201, 0x2102, 0x20c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2468 (⑨)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2622, 0x4931, 0x4929, 0x4921, 0x4921, 0x4921, 0x26fa, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2469 (⑩)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2222, 0x4331, 0x42a9, 0x4221, 0x4221, 0x4221, 0x2ffa, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+246A (⑪)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2622, 0x4931, 0x4829, 0x4421, 0x4221, 0x4121, 0x2ffa, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+246B (⑫)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2622, 0x4931, 0x4829, 0x4421, 0x4821, 0x4921, 0x26fa, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+246C (⑬)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2822, 0x4c31, 0x4a29, 0x4921, 0x5f21, 0x4821, 0x28fa, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+246D (⑭)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2f22, 0x4131, 0x4129, 0x4721, 0x4821, 0x4921, 0x26fa, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+246E (⑮)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2e22, 0x4131, 0x4129, 0x4721, 0x4921, 0x4921, 0x26fa, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+246F (⑯)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2f22, 0x4831, 0x4829, 0x4421, 0x4421, 0x4221, 0x22fa, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2470 (⑰)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2622, 0x4931, 0x4929, 0x4621, 0x4921, 0x4921, 0x26fa, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2471 (⑱)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2622, 0x4931, 0x4929, 0x4e21, 0x4821, 0x4821, 0x26fa, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2472 (⑲)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2632, 0x4949, 0x4941, 0x4921, 0x4911, 0x4909, 0x267a, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2473 (⑳)
	{ 0x0000, 0x0000, 0x1008, 0x2104, 0x2184, 0x4142, 0x4102, 0x4102, 0x4102, 0x4102, 0x4102, 0x2104, 0x27c4, 0x1008, 0x0000, 0x0000 },	// U+2474 (⑴)
	{ 0x0000, 0x0000, 0x1008, 0x23c4, 0x2424, 0x4422, 0x4402, 0x4302, 0x4082, 0x4042, 0x4022, 0x2024, 0x27e4, 0x1008, 0x0000, 0x0000 },	// U+2475 (⑵)
	{ 0x0000, 0x0000, 0x1008, 0x23c4, 0x2424, 0x4422, 0x4402, 0x4382, 0x4402, 0x4402, 0x4422, 0x2424, 0x23c4, 0x1008, 0x0000, 0x0000 },	// U+2476 (⑶)
	{ 0x0000, 0x0000, 0x1008, 0x2204, 0x2304, 0x4282, 0x4242, 0x4222, 0x4222, 0x47e2, 0x4202, 0x2204, 0x2204, 0x1008, 0x0000, 0x0000 },	// U+2477 (⑷)
	{ 0x0000, 0x0000, 0x1008, 0x27e4, 0x2024, 0x4022, 0x4022, 0x43e2, 0x4402, 0x4402, 0x4402, 0x2424, 0x23c4, 0x1008, 0x0000, 0x0000 },	// U+2478 (⑸)
	{ 0x0000, 0x0000, 0x1008, 0x2384, 0x2044, 0x4022, 0x4022, 0x43e2, 0x4422, 0x4422, 0x4422, 0x2424, 0x23c4, 0x1008, 0x0000, 0x0000 },	// U+2479 (⑹)
	{ 0x0000, 0x0000, 0x1008, 0x27e4, 0x2404, 0x4402, 0x4202, 0x4202, 0x4202, 0x4102, 0x4102, 0x2104, 0x2104, 0x1008, 0x0000, 0x0000 },	// U+247A (⑺)
	{ 0x0000, 0x0000, 0x1008, 0x23c4, 0x2424, 0x4422, 0x4422, 0x43c2, 0x4422, 0x4422, 0x4422, 0x2424, 0x23c4, 0x1008, 0x0000, 0x0000 },	// U+247B (⑻)
	{ 0x0000, 0x0000, 0x1008, 0x23c4, 0x2424, 0x4422, 0x4422, 0x47c2, 0x4402, 0x4402, 0x4402, 0x2204, 0x21c4, 0x1008, 0x0000, 0x0000 },	// U+247C (⑼)
	{ 0x0000, 0x0000, 0x4002, 0x8c11, 0x9219, 0xa115, 0xa111, 0xa111, 0xa111, 0xa111, 0xa111, 0x9211, 0x8c7d, 0x4002, 0x0000, 0x0000 },	// U+247D (⑽)
	{ 0x0000, 0x0000, 0x4002, 0x8811, 0x8c19, 0x8a15, 0x8811, 0x8811, 0x8811, 0x8811, 0x8811, 0x8811, 0xbe7d, 0x4002, 0x0000, 0x0000 },	// U+247E (⑾)
	{ 0x0000, 0x0000, 0x4002, 0x9e11, 0xa119, 0xa115, 0xa011, 0x9811, 0x8411, 0x8211, 0x8111, 0x8111, 0xbf7d, 0x4002, 0x0000, 0x0000 },	// U+247F (⑿)
	{ 0x0000, 0x0000, 0x4002, 0x9e11, 0xa119, 0xa115, 0xa011, 0x9c11, 0xa011, 0xa011, 0xa111, 0xa111, 0x9e7d, 0x4002, 0x0000, 0x0000 },	// U+2480 (⒀)
	{ 0x0000, 0x0000, 0x4002, 0x9011, 0x9819, 0x9415, 0x9211, 0x9111, 0x9111, 0xbf11, 0x9011, 0x9011, 0x907d, 0x4002, 0x0000, 0x0000 },	// U+2481 (⒁)
	{ 0x0000, 0x0000, 0x4002, 0xbf11, 0x8119, 0x8115, 0x8111, 0x9f11, 0xa011, 0xa011, 0xa011, 0xa111, 0x9e7d, 0x4002, 0x0000, 0x0000 },	// U+2482 (⒂)
	{ 0x0000, 0x0000, 0x4002, 0x9c11, 0x8219, 0x8115, 0x8111, 0x9f11, 0xa111, 0xa111, 0xa111, 0xa111, 0x9e7d, 0x4002, 0x0000, 0x0000 },	// U+2483 (⒃)
	{ 0x0000, 0x0000, 0x4002, 0x9f91, 0x9019, 0x9015, 0x8811, 0x8811, 0x8811, 0x8411, 0x8411, 0x8411, 0x847d, 0x4002, 0x0000, 0x0000 },	// U+2484 (⒄)
	{ 0x0000, 0x0000, 0x4002, 0x9e11, 0xa119, 0xa115, 0xa111, 0x9e11, 0xa111, 0xa111, 0xa111, 0xa111, 0x9e7d, 0x4002, 0x0000, 0x0000 },	// U+2485 (⒅)
	{ 0x0000, 0x0000, 0x4002, 0x9e11, 0xa119, 0xa115, 0xa111, 0xbe11, 0xa011, 0xa011, 0xa011, 0x9011, 0x8e7d, 0x4002, 0x0000, 0x0000 },	// U+2486 (⒆)
	{ 0x0000, 0x0000, 0x4002, 0x8c39, 0x9245, 0xa145, 0xa141, 0xa121, 0xa111, 0xa109, 0xa105, 0x9205, 0x8c7d, 0x4002, 0x0000, 0x0000 },	// U+2487 (⒇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x00c0, 0x00a0, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0be0, 0x0000, 0x0000 },	// U+2488 (⒈)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0210, 0x0200, 0x0180, 0x0040, 0x0020, 0x0010, 0x0010, 0x0bf0, 0x0000, 0x0000 },	// U+2489 (⒉)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0210, 0x0200, 0x01c0, 0x0200, 0x0200, 0x0210, 0x0210, 0x09e0, 0x0000, 0x0000 },	// U+248A (⒊)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0180, 0x0140, 0x0120, 0x0110, 0x0110, 0x03f0, 0x0100, 0x0100, 0x0900, 0x0000, 0x0000 },	// U+248B (⒋)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0010, 0x0010, 0x0010, 0x01f0, 0x0200, 0x0200, 0x0200, 0x0210, 0x09e0, 0x0000, 0x0000 },	// U+248C (⒌)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0020, 0x0010, 0x0010, 0x01f0, 0x0210, 0x0210, 0x0210, 0x0210, 0x09e0, 0x0000, 0x0000 },	// U+248D (⒍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0200, 0x0200, 0x0100, 0x0100, 0x0100, 0x0080, 0x0080, 0x0080, 0x0880, 0x0000, 0x0000 },	// U+248E (⒎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0210, 0x0210, 0x01e0, 0x0210, 0x0210, 0x0210, 0x0210, 0x09e0, 0x0000, 0x0000 },	// U+248F (⒏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0210, 0x0210, 0x03e0, 0x0200, 0x0200, 0x0200, 0x0100, 0x08e0, 0x0000, 0x0000 },	// U+2490 (⒐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0608, 0x090c, 0x108a, 0x1088, 0x1088, 0x1088, 0x1088, 0x1088, 0x0908, 0x463e, 0x0000, 0x0000 },	// U+2491 (⒑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0408, 0x060c, 0x050a, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x5f3e, 0x0000, 0x0000 },	// U+2492 (⒒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f08, 0x108c, 0x108a, 0x1008, 0x0c08, 0x0208, 0x0108, 0x0088, 0x0088, 0x5fbe, 0x0000, 0x0000 },	// U+2493 (⒓)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f08, 0x108c, 0x108a, 0x1008, 0x0e08, 0x1008, 0x1008, 0x1088, 0x1088, 0x4f3e, 0x0000, 0x0000 },	// U+2494 (⒔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0808, 0x0c0c, 0x0a0a, 0x0908, 0x0888, 0x0888, 0x1f88, 0x0808, 0x0808, 0x483e, 0x0000, 0x0000 },	// U+2495 (⒕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1f88, 0x008c, 0x008a, 0x0088, 0x0f88, 0x1008, 0x1008, 0x1008, 0x1088, 0x4f3e, 0x0000, 0x0000 },	// U+2496 (⒖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e08, 0x010c, 0x008a, 0x0088, 0x0f88, 0x1088, 0x1088, 0x1088, 0x1088, 0x4f3e, 0x0000, 0x0000 },	// U+2497 (⒗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1f88, 0x100c, 0x100a, 0x0808, 0x0808, 0x0808, 0x0408, 0x0408, 0x0408, 0x443e, 0x0000, 0x0000 },	// U+2498 (⒘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f08, 0x108c, 0x108a, 0x1088, 0x0f08, 0x1088, 0x1088, 0x1088, 0x1088, 0x4f3e, 0x0000, 0x0000 },	// U+2499 (⒙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f08, 0x108c, 0x108a, 0x1088, 0x1f08, 0x1008, 0x1008, 0x1008, 0x0808, 0x473e, 0x0000, 0x0000 },	// U+249A (⒚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c3c, 0x1242, 0x2142, 0x2140, 0x2130, 0x2108, 0x2104, 0x2102, 0x1202, 0x8c7e, 0x0000, 0x0000 },	// U+249B (⒛)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x43c2, 0x4422, 0x4402, 0x47c2, 0x4422, 0x4422, 0x2624, 0x25c4, 0x1008, 0x0000 },	// U+249C (⒜)
	{ 0x0000, 0x0000, 0x0000, 0x1028, 0x2024, 0x2024, 0x43a2, 0x4462, 0x4422, 0x4422, 0x4422, 0x4422, 0x2464, 0x23a4, 0x1008, 0x0000 },	// U+249D (⒝)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x43c2, 0x4422, 0x4022, 0x4022, 0x4022, 0x4022, 0x2424, 0x23c4, 0x1008, 0x0000 },	// U+249E (⒞)
	{ 0x0000, 0x0000, 0x0000, 0x1408, 0x2404, 0x2404, 0x45c2, 0x4622, 0x4422, 0x4422, 0x4422, 0x4422, 0x2624, 0x25c4, 0x1008, 0x0000 },	// U+249F (⒟)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x43c2, 0x4422, 0x4422, 0x47e2, 0x4022, 0x4022, 0x2424, 0x23c4, 0x1008, 0x0000 },	// U+24A0 (⒠)
	{ 0x0000, 0x0000, 0x0000, 0x1308, 0x2084, 0x2084, 0x4082, 0x43e2, 0x4082, 0x4082, 0x4082, 0x4082, 0x2084, 0x2084, 0x1008, 0x0000 },	// U+24A1 (⒡)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2404, 0x45c2, 0x4222, 0x4222, 0x4222, 0x41c2, 0x4042, 0x23c4, 0x2424, 0x1428, 0x03c0 },	// U+24A2 (⒢)
	{ 0x0000, 0x0000, 0x0000, 0x1028, 0x2024, 0x2024, 0x43a2, 0x4462, 0x4422, 0x4422, 0x4422, 0x4422, 0x2424, 0x2424, 0x1008, 0x0000 },	// U+24A3 (⒣)
	{ 0x0000, 0x0000, 0x0000, 0x0888, 0x1084, 0x1004, 0x20c2, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x1084, 0x13e4, 0x0808, 0x0000 },	// U+24A4 (⒤)
	{ 0x0000, 0x0000, 0x0000, 0x0a08, 0x1204, 0x1004, 0x2302, 0x2202, 0x2202, 0x2202, 0x2202, 0x2202, 0x1204, 0x1204, 0x0928, 0x00c0 },	// U+24A5 (⒥)
	{ 0x0000, 0x0000, 0x0000, 0x1028, 0x2024, 0x2024, 0x4222, 0x4122, 0x40a2, 0x4062, 0x40a2, 0x4122, 0x2224, 0x2424, 0x1008, 0x0000 },	// U+24A6 (⒦)
	{ 0x0000, 0x0000, 0x0000, 0x08c8, 0x1084, 0x1084, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x1084, 0x13e4, 0x0808, 0x0000 },	// U+24A7 (⒧)
	{ 0x0000, 0x0000, 0x0000, 0x2008, 0x4004, 0x4004, 0x86e2, 0x8922, 0x8922, 0x8922, 0x8922, 0x8922, 0x4924, 0x4924, 0x2008, 0x0000 },	// U+24A8 (⒨)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x43a2, 0x4462, 0x4422, 0x4422, 0x4422, 0x4422, 0x2424, 0x2424, 0x1008, 0x0000 },	// U+24A9 (⒩)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x43c2, 0x4422, 0x4422, 0x4422, 0x4422, 0x4422, 0x2424, 0x23c4, 0x1008, 0x0000 },	// U+24AA (⒪)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x43a2, 0x4462, 0x4422, 0x4422, 0x4422, 0x4422, 0x2464, 0x23a4, 0x1028, 0x0020 },	// U+24AB (⒫)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x45c2, 0x4622, 0x4422, 0x4422, 0x4422, 0x4422, 0x2624, 0x25c4, 0x1408, 0x0400 },	// U+24AC (⒬)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x43a2, 0x4462, 0x4422, 0x4022, 0x4022, 0x4022, 0x2024, 0x2024, 0x1008, 0x0000 },	// U+24AD (⒭)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x43c2, 0x4422, 0x4022, 0x40c2, 0x4302, 0x4402, 0x2424, 0x23c4, 0x1008, 0x0000 },	// U+24AE (⒮)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2084, 0x2084, 0x43e2, 0x4082, 0x4082, 0x4082, 0x4082, 0x4082, 0x2084, 0x2304, 0x1008, 0x0000 },	// U+24AF (⒯)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x4422, 0x4422, 0x4422, 0x4422, 0x4422, 0x4422, 0x2624, 0x25c4, 0x1008, 0x0000 },	// U+24B0 (⒰)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x4422, 0x4422, 0x4422, 0x4242, 0x4242, 0x4242, 0x2184, 0x2184, 0x1008, 0x0000 },	// U+24B1 (⒱)
	{ 0x0000, 0x0000, 0x0000, 0x2008, 0x4004, 0x4004, 0x8822, 0x8922, 0x8922, 0x8922, 0x8922, 0x8922, 0x4924, 0x46c4, 0x2008, 0x0000 },	// U+24B2 (⒲)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x4422, 0x4422, 0x4242, 0x4182, 0x4182, 0x4242, 0x2424, 0x2424, 0x1008, 0x0000 },	// U+24B3 (⒳)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x4422, 0x4422, 0x4422, 0x4422, 0x4422, 0x4642, 0x2584, 0x2404, 0x1408, 0x03c0 },	// U+24B4 (⒴)
	{ 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x2004, 0x47e2, 0x4402, 0x4202, 0x4102, 0x4082, 0x4042, 0x2024, 0x27e4, 0x1008, 0x0000 },	// U+24B5 (⒵)
	{ 0x03e0, 0x0c18, 0x1004, 0x2082, 0x2142, 0x4141, 0x4221, 0x4221, 0x43e1, 0x4221, 0x2222, 0x2222, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24B6 (Ⓐ)
	{ 0x03e0, 0x0c18, 0x1004, 0x21e2, 0x2222, 0x4221, 0x4221, 0x41e1, 0x4221, 0x4221, 0x2222, 0x21e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24B7 (Ⓑ)
	{ 0x03e0, 0x0c18, 0x1004, 0x21c2, 0x2222, 0x4221, 0x4021, 0x4021, 0x4021, 0x4221, 0x2222, 0x21c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24B8 (Ⓒ)
	{ 0x03e0, 0x0c18, 0x1004, 0x20e2, 0x2122, 0x4221, 0x4221, 0x4221, 0x4221, 0x4221, 0x2122, 0x20e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24B9 (Ⓓ)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x2022, 0x4021, 0x4021, 0x41e1, 0x4021, 0x4021, 0x2022, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24BA (Ⓔ)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x2022, 0x4021, 0x4021, 0x41e1, 0x4021, 0x4021, 0x2022, 0x2022, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24BB (Ⓕ)
	{ 0x03e0, 0x0c18, 0x1004, 0x21c2, 0x2222, 0x4221, 0x4021, 0x43a1, 0x4221, 0x4221, 0x2322, 0x22c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24BC (Ⓖ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2222, 0x2222, 0x4221, 0x4221, 0x43e1, 0x4221, 0x4221, 0x2222, 0x2222, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24BD (Ⓗ)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x2082, 0x4081, 0x4081, 0x4081, 0x4081, 0x4081, 0x2082, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24BE (Ⓘ)
	{ 0x03e0, 0x0c18, 0x1004, 0x27c2, 0x2102, 0x4101, 0x4101, 0x4101, 0x4101, 0x4121, 0x2122, 0x20c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24BF (Ⓙ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2222, 0x2222, 0x4121, 0x40a1, 0x4061, 0x40a1, 0x4121, 0x2222, 0x2222, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24C0 (Ⓚ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2022, 0x2022, 0x4021, 0x4021, 0x4021, 0x4021, 0x4021, 0x2022, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24C1 (Ⓛ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2222, 0x2222, 0x4361, 0x4361, 0x42a1, 0x42a1, 0x4221, 0x2222, 0x2222, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24C2 (Ⓜ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2222, 0x4261, 0x4261, 0x42a1, 0x42a1, 0x4321, 0x2322, 0x2222, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24C3 (Ⓝ)
	{ 0x03e0, 0x0c18, 0x1004, 0x21c2, 0x2222, 0x4221, 0x4221, 0x4221, 0x4221, 0x4221, 0x2222, 0x21c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24C4 (Ⓞ)
	{ 0x03e0, 0x0c18, 0x1004, 0x21e2, 0x2222, 0x4221, 0x4221, 0x41e1, 0x4021, 0x4021, 0x2022, 0x2022, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24C5 (Ⓟ)
	{ 0x03e0, 0x0c18, 0x1004, 0x21c2, 0x2222, 0x4221, 0x4221, 0x4221, 0x4221, 0x42a1, 0x2362, 0x21c2, 0x1604, 0x0c18, 0x03e0, 0x0000 },	// U+24C6 (Ⓠ)
	{ 0x03e0, 0x0c18, 0x1004, 0x21e2, 0x2222, 0x4221, 0x4221, 0x41e1, 0x40a1, 0x4121, 0x2122, 0x2222, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24C7 (Ⓡ)
	{ 0x03e0, 0x0c18, 0x1004, 0x21c2, 0x2222, 0x4221, 0x4021, 0x41c1, 0x4201, 0x4221, 0x2222, 0x21c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24C8 (Ⓢ)
	{ 0x03e0, 0x0c18, 0x1004, 0x27f2, 0x2082, 0x4081, 0x4081, 0x4081, 0x4081, 0x4081, 0x2082, 0x2082, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24C9 (Ⓣ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2222, 0x2222, 0x4221, 0x4221, 0x4221, 0x4221, 0x4221, 0x2222, 0x21c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24CA (Ⓤ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2412, 0x2412, 0x4221, 0x4221, 0x4221, 0x4141, 0x4141, 0x2082, 0x2082, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24CB (Ⓥ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2222, 0x2222, 0x4221, 0x42a1, 0x42a1, 0x4361, 0x4361, 0x2222, 0x2222, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24CC (Ⓦ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2222, 0x2222, 0x4141, 0x4141, 0x4081, 0x4141, 0x4141, 0x2222, 0x2222, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24CD (Ⓧ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2412, 0x2412, 0x4221, 0x4221, 0x4141, 0x4081, 0x4081, 0x2082, 0x2082, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24CE (Ⓨ)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x2202, 0x4201, 0x4101, 0x4081, 0x4041, 0x4021, 0x2022, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24CF (Ⓩ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x21c2, 0x4221, 0x4201, 0x43c1, 0x4221, 0x4321, 0x22c2, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24D0 (ⓐ)
	{ 0x03e0, 0x0c18, 0x1024, 0x2022, 0x2022, 0x41a1, 0x4261, 0x4221, 0x4221, 0x4221, 0x2262, 0x21a2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24D1 (ⓑ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x21c2, 0x4221, 0x4021, 0x4021, 0x4021, 0x4221, 0x21c2, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24D2 (ⓒ)
	{ 0x03e0, 0x0c18, 0x1204, 0x2202, 0x2202, 0x42c1, 0x4321, 0x4221, 0x4221, 0x4221, 0x2322, 0x22c2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24D3 (ⓓ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x21c2, 0x4221, 0x4221, 0x43e1, 0x4021, 0x4221, 0x21c2, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24D4 (ⓔ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2302, 0x2082, 0x4081, 0x4081, 0x43e1, 0x4081, 0x4081, 0x2082, 0x2082, 0x1084, 0x0c18, 0x03e0, 0x0000 },	// U+24D5 (ⓕ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2202, 0x22c2, 0x4121, 0x4121, 0x40c1, 0x4041, 0x41c1, 0x2222, 0x2222, 0x11c4, 0x0c18, 0x03e0, 0x0000 },	// U+24D6 (ⓖ)
	{ 0x03e0, 0x0c18, 0x1024, 0x2022, 0x2022, 0x41a1, 0x4261, 0x4221, 0x4221, 0x4221, 0x2222, 0x2222, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24D7 (ⓗ)
	{ 0x03e0, 0x0c18, 0x1084, 0x2082, 0x2002, 0x40c1, 0x4081, 0x4081, 0x4081, 0x4081, 0x2082, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24D8 (ⓘ)
	{ 0x03e0, 0x0c18, 0x1204, 0x2202, 0x2002, 0x4301, 0x4201, 0x4201, 0x4201, 0x4201, 0x2202, 0x2122, 0x10c4, 0x0c18, 0x03e0, 0x0000 },	// U+24D9 (ⓙ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2022, 0x2022, 0x4121, 0x40a1, 0x4061, 0x4061, 0x40a1, 0x2122, 0x2222, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24DA (ⓚ)
	{ 0x03e0, 0x0c18, 0x1004, 0x20c2, 0x2082, 0x4081, 0x4081, 0x4081, 0x4081, 0x4081, 0x2082, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24DB (ⓛ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2372, 0x4491, 0x4491, 0x4491, 0x4491, 0x4491, 0x2492, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24DC (ⓜ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x21a2, 0x4261, 0x4221, 0x4221, 0x4221, 0x4221, 0x2222, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24DD (ⓝ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x21c2, 0x4221, 0x4221, 0x4221, 0x4221, 0x4221, 0x21c2, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24DE (ⓞ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x21a2, 0x4261, 0x4221, 0x4221, 0x4221, 0x4261, 0x21a2, 0x2022, 0x1024, 0x0c18, 0x03e0, 0x0000 },	// U+24DF (ⓟ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x22c2, 0x4321, 0x4221, 0x4221, 0x4221, 0x4221, 0x2322, 0x22c2, 0x1204, 0x0c18, 0x03e0, 0x0000 },	// U+24E0 (ⓠ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x21a2, 0x4261, 0x4221, 0x4021, 0x4021, 0x4021, 0x2022, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24E1 (ⓡ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x21c2, 0x4221, 0x4021, 0x41c1, 0x4201, 0x4221, 0x21c2, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24E2 (ⓢ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2082, 0x2082, 0x43e1, 0x4081, 0x4081, 0x4081, 0x4081, 0x2082, 0x2302, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24E3 (ⓣ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2222, 0x4221, 0x4221, 0x4221, 0x4221, 0x4321, 0x22c2, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24E4 (ⓤ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2222, 0x4221, 0x4141, 0x4141, 0x4141, 0x4081, 0x2082, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24E5 (ⓥ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2412, 0x4491, 0x4491, 0x4491, 0x4491, 0x4491, 0x2362, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24E6 (ⓦ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2222, 0x4221, 0x4141, 0x4081, 0x4141, 0x4221, 0x2222, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24E7 (ⓧ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x2222, 0x4221, 0x4221, 0x4221, 0x4341, 0x4281, 0x2202, 0x2202, 0x11c4, 0x0c18, 0x03e0, 0x0000 },	// U+24E8 (ⓨ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2002, 0x23e2, 0x4201, 0x4101, 0x4081, 0x4041, 0x4021, 0x23e2, 0x2002, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24E9 (ⓩ)
	{ 0x03e0, 0x0c18, 0x1004, 0x2082, 0x2142, 0x4221, 0x4221, 0x4221, 0x4221, 0x4221, 0x2142, 0x2082, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+24EA (⓪)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3ffe, 0x3dde, 0x7ccf, 0x7d57, 0x7ddf, 0x7ddf, 0x7ddf, 0x3006, 0x3ffe, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+24EB (⓫)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3ffe, 0x39de, 0x76cf, 0x77d7, 0x7bdf, 0x7ddf, 0x7edf, 0x3006, 0x3ffe, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+24EC (⓬)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3ffe, 0x39de, 0x76cf, 0x77d7, 0x7bdf, 0x77df, 0x76df, 0x3906, 0x3ffe, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+24ED (⓭)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3ffe, 0x37de, 0x73cf, 0x75d7, 0x76df, 0x60df, 0x77df, 0x3706, 0x3ffe, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+24EE (⓮)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3ffe, 0x30de, 0x7ecf, 0x7ed7, 0x78df, 0x77df, 0x76df, 0x3906, 0x3ffe, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+24EF (⓯)
	{ 0x0000, 0x03e0, 0x0ff8, 0x1ffc, 0x11dc, 0x3ece, 0x3ed6, 0x38de, 0x36de, 0x36de, 0x1904, 0x1ffc, 0x0ff8, 0x03e0, 0x0000, 0x0000 },	// U+24F0 (⓰)
	{ 0x0000, 0x03e0, 0x0ff8, 0x1ffc, 0x10dc, 0x37ce, 0x37d6, 0x3bde, 0x3bde, 0x3dde, 0x1d04, 0x1ffc, 0x0ff8, 0x03e0, 0x0000, 0x0000 },	// U+24F1 (⓱)
	{ 0x0000, 0x03e0, 0x0ff8, 0x1ffc, 0x19dc, 0x36ce, 0x36d6, 0x39de, 0x36de, 0x36de, 0x1904, 0x1ffc, 0x0ff8, 0x03e0, 0x0000, 0x0000 },	// U+24F2 (⓲)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3ffe, 0x39de, 0x76cf, 0x76d7, 0x71df, 0x77df, 0x77df, 0x3906, 0x3ffe, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+24F3 (⓳)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3ffe, 0x39ce, 0x76b7, 0x76bf, 0x76df, 0x76ef, 0x76f7, 0x3986, 0x3ffe, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+24F4 (⓴)
	{ 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9109, 0xa185, 0xa105, 0xa105, 0x9389, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0, 0x0000 },	// U+24F5 (⓵)
	{ 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9189, 0xa205, 0xa105, 0xa085, 0x9389, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0, 0x0000 },	// U+24F6 (⓶)
	{ 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9189, 0xa205, 0xa185, 0xa205, 0x9189, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0, 0x0000 },	// U+24F7 (⓷)
	{ 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9149, 0xa145, 0xa3c5, 0xa105, 0x9109, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0, 0x0000 },	// U+24F8 (⓸)
	{ 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9389, 0xa085, 0xa185, 0xa205, 0x9189, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0, 0x0000 },	// U+24F9 (⓹)
	{ 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9189, 0xa045, 0xa1c5, 0xa245, 0x9189, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0, 0x0000 },	// U+24FA (⓺)
	{ 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9389, 0xa205, 0xa205, 0xa105, 0x9109, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0, 0x0000 },	// U+24FB (⓻)
	{ 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9189, 0xa245, 0xa185, 0xa245, 0x9189, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0, 0x0000 },	// U+24FC (⓼)
	{ 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9189, 0xa245, 0xa385, 0xa205, 0x9189, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0, 0x0000 },	// U+24FD (⓽)
	{ 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9649, 0xa965, 0xa945, 0xa945, 0x96e9, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0, 0x0000 },	// U+24FE (⓾)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3f7e, 0x3ebe, 0x7ddf, 0x7ddf, 0x7ddf, 0x7ddf, 0x7ddf, 0x3ebe, 0x3f7e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+24FF (⓿)
}; // 181

static const uint16_t unifontdw_block207[][16] = {
	{ 0x0000, 0x0000, 0x0380, 0x0c60, 0x1010, 0x2008, 0x2008, 0x4004, 0x4004, 0x4004, 0x2008, 0x2008, 0x1010, 0x0c60, 0x0380, 0x0000 },	// U+25EF (◯)
}; // 1

static const uint16_t unifontdw_block208[][16] = {
	{ 0x13d1, 0x03c0, 0x8ff4, 0x2420, 0x0a51, 0x4814, 0x0a50, 0x2992, 0x8420, 0x07e2, 0x0810, 0x1108, 0x781e, 0x1108, 0x0810, 0x07e0 },	// U+2603 (☃)
}; // 1

static const uint16_t unifontdw_block209[][16] = {
	{ 0x0000, 0x0000, 0x1ffc, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1ffc, 0x0000, 0x0000 },	// U+2610 (☐)
	{ 0x0000, 0x0000, 0x1ffc, 0x1004, 0x1004, 0x1c04, 0x1614, 0x1314, 0x1194, 0x10d4, 0x1074, 0x1034, 0x1004, 0x1ffc, 0x0000, 0x0000 },	// U+2611 (☑)
	{ 0x0000, 0x0000, 0x3ffc, 0x2004, 0x2004, 0x2c34, 0x2664, 0x23c4, 0x2184, 0x23c4, 0x2664, 0x2c34, 0x2004, 0x3ffc, 0x0000, 0x0000 },	// U+2612 (☒)
}; // 3

static const uint16_t unifontdw_block210[][16] = {
	{ 0x0000, 0x0490, 0x0248, 0x0248, 0x0490, 0x0490, 0x0248, 0x0000, 0x13f8, 0x2ffc, 0x2bf4, 0x2804, 0x1c04, 0x03f8, 0x0000, 0x0000 },	// U+2615 (☕)
	{ 0x0000, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1ffc, 0x0000, 0x0000 },	// U+2616 (☖)
	{ 0x0000, 0x0080, 0x01c0, 0x03e0, 0x07f0, 0x0ff8, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x0000, 0x0000 },	// U+2617 (☗)
	{ 0x0000, 0x0000, 0x0140, 0x03e0, 0x03e0, 0x19cc, 0x3c9e, 0x1ffc, 0x3c9e, 0x188c, 0x0040, 0x0040, 0x0040, 0x0020, 0x0010, 0x0000 },	// U+2618 (☘)
	{ 0x0000, 0x0000, 0x2000, 0x1380, 0x17c4, 0x17e2, 0x17f2, 0x1bfe, 0x3bfc, 0x27f0, 0x27e0, 0x27c0, 0x2380, 0x1000, 0x0000, 0x0000 },	// U+2619 (☙)
}; // 5

static const uint16_t unifontdw_block211[][16] = {
	{ 0x07e0, 0x1818, 0x2424, 0x5c3a, 0x5c3a, 0xbe7d, 0xbe7d, 0xbe7d, 0x8181, 0x8181, 0x83c1, 0x43c2, 0x47e2, 0x23c4, 0x1818, 0x07e0 },	// U+2622 (☢)
	{ 0x0000, 0x0000, 0x0220, 0x0410, 0x0808, 0x0808, 0x09c8, 0x0630, 0x1f7c, 0x2222, 0x42a1, 0x41c1, 0x0140, 0x0220, 0x0c18, 0x0000 },	// U+2623 (☣)
	{ 0x0000, 0x00c0, 0x0080, 0x3ffe, 0x11c4, 0x0ff8, 0x0080, 0x06b0, 0x0888, 0x07f0, 0x0490, 0x03e0, 0x02a0, 0x01c0, 0x02a0, 0x0080 },	// U+2624 (☤)
}; // 3

static const uint16_t unifontdw_block212[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x02a0, 0x0360, 0x0000, 0x0aa8, 0x1494, 0x1494, 0x1494, 0x12a4, 0x09c8, 0x03e0, 0x0080, 0x0000, 0x0000 },	// U+262B (☫)
	{ 0x0000, 0x0000, 0x0000, 0x0100, 0x0540, 0x0920, 0x1390, 0x3558, 0x3558, 0x3398, 0x3938, 0x37d8, 0x2388, 0x0540, 0x0100, 0x0000 },	// U+262C (☬)
}; // 2

static const uint16_t unifontdw_block213[][16] = {
	{ 0x07e0, 0x1818, 0x2004, 0x4002, 0x4002, 0x8c39, 0x8c7d, 0xc0ff, 0xc1e7, 0xe3e7, 0xffff, 0x7ffe, 0x7ffe, 0x3ffc, 0x1ff8, 0x07e0 },	// U+262F (☯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000 },	// U+2630 (☰)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000 },	// U+2631 (☱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000 },	// U+2632 (☲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000 },	// U+2633 (☳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000 },	// U+2634 (☴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000 },	// U+2635 (☵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000 },	// U+2636 (☶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000 },	// U+2637 (☷)
}; // 9

static const uint16_t unifontdw_block214[][16] = {
	{ 0x03c0, 0x04a0, 0x1950, 0x1248, 0x0b50, 0x0c20, 0x200c, 0x5012, 0x8831, 0x900a, 0xa005, 0x6475, 0x1a4a, 0x614a, 0x3a78, 0x0400 },	// U+2672 (♲)
	{ 0x01c0, 0x0220, 0x0220, 0x0410, 0x1400, 0x189c, 0x1cd8, 0x0094, 0x1084, 0x21c2, 0x2002, 0x4401, 0x4201, 0x3f7e, 0x0200, 0x0400 },	// U+2673 (♳)
	{ 0x01c0, 0x0220, 0x0220, 0x0410, 0x1400, 0x18dc, 0x1d18, 0x0094, 0x1044, 0x21c2, 0x2002, 0x4401, 0x4201, 0x3f7e, 0x0200, 0x0400 },	// U+2674 (♴)
	{ 0x01c0, 0x0220, 0x0220, 0x0410, 0x1400, 0x18dc, 0x1d18, 0x00d4, 0x1104, 0x20c2, 0x2002, 0x4401, 0x4201, 0x3f7e, 0x0200, 0x0400 },	// U+2675 (♵)
	{ 0x01c0, 0x0220, 0x0220, 0x0410, 0x1400, 0x195c, 0x1d58, 0x01d4, 0x1104, 0x2102, 0x2002, 0x4401, 0x4201, 0x3f7e, 0x0200, 0x0400 },	// U+2676 (♶)
	{ 0x01c0, 0x0220, 0x0220, 0x0410, 0x1400, 0x19dc, 0x1c58, 0x00d4, 0x1104, 0x20c2, 0x2002, 0x4401, 0x4201, 0x3f7e, 0x0200, 0x0400 },	// U+2677 (♷)
	{ 0x01c0, 0x0220, 0x0220, 0x0410, 0x1400, 0x199c, 0x1c58, 0x01d4, 0x1244, 0x2182, 0x2002, 0x4401, 0x4201, 0x3f7e, 0x0200, 0x0400 },	// U+2678 (♸)
	{ 0x01c0, 0x0220, 0x0220, 0x0410, 0x1400, 0x19dc, 0x1d18, 0x0094, 0x1084, 0x2082, 0x2002, 0x4401, 0x4201, 0x3f7e, 0x0200, 0x0400 },	// U+2679 (♹)
	{ 0x01c0, 0x0220, 0x0220, 0x0410, 0x1400, 0x181c, 0x1c18, 0x0014, 0x1004, 0x2002, 0x2002, 0x4401, 0x4201, 0x3f7e, 0x0200, 0x0400 },	// U+267A (♺)
	{ 0x03c0, 0x07a0, 0x1f70, 0x1e78, 0x0f70, 0x0c20, 0x200c, 0x701e, 0xf83f, 0xf00e, 0xe007, 0x6477, 0x1e7a, 0x7f7a, 0x3e78, 0x0400 },	// U+267B (♻)
	{ 0x07e0, 0x1ff8, 0x3e7c, 0x7dbe, 0x7bde, 0xf1ff, 0xfbef, 0xffe7, 0xf7cf, 0xf7ef, 0xeff7, 0x6df6, 0x708e, 0x3dfc, 0x1ff8, 0x07e0 },	// U+267C (♼)
	{ 0x07e0, 0x1818, 0x2184, 0x4242, 0x4422, 0x8e01, 0x8411, 0x8019, 0x8831, 0x8811, 0x9009, 0x520a, 0x4f72, 0x2204, 0x1818, 0x07e0 },	// U+267D (♽)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0630, 0x0808, 0x1004, 0x1364, 0x2492, 0x2492, 0x1364, 0x1004, 0x0808, 0x0630, 0x01c0, 0x0000 },	// U+267E (♾)
	{ 0x0000, 0x0000, 0x0000, 0x0060, 0x0060, 0x0020, 0x01e0, 0x0020, 0x07e8, 0x0404, 0x0804, 0x0a04, 0x3108, 0x00f0, 0x0000, 0x0000 },	// U+267F (♿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0888, 0x0808, 0x0808, 0x0808, 0x0ff8, 0x0000, 0x0000, 0x0000 },	// U+2680 (⚀)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0808, 0x0808, 0x0828, 0x0808, 0x0a08, 0x0808, 0x0808, 0x0ff8, 0x0000, 0x0000, 0x0000 },	// U+2681 (⚁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0808, 0x0828, 0x0808, 0x0888, 0x0808, 0x0a08, 0x0808, 0x0ff8, 0x0000, 0x0000, 0x0000 },	// U+2682 (⚂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0808, 0x0a28, 0x0808, 0x0808, 0x0808, 0x0a28, 0x0808, 0x0ff8, 0x0000, 0x0000, 0x0000 },	// U+2683 (⚃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0808, 0x0a28, 0x0808, 0x0888, 0x0808, 0x0a28, 0x0808, 0x0ff8, 0x0000, 0x0000, 0x0000 },	// U+2684 (⚄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0808, 0x0a28, 0x0808, 0x0a28, 0x0808, 0x0a28, 0x0808, 0x0ff8, 0x0000, 0x0000, 0x0000 },	// U+2685 (⚅)
	{ 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x1008, 0x2004, 0x2604, 0x2604, 0x2004, 0x1008, 0x0810, 0x0420, 0x03c0, 0x0000 },	// U+2686 (⚆)
	{ 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0810, 0x1008, 0x2004, 0x2664, 0x2664, 0x2004, 0x1008, 0x0810, 0x0420, 0x03c0, 0x0000 },	// U+2687 (⚇)
	{ 0x0000, 0x0000, 0x0000, 0x03c0, 0x07e0, 0x0ff0, 0x1ff8, 0x3ffc, 0x39fc, 0x39fc, 0x3ffc, 0x1ff8, 0x0ff0, 0x07e0, 0x03c0, 0x0000 },	// U+2688 (⚈)
	{ 0x0000, 0x0000, 0x0000, 0x03c0, 0x07e0, 0x0ff0, 0x1ff8, 0x3ffc, 0x399c, 0x399c, 0x3ffc, 0x1ff8, 0x0ff0, 0x07e0, 0x03c0, 0x0000 },	// U+2689 (⚉)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+268A (⚊)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+268B (⚋)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+268C (⚌)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+268D (⚍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+268E (⚎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x3e3e, 0x3e3e, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+268F (⚏)
}; // 30

static const uint16_t unifontdw_block215[][16] = {
	{ 0x0000, 0x4c10, 0x3e3a, 0x7e7c, 0xf83e, 0xe41f, 0xc22e, 0x8144, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x1004, 0x2002, 0x0000 },	// U+2692 (⚒)
	{ 0x0000, 0x0000, 0x01c0, 0x0220, 0x0220, 0x01c0, 0x0080, 0x03e0, 0x0080, 0x1084, 0x388e, 0x1084, 0x0888, 0x07f0, 0x0000, 0x0000 },	// U+2693 (⚓)
	{ 0x0000, 0x2002, 0x1004, 0x0808, 0x0410, 0x0220, 0x0140, 0x0080, 0x0140, 0x0220, 0x1414, 0x0808, 0x1414, 0x2002, 0x0000, 0x0000 },	// U+2694 (⚔)
	{ 0x0000, 0x0080, 0x0080, 0x0ff0, 0x0c88, 0x0088, 0x03f0, 0x0480, 0x0480, 0x03e0, 0x0090, 0x01e0, 0x0280, 0x01c0, 0x0080, 0x0000 },	// U+2695 (⚕)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0888, 0x3ffe, 0x1c9c, 0x2a2a, 0x2a2a, 0x4949, 0x4949, 0x7f7f, 0x3e3e, 0x1c1c, 0x0000, 0x0000 },	// U+2696 (⚖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0fe0, 0x1fd0, 0x1fd0, 0x0f88, 0x0708, 0x0008, 0x0f80, 0x1240, 0x2220, 0x0000, 0x0000 },	// U+2697 (⚗)
	{ 0x0000, 0x0000, 0x01c0, 0x0220, 0x0220, 0x0220, 0x01c0, 0x0080, 0x1c9c, 0x1ebc, 0x0eb8, 0x06b0, 0x01c0, 0x0080, 0x0080, 0x0000 },	// U+2698 (⚘)
	{ 0x0000, 0x0000, 0x0080, 0x1084, 0x0be8, 0x0410, 0x0808, 0x0808, 0x388e, 0x0808, 0x0808, 0x0410, 0x0be8, 0x1084, 0x0080, 0x0000 },	// U+2699 (⚙)
	{ 0x0000, 0x0080, 0x0140, 0x1c9c, 0x3ffe, 0x7ebf, 0x02a0, 0x01c0, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+269A (⚚)
	{ 0x0180, 0x0240, 0x0240, 0x742e, 0x8e71, 0x85a1, 0x4e72, 0x35ac, 0x35ac, 0x4e72, 0x85a1, 0x8e71, 0x742e, 0x0240, 0x0240, 0x0180 },	// U+269B (⚛)
	{ 0x0080, 0x0140, 0x0220, 0x1a2c, 0x2632, 0x4221, 0x594d, 0x6553, 0x0d58, 0x0808, 0x0dd8, 0x0550, 0x1d5c, 0x1364, 0x0c98, 0x0080 },	// U+269C (⚜)
	{ 0x0080, 0x0140, 0x0220, 0x0220, 0x0010, 0x3fd6, 0x4011, 0x4411, 0x2406, 0x0818, 0x0a60, 0x1100, 0x1084, 0x1264, 0x0c18, 0x0000 },	// U+269D (⚝)
	{ 0x000c, 0x0030, 0x00c0, 0x0300, 0x0c00, 0x3000, 0x0000, 0x3ffc, 0x0000, 0x3000, 0x0c00, 0x0300, 0x00c0, 0x0030, 0x000c, 0x0000 },	// U+269E (⚞)
	{ 0x3000, 0x0c00, 0x0300, 0x00c0, 0x0030, 0x000c, 0x0000, 0x3ffc, 0x0000, 0x000c, 0x0030, 0x00c0, 0x0300, 0x0c00, 0x3000, 0x0000 },	// U+269F (⚟)
	{ 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0490, 0x0490, 0x0888, 0x0888, 0x1084, 0x1004, 0x2082, 0x2002, 0x3ffe, 0x0000 },	// U+26A0 (⚠)
}; // 15

static const uint16_t unifontdw_block216[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0770, 0x0888, 0x1144, 0x1144, 0x0888, 0x0770, 0x0220, 0x0770, 0x0220, 0x0000, 0x0000 },	// U+26A2 (⚢)
	{ 0x0000, 0x0000, 0x0000, 0x0380, 0x0300, 0x0280, 0x1c70, 0x1888, 0x15c4, 0x02a4, 0x0458, 0x0430, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+26A3 (⚣)
	{ 0x0000, 0x1c00, 0x1800, 0x1400, 0x0380, 0x0440, 0x08e0, 0x0950, 0x0688, 0x0308, 0x0110, 0x00e0, 0x0040, 0x00e0, 0x0040, 0x0000 },	// U+26A4 (⚤)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e00, 0x0c00, 0x0a00, 0x01c0, 0x0220, 0x0410, 0x0410, 0x0220, 0x01c0, 0x0080, 0x01c0, 0x0080 },	// U+26A5 (⚥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c00, 0x1800, 0x1500, 0x0200, 0x0570, 0x0088, 0x0104, 0x0104, 0x0088, 0x0070, 0x0000, 0x0000 },	// U+26A6 (⚦)
	{ 0x0000, 0x0000, 0x0000, 0x7007, 0x6003, 0x5015, 0x0808, 0x05d4, 0x0220, 0x0410, 0x0410, 0x0220, 0x01c0, 0x0080, 0x01c0, 0x0080 },	// U+26A7 (⚧)
}; // 6

static const uint16_t unifontdw_block217[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0038, 0x1044, 0x2282, 0x7f82, 0x2282, 0x1044, 0x0038, 0x0000 },	// U+26A9 (⚩)
}; // 1

static const uint16_t unifontdw_block218[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0770, 0x0888, 0x1144, 0x1144, 0x0888, 0x0770, 0x0000, 0x0000 },	// U+26AD (⚭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x1d70, 0x2388, 0x2388, 0x2388, 0x1d70, 0x0100, 0x0000 },	// U+26AE (⚮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c1c, 0x2222, 0x23e2, 0x2222, 0x1c1c, 0x0000, 0x0000 },	// U+26AF (⚯)
	{ 0x0000, 0x0000, 0x0030, 0x03c8, 0x7c04, 0x4002, 0x4002, 0x4002, 0x4002, 0x7c06, 0x43ca, 0x7c74, 0x03d8, 0x0030, 0x0000, 0x0000 },	// U+26B0 (⚰)
	{ 0x0000, 0x03e0, 0x0140, 0x07f0, 0x0808, 0x1004, 0x1004, 0x0808, 0x0808, 0x0808, 0x0410, 0x0410, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+26B1 (⚱)
}; // 5

static const uint16_t unifontdw_block219[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x1c9c, 0x0220, 0x0140, 0x3c9e, 0x0220, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+26B6 (⚶)
}; // 1

static const uint16_t unifontdw_block220[][16] = {
	{ 0x0000, 0x0000, 0x0380, 0x0ce0, 0x1cf0, 0x3ce8, 0x2008, 0x4384, 0x47c4, 0x739c, 0x3838, 0x3018, 0x1390, 0x0fe0, 0x0380, 0x0000 },	// U+26BD (⚽)
	{ 0x0000, 0x0000, 0x0380, 0x0c60, 0x1830, 0x2448, 0x2008, 0x4284, 0x4004, 0x4284, 0x2008, 0x2448, 0x1830, 0x0c60, 0x0380, 0x0000 },	// U+26BE (⚾)
	{ 0x0000, 0x0000, 0x3ffe, 0x2002, 0x21c2, 0x2222, 0x2222, 0x21c2, 0x2082, 0x2082, 0x2082, 0x2382, 0x2082, 0x2002, 0x3ffe, 0x0000 },	// U+26BF (⚿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x1818, 0x2184, 0x2184, 0x381c, 0x2ff4, 0x2a54, 0x1a58, 0x07e0, 0x0000, 0x0000 },	// U+26C0 (⛀)
	{ 0x0000, 0x0000, 0x07e0, 0x1818, 0x2184, 0x2184, 0x381c, 0x2ff4, 0x2a54, 0x3a5c, 0x2ff4, 0x2a54, 0x1a58, 0x07e0, 0x0000, 0x0000 },	// U+26C1 (⛁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff0, 0x381c, 0x67e6, 0x5e7a, 0x5e7a, 0x47e2, 0x500a, 0x55aa, 0x65a6, 0x381c, 0x0ff0, 0x0000 },	// U+26C2 (⛂)
	{ 0x0000, 0x0ff0, 0x381c, 0x67e6, 0x5e7a, 0x5e7a, 0x47e2, 0x500a, 0x55aa, 0x45a2, 0x500a, 0x55aa, 0x65a6, 0x381c, 0x0ff0, 0x0000 },	// U+26C3 (⛃)
	{ 0x03c0, 0x03c0, 0x0ff0, 0x0420, 0x0a50, 0x0810, 0x0a50, 0x0990, 0x0420, 0x07e0, 0x0810, 0x1108, 0x781e, 0x1108, 0x0810, 0x07e0 },	// U+26C4 (⛄)
	{ 0x0000, 0x0000, 0x0000, 0x0480, 0x1280, 0x0800, 0x0300, 0x34e0, 0x0590, 0x0608, 0x0804, 0x0804, 0x0608, 0x01f0, 0x0000, 0x0000 },	// U+26C5 (⛅)
	{ 0x0000, 0x4444, 0x2222, 0x1100, 0x0008, 0x4444, 0x2222, 0x1100, 0x0008, 0x4444, 0x2222, 0x0100, 0x4808, 0x2444, 0x1222, 0x0000 },	// U+26C6 (⛆)
	{ 0x13d1, 0x03c0, 0x8ff4, 0x27e0, 0x0db1, 0x4ff4, 0x0db0, 0x2e72, 0x87e0, 0x07e2, 0x0ff0, 0x1ef8, 0x7ffe, 0x1ef8, 0x0ff0, 0x07e0 },	// U+26C7 (⛇)
	{ 0x0000, 0x04e0, 0x3310, 0x4d08, 0x4084, 0x4104, 0x2088, 0x1850, 0x07e0, 0x0004, 0x0222, 0x0100, 0x0808, 0x0444, 0x0222, 0x0000 },	// U+26C8 (⛈)
	{ 0x0000, 0x1ffc, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x0808, 0x0410, 0x0220, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+26C9 (⛉)
	{ 0x0000, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x0ff8, 0x07f0, 0x01c0, 0x0080, 0x0000, 0x0000 },	// U+26CA (⛊)
	{ 0x0000, 0x0000, 0x0000, 0x0ffe, 0x08a2, 0x0912, 0x0a0a, 0x0c06, 0x0802, 0x0c06, 0x0a0a, 0x0912, 0x08a2, 0x0ffe, 0x0000, 0x0000 },	// U+26CB (⛋)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0404, 0x0208, 0x0110, 0x0020, 0x0040, 0x0080, 0x0110, 0x0208, 0x0404, 0x0000, 0x0000, 0x0000 },	// U+26CC (⛌)
	{ 0x0000, 0x003c, 0x0042, 0x0042, 0x0081, 0x00ff, 0x00ff, 0x00ff, 0x0042, 0x0042, 0x0200, 0x0500, 0x0880, 0x1040, 0x2020, 0x7ff0 },	// U+26CD (⛍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0220, 0x0220, 0x0a20, 0x1278, 0x12a4, 0x0f24, 0x0228, 0x0220, 0x0660, 0x0000, 0x0000 },	// U+26CE (⛎)
	{ 0x0000, 0x0302, 0x00e4, 0x0038, 0x0038, 0x007c, 0x00cc, 0x0184, 0x0302, 0x0602, 0x0c00, 0x1800, 0x3000, 0x6000, 0x0000, 0x0000 },	// U+26CF (⛏)
	{ 0x0000, 0x0700, 0x08c0, 0x13a0, 0x1fc0, 0x1720, 0x0c00, 0x0200, 0x0038, 0x0184, 0x0044, 0x0358, 0x0440, 0x043c, 0x0000, 0x0000 },	// U+26D0 (⛐)
	{ 0x0000, 0x0000, 0x00e0, 0x03b8, 0x071c, 0x0fbe, 0x1fff, 0x0802, 0x0802, 0x0802, 0x0404, 0x0404, 0x0318, 0x00e0, 0x0000, 0x0000 },	// U+26D1 (⛑)
	{ 0x0000, 0x0000, 0x00e0, 0x0318, 0x0404, 0x0a0a, 0x0912, 0x1081, 0x1041, 0x1021, 0x0912, 0x0a0a, 0x0404, 0x0318, 0x00e0, 0x0000 },	// U+26D2 (⛒)
	{ 0x0000, 0x0844, 0x1c54, 0x2a38, 0x2210, 0x2238, 0x2a54, 0x1c44, 0x0844, 0x1c54, 0x2a38, 0x2210, 0x2238, 0x2a54, 0x1c44, 0x0800 },	// U+26D3 (⛓)
	{ 0x0000, 0x0000, 0x0000, 0x00e0, 0x03f8, 0x07fc, 0x0ffe, 0x0ffe, 0x1803, 0x1803, 0x0ffe, 0x0ffe, 0x07fc, 0x03f8, 0x00e0, 0x0000 },	// U+26D4 (⛔)
	{ 0x0000, 0x0000, 0x0c30, 0x0c78, 0x0cb4, 0x0c30, 0x0710, 0x03d0, 0x0050, 0x03d0, 0x0710, 0x0c30, 0x2d30, 0x1e30, 0x0c30, 0x0000 },	// U+26D5 (⛕)
	{ 0x0000, 0x0000, 0x0180, 0x03c0, 0x07e0, 0x0bd0, 0x1b88, 0x3b54, 0x7bde, 0x2adc, 0x11d8, 0x0bf0, 0x07e0, 0x03c0, 0x0180, 0x0000 },	// U+26D6 (⛖)
	{ 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1428, 0x2474, 0x44aa, 0x8421, 0x5522, 0x2e24, 0x1408, 0x0810, 0x0420, 0x0240, 0x0180 },	// U+26D7 (⛗)
	{ 0x0000, 0x0000, 0x3fe0, 0x3fe0, 0x3fe0, 0x3ff0, 0x3ff8, 0x3ffc, 0x3ffc, 0x3ffc, 0x3ffc, 0x3ffc, 0x3ffc, 0x3ffc, 0x0000, 0x0000 },	// U+26D8 (⛘)
	{ 0x0000, 0x0000, 0x6018, 0x6098, 0x6098, 0x6098, 0x600c, 0x6086, 0x6083, 0x6083, 0x6003, 0x6083, 0x6083, 0x6083, 0x0000, 0x0000 },	// U+26D9 (⛙)
	{ 0x0000, 0x0000, 0x781e, 0x781e, 0x700e, 0x6006, 0x0000, 0x0000, 0x0000, 0x0000, 0x6006, 0x700e, 0x781e, 0x781e, 0x0000, 0x0000 },	// U+26DA (⛚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0c18, 0x0630, 0x0630, 0x0360, 0x03e0, 0x01c0, 0x01c0, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+26DB (⛛)
	{ 0x0000, 0x0000, 0xc018, 0xc218, 0xc218, 0xc218, 0xc00c, 0xc206, 0xc203, 0xc203, 0xc023, 0xc223, 0xc223, 0xc223, 0x0000, 0x0000 },	// U+26DC (⛜)
	{ 0x0000, 0x0000, 0x0000, 0x1ffc, 0x180c, 0x1414, 0x1224, 0x1144, 0x1084, 0x1144, 0x1224, 0x1414, 0x180c, 0x1ffc, 0x0000, 0x0000 },	// U+26DD (⛝)
	{ 0x0000, 0x0000, 0x1fbf, 0x1f1f, 0x1c07, 0x180b, 0x1813, 0x1021, 0x0040, 0x1081, 0x1903, 0x1a03, 0x1c07, 0x1f1f, 0x1fbf, 0x0000 },	// U+26DE (⛞)
	{ 0x0000, 0x0000, 0x0ffe, 0x0ffe, 0x3ffe, 0x4ffe, 0x4ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x6ff6, 0x57ea, 0x381c, 0x1008, 0x0000, 0x0000 },	// U+26DF (⛟)
	{ 0x0000, 0x7ffe, 0x407c, 0x4238, 0x4210, 0x4000, 0x4200, 0x4200, 0x4000, 0x4200, 0x4200, 0x4000, 0x4200, 0x4200, 0x4000, 0x0000 },	// U+26E0 (⛠)
	{ 0x0000, 0x0002, 0x0006, 0x000e, 0x001e, 0x000e, 0x0006, 0x0002, 0x0102, 0x0202, 0x0442, 0x0862, 0x1072, 0x207a, 0x7ffe, 0x0000 },	// U+26E1 (⛡)
}; // 37

static const uint16_t unifontdw_block221[][16] = {
	{ 0x0000, 0x0080, 0x0c98, 0x0c98, 0x0080, 0x0080, 0x01c0, 0x0630, 0x0410, 0x0808, 0x0808, 0x0808, 0x0410, 0x0630, 0x01c0, 0x0000 },	// U+26E3 (⛣)
	{ 0x0000, 0x0080, 0x0080, 0x0140, 0x0140, 0x0140, 0x3ffe, 0x1224, 0x0a28, 0x0630, 0x0550, 0x0490, 0x0b68, 0x0c18, 0x1004, 0x0000 },	// U+26E4 (⛤)
	{ 0x0000, 0x0080, 0x0080, 0x0140, 0x0140, 0x0100, 0x3afe, 0x1204, 0x0828, 0x0610, 0x0050, 0x0490, 0x0b28, 0x0c18, 0x1004, 0x0000 },	// U+26E5 (⛥)
	{ 0x0000, 0x0080, 0x0080, 0x0140, 0x0140, 0x0040, 0x3fae, 0x1024, 0x0a08, 0x0430, 0x0500, 0x0490, 0x0a68, 0x0c18, 0x1004, 0x0000 },	// U+26E6 (⛦)
	{ 0x0000, 0x1004, 0x0c18, 0x0b68, 0x0490, 0x0550, 0x0630, 0x0a28, 0x1224, 0x3ffe, 0x0140, 0x0140, 0x0140, 0x0080, 0x0080, 0x0000 },	// U+26E7 (⛧)
	{ 0x0000, 0x0000, 0x0000, 0x0ffc, 0x0804, 0x08c4, 0x08c4, 0x0bf4, 0x0bf4, 0x08c4, 0x08c4, 0x0804, 0x0c0c, 0x0330, 0x00c0, 0x0000 },	// U+26E8 (⛨)
	{ 0x0000, 0x0000, 0x7fff, 0x0808, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0000, 0x0000 },	// U+26E9 (⛩)
	{ 0x0080, 0x0080, 0x03e0, 0x0080, 0x0080, 0x01c0, 0x03e0, 0x0ff8, 0x3e3e, 0x1c1c, 0x19cc, 0x1bec, 0x1bec, 0x1bec, 0x0000, 0x0000 },	// U+26EA (⛪)
	{ 0x0000, 0x0000, 0x0000, 0x01f0, 0x0110, 0x0f1e, 0x0802, 0x0802, 0x0802, 0x0802, 0x0802, 0x0802, 0x0802, 0x0802, 0x0000, 0x0000 },	// U+26EB (⛫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c30, 0x0c30, 0x0000, 0x0000, 0x0000 },	// U+26EC (⛬)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0888, 0x05d0, 0x0220, 0x0410, 0x1c1c, 0x0410, 0x0220, 0x05d0, 0x0888, 0x0080, 0x0000, 0x0000 },	// U+26ED (⛭)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0888, 0x05d0, 0x2220, 0x2410, 0x3c1e, 0x0412, 0x0222, 0x05d0, 0x0888, 0x0080, 0x0000, 0x0000 },	// U+26EE (⛮)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0888, 0x05d0, 0x0220, 0x05d0, 0x1ddc, 0x05d0, 0x0220, 0x05d0, 0x0888, 0x0080, 0x0000, 0x0000 },	// U+26EF (⛯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0620, 0x0820, 0x1810, 0x1fc8, 0x3ffc, 0x3ffc, 0x7ffe, 0x7ffe, 0x0000, 0x0000 },	// U+26F0 (⛰)
	{ 0x0000, 0x07e0, 0x1818, 0x2414, 0x47e2, 0x789e, 0x4082, 0x0040, 0x0040, 0x0040, 0x0020, 0x0020, 0x0020, 0x7ffe, 0x7ffe, 0x0000 },	// U+26F1 (⛱)
	{ 0x0000, 0x0a28, 0x1144, 0x2142, 0x2002, 0x21c2, 0x23e2, 0x03e0, 0x0000, 0x3ffe, 0x1ffc, 0x07f0, 0x07f0, 0x0ff8, 0x1ffc, 0x0000 },	// U+26F2 (⛲)
	{ 0x0000, 0x0180, 0x0780, 0x1f80, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x1ebc, 0x3ebe, 0x7e3f, 0x3f7e, 0x1ffc, 0x03e0, 0x0000 },	// U+26F3 (⛳)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x07e0, 0x0a50, 0x1248, 0x1244, 0x3fff, 0x1ffc, 0x1ff8, 0x0ff0, 0x0000, 0x0000, 0x0000 },	// U+26F4 (⛴)
	{ 0x0000, 0x0080, 0x0180, 0x0280, 0x02a0, 0x04b0, 0x04a8, 0x08a4, 0x08a2, 0x1fbf, 0x0080, 0x3fff, 0x1ffc, 0x1ff8, 0x0ff0, 0x0000 },	// U+26F5 (⛵)
	{ 0x0000, 0x381c, 0x4002, 0x4002, 0x4002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x4002, 0x4002, 0x381c, 0x0000 },	// U+26F6 (⛶)
	{ 0x0000, 0x0000, 0x001c, 0x001c, 0x001c, 0x0060, 0x0470, 0x0ffe, 0x0438, 0x3038, 0x0c70, 0x03f0, 0x00c0, 0x0038, 0x0000, 0x0000 },	// U+26F7 (⛷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x0f00, 0x0f00, 0x0f00, 0x0ff8, 0x0ffc, 0x07fc, 0x0210, 0x1ffc, 0x0000, 0x0000 },	// U+26F8 (⛸)
	{ 0x0000, 0x01c0, 0x01c0, 0x01c0, 0x0000, 0x3fc0, 0x01e0, 0x01d0, 0x31c8, 0x31c4, 0x01c0, 0x0360, 0x0360, 0x0630, 0x0630, 0x3c1e },	// U+26F9 (⛹)
	{ 0x0000, 0x0060, 0x00a0, 0x0170, 0x0270, 0x0470, 0x08f8, 0x10f8, 0x20f8, 0x41fc, 0x21fc, 0x118c, 0x138e, 0x0b8e, 0x078e, 0x0000 },	// U+26FA (⛺)
	{ 0x0000, 0x0000, 0x03e0, 0x0c18, 0x1004, 0x180c, 0x0410, 0x0220, 0x0220, 0x0220, 0x0410, 0x180c, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+26FB (⛻)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x03e0, 0x0000, 0x0000, 0x0808, 0x0808, 0x0808, 0x0808, 0x3e3e, 0x0000, 0x0000 },	// U+26FC (⛼)
	{ 0x0000, 0x0000, 0x01f0, 0x1bf8, 0x2208, 0x4208, 0x4ff8, 0x53f8, 0x53f8, 0x53f8, 0x53f8, 0x23f8, 0x03f8, 0x0ffe, 0x0000, 0x0000 },	// U+26FD (⛽)
	{ 0x0000, 0x7ffe, 0x7ffe, 0x600e, 0x580e, 0x580e, 0x580e, 0x600e, 0x701e, 0x783e, 0x4ff2, 0x47e2, 0x6006, 0x781e, 0x7ffe, 0x0000 },	// U+26FE (⛾)
	{ 0x0000, 0x0000, 0x3ffe, 0x2002, 0x2002, 0x3ffe, 0x3ffe, 0x2002, 0x2002, 0x3ffe, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0000 },	// U+26FF (⛿)
	{ 0x0000, 0x0000, 0x201c, 0x783e, 0x3c36, 0x1efe, 0x0ffc, 0x07c0, 0x0ffc, 0x1efe, 0x3c36, 0x783e, 0x201c, 0x0000, 0x0000, 0x0000 },	// U+2700 (✀)
	{ 0x0000, 0x001c, 0x003e, 0x0036, 0x003e, 0x003c, 0x0070, 0x3ffe, 0x7fff, 0x039b, 0x071f, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2701 (✁)
	{ 0x0000, 0x0000, 0x601c, 0x383e, 0x1c36, 0x0efe, 0x07fc, 0x03c0, 0x07fc, 0x0efe, 0x1c36, 0x383e, 0x601c, 0x0000, 0x0000, 0x0000 },	// U+2702 (✂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x000e, 0x071f, 0x039b, 0x7fff, 0x3ffe, 0x0070, 0x003c, 0x003e, 0x0036, 0x003e, 0x001c, 0x0000 },	// U+2703 (✃)
	{ 0x0000, 0x0000, 0x300e, 0x4c11, 0x2275, 0x1181, 0x089e, 0x0460, 0x0a1e, 0x1181, 0x2275, 0x4c11, 0x300e, 0x0000, 0x0000, 0x0000 },	// U+2704 (✄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x5000, 0x4800, 0x2400, 0x1204, 0x090a, 0x048a, 0x0254, 0x0124, 0x0088, 0x0070, 0x0000 },	// U+2705 (✅)
	{ 0x03e0, 0x0c18, 0x1004, 0x2382, 0x27e2, 0x4ff1, 0x4ef1, 0x4679, 0x4039, 0x40f9, 0x20f2, 0x2062, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2706 (✆)
	{ 0x03e0, 0x0c98, 0x11c4, 0x21c2, 0x2082, 0x41c1, 0x43e1, 0x43e1, 0x43e1, 0x45d1, 0x2e3a, 0x2c1a, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2707 (✇)
	{ 0x0000, 0x0010, 0x00f0, 0x0060, 0x03e0, 0x01c3, 0x03c7, 0x7ffe, 0x7ffe, 0x03c7, 0x01c3, 0x03e0, 0x0060, 0x00f0, 0x0010, 0x0000 },	// U+2708 (✈)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x6006, 0x500a, 0x4992, 0x47e2, 0x47e2, 0x4992, 0x500a, 0x6006, 0x7ffe, 0x0000, 0x0000 },	// U+2709 (✉)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x06c0, 0x0930, 0x0928, 0x1fac, 0x20aa, 0x272a, 0x232a, 0x20ec, 0x1014, 0x0808, 0x07f0, 0x0000 },	// U+270A (✊)
	{ 0x0000, 0x0150, 0x02a8, 0x02a8, 0x02ac, 0x02aa, 0x32aa, 0x4aaa, 0x4402, 0x2002, 0x1002, 0x0804, 0x0808, 0x07f0, 0x0000, 0x0000 },	// U+270B (✋)
	{ 0x0c18, 0x1224, 0x1144, 0x0948, 0x0888, 0x0490, 0x0410, 0x3f3e, 0x4149, 0x4e49, 0x4449, 0x4249, 0x203e, 0x1004, 0x0ff8, 0x0000 },	// U+270C (✌)
	{ 0x0000, 0x1000, 0x3800, 0x1c00, 0xefc0, 0xaf30, 0xb388, 0xa1c4, 0xa0e2, 0xa7f6, 0xa048, 0xbff4, 0xa00e, 0xe006, 0x0000, 0x0000 },	// U+270D (✍)
	{ 0x0000, 0x0000, 0x0018, 0x0064, 0x00aa, 0x0152, 0x028e, 0x0514, 0x0a28, 0x1450, 0x14a0, 0x1340, 0x1880, 0x1f00, 0x0000, 0x0000 },	// U+270E (✎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ffc, 0x140a, 0x2ff1, 0x6815, 0x2ff1, 0x140a, 0x0ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+270F (✏)
	{ 0x0000, 0x0000, 0x1f00, 0x1880, 0x1340, 0x14a0, 0x1450, 0x0a28, 0x0514, 0x028e, 0x0152, 0x00aa, 0x0064, 0x0018, 0x0000, 0x0000 },	// U+2710 (✐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x109e, 0x3661, 0x7f01, 0x3661, 0x109e, 0x0f00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2711 (✑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x0f9e, 0x1cff, 0x70ff, 0x1cff, 0x0f9e, 0x0700, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2712 (✒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x1000, 0x0800, 0x0402, 0x0202, 0x0104, 0x0084, 0x0048, 0x0028, 0x0010, 0x0000 },	// U+2713 (✓)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x7000, 0x3802, 0x1c07, 0x0e07, 0x070e, 0x038e, 0x01dc, 0x00fc, 0x0078, 0x0030, 0x0000 },	// U+2714 (✔)
	{ 0x0000, 0x0000, 0x0808, 0x1c1c, 0x0e38, 0x0770, 0x03e0, 0x01c0, 0x03e0, 0x0770, 0x0e38, 0x1c1c, 0x0808, 0x0000, 0x0000, 0x0000 },	// U+2715 (✕)
	{ 0x0808, 0x1c1c, 0x3e3e, 0x7f7f, 0x3ffe, 0x1ffc, 0x0ff8, 0x07f0, 0x0ff8, 0x1ffc, 0x3ffe, 0x7f7f, 0x3e3e, 0x1c1c, 0x0808, 0x0000 },	// U+2716 (✖)
	{ 0x0000, 0x1806, 0x060c, 0x038c, 0x00d8, 0x0070, 0x0070, 0x00d8, 0x0198, 0x030c, 0x060c, 0x0c06, 0x1806, 0x0004, 0x0000, 0x0000 },	// U+2717 (✗)
	{ 0x0000, 0x1806, 0x0e0e, 0x078c, 0x01dc, 0x00f8, 0x0070, 0x00f8, 0x01d8, 0x039c, 0x070c, 0x0e0e, 0x1c06, 0x0806, 0x0004, 0x0000 },	// U+2718 (✘)
	{ 0x03e0, 0x0220, 0x02a0, 0x02a0, 0x02a0, 0x7ebf, 0x4081, 0x5ffd, 0x4081, 0x7ebf, 0x02a0, 0x02a0, 0x02a0, 0x0220, 0x03e0, 0x0000 },	// U+2719 (✙)
	{ 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x0000 },	// U+271A (✚)
	{ 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x7e3f, 0x7e3f, 0x7e3f, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x0000 },	// U+271B (✛)
	{ 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x7c1f, 0x7c1f, 0x7c1f, 0x7c1f, 0x7c1f, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x0000 },	// U+271C (✜)
	{ 0x0000, 0x0000, 0x01c0, 0x01c0, 0x01c0, 0x0ff8, 0x0ff8, 0x0ff8, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+271D (✝)
	{ 0x01e0, 0x0320, 0x0320, 0x0320, 0x1f3e, 0x3002, 0x3002, 0x3f3e, 0x3f3c, 0x0320, 0x0320, 0x0320, 0x0320, 0x03e0, 0x03c0, 0x0000 },	// U+271E (✞)
	{ 0x0000, 0x07f0, 0x0410, 0x3dde, 0x21c2, 0x2ffa, 0x2ffa, 0x2ffa, 0x21c2, 0x3dde, 0x05d0, 0x05d0, 0x05d0, 0x0410, 0x07f0, 0x0000 },	// U+271F (✟)
	{ 0x0ff8, 0x03e0, 0x01c0, 0x41c1, 0x41c1, 0x61c3, 0x7fff, 0x7fff, 0x7fff, 0x61c3, 0x41c1, 0x41c1, 0x01c0, 0x03e0, 0x0ff8, 0x0000 },	// U+2720 (✠)
	{ 0x0000, 0x0000, 0x0080, 0x0140, 0x0220, 0x3ffe, 0x1224, 0x0c18, 0x0410, 0x0c18, 0x1224, 0x3ffe, 0x0220, 0x0140, 0x0080, 0x0000 },	// U+2721 (✡)
	{ 0x01c0, 0x03e0, 0x03e0, 0x01c0, 0x01c0, 0x3086, 0x7c9f, 0x7fff, 0x7c9f, 0x3086, 0x01c0, 0x01c0, 0x03e0, 0x03e0, 0x01c0, 0x0000 },	// U+2722 (✢)
	{ 0x01c0, 0x03e0, 0x03e0, 0x03e0, 0x01c0, 0x388e, 0x7c9f, 0x7fff, 0x7c9f, 0x388e, 0x01c0, 0x03e0, 0x03e0, 0x03e0, 0x01c0, 0x0000 },	// U+2723 (✣)
	{ 0x03e0, 0x07f0, 0x07f0, 0x03e0, 0x31c6, 0x79cf, 0x7fff, 0x7fff, 0x7fff, 0x79cf, 0x31c6, 0x03e0, 0x07f0, 0x07f0, 0x03e0, 0x0000 },	// U+2724 (✤)
	{ 0x0080, 0x01c0, 0x03e0, 0x03e0, 0x0080, 0x308c, 0x708e, 0xffff, 0x708e, 0x308c, 0x0080, 0x03e0, 0x03e0, 0x01c0, 0x0080, 0x0000 },	// U+2725 (✥)
	{ 0x0080, 0x01c0, 0x01c0, 0x03e0, 0x03e0, 0x0ff8, 0x3ffe, 0x7fff, 0x3ffe, 0x0ff8, 0x03e0, 0x03e0, 0x01c0, 0x01c0, 0x0080, 0x0000 },	// U+2726 (✦)
	{ 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0c18, 0x3006, 0x4001, 0x3006, 0x0c18, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080, 0x0000 },	// U+2727 (✧)
	{ 0x0000, 0x0020, 0x0020, 0x0050, 0x0088, 0x0306, 0x0888, 0x0850, 0x1420, 0x6320, 0x1400, 0x0800, 0x0880, 0x0140, 0x0080, 0x0000 },	// U+2728 (✨)
	{ 0x0000, 0x0080, 0x0140, 0x0140, 0x7e3f, 0x2002, 0x1c1c, 0x0410, 0x0808, 0x0888, 0x1364, 0x1414, 0x180c, 0x0000, 0x0000, 0x0000 },	// U+2729 (✩)
	{ 0x03e0, 0x0ff8, 0x1f7c, 0x3f7e, 0x3e3e, 0x6003, 0x780f, 0x7c1f, 0x780f, 0x788f, 0x33e6, 0x37f6, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+272A (✪)
	{ 0x0000, 0x0080, 0x01c0, 0x01c0, 0x7fff, 0x3e3e, 0x1c1c, 0x0410, 0x0e38, 0x0ff8, 0x1f7c, 0x1c1c, 0x180c, 0x0000, 0x0000, 0x0000 },	// U+272B (✫)
	{ 0x0000, 0x0080, 0x0140, 0x0140, 0x7e3f, 0x21c2, 0x13e4, 0x0be8, 0x09c8, 0x0808, 0x13e4, 0x1414, 0x180c, 0x0000, 0x0000, 0x0000 },	// U+272C (✬)
	{ 0x0000, 0x0080, 0x0140, 0x0e38, 0x7087, 0x27f2, 0x11c4, 0x0be8, 0x0a28, 0x0888, 0x1144, 0x1634, 0x180c, 0x0000, 0x0000, 0x0000 },	// U+272D (✭)
	{ 0x0000, 0x0080, 0x0140, 0x0eb8, 0x71c7, 0x2ffa, 0x17f4, 0x0be8, 0x0b68, 0x0aa8, 0x1144, 0x1634, 0x180c, 0x0000, 0x0000, 0x0000 },	// U+272E (✮)
	{ 0x0000, 0x0080, 0x01c0, 0x03a0, 0x7f9f, 0x31ba, 0x1de4, 0x0fc8, 0x0bf0, 0x09b8, 0x0b98, 0x174c, 0x1e34, 0x180c, 0x0000, 0x0000 },	// U+272F (✯)
	{ 0x0000, 0x0080, 0x0140, 0x0340, 0x7e3f, 0xe002, 0x7c1c, 0x3c10, 0x0808, 0x1888, 0x13e4, 0x34f4, 0x383c, 0x3018, 0x0000, 0x0000 },	// U+2730 (✰)
	{ 0x0000, 0x01c0, 0x01c0, 0x01c0, 0x21c2, 0x79cf, 0x3ffc, 0x0ff0, 0x3ffc, 0x79cf, 0x21c2, 0x01c0, 0x01c0, 0x01c0, 0x0000, 0x0000 },	// U+2731 (✱)
	{ 0x0000, 0x01c0, 0x01c0, 0x01c0, 0x21c2, 0x79cf, 0x3e3c, 0x0c10, 0x3e3c, 0x79cf, 0x21c2, 0x01c0, 0x01c0, 0x01c0, 0x0000, 0x0000 },	// U+2732 (✲)
	{ 0x0080, 0x0080, 0x1084, 0x0888, 0x06b0, 0x07f0, 0x03e0, 0x7fff, 0x03e0, 0x07f0, 0x06b0, 0x0888, 0x1084, 0x0080, 0x0080, 0x0000 },	// U+2733 (✳)
	{ 0x0080, 0x0080, 0x1084, 0x0dd8, 0x0ff8, 0x07f0, 0x07f8, 0x7fff, 0x0ff8, 0x07f0, 0x0ff8, 0x0dd8, 0x1084, 0x0080, 0x0080, 0x0000 },	// U+2734 (✴)
	{ 0x0080, 0x0140, 0x1f3c, 0x1334, 0x1964, 0x1d4c, 0x32be, 0x61c1, 0x3eb2, 0x195c, 0x134c, 0x1664, 0x1e7c, 0x0140, 0x0080, 0x0000 },	// U+2735 (✵)
	{ 0x0000, 0x0080, 0x0080, 0x0080, 0x21c2, 0x1ddc, 0x0ff8, 0x07f0, 0x0ff8, 0x1ddc, 0x21c2, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+2736 (✶)
	{ 0x0410, 0x0410, 0x0630, 0x0360, 0x7367, 0x1ddc, 0x0ff8, 0x03e0, 0x0ff8, 0x1ddc, 0x7367, 0x0360, 0x0630, 0x0410, 0x0410, 0x0000 },	// U+2737 (✷)
	{ 0x0410, 0x0630, 0x0770, 0x07f0, 0x7fff, 0x3ffe, 0x1ffc, 0x0ff8, 0x1ffc, 0x3ffe, 0x7fff, 0x07f0, 0x0770, 0x0630, 0x0410, 0x0000 },	// U+2738 (✸)
	{ 0x0080, 0x0c98, 0x07f0, 0x27f2, 0x3ffe, 0x1ffc, 0x1ffc, 0x7fff, 0x1ffc, 0x1ffc, 0x3ffe, 0x27f2, 0x07f0, 0x0c98, 0x0080, 0x0000 },	// U+2739 (✹)
	{ 0x0490, 0x2492, 0x12a4, 0x0aa8, 0x65d3, 0x1bec, 0x07f0, 0x7fff, 0x07f0, 0x1bec, 0x65d3, 0x0aa8, 0x12a4, 0x2492, 0x0490, 0x0000 },	// U+273A (✺)
	{ 0x0080, 0x01c0, 0x01c0, 0x01c0, 0x7087, 0x388e, 0x06b0, 0x01c0, 0x06b0, 0x388e, 0x7087, 0x01c0, 0x01c0, 0x01c0, 0x0080, 0x0000 },	// U+273B (✻)
	{ 0x01c0, 0x03e0, 0x03e0, 0x31c6, 0x788f, 0x79cf, 0x1e3c, 0x0410, 0x1e3c, 0x79cf, 0x788f, 0x31c6, 0x03e0, 0x03e0, 0x01c0, 0x0000 },	// U+273C (✼)
	{ 0x01c0, 0x03e0, 0x03e0, 0x31c6, 0x79cf, 0x788f, 0x1ebc, 0x03e0, 0x1ebc, 0x788f, 0x79cf, 0x31c6, 0x03e0, 0x03e0, 0x01c0, 0x0000 },	// U+273D (✽)
	{ 0x01c0, 0x0220, 0x0220, 0x3a2e, 0x7e3f, 0x7f7f, 0x3ffe, 0x1084, 0x21c2, 0x43e1, 0x47f1, 0x3bee, 0x03e0, 0x03e0, 0x01c0, 0x0000 },	// U+273E (✾)
	{ 0x01c0, 0x03e0, 0x07f0, 0x3bee, 0x7fff, 0x7e3f, 0x780f, 0x380e, 0x0c18, 0x1f7c, 0x3ffe, 0x3f7e, 0x3f7e, 0x1e3c, 0x0000, 0x0000 },	// U+273F (✿)
	{ 0x01c0, 0x0220, 0x0490, 0x3c9e, 0x42a1, 0x59cd, 0x47f1, 0x37f6, 0x0be8, 0x13e4, 0x2492, 0x294a, 0x2142, 0x1e3c, 0x0000, 0x0000 },	// U+2740 (❀)
	{ 0x01c0, 0x1e3c, 0x22a2, 0x288a, 0x26b2, 0x37f6, 0x4361, 0x5e3d, 0x4361, 0x37f6, 0x26b2, 0x288a, 0x22a2, 0x1e3c, 0x01c0, 0x0000 },	// U+2741 (❁)
	{ 0x03e0, 0x0f78, 0x1f7c, 0x2e3a, 0x33e6, 0x7e3f, 0x7417, 0x4411, 0x7417, 0x7e3f, 0x33e6, 0x2e3a, 0x1f7c, 0x0f78, 0x03e0, 0x0000 },	// U+2742 (❂)
	{ 0x01c0, 0x0320, 0x0320, 0x3b2e, 0x673d, 0x79f9, 0x3cf2, 0x1ffc, 0x264e, 0x4e67, 0x5e73, 0x3a6e, 0x0260, 0x0260, 0x01c0, 0x0000 },	// U+2743 (❃)
	{ 0x0000, 0x0080, 0x02a0, 0x01c0, 0x6493, 0x188c, 0x26b2, 0x01c0, 0x26b2, 0x188c, 0x6493, 0x01c0, 0x02a0, 0x0080, 0x0000, 0x0000 },	// U+2744 (❄)
	{ 0x0000, 0x0080, 0x02a0, 0x05d0, 0x6493, 0x188c, 0x26b2, 0x41c1, 0x26b2, 0x188c, 0x6493, 0x05d0, 0x02a0, 0x0080, 0x0000, 0x0000 },	// U+2745 (❅)
	{ 0x0490, 0x06b0, 0x03e0, 0x09c8, 0x6493, 0x188c, 0x76b7, 0x01c0, 0x76b7, 0x188c, 0x6493, 0x0888, 0x03e0, 0x06b0, 0x0490, 0x0000 },	// U+2746 (❆)
	{ 0x0000, 0x03c0, 0x23c4, 0x13c8, 0x0990, 0x05a0, 0x700e, 0x7dbe, 0x7dbe, 0x700e, 0x05a0, 0x0990, 0x13c8, 0x23c4, 0x03c0, 0x0000 },	// U+2747 (❇)
	{ 0x03e0, 0x23e2, 0x13e4, 0x09c8, 0x05d0, 0x7007, 0x7ddf, 0x7ddf, 0x7ddf, 0x7007, 0x05d0, 0x09c8, 0x13e4, 0x23e2, 0x03e0, 0x0000 },	// U+2748 (❈)
	{ 0x01c0, 0x03e0, 0x03e0, 0x3bee, 0x7ddf, 0x7c9f, 0x3ebe, 0x03e0, 0x3ebe, 0x7c9f, 0x7ddf, 0x3bee, 0x03e0, 0x03e0, 0x01c0, 0x0000 },	// U+2749 (❉)
	{ 0x0080, 0x01c0, 0x19cc, 0x188c, 0x0490, 0x02a0, 0x31c6, 0x7fff, 0x31c6, 0x02a0, 0x0490, 0x188c, 0x19cc, 0x01c0, 0x0080, 0x0000 },	// U+274A (❊)
	{ 0x0080, 0x01c0, 0x19cc, 0x1ddc, 0x0c98, 0x03e0, 0x3bee, 0x7fff, 0x3bee, 0x03e0, 0x0c98, 0x1ddc, 0x19cc, 0x01c0, 0x0080, 0x0000 },	// U+274B (❋)
	{ 0x0000, 0x0000, 0x0c18, 0x1e3c, 0x0f78, 0x07f0, 0x03e0, 0x03e0, 0x07f0, 0x0f78, 0x1e3c, 0x1c1c, 0x0808, 0x0000, 0x0000, 0x0000 },	// U+274C (❌)
	{ 0x0000, 0x0000, 0x03c0, 0x0c30, 0x1008, 0x3008, 0x2004, 0x6004, 0x6004, 0x6004, 0x7008, 0x3008, 0x3c30, 0x1fc0, 0x0780, 0x0000 },	// U+274D (❍)
	{ 0x0000, 0x3ffe, 0x37f6, 0x23e2, 0x31c6, 0x388e, 0x3c1e, 0x3e3e, 0x3c1e, 0x388e, 0x31c6, 0x23e2, 0x37f6, 0x3ffe, 0x0000, 0x0000 },	// U+274E (❎)
	{ 0x0000, 0x1ff8, 0x1008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7ff8, 0x7fe0, 0x7fe0, 0x0000, 0x0000, 0x0000 },	// U+274F (❏)
	{ 0x0000, 0x7fe0, 0x7fe0, 0x7ff8, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x1008, 0x1ff8, 0x0000, 0x0000, 0x0000 },	// U+2750 (❐)
	{ 0x0000, 0x1ff8, 0x3008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7ff8, 0x7ff0, 0x7fe0, 0x0000, 0x0000, 0x0000 },	// U+2751 (❑)
	{ 0x0000, 0x7fe0, 0x7ff0, 0x7ff8, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x7008, 0x3008, 0x1ff8, 0x0000, 0x0000, 0x0000 },	// U+2752 (❒)
	{ 0x0000, 0x01c0, 0x07f0, 0x0e78, 0x0c18, 0x0f18, 0x0780, 0x01c0, 0x00c0, 0x00c0, 0x00c0, 0x0000, 0x00c0, 0x01e0, 0x01e0, 0x00c0 },	// U+2753 (❓)
	{ 0x03e0, 0x0410, 0x09c8, 0x0a28, 0x0a10, 0x0900, 0x0480, 0x0240, 0x0140, 0x0140, 0x01c0, 0x0000, 0x01c0, 0x0220, 0x0220, 0x01c0 },	// U+2754 (❔)
	{ 0x01c0, 0x0360, 0x0630, 0x0410, 0x0630, 0x0220, 0x0360, 0x0140, 0x0140, 0x01c0, 0x0000, 0x01c0, 0x0220, 0x0220, 0x01c0, 0x0000 },	// U+2755 (❕)
	{ 0x0000, 0x0080, 0x01c0, 0x03e0, 0x01c0, 0x0888, 0x1c1c, 0x3e3e, 0x1c1c, 0x0888, 0x01c0, 0x03e0, 0x01c0, 0x0080, 0x0000, 0x0000 },	// U+2756 (❖)
	{ 0x0180, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+2757 (❗)
	{ 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000 },	// U+2758 (❘)
	{ 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x0000 },	// U+2759 (❙)
	{ 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0ff0, 0x0000 },	// U+275A (❚)
	{ 0x0380, 0x00e0, 0x0030, 0x01f0, 0x03f0, 0x07f0, 0x07f0, 0x07f0, 0x03e0, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+275B (❛)
	{ 0x01c0, 0x03e0, 0x07f0, 0x07f0, 0x07f0, 0x07e0, 0x07c0, 0x0600, 0x0380, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+275C (❜)
	{ 0x3838, 0x0e0e, 0x0303, 0x1f1f, 0x3f3f, 0x7f7f, 0x7f7f, 0x7f7f, 0x3e3e, 0x1c1c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+275D (❝)
	{ 0x1c1c, 0x3e3e, 0x7f7f, 0x7f7f, 0x7f7f, 0x7e7e, 0x7c7c, 0x6060, 0x3838, 0x0e0e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+275E (❞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x00e0, 0x01f0, 0x03f8, 0x03f8, 0x03f8, 0x03f0, 0x03e0, 0x0300, 0x01c0, 0x0070, 0x0000, 0x0000 },	// U+275F (❟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c1c, 0x3e3e, 0x7f7f, 0x7f7f, 0x7f7f, 0x7e7e, 0x7c7c, 0x6060, 0x3838, 0x0e0e, 0x0000, 0x0000 },	// U+2760 (❠)
	{ 0x0000, 0x0800, 0x0800, 0x7ff0, 0x1ffc, 0x087e, 0x087e, 0x08fc, 0x0ff0, 0x0800, 0x0c0c, 0x041e, 0x061e, 0x038c, 0x00f8, 0x0000 },	// U+2761 (❡)
	{ 0x01c0, 0x07f0, 0x0ff8, 0x0ff8, 0x0ff8, 0x07f0, 0x01c0, 0x0080, 0x0080, 0x0000, 0x01c0, 0x03e0, 0x03e0, 0x03e0, 0x01c0, 0x0000 },	// U+2762 (❢)
	{ 0x0000, 0x0770, 0x0ff8, 0x0ff8, 0x0ff8, 0x07f0, 0x01c0, 0x0080, 0x0000, 0x01c0, 0x03e0, 0x03e0, 0x03e0, 0x01c0, 0x0000, 0x0000 },	// U+2763 (❣)
	{ 0x0000, 0x0000, 0x1e3c, 0x3f7e, 0x7fff, 0x7fff, 0x7fff, 0x3ffe, 0x3ffe, 0x1ffc, 0x0ff8, 0x07f0, 0x03e0, 0x01c0, 0x0080, 0x0000 },	// U+2764 (❤)
	{ 0x0038, 0x00fc, 0x01fe, 0x03fe, 0x07fe, 0x0ffe, 0x1ffc, 0x3ff8, 0x1ffc, 0x0ffe, 0x07fe, 0x03fe, 0x01fe, 0x00fc, 0x0038, 0x0000 },	// U+2765 (❥)
	{ 0x0000, 0x0000, 0x20f8, 0x1f84, 0x0180, 0x0e70, 0x1ff8, 0x1ff8, 0x1ff8, 0x0ff0, 0x07e0, 0x03c0, 0x0180, 0x0980, 0x0700, 0x0000 },	// U+2766 (❦)
	{ 0x0000, 0x0000, 0x0004, 0x01c8, 0x23e8, 0x47e8, 0x4fe8, 0x7fd8, 0x3fdc, 0x0fe4, 0x07e4, 0x03e4, 0x01c4, 0x0008, 0x0000, 0x0000 },	// U+2767 (❧)
}; // 133

static const uint16_t unifontdw_block222[][16] = {
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3f7e, 0x3f3e, 0x7f5f, 0x7f7f, 0x7f7f, 0x7f7f, 0x7f7f, 0x3f7e, 0x3c1e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+2776 (❶)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3e3e, 0x3dde, 0x7ddf, 0x7dff, 0x7eff, 0x7f7f, 0x7fbf, 0x3fde, 0x3c1e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+2777 (❷)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3e3e, 0x3dde, 0x7ddf, 0x7dff, 0x7e7f, 0x7dff, 0x7ddf, 0x3dde, 0x3e3e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+2778 (❸)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3efe, 0x3e7e, 0x7ebf, 0x7edf, 0x7eef, 0x7c0f, 0x7eff, 0x3efe, 0x3efe, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+2779 (❹)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3c1e, 0x3fde, 0x7fdf, 0x7fdf, 0x7e1f, 0x7dff, 0x7dff, 0x3dde, 0x3e3e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+277A (❺)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3e7e, 0x3fbe, 0x7fdf, 0x7fdf, 0x7e1f, 0x7ddf, 0x7ddf, 0x3dde, 0x3e3e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+277B (❻)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3c1e, 0x3dfe, 0x7dff, 0x7eff, 0x7eff, 0x7eff, 0x7f7f, 0x3f7e, 0x3f7e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+277C (❼)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3e3e, 0x3dde, 0x7ddf, 0x7ddf, 0x7e3f, 0x7ddf, 0x7ddf, 0x3dde, 0x3e3e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+277D (❽)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3e3e, 0x3dde, 0x7ddf, 0x7ddf, 0x7c3f, 0x7dff, 0x7dff, 0x3efe, 0x3f3e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+277E (❾)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3ffe, 0x39de, 0x76cf, 0x76d7, 0x76df, 0x76df, 0x76df, 0x3906, 0x3ffe, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+277F (❿)
	{ 0x03e0, 0x0c18, 0x1004, 0x2102, 0x2182, 0x41c1, 0x4181, 0x4181, 0x4181, 0x4181, 0x2182, 0x2182, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2780 (➀)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x27f2, 0x4631, 0x4601, 0x4381, 0x40e1, 0x4031, 0x27f2, 0x27f2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2781 (➁)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x27f2, 0x4631, 0x4601, 0x4381, 0x4601, 0x4631, 0x27f2, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2782 (➂)
	{ 0x03e0, 0x0c18, 0x1004, 0x2702, 0x2782, 0x46c1, 0x4661, 0x4631, 0x4ff9, 0x4ff9, 0x2602, 0x2602, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2783 (➃)
	{ 0x03e0, 0x0c18, 0x1004, 0x27f2, 0x27f2, 0x4031, 0x43f1, 0x47f1, 0x4601, 0x4631, 0x27f2, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2784 (➄)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x27f2, 0x4031, 0x43f1, 0x47f1, 0x4631, 0x4631, 0x27f2, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2785 (➅)
	{ 0x03e0, 0x0c18, 0x1004, 0x27f2, 0x27f2, 0x4601, 0x4601, 0x4301, 0x41c1, 0x4061, 0x2062, 0x2062, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2786 (➆)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x27f2, 0x4631, 0x4631, 0x43e1, 0x4631, 0x4631, 0x27f2, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2787 (➇)
	{ 0x03e0, 0x0c18, 0x1004, 0x23e2, 0x27f2, 0x4631, 0x4631, 0x47f1, 0x47e1, 0x4601, 0x27f2, 0x23e2, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2788 (➈)
	{ 0x03e0, 0x0c18, 0x1004, 0x2722, 0x2fb2, 0x4db9, 0x4db1, 0x4db1, 0x4db1, 0x4db1, 0x2fb2, 0x2732, 0x1004, 0x0c18, 0x03e0, 0x0000 },	// U+2789 (➉)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3efe, 0x3e7e, 0x7e3f, 0x7e7f, 0x7e7f, 0x7e7f, 0x7e7f, 0x3e7e, 0x3e7e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+278A (➊)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3c1e, 0x380e, 0x79cf, 0x79ff, 0x7c7f, 0x7f1f, 0x7fcf, 0x380e, 0x380e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+278B (➋)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3c1e, 0x380e, 0x79cf, 0x79ff, 0x7c7f, 0x79ff, 0x79cf, 0x380e, 0x3c1e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+278C (➌)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x38fe, 0x387e, 0x793f, 0x799f, 0x79cf, 0x7007, 0x7007, 0x39fe, 0x39fe, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+278D (➍)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x380e, 0x380e, 0x7fcf, 0x7c0f, 0x780f, 0x79ff, 0x79cf, 0x380e, 0x3c1e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+278E (➎)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3c1e, 0x380e, 0x7fcf, 0x7c0f, 0x780f, 0x79cf, 0x79cf, 0x380e, 0x3c1e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+278F (➏)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x380e, 0x380e, 0x79ff, 0x79ff, 0x7cff, 0x7e3f, 0x7f9f, 0x3f9e, 0x3f9e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+2790 (➐)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3c1e, 0x380e, 0x79cf, 0x79cf, 0x7c1f, 0x79cf, 0x79cf, 0x380e, 0x3c1e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+2791 (➑)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x3c1e, 0x380e, 0x79cf, 0x79cf, 0x780f, 0x781f, 0x79ff, 0x380e, 0x3c1e, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+2792 (➒)
	{ 0x03e0, 0x0ff8, 0x1ffc, 0x38de, 0x304e, 0x7247, 0x724f, 0x724f, 0x724f, 0x724f, 0x304e, 0x38ce, 0x1ffc, 0x0ff8, 0x03e0, 0x0000 },	// U+2793 (➓)
	{ 0x0000, 0x01f8, 0x03f0, 0x07e0, 0x0fc0, 0x1fff, 0x3fff, 0x7fff, 0x3fff, 0x1fff, 0x0fc0, 0x07e0, 0x03f0, 0x01f8, 0x0000, 0x0000 },	// U+2794 (➔)
	{ 0x0000, 0x0000, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x1ffc, 0x1ffc, 0x1ffc, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+2795 (➕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2796 (➖)
	{ 0x0000, 0x0000, 0x01c0, 0x01c0, 0x01c0, 0x0000, 0x3ffe, 0x3ffe, 0x3ffe, 0x0000, 0x01c0, 0x01c0, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+2797 (➗)
	{ 0x0000, 0x0000, 0x0010, 0x0038, 0x007c, 0x0078, 0x04f0, 0x04c0, 0x0700, 0x0f00, 0x0fc0, 0x0e00, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+2798 (➘)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0180, 0x0307, 0x0f3f, 0x7fff, 0x0f3f, 0x0307, 0x0180, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2799 (➙)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x0e00, 0x0fc0, 0x0f00, 0x0700, 0x04c0, 0x04f0, 0x0078, 0x007c, 0x0038, 0x0010, 0x0000, 0x0000 },	// U+279A (➚)
	{ 0x0000, 0x0000, 0x0000, 0x0040, 0x0080, 0x0380, 0x0f00, 0x7fff, 0x0f00, 0x0380, 0x0080, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+279B (➛)
	{ 0x0000, 0x0300, 0x0780, 0x0f80, 0x1f00, 0x3ffe, 0x7fff, 0x7fff, 0x7fff, 0x3ffe, 0x1f00, 0x0f80, 0x0780, 0x0300, 0x0000, 0x0000 },	// U+279C (➜)
	{ 0x0000, 0x0000, 0x0800, 0x0800, 0x1800, 0x1800, 0x3fff, 0x7fff, 0x3fff, 0x1800, 0x1800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+279D (➝)
	{ 0x0000, 0x0800, 0x0800, 0x1800, 0x1800, 0x3fff, 0x3fff, 0x7fff, 0x3fff, 0x3fff, 0x1800, 0x1800, 0x0800, 0x0800, 0x0000, 0x0000 },	// U+279E (➞)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0c00, 0x1c00, 0x3f55, 0x7f55, 0x3f55, 0x1c00, 0x0c00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+279F (➟)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0c00, 0x1f55, 0x3f55, 0x7f55, 0x3f55, 0x1f55, 0x0c00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27A0 (➠)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0c00, 0x1c00, 0x3fff, 0x7fff, 0x3fff, 0x1c00, 0x0c00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27A1 (➡)
	{ 0x0002, 0x000e, 0x0034, 0x00c4, 0x0308, 0x0c08, 0x3010, 0x7fe0, 0x3ff0, 0x0ff8, 0x03f8, 0x00fc, 0x003c, 0x000e, 0x0002, 0x0000 },	// U+27A2 (➢)
	{ 0x0002, 0x000e, 0x003c, 0x00fc, 0x03f8, 0x0ff8, 0x3ff0, 0x7fe0, 0x3010, 0x0c08, 0x0308, 0x00c4, 0x0034, 0x000e, 0x0002, 0x0000 },	// U+27A3 (➣)
	{ 0x0002, 0x000e, 0x003c, 0x00fc, 0x03f8, 0x0ff8, 0x3ff0, 0x7fe0, 0x3ff0, 0x0ff8, 0x03f8, 0x00fc, 0x003c, 0x000e, 0x0002, 0x0000 },	// U+27A4 (➤)
	{ 0x0000, 0x0000, 0x0000, 0x0001, 0x0801, 0x1803, 0x3ffe, 0x7ffe, 0x3ffc, 0x1800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27A5 (➥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1800, 0x3ffc, 0x7ffe, 0x3ffe, 0x1803, 0x0801, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27A6 (➦)
	{ 0x0000, 0x0100, 0x0100, 0x0300, 0x03e0, 0x07e0, 0x07e0, 0x0fe0, 0x07e0, 0x07e0, 0x03e0, 0x0300, 0x0100, 0x0100, 0x0000, 0x0000 },	// U+27A7 (➧)
	{ 0x0000, 0x0000, 0x0000, 0x0200, 0x0200, 0x07ff, 0x0fff, 0x7fff, 0x0fff, 0x07ff, 0x0200, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27A8 (➨)
	{ 0x0000, 0x0000, 0x0000, 0x0600, 0x0e00, 0x1bfe, 0x3002, 0x6002, 0x3002, 0x1bfe, 0x0e00, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27A9 (➩)
	{ 0x0000, 0x0000, 0x0000, 0x0600, 0x0e00, 0x17fe, 0x2006, 0x4006, 0x2006, 0x17fe, 0x0e00, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27AA (➪)
	{ 0x0000, 0x0000, 0x1000, 0x1800, 0x2400, 0x2200, 0x41fc, 0x4002, 0x6001, 0x78ff, 0x3e7f, 0x0fa0, 0x03f0, 0x00f0, 0x0030, 0x0000 },	// U+27AB (➫)
	{ 0x0000, 0x0030, 0x00f0, 0x03f0, 0x0fa0, 0x3e7f, 0x78ff, 0x6001, 0x4002, 0x41fc, 0x2200, 0x2400, 0x1800, 0x1000, 0x0000, 0x0000 },	// U+27AC (➬)
	{ 0x0000, 0x0000, 0x0100, 0x0300, 0x05ff, 0x0801, 0x1001, 0x2001, 0x7001, 0x3801, 0x1dff, 0x0ffe, 0x0700, 0x0200, 0x0000, 0x0000 },	// U+27AD (➭)
	{ 0x0000, 0x0200, 0x0700, 0x0ffe, 0x1dff, 0x3801, 0x7001, 0x2001, 0x1001, 0x0801, 0x05ff, 0x0300, 0x0100, 0x0000, 0x0000, 0x0000 },	// U+27AE (➮)
	{ 0x0000, 0x0000, 0x0200, 0x0600, 0x0a00, 0x13ff, 0x2002, 0x4002, 0xe002, 0x73ff, 0x3bfe, 0x1e00, 0x0e00, 0x0400, 0x0000, 0x0000 },	// U+27AF (➯)
}; // 58

static const uint16_t unifontdw_block223[][16] = {
	{ 0x0000, 0x0400, 0x0e00, 0x1e00, 0x3bfe, 0x73ff, 0xe002, 0x4002, 0x2002, 0x13ff, 0x0a00, 0x0600, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+27B1 (➱)
	{ 0x03e0, 0x0ff8, 0x1efc, 0x3cfe, 0x38fe, 0x7000, 0x6000, 0x4000, 0x6000, 0x7000, 0x38fe, 0x3cfe, 0x1efc, 0x0ff8, 0x03e0, 0x0000 },	// U+27B2 (➲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x007f, 0x1092, 0x3124, 0x7ff8, 0x3124, 0x1092, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27B3 (➳)
	{ 0x0000, 0x0000, 0x0020, 0x0060, 0x00e0, 0x00fc, 0x00f8, 0x10f0, 0x1100, 0x1a00, 0x1c00, 0x1e00, 0x1f80, 0x0000, 0x0000, 0x0000 },	// U+27B4 (➴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x103e, 0x307c, 0x7ff8, 0x307c, 0x103e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27B5 (➵)
	{ 0x0000, 0x0000, 0x0000, 0x1f80, 0x1e00, 0x1c00, 0x1a00, 0x1100, 0x10f0, 0x00f8, 0x00fc, 0x00e0, 0x0060, 0x0020, 0x0000, 0x0000 },	// U+27B6 (➶)
	{ 0x0000, 0x0000, 0x0040, 0x00c0, 0x01c0, 0x01c0, 0x11fc, 0x11f8, 0x1bf0, 0x1f00, 0x1e00, 0x1f00, 0x1fc0, 0x0000, 0x0000, 0x0000 },	// U+27B7 (➷)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x083f, 0x187e, 0x3ffc, 0x7ff8, 0x3ffc, 0x187e, 0x083f, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27B8 (➸)
	{ 0x0000, 0x0000, 0x0000, 0x1fc0, 0x1f00, 0x1e00, 0x1f00, 0x1bf0, 0x11f8, 0x11fc, 0x01c0, 0x01c0, 0x00c0, 0x0040, 0x0000, 0x0000 },	// U+27B9 (➹)
	{ 0x0000, 0x0000, 0x0600, 0x0f00, 0x0f00, 0x1c1e, 0x30ff, 0x7fff, 0x30ff, 0x1c1e, 0x0f00, 0x0f00, 0x0600, 0x0000, 0x0000, 0x0000 },	// U+27BA (➺)
	{ 0x0000, 0x0000, 0x0000, 0x0200, 0x0706, 0x0f1e, 0x1e3f, 0x7fff, 0x1e3f, 0x0f1e, 0x0706, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27BB (➻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x081f, 0x183e, 0x387c, 0x7ff8, 0x387c, 0x183e, 0x081f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27BC (➼)
	{ 0x0000, 0x0000, 0x0000, 0x061f, 0x0e3f, 0x1e7e, 0x3ffe, 0x7ffc, 0x3ffe, 0x1e7e, 0x0e3f, 0x061f, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27BD (➽)
	{ 0x0000, 0x0000, 0x0000, 0x0440, 0x0880, 0x1100, 0x23ff, 0x4000, 0x23ff, 0x1100, 0x0880, 0x0440, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27BE (➾)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe3c7, 0x1c38, 0x2244, 0x2244, 0x2244, 0x1c38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27BF (➿)
}; // 15

static const uint16_t unifontdw_block224[][16] = {
	{ 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0490, 0x0550, 0x0948, 0x0a28, 0x13e4, 0x1004, 0x1ffc, 0x0000, 0x0000 },	// U+27C1 (⟁)
}; // 1

static const uint16_t unifontdw_block225[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fe0, 0x0010, 0x0c08, 0x1208, 0x1208, 0x0c08, 0x0010, 0x1fe0, 0x0000, 0x0000, 0x0000 },	// U+27C3 (⟃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f8, 0x0800, 0x1030, 0x1048, 0x1048, 0x1030, 0x0800, 0x07f8, 0x0000, 0x0000, 0x0000 },	// U+27C4 (⟄)
}; // 2

static const uint16_t unifontdw_block226[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7f02, 0x0082, 0x0044, 0x0044, 0x0048, 0x0048, 0x0090, 0x7f10, 0x0000, 0x0000, 0x0000 },	// U+27C8 (⟈)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x40fe, 0x4100, 0x2200, 0x2200, 0x1200, 0x1200, 0x0900, 0x08fe, 0x0000, 0x0000, 0x0000 },	// U+27C9 (⟉)
}; // 2

static const uint16_t unifontdw_block227[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0010, 0x0000, 0x0000, 0x0000 },	// U+27CB (⟋)
	{ 0x0000, 0x0000, 0x3ffc, 0x0004, 0x0008, 0x0008, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0008, 0x0008, 0x0004, 0x0004 },	// U+27CC (⟌)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800, 0x0000, 0x0000, 0x0000 },	// U+27CD (⟍)
	{ 0x0000, 0x0000, 0x0000, 0x3ff8, 0x2008, 0x2108, 0x2108, 0x2288, 0x2288, 0x2448, 0x2448, 0x2828, 0x2828, 0x3ff8, 0x0000, 0x0000 },	// U+27CE (⟎)
	{ 0x0000, 0x0000, 0x0000, 0x3ff8, 0x2828, 0x2828, 0x2448, 0x2448, 0x2288, 0x2288, 0x2108, 0x2108, 0x2008, 0x3ff8, 0x0000, 0x0000 },	// U+27CF (⟏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0280, 0x0440, 0x0820, 0x1110, 0x0820, 0x0440, 0x0280, 0x0100, 0x0000, 0x0000 },	// U+27D0 (⟐)
}; // 6

static const uint16_t unifontdw_block228[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0490, 0x03e0, 0x0000, 0x0000 },	// U+27D2 (⟒)
}; // 1

static const uint16_t unifontdw_block229[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x201c, 0x3030, 0x2850, 0x2490, 0x2310, 0x2310, 0x2490, 0x2850, 0x3030, 0x201c, 0x0000, 0x0000 },	// U+27D5 (⟕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3804, 0x0c0c, 0x0a14, 0x0924, 0x08c4, 0x08c4, 0x0924, 0x0a14, 0x0c0c, 0x3804, 0x0000, 0x0000 },	// U+27D6 (⟖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x700e, 0x1818, 0x1428, 0x1248, 0x1188, 0x1188, 0x1248, 0x1428, 0x1818, 0x700e, 0x0000, 0x0000 },	// U+27D7 (⟗)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0ff8, 0x0000, 0x0000 },	// U+27D8 (⟘)
	{ 0x0000, 0x0000, 0x0ff8, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+27D9 (⟙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x0140, 0x3f7e, 0x0140, 0x3f7e, 0x0140, 0x0140, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27DA (⟚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x0140, 0x0140, 0x3f7e, 0x0140, 0x0140, 0x0140, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27DB (⟛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0038, 0x0044, 0x3fc4, 0x0044, 0x0038, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27DC (⟜)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0002, 0x0002, 0x7ffe, 0x0002, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000 },	// U+27DD (⟝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x4000, 0x4000, 0x7ffe, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000 },	// U+27DE (⟞)
}; // 10

static const uint16_t unifontdw_block230[][16] = {
	{ 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0410, 0x180c, 0x2002, 0x180c, 0x0410, 0x0220, 0x0140, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+27E1 (⟡)
	{ 0x0000, 0x0100, 0x0280, 0x0280, 0x0440, 0x0820, 0x3018, 0x4007, 0x3018, 0x0820, 0x0440, 0x0280, 0x0280, 0x0100, 0x0000, 0x0000 },	// U+27E2 (⟢)
	{ 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0410, 0x180c, 0xe002, 0x180c, 0x0410, 0x0220, 0x0140, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+27E3 (⟣)
	{ 0x0000, 0x7ff8, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x400f, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x7ff8, 0x0000, 0x0000 },	// U+27E4 (⟤)
	{ 0x0000, 0x1ffe, 0x1002, 0x1002, 0x1002, 0x1002, 0x1002, 0xf002, 0x1002, 0x1002, 0x1002, 0x1002, 0x1002, 0x1ffe, 0x0000, 0x0000 },	// U+27E5 (⟥)
}; // 5

static const uint16_t unifontdw_block231[][16] = {
	{ 0x0000, 0x0000, 0x0080, 0x0140, 0x0360, 0x0550, 0x0d58, 0x1554, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0000, 0x0000 },	// U+27F0 (⟰)
	{ 0x0000, 0x0000, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x1554, 0x0d58, 0x0550, 0x0360, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+27F1 (⟱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0840, 0x1020, 0x2010, 0x2054, 0x2038, 0x2010, 0x1000, 0x0840, 0x0780, 0x0000, 0x0000 },	// U+27F2 (⟲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01e0, 0x0210, 0x0408, 0x0804, 0x2a04, 0x1c04, 0x0804, 0x0008, 0x0210, 0x01e0, 0x0000, 0x0000 },	// U+27F3 (⟳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x12a0, 0x2490, 0x7fff, 0x2490, 0x12a0, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27F4 (⟴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0xfffe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27F5 (⟵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7fff, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27F6 (⟶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x7ffe, 0x2004, 0x1008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27F7 (⟷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0x7ffe, 0x0001, 0x7ffe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27F8 (⟸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x3fff, 0x4000, 0x3fff, 0x1000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27F9 (⟹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x1008, 0x3ffc, 0x4002, 0x3ffc, 0x1008, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27FA (⟺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4008, 0x4004, 0x7ffe, 0x4004, 0x4008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27FB (⟻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1002, 0x2002, 0x7ffe, 0x2002, 0x1002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27FC (⟼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4010, 0x4008, 0x7ffc, 0x4002, 0x7ffc, 0x4008, 0x4010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27FD (⟽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0802, 0x1002, 0x3ffe, 0x4002, 0x3ffe, 0x1002, 0x0802, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27FE (⟾)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2444, 0x7aab, 0x2110, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+27FF (⟿)
}; // 16

static const uint16_t unifontdw_block232[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1440, 0x2840, 0x7fff, 0x2840, 0x1440, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2900 (⤀)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14a0, 0x28a0, 0x7fff, 0x28a0, 0x14a0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2901 (⤁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0110, 0x0108, 0xfffc, 0x0102, 0xfffc, 0x0108, 0x0110, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2902 (⤂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0880, 0x1080, 0x3fff, 0x4080, 0x3fff, 0x1080, 0x0880, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2903 (⤃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0920, 0x1110, 0x3ff8, 0x4104, 0x3ff8, 0x1110, 0x0920, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2904 (⤄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1402, 0x2802, 0x7ffe, 0x2802, 0x1402, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2905 (⤅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x4008, 0x7ffc, 0x4002, 0x7ffc, 0x4008, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2906 (⤆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1002, 0x3ffe, 0x4002, 0x3ffe, 0x1002, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2907 (⤇)
}; // 8

static const uint16_t unifontdw_block233[][16] = {
	{ 0x0000, 0x0000, 0x0080, 0x01c0, 0x02a0, 0x06b0, 0x0aa8, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x0000, 0x0000 },	// U+290A (⤊)
	{ 0x0000, 0x0000, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x02a0, 0x0aa8, 0x06b0, 0x02a0, 0x01c0, 0x0080, 0x0000, 0x0000 },	// U+290B (⤋)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0xfefe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+290C (⤌)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7f7f, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+290D (⤍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0xf7be, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+290E (⤎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7def, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+290F (⤏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1402, 0x2804, 0x7ed8, 0x2804, 0x1402, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2910 (⤐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7555, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2911 (⤑)
}; // 8

static const uint16_t unifontdw_block234[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1082, 0x2084, 0x7ff8, 0x2084, 0x1082, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2914 (⤔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1142, 0x2144, 0x7ff8, 0x2144, 0x1142, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2915 (⤕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1402, 0x2804, 0x7ff8, 0x2804, 0x1402, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2916 (⤖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1482, 0x2884, 0x7ff8, 0x2884, 0x1482, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2917 (⤗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14a2, 0x28a4, 0x7ff8, 0x28a4, 0x14a2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2918 (⤘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x2000, 0x1ffe, 0x2000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2919 (⤙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0004, 0x7ff8, 0x0004, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+291A (⤚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4800, 0x2400, 0x1ffe, 0x2400, 0x4800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+291B (⤛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0024, 0x7ff8, 0x0024, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+291C (⤜)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0088, 0x005c, 0xfffe, 0x005c, 0x0088, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+291D (⤝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2200, 0x7400, 0xfffe, 0x7400, 0x2200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+291E (⤞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4088, 0x405c, 0x7ffe, 0x405c, 0x4088, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+291F (⤟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1102, 0x3a02, 0x7ffe, 0x3a02, 0x1102, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2920 (⤠)
	{ 0x0000, 0x003c, 0x000c, 0x0014, 0x0024, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x4800, 0x5000, 0x6000, 0x7800, 0x0000, 0x0000 },	// U+2921 (⤡)
	{ 0x0000, 0x7800, 0x6000, 0x5000, 0x4800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0024, 0x0014, 0x000c, 0x003c, 0x0000, 0x0000 },	// U+2922 (⤢)
	{ 0x0000, 0x003c, 0x000c, 0x0014, 0x0024, 0x0040, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x2400, 0x1800, 0x0000, 0x0000 },	// U+2923 (⤣)
	{ 0x0000, 0x1e00, 0x1800, 0x1400, 0x1200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x0004, 0x0012, 0x000c, 0x0000, 0x0000 },	// U+2924 (⤤)
	{ 0x0000, 0x000c, 0x0012, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100, 0x1200, 0x1400, 0x1800, 0x1e00, 0x0000, 0x0000 },	// U+2925 (⤥)
	{ 0x0000, 0x0c00, 0x1200, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0012, 0x000a, 0x0006, 0x001e, 0x0000, 0x0000 },	// U+2926 (⤦)
	{ 0x0000, 0x781e, 0x6006, 0x500a, 0x4812, 0x0420, 0x0240, 0x0180, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x2004, 0x0000, 0x0000 },	// U+2927 (⤧)
	{ 0x0000, 0x7800, 0x6004, 0x5008, 0x4810, 0x0420, 0x0240, 0x0180, 0x0180, 0x0240, 0x0420, 0x4810, 0x5008, 0x6004, 0x7800, 0x0000 },	// U+2928 (⤨)
	{ 0x0000, 0x2004, 0x1008, 0x0810, 0x0420, 0x0240, 0x0180, 0x0180, 0x0240, 0x0420, 0x4812, 0x500a, 0x6006, 0x781e, 0x0000, 0x0000 },	// U+2929 (⤩)
	{ 0x0000, 0x001e, 0x2006, 0x100a, 0x0812, 0x0420, 0x0240, 0x0180, 0x0180, 0x0240, 0x0420, 0x0812, 0x100a, 0x2006, 0x001e, 0x0000 },	// U+292A (⤪)
	{ 0x0000, 0x0000, 0x2004, 0x1008, 0x0810, 0x0420, 0x0200, 0x0100, 0x0080, 0x0040, 0x0420, 0x0810, 0x1008, 0x2004, 0x0000, 0x0000 },	// U+292B (⤫)
	{ 0x0000, 0x0000, 0x2004, 0x1008, 0x0810, 0x0420, 0x0040, 0x0080, 0x0100, 0x0200, 0x0420, 0x0810, 0x1008, 0x2004, 0x0000, 0x0000 },	// U+292C (⤬)
	{ 0x0000, 0x7800, 0x6004, 0x5008, 0x4810, 0x0420, 0x0040, 0x0080, 0x0100, 0x0200, 0x0420, 0x4810, 0x5008, 0x6004, 0x7800, 0x0000 },	// U+292D (⤭)
	{ 0x0000, 0x7800, 0x6004, 0x5008, 0x4810, 0x0420, 0x0200, 0x0100, 0x0080, 0x0040, 0x0420, 0x4810, 0x5008, 0x6004, 0x7800, 0x0000 },	// U+292E (⤮)
	{ 0x0000, 0x7800, 0x6004, 0x5008, 0x4810, 0x0420, 0x0040, 0x0080, 0x0100, 0x0200, 0x0420, 0x0810, 0x1008, 0x2004, 0x0000, 0x0000 },	// U+292F (⤯)
	{ 0x0000, 0x2004, 0x1008, 0x0810, 0x0420, 0x0200, 0x0100, 0x0080, 0x0040, 0x0420, 0x4810, 0x5008, 0x6004, 0x7800, 0x0000, 0x0000 },	// U+2930 (⤰)
	{ 0x0000, 0x781e, 0x6006, 0x500a, 0x4812, 0x0420, 0x0200, 0x0100, 0x0080, 0x0040, 0x0420, 0x0810, 0x1008, 0x2004, 0x0000, 0x0000 },	// U+2931 (⤱)
	{ 0x0000, 0x781e, 0x6006, 0x500a, 0x4812, 0x0420, 0x0040, 0x0080, 0x0100, 0x0200, 0x0420, 0x0810, 0x1008, 0x2004, 0x0000, 0x0000 },	// U+2932 (⤲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x103c, 0x2042, 0x7f81, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2933 (⤳)
	{ 0x0000, 0x0800, 0x1c00, 0x2a00, 0x0800, 0x0800, 0x0400, 0x03ff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2934 (⤴)
	{ 0x0000, 0x0000, 0x03ff, 0x0400, 0x0800, 0x0800, 0x0800, 0x2a00, 0x1c00, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2935 (⤵)
	{ 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1020, 0x0810, 0x07f8, 0x0010, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2936 (⤶)
	{ 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0408, 0x0810, 0x1fe0, 0x0800, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2937 (⤷)
}; // 36

static const uint16_t unifontdw_block235[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c4, 0x0c34, 0x100c, 0x203c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+293A (⤺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c04, 0x3008, 0x2c30, 0x23c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+293B (⤻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x23c0, 0x2c30, 0x3008, 0x3c04, 0x00e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+293C (⤼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03c4, 0x0c34, 0x100c, 0x223c, 0x0700, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+293D (⤽)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x2000, 0x2000, 0x203c, 0x100c, 0x0c34, 0x03c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+293E (⤾)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0008, 0x0004, 0x0004, 0x3c04, 0x3008, 0x2c30, 0x23c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+293F (⤿)
	{ 0x0000, 0x0000, 0x0100, 0x0080, 0x01c0, 0x06b0, 0x0908, 0x0808, 0x1004, 0x1004, 0x0808, 0x0808, 0x0630, 0x01c0, 0x0000, 0x0000 },	// U+2940 (⥀)
	{ 0x0000, 0x0000, 0x0040, 0x0080, 0x01c0, 0x06b0, 0x0848, 0x0808, 0x1004, 0x1004, 0x0808, 0x0808, 0x0630, 0x01c0, 0x0000, 0x0000 },	// U+2941 (⥁)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7ffe, 0x2000, 0x1000, 0x0008, 0x0004, 0x007e, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+2942 (⥂)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0x7ffe, 0x0004, 0x0008, 0x1000, 0x2000, 0x7e00, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+2943 (⥃)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7e00, 0x2000, 0x1000, 0x0008, 0x0004, 0x7ffe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+2944 (⥄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7fff, 0x2000, 0x1000, 0x0010, 0x0010, 0x007c, 0x0010, 0x0010, 0x0000 },	// U+2945 (⥅)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x0002, 0xffff, 0x0002, 0x0004, 0x0400, 0x0400, 0x1f00, 0x0400, 0x0400, 0x0000 },	// U+2946 (⥆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1088, 0x2050, 0x7fff, 0x2050, 0x1088, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2947 (⥇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0808, 0x11c4, 0x2222, 0x7fff, 0x2222, 0x11c4, 0x0808, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2948 (⥈)
}; // 15

static const uint16_t unifontdw_block236[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0x7ffe, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+294A (⥊)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7ffe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+294B (⥋)
}; // 2

static const uint16_t unifontdw_block237[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1008, 0x2004, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+294E (⥎)
}; // 1

static const uint16_t unifontdw_block238[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x2004, 0x1008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2950 (⥐)
}; // 1

static const uint16_t unifontdw_block239[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x000a, 0xfffe, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2952 (⥒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4800, 0x5000, 0x7fff, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2953 (⥓)
}; // 2

static const uint16_t unifontdw_block240[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0002, 0xfffe, 0x000a, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2956 (⥖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x4000, 0x7fff, 0x5000, 0x4800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2957 (⥗)
}; // 2

static const uint16_t unifontdw_block241[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4010, 0x4008, 0x7ffc, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+295A (⥚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0802, 0x1002, 0x3ffe, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+295B (⥛)
}; // 2

static const uint16_t unifontdw_block242[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x4000, 0x7ffc, 0x4008, 0x4010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+295E (⥞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0002, 0x3ffe, 0x1002, 0x0802, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+295F (⥟)
}; // 2

static const uint16_t unifontdw_block243[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2962 (⥢)
	{ 0x0000, 0x0000, 0x0440, 0x0c60, 0x1450, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0000, 0x0000 },	// U+2963 (⥣)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2964 (⥤)
	{ 0x0000, 0x0000, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x1450, 0x0c60, 0x0440, 0x0000, 0x0000 },	// U+2965 (⥥)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0x7ffe, 0x0000, 0x1000, 0x2000, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2966 (⥦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x0004, 0x0008, 0x0000, 0x7ffe, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2967 (⥧)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7ffe, 0x0000, 0x0008, 0x0004, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2968 (⥨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x2000, 0x1000, 0x0000, 0x7ffe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2969 (⥩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0x7ffe, 0x0000, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+296A (⥪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x0000, 0x7ffe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+296B (⥫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7ffe, 0x0000, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+296C (⥬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x0000, 0x7ffe, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+296D (⥭)
	{ 0x0000, 0x0000, 0x0440, 0x0460, 0x0450, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x1440, 0x0c40, 0x0440, 0x0000, 0x0000 },	// U+296E (⥮)
	{ 0x0000, 0x0000, 0x0440, 0x0c40, 0x1440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0440, 0x0450, 0x0460, 0x0440, 0x0000, 0x0000 },	// U+296F (⥯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x4000, 0x4000, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2970 (⥰)
	{ 0x0000, 0x0000, 0x0000, 0x01f8, 0x0000, 0x11f8, 0x2000, 0x7fff, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2971 (⥱)
	{ 0x0000, 0x0000, 0x0000, 0x001c, 0x0222, 0x11c0, 0x2000, 0x7fff, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2972 (⥲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0xfffe, 0x0004, 0x0388, 0x4440, 0x3800, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2973 (⥳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7fff, 0x2000, 0x101c, 0x0222, 0x01c0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2974 (⥴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7fff, 0x201c, 0x1222, 0x01c0, 0x001c, 0x0222, 0x01c0, 0x0000, 0x0000 },	// U+2975 (⥵)
	{ 0x0000, 0x0000, 0x1800, 0x0600, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0600, 0x1840, 0x0020, 0x1ff0, 0x0020, 0x0040, 0x0000 },	// U+2976 (⥶)
	{ 0x0000, 0x0000, 0x0000, 0x6000, 0x1800, 0x0608, 0x0184, 0x0ffe, 0x0184, 0x0608, 0x1800, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2977 (⥷)
	{ 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0c00, 0x1000, 0x0c00, 0x0300, 0x00c0, 0x0430, 0x0800, 0x1ff0, 0x0800, 0x0400, 0x0000 },	// U+2978 (⥸)
	{ 0x0000, 0x0000, 0x1fc0, 0x0020, 0x0010, 0x0010, 0x0010, 0x0020, 0x1fc0, 0x0000, 0x0400, 0x0800, 0x1ff0, 0x0800, 0x0400, 0x0000 },	// U+2979 (⥹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7f80, 0x0048, 0x0024, 0x7ffe, 0x0024, 0x0048, 0x7f80, 0x0000, 0x0000, 0x0000 },	// U+297A (⥺)
	{ 0x0000, 0x0000, 0x07f0, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x07f0, 0x0000, 0x0040, 0x0020, 0x1ff0, 0x0020, 0x0040, 0x0000 },	// U+297B (⥻)
}; // 26

static const uint16_t unifontdw_block244[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0948, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000 },	// U+297E (⥾)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0948, 0x0630, 0x0000, 0x0000 },	// U+297F (⥿)
}; // 2

static const uint16_t unifontdw_block245[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0200, 0x3100, 0x0f00, 0x0180, 0x00c0, 0x00b0, 0x0088, 0x00b0, 0x00c0, 0x0180, 0x0f00, 0x3100, 0x0200 },	// U+2993 (⦓)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0118, 0x01e0, 0x0300, 0x0600, 0x1a00, 0x2200, 0x1a00, 0x0600, 0x0300, 0x01e0, 0x0118, 0x0080 },	// U+2994 (⦔)
	{ 0x0000, 0x0000, 0x0000, 0x0500, 0x0298, 0x02e0, 0x01c0, 0x0740, 0x1940, 0x2140, 0x1940, 0x0640, 0x0380, 0x02e0, 0x0518, 0x0000 },	// U+2995 (⦕)
	{ 0x0000, 0x0000, 0x0000, 0x0140, 0x3280, 0x0e80, 0x0700, 0x05c0, 0x0530, 0x0508, 0x0530, 0x04c0, 0x0380, 0x0e80, 0x3140, 0x0000 },	// U+2996 (⦖)
}; // 4

static const uint16_t unifontdw_block246[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0200, 0x3900, 0x0480, 0x1840, 0x2020, 0x1c10, 0x0008, 0x7ffc, 0x0000, 0x0000 },	// U+299E (⦞)
}; // 1

static const uint16_t unifontdw_block247[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x1e00, 0x1800, 0x1480, 0x1300, 0x0300, 0x0480, 0x0440, 0x0820, 0x0810, 0x0808, 0x7ffc, 0x0800, 0x0000 },	// U+29A8 (⦨)
	{ 0x0000, 0x0000, 0x0000, 0x00f0, 0x0030, 0x0250, 0x0190, 0x0180, 0x0240, 0x0440, 0x0820, 0x1020, 0x2020, 0x7ffc, 0x0020, 0x0000 },	// U+29A9 (⦩)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x7ffc, 0x0808, 0x0810, 0x0820, 0x0440, 0x0480, 0x0300, 0x1300, 0x1480, 0x1800, 0x1e00, 0x0000 },	// U+29AA (⦪)
	{ 0x0000, 0x0000, 0x0000, 0x0020, 0x7ffc, 0x2020, 0x1020, 0x0820, 0x0440, 0x0240, 0x0180, 0x0190, 0x0250, 0x0030, 0x00f0, 0x0000 },	// U+29AB (⦫)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x3c08, 0x307c, 0x2988, 0x2608, 0x0608, 0x0908, 0x0088, 0x0048, 0x0028, 0x0018, 0x0008 },	// U+29AC (⦬)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x103c, 0x3e0c, 0x1194, 0x1064, 0x1060, 0x1090, 0x1100, 0x1200, 0x1400, 0x1800, 0x1000 },	// U+29AD (⦭)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x0018, 0x0028, 0x0048, 0x0088, 0x0908, 0x0608, 0x2608, 0x2988, 0x307c, 0x3c08, 0x0008, 0x0008 },	// U+29AE (⦮)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x1800, 0x1400, 0x1200, 0x1100, 0x1090, 0x1060, 0x1064, 0x1194, 0x3e0c, 0x103c, 0x1000, 0x1000 },	// U+29AF (⦯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e8, 0x0410, 0x0828, 0x0848, 0x0888, 0x0908, 0x0a08, 0x0410, 0x0be0, 0x0000, 0x0000 },	// U+29B0 (⦰)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x0000, 0x0be0, 0x0410, 0x0a08, 0x0908, 0x0888, 0x0848, 0x0828, 0x0410, 0x03e8, 0x0000, 0x0000 },	// U+29B1 (⦱)
	{ 0x0000, 0x0080, 0x0140, 0x0080, 0x0000, 0x0be0, 0x0410, 0x0a08, 0x0908, 0x0888, 0x0848, 0x0828, 0x0410, 0x03e8, 0x0000, 0x0000 },	// U+29B2 (⦲)
	{ 0x0080, 0x0100, 0x03f0, 0x0100, 0x0080, 0x0be0, 0x0410, 0x0a08, 0x0908, 0x0888, 0x0848, 0x0828, 0x0410, 0x03e8, 0x0000, 0x0000 },	// U+29B3 (⦳)
	{ 0x0040, 0x0020, 0x03f0, 0x0020, 0x0040, 0x0be0, 0x0410, 0x0a08, 0x0908, 0x0888, 0x0848, 0x0828, 0x0410, 0x03e8, 0x0000, 0x0000 },	// U+29B4 (⦴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0808, 0x0808, 0x1ffc, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+29B5 (⦵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0490, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0490, 0x03e0, 0x0000, 0x0000 },	// U+29B6 (⦶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0948, 0x0948, 0x0948, 0x0948, 0x0948, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+29B7 (⦷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0828, 0x0848, 0x0888, 0x0908, 0x0a08, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+29B8 (⦸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0888, 0x0888, 0x0888, 0x0888, 0x0be8, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+29B9 (⦹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0490, 0x0888, 0x0888, 0x0ff8, 0x0808, 0x0808, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+29BA (⦺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0be8, 0x0410, 0x0a28, 0x0948, 0x0888, 0x0948, 0x0a28, 0x0410, 0x0be8, 0x0000, 0x0000 },	// U+29BB (⦻)
	{ 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1010, 0x2448, 0x2208, 0x2108, 0x2088, 0x2448, 0x1010, 0x0820, 0x07c0, 0x0000, 0x0000 },	// U+29BC (⦼)
	{ 0x0000, 0x0080, 0x01c0, 0x02a0, 0x0080, 0x03e0, 0x0490, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0490, 0x03e0, 0x0080, 0x0000 },	// U+29BD (⦽)
	{ 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1390, 0x2448, 0x2828, 0x2828, 0x2828, 0x2448, 0x1390, 0x0820, 0x07c0, 0x0000, 0x0000 },	// U+29BE (⦾)
	{ 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1390, 0x27c8, 0x2fe8, 0x2fe8, 0x2fe8, 0x27c8, 0x1390, 0x0820, 0x07c0, 0x0000, 0x0000 },	// U+29BF (⦿)
	{ 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1010, 0x2308, 0x20c8, 0x2028, 0x20c8, 0x2308, 0x1010, 0x0820, 0x07c0, 0x0000, 0x0000 },	// U+29C0 (⧀)
	{ 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1010, 0x2188, 0x2608, 0x2808, 0x2608, 0x2188, 0x1010, 0x0820, 0x07c0, 0x0000, 0x0000 },	// U+29C1 (⧁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f8, 0x0104, 0x0202, 0x1202, 0x2a02, 0x1202, 0x0202, 0x0104, 0x00f8, 0x0000, 0x0000 },	// U+29C2 (⧂)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01f0, 0x0208, 0x0404, 0x3c04, 0x0404, 0x3c04, 0x0404, 0x0208, 0x01f0, 0x0000, 0x0000 },	// U+29C3 (⧃)
	{ 0x0000, 0x0000, 0x0000, 0x3ff8, 0x3008, 0x2808, 0x2408, 0x2208, 0x2108, 0x2088, 0x2048, 0x2028, 0x2018, 0x3ff8, 0x0000, 0x0000 },	// U+29C4 (⧄)
	{ 0x0000, 0x0000, 0x0000, 0x3ff8, 0x2018, 0x2028, 0x2048, 0x2088, 0x2108, 0x2208, 0x2408, 0x2808, 0x3008, 0x3ff8, 0x0000, 0x0000 },	// U+29C5 (⧅)
	{ 0x0000, 0x0000, 0x0000, 0x3ff8, 0x2008, 0x2108, 0x2928, 0x2548, 0x2388, 0x2548, 0x2928, 0x2108, 0x2008, 0x3ff8, 0x0000, 0x0000 },	// U+29C6 (⧆)
	{ 0x0000, 0x0000, 0x0000, 0x3ff8, 0x2008, 0x2008, 0x2388, 0x2448, 0x2448, 0x2448, 0x2388, 0x2008, 0x2008, 0x3ff8, 0x0000, 0x0000 },	// U+29C7 (⧇)
	{ 0x0000, 0x0000, 0x0000, 0x3ff8, 0x2008, 0x2008, 0x27c8, 0x2448, 0x2448, 0x2448, 0x27c8, 0x2008, 0x2008, 0x3ff8, 0x0000, 0x0000 },	// U+29C8 (⧈)
	{ 0x0000, 0x0000, 0x03fc, 0x0204, 0x0204, 0x0204, 0x3fc4, 0x2244, 0x2244, 0x23fc, 0x2040, 0x2040, 0x2040, 0x3fc0, 0x0000, 0x0000 },	// U+29C9 (⧉)
	{ 0x0000, 0x0080, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0410, 0x0808, 0x0808, 0x1004, 0x1004, 0x3ffe, 0x0000 },	// U+29CA (⧊)
	{ 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0410, 0x0808, 0x0808, 0x1004, 0x1004, 0x3ffe, 0x0000, 0x3ffe },	// U+29CB (⧋)
	{ 0x0000, 0x0100, 0x0280, 0x0280, 0x0440, 0x0440, 0x0820, 0x0820, 0x1390, 0x1050, 0x2188, 0x2208, 0x41c4, 0x4004, 0xfffe, 0x0000 },	// U+29CC (⧌)
	{ 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0410, 0x0808, 0x0808, 0x1004, 0x1004, 0x7fff, 0x0000, 0x0000 },	// U+29CD (⧍)
	{ 0x0018, 0x0068, 0x0188, 0x0608, 0x0808, 0x0608, 0x0188, 0x0c68, 0x0b18, 0x08c0, 0x0830, 0x0808, 0x0830, 0x08c0, 0x0b00, 0x0c00 },	// U+29CE (⧎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1600, 0x1580, 0x1460, 0x1418, 0x1404, 0x1418, 0x1460, 0x1580, 0x1600, 0x0000, 0x0000 },	// U+29CF (⧏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0034, 0x00d4, 0x0314, 0x0c14, 0x1014, 0x0c14, 0x0314, 0x00d4, 0x0034, 0x0000, 0x0000 },	// U+29D0 (⧐)
}; // 41

static const uint16_t unifontdw_block248[][16] = {
	{ 0x0000, 0x0000, 0x0220, 0x0440, 0x0880, 0x0440, 0x0220, 0x0440, 0x0880, 0x0440, 0x0220, 0x0440, 0x0880, 0x0440, 0x0220, 0x0000 },	// U+29DA (⧚)
	{ 0x0000, 0x0000, 0x0880, 0x0440, 0x0220, 0x0440, 0x0880, 0x0440, 0x0220, 0x0440, 0x0880, 0x0440, 0x0220, 0x0440, 0x0880, 0x0000 },	// U+29DB (⧛)
}; // 2

static const uint16_t unifontdw_block249[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x300c, 0x4812, 0x4ff2, 0x4812, 0x300c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+29DF (⧟)
	{ 0x0000, 0x0000, 0x1ffc, 0x3ffc, 0x200c, 0x200c, 0x200c, 0x200c, 0x200c, 0x200c, 0x200c, 0x200c, 0x200c, 0x3ffc, 0x0000, 0x0000 },	// U+29E0 (⧠)
}; // 2

static const uint16_t unifontdw_block250[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1ffc, 0x0000, 0x0000 },	// U+29E2 (⧢)
	{ 0x0000, 0x0000, 0x0000, 0x4800, 0x2400, 0x1200, 0x0900, 0x7ffe, 0x0240, 0x7ffe, 0x0090, 0x0048, 0x0024, 0x0012, 0x0000, 0x0000 },	// U+29E3 (⧣)
	{ 0x0000, 0x0000, 0x0260, 0x4990, 0x2400, 0x1200, 0x0900, 0x7ffe, 0x0240, 0x7ffe, 0x0090, 0x0048, 0x0024, 0x0012, 0x0000, 0x0000 },	// U+29E4 (⧤)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4800, 0x2400, 0x1200, 0x7ffe, 0x0480, 0x7ffe, 0x0120, 0x7ffe, 0x0048, 0x0024, 0x0012, 0x0000 },	// U+29E5 (⧥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x4002, 0x4002, 0x7ffe, 0x4002, 0x4002, 0x7ffe, 0x4002, 0x4002, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+29E6 (⧦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0ff8, 0x0080, 0x0080, 0x0ff8, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+29E7 (⧧)
	{ 0x0000, 0x0000, 0x0000, 0x3ffe, 0x10fc, 0x10fc, 0x08f8, 0x08f8, 0x04f0, 0x04f0, 0x02e0, 0x02e0, 0x01c0, 0x01c0, 0x0080, 0x0000 },	// U+29E8 (⧨)
	{ 0x0000, 0x0000, 0x0000, 0x3ffe, 0x1f84, 0x1f84, 0x0f88, 0x0f88, 0x0790, 0x0790, 0x03a0, 0x03a0, 0x01c0, 0x01c0, 0x0080, 0x0000 },	// U+29E9 (⧩)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x07f0, 0x0ff8, 0x07f0, 0x03e0, 0x01c0, 0x0080, 0x02a0, 0x01c0, 0x0080, 0x0000 },	// U+29EA (⧪)
}; // 9

static const uint16_t unifontdw_block251[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0440, 0x0820, 0x0820, 0x0820, 0x0440, 0x0380, 0x0100, 0x0540, 0x0380, 0x0100, 0x0000 },	// U+29EC (⧬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x07c0, 0x0fe0, 0x0fe0, 0x0fe0, 0x07c0, 0x0380, 0x0100, 0x0540, 0x0380, 0x0100, 0x0000 },	// U+29ED (⧭)
}; // 2

static const uint16_t unifontdw_block252[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1002, 0x2000, 0x7ff8, 0x2000, 0x1002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+29F4 (⧴)
}; // 1

static const uint16_t unifontdw_block253[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x03e0, 0x01c0, 0x3086, 0x3c9e, 0x3ffe, 0x3c9e, 0x3086, 0x01c0, 0x01c0, 0x03e0, 0x03e0, 0x0000 },	// U+29FE (⧾)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3006, 0x3c1e, 0x3ffe, 0x3c1e, 0x3006, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+29FF (⧿)
	{ 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1010, 0x2008, 0x2008, 0x2108, 0x2008, 0x2008, 0x1010, 0x0820, 0x07c0, 0x0000, 0x0000 },	// U+2A00 (⨀)
	{ 0x0000, 0x0000, 0x0000, 0x07c0, 0x0920, 0x1110, 0x2108, 0x2108, 0x3ff8, 0x2108, 0x2108, 0x1110, 0x0920, 0x07c0, 0x0000, 0x0000 },	// U+2A01 (⨁)
	{ 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1830, 0x2448, 0x2288, 0x2108, 0x2288, 0x2448, 0x1830, 0x0820, 0x07c0, 0x0000, 0x0000 },	// U+2A02 (⨂)
	{ 0x0000, 0x0000, 0x0000, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x04c8, 0x04c8, 0x0408, 0x0408, 0x0210, 0x01e0, 0x0000, 0x0000 },	// U+2A03 (⨃)
	{ 0x0000, 0x0000, 0x0000, 0x0808, 0x0808, 0x0808, 0x0808, 0x0888, 0x0888, 0x0be8, 0x0888, 0x0888, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+2A04 (⨄)
	{ 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0000, 0x0000 },	// U+2A05 (⨅)
	{ 0x0000, 0x0000, 0x0000, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0ff8, 0x0000, 0x0000 },	// U+2A06 (⨆)
	{ 0x0000, 0x0000, 0x0000, 0x0240, 0x05a0, 0x05a0, 0x0990, 0x0990, 0x1248, 0x1248, 0x2424, 0x2424, 0x4812, 0x4812, 0x0000, 0x0000 },	// U+2A07 (⨇)
	{ 0x0000, 0x0000, 0x0000, 0x4812, 0x4812, 0x2424, 0x2424, 0x1248, 0x1248, 0x0990, 0x0990, 0x05a0, 0x05a0, 0x0240, 0x0000, 0x0000 },	// U+2A08 (⨈)
	{ 0x0000, 0x0000, 0x0000, 0x1004, 0x0808, 0x0410, 0x0220, 0x0140, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x1004, 0x0000, 0x0000 },	// U+2A09 (⨉)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0808, 0x00d0, 0x0120, 0x0250, 0x0250, 0x0120, 0x00d0, 0x0808, 0x0ff8, 0x0000, 0x0000 },	// U+2A0A (⨊)
}; // 13

static const uint16_t unifontdw_block254[][16] = {
	{ 0x0000, 0x2490, 0x5b68, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x16da, 0x0924, 0x0000 },	// U+2A0C (⨌)
}; // 1

static const uint16_t unifontdw_block255[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1008, 0x1818, 0x1428, 0x1248, 0x1188, 0x1188, 0x1248, 0x1428, 0x1818, 0x1008, 0x0000, 0x0000 },	// U+2A1D (⨝)
}; // 1

static const uint16_t unifontdw_block256[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0088, 0x0110, 0x0220, 0x0440, 0x0880, 0x1100, 0x0880, 0x0440, 0x0220, 0x0110, 0x0088, 0x0000, 0x0000 },	// U+2A20 (⨠)
}; // 1

static const uint16_t unifontdw_block257[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0060, 0x0110, 0x0110, 0x0108, 0x0fe8, 0x0108, 0x0110, 0x0110, 0x0060, 0x0180, 0x0000 },	// U+2A2D (⨭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0600, 0x0880, 0x0880, 0x1080, 0x17f0, 0x1080, 0x0880, 0x0880, 0x0600, 0x0180, 0x0000 },	// U+2A2E (⨮)
}; // 2

static const uint16_t unifontdw_block258[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0440, 0x0280, 0x1110, 0x0aa0, 0x0440, 0x0aa0, 0x1110, 0x0280, 0x0440, 0x0000, 0x0000 },	// U+2A33 (⨳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0060, 0x0010, 0x0850, 0x0488, 0x0308, 0x0488, 0x0850, 0x0010, 0x0060, 0x0180, 0x0000 },	// U+2A34 (⨴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0600, 0x0800, 0x0a10, 0x1120, 0x10c0, 0x1120, 0x0a10, 0x0800, 0x0600, 0x0180, 0x0000 },	// U+2A35 (⨵)
	{ 0x0000, 0x0180, 0x0240, 0x0000, 0x03c0, 0x0c30, 0x1008, 0x1428, 0x2244, 0x2184, 0x2244, 0x1428, 0x1008, 0x0c30, 0x03c0, 0x0000 },	// U+2A36 (⨶)
	{ 0x0000, 0x07e0, 0x1818, 0x23c4, 0x4c32, 0x500a, 0x9429, 0xa245, 0xa185, 0xa245, 0x9429, 0x500a, 0x4c32, 0x23c4, 0x1818, 0x07e0 },	// U+2A37 (⨷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0820, 0x1110, 0x1010, 0x17d0, 0x1010, 0x1110, 0x0820, 0x07c0, 0x0000, 0x0000 },	// U+2A38 (⨸)
	{ 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0490, 0x0888, 0x0be8, 0x1084, 0x1084, 0x2002, 0x3ffe, 0x0000, 0x0000 },	// U+2A39 (⨹)
	{ 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0410, 0x0808, 0x0be8, 0x1004, 0x1004, 0x2002, 0x3ffe, 0x0000, 0x0000 },	// U+2A3A (⨺)
	{ 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0630, 0x0948, 0x0888, 0x1144, 0x1224, 0x2002, 0x3ffe, 0x0000, 0x0000 },	// U+2A3B (⨻)
}; // 9

static const uint16_t unifontdw_block259[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0808, 0x0be8, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0000, 0x0000 },	// U+2A4E (⩎)
	{ 0x0000, 0x0000, 0x0000, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0be8, 0x0808, 0x0ff8, 0x0000, 0x0000 },	// U+2A4F (⩏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffc, 0x2008, 0x2008, 0x2288, 0x2108, 0x2aa8, 0x2448, 0x2aa8, 0x3108, 0x1290, 0x0fe0, 0x0000 },	// U+2A50 (⩐)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0410, 0x0808, 0x0808, 0x0000, 0x0000 },	// U+2A51 (⩑)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0000, 0x0808, 0x0808, 0x0410, 0x0410, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+2A52 (⩒)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0490, 0x0948, 0x0948, 0x1224, 0x1224, 0x0000, 0x0000 },	// U+2A53 (⩓)
	{ 0x0000, 0x0000, 0x0000, 0x1224, 0x1224, 0x0948, 0x0948, 0x0490, 0x0410, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+2A54 (⩔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x05a0, 0x05a0, 0x0990, 0x0990, 0x1248, 0x1248, 0x2424, 0x2424, 0x0000, 0x0000 },	// U+2A55 (⩕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2424, 0x2424, 0x1248, 0x1248, 0x0990, 0x0990, 0x05a0, 0x05a0, 0x0240, 0x0000, 0x0000 },	// U+2A56 (⩖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1008, 0x0808, 0x0408, 0x0208, 0x0108, 0x0088, 0x0048, 0x0028, 0x0018, 0x0008, 0x0000, 0x0000 },	// U+2A57 (⩗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x3000, 0x2800, 0x2400, 0x2200, 0x2100, 0x2080, 0x2040, 0x2020, 0x2010, 0x0000, 0x0000 },	// U+2A58 (⩘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2002, 0x1004, 0x0888, 0x0550, 0x0220, 0x0550, 0x0888, 0x1004, 0x2002, 0x0000, 0x0000 },	// U+2A59 (⩙)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x01c0, 0x02a0, 0x02a0, 0x0490, 0x0490, 0x0888, 0x0888, 0x1084, 0x1084, 0x0000, 0x0000 },	// U+2A5A (⩚)
	{ 0x0000, 0x0000, 0x0000, 0x1084, 0x1084, 0x0888, 0x0888, 0x0490, 0x0490, 0x02a0, 0x02a0, 0x01c0, 0x01c0, 0x0080, 0x0000, 0x0000 },	// U+2A5B (⩛)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x1ffc, 0x0410, 0x0808, 0x0808, 0x1004, 0x1004, 0x0000, 0x0000 },	// U+2A5C (⩜)
	{ 0x0000, 0x0000, 0x0000, 0x1004, 0x1004, 0x0808, 0x0808, 0x0410, 0x1ffc, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080, 0x0000, 0x0000 },	// U+2A5D (⩝)
	{ 0x0000, 0x0ff8, 0x0000, 0x0ff8, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0410, 0x0808, 0x0808, 0x0000, 0x0000 },	// U+2A5E (⩞)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0410, 0x0808, 0x0808, 0x0000, 0x0ff8, 0x0000, 0x0000 },	// U+2A5F (⩟)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0410, 0x0808, 0x0808, 0x0000, 0x0ff8, 0x0000, 0x0ff8 },	// U+2A60 (⩠)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0220, 0x0140, 0x0080, 0x0000, 0x0ff8, 0x0000, 0x0000 },	// U+2A61 (⩡)
	{ 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0000, 0x0ff8, 0x0000, 0x0808, 0x0808, 0x0410, 0x0410, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080 },	// U+2A62 (⩢)
	{ 0x0000, 0x0000, 0x0000, 0x0808, 0x0808, 0x0410, 0x0410, 0x0220, 0x0220, 0x0140, 0x0140, 0x0080, 0x0000, 0x0ff8, 0x0000, 0x0ff8 },	// U+2A63 (⩣)
	{ 0x0000, 0x0000, 0x0000, 0x1800, 0x1600, 0x1180, 0x1060, 0x1018, 0x1ffc, 0x1018, 0x1060, 0x1180, 0x1600, 0x1800, 0x0000, 0x0000 },	// U+2A64 (⩤)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x0034, 0x00c4, 0x0304, 0x0c04, 0x1ffc, 0x0c04, 0x0304, 0x00c4, 0x0034, 0x000c, 0x0000, 0x0000 },	// U+2A65 (⩥)
}; // 24

static const uint16_t unifontdw_block260[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x0140, 0x1ffc, 0x0140, 0x1ffc, 0x0140, 0x1ffc, 0x0140, 0x0000, 0x0000, 0x0000 },	// U+2A68 (⩨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02a0, 0x02a0, 0x1ffc, 0x02a0, 0x1ffc, 0x02a0, 0x1ffc, 0x02a0, 0x0000, 0x0000, 0x0000 },	// U+2A69 (⩩)
}; // 2

static const uint16_t unifontdw_block261[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fd4, 0x0000, 0x0000, 0x1fd4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2A74 (⩴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7e7e, 0x0000, 0x0000, 0x0000, 0x7e7e, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2A75 (⩵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7bde, 0x0000, 0x0000, 0x7bde, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2A76 (⩶)
}; // 3

static const uint16_t unifontdw_block262[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1248, 0x0000, 0x3ffc, 0x0000, 0x3ffc, 0x0000, 0x3ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2A78 (⩸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x0300, 0x00c0, 0x0230, 0x0508, 0x0230, 0x00c0, 0x0300, 0x0c00, 0x0000, 0x0000, 0x0000 },	// U+2A79 (⩹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0060, 0x0180, 0x0620, 0x0850, 0x0620, 0x0180, 0x0060, 0x0018, 0x0000, 0x0000, 0x0000 },	// U+2A7A (⩺)
	{ 0x0018, 0x0024, 0x0010, 0x0010, 0x0c00, 0x0310, 0x00c0, 0x0030, 0x0008, 0x0030, 0x00c0, 0x0300, 0x0c00, 0x0000, 0x0000, 0x0000 },	// U+2A7B (⩻)
	{ 0x0c00, 0x1200, 0x0800, 0x0800, 0x0018, 0x0860, 0x0180, 0x0600, 0x0800, 0x0600, 0x0180, 0x0060, 0x0018, 0x0000, 0x0000, 0x0000 },	// U+2A7C (⩼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0610, 0x0060, 0x0180, 0x0600, 0x0000 },	// U+2A7D (⩽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0430, 0x0300, 0x00c0, 0x0030, 0x0000 },	// U+2A7E (⩾)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0180, 0x0060, 0x0210, 0x0060, 0x0180, 0x0610, 0x0060, 0x0180, 0x0600, 0x0000 },	// U+2A7F (⩿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0410, 0x0300, 0x00c0, 0x0430, 0x0300, 0x00c0, 0x0030, 0x0000 },	// U+2A80 (⪀)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0600, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0610, 0x0060, 0x0180, 0x0600, 0x0000 },	// U+2A81 (⪁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0430, 0x0300, 0x00c0, 0x0030, 0x0000 },	// U+2A82 (⪂)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0000, 0x0600, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0610, 0x0060, 0x0180, 0x0600, 0x0000 },	// U+2A83 (⪃)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0430, 0x0300, 0x00c0, 0x0030, 0x0000 },	// U+2A84 (⪄)
	{ 0x0000, 0x0000, 0x0000, 0x0600, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0600, 0x0000, 0x0000, 0x08e0, 0x0710, 0x08e0, 0x0710 },	// U+2A85 (⪅)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0030, 0x0000, 0x0000, 0x0470, 0x0388, 0x0470, 0x0388 },	// U+2A86 (⪆)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0600, 0x0200, 0x0100, 0x07f0, 0x0040, 0x0020 },	// U+2A87 (⪇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0030, 0x0200, 0x0100, 0x07f0, 0x0040, 0x0020 },	// U+2A88 (⪈)
	{ 0x0000, 0x0600, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0600, 0x0800, 0x0400, 0x0ae0, 0x0710, 0x08e0, 0x0750, 0x0020, 0x0010 },	// U+2A89 (⪉)
	{ 0x0000, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0030, 0x0400, 0x0200, 0x0570, 0x0388, 0x0470, 0x03a8, 0x0010, 0x0008 },	// U+2A8A (⪊)
}; // 19

static const uint16_t unifontdw_block263[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0600, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0600, 0x0000, 0x0000, 0x08e0, 0x0710, 0x0000, 0x0ff0 },	// U+2A8D (⪍)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0030, 0x0000, 0x0000, 0x0470, 0x0388, 0x0000, 0x07f8 },	// U+2A8E (⪎)
}; // 2

static const uint16_t unifontdw_block264[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0180, 0x0060, 0x0610, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0600, 0x0000 },	// U+2A95 (⪕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0430, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0030, 0x0000 },	// U+2A96 (⪖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0180, 0x0060, 0x0610, 0x0180, 0x0060, 0x0210, 0x0060, 0x0180, 0x0600, 0x0000 },	// U+2A97 (⪗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0430, 0x00c0, 0x0300, 0x0420, 0x0300, 0x00c0, 0x0030, 0x0000 },	// U+2A98 (⪘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0000, 0x07f0, 0x0000, 0x0600, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0600, 0x0000 },	// U+2A99 (⪙)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x0000, 0x07f0, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0030, 0x0000 },	// U+2A9A (⪚)
	{ 0x0000, 0x0000, 0x0600, 0x0180, 0x0060, 0x0610, 0x0180, 0x0060, 0x0610, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0600, 0x0000 },	// U+2A9B (⪛)
	{ 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0430, 0x00c0, 0x0300, 0x0430, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0030, 0x0000 },	// U+2A9C (⪜)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08e0, 0x0710, 0x0000, 0x0c00, 0x0300, 0x00c0, 0x0020, 0x00c0, 0x0300, 0x0c00, 0x0000 },	// U+2A9D (⪝)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x08e0, 0x0710, 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0030, 0x0000 },	// U+2A9E (⪞)
	{ 0x0000, 0x0000, 0x08e0, 0x0710, 0x0000, 0x0c00, 0x0300, 0x00c0, 0x0020, 0x00c0, 0x0300, 0x0c00, 0x0000, 0x0ff0, 0x0000, 0x0ff0 },	// U+2A9F (⪟)
	{ 0x0000, 0x0000, 0x0710, 0x08e0, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0030, 0x0000, 0x0ff0, 0x0000, 0x0ff0 },	// U+2AA0 (⪠)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x0300, 0x0cc0, 0x0330, 0x0088, 0x0330, 0x0cc0, 0x0300, 0x0c00, 0x0000, 0x0000 },	// U+2AA1 (⪡)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0060, 0x0198, 0x0660, 0x0880, 0x0660, 0x0198, 0x0060, 0x0018, 0x0000, 0x0000 },	// U+2AA2 (⪢)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3180, 0x0c60, 0x0318, 0x0084, 0x0318, 0x0c60, 0x3180, 0x0000, 0x3ffc, 0x0000, 0x0000, 0x0000 },	// U+2AA3 (⪣)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3060, 0x0d80, 0x0700, 0x0880, 0x0700, 0x0d80, 0x3060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2AA4 (⪤)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2002, 0x180c, 0x0630, 0x0140, 0x0630, 0x180c, 0x2002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2AA5 (⪥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x04c0, 0x0830, 0x0808, 0x0830, 0x04c0, 0x0300, 0x0000, 0x0000 },	// U+2AA6 (⪦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0190, 0x0608, 0x0808, 0x0608, 0x0190, 0x0060, 0x0000, 0x0000 },	// U+2AA7 (⪧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0300, 0x04c0, 0x0830, 0x0808, 0x0830, 0x04c0, 0x0308, 0x0030, 0x00c0, 0x0300, 0x0000 },	// U+2AA8 (⪨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0190, 0x0608, 0x0808, 0x0608, 0x0190, 0x0860, 0x0600, 0x0180, 0x0060, 0x0000 },	// U+2AA9 (⪩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c00, 0x0300, 0x00c0, 0x0030, 0x0ff8, 0x0030, 0x00c0, 0x0300, 0x0c00, 0x0000, 0x0000 },	// U+2AAA (⪪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0060, 0x0180, 0x0600, 0x0ff8, 0x0600, 0x0180, 0x0060, 0x0018, 0x0000, 0x0000 },	// U+2AAB (⪫)
	{ 0x0000, 0x0000, 0x0000, 0x0c00, 0x0300, 0x00c0, 0x0030, 0x0ff8, 0x0030, 0x00c0, 0x0300, 0x0c00, 0x0000, 0x0ff8, 0x0000, 0x0000 },	// U+2AAC (⪬)
	{ 0x0000, 0x0000, 0x0000, 0x0018, 0x0060, 0x0180, 0x0600, 0x0ff8, 0x0600, 0x0180, 0x0060, 0x0018, 0x0000, 0x0ff8, 0x0000, 0x0000 },	// U+2AAD (⪭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x1e3c, 0x0000, 0x1ffc, 0x0000, 0x1ffc, 0x0000, 0x0000, 0x0000 },	// U+2AAE (⪮)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0300, 0x00c0, 0x0038, 0x00c0, 0x0300, 0x0400, 0x0800, 0x0000, 0x0ff8, 0x0000, 0x0000 },	// U+2AAF (⪯)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0020, 0x00c0, 0x0300, 0x1c00, 0x0300, 0x00c0, 0x0020, 0x0010, 0x0000, 0x1ff0, 0x0000, 0x0000 },	// U+2AB0 (⪰)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x0400, 0x0300, 0x00c0, 0x0038, 0x00c0, 0x0300, 0x0400, 0x0a00, 0x0100, 0x0ff8, 0x0040, 0x0020 },	// U+2AB1 (⪱)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x0010, 0x0060, 0x0180, 0x0e00, 0x0180, 0x0060, 0x0010, 0x0108, 0x0080, 0x0ff8, 0x0020, 0x0010 },	// U+2AB2 (⪲)
	{ 0x0000, 0x0800, 0x0400, 0x0300, 0x00c0, 0x0038, 0x00c0, 0x0300, 0x0400, 0x0800, 0x0000, 0x0ff8, 0x0000, 0x0ff8, 0x0000, 0x0000 },	// U+2AB3 (⪳)
	{ 0x0000, 0x0008, 0x0010, 0x0060, 0x0180, 0x0e00, 0x0180, 0x0060, 0x0010, 0x0008, 0x0000, 0x0ff8, 0x0000, 0x0ff8, 0x0000, 0x0000 },	// U+2AB4 (⪴)
	{ 0x0000, 0x0800, 0x0400, 0x0300, 0x00c0, 0x0038, 0x00c0, 0x0300, 0x0400, 0x0c00, 0x0200, 0x0ff8, 0x0080, 0x0ff8, 0x0020, 0x0010 },	// U+2AB5 (⪵)
	{ 0x0000, 0x0008, 0x0010, 0x0060, 0x0180, 0x0e00, 0x0180, 0x0060, 0x0010, 0x0208, 0x0100, 0x0ff8, 0x0040, 0x0ff8, 0x0010, 0x0008 },	// U+2AB6 (⪶)
	{ 0x0800, 0x0400, 0x0300, 0x00c0, 0x0038, 0x00c0, 0x0300, 0x0400, 0x0800, 0x0000, 0x09e0, 0x0610, 0x08e0, 0x0710, 0x0000, 0x0000 },	// U+2AB7 (⪷)
	{ 0x0008, 0x0010, 0x0060, 0x0180, 0x0e00, 0x0180, 0x0060, 0x0010, 0x0008, 0x0000, 0x0470, 0x0388, 0x0470, 0x0388, 0x0000, 0x0000 },	// U+2AB8 (⪸)
	{ 0x0800, 0x0400, 0x0300, 0x00c0, 0x0038, 0x00c0, 0x0300, 0x0400, 0x0a00, 0x0200, 0x09e0, 0x0710, 0x08e0, 0x0790, 0x0040, 0x0040 },	// U+2AB9 (⪹)
	{ 0x0008, 0x0010, 0x0060, 0x0180, 0x0e00, 0x0180, 0x0060, 0x0010, 0x0108, 0x0100, 0x04f0, 0x0388, 0x0470, 0x03c8, 0x0020, 0x0020 },	// U+2ABA (⪺)
	{ 0x0000, 0x0000, 0x0000, 0x4200, 0x2100, 0x18c0, 0x0630, 0x01ce, 0x0630, 0x18c0, 0x2100, 0x4200, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2ABB (⪻)
	{ 0x0000, 0x0000, 0x0000, 0x0042, 0x0084, 0x0318, 0x0c60, 0x7380, 0x0c60, 0x0318, 0x0084, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2ABC (⪼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff0, 0x0008, 0x0004, 0x0064, 0x0064, 0x0004, 0x0008, 0x1ff0, 0x0000, 0x0000 },	// U+2ABD (⪽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07fc, 0x0800, 0x1000, 0x1300, 0x1300, 0x1000, 0x0800, 0x07fc, 0x0000, 0x0000 },	// U+2ABE (⪾)
}; // 42

static const uint16_t unifontdw_block265[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x00fe, 0x0000, 0x0000 },	// U+2ACD (⫍)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x7f00, 0x0000, 0x0000 },	// U+2ACE (⫎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0810, 0x0808, 0x0808, 0x0808, 0x0808, 0x0810, 0x0fe0, 0x0000, 0x0000 },	// U+2ACF (⫏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0408, 0x0808, 0x0808, 0x0808, 0x0808, 0x0408, 0x03f8, 0x0000, 0x0000 },	// U+2AD0 (⫐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fe0, 0x0810, 0x0808, 0x0808, 0x0808, 0x0808, 0x0810, 0x0fe0, 0x0000, 0x0ff8, 0x0000, 0x0000 },	// U+2AD1 (⫑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f8, 0x0408, 0x0808, 0x0808, 0x0808, 0x0808, 0x0408, 0x03f8, 0x0000, 0x0ff8, 0x0000, 0x0000 },	// U+2AD2 (⫒)
}; // 6

static const uint16_t unifontdw_block266[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c7c, 0x0280, 0x0280, 0x0280, 0x7c7c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2AD7 (⫗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c7c, 0x0280, 0x0fe0, 0x0280, 0x7c7c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2AD8 (⫘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0490, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0000, 0x0000 },	// U+2AD9 (⫙)
	{ 0x0000, 0x0000, 0x07f0, 0x0080, 0x03e0, 0x0490, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0000, 0x0000 },	// U+2ADA (⫚)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x03e0, 0x0490, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0080, 0x0080 },	// U+2ADB (⫛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0880, 0x0480, 0x0280, 0x0180, 0x0888, 0x08c8, 0x08a8, 0x0490, 0x03e8, 0x0000, 0x0000 },	// U+2ADC (⫝̸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0888, 0x0888, 0x0888, 0x0490, 0x03e0, 0x0000, 0x0000 },	// U+2ADD (⫝)
}; // 7

static const uint16_t unifontdw_block267[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2ADF (⫟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0ff8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2AE0 (⫠)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x1c80, 0x0280, 0x0c80, 0x1080, 0x0e80, 0x0080, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2AE1 (⫡)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x0004, 0x0ffc, 0x0004, 0x0ffc, 0x0004, 0x0ffc, 0x0004, 0x0004, 0x0000, 0x0000 },	// U+2AE2 (⫢)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2ffc, 0x2800, 0x2800, 0x2800, 0x2800, 0x0000, 0x0000 },	// U+2AE3 (⫣)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x1ff8, 0x1000, 0x1ff8, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000 },	// U+2AE4 (⫤)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2800, 0x2800, 0x2800, 0x2ffc, 0x2800, 0x2ffc, 0x2800, 0x2800, 0x2800, 0x0000, 0x0000 },	// U+2AE5 (⫥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014, 0x0014, 0x0014, 0x0014, 0x3ffc, 0x0014, 0x0014, 0x0014, 0x0014, 0x0000, 0x0000 },	// U+2AE6 (⫦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0000, 0x0ff8, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2AE7 (⫧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0ff8, 0x0000, 0x0ff8, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2AE8 (⫨)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0ff8, 0x0000, 0x0ff8, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2AE9 (⫩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0000, 0x0000 },	// U+2AEA (⫪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0ff8, 0x0000, 0x0000 },	// U+2AEB (⫫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1000, 0x1ff8, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+2AEC (⫬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x0008, 0x1ff8, 0x0008, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+2AED (⫭)
}; // 15

static const uint16_t unifontdw_block268[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0ae0, 0x0750, 0x0240, 0x0240, 0x0240, 0x0000, 0x0000 },	// U+2AF3 (⫳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0000, 0x0000 },	// U+2AF4 (⫴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x1ffc, 0x0490, 0x0490, 0x0490, 0x0490, 0x0000, 0x0000 },	// U+2AF5 (⫵)
}; // 3

static const uint16_t unifontdw_block269[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x1800, 0x0600, 0x1980, 0x0660, 0x1998, 0x0444, 0x1998, 0x0660, 0x1980, 0x0600, 0x1800, 0x0000, 0x0000 },	// U+2AF7 (⫷)
	{ 0x0000, 0x0000, 0x0000, 0x000c, 0x0030, 0x00cc, 0x0330, 0x0ccc, 0x1110, 0x0ccc, 0x0330, 0x00cc, 0x0030, 0x000c, 0x0000, 0x0000 },	// U+2AF8 (⫸)
	{ 0x0000, 0x0000, 0x0600, 0x0180, 0x0060, 0x0010, 0x0060, 0x0180, 0x0610, 0x0060, 0x0180, 0x0610, 0x0060, 0x0180, 0x0600, 0x0000 },	// U+2AF9 (⫹)
	{ 0x0000, 0x0000, 0x0030, 0x00c0, 0x0300, 0x0400, 0x0300, 0x00c0, 0x0430, 0x0300, 0x00c0, 0x0430, 0x0300, 0x00c0, 0x0030, 0x0000 },	// U+2AFA (⫺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1240, 0x1240, 0x0920, 0x0920, 0x0490, 0x0490, 0x0248, 0x0248, 0x0124, 0x0124, 0x0000, 0x0000 },	// U+2AFB (⫻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0490, 0x0000 },	// U+2AFC (⫼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0900, 0x0900, 0x0480, 0x0480, 0x0240, 0x0240, 0x0120, 0x0120, 0x0090, 0x0090, 0x0000, 0x0000 },	// U+2AFD (⫽)
}; // 7

static const uint16_t unifontdw_block270[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x1f80, 0x1080, 0x1100, 0x1080, 0x1440, 0x1a20, 0x0110, 0x0088, 0x0044, 0x0028, 0x0010, 0x0000, 0x0000 },	// U+2B00 (⬀)
	{ 0x0000, 0x0000, 0x0000, 0x00fc, 0x0084, 0x0044, 0x0084, 0x0114, 0x022c, 0x0440, 0x0880, 0x1100, 0x0a00, 0x0400, 0x0000, 0x0000 },	// U+2B01 (⬁)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0028, 0x0044, 0x0088, 0x0110, 0x1a20, 0x1440, 0x1080, 0x1100, 0x1080, 0x1f80, 0x0000, 0x0000 },	// U+2B02 (⬂)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0a00, 0x1100, 0x0880, 0x0440, 0x022c, 0x0114, 0x0084, 0x0044, 0x0084, 0x00fc, 0x0000, 0x0000 },	// U+2B03 (⬃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x1818, 0x2ff4, 0x4002, 0x2ff4, 0x1818, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B04 (⬄)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0018, 0x3ffc, 0x3ffe, 0x3ffc, 0x0018, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B05 (⬅)
}; // 6

static const uint16_t unifontdw_block271[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x1f80, 0x1f80, 0x1f00, 0x1f80, 0x1fc0, 0x1be0, 0x01f0, 0x00f8, 0x007c, 0x0038, 0x0010, 0x0000, 0x0000 },	// U+2B08 (⬈)
	{ 0x0000, 0x0000, 0x0000, 0x00fc, 0x00fc, 0x007c, 0x00fc, 0x01fc, 0x03ec, 0x07c0, 0x0f80, 0x1f00, 0x0e00, 0x0400, 0x0000, 0x0000 },	// U+2B09 (⬉)
	{ 0x0000, 0x0000, 0x0000, 0x0010, 0x0038, 0x007c, 0x00f8, 0x01f0, 0x1be0, 0x1fc0, 0x1f80, 0x1f00, 0x1f80, 0x1f80, 0x0000, 0x0000 },	// U+2B0A (⬊)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0e00, 0x1f00, 0x0f80, 0x07c0, 0x03ec, 0x01fc, 0x00fc, 0x007c, 0x00fc, 0x00fc, 0x0000, 0x0000 },	// U+2B0B (⬋)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0810, 0x1818, 0x3ffc, 0x7ffe, 0x3ffc, 0x1818, 0x0810, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B0C (⬌)
}; // 5

static const uint16_t unifontdw_block272[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fff, 0x1000, 0x5400, 0x3800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B0E (⬎)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x3800, 0x5400, 0x1000, 0x1fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B0F (⬏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfff8, 0x0008, 0x002a, 0x001c, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B10 (⬐)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x001c, 0x002a, 0x0008, 0xfff8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B11 (⬑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1008, 0x1008, 0x1008, 0x1008, 0x1ff8, 0x0000 },	// U+2B12 (⬒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1008, 0x1008, 0x1008, 0x1008, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x1ff8, 0x0000 },	// U+2B13 (⬓)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1ff8, 0x1fe8, 0x1fc8, 0x1f88, 0x1f08, 0x1e08, 0x1c08, 0x1808, 0x1ff8, 0x0000 },	// U+2B14 (⬔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1018, 0x1038, 0x1078, 0x10f8, 0x11f8, 0x13f8, 0x17f8, 0x1ff8, 0x1ff8, 0x0000 },	// U+2B15 (⬕)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x02c0, 0x04e0, 0x08f0, 0x10f8, 0x10f8, 0x08f0, 0x04e0, 0x02c0, 0x0180, 0x0000 },	// U+2B16 (⬖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0340, 0x0720, 0x0f10, 0x1f08, 0x1f08, 0x0f10, 0x0720, 0x0340, 0x0180, 0x0000 },	// U+2B17 (⬗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x03c0, 0x07e0, 0x0ff0, 0x1ff8, 0x1008, 0x0810, 0x0420, 0x0240, 0x0180, 0x0000 },	// U+2B18 (⬘)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x1ff8, 0x0ff0, 0x07e0, 0x03c0, 0x0180, 0x0000 },	// U+2B19 (⬙)
	{ 0x0000, 0x0000, 0x0000, 0x1554, 0x0000, 0x1004, 0x0000, 0x1004, 0x0000, 0x1004, 0x0000, 0x1004, 0x0000, 0x1554, 0x0000, 0x0000 },	// U+2B1A (⬚)
	{ 0x0000, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x0000 },	// U+2B1B (⬛)
	{ 0x0000, 0x7ffe, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x4002, 0x7ffe, 0x0000 },	// U+2B1C (⬜)
}; // 15

static const uint16_t unifontdw_block273[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x03c0, 0x07e0, 0x0ff0, 0x1ff8, 0x3ffc, 0x1ff8, 0x1ff8, 0x0ff0, 0x0ff0, 0x07e0, 0x0000, 0x0000 },	// U+2B1F (⬟)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x2004, 0x1008, 0x1008, 0x0810, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+2B20 (⬠)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0360, 0x0c18, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x0c18, 0x0360, 0x0080, 0x0000 },	// U+2B21 (⬡)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x03e0, 0x0ff8, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x1ffc, 0x0ff8, 0x03e0, 0x0080, 0x0000 },	// U+2B22 (⬢)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0ff0, 0x1ff8, 0x3ffc, 0x7ffe, 0x7ffe, 0x3ffc, 0x1ff8, 0x0ff0, 0x07e0, 0x0000, 0x0000 },	// U+2B23 (⬣)
	{ 0x0000, 0x0000, 0x0380, 0x0fe0, 0x1ff0, 0x3ff8, 0x3ff8, 0x7ffc, 0x7ffc, 0x7ffc, 0x3ff8, 0x3ff8, 0x1ff0, 0x0fe0, 0x0380, 0x0000 },	// U+2B24 (⬤)
}; // 6

static const uint16_t unifontdw_block274[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x3ffe, 0x7fff, 0x7fff, 0x3ffe, 0x07f0, 0x0000, 0x0000 },	// U+2B2C (⬬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07f0, 0x380e, 0x4001, 0x4001, 0x380e, 0x07f0, 0x0000, 0x0000 },	// U+2B2D (⬭)
}; // 2

static const uint16_t unifontdw_block275[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0708, 0x0884, 0xfffe, 0x0884, 0x0708, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B30 (⬰)
}; // 1

static const uint16_t unifontdw_block276[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0548, 0x0924, 0xfffe, 0x0924, 0x0548, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B32 (⬲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x2224, 0xd55e, 0x0884, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B33 (⬳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0428, 0x0414, 0xfffe, 0x0414, 0x0428, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B34 (⬴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a28, 0x0a14, 0xfffe, 0x0a14, 0x0a28, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B35 (⬵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4028, 0x4014, 0x7ffe, 0x4014, 0x4028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B36 (⬶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4028, 0x2014, 0x1b7e, 0x2014, 0x4028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B37 (⬷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0xaaae, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B38 (⬸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4208, 0x2204, 0x1ffe, 0x2204, 0x4208, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B39 (⬹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4508, 0x2504, 0x1ffe, 0x2504, 0x4508, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B3A (⬺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4028, 0x2014, 0x1ffe, 0x2014, 0x4028, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B3B (⬻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4228, 0x2214, 0x1ffe, 0x2214, 0x4228, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B3C (⬼)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4528, 0x2514, 0x1ffe, 0x2514, 0x4528, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B3D (⬽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x1108, 0x0a04, 0xfffe, 0x0a04, 0x1108, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B3E (⬾)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c08, 0x4204, 0x81fe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B3F (⬿)
	{ 0x0000, 0x0000, 0x0000, 0x1f80, 0x0000, 0x1f88, 0x0004, 0xfffe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B40 (⭀)
	{ 0x0000, 0x0000, 0x0000, 0x3800, 0x4440, 0x0388, 0x0004, 0xfffe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B41 (⭁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0xfffe, 0x3804, 0x4448, 0x0380, 0x3800, 0x4440, 0x0380, 0x0000, 0x0000 },	// U+2B42 (⭂)
	{ 0x0000, 0x0000, 0x0000, 0x0006, 0x0018, 0x1060, 0x2180, 0x7ff0, 0x2180, 0x1060, 0x0018, 0x0006, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B43 (⭃)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01fe, 0x1200, 0x2400, 0x7ffe, 0x2400, 0x1200, 0x01fe, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B44 (⭄)
	{ 0x0000, 0x0000, 0x0040, 0x0020, 0xfff0, 0x0008, 0xfffc, 0x0002, 0xfffc, 0x0008, 0xfff0, 0x0020, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+2B45 (⭅)
	{ 0x0000, 0x0000, 0x0200, 0x0400, 0x0fff, 0x1000, 0x3fff, 0x4000, 0x3fff, 0x1000, 0x0fff, 0x0400, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+2B46 (⭆)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0222, 0x101c, 0x2000, 0x7fff, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B47 (⭇)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7fff, 0x21c0, 0x1222, 0x001c, 0x01c0, 0x0222, 0x001c, 0x0000, 0x0000 },	// U+2B48 (⭈)
	{ 0x0000, 0x0000, 0x0000, 0x0380, 0x4440, 0x3808, 0x0004, 0xfffe, 0x0004, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B49 (⭉)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0xfffe, 0x0384, 0x4448, 0x3800, 0x0380, 0x4440, 0x3800, 0x0000, 0x0000 },	// U+2B4A (⭊)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0004, 0xfffe, 0x0004, 0x3808, 0x4440, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B4B (⭋)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x7fff, 0x2000, 0x11c0, 0x0222, 0x001c, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B4C (⭌)
	{ 0x0000, 0x0000, 0x0100, 0x0080, 0x0040, 0x0020, 0x0010, 0x1ff8, 0x0800, 0x0400, 0x0200, 0x0140, 0x00c0, 0x01c0, 0x0000, 0x0000 },	// U+2B4D (⭍)
}; // 28

static const uint16_t unifontdw_block277[][16] = {
	{ 0x0000, 0x0080, 0x0080, 0x0140, 0x0140, 0x3e3e, 0x1004, 0x0808, 0x0410, 0x0220, 0x0410, 0x0888, 0x1364, 0x1c1c, 0x0000, 0x0000 },	// U+2B50 (⭐)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x01c0, 0x1ffc, 0x0ff8, 0x07f0, 0x07f0, 0x0f78, 0x1e3c, 0x180c, 0x0000, 0x0000, 0x0000 },	// U+2B51 (⭑)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x1e3c, 0x0808, 0x0410, 0x0490, 0x0948, 0x1634, 0x180c, 0x0000, 0x0000, 0x0000 },	// U+2B52 (⭒)
	{ 0x0000, 0x0000, 0x0100, 0x03c0, 0x07f0, 0x0ff8, 0x1ff8, 0x3ff8, 0x3ff8, 0x1ff8, 0x0ff8, 0x07f0, 0x03c0, 0x0100, 0x0000, 0x0000 },	// U+2B53 (⭓)
	{ 0x0000, 0x0000, 0x0100, 0x02c0, 0x0430, 0x0808, 0x1008, 0x2008, 0x2008, 0x1008, 0x0808, 0x0430, 0x02c0, 0x0100, 0x0000, 0x0000 },	// U+2B54 (⭔)
	{ 0x0000, 0x03e0, 0x07f0, 0x0c18, 0x180c, 0x3006, 0x3006, 0x3006, 0x3006, 0x3006, 0x180c, 0x0c18, 0x07f0, 0x03e0, 0x0000, 0x0000 },	// U+2B55 (⭕)
	{ 0x0000, 0x0000, 0x0000, 0x07f0, 0x0ff8, 0x180c, 0x33e6, 0x3416, 0x3416, 0x33e6, 0x180c, 0x0ff8, 0x07f0, 0x0000, 0x0000, 0x0000 },	// U+2B56 (⭖)
	{ 0x0000, 0x03e0, 0x07f0, 0x0c18, 0x180c, 0x31c6, 0x3226, 0x3226, 0x3226, 0x31c6, 0x180c, 0x0c18, 0x07f0, 0x03e0, 0x0000, 0x0000 },	// U+2B57 (⭗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x07f0, 0x0630, 0x0c18, 0x0c18, 0x0c18, 0x0630, 0x07f0, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+2B58 (⭘)
	{ 0x0000, 0x03e0, 0x07f0, 0x0c18, 0x1c1c, 0x3226, 0x3146, 0x3086, 0x3146, 0x3226, 0x1c1c, 0x0c18, 0x07f0, 0x03e0, 0x0000, 0x0000 },	// U+2B59 (⭙)
	{ 0x0000, 0x0000, 0x0000, 0x03c0, 0x0420, 0x0420, 0x0210, 0x0a90, 0x0710, 0x0208, 0x0008, 0x0008, 0x0004, 0x0004, 0x0000, 0x0000 },	// U+2B5A (⭚)
	{ 0x0000, 0x0000, 0x0000, 0x00f0, 0x0108, 0x0108, 0x0210, 0x0210, 0x0400, 0x0400, 0x0800, 0x2a00, 0x1c00, 0x0800, 0x0000, 0x0000 },	// U+2B5B (⭛)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0e00, 0x1500, 0x0400, 0x0200, 0x0200, 0x0200, 0x0200, 0x0100, 0x0100, 0x01f0, 0x0000, 0x0000 },	// U+2B5C (⭜)
	{ 0x0000, 0x0000, 0x0000, 0x01f0, 0x0100, 0x0100, 0x0200, 0x0200, 0x0200, 0x0200, 0x0400, 0x1500, 0x0e00, 0x0400, 0x0000, 0x0000 },	// U+2B5D (⭝)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0040, 0x0040, 0x0440, 0x0840, 0x1e20, 0x09a0, 0x0460, 0x0000, 0x0000 },	// U+2B5E (⭞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0040, 0x0440, 0x0820, 0x1e20, 0x09a0, 0x0460, 0x0000, 0x0000 },	// U+2B5F (⭟)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x000c, 0x7ffe, 0x000c, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B60 (⭠)
	{ 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080 },	// U+2B61 (⭡)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x3000, 0x7ffe, 0x3000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B62 (⭢)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x03e0, 0x01c0, 0x0080 },	// U+2B63 (⭣)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1004, 0x3006, 0x7fff, 0x3006, 0x1004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B64 (⭤)
	{ 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x03e0, 0x01c0, 0x0080 },	// U+2B65 (⭥)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0078, 0x0038, 0x0038, 0x0048, 0x0080, 0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x0000, 0x0000 },	// U+2B66 (⭦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1e00, 0x1c00, 0x1c00, 0x1200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x0000, 0x0000 },	// U+2B67 (⭧)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100, 0x1200, 0x1c00, 0x1c00, 0x1e00, 0x0000, 0x0000 },	// U+2B68 (⭨)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0048, 0x0038, 0x0038, 0x0078, 0x0000, 0x0000 },	// U+2B69 (⭩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x000c, 0x6dbe, 0x000c, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B6A (⭪)
	{ 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x0080, 0x0080, 0x0000, 0x0080, 0x0080, 0x0000, 0x0080, 0x0080, 0x0000, 0x0080, 0x0080 },	// U+2B6B (⭫)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x3000, 0x7db6, 0x3000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B6C (⭬)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x0000, 0x0080, 0x0080, 0x0000, 0x0080, 0x0080, 0x0000, 0x0080, 0x0080, 0x03e0, 0x01c0, 0x0080 },	// U+2B6D (⭭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0038, 0x0830, 0x1028, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x1008, 0x0810, 0x07e0, 0x0000 },	// U+2B6E (⭮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c00, 0x0c10, 0x1408, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x1008, 0x0810, 0x07e0, 0x0000 },	// U+2B6F (⭯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0022, 0x0032, 0x7ffa, 0x0032, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B70 (⭰)
	{ 0x0000, 0x0000, 0x03e0, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080 },	// U+2B71 (⭱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4400, 0x4c00, 0x5ffe, 0x4c00, 0x4400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B72 (⭲)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x03e0, 0x01c0, 0x0080, 0x0000, 0x03e0 },	// U+2B73 (⭳)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x7186, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6d86, 0x6dbe, 0x61de, 0x6fee, 0x6fee, 0x7ffe, 0x0000 },	// U+2B74 (⭴)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x7186, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x61de, 0x6fee, 0x61ee, 0x7ffe, 0x0000 },	// U+2B75 (⭵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x03f0, 0x0000, 0x01e0, 0x00e0, 0x00e0, 0x0120, 0x0200, 0x0400, 0x0800, 0x1000, 0x0000, 0x0000 },	// U+2B76 (⭶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1f80, 0x0000, 0x0f00, 0x0e00, 0x0e00, 0x0900, 0x0080, 0x0040, 0x0020, 0x0010, 0x0000, 0x0000 },	// U+2B77 (⭷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0020, 0x0040, 0x0080, 0x0900, 0x0e00, 0x0e00, 0x0f00, 0x0000, 0x1f80, 0x0000, 0x0000 },	// U+2B78 (⭸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x0800, 0x0400, 0x0200, 0x0120, 0x00e0, 0x00e0, 0x01e0, 0x0000, 0x03f0, 0x0000, 0x0000 },	// U+2B79 (⭹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0280, 0x0288, 0x028c, 0x7ffe, 0x028c, 0x0288, 0x0280, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B7A (⭺)
	{ 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x0080, 0x0080, 0x0080, 0x0080, 0x07f0, 0x0080, 0x07f0, 0x0080, 0x0080, 0x0080, 0x0080 },	// U+2B7B (⭻)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x1140, 0x3140, 0x7ffe, 0x3140, 0x1140, 0x0140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B7C (⭼)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x07f0, 0x0080, 0x07f0, 0x0080, 0x0080, 0x0080, 0x0080, 0x03e0, 0x01c0, 0x0080 },	// U+2B7D (⭽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0022, 0x0032, 0x7ffa, 0x0032, 0x0022, 0x4400, 0x4c00, 0x5ffe, 0x4c00, 0x4400, 0x0000, 0x0000 },	// U+2B7E (⭾)
	{ 0x0000, 0x0000, 0x1f20, 0x0020, 0x0420, 0x0e20, 0x1f20, 0x0420, 0x0420, 0x0420, 0x0420, 0x04f8, 0x0470, 0x0420, 0x0400, 0x04f8 },	// U+2B7F (⭿)
	{ 0x0000, 0x0000, 0x0000, 0x0008, 0x000c, 0x7ffe, 0x000c, 0x0008, 0x1000, 0x3000, 0x7ffe, 0x3000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+2B80 (⮀)
	{ 0x0000, 0x0000, 0x0420, 0x0470, 0x04f8, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x1f20, 0x0e20, 0x0420 },	// U+2B81 (⮁)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x3000, 0x7ffe, 0x3000, 0x1000, 0x0008, 0x000c, 0x7ffe, 0x000c, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+2B82 (⮂)
	{ 0x0000, 0x0000, 0x0420, 0x0e20, 0x1f20, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x04f8, 0x0470, 0x0420 },	// U+2B83 (⮃)
	{ 0x0000, 0x0000, 0x0008, 0x000c, 0x7ffe, 0x000c, 0x0008, 0x0000, 0x0008, 0x000c, 0x7ffe, 0x000c, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+2B84 (⮄)
	{ 0x0000, 0x0000, 0x0410, 0x0e38, 0x1f7c, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410 },	// U+2B85 (⮅)
	{ 0x0000, 0x0000, 0x1000, 0x3000, 0x7ffe, 0x3000, 0x1000, 0x0000, 0x1000, 0x3000, 0x7ffe, 0x3000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+2B86 (⮆)
	{ 0x0000, 0x0000, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x1f7c, 0x0e38, 0x0410 },	// U+2B87 (⮇)
	{ 0x0000, 0x07c0, 0x0fe0, 0x1f70, 0x3f38, 0x3f1c, 0x000c, 0x0004, 0x000c, 0x3f1c, 0x3f38, 0x1f70, 0x0fe0, 0x07c0, 0x0000, 0x0000 },	// U+2B88 (⮈)
	{ 0x0000, 0x0000, 0x07c0, 0x0ee0, 0x1c70, 0x3838, 0x701c, 0x600c, 0x7c7c, 0x7c7c, 0x7c7c, 0x3c78, 0x1c70, 0x0c60, 0x0000, 0x0000 },	// U+2B89 (⮉)
	{ 0x0000, 0x03e0, 0x07f0, 0x0ef8, 0x1cfc, 0x38fc, 0x3000, 0x2000, 0x3000, 0x38fc, 0x1cfc, 0x0ef8, 0x07f0, 0x03e0, 0x0000, 0x0000 },	// U+2B8A (⮊)
	{ 0x0000, 0x0000, 0x0c60, 0x1c70, 0x3c78, 0x7c7c, 0x7c7c, 0x7c7c, 0x600c, 0x701c, 0x3838, 0x1c70, 0x0ee0, 0x07c0, 0x0000, 0x0000 },	// U+2B8B (⮋)
	{ 0x0000, 0x0000, 0x0010, 0x0018, 0x0ffc, 0x1018, 0x2010, 0x4000, 0x4000, 0x4000, 0x4000, 0x2000, 0x1000, 0x0ff0, 0x0000, 0x0000 },	// U+2B8C (⮌)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x3800, 0x7c08, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x0810, 0x0420, 0x03c0, 0x0000 },	// U+2B8D (⮍)
	{ 0x0000, 0x0000, 0x1fe0, 0x0010, 0x0008, 0x0004, 0x0004, 0x0004, 0x0004, 0x1008, 0x3010, 0x7fe0, 0x3000, 0x1000, 0x0000, 0x0000 },	// U+2B8E (⮎)
	{ 0x0000, 0x0000, 0x0000, 0x0f00, 0x1080, 0x2040, 0x4020, 0x4020, 0x4020, 0x4020, 0x4020, 0x4020, 0x40f8, 0x0070, 0x0020, 0x0000 },	// U+2B8F (⮏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7800, 0x4000, 0x2000, 0x2008, 0x100c, 0x1ffe, 0x000c, 0x0008, 0x0000, 0x0000, 0x0000 },	// U+2B90 (⮐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001e, 0x0002, 0x0004, 0x1004, 0x3008, 0x7ff8, 0x3000, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+2B91 (⮑)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7efe, 0x4000, 0x4000, 0x4040, 0x4060, 0x7ff6, 0x0060, 0x0040, 0x0000, 0x0000, 0x0000 },	// U+2B92 (⮒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7f7e, 0x0002, 0x0002, 0x0202, 0x0602, 0x6ffe, 0x0600, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+2B93 (⮓)
	{ 0x0000, 0x0000, 0x0400, 0x0200, 0x3f7c, 0x2204, 0x2404, 0x0015, 0x200e, 0x7004, 0xa800, 0x2024, 0x2044, 0x3efc, 0x0040, 0x0020 },	// U+2B94 (⮔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0c00, 0x1ffe, 0x3ffe, 0x1ffe, 0x0c00, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2B95 (⮕)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x7186, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x73ce, 0x7db6, 0x718e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+2B96 (⮖)
	{ 0x0000, 0x0000, 0x3ffe, 0x2002, 0x27f2, 0x1004, 0x17f4, 0x0888, 0x0888, 0x0490, 0x0490, 0x02a0, 0x0220, 0x0140, 0x0080, 0x0000 },	// U+2B97 (⮗)
	{ 0x0000, 0x2000, 0x1c00, 0x1300, 0x08c0, 0x0830, 0x040c, 0x0202, 0x07fc, 0x0ff0, 0x0fc0, 0x1f00, 0x1c00, 0x2000, 0x0000, 0x0000 },	// U+2B98 (⮘)
	{ 0x0000, 0x0000, 0x0080, 0x0140, 0x0140, 0x0260, 0x0260, 0x0470, 0x0470, 0x0878, 0x08f8, 0x117c, 0x163c, 0x180c, 0x2002, 0x0000 },	// U+2B99 (⮙)
	{ 0x0000, 0x0002, 0x001c, 0x0064, 0x0188, 0x0608, 0x1810, 0x2020, 0x1ff0, 0x07f8, 0x01f8, 0x007c, 0x001c, 0x0002, 0x0000, 0x0000 },	// U+2B9A (⮚)
	{ 0x0000, 0x0000, 0x2002, 0x180c, 0x1e34, 0x1f44, 0x0f88, 0x0f08, 0x0710, 0x0710, 0x0320, 0x0320, 0x0140, 0x0140, 0x0080, 0x0000 },	// U+2B9B (⮛)
	{ 0x0000, 0x2000, 0x1c00, 0x1f00, 0x0fc0, 0x0ff0, 0x07fc, 0x03fe, 0x07fc, 0x0ff0, 0x0fc0, 0x1f00, 0x1c00, 0x2000, 0x0000, 0x0000 },	// U+2B9C (⮜)
	{ 0x0000, 0x0000, 0x0080, 0x01c0, 0x01c0, 0x03e0, 0x03e0, 0x07f0, 0x07f0, 0x0ff8, 0x0ff8, 0x1f7c, 0x1e3c, 0x180c, 0x2002, 0x0000 },	// U+2B9D (⮝)
	{ 0x0000, 0x0002, 0x001c, 0x007c, 0x01f8, 0x07f8, 0x1ff0, 0x3fe0, 0x1ff0, 0x07f8, 0x01f8, 0x007c, 0x001c, 0x0002, 0x0000, 0x0000 },	// U+2B9E (⮞)
	{ 0x0000, 0x0000, 0x2002, 0x180c, 0x1e3c, 0x1f7c, 0x0ff8, 0x0ff8, 0x07f0, 0x07f0, 0x03e0, 0x03e0, 0x01c0, 0x01c0, 0x0080, 0x0000 },	// U+2B9F (⮟)
	{ 0x0000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4008, 0x400c, 0x7ffe, 0x000c, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2BA0 (⮠)
	{ 0x0000, 0x0002, 0x0002, 0x0002, 0x0002, 0x1002, 0x3002, 0x7ffe, 0x3000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2BA1 (⮡)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x000c, 0x7ffe, 0x400c, 0x4008, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000 },	// U+2BA2 (⮢)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x3000, 0x7ffe, 0x3002, 0x1002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0000, 0x0000 },	// U+2BA3 (⮣)
	{ 0x0000, 0x0000, 0x0020, 0x0070, 0x00f8, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0fe0, 0x0000 },	// U+2BA4 (⮤)
	{ 0x0000, 0x0000, 0x0200, 0x0700, 0x0f80, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x03f8, 0x0000 },	// U+2BA5 (⮥)
	{ 0x0000, 0x0000, 0x0fe0, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x00f8, 0x0070, 0x0020, 0x0000 },	// U+2BA6 (⮦)
	{ 0x0000, 0x0000, 0x03f8, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0f80, 0x0700, 0x0200, 0x0000 },	// U+2BA7 (⮧)
	{ 0x0000, 0x0000, 0x0000, 0x4000, 0x4008, 0x600c, 0x3ffe, 0x3fff, 0x1ffe, 0x000c, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2BA8 (⮨)
	{ 0x0000, 0x0000, 0x0000, 0x0001, 0x0801, 0x1803, 0x3ffe, 0x7ffe, 0x3ffc, 0x1800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2BA9 (⮩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x000c, 0x1ffe, 0x3fff, 0x3ffe, 0x600c, 0x4008, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2BAA (⮪)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1800, 0x3ffc, 0x7ffe, 0x3ffe, 0x1803, 0x0801, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2BAB (⮫)
	{ 0x0000, 0x0000, 0x0000, 0x0040, 0x00e0, 0x01f0, 0x03f8, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x01c0, 0x0700, 0x0000 },	// U+2BAC (⮬)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x07f0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x00e0, 0x0038, 0x0000 },	// U+2BAD (⮭)
	{ 0x0000, 0x0000, 0x0000, 0x0700, 0x01c0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x03f8, 0x01f0, 0x00e0, 0x0040, 0x0000 },	// U+2BAE (⮮)
	{ 0x0000, 0x0000, 0x0000, 0x0038, 0x00e0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x07f0, 0x03e0, 0x01c0, 0x0080, 0x0000 },	// U+2BAF (⮯)
	{ 0x0000, 0x4400, 0x6c00, 0x5400, 0x4400, 0x4400, 0x4420, 0x4450, 0x3fc8, 0x2004, 0x1002, 0x0804, 0x07c8, 0x0050, 0x0020, 0x0000 },	// U+2BB0 (⮰)
	{ 0x0000, 0x0022, 0x0036, 0x002a, 0x0022, 0x0022, 0x0422, 0x0a22, 0x13fc, 0x2004, 0x4008, 0x2010, 0x13e0, 0x0a00, 0x0400, 0x0000 },	// U+2BB1 (⮱)
	{ 0x0000, 0x0020, 0x0050, 0x07c8, 0x0804, 0x1002, 0x2004, 0x3fc8, 0x4450, 0x4420, 0x4400, 0x4400, 0x5400, 0x6c00, 0x4400, 0x0000 },	// U+2BB2 (⮲)
	{ 0x0000, 0x0400, 0x0a00, 0x13e0, 0x2010, 0x4008, 0x2004, 0x13fc, 0x0a22, 0x0422, 0x0022, 0x0022, 0x002a, 0x0036, 0x0022, 0x0000 },	// U+2BB3 (⮳)
	{ 0x0000, 0x0020, 0x0050, 0x0088, 0x0104, 0x0202, 0x018c, 0x0088, 0x0088, 0x0088, 0x7f88, 0x2090, 0x10a0, 0x20c0, 0x7f00, 0x0000 },	// U+2BB4 (⮴)
	{ 0x0000, 0x0400, 0x0a00, 0x1100, 0x2080, 0x4040, 0x3180, 0x1100, 0x1100, 0x1100, 0x11fe, 0x0904, 0x0508, 0x0304, 0x00fe, 0x0000 },	// U+2BB5 (⮵)
	{ 0x0000, 0x7f00, 0x20c0, 0x10a0, 0x2090, 0x7f88, 0x0088, 0x0088, 0x0088, 0x018c, 0x0202, 0x0104, 0x0088, 0x0050, 0x0020, 0x0000 },	// U+2BB6 (⮶)
	{ 0x0000, 0x00fe, 0x0304, 0x0508, 0x0904, 0x11fe, 0x1100, 0x1100, 0x1100, 0x3180, 0x4040, 0x2080, 0x1100, 0x0a00, 0x0400, 0x0000 },	// U+2BB7 (⮷)
	{ 0x0000, 0x0080, 0x0140, 0x0220, 0x07f0, 0x0808, 0x0630, 0x0220, 0x0220, 0x03e0, 0x0000, 0x03e0, 0x0220, 0x03e0, 0x0000, 0x0000 },	// U+2BB8 (⮸)
	{ 0x0000, 0x0000, 0x0000, 0x3ffe, 0x2002, 0x2082, 0x2142, 0x2222, 0x2412, 0x280a, 0x2002, 0x2002, 0x2002, 0x3ffe, 0x0000, 0x0000 },	// U+2BB9 (⮹)
	{ 0x0000, 0x0000, 0x3fc0, 0x2040, 0x2040, 0x2040, 0x23fc, 0x2244, 0x2244, 0x3fc4, 0x0204, 0x0204, 0x0204, 0x03fc, 0x0000, 0x0000 },	// U+2BBA (⮺)
	{ 0x0000, 0x0000, 0x3fc0, 0x3fc0, 0x3fc0, 0x3fc0, 0x3ffc, 0x3fc4, 0x3fc4, 0x3fc4, 0x0204, 0x0204, 0x0204, 0x03fc, 0x0000, 0x0000 },	// U+2BBB (⮻)
	{ 0x0000, 0x0000, 0x3fc0, 0x3fc0, 0x3fc0, 0x3fc0, 0x3ffc, 0x3ffc, 0x3ffc, 0x3ffc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x0000, 0x0000 },	// U+2BBC (⮼)
	{ 0x0000, 0x0000, 0x3ffc, 0x2004, 0x2004, 0x2824, 0x2444, 0x2284, 0x2104, 0x2284, 0x2444, 0x2824, 0x2004, 0x3ffc, 0x0000, 0x0000 },	// U+2BBD (⮽)
	{ 0x0000, 0x0000, 0x03e0, 0x0410, 0x0808, 0x1004, 0x1224, 0x2142, 0x2082, 0x2142, 0x1224, 0x1004, 0x0808, 0x0410, 0x03e0, 0x0000 },	// U+2BBE (⮾)
	{ 0x0000, 0x0000, 0x03e0, 0x0ff8, 0x1c1c, 0x180c, 0x3226, 0x3146, 0x3086, 0x3146, 0x3226, 0x180c, 0x1c1c, 0x0ff8, 0x03e0, 0x0000 },	// U+2BBF (⮿)
	{ 0x0000, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ffe, 0x0000, 0x0000 },	// U+2BC0 (⯀)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x07f0, 0x0ff8, 0x1ffc, 0x0ff8, 0x07f0, 0x03e0, 0x01c0, 0x0080, 0x0000, 0x0000 },	// U+2BC1 (⯁)
	{ 0x0000, 0x0000, 0x0000, 0x07e0, 0x0ff0, 0x0ff0, 0x1ff8, 0x1ff8, 0x3ffc, 0x3ffc, 0x1ff8, 0x0ff0, 0x07e0, 0x03c0, 0x0180, 0x0000 },	// U+2BC2 (⯂)
	{ 0x0000, 0x0000, 0x03e0, 0x07f0, 0x0ff8, 0x1ffc, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ffe, 0x1ffc, 0x0ff8, 0x07f0, 0x03e0, 0x0000 },	// U+2BC3 (⯃)
	{ 0x0000, 0x01c0, 0x03e0, 0x1ffc, 0x1ffc, 0x1ffc, 0x3ffe, 0x7fff, 0x7fff, 0x7fff, 0x3ffe, 0x1ffc, 0x1ffc, 0x1ffc, 0x03e0, 0x01c0 },	// U+2BC4 (⯄)
	{ 0x0000, 0x0000, 0x0080, 0x01c0, 0x01c0, 0x03e0, 0x03e0, 0x07f0, 0x07f0, 0x0ff8, 0x0ff8, 0x1ffc, 0x1ffc, 0x3ffe, 0x0000, 0x0000 },	// U+2BC5 (⯅)
	{ 0x0000, 0x0000, 0x0000, 0x3ffe, 0x1ffc, 0x1ffc, 0x0ff8, 0x0ff8, 0x07f0, 0x07f0, 0x03e0, 0x03e0, 0x01c0, 0x01c0, 0x0080, 0x0000 },	// U+2BC6 (⯆)
	{ 0x0000, 0x1000, 0x1c00, 0x1f00, 0x1fc0, 0x1ff0, 0x1ffc, 0x1ffe, 0x1ffc, 0x1ff0, 0x1fc0, 0x1f00, 0x1c00, 0x1000, 0x0000, 0x0000 },	// U+2BC7 (⯇)
	{ 0x0000, 0x0002, 0x000e, 0x003e, 0x00fe, 0x03fe, 0x0ffe, 0x1ffe, 0x0ffe, 0x03fe, 0x00fe, 0x003e, 0x000e, 0x0002, 0x0000, 0x0000 },	// U+2BC8 (⯈)
}; // 121

static const uint16_t unifontdw_block278[][16] = {
	{ 0x0000, 0x0000, 0x03e0, 0x07f0, 0x0ff8, 0x1ffc, 0x1ffc, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2BCA (⯊)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x3ffe, 0x1ffc, 0x1ffc, 0x0ff8, 0x07f0, 0x03e0, 0x0000 },	// U+2BCB (⯋)
	{ 0x0080, 0x0080, 0x01c0, 0x01c0, 0x03e0, 0x07f0, 0x1ffc, 0x7fff, 0x1ffc, 0x07f0, 0x03e0, 0x01c0, 0x01c0, 0x0080, 0x0080, 0x0000 },	// U+2BCC (⯌)
	{ 0x0000, 0x0000, 0x0000, 0x1004, 0x0808, 0x0630, 0x07f0, 0x03e0, 0x03e0, 0x03e0, 0x07f0, 0x0630, 0x0808, 0x1004, 0x0000, 0x0000 },	// U+2BCD (⯍)
	{ 0x0080, 0x0080, 0x01c0, 0x0140, 0x0220, 0x0410, 0x180c, 0x7007, 0x180c, 0x0410, 0x0220, 0x0140, 0x01c0, 0x0080, 0x0080, 0x0000 },	// U+2BCE (⯎)
	{ 0x0000, 0x0000, 0x0000, 0x1004, 0x0808, 0x0630, 0x05d0, 0x0220, 0x0220, 0x0220, 0x05d0, 0x0630, 0x0808, 0x1004, 0x0000, 0x0000 },	// U+2BCF (⯏)
	{ 0x0000, 0x0000, 0x0080, 0x0080, 0x0ff8, 0x0888, 0x0888, 0x0808, 0x3e3e, 0x0808, 0x0888, 0x0888, 0x0ff8, 0x0080, 0x0080, 0x0000 },	// U+2BD0 (⯐)
	{ 0x0000, 0x0000, 0x0080, 0x0140, 0x0220, 0x05d0, 0x0a28, 0x1204, 0x2182, 0x1084, 0x0808, 0x0490, 0x0220, 0x0140, 0x0080, 0x0000 },	// U+2BD1 (⯑)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x07f0, 0x0080, 0x0080, 0x07f0, 0x0080, 0x0080, 0x07f0, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+2BD2 (⯒)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0410, 0x1414, 0x1414, 0x1224, 0x09c8, 0x0410, 0x03e0, 0x0080, 0x03e0, 0x0080 },	// U+2BD3 (⯓)
	{ 0x0000, 0x0000, 0x0e38, 0x1144, 0x1084, 0x03e0, 0x0080, 0x01c0, 0x0220, 0x0410, 0x0410, 0x0410, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+2BD4 (⯔)
	{ 0x0000, 0x0000, 0x01c0, 0x0220, 0x0410, 0x0410, 0x0410, 0x2222, 0x31c6, 0x280a, 0x2632, 0x11c4, 0x0808, 0x0410, 0x03e0, 0x0000 },	// U+2BD5 (⯕)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x0510, 0x0a08, 0x1204, 0x1404, 0x1404, 0x1404, 0x1204, 0x0a08, 0x0510, 0x03e0, 0x0000, 0x0000 },	// U+2BD6 (⯖)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x0080, 0x01c0, 0x0220, 0x05d0, 0x0410, 0x0410, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+2BD7 (⯗)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3c3c, 0x0420, 0x0420, 0x0420, 0x05a0, 0x05a0, 0x0420, 0x0420, 0x0420, 0x3c3c, 0x0000, 0x0000 },	// U+2BD8 (⯘)
	{ 0x0000, 0x0000, 0x0000, 0x0180, 0x0240, 0x1e40, 0x0380, 0x0200, 0x0100, 0x0100, 0x0080, 0x0180, 0x0240, 0x0278, 0x0180, 0x0000 },	// U+2BD9 (⯙)
	{ 0x0000, 0x0000, 0x0888, 0x1084, 0x1084, 0x1084, 0x0c98, 0x03e0, 0x0490, 0x0888, 0x0490, 0x03e0, 0x0490, 0x03e0, 0x0000, 0x0000 },	// U+2BDA (⯚)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0480, 0x0480, 0x0380, 0x0080, 0x0080, 0x03e0, 0x0410, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+2BDB (⯛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0480, 0x0580, 0x0680, 0x0480, 0x0080, 0x0080, 0x03e0, 0x0410, 0x0410, 0x03e0, 0x0000, 0x0000 },	// U+2BDC (⯜)
	{ 0x0000, 0x0000, 0x0000, 0x00e0, 0x0140, 0x0280, 0x0480, 0x0500, 0x0500, 0x0480, 0x0280, 0x0140, 0x00e0, 0x0080, 0x03e0, 0x0080 },	// U+2BDD (⯝)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x07f0, 0x0ff8, 0x07f0, 0x03e0, 0x01c0, 0x0080, 0x0080, 0x03e0, 0x0080, 0x0080 },	// U+2BDE (⯞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1004, 0x180c, 0x1634, 0x09c8, 0x0410, 0x03e0, 0x0080, 0x03e0, 0x0080 },	// U+2BDF (⯟)
	{ 0x0000, 0x0000, 0x0000, 0x001c, 0x0020, 0x0e40, 0x1140, 0x1140, 0x1140, 0x0e20, 0x0410, 0x1ffc, 0x0400, 0x1f00, 0x0400, 0x0400 },	// U+2BE0 (⯠)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0808, 0x0084, 0x0084, 0x03e4, 0x0084, 0x0084, 0x0888, 0x0490, 0x03e0, 0x0080, 0x0080 },	// U+2BE1 (⯡)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x0080, 0x0080, 0x0080, 0x0c98, 0x03e0, 0x0080, 0x0360, 0x0c18, 0x0000, 0x0000 },	// U+2BE2 (⯢)
	{ 0x0000, 0x0000, 0x0000, 0x03e0, 0x0410, 0x0808, 0x1084, 0x1084, 0x13e4, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080 },	// U+2BE3 (⯣)
	{ 0x0000, 0x0000, 0x0000, 0x001c, 0x0020, 0x0040, 0x0040, 0x0a40, 0x0a40, 0x0a20, 0x0a10, 0x1ffc, 0x0a00, 0x0a00, 0x0a00, 0x0a00 },	// U+2BE4 (⯤)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0220, 0x0220, 0x01c0, 0x02a0, 0x03e0, 0x02a0, 0x01c0, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080 },	// U+2BE5 (⯥)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x1ffc },	// U+2BE6 (⯦)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1004, 0x1004, 0x0888, 0x0490, 0x03e0, 0x0080, 0x0080, 0x03e0, 0x0490, 0x0888, 0x1004, 0x1004 },	// U+2BE7 (⯧)
	{ 0x0000, 0x0200, 0x0200, 0x0300, 0x0300, 0x0380, 0x03f8, 0x03f0, 0x03e0, 0x03c0, 0x0380, 0x03c0, 0x01e0, 0x0060, 0x0010, 0x0000 },	// U+2BE8 (⯨)
	{ 0x0000, 0x0020, 0x0020, 0x0060, 0x0060, 0x00e0, 0x0fe0, 0x07e0, 0x03e0, 0x01e0, 0x00e0, 0x01e0, 0x03c0, 0x0300, 0x0400, 0x0000 },	// U+2BE9 (⯩)
	{ 0x0000, 0x0080, 0x0080, 0x01c0, 0x01c0, 0x02e0, 0x3cfe, 0x10fc, 0x08f8, 0x06f0, 0x02e0, 0x04f0, 0x0b78, 0x0c18, 0x1004, 0x0000 },	// U+2BEA (⯪)
	{ 0x0000, 0x0080, 0x0080, 0x01c0, 0x01c0, 0x03a0, 0x3f9e, 0x1f84, 0x0f88, 0x07b0, 0x03a0, 0x0790, 0x0f68, 0x0c18, 0x1004, 0x0000 },	// U+2BEB (⯫)
	{ 0x0000, 0x0000, 0x1040, 0x1860, 0x1c70, 0x1e78, 0x1f7c, 0x7ffe, 0x1f7c, 0x1e78, 0x1c70, 0x1860, 0x1040, 0x0000, 0x0000, 0x0000 },	// U+2BEC (⯬)
	{ 0x0000, 0x0080, 0x01c0, 0x03e0, 0x07f0, 0x0ff8, 0x1ffc, 0x0080, 0x01c0, 0x03e0, 0x07f0, 0x0ff8, 0x1ffc, 0x0080, 0x0080, 0x0000 },	// U+2BED (⯭)
	{ 0x0000, 0x0000, 0x0208, 0x0618, 0x0e38, 0x1e78, 0x3ef8, 0x7ffe, 0x3ef8, 0x1e78, 0x0e38, 0x0618, 0x0208, 0x0000, 0x0000, 0x0000 },	// U+2BEE (⯮)
	{ 0x0000, 0x0100, 0x0100, 0x3ff8, 0x1ff0, 0x0fe0, 0x07c0, 0x0380, 0x0100, 0x3ff8, 0x1ff0, 0x0fe0, 0x07c0, 0x0380, 0x0100, 0x0000 },	// U+2BEF (⯯)
	{ 0x0000, 0x0000, 0x0000, 0x1c9c, 0x02a0, 0x01c0, 0x01c0, 0x0080, 0x0080, 0x0080, 0x01c0, 0x01c0, 0x02a0, 0x1c9c, 0x0000, 0x0000 },	// U+2BF0 (⯰)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0410, 0x0410, 0x0410, 0x0220, 0x01c0, 0x0080, 0x03e0, 0x01c0, 0x0080, 0x0000, 0x0000 },	// U+2BF1 (⯱)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0098, 0x00a4, 0x00a4, 0x03f8, 0x0080, 0x0180, 0x0200, 0x0400, 0x0400, 0x0400, 0x0000, 0x0000 },	// U+2BF2 (⯲)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1ffc, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1ffc, 0x0080, 0x0360, 0x0c18, 0x0000, 0x0000 },	// U+2BF3 (⯳)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffe, 0x2082, 0x1144, 0x0a28, 0x0410, 0x0410, 0x0a28, 0x1144, 0x2082, 0x3ffe, 0x0000, 0x0000 },	// U+2BF4 (⯴)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2082, 0x2082, 0x1144, 0x0a28, 0x0410, 0x0410, 0x0a28, 0x1144, 0x2082, 0x2082, 0x0000, 0x0000 },	// U+2BF5 (⯵)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1ffc, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1ffc, 0x0080, 0x0080, 0x0ff8, 0x0000, 0x0000 },	// U+2BF6 (⯶)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0808, 0x0410, 0x0220, 0x0140, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x1ffc, 0x0000, 0x0000 },	// U+2BF7 (⯷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x1ffc, 0x01c0, 0x02a0, 0x0490, 0x0888, 0x1084, 0x0000, 0x0000 },	// U+2BF8 (⯸)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ffc, 0x0000, 0x1ffc, 0x0000, 0x0e38, 0x1144, 0x1084, 0x1144, 0x0e38, 0x0000, 0x0000 },	// U+2BF9 (⯹)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e38, 0x1144, 0x1144, 0x1144, 0x0e38, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2BFA (⯺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x380e, 0x4411, 0x4551, 0x4411, 0x380e, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2BFB (⯻)
	{ 0x0000, 0x0000, 0x0000, 0x01c0, 0x0220, 0x0220, 0x0220, 0x01c0, 0x0000, 0x01c0, 0x0220, 0x0220, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+2BFC (⯼)
	{ 0x0000, 0x0000, 0x0000, 0x0080, 0x01c0, 0x03e0, 0x0080, 0x0080, 0x0080, 0x01c0, 0x0220, 0x0220, 0x0220, 0x01c0, 0x0000, 0x0000 },	// U+2BFD (⯽)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x07f0, 0x0000, 0x0000 },	// U+2BFE (⯾)
}; // 53

static const uint16_t unifontdw_block279[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff0, 0x2548, 0x2548, 0x1930, 0x0100, 0x07c0, 0x0ee0, 0x1290, 0x1290, 0x0c60, 0x0000, 0x0000 },	// U+2C0F (Ⰿ)
}; // 1

static const uint16_t unifontdw_block280[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1fc0, 0x0880, 0x0500, 0x0700, 0x08f8, 0x08a8, 0x0710, 0x0500, 0x0880, 0x1fc0, 0x0000, 0x0000 },	// U+2C1F (Ⱏ)
}; // 1

static const uint16_t unifontdw_block281[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c38, 0x2244, 0x0240, 0x0370, 0x0ec0, 0x0370, 0x0240, 0x0240, 0x2244, 0x1c38, 0x0000, 0x0000 },	// U+2C27 (Ⱗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e1c, 0x1122, 0x013c, 0x01a0, 0x0760, 0x01a0, 0x0120, 0x013c, 0x1122, 0x0e1c, 0x0000, 0x0000 },	// U+2C28 (Ⱘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1c08, 0x2214, 0x0232, 0x0349, 0x0eff, 0x031c, 0x0222, 0x0241, 0x2222, 0x1c1c, 0x0000, 0x0000 },	// U+2C29 (Ⱙ)
}; // 3

static const uint16_t unifontdw_block282[][16] = {
	{ 0x0000, 0x7ffe, 0x6386, 0x7dbe, 0x7d86, 0x7df6, 0x6386, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x0000 },	// U+2C2F (Ⱟ)
}; // 1

static const uint16_t unifontdw_block283[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x12a4, 0x0c98, 0x0080, 0x03e0, 0x0770, 0x0948, 0x0630, 0x0000, 0x0000 },	// U+2C3F (ⰿ)
}; // 1

static const uint16_t unifontdw_block284[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fc0, 0x0880, 0x0700, 0x08f8, 0x08a8, 0x0710, 0x0880, 0x1fc0, 0x0000, 0x0000 },	// U+2C4F (ⱏ)
}; // 1

static const uint16_t unifontdw_block285[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c38, 0x2244, 0x0370, 0x0ec0, 0x0370, 0x0240, 0x2244, 0x1c38, 0x0000, 0x0000 },	// U+2C57 (ⱗ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c38, 0x2244, 0x0378, 0x0ec0, 0x0340, 0x0278, 0x2244, 0x1c38, 0x0000, 0x0000 },	// U+2C58 (ⱘ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3810, 0x4428, 0x0664, 0x1d92, 0x06fe, 0x0438, 0x4444, 0x3838, 0x0000, 0x0000 },	// U+2C59 (ⱙ)
}; // 3

static const uint16_t unifontdw_block286[][16] = {
	{ 0x0000, 0x7ffe, 0x6386, 0x7dbe, 0x7d86, 0x7df6, 0x6386, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x7d86, 0x7ffe, 0x0000 },	// U+2C5F (ⱟ)
}; // 1

static const uint16_t unifontdw_block287[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f80, 0x1080, 0x1080, 0x1040, 0x0840, 0x0040, 0x0040, 0x0020, 0x0020, 0x0020, 0x0010, 0x0010 },	// U+2CCE (Ⳏ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0780, 0x0880, 0x0840, 0x0840, 0x0440, 0x0020, 0x0020, 0x0020, 0x0010, 0x0010 },	// U+2CCF (ⳏ)
}; // 2

static const uint16_t unifontdw_block288[][16] = {
	{ 0x0780, 0x0880, 0x0880, 0x0780, 0x0080, 0x7ffe, 0x389c, 0x6cb6, 0x44a2, 0x0281, 0x0281, 0x44a2, 0x6cb6, 0x389c, 0x0080, 0x0080 },	// U+2CE7 (⳧)
}; // 1

static const uint16_t unifontdw_block289[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ff8, 0x6c6c, 0x4444, 0x0282, 0x0282, 0x4444, 0x6c6c, 0x3838, 0x0000, 0x0000 },	// U+2CEA (⳪)
}; // 1

static const uint16_t unifontdw_block290[][16] = {
	{ 0x0000, 0x0000, 0x0030, 0x3ff0, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2CEF (⳯)
}; // 1

static const uint16_t unifontdw_block291[][16] = {
	{ 0x0000, 0x7ffe, 0x6386, 0x7dbe, 0x7d86, 0x7df6, 0x6386, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6ff6, 0x7ffe, 0x0000 },	// U+2CF4 (⳴)
	{ 0x0000, 0x7ffe, 0x6386, 0x7dbe, 0x7d86, 0x7df6, 0x6386, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+2CF5 (⳵)
	{ 0x0000, 0x7ffe, 0x6386, 0x7dbe, 0x7d86, 0x7df6, 0x6386, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+2CF6 (⳶)
	{ 0x0000, 0x7ffe, 0x6386, 0x7dbe, 0x7d86, 0x7df6, 0x6386, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+2CF7 (⳷)
	{ 0x0000, 0x7ffe, 0x6386, 0x7dbe, 0x7d86, 0x7df6, 0x6386, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+2CF8 (⳸)
}; // 5

static const uint16_t unifontdw_block292[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ffc, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0080, 0x0100 },	// U+2D05 (ⴅ)
}; // 1

static const uint16_t unifontdw_block293[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1110, 0x1110, 0x1110, 0x1110, 0x11f0, 0x0000, 0x0000 },	// U+2D07 (ⴇ)
}; // 1

static const uint16_t unifontdw_block294[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1110, 0x1110, 0x1110, 0x1110, 0x1f10, 0x0000, 0x0000 },	// U+2D0A (ⴊ)
}; // 1

static const uint16_t unifontdw_block295[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x088c, 0x0888, 0x0888, 0x0888, 0x0888, 0x1ff8, 0x0000, 0x0000 },	// U+2D0D (ⴍ)
}; // 1

static const uint16_t unifontdw_block296[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0f88, 0x0888, 0x0888, 0x0888, 0x0888, 0x08f8, 0x0000, 0x0000 },	// U+2D10 (ⴐ)
}; // 1

static const uint16_t unifontdw_block297[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1118, 0x1110, 0x1110, 0x1110, 0x1110, 0x1ff0, 0x1000, 0x1000 },	// U+2D13 (ⴓ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1110, 0x1110, 0x1110, 0x1110, 0x1ff0, 0x0100, 0x0100 },	// U+2D14 (ⴔ)
}; // 2

static const uint16_t unifontdw_block298[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0ff8, 0x0888, 0x0888, 0x0888, 0x0888, 0x08f8, 0x0000, 0x0000 },	// U+2D1B (ⴛ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ff8, 0x1110, 0x1110, 0x1110, 0x1110, 0x1910, 0x0010, 0x0010 },	// U+2D1C (ⴜ)
}; // 2

static const uint16_t unifontdw_block299[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08fc, 0x0888, 0x0888, 0x0888, 0x0888, 0x1f88, 0x0000, 0x0000 },	// U+2D20 (ⴠ)
}; // 1

static const uint16_t unifontdw_block300[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f00, 0x0880, 0x0080, 0x0080, 0x0ff8, 0x0888, 0x0888, 0x0888, 0x0888, 0x08f8, 0x0000, 0x0000 },	// U+2D25 (ⴥ)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7386, 0x7dbe, 0x7186, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+2D26 (⴦)
}; // 2

static const uint16_t unifontdw_block301[][16] = {
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x7386, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+2D28 (⴨)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x6386, 0x6ff6, 0x7386, 0x7ffe, 0x0000 },	// U+2D29 (⴩)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x6186, 0x6df6, 0x6d86, 0x7ffe, 0x0000 },	// U+2D2A (⴪)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x7186, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+2D2B (⴫)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7d86, 0x7df6, 0x6386, 0x7ffe, 0x0000 },	// U+2D2C (⴬)
}; // 5

static const uint16_t unifontdw_block302[][16] = {
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+2D2E (⴮)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x0000 },	// U+2D2F (⴯)
}; // 2

static const uint16_t unifontdw_block303[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1998, 0x1998, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2D48 (ⵈ)
}; // 1

static const uint16_t unifontdw_block304[][16] = {
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x73ce, 0x6df6, 0x73c6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+2D68 (⵨)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x73ce, 0x6df6, 0x63c6, 0x6fb6, 0x73ce, 0x7ffe, 0x0000 },	// U+2D69 (⵩)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x61ce, 0x6df6, 0x61c6, 0x6db6, 0x6dce, 0x7ffe, 0x0000 },	// U+2D6A (⵪)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x71ce, 0x6df6, 0x71c6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+2D6B (⵫)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x63ce, 0x7df6, 0x7dc6, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+2D6C (⵬)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x71ce, 0x6df6, 0x6dc6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+2D6D (⵭)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+2D6E (⵮)
}; // 7

static const uint16_t unifontdw_block305[][16] = {
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7786, 0x73be, 0x77de, 0x77ee, 0x63ee, 0x7ffe, 0x0000 },	// U+2D71 (⵱)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x61de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+2D72 (⵲)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7186, 0x6fbe, 0x63de, 0x6fee, 0x71ee, 0x7ffe, 0x0000 },	// U+2D73 (⵳)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6d86, 0x6dbe, 0x61de, 0x6fee, 0x6fee, 0x7ffe, 0x0000 },	// U+2D74 (⵴)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x61de, 0x6fee, 0x61ee, 0x7ffe, 0x0000 },	// U+2D75 (⵵)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7386, 0x7dbe, 0x71de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+2D76 (⵶)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x77de, 0x7bee, 0x7bee, 0x7ffe, 0x0000 },	// U+2D77 (⵷)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x73de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+2D78 (⵸)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x63de, 0x6fee, 0x73ee, 0x7ffe, 0x0000 },	// U+2D79 (⵹)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x61de, 0x6dee, 0x6dee, 0x7ffe, 0x0000 },	// U+2D7A (⵺)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x71de, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+2D7B (⵻)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7dde, 0x7dee, 0x63ee, 0x7ffe, 0x0000 },	// U+2D7C (⵼)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+2D7D (⵽)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+2D7E (⵾)
}; // 14

static const uint16_t unifontdw_block306[][16] = {
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x00f0, 0x01f0, 0x0398, 0x031b, 0x3f1f, 0x6b1b, 0x3b18, 0x0318, 0x0318, 0x0000, 0x0000 },	// U+2D80 (ⶀ)
	{ 0x0000, 0x0000, 0x3fe0, 0x3ff0, 0x6518, 0x6508, 0x6288, 0x3ef8, 0x3c70, 0x0040, 0x0040, 0x006c, 0x003c, 0x002c, 0x0000, 0x0000 },	// U+2D81 (ⶁ)
	{ 0x0000, 0x0000, 0x0000, 0x1f80, 0x27c0, 0x3c60, 0x0036, 0x003e, 0x0036, 0x0030, 0x0030, 0x0030, 0x0c20, 0x0fc0, 0x0c00, 0x0000 },	// U+2D82 (ⶂ)
	{ 0x0000, 0x0000, 0x0060, 0x0060, 0x0060, 0x00f0, 0x01f0, 0x0398, 0x031b, 0x001f, 0x001b, 0x0018, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+2D83 (ⶃ)
	{ 0x0000, 0x0000, 0x0606, 0x07fe, 0x0060, 0x00f0, 0x01f0, 0x0398, 0x031b, 0x001f, 0x001b, 0x0018, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+2D84 (ⶄ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f0, 0x01f0, 0x0398, 0x031b, 0x001f, 0x001b, 0x0018, 0x0018, 0x0018, 0x0000, 0x0000 },	// U+2D85 (ⶅ)
	{ 0x0000, 0x0000, 0x01c0, 0x0360, 0x0630, 0x0630, 0x0630, 0x0630, 0x0370, 0x01e0, 0x0ffc, 0x0ccc, 0x00c0, 0x00fc, 0x000c, 0x0000 },	// U+2D86 (ⶆ)
	{ 0x0000, 0x0c18, 0x0ff8, 0x0360, 0x0630, 0x0630, 0x0630, 0x0630, 0x0370, 0x01e0, 0x0ffc, 0x0ccc, 0x00c0, 0x00fc, 0x000c, 0x0000 },	// U+2D87 (ⶇ)
	{ 0x0000, 0x0000, 0x1fe0, 0x33f0, 0x1e18, 0x0018, 0x0038, 0x0030, 0x03e0, 0x0300, 0x0300, 0x0330, 0x03f0, 0x0030, 0x0000, 0x0000 },	// U+2D88 (ⶈ)
	{ 0x1818, 0x1ff8, 0x0180, 0x1fe0, 0x33f0, 0x1e18, 0x0018, 0x0030, 0x03e0, 0x0300, 0x0300, 0x0330, 0x03f0, 0x0030, 0x0000, 0x0000 },	// U+2D89 (ⶉ)
	{ 0x0000, 0x0000, 0x00c0, 0x00c0, 0x00c0, 0x03c0, 0x0300, 0x0380, 0x078c, 0x0efc, 0x0cec, 0x0c60, 0x0c60, 0x0060, 0x0000, 0x0000 },	// U+2D8A (ⶊ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x018c, 0x018d, 0x01ff, 0x018d, 0x018c, 0x000c, 0x000c, 0x000c, 0x000c, 0x0000, 0x0000 },	// U+2D8B (ⶋ)
	{ 0x0000, 0x0000, 0x0380, 0x07c0, 0x046c, 0x047c, 0x026c, 0x1fe0, 0x1980, 0x00c0, 0x00c0, 0x0060, 0x0070, 0x0000, 0x0000, 0x0000 },	// U+2D8C (ⶌ)
	{ 0x0180, 0x0180, 0x0380, 0x07c0, 0x046c, 0x047c, 0x026c, 0x1fe0, 0x1980, 0x00c0, 0x00c0, 0x0060, 0x0070, 0x0000, 0x0000, 0x0000 },	// U+2D8D (ⶍ)
	{ 0x0c30, 0x0ff0, 0x0180, 0x0380, 0x07cc, 0x047c, 0x026c, 0x1fe0, 0x1980, 0x00c0, 0x00c0, 0x0060, 0x0070, 0x0000, 0x0000, 0x0000 },	// U+2D8E (ⶎ)
	{ 0x0000, 0x0000, 0x0000, 0x0f80, 0x1ac0, 0x1ac0, 0x326c, 0x327c, 0x326c, 0x3260, 0x0060, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+2D8F (ⶏ)
	{ 0x0000, 0x0000, 0x0000, 0x3f80, 0x33c0, 0x3360, 0x5530, 0x7730, 0x0036, 0x00fe, 0x0176, 0x0230, 0x0360, 0x01c0, 0x0000, 0x0000 },	// U+2D90 (ⶐ)
	{ 0x0000, 0x0000, 0x0380, 0x07c0, 0x0c40, 0x0cc0, 0x0f80, 0x0600, 0x0300, 0x0fe0, 0x1860, 0x187e, 0x00c6, 0x00c0, 0x0000, 0x0000 },	// U+2D91 (ⶑ)
	{ 0x0000, 0x0000, 0x0c30, 0x0ff0, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x018c, 0x01fc, 0x00cc, 0x0060, 0x0030, 0x0010, 0x0000, 0x0000 },	// U+2D92 (ⶒ)
	{ 0x0380, 0x03c6, 0x007e, 0x0030, 0x0038, 0x00cc, 0x01c6, 0x0386, 0x0306, 0x3f00, 0x2b00, 0x3b00, 0x0300, 0x0300, 0x1fe0, 0x3870 },	// U+2D93 (ⶓ)
	{ 0x0000, 0x0000, 0x0303, 0x03ff, 0x0030, 0x0078, 0x007c, 0x00ce, 0x06c6, 0x07c0, 0x3ec0, 0x30c0, 0x00c0, 0x00c0, 0x0000, 0x0000 },	// U+2D94 (ⶔ)
	{ 0x0000, 0x0000, 0x0606, 0x07fe, 0x0060, 0x00f0, 0x00f8, 0x019c, 0x018c, 0x0180, 0x0180, 0x0f80, 0x0980, 0x0ff0, 0x0030, 0x0000 },	// U+2D95 (ⶕ)
	{ 0x0380, 0x03c6, 0x007e, 0x0030, 0x0038, 0x00cc, 0x01c6, 0x1b86, 0x1b06, 0x7f00, 0x6300, 0x0300, 0x0300, 0x0300, 0x1fe0, 0x3870 },	// U+2D96 (ⶖ)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x778e, 0x7bbe, 0x7bce, 0x7ffe, 0x0000 },	// U+2D97 (⶗)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x738e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+2D98 (⶘)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x638e, 0x6fbe, 0x73ce, 0x7ffe, 0x0000 },	// U+2D99 (⶙)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x61ce, 0x6db6, 0x618e, 0x6dbe, 0x6dce, 0x7ffe, 0x0000 },	// U+2D9A (⶚)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x718e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+2D9B (⶛)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x63ce, 0x7db6, 0x7d8e, 0x7dbe, 0x63ce, 0x7ffe, 0x0000 },	// U+2D9C (⶜)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x71ce, 0x6db6, 0x6d8e, 0x6dbe, 0x71ce, 0x7ffe, 0x0000 },	// U+2D9D (⶝)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x61ce, 0x7ffe, 0x0000 },	// U+2D9E (⶞)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x61ce, 0x7db6, 0x718e, 0x7dbe, 0x7dce, 0x7ffe, 0x0000 },	// U+2D9F (⶟)
	{ 0x0000, 0x0000, 0x1ff8, 0x1998, 0x0180, 0x03c0, 0x07c0, 0x0e60, 0x0c6c, 0x0c7c, 0x0c6c, 0x0c60, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+2DA0 (ⶠ)
	{ 0x0000, 0x0000, 0x0ffc, 0x0ccc, 0x00c0, 0x01e0, 0x03e0, 0x0730, 0x3636, 0x3e3e, 0x3636, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+2DA1 (ⶡ)
	{ 0x0000, 0x0000, 0x0ffc, 0x0ccc, 0x00c0, 0x01e0, 0x03e0, 0x0730, 0x0636, 0x063e, 0x0636, 0x0630, 0x3630, 0x3e30, 0x3000, 0x0000 },	// U+2DA2 (ⶢ)
	{ 0x0000, 0x0000, 0x1ff8, 0x1998, 0x0180, 0x03c0, 0x07c0, 0x0e60, 0x0c6c, 0x0c7c, 0x0c6c, 0x0c00, 0x0c00, 0x0c00, 0x0000, 0x0000 },	// U+2DA3 (ⶣ)
	{ 0x0000, 0x0000, 0x0ffc, 0x0ccc, 0x00c0, 0x01e0, 0x03e0, 0x0730, 0x0636, 0x063e, 0x0636, 0x3e30, 0x2630, 0x3e30, 0x0000, 0x0000 },	// U+2DA4 (ⶤ)
	{ 0x0000, 0x0000, 0x07fe, 0x0666, 0x00c0, 0x01e0, 0x03e0, 0x0730, 0x0636, 0x063e, 0x0636, 0x0630, 0x0630, 0x0630, 0x0000, 0x0000 },	// U+2DA5 (ⶥ)
	{ 0x0000, 0x0000, 0x3ff0, 0x3330, 0x0300, 0x0780, 0x07c0, 0x0ce0, 0x0c6c, 0x0c7c, 0x0c6c, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+2DA6 (ⶦ)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x6fb6, 0x7786, 0x7bb6, 0x7bb6, 0x7ffe, 0x0000 },	// U+2DA7 (⶧)
	{ 0x0000, 0x1818, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x01f8, 0x0198, 0x0180, 0x0000, 0x0000, 0x0000 },	// U+2DA8 (ⶨ)
	{ 0x0000, 0x1818, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x1ff8, 0x1998, 0x0180, 0x1980, 0x1ff8, 0x1998, 0x0180, 0x0000, 0x0000, 0x0000 },	// U+2DA9 (ⶩ)
	{ 0x0000, 0x1818, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x01f8, 0x1998, 0x1f80, 0x1800, 0x0000, 0x0000 },	// U+2DAA (ⶪ)
	{ 0x0000, 0x1818, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x01f8, 0x0198, 0x01c0, 0x00e0, 0x0018, 0x0018 },	// U+2DAB (ⶫ)
	{ 0x0000, 0x1818, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x0ff8, 0x0998, 0x0f80, 0x0000, 0x0000, 0x0000 },	// U+2DAC (ⶬ)
	{ 0x0000, 0x0c0c, 0x0ffc, 0x0ccc, 0x0180, 0x0180, 0x1ff8, 0x1998, 0x0180, 0x0180, 0x01f8, 0x0198, 0x0180, 0x0000, 0x0000, 0x0000 },	// U+2DAD (ⶭ)
	{ 0x180c, 0x180c, 0x05dc, 0x0360, 0x0630, 0x0630, 0x0630, 0x0630, 0x0370, 0x1ffe, 0x18c6, 0x00c0, 0x00fc, 0x00cc, 0x00c0, 0x0000 },	// U+2DAE (ⶮ)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x6186, 0x7db6, 0x7186, 0x7db6, 0x7db6, 0x7ffe, 0x0000 },	// U+2DAF (⶯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c3e, 0x6666, 0x0660, 0x07fe, 0x0666, 0x0660, 0x0660, 0x0660, 0x0000, 0x0000, 0x0000 },	// U+2DB0 (ⶰ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c3e, 0x6666, 0x0660, 0x7ffe, 0x6666, 0x0660, 0x0660, 0x0660, 0x0000, 0x0000, 0x0000 },	// U+2DB1 (ⶱ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c3e, 0x6666, 0x0660, 0x07fe, 0x0666, 0x0660, 0x6660, 0x7e60, 0x6000, 0x0000, 0x0000 },	// U+2DB2 (ⶲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c3e, 0x6666, 0x0660, 0x07fe, 0x0666, 0x0660, 0x0600, 0x0600, 0x0000, 0x0000, 0x0000 },	// U+2DB3 (ⶳ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c3e, 0x6666, 0x0660, 0x07fe, 0x0666, 0x3e60, 0x2660, 0x3e60, 0x0000, 0x0000, 0x0000 },	// U+2DB4 (ⶴ)
	{ 0x0186, 0x01fe, 0x0030, 0x0030, 0x7c3e, 0x6666, 0x0660, 0x07fe, 0x0666, 0x0660, 0x0660, 0x0660, 0x0660, 0x0000, 0x0000, 0x0000 },	// U+2DB5 (ⶵ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c3e, 0x6666, 0x0660, 0x07fe, 0x0666, 0x0660, 0x0060, 0x0060, 0x0000, 0x0000, 0x0000 },	// U+2DB6 (ⶶ)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x77c6, 0x7bb6, 0x7bc6, 0x7ffe, 0x0000 },	// U+2DB7 (⶷)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0fe0, 0x1930, 0x3118, 0x311f, 0x3113, 0x7338, 0xb558, 0xb558, 0xf778, 0x0000, 0x0000 },	// U+2DB8 (ⶸ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0fe0, 0x1930, 0xf118, 0xd11f, 0x1113, 0x3338, 0x5558, 0x5558, 0x7778, 0x0000, 0x0000 },	// U+2DB9 (ⶹ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0fe0, 0x1930, 0x3118, 0x311f, 0x3113, 0x3338, 0x3558, 0x3558, 0xf778, 0xc000, 0x0000 },	// U+2DBA (ⶺ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0fe0, 0x1930, 0x3338, 0x355f, 0x355b, 0x3778, 0x1800, 0x3800, 0x4c00, 0x7c00, 0x0000 },	// U+2DBB (ⶻ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fc0, 0x1fe0, 0xd930, 0x7118, 0xd11f, 0x1113, 0x3338, 0x5558, 0x5558, 0x7778, 0x0000, 0x0000 },	// U+2DBC (ⶼ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fc0, 0x1fe0, 0x1b30, 0x3338, 0x575f, 0x565b, 0x7678, 0x0a00, 0x0a00, 0x0e00, 0x0000, 0x0000 },	// U+2DBD (ⶽ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0fc0, 0x1fe0, 0x1930, 0x3318, 0x551f, 0x5513, 0x7738, 0x0058, 0x0058, 0x0078, 0x0000, 0x0000 },	// U+2DBE (ⶾ)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71c6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+2DBF (⶿)
	{ 0x0000, 0x0c30, 0x0e70, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+2DC0 (ⷀ)
	{ 0x0000, 0x0c30, 0x0e70, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x1980, 0x1f80, 0x1980, 0x0180, 0x0000, 0x0000 },	// U+2DC1 (ⷁ)
	{ 0x0000, 0x0c30, 0x0e70, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x1980, 0x1f80, 0x1800, 0x0000 },	// U+2DC2 (ⷂ)
	{ 0x0000, 0x0618, 0x0738, 0x00c0, 0x00c0, 0x07e0, 0x0cd8, 0x0ccc, 0x06cc, 0x01f8, 0x00c0, 0x0060, 0x0030, 0x001c, 0x001c, 0x001c },	// U+2DC3 (ⷃ)
	{ 0x0000, 0x0c30, 0x0e70, 0x0180, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0f80, 0x0980, 0x0f80, 0x0000, 0x0000 },	// U+2DC4 (ⷄ)
	{ 0x0000, 0x030c, 0x039c, 0x0060, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+2DC5 (ⷅ)
	{ 0x0000, 0x0c30, 0x0e70, 0x0180, 0x0240, 0x0240, 0x0180, 0x0fc0, 0x19b0, 0x1998, 0x0d98, 0x03f0, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+2DC6 (ⷆ)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x618e, 0x6ff6, 0x77f6, 0x7bf6, 0x7b8e, 0x7ffe, 0x0000 },	// U+2DC7 (⷇)
	{ 0x0000, 0x0000, 0x0000, 0x19b0, 0x1bb0, 0x0ff0, 0x0670, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0000, 0x0000 },	// U+2DC8 (ⷈ)
	{ 0x0000, 0x0000, 0x0000, 0x0cd8, 0x0dd8, 0x07f8, 0x0338, 0x0330, 0x1f30, 0x1b30, 0x0330, 0x0330, 0x0330, 0x0330, 0x0000, 0x0000 },	// U+2DC9 (ⷉ)
	{ 0x0000, 0x0000, 0x0000, 0x0cd8, 0x0dd8, 0x07f8, 0x0338, 0x0330, 0x0330, 0x0330, 0x0330, 0x0330, 0x0330, 0x1f30, 0x1800, 0x0000 },	// U+2DCA (ⷊ)
	{ 0x0000, 0x0000, 0x0000, 0x19b0, 0x1bb0, 0x0ff0, 0x0670, 0x0660, 0x0660, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0000, 0x0000 },	// U+2DCB (ⷋ)
	{ 0x0000, 0x0000, 0x0000, 0x0cd8, 0x0dd8, 0x07f8, 0x0338, 0x0330, 0x0330, 0x0330, 0x0330, 0x1f30, 0x1330, 0x1f30, 0x0000, 0x0000 },	// U+2DCC (ⷌ)
	{ 0x0000, 0x0000, 0x0000, 0x1998, 0x1b98, 0x0ff8, 0x0618, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0000, 0x0000 },	// U+2DCD (ⷍ)
	{ 0x0000, 0x0000, 0x0000, 0x19b0, 0x1bb0, 0x0ff0, 0x0670, 0x0660, 0x0660, 0x0660, 0x0060, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+2DCE (ⷎ)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x618e, 0x7df6, 0x71f6, 0x7df6, 0x7d8e, 0x7ffe, 0x0000 },	// U+2DCF (⷏)
	{ 0x030c, 0x039c, 0x0c63, 0x0fff, 0x0c63, 0x0380, 0x07c0, 0x0e60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+2DD0 (ⷐ)
	{ 0x030c, 0x039c, 0x0c63, 0x0fff, 0x0c63, 0x0380, 0x07c0, 0x0e60, 0x6c60, 0x7c60, 0x6c60, 0x0c60, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+2DD1 (ⷑ)
	{ 0x030c, 0x039c, 0x0c63, 0x0fff, 0x0c63, 0x0380, 0x07c0, 0x0e60, 0x0c6c, 0x0c7c, 0x0c6c, 0x0c60, 0x6c60, 0x7c60, 0x6000, 0x0000 },	// U+2DD2 (ⷒ)
	{ 0x030c, 0x039c, 0x0c63, 0x0fff, 0x0c63, 0x0380, 0x07c0, 0x0e60, 0x0c60, 0x0c60, 0x0c00, 0x0c00, 0x0c00, 0x0c00, 0x0000, 0x0000 },	// U+2DD3 (ⷓ)
	{ 0x030c, 0x039c, 0x0c63, 0x0fff, 0x0c63, 0x0380, 0x07c0, 0x0e60, 0x0c60, 0x0c60, 0x0c60, 0x7c60, 0x4c60, 0x7c60, 0x0000, 0x0000 },	// U+2DD4 (ⷔ)
	{ 0x030c, 0x039c, 0x0c63, 0x0fff, 0x0c63, 0x03c0, 0x07f0, 0x0e18, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0c60, 0x0000, 0x0000 },	// U+2DD5 (ⷕ)
	{ 0x030c, 0x039c, 0x0c63, 0x0fff, 0x0c63, 0x0380, 0x07c0, 0x0e60, 0x0c60, 0x0c60, 0x0060, 0x0060, 0x0060, 0x0060, 0x0000, 0x0000 },	// U+2DD6 (ⷖ)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x77b6, 0x7bb6, 0x7bc6, 0x7ffe, 0x0000 },	// U+2DD7 (⷗)
	{ 0x0000, 0x0000, 0x0618, 0x0738, 0x03f0, 0x01e0, 0x01fc, 0x030c, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0000, 0x0000 },	// U+2DD8 (ⷘ)
	{ 0x0000, 0x0000, 0x030c, 0x039c, 0x01f8, 0x00f0, 0x00fe, 0x0186, 0x0f80, 0x0d80, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+2DD9 (ⷙ)
	{ 0x0000, 0x0000, 0x030c, 0x039c, 0x01f8, 0x00f0, 0x00fe, 0x0186, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0f80, 0x0c00, 0x0000 },	// U+2DDA (ⷚ)
	{ 0x0000, 0x0000, 0x030c, 0x039c, 0x01f8, 0x00f0, 0x00fe, 0x0186, 0x0180, 0x0180, 0x0180, 0x01c0, 0x00e0, 0x003e, 0x0006, 0x0000 },	// U+2DDB (ⷛ)
	{ 0x0000, 0x0000, 0x030c, 0x039c, 0x01f8, 0x00f0, 0x00fe, 0x0186, 0x0180, 0x0180, 0x0180, 0x0f80, 0x0980, 0x0f80, 0x0000, 0x0000 },	// U+2DDC (ⷜ)
	{ 0x0000, 0x0000, 0x030c, 0x039c, 0x01f8, 0x00f0, 0x00fc, 0x01a4, 0x01bc, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+2DDD (ⷝ)
	{ 0x030c, 0x039c, 0x01f8, 0x0060, 0x0060, 0x00f0, 0x00fe, 0x0186, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000 },	// U+2DDE (ⷞ)
	{ 0x0000, 0x7ffe, 0x7186, 0x6dbe, 0x6d86, 0x6df6, 0x7186, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+2DDF (⷟)
}; // 96

static const uint16_t unifontdw_block307[][16] = {
	{ 0x0000, 0x0100, 0x0080, 0x01c0, 0x0000, 0x07f0, 0x0080, 0x0140, 0x3ffe, 0x0140, 0x0080, 0x07f0, 0x0000, 0x01c0, 0x0080, 0x0040 },	// U+2E0E (⸎)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe },	// U+2E0F (⸏)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x0008, 0x0004, 0x0002 },	// U+2E10 (⸐)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfffe, 0x1000, 0x2000, 0x4000 },	// U+2E11 (⸑)
}; // 4

static const uint16_t unifontdw_block308[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x0800, 0x0400, 0x0220, 0x0100, 0x0080, 0x0040, 0x0220, 0x0010, 0x0008, 0x0004, 0x0000, 0x0000 },	// U+2E13 (⸓)
	{ 0x0000, 0x0000, 0x0000, 0x1000, 0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0044, 0x0024, 0x0014, 0x0008, 0x0070, 0x0000, 0x0000 },	// U+2E14 (⸔)
	{ 0x0000, 0x0000, 0x0000, 0x0700, 0x0800, 0x1400, 0x1200, 0x1100, 0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x0004, 0x0000, 0x0000 },	// U+2E15 (⸕)
}; // 3

static const uint16_t unifontdw_block309[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2E3A (⸺)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2E3B (⸻)
}; // 2

static const uint16_t unifontdw_block310[][16] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0018, 0x0018, 0x7ff8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2E43 (⹃)
}; // 1

static const uint16_t unifontdw_block311[][16] = {
	{ 0x0000, 0x07fc, 0x01f0, 0x10e0, 0x10e0, 0x18e0, 0x1fe0, 0x1fe0, 0x1fe0, 0x18e0, 0x10e0, 0x10e0, 0x01f0, 0x07fc, 0x0000, 0x0000 },	// U+2E50 (⹐)
	{ 0x0000, 0x1ff0, 0x07c0, 0x0384, 0x0384, 0x038c, 0x03fc, 0x03fc, 0x03fc, 0x038c, 0x0384, 0x0384, 0x07c0, 0x1ff0, 0x0000, 0x0000 },	// U+2E51 (⹑)
}; // 2

static const uint16_t unifontdw_block312[][16] = {
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x6386, 0x6fbe, 0x7186, 0x7ffe, 0x0000 },	// U+2E53 (⹓)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x6186, 0x6fbe, 0x6f86, 0x7ffe, 0x0000 },	// U+2E54 (⹔)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x6186, 0x6fbe, 0x6186, 0x7ffe, 0x0000 },	// U+2E55 (⹕)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x7186, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+2E56 (⹖)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x7786, 0x7bbe, 0x7b86, 0x7ffe, 0x0000 },	// U+2E57 (⹗)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x7386, 0x6dbe, 0x7386, 0x7ffe, 0x0000 },	// U+2E58 (⹘)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6386, 0x6fbe, 0x7386, 0x7ffe, 0x0000 },	// U+2E59 (⹙)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x6186, 0x6dbe, 0x6d86, 0x7ffe, 0x0000 },	// U+2E5A (⹚)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x7186, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+2E5B (⹛)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7d86, 0x7dbe, 0x6386, 0x7ffe, 0x0000 },	// U+2E5C (⹜)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6d86, 0x6dbe, 0x7186, 0x7ffe, 0x0000 },	// U+2E5D (⹝)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x6186, 0x7ffe, 0x0000 },	// U+2E5E (⹞)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x7186, 0x7dbe, 0x7d86, 0x7ffe, 0x0000 },	// U+2E5F (⹟)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x73ce, 0x6df6, 0x6dc6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+2E60 (⹠)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x77ce, 0x73f6, 0x77c6, 0x77b6, 0x63ce, 0x7ffe, 0x0000 },	// U+2E61 (⹡)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x61ce, 0x6ff6, 0x61c6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+2E62 (⹢)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x71ce, 0x6ff6, 0x63c6, 0x6fb6, 0x71ce, 0x7ffe, 0x0000 },	// U+2E63 (⹣)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6dce, 0x6df6, 0x61c6, 0x6fb6, 0x6fce, 0x7ffe, 0x0000 },	// U+2E64 (⹤)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x61c6, 0x6fb6, 0x61ce, 0x7ffe, 0x0000 },	// U+2E65 (⹥)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x73ce, 0x7df6, 0x71c6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+2E66 (⹦)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x61ce, 0x6ff6, 0x77c6, 0x7bb6, 0x7bce, 0x7ffe, 0x0000 },	// U+2E67 (⹧)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x73ce, 0x6df6, 0x73c6, 0x6db6, 0x73ce, 0x7ffe, 0x0000 },	// U+2E68 (⹨)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x73ce, 0x6df6, 0x63c6, 0x6fb6, 0x73ce, 0x7ffe, 0x0000 },	// U+2E69 (⹩)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x61ce, 0x6df6, 0x61c6, 0x6db6, 0x6dce, 0x7ffe, 0x0000 },	// U+2E6A (⹪)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x71ce, 0x6df6, 0x71c6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+2E6B (⹫)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x63ce, 0x7df6, 0x7dc6, 0x7db6, 0x63ce, 0x7ffe, 0x0000 },	// U+2E6C (⹬)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x71ce, 0x6df6, 0x6dc6, 0x6db6, 0x71ce, 0x7ffe, 0x0000 },	// U+2E6D (⹭)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x61ce, 0x7ffe, 0x0000 },	// U+2E6E (⹮)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x61ce, 0x7df6, 0x71c6, 0x7db6, 0x7dce, 0x7ffe, 0x0000 },	// U+2E6F (⹯)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x6dde, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+2E70 (⹰)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7786, 0x73be, 0x77de, 0x77ee, 0x63ee, 0x7ffe, 0x0000 },	// U+2E71 (⹱)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x61de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+2E72 (⹲)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7186, 0x6fbe, 0x63de, 0x6fee, 0x71ee, 0x7ffe, 0x0000 },	// U+2E73 (⹳)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6d86, 0x6dbe, 0x61de, 0x6fee, 0x6fee, 0x7ffe, 0x0000 },	// U+2E74 (⹴)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x61de, 0x6fee, 0x61ee, 0x7ffe, 0x0000 },	// U+2E75 (⹵)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7386, 0x7dbe, 0x71de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+2E76 (⹶)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x6fbe, 0x77de, 0x7bee, 0x7bee, 0x7ffe, 0x0000 },	// U+2E77 (⹷)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x73de, 0x6dee, 0x73ee, 0x7ffe, 0x0000 },	// U+2E78 (⹸)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7386, 0x6dbe, 0x63de, 0x6fee, 0x73ee, 0x7ffe, 0x0000 },	// U+2E79 (⹹)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x6dbe, 0x61de, 0x6dee, 0x6dee, 0x7ffe, 0x0000 },	// U+2E7A (⹺)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x71de, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+2E7B (⹻)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6386, 0x7dbe, 0x7dde, 0x7dee, 0x63ee, 0x7ffe, 0x0000 },	// U+2E7C (⹼)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7186, 0x6dbe, 0x6dde, 0x6dee, 0x71ee, 0x7ffe, 0x0000 },	// U+2E7D (⹽)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x61ee, 0x7ffe, 0x0000 },	// U+2E7E (⹾)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x7dbe, 0x71de, 0x7dee, 0x7dee, 0x7ffe, 0x0000 },	// U+2E7F (⹿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0070, 0x0180, 0x0600, 0x0800, 0x0038, 0x00c0, 0x0300, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2E80 (⺀)
	{ 0x0000, 0x3e00, 0x01f8, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0004, 0x0004, 0x0004, 0x0002, 0x0001 },	// U+2E81 (⺁)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ffc, 0x1000, 0x1000, 0x0800, 0x0800, 0x0400, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2E82 (⺂)
	{ 0x0000, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0808, 0x0808, 0x0808, 0x0ff0 },	// U+2E83 (⺃)
	{ 0x0000, 0x0000, 0x07ff, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0800, 0x4800, 0x5000, 0x6000, 0x4000 },	// U+2E84 (⺄)
	{ 0x0200, 0x0200, 0x0100, 0x0080, 0x0080, 0x00c0, 0x00a0, 0x0090, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080 },	// U+2E85 (⺅)
	{ 0x0000, 0x0ff0, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0808, 0x0808, 0x0808, 0x0a04, 0x0402 },	// U+2E86 (⺆)
	{ 0x0000, 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x1004, 0x5004, 0x5004, 0x6002, 0x4001 },	// U+2E87 (⺇)
	{ 0x0020, 0x0020, 0x0fe0, 0x0410, 0x0210, 0x0008, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2E88 (⺈)
	{ 0x2000, 0x2000, 0x2000, 0x2200, 0x2200, 0x2200, 0x2200, 0x2200, 0x2200, 0x2200, 0x2200, 0x2200, 0x2000, 0x2000, 0x2800, 0x1000 },	// U+2E89 (⺉)
	{ 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0fe0, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020 },	// U+2E8A (⺊)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ffc, 0x0804, 0x0804, 0x0804, 0x0a04, 0x0404, 0x2004, 0x2004, 0x3ff8 },	// U+2E8B (⺋)
	{ 0x0080, 0x0888, 0x0490, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2E8C (⺌)
	{ 0x1040, 0x1084, 0x0908, 0x0410, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2E8D (⺍)
	{ 0x0000, 0x0000, 0x0000, 0x7fff, 0x0220, 0x0220, 0x0220, 0x0220, 0x0220, 0x0210, 0x0210, 0x4208, 0x4208, 0x4204, 0x7c02, 0x0001 },	// U+2E8E (⺎)
	{ 0x0440, 0x0840, 0x1020, 0x2010, 0x4008, 0x4426, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x4410, 0x4410, 0x4408, 0x7806 },	// U+2E8F (⺏)
	{ 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x7fff, 0x0240, 0x0240, 0x0240, 0x0220, 0x0220, 0x0210, 0x4210, 0x4208, 0x4204, 0x7c03 },	// U+2E90 (⺐)
	{ 0x0440, 0x0840, 0x1020, 0x2010, 0x4008, 0x47e6, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x4410, 0x4410, 0x4408, 0x7806 },	// U+2E91 (⺑)
	{ 0x0000, 0x0000, 0x0ffc, 0x0804, 0x0804, 0x0804, 0x0804, 0x0ffc, 0x0004, 0x0004, 0x0004, 0x2004, 0x2004, 0x2004, 0x3ff8, 0x0000 },	// U+2E92 (⺒)
	{ 0x0000, 0x0080, 0x0080, 0x0840, 0x0820, 0x0410, 0x0208, 0x01f8, 0x0080, 0x0040, 0x0420, 0x0810, 0x1008, 0x3ffc, 0x2000, 0x2000 },	// U+2E93 (⺓)
	{ 0x0000, 0x0020, 0x0020, 0x0020, 0x0fe0, 0x0420, 0x0410, 0x0410, 0x0410, 0x0210, 0x03f8, 0x0200, 0x0200, 0x0200, 0x3ffe, 0x0000 },	// U+2E94 (⺔)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x1ffc, 0x1000, 0x1000, 0x1ffc, 0x1000, 0x1000, 0x1000, 0x1ffc, 0x1000, 0x0000, 0x0000, 0x0000 },	// U+2E95 (⺕)
	{ 0x0010, 0x0010, 0x0010, 0x0010, 0x0030, 0x0052, 0x0052, 0x0011, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010 },	// U+2E96 (⺖)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0040, 0x0440, 0x0940, 0x1248, 0x2448, 0x2844, 0x0844, 0x0042, 0x0050, 0x0020 },	// U+2E97 (⺗)
	{ 0x0080, 0x0080, 0x0080, 0x03f8, 0x0080, 0x0080, 0x0080, 0x0380, 0x00e0, 0x0098, 0x0080, 0x0080, 0x0080, 0x0080, 0x00a0, 0x0040 },	// U+2E98 (⺘)
	{ 0x0010, 0x0010, 0x0010, 0x3ff0, 0x0818, 0x0824, 0x0422, 0x0441, 0x0280, 0x0100, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x6007 },	// U+2E99 (⺙)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x61ce, 0x6db6, 0x618e, 0x6dbe, 0x6dce, 0x7ffe, 0x0000 },	// U+2E9A (⺚)
	{ 0x0ffc, 0x0040, 0x0040, 0x0042, 0x0042, 0x3ffe, 0x0120, 0x0120, 0x0120, 0x0110, 0x0110, 0x2108, 0x2104, 0x3e02, 0x0001, 0x0000 },	// U+2E9B (⺛)
	{ 0x1ffc, 0x1004, 0x17f4, 0x1004, 0x17f4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2E9C (⺜)
	{ 0x0000, 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0808, 0x0a08, 0x0408 },	// U+2E9D (⺝)
	{ 0x0100, 0x0100, 0x7f00, 0x0110, 0x0110, 0x1ff0, 0x1008, 0x0828, 0x0844, 0x0482, 0x0280, 0x0100, 0x0080, 0x0040, 0x0030, 0x000e },	// U+2E9E (⺞)
	{ 0x0000, 0x0ff8, 0x0808, 0x0848, 0x0888, 0x0888, 0x7fff, 0x0804, 0x0844, 0x0884, 0x0884, 0x3ffc, 0x0800, 0x0800, 0x0500, 0x0200 },	// U+2E9F (⺟)
	{ 0x0000, 0x0800, 0x1ffc, 0x1004, 0x1004, 0x1004, 0x1ffc, 0x0004, 0x1104, 0x3ffc, 0x0104, 0x0204, 0x0404, 0x0804, 0x701c, 0x200c },	// U+2EA0 (⺠)
	{ 0x0004, 0x0008, 0x0008, 0x0001, 0x0002, 0x0012, 0x0010, 0x0008, 0x0008, 0x0007, 0x0004, 0x0004, 0x0004, 0x0004, 0x0000, 0x0000 },	// U+2EA1 (⺡)
	{ 0x0080, 0x0080, 0x0080, 0x1084, 0x0888, 0x0490, 0x0080, 0x0280, 0x04a0, 0x0890, 0x1088, 0x2087, 0x2082, 0x0080, 0x00a0, 0x0040 },	// U+2EA2 (⺢)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1124, 0x2244, 0x2242, 0x2001, 0x0000, 0x0000 },	// U+2EA3 (⺣)
	{ 0x0800, 0x3e00, 0x01e0, 0x101f, 0x1084, 0x0918, 0x0910, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EA4 (⺤)
	{ 0x3e00, 0x09f8, 0x0888, 0x0888, 0x1084, 0x2084, 0x4002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EA5 (⺥)
	{ 0x0040, 0x0040, 0x0040, 0x0044, 0x0048, 0x0050, 0x0040, 0x0040, 0x0060, 0x0050, 0x0048, 0x0046, 0x0044, 0x0040, 0x0040, 0x0040 },	// U+2EA6 (⺦)
	{ 0x0080, 0x0088, 0x1ff8, 0x0084, 0x0080, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EA7 (⺧)
	{ 0x0022, 0x0014, 0x0008, 0x0014, 0x0012, 0x0011, 0x0010, 0x0018, 0x0014, 0x0012, 0x0011, 0x0010, 0x0010, 0x000a, 0x0004, 0x0000 },	// U+2EA8 (⺨)
	{ 0x007f, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x007f, 0x0008, 0x0008, 0x0008, 0x0008, 0x0068, 0x001c, 0x0003, 0x0000, 0x0000 },	// U+2EA9 (⺩)
	{ 0x0000, 0x0000, 0x003f, 0x0010, 0x0008, 0x0008, 0x0008, 0x003a, 0x000a, 0x000a, 0x000a, 0x000a, 0x003a, 0x000f, 0x0002, 0x0000 },	// U+2EAA (⺪)
	{ 0x1ffc, 0x1224, 0x1224, 0x1224, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EAB (⺫)
	{ 0x0000, 0x007e, 0x0000, 0x0000, 0x007f, 0x0008, 0x0008, 0x002a, 0x004a, 0x004a, 0x0009, 0x0008, 0x0008, 0x0008, 0x000a, 0x0004 },	// U+2EAC (⺬)
	{ 0x0004, 0x0008, 0x0008, 0x001f, 0x0010, 0x0008, 0x0008, 0x001c, 0x002a, 0x0029, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008 },	// U+2EAD (⺭)
	{ 0x0000, 0x0208, 0x0208, 0x0208, 0x7f7c, 0x0914, 0x0892, 0x0851, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EAE (⺮)
	{ 0x0010, 0x0010, 0x0008, 0x0048, 0x0044, 0x003e, 0x0010, 0x0008, 0x0024, 0x007e, 0x0040, 0x0000, 0x004a, 0x0092, 0x0091, 0x0000 },	// U+2EAF (⺯)
	{ 0x0008, 0x0008, 0x0004, 0x0024, 0x0022, 0x001f, 0x0008, 0x0004, 0x0002, 0x003f, 0x0002, 0x0000, 0x0038, 0x0007, 0x0002, 0x0000 },	// U+2EB0 (⺰)
	{ 0x1ffc, 0x1004, 0x1224, 0x1144, 0x1084, 0x1144, 0x1224, 0x1004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EB1 (⺱)
	{ 0x1ffc, 0x1224, 0x1224, 0x1224, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EB2 (⺲)
	{ 0x0000, 0x3ffc, 0x2004, 0x1002, 0x0220, 0x0410, 0x0808, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EB3 (⺳)
	{ 0x0000, 0x7ffe, 0x2222, 0x1221, 0x0220, 0x0220, 0x0220, 0x0220, 0x0220, 0x0220, 0x0210, 0x4210, 0x4208, 0x4208, 0x4204, 0x7c02 },	// U+2EB4 (⺴)
	{ 0x0000, 0x0000, 0x0000, 0x3ffc, 0x2244, 0x2244, 0x2244, 0x2244, 0x2244, 0x2244, 0x2244, 0x2244, 0x2244, 0x2004, 0x0000, 0x0000 },	// U+2EB5 (⺵)
	{ 0x0808, 0x0410, 0x1ffc, 0x0080, 0x0ff8, 0x0080, 0x0040, 0x7fff, 0x0020, 0x0010, 0x0008, 0x0007, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EB6 (⺶)
	{ 0x0410, 0x0220, 0x3ffe, 0x0080, 0x0ff8, 0x0080, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EB7 (⺷)
	{ 0x0220, 0x0220, 0x0220, 0x3e3e, 0x0220, 0x0220, 0x0000, 0x7fff, 0x0080, 0x0080, 0x1ffc, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080 },	// U+2EB8 (⺸)
	{ 0x0040, 0x1040, 0x13fc, 0x0840, 0x0440, 0x7fff, 0x0100, 0x0080, 0x0040, 0x0030, 0x000c, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EB9 (⺹)
	{ 0x0080, 0x0080, 0x1ffc, 0x1080, 0x7fff, 0x1080, 0x1ffc, 0x1080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080 },	// U+2EBA (⺺)
	{ 0x0080, 0x0080, 0x1ff8, 0x1080, 0x7fff, 0x1080, 0x1ff8, 0x0080, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EBB (⺻)
	{ 0x1fe0, 0x1020, 0x10a0, 0x1120, 0x1220, 0x1620, 0x1020, 0x1820, 0x1420, 0x1220, 0x11a0, 0x1110, 0x1010, 0x1008, 0x1404, 0x0802 },	// U+2EBC (⺼)
	{ 0x0040, 0x0030, 0x3e0e, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x3f3e, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x3f3e, 0x2002 },	// U+2EBD (⺽)
	{ 0x0410, 0x0410, 0x7fff, 0x0410, 0x0410, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EBE (⺾)
	{ 0x0410, 0x0410, 0x7f7f, 0x0410, 0x0410, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EBF (⺿)
	{ 0x0000, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x7c1f, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0000 },	// U+2EC0 (⻀)
	{ 0x0080, 0x1f80, 0x0080, 0x3ffc, 0x2084, 0x0684, 0x11f4, 0x1084, 0x1f04, 0x0004, 0x07c4, 0x0444, 0x0444, 0x2422, 0x2412, 0x3809 },	// U+2EC1 (⻁)
	{ 0x0004, 0x0008, 0x0000, 0x003f, 0x0010, 0x0008, 0x0008, 0x002c, 0x001a, 0x0029, 0x0028, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008 },	// U+2EC2 (⻂)
	{ 0x3ffe, 0x0220, 0x0220, 0x1ffc, 0x1224, 0x1224, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2EC3 (⻃)
	{ 0x0000, 0x0000, 0x7fff, 0x0120, 0x0120, 0x0120, 0x3ffe, 0x2122, 0x2122, 0x2122, 0x2122, 0x2912, 0x2f12, 0x200a, 0x2002, 0x3ffe },	// U+2EC4 (⻄)
	{ 0x0ff8, 0x0808, 0x0808, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0948, 0x0948, 0x0120, 0x0120, 0x4110, 0x410c, 0x7e03, 0x0000 },	// U+2EC5 (⻅)
	{ 0x0010, 0x0010, 0x07f8, 0x0404, 0x0202, 0x1ffd, 0x1084, 0x1084, 0x1ffc, 0x1084, 0x1084, 0x1ffc, 0x1084, 0x1082, 0x1482, 0x0801 },	// U+2EC6 (⻆)
	{ 0x0020, 0x0020, 0x0fe0, 0x0410, 0x0208, 0x1ffc, 0x108a, 0x1188, 0x1248, 0x14a8, 0x1198, 0x1248, 0x1428, 0x1018, 0x1408, 0x0808 },	// U+2EC7 (⻇)
	{ 0x0004, 0x0008, 0x0008, 0x0000, 0x0000, 0x000f, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0028, 0x0018, 0x0008, 0x0000, 0x0000 },	// U+2EC8 (⻈)
	{ 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0848, 0x0140, 0x0220, 0x0410, 0x0808, 0x1004, 0x0000 },	// U+2EC9 (⻉)
	{ 0x0000, 0x00fe, 0x0082, 0x0082, 0x0082, 0x00fe, 0x0092, 0x0010, 0x0010, 0x00f2, 0x0012, 0x0012, 0x0012, 0x00f2, 0x000f, 0x0002 },	// U+2ECA (⻊)
	{ 0x0040, 0x0040, 0x0040, 0x3ffe, 0x0020, 0x0090, 0x0088, 0x0084, 0x1ffc, 0x0080, 0x0080, 0x7fff, 0x0080, 0x0080, 0x0080, 0x0080 },	// U+2ECB (⻋)
	{ 0x0004, 0x0008, 0x0008, 0x0000, 0x0000, 0x000f, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0014, 0x7fe2, 0x0000, 0x0000 },	// U+2ECC (⻌)
	{ 0x0004, 0x0008, 0x0010, 0x0002, 0x0004, 0x0008, 0x0000, 0x000f, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0014, 0x0022, 0x7fc1 },	// U+2ECD (⻍)
	{ 0x0000, 0x0004, 0x0008, 0x0000, 0x0000, 0x001f, 0x0010, 0x0008, 0x0004, 0x001e, 0x0010, 0x0010, 0x0008, 0x0008, 0x0014, 0x7fe3 },	// U+2ECE (⻎)
	{ 0x0000, 0x3c00, 0x2400, 0x1400, 0x1400, 0x0c00, 0x1400, 0x2400, 0x2400, 0x2400, 0x2c00, 0x1400, 0x0400, 0x0400, 0x0400, 0x0400 },	// U+2ECF (⻏)
	{ 0x0008, 0x0008, 0x0078, 0x0004, 0x0004, 0x003e, 0x0009, 0x0008, 0x007f, 0x0008, 0x0008, 0x0048, 0x0028, 0x0018, 0x0008, 0x0000 },	// U+2ED0 (⻐)
	{ 0x1ff0, 0x0010, 0x0ff0, 0x0010, 0x0ff0, 0x0010, 0x7fff, 0x0048, 0x0888, 0x0508, 0x0208, 0x0448, 0x1828, 0x6018, 0x0008, 0x0000 },	// U+2ED1 (⻑)
	{ 0x1ff0, 0x0010, 0x0010, 0x0ff0, 0x0010, 0x0010, 0x0ff0, 0x0010, 0x0010, 0x7fff, 0x0020, 0x0410, 0x0808, 0x1ffc, 0x1008, 0x0000 },	// U+2ED2 (⻒)
	{ 0x0010, 0x0810, 0x0410, 0x0210, 0x0110, 0x0090, 0x0010, 0x7fff, 0x0050, 0x0090, 0x0110, 0x0210, 0x0490, 0x1850, 0x6030, 0x0010 },	// U+2ED3 (⻓)
	{ 0x0004, 0x3fc8, 0x2008, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2802, 0x1002 },	// U+2ED4 (⻔)
	{ 0x0040, 0x0020, 0x0ff8, 0x0808, 0x0808, 0x0ff8, 0x0008, 0x1ff8, 0x1008, 0x1008, 0x1ff8, 0x0008, 0x1ff8, 0x1008, 0x1008, 0x1ff8 },	// U+2ED5 (⻕)
	{ 0x001f, 0x0011, 0x0009, 0x0009, 0x0005, 0x0009, 0x0009, 0x0011, 0x0011, 0x0011, 0x0011, 0x000f, 0x0001, 0x0001, 0x0001, 0x0001 },	// U+2ED6 (⻖)
	{ 0x3ffe, 0x0080, 0x7fff, 0x4889, 0x46b1, 0x0080, 0x0eb8, 0x3086, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2ED7 (⻗)
	{ 0x0040, 0x0040, 0x1ffe, 0x0040, 0x0ffc, 0x0040, 0x3fff, 0x0000, 0x07f8, 0x0408, 0x07f8, 0x0408, 0x07f8, 0x0408, 0x0408, 0x0308 },	// U+2ED8 (⻘)
	{ 0x0080, 0x0080, 0x2080, 0x7fff, 0x0080, 0x0880, 0x1ffc, 0x0080, 0x2080, 0x7ffe, 0x2080, 0x2080, 0x2080, 0x1480, 0x0880, 0x0080 },	// U+2ED9 (⻙)
	{ 0x3ffe, 0x0040, 0x0020, 0x0ff8, 0x0808, 0x0888, 0x0888, 0x0888, 0x0888, 0x0888, 0x0948, 0x0240, 0x0420, 0x0818, 0x1006, 0x0000 },	// U+2EDA (⻚)
	{ 0x0ffc, 0x0804, 0x0804, 0x0a14, 0x0a24, 0x0944, 0x0944, 0x0884, 0x0884, 0x0944, 0x4944, 0x5224, 0x5212, 0x6002, 0x4001, 0x0000 },	// U+2EDB (⻛)
	{ 0x03ff, 0x0200, 0x2200, 0x1200, 0x0a00, 0x0600, 0x0a00, 0x1200, 0x2200, 0x0400, 0x0400, 0x4800, 0x5000, 0x6000, 0x4000, 0x0000 },	// U+2EDC (⻜)
	{ 0x0080, 0x0140, 0x0220, 0x0450, 0x188c, 0x6ffb, 0x0808, 0x0ff8, 0x0808, 0x0ff8, 0x1008, 0x0988, 0x0608, 0x0848, 0x1028, 0x2018 },	// U+2EDD (⻝)
	{ 0x0010, 0x0010, 0x0028, 0x0048, 0x0094, 0x007e, 0x0045, 0x007c, 0x0044, 0x007c, 0x0004, 0x007c, 0x0004, 0x0004, 0x007c, 0x0004 },	// U+2EDE (⻞)
	{ 0x0010, 0x0010, 0x0028, 0x0048, 0x0094, 0x007e, 0x0045, 0x007c, 0x0044, 0x007c, 0x0004, 0x0014, 0x0024, 0x0054, 0x004c, 0x0004 },	// U+2EDF (⻟)
	{ 0x0004, 0x0004, 0x0004, 0x007c, 0x0022, 0x0012, 0x0001, 0x0008, 0x0008, 0x0008, 0x0008, 0x0048, 0x0028, 0x0018, 0x0008, 0x0000 },	// U+2EE0 (⻠)
	{ 0x1110, 0x1110, 0x0888, 0x0444, 0x0888, 0x1110, 0x7fff, 0x0040, 0x0ff8, 0x0808, 0x0ff8, 0x0808, 0x0ff8, 0x0808, 0x0ff8, 0x0808 },	// U+2EE1 (⻡)
	{ 0x07fe, 0x0400, 0x0400, 0x0408, 0x0408, 0x0408, 0x3ff8, 0x2000, 0x2000, 0x2000, 0x27ff, 0x2000, 0x2000, 0x1400, 0x0800, 0x0000 },	// U+2EE2 (⻢)
	{ 0x0ff8, 0x0808, 0x09f8, 0x0908, 0x0908, 0x7ffe, 0x4002, 0x2ff9, 0x0808, 0x0ff8, 0x0808, 0x0ff8, 0x0808, 0x0808, 0x0a08, 0x0408 },	// U+2EE3 (⻣)
	{ 0x0040, 0x0020, 0x1ffc, 0x1084, 0x1084, 0x1ffc, 0x1044, 0x1044, 0x1ffc, 0x08a0, 0x0490, 0x1290, 0x3e88, 0x4084, 0x4082, 0x7f01 },	// U+2EE4 (⻤)
	{ 0x0020, 0x0020, 0x07f0, 0x0408, 0x0204, 0x1ffe, 0x1085, 0x1084, 0x1ffc, 0x1084, 0x1084, 0x1ffc, 0x0000, 0x0000, 0x7fff, 0x0000 },	// U+2EE5 (⻥)
	{ 0x0080, 0x0040, 0x0ff8, 0x0808, 0x0848, 0x0888, 0x0a88, 0x0408, 0x0008, 0x3ff8, 0x2000, 0x2000, 0x27fe, 0x2000, 0x1400, 0x0800 },	// U+2EE6 (⻦)
	{ 0x0080, 0x0080, 0x7f80, 0x0080, 0x0080, 0x1ffc, 0x1004, 0x1414, 0x1224, 0x1144, 0x1084, 0x1144, 0x1224, 0x1414, 0x1ffc, 0x1004 },	// U+2EE7 (⻧)
	{ 0x0080, 0x0080, 0x3ffe, 0x0080, 0x0080, 0x1ffc, 0x0080, 0x0080, 0x7fff, 0x0010, 0x0ff8, 0x0414, 0x0222, 0x01c0, 0x0e38, 0x7007 },	// U+2EE8 (⻨)
	{ 0x0220, 0x1ffc, 0x0220, 0x0220, 0x7fff, 0x0080, 0x0ff8, 0x0888, 0x0888, 0x0ff8, 0x0888, 0x0888, 0x0ff8, 0x0220, 0x0410, 0x0808 },	// U+2EE9 (⻩)
	{ 0x0ff8, 0x0808, 0x0808, 0x0ff8, 0x0080, 0x1ffc, 0x1084, 0x1084, 0x1ffc, 0x1084, 0x1084, 0x1ffc, 0x5084, 0x4080, 0x4080, 0x7f00 },	// U+2EEA (⻪)
	{ 0x0040, 0x0080, 0x3ffe, 0x0410, 0x0220, 0x01c0, 0x0e38, 0x780f, 0x0808, 0x0ff8, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0804, 0x0802 },	// U+2EEB (⻫)
	{ 0x0040, 0x0080, 0x3ffe, 0x0410, 0x0220, 0x01c0, 0x0630, 0x180c, 0x6413, 0x0410, 0x0410, 0x0410, 0x0410, 0x0408, 0x0408, 0x0404 },	// U+2EEC (⻬)
	{ 0x0080, 0x0080, 0x1f88, 0x0088, 0x0088, 0x7fff, 0x0000, 0x1494, 0x12a4, 0x11c4, 0x1ffc, 0x11c4, 0x12a4, 0x1494, 0x1084, 0x1ffc },	// U+2EED (⻭)
	{ 0x0080, 0x0080, 0x1f88, 0x0088, 0x0088, 0x0088, 0x7fff, 0x0000, 0x1084, 0x1084, 0x1144, 0x1224, 0x1414, 0x1004, 0x1ffc, 0x1000 },	// U+2EEE (⻮)
	{ 0x0040, 0x0080, 0x3ffe, 0x0808, 0x0410, 0x7fff, 0x0080, 0x0ff8, 0x0888, 0x0ff8, 0x0888, 0x0888, 0x0ff8, 0x4888, 0x4080, 0x7f00 },	// U+2EEF (⻯)
	{ 0x0420, 0x0820, 0x0820, 0x0020, 0x7fff, 0x0120, 0x1120, 0x1120, 0x0920, 0x0510, 0x0310, 0x4108, 0x4188, 0x4144, 0x7e22, 0x0001 },	// U+2EF0 (⻰)
	{ 0x0020, 0x1ffc, 0x1004, 0x1f7c, 0x0140, 0x015e, 0x3f50, 0x297f, 0x2b50, 0x255e, 0x2540, 0x2b5e, 0x2950, 0x3f7f, 0x4150, 0x7f9e },	// U+2EF1 (⻱)
	{ 0x0020, 0x03f0, 0x0108, 0x0ffc, 0x088b, 0x0ff8, 0x0888, 0x0ff8, 0x0080, 0x1ffc, 0x1084, 0x1ffc, 0x1084, 0x1ffc, 0x4080, 0x7f00 },	// U+2EF2 (⻲)
	{ 0x0020, 0x0020, 0x07f0, 0x0408, 0x0204, 0x1ffe, 0x1085, 0x1084, 0x1ffc, 0x1084, 0x1084, 0x1ffc, 0x1084, 0x4080, 0x4080, 0x7f00 },	// U+2EF3 (⻳)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6ff6, 0x7ffe, 0x0000 },	// U+2EF4 (⻴)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x61f6, 0x7ffe, 0x0000 },	// U+2EF5 (⻵)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+2EF6 (⻶)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7bf6, 0x7ffe, 0x0000 },	// U+2EF7 (⻷)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x73f6, 0x7ffe, 0x0000 },	// U+2EF8 (⻸)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x73f6, 0x7ffe, 0x0000 },	// U+2EF9 (⻹)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6df6, 0x7ffe, 0x0000 },	// U+2EFA (⻺)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+2EFB (⻻)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+2EFC (⻼)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+2EFD (⻽)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+2EFE (⻾)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x6186, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+2EFF (⻿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2F00 (⼀)
	{ 0x0080, 0x0180, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+2F01 (⼁)
	{ 0x0000, 0x0000, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2F02 (⼂)
	{ 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0020, 0x0020, 0x0010, 0x0008, 0x0004, 0x0000 },	// U+2F03 (⼃)
	{ 0x0200, 0x07fc, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x2004, 0x2004, 0x6004, 0x3ff8, 0x0000, 0x0000, 0x0000 },	// U+2F04 (⼄)
	{ 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x03c0, 0x0200, 0x0000, 0x0000 },	// U+2F05 (⼅)
	{ 0x0800, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2F06 (⼆)
	{ 0x0000, 0x0000, 0x0080, 0x0100, 0x2100, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2F07 (⼇)
	{ 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x7004, 0x2002, 0x0000 },	// U+2F08 (⼈)
	{ 0x0210, 0x0630, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0208, 0x2208, 0x2204, 0x6202, 0x3c01, 0x0000 },	// U+2F09 (⼉)
	{ 0x0078, 0x0080, 0x0080, 0x0080, 0x0080, 0x0140, 0x0140, 0x0220, 0x0220, 0x0410, 0x0808, 0x3004, 0x6002, 0x4001, 0x0000, 0x0000 },	// U+2F0A (⼊)
	{ 0x0300, 0x0200, 0x0200, 0x0260, 0x0220, 0x0220, 0x0420, 0x0410, 0x0410, 0x0810, 0x0808, 0x1008, 0x2004, 0x6002, 0x4001, 0x0000 },	// U+2F0B (⼋)
	{ 0x2004, 0x7ffc, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2404, 0x3804, 0x1004, 0x0000 },	// U+2F0C (⼌)
	{ 0x0000, 0x0000, 0x0000, 0x4004, 0x7ffc, 0x2004, 0x1002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2F0D (⼍)
	{ 0x0020, 0x00c0, 0x0080, 0x0000, 0x0200, 0x0100, 0x0100, 0x0080, 0x0080, 0x0060, 0x0040, 0x0040, 0x0040, 0x0040, 0x0000, 0x0000 },	// U+2F0E (⼎)
	{ 0x0400, 0x0ff0, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x4410, 0x4408, 0x4404, 0x7802, 0x0000 },	// U+2F0F (⼏)
	{ 0x2004, 0x600c, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x3ffc, 0x2004, 0x0000, 0x0000 },	// U+2F10 (⼐)
	{ 0x2000, 0x7ffc, 0x2080, 0x2080, 0x2080, 0x2080, 0x2080, 0x2080, 0x2040, 0x2040, 0x2020, 0x2020, 0x2210, 0x1c08, 0x0806, 0x0000 },	// U+2F11 (⼑)
	{ 0x0080, 0x0080, 0x0080, 0x1080, 0x3ffc, 0x1080, 0x1080, 0x1080, 0x1080, 0x1040, 0x1040, 0x1020, 0x1110, 0x0e08, 0x0406, 0x0000 },	// U+2F12 (⼒)
	{ 0x0008, 0x0008, 0x2008, 0x7ff8, 0x2008, 0x2004, 0x2002, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2200, 0x1c00, 0x0800, 0x0000 },	// U+2F13 (⼓)
	{ 0x0010, 0x0030, 0x0010, 0x0810, 0x0410, 0x0210, 0x0190, 0x0050, 0x0030, 0x001c, 0x0013, 0x2010, 0x2010, 0x6010, 0x3fe0, 0x0000 },	// U+2F14 (⼔)
	{ 0x1004, 0x3ffc, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x1004, 0x3ffc, 0x0004, 0x0000, 0x0000 },	// U+2F15 (⼕)
	{ 0x3ffe, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x1004, 0x3ffc, 0x0000, 0x0000, 0x0000 },	// U+2F16 (⼖)
	{ 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x2080, 0x7ffe, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+2F17 (⼗)
	{ 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x01c0, 0x0240, 0x0c40, 0x1840, 0x1040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0000 },	// U+2F18 (⼘)
	{ 0x0420, 0x0fe0, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420, 0x0720, 0x0220, 0x0020, 0x0020, 0x0020, 0x0020, 0x0000 },	// U+2F19 (⼙)
	{ 0x2004, 0x7ffc, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0002, 0x0002, 0x0001, 0x0000 },	// U+2F1A (⼚)
	{ 0x0180, 0x0080, 0x0080, 0x0040, 0x0040, 0x0020, 0x0020, 0x0410, 0x0810, 0x1008, 0x3f88, 0x207f, 0x2002, 0x0000, 0x0000, 0x0000 },	// U+2F1B (⼛)
	{ 0x0800, 0x1ffc, 0x0810, 0x0810, 0x0420, 0x0420, 0x0240, 0x0240, 0x0180, 0x0180, 0x0240, 0x0420, 0x7818, 0x2006, 0x0000, 0x0000 },	// U+2F1C (⼜)
	{ 0x1008, 0x3ff8, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008, 0x1ff8, 0x1008, 0x0000, 0x0000, 0x0000 },	// U+2F1D (⼝)
	{ 0x2004, 0x7ffc, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x3ffc, 0x2004, 0x0000, 0x0000 },	// U+2F1E (⼞)
	{ 0x0080, 0x0180, 0x0080, 0x0080, 0x0080, 0x1080, 0x3ffc, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x2080, 0x7ffe, 0x0000 },	// U+2F1F (⼟)
	{ 0x0080, 0x0180, 0x0080, 0x0080, 0x0080, 0x2080, 0x7ffe, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x1080, 0x3ffc, 0x0000 },	// U+2F20 (⼠)
	{ 0x0020, 0x0820, 0x1fe0, 0x0830, 0x0448, 0x0284, 0x0180, 0x0e70, 0x700e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2F21 (⼡)
	{ 0x0040, 0x0040, 0x0848, 0x1fd0, 0x0820, 0x0820, 0x0450, 0x0450, 0x0288, 0x0284, 0x0102, 0x0280, 0x0460, 0x1818, 0x6007, 0x0000 },	// U+2F22 (⼢)
	{ 0x0040, 0x0040, 0x1040, 0x3fc0, 0x1020, 0x1020, 0x0830, 0x0848, 0x0484, 0x0482, 0x0200, 0x0100, 0x0080, 0x0060, 0x001c, 0x0000 },	// U+2F23 (⼣)
	{ 0x0080, 0x0180, 0x0080, 0x0080, 0x2080, 0x7ffe, 0x0080, 0x0080, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x7004, 0x2002, 0x0000 },	// U+2F24 (⼤)
	{ 0x0040, 0x00c0, 0x0040, 0x0040, 0x2040, 0x7ffe, 0x0420, 0x0420, 0x0410, 0x0410, 0x0208, 0x0170, 0x0180, 0x0e60, 0x701e, 0x0000 },	// U+2F25 (⼥)
	{ 0x1000, 0x3ffc, 0x0800, 0x0400, 0x0300, 0x0100, 0x2100, 0x7ffe, 0x0100, 0x0100, 0x0100, 0x0100, 0x0120, 0x01c0, 0x0080, 0x0000 },	// U+2F26 (⼦)
	{ 0x0000, 0x0080, 0x0100, 0x2104, 0x7ffc, 0x2004, 0x1002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2F27 (⼧)
	{ 0x0400, 0x0400, 0x0400, 0x2400, 0x7ffe, 0x0400, 0x0400, 0x0410, 0x0420, 0x0420, 0x0420, 0x0400, 0x0480, 0x0700, 0x0200, 0x0000 },	// U+2F28 (⼨)
	{ 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0930, 0x1110, 0x2108, 0x6108, 0x4104, 0x4102, 0x0100, 0x0120, 0x01c0, 0x0080, 0x0000 },	// U+2F29 (⼩)
	{ 0x0040, 0x0040, 0x0040, 0x1040, 0x3fff, 0x0040, 0x0040, 0x0140, 0x0140, 0x0120, 0x2120, 0x2110, 0x2108, 0x6104, 0x3e03, 0x0000 },	// U+2F2A (⼪)
	{ 0x1008, 0x3ff8, 0x1008, 0x1008, 0x1008, 0x1ff8, 0x1008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0004, 0x0004, 0x0002, 0x0001, 0x0000 },	// U+2F2B (⼫)
	{ 0x0080, 0x0080, 0x0080, 0x2084, 0x2084, 0x2084, 0x2084, 0x2084, 0x3ffc, 0x2084, 0x0080, 0x0080, 0x0040, 0x0030, 0x000e, 0x0000 },	// U+2F2C (⼬)
	{ 0x0080, 0x0080, 0x0080, 0x0080, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x2082, 0x3ffe, 0x2002, 0x0000 },	// U+2F2D (⼭)
	{ 0x2220, 0x2220, 0x1110, 0x1110, 0x0888, 0x0888, 0x0444, 0x0222, 0x0444, 0x0888, 0x1110, 0x1110, 0x2220, 0x2220, 0x2220, 0x0000 },	// U+2F2E (⼮)
	{ 0x1000, 0x3ffc, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x2080, 0x7ffe, 0x0000, 0x0000, 0x0000 },	// U+2F2F (⼯)
	{ 0x0800, 0x1ffe, 0x0800, 0x0800, 0x0800, 0x0800, 0x0ffc, 0x0804, 0x0004, 0x0004, 0x0004, 0x2004, 0x2004, 0x6004, 0x3ff8, 0x0000 },	// U+2F30 (⼰)
	{ 0x0100, 0x0100, 0x0100, 0x2108, 0x7ff8, 0x2108, 0x2108, 0x2108, 0x2108, 0x2108, 0x2108, 0x3d08, 0x1108, 0x0100, 0x0100, 0x0000 },	// U+2F31 (⼱)
	{ 0x1000, 0x3ffc, 0x0080, 0x0080, 0x0080, 0x0080, 0x2080, 0x7ffe, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+2F32 (⼲)
	{ 0x00c0, 0x0040, 0x0020, 0x0c20, 0x0410, 0x0208, 0x01fe, 0x0084, 0x0040, 0x0420, 0x0810, 0x17c8, 0x303e, 0x2004, 0x0000, 0x0000 },	// U+2F33 (⼳)
	{ 0x0080, 0x0100, 0x2100, 0x7ff8, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0004, 0x0004, 0x0002, 0x0001, 0x0000 },	// U+2F34 (⼴)
	{ 0x0010, 0x003e, 0x0010, 0x0010, 0x0008, 0x0024, 0x007c, 0x0020, 0x0021, 0x0022, 0x0014, 0x0008, 0x0014, 0x6023, 0x3fc1, 0x0000 },	// U+2F35 (⼵)
	{ 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x7ffe, 0x0820, 0x0820, 0x0820, 0x0820, 0x0810, 0x0810, 0x0808, 0x0804, 0x0000 },	// U+2F36 (⼶)
	{ 0x0480, 0x1880, 0x1080, 0x0080, 0x7880, 0x0780, 0x00fe, 0x010c, 0x0100, 0x0100, 0x0200, 0x4200, 0x4400, 0x4800, 0x7000, 0x0000 },	// U+2F37 (⼷)
	{ 0x0800, 0x1ffc, 0x0800, 0x0800, 0x0800, 0x0ff8, 0x0008, 0x1008, 0x3ffc, 0x1000, 0x1000, 0x1000, 0x1080, 0x0f00, 0x0400, 0x0000 },	// U+2F38 (⼸)
	{ 0x1000, 0x3ffc, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1ff8, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1ffc, 0x1000, 0x0000 },	// U+2F39 (⼹)
	{ 0x0300, 0x0100, 0x0080, 0x0040, 0x0020, 0x0300, 0x0100, 0x0080, 0x0040, 0x0620, 0x0200, 0x0100, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+2F3A (⼺)
	{ 0x0300, 0x0100, 0x0080, 0x0040, 0x0320, 0x0110, 0x0080, 0x00c0, 0x00a0, 0x0090, 0x0088, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+2F3B (⼻)
	{ 0x0080, 0x0100, 0x0300, 0x0200, 0x0020, 0x0020, 0x1024, 0x2024, 0x6024, 0x4024, 0x0022, 0x0821, 0x0820, 0x1820, 0x0fc0, 0x0000 },	// U+2F3C (⼼)
	{ 0x0040, 0x0240, 0x0440, 0x0040, 0x3840, 0x0740, 0x00fe, 0x1840, 0x0840, 0x0440, 0x0280, 0x4180, 0x2240, 0x2430, 0x780e, 0x0000 },	// U+2F3D (⼽)
	{ 0x0800, 0x1c08, 0x03f8, 0x1008, 0x3ff8, 0x1008, 0x1008, 0x1008, 0x1ff8, 0x1008, 0x0008, 0x0004, 0x0004, 0x0002, 0x0001, 0x0000 },	// U+2F3E (⼾)
	{ 0x0800, 0x1e00, 0x01fe, 0x0080, 0x0880, 0x1ffc, 0x0080, 0x2080, 0x7ffe, 0x0080, 0x0080, 0x0080, 0x0090, 0x00e0, 0x0040, 0x0000 },	// U+2F3F (⼿)
	{ 0x0100, 0x0100, 0x2100, 0x7ffe, 0x0100, 0x0900, 0x1ff8, 0x0820, 0x0820, 0x0440, 0x0280, 0x0100, 0x0280, 0x0c60, 0x701c, 0x0000 },	// U+2F40 (⽀)
	{ 0x0080, 0x0080, 0x2080, 0x7f80, 0x0080, 0x0880, 0x1ffc, 0x0810, 0x0420, 0x0420, 0x0240, 0x0180, 0x0180, 0x0e70, 0x700e, 0x0000 },	// U+2F41 (⽁)
	{ 0x0080, 0x0100, 0x2100, 0x7ffe, 0x0410, 0x0410, 0x0410, 0x0220, 0x0220, 0x0240, 0x0140, 0x0180, 0x0660, 0x1818, 0x6006, 0x0000 },	// U+2F42 (⽂)
	{ 0x0400, 0x0410, 0x0420, 0x0440, 0x0440, 0x0410, 0x0420, 0x0440, 0x2440, 0x7c00, 0x07c0, 0x043e, 0x0404, 0x0400, 0x0400, 0x0000 },	// U+2F43 (⽃)
	{ 0x0400, 0x0e08, 0x01f8, 0x0008, 0x0008, 0x2008, 0x7ff8, 0x0208, 0x0208, 0x0208, 0x0208, 0x0204, 0x0204, 0x0202, 0x0201, 0x0000 },	// U+2F44 (⽄)
	{ 0x0080, 0x0100, 0x2100, 0x7ffe, 0x0040, 0x0040, 0x1040, 0x3fc0, 0x1040, 0x1040, 0x1040, 0x1020, 0x1110, 0x0e08, 0x0406, 0x0000 },	// U+2F45 (⽅)
	{ 0x1000, 0x3ff8, 0x0080, 0x0080, 0x0080, 0x2080, 0x7ffe, 0x0240, 0x0240, 0x0240, 0x0240, 0x4220, 0x4210, 0x4208, 0x7c06, 0x0000 },	// U+2F46 (⽆)
	{ 0x0808, 0x1ff8, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0000 },	// U+2F47 (⽇)
	{ 0x1004, 0x3ffc, 0x1004, 0x1004, 0x1004, 0x1004, 0x1ffc, 0x1004, 0x1004, 0x1004, 0x1004, 0x1ffc, 0x1004, 0x0000, 0x0000, 0x0000 },	// U+2F48 (⽈)
	{ 0x0810, 0x1ff0, 0x0810, 0x0810, 0x0810, 0x0ff0, 0x0810, 0x0810, 0x0810, 0x0ff0, 0x0810, 0x0810, 0x0908, 0x0e04, 0x0402, 0x0000 },	// U+2F49 (⽉)
	{ 0x0100, 0x0100, 0x0100, 0x2100, 0x7ffe, 0x0100, 0x0140, 0x0540, 0x0520, 0x0920, 0x0910, 0x1110, 0x6108, 0x2106, 0x0100, 0x0000 },	// U+2F4A (⽊)
	{ 0x0010, 0x0010, 0x2010, 0x7ff0, 0x1008, 0x0884, 0x0082, 0x0080, 0x0080, 0x0080, 0x0180, 0x0240, 0x0420, 0x1818, 0x6006, 0x0000 },	// U+2F4B (⽋)
	{ 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x1110, 0x3f10, 0x0110, 0x0110, 0x0110, 0x0110, 0x0110, 0x0110, 0x2110, 0x7ffe, 0x0000 },	// U+2F4C (⽌)
	{ 0x2000, 0x7ffe, 0x0040, 0x0040, 0x0840, 0x1fc0, 0x0820, 0x0830, 0x0448, 0x0484, 0x0282, 0x0100, 0x0080, 0x0060, 0x001e, 0x0000 },	// U+2F4D (⽍)
	{ 0x0420, 0x0fe0, 0x0420, 0x0420, 0x0420, 0x0410, 0x3808, 0x0004, 0x1ff8, 0x0810, 0x0420, 0x0240, 0x0180, 0x0e70, 0x300e, 0x0000 },	// U+2F4E (⽎)
	{ 0x1000, 0x3ff8, 0x1108, 0x1108, 0x1108, 0x1108, 0x7ffe, 0x1088, 0x1088, 0x1084, 0x1044, 0x7ffe, 0x0820, 0x0f90, 0x040c, 0x0000 },	// U+2F4F (⽏)
	{ 0x0200, 0x0208, 0x0208, 0x0208, 0x3208, 0x1248, 0x0af8, 0x0608, 0x0208, 0x0208, 0x0208, 0x2208, 0x22c8, 0x623c, 0x3c08, 0x0000 },	// U+2F50 (⽐)
	{ 0x0800, 0x1c00, 0x03fc, 0x0080, 0x0080, 0x3880, 0x07fc, 0x0080, 0x7080, 0x0f80, 0x00fe, 0x4080, 0x4080, 0x4080, 0x7f00, 0x0000 },	// U+2F51 (⽑)
	{ 0x0800, 0x1c08, 0x03f8, 0x0108, 0x0108, 0x1108, 0x3ff8, 0x0108, 0x0108, 0x0108, 0x0108, 0x4248, 0x4428, 0x481e, 0x7004, 0x0000 },	// U+2F52 (⽒)
	{ 0x0010, 0x1010, 0x3ff0, 0x0008, 0x0ff4, 0x0002, 0x0ffd, 0x0800, 0x0800, 0x0800, 0x0800, 0x4800, 0x5000, 0x6000, 0x4000, 0x0000 },	// U+2F53 (⽓)
	{ 0x0080, 0x0080, 0x0080, 0x1880, 0x0880, 0x04be, 0x02a0, 0x01a0, 0x0290, 0x0490, 0x0888, 0x3084, 0x6092, 0x40e1, 0x0040, 0x0000 },	// U+2F54 (⽔)
	{ 0x0100, 0x0100, 0x0100, 0x0100, 0x3110, 0x1110, 0x0910, 0x0508, 0x0304, 0x0100, 0x0180, 0x0240, 0x0420, 0x1818, 0x6006, 0x0000 },	// U+2F55 (⽕)
	{ 0x0800, 0x1c08, 0x07f8, 0x0488, 0x0488, 0x0488, 0x0488, 0x0488, 0x0888, 0x0888, 0x0888, 0x1084, 0x1084, 0x6082, 0x4081, 0x0000 },	// U+2F56 (⽖)
	{ 0x0220, 0x0420, 0x0810, 0x3008, 0x2004, 0x0402, 0x0420, 0x0220, 0x0240, 0x0140, 0x0180, 0x0180, 0x0240, 0x0c30, 0x700c, 0x0000 },	// U+2F57 (⽗)
	{ 0x1800, 0x0818, 0x0460, 0x0380, 0x0c40, 0x3030, 0x240c, 0x0420, 0x0220, 0x0240, 0x0140, 0x0180, 0x0340, 0x0c30, 0x700c, 0x0000 },	// U+2F58 (⽘)
	{ 0x0800, 0x0820, 0x0820, 0x0820, 0x0820, 0x0fe0, 0x0800, 0x0800, 0x0ffc, 0x0820, 0x0820, 0x0820, 0x0820, 0x0810, 0x080c, 0x0000 },	// U+2F59 (⽙)
	{ 0x0208, 0x0208, 0x0208, 0x0208, 0x2208, 0x7ff8, 0x0008, 0x0408, 0x0ff8, 0x0408, 0x0408, 0x0408, 0x0408, 0x0404, 0x0402, 0x0000 },	// U+2F5A (⽚)
	{ 0x2000, 0x7ffe, 0x0200, 0x0210, 0x0210, 0x2208, 0x7ffc, 0x0280, 0x0240, 0x0220, 0x0210, 0x0208, 0x0244, 0x0382, 0x0100, 0x0000 },	// U+2F5B (⽛)
	{ 0x0100, 0x0100, 0x0108, 0x1108, 0x3ff8, 0x0108, 0x0104, 0x0102, 0x2100, 0x7ffe, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000 },	// U+2F5C (⽜)
	{ 0x0080, 0x0580, 0x0880, 0x0880, 0x2080, 0x7ffe, 0x0080, 0x0080, 0x0080, 0x0140, 0x0220, 0x0410, 0x0808, 0x7004, 0x2002, 0x0000 },	// U+2F5D (⽝)
	{ 0x0080, 0x0100, 0x2100, 0x7ffe, 0x0080, 0x0080, 0x0c40, 0x07a0, 0x0278, 0x0110, 0x0080, 0x0840, 0x1fa0, 0x3078, 0x2010, 0x0000 },	// U+2F5E (⽞)
	{ 0x1000, 0x3ffc, 0x0080, 0x0080, 0x0080, 0x0880, 0x1ff8, 0x0080, 0x0480, 0x0880, 0x0880, 0x0080, 0x2080, 0x7ffe, 0x0000, 0x0000 },	// U+2F5F (⽟)
	{ 0x1000, 0x3c08, 0x07f8, 0x0488, 0x0488, 0x0488, 0x0488, 0x0488, 0x0888, 0x0888, 0x0a88, 0x1288, 0x1284, 0x65c2, 0x4481, 0x0000 },	// U+2F60 (⽠)
	{ 0x2000, 0x7ffe, 0x0020, 0x0020, 0x0420, 0x0fe0, 0x0410, 0x0450, 0x0490, 0x0490, 0x0408, 0x4408, 0x44c8, 0x443e, 0x7804, 0x0000 },	// U+2F61 (⽡)
	{ 0x0810, 0x0810, 0x2810, 0x7ffe, 0x0810, 0x0810, 0x0810, 0x0810, 0x0ff0, 0x0810, 0x0810, 0x0810, 0x0810, 0x0ff0, 0x0810, 0x0000 },	// U+2F62 (⽢)
	{ 0x0100, 0x0108, 0x0108, 0x1108, 0x3ff8, 0x0108, 0x0104, 0x0102, 0x0900, 0x1ff8, 0x0100, 0x0100, 0x0100, 0x2100, 0x7ffe, 0x0000 },	// U+2F63 (⽣)
	{ 0x2008, 0x7ff8, 0x2108, 0x2108, 0x2108, 0x3ff8, 0x2108, 0x2108, 0x2108, 0x3ff8, 0x2108, 0x2104, 0x2504, 0x3902, 0x1101, 0x0000 },	// U+2F64 (⽤)
	{ 0x2004, 0x7ffc, 0x2104, 0x2104, 0x2104, 0x2104, 0x3ffc, 0x2104, 0x2104, 0x2104, 0x2104, 0x2104, 0x3ffc, 0x2004, 0x0000, 0x0000 },	// U+2F65 (⽥)
	{ 0x2000, 0x7ffe, 0x2100, 0x1100, 0x0100, 0x0108, 0x1108, 0x3f08, 0x0108, 0x0108, 0x0118, 0x0128, 0x0144, 0x0183, 0x7f01, 0x0000 },	// U+2F66 (⽦)
	{ 0x0100, 0x2210, 0x7ff0, 0x0012, 0x0014, 0x0014, 0x0010, 0x0018, 0x0016, 0x0012, 0x0010, 0x0008, 0x0008, 0x0004, 0x0002, 0x0000 },	// U+2F67 (⽧)
	{ 0x1000, 0x08fe, 0x4540, 0x2244, 0x1428, 0x0810, 0x1008, 0x2004, 0x4002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+2F68 (⽨)
	{ 0x0080, 0x0080, 0x1048, 0x3ff8, 0x1008, 0x1008, 0x1008, 0x1008, 0x1ff8, 0x1008, 0x1008, 0x1008, 0x1008, 0x1ff8, 0x1008, 0x0000 },	// U+2F69 (⽩)
	{ 0x0100, 0x0100, 0x2108, 0x7ff8, 0x2108, 0x1108, 0x0108, 0x1ff8, 0x0848, 0x0848, 0x0488, 0x0304, 0x0304, 0x0cc2, 0x7039, 0x0000 },	// U+2F6A (⽪)
	{ 0x1008, 0x3ff8, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x7ffe, 0x0000, 0x0000, 0x0000 },	// U+2F6B (⽫)
	{ 0x0808, 0x1ff8, 0x0808, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0000 },	// U+2F6C (⽬)
	{ 0x0800, 0x1ff8, 0x0400, 0x02c0, 0x0100, 0x2100, 0x7ffe, 0x1180, 0x0940, 0x0120, 0x0110, 0x0108, 0x0124, 0x01c2, 0x0080, 0x0000 },	// U+2F6D (⽭)
	{ 0x0010, 0x0010, 0x1010, 0x3ff0, 0x0108, 0x0104, 0x0100, 0x2100, 0x7ffe, 0x0100, 0x0280, 0x0440, 0x0820, 0x7018, 0x2006, 0x0000 },	// U+2F6E (⽮)
	{ 0x2000, 0x7ffe, 0x0080, 0x0080, 0x0040, 0x1020, 0x3ff0, 0x1028, 0x1024, 0x1022, 0x1020, 0x1020, 0x1fe0, 0x1020, 0x0000, 0x0000 },	// U+2F6F (⽯)
	{ 0x0800, 0x1ff8, 0x0000, 0x0000, 0x0000, 0x2000, 0x7ffe, 0x0100, 0x0530, 0x0910, 0x1108, 0x2104, 0x2122, 0x01c0, 0x0080, 0x0000 },	// U+2F70 (⽰)
	{ 0x0080, 0x0080, 0x2084, 0x7ffc, 0x2084, 0x2044, 0x2244, 0x2444, 0x2f24, 0x28fc, 0x2814, 0x2004, 0x2004, 0x3c04, 0x1004, 0x0000 },	// U+2F71 (⽱)
	{ 0x1000, 0x3c00, 0x03f8, 0x0100, 0x0100, 0x2100, 0x7ffe, 0x0100, 0x0380, 0x0540, 0x0920, 0x1110, 0x6108, 0x4106, 0x0100, 0x0000 },	// U+2F72 (⽲)
	{ 0x0080, 0x0100, 0x4104, 0x7ffc, 0x2004, 0x1002, 0x0220, 0x0220, 0x0220, 0x0420, 0x0410, 0x0810, 0x1008, 0x3004, 0x6002, 0x0000 },	// U+2F73 (⽳)
	{ 0x0040, 0x0080, 0x0100, 0x1100, 0x3ffc, 0x0000, 0x0810, 0x0810, 0x0420, 0x0420, 0x0240, 0x0240, 0x2100, 0x7ffe, 0x0000, 0x0000 },	// U+2F74 (⽴)
	{ 0x0008, 0x0608, 0x0208, 0x2248, 0x7ef8, 0x0914, 0x0892, 0x0851, 0x0810, 0x0810, 0x0810, 0x0810, 0x0910, 0x0e10, 0x0410, 0x0000 },	// U+2F75 (⽵)
	{ 0x0100, 0x3108, 0x1110, 0x0930, 0x0520, 0x2300, 0x7ffe, 0x0140, 0x0340, 0x0520, 0x0910, 0x1108, 0x6104, 0x4102, 0x0100, 0x0000 },	// U+2F76 (⽶)
	{ 0x0180, 0x0080, 0x0c40, 0x0420, 0x03f8, 0x0110, 0x0480, 0x0840, 0x3ffc, 0x2108, 0x0100, 0x0930, 0x1110, 0x6108, 0x4104, 0x0000 },	// U+2F77 (⽷)
	{ 0x0010, 0x0010, 0x1010, 0x3ff0, 0x0108, 0x0104, 0x2100, 0x7ffe, 0x0100, 0x2108, 0x2108, 0x2108, 0x2108, 0x3ff8, 0x2008, 0x0000 },	// U+2F78 (⽸)
	{ 0x2004, 0x7ffc, 0x2004, 0x2884, 0x2884, 0x2954, 0x2624, 0x2444, 0x24a4, 0x2a94, 0x290c, 0x2084, 0x2404, 0x3804, 0x1004, 0x0000 },	// U+2F79 (⽹)
	{ 0x0c10, 0x0420, 0x2240, 0x7ffe, 0x0080, 0x0080, 0x0880, 0x1ff8, 0x0080, 0x2080, 0x7ffe, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+2F7A (⽺)
	{ 0x2040, 0x7ffe, 0x2040, 0x2244, 0x2448, 0x2448, 0x2040, 0x3060, 0x2c58, 0x2346, 0x2040, 0x2040, 0x2448, 0x3870, 0x1020, 0x0000 },	// U+2F7B (⽻)
	{ 0x0080, 0x0080, 0x3080, 0x17fc, 0x0880, 0x2480, 0x7ffe, 0x0100, 0x0080, 0x0c60, 0x0330, 0x20e8, 0x2026, 0x6020, 0x3fc0, 0x0000 },	// U+2F7C (⽼)
	{ 0x2000, 0x7ffe, 0x0100, 0x0100, 0x2084, 0x7ffc, 0x2244, 0x2244, 0x2244, 0x2244, 0x2244, 0x2244, 0x2244, 0x3a44, 0x1004, 0x0000 },	// U+2F7D (⽽)
	{ 0x0080, 0x2080, 0x7fff, 0x0080, 0x0880, 0x1ffc, 0x0080, 0x2080, 0x7fff, 0x02a0, 0x04a0, 0x0890, 0x3088, 0x6084, 0x4083, 0x0000 },	// U+2F7E (⽾)
	{ 0x2000, 0x7ffe, 0x0410, 0x0410, 0x07f0, 0x0410, 0x0410, 0x0410, 0x07f0, 0x2410, 0x7c10, 0x07f0, 0x041e, 0x0400, 0x0400, 0x0000 },	// U+2F7F (⽿)
	{ 0x0080, 0x1080, 0x3ff8, 0x1080, 0x7ffe, 0x1080, 0x1ff8, 0x1080, 0x0080, 0x1ffc, 0x2080, 0x7ffe, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+2F80 (⾀)
	{ 0x0080, 0x0080, 0x2084, 0x7ffc, 0x2084, 0x2184, 0x2244, 0x2c24, 0x2894, 0x2084, 0x2184, 0x2244, 0x2424, 0x3814, 0x1004, 0x0000 },	// U+2F81 (⾁)
	{ 0x1004, 0x3ffc, 0x0084, 0x0084, 0x1084, 0x3ffc, 0x1004, 0x1004, 0x1004, 0x1ffc, 0x1084, 0x0084, 0x2084, 0x7ffc, 0x0004, 0x0000 },	// U+2F82 (⾂)
	{ 0x0180, 0x0080, 0x1040, 0x3ff8, 0x1008, 0x1008, 0x1ff8, 0x1008, 0x1008, 0x1008, 0x1ff8, 0x1008, 0x1008, 0x1ff8, 0x1008, 0x0000 },	// U+2F83 (⾃)
	{ 0x2000, 0x7ffe, 0x0080, 0x0040, 0x0420, 0x0810, 0x1ffe, 0x2084, 0x0080, 0x1080, 0x3ffc, 0x0080, 0x0080, 0x2080, 0x7ffe, 0x0000 },	// U+2F84 (⾄)
	{ 0x0040, 0x20e4, 0x7e1c, 0x2004, 0x2004, 0x2004, 0x2004, 0x3e7c, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x3ffc, 0x2004, 0x0000 },	// U+2F85 (⾅)
	{ 0x0800, 0x1e00, 0x01fc, 0x0100, 0x2100, 0x7ffe, 0x0100, 0x0100, 0x1110, 0x3ff0, 0x1010, 0x1010, 0x1010, 0x1ff0, 0x1010, 0x0000 },	// U+2F86 (⾆)
	{ 0x0808, 0x0808, 0x0808, 0x2848, 0x7ef8, 0x0848, 0x0a44, 0x0a4a, 0x0950, 0x7f50, 0x0820, 0x0810, 0x0808, 0x0804, 0x0802, 0x0000 },	// U+2F87 (⾇)
	{ 0x0080, 0x0080, 0x0850, 0x1ff0, 0x0890, 0x0910, 0x0910, 0x2810, 0x7ffe, 0x0890, 0x0910, 0x0910, 0x0810, 0x0f08, 0x0404, 0x0000 },	// U+2F88 (⾈)
	{ 0x0808, 0x1ff8, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0808, 0x0ff8, 0x0048, 0x3088, 0x0c88, 0x0308, 0x0668, 0x181e, 0x6004, 0x0000 },	// U+2F89 (⾉)
	{ 0x0020, 0x0420, 0x0fe0, 0x0210, 0x1108, 0x3ffc, 0x108a, 0x1088, 0x1088, 0x1ff8, 0x1008, 0x4008, 0x4008, 0x4008, 0x7ff0, 0x0000 },	// U+2F8A (⾊)
	{ 0x0810, 0x0810, 0x0810, 0x2a54, 0x2a54, 0x2a54, 0x2a54, 0x2a54, 0x2a54, 0x3e7c, 0x2a54, 0x0810, 0x0808, 0x0804, 0x0802, 0x0000 },	// U+2F8B (⾋)
	{ 0x0080, 0x3f80, 0x0080, 0x0080, 0x7ffc, 0x4004, 0x2084, 0x0884, 0x1c84, 0x0384, 0x00f4, 0x4084, 0x4084, 0x4082, 0x7f01, 0x0000 },	// U+2F8C (⾌)
	{ 0x0100, 0x0100, 0x0100, 0x1108, 0x3ff8, 0x1108, 0x1108, 0x1108, 0x1ff8, 0x1108, 0x0100, 0x1100, 0x2100, 0x7ffe, 0x400c, 0x0000 },	// U+2F8D (⾍)
	{ 0x0300, 0x0100, 0x0080, 0x1048, 0x3ff8, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x1248, 0x7ffe, 0x0000, 0x0000 },	// U+2F8E (⾎)
	{ 0x1018, 0x3f88, 0x0004, 0x0002, 0x2030, 0x7fd0, 0x0808, 0x080c, 0x080a, 0x0809, 0x0808, 0x0808, 0x0908, 0x0e08, 0x0408, 0x0000 },	// U+2F8F (⾏)
	{ 0x0080, 0x0100, 0x2100, 0x7ffe, 0x0180, 0x3140, 0x1120, 0x0a30, 0x0628, 0x0224, 0x0422, 0x0920, 0x10a0, 0x6070, 0x4020, 0x0000 },	// U+2F90 (⾐)
	{ 0x2000, 0x7ffe, 0x0440, 0x0440, 0x2444, 0x7ffc, 0x2444, 0x2444, 0x2444, 0x2444, 0x27c4, 0x2444, 0x2004, 0x2004, 0x2004, 0x0000 },	// U+2F91 (⾑)
	{ 0x0400, 0x0ff8, 0x0408, 0x0408, 0x07f8, 0x0408, 0x0408, 0x07f8, 0x0408, 0x0408, 0x07f8, 0x2528, 0x2110, 0x610c, 0x3e03, 0x0000 },	// U+2F92 (⾒)
	{ 0x0420, 0x0fe0, 0x0420, 0x2210, 0x7ff8, 0x2114, 0x2112, 0x3ff0, 0x2110, 0x2110, 0x3ff0, 0x2108, 0x2108, 0x3904, 0x1102, 0x0000 },	// U+2F93 (⾓)
	{ 0x0040, 0x2080, 0x7fff, 0x0000, 0x0000, 0x0ff8, 0x0000, 0x0ff8, 0x0000, 0x0808, 0x1ff8, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0000 },	// U+2F94 (⾔)
	{ 0x0220, 0x0420, 0x0810, 0x3008, 0x2184, 0x0240, 0x0420, 0x1818, 0x6006, 0x0ff0, 0x0810, 0x0810, 0x0810, 0x0ff0, 0x0810, 0x0000 },	// U+2F95 (⾕)
	{ 0x1000, 0x3ffc, 0x0000, 0x0810, 0x1ff0, 0x0810, 0x0810, 0x0810, 0x0ff0, 0x0810, 0x0620, 0x0220, 0x0240, 0x2140, 0x7ffe, 0x0000 },	// U+2F96 (⾖)
	{ 0x2000, 0x7ffe, 0x0080, 0x0040, 0x3020, 0x1058, 0x08c6, 0x0520, 0x0398, 0x0546, 0x0920, 0x7118, 0x2106, 0x0120, 0x00c0, 0x0000 },	// U+2F97 (⾗)
	{ 0x0600, 0x0300, 0x1180, 0x3a60, 0x0458, 0x0380, 0x04c0, 0x0630, 0x0908, 0x0cc0, 0x0a38, 0x0900, 0x08c0, 0x04b8, 0x0300, 0x0000 },	// U+2F98 (⾘)
	{ 0x1010, 0x3ff0, 0x1010, 0x1010, 0x1ff0, 0x1010, 0x1010, 0x1ff0, 0x1010, 0x1010, 0x1ff0, 0x1010, 0x06c0, 0x1830, 0x600c, 0x0000 },	// U+2F99 (⾙)
	{ 0x0100, 0x0100, 0x1100, 0x3ff8, 0x0100, 0x2100, 0x7ffe, 0x0240, 0x1248, 0x2248, 0x2244, 0x4224, 0x4222, 0x0390, 0x010c, 0x0000 },	// U+2F9A (⾚)
	{ 0x0080, 0x0080, 0x0880, 0x1ff8, 0x0080, 0x2080, 0x7ffe, 0x0080, 0x0090, 0x1090, 0x3f90, 0x0090, 0x00a8, 0x00c4, 0x7f02, 0x0000 },	// U+2F9B (⾛)
	{ 0x0810, 0x1ff0, 0x0810, 0x0810, 0x0810, 0x0ff0, 0x0910, 0x0100, 0x1110, 0x3f10, 0x0110, 0x0128, 0x0148, 0x6184, 0x3f02, 0x0000 },	// U+2F9C (⾜)
	{ 0x0100, 0x0890, 0x1ff0, 0x0810, 0x0ff0, 0x0810, 0x6810, 0x2ff0, 0x1810, 0x0ffe, 0x0a00, 0x0980, 0x0860, 0x0f18, 0x0406, 0x0000 },	// U+2F9D (⾝)
	{ 0x0080, 0x2080, 0x7ffe, 0x0080, 0x1088, 0x3ff8, 0x1088, 0x1ff8, 0x1088, 0x1ff8, 0x1088, 0x2080, 0x7ffe, 0x0080, 0x0080, 0x0000 },	// U+2F9E (⾞)
	{ 0x0080, 0x1100, 0x3ffc, 0x0410, 0x0420, 0x0240, 0x2240, 0x7ffe, 0x0080, 0x1080, 0x3ffc, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+2F9F (⾟)
	{ 0x2008, 0x7ff8, 0x0008, 0x0808, 0x1fe8, 0x0008, 0x2008, 0x7ff8, 0x0248, 0x1248, 0x0a48, 0x0444, 0x0944, 0x10f2, 0x6021, 0x0000 },	// U+2FA0 (⾠)
	{ 0x0600, 0x0180, 0x1c78, 0x0300, 0x18f8, 0x0600, 0x01f8, 0x0100, 0x0108, 0x1108, 0x3f18, 0x0128, 0x0144, 0x0182, 0x7e01, 0x0000 },	// U+2FA1 (⾡)
	{ 0x0ff8, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0000, 0x1ffc, 0x1084, 0x1084, 0x1ffc, 0x1004, 0x2004, 0x2004, 0x6004, 0x3ff8, 0x0000 },	// U+2FA2 (⾢)
	{ 0x2000, 0x7ffe, 0x0240, 0x2248, 0x7ff8, 0x2248, 0x2248, 0x2248, 0x3c28, 0x2018, 0x2008, 0x3ff8, 0x2008, 0x3ff8, 0x2008, 0x0000 },	// U+2FA3 (⾣)
	{ 0x0c00, 0x1f00, 0x00fc, 0x0880, 0x0888, 0x0490, 0x2290, 0x7ffe, 0x01c0, 0x02a0, 0x0490, 0x0888, 0x7084, 0x2082, 0x0080, 0x0000 },	// U+2FA4 (⾤)
	{ 0x1008, 0x3ff8, 0x1088, 0x1088, 0x1ff8, 0x1088, 0x1088, 0x1ff8, 0x1088, 0x0080, 0x1080, 0x3ffc, 0x0080, 0x2080, 0x7ffe, 0x0000 },	// U+2FA5 (⾥)
	{ 0x0100, 0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x6ff6, 0x0080, 0x1080, 0x3ffc, 0x0080, 0x1888, 0x0890, 0x2490, 0x7ffe, 0x0000 },	// U+2FA6 (⾦)
	{ 0x0810, 0x1ff0, 0x0010, 0x0ff0, 0x0010, 0x0ff0, 0x0010, 0x2010, 0x7ffe, 0x1110, 0x0a10, 0x0410, 0x0990, 0x7070, 0x201c, 0x0000 },	// U+2FA7 (⾧)
	{ 0x3f7e, 0x2142, 0x2142, 0x3f7e, 0x2142, 0x2142, 0x3f7e, 0x2002, 0x2002, 0x2002, 0x2002, 0x2002, 0x2402, 0x3802, 0x1002, 0x0000 },	// U+2FA8 (⾨)
	{ 0x0080, 0x0848, 0x1ff8, 0x0808, 0x0ff8, 0x0008, 0x1ff8, 0x1008, 0x1ff8, 0x1108, 0x2100, 0x7ffe, 0x0100, 0x0100, 0x0100, 0x0000 },	// U+2FA9 (⾩)
	{ 0x0080, 0x0880, 0x1ffc, 0x0880, 0x7ffe, 0x0880, 0x0ffc, 0x0880, 0x118c, 0x0990, 0x06e0, 0x0490, 0x188e, 0x60e4, 0x0040, 0x0000 },	// U+2FAA (⾪)
	{ 0x0120, 0x0220, 0x2220, 0x7ff0, 0x0210, 0x0218, 0x1214, 0x3ff2, 0x0210, 0x1210, 0x3ff0, 0x0210, 0x2210, 0x7ff0, 0x0010, 0x0000 },	// U+2FAB (⾫)
	{ 0x2000, 0x7ffe, 0x0080, 0x2084, 0x7ffc, 0x2084, 0x2294, 0x24a4, 0x24a4, 0x2084, 0x2294, 0x24a4, 0x24a4, 0x3884, 0x1084, 0x0000 },	// U+2FAC (⾬)
	{ 0x2080, 0x7fff, 0x0080, 0x1ffc, 0x2080, 0x7fff, 0x0000, 0x1ffc, 0x1084, 0x1084, 0x1084, 0x1ffc, 0x1004, 0x1e04, 0x0804, 0x0000 },	// U+2FAD (⾭)
	{ 0x0240, 0x0240, 0x2240, 0x7e7e, 0x0240, 0x0240, 0x1240, 0x3e7c, 0x0240, 0x0240, 0x2240, 0x7e7e, 0x0240, 0x0240, 0x0240, 0x0000 },	// U+2FAE (⾮)
	{ 0x2000, 0x7ffe, 0x0100, 0x2084, 0x7ffc, 0x2244, 0x2244, 0x23c4, 0x2244, 0x2244, 0x23c4, 0x2244, 0x2244, 0x3ffc, 0x2004, 0x0000 },	// U+2FAF (⾯)
	{ 0x0410, 0x2410, 0x7fff, 0x0410, 0x07f0, 0x0080, 0x1ffc, 0x1084, 0x1ffc, 0x1084, 0x0080, 0x7fff, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+2FB0 (⾰)
	{ 0x0040, 0x0440, 0x0ff8, 0x2420, 0x7ffe, 0x0000, 0x0ff0, 0x0810, 0x0ff0, 0x0100, 0x3ffc, 0x0108, 0x3ffc, 0x0100, 0x0100, 0x0000 },	// U+2FB1 (⾱)
	{ 0x0240, 0x0240, 0x0240, 0x2240, 0x7e7e, 0x0240, 0x0240, 0x3e7c, 0x0240, 0x2240, 0x7e7e, 0x0240, 0x0240, 0x2240, 0x7ffe, 0x0000 },	// U+2FB2 (⾲)
	{ 0x00c0, 0x1080, 0x3ffe, 0x0408, 0x0410, 0x0220, 0x7fff, 0x0000, 0x0808, 0x1ff8, 0x0808, 0x0ff8, 0x0808, 0x0ff8, 0x0808, 0x0000 },	// U+2FB3 (⾳)
	{ 0x2000, 0x7ffe, 0x0100, 0x1088, 0x3ff8, 0x1008, 0x1ff8, 0x1008, 0x1ff8, 0x1008, 0x1ff8, 0x1008, 0x06c0, 0x1830, 0x600c, 0x0000 },	// U+2FB4 (⾴)
	{ 0x1004, 0x3ffc, 0x1204, 0x1784, 0x10f4, 0x1084, 0x17f4, 0x1494, 0x1494, 0x17f4, 0x1494, 0x5284, 0x5784, 0x64f2, 0x4021, 0x0000 },	// U+2FB5 (⾵)
	{ 0x07fc, 0x2400, 0x1400, 0x0cb0, 0x349c, 0x4490, 0x4890, 0x77fe, 0x2490, 0x1490, 0x0c90, 0x3488, 0x4888, 0x5084, 0x6082, 0x0000 },	// U+2FB6 (⾶)
	{ 0x0100, 0x0180, 0x0240, 0x04a0, 0x1918, 0x6ff6, 0x0810, 0x0ff0, 0x0810, 0x0ff0, 0x1010, 0x0990, 0x0650, 0x183c, 0x6008, 0x0000 },	// U+2FB7 (⾷)
	{ 0x0c10, 0x0420, 0x7ffe, 0x0100, 0x0888, 0x1ff8, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0ff8, 0x0808, 0x0808, 0x0ff8, 0x0808, 0x0000 },	// U+2FB8 (⾸)
	{ 0x0400, 0x0e00, 0x01fc, 0x2080, 0x7ffe, 0x02a0, 0x0490, 0x188c, 0x6813, 0x1ff0, 0x0810, 0x0ff0, 0x0810, 0x0ff0, 0x0810, 0x0000 },	// U+2FB9 (⾹)
	{ 0x1008, 0x3ff8, 0x0088, 0x0888, 0x1ff8, 0x0088, 0x1ff8, 0x0088, 0x2088, 0x7ff8, 0x2400, 0x2890, 0x2924, 0x2124, 0x1c02, 0x0000 },	// U+2FBA (⾺)
	{ 0x0810, 0x1ff0, 0x0810, 0x0f90, 0x4894, 0x7ffc, 0x2004, 0x2ff2, 0x0810, 0x0ff0, 0x0810, 0x0ff0, 0x0810, 0x0e10, 0x0410, 0x0000 },	// U+2FBB (⾻)
	{ 0x0080, 0x2100, 0x7ffe, 0x0000, 0x0ff0, 0x0810, 0x0ff0, 0x2004, 0x7ffc, 0x2004, 0x27e4, 0x2424, 0x27e4, 0x3c24, 0x1004, 0x0000 },	// U+2FBC (⾼)
	{ 0x0044, 0x30fc, 0x1004, 0x0804, 0x64fc, 0x2204, 0x11fc, 0x0804, 0x64fe, 0x2208, 0x1008, 0x0844, 0x04ff, 0x0282, 0x0180, 0x0000 },	// U+2FBD (⾽)
	{ 0x4001, 0x5f7d, 0x4411, 0x5f7d, 0x4411, 0x5f7d, 0x4001, 0x4001, 0x4001, 0x4001, 0x4001, 0x4001, 0x4801, 0x7001, 0x2001, 0x0000 },	// U+2FBE (⾾)
	{ 0x0840, 0x2494, 0x2224, 0x254c, 0x2994, 0x2244, 0x2524, 0x3ffc, 0x2004, 0x0c08, 0x0308, 0x00e8, 0x2018, 0x2008, 0x3ff0, 0x0000 },	// U+2FBF (⾿)
	{ 0x2000, 0x7ffe, 0x0000, 0x0ff0, 0x0810, 0x0ff0, 0x0000, 0x3ffc, 0x2004, 0x2224, 0x2144, 0x2ff4, 0x2084, 0x3884, 0x1084, 0x0000 },	// U+2FC0 (⿀)
	{ 0x0080, 0x1048, 0x3ff8, 0x1088, 0x1088, 0x1ff8, 0x1088, 0x1088, 0x1ff8, 0x1108, 0x0980, 0x1540, 0x7f20, 0x4118, 0x7e06, 0x0000 },	// U+2FC1 (⿁)
	{ 0x0420, 0x0fe0, 0x0420, 0x0210, 0x1ff8, 0x1114, 0x1112, 0x1ff0, 0x1110, 0x1110, 0x1ff0, 0x1010, 0x2224, 0x4444, 0x4442, 0x0000 },	// U+2FC2 (⿂)
	{ 0x0080, 0x0850, 0x1ff0, 0x0810, 0x0ff0, 0x0810, 0x0ff0, 0x1010, 0x3ff0, 0x0010, 0x3ff0, 0x2494, 0x2924, 0x2922, 0x1800, 0x0000 },	// U+2FC3 (⿃)
	{ 0x0080, 0x2080, 0x7f80, 0x0080, 0x3ffc, 0x2844, 0x2494, 0x2224, 0x254c, 0x2994, 0x2244, 0x24a4, 0x2914, 0x3ffc, 0x2004, 0x0000 },	// U+2FC4 (⿄)
	{ 0x0080, 0x2104, 0x7ffc, 0x0444, 0x2444, 0x7ffc, 0x2444, 0x3ffc, 0x2014, 0x0414, 0x25f4, 0x1c14, 0x4594, 0x447a, 0x7c11, 0x0000 },	// U+2FC5 (⿅)
	{ 0x0100, 0x2100, 0x7ffe, 0x1110, 0x1110, 0x2928, 0x47c4, 0x0920, 0x1098, 0x6fc6, 0x0420, 0x02d0, 0x030c, 0x0480, 0x0878, 0x0000 },	// U+2FC6 (⿆)
	{ 0x0080, 0x2102, 0x7ffe, 0x0822, 0x0822, 0x7efe, 0x0822, 0x2aaa, 0x2aaa, 0x2aaa, 0x2aaa, 0x2aaa, 0x2926, 0x6925, 0x0821, 0x0000 },	// U+2FC7 (⿇)
	{ 0x2420, 0x7ffe, 0x0420, 0x07e0, 0x2000, 0x7ffe, 0x0080, 0x1ff8, 0x1088, 0x1ff8, 0x1088, 0x1ff8, 0x1008, 0x0c30, 0x700e, 0x0000 },	// U+2FC8 (⿈)
	{ 0x0e00, 0x01f8, 0x1080, 0x7ffe, 0x0080, 0x07e0, 0x1898, 0x6146, 0x06b0, 0x788e, 0x26b0, 0x01c0, 0x06a0, 0x1898, 0x60c6, 0x0000 },	// U+2FC9 (⿉)
	{ 0x1008, 0x3ff8, 0x1088, 0x1498, 0x12a8, 0x1ff8, 0x1088, 0x0080, 0x1ffc, 0x0080, 0x0080, 0x7ffe, 0x2224, 0x4444, 0x4442, 0x0000 },	// U+2FCA (⿊)
	{ 0x1248, 0x1248, 0x0a50, 0x0a50, 0x7ffe, 0x1108, 0x2104, 0x7ffa, 0x2108, 0x2188, 0x2348, 0x2528, 0x2918, 0x3908, 0x1108, 0x0000 },	// U+2FCB (⿋)
	{ 0x3ffc, 0x2244, 0x2244, 0x3e7c, 0x2244, 0x0240, 0x3e7c, 0x2244, 0x3e7c, 0x2244, 0x3e7c, 0x2244, 0x4240, 0x4240, 0x7f80, 0x0000 },	// U+2FCC (⿌)
	{ 0x07e0, 0x0420, 0x27e4, 0x2424, 0x27e4, 0x2424, 0x27e4, 0x2424, 0x3e7c, 0x0240, 0x7e7e, 0x1248, 0x1248, 0x1244, 0x1242, 0x0000 },	// U+2FCD (⿍)
	{ 0x0410, 0x0410, 0x24ff, 0x7f10, 0x047e, 0x2400, 0x7ffe, 0x2242, 0x2242, 0x127e, 0x1442, 0x0824, 0x0c78, 0x720e, 0x2184, 0x0000 },	// U+2FCE (⿎)
	{ 0x1060, 0x3f1c, 0x1004, 0x1f7c, 0x1004, 0x1ffc, 0x1004, 0x0290, 0x14a4, 0x1084, 0x1294, 0x54a4, 0x5084, 0x6294, 0x41ce, 0x0000 },	// U+2FCF (⿏)
	{ 0x0080, 0x0ff0, 0x0810, 0x0ff0, 0x0810, 0x0ff0, 0x0810, 0x1ff8, 0x1088, 0x1ff8, 0x1088, 0x7ffe, 0x0420, 0x0420, 0x041c, 0x0000 },	// U+2FD0 (⿐)
	{ 0x0040, 0x2080, 0x7ffe, 0x1240, 0x0d7c, 0x14a8, 0x14a8, 0x2ca4, 0x449a, 0x0810, 0x0ff0, 0x0810, 0x0ff0, 0x0808, 0x0806, 0x0000 },	// U+2FD1 (⿑)
	{ 0x0100, 0x0910, 0x1f10, 0x0110, 0x7fff, 0x0220, 0x2222, 0x2552, 0x288a, 0x3ffe, 0x2222, 0x2552, 0x288a, 0x3ffe, 0x2002, 0x0000 },	// U+2FD2 (⿒)
	{ 0x0208, 0x2210, 0x7efe, 0x0244, 0x3e28, 0x20fe, 0x3e00, 0x027c, 0x3e44, 0x027c, 0x3e44, 0x027c, 0x7e44, 0x4274, 0x7c24, 0x0000 },	// U+2FD3 (⿓)
	{ 0x0210, 0x07f0, 0x0210, 0x0108, 0x3ffe, 0x2288, 0x3efe, 0x22a0, 0x36fe, 0x2aa0, 0x36be, 0x22a0, 0x7efe, 0x40a0, 0x3f3e, 0x0000 },	// U+2FD4 (⿔)
	{ 0x0180, 0x0660, 0x1818, 0x63c6, 0x0000, 0x7bde, 0x4a52, 0x7bde, 0x0000, 0x3ffc, 0x2244, 0x3ffc, 0x2244, 0x3a44, 0x1244, 0x0000 },	// U+2FD5 (⿕)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x73c6, 0x7db6, 0x71b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+2FD6 (⿖)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x61c6, 0x6fb6, 0x77b6, 0x7bb6, 0x7bc6, 0x7ffe, 0x0000 },	// U+2FD7 (⿗)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x73b6, 0x6db6, 0x73c6, 0x7ffe, 0x0000 },	// U+2FD8 (⿘)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x73c6, 0x6db6, 0x63b6, 0x6fb6, 0x73c6, 0x7ffe, 0x0000 },	// U+2FD9 (⿙)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x61c6, 0x6db6, 0x61b6, 0x6db6, 0x6dc6, 0x7ffe, 0x0000 },	// U+2FDA (⿚)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x71b6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+2FDB (⿛)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x63c6, 0x7db6, 0x7db6, 0x7db6, 0x63c6, 0x7ffe, 0x0000 },	// U+2FDC (⿜)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x71c6, 0x6db6, 0x6db6, 0x6db6, 0x71c6, 0x7ffe, 0x0000 },	// U+2FDD (⿝)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x61c6, 0x7ffe, 0x0000 },	// U+2FDE (⿞)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x61c6, 0x7db6, 0x71b6, 0x7db6, 0x7dc6, 0x7ffe, 0x0000 },	// U+2FDF (⿟)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x6dc6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+2FE0 (⿠)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x7786, 0x73f6, 0x77c6, 0x77f6, 0x6386, 0x7ffe, 0x0000 },	// U+2FE1 (⿡)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x61c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+2FE2 (⿢)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x7186, 0x6ff6, 0x63c6, 0x6ff6, 0x7186, 0x7ffe, 0x0000 },	// U+2FE3 (⿣)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6d86, 0x6df6, 0x61c6, 0x6ff6, 0x6f86, 0x7ffe, 0x0000 },	// U+2FE4 (⿤)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x61c6, 0x6ff6, 0x6186, 0x7ffe, 0x0000 },	// U+2FE5 (⿥)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x7386, 0x7df6, 0x71c6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+2FE6 (⿦)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6186, 0x6ff6, 0x77c6, 0x7bf6, 0x7b86, 0x7ffe, 0x0000 },	// U+2FE7 (⿧)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x73c6, 0x6df6, 0x7386, 0x7ffe, 0x0000 },	// U+2FE8 (⿨)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x7386, 0x6df6, 0x63c6, 0x6ff6, 0x7386, 0x7ffe, 0x0000 },	// U+2FE9 (⿩)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6186, 0x6df6, 0x61c6, 0x6df6, 0x6d86, 0x7ffe, 0x0000 },	// U+2FEA (⿪)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x71c6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+2FEB (⿫)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x6386, 0x7ffe, 0x0000 },	// U+2FEC (⿬)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x7186, 0x7ffe, 0x0000 },	// U+2FED (⿭)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x6186, 0x7ffe, 0x0000 },	// U+2FEE (⿮)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7d86, 0x7ffe, 0x0000 },	// U+2FEF (⿯)
	{ 0x6db7, 0x0000, 0x4081, 0x4081, 0x0000, 0x4081, 0x4081, 0x0000, 0x4081, 0x4081, 0x0000, 0x4081, 0x4081, 0x0080, 0x4001, 0x5b6d },	// U+2FF0 (⿰)
	{ 0x6db7, 0x0000, 0x4001, 0x4001, 0x4001, 0x0000, 0x4001, 0x4001, 0x1b6c, 0x4001, 0x4001, 0x0000, 0x4001, 0x4001, 0x0000, 0x6db7 },	// U+2FF1 (⿱)
	{ 0x6db7, 0x0000, 0x4221, 0x4221, 0x4001, 0x0220, 0x4221, 0x4001, 0x0220, 0x4221, 0x4001, 0x0220, 0x4221, 0x4221, 0x0000, 0x6db7 },	// U+2FF2 (⿲)
	{ 0x6db7, 0x0000, 0x4001, 0x4001, 0x4001, 0x0000, 0x5b6d, 0x4001, 0x0000, 0x4001, 0x5b6d, 0x0000, 0x4001, 0x4001, 0x0000, 0x6db7 },	// U+2FF3 (⿳)
	{ 0x5555, 0x0000, 0x4001, 0x0aa8, 0x4001, 0x0808, 0x4001, 0x0808, 0x4001, 0x0808, 0x4809, 0x0000, 0x4aa9, 0x4001, 0x0000, 0x5555 },	// U+2FF4 (⿴)
	{ 0x6ddb, 0x0000, 0x4001, 0x4001, 0x06b0, 0x4411, 0x4001, 0x0410, 0x4001, 0x4411, 0x4411, 0x0000, 0x4411, 0x4411, 0x0000, 0x6ddb },	// U+2FF5 (⿵)
	{ 0x6ddb, 0x0000, 0x4411, 0x4411, 0x0000, 0x4411, 0x4411, 0x0000, 0x4411, 0x4001, 0x4411, 0x06b0, 0x4001, 0x4001, 0x0000, 0x6ddb },	// U+2FF6 (⿶)
	{ 0xb6db, 0x8000, 0x0001, 0x8001, 0xb6a0, 0x0021, 0x8001, 0x8020, 0x0001, 0x8021, 0xb6a0, 0x0001, 0x8001, 0x8000, 0x0001, 0xdb6d },	// U+2FF7 (⿷)
	{ 0xb6db, 0x8000, 0x0001, 0x8001, 0xb6d0, 0x0011, 0x8001, 0x8010, 0x0011, 0x8001, 0x8010, 0x0011, 0x8001, 0x8010, 0x0011, 0xdb6d },	// U+2FF8 (⿸)
	{ 0xb6db, 0x8000, 0x0001, 0x8001, 0x8b6c, 0x0801, 0x8001, 0x8800, 0x0801, 0x8001, 0x8800, 0x0801, 0x8001, 0x8800, 0x0801, 0xdb6d },	// U+2FF9 (⿹)
	{ 0xb6db, 0x8010, 0x0011, 0x8001, 0x8010, 0x0011, 0x8001, 0x8010, 0x0011, 0x8001, 0x8010, 0x36d1, 0x8001, 0x8000, 0x0001, 0xdb6d },	// U+2FFA (⿺)
	{ 0x0000, 0x06db, 0x0401, 0x0000, 0x36d9, 0x2409, 0x0000, 0x2409, 0x2409, 0x0000, 0x2409, 0x26db, 0x0000, 0x2008, 0x36d8, 0x0000 },	// U+2FFB (⿻)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6386, 0x7df6, 0x7dc6, 0x7df6, 0x63f6, 0x7ffe, 0x0000 },	// U+2FFC (⿼)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x7186, 0x6df6, 0x6dc6, 0x6df6, 0x71f6, 0x7ffe, 0x0000 },	// U+2FFD (⿽)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x61f6, 0x7ffe, 0x0000 },	// U+2FFE (⿾)
	{ 0x0000, 0x7ffe, 0x6186, 0x7dbe, 0x7186, 0x7df6, 0x7d86, 0x7ffe, 0x7ffe, 0x6186, 0x7df6, 0x71c6, 0x7df6, 0x7df6, 0x7ffe, 0x0000 },	// U+2FFF (⿿)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+3000 (　)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0030, 0x0060, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+3001 (、)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0048, 0x0048, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+3002 (。)
	{ 0x0000, 0x0000, 0x0000, 0x0240, 0x0240, 0x0240, 0x0120, 0x0120, 0x0090, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+3003 (〃)
	{ 0x0000, 0x0060, 0x0418, 0x0c04, 0x1482, 0x1582, 0x2281, 0x20b1, 0x20c9, 0x1092, 0x1022, 0x0824, 0x0618, 0x0180, 0x0000, 0x0000 },	// U+3004 (〄)
	{ 0x0000, 0x0000, 0x0040, 0x0080, 0x0080, 0x0c40, 0x13c0, 0x0820, 0x0410, 0x0248, 0x0184, 0x0100, 0x0200, 0x0000, 0x0000, 0x0000 },	// U+3005 (々)
	{ 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x0460, 0x0290, 0x0110, 0x0290, 0x0448, 0x0828, 0x0018, 0x000c, 0x0004, 0x0000, 0x0000 },	// U+3006 (〆)
	{ 0x0000, 0x01e0, 0x0618, 0x0804, 0x1002, 0x1002, 0x2001, 0x2001, 0x2001, 0x2001, 0x1002, 0x1002, 0x0804, 0x0618, 0x01e0, 0x0000 },	// U+3007 (〇)
	{ 0x1000, 0x1000, 0x0800, 0x0800, 0x0400, 0x0400, 0x0200, 0x0100, 0x0200, 0x0400, 0x0400, 0x0800, 0x0800, 0x1000, 0x1000, 0x0000 },	// U+3008 (〈)
	{ 0x0008, 0x0008, 0x0010, 0x0010, 0x0020, 0x0020, 0x0040, 0x0080, 0x0040, 0x0020, 0x0020, 0x0010, 0x0010, 0x0008, 0x0008, 0x0000 },	// U+3009 (〉)
	{ 0x1200, 0x1200, 0x0900, 0x0900, 0x0480, 0x0480, 0x0240, 0x0120, 0x0240, 0x0480, 0x0480, 0x0900, 0x0900, 0x1200, 0x1200, 0x0000 },	// U+300A (《)
	{ 0x0048, 0x0048, 0x0090, 0x0090, 0x0120, 0x0120, 0x0240, 0x0480, 0x0240, 0x0120, 0x0120, 0x0090, 0x0090, 0x0048, 0x0048, 0x0000 },	// U+300B (》)
	{ 0x1f00, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+300C (「)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x00f8, 0x0000 },	// U+300D (」)
	{ 0x1f80, 0x1080, 0x1e80, 0x0280, 0x0280, 0x0280, 0x0280, 0x0280, 0x0280, 0x0280, 0x0380, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+300E (『)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x01c0, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0178, 0x0108, 0x01f8, 0x0000 },	// U+300F (』)
	{ 0x1f00, 0x0f00, 0x0700, 0x0700, 0x0700, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0700, 0x0700, 0x0f00, 0x1f00, 0x0000 },	// U+3010 (【)
	{ 0x00f8, 0x00f0, 0x00e0, 0x00e0, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00e0, 0x00e0, 0x00f0, 0x00f8, 0x0000 },	// U+3011 (】)
	{ 0x0000, 0x7ffe, 0x0000, 0x0000, 0x7ffe, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+3012 (〒)
	{ 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x0000, 0x0000, 0x0000 },	// U+3013 (〓)
	{ 0x1000, 0x0800, 0x0400, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0400, 0x0800, 0x1000, 0x0000 },	// U+3014 (〔)
	{ 0x0008, 0x0010, 0x0020, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0020, 0x0010, 0x0008, 0x0000 },	// U+3015 (〕)
	{ 0x1fc0, 0x0840, 0x0440, 0x0240, 0x0240, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x0240, 0x0240, 0x0440, 0x0840, 0x1fc0, 0x0000 },	// U+3016 (〖)
	{ 0x03f8, 0x0210, 0x0220, 0x0240, 0x0240, 0x0280, 0x0280, 0x0280, 0x0280, 0x0280, 0x0240, 0x0240, 0x0220, 0x0210, 0x03f8, 0x0000 },	// U+3017 (〗)
	{ 0x1000, 0x0c00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0c00, 0x1000, 0x0000 },	// U+3018 (〘)
	{ 0x0008, 0x0030, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0030, 0x0008, 0x0000 },	// U+3019 (〙)
	{ 0x1f00, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x0500, 0x1f00, 0x0000 },	// U+301A (〚)
	{ 0x00f8, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00f8, 0x0000 },	// U+301B (〛)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x007c, 0x4182, 0x3e00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+301C (〜)
	{ 0x0900, 0x1200, 0x2400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+301D (〝)
	{ 0x0090, 0x0048, 0x0024, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+301E (〞)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0090, 0x0048, 0x0024, 0x0000 },	// U+301F (〟)
	{ 0x0000, 0x3ffc, 0x3ffc, 0x0000, 0x3ffc, 0x3ffc, 0x69aa, 0x9d9b, 0xa5a5, 0xa5a5, 0x599a, 0x4182, 0x2424, 0x13c8, 0x0810, 0x07e0 },	// U+3020 (〠)
	{ 0x0180, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000, 0x0000 },	// U+3021 (〡)
	{ 0x0600, 0x0200, 0x0230, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0210, 0x0200, 0x0200, 0x0200, 0x0000, 0x0000 },	// U+3022 (〢)
	{ 0x1000, 0x1004, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1004, 0x1004, 0x1000, 0x0000, 0x0000 },	// U+3023 (〣)
	{ 0x0800, 0x0800, 0x0408, 0x0410, 0x0220, 0x0240, 0x0180, 0x0300, 0x0480, 0x0840, 0x1020, 0x1010, 0x000c, 0x0000, 0x0000, 0x0000 },	// U+3024 (〤)
	{ 0x0000, 0x0420, 0x0c20, 0x0410, 0x0338, 0x00c0, 0x0120, 0x0210, 0x0410, 0x0408, 0x0408, 0x0408, 0x0208, 0x0210, 0x01e0, 0x0000 },	// U+3025 (〥)
	{ 0x0000, 0x0080, 0x0100, 0x2100, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+3026 (〦)
	{ 0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x3ffc, 0x0000, 0x0000, 0x0000, 0x3ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+3027 (〧)
	{ 0x0080, 0x0080, 0x0080, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x3ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ffe, 0x0000, 0x0000, 0x0000 },	// U+3028 (〨)
	{ 0x0010, 0x0010, 0x0010, 0x3ff0, 0x0808, 0x0814, 0x0420, 0x0440, 0x0280, 0x0100, 0x0300, 0x0480, 0x0840, 0x0830, 0x000c, 0x0000 },	// U+3029 (〩)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0009, 0x0009, 0x0006 },	// U+302A (〪)
	{ 0x0000, 0x0006, 0x0009, 0x0009, 0x0006, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+302B (〫)
	{ 0x0000, 0x6000, 0x9000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+302C (〬)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x9000, 0x9000, 0x6000 },	// U+302D (〭)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+302E (〮)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0003, 0x0000, 0x0003, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+302F (〯)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6186, 0x9249, 0x0c30, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+3030 (〰)
	{ 0x0080, 0x0180, 0x0080, 0x0040, 0x0040, 0x0020, 0x0010, 0x0008, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080, 0x0080, 0x0100, 0x0100 },	// U+3031 (〱)
	{ 0x0080, 0x0180, 0x0880, 0x1040, 0x1240, 0x0420, 0x0410, 0x0008, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080, 0x0080, 0x0100, 0x0100 },	// U+3032 (〲)
	{ 0x0020, 0x0060, 0x0020, 0x0010, 0x0010, 0x0010, 0x0008, 0x0008, 0x0008, 0x0004, 0x0004, 0x0004, 0x0002, 0x0002, 0x0001, 0x0001 },	// U+3033 (〳)
	{ 0x0020, 0x0060, 0x0220, 0x0410, 0x0110, 0x0210, 0x0208, 0x0008, 0x0008, 0x0004, 0x0004, 0x0004, 0x0002, 0x0002, 0x0001, 0x0001 },	// U+3034 (〴)
	{ 0x0001, 0x0001, 0x0002, 0x0004, 0x0004, 0x0008, 0x0008, 0x0010, 0x0010, 0x0020, 0x0020, 0x0040, 0x0040, 0x0080, 0x0080, 0x0000 },	// U+3035 (〵)
	{ 0x03e0, 0x0c18, 0x1004, 0x2ffa, 0x2ffa, 0x4001, 0x4ff9, 0x4ff9, 0x4081, 0x4081, 0x4081, 0x2082, 0x2082, 0x1084, 0x0c18, 0x03e0 },	// U+3036 (〶)
	{ 0x4141, 0x4141, 0x4141, 0x2222, 0x2222, 0x1414, 0x1414, 0x0808, 0x0808, 0x1414, 0x1414, 0x2222, 0x2222, 0x4141, 0x4141, 0x4141 },	// U+3037 (〷)
	{ 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x7fff, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000 },	// U+3038 (〸)
	{ 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x7fff, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0410, 0x0000 },	// U+3039 (〹)
	{ 0x1108, 0x1108, 0x1108, 0x1108, 0x1108, 0x7fff, 0x1108, 0x1108, 0x1108, 0x1108, 0x1108, 0x1104, 0x1104, 0x1102, 0x1001, 0x0000 },	// U+303A (〺)
	{ 0x0000, 0x0000, 0x0040, 0x0080, 0x0100, 0x0200, 0x0100, 0x0080, 0x0100, 0x0200, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+303B (〻)
	{ 0x0000, 0x0000, 0x0000, 0x1ffc, 0x1804, 0x1404, 0x1204, 0x1104, 0x1084, 0x1044, 0x1024, 0x1014, 0x100c, 0x1ffc, 0x0000, 0x0000 },	// U+303C (〼)
	{ 0x0000, 0x0000, 0x0008, 0x0614, 0x0922, 0x08c0, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x2000, 0x0000 },	// U+303D (〽)
	{ 0xb6db, 0x8001, 0x0070, 0x9189, 0x8e01, 0x0000, 0x8801, 0x8401, 0x1ff8, 0x8101, 0x8081, 0x1ff8, 0x8021, 0x0011, 0x8000, 0xb6db },	// U+303E (〾)
}; // 492

static const uint16_t unifontdw_block313[][16] = {
	{ 0x0000, 0x7ffe, 0x73c6, 0x6dbe, 0x6d8e, 0x6dbe, 0x73c6, 0x7ffe, 0x7ffe, 0x73b6, 0x6db6, 0x6d86, 0x6dbe, 0x73be, 0x7ffe, 0x0000 },	// U+3040 (぀)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0040, 0x01c8, 0x0070, 0x0120, 0x07e0, 0x08b0, 0x0868, 0x0864, 0x0454, 0x0308, 0x0000 },	// U+3041 (ぁ)
	{ 0x0000, 0x0020, 0x0040, 0x0340, 0x00f8, 0x0120, 0x0120, 0x07e0, 0x08b0, 0x10a8, 0x1044, 0x1064, 0x0854, 0x0608, 0x0000, 0x0000 },	// U+3042 (あ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0408, 0x0808, 0x0c08, 0x0050, 0x0030, 0x0020, 0x0000, 0x0000 },	// U+3043 (ぃ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0604, 0x0804, 0x1004, 0x1044, 0x1824, 0x1028, 0x0018, 0x0010, 0x0000, 0x0000, 0x0000 },	// U+3044 (い)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0180, 0x0000, 0x01c8, 0x0230, 0x0200, 0x0200, 0x0200, 0x0100, 0x00c0, 0x0000 },	// U+3045 (ぅ)
	{ 0x0000, 0x0040, 0x0380, 0x0000, 0x0000, 0x03c0, 0x0438, 0x0400, 0x0400, 0x0400, 0x0400, 0x0200, 0x0200, 0x0100, 0x0080, 0x0000 },	// U+3046 (う)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0180, 0x0000, 0x0380, 0x0170, 0x0080, 0x0040, 0x00e0, 0x0090, 0x0f08, 0x0000 },	// U+3047 (ぇ)
	{ 0x0000, 0x0020, 0x01c0, 0x0000, 0x0000, 0x0388, 0x0170, 0x0080, 0x0040, 0x0020, 0x0070, 0x0088, 0x0084, 0x1f04, 0x0000, 0x0000 },	// U+3048 (え)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0208, 0x0c10, 0x0430, 0x001c, 0x03d0, 0x0430, 0x0418, 0x0414, 0x0318, 0x0010, 0x0000 },	// U+3049 (ぉ)
	{ 0x0000, 0x0000, 0x0010, 0x0c20, 0x10a0, 0x3060, 0x0038, 0x0620, 0x09a0, 0x1060, 0x1030, 0x112c, 0x0e30, 0x0020, 0x0000, 0x0000 },	// U+304A (お)
	{ 0x0000, 0x0000, 0x0010, 0x0020, 0x0620, 0x08e2, 0x113c, 0x1910, 0x0110, 0x0110, 0x0108, 0x0088, 0x00a4, 0x0044, 0x0000, 0x0000 },	// U+304B (か)
	{ 0x0000, 0x1000, 0x2410, 0x0820, 0x0220, 0x04e2, 0x093c, 0x1110, 0x1910, 0x0110, 0x0108, 0x0088, 0x00a4, 0x0044, 0x0000, 0x0000 },	// U+304C (が)
	{ 0x0000, 0x0040, 0x0080, 0x0680, 0x01f0, 0x0100, 0x0f00, 0x02f8, 0x0400, 0x0400, 0x0fe0, 0x0810, 0x0010, 0x0060, 0x0380, 0x0000 },	// U+304D (き)
	{ 0x0000, 0x1020, 0x2440, 0x0b40, 0x00f8, 0x0080, 0x0780, 0x017c, 0x0200, 0x0200, 0x07f0, 0x0408, 0x0008, 0x0030, 0x01c0, 0x0000 },	// U+304E (ぎ)
	{ 0x0000, 0x0100, 0x0200, 0x0200, 0x0100, 0x0080, 0x0060, 0x0010, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0200, 0x0000 },	// U+304F (く)
	{ 0x0000, 0x0100, 0x0200, 0x0200, 0x1100, 0x2480, 0x0860, 0x0010, 0x0010, 0x0020, 0x0040, 0x0080, 0x0100, 0x0200, 0x0200, 0x0000 },	// U+3050 (ぐ)
	{ 0x0000, 0x0100, 0x0204, 0x0408, 0x0408, 0x3c08, 0x07c4, 0x0404, 0x0404, 0x0404, 0x0404, 0x0418, 0x0208, 0x0208, 0x0100, 0x0000 },	// U+3051 (け)
	{ 0x0000, 0x1080, 0x2502, 0x0a04, 0x0204, 0x1e04, 0x03e2, 0x0202, 0x0202, 0x0202, 0x0202, 0x020c, 0x0104, 0x0104, 0x0080, 0x0000 },	// U+3052 (げ)
	{ 0x0000, 0x0000, 0x0010, 0x07e0, 0x0100, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x0004, 0x0808, 0x07f0, 0x0000, 0x0000 },	// U+3053 (こ)
	{ 0x0000, 0x1000, 0x2010, 0x0fe0, 0x1100, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x0004, 0x0808, 0x07f0, 0x0000, 0x0000 },	// U+3054 (ご)
	{ 0x0000, 0x0020, 0x0040, 0x0c80, 0x0384, 0x0178, 0x0200, 0x0200, 0x07e0, 0x0410, 0x0008, 0x0008, 0x0030, 0x03c0, 0x0000, 0x0000 },	// U+3055 (さ)
	{ 0x0000, 0x1020, 0x2040, 0x0c80, 0x1384, 0x0178, 0x0200, 0x0200, 0x07e0, 0x0410, 0x0008, 0x0008, 0x0030, 0x03c0, 0x0000, 0x0000 },	// U+3056 (ざ)
	{ 0x0000, 0x0000, 0x0008, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x1010, 0x0810, 0x0620, 0x01c0, 0x0000, 0x0000 },	// U+3057 (し)
	{ 0x0000, 0x0000, 0x0408, 0x0910, 0x0210, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x1010, 0x0810, 0x0620, 0x01c0, 0x0000, 0x0000 },	// U+3058 (じ)
	{ 0x0000, 0x0080, 0x0100, 0x1f02, 0x01fc, 0x0100, 0x01c0, 0x0320, 0x0220, 0x03c0, 0x0200, 0x0100, 0x0100, 0x0080, 0x0040, 0x0000 },	// U+3059 (す)
	{ 0x0000, 0x1480, 0x2900, 0x1f02, 0x01fc, 0x0100, 0x01c0, 0x0320, 0x0220, 0x03c0, 0x0200, 0x0100, 0x0100, 0x0080, 0x0040, 0x0000 },	// U+305A (ず)
	{ 0x0000, 0x0000, 0x0100, 0x0208, 0x0210, 0x1e10, 0x03d2, 0x023c, 0x0210, 0x0210, 0x0310, 0x0210, 0x0020, 0x07c0, 0x0000, 0x0000 },	// U+305B (せ)
	{ 0x0000, 0x1000, 0x2100, 0x0a08, 0x1210, 0x1e10, 0x03d2, 0x023c, 0x0210, 0x0210, 0x0310, 0x0210, 0x0020, 0x07c0, 0x0000, 0x0000 },	// U+305C (ぜ)
	{ 0x0000, 0x0000, 0x0390, 0x0260, 0x0100, 0x0080, 0x1c40, 0x03e0, 0x011c, 0x0080, 0x0040, 0x0040, 0x0040, 0x0080, 0x0700, 0x0000 },	// U+305D (そ)
	{ 0x0000, 0x0000, 0x1390, 0x2660, 0x0900, 0x0080, 0x1c40, 0x03e0, 0x011c, 0x0080, 0x0040, 0x0040, 0x0040, 0x0080, 0x0700, 0x0000 },	// U+305E (ぞ)
	{ 0x0000, 0x0000, 0x0010, 0x0120, 0x00e0, 0x003c, 0x0f10, 0x1810, 0x0410, 0x0008, 0x0008, 0x0088, 0x0084, 0x1f04, 0x0000, 0x0000 },	// U+305F (た)
	{ 0x0000, 0x1000, 0x2410, 0x0920, 0x00e0, 0x003c, 0x0f10, 0x1810, 0x0410, 0x0008, 0x0008, 0x0088, 0x0084, 0x1f04, 0x0000, 0x0000 },	// U+3060 (だ)
	{ 0x0000, 0x0010, 0x0020, 0x0320, 0x00e2, 0x003c, 0x0010, 0x0310, 0x04d0, 0x0838, 0x0808, 0x0800, 0x0400, 0x0300, 0x00e0, 0x0000 },	// U+3061 (ち)
	{ 0x0000, 0x0010, 0x1020, 0x2320, 0x08e2, 0x103c, 0x0010, 0x0310, 0x04d0, 0x0838, 0x0808, 0x0800, 0x0400, 0x0300, 0x00e0, 0x0000 },	// U+3062 (ぢ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0380, 0x0460, 0x081c, 0x0800, 0x0800, 0x0400, 0x0300, 0x00e0, 0x0000 },	// U+3063 (っ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x0832, 0x100c, 0x1000, 0x1000, 0x1000, 0x0800, 0x0600, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+3064 (つ)
	{ 0x0000, 0x1000, 0x2400, 0x0800, 0x07c0, 0x0832, 0x100c, 0x1000, 0x1000, 0x1000, 0x0800, 0x0600, 0x01c0, 0x0000, 0x0000, 0x0000 },	// U+3065 (づ)
	{ 0x0000, 0x0000, 0x1c00, 0x03c2, 0x013c, 0x0080, 0x0080, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0080, 0x0700, 0x0000, 0x0000 },	// U+3066 (て)
	{ 0x0000, 0x0000, 0x1c00, 0x03c2, 0x113c, 0x2480, 0x0880, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0080, 0x0700, 0x0000, 0x0000 },	// U+3067 (で)
	{ 0x0000, 0x0000, 0x0020, 0x0040, 0x0040, 0x0040, 0x0e40, 0x01c0, 0x0060, 0x0010, 0x0008, 0x0008, 0x0010, 0x0fe0, 0x0000, 0x0000 },	// U+3068 (と)
	{ 0x0000, 0x0000, 0x1020, 0x2440, 0x0840, 0x0040, 0x0e40, 0x01c0, 0x0060, 0x0010, 0x0008, 0x0008, 0x0010, 0x0fe0, 0x0000, 0x0000 },	// U+3069 (ど)
	{ 0x0000, 0x0020, 0x0040, 0x0140, 0x00fc, 0x0e20, 0x1810, 0x0410, 0x0208, 0x0208, 0x0204, 0x03c0, 0x0620, 0x0a20, 0x01c0, 0x0000 },	// U+306A (な)
	{ 0x0000, 0x0000, 0x0004, 0x0008, 0x0f08, 0x18c8, 0x0404, 0x0004, 0x0004, 0x0004, 0x0044, 0x0054, 0x1f88, 0x0008, 0x0008, 0x0000 },	// U+306B (に)
	{ 0x0000, 0x0000, 0x0080, 0x0100, 0x0100, 0x07c8, 0x08a8, 0x1098, 0x1048, 0x1054, 0x1032, 0x1632, 0x092a, 0x1604, 0x0000, 0x0000 },	// U+306C (ぬ)
	{ 0x0000, 0x0008, 0x0010, 0x0010, 0x0010, 0x0732, 0x08fc, 0x0830, 0x0810, 0x0818, 0x0818, 0x0f14, 0x189a, 0x0710, 0x0000, 0x0000 },	// U+306D (ね)
	{ 0x0000, 0x0000, 0x0000, 0x03c0, 0x04b0, 0x0888, 0x1088, 0x1044, 0x1044, 0x1024, 0x0824, 0x0814, 0x0608, 0x0180, 0x0000, 0x0000 },	// U+306E (の)
	{ 0x0000, 0x0200, 0x0404, 0x0408, 0x1c28, 0x07c8, 0x0404, 0x0404, 0x0404, 0x0404, 0x0794, 0x0c48, 0x1448, 0x0388, 0x0000, 0x0000 },	// U+306F (は)
	{ 0x0000, 0x1100, 0x2202, 0x0a04, 0x1e14, 0x03e4, 0x0202, 0x0202, 0x0202, 0x0202, 0x03ca, 0x0624, 0x0a24, 0x01c4, 0x0000, 0x0000 },	// U+3070 (ば)
	{ 0x0000, 0x1900, 0x2602, 0x2604, 0x1e14, 0x03e4, 0x0202, 0x0202, 0x0202, 0x0202, 0x03ca, 0x0624, 0x0a24, 0x01c4, 0x0000, 0x0000 },	// U+3071 (ぱ)
	{ 0x0000, 0x0000, 0x0200, 0x0220, 0x043c, 0x0410, 0x0c10, 0x1408, 0x0408, 0x0408, 0x0208, 0x0208, 0x0110, 0x00e0, 0x0000, 0x0000 },	// U+3072 (ひ)
	{ 0x0000, 0x1000, 0x2200, 0x0a20, 0x143c, 0x0410, 0x0c10, 0x1408, 0x0408, 0x0408, 0x0208, 0x0208, 0x0110, 0x00e0, 0x0000, 0x0000 },	// U+3073 (び)
	{ 0x0000, 0x0c00, 0x1200, 0x1220, 0x0c3c, 0x0410, 0x0c10, 0x1408, 0x0408, 0x0408, 0x0208, 0x0208, 0x0110, 0x00e0, 0x0000, 0x0000 },	// U+3074 (ぴ)
	{ 0x0000, 0x0000, 0x0020, 0x01c0, 0x0100, 0x0080, 0x0040, 0x0040, 0x0080, 0x0d40, 0x1132, 0x391c, 0x0124, 0x00c0, 0x0000, 0x0000 },	// U+3075 (ふ)
	{ 0x0000, 0x0000, 0x0020, 0x11c0, 0x2500, 0x0880, 0x0040, 0x0040, 0x0080, 0x0d40, 0x1132, 0x391c, 0x0124, 0x00c0, 0x0000, 0x0000 },	// U+3076 (ぶ)
	{ 0x0000, 0x0000, 0x0020, 0x19c0, 0x2500, 0x2480, 0x1840, 0x0040, 0x0080, 0x0d40, 0x1132, 0x391c, 0x0124, 0x00c0, 0x0000, 0x0000 },	// U+3077 (ぷ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0090, 0x0108, 0x0204, 0x0c00, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+3078 (へ)
	{ 0x0000, 0x0000, 0x0000, 0x0800, 0x1200, 0x0460, 0x0090, 0x0108, 0x0204, 0x0c00, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+3079 (べ)
	{ 0x0000, 0x0000, 0x0c00, 0x1200, 0x1200, 0x0c60, 0x0090, 0x0108, 0x0204, 0x0c00, 0x3000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+307A (ぺ)
	{ 0x0000, 0x0000, 0x0c44, 0x0388, 0x0208, 0x1c08, 0x07c4, 0x0404, 0x0404, 0x0404, 0x0794, 0x0c48, 0x1448, 0x0388, 0x0000, 0x0000 },	// U+307B (ほ)
	{ 0x0000, 0x0000, 0x1622, 0x21c4, 0x0904, 0x1e04, 0x03e2, 0x0202, 0x0202, 0x0202, 0x03ca, 0x0624, 0x0a24, 0x01c4, 0x0000, 0x0000 },	// U+307C (ぼ)
	{ 0x0000, 0x1800, 0x2622, 0x25c4, 0x1904, 0x0e04, 0x03e2, 0x0202, 0x0202, 0x0202, 0x03ca, 0x0624, 0x0a24, 0x01c4, 0x0000, 0x0000 },	// U+307D (ぽ)
	{ 0x0000, 0x0080, 0x0100, 0x0f08, 0x01f0, 0x0100, 0x0708, 0x01f0, 0x0100, 0x0100, 0x01f0, 0x0708, 0x0908, 0x00f0, 0x0000, 0x0000 },	// U+307E (ま)
	{ 0x0000, 0x0000, 0x0110, 0x01e0, 0x0080, 0x0080, 0x0440, 0x0840, 0x0ff0, 0x182c, 0x2422, 0x0412, 0x020c, 0x0100, 0x0000, 0x0000 },	// U+307F (み)
	{ 0x0000, 0x0010, 0x0020, 0x00e4, 0x0c38, 0x1020, 0x3038, 0x0024, 0x0024, 0x0434, 0x0818, 0x0810, 0x0810, 0x07e0, 0x0000, 0x0000 },	// U+3080 (む)
	{ 0x0000, 0x0000, 0x0080, 0x0100, 0x0108, 0x03c8, 0x0538, 0x0888, 0x1094, 0x1054, 0x1062, 0x1022, 0x0852, 0x060c, 0x0000, 0x0000 },	// U+3081 (め)
	{ 0x0000, 0x0040, 0x0080, 0x0088, 0x0070, 0x01c0, 0x0048, 0x0424, 0x0438, 0x08e0, 0x0820, 0x0820, 0x0820, 0x0440, 0x0380, 0x0000 },	// U+3082 (も)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0110, 0x0790, 0x0870, 0x083c, 0x0620, 0x0040, 0x0040, 0x0080, 0x0080, 0x0000 },	// U+3083 (ゃ)
	{ 0x0000, 0x0080, 0x0100, 0x0380, 0x0018, 0x0f08, 0x10d0, 0x1032, 0x102c, 0x0e40, 0x0040, 0x0080, 0x0080, 0x0100, 0x0100, 0x0000 },	// U+3084 (や)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0080, 0x0784, 0x08e4, 0x0894, 0x088c, 0x04c4, 0x0384, 0x0080, 0x0040, 0x0000 },	// U+3085 (ゅ)
	{ 0x0000, 0x0000, 0x00c0, 0x0102, 0x0784, 0x0944, 0x1124, 0x1114, 0x110c, 0x112c, 0x0944, 0x0784, 0x0100, 0x0080, 0x0040, 0x0000 },	// U+3086 (ゆ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0080, 0x0480, 0x0380, 0x0080, 0x0080, 0x0080, 0x00f0, 0x0388, 0x0488, 0x0070, 0x0000 },	// U+3087 (ょ)
	{ 0x0000, 0x0040, 0x0080, 0x0080, 0x0c80, 0x0380, 0x0080, 0x0080, 0x0080, 0x0080, 0x01f8, 0x0684, 0x0884, 0x0078, 0x0000, 0x0000 },	// U+3088 (よ)
	{ 0x0000, 0x0040, 0x0080, 0x0380, 0x0060, 0x0010, 0x0010, 0x0010, 0x0790, 0x0870, 0x0810, 0x0810, 0x0400, 0x0300, 0x00c0, 0x0000 },	// U+3089 (ら)
	{ 0x0000, 0x0008, 0x0190, 0x0250, 0x0430, 0x0430, 0x0410, 0x0410, 0x0410, 0x0410, 0x0200, 0x0200, 0x0100, 0x0080, 0x0040, 0x0000 },	// U+308A (り)
	{ 0x0000, 0x0000, 0x0310, 0x02e0, 0x0100, 0x0080, 0x0040, 0x03e0, 0x0430, 0x0808, 0x0804, 0x09c0, 0x0620, 0x0220, 0x01c0, 0x0000 },	// U+308B (る)
	{ 0x0000, 0x0000, 0x0008, 0x0010, 0x0390, 0x0450, 0x0438, 0x0436, 0x0410, 0x0418, 0x0418, 0x0414, 0x2412, 0x1818, 0x0010, 0x0000 },	// U+308C (れ)
	{ 0x0000, 0x0000, 0x0188, 0x0170, 0x0080, 0x0040, 0x0020, 0x03f0, 0x0410, 0x0808, 0x0804, 0x0800, 0x0400, 0x0300, 0x00e0, 0x0000 },	// U+308D (ろ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0020, 0x0020, 0x0760, 0x08b8, 0x0860, 0x0830, 0x0830, 0x0428, 0x0220, 0x0000 },	// U+308E (ゎ)
	{ 0x0000, 0x0008, 0x0010, 0x0010, 0x0010, 0x0732, 0x08fc, 0x1030, 0x1010, 0x1018, 0x1018, 0x0814, 0x0412, 0x0318, 0x0010, 0x0000 },	// U+308F (わ)
	{ 0x0000, 0x0000, 0x0190, 0x0160, 0x0080, 0x0080, 0x07c0, 0x0870, 0x1048, 0x1024, 0x1024, 0x1314, 0x0c98, 0x0708, 0x0000, 0x0000 },	// U+3090 (ゐ)
	{ 0x0000, 0x0000, 0x0190, 0x00e0, 0x0040, 0x03e0, 0x0410, 0x0408, 0x0460, 0x0390, 0x00e0, 0x0010, 0x0738, 0x08c4, 0x1c02, 0x0000 },	// U+3091 (ゑ)
	{ 0x0000, 0x0020, 0x0040, 0x0348, 0x00f0, 0x0020, 0x0420, 0x1cf0, 0x0318, 0x0184, 0x0140, 0x0120, 0x0010, 0x0010, 0x07e0, 0x0000 },	// U+3092 (を)
	{ 0x0000, 0x0040, 0x0080, 0x0080, 0x0040, 0x0040, 0x0020, 0x0020, 0x00f0, 0x0110, 0x0108, 0x1108, 0x0904, 0x0604, 0x0000, 0x0000 },	// U+3093 (ん)
	{ 0x0000, 0x0040, 0x1380, 0x2000, 0x0800, 0x13c0, 0x0438, 0x0400, 0x0400, 0x0400, 0x0400, 0x0200, 0x0200, 0x0100, 0x0080, 0x0000 },	// U+3094 (ゔ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0620, 0x08fc, 0x1120, 0x1910, 0x0108, 0x0088, 0x00a4, 0x0044, 0x0000, 0x0000 },	// U+3095 (ゕ)
	{ 0x0000, 0x0000, 0x0000, 0x0100, 0x0200, 0x0410, 0x0410, 0x1c10, 0x0788, 0x0408, 0x0408, 0x0428, 0x0228, 0x0210, 0x0100, 0x0000 },	// U+3096 (ゖ)
	{ 0x0000, 0x7ffe, 0x73c6, 0x6dbe, 0x6d8e, 0x6dbe, 0x73c6, 0x7ffe, 0x7ffe, 0x61ce, 0x6fb6, 0x778e, 0x7bbe, 0x7bce, 0x7ffe, 0x0000 },	// U+3097 (゗)
	{ 0x0000, 0x7ffe, 0x73c6, 0x6dbe, 0x6d8e, 0x6dbe, 0x73c6, 0x7ffe, 0x7ffe, 0x73ce, 0x6db6, 0x738e, 0x6dbe, 0x73ce, 0x7ffe, 0x0000 },	// U+3098 (゘)
	{ 0x0000, 0x2000, 0x4800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+3099 (゙)
	{ 0x0000, 0x6000, 0x9000, 0x9000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+309A (゚)
	{ 0x0000, 0x0008, 0x0012, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+309B (゛)
	{ 0x0000, 0x000c, 0x0012, 0x0012, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+309C (゜)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x00c0, 0x0100, 0x0300, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+309D (ゝ)
	{ 0x0000, 0x0000, 0x0000, 0x0400, 0x0900, 0x0230, 0x00c0, 0x0100, 0x0300, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+309E (ゞ)
	{ 0x0000, 0x0000, 0x0060, 0x0180, 0x0010, 0x0010, 0x0010, 0x0010, 0x03f0, 0x0408, 0x0800, 0x0800, 0x0400, 0x0300, 0x00c0, 0x0000 },	// U+309F (ゟ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0000, 0x0000, 0x0000, 0x07e0, 0x0000, 0x0000, 0x0000, 0x0000 },	// U+30A0 (゠)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0784, 0x0478, 0x0240, 0x0180, 0x0080, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+30A1 (ァ)
	{ 0x0000, 0x0000, 0x0000, 0x0f84, 0x0878, 0x0400, 0x0240, 0x0180, 0x0080, 0x0080, 0x0080, 0x0040, 0x0040, 0x0020, 0x0010, 0x0000 },	// U+30A2 (ア)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0200, 0x0100, 0x01c0, 0x0138, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000 },	// U+30A3 (ィ)
	{ 0x0000, 0x0000, 0x0400, 0x0400, 0x0200, 0x0100, 0x00c0, 0x00b0, 0x010c, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000 },	// U+30A4 (イ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0040, 0x0080, 0x0780, 0x0478, 0x0410, 0x0210, 0x0200, 0x0100, 0x0080, 0x0040, 0x0000 },	// U+30A5 (ゥ)
	{ 0x0000, 0x0000, 0x0040, 0x0080, 0x0080, 0x0f80, 0x087c, 0x0808, 0x0408, 0x0410, 0x0210, 0x0200, 0x0100, 0x0080, 0x0040, 0x0000 },	// U+30A6 (ウ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0700, 0x00f0, 0x0080, 0x0080, 0x0080, 0x0780, 0x0878, 0x0000, 0x0000 },	// U+30A7 (ェ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0e00, 0x01f8, 0x0040, 0x0080, 0x0080, 0x0080, 0x0080, 0x0fc0, 0x103c, 0x0000, 0x0000, 0x0000 },	// U+30A8 (エ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0100, 0x0708, 0x01f0, 0x0180, 0x0140, 0x0120, 0x0110, 0x0188, 0x0100, 0x0000 },	// U+30A9 (ォ)
	{ 0x0000, 0x0000, 0x0100, 0x0200, 0x0200, 0x1e04, 0x03f8, 0x0300, 0x0280, 0x0240, 0x0220, 0x0210, 0x0208, 0x0300, 0x0200, 0x0000 },	// U+30AA (オ)
	{ 0x0000, 0x0000, 0x0040, 0x0080, 0x0080, 0x0f84, 0x08f8, 0x0840, 0x0840, 0x0420, 0x0420, 0x0410, 0x0288, 0x0304, 0x0100, 0x0000 },	// U+30AB (カ)
	{ 0x0000, 0x1000, 0x2440, 0x2880, 0x0880, 0x0f84, 0x08f8, 0x0840, 0x0840, 0x0420, 0x0420, 0x0410, 0x0288, 0x0304, 0x0100, 0x0000 },	// U+30AC (ガ)
	{ 0x0000, 0x0000, 0x0020, 0x0040, 0x0e40, 0x01c0, 0x00b8, 0x0080, 0x1e80, 0x01c0, 0x013c, 0x0100, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+30AD (キ)
	{ 0x0000, 0x1000, 0x2420, 0x2840, 0x0e40, 0x01c0, 0x00b8, 0x0080, 0x1e80, 0x01c0, 0x013c, 0x0100, 0x0200, 0x0200, 0x0200, 0x0000 },	// U+30AE (ギ)
	{ 0x0000, 0x0000, 0x0020, 0x0e40, 0x09c0, 0x0440, 0x0420, 0x0220, 0x0210, 0x0108, 0x0100, 0x0080, 0x0040, 0x0020, 0x0010, 0x0000 },	// U+30AF (ク)
	{ 0x0000, 0x1000, 0x2410, 0x2b20, 0x0ae0, 0x0220, 0x0210, 0x0110, 0x0108, 0x0084, 0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x0000 },	// U+30B0 (グ)
	{ 0x0000, 0x0000, 0x0010, 0x0020, 0x0020, 0x1c20, 0x03f0, 0x0090, 0x0108, 0x0104, 0x0100, 0x0080, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+30B1 (ケ)
	{ 0x0000, 0x1000, 0x2410, 0x2820, 0x0820, 0x1c20, 0x03f0, 0x0090, 0x0108, 0x0104, 0x0100, 0x0080, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+30B2 (ゲ)
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0f84, 0x0878, 0x0800, 0x0800, 0x0800, 0x0400, 0x0400, 0x07c0, 0x0438, 0x0000, 0x0000, 0x0000 },	// U+30B3 (コ)
	{ 0x0000, 0x1000, 0x2400, 0x2800, 0x0bc2, 0x023c, 0x0200, 0x0200, 0x0200, 0x0100, 0x0100, 0x01e0, 0x011c, 0x0000, 0x0000, 0x0000 },	// U+30B4 (ゴ)
	{ 0x0000, 0x0000, 0x0100, 0x0210, 0x0220, 0x0220, 0x1f24, 0x02f8, 0x0220, 0x0220, 0x0220, 0x0100, 0x0100, 0x0080, 0x0040, 0x0000 },	// U+30B5 (サ)
	{ 0x0000, 0x1000, 0x2500, 0x2a10, 0x0a20, 0x0220, 0x1f24, 0x02f8, 0x0220, 0x0220, 0x0220, 0x0100, 0x0100, 0x0080, 0x0040, 0x0000 },	// U+30B6 (ザ)
	{ 0x0000, 0x0000, 0x0000, 0x0030, 0x0040, 0x0000, 0x0018, 0x1020, 0x0800, 0x0400, 0x0200, 0x0100, 0x00c8, 0x0030, 0x0000, 0x0000 },	// U+30B7 (シ)
	{ 0x0000, 0x0000, 0x1000, 0x2430, 0x2840, 0x0800, 0x0018, 0x1020, 0x0800, 0x0400, 0x0200, 0x0100, 0x00c8, 0x0030, 0x0000, 0x0000 },	// U+30B8 (ジ)
	{ 0x0000, 0x0000, 0x0000, 0x0708, 0x04f0, 0x0200, 0x0200, 0x0100, 0x0100, 0x0280, 0x0440, 0x0830, 0x080c, 0x0000, 0x0000, 0x0000 },	// U+30B9 (ス)
	{ 0x0000, 0x1000, 0x2400, 0x2b84, 0x0a78, 0x0100, 0x0100, 0x0080, 0x0080, 0x0140, 0x0220, 0x0418, 0x0406, 0x0000, 0x0000, 0x0000 },	// U+30BA (ズ)
	{ 0x0000, 0x0000, 0x0010, 0x0020, 0x0020, 0x1e20, 0x11a0, 0x0864, 0x0438, 0x0220, 0x0020, 0x0020, 0x0040, 0x0f80, 0x0000, 0x0000 },	// U+30BB (セ)
	{ 0x0000, 0x1000, 0x2410, 0x2820, 0x0820, 0x1e20, 0x11a0, 0x0864, 0x0438, 0x0220, 0x0020, 0x0020, 0x0040, 0x1f80, 0x0000, 0x0000 },	// U+30BC (ゼ)
	{ 0x0000, 0x0000, 0x0400, 0x0808, 0x0810, 0x0820, 0x0420, 0x0420, 0x0200, 0x0200, 0x0100, 0x0100, 0x0080, 0x0040, 0x0020, 0x0000 },	// U+30BD (ソ)
	{ 0x0000, 0x1000, 0x2500, 0x2a04, 0x0a08, 0x0210, 0x0210, 0x0210, 0x0100, 0x0100, 0x0080, 0x0080, 0x0040, 0x0020, 0x0010, 0x0000 },	// U+30BE (ゾ)
	{ 0x0000, 0x0000, 0x0040, 0x0080, 0x0f80, 0x0840, 0x0440, 0x04a0, 0x0310, 0x0208, 0x0100, 0x0080, 0x0040, 0x0030, 0x000c, 0x0000 },	// U+30BF (タ)
	{ 0x0000, 0x1000, 0x2420, 0x2840, 0x0fc0, 0x0420, 0x0420, 0x0250, 0x0288, 0x0104, 0x0080, 0x0040, 0x0020, 0x0018, 0x0006, 0x0000 },	// U+30C0 (ダ)
	{ 0x0000, 0x0000, 0x0200, 0x0180, 0x0078, 0x0080, 0x1f00, 0x01c4, 0x0138, 0x0100, 0x0100, 0x0080, 0