/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font unifont-8x16.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char unifont_block1[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x48, 0x7e, 0x24, 0x24, 0x7e, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x12, 0x1c, 0x70, 0x90, 0x92, 0x7c, 0x10, 0x00, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x00, 0x8c, 0x52, 0x52, 0x2c, 0x10, 0x10, 0x68, 0x94, 0x94, 0x62, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x28, 0x18, 0x94, 0xa2, 0x42, 0x62, 0x9c, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x00 },	// U+0028 (()
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x92, 0x54, 0x38, 0x54, 0x92, 0x10, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x30, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x38, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x28, 0x24, 0x22, 0x22, 0x7e, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x20, 0x1c, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x20, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x52, 0x6a, 0x4a, 0x4a, 0x4a, 0x72, 0x04, 0x78, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x66, 0x3c, 0xc0, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x00, 0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x70, 0x00 },	// U+005B ([)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x40, 0x40, 0x00, 0x00 },	// U+005C (\)
	{ 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00 },	// U+005D (])
	{ 0x00, 0x00, 0x18, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00 },	// U+005F (_)
	{ 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x1c, 0x04, 0x3c, 0x42, 0x42, 0x3c },	// U+0067 (g)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x12, 0x0c },	// U+006A (j)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x18, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x10, 0x10, 0x08, 0x04, 0x08, 0x10, 0x10, 0x08, 0x08, 0x30 },	// U+007B ({)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+007C (|)
	{ 0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x08, 0x08, 0x10, 0x20, 0x10, 0x08, 0x08, 0x10, 0x10, 0x0c },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x8c, 0x92, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
}; // 95

static const unsigned char unifont_block2[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x92, 0x12, 0x12, 0x92, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x7c, 0x86, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x3c, 0x24, 0x42, 0x42, 0x24, 0x3c, 0x42, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0xfe, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x42, 0x42, 0x3c, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x99, 0xa5, 0x85, 0x85, 0xa5, 0x99, 0x42, 0x3c, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x00, 0x38, 0x40, 0x78, 0x44, 0x78, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x24, 0x24, 0x12, 0x24, 0x24, 0x48, 0x48, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+00AC (¬)
}; // 13

static const unsigned char unifont_block3[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x9d, 0xa5, 0xa5, 0x9d, 0x95, 0xa5, 0x42, 0x3c, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0xfe, 0x00, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x18, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x1c, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x66, 0x9a, 0x02, 0x01 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x5e, 0x5e, 0x5e, 0x5c, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0c },	// U+00B8 (¸)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x24, 0x24, 0x48, 0x24, 0x24, 0x12, 0x12, 0x00, 0x00 },	// U+00BB (»)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x24, 0x14, 0x14, 0x48, 0x68, 0x54, 0x72, 0x42, 0x00, 0x00 },	// U+00BC (¼)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x24, 0x14, 0x14, 0x28, 0x58, 0x44, 0x22, 0x72, 0x00, 0x00 },	// U+00BD (½)
	{ 0x00, 0x00, 0x00, 0x00, 0x46, 0x48, 0x24, 0x18, 0x16, 0x48, 0x68, 0x54, 0x72, 0x42, 0x00, 0x00 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x08, 0x08, 0x04, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00BF (¿)
	{ 0x0c, 0x30, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x30, 0x0c, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x18, 0x24, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x4c, 0x32, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x24, 0x24, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x18, 0x24, 0x18, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x14, 0x12, 0x12, 0xfe, 0x12, 0x12, 0x12, 0x12, 0xf2, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x10, 0x0c },	// U+00C7 (Ç)
	{ 0x0c, 0x30, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x30, 0x0c, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x18, 0x24, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x24, 0x24, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x18, 0x60, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x30, 0x0c, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x18, 0x24, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x24, 0x24, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x4f, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x4c, 0x32, 0x00, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x0c, 0x30, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x4c, 0x32, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x00, 0x00, 0x40, 0x5c, 0x22, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x44, 0x3a, 0x02, 0x00 },	// U+00D8 (Ø)
	{ 0x0c, 0x30, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x30, 0x0c, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x18, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x30, 0x0c, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x42, 0x42, 0x22, 0x1e, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x12, 0x1a, 0x22, 0x42, 0x42, 0x4a, 0x32, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x18, 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x90, 0xfc, 0x12, 0x12, 0x92, 0x7c, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x10, 0x0c },	// U+00E7 (ç)
	{ 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x00, 0x4c, 0x30, 0x28, 0x44, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x3c, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x3c, 0x02, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+00FD (ý)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+00FF (ÿ)
	{ 0x00, 0x3c, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0101 (ā)
	{ 0x42, 0x42, 0x3c, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x20, 0xc0 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x20, 0xc0 },	// U+0105 (ą)
	{ 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x08, 0x08, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+010B (ċ)
	{ 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+010D (č)
	{ 0x12, 0x0c, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x24, 0x18, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x4f, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x00, 0x00, 0x40, 0xf0, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x00, 0x3c, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0113 (ē)
	{ 0x42, 0x42, 0x3c, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0114 (Ĕ)
	{ 0x00, 0x00, 0x42, 0x42, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0115 (ĕ)
	{ 0x08, 0x08, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x10, 0x60 },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x08, 0x30 },	// U+0119 (ę)
	{ 0x24, 0x18, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+011B (ě)
	{ 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x1c, 0x04, 0x3c, 0x42, 0x42, 0x3c },	// U+011D (ĝ)
	{ 0x42, 0x42, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x42, 0x42, 0x3c, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x1c, 0x04, 0x3c, 0x42, 0x42, 0x3c },	// U+011F (ğ)
	{ 0x08, 0x08, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x08, 0x08, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x1c, 0x04, 0x3c, 0x42, 0x42, 0x3c },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x62, 0x5c, 0x10, 0x0c },	// U+0122 (Ģ)
	{ 0x00, 0x00, 0x30, 0x08, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x1c, 0x04, 0x3c, 0x42, 0x42, 0x3c },	// U+0123 (ģ)
	{ 0x18, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x0c, 0x12, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0xff, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0x4c, 0x32, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x00, 0x3c, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+012B (ī)
	{ 0x42, 0x42, 0x3c, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+012C (Ĭ)
	{ 0x00, 0x00, 0x42, 0x42, 0x3c, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+012D (ĭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x60 },	// U+012E (Į)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x60 },	// U+012F (į)
	{ 0x10, 0x10, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0131 (ı)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+0132 (Ĳ)
	{ 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x58, 0x40, 0x44, 0x38 },	// U+0133 (ĳ)
	{ 0x30, 0x48, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x00, 0x30, 0x48, 0x00, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x12, 0x0c },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x04, 0x03 },	// U+0136 (Ķ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x04, 0x03 },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0e, 0x0e, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x18, 0x06, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x30, 0x0c, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x10, 0x0c },	// U+013B (Ļ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x0c },	// U+013C (ļ)
	{ 0x24, 0x18, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x24, 0x18, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+013E (ľ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x22, 0x22, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+013F (Ŀ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x28, 0x28, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+0140 (ŀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x12, 0x0a, 0x06, 0x03, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x50, 0x30, 0x18, 0x14, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x30, 0x0c, 0x00, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x04, 0x03 },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x04, 0x03 },	// U+0146 (ņ)
	{ 0x24, 0x18, 0x00, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0148 (ň)
	{ 0x00, 0x06, 0x04, 0x04, 0x02, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0149 (ŉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x32, 0x00, 0x00 },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x30 },	// U+014B (ŋ)
	{ 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+014D (ō)
	{ 0x42, 0x42, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+014E (Ŏ)
	{ 0x00, 0x00, 0x42, 0x42, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+014F (ŏ)
	{ 0xcc, 0x22, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x00, 0xcc, 0x22, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x00, 0x00, 0xec, 0x12, 0x12, 0x12, 0x72, 0x12, 0x12, 0x12, 0x12, 0xec, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0xf2, 0x12, 0x12, 0x92, 0x6c, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x30, 0x0c, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x04, 0x03 },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x03 },	// U+0157 (ŗ)
	{ 0x24, 0x18, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+015B (ś)
	{ 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x10, 0x0c },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x10, 0x0c },	// U+015F (ş)
	{ 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x10, 0x0c },	// U+0163 (ţ)
	{ 0x24, 0x18, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x24, 0x18, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0x4c, 0x32, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x00, 0x3c, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+016B (ū)
	{ 0x42, 0x42, 0x3c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x18, 0x24, 0x18, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x00, 0x00, 0x18, 0x24, 0x18, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+016F (ů)
	{ 0xcc, 0x22, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x00, 0xcc, 0x22, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x30 },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x20, 0xc0 },	// U+0173 (ų)
	{ 0x18, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x18, 0x24, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+0177 (ŷ)
	{ 0x24, 0x24, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x30, 0x0c, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+017A (ź)
	{ 0x08, 0x08, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+017C (ż)
	{ 0x24, 0x18, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+017E (ž)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+017F (ſ)
	{ 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00 },	// U+0180 (ƀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x45, 0x45, 0x44, 0x3c, 0x44, 0x44, 0x44, 0x44, 0x3c, 0x00, 0x00 },	// U+0181 (Ɓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+0182 (Ƃ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00 },	// U+0183 (ƃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x3c, 0x44, 0x44, 0x44, 0x44, 0x3c, 0x00, 0x00 },	// U+0184 (Ƅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x3c, 0x44, 0x44, 0x3c, 0x00, 0x00 },	// U+0185 (ƅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0186 (Ɔ)
	{ 0x00, 0x00, 0xc0, 0x20, 0x3c, 0x22, 0x22, 0x02, 0x02, 0x02, 0x02, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+0187 (Ƈ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x3c, 0x22, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00 },	// U+0188 (ƈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x4f, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+0189 (Ɖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x25, 0x45, 0x44, 0x44, 0x44, 0x44, 0x44, 0x24, 0x1c, 0x00, 0x00 },	// U+018A (Ɗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00 },	// U+018B (Ƌ)
	{ 0x00, 0x00, 0x00, 0x7c, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+018C (ƌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x20, 0x20, 0x1c },	// U+018D (ƍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+018E (Ǝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x40, 0x40, 0x7e, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+018F (Ə)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x1c, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0190 (Ɛ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06, 0x00 },	// U+0191 (Ƒ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06, 0x00 },	// U+0192 (ƒ)
	{ 0x00, 0x00, 0x00, 0xc0, 0x3c, 0x22, 0x22, 0x02, 0x02, 0x3a, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+0193 (Ɠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0194 (Ɣ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x4e, 0x52, 0x52, 0x52, 0x52, 0x52, 0x22, 0x00, 0x00 },	// U+0195 (ƕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x60, 0x00, 0x00 },	// U+0196 (Ɩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0197 (Ɨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x62, 0x52, 0x0a, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+0198 (Ƙ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+0199 (ƙ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+019A (ƚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x14, 0x08, 0x0c, 0x12, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+019B (ƛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xec, 0x00, 0x00 },	// U+019C (Ɯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x4c, 0x4c, 0x54, 0x54, 0x64, 0x64, 0x44, 0x44, 0x03, 0x00 },	// U+019D (Ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+019E (ƞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+019F (Ɵ)
	{ 0x00, 0x00, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+01A0 (Ơ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+01A1 (ơ)
	{ 0x00, 0x00, 0x00, 0x00, 0x6c, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x4c, 0x40, 0x40 },	// U+01A2 (Ƣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x4c, 0x40, 0x40 },	// U+01A3 (ƣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x8a, 0x8a, 0x88, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+01A4 (Ƥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x26, 0x1a, 0x02, 0x02 },	// U+01A5 (ƥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x3c, 0x44, 0x44, 0x3c, 0x14, 0x24, 0x44, 0x84, 0x00, 0x00 },	// U+01A6 (Ʀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x30, 0x0c, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+01A7 (Ƨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x30, 0x0c, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+01A8 (ƨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x04, 0x08, 0x10, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+01A9 (Ʃ)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00 },	// U+01AA (ƪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x20, 0x18 },	// U+01AB (ƫ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+01AC (Ƭ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+01AD (ƭ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x60, 0x00 },	// U+01AE (Ʈ)
	{ 0x00, 0x00, 0x80, 0x80, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+01AF (Ư)
	{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+01B0 (ư)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+01B1 (Ʊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x12, 0x0c, 0x00, 0x00 },	// U+01B2 (Ʋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x62, 0xa2, 0x22, 0x14, 0x14, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+01B3 (Ƴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x38, 0x20, 0x20, 0x1c },	// U+01B4 (ƴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x3c, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+01B5 (Ƶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x3c, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+01B6 (ƶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x08, 0x38, 0x40, 0x40, 0x40, 0x62, 0x3c, 0x00, 0x00 },	// U+01B7 (Ʒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x08, 0x10, 0x1c, 0x02, 0x02, 0x02, 0x46, 0x3c, 0x00, 0x00 },	// U+01B8 (Ƹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x04, 0x08, 0x10, 0x1c, 0x02, 0x02, 0x02, 0x42, 0x3c },	// U+01B9 (ƹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x20, 0x10, 0x38, 0x40, 0x40, 0x3c, 0x02, 0x42, 0x3c },	// U+01BA (ƺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x20, 0x10, 0x7e, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+01BB (ƻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x04, 0x04, 0x3c, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+01BC (Ƽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x04, 0x3c, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+01BD (ƽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x18, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00 },	// U+01BE (ƾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x02, 0x02 },	// U+01BF (ƿ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+01C0 (ǀ)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+01C1 (ǁ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+01C2 (ǂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x00 },	// U+01C3 (ǃ)
	{ 0xa0, 0x40, 0x00, 0x00, 0xe6, 0x8a, 0x8a, 0x8a, 0x4a, 0x4a, 0x2a, 0x2a, 0x2a, 0xe6, 0x00, 0x00 },	// U+01C4 (Ǆ)
	{ 0x00, 0x00, 0xa0, 0x40, 0x06, 0x0a, 0xea, 0x8a, 0x8a, 0x4a, 0x4a, 0x2a, 0x2a, 0xe6, 0x00, 0x00 },	// U+01C5 (ǅ)
	{ 0x00, 0x00, 0xa0, 0x48, 0x08, 0x08, 0xec, 0x8a, 0x8a, 0x4a, 0x4a, 0x2a, 0x2a, 0xec, 0x00, 0x00 },	// U+01C6 (ǆ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe2, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0x92, 0x6e, 0x00, 0x00 },	// U+01C7 (Ǉ)
	{ 0x00, 0x00, 0x00, 0x80, 0x82, 0x02, 0xc2, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x9e, 0x40, 0x30 },	// U+01C8 (ǈ)
	{ 0x00, 0x00, 0x00, 0x86, 0x84, 0x04, 0xc4, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x9f, 0x40, 0x30 },	// U+01C9 (ǉ)
	{ 0x00, 0x00, 0x00, 0x00, 0xd2, 0x92, 0x92, 0x96, 0x96, 0x9a, 0x9a, 0xb2, 0xb2, 0x52, 0x00, 0x00 },	// U+01CA (Ǌ)
	{ 0x00, 0x00, 0x00, 0x80, 0x92, 0x12, 0xd6, 0x96, 0x96, 0x9a, 0x9a, 0x9a, 0x92, 0x92, 0x48, 0x30 },	// U+01CB (ǋ)
	{ 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0xca, 0x96, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x48, 0x30 },	// U+01CC (ǌ)
	{ 0x24, 0x18, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+01CD (Ǎ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01CE (ǎ)
	{ 0x24, 0x18, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+01CF (Ǐ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+01D0 (ǐ)
	{ 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+01D1 (Ǒ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+01D2 (ǒ)
	{ 0x24, 0x18, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+01D3 (Ǔ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01D4 (ǔ)
	{ 0x3c, 0x00, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+01D5 (Ǖ)
	{ 0x00, 0x3c, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01D6 (ǖ)
	{ 0x30, 0x0c, 0x00, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+01D7 (Ǘ)
	{ 0x30, 0x0c, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01D8 (ǘ)
	{ 0x24, 0x18, 0x00, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+01D9 (Ǚ)
	{ 0x24, 0x18, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01DA (ǚ)
	{ 0x0c, 0x30, 0x00, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+01DB (Ǜ)
	{ 0x0c, 0x30, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01DC (ǜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+01DD (ǝ)
	{ 0x3c, 0x00, 0x24, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+01DE (Ǟ)
	{ 0x00, 0x3c, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01DF (ǟ)
	{ 0x3c, 0x00, 0x18, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+01E0 (Ǡ)
	{ 0x00, 0x3c, 0x00, 0x08, 0x08, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01E1 (ǡ)
	{ 0x00, 0x3c, 0x00, 0x00, 0xf8, 0x14, 0x12, 0x12, 0xfe, 0x12, 0x12, 0x12, 0x12, 0xf2, 0x00, 0x00 },	// U+01E2 (Ǣ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x7c, 0x92, 0x90, 0xfc, 0x12, 0x12, 0x92, 0x7c, 0x00, 0x00 },	// U+01E3 (ǣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0xf2, 0x42, 0x7c, 0x00, 0x00 },	// U+01E4 (Ǥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x1c, 0x04, 0x3c, 0xf2, 0x42, 0x3c },	// U+01E5 (ǥ)
	{ 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01E6 (Ǧ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x1c, 0x04, 0x3c, 0x42, 0x42, 0x3c },	// U+01E7 (ǧ)
	{ 0x24, 0x18, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+01E8 (Ǩ)
	{ 0x24, 0x18, 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+01E9 (ǩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x30 },	// U+01EA (Ǫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x30 },	// U+01EB (ǫ)
	{ 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x30 },	// U+01EC (Ǭ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x30 },	// U+01ED (ǭ)
	{ 0x24, 0x18, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x08, 0x38, 0x40, 0x40, 0x40, 0x62, 0x3c, 0x00, 0x00 },	// U+01EE (Ǯ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x7c, 0x20, 0x10, 0x08, 0x38, 0x40, 0x40, 0x40, 0x42, 0x3c },	// U+01EF (ǯ)
	{ 0x00, 0x00, 0x48, 0x30, 0x00, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x12, 0x0c },	// U+01F0 (ǰ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe6, 0x8a, 0x8a, 0x8a, 0x4a, 0x4a, 0x2a, 0x2a, 0x2a, 0xe6, 0x00, 0x00 },	// U+01F1 (Ǳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x0a, 0xea, 0x8a, 0x8a, 0x4a, 0x4a, 0x2a, 0x2a, 0xe6, 0x00, 0x00 },	// U+01F2 (ǲ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0xec, 0x8a, 0x8a, 0x4a, 0x4a, 0x2a, 0x2a, 0xec, 0x00, 0x00 },	// U+01F3 (ǳ)
	{ 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01F4 (Ǵ)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x1c, 0x04, 0x3c, 0x42, 0x42, 0x3c },	// U+01F5 (ǵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x52, 0x5e, 0x52, 0x52, 0x52, 0x52, 0x22, 0x00, 0x00 },	// U+01F6 (Ƕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x02, 0x02, 0x02, 0x00 },	// U+01F7 (Ƿ)
	{ 0x00, 0x0c, 0x30, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x00, 0x00 },	// U+01F8 (Ǹ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x30, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+01F9 (ǹ)
	{ 0x30, 0x0c, 0x18, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+01FA (Ǻ)
	{ 0x30, 0x0c, 0x00, 0x18, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+01FB (ǻ)
	{ 0x60, 0x18, 0x00, 0x00, 0xf8, 0x14, 0x12, 0x12, 0xfe, 0x12, 0x12, 0x12, 0x12, 0xf2, 0x00, 0x00 },	// U+01FC (Ǽ)
	{ 0x00, 0x00, 0x60, 0x18, 0x00, 0x00, 0x7c, 0x92, 0x90, 0xfc, 0x12, 0x12, 0x92, 0x7c, 0x00, 0x00 },	// U+01FD (ǽ)
	{ 0x30, 0x0c, 0x00, 0x40, 0x5c, 0x22, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x44, 0x3a, 0x02, 0x00 },	// U+01FE (Ǿ)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x40, 0x3c, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x3c, 0x02, 0x00 },	// U+01FF (ǿ)
	{ 0x33, 0x44, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0200 (Ȁ)
	{ 0x00, 0x00, 0x33, 0x44, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0201 (ȁ)
	{ 0x3c, 0x42, 0x42, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0202 (Ȃ)
	{ 0x00, 0x00, 0x3c, 0x42, 0x42, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0203 (ȃ)
	{ 0x33, 0x44, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0204 (Ȅ)
	{ 0x00, 0x00, 0x33, 0x44, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0205 (ȅ)
	{ 0x3c, 0x42, 0x42, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0206 (Ȇ)
	{ 0x00, 0x00, 0x3c, 0x42, 0x42, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0207 (ȇ)
	{ 0x33, 0x44, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0208 (Ȉ)
	{ 0x00, 0x00, 0x33, 0x44, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0209 (ȉ)
	{ 0x3c, 0x42, 0x42, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+020A (Ȋ)
	{ 0x00, 0x00, 0x3c, 0x42, 0x42, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+020B (ȋ)
	{ 0x33, 0x44, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+020C (Ȍ)
	{ 0x00, 0x00, 0x33, 0x44, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+020D (ȍ)
	{ 0x3c, 0x42, 0x42, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+020E (Ȏ)
	{ 0x00, 0x00, 0x3c, 0x42, 0x42, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+020F (ȏ)
	{ 0x33, 0x44, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+0210 (Ȑ)
	{ 0x00, 0x00, 0x33, 0x44, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0211 (ȑ)
	{ 0x3c, 0x42, 0x42, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+0212 (Ȓ)
	{ 0x00, 0x00, 0x3c, 0x42, 0x42, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0213 (ȓ)
	{ 0x33, 0x44, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0214 (Ȕ)
	{ 0x00, 0x00, 0x33, 0x44, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0215 (ȕ)
	{ 0x3c, 0x42, 0x42, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0216 (Ȗ)
	{ 0x00, 0x00, 0x3c, 0x42, 0x42, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0217 (ȗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x10, 0x08 },	// U+0218 (Ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x10, 0x08 },	// U+0219 (ș)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x40, 0x20 },	// U+021A (Ț)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x04, 0x02 },	// U+021B (ț)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x30, 0x2c, 0x40, 0x40, 0x40, 0x30, 0x0c, 0x00 },	// U+021C (Ȝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x30, 0x4c, 0x40, 0x40, 0x30, 0x0c },	// U+021D (ȝ)
	{ 0x00, 0x24, 0x18, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+021E (Ȟ)
	{ 0x00, 0x24, 0x18, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+021F (ȟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+0220 (Ƞ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0xe2, 0xdc, 0x40, 0x20 },	// U+0221 (ȡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x24, 0x42, 0x42, 0x24, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0222 (Ȣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x44, 0x24, 0x18, 0x24, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+0223 (ȣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x40, 0x20 },	// U+0224 (Ȥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x40, 0x20 },	// U+0225 (ȥ)
	{ 0x00, 0x00, 0x10, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0226 (Ȧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0227 (ȧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x10, 0x0c },	// U+0228 (Ȩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x10, 0x0c },	// U+0229 (ȩ)
	{ 0x3c, 0x00, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+022A (Ȫ)
	{ 0x00, 0x00, 0x3c, 0x00, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+022B (ȫ)
	{ 0x3c, 0x00, 0x4c, 0x32, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+022C (Ȭ)
	{ 0x00, 0x3c, 0x00, 0x4c, 0x32, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+022D (ȭ)
	{ 0x00, 0x00, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+022E (Ȯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+022F (ȯ)
	{ 0x3c, 0x00, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0230 (Ȱ)
	{ 0x00, 0x00, 0x3c, 0x00, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0231 (ȱ)
	{ 0x00, 0x00, 0x7c, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0232 (Ȳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+0233 (ȳ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0x30, 0x08, 0x04 },	// U+0234 (ȴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0xc2, 0xc2, 0x40, 0x20 },	// U+0235 (ȵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x68, 0x70, 0x10, 0x08 },	// U+0236 (ȶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x12, 0x0c },	// U+0237 (ȷ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x2a, 0x5d, 0x49, 0x49, 0x49, 0x49, 0x5d, 0x2a, 0x00, 0x00 },	// U+0238 (ȸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x5d, 0x49, 0x49, 0x49, 0x49, 0x5d, 0x2a, 0x08, 0x08 },	// U+0239 (ȹ)
	{ 0x00, 0x00, 0x00, 0x40, 0x58, 0x24, 0x34, 0x52, 0x4a, 0x7e, 0x46, 0x42, 0x42, 0x43, 0x00, 0x00 },	// U+023A (Ⱥ)
	{ 0x00, 0x00, 0x00, 0x40, 0x3c, 0x62, 0x52, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x42, 0x3e, 0x01, 0x00 },	// U+023B (Ȼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x3c, 0x52, 0x0a, 0x0a, 0x06, 0x06, 0x42, 0x3e, 0x01, 0x00 },	// U+023C (ȼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x00, 0x00 },	// U+023D (Ƚ)
	{ 0x00, 0x00, 0x80, 0x40, 0xfe, 0x30, 0x30, 0x10, 0x10, 0x18, 0x18, 0x14, 0x14, 0x12, 0x00, 0x00 },	// U+023E (Ⱦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x90, 0x60 },	// U+023F (ȿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x06, 0x08, 0x70 },	// U+0240 (ɀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0241 (Ɂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x20, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0242 (ɂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x44, 0x44, 0x44, 0x3c, 0x44, 0x5e, 0x44, 0x44, 0x3c, 0x00, 0x00 },	// U+0243 (Ƀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x7f, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+0244 (Ʉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x24, 0x24, 0x24, 0x24, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0245 (Ʌ)
	{ 0x00, 0x00, 0x20, 0x20, 0x7e, 0x12, 0x12, 0x0a, 0x3e, 0x0a, 0x0a, 0x06, 0x06, 0x7e, 0x02, 0x02 },	// U+0246 (Ɇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x3c, 0x62, 0x52, 0x7e, 0x0a, 0x06, 0x42, 0x3e, 0x01, 0x00 },	// U+0247 (ɇ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0xf8, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+0248 (Ɉ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, 0x30, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x12, 0x0c },	// U+0249 (ɉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x20, 0xc0 },	// U+024A (Ɋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x32, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x20, 0xc0 },	// U+024B (ɋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x44, 0x44, 0x44, 0x3e, 0x14, 0x24, 0x24, 0x44, 0x44, 0x00, 0x00 },	// U+024C (Ɍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x44, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+024D (ɍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0xfe, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+024E (Ɏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x48, 0x70, 0x40, 0x40, 0x38 },	// U+024F (ɏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x3e, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0250 (ɐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4c, 0x00, 0x00 },	// U+0251 (ɑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x46, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00 },	// U+0252 (ɒ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00 },	// U+0253 (ɓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+0254 (ɔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x32, 0x4a, 0x3c, 0x02, 0x00 },	// U+0255 (ɕ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x2c, 0x32, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0xc0, 0x00 },	// U+0256 (ɖ)
	{ 0x00, 0x00, 0x00, 0xc0, 0x20, 0x20, 0x2c, 0x32, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+0257 (ɗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+0258 (ɘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0259 (ə)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xb2, 0x58, 0x14, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+025A (ɚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+025B (ɛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x3c, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+025C (ɜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xb2, 0x50, 0x0c, 0x10, 0x10, 0x12, 0x0c, 0x00, 0x00 },	// U+025D (ɝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x3a, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+025E (ɞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x20, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x20, 0x12, 0x0c },	// U+025F (ɟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x2c, 0x32, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x20, 0x22, 0x1c },	// U+0260 (ɠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x42, 0x3c },	// U+0261 (ɡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x7c, 0x00, 0x00 },	// U+0262 (ɢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x18 },	// U+0263 (ɣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x18, 0x00, 0x00 },	// U+0264 (ɤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40, 0x40 },	// U+0265 (ɥ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0266 (ɦ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x30 },	// U+0267 (ɧ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x18, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0268 (ɨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+0269 (ɩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+026A (ɪ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x5c, 0x32, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+026B (ɫ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x1c, 0x12, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+026C (ɬ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x60, 0x00 },	// U+026D (ɭ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0xf8, 0x88, 0x48, 0x28, 0x68, 0x88, 0x88, 0xbe, 0x90, 0x60 },	// U+026E (ɮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xec, 0x00, 0x00 },	// U+026F (ɯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xec, 0x80, 0x80 },	// U+0270 (ɰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x82, 0x60, 0x00 },	// U+0271 (ɱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x98, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x06, 0x00 },	// U+0272 (ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xc0, 0x00 },	// U+0273 (ɳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x42, 0x00, 0x00 },	// U+0274 (ɴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0275 (ɵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0x12, 0x12, 0x72, 0x12, 0x12, 0x12, 0xec, 0x00, 0x00 },	// U+0276 (ɶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+0277 (ɷ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10 },	// U+0278 (ɸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0279 (ɹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+027A (ɺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x32, 0x2c, 0xc0, 0x00 },	// U+027B (ɻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+027C (ɼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0c, 0x00 },	// U+027D (ɽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+027E (ɾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },	// U+027F (ɿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+0280 (ʀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x22, 0x12, 0x3e, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+0281 (ʁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3e, 0x02, 0x0c },	// U+0282 (ʂ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06, 0x00 },	// U+0283 (ʃ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x06, 0x00 },	// U+0284 (ʄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00 },	// U+0285 (ʅ)
	{ 0x00, 0x00, 0x00, 0x60, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x72, 0x0c, 0x00 },	// U+0286 (ʆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00 },	// U+0287 (ʇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00 },	// U+0288 (ʈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x44, 0x64, 0x58, 0x00, 0x00 },	// U+0289 (ʉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+028A (ʊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x42, 0x42, 0x42, 0x42, 0x22, 0x12, 0x0c, 0x00, 0x00 },	// U+028B (ʋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x24, 0x24, 0x24, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+028C (ʌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x82, 0x00, 0x00 },	// U+028D (ʍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x1a, 0x26, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+028E (ʎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+028F (ʏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x3e, 0x20, 0xc0 },	// U+0290 (ʐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x64, 0x92, 0x7e, 0x08, 0x00 },	// U+0291 (ʑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x20, 0x10, 0x08, 0x38, 0x40, 0x40, 0x40, 0x42, 0x3c },	// U+0292 (ʒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x20, 0x10, 0x08, 0x38, 0x40, 0x40, 0x4c, 0x52, 0x3c },	// U+0293 (ʓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0294 (ʔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0295 (ʕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0296 (ʖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c },	// U+0297 (ʗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0298 (ʘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+0299 (ʙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x5c, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+029A (ʚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x22, 0x02, 0x02, 0x32, 0x22, 0x22, 0x3c, 0x00, 0x00 },	// U+029B (ʛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+029C (ʜ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x12, 0x0c },	// U+029D (ʝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0x40, 0x40, 0x40 },	// U+029E (ʞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+029F (ʟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x2c, 0x32, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x20, 0x20 },	// U+02A0 (ʠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x20, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+02A1 (ʡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x04, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00 },	// U+02A2 (ʢ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0xfc, 0x8a, 0x4a, 0x4a, 0x2a, 0x2a, 0x1a, 0xfc, 0x00, 0x00 },	// U+02A3 (ʣ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0xfc, 0x8a, 0x4a, 0x2a, 0x6a, 0x8a, 0x8a, 0x8c, 0x90, 0x60 },	// U+02A4 (ʤ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0xfc, 0x8a, 0x4a, 0x2a, 0x1a, 0x4a, 0xaa, 0x7c, 0x20, 0x00 },	// U+02A5 (ʥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x62, 0x9f, 0x12, 0x22, 0x42, 0x82, 0x82, 0x7c, 0x00, 0x00 },	// U+02A6 (ʦ)
	{ 0x00, 0x00, 0x00, 0xc0, 0x24, 0x24, 0x24, 0x3e, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x20, 0x18 },	// U+02A7 (ʧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x62, 0x9f, 0x12, 0x12, 0x12, 0x52, 0xb2, 0x7c, 0x20, 0x00 },	// U+02A8 (ʨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x02, 0x76, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x40, 0x30 },	// U+02A9 (ʩ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x64, 0x94, 0x14, 0x24, 0x44, 0x84, 0x84, 0x7e, 0x00, 0x00 },	// U+02AA (ʪ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x7c, 0x44, 0x24, 0x24, 0x14, 0x14, 0x0c, 0x7e, 0x00, 0x00 },	// U+02AB (ʫ)
	{ 0x00, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x82, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+02AC (ʬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+02AD (ʭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x24, 0x24, 0x24, 0x24, 0x24, 0x34, 0x28, 0x20, 0x20 },	// U+02AE (ʮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x24, 0x24, 0x24, 0x24, 0x24, 0x34, 0x28, 0x20, 0xc0 },	// U+02AF (ʯ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B0 (ʰ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x1a, 0x26, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B1 (ʱ)
	{ 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x20, 0x20, 0x20, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B2 (ʲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B3 (ʳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B4 (ʴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x22, 0x32, 0x2c, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B5 (ʵ)
	{ 0x00, 0x00, 0x00, 0x22, 0x22, 0x12, 0x1e, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B6 (ʶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B7 (ʷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x32, 0x2c, 0x20, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B8 (ʸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B9 (ʹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x48, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BA (ʺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BB (ʻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BC (ʼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BD (ʽ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x10, 0x20, 0x20, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BE (ʾ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x04, 0x04, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BF (ʿ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x38, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C0 (ˀ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x1c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C1 (ˁ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C2 (˂)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C3 (˃)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C4 (˄)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C5 (˅)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C6 (ˆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C7 (ˇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C8 (ˈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C9 (ˉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02CA (ˊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02CB (ˋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+02CC (ˌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00 },	// U+02CD (ˍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x00 },	// U+02CE (ˎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x00 },	// U+02CF (ˏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x08, 0x00, 0x00, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+02D0 (ː)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D1 (ˑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10, 0x20, 0x20, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+02D2 (˒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0x04, 0x04, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+02D3 (˓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+02D4 (˔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+02D5 (˕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+02D6 (˖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D7 (˗)
	{ 0x00, 0x00, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D8 (˘)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D9 (˙)
	{ 0x00, 0x00, 0x18, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DA (˚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x60 },	// U+02DB (˛)
	{ 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DC (˜)
	{ 0x00, 0x00, 0xcc, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DD (˝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x45, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DE (˞)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DF (˟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+02E0 (ˠ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E1 (ˡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x3c, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E2 (ˢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E3 (ˣ)
	{ 0x00, 0x00, 0x3c, 0x02, 0x02, 0x1c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E4 (ˤ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+02E5 (˥)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+02E6 (˦)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+02E7 (˧)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x20, 0x20, 0x00, 0x00 },	// U+02E8 (˨)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x00, 0x00 },	// U+02E9 (˩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x32, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+02EA (˪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x32, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+02EB (˫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x00 },	// U+02EC (ˬ)
	{ 0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02ED (˭)
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0x44, 0x44, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02EE (ˮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00 },	// U+02EF (˯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x00 },	// U+02F0 (˰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x10, 0x20, 0x00 },	// U+02F1 (˱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x10, 0x08, 0x00 },	// U+02F2 (˲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x18, 0x00 },	// U+02F3 (˳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F4 (˴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F5 (˵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F6 (˶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32 },	// U+02F7 (˷)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F8 (˸)
	{ 0x00, 0x00, 0x00, 0x1c, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F9 (˹)
	{ 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02FA (˺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x1c, 0x00, 0x00 },	// U+02FB (˻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x1c, 0x00, 0x00 },	// U+02FC (˼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x7e },	// U+02FD (˽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x7e },	// U+02FE (˾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x7e, 0x04, 0x08 },	// U+02FF (˿)
	{ 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0300 (̀)
	{ 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0301 (́)
	{ 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0302 (̂)
	{ 0x00, 0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0303 (̃)
	{ 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0304 (̄)
	{ 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0305 (̅)
	{ 0x00, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0306 (̆)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0307 (̇)
	{ 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0308 (̈)
	{ 0x18, 0x24, 0x20, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0309 (̉)
	{ 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030A (̊)
	{ 0xcc, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030B (̋)
	{ 0x00, 0x42, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030C (̌)
	{ 0x00, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030D (̍)
	{ 0x00, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030E (̎)
	{ 0x33, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030F (̏)
	{ 0x18, 0x5a, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0310 (̐)
	{ 0x00, 0x3c, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0311 (̑)
	{ 0x00, 0x10, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0312 (̒)
	{ 0x00, 0x18, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0313 (̓)
	{ 0x00, 0x18, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0314 (̔)
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0315 (̕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20 },	// U+0316 (̖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04 },	// U+0317 (̗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1c, 0x10 },	// U+0318 (̘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x38, 0x08 },	// U+0319 (̙)
	{ 0x00, 0x78, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+031A (̚)
	{ 0x00, 0x00, 0x20, 0x50, 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+031B (̛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x18 },	// U+031C (̜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c },	// U+031D (̝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08 },	// U+031E (̞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0x08 },	// U+031F (̟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c },	// U+0320 (̠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x48, 0x30 },	// U+0321 (̡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x90, 0x60 },	// U+0322 (̢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+0323 (̣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66 },	// U+0324 (̤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x18 },	// U+0325 (̥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x08 },	// U+0326 (̦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x20, 0x1c },	// U+0327 (̧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x60 },	// U+0328 (̨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08 },	// U+0329 (̩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42 },	// U+032A (̪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x6c },	// U+032B (̫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18 },	// U+032C (̬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42 },	// U+032D (̭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x3c },	// U+032E (̮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42 },	// U+032F (̯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32 },	// U+0330 (̰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e },	// U+0331 (̱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff },	// U+0332 (̲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff },	// U+0333 (̳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0334 (̴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0335 (̵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0336 (̶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0337 (̷)
	{ 0x00, 0x00, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+0338 (̸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x20, 0x20, 0x18 },	// U+0339 (̹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x7e },	// U+033A (̺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x3c },	// U+033B (̻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x08 },	// U+033C (̼)
	{ 0x66, 0x18, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+033D (̽)
	{ 0x10, 0x08, 0x08, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+033E (̾)
	{ 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+033F (̿)
	{ 0x00, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0340 (̀)
	{ 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0341 (́)
	{ 0x00, 0x2c, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0342 (͂)
	{ 0x00, 0x18, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0343 (̓)
	{ 0x08, 0x08, 0x2a, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0344 (̈́)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x30 },	// U+0345 (ͅ)
	{ 0x00, 0x7e, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0346 (͆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7e },	// U+0347 (͇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24 },	// U+0348 (͈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10 },	// U+0349 (͉)
	{ 0x10, 0x5c, 0x3a, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+034A (͊)
	{ 0x20, 0x8e, 0x71, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+034B (͋)
	{ 0x4c, 0x32, 0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+034C (͌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xfe, 0x44 },	// U+034D (͍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x10 },	// U+034E (͎)
}; // 673

static const unsigned char unifont_block4[][16] = {
	{ 0x10, 0x20, 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0350 (͐)
	{ 0x18, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0351 (͑)
	{ 0x3c, 0x42, 0x5a, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0352 (͒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x24 },	// U+0353 (͓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x08, 0x10 },	// U+0354 (͔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x10, 0x08 },	// U+0355 (͕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x24, 0x52, 0x89 },	// U+0356 (͖)
	{ 0x18, 0x20, 0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0357 (͗)
	{ 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0358 (͘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x1c, 0x3e, 0x1c },	// U+0359 (͙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x36 },	// U+035A (͚)
	{ 0x10, 0x08, 0x7c, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+035B (͛)
}; // 12

static const unsigned char unifont_block5[][16] = {
	{ 0x3c, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0363 (ͣ)
	{ 0x1c, 0x22, 0x1e, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0364 (ͤ)
	{ 0x08, 0x00, 0x0c, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0365 (ͥ)
	{ 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0366 (ͦ)
	{ 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0367 (ͧ)
	{ 0x38, 0x04, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0368 (ͨ)
	{ 0x20, 0x20, 0x3c, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0369 (ͩ)
	{ 0x04, 0x04, 0x1c, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036A (ͪ)
	{ 0x00, 0x00, 0x37, 0x49, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036B (ͫ)
	{ 0x00, 0x1c, 0x24, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036C (ͬ)
	{ 0x04, 0x1e, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036D (ͭ)
	{ 0x00, 0x22, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036E (ͮ)
	{ 0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036F (ͯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0370 (Ͱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x78, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0371 (ͱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x49, 0x49, 0x49, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0372 (Ͳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x2a, 0x2a, 0x2a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0373 (ͳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0374 (ʹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x18, 0x0c },	// U+0375 (͵)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x42, 0x00, 0x00 },	// U+0376 (Ͷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x19, 0x19, 0x15, 0x15, 0x53, 0x53, 0x21, 0x00, 0x00 },	// U+0377 (ͷ)
}; // 21

static const unsigned char unifont_block6[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x18 },	// U+037A (ͺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+037B (ͻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x1a, 0x1a, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+037C (ͼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x58, 0x58, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+037D (ͽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08, 0x00 },	// U+037E (;)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+037F (Ϳ)
}; // 6

static const unsigned char unifont_block7[][16] = {
	{ 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0384 (΄)
	{ 0x20, 0x10, 0x2a, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0385 (΅)
	{ 0x08, 0x04, 0x02, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0386 (Ά)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0387 (·)
	{ 0x08, 0x04, 0x02, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0388 (Έ)
	{ 0x08, 0x04, 0x02, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0389 (Ή)
	{ 0x08, 0x04, 0x02, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+038A (Ί)
}; // 7

static const unsigned char unifont_block8[][16] = {
	{ 0x08, 0x04, 0x02, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+038C (Ό)
}; // 1

static const unsigned char unifont_block9[][16] = {
	{ 0x08, 0x04, 0x02, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+038E (Ύ)
	{ 0x08, 0x04, 0x02, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00 },	// U+038F (Ώ)
	{ 0x20, 0x10, 0x08, 0x22, 0x22, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+0390 (ΐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0391 (Α)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+0392 (Β)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0393 (Γ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x44, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+0394 (Δ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0395 (Ε)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0396 (Ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0397 (Η)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0398 (Θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0399 (Ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+039A (Κ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x44, 0x82, 0x82, 0x82, 0x00, 0x00 },	// U+039B (Λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+039C (Μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x00, 0x00 },	// U+039D (Ν)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00 },	// U+039E (Ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+039F (Ο)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+03A0 (Π)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+03A1 (Ρ)
}; // 20

static const unsigned char unifont_block10[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x04, 0x08, 0x10, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+03A3 (Σ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+03A4 (Τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+03A5 (Υ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0xfe, 0x00, 0x00 },	// U+03A6 (Φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+03A7 (Χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+03A8 (Ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+03A9 (Ω)
	{ 0x24, 0x24, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+03AA (Ϊ)
	{ 0x24, 0x24, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+03AB (Ϋ)
	{ 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+03AC (ά)
	{ 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x3c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x00 },	// U+03AD (έ)
	{ 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+03AE (ή)
	{ 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+03AF (ί)
	{ 0x20, 0x10, 0x08, 0x22, 0x22, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03B0 (ΰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+03B1 (α)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+03B2 (β)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x92, 0x50, 0x20, 0x10, 0x10, 0x08, 0x08, 0x00, 0x00 },	// U+03B3 (γ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x04, 0x18, 0x24, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03B4 (δ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+03B5 (ε)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x38, 0x10, 0x08, 0x04, 0x04, 0x04, 0x04, 0x38, 0x40, 0x38 },	// U+03B6 (ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+03B7 (η)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+03B8 (θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+03B9 (ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x24, 0x14, 0x0c, 0x0c, 0x14, 0x24, 0x44, 0x00, 0x00 },	// U+03BA (κ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+03BB (λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x42, 0x02, 0x02 },	// U+03BC (μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x22, 0x22, 0x12, 0x0a, 0x06, 0x00, 0x00 },	// U+03BD (ν)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x3c, 0x02, 0x02, 0x3c, 0x02, 0x02, 0x3c, 0x40, 0x40, 0x3c },	// U+03BE (ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03BF (ο)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+03C0 (π)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+03C1 (ρ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x02, 0x02, 0x04, 0x38, 0x40, 0x40, 0x38 },	// U+03C2 (ς)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+03C3 (σ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+03C4 (τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03C5 (υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10 },	// U+03C6 (φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x84, 0x44, 0x48, 0x28, 0x18, 0x14, 0x12, 0x22, 0x21, 0xc1 },	// U+03C7 (χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10 },	// U+03C8 (ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+03C9 (ω)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+03CA (ϊ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03CB (ϋ)
	{ 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03CC (ό)
	{ 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03CD (ύ)
	{ 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+03CE (ώ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x20, 0x10 },	// U+03CF (Ϗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x42, 0x22, 0x1e, 0x22, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+03D0 (ϐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x48, 0xf0, 0x44, 0x46, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+03D1 (ϑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x6c, 0xaa, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+03D2 (ϒ)
	{ 0x08, 0x04, 0x02, 0x00, 0x6c, 0xaa, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+03D3 (ϓ)
	{ 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0xaa, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+03D4 (ϔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10 },	// U+03D5 (ϕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+03D6 (ϖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x22, 0x34, 0x34, 0x2c, 0x2c, 0x44, 0x82, 0x80, 0x78 },	// U+03D7 (ϗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x18, 0x3c },	// U+03D8 (Ϙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x18, 0x18 },	// U+03D9 (ϙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1c, 0x10, 0x38, 0x00, 0x00 },	// U+03DA (Ϛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x04, 0x38, 0x40, 0x38, 0x00, 0x00 },	// U+03DB (ϛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+03DC (Ϝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x44, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x04, 0x04 },	// U+03DD (ϝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x20, 0x20, 0x10, 0x10, 0x00, 0x00 },	// U+03DE (Ϟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x44, 0x3c, 0x22, 0x10, 0x10, 0x20, 0x00 },	// U+03DF (ϟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x60, 0x50, 0x48, 0x60, 0x50, 0x48, 0x40, 0x30, 0x00, 0x00 },	// U+03E0 (Ϡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x18, 0x14, 0x32, 0x28, 0x24, 0x20, 0x10 },	// U+03E1 (ϡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x76, 0x40, 0x3e, 0x01 },	// U+03E2 (Ϣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x49, 0x49, 0x49, 0x49, 0x49, 0x76, 0x40, 0x3e, 0x01 },	// U+03E3 (ϣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x4c, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+03E4 (Ϥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x44, 0x44, 0x44, 0x78, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+03E5 (ϥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x82, 0x82, 0x82, 0x80, 0x80, 0x46, 0x38 },	// U+03E6 (Ϧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3c, 0x4a, 0x4a, 0x44, 0x40, 0x40, 0x4c, 0x32, 0x00, 0x00 },	// U+03E7 (ϧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x20, 0x10, 0x08, 0x04, 0x42, 0x3c, 0x00, 0x00 },	// U+03E8 (Ϩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x20, 0x10, 0x0c, 0x42, 0x3c, 0x00, 0x00 },	// U+03E9 (ϩ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc3, 0xa5, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x81, 0x00 },	// U+03EA (Ϫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x5a, 0x18, 0x18, 0x18, 0x24, 0x42, 0x7e, 0x00, 0x00 },	// U+03EB (ϫ)
	{ 0x00, 0x00, 0x00, 0x40, 0x3c, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03EC (Ϭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x3c, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03ED (ϭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x7f, 0x49, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+03EE (Ϯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x7f, 0x49, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+03EF (ϯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x22, 0x34, 0x34, 0x2c, 0x2c, 0x44, 0x82, 0x00, 0x00 },	// U+03F0 (ϰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x40, 0x00 },	// U+03F1 (ϱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+03F2 (ϲ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x12, 0x0c },	// U+03F3 (ϳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03F4 (ϴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x02, 0x1e, 0x02, 0x02, 0x04, 0x38, 0x00, 0x00 },	// U+03F5 (ϵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x20, 0x3c, 0x20, 0x20, 0x10, 0x0e, 0x00, 0x00 },	// U+03F6 (϶)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x02, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x02, 0x07 },	// U+03F7 (Ϸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+03F8 (ϸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03F9 (Ϲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+03FA (Ϻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x36, 0x36, 0x2a, 0x2a, 0x22, 0x22, 0xa2, 0x42, 0x02, 0x02 },	// U+03FB (ϻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x1f, 0x02 },	// U+03FC (ϼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03FD (Ͻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x1a, 0x1a, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03FE (Ͼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x58, 0x58, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+03FF (Ͽ)
	{ 0x00, 0x0c, 0x30, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0400 (Ѐ)
	{ 0x24, 0x24, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0401 (Ё)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x08, 0x08, 0x78, 0x88, 0x88, 0x88, 0x88, 0x68, 0x00, 0x00 },	// U+0402 (Ђ)
	{ 0x30, 0x0c, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0403 (Ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x44, 0x38, 0x00, 0x00 },	// U+0404 (Є)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0405 (Ѕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0406 (І)
	{ 0x24, 0x24, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0407 (Ї)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+0408 (Ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x12, 0x12, 0x72, 0x92, 0x92, 0x92, 0x92, 0x71, 0x00, 0x00 },	// U+0409 (Љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x7e, 0x92, 0x92, 0x92, 0x92, 0x72, 0x00, 0x00 },	// U+040A (Њ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x08, 0x08, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00 },	// U+040B (Ћ)
	{ 0x30, 0x0c, 0x00, 0x00, 0x62, 0x12, 0x12, 0x0a, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+040C (Ќ)
	{ 0x00, 0x0c, 0x30, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x42, 0x00, 0x00 },	// U+040D (Ѝ)
	{ 0x42, 0x42, 0x3c, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x08, 0x0c, 0x00, 0x00 },	// U+040E (Ў)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x10, 0x10 },	// U+040F (Џ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0410 (А)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+0411 (Б)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+0412 (В)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0413 (Г)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x48, 0x48, 0x48, 0x44, 0x44, 0x44, 0x42, 0x42, 0xff, 0x81, 0x81 },	// U+0414 (Д)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+0415 (Е)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x54, 0x54, 0x38, 0x38, 0x54, 0x54, 0x92, 0x92, 0x00, 0x00 },	// U+0416 (Ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x20, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+0417 (З)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x42, 0x00, 0x00 },	// U+0418 (И)
	{ 0x00, 0x24, 0x18, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x42, 0x00, 0x00 },	// U+0419 (Й)
	{ 0x00, 0x00, 0x00, 0x00, 0x62, 0x12, 0x12, 0x0a, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+041A (К)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x44, 0x44, 0x42, 0x00, 0x00 },	// U+041B (Л)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+041C (М)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+041D (Н)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+041E (О)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+041F (П)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0420 (Р)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0421 (С)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0422 (Т)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x08, 0x0c, 0x00, 0x00 },	// U+0423 (У)
	{ 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0424 (Ф)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+0425 (Х)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xfe, 0x80, 0x80 },	// U+0426 (Ц)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+0427 (Ч)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+0428 (Ш)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0xff, 0x80, 0x80 },	// U+0429 (Щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x78, 0x88, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00 },	// U+042A (Ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x4e, 0x52, 0x52, 0x52, 0x52, 0x4e, 0x00, 0x00 },	// U+042B (Ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+042C (Ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x22, 0x1c, 0x00, 0x00 },	// U+042D (Э)
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x4a, 0x4a, 0x4e, 0x4a, 0x4a, 0x4a, 0x4a, 0x32, 0x00, 0x00 },	// U+042E (Ю)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x48, 0x44, 0x44, 0x42, 0x42, 0x00, 0x00 },	// U+042F (Я)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0430 (а)
	{ 0x00, 0x00, 0x40, 0x38, 0x04, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0431 (б)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+0432 (в)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0433 (г)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x44, 0x44, 0x42, 0x42, 0x42, 0xfe, 0x82, 0x00 },	// U+0434 (д)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0435 (е)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x54, 0x38, 0x38, 0x54, 0x92, 0x92, 0x00, 0x00 },	// U+0436 (ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x3c, 0x20, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+0437 (з)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x00, 0x00 },	// U+0438 (и)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x00, 0x00 },	// U+0439 (й)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+043A (к)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x48, 0x44, 0x44, 0x42, 0x00, 0x00 },	// U+043B (л)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+043C (м)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+043D (н)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+043E (о)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+043F (п)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+0440 (р)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0441 (с)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0442 (т)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x08, 0x08, 0x04, 0x06 },	// U+0443 (у)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10 },	// U+0444 (ф)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+0445 (х)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xfe, 0x80, 0x80 },	// U+0446 (ц)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40, 0x00, 0x00 },	// U+0447 (ч)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+0448 (ш)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0xff, 0x80, 0x80 },	// U+0449 (щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x78, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00 },	// U+044A (ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x4e, 0x52, 0x52, 0x52, 0x4e, 0x00, 0x00 },	// U+044B (ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+044C (ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x7c, 0x40, 0x40, 0x22, 0x1c, 0x00, 0x00 },	// U+044D (э)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x4a, 0x4e, 0x4a, 0x4a, 0x4a, 0x32, 0x00, 0x00 },	// U+044E (ю)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x48, 0x44, 0x42, 0x00, 0x00 },	// U+044F (я)
	{ 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0450 (ѐ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0451 (ё)
	{ 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x30 },	// U+0452 (ђ)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0453 (ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x02, 0x3e, 0x02, 0x02, 0x44, 0x38, 0x00, 0x00 },	// U+0454 (є)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+0455 (ѕ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0456 (і)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+0457 (ї)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x12, 0x0c },	// U+0458 (ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x12, 0x72, 0x92, 0x92, 0x92, 0x71, 0x00, 0x00 },	// U+0459 (љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x7e, 0x92, 0x92, 0x92, 0x72, 0x00, 0x00 },	// U+045A (њ)
	{ 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+045B (ћ)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x62, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+045C (ќ)
	{ 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x00, 0x00 },	// U+045D (ѝ)
	{ 0x00, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x08, 0x08, 0x04, 0x06 },	// U+045E (ў)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7c, 0x10, 0x10 },	// U+045F (џ)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x5a, 0x24, 0x00, 0x00 },	// U+0460 (Ѡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x5a, 0x24, 0x00, 0x00 },	// U+0461 (ѡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0x08, 0x08, 0x78, 0x88, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00 },	// U+0462 (Ѣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x3c, 0x44, 0x44, 0x44, 0x3c, 0x00, 0x00 },	// U+0463 (ѣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x62, 0x92, 0x0a, 0x0a, 0x7e, 0x0a, 0x0a, 0x0a, 0x92, 0x62, 0x00, 0x00 },	// U+0464 (Ѥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x92, 0x0a, 0x7e, 0x0a, 0x0a, 0x92, 0x62, 0x00, 0x00 },	// U+0465 (ѥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x6c, 0x54, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+0466 (Ѧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x44, 0x6c, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+0467 (ѧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x2a, 0x2a, 0x4a, 0x6e, 0x56, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+0468 (Ѩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2a, 0x2a, 0x4a, 0x6e, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+0469 (ѩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x44, 0x28, 0x10, 0x38, 0x54, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+046A (Ѫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x28, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+046B (ѫ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfa, 0x8a, 0x8a, 0x52, 0x2e, 0x72, 0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00 },	// U+046C (Ѭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfa, 0x8a, 0x52, 0x2e, 0x72, 0xaa, 0xaa, 0xaa, 0x00, 0x00 },	// U+046D (ѭ)
	{ 0x00, 0x00, 0x24, 0x18, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x20, 0x40, 0x40, 0x40, 0x3c, 0x02, 0x02 },	// U+046E (Ѯ)
	{ 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x40, 0x3c, 0x20, 0x40, 0x40, 0x3c, 0x02, 0x02 },	// U+046F (ѯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0470 (Ѱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10 },	// U+0471 (ѱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0472 (Ѳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0473 (ѳ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc2, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0474 (Ѵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x12, 0x12, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00 },	// U+0475 (ѵ)
	{ 0x66, 0x88, 0x00, 0x00, 0xc2, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0476 (Ѷ)
	{ 0x00, 0x00, 0x66, 0x88, 0x00, 0x00, 0x62, 0x12, 0x12, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00 },	// U+0477 (ѷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x9a, 0x9a, 0x9a, 0xaa, 0x6a, 0x2a, 0x2a, 0x24, 0x10, 0x10 },	// U+0478 (Ѹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0x9a, 0x9a, 0xaa, 0x6a, 0x2a, 0x2a, 0x24, 0x10, 0x10 },	// U+0479 (ѹ)
	{ 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0x7c, 0x10, 0x00 },	// U+047A (Ѻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x82, 0x82, 0x82, 0x82, 0x92, 0x7c, 0x10, 0x00 },	// U+047B (ѻ)
	{ 0x3c, 0xc2, 0x18, 0x20, 0x10, 0x00, 0x6c, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+047C (Ѽ)
	{ 0x00, 0x00, 0x00, 0x3c, 0xc2, 0x18, 0x20, 0x10, 0x00, 0x6c, 0x82, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+047D (ѽ)
	{ 0x00, 0xfe, 0x10, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x5a, 0x24, 0x00, 0x00 },	// U+047E (Ѿ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x5a, 0x24, 0x00, 0x00 },	// U+047F (ѿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3c, 0x20, 0x20, 0x20 },	// U+0480 (Ҁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x3c, 0x20, 0x20, 0x20 },	// U+0481 (ҁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x30, 0x22, 0x54, 0x88, 0x18, 0x24, 0x00, 0x00, 0x00 },	// U+0482 (҂)
	{ 0x00, 0x10, 0x1e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0483 (҃)
	{ 0x40, 0xa0, 0x90, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0484 (҄)
	{ 0x00, 0x1c, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0485 (҅)
	{ 0x00, 0x1c, 0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0486 (҆)
	{ 0x00, 0x0c, 0x32, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0487 (҇)
}; // 229

static const unsigned char unifont_block11[][16] = {
	{ 0x00, 0x24, 0x18, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0xc2, 0x40, 0x20 },	// U+048A (Ҋ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0xc6, 0x40, 0x20 },	// U+048B (ҋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x3c, 0x44, 0x44, 0x64, 0x3c, 0x00, 0x00 },	// U+048C (Ҍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x3c, 0x44, 0x44, 0x3c, 0x00, 0x00 },	// U+048D (ҍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x52, 0x22, 0x5e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+048E (Ҏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x52, 0x26, 0x5a, 0x02, 0x02 },	// U+048F (ҏ)
	{ 0x00, 0x00, 0x40, 0x40, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0490 (Ґ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0491 (ґ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0492 (Ғ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0493 (ғ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x30, 0x00 },	// U+0494 (Ҕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x30, 0x00 },	// U+0495 (ҕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x54, 0x54, 0x38, 0x38, 0x54, 0x54, 0x92, 0x92, 0x80, 0x80 },	// U+0496 (Җ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x54, 0x38, 0x38, 0x54, 0x92, 0x92, 0x80, 0x80 },	// U+0497 (җ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x20, 0x40, 0x40, 0x42, 0x3c, 0x10, 0x0c },	// U+0498 (Ҙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x3c, 0x20, 0x40, 0x42, 0x3c, 0x10, 0x0c },	// U+0499 (ҙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x62, 0x12, 0x12, 0x0a, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x40, 0x40 },	// U+049A (Қ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x40, 0x40 },	// U+049B (қ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc2, 0x22, 0x2a, 0x2a, 0x1e, 0x2a, 0x2a, 0x2a, 0x42, 0x82, 0x00, 0x00 },	// U+049C (Ҝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x2a, 0x2a, 0x1e, 0x2a, 0x2a, 0x42, 0x82, 0x00, 0x00 },	// U+049D (ҝ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc4, 0x2e, 0x24, 0x14, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x84, 0x00, 0x00 },	// U+049E (Ҟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0x2e, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x84, 0x00, 0x00 },	// U+049F (ҟ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc7, 0x24, 0x24, 0x14, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x84, 0x00, 0x00 },	// U+04A0 (Ҡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc7, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x84, 0x00, 0x00 },	// U+04A1 (ҡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0xc2, 0x80, 0x80 },	// U+04A2 (Ң)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0xc2, 0x80, 0x80 },	// U+04A3 (ң)
	{ 0x00, 0x00, 0x00, 0x00, 0xe2, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+04A4 (Ҥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+04A5 (ҥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x12, 0x12, 0x12, 0x72, 0x92, 0x92, 0x92, 0x92, 0x80, 0x60 },	// U+04A6 (Ҧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x12, 0x12, 0x72, 0x92, 0x92, 0x92, 0x80, 0x60 },	// U+04A7 (ҧ)
	{ 0x00, 0x00, 0x00, 0x04, 0x32, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x34, 0x18, 0x60, 0x00 },	// U+04A8 (Ҩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x32, 0x4a, 0x4a, 0x4a, 0x4a, 0x34, 0x18, 0x60, 0x00 },	// U+04A9 (ҩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x10, 0x0c },	// U+04AA (Ҫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x10, 0x0c },	// U+04AB (ҫ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0x20, 0x20 },	// U+04AC (Ҭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0x20, 0x20 },	// U+04AD (ҭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+04AE (Ү)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+04AF (ү)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+04B0 (Ұ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x7c, 0x10, 0x10, 0x10 },	// U+04B1 (ұ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0xc2, 0x80, 0x80 },	// U+04B2 (Ҳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0xc2, 0x80, 0x80 },	// U+04B3 (ҳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x5f, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfc, 0x80, 0x80 },	// U+04B4 (Ҵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfc, 0x80, 0x80 },	// U+04B5 (ҵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40, 0xc0, 0x80, 0x80 },	// U+04B6 (Ҷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0xc0, 0x80, 0x80 },	// U+04B7 (ҷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x4a, 0x6a, 0x5c, 0x48, 0x48, 0x40, 0x00, 0x00 },	// U+04B8 (Ҹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x4a, 0x6a, 0x5c, 0x48, 0x40, 0x00, 0x00 },	// U+04B9 (ҹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+04BA (Һ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+04BB (һ)
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x4a, 0x4a, 0x7c, 0x08, 0x08, 0x48, 0x48, 0x30, 0x00, 0x00 },	// U+04BC (Ҽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x4a, 0x7c, 0x08, 0x08, 0x48, 0x30, 0x00, 0x00 },	// U+04BD (ҽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x4a, 0x4a, 0x7c, 0x08, 0x08, 0x48, 0x48, 0x30, 0x10, 0x10 },	// U+04BE (Ҿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x4a, 0x7c, 0x08, 0x08, 0x48, 0x30, 0x10, 0x10 },	// U+04BF (ҿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+04C0 (Ӏ)
	{ 0x82, 0x82, 0x7c, 0x00, 0x92, 0x92, 0x54, 0x54, 0x38, 0x38, 0x54, 0x54, 0x92, 0x92, 0x00, 0x00 },	// U+04C1 (Ӂ)
	{ 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x92, 0x92, 0x54, 0x38, 0x38, 0x54, 0x92, 0x92, 0x00, 0x00 },	// U+04C2 (ӂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x62, 0x12, 0x12, 0x0a, 0x06, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x40, 0x30 },	// U+04C3 (Ӄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x12, 0x0a, 0x06, 0x3e, 0x42, 0x42, 0x42, 0x40, 0x30 },	// U+04C4 (ӄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x44, 0x44, 0xc2, 0x40, 0x20 },	// U+04C5 (Ӆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x48, 0x44, 0x44, 0xc2, 0x40, 0x20 },	// U+04C6 (ӆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x30 },	// U+04C7 (Ӈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x40, 0x30 },	// U+04C8 (ӈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0xc2, 0x40, 0x20 },	// U+04C9 (Ӊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0xc2, 0x40, 0x20 },	// U+04CA (ӊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40, 0x60, 0x20, 0x20 },	// U+04CB (Ӌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x60, 0x20, 0x20 },	// U+04CC (ӌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0xc2, 0x40, 0x20 },	// U+04CD (Ӎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0xc2, 0x40, 0x20 },	// U+04CE (ӎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+04CF (ӏ)
	{ 0x42, 0x42, 0x3c, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+04D0 (Ӑ)
	{ 0x00, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+04D1 (ӑ)
	{ 0x24, 0x24, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+04D2 (Ӓ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+04D3 (ӓ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x14, 0x12, 0x12, 0xfe, 0x12, 0x12, 0x12, 0x12, 0xf2, 0x00, 0x00 },	// U+04D4 (Ӕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x90, 0xfc, 0x12, 0x12, 0x92, 0x7c, 0x00, 0x00 },	// U+04D5 (ӕ)
	{ 0x42, 0x42, 0x3c, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+04D6 (Ӗ)
	{ 0x00, 0x00, 0x42, 0x42, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+04D7 (ӗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x40, 0x40, 0x7e, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+04D8 (Ә)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+04D9 (ә)
	{ 0x24, 0x24, 0x00, 0x00, 0x18, 0x24, 0x42, 0x40, 0x40, 0x7e, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+04DA (Ӛ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+04DB (ӛ)
	{ 0x24, 0x24, 0x00, 0x00, 0x92, 0x92, 0x54, 0x54, 0x38, 0x38, 0x54, 0x54, 0x92, 0x92, 0x00, 0x00 },	// U+04DC (Ӝ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x92, 0x92, 0x54, 0x38, 0x38, 0x54, 0x92, 0x92, 0x00, 0x00 },	// U+04DD (ӝ)
	{ 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x20, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+04DE (Ӟ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x3c, 0x20, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+04DF (ӟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x08, 0x38, 0x40, 0x40, 0x40, 0x62, 0x3c, 0x00, 0x00 },	// U+04E0 (Ӡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x20, 0x10, 0x08, 0x38, 0x40, 0x40, 0x40, 0x42, 0x3c },	// U+04E1 (ӡ)
	{ 0x00, 0x3c, 0x00, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x42, 0x00, 0x00 },	// U+04E2 (Ӣ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x00, 0x00 },	// U+04E3 (ӣ)
	{ 0x24, 0x24, 0x00, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x42, 0x00, 0x00 },	// U+04E4 (Ӥ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x00, 0x00 },	// U+04E5 (ӥ)
	{ 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+04E6 (Ӧ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+04E7 (ӧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+04E8 (Ө)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+04E9 (ө)
	{ 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+04EA (Ӫ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+04EB (ӫ)
	{ 0x00, 0x00, 0x24, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+04EC (Ӭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x3c, 0x42, 0x40, 0x78, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+04ED (ӭ)
	{ 0x00, 0x7c, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x08, 0x0c, 0x00, 0x00 },	// U+04EE (Ӯ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x08, 0x08, 0x04, 0x06 },	// U+04EF (ӯ)
	{ 0x24, 0x24, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x08, 0x0c, 0x00, 0x00 },	// U+04F0 (Ӱ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x08, 0x08, 0x04, 0x06 },	// U+04F1 (ӱ)
	{ 0xcc, 0x22, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x08, 0x0c, 0x00, 0x00 },	// U+04F2 (Ӳ)
	{ 0x00, 0x00, 0xcc, 0x22, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x08, 0x08, 0x04, 0x06 },	// U+04F3 (ӳ)
	{ 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+04F4 (Ӵ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40, 0x00, 0x00 },	// U+04F5 (ӵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x04, 0x04 },	// U+04F6 (Ӷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x04, 0x04 },	// U+04F7 (ӷ)
	{ 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x4e, 0x52, 0x52, 0x52, 0x52, 0x4e, 0x00, 0x00 },	// U+04F8 (Ӹ)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x4e, 0x52, 0x52, 0x52, 0x4e, 0x00, 0x00 },	// U+04F9 (ӹ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x18, 0x10, 0x18 },	// U+04FA (Ӻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x18, 0x10, 0x18 },	// U+04FB (ӻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x40, 0x20 },	// U+04FC (Ӽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x42, 0x40, 0x20 },	// U+04FD (ӽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x7e, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+04FE (Ӿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x7e, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+04FF (ӿ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0500 (Ԁ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0501 (ԁ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0xa2, 0xa2, 0xa2, 0xb2, 0x6c, 0x00, 0x00 },	// U+0502 (Ԃ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x2c, 0x32, 0x22, 0x22, 0xa2, 0xb2, 0x6c, 0x00, 0x00 },	// U+0503 (ԃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x20, 0x18, 0xa0, 0xa0, 0xa0, 0xa0, 0x40, 0x00, 0x00 },	// U+0504 (Ԅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x20, 0x18, 0xa0, 0xa0, 0x40, 0x00, 0x00 },	// U+0505 (ԅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x20, 0x18, 0x20, 0x20, 0x20, 0x20, 0xc0, 0x80, 0x80 },	// U+0506 (Ԇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x20, 0x18, 0x20, 0x20, 0xc0, 0x80, 0x80 },	// U+0507 (ԇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0xa4, 0xa4, 0xa2, 0xa2, 0x41, 0x00, 0x00 },	// U+0508 (Ԉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0xa2, 0xa2, 0x41, 0x00, 0x00 },	// U+0509 (ԉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3e, 0xa2, 0xa2, 0xa2, 0xa2, 0x62, 0x00, 0x00 },	// U+050A (Ԋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0xa2, 0xa2, 0x62, 0x00, 0x00 },	// U+050B (ԋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+050C (Ԍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+050D (ԍ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x90, 0x90, 0x90, 0x90, 0x70, 0x00, 0x00 },	// U+050E (Ԏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x90, 0x90, 0x90, 0x70, 0x00, 0x00 },	// U+050F (ԏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x3c, 0x04, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0510 (Ԑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+0511 (ԑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x44, 0x44, 0x42, 0x50, 0x30 },	// U+0512 (Ԓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x48, 0x44, 0x44, 0x42, 0x50, 0x30 },	// U+0513 (ԓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x8e, 0x8a, 0x52, 0x52, 0x22, 0x22, 0x52, 0x52, 0x8a, 0x89, 0x00, 0x00 },	// U+0514 (Ԕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0x8a, 0x52, 0x22, 0x22, 0x52, 0x8a, 0x89, 0x00, 0x00 },	// U+0515 (ԕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x87, 0x49, 0x29, 0x19, 0x09, 0x0f, 0x11, 0x21, 0x41, 0x81, 0x00, 0x00 },	// U+0516 (Ԗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x47, 0x29, 0x19, 0x19, 0x29, 0x47, 0x81, 0x01, 0x01 },	// U+0517 (ԗ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x11, 0x11, 0x11, 0xfe, 0x14, 0x12, 0x12, 0x11, 0xf1, 0x00, 0x00 },	// U+0518 (Ԙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x91, 0x91, 0xfe, 0x14, 0x14, 0x92, 0x62, 0x00, 0x00 },	// U+0519 (ԙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x66, 0x3c, 0xc0, 0x00 },	// U+051A (Ԛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40 },	// U+051B (ԛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+051C (Ԝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+051D (ԝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x52, 0x22, 0x52, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+051E (Ԟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x12, 0x2a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+051F (ԟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x0a, 0x7a, 0x8a, 0x8a, 0x89, 0x89, 0x89, 0xa0, 0x40 },	// U+0520 (Ԡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x7a, 0x8a, 0x8a, 0x89, 0x89, 0xa0, 0x40 },	// U+0521 (ԡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x09, 0x7f, 0x89, 0x89, 0x89, 0x89, 0x89, 0xa0, 0x40 },	// U+0522 (Ԣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x7f, 0x89, 0x89, 0x89, 0x89, 0xa0, 0x40 },	// U+0523 (ԣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x62, 0x40, 0x40 },	// U+0524 (Ԥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x62, 0x40, 0x40 },	// U+0525 (ԥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0xc2, 0x80, 0x80 },	// U+0526 (Ԧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0xc2, 0x80, 0x80 },	// U+0527 (ԧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x88, 0x88, 0x0a, 0x04 },	// U+0528 (Ԩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x88, 0x0a, 0x04 },	// U+0529 (ԩ)
}; // 160

static const unsigned char unifont_block12[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x32, 0x2a, 0x2a, 0x2a, 0x3e, 0x24, 0x24, 0x22, 0x7e, 0x42, 0x42 },	// U+052C (Ԭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x2a, 0x2a, 0x2a, 0x3e, 0x24, 0x24, 0x24, 0x7e, 0x42 },	// U+052D (ԭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x44, 0x44, 0xc2, 0x80, 0x80 },	// U+052E (Ԯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x48, 0x44, 0x44, 0xc2, 0x80, 0x80 },	// U+052F (ԯ)
}; // 4

static const unsigned char unifont_block13[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xe2, 0xa2, 0x1c, 0x00, 0x00 },	// U+0531 (Ա)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x3e, 0x42, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0532 (Բ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x7c, 0xa0, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+0533 (Գ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x20, 0x20, 0x60, 0xa0, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+0534 (Դ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x3e, 0x42, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0535 (Ե)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x44, 0x38, 0x20, 0x10, 0x08, 0x7e, 0x40, 0x00 },	// U+0536 (Զ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x40, 0x00 },	// U+0537 (Է)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x40, 0x00 },	// U+0538 (Ը)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0xf2, 0x2a, 0x2a, 0x12, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0539 (Թ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0xfc, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+053A (Ժ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+053B (Ի)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x40, 0x00 },	// U+053C (Լ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x9e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x62, 0x00, 0x00 },	// U+053D (Խ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+053E (Ծ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x00, 0x00 },	// U+053F (Կ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x10, 0x08, 0x04, 0x02, 0x06, 0x18, 0x60, 0x00, 0x00 },	// U+0540 (Հ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x44, 0x38, 0x24, 0x1a, 0x12, 0x6c, 0x00, 0x00 },	// U+0541 (Ձ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xe0, 0x80, 0x00 },	// U+0542 (Ղ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x26, 0x18, 0x24, 0x24, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x00, 0x00 },	// U+0543 (Ճ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe2, 0xa2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+0544 (Մ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x40, 0x42, 0x3e, 0x42, 0x40, 0x40, 0x44, 0x38, 0x00, 0x00 },	// U+0545 (Յ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x88, 0x88, 0x70, 0x00 },	// U+0546 (Ն)
	{ 0x00, 0x00, 0x00, 0x02, 0x3c, 0x04, 0x02, 0x02, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0547 (Շ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0548 (Ո)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x44, 0x38, 0x20, 0x10, 0x0e, 0x18, 0x60, 0x00 },	// U+0549 (Չ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x90, 0x90, 0x80, 0x80, 0x80, 0x00, 0x00 },	// U+054A (Պ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x48, 0x50, 0x30, 0x30, 0x10, 0x08, 0x7e, 0x40, 0x00 },	// U+054B (Ջ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0xe2, 0xa2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+054C (Ռ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+054D (Ս)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0xe0, 0x80, 0x00 },	// U+054E (Վ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+054F (Տ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0550 (Ր)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x42, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+0551 (Ց)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x1a, 0x26, 0x22, 0x22, 0xc2, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0552 (Ւ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x00, 0x00 },	// U+0553 (Փ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x48, 0x38, 0x0a, 0x3e, 0x28, 0x08, 0x08, 0x00, 0x00 },	// U+0554 (Ք)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0555 (Օ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x1c, 0x70, 0x90, 0x90, 0x90, 0x92, 0x7c, 0x00, 0x00 },	// U+0556 (Ֆ)
}; // 38

static const unsigned char unifont_block14[][16] = {
	{ 0x08, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0559 (ՙ)
	{ 0x04, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055A (՚)
	{ 0x10, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055B (՛)
	{ 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055C (՜)
	{ 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055D (՝)
	{ 0x1c, 0x22, 0x2a, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055E (՞)
	{ 0x0c, 0x0a, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055F (՟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+0560 (ՠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xec, 0x00, 0x00 },	// U+0561 (ա)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x42, 0x42, 0x02, 0x7e, 0x02, 0x02, 0x02 },	// U+0562 (բ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0xfc, 0x20, 0x20, 0x20 },	// U+0563 (գ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x22, 0xe2, 0x20, 0x20 },	// U+0564 (դ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x7e, 0x02, 0x42, 0x42, 0x44, 0x38, 0x00, 0x00 },	// U+0565 (ե)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x32, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0xe0 },	// U+0566 (զ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1c, 0x20, 0x00 },	// U+0567 (է)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x02, 0x7e },	// U+0568 (ը)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0xf2, 0x2a, 0x2a, 0x12, 0x02, 0x02, 0x02 },	// U+0569 (թ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0xfc, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+056A (ժ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x02, 0x02 },	// U+056B (ի)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e },	// U+056C (լ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x9e, 0x92, 0x92, 0x92, 0x92, 0x62, 0x02, 0x02, 0x02 },	// U+056D (խ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x20, 0xfc, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+056E (ծ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x78, 0x40, 0x40 },	// U+056F (կ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0570 (հ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x10, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00 },	// U+0571 (ձ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0xe0 },	// U+0572 (ղ)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x08, 0xfe, 0x88, 0x88, 0x88, 0x88, 0xc8, 0xb0, 0x00, 0x00 },	// U+0573 (ճ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0xa0, 0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+0574 (մ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x12, 0x0c },	// U+0575 (յ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+0576 (ն)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0xfc, 0x00, 0x00 },	// U+0577 (շ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+0578 (ո)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x08, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0xfc, 0x00, 0x00 },	// U+0579 (չ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xec, 0x80, 0x80 },	// U+057A (պ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x24, 0x28, 0x18, 0x18, 0x04, 0x04, 0xfc, 0x00, 0x00 },	// U+057B (ջ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x22, 0xe2, 0x00, 0x00 },	// U+057C (ռ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+057D (ս)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x20, 0xe0 },	// U+057E (վ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xb2, 0x92, 0x92, 0x92, 0x92, 0x9a, 0x94, 0x00, 0x00 },	// U+057F (տ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x02, 0x02 },	// U+0580 (ր)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x42, 0x3c },	// U+0581 (ց)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x70, 0x00, 0x00 },	// U+0582 (ւ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x52, 0xb2, 0x92, 0x92, 0x92, 0x92, 0x9a, 0x94, 0x10, 0x10 },	// U+0583 (փ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x48, 0x38, 0x08, 0x3c, 0x08, 0x08, 0x18 },	// U+0584 (ք)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0585 (օ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x1c, 0x70, 0x90, 0x90, 0x90, 0x92, 0x7c, 0x10, 0x10 },	// U+0586 (ֆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xdc, 0x00, 0x00 },	// U+0587 (և)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x78, 0x20, 0x20, 0x12, 0x0c },	// U+0588 (ֈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0589 (։)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x3c, 0x00, 0x00, 0x00 },	// U+058A (֊)
}; // 50

static const unsigned char unifont_block15[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x20, 0xf8, 0x20, 0xf8, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+058F (֏)
}; // 1

static const unsigned char unifont_block16[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x11 },	// U+0591 (֑)
	{ 0x00, 0x18, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0592 (֒)
	{ 0x30, 0x0c, 0x30, 0x0c, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0593 (֓)
	{ 0x00, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0594 (֔)
	{ 0x00, 0x34, 0x04, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0595 (֕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x06 },	// U+0596 (֖)
	{ 0x10, 0x38, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0597 (֗)
	{ 0x00, 0x24, 0x4a, 0x52, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0598 (֘)
	{ 0x00, 0x03, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0599 (֙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x80 },	// U+059A (֚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x08, 0x07 },	// U+059B (֛)
	{ 0x00, 0x30, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+059C (֜)
	{ 0x00, 0xc0, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+059D (֝)
	{ 0x00, 0x6c, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+059E (֞)
	{ 0x00, 0x42, 0xa5, 0x42, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+059F (֟)
	{ 0x00, 0x40, 0xa0, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05A0 (֠)
	{ 0x00, 0x0a, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05A1 (֡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x04 },	// U+05A2 (֢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x07 },	// U+05A3 (֣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x02 },	// U+05A4 (֤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x03 },	// U+05A5 (֥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x1b },	// U+05A6 (֦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x01, 0x06, 0x08, 0x06 },	// U+05A7 (֧)
	{ 0x00, 0x03, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05A8 (֨)
	{ 0x00, 0x02, 0x05, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05A9 (֩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x06 },	// U+05AA (֪)
	{ 0x00, 0x08, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05AB (֫)
	{ 0x00, 0x20, 0x20, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05AC (֬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0xc0 },	// U+05AD (֭)
	{ 0x00, 0x12, 0x15, 0x15, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05AE (֮)
	{ 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05AF (֯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18 },	// U+05B0 (ְ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x00, 0x48 },	// U+05B1 (ֱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x40 },	// U+05B2 (ֲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x08, 0x48 },	// U+05B3 (ֳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+05B4 (ִ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66 },	// U+05B5 (ֵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x00, 0x18 },	// U+05B6 (ֶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00 },	// U+05B7 (ַ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10 },	// U+05B8 (ָ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05B9 (ֹ)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05BA (ֺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x10, 0x40 },	// U+05BB (ֻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05BC (ּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10 },	// U+05BD (ֽ)
	{ 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05BE (־)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05BF (ֿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+05C0 (׀)
	{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05C1 (ׁ)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05C2 (ׂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x10, 0x00, 0x00, 0x10, 0x38, 0x10, 0x00, 0x00 },	// U+05C3 (׃)
	{ 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05C4 (ׄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+05C5 (ׅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+05C6 (׆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10 },	// U+05C7 (ׇ)
}; // 55

static const unsigned char unifont_block17[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x44, 0x48, 0x34, 0x12, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+05D0 (א)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xfe, 0x00, 0x00 },	// U+05D1 (ב)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x20, 0x30, 0x28, 0x44, 0x42, 0x00, 0x00 },	// U+05D2 (ג)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+05D3 (ד)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+05D4 (ה)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+05D5 (ו)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+05D6 (ז)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+05D7 (ח)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x52, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x00, 0x00 },	// U+05D8 (ט)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05D9 (י)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },	// U+05DA (ך)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x00 },	// U+05DB (כ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x10, 0x0c, 0x00, 0x00 },	// U+05DC (ל)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7c, 0x00, 0x00 },	// U+05DD (ם)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x8c, 0x84, 0x82, 0x82, 0x82, 0x82, 0x82, 0xe2, 0x00, 0x00 },	// U+05DE (מ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+05DF (ן)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x00, 0x00 },	// U+05E0 (נ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+05E1 (ס)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x7f, 0x00, 0x00 },	// U+05E2 (ע)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x4e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },	// U+05E3 (ף)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x4e, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+05E4 (פ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x24, 0x14, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+05E5 (ץ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x10, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+05E6 (צ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x44, 0x44, 0x24, 0x24, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+05E7 (ק)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+05E8 (ר)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+05E9 (ש)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x46, 0x00, 0x00 },	// U+05EA (ת)
}; // 27

static const unsigned char unifont_block18[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0xee, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00 },	// U+05EF (ׯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00 },	// U+05F0 (װ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x88, 0x88, 0x88, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00 },	// U+05F1 (ױ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05F2 (ײ)
	{ 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05F3 (׳)
	{ 0x00, 0x00, 0x48, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05F4 (״)
}; // 6

static const unsigned char unifont_block19[][16] = {
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x14, 0x10, 0x08, 0x08, 0x04, 0x04, 0x22, 0x0a, 0x00, 0x00, 0x00 },	// U+0609 (؉)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x14, 0x10, 0x08, 0x08, 0x04, 0x84, 0x22, 0x0a, 0x00, 0x00, 0x00 },	// U+060A (؊)
}; // 2

static const unsigned char unifont_block20[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+060C (،)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+060D (؍)
}; // 2

static const unsigned char unifont_block21[][16] = {
	{ 0x00, 0x60, 0x90, 0x9c, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0610 (ؐ)
}; // 1

static const unsigned char unifont_block22[][16] = {
	{ 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0618 (ؘ)
	{ 0x18, 0x38, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0619 (ؙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00 },	// U+061A (ؚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+061B (؛)
}; // 4

static const unsigned char unifont_block23[][16] = {
	{ 0x00, 0x00, 0x00, 0x7c, 0x82, 0x02, 0x04, 0x08, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+061F (؟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x4a, 0x12, 0x22, 0x1c, 0x08, 0x14, 0x08, 0x00 },	// U+0620 (ؠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x3c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+0621 (ء)
	{ 0x00, 0x80, 0x7c, 0x02, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0622 (آ)
	{ 0x18, 0x04, 0x18, 0x04, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0623 (أ)
	{ 0x00, 0x00, 0x30, 0x08, 0x30, 0x08, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0624 (ؤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x30, 0x08, 0x30, 0x08 },	// U+0625 (إ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x18, 0x04, 0x00, 0x62, 0x12, 0x12, 0x62, 0x42, 0x3c, 0x00 },	// U+0626 (ئ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0627 (ا)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+0628 (ب)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x08, 0x18, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0629 (ة)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+062A (ت)
	{ 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+062B (ث)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+062C (ج)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+062D (ح)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+062E (خ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+062F (د)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0630 (ذ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0631 (ر)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0632 (ز)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x12, 0x0c, 0x00 },	// U+0633 (س)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x00, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x12, 0x0c, 0x00 },	// U+0634 (ش)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x98, 0x72, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+0635 (ص)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x60, 0x98, 0x72, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+0636 (ض)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x44, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0637 (ط)
	{ 0x00, 0x00, 0x00, 0x04, 0x24, 0x04, 0x04, 0x34, 0x4c, 0x44, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0638 (ظ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+0639 (ع)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+063A (غ)
	{ 0x00, 0x00, 0x0a, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+063B (ػ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x14, 0x00, 0x08, 0x00 },	// U+063C (ؼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x00, 0x20, 0x52, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+063D (ؽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x20, 0x52, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+063E (ؾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0a, 0x20, 0x52, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+063F (ؿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0640 (ـ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0641 (ف)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x38, 0x48, 0x50, 0x64, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+0642 (ق)
	{ 0x00, 0x00, 0x00, 0x40, 0x50, 0x48, 0x50, 0x44, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0643 (ك)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x44, 0x42, 0x42, 0x22, 0x3c, 0x00, 0x00 },	// U+0644 (ل)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x60, 0x78, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+0645 (م)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+0646 (ن)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0647 (ه)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0648 (و)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x52, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+0649 (ى)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x52, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+064A (ي)
	{ 0x30, 0x0c, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+064B (ً)
	{ 0x30, 0x30, 0x26, 0x14, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+064C (ٌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0c, 0x30, 0x0c, 0x00, 0x00 },	// U+064D (ٍ)
	{ 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+064E (َ)
	{ 0x30, 0x70, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+064F (ُ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c },	// U+0650 (ِ)
	{ 0x00, 0x00, 0x00, 0x20, 0x28, 0x1a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0651 (ّ)
	{ 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0652 (ْ)
	{ 0x00, 0x80, 0x7c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0653 (ٓ)
	{ 0x18, 0x04, 0x18, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0654 (ٔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x18, 0x04 },	// U+0655 (ٕ)
}; // 55

static const unsigned char unifont_block24[][16] = {
	{ 0x20, 0x10, 0x08, 0x0e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0657 (ٗ)
	{ 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0658 (٘)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0659 (ٙ)
	{ 0x00, 0x22, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+065A (ٚ)
	{ 0x00, 0x08, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+065B (ٛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+065C (ٜ)
	{ 0x0c, 0x0e, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+065D (ٝ)
	{ 0x24, 0x10, 0x08, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+065E (ٞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x10, 0x64, 0x1a },	// U+065F (ٟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0660 (٠)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+0661 (١)
	{ 0x00, 0x00, 0x00, 0x44, 0x24, 0x18, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+0662 (٢)
	{ 0x00, 0x00, 0x00, 0x92, 0x4a, 0x3c, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+0663 (٣)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x18, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0664 (٤)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0665 (٥)
	{ 0x00, 0x00, 0x00, 0x02, 0x3c, 0x20, 0x20, 0x40, 0x40, 0x40, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+0666 (٦)
	{ 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+0667 (٧)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00 },	// U+0668 (٨)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x22, 0x32, 0x2c, 0x40, 0x40, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+0669 (٩)
	{ 0x00, 0x00, 0x20, 0x20, 0x12, 0x12, 0x08, 0x08, 0x24, 0x24, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+066A (٪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x1c, 0x00, 0x00, 0x00 },	// U+066B (٫)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+066C (٬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0xfe, 0x38, 0x6c, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+066D (٭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+066E (ٮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x48, 0x50, 0x64, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+066F (ٯ)
	{ 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0670 (ٰ)
	{ 0x20, 0x50, 0x78, 0x04, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0671 (ٱ)
	{ 0x60, 0x10, 0x64, 0x1a, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0672 (ٲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x60, 0x10, 0x64, 0x1a },	// U+0673 (ٳ)
	{ 0x18, 0x04, 0x18, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0674 (ٴ)
	{ 0x60, 0x10, 0x60, 0x10, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0675 (ٵ)
	{ 0x00, 0x00, 0xc0, 0x20, 0xc0, 0x20, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0676 (ٶ)
	{ 0x00, 0x00, 0xcc, 0x2c, 0xc8, 0x24, 0x02, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0677 (ٷ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0xc0, 0x20, 0x00, 0x62, 0x12, 0x12, 0x62, 0x42, 0x3c, 0x00 },	// U+0678 (ٸ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1c, 0x1c, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0679 (ٹ)
	{ 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+067A (ٺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x10, 0x00, 0x10, 0x00 },	// U+067B (ٻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x10, 0x28, 0x10, 0x00, 0x00 },	// U+067C (ټ)
	{ 0x00, 0x00, 0x14, 0x00, 0x08, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+067D (ٽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x28, 0x00, 0x10, 0x00 },	// U+067E (پ)
	{ 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+067F (ٿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x28, 0x00, 0x28, 0x00 },	// U+0680 (ڀ)
	{ 0x00, 0x00, 0x00, 0x18, 0x04, 0x18, 0x04, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+0681 (ځ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+0682 (ڂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x2a, 0x02, 0x44, 0x38 },	// U+0683 (ڃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x12, 0x02, 0x12, 0x44, 0x38 },	// U+0684 (ڄ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+0685 (څ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x02, 0x2a, 0x02, 0x12, 0x44, 0x38 },	// U+0686 (چ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x02, 0x2a, 0x02, 0x2a, 0x44, 0x38 },	// U+0687 (ڇ)
	{ 0x00, 0x04, 0x04, 0x1c, 0x1c, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0688 (ڈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x10, 0x28, 0x10, 0x00, 0x00 },	// U+0689 (ډ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+068A (ڊ)
	{ 0x00, 0x04, 0x04, 0x1c, 0x1c, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+068B (ڋ)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+068C (ڌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x14, 0x00, 0x00, 0x00 },	// U+068D (ڍ)
	{ 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+068E (ڎ)
	{ 0x00, 0x00, 0x14, 0x00, 0x08, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+068F (ڏ)
	{ 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0690 (ڐ)
	{ 0x00, 0x00, 0x10, 0x10, 0x70, 0x70, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0691 (ڑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0692 (ڒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x32, 0x5c, 0x20 },	// U+0693 (ړ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x4c, 0x00 },	// U+0694 (ڔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0x20, 0x10, 0x12, 0xac, 0x40 },	// U+0695 (ڕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x48, 0x20, 0x12, 0x4c, 0x00 },	// U+0696 (ږ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0697 (ڗ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0698 (ژ)
	{ 0x00, 0x00, 0x00, 0x48, 0x00, 0x48, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0699 (ڙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x52, 0x0c, 0x00, 0x00 },	// U+069A (ښ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xa8, 0xa8, 0x7a, 0x0a, 0xaa, 0x04, 0x40, 0x00 },	// U+069B (ڛ)
	{ 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x00, 0x80, 0xa8, 0xa8, 0x7a, 0x0a, 0xaa, 0x04, 0x40, 0x00 },	// U+069C (ڜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x98, 0x72, 0x0a, 0xaa, 0x04, 0x00, 0x00 },	// U+069D (ڝ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x00, 0x60, 0x98, 0x72, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+069E (ڞ)
	{ 0x00, 0x00, 0x00, 0x24, 0x04, 0x54, 0x04, 0x34, 0x4c, 0x44, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+069F (ڟ)
	{ 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+06A0 (ڠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06A1 (ڡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+06A2 (ڢ)
	{ 0x00, 0x00, 0x20, 0x00, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+06A3 (ڣ)
	{ 0x00, 0x10, 0x00, 0x48, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06A4 (ڤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x24, 0x00, 0x08, 0x00 },	// U+06A5 (ڥ)
	{ 0x00, 0x50, 0x00, 0x50, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06A6 (ڦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x38, 0x48, 0x50, 0x64, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+06A7 (ڧ)
	{ 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x00, 0x38, 0x48, 0x50, 0x64, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+06A8 (ڨ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06A9 (ک)
}; // 83

static const unsigned char unifont_block25[][16] = {
	{ 0x00, 0x00, 0x00, 0x20, 0x30, 0x58, 0x24, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06AB (ګ)
	{ 0x00, 0x10, 0x00, 0x40, 0x50, 0x48, 0x50, 0x44, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06AC (ڬ)
	{ 0x08, 0x00, 0x14, 0x40, 0x50, 0x48, 0x50, 0x44, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06AD (ڭ)
	{ 0x00, 0x00, 0x00, 0x40, 0x50, 0x48, 0x50, 0x44, 0x42, 0x42, 0x3c, 0x00, 0x28, 0x00, 0x10, 0x00 },	// U+06AE (ڮ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06AF (گ)
	{ 0x00, 0x10, 0x08, 0x24, 0x32, 0x58, 0x24, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06B0 (ڰ)
	{ 0x00, 0x0a, 0x60, 0x18, 0x46, 0x30, 0x0c, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06B1 (ڱ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x14, 0x00, 0x00, 0x00 },	// U+06B2 (ڲ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x08, 0x00, 0x08, 0x00 },	// U+06B3 (ڳ)
	{ 0x02, 0x00, 0x65, 0x18, 0x46, 0x30, 0x0c, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06B4 (ڴ)
	{ 0x00, 0x88, 0x50, 0x20, 0x00, 0x40, 0x40, 0x40, 0x40, 0x44, 0x42, 0x42, 0x22, 0x3c, 0x00, 0x00 },	// U+06B5 (ڵ)
	{ 0x00, 0x40, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x44, 0x42, 0x42, 0x22, 0x3c, 0x00, 0x00 },	// U+06B6 (ڶ)
	{ 0x20, 0x00, 0x90, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x44, 0x42, 0x42, 0x22, 0x3c, 0x00, 0x00 },	// U+06B7 (ڷ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x44, 0x42, 0x3c, 0x00, 0x28, 0x00, 0x10 },	// U+06B8 (ڸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x10 },	// U+06B9 (ڹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+06BA (ں)
	{ 0x00, 0x00, 0x08, 0x08, 0x38, 0x38, 0x00, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+06BB (ڻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x3c, 0x50, 0x20 },	// U+06BC (ڼ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+06BD (ڽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x34, 0x54, 0x58, 0x24, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+06BE (ھ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x7e, 0x04, 0x02, 0x2a, 0x02, 0x12, 0x44, 0x38 },	// U+06BF (ڿ)
	{ 0x00, 0x18, 0x04, 0x18, 0x04, 0x00, 0x08, 0x18, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06C0 (ۀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf4, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+06C1 (ہ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x18, 0x04, 0x00, 0x08, 0xf4, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+06C2 (ۂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x08, 0xf4, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+06C3 (ۃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x70, 0x44, 0x4a, 0x24, 0x1e, 0x00 },	// U+06C4 (ۄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x38, 0x12, 0x0c, 0x00 },	// U+06C5 (ۅ)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+06C6 (ۆ)
	{ 0x00, 0x00, 0x18, 0x18, 0x10, 0x08, 0x04, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+06C7 (ۇ)
	{ 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+06C8 (ۈ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+06C9 (ۉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+06CA (ۊ)
	{ 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+06CB (ۋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x52, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+06CC (ی)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x54, 0x16, 0x25, 0x44, 0x44, 0x38, 0x00 },	// U+06CD (ۍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x20, 0x52, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+06CE (ێ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+06CF (ۏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x4a, 0x12, 0x22, 0x1c, 0x00, 0x08, 0x00, 0x08 },	// U+06D0 (ې)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x4a, 0x12, 0x22, 0x1c, 0x00, 0x14, 0x00, 0x08 },	// U+06D1 (ۑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x08, 0x04, 0x02, 0xfe, 0x00 },	// U+06D2 (ے)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x0c, 0x02, 0x10, 0x28, 0x08, 0x04, 0x02, 0xfe, 0x00 },	// U+06D3 (ۓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06D4 (۔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06D5 (ە)
}; // 43

static const unsigned char unifont_block26[][16] = {
	{ 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06DB (ۛ)
}; // 1

static const unsigned char unifont_block27[][16] = {
	{ 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06DF (۟)
	{ 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06E0 (۠)
	{ 0x7e, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06E1 (ۡ)
}; // 3

static const unsigned char unifont_block28[][16] = {
	{ 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06E4 (ۤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x70, 0x40, 0x38, 0x00, 0x00, 0x00 },	// U+06E5 (ۥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+06E6 (ۦ)
	{ 0x00, 0x08, 0x04, 0x02, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06E7 (ۧ)
}; // 4

static const unsigned char unifont_block29[][16] = {
	{ 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06EE (ۮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x88, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+06EF (ۯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+06F0 (۰)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+06F1 (۱)
	{ 0x00, 0x00, 0x00, 0x44, 0x24, 0x18, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+06F2 (۲)
	{ 0x00, 0x00, 0x00, 0x92, 0x4a, 0x3c, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+06F3 (۳)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x06, 0x4e, 0x34, 0x04, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+06F4 (۴)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x92, 0xaa, 0xc6, 0x00, 0x00, 0x00 },	// U+06F5 (۵)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x04, 0x04, 0x18, 0x60, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+06F6 (۶)
	{ 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+06F7 (۷)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00 },	// U+06F8 (۸)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x22, 0x32, 0x2c, 0x40, 0x40, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+06F9 (۹)
	{ 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x00, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x52, 0x0c, 0x00, 0x00 },	// U+06FA (ۺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x60, 0x98, 0x72, 0x12, 0x52, 0x0c, 0x00, 0x00 },	// U+06FB (ۻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x12, 0x02, 0x42, 0x3c },	// U+06FC (ۼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x3c, 0x08, 0x04, 0x00, 0x28, 0x28, 0x28, 0x28 },	// U+06FD (۽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x60, 0x7c, 0x02, 0x52, 0x52, 0x52, 0x52 },	// U+06FE (۾)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x08, 0x34, 0x54, 0x58, 0x24, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+06FF (ۿ)
}; // 18

static const unsigned char unifont_block30[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x54, 0x00, 0x00 },	// U+0750 (ݐ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+0751 (ݑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x10, 0x00, 0x28, 0x00 },	// U+0752 (ݒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x10, 0x00, 0x28, 0x00 },	// U+0753 (ݓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x28, 0x00, 0x00 },	// U+0754 (ݔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x10, 0x28, 0x44, 0x00 },	// U+0755 (ݕ)
	{ 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0756 (ݖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+0757 (ݗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x24, 0x02, 0x52, 0x02, 0x44, 0x38 },	// U+0758 (ݘ)
	{ 0x04, 0x04, 0x14, 0x2c, 0x1e, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x08, 0x00, 0x08, 0x00 },	// U+0759 (ݙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x10, 0x28, 0x44, 0x00 },	// U+075A (ݚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0xf8, 0x20, 0x12, 0x0c, 0x00 },	// U+075B (ݛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x28, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x12, 0x0c, 0x00 },	// U+075C (ݜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+075D (ݝ)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x08, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+075E (ݞ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+075F (ݟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x50, 0x00, 0x00, 0x00 },	// U+0760 (ݠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x20, 0x00, 0x50, 0x00 },	// U+0761 (ݡ)
	{ 0x00, 0x00, 0x00, 0x20, 0x11, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0762 (ݢ)
	{ 0x00, 0x02, 0x00, 0x25, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0763 (ݣ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x10, 0x00, 0x28, 0x00 },	// U+0764 (ݤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x38, 0x60, 0x78, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+0765 (ݥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x60, 0x78, 0x04, 0x14, 0x04, 0x04, 0x04 },	// U+0766 (ݦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x28 },	// U+0767 (ݧ)
	{ 0x04, 0x04, 0x14, 0x2c, 0x1e, 0x00, 0x04, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+0768 (ݨ)
	{ 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x04, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+0769 (ݩ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x78, 0x20, 0x24, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+076A (ݪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+076B (ݫ)
	{ 0x00, 0x00, 0x00, 0x18, 0x04, 0x18, 0x04, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+076C (ݬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x12, 0x0c, 0x00 },	// U+076D (ݭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x14, 0x32, 0x52, 0x3a, 0x44, 0x38 },	// U+076E (ݮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x14, 0x32, 0x52, 0x3a, 0x02, 0x2a, 0x02, 0x44, 0x38 },	// U+076F (ݯ)
	{ 0x00, 0x04, 0x04, 0x14, 0x2c, 0x1e, 0x00, 0x28, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x12, 0x0c, 0x00 },	// U+0770 (ݰ)
	{ 0x04, 0x04, 0x14, 0x2c, 0x1e, 0x00, 0x08, 0x02, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0771 (ݱ)
	{ 0x00, 0x00, 0x08, 0x08, 0x28, 0x58, 0x3c, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+0772 (ݲ)
	{ 0x14, 0x14, 0x0c, 0x04, 0x14, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0773 (ݳ)
	{ 0x54, 0x54, 0x2c, 0x04, 0x14, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0774 (ݴ)
	{ 0x00, 0x00, 0x00, 0x28, 0x28, 0x18, 0x08, 0x08, 0x08, 0x62, 0x12, 0x12, 0x62, 0x42, 0x3c, 0x00 },	// U+0775 (ݵ)
	{ 0x00, 0x00, 0x00, 0xa8, 0xa8, 0x58, 0x08, 0x08, 0x08, 0x62, 0x12, 0x12, 0x62, 0x42, 0x3c, 0x00 },	// U+0776 (ݶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x62, 0x12, 0x12, 0x62, 0x42, 0x3c, 0x00, 0x10, 0x68, 0x08, 0x08, 0x08 },	// U+0777 (ݷ)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x06, 0x02, 0x02, 0x32, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0778 (ݸ)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x16, 0x02, 0x02, 0x32, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+0779 (ݹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x06, 0x02, 0x12, 0x2a, 0x08, 0x04, 0x02, 0xfe, 0x00 },	// U+077A (ݺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x16, 0x02, 0x12, 0x2a, 0x08, 0x04, 0x02, 0xfe, 0x00 },	// U+077B (ݻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x24, 0xd2, 0x12, 0x12, 0x44, 0x38 },	// U+077C (ݼ)
	{ 0x00, 0x00, 0x00, 0x10, 0x68, 0x08, 0x08, 0x08, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x12, 0x0c, 0x00 },	// U+077D (ݽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x12, 0x0c, 0x00 },	// U+077E (ݾ)
	{ 0x00, 0x00, 0x14, 0x40, 0x50, 0x48, 0x50, 0x44, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+077F (ݿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+0780 (ހ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x38, 0x04, 0x02, 0x00, 0x00 },	// U+0781 (ށ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x2c, 0x02, 0x01, 0x00, 0x00 },	// U+0782 (ނ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x30, 0x30, 0x48, 0x04, 0x02, 0x00, 0x00 },	// U+0783 (ރ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x2a, 0x1c, 0x00, 0x00 },	// U+0784 (ބ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x24, 0x18, 0x08, 0x04, 0x00, 0x00 },	// U+0785 (ޅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x14, 0x0c, 0x04, 0x00, 0x00 },	// U+0786 (ކ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x28, 0x24, 0x00, 0x00 },	// U+0787 (އ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+0788 (ވ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+0789 (މ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x40, 0x20, 0x40, 0x20, 0x10, 0x08, 0x00, 0x00 },	// U+078A (ފ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x18, 0x04, 0x02, 0x00 },	// U+078B (ދ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x34, 0x02, 0x04, 0x02, 0x00, 0x00 },	// U+078C (ތ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x48, 0x3c, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+078D (ލ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x10, 0x0c, 0x00, 0x00 },	// U+078E (ގ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x14, 0x02, 0x02, 0x1c, 0x00, 0x00 },	// U+078F (ޏ)
}; // 64

static const unsigned char unifont_block31[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x30, 0x10, 0x08, 0x78, 0x00, 0x00 },	// U+0791 (ޑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x30, 0x30, 0x48, 0x04, 0x04, 0x38, 0x00, 0x00 },	// U+0792 (ޒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x54, 0x54, 0x38, 0x04, 0x04, 0x38, 0x00, 0x00 },	// U+0793 (ޓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x58, 0x48, 0x04, 0x02, 0x00, 0x00 },	// U+0794 (ޔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x40, 0x20, 0x40, 0x20, 0x10, 0x48, 0x00, 0x00 },	// U+0795 (ޕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x0e, 0x02, 0x02, 0x1c, 0x00, 0x00 },	// U+0796 (ޖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x30, 0x58, 0x54, 0x22, 0x04, 0x03, 0x00, 0x00 },	// U+0797 (ޗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x50, 0x00, 0x30, 0x58, 0x54, 0x22, 0x04, 0x03, 0x00, 0x00 },	// U+0798 (ޘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x04, 0x12, 0x00, 0x00 },	// U+0799 (ޙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+079A (ޚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x40, 0x20, 0x20, 0x18, 0x04, 0x02, 0x00 },	// U+079B (ޛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x48, 0x30, 0x30, 0x48, 0x04, 0x02, 0x00, 0x00 },	// U+079C (ޜ)
}; // 12

static const unsigned char unifont_block32[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x34, 0x02, 0x24, 0x02, 0x00, 0x00 },	// U+07A0 (ޠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x30, 0x48, 0x34, 0x02, 0x04, 0x02, 0x00, 0x00 },	// U+07A1 (ޡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x28, 0x24, 0x00, 0x08 },	// U+07A2 (ޢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x30, 0x28, 0x24, 0x00, 0x00 },	// U+07A3 (ޣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x20, 0x10, 0x08, 0x10, 0x0c, 0x00, 0x00 },	// U+07A4 (ޤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x28, 0x28, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+07A5 (ޥ)
	{ 0x00, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07A6 (ަ)
	{ 0x00, 0x48, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07A7 (ާ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02 },	// U+07A8 (ި)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x24, 0x12 },	// U+07A9 (ީ)
	{ 0x00, 0x06, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07AA (ު)
	{ 0x00, 0x66, 0x88, 0x44, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07AB (ޫ)
	{ 0x00, 0x08, 0x04, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07AC (ެ)
	{ 0x44, 0x22, 0x11, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07AD (ޭ)
	{ 0x46, 0x28, 0x14, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07AE (ޮ)
	{ 0x38, 0x24, 0x02, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07AF (ޯ)
	{ 0x00, 0x0c, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07B0 (ް)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x08, 0x04, 0x02, 0x02, 0x1c, 0x00, 0x00 },	// U+07B1 (ޱ)
}; // 18

static const unsigned char unifont_block33[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+07C0 (߀)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x28, 0x48, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7e, 0x00, 0x00 },	// U+07C1 (߁)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x7c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+07C2 (߂)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x3c, 0x00, 0x00 },	// U+07C3 (߃)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+07C4 (߄)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+07C5 (߅)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+07C6 (߆)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x00, 0x00 },	// U+07C7 (߇)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x00, 0x00 },	// U+07C8 (߈)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+07C9 (߉)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+07CA (ߊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+07CB (ߋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x41, 0x22, 0x14, 0x14, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+07CC (ߌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x22, 0x00, 0x00 },	// U+07CD (ߍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+07CE (ߎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x00, 0x00 },	// U+07CF (ߏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+07D0 (ߐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00 },	// U+07D1 (ߑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x78, 0x50, 0x48, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+07D2 (ߒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+07D3 (ߓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+07D4 (ߔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00 },	// U+07D5 (ߕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+07D6 (ߖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x14, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+07D7 (ߗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4a, 0x4a, 0x4a, 0x4a, 0x7e, 0x00, 0x00 },	// U+07D8 (ߘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+07D9 (ߙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x7e, 0x24, 0x24, 0x24, 0x24, 0x3c, 0x00, 0x00 },	// U+07DA (ߚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x00, 0x00 },	// U+07DB (ߛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+07DC (ߜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x50, 0x50, 0x30, 0x1e, 0x12, 0x12, 0x12, 0x1e, 0x00, 0x00 },	// U+07DD (ߝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+07DE (ߞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+07DF (ߟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+07E0 (ߠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+07E1 (ߡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x1c, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+07E2 (ߢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x44, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+07E3 (ߣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x3c, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+07E4 (ߤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x20, 0x20, 0x20, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x3c, 0x00, 0x00 },	// U+07E5 (ߥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x1c, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+07E6 (ߦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x1c, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+07E7 (ߧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0e, 0x48, 0x38 },	// U+07E8 (ߨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x2e, 0x58, 0x38 },	// U+07E9 (ߩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10 },	// U+07EA (ߪ)
	{ 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07EB (߫)
	{ 0x48, 0x34, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07EC (߬)
	{ 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07ED (߭)
	{ 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07EE (߮)
	{ 0x10, 0x20, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07EF (߯)
	{ 0x12, 0x2c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07F0 (߰)
	{ 0x08, 0x04, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07F1 (߱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08 },	// U+07F2 (߲)
	{ 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07F3 (߳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07F4 (ߴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+07F5 (ߵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x78, 0x20, 0x10, 0x08, 0x04, 0x7c, 0x00, 0x00 },	// U+07F6 (߶)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x54, 0x44, 0x82, 0xaa, 0x82, 0x54, 0x38, 0x00, 0x00, 0x00 },	// U+07F7 (߷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00 },	// U+07F8 (߸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+07F9 (߹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00 },	// U+07FA (ߺ)
}; // 59

static const unsigned char unifont_block34[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42 },	// U+07FD (߽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4a, 0x4a, 0x4a, 0x7e, 0x08, 0x3e, 0x08 },	// U+07FE (߾)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00 },	// U+07FF (߿)
}; // 3

static const unsigned char unifont_block35[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x44, 0x28, 0x10, 0x00 },	// U+08A0 (ࢠ)
	{ 0x00, 0x00, 0x30, 0x08, 0x30, 0x08, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+08A1 (ࢡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+08A2 (ࢢ)
	{ 0x00, 0x00, 0x00, 0x04, 0x44, 0x14, 0x04, 0x34, 0x4c, 0x44, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08A3 (ࢣ)
	{ 0x00, 0x08, 0x00, 0x14, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+08A4 (ࢤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x38, 0x48, 0x50, 0x64, 0x42, 0x22, 0x1c, 0x00, 0x08 },	// U+08A5 (ࢥ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0xf8, 0x20, 0xf8, 0x20, 0x24, 0x22, 0x22, 0x12, 0x1c, 0x00, 0x00 },	// U+08A6 (ࢦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x38, 0x60, 0x78, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+08A7 (ࢧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x18, 0x04, 0x20, 0x52, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+08A8 (ࢨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x20, 0x52, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+08A9 (ࢩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x2c, 0x12, 0x2c, 0x40 },	// U+08AA (ࢪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x70, 0x44, 0x20, 0x12, 0x0c, 0x00 },	// U+08AB (ࢫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x76, 0x02, 0x52 },	// U+08AC (ࢬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08AD (ࢭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x14, 0x00, 0x08, 0x00 },	// U+08AE (ࢮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x98, 0x72, 0x12, 0x0c, 0x20, 0x04, 0x10 },	// U+08AF (ࢯ)
	{ 0x00, 0x00, 0x10, 0x08, 0x24, 0x12, 0x0a, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08B0 (ࢰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x78, 0x20, 0x20, 0x20, 0x20, 0x00 },	// U+08B1 (ࢱ)
	{ 0x00, 0x00, 0x08, 0x14, 0x22, 0x00, 0x08, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+08B2 (ࢲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x2a, 0x02, 0x12, 0x42, 0x3c },	// U+08B3 (ࢳ)
	{ 0x00, 0x00, 0x00, 0x40, 0x50, 0x48, 0x50, 0x44, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+08B4 (ࢴ)
}; // 21

static const unsigned char unifont_block36[][16] = {
	{ 0x00, 0x00, 0x18, 0x20, 0x38, 0x08, 0x08, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+08B6 (ࢶ)
	{ 0x00, 0x00, 0x18, 0x20, 0x38, 0x08, 0x08, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x24, 0x00, 0x10, 0x00 },	// U+08B7 (ࢷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x44, 0xb9, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08B8 (ࢸ)
	{ 0x00, 0x04, 0x00, 0x10, 0x20, 0x22, 0x12, 0x0c, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+08B9 (ࢹ)
	{ 0x00, 0x04, 0x00, 0x10, 0x20, 0x22, 0x12, 0x0c, 0x20, 0x52, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+08BA (ࢺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x50, 0x60, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08BB (ࢻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08BC (ࢼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+08BD (ࢽ)
	{ 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x28, 0x00, 0x10, 0x00 },	// U+08BE (ࢾ)
	{ 0x00, 0x22, 0x14, 0x08, 0x00, 0x28, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08BF (ࢿ)
	{ 0x44, 0x28, 0x12, 0x02, 0x0a, 0x16, 0x0f, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08C0 (ࣀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x7e, 0x04, 0x02, 0x2a, 0x02, 0x12, 0x44, 0x38 },	// U+08C1 (ࣁ)
	{ 0x00, 0x11, 0x0a, 0x24, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08C2 (ࣂ)
	{ 0x00, 0x08, 0x00, 0x24, 0x00, 0x10, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+08C3 (ࣃ)
	{ 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x00, 0x38, 0x48, 0x50, 0x64, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+08C4 (ࣄ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+08C5 (ࣅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x12, 0x02, 0x2a, 0x02, 0x12, 0x44, 0x38 },	// U+08C6 (ࣆ)
	{ 0x02, 0x02, 0x0a, 0x56, 0x4f, 0x40, 0x40, 0x40, 0x40, 0x44, 0x42, 0x42, 0x22, 0x3c, 0x00, 0x00 },	// U+08C7 (ࣇ)
}; // 18

static const unsigned char unifont_block37[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x70, 0x40, 0x38 },	// U+08D3 (࣓)
	{ 0x84, 0xd6, 0xe1, 0xe5, 0xc1, 0xc9, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08D4 (ࣔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x98, 0x72, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08D5 (ࣕ)
	{ 0x00, 0x08, 0x14, 0x04, 0x18, 0x04, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08D6 (ࣖ)
	{ 0x00, 0x24, 0x00, 0x30, 0x50, 0x62, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08D7 (ࣗ)
	{ 0x00, 0x04, 0x00, 0x10, 0x24, 0x12, 0x4c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08D8 (ࣘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x10, 0x24, 0x92, 0x4c },	// U+08D9 (ࣙ)
}; // 7

static const unsigned char unifont_block38[][16] = {
	{ 0x00, 0x04, 0x4a, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08E0 (࣠)
	{ 0x00, 0x40, 0xa0, 0xa8, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08E1 (࣡)
	{ 0x10, 0x28, 0x44, 0x44, 0x82, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08E2 (࣢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x32, 0x0c, 0x12, 0x0c },	// U+08E3 (ࣣ)
	{ 0x00, 0x20, 0x40, 0x30, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08E4 (ࣤ)
	{ 0x30, 0x70, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08E5 (ࣥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x30, 0x08, 0x10 },	// U+08E6 (ࣦ)
	{ 0x00, 0x44, 0x88, 0x66, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08E7 (ࣧ)
	{ 0x38, 0x44, 0x44, 0xaa, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08E8 (ࣨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x88, 0x66, 0x11, 0x22 },	// U+08E9 (ࣩ)
	{ 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08EA (࣪)
	{ 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08EB (࣫)
	{ 0x00, 0x58, 0x24, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08EC (࣬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08 },	// U+08ED (࣭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x02 },	// U+08EE (࣮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x12, 0x2c },	// U+08EF (࣯)
	{ 0x60, 0x18, 0x00, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08F0 (ࣰ)
	{ 0x66, 0xee, 0x44, 0x22, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08F1 (ࣱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x18, 0x00, 0x18, 0x06 },	// U+08F2 (ࣲ)
	{ 0x00, 0x20, 0x50, 0x70, 0x40, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08F3 (ࣳ)
	{ 0x00, 0x2c, 0x12, 0x2a, 0x24, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08F4 (ࣴ)
	{ 0x04, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08F5 (ࣵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x20 },	// U+08F6 (ࣶ)
	{ 0x04, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08F7 (ࣷ)
	{ 0x08, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08F8 (ࣸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x08 },	// U+08F9 (ࣹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x08 },	// U+08FA (ࣺ)
	{ 0x12, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08FB (ࣻ)
	{ 0x24, 0x49, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08FC (ࣼ)
	{ 0x10, 0x24, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08FD (ࣽ)
	{ 0x30, 0x74, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08FE (ࣾ)
	{ 0x00, 0x38, 0x40, 0x40, 0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+08FF (ࣿ)
}; // 32

static const unsigned char unifont_block39[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x46, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+0E01 (ก)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x26, 0x24, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+0E02 (ข)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x4e, 0x48, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+0E03 (ฃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x5a, 0x5e, 0x46, 0x42, 0x42, 0x00, 0x00 },	// U+0E04 (ค)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x52, 0x42, 0x5a, 0x5e, 0x46, 0x42, 0x42, 0x00, 0x00 },	// U+0E05 (ฅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x4e, 0x48, 0x44, 0x44, 0x44, 0x4e, 0x36, 0x00, 0x00 },	// U+0E06 (ฆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x20, 0x20, 0x22, 0x24, 0x28, 0x30, 0x00, 0x00 },	// U+0E07 (ง)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x58, 0x58, 0x50, 0x50, 0x30, 0x00, 0x00 },	// U+0E08 (จ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x26, 0x26, 0x24, 0x74, 0x6c, 0x00, 0x00 },	// U+0E09 (ฉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x4c, 0x2c, 0x48, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+0E0A (ช)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x4a, 0x2e, 0x48, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+0E0B (ซ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xa2, 0xa4, 0xa2, 0xa2, 0xa2, 0xf6, 0xb6, 0x00, 0x00 },	// U+0E0C (ฌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x54, 0x52, 0x52, 0x52, 0x76, 0x46, 0x70, 0x00 },	// U+0E0D (ญ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x46, 0x44, 0x44, 0x44, 0x66, 0x5e, 0x68, 0x00 },	// U+0E0E (ฎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x46, 0x44, 0x44, 0x44, 0x56, 0x76, 0x58, 0x00 },	// U+0E0F (ฏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x38, 0x40, 0x58, 0x58, 0x60, 0x40, 0x54, 0x68 },	// U+0E10 (ฐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x5e, 0x48, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+0E11 (ฑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xaa, 0xa2, 0xae, 0xae, 0xaa, 0xf6, 0xb2, 0x00, 0x00 },	// U+0E12 (ฒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x54, 0x52, 0x52, 0x52, 0xf6, 0xd6, 0x00, 0x00 },	// U+0E13 (ณ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x5a, 0x5a, 0x52, 0x4e, 0x42, 0x00, 0x00 },	// U+0E14 (ด)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x52, 0x42, 0x5a, 0x5a, 0x52, 0x4e, 0x42, 0x00, 0x00 },	// U+0E15 (ต)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x46, 0x44, 0x44, 0x44, 0x4c, 0x4c, 0x00, 0x00 },	// U+0E16 (ถ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x56, 0x4c, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+0E17 (ท)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1e, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0E18 (ธ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x26, 0x24, 0x22, 0x22, 0x22, 0x72, 0x6c, 0x00, 0x00 },	// U+0E19 (น)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x4c, 0x48, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+0E1A (บ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x4c, 0x4c, 0x48, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+0E1B (ป)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0x96, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+0E1C (ผ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x96, 0x96, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+0E1D (ฝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0x96, 0x94, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+0E1E (พ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x96, 0x96, 0x94, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+0E1F (ฟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x46, 0x44, 0x44, 0x44, 0x46, 0x46, 0x00, 0x00 },	// U+0E20 (ภ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x46, 0x44, 0x44, 0x44, 0x44, 0x4e, 0x36, 0x00, 0x00 },	// U+0E21 (ม)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x46, 0x42, 0x4c, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0E22 (ย)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1e, 0x20, 0x20, 0x20, 0x30, 0x30, 0x00, 0x00 },	// U+0E23 (ร)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x46, 0x44, 0x44, 0x44, 0x4c, 0x4c, 0x40, 0x00 },	// U+0E24 (ฤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x58, 0x64, 0x44, 0x4c, 0x4c, 0x00, 0x00 },	// U+0E25 (ล)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x46, 0x44, 0x44, 0x44, 0x46, 0x46, 0x40, 0x00 },	// U+0E26 (ฦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x20, 0x20, 0x30, 0x30, 0x00, 0x00 },	// U+0E27 (ว)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x3c, 0x42, 0x5a, 0x5e, 0x46, 0x42, 0x42, 0x00, 0x00 },	// U+0E28 (ศ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x46, 0x44, 0x54, 0xf4, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+0E29 (ษ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3c, 0x42, 0x40, 0x58, 0x64, 0x44, 0x4c, 0x4c, 0x00, 0x00 },	// U+0E2A (ส)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x24, 0x54, 0x4c, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+0E2B (ห)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x56, 0x96, 0x94, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+0E2C (ฬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x46, 0x46, 0x42, 0x42, 0x7e, 0x00, 0x00 },	// U+0E2D (อ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3c, 0x5e, 0x40, 0x46, 0x46, 0x42, 0x42, 0x7e, 0x00, 0x00 },	// U+0E2E (ฮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x2e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+0E2F (ฯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x1c, 0x00, 0x2c, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+0E30 (ะ)
	{ 0x00, 0x00, 0x00, 0x8c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E31 (ั)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+0E32 (า)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x38, 0x44, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+0E33 (ำ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E34 (ิ)
	{ 0x00, 0x00, 0x00, 0x5c, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E35 (ี)
	{ 0x00, 0x00, 0x00, 0x7c, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E36 (ึ)
	{ 0x00, 0x00, 0x00, 0x5c, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E37 (ื)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x40 },	// U+0E38 (ุ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x70 },	// U+0E39 (ู)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30 },	// U+0E3A (ฺ)
}; // 58

static const unsigned char unifont_block40[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x3e, 0x54, 0x54, 0x54, 0x3c, 0x54, 0x54, 0x54, 0x3e, 0x10, 0x00 },	// U+0E3F (฿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x18, 0x00, 0x00 },	// U+0E40 (เ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x6c, 0x6c, 0x00, 0x00 },	// U+0E41 (แ)
	{ 0x00, 0x00, 0x00, 0x7c, 0x82, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x00, 0x00 },	// U+0E42 (โ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x2a, 0x2c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x00, 0x00 },	// U+0E43 (ใ)
	{ 0x00, 0x00, 0x00, 0x36, 0x28, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x00, 0x00 },	// U+0E44 (ไ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },	// U+0E45 (ๅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x4e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x20, 0x10 },	// U+0E46 (ๆ)
	{ 0x40, 0x3c, 0x02, 0x2a, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E47 (็)
	{ 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E48 (่)
	{ 0x18, 0x90, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E49 (้)
	{ 0x14, 0xaa, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E4A (๊)
	{ 0x20, 0x70, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E4B (๋)
	{ 0x80, 0x70, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E4C (์)
	{ 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E4D (ํ)
	{ 0xc0, 0x20, 0x60, 0x10, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0E4E (๎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x5a, 0x5a, 0x42, 0x3c, 0x00, 0x00 },	// U+0E4F (๏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0E50 (๐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x5a, 0x5c, 0x40, 0x3c, 0x00, 0x00 },	// U+0E51 (๑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x52, 0x6a, 0x4a, 0x5a, 0x5a, 0x42, 0x3c, 0x00, 0x00 },	// U+0E52 (๒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x52, 0x52, 0x52, 0x42, 0x4e, 0x4e, 0x00, 0x00 },	// U+0E53 (๓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x32, 0x32, 0x12, 0x7c, 0x00, 0x00 },	// U+0E54 (๔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x68, 0x3c, 0x02, 0x02, 0x32, 0x32, 0x12, 0x7c, 0x00, 0x00 },	// U+0E55 (๕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x34, 0x48, 0x40, 0x40, 0x4c, 0x4c, 0x3c, 0x00, 0x00 },	// U+0E56 (๖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x54, 0x5a, 0x52, 0x52, 0x52, 0x56, 0x36, 0x00, 0x00 },	// U+0E57 (๗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3c, 0x02, 0x02, 0x62, 0x6a, 0x4a, 0x76, 0x00, 0x00 },	// U+0E58 (๘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x58, 0x2c, 0x0a, 0x12, 0x12, 0x26, 0x26, 0x00, 0x00 },	// U+0E59 (๙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xae, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0x00, 0x00 },	// U+0E5A (๚)
}; // 28

static const unsigned char unifont_block41[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x46, 0x00, 0x00 },	// U+0E81 (ກ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x20, 0x18, 0x04, 0x32, 0x4a, 0x44, 0x00, 0x00 },	// U+0E82 (ຂ)
}; // 2

static const unsigned char unifont_block42[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x4c, 0x42, 0x42, 0x42, 0x4c, 0x00, 0x00 },	// U+0E84 (ຄ)
}; // 1

static const unsigned char unifont_block43[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x55, 0x51, 0x48, 0x44, 0x52, 0x52, 0x2c, 0x00, 0x00 },	// U+0E86 (ຆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x34, 0x28, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1c },	// U+0E87 (ງ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x58, 0x64, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+0E88 (ຈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x46, 0x44, 0x44, 0x44, 0x3a, 0x00, 0x00 },	// U+0E89 (ຉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x26, 0x10, 0x08, 0x04, 0x32, 0x4e, 0x40, 0x40 },	// U+0E8A (ຊ)
}; // 5

static const unsigned char unifont_block44[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x52, 0x46, 0x20, 0x18, 0x04, 0x32, 0x4e, 0x40, 0x40 },	// U+0E8C (ຌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x42, 0x42, 0x4c, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0E8D (ຍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x49, 0x49, 0x4a, 0x49, 0x49, 0x49, 0x3a, 0x00, 0x00 },	// U+0E8E (ຎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x42, 0x42, 0x4c, 0x42, 0x42, 0x5a, 0x24, 0x00, 0x00 },	// U+0E8F (ຏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4a, 0x44, 0x40, 0x40 },	// U+0E90 (ຐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x57, 0x55, 0x54, 0x52, 0x52, 0x52, 0x4c, 0x00, 0x00 },	// U+0E91 (ຑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x55, 0x55, 0x51, 0x51, 0x51, 0x51, 0x2a, 0x00, 0x00 },	// U+0E92 (ຒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x54, 0x00, 0x00 },	// U+0E93 (ຓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x4a, 0x44, 0x00, 0x00 },	// U+0E94 (ດ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x00, 0x00 },	// U+0E95 (ຕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4c, 0x40, 0x40 },	// U+0E96 (ຖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x44, 0x00, 0x00 },	// U+0E97 (ທ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x3e, 0x40, 0x46, 0x42, 0x5a, 0x24, 0x00, 0x00 },	// U+0E98 (ຘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x4a, 0x44, 0x44, 0x44, 0x44, 0x44, 0x3a, 0x00, 0x00 },	// U+0E99 (ນ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x4a, 0x44, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0E9A (ບ)
	{ 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x44, 0x4a, 0x44, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0E9B (ປ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x66, 0x61, 0x41, 0x41, 0x41, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+0E9C (ຜ)
	{ 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x46, 0x41, 0x41, 0x41, 0x41, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+0E9D (ຝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x45, 0x42, 0x41, 0x41, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+0E9E (ພ)
	{ 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x42, 0x45, 0x42, 0x41, 0x41, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+0E9F (ຟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x4a, 0x48, 0x48, 0x48, 0x48, 0x4c, 0x00, 0x00 },	// U+0EA0 (ຠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x3a, 0x00, 0x00 },	// U+0EA1 (ມ)
	{ 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x4c, 0x42, 0x42, 0x44, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0EA2 (ຢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x40, 0x46, 0x42, 0x3c, 0x00, 0x00 },	// U+0EA3 (ຣ)
}; // 24

static const unsigned char unifont_block45[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x4c, 0x52, 0x24, 0x00, 0x00 },	// U+0EA5 (ລ)
}; // 1

static const unsigned char unifont_block46[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0EA7 (ວ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xaa, 0x7a, 0x22, 0x2c, 0x22, 0x22, 0x2c, 0x00, 0x00 },	// U+0EA8 (ຨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x2a, 0x24, 0x22, 0xaa, 0x7a, 0x22, 0x1c, 0x00, 0x00 },	// U+0EA9 (ຩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x22, 0x62, 0x5e, 0x40, 0x4c, 0x52, 0x22, 0x00, 0x00 },	// U+0EAA (ສ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x8c, 0x00, 0x00 },	// U+0EAB (ຫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x02, 0x3c, 0x42, 0x42, 0x4a, 0x2c, 0x00, 0x00 },	// U+0EAC (ຬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x22, 0x1c, 0x00, 0x00 },	// U+0EAD (ອ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x02, 0x3c, 0x40, 0x46, 0x42, 0x3c, 0x00, 0x00 },	// U+0EAE (ຮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x64, 0x58, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08 },	// U+0EAF (ຯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x4a, 0x3c, 0x00, 0x44, 0x4a, 0x3c, 0x00, 0x00, 0x00 },	// U+0EB0 (ະ)
	{ 0x00, 0x00, 0x00, 0x46, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0EB1 (ັ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x28, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+0EB2 (າ)
	{ 0x00, 0x00, 0x02, 0x05, 0x02, 0x00, 0x30, 0x48, 0x50, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+0EB3 (ຳ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0EB4 (ິ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0EB5 (ີ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0EB6 (ຶ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0EB7 (ື)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10 },	// U+0EB8 (ຸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x30 },	// U+0EB9 (ູ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08 },	// U+0EBA (຺)
	{ 0x00, 0x00, 0x00, 0x3e, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0EBB (ົ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32 },	// U+0EBC (ຼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x24, 0x18, 0x20, 0x20, 0x20, 0x20, 0x26, 0x22, 0x1c },	// U+0EBD (ຽ)
}; // 23

static const unsigned char unifont_block47[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x18, 0x00, 0x00 },	// U+0EC0 (ເ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x11, 0x11, 0x11, 0x11, 0x11, 0x33, 0x33, 0x00, 0x00 },	// U+0EC1 (ແ)
	{ 0x00, 0x00, 0x0c, 0x32, 0x44, 0x18, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x00, 0x00 },	// U+0EC2 (ໂ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x2a, 0x2c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x00, 0x00 },	// U+0EC3 (ໃ)
	{ 0x00, 0x00, 0x01, 0x32, 0x2c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x00, 0x00 },	// U+0EC4 (ໄ)
}; // 5

static const unsigned char unifont_block48[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x4a, 0x4a, 0x44, 0x40, 0x40, 0x40, 0x40, 0x20, 0x10 },	// U+0EC6 (ໆ)
}; // 1

static const unsigned char unifont_block49[][16] = {
	{ 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0EC8 (່)
	{ 0x4c, 0x28, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0EC9 (້)
	{ 0x94, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0ECA (໊)
	{ 0x10, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0ECB (໋)
	{ 0x40, 0x38, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0ECC (໌)
	{ 0x00, 0x00, 0x10, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0ECD (ໍ)
}; // 6

static const unsigned char unifont_block50[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+0ED0 (໐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x5a, 0x5c, 0x40, 0x20, 0x1c, 0x00, 0x00 },	// U+0ED1 (໑)
	{ 0x00, 0x00, 0x20, 0x20, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x02, 0x62, 0x42, 0x3c, 0x00, 0x00 },	// U+0ED2 (໒)
	{ 0x00, 0x00, 0x08, 0x14, 0x28, 0x50, 0x22, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x3a, 0x00, 0x00 },	// U+0ED3 (໓)
	{ 0x00, 0x00, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x32, 0x32, 0x12, 0x7c, 0x00, 0x00 },	// U+0ED4 (໔)
	{ 0x00, 0x00, 0x40, 0x50, 0x28, 0x10, 0x08, 0x04, 0x02, 0x02, 0x32, 0x32, 0x12, 0x7c, 0x00, 0x00 },	// U+0ED5 (໕)
	{ 0x00, 0x00, 0x08, 0x14, 0x28, 0x50, 0x24, 0x42, 0x42, 0x42, 0x4a, 0x4a, 0x4a, 0x34, 0x00, 0x00 },	// U+0ED6 (໖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x46, 0x40, 0x40 },	// U+0ED7 (໗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4a, 0x4a, 0x42, 0x42, 0x64, 0x50, 0x28, 0x34, 0x0c },	// U+0ED8 (໘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x24, 0x00, 0x00 },	// U+0ED9 (໙)
}; // 10

static const unsigned char unifont_block51[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x64, 0x00, 0x00 },	// U+0EDC (ໜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 0x74, 0x00, 0x00 },	// U+0EDD (ໝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x22, 0x22, 0x22, 0xaa, 0x7a, 0x22, 0x23, 0x00, 0x00 },	// U+0EDE (ໞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x21, 0x21, 0x26, 0xa9, 0x79, 0x21, 0x1e, 0x00, 0x00 },	// U+0EDF (ໟ)
}; // 4

static const unsigned char unifont_block52[][16] = {
	{ 0x18, 0xe6, 0x38, 0xba, 0x92, 0xaa, 0xca, 0xd2, 0x9c, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F00 (ༀ)
	{ 0x00, 0x00, 0x00, 0x3a, 0x12, 0x2a, 0x4a, 0x52, 0x9c, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F01 (༁)
}; // 2

static const unsigned char unifont_block53[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x83, 0x8c, 0x72, 0x8c, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F04 (༄)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x46, 0x38, 0x46, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F05 (༅)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x83, 0x8c, 0x72, 0x8c, 0x70, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20 },	// U+0F06 (༆)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0xa8, 0x23, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F07 (༇)
	{ 0x00, 0x00, 0x4c, 0x32, 0x00, 0x36, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0F08 (༈)
	{ 0x00, 0x00, 0x00, 0x78, 0x84, 0x80, 0x40, 0x70, 0x88, 0x70, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+0F09 (༉)
	{ 0x00, 0xf0, 0x0c, 0x72, 0x8a, 0x82, 0x42, 0x72, 0x8a, 0x72, 0x8a, 0x02, 0x8c, 0xf0, 0x00, 0x00 },	// U+0F0A (༊)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F0B (་)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F0C (༌)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0F0D (།)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x00, 0x00 },	// U+0F0E (༎)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0F0F (༏)
	{ 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0F10 (༐)
	{ 0x00, 0x00, 0x00, 0x66, 0x00, 0x18, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0F11 (༑)
	{ 0x10, 0x28, 0x92, 0x7c, 0x00, 0xee, 0x00, 0x58, 0x34, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+0F12 (༒)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0xa5, 0xa5, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0F13 (༓)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x3c, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0F14 (༔)
	{ 0x00, 0xff, 0xe7, 0x81, 0xa5, 0x81, 0xff, 0x8d, 0xb1, 0xc7, 0xc8, 0x90, 0xa0, 0xc0, 0xc0, 0x80 },	// U+0F15 (༕)
}; // 18

static const unsigned char unifont_block54[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+0F19 (༙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F1A (༚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xaa, 0xaa, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F1B (༛)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x10, 0x44, 0xaa, 0xaa, 0x44, 0x00, 0x00, 0x00, 0x00 },	// U+0F1C (༜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F1D (༝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x44, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F1E (༞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0x4a, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F1F (༟)
	{ 0x00, 0x00, 0x00, 0x70, 0x88, 0x84, 0x84, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F20 (༠)
	{ 0x00, 0x00, 0x00, 0x60, 0xd0, 0x88, 0x80, 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F21 (༡)
	{ 0x00, 0x00, 0x00, 0x78, 0x84, 0x80, 0x40, 0x70, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F22 (༢)
	{ 0x00, 0x00, 0x00, 0x78, 0x84, 0x40, 0x70, 0x80, 0x40, 0x78, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F23 (༣)
	{ 0x00, 0x00, 0x00, 0x00, 0x48, 0x34, 0x02, 0x82, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F24 (༤)
	{ 0x00, 0x00, 0x00, 0x44, 0x22, 0x22, 0x3c, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F25 (༥)
	{ 0x00, 0x00, 0x00, 0x02, 0x22, 0x14, 0xe4, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F26 (༦)
	{ 0x00, 0x00, 0x00, 0x80, 0x80, 0x8c, 0x52, 0x48, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F27 (༧)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x0e, 0x10, 0x20, 0x40, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+0F28 (༨)
	{ 0x00, 0x00, 0x00, 0x38, 0x44, 0x24, 0x92, 0x72, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F29 (༩)
	{ 0x00, 0x00, 0x00, 0x30, 0x68, 0x44, 0xf0, 0x2e, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F2A (༪)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0xf0, 0x2e, 0x38, 0x44, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F2B (༫)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x20, 0xf8, 0x4e, 0x20, 0x3c, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F2C (༬)
	{ 0x00, 0x00, 0x00, 0x00, 0x48, 0x34, 0x62, 0x92, 0x7e, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F2D (༭)
	{ 0x00, 0x00, 0x00, 0x44, 0x72, 0xaa, 0x3c, 0x22, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F2E (༮)
	{ 0x00, 0x00, 0x00, 0x02, 0xa2, 0x54, 0xe4, 0x98, 0x88, 0x74, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F2F (༯)
	{ 0x00, 0x00, 0x00, 0x80, 0x80, 0x8c, 0xf2, 0x4e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F30 (༰)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x4e, 0xb0, 0x2c, 0x42, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+0F31 (༱)
	{ 0x00, 0x00, 0xc0, 0xb8, 0x54, 0x2c, 0x96, 0x72, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F32 (༲)
	{ 0x00, 0x00, 0x00, 0xb8, 0x44, 0x62, 0x52, 0x2a, 0x1c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F33 (༳)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x08, 0x38, 0x20, 0x08, 0x38, 0x20, 0x00, 0x00, 0x00 },	// U+0F34 (༴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xaa, 0x54, 0x38 },	// U+0F35 (༵)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x66, 0x66, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0F36 (༶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18 },	// U+0F37 (༷)
	{ 0xcc, 0x52, 0x4a, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F38 (༸)
	{ 0xe0, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F39 (༹)
}; // 33

static const unsigned char unifont_block55[][16] = {
	{ 0x00, 0x00, 0x40, 0x40, 0x20, 0x10, 0x10, 0x18, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x00 },	// U+0F3C (༼)
	{ 0x00, 0x00, 0x04, 0x04, 0x08, 0x10, 0x10, 0x30, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00 },	// U+0F3D (༽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80 },	// U+0F3E (༾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01 },	// U+0F3F (༿)
	{ 0x00, 0x00, 0x00, 0xfc, 0xa8, 0xa6, 0xa0, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F40 (ཀ)
	{ 0x00, 0x00, 0x00, 0xfc, 0x92, 0xb2, 0xd2, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F41 (ཁ)
	{ 0x00, 0x00, 0x00, 0xfc, 0x92, 0x96, 0x9a, 0x90, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F42 (ག)
	{ 0x00, 0x00, 0x00, 0xfc, 0x92, 0x96, 0x9a, 0x90, 0xf8, 0x04, 0x72, 0x8c, 0x88, 0x80, 0x00, 0x00 },	// U+0F43 (གྷ)
	{ 0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x1e, 0x22, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F44 (ང)
	{ 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x72, 0x8c, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F45 (ཅ)
	{ 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x7c, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F46 (ཆ)
	{ 0x00, 0x00, 0x00, 0x78, 0x04, 0x3c, 0x02, 0x3e, 0x42, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F47 (ཇ)
}; // 12

static const unsigned char unifont_block56[][16] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x72, 0x88, 0x88, 0x80, 0x80, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F49 (ཉ)
	{ 0x00, 0x00, 0x00, 0xfe, 0x80, 0xbc, 0xc2, 0x82, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F4A (ཊ)
	{ 0x00, 0x00, 0x00, 0xfc, 0x84, 0x5c, 0x34, 0x44, 0xf4, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F4B (ཋ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x40, 0x80, 0xf8, 0x84, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F4C (ཌ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x40, 0x80, 0xf8, 0x04, 0x7a, 0x06, 0x72, 0x8c, 0x88, 0x80, 0x00, 0x00 },	// U+0F4D (ཌྷ)
	{ 0x00, 0x00, 0x00, 0xfc, 0x10, 0x38, 0x48, 0x4c, 0x34, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F4E (ཎ)
	{ 0x00, 0x00, 0x00, 0xfe, 0x02, 0x7a, 0x86, 0x82, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F4F (ཏ)
	{ 0x00, 0x00, 0x00, 0xfc, 0x84, 0xe8, 0xb0, 0x88, 0xbc, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F50 (ཐ)
	{ 0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x3e, 0x42, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F51 (ད)
	{ 0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x3e, 0x42, 0xf8, 0x04, 0x72, 0x8c, 0x88, 0x80, 0x00, 0x00 },	// U+0F52 (དྷ)
	{ 0x00, 0x00, 0x00, 0xfc, 0x20, 0x70, 0x48, 0xc8, 0xb0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F53 (ན)
	{ 0x00, 0x00, 0x00, 0xcc, 0x84, 0x82, 0xbe, 0xc2, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F54 (པ)
	{ 0x00, 0x00, 0x00, 0xcc, 0xc4, 0xa2, 0xbe, 0xc2, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F55 (ཕ)
	{ 0x00, 0x00, 0x00, 0xf8, 0x84, 0x82, 0xbe, 0xc2, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F56 (བ)
	{ 0x00, 0x00, 0x00, 0xf8, 0x84, 0x82, 0xbe, 0xc2, 0xf8, 0x04, 0x72, 0x8c, 0x88, 0x80, 0x00, 0x00 },	// U+0F57 (བྷ)
	{ 0x00, 0x00, 0x00, 0xbe, 0x90, 0x8c, 0xb2, 0xd2, 0x8c, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F58 (མ)
	{ 0x00, 0x80, 0x80, 0x7c, 0x10, 0x10, 0x72, 0x8c, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F59 (ཙ)
	{ 0x00, 0x80, 0x80, 0x7c, 0x10, 0x10, 0x7c, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F5A (ཚ)
	{ 0x00, 0x80, 0x80, 0x78, 0x04, 0x1c, 0x02, 0x3e, 0x42, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F5B (ཛ)
	{ 0x00, 0x80, 0x80, 0x78, 0x04, 0x1c, 0x02, 0x3e, 0x42, 0xf8, 0x04, 0x72, 0x8c, 0x88, 0x80, 0x00 },	// U+0F5C (ཛྷ)
	{ 0x00, 0x00, 0x00, 0x8c, 0x92, 0xf2, 0x90, 0x88, 0xb8, 0xc8, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F5D (ཝ)
	{ 0x00, 0x00, 0x00, 0x38, 0x44, 0x32, 0x4a, 0xca, 0xb2, 0x84, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F5E (ཞ)
	{ 0x00, 0x00, 0x00, 0xfc, 0x80, 0xf8, 0x80, 0xbc, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F5F (ཟ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x12, 0x38, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F60 (འ)
	{ 0x00, 0x00, 0x00, 0xd6, 0x92, 0x92, 0x92, 0xac, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F61 (ཡ)
	{ 0x00, 0x00, 0x00, 0x7c, 0x10, 0x38, 0x40, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F62 (ར)
	{ 0x00, 0x00, 0x00, 0x9c, 0xa2, 0x92, 0xb0, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F63 (ལ)
	{ 0x00, 0x00, 0x00, 0xf0, 0x88, 0x88, 0xf2, 0x8c, 0x88, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F64 (ཤ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x44, 0x44, 0xbc, 0xc4, 0x44, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F65 (ཥ)
	{ 0x00, 0x00, 0x00, 0xde, 0x88, 0x94, 0xa6, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F66 (ས)
	{ 0x00, 0x00, 0x00, 0x78, 0x04, 0x72, 0x8c, 0x88, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F67 (ཧ)
	{ 0x00, 0x00, 0x00, 0xba, 0x92, 0xaa, 0xca, 0xd2, 0x8c, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F68 (ཨ)
	{ 0x00, 0x00, 0x00, 0xfc, 0xa8, 0xa6, 0xa0, 0x80, 0x9c, 0xa4, 0x24, 0xbc, 0x44, 0x24, 0x04, 0x00 },	// U+0F69 (ཀྵ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x10, 0x1c, 0x22, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F6A (ཪ)
	{ 0x00, 0x00, 0x00, 0x7e, 0x2a, 0xca, 0x0a, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F6B (ཫ)
	{ 0x00, 0x00, 0x00, 0xf8, 0x10, 0x70, 0x88, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F6C (ཬ)
}; // 36

static const unsigned char unifont_block57[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x14, 0x20, 0x00, 0x00, 0x00 },	// U+0F71 (ཱ)
	{ 0x0e, 0x12, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F72 (ི)
	{ 0x0e, 0x12, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x42, 0x42, 0x20, 0x38, 0x44, 0x40 },	// U+0F73 (ཱི)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x24, 0x38 },	// U+0F74 (ུ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x20, 0x30, 0x42, 0x44, 0x38 },	// U+0F75 (ཱུ)
	{ 0x0e, 0x12, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x50, 0x60, 0x40, 0x00, 0x00, 0x00 },	// U+0F76 (ྲྀ)
	{ 0x0e, 0x12, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40, 0x5e, 0x60, 0xfc, 0x42, 0x20, 0x38, 0x44, 0x00 },	// U+0F77 (ཷ)
	{ 0x0e, 0x12, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x4a, 0x7a, 0x40 },	// U+0F78 (ླྀ)
	{ 0x0e, 0x12, 0x20, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x7a, 0x40, 0xfc, 0x42, 0x20, 0x38, 0x44, 0x00 },	// U+0F79 (ཹ)
	{ 0x07, 0x18, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F7A (ེ)
	{ 0x33, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F7B (ཻ)
	{ 0xf3, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F7C (ོ)
	{ 0xa2, 0x77, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F7D (ཽ)
	{ 0x08, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F7E (ཾ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0F7F (ཿ)
	{ 0x38, 0x24, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F80 (ྀ)
	{ 0x38, 0x24, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x42, 0x42, 0x20, 0x38, 0x44, 0x40 },	// U+0F81 (ཱྀ)
	{ 0x10, 0x10, 0x30, 0x44, 0xba, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F82 (ྂ)
	{ 0x10, 0x28, 0x92, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F83 (ྃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x60, 0x40, 0xc0, 0x80, 0x80, 0x80 },	// U+0F84 (྄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x10, 0x38, 0x48, 0x48, 0x50, 0x40, 0x40, 0x80 },	// U+0F85 (྅)
	{ 0x08, 0x08, 0x08, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F86 (྆)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F87 (྇)
}; // 23

static const unsigned char unifont_block58[][16] = {
	{ 0x00, 0x6c, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F89 (ྉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x55, 0x55, 0x55, 0x5d, 0x00, 0x00, 0x00 },	// U+0F8A (ྊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x5c, 0x52, 0x52, 0x74, 0x00, 0x00 },	// U+0F8B (ྋ)
	{ 0x00, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F8C (ྌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x28, 0x10, 0x28, 0x44, 0xfe },	// U+0F8D (ྍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x00 },	// U+0F8E (ྎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x6c, 0x00 },	// U+0F8F (ྏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xa8, 0xa4, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F90 (ྐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x92, 0xb2, 0xd2, 0x82, 0x00, 0x00, 0x00 },	// U+0F91 (ྑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x92, 0x9e, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0F92 (ྒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x92, 0x9e, 0x80, 0x78, 0x04, 0x72, 0x8c, 0x88 },	// U+0F93 (ྒྷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x3e, 0x42, 0x80, 0x00, 0x00, 0x00 },	// U+0F94 (ྔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x72, 0x8c, 0x70, 0x00, 0x00, 0x00 },	// U+0F95 (ྕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x7c, 0x92, 0x6c, 0x00, 0x00, 0x00 },	// U+0F96 (ྖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x1c, 0x02, 0x7e, 0x82, 0x00, 0x00 },	// U+0F97 (ྗ)
}; // 15

static const unsigned char unifont_block59[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x70, 0x88, 0x80, 0x40, 0x00, 0x00 },	// U+0F99 (ྙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0xbc, 0xc2, 0x82, 0x02, 0x00, 0x00 },	// U+0F9A (ྚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x22, 0x1e, 0x22, 0x7e, 0x02, 0x00, 0x00 },	// U+0F9B (ྛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x40, 0xf8, 0x84, 0x02, 0x02, 0x00, 0x00 },	// U+0F9C (ྜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x40, 0xf8, 0x04, 0x7e, 0x8a, 0x80, 0x00 },	// U+0F9D (ྜྷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x10, 0x38, 0x4c, 0x32, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+0F9E (ྞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x7a, 0x86, 0x82, 0x80, 0x00, 0x00 },	// U+0F9F (ྟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x88, 0xf0, 0x88, 0xfc, 0x80, 0x00, 0x00 },	// U+0FA0 (ྠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x3e, 0x42, 0x80, 0x80, 0x00, 0x00 },	// U+0FA1 (ྡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x3e, 0x42, 0xf8, 0x04, 0x72, 0x8c },	// U+0FA2 (ྡྷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x10, 0x38, 0x64, 0x98, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+0FA3 (ྣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x84, 0xbe, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+0FA4 (ྤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0x92, 0xbe, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+0FA5 (ྥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x84, 0xbe, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+0FA6 (ྦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x84, 0xbe, 0xc0, 0xf8, 0x04, 0x72, 0x8c, 0x88 },	// U+0FA7 (ྦྷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0x8c, 0xb2, 0xcc, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+0FA8 (ྨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x50, 0x90, 0x32, 0x4c, 0x48, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+0FA9 (ྩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x90, 0x7c, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+0FAA (ྪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x9c, 0x82, 0x3e, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0FAB (ྫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x9c, 0x82, 0x3e, 0x42, 0x78, 0x04, 0x72, 0x8c, 0x88 },	// U+0FAC (ྫྷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xa0, 0xc0 },	// U+0FAD (ྭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x32, 0xca, 0xb2, 0x84, 0x80, 0x00 },	// U+0FAE (ྮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x80, 0xf8, 0x80, 0xfc, 0x80, 0x00, 0x00 },	// U+0FAF (ྯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x12, 0x38, 0x40, 0x80, 0x00, 0x00 },	// U+0FB0 (ྰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x48, 0x38, 0x90, 0x60, 0x00 },	// U+0FB1 (ྱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x9c, 0xa2, 0xc0, 0x80, 0x00 },	// U+0FB2 (ྲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xa2, 0x92, 0xb8, 0xc0, 0x80, 0x00, 0x00 },	// U+0FB3 (ླ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x90, 0xf4, 0x88, 0x90, 0x80, 0x80, 0x00 },	// U+0FB4 (ྴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x24, 0xbc, 0x44, 0x24, 0x04, 0x04, 0x00 },	// U+0FB5 (ྵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0x94, 0xa2, 0xc6, 0x80, 0x00, 0x00, 0x00 },	// U+0FB6 (ྶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x72, 0x8c, 0x88, 0x80, 0x00, 0x00 },	// U+0FB7 (ྷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0x92, 0xaa, 0xca, 0x8c, 0x80, 0x00, 0x00 },	// U+0FB8 (ྸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xa8, 0xa6, 0xa0, 0x9c, 0x24, 0xbc, 0x44, 0x04 },	// U+0FB9 (ྐྵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x92, 0xf2, 0x90, 0xb8, 0xc0, 0x80, 0x00 },	// U+0FBA (ྺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0x92, 0x92, 0xac, 0xc0, 0x80, 0x00, 0x00 },	// U+0FBB (ྻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x38, 0x40, 0x80, 0x80, 0x00, 0x00 },	// U+0FBC (ྼ)
}; // 36

static const unsigned char unifont_block60[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00 },	// U+0FBE (྾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x44, 0x28, 0x92, 0x28, 0x44, 0x92, 0x00, 0x00, 0x00, 0x00 },	// U+0FBF (྿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0FC0 (࿀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0FC1 (࿁)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x40, 0x58, 0x24, 0x24, 0x1a, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+0FC2 (࿂)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x92, 0xaa, 0x92, 0x54, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0FC3 (࿃)
	{ 0x00, 0x00, 0x00, 0xd6, 0x28, 0x10, 0x38, 0x44, 0x44, 0x44, 0x7c, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+0FC4 (࿄)
}; // 7

static const unsigned char unifont_block61[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xa4, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0FCE (࿎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x28, 0x00, 0xaa, 0x44, 0xaa, 0x00, 0x00, 0x00, 0x00 },	// U+0FCF (࿏)
}; // 2

static const unsigned char unifont_block62[][16] = {
	{ 0x00, 0x3c, 0x42, 0x40, 0x20, 0x38, 0x44, 0x38, 0x44, 0x18, 0x24, 0x20, 0x10, 0x20, 0x40, 0x00 },	// U+0FD1 (࿑)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+0FD2 (࿒)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x83, 0x8c, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0FD3 (࿓)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x46, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0FD4 (࿔)
}; // 4

static const unsigned char unifont_block63[][16] = {
	{ 0x00, 0x00, 0x00, 0x01, 0x7f, 0x44, 0x02, 0x01, 0x01, 0x01, 0x01, 0x41, 0x62, 0x5c, 0x00, 0x00 },	// U+10A0 (Ⴀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x11, 0x11, 0x11, 0x19, 0x16, 0x10, 0x10, 0x10, 0x70, 0x40, 0x00 },	// U+10A1 (Ⴁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x70, 0x40, 0x00 },	// U+10A2 (Ⴂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x7f, 0x48, 0x08, 0x1c, 0x22, 0x41, 0x41, 0x22, 0x1c, 0x00, 0x00 },	// U+10A3 (Ⴃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+10A4 (Ⴄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x10, 0x70, 0x50, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+10A5 (Ⴅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x44, 0x44, 0x44, 0x38, 0x00 },	// U+10A6 (Ⴆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x09, 0x09, 0x79, 0x49, 0x09, 0x09, 0x0a, 0x0c, 0x00, 0x00 },	// U+10A7 (Ⴇ)
	{ 0x00, 0x00, 0x00, 0x02, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+10A8 (Ⴈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x1a, 0x26, 0x22, 0x22, 0x32, 0x2c, 0x20, 0x20, 0x00, 0x00 },	// U+10A9 (Ⴉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x05, 0x04, 0x04, 0x34, 0x4c, 0x44, 0x44, 0x44, 0x38, 0x00 },	// U+10AA (Ⴊ)
	{ 0x00, 0x00, 0x00, 0x01, 0x1f, 0x10, 0x10, 0x10, 0x7e, 0x51, 0x51, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+10AB (Ⴋ)
	{ 0x00, 0x00, 0x00, 0x20, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+10AC (Ⴌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x51, 0x51, 0x2e, 0x00, 0x00 },	// U+10AD (Ⴍ)
	{ 0x00, 0x00, 0x00, 0x01, 0x47, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+10AE (Ⴎ)
	{ 0x00, 0x00, 0x00, 0x02, 0x5e, 0x48, 0x44, 0x44, 0x64, 0x58, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+10AF (Ⴏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x28, 0x58, 0x48, 0x49, 0x09, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+10B0 (Ⴐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x12, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+10B1 (Ⴑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x40, 0x00 },	// U+10B2 (Ⴒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x31, 0x51, 0x4e, 0x00, 0x00 },	// U+10B3 (Ⴓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x49, 0x49, 0x49, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+10B4 (Ⴔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0a, 0x3e, 0x28, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+10B5 (Ⴕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+10B6 (Ⴖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x22, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x20, 0x20, 0x00, 0x00 },	// U+10B7 (Ⴗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+10B8 (Ⴘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+10B9 (Ⴙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x44, 0x38, 0x20, 0x10 },	// U+10BA (Ⴚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x52, 0x52, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+10BB (Ⴛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x1e, 0x22, 0x12, 0x02, 0x02 },	// U+10BC (Ⴜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x04, 0x08, 0x10, 0x20, 0x42, 0x42, 0x3c },	// U+10BD (Ⴝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x20, 0x00 },	// U+10BE (Ⴞ)
	{ 0x00, 0x00, 0x00, 0x01, 0x7f, 0x44, 0x44, 0x28, 0x28, 0x10, 0x28, 0x28, 0x44, 0x44, 0x02, 0x01 },	// U+10BF (Ⴟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x09, 0x09, 0x08, 0x08, 0x08, 0x48, 0x48, 0x48, 0x30, 0x00, 0x00 },	// U+10C0 (Ⴠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x62, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+10C1 (Ⴡ)
	{ 0x00, 0x00, 0x00, 0x02, 0x1e, 0x22, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+10C2 (Ⴢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+10C3 (Ⴣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x41, 0x41, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+10C4 (Ⴤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x48, 0x48, 0x38, 0x08, 0x3e, 0x29, 0x69, 0x09, 0x06, 0x00, 0x00 },	// U+10C5 (Ⴥ)
}; // 38

static const unsigned char unifont_block64[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x20, 0x10, 0x08, 0x04, 0x42, 0x42, 0x3c },	// U+10C7 (Ⴧ)
}; // 1

static const unsigned char unifont_block65[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x3e, 0x00, 0x00 },	// U+10CD (Ⴭ)
}; // 1

static const unsigned char unifont_block66[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x30, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+10D0 (ა)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x08, 0x08, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+10D1 (ბ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x10, 0x10, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c },	// U+10D2 (გ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4a, 0x4a, 0x4a, 0x4a, 0x32, 0x04, 0x38, 0x40 },	// U+10D3 (დ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c },	// U+10D4 (ე)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x38, 0x40, 0x40, 0x42, 0x42, 0x3c },	// U+10D5 (ვ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x2a, 0x1c, 0x38, 0x48, 0x48, 0x48, 0x30, 0x00, 0x00 },	// U+10D6 (ზ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x52, 0x52, 0x52, 0x52, 0x52, 0x4c, 0x00, 0x00 },	// U+10D7 (თ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x00, 0x00 },	// U+10D8 (ი)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x40, 0x40, 0x38, 0x40, 0x40, 0x42, 0x42, 0x3c },	// U+10D9 (კ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xaa, 0xaa, 0xaa, 0x82, 0x42, 0x02, 0x7c, 0x80 },	// U+10DA (ლ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+10DB (მ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x3c, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+10DC (ნ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x2a, 0x2a, 0x2a, 0x22, 0x24, 0x00, 0x00 },	// U+10DD (ო)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x18, 0x20, 0x40, 0x40, 0x38, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+10DE (პ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x50, 0x4a, 0x4a, 0x44, 0x40, 0x44, 0x44, 0x38 },	// U+10DF (ჟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x1c, 0x02, 0x16, 0x2a, 0x2a, 0x2a, 0x2a, 0x22, 0x24, 0x00, 0x00 },	// U+10E0 (რ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x12, 0x0a, 0x12, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+10E1 (ს)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x66, 0x66, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x3c },	// U+10E2 (ტ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x48, 0x48, 0x40, 0x40, 0x40, 0x44, 0x44, 0x38 },	// U+10E3 (უ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x52, 0x52, 0x52, 0x52, 0x2c, 0x40, 0x40, 0x38 },	// U+10E4 (ფ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x20, 0x20, 0x20, 0x38, 0x24, 0x20, 0x20, 0x20, 0x22, 0x1c },	// U+10E5 (ქ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x2a, 0x2a, 0x22, 0x12, 0x02, 0x1c, 0x20 },	// U+10E6 (ღ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x42, 0x42, 0x42, 0x64, 0x58, 0x42, 0x42, 0x3c },	// U+10E7 (ყ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x2a, 0x20, 0x20, 0x38, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+10E8 (შ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x1e, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+10E9 (ჩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x42, 0x42, 0x42, 0x3a, 0x42, 0x42, 0x42, 0x42, 0x3c },	// U+10EA (ც)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+10EB (ძ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x2a, 0x02, 0x02, 0x3e, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08 },	// U+10EC (წ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x10, 0x10, 0x98, 0x64, 0xb8, 0x20, 0x20, 0x22, 0x1c },	// U+10ED (ჭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x12, 0x0a, 0x1e, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+10EE (ხ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x04, 0x02 },	// U+10EF (ჯ)
	{ 0x00, 0x00, 0x08, 0x30, 0x40, 0x48, 0x30, 0x40, 0x48, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+10F0 (ჰ)
	{ 0x00, 0x00, 0x0a, 0x32, 0x42, 0x4a, 0x32, 0x42, 0x4a, 0x32, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+10F1 (ჱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x7e, 0x00, 0x00 },	// U+10F2 (ჲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x40, 0x20, 0x10, 0x38, 0x40, 0x40, 0x42, 0x42, 0x3c },	// U+10F3 (ჳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x30, 0x40, 0x40, 0x40, 0x38, 0x40, 0x40, 0x42, 0x42, 0x3c },	// U+10F4 (ჴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x7c, 0x20, 0x7c, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+10F5 (ჵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x08, 0x1c, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x08, 0x10 },	// U+10F6 (ჶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x20, 0x10, 0x08, 0x04, 0x42, 0x42, 0x3c },	// U+10F7 (ჷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x42, 0x42, 0x42, 0x26, 0x1a, 0x42, 0x42, 0x3c },	// U+10F8 (ჸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x08, 0x48, 0x48, 0x30 },	// U+10F9 (ჹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x0c, 0x30, 0x38, 0x44, 0x02, 0x00, 0x00 },	// U+10FA (ჺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x60, 0x60, 0x00, 0x06, 0x06, 0x00, 0x00 },	// U+10FB (჻)
	{ 0x00, 0x00, 0x40, 0x38, 0x04, 0x04, 0x3c, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+10FC (ჼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x04, 0x08, 0x10, 0x20, 0x42, 0x42, 0x3c },	// U+10FD (ჽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x44, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+10FE (ჾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+10FF (ჿ)
}; // 48

static const unsigned char unifont_block67[][16] = {
	{ 0x00, 0x00, 0x7e, 0xc3, 0xc3, 0xff, 0xc3, 0xc3, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00 },	// U+1343 (ፃ)
}; // 1

static const unsigned char unifont_block68[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1361 (፡)
}; // 1

static const unsigned char unifont_block69[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+1390 (᎐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x3c, 0x00, 0x00 },	// U+1391 (᎑)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+1392 (᎒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+1393 (᎓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x00, 0x00 },	// U+1394 (᎔)
}; // 5

static const unsigned char unifont_block70[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x70, 0x38, 0x06, 0x00, 0x00 },	// U+1396 (᎖)
}; // 1

static const unsigned char unifont_block71[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x66, 0x7e, 0x66, 0x06, 0x06, 0x06, 0x00, 0x00 },	// U+1399 (᎙)
}; // 1

static const unsigned char unifont_block72[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+13A0 (Ꭰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x22, 0x1e, 0x0a, 0x12, 0x22, 0xc2, 0x00, 0x00 },	// U+13A1 (Ꭱ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+13A2 (Ꭲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x28, 0x48, 0x84, 0x8a, 0x8a, 0x8a, 0xaa, 0x64, 0x00, 0x00 },	// U+13A3 (Ꭳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0xd2, 0x92, 0x72, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+13A4 (Ꭴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+13A5 (Ꭵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x04, 0xfe, 0x20, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13A6 (Ꭶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x40, 0x44, 0x4a, 0x4a, 0x4a, 0x46, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13A7 (Ꭷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x32, 0x2a, 0x6e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+13A8 (Ꭸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c, 0x00, 0x00 },	// U+13A9 (Ꭹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+13AA (Ꭺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+13AB (Ꭻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+13AC (Ꭼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x12, 0x15, 0xdd, 0x92, 0x50, 0x50, 0x30, 0x00, 0x00 },	// U+13AD (Ꭽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+13AE (Ꭾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x55, 0x33, 0x00, 0x00 },	// U+13AF (Ꭿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+13B0 (Ꮀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+13B1 (Ꮁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x0c, 0xed, 0x4d, 0x2d, 0x12, 0x00, 0x00 },	// U+13B2 (Ꮂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+13B3 (Ꮃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x90, 0x90, 0x10, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+13B4 (Ꮄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x4a, 0x32, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+13B5 (Ꮅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x02, 0x12, 0x32, 0x52, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+13B6 (Ꮆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+13B7 (Ꮇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x40, 0x4e, 0x78, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+13B8 (Ꮈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x50, 0xa8, 0x04, 0x3c, 0x4a, 0x4a, 0x48, 0x48, 0x30, 0x00, 0x00 },	// U+13B9 (Ꮉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x52, 0x52, 0x72, 0x52, 0x52, 0x52, 0x52, 0x4c, 0x00, 0x00 },	// U+13BA (Ꮊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+13BB (Ꮋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x08, 0x1c, 0x22, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13BC (Ꮌ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe2, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x47, 0x22, 0x1c, 0x00 },	// U+13BD (Ꮍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13BE (Ꮎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0f, 0x02, 0x02, 0x02, 0x02, 0x72, 0x22, 0x3c, 0x20, 0x18 },	// U+13BF (Ꮏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x21, 0x01, 0x01, 0x79, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00 },	// U+13C0 (Ꮐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x48, 0x48, 0x44, 0x44, 0x45, 0x45, 0x42, 0x00, 0x00 },	// U+13C1 (Ꮑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+13C2 (Ꮒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+13C3 (Ꮓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x27, 0x20, 0x27, 0x22, 0x3c, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+13C4 (Ꮔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x52, 0xb2, 0x92, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+13C5 (Ꮕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x00, 0x00 },	// U+13C6 (Ꮖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x40, 0x42, 0x52, 0x52, 0x52, 0x52, 0x52, 0x2c, 0x00, 0x00 },	// U+13C7 (Ꮗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0x98, 0x98, 0x94, 0x54, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+13C8 (Ꮘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x8f, 0x85, 0x44, 0x44, 0x44, 0x24, 0x24, 0x24, 0x14, 0x08, 0x00, 0x00 },	// U+13C9 (Ꮙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x40, 0x59, 0x45, 0x45, 0x45, 0x45, 0x3a, 0x00, 0x00 },	// U+13CA (Ꮚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x3c, 0x02, 0x22, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13CB (Ꮛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13CC (Ꮜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x40, 0x40, 0x58, 0x4b, 0x4d, 0x36, 0x00, 0x00 },	// U+13CD (Ꮝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x28, 0x24, 0x22, 0x22, 0x7e, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+13CE (Ꮞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+13CF (Ꮟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0xd0, 0xba, 0x16, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+13D0 (Ꮠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x26, 0x59, 0x47, 0x22, 0x01, 0x19, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00 },	// U+13D1 (Ꮡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x22, 0x1a, 0x12, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+13D2 (Ꮢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+13D3 (Ꮣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x49, 0x4d, 0x4d, 0x53, 0x53, 0x61, 0x41, 0x00, 0x00 },	// U+13D4 (Ꮤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0xe2, 0x02, 0x04, 0xf8, 0x20, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13D5 (Ꮥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x09, 0x08, 0x08, 0x08, 0x08, 0x48, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+13D6 (Ꮦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x00 },	// U+13D7 (Ꮧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x00 },	// U+13D8 (Ꮨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x41, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00 },	// U+13D9 (Ꮩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13DA (Ꮪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x42, 0x06, 0x0a, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+13DB (Ꮫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x24, 0x44, 0xaa, 0xaa, 0xaa, 0x44, 0x00, 0x00 },	// U+13DC (Ꮬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+13DD (Ꮭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+13DE (Ꮮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13DF (Ꮯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x22, 0x25, 0x25, 0x7e, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+13E0 (Ꮰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0x99, 0x99, 0x59, 0x14, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+13E1 (Ꮱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+13E2 (Ꮲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0xe2, 0x02, 0x02, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13E3 (Ꮳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x8f, 0x89, 0x48, 0x48, 0x28, 0x28, 0x28, 0x18, 0x18, 0x08, 0x00, 0x00 },	// U+13E4 (Ꮴ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0xc2, 0xb2, 0x2e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+13E5 (Ꮵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+13E6 (Ꮶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x78, 0x44, 0x42, 0x42, 0x44, 0x38, 0x00, 0x00 },	// U+13E7 (Ꮷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x52, 0xa2, 0x02, 0x02, 0xa2, 0x52, 0x12, 0x0c, 0x00, 0x00 },	// U+13E8 (Ꮸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x02, 0x02, 0x72, 0x22, 0x22, 0xdc, 0x00, 0x00 },	// U+13E9 (Ꮹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0xaa, 0xaa, 0xca, 0x8a, 0x8c, 0x98, 0x99, 0xa9, 0x46, 0x00, 0x00 },	// U+13EA (Ꮺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x4e, 0x4a, 0x7a, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13EB (Ꮻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x4c, 0x92, 0x92, 0x92, 0x8e, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00 },	// U+13EC (Ꮼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x48, 0x50, 0x60, 0x40, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+13ED (Ꮽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+13EE (Ꮾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x80, 0x80, 0x80, 0xba, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+13EF (Ꮿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x3c, 0x44, 0x44, 0x46, 0x4c, 0x34, 0x02, 0x00 },	// U+13F0 (Ᏸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x20, 0x70, 0x88, 0x88, 0x84, 0x84, 0x94, 0x95, 0x66, 0x00, 0x00 },	// U+13F1 (Ᏹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+13F2 (Ᏺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x52, 0xa2, 0x02, 0x02, 0x72, 0x22, 0x22, 0x3c, 0x00, 0x00 },	// U+13F3 (Ᏻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+13F4 (Ᏼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x72, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+13F5 (Ᏽ)
}; // 86

static const unsigned char unifont_block73[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x3c, 0x44, 0x46, 0x4c, 0x34, 0x02, 0x00 },	// U+13F8 (ᏸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x20, 0x70, 0x88, 0x88, 0x84, 0x95, 0x66, 0x00, 0x00 },	// U+13F9 (ᏹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x00, 0x00 },	// U+13FA (ᏺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x52, 0xa2, 0x02, 0x02, 0x72, 0x22, 0x3c, 0x00, 0x00 },	// U+13FB (ᏻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+13FC (ᏼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0x02, 0x72, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+13FD (ᏽ)
}; // 6

static const unsigned char unifont_block74[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+1400 (᐀)
}; // 1

static const unsigned char unifont_block75[][16] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x14, 0x14, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+141E (ᐞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+141F (ᐟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1420 (ᐠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1421 (ᐡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1422 (ᐢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1423 (ᐣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1424 (ᐤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x90, 0x48, 0x24, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1425 (ᐥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1426 (ᐦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1427 (ᐧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1428 (ᐨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1429 (ᐩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+142A (ᐪ)
}; // 13

static const unsigned char unifont_block76[][16] = {
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00 },	// U+1433 (ᐳ)
	{ 0x06, 0x06, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00 },	// U+1434 (ᐴ)
	{ 0x66, 0x66, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00 },	// U+1435 (ᐵ)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x24, 0x44, 0x44, 0x24, 0x10, 0x08, 0x04, 0x02, 0x00 },	// U+1436 (ᐶ)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x4c, 0x4c, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00 },	// U+1437 (ᐷ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00 },	// U+1438 (ᐸ)
	{ 0x60, 0x60, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00 },	// U+1439 (ᐹ)
}; // 7

static const unsigned char unifont_block77[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1449 (ᑉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+144A (ᑊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+144B (ᑋ)
}; // 3

static const unsigned char unifont_block78[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1466 (ᑦ)
}; // 1

static const unsigned char unifont_block79[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+146B (ᑫ)
	{ 0x18, 0x24, 0x24, 0x18, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+146C (ᑬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+146D (ᑭ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+146E (ᑮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+146F (ᑯ)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1470 (ᑰ)
	{ 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1471 (ᑱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1472 (ᑲ)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1473 (ᑳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x78, 0x40, 0x46, 0x46, 0x40, 0x00, 0x00 },	// U+1474 (ᑴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0xd0, 0xd0, 0x10, 0x10, 0x00, 0x00 },	// U+1475 (ᑵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x78, 0x0b, 0x0b, 0x08, 0x08, 0x00, 0x00 },	// U+1476 (ᑶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0f, 0x61, 0x61, 0x01, 0x01, 0x00, 0x00 },	// U+1477 (ᑷ)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x70, 0x88, 0x88, 0x88, 0x78, 0x0b, 0x0b, 0x08, 0x08, 0x00, 0x00 },	// U+1478 (ᑸ)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0f, 0x61, 0x61, 0x01, 0x01, 0x00, 0x00 },	// U+1479 (ᑹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x86, 0x86, 0xf0, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+147A (ᑺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0xd0, 0xd0, 0x1e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+147B (ᑻ)
	{ 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x80, 0x80, 0x86, 0x86, 0xf0, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+147C (ᑼ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x10, 0x10, 0xd0, 0xd0, 0x1e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+147D (ᑽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0b, 0x7b, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+147E (ᑾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x61, 0x61, 0x0f, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+147F (ᑿ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x08, 0x08, 0x08, 0x0b, 0x7b, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+1480 (ᒀ)
	{ 0x00, 0x00, 0x03, 0x03, 0x00, 0x01, 0x01, 0x61, 0x61, 0x0f, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1481 (ᒁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0b, 0x0b, 0x78, 0x8b, 0x8b, 0x88, 0x70, 0x00, 0x00 },	// U+1482 (ᒂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1483 (ᒃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x38, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1484 (ᒄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x51, 0x51, 0x51, 0x1e, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1485 (ᒅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x51, 0x51, 0x51, 0x0f, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+1486 (ᒆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x50, 0x50, 0x50, 0x1e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1487 (ᒇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x1e, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1488 (ᒈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+1489 (ᒉ)
	{ 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+148A (ᒊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+148B (ᒋ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+148C (ᒌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+148D (ᒍ)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+148E (ᒎ)
	{ 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+148F (ᒏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1490 (ᒐ)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1491 (ᒑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x40, 0x43, 0x43, 0x40, 0x40, 0x00, 0x00 },	// U+1492 (ᒒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0xd1, 0xd0, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1493 (ᒓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x8b, 0x0b, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+1494 (ᒔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x01, 0x61, 0x61, 0x01, 0x01, 0x00, 0x00 },	// U+1495 (ᒕ)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x70, 0x88, 0x88, 0x8b, 0x0b, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+1496 (ᒖ)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x01, 0x31, 0x31, 0x01, 0x01, 0x00, 0x00 },	// U+1497 (ᒗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x43, 0x43, 0x40, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+1498 (ᒘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xd0, 0xd0, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1499 (ᒙ)
	{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x40, 0x40, 0x43, 0x43, 0x40, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+149A (ᒚ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x10, 0x10, 0xd0, 0xd0, 0x10, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+149B (ᒛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0b, 0x0b, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+149C (ᒜ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x61, 0x61, 0x01, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+149D (ᒝ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x08, 0x08, 0x08, 0x0b, 0x0b, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+149E (ᒞ)
	{ 0x00, 0x00, 0x03, 0x03, 0x00, 0x01, 0x01, 0x61, 0x61, 0x01, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+149F (ᒟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0b, 0x0b, 0x88, 0x8b, 0x8b, 0x70, 0x00, 0x00 },	// U+14A0 (ᒠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14A1 (ᒡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14A2 (ᒢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+14A3 (ᒣ)
	{ 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14A4 (ᒤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14A5 (ᒥ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14A6 (ᒦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x00, 0x00 },	// U+14A7 (ᒧ)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x00, 0x00 },	// U+14A8 (ᒨ)
	{ 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x00, 0x00 },	// U+14A9 (ᒩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00 },	// U+14AA (ᒪ)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00 },	// U+14AB (ᒫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x80, 0x80, 0x86, 0x86, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00 },	// U+14AC (ᒬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0xd0, 0xd0, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+14AD (ᒭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x0b, 0x0b, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+14AE (ᒮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x61, 0x61, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+14AF (ᒯ)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0xf8, 0x08, 0x08, 0x0b, 0x0b, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+14B0 (ᒰ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x3e, 0x02, 0x02, 0x62, 0x62, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14B1 (ᒱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x86, 0x86, 0x80, 0x80, 0x80, 0xf8, 0x00, 0x00 },	// U+14B2 (ᒲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xd0, 0xd0, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x00 },	// U+14B3 (ᒳ)
	{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x40, 0x40, 0x40, 0x43, 0x43, 0x40, 0x40, 0x40, 0x7c, 0x00, 0x00 },	// U+14B4 (ᒴ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x10, 0x10, 0x10, 0xd0, 0xd0, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x00 },	// U+14B5 (ᒵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0b, 0x0b, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00 },	// U+14B6 (ᒶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x61, 0x61, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+14B7 (ᒷ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x08, 0x08, 0x08, 0x0b, 0x0b, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00 },	// U+14B8 (ᒸ)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x02, 0x02, 0x02, 0x62, 0x62, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00 },	// U+14B9 (ᒹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0b, 0x0b, 0x08, 0x0b, 0x0b, 0x08, 0xf8, 0x00, 0x00 },	// U+14BA (ᒺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14BB (ᒻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14BC (ᒼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14BD (ᒽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x10, 0x08, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14BE (ᒾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+14BF (ᒿ)
}; // 85

static const unsigned char unifont_block80[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14D0 (ᓐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14D1 (ᓑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x90, 0x90, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14D2 (ᓒ)
}; // 3

static const unsigned char unifont_block81[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x01, 0x01, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14EA (ᓪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x30, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+14EB (ᓫ)
	{ 0x00, 0x00, 0x00, 0x60, 0x18, 0x06, 0x0c, 0x30, 0x40, 0x30, 0x0c, 0x06, 0x18, 0x60, 0x00, 0x00 },	// U+14EC (ᓬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x04, 0x38, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+14ED (ᓭ)
	{ 0x30, 0x48, 0x48, 0x30, 0x00, 0x20, 0x20, 0x20, 0x10, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14EE (ᓮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x10, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14EF (ᓯ)
	{ 0x00, 0x30, 0x30, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14F0 (ᓰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x38, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14F1 (ᓱ)
	{ 0x00, 0x30, 0x30, 0x00, 0x20, 0x20, 0x20, 0x38, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14F2 (ᓲ)
	{ 0x00, 0x66, 0x66, 0x00, 0x20, 0x20, 0x20, 0x38, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14F3 (ᓳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x0e, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+14F4 (ᓴ)
	{ 0x00, 0x06, 0x06, 0x00, 0x02, 0x02, 0x02, 0x0e, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+14F5 (ᓵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x73, 0x43, 0x40, 0x40, 0x00, 0x00 },	// U+14F6 (ᓶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x61, 0x61, 0x02, 0x1c, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+14F7 (ᓷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x43, 0x43, 0x20, 0x1c, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+14F8 (ᓸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x67, 0x61, 0x01, 0x01, 0x00, 0x00 },	// U+14F9 (ᓹ)
	{ 0x00, 0x60, 0x60, 0x00, 0x40, 0x40, 0x40, 0x43, 0x43, 0x20, 0x1c, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+14FA (ᓺ)
	{ 0x00, 0x18, 0x18, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x67, 0x61, 0x01, 0x01, 0x00, 0x00 },	// U+14FB (ᓻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x46, 0x46, 0x70, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+14FC (ᓼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x38, 0x04, 0x62, 0x62, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14FD (ᓽ)
	{ 0x00, 0x60, 0x60, 0x00, 0x40, 0x46, 0x46, 0x70, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+14FE (ᓾ)
	{ 0x00, 0x30, 0x30, 0x00, 0x20, 0x20, 0x20, 0x38, 0x04, 0x62, 0x62, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+14FF (ᓿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x0e, 0x10, 0x23, 0x23, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+1500 (ᔀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x61, 0x67, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1501 (ᔁ)
	{ 0x00, 0x06, 0x06, 0x00, 0x02, 0x02, 0x02, 0x0e, 0x10, 0x23, 0x23, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+1502 (ᔂ)
	{ 0x00, 0x03, 0x03, 0x00, 0x01, 0x01, 0x61, 0x67, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1503 (ᔃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0b, 0x0b, 0x38, 0x40, 0x83, 0x83, 0x80, 0x80, 0x80, 0x00, 0x00 },	// U+1504 (ᔄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1505 (ᔅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x08, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1506 (ᔆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x18, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1507 (ᔇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1508 (ᔈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1c, 0x20, 0x38, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1509 (ᔉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x38, 0x04, 0x1c, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+150A (ᔊ)
	{ 0x00, 0x0c, 0x0c, 0x00, 0x04, 0x04, 0x0c, 0x10, 0x10, 0x10, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+150B (ᔋ)
}; // 34

static const unsigned char unifont_block82[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x2a, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1525 (ᔥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+1526 (ᔦ)
	{ 0x18, 0x24, 0x24, 0x18, 0x02, 0x04, 0x08, 0x10, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1527 (ᔧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1528 (ᔨ)
	{ 0x00, 0x06, 0x06, 0x00, 0x02, 0x04, 0x08, 0x10, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1529 (ᔩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+152A (ᔪ)
	{ 0x00, 0x30, 0x30, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+152B (ᔫ)
	{ 0x00, 0x66, 0x66, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+152C (ᔬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+152D (ᔭ)
	{ 0x00, 0x06, 0x06, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+152E (ᔮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x13, 0x0b, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+152F (ᔯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0xc4, 0xc2, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1530 (ᔰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x43, 0xfb, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+1531 (ᔱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x64, 0x68, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+1532 (ᔲ)
	{ 0x00, 0x18, 0x18, 0x00, 0x08, 0x10, 0x20, 0x43, 0xfb, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+1533 (ᔳ)
	{ 0x00, 0x03, 0x03, 0x00, 0x01, 0x02, 0x64, 0x68, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+1534 (ᔴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x0b, 0x13, 0x20, 0x40, 0x00, 0x00 },	// U+1535 (ᔵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0xdf, 0xc2, 0x04, 0x08, 0x10, 0x00, 0x00 },	// U+1536 (ᔶ)
	{ 0x00, 0x60, 0x60, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x0b, 0x13, 0x20, 0x40, 0x00, 0x00 },	// U+1537 (ᔷ)
	{ 0x00, 0x18, 0x18, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0xdf, 0xc2, 0x04, 0x08, 0x10, 0x00, 0x00 },	// U+1538 (ᔸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0xfb, 0x43, 0x20, 0x10, 0x08, 0x00, 0x00 },	// U+1539 (ᔹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x68, 0x64, 0x02, 0x01, 0x00, 0x00 },	// U+153A (ᔺ)
	{ 0x00, 0x18, 0x18, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0xfb, 0x43, 0x20, 0x10, 0x08, 0x00, 0x00 },	// U+153B (ᔻ)
	{ 0x00, 0x03, 0x03, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x68, 0x64, 0x02, 0x01, 0x00, 0x00 },	// U+153C (ᔼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0b, 0x0b, 0x08, 0xf8, 0x43, 0x23, 0x10, 0x08, 0x00, 0x00 },	// U+153D (ᔽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x3c, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+153E (ᔾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x2a, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+153F (ᔿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1540 (ᕀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1541 (ᕁ)
}; // 29

static const unsigned char unifont_block83[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1548 (ᕈ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1549 (ᕉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x00 },	// U+154A (ᕊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+154B (ᕋ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+154C (ᕌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x00 },	// U+154D (ᕍ)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0xf8, 0x04, 0x04, 0x04, 0x04, 0xf8, 0x83, 0x83, 0x80, 0x00, 0x00 },	// U+154E (ᕎ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x3e, 0x01, 0x01, 0xc1, 0xc1, 0x3e, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+154F (ᕏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x04, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1550 (ᕐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x0c, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1551 (ᕑ)
	{ 0x00, 0x00, 0x00, 0x06, 0x18, 0x60, 0x30, 0x0c, 0x02, 0x0c, 0x30, 0x60, 0x18, 0x06, 0x00, 0x00 },	// U+1552 (ᕒ)
}; // 11

static const unsigned char unifont_block84[][16] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x48, 0x34, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+155D (ᕝ)
}; // 1

static const unsigned char unifont_block85[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x54, 0x54, 0x24, 0x04, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+156A (ᕪ)
}; // 1

static const unsigned char unifont_block86[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x38, 0x48, 0x48, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+157B (ᕻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+157C (ᕼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+157D (ᕽ)
}; // 3

static const unsigned char unifont_block87[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0xf0, 0xa0, 0xa0, 0x90, 0x90, 0x00, 0x00 },	// U+1586 (ᖆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x78, 0x28, 0x28, 0x48, 0x48, 0x00, 0x00 },	// U+1587 (ᖇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90, 0xa0, 0xa0, 0xf0, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+1588 (ᖈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x28, 0x28, 0x78, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+1589 (ᖉ)
}; // 4

static const unsigned char unifont_block88[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x52, 0x52, 0x4c, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+1597 (ᖗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x4a, 0x4a, 0x32, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1598 (ᖘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x4c, 0x52, 0x52, 0x42, 0x3c, 0x00, 0x00 },	// U+1599 (ᖙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x32, 0x4a, 0x4a, 0x42, 0x3c, 0x00, 0x00 },	// U+159A (ᖚ)
}; // 4

static const unsigned char unifont_block89[][16] = {
	{ 0x00, 0x00, 0x00, 0xfc, 0x00, 0x0c, 0x12, 0x12, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+159F (ᖟ)
}; // 1

static const unsigned char unifont_block90[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x02, 0x3c, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+15A6 (ᖦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x3e, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+15A7 (ᖧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x7c, 0x04, 0x3e, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+15A8 (ᖨ)
	{ 0x00, 0x06, 0x06, 0x00, 0x04, 0x08, 0x10, 0x20, 0x7c, 0x04, 0x3e, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+15A9 (ᖩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x3e, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+15AA (ᖪ)
	{ 0x00, 0x30, 0x30, 0x00, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x3e, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+15AB (ᖫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x3e, 0x04, 0x7c, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+15AC (ᖬ)
	{ 0x00, 0x0c, 0x0c, 0x00, 0x04, 0x04, 0x04, 0x3e, 0x04, 0x7c, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+15AD (ᖭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1e, 0x04, 0x3c, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+15AE (ᖮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x3d, 0x43, 0x41, 0x41, 0x43, 0x3d, 0x00, 0x00 },	// U+15AF (ᖯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x7f, 0x7f, 0x7f, 0x7f, 0x3d, 0x01, 0x01, 0x01, 0x00 },	// U+15B0 (ᖰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5e, 0x7f, 0x7f, 0x7f, 0x7f, 0x5e, 0x00 },	// U+15B1 (ᖱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x3d, 0x7f, 0x7f, 0x7f, 0x7f, 0x3d, 0x00 },	// U+15B2 (ᖲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x7f, 0x7f, 0x7f, 0x7f, 0x5e, 0x40, 0x40, 0x40, 0x00 },	// U+15B3 (ᖳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+15B4 (ᖴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x20, 0x20, 0x20, 0x3e, 0x00, 0x00 },	// U+15B5 (ᖵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00 },	// U+15B6 (ᖶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+15B7 (ᖷ)
}; // 18

static const unsigned char unifont_block91[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+15EE (ᗮ)
}; // 1

static const unsigned char unifont_block92[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1601 (ᘁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1602 (ᘂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+1603 (ᘃ)
}; // 3

static const unsigned char unifont_block93[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1646 (ᙆ)
	{ 0x00, 0x00, 0x08, 0x08, 0x3e, 0x10, 0x08, 0x04, 0x3e, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1647 (ᙇ)
}; // 2

static const unsigned char unifont_block94[][16] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x3c, 0x02, 0x1c, 0x20, 0x1e, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+165A (ᙚ)
}; // 1

static const unsigned char unifont_block95[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+166D (᙭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00 },	// U+166E (᙮)
}; // 2

static const unsigned char unifont_block96[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x64, 0x62, 0x1f, 0x10, 0x3e, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1677 (ᙷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0xc4, 0xc8, 0x10, 0x3e, 0x02, 0x1f, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1678 (ᙸ)
	{ 0x00, 0x06, 0x06, 0x00, 0x02, 0xc4, 0xc8, 0x10, 0x3e, 0x02, 0x1f, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1679 (ᙹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x3e, 0x10, 0x1f, 0x62, 0x64, 0x08, 0x10, 0x00, 0x00 },	// U+167A (ᙺ)
	{ 0x00, 0x18, 0x18, 0x00, 0x10, 0x10, 0x10, 0x3e, 0x10, 0x1f, 0x62, 0x64, 0x08, 0x10, 0x00, 0x00 },	// U+167B (ᙻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x1f, 0x02, 0x3e, 0xd0, 0xc8, 0x04, 0x02, 0x00, 0x00 },	// U+167C (ᙼ)
	{ 0x00, 0x06, 0x06, 0x00, 0x02, 0x02, 0x02, 0x1f, 0x02, 0x3e, 0xd0, 0xc8, 0x04, 0x02, 0x00, 0x00 },	// U+167D (ᙽ)
	{ 0x00, 0x00, 0x00, 0x08, 0x3e, 0x08, 0x3e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+167E (ᙾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+167F (ᙿ)
}; // 9

static const unsigned char unifont_block97[][16] = {
	{ 0x00, 0x49, 0x25, 0x13, 0x09, 0x05, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },	// U+16A0 (ᚠ)
	{ 0x00, 0x55, 0x29, 0x15, 0x0b, 0x05, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },	// U+16A1 (ᚡ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x11, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00 },	// U+16A2 (ᚢ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x11, 0x21, 0x41, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x00 },	// U+16A3 (ᚣ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x11, 0x21, 0x21, 0x2d, 0x2d, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00 },	// U+16A4 (ᚤ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x11, 0x21, 0x43, 0x45, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x00 },	// U+16A5 (ᚥ)
	{ 0x00, 0x01, 0x01, 0x01, 0x03, 0x05, 0x09, 0x11, 0x11, 0x09, 0x05, 0x03, 0x01, 0x01, 0x01, 0x00 },	// U+16A6 (ᚦ)
	{ 0x00, 0x01, 0x01, 0x01, 0x03, 0x05, 0x09, 0x15, 0x15, 0x09, 0x05, 0x03, 0x01, 0x01, 0x01, 0x00 },	// U+16A7 (ᚧ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x13, 0x05, 0x09, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },	// U+16A8 (ᚨ)
	{ 0x00, 0x01, 0x43, 0x25, 0x19, 0x43, 0x25, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },	// U+16A9 (ᚩ)
	{ 0x00, 0x01, 0x43, 0x25, 0x19, 0x03, 0x05, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },	// U+16AA (ᚪ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x13, 0x05, 0x09, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },	// U+16AB (ᚫ)
	{ 0x00, 0x08, 0x08, 0x09, 0x0a, 0x0c, 0x09, 0x1a, 0x2c, 0x48, 0x18, 0x28, 0x48, 0x08, 0x08, 0x00 },	// U+16AC (ᚬ)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x28, 0x48, 0x18, 0x28, 0x48, 0x08, 0x08, 0x08, 0x00 },	// U+16AD (ᚭ)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x14, 0x12, 0x18, 0x14, 0x12, 0x10, 0x10, 0x10, 0x10 },	// U+16AE (ᚮ)
	{ 0x00, 0x08, 0x08, 0x48, 0x28, 0x18, 0x48, 0x2c, 0x1a, 0x09, 0x0c, 0x0a, 0x09, 0x08, 0x08, 0x00 },	// U+16AF (ᚯ)
	{ 0x00, 0x08, 0x08, 0x48, 0x28, 0x18, 0x08, 0x0c, 0x0a, 0x09, 0x0c, 0x0a, 0x09, 0x08, 0x08, 0x00 },	// U+16B0 (ᚰ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x11, 0x21, 0x11, 0x09, 0x05, 0x05, 0x09, 0x11, 0x21, 0x41, 0x00 },	// U+16B1 (ᚱ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+16B2 (ᚲ)
	{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x05, 0x09, 0x11, 0x21, 0x41, 0x00 },	// U+16B3 (ᚳ)
	{ 0x00, 0x41, 0x21, 0x11, 0x09, 0x05, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },	// U+16B4 (ᚴ)
	{ 0x00, 0x4d, 0x2d, 0x11, 0x09, 0x05, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },	// U+16B5 (ᚵ)
	{ 0x00, 0x42, 0x22, 0x12, 0x0a, 0x07, 0x07, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00 },	// U+16B6 (ᚶ)
	{ 0x00, 0x41, 0x41, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x14, 0x14, 0x22, 0x22, 0x41, 0x41, 0x00 },	// U+16B7 (ᚷ)
	{ 0x00, 0x41, 0x41, 0x22, 0x22, 0x14, 0x14, 0x2a, 0x2a, 0x14, 0x14, 0x22, 0x22, 0x41, 0x41, 0x00 },	// U+16B8 (ᚸ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x11, 0x09, 0x05, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },	// U+16B9 (ᚹ)
	{ 0x00, 0x41, 0x41, 0x41, 0x41, 0x41, 0x47, 0x49, 0x71, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x00 },	// U+16BA (ᚺ)
	{ 0x00, 0x41, 0x41, 0x41, 0x41, 0x47, 0x49, 0x71, 0x47, 0x49, 0x71, 0x41, 0x41, 0x41, 0x41, 0x00 },	// U+16BB (ᚻ)
	{ 0x00, 0x08, 0x08, 0x08, 0x49, 0x2a, 0x1c, 0x08, 0x1c, 0x2a, 0x49, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16BC (ᚼ)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x1c, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16BD (ᚽ)
	{ 0x00, 0x08, 0x08, 0x08, 0x09, 0x0a, 0x0c, 0x08, 0x18, 0x28, 0x48, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16BE (ᚾ)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x14, 0x24, 0x44, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+16BF (ᚿ)
	{ 0x00, 0x08, 0x08, 0x08, 0x09, 0x0a, 0x1c, 0x1c, 0x1c, 0x28, 0x48, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16C0 (ᛀ)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16C1 (ᛁ)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x1c, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16C2 (ᛂ)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x11, 0x22, 0x44, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+16C3 (ᛃ)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x2a, 0x49, 0x49, 0x2a, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16C4 (ᛄ)
	{ 0x00, 0x08, 0x08, 0x08, 0x48, 0x28, 0x18, 0x08, 0x0c, 0x0a, 0x09, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16C5 (ᛅ)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x14, 0x12, 0x11, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+16C6 (ᛆ)
	{ 0x00, 0x08, 0x18, 0x28, 0x48, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x0a, 0x0c, 0x08, 0x00 },	// U+16C7 (ᛇ)
	{ 0x00, 0x41, 0x23, 0x15, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x15, 0x23, 0x41, 0x00 },	// U+16C8 (ᛈ)
	{ 0x00, 0x49, 0x49, 0x2a, 0x2a, 0x1c, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16C9 (ᛉ)
	{ 0x00, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00 },	// U+16CA (ᛊ)
	{ 0x00, 0x02, 0x02, 0x02, 0x02, 0x22, 0x32, 0x2a, 0x26, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00 },	// U+16CB (ᛋ)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+16CC (ᛌ)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+16CD (ᛍ)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x49, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+16CE (ᛎ)
	{ 0x00, 0x08, 0x1c, 0x2a, 0x49, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16CF (ᛏ)
	{ 0x00, 0x10, 0x18, 0x14, 0x12, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+16D0 (ᛐ)
	{ 0x00, 0x10, 0x18, 0x14, 0x12, 0x11, 0x10, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+16D1 (ᛑ)
	{ 0x00, 0x06, 0x0a, 0x12, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x12, 0x0a, 0x06, 0x00 },	// U+16D2 (ᛒ)
	{ 0x00, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x26, 0x12, 0x0a, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00 },	// U+16D3 (ᛓ)
	{ 0x00, 0x03, 0x05, 0x09, 0x15, 0x09, 0x05, 0x03, 0x03, 0x05, 0x09, 0x15, 0x09, 0x05, 0x03, 0x00 },	// U+16D4 (ᛔ)
	{ 0x00, 0x41, 0x21, 0x11, 0x09, 0x05, 0x03, 0x01, 0x01, 0x03, 0x05, 0x09, 0x11, 0x21, 0x41, 0x00 },	// U+16D5 (ᛕ)
	{ 0x00, 0x41, 0x63, 0x63, 0x55, 0x55, 0x49, 0x49, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x00 },	// U+16D6 (ᛖ)
	{ 0x00, 0x41, 0x63, 0x55, 0x49, 0x55, 0x63, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x00 },	// U+16D7 (ᛗ)
	{ 0x00, 0x49, 0x49, 0x2a, 0x2a, 0x1c, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16D8 (ᛘ)
	{ 0x00, 0x1c, 0x1c, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16D9 (ᛙ)
	{ 0x00, 0x02, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00 },	// U+16DA (ᛚ)
	{ 0x00, 0x02, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x07, 0x07, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00 },	// U+16DB (ᛛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x41, 0x41, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+16DC (ᛜ)
	{ 0x00, 0x41, 0x22, 0x14, 0x08, 0x14, 0x22, 0x41, 0x41, 0x22, 0x14, 0x08, 0x14, 0x22, 0x41, 0x00 },	// U+16DD (ᛝ)
	{ 0x00, 0x41, 0x63, 0x63, 0x55, 0x55, 0x49, 0x49, 0x49, 0x49, 0x55, 0x55, 0x63, 0x63, 0x41, 0x00 },	// U+16DE (ᛞ)
	{ 0x00, 0x00, 0x08, 0x14, 0x22, 0x41, 0x41, 0x22, 0x14, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00, 0x00 },	// U+16DF (ᛟ)
}; // 64

static const unsigned char unifont_block98[][16] = {
	{ 0x00, 0x08, 0x08, 0x08, 0x49, 0x2a, 0x1c, 0x08, 0x1c, 0x2a, 0x49, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16E1 (ᛡ)
}; // 1

static const unsigned char unifont_block99[][16] = {
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x1c, 0x2a, 0x2a, 0x49, 0x49, 0x00 },	// U+16E3 (ᛣ)
	{ 0x00, 0x49, 0x49, 0x2a, 0x2a, 0x1c, 0x1c, 0x2a, 0x2a, 0x1c, 0x1c, 0x2a, 0x2a, 0x49, 0x49, 0x00 },	// U+16E4 (ᛤ)
	{ 0x00, 0x41, 0x63, 0x55, 0x49, 0x55, 0x63, 0x41, 0x41, 0x63, 0x55, 0x49, 0x55, 0x63, 0x41, 0x00 },	// U+16E5 (ᛥ)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x1c, 0x2a, 0x2a, 0x49, 0x49, 0x00 },	// U+16E6 (ᛦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16E7 (ᛧ)
	{ 0x00, 0x08, 0x1c, 0x2a, 0x49, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x49, 0x2a, 0x1c, 0x08, 0x00 },	// U+16E8 (ᛨ)
	{ 0x00, 0x20, 0x30, 0x28, 0x24, 0x22, 0x24, 0x28, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00 },	// U+16E9 (ᛩ)
	{ 0x00, 0x02, 0x02, 0x07, 0x02, 0x22, 0x32, 0x2a, 0x26, 0x22, 0x20, 0x70, 0x20, 0x20, 0x20, 0x00 },	// U+16EA (ᛪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+16EB (᛫)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00 },	// U+16EC (᛬)
	{ 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x08, 0x6b, 0x7f, 0x6b, 0x08, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+16ED (᛭)
	{ 0x00, 0x08, 0x18, 0x28, 0x48, 0x08, 0x08, 0x0c, 0x0a, 0x09, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+16EE (ᛮ)
	{ 0x00, 0x49, 0x2a, 0x2a, 0x1c, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x1c, 0x2a, 0x2a, 0x49, 0x00 },	// U+16EF (ᛯ)
	{ 0x00, 0x08, 0x08, 0x08, 0x1c, 0x2a, 0x49, 0x49, 0x49, 0x49, 0x49, 0x2a, 0x1c, 0x08, 0x08, 0x00 },	// U+16F0 (ᛰ)
	{ 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x12, 0x2a, 0x26, 0x22, 0x42, 0x42, 0x42, 0x00 },	// U+16F1 (ᛱ)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x11, 0x13, 0x15, 0x19, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 },	// U+16F2 (ᛲ)
	{ 0x00, 0x10, 0x38, 0x54, 0x92, 0x54, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+16F3 (ᛳ)
	{ 0x00, 0x02, 0x02, 0x02, 0x22, 0x62, 0x32, 0x2a, 0x26, 0x23, 0x22, 0x20, 0x20, 0x20, 0x20, 0x00 },	// U+16F4 (ᛴ)
	{ 0x00, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x00, 0x00 },	// U+16F5 (ᛵ)
	{ 0x00, 0x01, 0x01, 0x02, 0x02, 0x44, 0x24, 0x18, 0x08, 0x14, 0x12, 0x21, 0x20, 0x40, 0x40, 0x00 },	// U+16F6 (ᛶ)
	{ 0x00, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x12, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00 },	// U+16F7 (ᛷ)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00 },	// U+16F8 (ᛸ)
}; // 22

static const unsigned char unifont_block100[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x00 },	// U+1762 (ᝢ)
}; // 1

static const unsigned char unifont_block101[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80 },	// U+17BB (ុ)
}; // 1

static const unsigned char unifont_block102[][16] = {
	{ 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+17CB (់)
}; // 1

static const unsigned char unifont_block103[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0c, 0x00, 0x1e, 0x00, 0x0c, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+17D6 (៖)
}; // 1

static const unsigned char unifont_block104[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x04, 0x38, 0x40, 0x48, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+17DC (ៜ)
}; // 1

static const unsigned char unifont_block105[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+17F0 (៰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+17F1 (៱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+17F2 (៲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x5a, 0x91, 0x00, 0x00, 0x00 },	// U+17F3 (៳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+17F4 (៴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+17F5 (៵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+17F6 (៶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x2a, 0x11, 0x00, 0x00, 0x00 },	// U+17F7 (៷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+17F8 (៸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x02, 0x1e, 0x20, 0x18, 0x00, 0x00, 0x00 },	// U+17F9 (៹)
}; // 10

static const unsigned char unifont_block106[][16] = {
	{ 0x18, 0x24, 0x24, 0x1a, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00 },	// U+18B4 (ᢴ)
	{ 0x18, 0x24, 0x24, 0x58, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00 },	// U+18B5 (ᢵ)
	{ 0x18, 0x24, 0x24, 0x1a, 0x04, 0x08, 0x10, 0x20, 0x46, 0x46, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00 },	// U+18B6 (ᢶ)
}; // 3

static const unsigned char unifont_block107[][16] = {
	{ 0x06, 0x09, 0x09, 0x06, 0x00, 0x01, 0x01, 0x01, 0x3d, 0x43, 0x41, 0x41, 0x43, 0x3d, 0x00, 0x00 },	// U+18B8 (ᢸ)
}; // 1

static const unsigned char unifont_block108[][16] = {
	{ 0x06, 0x09, 0x09, 0x06, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+18BA (ᢺ)
}; // 1

static const unsigned char unifont_block109[][16] = {
	{ 0x18, 0x24, 0x24, 0x18, 0x00, 0x20, 0x20, 0x20, 0x38, 0x04, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+18BE (ᢾ)
	{ 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x02, 0x02, 0x02, 0x0e, 0x10, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+18BF (ᢿ)
}; // 2

static const unsigned char unifont_block110[][16] = {
	{ 0x18, 0x24, 0x24, 0x18, 0x00, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00 },	// U+18C3 (ᣃ)
	{ 0x06, 0x09, 0x09, 0x06, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+18C4 (ᣄ)
	{ 0x18, 0x24, 0x24, 0x18, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+18C5 (ᣅ)
}; // 3

static const unsigned char unifont_block111[][16] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x14, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18D4 (ᣔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18D5 (ᣕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18D6 (ᣖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18D7 (ᣗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18D8 (ᣘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18D9 (ᣙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x08, 0x06, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18DA (ᣚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x46, 0x49, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18DB (ᣛ)
	{ 0x00, 0x00, 0x00, 0x10, 0x13, 0x2b, 0x28, 0x44, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18DC (ᣜ)
	{ 0x00, 0x00, 0x00, 0x04, 0x64, 0x6a, 0x0a, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18DD (ᣝ)
	{ 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18DE (ᣞ)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18DF (ᣟ)
}; // 12

static const unsigned char unifont_block112[][16] = {
	{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x90, 0x90, 0xa0, 0xa0, 0xf0, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+18E9 (ᣩ)
}; // 1

static const unsigned char unifont_block113[][16] = {
	{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x40, 0x40, 0x40, 0x40, 0x4c, 0x52, 0x52, 0x42, 0x3c, 0x00, 0x00 },	// U+18EB (ᣫ)
}; // 1

static const unsigned char unifont_block114[][16] = {
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18F3 (ᣳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18F4 (ᣴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+18F5 (ᣵ)
}; // 3

static const unsigned char unifont_block115[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2a, 0x24, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+1950 (ᥐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2a, 0x24, 0x20, 0x38, 0x24, 0x38, 0x00, 0x00, 0x00 },	// U+1951 (ᥑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1952 (ᥒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x6a, 0x58, 0x48, 0x48, 0x68, 0x58, 0x00, 0x00, 0x00 },	// U+1953 (ᥓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x4a, 0x48, 0x48, 0x48, 0x68, 0x58, 0x00, 0x00, 0x00 },	// U+1954 (ᥔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x6a, 0x54, 0x00, 0x00, 0x00 },	// U+1955 (ᥕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0x5b, 0x49, 0x49, 0x49, 0x4d, 0x4b, 0x00, 0x00, 0x00 },	// U+1956 (ᥖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0x5b, 0x49, 0x49, 0x49, 0x6d, 0x5b, 0x00, 0x00, 0x00 },	// U+1957 (ᥗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x42, 0x6a, 0x54, 0x00, 0x00, 0x00 },	// U+1958 (ᥘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+1959 (ᥙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x59, 0x49, 0x49, 0x49, 0x6d, 0x5b, 0x00, 0x00, 0x00 },	// U+195A (ᥚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+195B (ᥛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x59, 0x49, 0x49, 0x49, 0x6d, 0x5b, 0x40, 0x20, 0x10 },	// U+195C (ᥜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+195D (ᥝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0x5b, 0x49, 0x49, 0x49, 0x4d, 0x4b, 0x08, 0x04, 0x02 },	// U+195E (ᥞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0x5a, 0x48, 0x48, 0x48, 0x48, 0x48, 0x08, 0x04, 0x02 },	// U+195F (ᥟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2a, 0x24, 0x20, 0x38, 0x24, 0x38, 0x20, 0x10, 0x08 },	// U+1960 (ᥠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x4a, 0x48, 0x48, 0x48, 0x68, 0x58, 0x40, 0x20, 0x10 },	// U+1961 (ᥡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x42, 0x00, 0x00, 0x00 },	// U+1962 (ᥢ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1963 (ᥣ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x2c, 0x34, 0x00, 0x00, 0x00 },	// U+1964 (ᥤ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1965 (ᥥ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x20, 0x20, 0x38 },	// U+1966 (ᥦ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x3c, 0x00 },	// U+1967 (ᥧ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+1968 (ᥨ)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00 },	// U+1969 (ᥩ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x2c, 0x34, 0x04, 0x04, 0x1c },	// U+196A (ᥪ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x04, 0x04, 0x1c },	// U+196B (ᥫ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+196C (ᥬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x4a, 0x48, 0x48, 0x48, 0x68, 0x58, 0x08, 0x04, 0x02 },	// U+196D (ᥭ)
}; // 30

static const unsigned char unifont_block116[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x12, 0x12, 0x52, 0x21, 0x00, 0x00, 0x00 },	// U+1970 (ᥰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1971 (ᥱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x24, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+1972 (ᥲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x24, 0x54, 0x54, 0x64, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+1973 (ᥳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1974 (ᥴ)
}; // 5

static const unsigned char unifont_block117[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x58, 0x24, 0x58, 0x40, 0x40, 0x42, 0x3c, 0x00 },	// U+1983 (ᦃ)
}; // 1

static const unsigned char unifont_block118[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x82, 0x8c, 0x82, 0xa2, 0x9c, 0x80, 0x80, 0x44, 0x38, 0x00 },	// U+198F (ᦏ)
}; // 1

static const unsigned char unifont_block119[][16] = {
	{ 0x78, 0x84, 0x02, 0x02, 0x72, 0x8a, 0x82, 0x62, 0x82, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1991 (ᦑ)
}; // 1

static const unsigned char unifont_block120[][16] = {
	{ 0x7c, 0x02, 0xfc, 0x80, 0x9c, 0xa2, 0x82, 0x8c, 0x82, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+199A (ᦚ)
}; // 1

static const unsigned char unifont_block121[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+199E (ᦞ)
}; // 1

static const unsigned char unifont_block122[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x40, 0x20, 0x18, 0x20, 0x40, 0x42, 0x3c, 0x00 },	// U+19A1 (ᦡ)
}; // 1

static const unsigned char unifont_block123[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x42, 0x44, 0x88, 0x8a, 0x84, 0x40, 0x40, 0x20, 0x00, 0x00 },	// U+19A3 (ᦣ)
	{ 0x00, 0x18, 0x24, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x40, 0x20, 0x18, 0x20, 0x40, 0x42, 0x3c, 0x00 },	// U+19A4 (ᦤ)
}; // 2

static const unsigned char unifont_block124[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x5c, 0x22, 0x5c, 0x00, 0x3c, 0x42, 0x42, 0x3c },	// U+19A7 (ᦧ)
}; // 1

static const unsigned char unifont_block125[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x92, 0x64, 0x00, 0x0c, 0x92, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19B0 (ᦰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x40, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19B1 (ᦱ)
	{ 0x38, 0x44, 0x82, 0x82, 0x82, 0xba, 0xc6, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19B2 (ᦲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x40, 0x22, 0x1e, 0x02, 0x02, 0x42, 0x3c, 0x00 },	// U+19B3 (ᦳ)
}; // 4

static const unsigned char unifont_block126[][16] = {
	{ 0x1c, 0x22, 0x02, 0x04, 0x18, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19B7 (ᦷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x28, 0x10, 0x28, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19B8 (ᦸ)
	{ 0x38, 0x54, 0x92, 0x92, 0x92, 0xba, 0xc6, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19B9 (ᦹ)
	{ 0x3c, 0x42, 0x40, 0x40, 0x78, 0x44, 0x02, 0x02, 0x02, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19BA (ᦺ)
}; // 4

static const unsigned char unifont_block127[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0xc4, 0xb8, 0x80, 0xb0, 0x48, 0x30, 0x00 },	// U+19C1 (ᧁ)
}; // 1

static const unsigned char unifont_block128[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x40, 0x20, 0x18, 0x20, 0x4c, 0x52, 0x3c, 0x00 },	// U+19C6 (ᧆ)
}; // 1

static const unsigned char unifont_block129[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x02, 0x3a, 0x46, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19C8 (ᧈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x46, 0x3a, 0x02, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19C9 (ᧉ)
}; // 2

static const unsigned char unifont_block130[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19D0 (᧐)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x40, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19D1 (᧑)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x22, 0x1c, 0x00 },	// U+19D2 (᧒)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x80, 0x80, 0x80, 0x42, 0x3c, 0x08, 0x10, 0x20, 0x40, 0x00 },	// U+19D3 (᧓)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x02, 0x02, 0x02, 0x84, 0x78, 0x20, 0x10, 0x08, 0x04, 0x00 },	// U+19D4 (᧔)
}; // 5

static const unsigned char unifont_block131[][16] = {
	{ 0x00, 0x3c, 0x42, 0x02, 0x22, 0x52, 0x12, 0x22, 0x42, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19D6 (᧖)
}; // 1

static const unsigned char unifont_block132[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x42, 0x42, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+19D8 (᧘)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x92, 0x62, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00 },	// U+19D9 (᧙)
}; // 2

static const unsigned char unifont_block133[][16] = {
	{ 0x00, 0x28, 0x54, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1AB0 (᪰)
	{ 0x00, 0x10, 0x28, 0xaa, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1AB1 (᪱)
	{ 0x00, 0x6c, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1AB2 (᪲)
	{ 0x00, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1AB3 (᪳)
	{ 0x00, 0x00, 0x10, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1AB4 (᪴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x44, 0xaa },	// U+1AB5 (᪵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xaa },	// U+1AB6 (᪶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20 },	// U+1AB7 (᪷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x48 },	// U+1AB8 (᪸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x01 },	// U+1AB9 (᪹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x03 },	// U+1ABA (᪺)
	{ 0x00, 0x00, 0x42, 0x81, 0x81, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1ABB (᪻)
	{ 0x00, 0x24, 0xc3, 0xc3, 0xc3, 0xc3, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1ABC (᪼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x81, 0x81, 0x42 },	// U+1ABD (᪽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x81, 0x81, 0x42, 0x00, 0x00 },	// U+1ABE (᪾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x14 },	// U+1ABF (ᪿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a },	// U+1AC0 (ᫀ)
}; // 17

static const unsigned char unifont_block134[][16] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1C50 (᱐)
	{ 0x00, 0x00, 0x00, 0x46, 0x4a, 0x52, 0x62, 0x02, 0x02, 0x02, 0x02, 0x04, 0x08, 0x70, 0x00, 0x00 },	// U+1C51 (᱑)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x28, 0x10, 0x08, 0x04, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+1C52 (᱒)
	{ 0x00, 0x00, 0x00, 0x4c, 0x52, 0x52, 0x7c, 0x08, 0x04, 0x04, 0x02, 0x02, 0x0c, 0x30, 0x00, 0x00 },	// U+1C53 (᱓)
	{ 0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x02, 0x02, 0x06, 0x4a, 0x72, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+1C54 (᱔)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x62, 0x12, 0x0a, 0x0a, 0x12, 0x62, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+1C55 (᱕)
	{ 0x00, 0x00, 0x00, 0x3a, 0x44, 0x4a, 0x32, 0x02, 0x02, 0x02, 0x02, 0x04, 0x08, 0x30, 0x00, 0x00 },	// U+1C56 (᱖)
	{ 0x00, 0x00, 0x00, 0x30, 0x4a, 0x4c, 0x20, 0x10, 0x08, 0x04, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+1C57 (᱗)
	{ 0x00, 0x00, 0x00, 0x2c, 0x52, 0x5a, 0x26, 0x02, 0x02, 0x02, 0x02, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+1C58 (᱘)
	{ 0x00, 0x00, 0x00, 0x38, 0x04, 0x02, 0x02, 0x02, 0x32, 0x4a, 0x4a, 0x52, 0x24, 0x18, 0x00, 0x00 },	// U+1C59 (᱙)
	{ 0x00, 0x00, 0x00, 0x38, 0x44, 0x66, 0x50, 0x48, 0x44, 0x42, 0x42, 0x42, 0x44, 0x38, 0x00, 0x00 },	// U+1C5A (ᱚ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1C5B (ᱛ)
	{ 0x00, 0x00, 0x00, 0x38, 0x44, 0x02, 0x02, 0x72, 0x0a, 0x0a, 0x72, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+1C5C (ᱜ)
	{ 0x00, 0x00, 0x00, 0x38, 0x44, 0x22, 0x12, 0x08, 0x64, 0x08, 0x12, 0x22, 0x44, 0x38, 0x00, 0x00 },	// U+1C5D (ᱝ)
	{ 0x00, 0x00, 0x00, 0x12, 0x2a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x2a, 0x12, 0x02, 0x00, 0x00 },	// U+1C5E (ᱞ)
	{ 0x00, 0x00, 0x00, 0x24, 0x5a, 0x5b, 0x48, 0x4c, 0x4a, 0x4a, 0x49, 0x45, 0x25, 0x12, 0x00, 0x00 },	// U+1C5F (ᱟ)
	{ 0x00, 0x00, 0x00, 0x02, 0x12, 0x2a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x44, 0x28, 0x10, 0x00, 0x00 },	// U+1C60 (ᱠ)
	{ 0x00, 0x00, 0x00, 0x12, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x2a, 0x12, 0x00, 0x00 },	// U+1C61 (ᱡ)
	{ 0x00, 0x00, 0x00, 0x48, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x54, 0x48, 0x00, 0x00 },	// U+1C62 (ᱢ)
	{ 0x00, 0x00, 0x00, 0x26, 0x49, 0x51, 0x50, 0x50, 0x48, 0x47, 0x41, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+1C63 (ᱣ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x60, 0x50, 0x50, 0x48, 0x48, 0x44, 0x44, 0x42, 0x42, 0x00, 0x00 },	// U+1C64 (ᱤ)
	{ 0x00, 0x00, 0x00, 0x42, 0x42, 0x22, 0x22, 0x12, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x38, 0x00, 0x00 },	// U+1C65 (ᱥ)
	{ 0x00, 0x00, 0x00, 0x22, 0x22, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x49, 0x55, 0x22, 0x00, 0x00 },	// U+1C66 (ᱦ)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x42, 0x42, 0x42, 0x42, 0x62, 0x54, 0x48, 0x40, 0x00, 0x00 },	// U+1C67 (ᱧ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x20, 0x40, 0x42, 0x44, 0x48, 0x50, 0x60, 0x44, 0x4a, 0x31, 0x00, 0x00 },	// U+1C68 (ᱨ)
	{ 0x00, 0x00, 0x00, 0x02, 0x12, 0x2a, 0x46, 0x42, 0x40, 0x40, 0x42, 0x44, 0x28, 0x10, 0x00, 0x00 },	// U+1C69 (ᱩ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x5d, 0x41, 0x3e, 0x00, 0x00 },	// U+1C6A (ᱪ)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x41, 0x49, 0x2a, 0x08, 0x0e, 0x02, 0x22, 0x1c, 0x00, 0x00 },	// U+1C6B (ᱫ)
	{ 0x00, 0x00, 0x00, 0x22, 0x55, 0x49, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x22, 0x22, 0x00, 0x00 },	// U+1C6C (ᱬ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x21, 0x21, 0x31, 0x09, 0x05, 0x05, 0x45, 0x49, 0x32, 0x00, 0x00 },	// U+1C6D (ᱭ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x42, 0x3c, 0x00, 0x00 },	// U+1C6E (ᱮ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x46, 0x25, 0x25, 0x24, 0x24, 0x24, 0xa4, 0xa4, 0x62, 0x3c, 0x00, 0x00 },	// U+1C6F (ᱯ)
	{ 0x00, 0x00, 0x00, 0x1a, 0x29, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x4a, 0x2c, 0x00, 0x00 },	// U+1C70 (ᱰ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x63, 0x22, 0x22, 0x12, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x38, 0x00, 0x00 },	// U+1C71 (ᱱ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x60, 0x50, 0x50, 0x48, 0x48, 0x44, 0x44, 0xc3, 0x7e, 0x00, 0x00 },	// U+1C72 (ᱲ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x70, 0x48, 0x48, 0x48, 0x70, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+1C73 (ᱳ)
	{ 0x00, 0x00, 0x00, 0x12, 0x2a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x12, 0x00, 0x00 },	// U+1C74 (ᱴ)
	{ 0x00, 0x00, 0x00, 0x2c, 0x4a, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x29, 0x1a, 0x00, 0x00 },	// U+1C75 (ᱵ)
	{ 0x00, 0x00, 0x00, 0x46, 0x49, 0x11, 0x10, 0x50, 0x48, 0x47, 0x41, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+1C76 (ᱶ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x44, 0x48, 0x72, 0x41, 0x41, 0x41, 0x49, 0x55, 0x22, 0x00, 0x00 },	// U+1C77 (ᱷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1C78 (ᱸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+1C79 (ᱹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+1C7A (ᱺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x49, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1C7B (ᱻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1C7C (ᱼ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x22, 0x24, 0x38, 0x20, 0x20, 0x20, 0x22, 0x14, 0x08, 0x00, 0x00 },	// U+1C7D (ᱽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+1C7E (᱾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+1C7F (᱿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x54, 0x52, 0x22, 0x02, 0x22, 0x52, 0x54, 0x38, 0x00, 0x00 },	// U+1C80 (ᲀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfe, 0x82, 0x82 },	// U+1C81 (ᲁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1C82 (ᲂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x02, 0x02, 0x02, 0x02, 0x44, 0x38, 0x00, 0x00 },	// U+1C83 (ᲃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x4c, 0x72, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+1C84 (ᲄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+1C85 (ᲅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x48, 0x48, 0x38, 0x00, 0x00 },	// U+1C86 (ᲆ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x44, 0x44, 0x44, 0x3c, 0x00, 0x00 },	// U+1C87 (ᲇ)
	{ 0x00, 0x00, 0x00, 0x22, 0x52, 0x54, 0x14, 0x08, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1C88 (ᲈ)
}; // 57

static const unsigned char unifont_block135[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x20, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1C90 (Ა)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1c, 0x10, 0x10, 0x2c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1C91 (Ბ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x10, 0x10, 0x2c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1C92 (Გ)
	{ 0x00, 0x00, 0x00, 0x00, 0x34, 0x4a, 0x4a, 0x4a, 0x4a, 0x32, 0x02, 0x04, 0x38, 0x46, 0x00, 0x00 },	// U+1C93 (Დ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x44, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1C94 (Ე)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x38, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1C95 (Ვ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x2a, 0x1c, 0x38, 0x48, 0x48, 0x48, 0x30, 0x00, 0x00 },	// U+1C96 (Ზ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2c, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x4c, 0x00, 0x00 },	// U+1C97 (Თ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x00, 0x00 },	// U+1C98 (Ი)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x40, 0x40, 0x38, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1C99 (Კ)
	{ 0x00, 0x00, 0x00, 0x00, 0x54, 0xaa, 0xaa, 0xaa, 0x82, 0x82, 0x42, 0x04, 0x78, 0x86, 0x00, 0x00 },	// U+1C9A (Ლ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1C9B (Მ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x3c, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1C9C (Ნ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x2a, 0x2a, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x24, 0x00, 0x00 },	// U+1C9D (Ო)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x18, 0x20, 0x40, 0x40, 0x38, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1C9E (Პ)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x50, 0x4a, 0x4a, 0x44, 0x40, 0x48, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+1C9F (Ჟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x1c, 0x02, 0x16, 0x2a, 0x2a, 0x2a, 0x2a, 0x22, 0x24, 0x00, 0x00 },	// U+1CA0 (Რ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x12, 0x0a, 0x12, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1CA1 (Ს)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x66, 0x66, 0x5a, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CA2 (Ტ)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x48, 0x48, 0x40, 0x40, 0x40, 0x40, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+1CA3 (Უ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2c, 0x52, 0x52, 0x52, 0x52, 0x2c, 0x40, 0x48, 0x44, 0x38, 0x00, 0x00 },	// U+1CA4 (Ფ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x20, 0x20, 0x38, 0x24, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00 },	// U+1CA5 (Ქ)
	{ 0x00, 0x00, 0x00, 0x00, 0x34, 0x4a, 0x4a, 0x4a, 0x42, 0x22, 0x02, 0x04, 0x38, 0x46, 0x00, 0x00 },	// U+1CA6 (Ღ)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x42, 0x42, 0x64, 0x58, 0x40, 0x44, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CA7 (Ყ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x2a, 0x20, 0x20, 0x38, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+1CA8 (Შ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x1e, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1CA9 (Ჩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x42, 0x42, 0x42, 0x3a, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CAA (Ც)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CAB (Ძ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x2a, 0x2a, 0x02, 0x3e, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+1CAC (Წ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x10, 0x98, 0x64, 0xb8, 0x20, 0x22, 0x1c, 0x00, 0x00 },	// U+1CAD (Ჭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x12, 0x0a, 0x1e, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1CAE (Ხ)
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x45, 0x45, 0x24, 0x28, 0x18, 0x0c, 0x52, 0x54, 0x23, 0x00, 0x00 },	// U+1CAF (Ჯ)
	{ 0x00, 0x00, 0x08, 0x30, 0x40, 0x48, 0x30, 0x40, 0x48, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CB0 (Ჰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x13, 0x65, 0x85, 0x95, 0x65, 0x83, 0x49, 0x31, 0x22, 0x1c, 0x00, 0x00 },	// U+1CB1 (Ჱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x24, 0x42, 0x00, 0x00 },	// U+1CB2 (Ჲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x40, 0x20, 0x10, 0x38, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CB3 (Ჳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x30, 0x40, 0x40, 0x38, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CB4 (Ჴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x7c, 0x20, 0x7c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1CB5 (Ჵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x1c, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+1CB6 (Ჶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x20, 0x10, 0x08, 0x04, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CB7 (Ჷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x42, 0x42, 0x42, 0x26, 0x1a, 0x02, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+1CB8 (Ჸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x48, 0x48, 0x30, 0x00, 0x00 },	// U+1CB9 (Ჹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x0c, 0x30, 0x38, 0x44, 0x02, 0x00, 0x00 },	// U+1CBA (Ჺ)
}; // 43

static const unsigned char unifont_block136[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x04, 0x08, 0x10, 0x20, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CBD (Ჽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x24, 0x24, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CBE (Ჾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1CBF (Ჿ)
}; // 3

static const unsigned char unifont_block137[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+1D00 (ᴀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x14, 0x12, 0x7e, 0x12, 0x12, 0x12, 0x72, 0x00, 0x00 },	// U+1D01 (ᴁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x90, 0x90, 0x7e, 0x12, 0x92, 0x7c, 0x00, 0x00 },	// U+1D02 (ᴂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x12, 0x7f, 0x12, 0x22, 0x22, 0x1e, 0x00, 0x00 },	// U+1D03 (ᴃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1D04 (ᴄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00 },	// U+1D05 (ᴅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x27, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00 },	// U+1D06 (ᴆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00 },	// U+1D07 (ᴇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x38, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+1D08 (ᴈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x08, 0x08 },	// U+1D09 (ᴉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00 },	// U+1D0A (ᴊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x24, 0x14, 0x0c, 0x0c, 0x14, 0x24, 0x44, 0x00, 0x00 },	// U+1D0B (ᴋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x06, 0x04, 0x7c, 0x00, 0x00 },	// U+1D0C (ᴌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x6c, 0x6c, 0x54, 0x54, 0x44, 0x44, 0x00, 0x00 },	// U+1D0D (ᴍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x22, 0x00, 0x00 },	// U+1D0E (ᴎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1D0F (ᴏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+1D10 (ᴐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00 },	// U+1D11 (ᴑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x44, 0x00, 0x00 },	// U+1D12 (ᴒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0x8a, 0x92, 0x92, 0xa2, 0x7c, 0x40, 0x00 },	// U+1D13 (ᴓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x90, 0x90, 0x9e, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1D14 (ᴔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1D15 (ᴕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D16 (ᴖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1D17 (ᴗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1D18 (ᴘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x7c, 0x48, 0x44, 0x42, 0x42, 0x00, 0x00 },	// U+1D19 (ᴙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x44, 0x48, 0x7c, 0x42, 0x42, 0x7c, 0x00, 0x00 },	// U+1D1A (ᴚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1D1B (ᴛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1D1C (ᴜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x40, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00 },	// U+1D1D (ᴝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x42, 0x80, 0x80, 0x82, 0x78, 0x00, 0x00 },	// U+1D1E (ᴞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x7e, 0x00, 0x00 },	// U+1D1F (ᴟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+1D20 (ᴠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+1D21 (ᴡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+1D22 (ᴢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x38, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+1D23 (ᴣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x38, 0x1c, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1D24 (ᴤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x49, 0x36, 0x00, 0x00 },	// U+1D25 (ᴥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1D26 (ᴦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00, 0x00 },	// U+1D27 (ᴧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+1D28 (ᴨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1D29 (ᴩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1D2A (ᴪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x48, 0x48, 0x44, 0x46, 0x00, 0x00 },	// U+1D2B (ᴫ)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D2C (ᴬ)
	{ 0x00, 0x00, 0x00, 0x78, 0x14, 0x12, 0x7e, 0x12, 0x12, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D2D (ᴭ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D2E (ᴮ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x22, 0x12, 0x7f, 0x12, 0x22, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D2F (ᴯ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D30 (ᴰ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D31 (ᴱ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D32 (ᴲ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x72, 0x42, 0x62, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D33 (ᴳ)
	{ 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D34 (ᴴ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D35 (ᴵ)
	{ 0x00, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D36 (ᴶ)
	{ 0x00, 0x00, 0x00, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D37 (ᴷ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D38 (ᴸ)
	{ 0x00, 0x00, 0x00, 0x44, 0x6c, 0x6c, 0x54, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D39 (ᴹ)
	{ 0x00, 0x00, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D3A (ᴺ)
	{ 0x00, 0x00, 0x00, 0x22, 0x32, 0x32, 0x2a, 0x26, 0x26, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D3B (ᴻ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D3C (ᴼ)
	{ 0x00, 0x00, 0x00, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D3D (ᴽ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D3E (ᴾ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D3F (ᴿ)
	{ 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D40 (ᵀ)
	{ 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D41 (ᵁ)
	{ 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x2a, 0x36, 0x36, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D42 (ᵂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x3c, 0x22, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D43 (ᵃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x1e, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D44 (ᵄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x62, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D45 (ᵅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x48, 0x3f, 0x09, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D46 (ᵆ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D47 (ᵇ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D48 (ᵈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D49 (ᵉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x3e, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D4A (ᵊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1c, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D4B (ᵋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x1c, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D4C (ᵌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x22, 0x22, 0x3c, 0x20, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D4D (ᵍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x18, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+1D4E (ᵎ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D4F (ᵏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D50 (ᵐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x52, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D51 (ᵑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D52 (ᵒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D53 (ᵓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D54 (ᵔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D55 (ᵕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+1D56 (ᵖ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D57 (ᵗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D58 (ᵘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D59 (ᵙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D5A (ᵚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D5B (ᵛ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x7f, 0x7f, 0x3e, 0x1c, 0x49, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D5C (ᵜ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x42, 0x46, 0x3a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D5D (ᵝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x4a, 0x28, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D5E (ᵞ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x02, 0x1c, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D5F (ᵟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+1D60 (ᵠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x48, 0x28, 0x18, 0x0c, 0x12, 0x61, 0x00, 0x00, 0x00, 0x00 },	// U+1D61 (ᵡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x3e, 0x00 },	// U+1D62 (ᵢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x02, 0x02, 0x02, 0x00 },	// U+1D63 (ᵣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00 },	// U+1D64 (ᵤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x00 },	// U+1D65 (ᵥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x42, 0x46, 0x3a, 0x02 },	// U+1D66 (ᵦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x4a, 0x30, 0x08, 0x04, 0x04 },	// U+1D67 (ᵧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x1e, 0x02, 0x0c, 0x10 },	// U+1D68 (ᵨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x92, 0x92, 0x92, 0x7c, 0x10 },	// U+1D69 (ᵩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x48, 0x28, 0x18, 0x0c, 0x12 },	// U+1D6A (ᵪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x91, 0x91, 0xf1, 0x11, 0x11, 0x99, 0x76, 0x00, 0x00 },	// U+1D6B (ᵫ)
	{ 0x00, 0x00, 0x00, 0x04, 0x14, 0x0e, 0x35, 0x4c, 0x44, 0x44, 0x44, 0x44, 0x4c, 0x34, 0x00, 0x00 },	// U+1D6C (ᵬ)
	{ 0x00, 0x00, 0x00, 0xa0, 0x70, 0x28, 0x2c, 0x32, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+1D6D (ᵭ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x28, 0x1c, 0x0a, 0x08, 0x00, 0x00 },	// U+1D6E (ᵮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x52, 0x52, 0x52, 0xde, 0x73, 0x52, 0x52, 0x00, 0x00 },	// U+1D6F (ᵯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x44, 0x44, 0xcc, 0x76, 0x44, 0x44, 0x00, 0x00 },	// U+1D70 (ᵰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x44, 0xcc, 0x76, 0x44, 0x4c, 0x34, 0x04, 0x04 },	// U+1D71 (ᵱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x04, 0x04, 0x9c, 0x66, 0x05, 0x04, 0x00, 0x00 },	// U+1D72 (ᵲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x08, 0x9c, 0x6a, 0x08, 0x08, 0x00, 0x00 },	// U+1D73 (ᵳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0xcc, 0x33, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+1D74 (ᵴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x4c, 0x3a, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1D75 (ᵵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x56, 0x39, 0x08, 0x04, 0x7e, 0x00, 0x00 },	// U+1D76 (ᵶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x3c, 0x20, 0x38, 0x44, 0x44, 0x44, 0x3a, 0x02 },	// U+1D77 (ᵷ)
	{ 0x00, 0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D78 (ᵸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x08, 0x08, 0x10, 0x3c, 0x42, 0x42, 0x3c },	// U+1D79 (ᵹ)
}; // 122

static const unsigned char unifont_block138[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+1D7B (ᵻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1D7C (ᵼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x44, 0x44, 0xfe, 0x44, 0x4c, 0x34, 0x04, 0x04 },	// U+1D7D (ᵽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+1D7E (ᵾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0xff, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+1D7F (ᵿ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0xc6, 0xba, 0x80, 0x60 },	// U+1D80 (ᶀ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0xdc, 0x80, 0x60 },	// U+1D81 (ᶁ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x18, 0x18, 0x10, 0x0c },	// U+1D82 (ᶂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x22, 0x22, 0x22, 0x22, 0xe2, 0xbc, 0xa0, 0xa1, 0x5e },	// U+1D83 (ᶃ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x62, 0x42, 0x40, 0x30 },	// U+1D84 (ᶄ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x40, 0x30 },	// U+1D85 (ᶅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x52, 0x52, 0x52, 0x52, 0x52, 0xd2, 0xd2, 0x80, 0x60 },	// U+1D86 (ᶆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0xc2, 0xc2, 0x80, 0x60 },	// U+1D87 (ᶇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x66, 0x5a, 0x42, 0x32 },	// U+1D88 (ᶈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x44, 0x04, 0x04, 0x04, 0x0c, 0x0c, 0x08, 0x06 },	// U+1D89 (ᶉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0xc2, 0xbc, 0x80, 0x60 },	// U+1D8A (ᶊ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x48, 0x48, 0x46, 0x30 },	// U+1D8B (ᶋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x24, 0x64, 0x58, 0x58, 0x40, 0x30 },	// U+1D8C (ᶌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x14, 0x62, 0x62, 0x40, 0x30 },	// U+1D8D (ᶍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x40, 0x30 },	// U+1D8E (ᶎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x3c, 0x22, 0x22, 0x72, 0x4c, 0x40, 0xc0 },	// U+1D8F (ᶏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x32, 0x22, 0x22, 0x22, 0x22, 0x32, 0x6c, 0x40, 0xc0 },	// U+1D90 (ᶐ)
	{ 0x00, 0x00, 0xc0, 0x20, 0x20, 0x20, 0x2c, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0xc0 },	// U+1D91 (ᶑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x20, 0xc0 },	// U+1D92 (ᶒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x20, 0xc0 },	// U+1D93 (ᶓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x3c, 0x40, 0x40, 0x42, 0x3e, 0x02, 0x0c },	// U+1D94 (ᶔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x10, 0x7f, 0x51, 0x51, 0x4e, 0x40, 0xc0 },	// U+1D95 (ᶕ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x3c, 0x20, 0xc0 },	// U+1D96 (ᶖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x3e, 0x02, 0x0c },	// U+1D97 (ᶗ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06, 0x02, 0x0c },	// U+1D98 (ᶘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x32, 0x6c, 0x40, 0xc0 },	// U+1D99 (ᶙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x08, 0x38, 0x40, 0x40, 0x3c, 0x04, 0x18 },	// U+1D9A (ᶚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x46, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D9B (ᶛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x02, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D9C (ᶜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x1a, 0x26, 0x1c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D9D (ᶝ)
	{ 0x00, 0x00, 0x26, 0x18, 0x14, 0x20, 0x3c, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D9E (ᶞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x1c, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D9F (ᶟ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DA0 (ᶠ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DA1 (ᶡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x62, 0x5c, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+1DA2 (ᶢ)
	{ 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DA3 (ᶣ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x1c, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DA4 (ᶤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DA5 (ᶥ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DA6 (ᶦ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DA7 (ᶧ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x1c, 0x32, 0x4c, 0x00, 0x00, 0x00, 0x00 },	// U+1DA8 (ᶨ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+1DA9 (ᶩ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x18, 0x18, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+1DAA (ᶪ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DAB (ᶫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x80, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+1DAC (ᶬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0xec, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+1DAD (ᶭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x44, 0x44, 0x44, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+1DAE (ᶮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+1DAF (ᶯ)
	{ 0x00, 0x00, 0x00, 0x44, 0x4c, 0x4c, 0x54, 0x64, 0x64, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DB0 (ᶰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DB1 (ᶱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DB2 (ᶲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x1c, 0x20, 0x1e, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+1DB3 (ᶳ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DB4 (ᶴ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x70, 0x40, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+1DB5 (ᶵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0xfe, 0x64, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DB6 (ᶶ)
	{ 0x00, 0x00, 0x00, 0x42, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DB7 (ᶷ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DB8 (ᶸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DB9 (ᶹ)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x14, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DBA (ᶺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DBB (ᶻ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x20, 0x10, 0x08, 0x04, 0x22, 0x3e, 0x20, 0xc0, 0x00, 0x00, 0x00, 0x00 },	// U+1DBC (ᶼ)
	{ 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x18, 0x64, 0x92, 0x7e, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+1DBD (ᶽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x08, 0x3c, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+1DBE (ᶾ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x7e, 0x42, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DBF (ᶿ)
	{ 0x24, 0x08, 0x10, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DC0 (᷀)
	{ 0x24, 0x10, 0x08, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DC1 (᷁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1c, 0x38, 0x70 },	// U+1DC2 (᷂)
	{ 0x00, 0x40, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DC3 (᷃)
	{ 0x00, 0x40, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DC4 (᷄)
	{ 0x00, 0x02, 0x04, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DC5 (᷅)
	{ 0x00, 0x1e, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DC6 (᷆)
	{ 0x00, 0x3c, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DC7 (᷇)
	{ 0x00, 0x11, 0x2a, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DC8 (᷈)
	{ 0x00, 0x44, 0x2a, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DC9 (᷉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x0c, 0x04, 0x04 },	// U+1DCA (᷊)
	{ 0x00, 0x71, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DCB (᷋)
	{ 0x00, 0x47, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DCC (᷌)
}; // 82

static const unsigned char unifont_block139[][16] = {
	{ 0x00, 0x0c, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DCE (᷎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x1c, 0x10, 0x08 },	// U+1DCF (᷏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xfc },	// U+1DD0 (᷐)
	{ 0x00, 0x26, 0x49, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DD1 (᷑)
	{ 0x00, 0x18, 0x24, 0x28, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DD2 (᷒)
	{ 0x00, 0x49, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DD3 (ᷓ)
	{ 0x37, 0x48, 0x3e, 0x09, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DD4 (ᷔ)
	{ 0x37, 0x48, 0x4e, 0x49, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DD5 (ᷕ)
	{ 0x87, 0x88, 0x5e, 0x59, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DD6 (ᷖ)
	{ 0x38, 0x04, 0x04, 0x04, 0x38, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DD7 (ᷗ)
	{ 0x0c, 0x10, 0x38, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DD8 (ᷘ)
	{ 0x14, 0x08, 0x14, 0x38, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DD9 (ᷙ)
	{ 0x38, 0x24, 0x38, 0x20, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DDA (ᷚ)
	{ 0x38, 0x04, 0x34, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DDB (ᷛ)
	{ 0x04, 0x24, 0x14, 0x2c, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DDC (ᷜ)
	{ 0x18, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DDD (ᷝ)
	{ 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DDE (ᷞ)
	{ 0x22, 0x36, 0x2a, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DDF (ᷟ)
	{ 0x1a, 0x26, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DE0 (ᷠ)
	{ 0x22, 0x26, 0x2a, 0x32, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DE1 (ᷡ)
	{ 0x1c, 0x24, 0x1c, 0x14, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DE2 (ᷢ)
	{ 0x18, 0x24, 0x20, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DE3 (ᷣ)
	{ 0x38, 0x04, 0x18, 0x20, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DE4 (ᷤ)
	{ 0x18, 0x24, 0x04, 0x06, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DE5 (ᷥ)
	{ 0x3c, 0x20, 0x18, 0x04, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DE6 (ᷦ)
	{ 0x00, 0x38, 0x24, 0x24, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DE7 (ᷧ)
	{ 0x08, 0x38, 0x48, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DE8 (ᷨ)
	{ 0x18, 0x24, 0x14, 0x24, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DE9 (ᷩ)
	{ 0x1c, 0x20, 0x3c, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DEA (ᷪ)
	{ 0x30, 0x08, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DEB (ᷫ)
	{ 0x08, 0x1c, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DEC (ᷬ)
	{ 0x00, 0x18, 0x24, 0x24, 0x1a, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DED (ᷭ)
	{ 0x1c, 0x24, 0x1c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DEE (ᷮ)
	{ 0x30, 0x08, 0x08, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DEF (ᷯ)
	{ 0x00, 0x24, 0x24, 0x3a, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DF0 (ᷰ)
	{ 0x00, 0x49, 0x2a, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DF1 (ᷱ)
	{ 0x28, 0x00, 0x38, 0x24, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DF2 (ᷲ)
	{ 0x14, 0x00, 0x18, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DF3 (ᷳ)
	{ 0x14, 0x00, 0x14, 0x14, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DF4 (ᷴ)
	{ 0x00, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DF5 (᷵)
	{ 0x00, 0x48, 0x48, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DF6 (᷶)
	{ 0x00, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DF7 (᷷)
	{ 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DF8 (᷸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x3e },	// U+1DF9 (᷹)
}; // 44

static const unsigned char unifont_block140[][16] = {
	{ 0x92, 0x92, 0x49, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DFB (᷻)
}; // 1

static const unsigned char unifont_block141[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x4c, 0x32 },	// U+1DFD (᷽)
	{ 0x10, 0x08, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1DFE (᷾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x24, 0x02 },	// U+1DFF (᷿)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x18, 0x24, 0x18 },	// U+1E00 (Ḁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x62, 0x5c, 0x18, 0x24, 0x18 },	// U+1E01 (ḁ)
	{ 0x00, 0x08, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+1E02 (Ḃ)
	{ 0x00, 0x00, 0x00, 0x12, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00 },	// U+1E03 (ḃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x08 },	// U+1E04 (Ḅ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x10 },	// U+1E05 (ḅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x3c },	// U+1E06 (Ḇ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x3c },	// U+1E07 (ḇ)
	{ 0x10, 0x08, 0x04, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x10, 0x0c },	// U+1E08 (Ḉ)
	{ 0x00, 0x00, 0x10, 0x08, 0x04, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x10, 0x0c },	// U+1E09 (ḉ)
	{ 0x00, 0x08, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+1E0A (Ḋ)
	{ 0x00, 0x00, 0x00, 0x48, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1E0B (ḋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x08 },	// U+1E0C (Ḍ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x08 },	// U+1E0D (ḍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x3c },	// U+1E0E (Ḏ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x3c },	// U+1E0F (ḏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x08, 0x04 },	// U+1E10 (Ḑ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x10, 0x08 },	// U+1E11 (ḑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x0c, 0x12 },	// U+1E12 (Ḓ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x18, 0x24 },	// U+1E13 (ḓ)
	{ 0x08, 0x10, 0x3c, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1E14 (Ḕ)
	{ 0x04, 0x08, 0x10, 0x00, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1E15 (ḕ)
	{ 0x10, 0x08, 0x3c, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1E16 (Ḗ)
	{ 0x10, 0x08, 0x04, 0x00, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1E17 (ḗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x18, 0x24 },	// U+1E18 (Ḙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x18, 0x24 },	// U+1E19 (ḙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x4c, 0x32 },	// U+1E1A (Ḛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x4c, 0x32 },	// U+1E1B (ḛ)
	{ 0x00, 0x44, 0x38, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x20, 0x18 },	// U+1E1C (Ḝ)
	{ 0x00, 0x00, 0x44, 0x38, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x10, 0x0c },	// U+1E1D (ḝ)
	{ 0x00, 0x08, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1E1E (Ḟ)
	{ 0x10, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+1E1F (ḟ)
	{ 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1E20 (Ḡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x1c, 0x04, 0x3c, 0x42, 0x42, 0x3c },	// U+1E21 (ḡ)
	{ 0x00, 0x00, 0x08, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+1E22 (Ḣ)
	{ 0x00, 0x00, 0x00, 0x12, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1E23 (ḣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x08 },	// U+1E24 (Ḥ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x10 },	// U+1E25 (ḥ)
	{ 0x00, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1E26 (Ḧ)
	{ 0x24, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1E27 (ḧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x46, 0x46, 0x08, 0x06 },	// U+1E28 (Ḩ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x46, 0x08, 0x06 },	// U+1E29 (ḩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x41, 0x41, 0x7f, 0x41, 0x41, 0x41, 0x41, 0x41, 0x14, 0x1c },	// U+1E2A (Ḫ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x72, 0x8a, 0x86, 0x82, 0x82, 0x82, 0x82, 0x82, 0x28, 0x38 },	// U+1E2B (ḫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x4c, 0x32 },	// U+1E2C (Ḭ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x4c, 0x32 },	// U+1E2D (ḭ)
	{ 0x20, 0x10, 0x54, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1E2E (Ḯ)
	{ 0x00, 0x40, 0x20, 0x10, 0x44, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1E2F (ḯ)
	{ 0x00, 0x20, 0x10, 0x08, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+1E30 (Ḱ)
	{ 0x00, 0x40, 0x20, 0x12, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+1E31 (ḱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x08 },	// U+1E32 (Ḳ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x08 },	// U+1E33 (ḳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x3c },	// U+1E34 (Ḵ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x3c },	// U+1E35 (ḵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x08 },	// U+1E36 (Ḷ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x10 },	// U+1E37 (ḷ)
	{ 0x00, 0x00, 0x3c, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x08 },	// U+1E38 (Ḹ)
	{ 0x00, 0x3c, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x10 },	// U+1E39 (ḹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x3c },	// U+1E3A (Ḻ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x38 },	// U+1E3B (ḻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x18, 0x24 },	// U+1E3C (Ḽ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x18, 0x24 },	// U+1E3D (ḽ)
	{ 0x00, 0x20, 0x10, 0x08, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1E3E (Ḿ)
	{ 0x00, 0x00, 0x20, 0x10, 0x08, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+1E3F (ḿ)
	{ 0x00, 0x00, 0x08, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1E40 (Ṁ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00 },	// U+1E41 (ṁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x00, 0x10 },	// U+1E42 (Ṃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x10 },	// U+1E43 (ṃ)
	{ 0x00, 0x00, 0x10, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x00, 0x00 },	// U+1E44 (Ṅ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1E45 (ṅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x00, 0x10 },	// U+1E46 (Ṇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x10 },	// U+1E47 (ṇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x00, 0x3c },	// U+1E48 (Ṉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x3c },	// U+1E49 (ṉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x18, 0x24 },	// U+1E4A (Ṋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x18, 0x24 },	// U+1E4B (ṋ)
	{ 0x20, 0x10, 0x4c, 0x32, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E4C (Ṍ)
	{ 0x40, 0x20, 0x10, 0x4c, 0x32, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E4D (ṍ)
	{ 0x24, 0x00, 0x4c, 0x32, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E4E (Ṏ)
	{ 0x00, 0x24, 0x00, 0x4c, 0x32, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E4F (ṏ)
	{ 0x08, 0x10, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E50 (Ṑ)
	{ 0x04, 0x08, 0x10, 0x00, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E51 (ṑ)
	{ 0x10, 0x08, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E52 (Ṓ)
	{ 0x10, 0x08, 0x04, 0x00, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E53 (ṓ)
	{ 0x00, 0x20, 0x10, 0x08, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1E54 (Ṕ)
	{ 0x00, 0x00, 0x20, 0x10, 0x08, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+1E55 (ṕ)
	{ 0x00, 0x08, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1E56 (Ṗ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+1E57 (ṗ)
	{ 0x00, 0x08, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+1E58 (Ṙ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1E59 (ṙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x10 },	// U+1E5A (Ṛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x10, 0x00 },	// U+1E5B (ṛ)
	{ 0x00, 0x00, 0x3c, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x10 },	// U+1E5C (Ṝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x10, 0x00 },	// U+1E5D (ṝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x3c },	// U+1E5E (Ṟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x3c },	// U+1E5F (ṟ)
	{ 0x00, 0x08, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E60 (Ṡ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+1E61 (ṡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x10 },	// U+1E62 (Ṣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x10 },	// U+1E63 (ṣ)
	{ 0x24, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E64 (Ṥ)
	{ 0x00, 0x04, 0x10, 0x08, 0x04, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+1E65 (ṥ)
	{ 0x10, 0x44, 0x28, 0x10, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E66 (Ṧ)
	{ 0x00, 0x10, 0x00, 0x44, 0x28, 0x10, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+1E67 (ṧ)
	{ 0x00, 0x10, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x10 },	// U+1E68 (Ṩ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x10 },	// U+1E69 (ṩ)
	{ 0x00, 0x10, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1E6A (Ṫ)
	{ 0x00, 0x08, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1E6B (ṫ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10 },	// U+1E6C (Ṭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x08 },	// U+1E6D (ṭ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x7c },	// U+1E6E (Ṯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x3c },	// U+1E6F (ṯ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x28, 0x44 },	// U+1E70 (Ṱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x48, 0x30, 0x28, 0x44 },	// U+1E71 (ṱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x24 },	// U+1E72 (Ṳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x14 },	// U+1E73 (ṳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x4c, 0x32 },	// U+1E74 (Ṵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x4c, 0x32 },	// U+1E75 (ṵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x28, 0x44 },	// U+1E76 (Ṷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x28, 0x44 },	// U+1E77 (ṷ)
	{ 0x20, 0x10, 0x4c, 0x32, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E78 (Ṹ)
	{ 0x40, 0x20, 0x10, 0x4c, 0x32, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1E79 (ṹ)
	{ 0x24, 0x00, 0x3c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E7A (Ṻ)
	{ 0x00, 0x00, 0x24, 0x00, 0x3c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1E7B (ṻ)
	{ 0x00, 0x00, 0x4c, 0x32, 0x00, 0x82, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+1E7C (Ṽ)
	{ 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x18, 0x00, 0x00 },	// U+1E7D (ṽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x10 },	// U+1E7E (Ṿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x08 },	// U+1E7F (ṿ)
	{ 0x00, 0x04, 0x08, 0x10, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+1E80 (Ẁ)
	{ 0x00, 0x00, 0x08, 0x10, 0x20, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1E81 (ẁ)
	{ 0x00, 0x20, 0x10, 0x08, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+1E82 (Ẃ)
	{ 0x00, 0x00, 0x20, 0x10, 0x08, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1E83 (ẃ)
	{ 0x00, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+1E84 (Ẅ)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1E85 (ẅ)
	{ 0x00, 0x08, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x36, 0x36, 0x22, 0x22, 0x00, 0x00 },	// U+1E86 (Ẇ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1E87 (ẇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x36, 0x36, 0x22, 0x22, 0x00, 0x08 },	// U+1E88 (Ẉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x10 },	// U+1E89 (ẉ)
	{ 0x00, 0x08, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x14, 0x14, 0x22, 0x22, 0x00, 0x00 },	// U+1E8A (Ẋ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x22, 0x00, 0x00 },	// U+1E8B (ẋ)
	{ 0x00, 0x24, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+1E8C (Ẍ)
	{ 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+1E8D (ẍ)
	{ 0x00, 0x10, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1E8E (Ẏ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+1E8F (ẏ)
	{ 0x18, 0x24, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1E90 (Ẑ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+1E91 (ẑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x10 },	// U+1E92 (Ẓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x10 },	// U+1E93 (ẓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x3c },	// U+1E94 (Ẕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x3c },	// U+1E95 (ẕ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x3c },	// U+1E96 (ẖ)
	{ 0x00, 0x00, 0x22, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1E97 (ẗ)
	{ 0x00, 0x10, 0x28, 0x10, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1E98 (ẘ)
	{ 0x00, 0x10, 0x28, 0x10, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+1E99 (ẙ)
	{ 0x00, 0x40, 0x80, 0x80, 0x40, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1E9A (ẚ)
	{ 0x00, 0x08, 0x00, 0x30, 0x08, 0x08, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+1E9B (ẛ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x2c, 0x18, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+1E9C (ẜ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x3e, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+1E9D (ẝ)
	{ 0x00, 0x00, 0x00, 0x7c, 0x42, 0x22, 0x22, 0x12, 0x32, 0x42, 0x42, 0x42, 0x4a, 0x32, 0x00, 0x00 },	// U+1E9E (ẞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x04, 0x18, 0x24, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1E9F (ẟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x08 },	// U+1EA0 (Ạ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x08 },	// U+1EA1 (ạ)
	{ 0x02, 0x04, 0x04, 0x02, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1EA2 (Ả)
	{ 0x00, 0x10, 0x20, 0x20, 0x10, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1EA3 (ả)
	{ 0x40, 0x28, 0x14, 0x22, 0x08, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+1EA4 (Ấ)
	{ 0x00, 0x40, 0x28, 0x14, 0x22, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1EA5 (ấ)
	{ 0x02, 0x14, 0x28, 0x44, 0x10, 0x28, 0x28, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+1EA6 (Ầ)
	{ 0x00, 0x02, 0x14, 0x28, 0x44, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1EA7 (ầ)
	{ 0x20, 0x40, 0x28, 0x14, 0x2a, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+1EA8 (Ẩ)
	{ 0x40, 0x80, 0x50, 0x28, 0x44, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1EA9 (ẩ)
	{ 0x98, 0x64, 0x10, 0x28, 0x44, 0x10, 0x28, 0x28, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+1EAA (Ẫ)
	{ 0x98, 0x64, 0x10, 0x28, 0x44, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1EAB (ẫ)
	{ 0x00, 0x10, 0x28, 0x44, 0x10, 0x28, 0x28, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x00, 0x10 },	// U+1EAC (Ậ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x10 },	// U+1EAD (ậ)
	{ 0x10, 0x08, 0x22, 0x1c, 0x08, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+1EAE (Ắ)
	{ 0x20, 0x10, 0x08, 0x22, 0x1c, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1EAF (ắ)
	{ 0x04, 0x08, 0x22, 0x1c, 0x08, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+1EB0 (Ằ)
	{ 0x04, 0x08, 0x10, 0x44, 0x38, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1EB1 (ằ)
	{ 0x08, 0x10, 0x4d, 0x3e, 0x08, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+1EB2 (Ẳ)
	{ 0x10, 0x10, 0x08, 0x22, 0x1c, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1EB3 (ẳ)
	{ 0x4c, 0x32, 0x41, 0x3e, 0x08, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+1EB4 (Ẵ)
	{ 0x4c, 0x32, 0x00, 0x42, 0x3c, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1EB5 (ẵ)
	{ 0x00, 0x00, 0x22, 0x1c, 0x08, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x08 },	// U+1EB6 (Ặ)
	{ 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x08 },	// U+1EB7 (ặ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x08 },	// U+1EB8 (Ẹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x08 },	// U+1EB9 (ẹ)
	{ 0x08, 0x10, 0x10, 0x08, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1EBA (Ẻ)
	{ 0x08, 0x10, 0x10, 0x08, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1EBB (ẻ)
	{ 0x00, 0x4c, 0x32, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1EBC (Ẽ)
	{ 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1EBD (ẽ)
	{ 0x40, 0x28, 0x14, 0x22, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1EBE (Ế)
	{ 0x00, 0x40, 0x28, 0x14, 0x22, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1EBF (ế)
	{ 0x02, 0x14, 0x28, 0x44, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1EC0 (Ề)
	{ 0x00, 0x02, 0x14, 0x28, 0x44, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1EC1 (ề)
	{ 0x20, 0x48, 0x54, 0x22, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1EC2 (Ể)
	{ 0x20, 0x40, 0x48, 0x34, 0x22, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1EC3 (ể)
	{ 0x4c, 0x32, 0x08, 0x14, 0x22, 0x7e, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1EC4 (Ễ)
	{ 0x4c, 0x32, 0x08, 0x14, 0x22, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1EC5 (ễ)
	{ 0x00, 0x18, 0x24, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x10 },	// U+1EC6 (Ệ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x10 },	// U+1EC7 (ệ)
	{ 0x10, 0x20, 0x20, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1EC8 (Ỉ)
	{ 0x00, 0x08, 0x10, 0x10, 0x08, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1EC9 (ỉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x10 },	// U+1ECA (Ị)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x10 },	// U+1ECB (ị)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x10 },	// U+1ECC (Ọ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x10 },	// U+1ECD (ọ)
	{ 0x08, 0x10, 0x10, 0x08, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1ECE (Ỏ)
	{ 0x00, 0x08, 0x10, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1ECF (ỏ)
	{ 0x40, 0x28, 0x14, 0x22, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1ED0 (Ố)
	{ 0x00, 0x40, 0x28, 0x14, 0x22, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1ED1 (ố)
	{ 0x02, 0x14, 0x28, 0x44, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1ED2 (Ồ)
	{ 0x00, 0x02, 0x14, 0x28, 0x44, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1ED3 (ồ)
	{ 0x20, 0x48, 0x54, 0x22, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1ED4 (Ổ)
	{ 0x20, 0x40, 0x48, 0x34, 0x22, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1ED5 (ổ)
	{ 0x4c, 0x32, 0x08, 0x14, 0x22, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1ED6 (Ỗ)
	{ 0x4c, 0x32, 0x08, 0x14, 0x22, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1ED7 (ỗ)
	{ 0x00, 0x18, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x10 },	// U+1ED8 (Ộ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x10 },	// U+1ED9 (ộ)
	{ 0x10, 0x08, 0x44, 0x80, 0x9c, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EDA (Ớ)
	{ 0x00, 0x00, 0x10, 0x08, 0x44, 0x80, 0x9c, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EDB (ớ)
	{ 0x04, 0x08, 0x50, 0x80, 0x9c, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EDC (Ờ)
	{ 0x00, 0x00, 0x04, 0x08, 0x50, 0x80, 0x9c, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EDD (ờ)
	{ 0x08, 0x10, 0x50, 0x88, 0x9c, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EDE (Ở)
	{ 0x00, 0x08, 0x10, 0x10, 0x48, 0x80, 0x9c, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EDF (ở)
	{ 0x00, 0x4c, 0x32, 0x40, 0x9c, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EE0 (Ỡ)
	{ 0x00, 0x4c, 0x32, 0x00, 0x40, 0x80, 0x9c, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EE1 (ỡ)
	{ 0x00, 0x00, 0x40, 0x80, 0x9c, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08 },	// U+1EE2 (Ợ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x9c, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08 },	// U+1EE3 (ợ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x10 },	// U+1EE4 (Ụ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x10 },	// U+1EE5 (ụ)
	{ 0x08, 0x10, 0x10, 0x08, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1EE6 (Ủ)
	{ 0x00, 0x08, 0x10, 0x10, 0x08, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+1EE7 (ủ)
	{ 0x20, 0x10, 0x48, 0x80, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EE8 (Ứ)
	{ 0x00, 0x00, 0x20, 0x10, 0x48, 0x80, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+1EE9 (ứ)
	{ 0x02, 0x04, 0x48, 0x80, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EEA (Ừ)
	{ 0x00, 0x00, 0x02, 0x04, 0x48, 0x80, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+1EEB (ừ)
	{ 0x08, 0x10, 0x50, 0x88, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EEC (Ử)
	{ 0x00, 0x08, 0x10, 0x10, 0x48, 0x80, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+1EED (ử)
	{ 0x4c, 0x32, 0x40, 0x80, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EEE (Ữ)
	{ 0x00, 0x4c, 0x32, 0x00, 0x40, 0x80, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+1EEF (ữ)
	{ 0x00, 0x00, 0x40, 0x80, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08 },	// U+1EF0 (Ự)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0xa2, 0x62, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x08 },	// U+1EF1 (ự)
	{ 0x04, 0x08, 0x10, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1EF2 (Ỳ)
	{ 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+1EF3 (ỳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10 },	// U+1EF4 (Ỵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x3c, 0x10 },	// U+1EF5 (ỵ)
	{ 0x10, 0x20, 0x20, 0x10, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1EF6 (Ỷ)
	{ 0x00, 0x08, 0x10, 0x10, 0x08, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+1EF7 (ỷ)
	{ 0x00, 0x4c, 0x32, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1EF8 (Ỹ)
	{ 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+1EF9 (ỹ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x7f, 0x00, 0x00 },	// U+1EFA (Ỻ)
	{ 0x00, 0x00, 0x00, 0x36, 0x24, 0x24, 0x24, 0x7e, 0x24, 0x24, 0x24, 0x24, 0x24, 0xff, 0x00, 0x00 },	// U+1EFB (ỻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x08, 0x04, 0x24, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1EFC (Ỽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x04, 0x12, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1EFD (ỽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x44, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x12, 0x0c },	// U+1EFE (Ỿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x44, 0x28, 0x28, 0x10, 0x10, 0x1c, 0x12, 0x0c },	// U+1EFF (ỿ)
	{ 0x00, 0x00, 0x0c, 0x08, 0x04, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1F00 (ἀ)
	{ 0x00, 0x00, 0x0c, 0x04, 0x08, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1F01 (ἁ)
	{ 0x00, 0x00, 0x16, 0x14, 0x22, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1F02 (ἂ)
	{ 0x00, 0x00, 0x16, 0x12, 0x24, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1F03 (ἃ)
	{ 0x00, 0x00, 0x26, 0x14, 0x12, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1F04 (ἄ)
	{ 0x00, 0x00, 0x26, 0x12, 0x14, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1F05 (ἅ)
	{ 0x26, 0x19, 0x00, 0x0c, 0x08, 0x04, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1F06 (ἆ)
	{ 0x26, 0x19, 0x00, 0x0c, 0x04, 0x08, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1F07 (ἇ)
	{ 0x03, 0x02, 0x01, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F08 (Ἀ)
	{ 0x03, 0x01, 0x02, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F09 (Ἁ)
	{ 0x0b, 0x0a, 0x11, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F0A (Ἂ)
	{ 0x0b, 0x09, 0x12, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F0B (Ἃ)
	{ 0x13, 0x0a, 0x09, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F0C (Ἄ)
	{ 0x13, 0x09, 0x0a, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F0D (Ἅ)
	{ 0x26, 0x19, 0x06, 0x04, 0x02, 0x18, 0x24, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F0E (Ἆ)
	{ 0x26, 0x19, 0x06, 0x02, 0x04, 0x18, 0x24, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F0F (Ἇ)
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1F10 (ἐ)
	{ 0x00, 0x00, 0x18, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1F11 (ἑ)
	{ 0x00, 0x00, 0x2c, 0x28, 0x44, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1F12 (ἒ)
	{ 0x00, 0x00, 0x2c, 0x24, 0x48, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1F13 (ἓ)
	{ 0x00, 0x00, 0x4c, 0x28, 0x24, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1F14 (ἔ)
	{ 0x00, 0x00, 0x4c, 0x24, 0x28, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1F15 (ἕ)
}; // 281

static const unsigned char unifont_block142[][16] = {
	{ 0x03, 0x02, 0x01, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1F18 (Ἐ)
	{ 0x03, 0x01, 0x02, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1F19 (Ἑ)
	{ 0x0b, 0x0a, 0x11, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1F1A (Ἒ)
	{ 0x0b, 0x09, 0x12, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1F1B (Ἓ)
	{ 0x13, 0x0a, 0x09, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1F1C (Ἔ)
	{ 0x13, 0x09, 0x0a, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1F1D (Ἕ)
}; // 6

static const unsigned char unifont_block143[][16] = {
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1F20 (ἠ)
	{ 0x00, 0x00, 0x18, 0x08, 0x10, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1F21 (ἡ)
	{ 0x00, 0x00, 0x2c, 0x28, 0x44, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1F22 (ἢ)
	{ 0x00, 0x00, 0x2c, 0x24, 0x48, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1F23 (ἣ)
	{ 0x00, 0x00, 0x4c, 0x28, 0x24, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1F24 (ἤ)
	{ 0x00, 0x00, 0x4c, 0x24, 0x28, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1F25 (ἥ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x10, 0x08, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1F26 (ἦ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x08, 0x10, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1F27 (ἧ)
	{ 0x03, 0x02, 0x01, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F28 (Ἠ)
	{ 0x03, 0x01, 0x02, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F29 (Ἡ)
	{ 0x0b, 0x0a, 0x11, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F2A (Ἢ)
	{ 0x0b, 0x09, 0x12, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F2B (Ἣ)
	{ 0x13, 0x0a, 0x09, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F2C (Ἤ)
	{ 0x13, 0x09, 0x0a, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F2D (Ἥ)
	{ 0x26, 0x19, 0x06, 0x04, 0x02, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F2E (Ἦ)
	{ 0x26, 0x19, 0x06, 0x02, 0x04, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1F2F (Ἧ)
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1F30 (ἰ)
	{ 0x00, 0x00, 0x18, 0x08, 0x10, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1F31 (ἱ)
	{ 0x00, 0x00, 0x16, 0x14, 0x22, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1F32 (ἲ)
	{ 0x00, 0x00, 0x16, 0x12, 0x24, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1F33 (ἳ)
	{ 0x00, 0x00, 0x26, 0x14, 0x12, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1F34 (ἴ)
	{ 0x00, 0x00, 0x26, 0x12, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1F35 (ἵ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x10, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1F36 (ἶ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x08, 0x10, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1F37 (ἷ)
	{ 0x03, 0x02, 0x01, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1F38 (Ἰ)
	{ 0x03, 0x01, 0x06, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1F39 (Ἱ)
	{ 0x0b, 0x0a, 0x11, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1F3A (Ἲ)
	{ 0x0b, 0x09, 0x12, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1F3B (Ἳ)
	{ 0x13, 0x0a, 0x09, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1F3C (Ἴ)
	{ 0x13, 0x09, 0x0a, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1F3D (Ἵ)
	{ 0x26, 0x19, 0x06, 0x04, 0x02, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1F3E (Ἶ)
	{ 0x26, 0x19, 0x06, 0x02, 0x04, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1F3F (Ἷ)
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F40 (ὀ)
	{ 0x00, 0x00, 0x18, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F41 (ὁ)
	{ 0x00, 0x00, 0x2c, 0x28, 0x44, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F42 (ὂ)
	{ 0x00, 0x00, 0x2c, 0x24, 0x48, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F43 (ὃ)
	{ 0x00, 0x00, 0x4c, 0x28, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F44 (ὄ)
	{ 0x00, 0x00, 0x4c, 0x24, 0x28, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F45 (ὅ)
}; // 38

static const unsigned char unifont_block144[][16] = {
	{ 0x03, 0x02, 0x01, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F48 (Ὀ)
	{ 0x03, 0x01, 0x02, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F49 (Ὁ)
	{ 0x0b, 0x0a, 0x11, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F4A (Ὂ)
	{ 0x0b, 0x09, 0x12, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F4B (Ὃ)
	{ 0x13, 0x0a, 0x09, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F4C (Ὄ)
	{ 0x13, 0x09, 0x0a, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F4D (Ὅ)
}; // 6

static const unsigned char unifont_block145[][16] = {
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F50 (ὐ)
	{ 0x00, 0x00, 0x18, 0x08, 0x10, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F51 (ὑ)
	{ 0x00, 0x00, 0x2c, 0x28, 0x44, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F52 (ὒ)
	{ 0x00, 0x00, 0x2c, 0x24, 0x48, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F53 (ὓ)
	{ 0x00, 0x00, 0x4c, 0x28, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F54 (ὔ)
	{ 0x00, 0x00, 0x4c, 0x24, 0x28, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F55 (ὕ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x10, 0x08, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F56 (ὖ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x08, 0x10, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F57 (ὗ)
}; // 8

static const unsigned char unifont_block146[][16] = {
	{ 0x03, 0x01, 0x02, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1F59 (Ὑ)
}; // 1

static const unsigned char unifont_block147[][16] = {
	{ 0x0b, 0x09, 0x12, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1F5B (Ὓ)
}; // 1

static const unsigned char unifont_block148[][16] = {
	{ 0x13, 0x09, 0x0a, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1F5D (Ὕ)
}; // 1

static const unsigned char unifont_block149[][16] = {
	{ 0x26, 0x19, 0x06, 0x02, 0x04, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1F5F (Ὗ)
	{ 0x00, 0x00, 0x30, 0x20, 0x10, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1F60 (ὠ)
	{ 0x00, 0x00, 0x30, 0x10, 0x20, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1F61 (ὡ)
	{ 0x00, 0x00, 0x2c, 0x28, 0x44, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1F62 (ὢ)
	{ 0x00, 0x00, 0x2c, 0x24, 0x48, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1F63 (ὣ)
	{ 0x00, 0x00, 0x4c, 0x28, 0x24, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1F64 (ὤ)
	{ 0x00, 0x00, 0x4c, 0x24, 0x28, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1F65 (ὥ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x10, 0x08, 0x00, 0x44, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1F66 (ὦ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x08, 0x10, 0x00, 0x44, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1F67 (ὧ)
	{ 0x03, 0x02, 0x01, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+1F68 (Ὠ)
	{ 0x03, 0x01, 0x02, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+1F69 (Ὡ)
	{ 0x0b, 0x0a, 0x11, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+1F6A (Ὢ)
	{ 0x0b, 0x09, 0x12, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+1F6B (Ὣ)
	{ 0x13, 0x0a, 0x09, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+1F6C (Ὤ)
	{ 0x13, 0x09, 0x0a, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+1F6D (Ὥ)
	{ 0x4c, 0x32, 0x18, 0x10, 0x08, 0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+1F6E (Ὦ)
	{ 0x4c, 0x32, 0x18, 0x08, 0x10, 0x38, 0xc4, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+1F6F (Ὧ)
	{ 0x00, 0x00, 0x04, 0x04, 0x08, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1F70 (ὰ)
	{ 0x00, 0x00, 0x08, 0x04, 0x04, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1F71 (ά)
	{ 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1F72 (ὲ)
	{ 0x00, 0x00, 0x10, 0x08, 0x08, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+1F73 (έ)
	{ 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1F74 (ὴ)
	{ 0x00, 0x00, 0x10, 0x08, 0x08, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1F75 (ή)
	{ 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1F76 (ὶ)
	{ 0x00, 0x00, 0x10, 0x08, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1F77 (ί)
	{ 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F78 (ὸ)
	{ 0x00, 0x00, 0x10, 0x08, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F79 (ό)
	{ 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F7A (ὺ)
	{ 0x00, 0x00, 0x10, 0x08, 0x08, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1F7B (ύ)
	{ 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1F7C (ὼ)
	{ 0x00, 0x00, 0x20, 0x10, 0x10, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1F7D (ώ)
}; // 31

static const unsigned char unifont_block150[][16] = {
	{ 0x00, 0x00, 0x0c, 0x08, 0x04, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1F80 (ᾀ)
	{ 0x00, 0x00, 0x0c, 0x04, 0x08, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1F81 (ᾁ)
	{ 0x00, 0x00, 0x16, 0x14, 0x22, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1F82 (ᾂ)
	{ 0x00, 0x00, 0x16, 0x12, 0x24, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1F83 (ᾃ)
	{ 0x00, 0x00, 0x26, 0x14, 0x12, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1F84 (ᾄ)
	{ 0x00, 0x00, 0x26, 0x12, 0x14, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1F85 (ᾅ)
	{ 0x4c, 0x32, 0x00, 0x0c, 0x08, 0x04, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1F86 (ᾆ)
	{ 0x4c, 0x32, 0x00, 0x0c, 0x04, 0x08, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1F87 (ᾇ)
	{ 0x03, 0x02, 0x01, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x08, 0x30 },	// U+1F88 (ᾈ)
	{ 0x03, 0x01, 0x02, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x08, 0x30 },	// U+1F89 (ᾉ)
	{ 0x0b, 0x0a, 0x11, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x08, 0x30 },	// U+1F8A (ᾊ)
	{ 0x0b, 0x09, 0x12, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x08, 0x30 },	// U+1F8B (ᾋ)
	{ 0x13, 0x0a, 0x09, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x08, 0x30 },	// U+1F8C (ᾌ)
	{ 0x13, 0x09, 0x0a, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x08, 0x30 },	// U+1F8D (ᾍ)
	{ 0x26, 0x19, 0x06, 0x04, 0x02, 0x18, 0x24, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x08, 0x30 },	// U+1F8E (ᾎ)
	{ 0x26, 0x19, 0x06, 0x02, 0x04, 0x18, 0x24, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x08, 0x30 },	// U+1F8F (ᾏ)
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1F90 (ᾐ)
	{ 0x00, 0x00, 0x18, 0x08, 0x10, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1F91 (ᾑ)
	{ 0x00, 0x00, 0x2c, 0x28, 0x44, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1F92 (ᾒ)
	{ 0x00, 0x00, 0x2c, 0x24, 0x48, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1F93 (ᾓ)
	{ 0x00, 0x00, 0x4c, 0x28, 0x24, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1F94 (ᾔ)
	{ 0x00, 0x00, 0x4c, 0x24, 0x28, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1F95 (ᾕ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x10, 0x08, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1F96 (ᾖ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x08, 0x10, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1F97 (ᾗ)
	{ 0x03, 0x02, 0x01, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x04, 0x18 },	// U+1F98 (ᾘ)
	{ 0x03, 0x01, 0x02, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x04, 0x18 },	// U+1F99 (ᾙ)
	{ 0x0b, 0x0a, 0x11, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x04, 0x18 },	// U+1F9A (ᾚ)
	{ 0x0b, 0x09, 0x12, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x04, 0x18 },	// U+1F9B (ᾛ)
	{ 0x13, 0x0a, 0x09, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x04, 0x18 },	// U+1F9C (ᾜ)
	{ 0x13, 0x09, 0x0a, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x04, 0x18 },	// U+1F9D (ᾝ)
	{ 0x26, 0x19, 0x06, 0x04, 0x02, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x04, 0x18 },	// U+1F9E (ᾞ)
	{ 0x26, 0x19, 0x06, 0x02, 0x04, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x04, 0x18 },	// U+1F9F (ᾟ)
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FA0 (ᾠ)
	{ 0x00, 0x00, 0x18, 0x08, 0x10, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FA1 (ᾡ)
	{ 0x00, 0x00, 0x2c, 0x28, 0x44, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FA2 (ᾢ)
	{ 0x00, 0x00, 0x2c, 0x24, 0x48, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FA3 (ᾣ)
	{ 0x00, 0x00, 0x4c, 0x28, 0x24, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FA4 (ᾤ)
	{ 0x00, 0x00, 0x4c, 0x24, 0x28, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FA5 (ᾥ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x10, 0x08, 0x00, 0x44, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FA6 (ᾦ)
	{ 0x4c, 0x32, 0x00, 0x18, 0x08, 0x10, 0x00, 0x44, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FA7 (ᾧ)
	{ 0x03, 0x02, 0x01, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x10, 0x60 },	// U+1FA8 (ᾨ)
	{ 0x03, 0x01, 0x02, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x10, 0x60 },	// U+1FA9 (ᾩ)
	{ 0x0b, 0x0a, 0x11, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x10, 0x60 },	// U+1FAA (ᾪ)
	{ 0x0b, 0x09, 0x12, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x10, 0x60 },	// U+1FAB (ᾫ)
	{ 0x13, 0x0a, 0x09, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x10, 0x60 },	// U+1FAC (ᾬ)
	{ 0x13, 0x09, 0x0a, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x10, 0x60 },	// U+1FAD (ᾭ)
	{ 0x26, 0x19, 0x06, 0x04, 0x02, 0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x10, 0x60 },	// U+1FAE (ᾮ)
	{ 0x26, 0x19, 0x06, 0x02, 0x04, 0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x10, 0x60 },	// U+1FAF (ᾯ)
	{ 0x00, 0x00, 0x22, 0x22, 0x1c, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1FB0 (ᾰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1FB1 (ᾱ)
	{ 0x00, 0x00, 0x04, 0x04, 0x08, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1FB2 (ᾲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1FB3 (ᾳ)
	{ 0x00, 0x00, 0x08, 0x04, 0x04, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1FB4 (ᾴ)
}; // 53

static const unsigned char unifont_block151[][16] = {
	{ 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+1FB6 (ᾶ)
	{ 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x04, 0x0c },	// U+1FB7 (ᾷ)
	{ 0x42, 0x42, 0x3c, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1FB8 (Ᾰ)
	{ 0x00, 0x3c, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1FB9 (Ᾱ)
	{ 0x01, 0x01, 0x02, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1FBA (Ὰ)
	{ 0x02, 0x01, 0x01, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1FBB (Ά)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x08, 0x30 },	// U+1FBC (ᾼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FBD (᾽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x30 },	// U+1FBE (ι)
	{ 0x18, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FBF (᾿)
	{ 0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FC0 (῀)
	{ 0x4c, 0x32, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FC1 (῁)
	{ 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1FC2 (ῂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1FC3 (ῃ)
	{ 0x00, 0x00, 0x10, 0x08, 0x08, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1FC4 (ῄ)
}; // 15

static const unsigned char unifont_block152[][16] = {
	{ 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40 },	// U+1FC6 (ῆ)
	{ 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x4c },	// U+1FC7 (ῇ)
	{ 0x01, 0x01, 0x02, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1FC8 (Ὲ)
	{ 0x02, 0x01, 0x01, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+1FC9 (Έ)
	{ 0x01, 0x01, 0x02, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1FCA (Ὴ)
	{ 0x02, 0x01, 0x01, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+1FCB (Ή)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x08, 0x30 },	// U+1FCC (ῌ)
	{ 0x16, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FCD (῍)
	{ 0x26, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FCE (῎)
	{ 0x4c, 0x32, 0x00, 0x18, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FCF (῏)
	{ 0x00, 0x00, 0x22, 0x22, 0x1c, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1FD0 (ῐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1FD1 (ῑ)
	{ 0x08, 0x08, 0x10, 0x00, 0x66, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1FD2 (ῒ)
	{ 0x10, 0x08, 0x08, 0x00, 0x66, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1FD3 (ΐ)
}; // 14

static const unsigned char unifont_block153[][16] = {
	{ 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1FD6 (ῖ)
	{ 0x00, 0x4c, 0x32, 0x00, 0x66, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+1FD7 (ῗ)
	{ 0x44, 0x44, 0x38, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1FD8 (Ῐ)
	{ 0x00, 0x7c, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1FD9 (Ῑ)
	{ 0x01, 0x01, 0x02, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1FDA (Ὶ)
	{ 0x02, 0x01, 0x01, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+1FDB (Ί)
}; // 6

static const unsigned char unifont_block154[][16] = {
	{ 0x16, 0x12, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FDD (῝)
	{ 0x26, 0x12, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FDE (῞)
	{ 0x4c, 0x32, 0x00, 0x18, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FDF (῟)
	{ 0x00, 0x00, 0x42, 0x42, 0x3c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1FE0 (ῠ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1FE1 (ῡ)
	{ 0x08, 0x08, 0x10, 0x00, 0x66, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1FE2 (ῢ)
	{ 0x10, 0x08, 0x08, 0x00, 0x66, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1FE3 (ΰ)
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+1FE4 (ῤ)
	{ 0x00, 0x00, 0x18, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+1FE5 (ῥ)
	{ 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1FE6 (ῦ)
	{ 0x00, 0x4c, 0x32, 0x00, 0x66, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1FE7 (ῧ)
	{ 0x44, 0x44, 0x38, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1FE8 (Ῠ)
	{ 0x00, 0x00, 0x7c, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1FE9 (Ῡ)
	{ 0x01, 0x01, 0x02, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1FEA (Ὺ)
	{ 0x02, 0x01, 0x01, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1FEB (Ύ)
	{ 0x03, 0x01, 0x02, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1FEC (Ῥ)
	{ 0x08, 0x08, 0x10, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FED (῭)
	{ 0x10, 0x08, 0x08, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FEE (΅)
	{ 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FEF (`)
}; // 19

static const unsigned char unifont_block155[][16] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FF2 (ῲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FF3 (ῳ)
	{ 0x00, 0x00, 0x20, 0x10, 0x10, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FF4 (ῴ)
}; // 3

static const unsigned char unifont_block156[][16] = {
	{ 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+1FF6 (ῶ)
	{ 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x44, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x10, 0x30 },	// U+1FF7 (ῷ)
	{ 0x01, 0x01, 0x02, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1FF8 (Ὸ)
	{ 0x02, 0x01, 0x01, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+1FF9 (Ό)
	{ 0x01, 0x01, 0x02, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+1FFA (Ὼ)
	{ 0x02, 0x01, 0x01, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+1FFB (Ώ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x10, 0x60 },	// U+1FFC (ῼ)
	{ 0x10, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FFD (´)
	{ 0x18, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FFE (῾)
}; // 9

static const unsigned char unifont_block157[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2000 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2001 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2002 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2003 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2004 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2005 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2006 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2007 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2008 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2009 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+200A ( )
}; // 11

static const unsigned char unifont_block158[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2010 (‐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2011 (‑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2012 (‒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2013 (–)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2014 (—)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2015 (―)
	{ 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00 },	// U+2016 (‖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff },	// U+2017 (‗)
	{ 0x00, 0x00, 0x10, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2018 (‘)
	{ 0x00, 0x00, 0x18, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2019 (’)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08 },	// U+201A (‚)
	{ 0x00, 0x00, 0x18, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201B (‛)
	{ 0x00, 0x00, 0x44, 0x22, 0x22, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201C (“)
	{ 0x00, 0x00, 0x66, 0x44, 0x44, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201D (”)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x44, 0x44, 0x22 },	// U+201E („)
	{ 0x00, 0x00, 0x66, 0x22, 0x22, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201F (‟)
	{ 0x00, 0x00, 0x10, 0x38, 0x10, 0x54, 0xfe, 0x54, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2020 (†)
	{ 0x00, 0x10, 0x38, 0x10, 0x54, 0xfe, 0x54, 0x10, 0x10, 0x54, 0xfe, 0x54, 0x10, 0x38, 0x10, 0x00 },	// U+2021 (‡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2022 (•)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x1c, 0x3c, 0x1c, 0x0c, 0x04, 0x00, 0x00, 0x00 },	// U+2023 (‣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+2024 (․)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+2025 (‥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x00, 0x00 },	// U+2026 (…)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2027 (‧)
}; // 24

static const unsigned char unifont_block159[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+202F ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x25, 0x25, 0x12, 0x08, 0x08, 0x54, 0xaa, 0xaa, 0x51, 0x00, 0x00 },	// U+2030 (‰)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x05, 0x32, 0x0c, 0x03, 0x54, 0xaa, 0xaa, 0x54, 0x00, 0x00 },	// U+2031 (‱)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2032 (′)
	{ 0x00, 0x00, 0x00, 0x00, 0xcc, 0x66, 0x22, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2033 (″)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7e, 0x2a, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2034 (‴)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2035 (‵)
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x66, 0x44, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2036 (‶)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x7e, 0x54, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2037 (‷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22 },	// U+2038 (‸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x10, 0x10, 0x08, 0x10, 0x10, 0x20, 0x20, 0x00, 0x00 },	// U+2039 (‹)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00 },	// U+203A (›)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x44, 0x28, 0x92, 0x28, 0x44, 0x92, 0x00, 0x00, 0x00, 0x00 },	// U+203B (※)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x24, 0x24, 0x00, 0x00 },	// U+203C (‼)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x52, 0x52, 0x50, 0x30, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x00 },	// U+203D (‽)
	{ 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+203E (‾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x3c },	// U+203F (‿)
	{ 0x3c, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2040 (⁀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x14, 0x22 },	// U+2041 (⁁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x10, 0x00, 0x44, 0xee, 0x44, 0x00, 0x00, 0x00 },	// U+2042 (⁂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2043 (⁃)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+2044 (⁄)
	{ 0x00, 0x00, 0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x70, 0x00 },	// U+2045 (⁅)
	{ 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00 },	// U+2046 (⁆)
	{ 0x00, 0x00, 0x00, 0x77, 0x88, 0x88, 0x44, 0x33, 0x11, 0x11, 0x11, 0x00, 0x00, 0x11, 0x00, 0x00 },	// U+2047 (⁇)
	{ 0x00, 0x00, 0x00, 0x4e, 0x50, 0x50, 0x48, 0x46, 0x42, 0x42, 0x42, 0x00, 0x00, 0x42, 0x00, 0x00 },	// U+2048 (⁈)
	{ 0x00, 0x00, 0x00, 0x3a, 0x42, 0x42, 0x22, 0x1a, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x0a, 0x00, 0x00 },	// U+2049 (⁉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x20, 0x20, 0x20 },	// U+204A (⁊)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x7a, 0x7a, 0x7a, 0x3a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00 },	// U+204B (⁋)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x5c, 0x5c, 0x5c, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+204C (⁌)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3a, 0x3a, 0x3a, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+204D (⁍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x92, 0x54, 0x38, 0x54, 0x92, 0x10, 0x00, 0x00 },	// U+204E (⁎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x08, 0x08, 0x10, 0x00 },	// U+204F (⁏)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x00, 0x00, 0x00, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2050 (⁐)
	{ 0x00, 0x10, 0x92, 0x54, 0x38, 0x54, 0x92, 0x10, 0x00, 0x10, 0x92, 0x54, 0x38, 0x54, 0x92, 0x10 },	// U+2051 (⁑)
	{ 0x00, 0x00, 0x00, 0x00, 0x46, 0x46, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x62, 0x62, 0x00, 0x00 },	// U+2052 (⁒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2053 (⁓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42 },	// U+2054 (⁔)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x2a, 0x1c, 0x7f, 0x1c, 0x2a, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2055 (⁕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x06, 0x06, 0x00, 0x60, 0x60, 0x00, 0x00 },	// U+2056 (⁖)
}; // 40

static const unsigned char unifont_block160[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x66, 0x66, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+2058 (⁘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x18, 0x18, 0x00, 0x66, 0x66, 0x00, 0x00 },	// U+2059 (⁙)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+205A (⁚)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+205B (⁛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x08, 0x3e, 0x08, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+205C (⁜)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+205D (⁝)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00 },	// U+205E (⁞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+205F ( )
}; // 8

static const unsigned char unifont_block161[][16] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2070 (⁰)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2071 (ⁱ)
}; // 2

static const unsigned char unifont_block162[][16] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x28, 0x24, 0x22, 0x7e, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2074 (⁴)
	{ 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2075 (⁵)
	{ 0x00, 0x00, 0x00, 0x18, 0x04, 0x02, 0x1e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2076 (⁶)
	{ 0x00, 0x00, 0x00, 0x3e, 0x20, 0x10, 0x10, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2077 (⁷)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2078 (⁸)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x3c, 0x20, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2079 (⁹)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207A (⁺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207B (⁻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207C (⁼)
	{ 0x00, 0x00, 0x20, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207D (⁽)
	{ 0x00, 0x00, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207E (⁾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207F (ⁿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00 },	// U+2080 (₀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x3e, 0x00 },	// U+2081 (₁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x18, 0x04, 0x02, 0x3e, 0x00 },	// U+2082 (₂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x1c, 0x20, 0x22, 0x1c, 0x00 },	// U+2083 (₃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x28, 0x24, 0x22, 0x7e, 0x20, 0x20, 0x00 },	// U+2084 (₄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x20, 0x20, 0x1e, 0x00 },	// U+2085 (₅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x02, 0x1e, 0x22, 0x22, 0x1c, 0x00 },	// U+2086 (₆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x10, 0x10, 0x08, 0x08, 0x08, 0x00 },	// U+2087 (₇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x1c, 0x00 },	// U+2088 (₈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x3c, 0x20, 0x10, 0x0c, 0x00 },	// U+2089 (₉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00 },	// U+208A (₊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+208B (₋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x3e, 0x00 },	// U+208C (₌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x20 },	// U+208D (₍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x04 },	// U+208E (₎)
}; // 27

static const unsigned char unifont_block163[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x3c, 0x22, 0x3c, 0x00 },	// U+2090 (ₐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x3c, 0x00 },	// U+2091 (ₑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+2092 (ₒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00 },	// U+2093 (ₓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x3e, 0x22, 0x1c, 0x00 },	// U+2094 (ₔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x00 },	// U+2095 (ₕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x00 },	// U+2096 (ₖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00 },	// U+2097 (ₗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x00 },	// U+2098 (ₘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x00 },	// U+2099 (ₙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x26, 0x1a, 0x02, 0x02 },	// U+209A (ₚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x1e, 0x00 },	// U+209B (ₛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x30, 0x00 },	// U+209C (ₜ)
}; // 13

static const unsigned char unifont_block164[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x7a, 0x0a, 0x0a, 0x3c, 0x08, 0x08, 0x78, 0x00, 0x00 },	// U+20A0 (₠)
	{ 0x00, 0x00, 0x00, 0x00, 0x50, 0x7c, 0x52, 0x2a, 0x2a, 0x16, 0x16, 0x4e, 0x3a, 0x08, 0x00, 0x00 },	// U+20A1 (₡)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x42, 0x02, 0x6a, 0x1a, 0x0a, 0x0a, 0x4c, 0x38, 0x00, 0x00 },	// U+20A2 (₢)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x04, 0x04, 0x04, 0x7c, 0x04, 0x04, 0x3f, 0x04, 0x04, 0x00, 0x00 },	// U+20A3 (₣)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x08, 0x08, 0x7e, 0x08, 0x7e, 0x08, 0x08, 0x7c, 0x86, 0x00, 0x00 },	// U+20A4 (₤)
	{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x6e, 0xb2, 0xb2, 0x92, 0x92, 0x9a, 0x96, 0x96, 0x00, 0x00 },	// U+20A5 (₥)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x4c, 0xfe, 0x54, 0xfe, 0x64, 0x64, 0x44, 0x44, 0x00, 0x00 },	// U+20A6 (₦)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x1a, 0xfa, 0x3a, 0x36, 0x52, 0x92, 0x92, 0x92, 0x72, 0x00, 0x00 },	// U+20A7 (₧)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x12, 0xd2, 0x32, 0x2e, 0x2a, 0x4a, 0x92, 0x92, 0x72, 0x00, 0x00 },	// U+20A8 (₨)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0xfe, 0x54, 0xfe, 0x6c, 0x6c, 0x44, 0x44, 0x00, 0x00, 0x00 },	// U+20A9 (₩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x51, 0x55, 0x55, 0x55, 0x55, 0x45, 0x3d, 0x00, 0x00 },	// U+20AA (₪)
	{ 0x00, 0x00, 0x00, 0x40, 0xf0, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x7e },	// U+20AB (₫)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x04, 0x3e, 0x04, 0x3e, 0x04, 0x04, 0x48, 0x30, 0x00, 0x00 },	// U+20AC (€)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x7f, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+20AD (₭)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x70, 0x1c, 0x70, 0x1c, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+20AE (₮)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x12, 0x12, 0x72, 0xb2, 0xb2, 0x72, 0x2e, 0x20, 0x20 },	// U+20AF (₯)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x18, 0x2a, 0x26, 0x46, 0x42, 0x20, 0x10 },	// U+20B0 (₰)
	{ 0x00, 0x00, 0x3e, 0x42, 0xff, 0x42, 0xff, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+20B1 (₱)
	{ 0x00, 0x00, 0x08, 0x08, 0x3c, 0x4a, 0x4a, 0x0a, 0x0a, 0x6a, 0x4a, 0x4a, 0x6a, 0x5c, 0x08, 0x08 },	// U+20B2 (₲)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0xff, 0x42, 0xff, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+20B3 (₳)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0xff, 0x0c, 0xff, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+20B4 (₴)
	{ 0x00, 0x00, 0x08, 0x08, 0x3c, 0x4a, 0x4a, 0x0a, 0x0a, 0x0a, 0x0a, 0x4a, 0x4a, 0x3c, 0x08, 0x08 },	// U+20B5 (₵)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x7e, 0x14, 0x14, 0x14, 0x14, 0x94, 0x64, 0x00, 0x00 },	// U+20B6 (₶)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x04, 0x18, 0x20, 0x4a, 0x55, 0x55, 0x3f, 0x15, 0x15 },	// U+20B7 (₷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+20B8 (₸)
}; // 25

static const unsigned char unifont_block165[][16] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x14, 0x0c, 0x06, 0x15, 0x0c, 0x46, 0x45, 0x24, 0x1c, 0x00, 0x00 },	// U+20BA (₺)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x3f, 0x44, 0x42, 0x2a, 0x17, 0x02, 0x22, 0x1c, 0x00, 0x00 },	// U+20BB (₻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x00 },	// U+20BC (₼)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x44, 0x44, 0x44, 0x3e, 0x04, 0x3e, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+20BD (₽)
	{ 0x00, 0x00, 0x14, 0x3e, 0x55, 0x55, 0x55, 0x01, 0x01, 0x01, 0x01, 0x02, 0x04, 0x7f, 0x00, 0x00 },	// U+20BE (₾)
	{ 0x00, 0x00, 0x14, 0x14, 0x3f, 0x42, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3f, 0x14, 0x14 },	// U+20BF (₿)
}; // 6

static const unsigned char unifont_block166[][16] = {
	{ 0x00, 0x08, 0x04, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D0 (⃐)
	{ 0x00, 0x10, 0x20, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D1 (⃑)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+20D2 (⃒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+20D3 (⃓)
	{ 0x00, 0x32, 0x4a, 0x06, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D4 (⃔)
	{ 0x00, 0x4c, 0x52, 0x60, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D5 (⃕)
	{ 0x08, 0x04, 0x7e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D6 (⃖)
	{ 0x10, 0x20, 0x7e, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D7 (⃗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D8 (⃘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2c, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D9 (⃙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x34, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20DA (⃚)
	{ 0x00, 0x00, 0x54, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20DB (⃛)
	{ 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20DC (⃜)
}; // 13

static const unsigned char unifont_block167[][16] = {
	{ 0x24, 0x42, 0xff, 0x42, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20E1 (⃡)
}; // 1

static const unsigned char unifont_block168[][16] = {
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+20E5 (⃥)
	{ 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+20E6 (⃦)
}; // 2

static const unsigned char unifont_block169[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a },	// U+20E8 (⃨)
	{ 0x00, 0xff, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20E9 (⃩)
}; // 2

static const unsigned char unifont_block170[][16] = {
	{ 0x00, 0x00, 0x50, 0x50, 0x50, 0x28, 0x28, 0x28, 0x28, 0x28, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+20EB (⃫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10 },	// U+20EC (⃬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x08 },	// U+20ED (⃭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x7e, 0x04, 0x08 },	// U+20EE (⃮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x7e, 0x20, 0x10 },	// U+20EF (⃯)
	{ 0x24, 0x18, 0x7e, 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20F0 (⃰)
}; // 6

static const unsigned char unifont_block171[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x8a, 0x4a, 0x2c, 0x10, 0xc8, 0x24, 0x22, 0xc0, 0x00, 0x00 },	// U+2100 (℀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x8a, 0x4a, 0x2c, 0xd0, 0x28, 0x44, 0x82, 0x60, 0x00, 0x00 },	// U+2101 (℁)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x8c, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x8c, 0x78, 0x00, 0x00 },	// U+2102 (ℂ)
	{ 0x02, 0x05, 0x05, 0x02, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+2103 (℃)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3c, 0x0a, 0x0a, 0x0a, 0x0a, 0x3c, 0x08, 0x78, 0x00, 0x00 },	// U+2104 (℄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x82, 0x42, 0x2c, 0x10, 0x68, 0x94, 0x92, 0x60, 0x00, 0x00 },	// U+2105 (℅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x82, 0x42, 0x2c, 0x10, 0x08, 0x94, 0x92, 0x60, 0x00, 0x00 },	// U+2106 (℆)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x02, 0x02, 0x1c, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+2107 (ℇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x40, 0x48, 0x78, 0x48, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+2108 (℈)
	{ 0x02, 0x05, 0x05, 0x02, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+2109 (℉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x7c, 0x40, 0xfc, 0x42, 0x3c, 0x00 },	// U+210A (ℊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x48, 0xae, 0x69, 0x28, 0x38, 0x2c, 0x2a, 0x29, 0x29, 0xc6, 0x00, 0x00 },	// U+210B (ℋ)
	{ 0x00, 0x00, 0x18, 0x6d, 0x06, 0x16, 0x2e, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x67, 0x60, 0x2c, 0x10 },	// U+210C (ℌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x8e, 0x8a, 0x8a, 0x8a, 0xfa, 0x8a, 0x8a, 0x8a, 0x8a, 0x8e, 0x00, 0x00 },	// U+210D (ℍ)
}; // 14

static const unsigned char unifont_block172[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x28, 0x24, 0x20, 0x20, 0x60, 0x30, 0x28, 0x24, 0x14, 0x0c, 0x00 },	// U+2110 (ℐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x9c, 0xfe, 0x63, 0x01, 0x66, 0x10, 0x36, 0x65, 0x66, 0x3c, 0x00, 0x00 },	// U+2111 (ℑ)
	{ 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x3c, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x99, 0x66, 0x00, 0x00 },	// U+2112 (ℒ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x14, 0x0c, 0x06, 0x04, 0x04, 0x44, 0x38, 0x00, 0x00 },	// U+2113 (ℓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x7f, 0x12, 0x52, 0xb2, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+2114 (℔)
	{ 0x00, 0x00, 0x00, 0x00, 0x8e, 0x8a, 0x9a, 0x9a, 0xaa, 0xaa, 0xca, 0xca, 0x8a, 0x8e, 0x00, 0x00 },	// U+2115 (ℕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0xa9, 0xa9, 0x4b, 0x0b, 0xed, 0x0d, 0x09, 0x09, 0x09, 0x00, 0x00 },	// U+2116 (№)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x9d, 0xa5, 0xa5, 0x9d, 0x85, 0x85, 0x42, 0x3c, 0x00, 0x00 },	// U+2117 (℗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x32, 0x4a, 0x44, 0x44, 0x54, 0x2a, 0x0a, 0x0a, 0x04 },	// U+2118 (℘)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x4a, 0x4a, 0x4a, 0x4a, 0x3a, 0x0a, 0x0a, 0x0a, 0x0e, 0x00, 0x00 },	// U+2119 (ℙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x4c, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x6c, 0x78, 0x80, 0x00 },	// U+211A (ℚ)
	{ 0x00, 0x00, 0x00, 0x02, 0x74, 0x88, 0x8c, 0x8a, 0x8a, 0x7a, 0x2a, 0x4a, 0x4a, 0x84, 0x00, 0x00 },	// U+211B (ℛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x76, 0x4d, 0xcc, 0x6c, 0x3c, 0x6c, 0x6c, 0x45, 0xc3, 0x00, 0x00 },	// U+211C (ℜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x8a, 0x8a, 0x8a, 0x8a, 0x7a, 0x1a, 0x2a, 0x4a, 0x8e, 0x00, 0x00 },	// U+211D (ℝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x0a, 0x52, 0x22, 0x52, 0x0a, 0x00, 0x00 },	// U+211E (℞)
	{ 0x00, 0x00, 0x1c, 0x10, 0x3e, 0x52, 0x52, 0x52, 0x3e, 0x16, 0x1a, 0x12, 0x32, 0x52, 0x10, 0x00 },	// U+211F (℟)
	{ 0x00, 0x00, 0x00, 0x00, 0x8e, 0xd9, 0xaa, 0x8c, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2120 (℠)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x4a, 0x5a, 0x4a, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2121 (℡)
	{ 0x00, 0x00, 0x00, 0x00, 0x8f, 0xda, 0xaa, 0x8a, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2122 (™)
	{ 0x00, 0x00, 0x0c, 0x30, 0xa1, 0x91, 0x52, 0x4a, 0x2a, 0x24, 0x14, 0x1e, 0x0a, 0x01, 0x00, 0x00 },	// U+2123 (℣)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x50, 0x50, 0x48, 0x28, 0x24, 0x14, 0x12, 0x0a, 0x7e, 0x00, 0x00 },	// U+2124 (ℤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x10, 0x08, 0x7c, 0x20, 0x10, 0x18, 0x20, 0x40, 0x42, 0x3c, 0x00 },	// U+2125 (℥)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x28, 0xee, 0x00, 0x00 },	// U+2126 (Ω)
	{ 0x00, 0x00, 0x00, 0x00, 0xee, 0x28, 0x28, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00 },	// U+2127 (℧)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x62, 0x62, 0x60, 0x10, 0x78, 0x40, 0x60, 0x66, 0x65, 0x66, 0x3c },	// U+2128 (ℨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0x00, 0x00 },	// U+2129 (℩)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+212A (K)
	{ 0x18, 0x24, 0x18, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+212B (Å)
	{ 0x00, 0x00, 0x00, 0x00, 0x74, 0x8a, 0x8a, 0x8a, 0x7a, 0x8a, 0x8a, 0x8a, 0x8a, 0x74, 0x00, 0x00 },	// U+212C (ℬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x68, 0x24, 0x16, 0x16, 0x66, 0x66, 0x26, 0x16, 0x44, 0x38, 0x00, 0x00 },	// U+212D (ℭ)
}; // 30

static const unsigned char unifont_block173[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x12, 0x0e, 0x02, 0x22, 0x1c, 0x00, 0x00 },	// U+212F (ℯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x48, 0x04, 0x04, 0x38, 0x04, 0x02, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+2130 (ℰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x20, 0x20, 0x10, 0x7c, 0x08, 0x04, 0x04, 0x00, 0x00 },	// U+2131 (ℱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+2132 (Ⅎ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0x6c, 0x54, 0x54, 0x54, 0x54, 0x54, 0x56, 0x55, 0x92, 0x00, 0x00 },	// U+2133 (ℳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0xca, 0x72, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00 },	// U+2134 (ℴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x62, 0x44, 0x28, 0x14, 0x26, 0x4e, 0x46, 0x00, 0x00 },	// U+2135 (ℵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x40, 0xfc, 0x7e, 0x00, 0x00 },	// U+2136 (ℶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3c, 0x78, 0x40, 0x40, 0x40, 0x70, 0x4c, 0x4c, 0x00, 0x00 },	// U+2137 (ℷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x7c, 0xf8, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x40, 0x00, 0x00 },	// U+2138 (ℸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00, 0x00, 0x00 },	// U+2139 (ℹ)
}; // 11

static const unsigned char unifont_block174[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xaa, 0xca, 0x8a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0e, 0x00, 0x00 },	// U+213E (ℾ)
}; // 1

static const unsigned char unifont_block175[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x4e, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+2141 (⅁)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+2142 (⅂)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+2143 (⅃)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00, 0x00 },	// U+2144 (⅄)
}; // 4

static const unsigned char unifont_block176[][16] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x3e, 0x4a, 0x4a, 0x4a, 0x4a, 0x3a, 0x08, 0x08, 0x08, 0x78, 0x00, 0x00 },	// U+214A (⅊)
	{ 0x00, 0x00, 0x00, 0x00, 0x72, 0x8c, 0x84, 0x8a, 0x52, 0x30, 0x28, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+214B (⅋)
}; // 2

static const unsigned char unifont_block177[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x45, 0x27, 0x15, 0x10, 0xc8, 0x28, 0x44, 0x82, 0x62, 0x00, 0x00 },	// U+214D (⅍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x3e, 0x00, 0x00 },	// U+214E (ⅎ)
}; // 2

static const unsigned char unifont_block178[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x24, 0x14, 0x14, 0x78, 0x48, 0x44, 0x22, 0x22, 0x20, 0x00 },	// U+2150 (⅐)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x24, 0x14, 0x14, 0x78, 0x58, 0x74, 0x42, 0x32, 0x00, 0x00 },	// U+2151 (⅑)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x43, 0x22, 0x12, 0x0a, 0x44, 0xaa, 0xad, 0xa9, 0x48, 0x00, 0x00 },	// U+2152 (⅒)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x24, 0x14, 0x14, 0x38, 0x48, 0x24, 0x42, 0x32, 0x00, 0x00 },	// U+2153 (⅓)
	{ 0x00, 0x00, 0x00, 0x00, 0x46, 0x48, 0x24, 0x12, 0x1e, 0x38, 0x48, 0x24, 0x42, 0x32, 0x00, 0x00 },	// U+2154 (⅔)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x24, 0x14, 0x14, 0x78, 0x18, 0x34, 0x42, 0x32, 0x00, 0x00 },	// U+2155 (⅕)
	{ 0x00, 0x00, 0x00, 0x00, 0x46, 0x48, 0x24, 0x12, 0x1e, 0x78, 0x18, 0x34, 0x42, 0x32, 0x00, 0x00 },	// U+2156 (⅖)
	{ 0x00, 0x00, 0x00, 0x00, 0x46, 0x48, 0x24, 0x18, 0x16, 0x78, 0x18, 0x34, 0x42, 0x32, 0x00, 0x00 },	// U+2157 (⅗)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x2f, 0x14, 0x14, 0x78, 0x18, 0x34, 0x42, 0x32, 0x00, 0x00 },	// U+2158 (⅘)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x24, 0x14, 0x14, 0x68, 0x18, 0x74, 0x52, 0x72, 0x00, 0x00 },	// U+2159 (⅙)
	{ 0x00, 0x00, 0x00, 0x00, 0x4e, 0x42, 0x26, 0x18, 0x16, 0x68, 0x18, 0x74, 0x52, 0x72, 0x00, 0x00 },	// U+215A (⅚)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x24, 0x14, 0x14, 0x28, 0x58, 0x24, 0x52, 0x72, 0x00, 0x00 },	// U+215B (⅛)
	{ 0x00, 0x00, 0x00, 0x00, 0x46, 0x48, 0x24, 0x18, 0x16, 0x28, 0x58, 0x24, 0x52, 0x72, 0x00, 0x00 },	// U+215C (⅜)
	{ 0x00, 0x00, 0x00, 0x00, 0x4e, 0x42, 0x26, 0x18, 0x16, 0x28, 0x58, 0x24, 0x52, 0x72, 0x00, 0x00 },	// U+215D (⅝)
	{ 0x00, 0x00, 0x00, 0x00, 0x4e, 0x48, 0x24, 0x12, 0x12, 0x28, 0x58, 0x24, 0x52, 0x72, 0x00, 0x00 },	// U+215E (⅞)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x24, 0x14, 0x14, 0x08, 0x08, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+215F (⅟)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+2160 (Ⅰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x7e, 0x00, 0x00 },	// U+2161 (Ⅱ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0xfe, 0x00, 0x00 },	// U+2162 (Ⅲ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x94, 0x94, 0x94, 0x94, 0x94, 0x64, 0x64, 0x64, 0xfe, 0x00, 0x00 },	// U+2163 (Ⅳ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+2164 (Ⅴ)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0x52, 0x52, 0x52, 0x52, 0x52, 0x4c, 0x4c, 0x4c, 0xfe, 0x00, 0x00 },	// U+2165 (Ⅵ)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4, 0xa4, 0xa4, 0xa4, 0xfe, 0x00, 0x00 },	// U+2166 (Ⅶ)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xad, 0xad, 0xad, 0xad, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0x00, 0x00 },	// U+2167 (Ⅷ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x54, 0x54, 0x54, 0x24, 0x24, 0x54, 0x54, 0x54, 0xfe, 0x00, 0x00 },	// U+2168 (Ⅸ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x44, 0x28, 0x10, 0x10, 0x28, 0x44, 0x44, 0xfe, 0x00, 0x00 },	// U+2169 (Ⅹ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x54, 0x54, 0x54, 0x48, 0x48, 0x54, 0x54, 0x54, 0xfe, 0x00, 0x00 },	// U+216A (Ⅺ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xaa, 0xaa, 0xaa, 0xa4, 0xa4, 0xaa, 0xaa, 0xaa, 0xfe, 0x00, 0x00 },	// U+216B (Ⅻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x7e, 0x00, 0x00 },	// U+216C (Ⅼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x58, 0x64, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x44, 0x38, 0x00, 0x00 },	// U+216D (Ⅽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x24, 0x1e, 0x00, 0x00 },	// U+216E (Ⅾ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc6, 0x44, 0x6c, 0x6c, 0x6c, 0x54, 0x54, 0x54, 0x54, 0xfe, 0x00, 0x00 },	// U+216F (Ⅿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x10, 0x18, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+2170 (ⅰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x24, 0x36, 0x24, 0x24, 0x24, 0x24, 0x7e, 0x00, 0x00 },	// U+2171 (ⅱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x54, 0x54, 0x00, 0x54, 0x7e, 0x54, 0x54, 0x54, 0x54, 0xfe, 0x00, 0x00 },	// U+2172 (ⅲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0xdc, 0x96, 0x94, 0x94, 0x64, 0x64, 0xfe, 0x00, 0x00 },	// U+2173 (ⅳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x44, 0x44, 0x44, 0x28, 0x10, 0x7c, 0x00, 0x00 },	// U+2174 (ⅴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x5a, 0x72, 0x52, 0x52, 0x4c, 0x4c, 0xfe, 0x00, 0x00 },	// U+2175 (ⅵ)
	{ 0x00, 0x00, 0x00, 0x00, 0xa0, 0xa0, 0x00, 0xaa, 0xfa, 0xaa, 0xaa, 0xa4, 0xa4, 0xfe, 0x00, 0x00 },	// U+2176 (ⅶ)
	{ 0x00, 0x00, 0x00, 0x00, 0xa8, 0xa8, 0x00, 0xad, 0xfd, 0xad, 0xaa, 0xaa, 0xaa, 0xff, 0x00, 0x00 },	// U+2177 (ⅷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x54, 0x56, 0x24, 0x24, 0x54, 0x54, 0xfe, 0x00, 0x00 },	// U+2178 (ⅸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x44, 0x28, 0x10, 0x28, 0x44, 0xee, 0x00, 0x00 },	// U+2179 (ⅹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x54, 0x74, 0x48, 0x48, 0x54, 0x54, 0xfe, 0x00, 0x00 },	// U+217A (ⅺ)
	{ 0x00, 0x00, 0x00, 0x00, 0xa0, 0xa0, 0x00, 0xaa, 0xfa, 0xa4, 0xa4, 0xaa, 0xaa, 0xfe, 0x00, 0x00 },	// U+217B (ⅻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+217C (ⅼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x64, 0x02, 0x02, 0x02, 0x44, 0x38, 0x00, 0x00 },	// U+217D (ⅽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x40, 0x58, 0x64, 0x42, 0x42, 0x42, 0x64, 0xd8, 0x00, 0x00 },	// U+217E (ⅾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0xfe, 0x00, 0x00 },	// U+217F (ⅿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x00, 0x00 },	// U+2180 (ↀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x24, 0x4c, 0x54, 0x54, 0x54, 0x54, 0x4c, 0x24, 0x1e, 0x00, 0x00 },	// U+2181 (ↁ)
}; // 50

static const unsigned char unifont_block179[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+2183 (Ↄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+2184 (ↄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x62, 0x5c, 0x40, 0x40 },	// U+2185 (ↅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x49, 0x2a, 0x1c, 0x08, 0x00, 0x00 },	// U+2186 (ↆ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x62, 0x8e, 0x92, 0xa6, 0xaa, 0xa6, 0x92, 0x8e, 0x62, 0x1f, 0x00, 0x00 },	// U+2187 (ↇ)
}; // 5

static const unsigned char unifont_block180[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x4a, 0x2a, 0x1a, 0x14, 0x38, 0x48, 0x24, 0x42, 0x32, 0x00, 0x00 },	// U+2189 (↉)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x0c, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+218A (↊)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x1c, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+218B (↋)
}; // 3

static const unsigned char unifont_block181[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0xfe, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2190 (←)
	{ 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2191 (↑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x7f, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2192 (→)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+2193 (↓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x42, 0xff, 0x42, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2194 (↔)
	{ 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+2195 (↕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x06, 0x0a, 0x12, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2196 (↖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x60, 0x50, 0x48, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2197 (↗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x48, 0x50, 0x60, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2198 (↘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x12, 0x0a, 0x06, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2199 (↙)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x28, 0x24, 0xfe, 0x24, 0x28, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+219A (↚)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x14, 0x24, 0x7f, 0x24, 0x14, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+219B (↛)
}; // 12

static const unsigned char unifont_block182[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x12, 0xff, 0x12, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+219E (↞)
	{ 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+219F (↟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x48, 0xff, 0x48, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A0 (↠)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x54, 0x38, 0x10, 0x00 },	// U+21A1 (↡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x44, 0x3e, 0x44, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A2 (↢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x22, 0x7c, 0x22, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A3 (↣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x44, 0x7e, 0x44, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A4 (↤)
	{ 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+21A5 (↥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x7e, 0x22, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A6 (↦)
	{ 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+21A7 (↧)
	{ 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x7c, 0x00, 0x00 },	// U+21A8 (↨)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x88, 0x84, 0x7e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A9 (↩)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x22, 0x42, 0xfc, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21AA (↪)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0xa8, 0xa4, 0x7e, 0x24, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21AB (↫)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x2a, 0x4a, 0xfc, 0x48, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21AC (↬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x5a, 0xe7, 0x42, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21AD (↭)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x34, 0x52, 0xff, 0x52, 0x34, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+21AE (↮)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x12, 0x1a, 0x16, 0x12, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+21AF (↯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x1e, 0x24, 0x28, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },	// U+21B0 (↰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x78, 0x24, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+21B1 (↱)
	{ 0x20, 0x20, 0x20, 0x20, 0x20, 0x28, 0x24, 0x1e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21B2 (↲)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x14, 0x24, 0x78, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21B3 (↳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x20, 0xa8, 0x70, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+21B4 (↴)
	{ 0x20, 0x20, 0x20, 0x20, 0x20, 0x28, 0x24, 0x3e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21B5 (↵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x95, 0x8e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21B6 (↶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0xa9, 0x71, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+21B7 (↷)
	{ 0x00, 0x00, 0x00, 0x7e, 0x00, 0x1e, 0x06, 0x0a, 0x12, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21B8 (↸)
	{ 0x00, 0x00, 0x00, 0x0a, 0x06, 0x7e, 0x06, 0x0a, 0x00, 0x50, 0x60, 0x7e, 0x60, 0x50, 0x00, 0x00 },	// U+21B9 (↹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x32, 0x52, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00 },	// U+21BA (↺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x4c, 0x4a, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00 },	// U+21BB (↻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21BC (↼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21BD (↽)
	{ 0x00, 0x00, 0x10, 0x30, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+21BE (↾)
	{ 0x00, 0x00, 0x10, 0x18, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+21BF (↿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21C0 (⇀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21C1 (⇁)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x50, 0x30, 0x10, 0x00, 0x00 },	// U+21C2 (⇂)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x18, 0x10, 0x00, 0x00 },	// U+21C3 (⇃)
	{ 0x00, 0x00, 0x00, 0x10, 0x20, 0x7e, 0x20, 0x10, 0x00, 0x08, 0x04, 0x7e, 0x04, 0x08, 0x00, 0x00 },	// U+21C4 (⇄)
	{ 0x00, 0x00, 0x24, 0x2e, 0x35, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0xac, 0x74, 0x24, 0x00, 0x00 },	// U+21C5 (⇅)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x7e, 0x04, 0x08, 0x00, 0x10, 0x20, 0x7e, 0x20, 0x10, 0x00, 0x00 },	// U+21C6 (⇆)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x7e, 0x04, 0x08, 0x00, 0x08, 0x04, 0x7e, 0x04, 0x08, 0x00, 0x00 },	// U+21C7 (⇇)
	{ 0x00, 0x00, 0x24, 0x7e, 0xa5, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+21C8 (⇈)
	{ 0x00, 0x00, 0x00, 0x10, 0x20, 0x7e, 0x20, 0x10, 0x00, 0x10, 0x20, 0x7e, 0x20, 0x10, 0x00, 0x00 },	// U+21C9 (⇉)
	{ 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0xa5, 0x7e, 0x24, 0x00, 0x00 },	// U+21CA (⇊)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x7e, 0x00, 0x7e, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21CB (⇋)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x7e, 0x00, 0x7e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21CC (⇌)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x7e, 0x11, 0x7e, 0x14, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+21CD (⇍)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x34, 0x7e, 0x91, 0x7e, 0x34, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+21CE (⇎)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x28, 0x7e, 0x88, 0x7e, 0x28, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21CF (⇏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0x02, 0x7c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D0 (⇐)
	{ 0x00, 0x00, 0x10, 0x28, 0x6c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+21D1 (⇑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3e, 0x40, 0x3e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D2 (⇒)
	{ 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x6c, 0x28, 0x10, 0x00, 0x00 },	// U+21D3 (⇓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x7e, 0x81, 0x7e, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D4 (⇔)
	{ 0x00, 0x00, 0x10, 0x28, 0x6c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x6c, 0x28, 0x10, 0x00, 0x00 },	// U+21D5 (⇕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x0a, 0x16, 0x2a, 0x50, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D6 (⇖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x50, 0x68, 0x54, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D7 (⇗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x54, 0x68, 0x50, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D8 (⇘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x2a, 0x16, 0x0a, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D9 (⇙)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0x02, 0x7f, 0x02, 0x7c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21DA (⇚)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x3e, 0x40, 0xfe, 0x40, 0x3e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21DB (⇛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x42, 0xaf, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21DC (⇜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x42, 0xf5, 0x48, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21DD (⇝)
	{ 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+21DE (⇞)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+21DF (⇟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0xee, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21E0 (⇠)
	{ 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10 },	// U+21E1 (⇡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0xf7, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21E2 (⇢)
	{ 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+21E3 (⇣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x06, 0xfe, 0x06, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21E4 (⇤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x60, 0x7f, 0x60, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21E5 (⇥)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0xfa, 0x81, 0xfa, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21E6 (⇦)
	{ 0x00, 0x00, 0x10, 0x28, 0x44, 0xee, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x38, 0x00, 0x00 },	// U+21E7 (⇧)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x5f, 0x81, 0x5f, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21E8 (⇨)
	{ 0x00, 0x00, 0x38, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xee, 0x44, 0x28, 0x10, 0x00, 0x00 },	// U+21E9 (⇩)
	{ 0x00, 0x00, 0x10, 0x28, 0x44, 0xee, 0x28, 0x28, 0x28, 0x38, 0x00, 0x38, 0x28, 0x38, 0x00, 0x00 },	// U+21EA (⇪)
	{ 0x00, 0x00, 0x10, 0x28, 0x44, 0xc6, 0x44, 0x44, 0x44, 0x44, 0x44, 0xc6, 0x82, 0xfe, 0x00, 0x00 },	// U+21EB (⇫)
	{ 0x00, 0x00, 0x10, 0x28, 0x7c, 0xc6, 0x44, 0x44, 0x44, 0x44, 0x44, 0xc6, 0x82, 0xfe, 0x00, 0x00 },	// U+21EC (⇬)
	{ 0x00, 0x00, 0x10, 0x38, 0x54, 0xd6, 0x54, 0x54, 0x54, 0x54, 0x54, 0xd6, 0x92, 0xfe, 0x00, 0x00 },	// U+21ED (⇭)
	{ 0x00, 0x10, 0x28, 0x54, 0xee, 0x44, 0xc6, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7c, 0x00, 0x00 },	// U+21EE (⇮)
	{ 0x00, 0x10, 0x28, 0x54, 0xee, 0x44, 0xc6, 0x44, 0x44, 0x44, 0x44, 0xc6, 0x82, 0xfe, 0x00, 0x00 },	// U+21EF (⇯)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x36, 0x5e, 0x82, 0x5e, 0x36, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21F0 (⇰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x3a, 0x1a, 0x2a, 0x42, 0x82, 0x02, 0x02, 0x00, 0x00 },	// U+21F1 (⇱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x82, 0x84, 0xa8, 0xb0, 0xb8, 0x80, 0xfe, 0x00, 0x00 },	// U+21F2 (⇲)
	{ 0x00, 0x00, 0x10, 0x28, 0x6c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x6c, 0x28, 0x10, 0x00, 0x00 },	// U+21F3 (⇳)
}; // 86

static const unsigned char unifont_block183[][16] = {
	{ 0x00, 0x00, 0x24, 0x74, 0xac, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x35, 0x2e, 0x24, 0x00, 0x00 },	// U+21F5 (⇵)
	{ 0x20, 0x40, 0xff, 0x40, 0x20, 0x20, 0x40, 0xff, 0x40, 0x20, 0x20, 0x40, 0xff, 0x40, 0x20, 0x00 },	// U+21F6 (⇶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x22, 0xff, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21F7 (⇷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x44, 0xff, 0x44, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21F8 (⇸)
}; // 4

static const unsigned char unifont_block184[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0xfd, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21FD (⇽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x60, 0xbf, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21FE (⇾)
}; // 2

static const unsigned char unifont_block185[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x7c, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+2200 (∀)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x04, 0x04, 0x04, 0x04, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2201 (∁)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x40, 0x40, 0x78, 0x44, 0x42, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+2202 (∂)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+2203 (∃)
	{ 0x00, 0x00, 0x08, 0x08, 0x7e, 0x48, 0x48, 0x48, 0x7e, 0x48, 0x48, 0x48, 0x48, 0x7e, 0x08, 0x00 },	// U+2204 (∄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0x44, 0xa2, 0x92, 0x8a, 0x44, 0x3a, 0x00, 0x00 },	// U+2205 (∅)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x28, 0x44, 0x44, 0x44, 0x82, 0xfe, 0x00, 0x00 },	// U+2206 (∆)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+2207 (∇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x7e, 0x02, 0x02, 0x7c, 0x00, 0x00 },	// U+2208 (∈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x12, 0x12, 0x7e, 0x12, 0x12, 0x7c, 0x10, 0x00 },	// U+2209 (∉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x7e, 0x02, 0x7c, 0x00, 0x00 },	// U+220A (∊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x7e, 0x40, 0x40, 0x3e, 0x00, 0x00 },	// U+220B (∋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x48, 0x48, 0x7e, 0x48, 0x48, 0x3e, 0x08, 0x00 },	// U+220C (∌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x7e, 0x40, 0x3e, 0x00, 0x00 },	// U+220D (∍)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00 },	// U+220E (∎)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xee, 0x00 },	// U+220F (∏)
	{ 0x00, 0x00, 0x00, 0x00, 0xee, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfe, 0x00 },	// U+2210 (∐)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x42, 0x7e, 0x00 },	// U+2211 (∑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2212 (−)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2213 (∓)
	{ 0x00, 0x00, 0x10, 0x38, 0x10, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2214 (∔)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x00, 0x00 },	// U+2215 (∕)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x00, 0x00 },	// U+2216 (∖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x54, 0x38, 0x10, 0x38, 0x54, 0x10, 0x00, 0x00, 0x00 },	// U+2217 (∗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2218 (∘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2219 (∙)
	{ 0x00, 0x00, 0xe0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2e, 0x28, 0x28, 0x30, 0x30, 0x20, 0x20, 0x00 },	// U+221A (√)
	{ 0x00, 0x00, 0xe6, 0x28, 0x26, 0x28, 0x26, 0x20, 0x2e, 0x28, 0x28, 0x30, 0x30, 0x20, 0x20, 0x00 },	// U+221B (∛)
	{ 0x00, 0x00, 0xea, 0x2a, 0x2e, 0x28, 0x28, 0x20, 0x2e, 0x28, 0x28, 0x30, 0x30, 0x20, 0x20, 0x00 },	// U+221C (∜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x12, 0x12, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+221D (∝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+221E (∞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+221F (∟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x7e, 0x00, 0x00 },	// U+2220 (∠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x28, 0x10, 0x28, 0x24, 0x7e, 0x20, 0x00 },	// U+2221 (∡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x30, 0x28, 0x26, 0x28, 0x30, 0x50, 0x00, 0x00 },	// U+2222 (∢)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+2223 (∣)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x58, 0x38, 0x18, 0x18, 0x1c, 0x1a, 0x18, 0x18, 0x00, 0x00 },	// U+2224 (∤)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+2225 (∥)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x64, 0x24, 0x34, 0x2c, 0x24, 0x26, 0x24, 0x24, 0x00, 0x00 },	// U+2226 (∦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00, 0x00 },	// U+2227 (∧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+2228 (∨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+2229 (∩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+222A (∪)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+222B (∫)
	{ 0x00, 0x50, 0xa8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2a, 0x16, 0x00 },	// U+222C (∬)
	{ 0x00, 0xa8, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x55, 0x2b, 0x00 },	// U+222D (∭)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x38, 0x54, 0x54, 0x38, 0x10, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+222E (∮)
	{ 0x00, 0x50, 0xa8, 0x28, 0x28, 0x28, 0x7c, 0xaa, 0xaa, 0x7c, 0x28, 0x28, 0x28, 0x2a, 0x16, 0x00 },	// U+222F (∯)
	{ 0x00, 0xa8, 0x54, 0x54, 0x54, 0x7e, 0xd5, 0xd5, 0xd5, 0x7e, 0x54, 0x54, 0x54, 0x55, 0x2b, 0x00 },	// U+2230 (∰)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0xb8, 0xd4, 0xf4, 0x10, 0x10, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2231 (∱)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0xb8, 0xd4, 0xf4, 0x54, 0x38, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2232 (∲)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x3a, 0x56, 0x5e, 0x54, 0x38, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2233 (∳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00 },	// U+2234 (∴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2235 (∵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2236 (∶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00 },	// U+2237 (∷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2238 (∸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x1e, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00 },	// U+2239 (∹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x7e, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00 },	// U+223A (∺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x4c, 0x32, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+223B (∻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+223C (∼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+223D (∽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x92, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+223E (∾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x92, 0x90, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+223F (∿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x10, 0x10, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+2240 (≀)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x5c, 0x32, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2241 (≁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x00 },	// U+2242 (≂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2243 (≃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x5c, 0x32, 0x10, 0x10, 0x7e, 0x10, 0x10, 0x00, 0x00 },	// U+2244 (≄)
	{ 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2245 (≅)
	{ 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x10, 0x7e, 0x10, 0x10, 0x7e, 0x10, 0x10, 0x00, 0x00 },	// U+2246 (≆)
	{ 0x00, 0x00, 0x10, 0x10, 0x5c, 0x32, 0x10, 0x10, 0x7e, 0x10, 0x10, 0x7e, 0x10, 0x10, 0x00, 0x00 },	// U+2247 (≇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x00, 0x00 },	// U+2248 (≈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x5c, 0x32, 0x10, 0x5c, 0x32, 0x10, 0x10, 0x00, 0x00 },	// U+2249 (≉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x4c, 0x32, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+224A (≊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x4c, 0x32, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x00 },	// U+224B (≋)
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+224C (≌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x3c, 0x00, 0x00, 0x3c, 0x42, 0x00, 0x00, 0x00, 0x00 },	// U+224D (≍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x66, 0x00, 0x00, 0x66, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+224E (≎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x66, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+224F (≏)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2250 (≐)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2251 (≑)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00 },	// U+2252 (≒)
	{ 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2253 (≓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2254 (≔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x00, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2255 (≕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24, 0x24, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2256 (≖)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2257 (≗)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2258 (≘)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2259 (≙)
	{ 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+225A (≚)
	{ 0x00, 0x00, 0x10, 0x7c, 0x38, 0x28, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+225B (≛)
	{ 0x00, 0x00, 0x10, 0x28, 0x44, 0x7c, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+225C (≜)
	{ 0x00, 0x00, 0x48, 0x28, 0x6e, 0x2a, 0x2e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00 },	// U+225D (≝)
	{ 0x00, 0x00, 0x00, 0x16, 0x2a, 0x2a, 0x2a, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+225E (≞)
	{ 0x00, 0x0c, 0x12, 0x10, 0x08, 0x08, 0x00, 0x08, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00 },	// U+225F (≟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x7e, 0x10, 0x08, 0x7e, 0x04, 0x02, 0x00, 0x00 },	// U+2260 (≠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2261 (≡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x7e, 0x10, 0x7e, 0x08, 0x7e, 0x04, 0x02, 0x00, 0x00 },	// U+2262 (≢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2263 (≣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x18, 0x06, 0x18, 0x60, 0x00, 0x7e, 0x00, 0x00, 0x00 },	// U+2264 (≤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x60, 0x18, 0x06, 0x00, 0x7e, 0x00, 0x00, 0x00 },	// U+2265 (≥)
	{ 0x00, 0x00, 0x00, 0x60, 0x18, 0x06, 0x18, 0x60, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00 },	// U+2266 (≦)
	{ 0x00, 0x00, 0x00, 0x06, 0x18, 0x60, 0x18, 0x06, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00 },	// U+2267 (≧)
	{ 0x00, 0x00, 0x00, 0x60, 0x18, 0x06, 0x18, 0x68, 0x08, 0x7e, 0x08, 0x08, 0x7e, 0x08, 0x08, 0x00 },	// U+2268 (≨)
	{ 0x00, 0x00, 0x00, 0x06, 0x18, 0x60, 0x18, 0x16, 0x10, 0x7e, 0x10, 0x10, 0x7e, 0x10, 0x10, 0x00 },	// U+2269 (≩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x48, 0x24, 0x12, 0x09, 0x12, 0x24, 0x48, 0x90, 0x00, 0x00 },	// U+226A (≪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x24, 0x48, 0x90, 0x48, 0x24, 0x12, 0x09, 0x00, 0x00 },	// U+226B (≫)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x18, 0x24, 0x24, 0x24, 0x24, 0x18, 0x18, 0x24, 0x00, 0x00 },	// U+226C (≬)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x52, 0x3c, 0x10, 0x10, 0x3c, 0x52, 0x10, 0x10, 0x00, 0x00 },	// U+226D (≭)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x50, 0x30, 0x10, 0x18, 0x14, 0x18, 0x10, 0x30, 0x50, 0x10, 0x00 },	// U+226E (≮)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0a, 0x0c, 0x08, 0x18, 0x28, 0x18, 0x08, 0x0c, 0x0a, 0x08, 0x00 },	// U+226F (≯)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x70, 0x18, 0x16, 0x18, 0x70, 0x10, 0x7e, 0x10, 0x10, 0x00 },	// U+2270 (≰)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0e, 0x18, 0x68, 0x18, 0x0e, 0x08, 0x7e, 0x08, 0x08, 0x00 },	// U+2271 (≱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x18, 0x06, 0x18, 0x60, 0x00, 0x4c, 0x32, 0x00, 0x00 },	// U+2272 (≲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x60, 0x18, 0x06, 0x00, 0x4c, 0x32, 0x00, 0x00 },	// U+2273 (≳)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x70, 0x18, 0x16, 0x18, 0x70, 0x10, 0x5c, 0x32, 0x10, 0x00 },	// U+2274 (≴)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0e, 0x18, 0x68, 0x18, 0x0e, 0x08, 0x4c, 0x3a, 0x08, 0x00 },	// U+2275 (≵)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x18, 0x06, 0x18, 0x60, 0x06, 0x18, 0x60, 0x18, 0x06, 0x00, 0x00 },	// U+2276 (≶)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x60, 0x18, 0x06, 0x60, 0x18, 0x06, 0x18, 0x60, 0x00, 0x00 },	// U+2277 (≷)
	{ 0x00, 0x00, 0x10, 0x10, 0x70, 0x18, 0x16, 0x18, 0x70, 0x16, 0x18, 0x70, 0x18, 0x16, 0x10, 0x00 },	// U+2278 (≸)
	{ 0x00, 0x00, 0x10, 0x10, 0x16, 0x18, 0x70, 0x18, 0x16, 0x70, 0x18, 0x16, 0x18, 0x70, 0x10, 0x00 },	// U+2279 (≹)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x18, 0x06, 0x18, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+227A (≺)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x18, 0x60, 0x18, 0x04, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+227B (≻)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x18, 0x06, 0x18, 0x20, 0x40, 0x00, 0x7e, 0x00, 0x00 },	// U+227C (≼)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x18, 0x60, 0x18, 0x04, 0x02, 0x00, 0x7e, 0x00, 0x00 },	// U+227D (≽)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x18, 0x06, 0x18, 0x20, 0x40, 0x4c, 0x32, 0x00, 0x00 },	// U+227E (≾)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x18, 0x60, 0x18, 0x04, 0x02, 0x4c, 0x32, 0x00, 0x00 },	// U+227F (≿)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x48, 0x28, 0x18, 0x0e, 0x18, 0x28, 0x48, 0x40, 0x00, 0x00, 0x00 },	// U+2280 (⊀)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x12, 0x14, 0x18, 0x70, 0x18, 0x14, 0x12, 0x02, 0x00, 0x00, 0x00 },	// U+2281 (⊁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+2282 (⊂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2283 (⊃)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x12, 0x12, 0x12, 0x12, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+2284 (⊄)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x48, 0x48, 0x48, 0x48, 0x3e, 0x08, 0x08, 0x00, 0x00 },	// U+2285 (⊅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x7e, 0x00, 0x00 },	// U+2286 (⊆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x7e, 0x00, 0x00 },	// U+2287 (⊇)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x12, 0x12, 0x12, 0x12, 0x7c, 0x10, 0x7e, 0x10, 0x00 },	// U+2288 (⊈)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x48, 0x48, 0x48, 0x48, 0x3e, 0x08, 0x7e, 0x08, 0x00 },	// U+2289 (⊉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x10, 0x7e, 0x10, 0x00 },	// U+228A (⊊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x08, 0x7e, 0x08, 0x00 },	// U+228B (⊋)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x52, 0x4a, 0x7e, 0x4a, 0x52, 0x42, 0x3c, 0x00, 0x00 },	// U+228C (⊌)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+228D (⊍)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x4a, 0x4a, 0x5e, 0x4a, 0x4a, 0x42, 0x3c, 0x00, 0x00 },	// U+228E (⊎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+228F (⊏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2290 (⊐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x7e, 0x00, 0x00 },	// U+2291 (⊑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x7e, 0x00, 0x00 },	// U+2292 (⊒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00 },	// U+2293 (⊓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2294 (⊔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x54, 0x92, 0xfe, 0x92, 0x54, 0x38, 0x00, 0x00, 0x00 },	// U+2295 (⊕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0xfe, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+2296 (⊖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0xaa, 0x92, 0xaa, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+2297 (⊗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0xa2, 0x92, 0x8a, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+2298 (⊘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x92, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+2299 (⊙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x92, 0xaa, 0x92, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+229A (⊚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x92, 0xba, 0x92, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+229B (⊛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0xba, 0x82, 0xba, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+229C (⊜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0xba, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+229D (⊝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x92, 0x92, 0xfe, 0x92, 0x92, 0xfe, 0x00, 0x00, 0x00 },	// U+229E (⊞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0xfe, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+229F (⊟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xaa, 0x92, 0xaa, 0xc6, 0xfe, 0x00, 0x00, 0x00 },	// U+22A0 (⊠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x92, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+22A1 (⊡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x7e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+22A2 (⊢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7e, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+22A3 (⊣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+22A4 (⊤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x00, 0x00, 0x00 },	// U+22A5 (⊥)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+22A6 (⊦)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+22A7 (⊧)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x02, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+22A8 (⊨)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x7a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+22A9 (⊩)
	{ 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0xea, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x00 },	// U+22AA (⊪)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x7a, 0x0a, 0x7a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+22AB (⊫)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x12, 0x12, 0x12, 0x7e, 0x12, 0x12, 0x12, 0x02, 0x02, 0x00, 0x00 },	// U+22AC (⊬)
	{ 0x00, 0x00, 0x00, 0x02, 0x12, 0x12, 0x12, 0x7e, 0x12, 0x7e, 0x12, 0x12, 0x12, 0x02, 0x00, 0x00 },	// U+22AD (⊭)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x2a, 0x2a, 0x2a, 0x7a, 0x2a, 0x2a, 0x2a, 0x0a, 0x0a, 0x00, 0x00 },	// U+22AE (⊮)
	{ 0x00, 0x00, 0x00, 0x0a, 0x2a, 0x2a, 0x2a, 0x7a, 0x2a, 0x7a, 0x2a, 0x2a, 0x2a, 0x0a, 0x00, 0x00 },	// U+22AF (⊯)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x20, 0x18, 0x06, 0x18, 0x20, 0x40, 0x30, 0x00, 0x00, 0x00 },	// U+22B0 (⊰)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x04, 0x18, 0x60, 0x18, 0x04, 0x02, 0x0c, 0x00, 0x00, 0x00 },	// U+22B1 (⊱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x58, 0x46, 0x58, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+22B2 (⊲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1a, 0x62, 0x1a, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+22B3 (⊳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x58, 0x46, 0x58, 0x60, 0x00, 0x7e, 0x00, 0x00 },	// U+22B4 (⊴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1a, 0x62, 0x1a, 0x06, 0x00, 0x7e, 0x00, 0x00 },	// U+22B5 (⊵)
}; // 182

static const unsigned char unifont_block186[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0xc6, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+22B9 (⊹)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+22BA (⊺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x7c, 0x00, 0x00 },	// U+22BB (⊻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x10, 0x28, 0x28, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00 },	// U+22BC (⊼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+22BD (⊽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x1e, 0x12, 0x12, 0x7e, 0x00, 0x00 },	// U+22BE (⊾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x50, 0x48, 0x44, 0x7e, 0x00, 0x00 },	// U+22BF (⊿)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x28, 0x44, 0x44, 0x44, 0x82, 0x82, 0x82, 0x00, 0x00 },	// U+22C0 (⋀)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10, 0x00, 0x00 },	// U+22C1 (⋁)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+22C2 (⋂)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+22C3 (⋃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+22C4 (⋄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22C5 (⋅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x38, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22C6 (⋆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x42, 0x24, 0x7e, 0x24, 0x42, 0x18, 0x00, 0x00, 0x00 },	// U+22C7 (⋇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+22C8 (⋈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x46, 0x2a, 0x12, 0x2a, 0x46, 0x82, 0x00, 0x00, 0x00 },	// U+22C9 (⋉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc4, 0xa8, 0x90, 0xa8, 0xc4, 0x82, 0x00, 0x00, 0x00 },	// U+22CA (⋊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00 },	// U+22CB (⋋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00 },	// U+22CC (⋌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+22CD (⋍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+22CE (⋎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x28, 0x44, 0x44, 0x82, 0x00, 0x00, 0x00 },	// U+22CF (⋏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x7a, 0x0a, 0x0a, 0x7a, 0x02, 0x7c, 0x00, 0x00 },	// U+22D0 (⋐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x5e, 0x50, 0x50, 0x5e, 0x40, 0x3e, 0x00, 0x00 },	// U+22D1 (⋑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00 },	// U+22D2 (⋒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 0x82, 0x7c, 0x00, 0x00 },	// U+22D3 (⋓)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x38, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x00, 0x00 },	// U+22D4 (⋔)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x7e, 0x24, 0x24, 0x7e, 0x24, 0x24, 0x00, 0x00 },	// U+22D5 (⋕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x44, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00 },	// U+22D6 (⋖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x22, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+22D7 (⋗)
}; // 31

static const unsigned char unifont_block187[][16] = {
	{ 0x00, 0x60, 0x18, 0x06, 0x18, 0x60, 0x00, 0x7e, 0x00, 0x06, 0x18, 0x60, 0x18, 0x06, 0x00, 0x00 },	// U+22DA (⋚)
	{ 0x00, 0x06, 0x18, 0x60, 0x18, 0x06, 0x00, 0x7e, 0x00, 0x60, 0x18, 0x06, 0x18, 0x60, 0x00, 0x00 },	// U+22DB (⋛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x60, 0x18, 0x06, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+22DC (⋜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x06, 0x18, 0x60, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+22DD (⋝)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x18, 0x06, 0x18, 0x20, 0x40, 0x40, 0x00, 0x00 },	// U+22DE (⋞)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x04, 0x18, 0x60, 0x18, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+22DF (⋟)
	{ 0x00, 0x00, 0x00, 0x10, 0x50, 0x50, 0x30, 0x18, 0x16, 0x18, 0x30, 0x50, 0x50, 0x7e, 0x10, 0x00 },	// U+22E0 (⋠)
	{ 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x14, 0x18, 0x70, 0x18, 0x14, 0x12, 0x12, 0x7e, 0x10, 0x00 },	// U+22E1 (⋡)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7e, 0x12, 0x12, 0x12, 0x12, 0x7e, 0x10, 0x7e, 0x10, 0x00 },	// U+22E2 (⋢)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7e, 0x50, 0x50, 0x50, 0x50, 0x7e, 0x10, 0x7e, 0x10, 0x00 },	// U+22E3 (⋣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x10, 0x7e, 0x10, 0x00 },	// U+22E4 (⋤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x10, 0x7e, 0x10, 0x00 },	// U+22E5 (⋥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x18, 0x06, 0x18, 0x60, 0x10, 0x5c, 0x32, 0x10, 0x10, 0x00 },	// U+22E6 (⋦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x60, 0x18, 0x06, 0x10, 0x5c, 0x32, 0x10, 0x10, 0x00 },	// U+22E7 (⋧)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x18, 0x06, 0x18, 0x20, 0x50, 0x5c, 0x32, 0x10, 0x10, 0x00 },	// U+22E8 (⋨)
	{ 0x00, 0x00, 0x02, 0x02, 0x04, 0x18, 0x60, 0x18, 0x04, 0x02, 0x12, 0x5c, 0x32, 0x10, 0x10, 0x00 },	// U+22E9 (⋩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x70, 0x58, 0x56, 0x58, 0x70, 0x10, 0x10, 0x00, 0x00 },	// U+22EA (⋪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x16, 0x1a, 0x72, 0x1a, 0x16, 0x10, 0x10, 0x00, 0x00 },	// U+22EB (⋫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x70, 0x58, 0x56, 0x58, 0x70, 0x10, 0x7e, 0x10, 0x00 },	// U+22EC (⋬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x16, 0x1a, 0x72, 0x1a, 0x16, 0x10, 0x7e, 0x10, 0x00 },	// U+22ED (⋭)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+22EE (⋮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22EF (⋯)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00 },	// U+22F0 (⋰)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00 },	// U+22F1 (⋱)
}; // 24

static const unsigned char unifont_block188[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x42, 0x7e, 0x42, 0x02, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+22F4 (⋴)
}; // 1

static const unsigned char unifont_block189[][16] = {
	{ 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7c, 0x02, 0x02, 0x7e, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+22F7 (⋷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x7e, 0x02, 0x02, 0x7c, 0x00, 0x7e },	// U+22F8 (⋸)
}; // 2

static const unsigned char unifont_block190[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x42, 0x7e, 0x42, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+22FC (⋼)
}; // 1

static const unsigned char unifont_block191[][16] = {
	{ 0x00, 0x00, 0x00, 0x7e, 0x00, 0x3e, 0x40, 0x40, 0x7e, 0x40, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+22FE (⋾)
}; // 1

static const unsigned char unifont_block192[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x1a, 0x2c, 0x48, 0x00, 0x00, 0x00, 0x00 },	// U+2301 (⌁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x00, 0x00 },	// U+2302 (⌂)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2303 (⌃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00 },	// U+2304 (⌄)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2305 (⌅)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2306 (⌆)
	{ 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x10, 0x08, 0x10, 0x20, 0x10, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+2307 (⌇)
	{ 0x00, 0x00, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2308 (⌈)
	{ 0x00, 0x00, 0x1e, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2309 (⌉)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x00, 0x00 },	// U+230A (⌊)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x00, 0x00 },	// U+230B (⌋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+230C (⌌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+230D (⌍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+230E (⌎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+230F (⌏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+2310 (⌐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x7c, 0x44, 0x44, 0x44, 0x7c, 0x82, 0x00, 0x00, 0x00 },	// U+2311 (⌑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00 },	// U+2312 (⌒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+2313 (⌓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00 },	// U+2314 (⌔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x8a, 0x44, 0x3a, 0x00, 0x00 },	// U+2315 (⌕)
}; // 21

static const unsigned char unifont_block193[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0xff, 0x24, 0x24, 0xff, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+2317 (⌗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xaa, 0x7c, 0x28, 0x7c, 0xaa, 0x44, 0x00, 0x00, 0x00, 0x00 },	// U+2318 (⌘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2319 (⌙)
	{ 0x00, 0x14, 0x14, 0x14, 0x14, 0x1c, 0x2a, 0x49, 0xd9, 0x41, 0x22, 0x1c, 0x14, 0x14, 0x14, 0x00 },	// U+231A (⌚)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x3c, 0x7e, 0x00, 0x00 },	// U+231B (⌛)
	{ 0x00, 0x1e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+231C (⌜)
	{ 0x00, 0x78, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+231D (⌝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x1e, 0x00 },	// U+231E (⌞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x78, 0x00 },	// U+231F (⌟)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2320 (⌠)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2321 (⌡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2322 (⌢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2323 (⌣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2324 (⌤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2325 (⌥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x55, 0x89, 0x55, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2326 (⌦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xaa, 0x92, 0xaa, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2327 (⌧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2328 (⌨)
}; // 18

static const unsigned char unifont_block194[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xaa, 0x91, 0xaa, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+232B (⌫)
}; // 1

static const unsigned char unifont_block195[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x00, 0x00 },	// U+2336 (⌶)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7c, 0x00, 0x00 },	// U+2337 (⌷)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0xfe, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+2338 (⌸)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0x92, 0x92, 0x82, 0xfe, 0x82, 0x92, 0x92, 0x82, 0xfe, 0x00, 0x00 },	// U+2339 (⌹)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0xc6, 0xaa, 0x92, 0x82, 0xfe, 0x00, 0x00 },	// U+233A (⌺)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xaa, 0x92, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+233B (⌻)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0xba, 0xc6, 0x82, 0x82, 0xc6, 0xba, 0x82, 0xfe, 0x00, 0x00 },	// U+233C (⌼)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x54, 0x92, 0x92, 0x92, 0x54, 0x38, 0x10, 0x10, 0x00, 0x00 },	// U+233D (⌽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x92, 0xaa, 0x92, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+233E (⌾)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x10, 0x10, 0xff, 0x08, 0x04, 0x04, 0x02, 0x00, 0x00 },	// U+233F (⌿)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x04, 0x08, 0x08, 0xff, 0x10, 0x20, 0x20, 0x40, 0x00, 0x00 },	// U+2340 (⍀)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0xc2, 0xa2, 0xa2, 0x92, 0x8a, 0x8a, 0x86, 0x82, 0xfe, 0x00, 0x00 },	// U+2341 (⍁)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0x86, 0x8a, 0x8a, 0x92, 0xa2, 0xa2, 0xc2, 0x82, 0xfe, 0x00, 0x00 },	// U+2342 (⍂)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0xe2, 0x9a, 0x86, 0x9a, 0xe2, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+2343 (⍃)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x8e, 0xb2, 0xc2, 0xb2, 0x8e, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+2344 (⍄)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x14, 0xfe, 0x14, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2345 (⍅)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x50, 0xfe, 0x50, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2346 (⍆)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x92, 0x8a, 0xfe, 0x8a, 0x92, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+2347 (⍇)
	{ 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x92, 0xa2, 0xfe, 0xa2, 0x92, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+2348 (⍈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x44, 0x8a, 0x92, 0xa2, 0x44, 0xb8, 0x00, 0x00 },	// U+2349 (⍉)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x00, 0xfe, 0x00, 0x00 },	// U+234A (⍊)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x38, 0x38, 0x54, 0x54, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+234B (⍋)
	{ 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x82, 0xc6, 0xc6, 0xaa, 0xaa, 0x92, 0x82, 0xfe, 0x00, 0x00 },	// U+234C (⍌)
	{ 0x00, 0x00, 0xfe, 0x82, 0x82, 0x92, 0x92, 0xaa, 0xaa, 0xc6, 0xc6, 0xfe, 0x82, 0xfe, 0x00, 0x00 },	// U+234D (⍍)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x38, 0x54, 0x54, 0x38, 0x10, 0x10, 0xfe, 0x00, 0x00 },	// U+234E (⍎)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+234F (⍏)
	{ 0x00, 0x00, 0xfe, 0x92, 0xba, 0xd6, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+2350 (⍐)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2351 (⍑)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x54, 0x54, 0x38, 0x38, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2352 (⍒)
	{ 0x00, 0x00, 0xfe, 0x82, 0x92, 0xaa, 0xaa, 0xc6, 0xc6, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+2353 (⍓)
	{ 0x00, 0x00, 0xfe, 0x82, 0x82, 0xfe, 0xc6, 0xc6, 0xaa, 0xaa, 0x92, 0x92, 0x82, 0xfe, 0x00, 0x00 },	// U+2354 (⍔)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x38, 0x54, 0x54, 0x38, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2355 (⍕)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+2356 (⍖)
	{ 0x00, 0x00, 0xfe, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xd6, 0xba, 0x92, 0xfe, 0x00, 0x00 },	// U+2357 (⍗)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00 },	// U+2358 (⍘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x7c, 0x00, 0x7c, 0x00, 0x00 },	// U+2359 (⍙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0x44, 0x28, 0x10, 0x00, 0x7c, 0x00, 0x00 },	// U+235A (⍚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x7c, 0x00, 0x00 },	// U+235B (⍛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0xfe, 0x00, 0x00 },	// U+235C (⍜)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x92, 0xaa, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00 },	// U+235D (⍝)
	{ 0x00, 0x00, 0xfe, 0x82, 0x92, 0x92, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+235E (⍞)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x92, 0xfe, 0xba, 0xaa, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+235F (⍟)
	{ 0x00, 0x00, 0xfe, 0x82, 0x82, 0x92, 0x92, 0x82, 0x82, 0x92, 0x92, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+2360 (⍠)
	{ 0x00, 0x24, 0x24, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2361 (⍡)
	{ 0x00, 0x24, 0x24, 0x00, 0x00, 0x7c, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2362 (⍢)
	{ 0x00, 0x24, 0x24, 0x00, 0x00, 0x10, 0x7c, 0x38, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2363 (⍣)
	{ 0x00, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2364 (⍤)
	{ 0x00, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00 },	// U+2365 (⍥)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+2366 (⍦)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0xf8, 0x14, 0x12, 0x12, 0x12, 0x14, 0xf8, 0x10, 0x10, 0x00, 0x00 },	// U+2367 (⍧)
	{ 0x00, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2368 (⍨)
	{ 0x00, 0x24, 0x24, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00 },	// U+2369 (⍩)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+236A (⍪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x44, 0x28, 0x28, 0x9c, 0x72, 0x00, 0x00, 0x00, 0x00 },	// U+236B (⍫)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0xcc, 0x76, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+236C (⍬)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x5c, 0x32, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+236D (⍭)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08, 0x00, 0x7c, 0x00, 0x00 },	// U+236E (⍮)
	{ 0x00, 0x00, 0xfe, 0x82, 0xc2, 0xa2, 0xfe, 0x92, 0xfe, 0x8a, 0x86, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+236F (⍯)
	{ 0x00, 0x00, 0xfe, 0x82, 0x92, 0xaa, 0xaa, 0xa2, 0x92, 0x92, 0x82, 0x92, 0x82, 0xfe, 0x00, 0x00 },	// U+2370 (⍰)
	{ 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2371 (⍱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x10, 0x28, 0x28, 0x44, 0x44, 0x00, 0x00, 0x00 },	// U+2372 (⍲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x60, 0x00, 0x00 },	// U+2373 (⍳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+2374 (⍴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x44, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+2375 (⍵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x7e, 0x00, 0x00 },	// U+2376 (⍶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x7c, 0x00, 0x7e, 0x00, 0x00 },	// U+2377 (⍷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x60, 0x00, 0x78, 0x00, 0x00 },	// U+2378 (⍸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0xfe, 0x00, 0x00 },	// U+2379 (⍹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x22, 0x22, 0x22, 0x22, 0x52, 0x4c, 0x00, 0x00 },	// U+237A (⍺)
}; // 69

static const unsigned char unifont_block196[][16] = {
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x7c, 0x38, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+237F (⍿)
	{ 0x00, 0x00, 0x00, 0x1c, 0x20, 0x3c, 0x22, 0x22, 0x5c, 0x00, 0x41, 0x22, 0x14, 0x08, 0x00, 0x00 },	// U+2380 (⎀)
}; // 2

static const unsigned char unifont_block197[][16] = {
	{ 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+2395 (⎕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x1e, 0x1e, 0x0e, 0x0e, 0x06, 0x06, 0x02, 0x00 },	// U+2396 (⎖)
}; // 2

static const unsigned char unifont_block198[][16] = {
	{ 0x00, 0x70, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+239B (⎛)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+239C (⎜)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x70 },	// U+239D (⎝)
	{ 0x00, 0x0e, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },	// U+239E (⎞)
	{ 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },	// U+239F (⎟)
	{ 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0e },	// U+23A0 (⎠)
	{ 0x00, 0x7c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+23A1 (⎡)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+23A2 (⎢)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x7c },	// U+23A3 (⎣)
	{ 0x00, 0x3e, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },	// U+23A4 (⎤)
	{ 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },	// U+23A5 (⎥)
	{ 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3e },	// U+23A6 (⎦)
	{ 0x00, 0x60, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+23A7 (⎧)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x04, 0x02, 0x04, 0x08, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+23A8 (⎨)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x60 },	// U+23A9 (⎩)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+23AA (⎪)
	{ 0x00, 0x06, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+23AB (⎫)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 0x20, 0x40, 0x20, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+23AC (⎬)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x06 },	// U+23AD (⎭)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+23AE (⎮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23AF (⎯)
	{ 0x00, 0x60, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x06 },	// U+23B0 (⎰)
	{ 0x00, 0x06, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x60 },	// U+23B1 (⎱)
}; // 23

static const unsigned char unifont_block199[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x40, 0x40, 0x46, 0x24, 0x28, 0x28, 0x10, 0x00, 0x00 },	// U+23B7 (⎷)
	{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+23B8 (⎸)
	{ 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },	// U+23B9 (⎹)
	{ 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BA (⎺)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BB (⎻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00 },	// U+23BC (⎼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff },	// U+23BD (⎽)
	{ 0x00, 0xfc, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+23BE (⎾)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xfc, 0x00 },	// U+23BF (⎿)
}; // 9

static const unsigned char unifont_block200[][16] = {
	{ 0x00, 0x3f, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00 },	// U+23CB (⏋)
	{ 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3f, 0x00 },	// U+23CC (⏌)
}; // 2

static const unsigned char unifont_block201[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x00, 0x7f, 0x7f, 0x7f, 0x00, 0x00 },	// U+23CF (⏏)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+23D0 (⏐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23D1 (⏑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23D2 (⏒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x22, 0x1c, 0x00, 0x7f, 0x00, 0x00, 0x00 },	// U+23D3 (⏓)
}; // 5

static const unsigned char unifont_block202[][16] = {
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x00, 0x38, 0x00, 0x10 },	// U+23DA (⏚)
}; // 1

static const unsigned char unifont_block203[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x56, 0x54, 0x54, 0x54, 0x24, 0x00, 0x00 },	// U+23E8 (⏨)
}; // 1

static const unsigned char unifont_block204[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x18, 0x08, 0x0c, 0x3a, 0x48, 0x48, 0x48, 0x48, 0x38, 0x00, 0x00 },	// U+2422 (␢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x7e, 0x00, 0x00 },	// U+2423 (␣)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x16, 0x1a, 0x12, 0x00, 0x08, 0x08, 0x08, 0x78, 0x00, 0x00, 0x00 },	// U+2424 (␤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x50, 0xa8, 0x54, 0x2a, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2425 (␥)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x04, 0x08, 0x08, 0x00, 0x08, 0x08, 0x00, 0x00 },	// U+2426 (␦)
}; // 5

static const unsigned char unifont_block205[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x50, 0x50, 0x50, 0x10, 0x10, 0x14, 0x14, 0x14, 0x1c, 0x00, 0x00 },	// U+2440 (⑀)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+2441 (⑁)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2442 (⑂)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+2443 (⑃)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x54, 0x54, 0x54, 0x10, 0x10, 0x54, 0x54, 0x54, 0x7c, 0x00, 0x00 },	// U+2444 (⑄)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x6c, 0x54, 0x6c, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2445 (⑅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x76, 0x76, 0x06, 0x06, 0x76, 0x76, 0x70, 0x00, 0x00, 0x00 },	// U+2446 (⑆)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xd8, 0x18, 0x18, 0x1b, 0x03, 0x03, 0x03, 0x00, 0x00 },	// U+2447 (⑇)
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0xea, 0xea, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2448 (⑈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0x00, 0x00 },	// U+2449 (⑉)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0a, 0x14, 0x14, 0x28, 0x28, 0x50, 0xa0, 0xa0, 0x00, 0x00 },	// U+244A (⑊)
}; // 11

static const unsigned char unifont_block206[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2500 (─)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2501 (━)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2502 (│)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2503 (┃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2504 (┄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2505 (┅)
	{ 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10 },	// U+2506 (┆)
	{ 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18 },	// U+2507 (┇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2508 (┈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2509 (┉)
	{ 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00 },	// U+250A (┊)
	{ 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00 },	// U+250B (┋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+250C (┌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+250D (┍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+250E (┎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+250F (┏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2510 (┐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2511 (┑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2512 (┒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2513 (┓)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2514 (└)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2515 (┕)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2516 (┖)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2517 (┗)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2518 (┘)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2519 (┙)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251A (┚)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251B (┛)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+251C (├)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+251D (┝)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+251E (┞)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+251F (┟)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2520 (┠)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2521 (┡)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2522 (┢)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2523 (┣)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2524 (┤)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2525 (┥)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2526 (┦)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2527 (┧)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2528 (┨)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2529 (┩)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+252A (┪)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+252B (┫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+252C (┬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+252D (┭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+252E (┮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+252F (┯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2530 (┰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2531 (┱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2532 (┲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2533 (┳)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2534 (┴)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2535 (┵)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2536 (┶)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2537 (┷)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2538 (┸)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2539 (┹)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253A (┺)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253B (┻)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+253C (┼)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+253D (┽)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+253E (┾)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+253F (┿)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2540 (╀)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2541 (╁)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2542 (╂)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2543 (╃)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xf8, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2544 (╄)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2545 (╅)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2546 (╆)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2547 (╇)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2548 (╈)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2549 (╉)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+254A (╊)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+254B (╋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+254C (╌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+254D (╍)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+254E (╎)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+254F (╏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2550 (═)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2551 (║)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2552 (╒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2553 (╓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0xe8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2554 (╔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2555 (╕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2556 (╖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x20, 0x2f, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2557 (╗)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x10, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2558 (╘)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2559 (╙)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xe8, 0x08, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255A (╚)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255B (╛)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255C (╜)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2f, 0x20, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255D (╝)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+255E (╞)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xe8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+255F (╟)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xe8, 0x08, 0xe8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2560 (╠)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x10, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2561 (╡)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2f, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2562 (╢)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2f, 0x20, 0x2f, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2563 (╣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2564 (╤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2565 (╥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xef, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2566 (╦)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2567 (╧)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2568 (╨)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xef, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2569 (╩)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x10, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+256A (╪)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xff, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+256B (╫)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xef, 0x00, 0xef, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+256C (╬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+256D (╭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+256E (╮)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+256F (╯)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2570 (╰)
	{ 0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01 },	// U+2571 (╱)
	{ 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x80, 0x80 },	// U+2572 (╲)
	{ 0x81, 0x81, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x81, 0x81 },	// U+2573 (╳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2574 (╴)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2575 (╵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2576 (╶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2577 (╷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2578 (╸)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2579 (╹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257A (╺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+257B (╻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257C (╼)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+257D (╽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257E (╾)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+257F (╿)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2580 (▀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff },	// U+2581 (▁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff },	// U+2582 (▂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2583 (▃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2584 (▄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2585 (▅)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2586 (▆)
	{ 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2587 (▇)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2588 (█)
	{ 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f },	// U+2589 (▉)
	{ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+258A (▊)
	{ 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f },	// U+258B (▋)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+258C (▌)
	{ 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+258D (▍)
	{ 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 },	// U+258E (▎)
	{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+258F (▏)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+2590 (▐)
	{ 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44 },	// U+2591 (░)
	{ 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa },	// U+2592 (▒)
	{ 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd },	// U+2593 (▓)
	{ 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2594 (▔)
	{ 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },	// U+2595 (▕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+2596 (▖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+2597 (▗)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2598 (▘)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2599 (▙)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+259A (▚)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+259B (▛)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+259C (▜)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+259D (▝)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+259E (▞)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+259F (▟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00 },	// U+25A0 (■)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+25A1 (□)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+25A2 (▢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0xba, 0xba, 0xba, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+25A3 (▣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0xfe, 0x82, 0xfe, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+25A4 (▤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xfe, 0x00, 0x00, 0x00 },	// U+25A5 (▥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xaa, 0xfe, 0xaa, 0xfe, 0xaa, 0xfe, 0x00, 0x00, 0x00 },	// U+25A6 (▦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xca, 0x92, 0xa6, 0xca, 0x92, 0xfe, 0x00, 0x00, 0x00 },	// U+25A7 (▧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xa6, 0x92, 0xca, 0xa6, 0x92, 0xfe, 0x00, 0x00, 0x00 },	// U+25A8 (▨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xaa, 0xd6, 0xaa, 0xd6, 0xaa, 0xfe, 0x00, 0x00, 0x00 },	// U+25A9 (▩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+25AA (▪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25AB (▫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25AC (▬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25AD (▭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+25AE (▮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+25AF (▯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7e, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B0 (▰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x42, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B1 (▱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B2 (▲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x24, 0x24, 0x42, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B3 (△)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B4 (▴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B5 (▵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1e, 0x7e, 0x7e, 0x1e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B6 (▶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1a, 0x62, 0x62, 0x1a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B7 (▷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x3c, 0x3c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B8 (▸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x34, 0x34, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B9 (▹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1e, 0x7e, 0x1e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25BA (►)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1a, 0x62, 0x1a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25BB (▻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25BC (▼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x24, 0x24, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25BD (▽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25BE (▾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25BF (▿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x78, 0x7e, 0x7e, 0x78, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25C0 (◀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x58, 0x46, 0x46, 0x58, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25C1 (◁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x3c, 0x3c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25C2 (◂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x2c, 0x2c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25C3 (◃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x78, 0x7e, 0x78, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25C4 (◄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x58, 0x46, 0x58, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25C5 (◅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+25C6 (◆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+25C7 (◇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x54, 0xba, 0x54, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+25C8 (◈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x9a, 0xba, 0xb2, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25C9 (◉)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+25CA (◊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25CB (○)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x82, 0x00, 0x82, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00 },	// U+25CC (◌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0xaa, 0xaa, 0xaa, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25CD (◍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x92, 0xaa, 0x92, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25CE (◎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x7c, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25CF (●)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x4c, 0x8e, 0x8e, 0x8e, 0x4c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25D0 (◐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x64, 0xe2, 0xe2, 0xe2, 0x64, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25D1 (◑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0xfe, 0x7c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25D2 (◒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x7c, 0xfe, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25D3 (◓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x74, 0xf2, 0xf2, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25D4 (◔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x64, 0xe2, 0xe2, 0xfe, 0x7c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25D5 (◕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1c, 0x1e, 0x1e, 0x1e, 0x1c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+25D6 (◖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x70, 0xf0, 0xf0, 0xf0, 0x70, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+25D7 (◗)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25D8 (◘)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdb, 0xbd, 0xbd, 0xdb, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25D9 (◙)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdb, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25DA (◚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbd, 0xdb, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25DB (◛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25DC (◜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25DD (◝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+25DE (◞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+25DF (◟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25E0 (◠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+25E1 (◡)
	{ 0x80, 0x80, 0xc0, 0xc0, 0xe0, 0xe0, 0xf0, 0xf0, 0xf8, 0xf8, 0xfc, 0xfc, 0xfe, 0xfe, 0xff, 0xff },	// U+25E2 (◢)
	{ 0x01, 0x01, 0x03, 0x03, 0x07, 0x07, 0x0f, 0x0f, 0x1f, 0x1f, 0x3f, 0x3f, 0x7f, 0x7f, 0xff, 0xff },	// U+25E3 (◣)
	{ 0xff, 0xff, 0x7f, 0x7f, 0x3f, 0x3f, 0x1f, 0x1f, 0x0f, 0x0f, 0x07, 0x07, 0x03, 0x03, 0x01, 0x01 },	// U+25E4 (◤)
	{ 0xff, 0xff, 0xfe, 0xfe, 0xfc, 0xfc, 0xf8, 0xf8, 0xf0, 0xf0, 0xe0, 0xe0, 0xc0, 0xc0, 0x80, 0x80 },	// U+25E5 (◥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+25E6 (◦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x4e, 0x4e, 0x4e, 0x4e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25E7 (◧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x72, 0x72, 0x72, 0x72, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25E8 (◨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x5e, 0x4e, 0x46, 0x42, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25E9 (◩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x62, 0x72, 0x7a, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25EA (◪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25EB (◫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x44, 0x54, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+25EC (◬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x2c, 0x2c, 0x4e, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+25ED (◭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x34, 0x34, 0x72, 0x72, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+25EE (◮)
}; // 239

static const unsigned char unifont_block207[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x4a, 0x4e, 0x42, 0x42, 0x7e, 0x00, 0x00 },	// U+25F0 (◰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x4e, 0x4a, 0x7e, 0x00, 0x00 },	// U+25F1 (◱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x72, 0x52, 0x7e, 0x00, 0x00 },	// U+25F2 (◲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x52, 0x72, 0x42, 0x42, 0x7e, 0x00, 0x00 },	// U+25F3 (◳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x4a, 0x89, 0x8f, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00 },	// U+25F4 (◴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x81, 0x81, 0x8f, 0x89, 0x4a, 0x3c, 0x00, 0x00 },	// U+25F5 (◵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x81, 0x81, 0xf1, 0x91, 0x52, 0x3c, 0x00, 0x00 },	// U+25F6 (◶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x52, 0x91, 0xf1, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00 },	// U+25F7 (◷)
	{ 0x00, 0x00, 0x7e, 0x22, 0x12, 0x0a, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25F8 (◸)
	{ 0x00, 0x00, 0x7e, 0x44, 0x48, 0x50, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25F9 (◹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0a, 0x12, 0x22, 0x7e, 0x00 },	// U+25FA (◺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x00 },	// U+25FB (◻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00 },	// U+25FC (◼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x3c, 0x00, 0x00 },	// U+25FD (◽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00 },	// U+25FE (◾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x50, 0x48, 0x44, 0x7e, 0x00 },	// U+25FF (◿)
	{ 0x00, 0x00, 0x10, 0x92, 0x44, 0x00, 0x38, 0x7c, 0x7c, 0x38, 0x00, 0x44, 0x92, 0x10, 0x00, 0x00 },	// U+2600 (☀)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x6e, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2601 (☁)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x7c, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2602 (☂)
}; // 19

static const unsigned char unifont_block208[][16] = {
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x24, 0x24, 0x14, 0x94, 0x40, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+2604 (☄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0xfe, 0x38, 0x6c, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2605 (★)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0xee, 0x44, 0x54, 0x6c, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2606 (☆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x08, 0x50, 0x60, 0x70, 0x00, 0x00 },	// U+2607 (☇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x22, 0x12, 0x0a, 0x52, 0x62, 0x72, 0x00, 0x00 },	// U+2608 (☈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x81, 0x99, 0x99, 0x81, 0x42, 0x3c, 0x00, 0x00 },	// U+2609 (☉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x66, 0xa5, 0x42, 0x00, 0x00, 0x00, 0x00 },	// U+260A (☊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xa5, 0x66, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+260B (☋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+260C (☌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x90, 0x90, 0x60, 0x10, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+260D (☍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x00, 0x54, 0xc6, 0xfe, 0x00, 0x00, 0x00 },	// U+260E (☎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0xba, 0x7c, 0x92, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+260F (☏)
}; // 12

static const unsigned char unifont_block209[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x00, 0x00 },	// U+2613 (☓)
	{ 0xa0, 0x0a, 0x20, 0x82, 0x38, 0x7c, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2614 (☔)
}; // 2

static const unsigned char unifont_block210[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xf8, 0xf8, 0x70, 0x00, 0x00, 0x00, 0x00 },	// U+261A (☚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x3e, 0x3e, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+261B (☛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x88, 0x98, 0x70, 0x00, 0x00, 0x00, 0x00 },	// U+261C (☜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x38, 0x2c, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+261D (☝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x22, 0x32, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+261E (☞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x2c, 0x38, 0x20, 0x20, 0x00, 0x00 },	// U+261F (☟)
	{ 0x00, 0x00, 0xe7, 0xa5, 0x7e, 0x81, 0xa5, 0xa5, 0x81, 0x5a, 0x5a, 0x42, 0xbd, 0xe7, 0x00, 0x00 },	// U+2620 (☠)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x38, 0x00, 0x00 },	// U+2621 (☡)
}; // 8

static const unsigned char unifont_block211[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x28, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2625 (☥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x7f, 0x08, 0x08, 0x0e, 0x38, 0x08, 0x00, 0x00 },	// U+2626 (☦)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x48, 0x48, 0x38, 0x08, 0x2a, 0x1c, 0x08, 0x1c, 0x2a, 0x00, 0x00 },	// U+2627 (☧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2628 (☨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x92, 0xfe, 0x92, 0x10, 0x38, 0x00, 0x00 },	// U+2629 (☩)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x02, 0x43, 0xe3, 0x43, 0x02, 0x84, 0x78, 0x00, 0x00, 0x00 },	// U+262A (☪)
}; // 6

static const unsigned char unifont_block212[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x9c, 0x9e, 0xb0, 0x7c, 0xc6, 0x83, 0x00, 0x00 },	// U+262D (☭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x92, 0x92, 0xba, 0xd6, 0x92, 0x7c, 0x00, 0x00 },	// U+262E (☮)
}; // 2

static const unsigned char unifont_block213[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x7c, 0x7c, 0xee, 0x7c, 0x7c, 0x92, 0x00, 0x00 },	// U+2638 (☸)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x81, 0xa5, 0x81, 0x99, 0xa5, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00 },	// U+2639 (☹)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x81, 0xa5, 0x81, 0xa5, 0x99, 0x42, 0x3c, 0x00, 0x00, 0x00 },	// U+263A (☺)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0xff, 0xdb, 0xff, 0xdb, 0xe7, 0x7e, 0x3c, 0x00, 0x00, 0x00 },	// U+263B (☻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x54, 0x38, 0xee, 0x38, 0x54, 0x92, 0x00, 0x00, 0x00, 0x00 },	// U+263C (☼)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x30, 0x60, 0xa0, 0xa0, 0xa0, 0xa0, 0x60, 0x30, 0x1c, 0x00, 0x00 },	// U+263D (☽)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x18, 0x0c, 0x0a, 0x0a, 0x0a, 0x0a, 0x0c, 0x18, 0x70, 0x00, 0x00 },	// U+263E (☾)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x44, 0x44, 0x44, 0x38, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+263F (☿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+2640 (♀)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+2641 (♁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xc0, 0xa0, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+2642 (♂)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x60, 0x50, 0x7e, 0x40, 0x40, 0x00, 0x00 },	// U+2643 (♃)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x04, 0x34, 0x4c, 0x44, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+2644 (♄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0x54, 0x7c, 0x54, 0xd6, 0x10, 0x38, 0x28, 0x38, 0x00, 0x00 },	// U+2645 (♅)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x9a, 0xd3, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x7c, 0x10, 0x10, 0x00 },	// U+2646 (♆)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+2647 (♇)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0xaa, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2648 (♈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+2649 (♉)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x7c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x7c, 0x82, 0x00, 0x00 },	// U+264A (♊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x12, 0x0c, 0x60, 0x90, 0x92, 0x7c, 0x00, 0x00 },	// U+264B (♋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x48, 0x2e, 0x29, 0x29, 0xa6, 0x40, 0x00, 0x00 },	// U+264C (♌)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x3e, 0xaa, 0xea, 0xaa, 0xaa, 0xaa, 0xaa, 0x60, 0x3e, 0x00, 0x00 },	// U+264D (♍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0xee, 0x00, 0xfe, 0x00, 0x00, 0x00 },	// U+264E (♎)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x3e, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0xaa, 0xc0, 0x00, 0x00 },	// U+264F (♏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xc0, 0xa2, 0x94, 0x08, 0x14, 0x22, 0x00, 0x00 },	// U+2650 (♐)
	{ 0x00, 0x00, 0x00, 0x00, 0x8c, 0x72, 0x21, 0x10, 0x08, 0x3c, 0x46, 0x45, 0x45, 0x38, 0x00, 0x00 },	// U+2651 (♑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x2a, 0x00, 0x00, 0x54, 0x2a, 0x00, 0x00, 0x00, 0x00 },	// U+2652 (♒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x7e, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+2653 (♓)
	{ 0x00, 0x00, 0x00, 0x10, 0x38, 0x10, 0xee, 0xba, 0x92, 0x92, 0x54, 0xfe, 0x82, 0xfe, 0x00, 0x00 },	// U+2654 (♔)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x92, 0x54, 0x54, 0xba, 0x54, 0x7c, 0x44, 0x7c, 0x00, 0x00 },	// U+2655 (♕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xfe, 0x82, 0x82, 0x44, 0x44, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+2656 (♖)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x44, 0x44, 0x44, 0x28, 0xee, 0x82, 0xfe, 0x00, 0x00 },	// U+2657 (♗)
	{ 0x00, 0x00, 0x00, 0x40, 0x78, 0x44, 0x42, 0x42, 0x5c, 0x48, 0x44, 0x42, 0x42, 0x7e, 0x00, 0x00 },	// U+2658 (♘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x24, 0x24, 0x42, 0x7e, 0x00, 0x00 },	// U+2659 (♙)
	{ 0x00, 0x00, 0x00, 0x10, 0x38, 0x10, 0xee, 0xba, 0x92, 0x92, 0x54, 0xfe, 0xfe, 0xfe, 0x00, 0x00 },	// U+265A (♚)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x92, 0x54, 0x54, 0xba, 0x54, 0x7c, 0x7c, 0x7c, 0x00, 0x00 },	// U+265B (♛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xfe, 0xfe, 0xfe, 0x7c, 0x7c, 0xfe, 0xfe, 0xfe, 0x00, 0x00 },	// U+265C (♜)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6c, 0x44, 0x6c, 0x7c, 0x38, 0xfe, 0xfe, 0xfe, 0x00, 0x00 },	// U+265D (♝)
	{ 0x00, 0x00, 0x00, 0x40, 0x78, 0x6c, 0x7e, 0x7e, 0x7c, 0x78, 0x7c, 0x7e, 0x7e, 0x7e, 0x00, 0x00 },	// U+265E (♞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x3c, 0x3c, 0x7e, 0x7e, 0x00, 0x00 },	// U+265F (♟)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x7c, 0xfe, 0xfe, 0xfe, 0x7c, 0x10, 0x38, 0x00, 0x00 },	// U+2660 (♠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+2661 (♡)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+2662 (♢)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x10, 0xfe, 0xfe, 0xd6, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+2663 (♣)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x44, 0x82, 0x82, 0x82, 0x7c, 0x10, 0x38, 0x00, 0x00 },	// U+2664 (♤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x10, 0x00, 0x00 },	// U+2665 (♥)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x7c, 0x7c, 0x38, 0x38, 0x10, 0x10, 0x00, 0x00 },	// U+2666 (♦)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x28, 0x38, 0x10, 0xee, 0xba, 0xd6, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+2667 (♧)
	{ 0x00, 0x00, 0x00, 0x10, 0x8a, 0x49, 0x49, 0x49, 0x92, 0x92, 0x92, 0x4a, 0x81, 0x7e, 0x00, 0x00 },	// U+2668 (♨)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x1e, 0x0e, 0x00, 0x00 },	// U+2669 (♩)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x50, 0x50, 0x10, 0x10, 0x10, 0x1c, 0x1e, 0x0e, 0x00, 0x00 },	// U+266A (♪)
	{ 0x00, 0x00, 0x00, 0x38, 0xe8, 0x88, 0x88, 0x88, 0x88, 0x8e, 0x8f, 0xe7, 0xf0, 0x70, 0x00, 0x00 },	// U+266B (♫)
	{ 0x00, 0x00, 0x00, 0x38, 0xe8, 0x88, 0xb8, 0xe8, 0x88, 0x8e, 0x8f, 0xe7, 0xf0, 0x70, 0x00, 0x00 },	// U+266C (♬)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3a, 0x66, 0x62, 0x22, 0x12, 0x0a, 0x06, 0x00, 0x00 },	// U+266D (♭)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x72, 0x7e, 0x4e, 0x42, 0x72, 0x7e, 0x4e, 0x40, 0x40, 0x00, 0x00 },	// U+266E (♮)
	{ 0x00, 0x00, 0x20, 0x24, 0x64, 0x7c, 0x3e, 0x26, 0x24, 0x64, 0x7c, 0x3e, 0x26, 0x24, 0x04, 0x00 },	// U+266F (♯)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x10, 0x92, 0x7c, 0x92, 0x10, 0x10, 0x10, 0x28, 0x00, 0x00 },	// U+2670 (♰)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x28, 0x10, 0xd6, 0xba, 0xd6, 0x10, 0x10, 0x28, 0x10, 0x00, 0x00 },	// U+2671 (♱)
}; // 58

static const unsigned char unifont_block214[][16] = {
	{ 0x00, 0x00, 0x00, 0x0e, 0x72, 0x42, 0x42, 0x4e, 0x72, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+2690 (⚐)
	{ 0x00, 0x00, 0x00, 0x0e, 0x7e, 0x7e, 0x7e, 0x7e, 0x72, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+2691 (⚑)
}; // 2

static const unsigned char unifont_block215[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x7e, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00 },	// U+26A1 (⚡)
}; // 1

static const unsigned char unifont_block216[][16] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x08, 0x1c, 0x08, 0x1c, 0x22, 0x41, 0x41, 0x22, 0x1c, 0x00, 0x00 },	// U+26A8 (⚨)
}; // 1

static const unsigned char unifont_block217[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x00 },	// U+26AA (⚪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x00 },	// U+26AB (⚫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+26AC (⚬)
}; // 3

static const unsigned char unifont_block218[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+26B2 (⚲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x20, 0x18, 0x08, 0x3e, 0x08, 0x00, 0x00 },	// U+26B3 (⚳)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x41, 0x22, 0x14, 0x08, 0x08, 0x3e, 0x08, 0x00, 0x00 },	// U+26B4 (⚴)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x2a, 0x1c, 0x7f, 0x1c, 0x2a, 0x49, 0x08, 0x3e, 0x08, 0x00, 0x00 },	// U+26B5 (⚵)
}; // 4

static const unsigned char unifont_block219[][16] = {
	{ 0x00, 0x00, 0x00, 0x48, 0x28, 0x18, 0x28, 0x48, 0x08, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+26B7 (⚷)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x1c, 0x0e, 0x0e, 0x0e, 0x1c, 0x38, 0x10, 0x7c, 0x10, 0x00, 0x00 },	// U+26B8 (⚸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0xff, 0x18, 0x24, 0x42, 0x00, 0x00, 0x00 },	// U+26B9 (⚹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x7f, 0x00, 0x00 },	// U+26BA (⚺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x14, 0x14, 0x14, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+26BB (⚻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x52, 0x7e, 0x04, 0x7e, 0x00, 0x00 },	// U+26BC (⚼)
}; // 6

static const unsigned char unifont_block220[][16] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x08, 0x08, 0x3e, 0x41, 0x5d, 0x5d, 0x41, 0x3e, 0x00, 0x00 },	// U+26E2 (⛢)
}; // 1

static const unsigned char unifont_block221[][16] = {
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x20, 0x40, 0x00 },	// U+2768 (❨)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x08, 0x04, 0x00 },	// U+2769 (❩)
	{ 0x00, 0x00, 0x00, 0x60, 0x30, 0x38, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x38, 0x30, 0x60, 0x00 },	// U+276A (❪)
	{ 0x00, 0x00, 0x00, 0x0c, 0x18, 0x38, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x38, 0x18, 0x0c, 0x00 },	// U+276B (❫)
	{ 0x00, 0x00, 0x00, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x60, 0x00 },	// U+276C (❬)
	{ 0x00, 0x00, 0x00, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x00 },	// U+276D (❭)
	{ 0x00, 0x00, 0x00, 0xe0, 0x70, 0x70, 0x38, 0x38, 0x1c, 0x1c, 0x38, 0x38, 0x70, 0x70, 0xe0, 0x00 },	// U+276E (❮)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1c, 0x1c, 0x38, 0x38, 0x70, 0x70, 0x38, 0x38, 0x1c, 0x1c, 0x0e, 0x00 },	// U+276F (❯)
	{ 0x00, 0x00, 0x00, 0xf0, 0x78, 0x78, 0x3c, 0x3c, 0x1e, 0x1e, 0x3c, 0x3c, 0x78, 0x78, 0xf0, 0x00 },	// U+2770 (❰)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1e, 0x1e, 0x3c, 0x3c, 0x78, 0x78, 0x3c, 0x3c, 0x1e, 0x1e, 0x0f, 0x00 },	// U+2771 (❱)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00 },	// U+2772 (❲)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00 },	// U+2773 (❳)
	{ 0x00, 0x00, 0x00, 0x78, 0x1c, 0x0c, 0x0c, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x0c, 0x0c, 0x1c, 0x78 },	// U+2774 (❴)
	{ 0x00, 0x00, 0x00, 0x1e, 0x38, 0x30, 0x30, 0x18, 0x18, 0x70, 0x18, 0x18, 0x30, 0x30, 0x38, 0x1e },	// U+2775 (❵)
}; // 14

static const unsigned char unifont_block222[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+27B0 (➰)
}; // 1

static const unsigned char unifont_block223[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x7e, 0x00, 0x00 },	// U+27C0 (⟀)
}; // 1

static const unsigned char unifont_block224[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+27C2 (⟂)
}; // 1

static const unsigned char unifont_block225[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x70, 0x00, 0x00 },	// U+27C5 (⟅)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x1c, 0x00, 0x00 },	// U+27C6 (⟆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x54, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+27C7 (⟇)
}; // 3

static const unsigned char unifont_block226[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+27CA (⟊)
}; // 1

static const unsigned char unifont_block227[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x54, 0x82, 0x82, 0x00, 0x00 },	// U+27D1 (⟑)
}; // 1

static const unsigned char unifont_block228[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x48, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+27D3 (⟓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x12, 0x02, 0x02, 0x00, 0x00 },	// U+27D4 (⟔)
}; // 2

static const unsigned char unifont_block229[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+27DF (⟟)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x22, 0x7f, 0x22, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+27E0 (⟠)
}; // 2

static const unsigned char unifont_block230[][16] = {
	{ 0x00, 0x7c, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x7c, 0x00, 0x00 },	// U+27E6 (⟦)
	{ 0x00, 0x3e, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x3e, 0x00, 0x00 },	// U+27E7 (⟧)
	{ 0x00, 0x00, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x00, 0x00 },	// U+27E8 (⟨)
	{ 0x00, 0x00, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00, 0x00 },	// U+27E9 (⟩)
	{ 0x00, 0x00, 0x50, 0x28, 0x28, 0x14, 0x14, 0x0a, 0x0a, 0x14, 0x14, 0x28, 0x28, 0x50, 0x00, 0x00 },	// U+27EA (⟪)
	{ 0x00, 0x00, 0x0a, 0x14, 0x14, 0x28, 0x28, 0x50, 0x50, 0x28, 0x28, 0x14, 0x14, 0x0a, 0x00, 0x00 },	// U+27EB (⟫)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x30, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x30, 0x20, 0x40, 0x00 },	// U+27EC (⟬)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x0c, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0c, 0x04, 0x02, 0x00 },	// U+27ED (⟭)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x40, 0x00 },	// U+27EE (⟮)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x02, 0x00 },	// U+27EF (⟯)
}; // 10

static const unsigned char unifont_block231[][16] = {
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2800 (⠀)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2801 (⠁)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2802 (⠂)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2803 (⠃)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2804 (⠄)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2805 (⠅)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2806 (⠆)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2807 (⠇)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2808 (⠈)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2809 (⠉)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+280A (⠊)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+280B (⠋)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+280C (⠌)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+280D (⠍)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+280E (⠎)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+280F (⠏)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2810 (⠐)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2811 (⠑)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2812 (⠒)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2813 (⠓)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2814 (⠔)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2815 (⠕)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2816 (⠖)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2817 (⠗)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2818 (⠘)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2819 (⠙)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+281A (⠚)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+281B (⠛)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+281C (⠜)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+281D (⠝)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+281E (⠞)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+281F (⠟)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2820 (⠠)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2821 (⠡)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2822 (⠢)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2823 (⠣)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2824 (⠤)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2825 (⠥)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2826 (⠦)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2827 (⠧)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2828 (⠨)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2829 (⠩)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+282A (⠪)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+282B (⠫)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+282C (⠬)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+282D (⠭)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+282E (⠮)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+282F (⠯)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2830 (⠰)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2831 (⠱)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2832 (⠲)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2833 (⠳)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2834 (⠴)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2835 (⠵)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2836 (⠶)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2837 (⠷)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2838 (⠸)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2839 (⠹)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+283A (⠺)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+283B (⠻)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+283C (⠼)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+283D (⠽)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+283E (⠾)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+283F (⠿)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2840 (⡀)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2841 (⡁)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2842 (⡂)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2843 (⡃)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2844 (⡄)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2845 (⡅)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2846 (⡆)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2847 (⡇)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2848 (⡈)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2849 (⡉)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+284A (⡊)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+284B (⡋)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+284C (⡌)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+284D (⡍)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+284E (⡎)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+284F (⡏)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2850 (⡐)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2851 (⡑)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2852 (⡒)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2853 (⡓)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2854 (⡔)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2855 (⡕)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2856 (⡖)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2857 (⡗)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2858 (⡘)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2859 (⡙)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+285A (⡚)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+285B (⡛)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+285C (⡜)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+285D (⡝)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+285E (⡞)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+285F (⡟)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2860 (⡠)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2861 (⡡)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2862 (⡢)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2863 (⡣)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2864 (⡤)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2865 (⡥)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2866 (⡦)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2867 (⡧)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2868 (⡨)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2869 (⡩)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+286A (⡪)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+286B (⡫)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+286C (⡬)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+286D (⡭)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+286E (⡮)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+286F (⡯)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2870 (⡰)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2871 (⡱)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2872 (⡲)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2873 (⡳)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2874 (⡴)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2875 (⡵)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2876 (⡶)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2877 (⡷)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2878 (⡸)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+2879 (⡹)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+287A (⡺)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+287B (⡻)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+287C (⡼)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+287D (⡽)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+287E (⡾)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x00 },	// U+287F (⡿)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2880 (⢀)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2881 (⢁)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2882 (⢂)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2883 (⢃)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2884 (⢄)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2885 (⢅)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2886 (⢆)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2887 (⢇)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2888 (⢈)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2889 (⢉)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+288A (⢊)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+288B (⢋)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+288C (⢌)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+288D (⢍)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+288E (⢎)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+288F (⢏)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2890 (⢐)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2891 (⢑)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2892 (⢒)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2893 (⢓)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2894 (⢔)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2895 (⢕)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2896 (⢖)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2897 (⢗)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2898 (⢘)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+2899 (⢙)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+289A (⢚)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+289B (⢛)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+289C (⢜)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+289D (⢝)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+289E (⢞)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+289F (⢟)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28A0 (⢠)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28A1 (⢡)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28A2 (⢢)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28A3 (⢣)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28A4 (⢤)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28A5 (⢥)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28A6 (⢦)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28A7 (⢧)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28A8 (⢨)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28A9 (⢩)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28AA (⢪)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28AB (⢫)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28AC (⢬)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28AD (⢭)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28AE (⢮)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28AF (⢯)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28B0 (⢰)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28B1 (⢱)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28B2 (⢲)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28B3 (⢳)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28B4 (⢴)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28B5 (⢵)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28B6 (⢶)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28B7 (⢷)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28B8 (⢸)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28B9 (⢹)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28BA (⢺)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28BB (⢻)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28BC (⢼)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28BD (⢽)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28BE (⢾)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x00 },	// U+28BF (⢿)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28C0 (⣀)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28C1 (⣁)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28C2 (⣂)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28C3 (⣃)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28C4 (⣄)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28C5 (⣅)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28C6 (⣆)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28C7 (⣇)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28C8 (⣈)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28C9 (⣉)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28CA (⣊)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28CB (⣋)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28CC (⣌)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28CD (⣍)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28CE (⣎)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28CF (⣏)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28D0 (⣐)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28D1 (⣑)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28D2 (⣒)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28D3 (⣓)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28D4 (⣔)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28D5 (⣕)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28D6 (⣖)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28D7 (⣗)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28D8 (⣘)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28D9 (⣙)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28DA (⣚)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28DB (⣛)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28DC (⣜)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28DD (⣝)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28DE (⣞)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28DF (⣟)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28E0 (⣠)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28E1 (⣡)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28E2 (⣢)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28E3 (⣣)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28E4 (⣤)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28E5 (⣥)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28E6 (⣦)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28E7 (⣧)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28E8 (⣨)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28E9 (⣩)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28EA (⣪)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28EB (⣫)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28EC (⣬)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28ED (⣭)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28EE (⣮)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28EF (⣯)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28F0 (⣰)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28F1 (⣱)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28F2 (⣲)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28F3 (⣳)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28F4 (⣴)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28F5 (⣵)
	{ 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28F6 (⣶)
	{ 0x00, 0x00, 0x00, 0x4c, 0x0c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28F7 (⣷)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28F8 (⣸)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28F9 (⣹)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28FA (⣺)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28FB (⣻)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28FC (⣼)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28FD (⣽)
	{ 0x00, 0x00, 0x00, 0x64, 0x60, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28FE (⣾)
	{ 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x00, 0x00 },	// U+28FF (⣿)
}; // 256

static const unsigned char unifont_block232[][16] = {
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+2908 (⤈)
	{ 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2909 (⤉)
}; // 2

static const unsigned char unifont_block233[][16] = {
	{ 0x00, 0x00, 0xfe, 0x38, 0x54, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2912 (⤒)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x54, 0x38, 0xfe, 0x00, 0x00 },	// U+2913 (⤓)
}; // 2

static const unsigned char unifont_block234[][16] = {
	{ 0x00, 0x00, 0x04, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20, 0x20, 0x14, 0x14, 0x0c, 0x3c, 0x00, 0x00 },	// U+2938 (⤸)
	{ 0x00, 0x00, 0x20, 0x10, 0x08, 0x08, 0x04, 0x04, 0x04, 0x04, 0x28, 0x28, 0x30, 0x3c, 0x00, 0x00 },	// U+2939 (⤹)
}; // 2

static const unsigned char unifont_block235[][16] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x1c, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+2949 (⥉)
}; // 1

static const unsigned char unifont_block236[][16] = {
	{ 0x00, 0x00, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x0c, 0x08, 0x00, 0x00 },	// U+294C (⥌)
	{ 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x18, 0x08, 0x00, 0x00 },	// U+294D (⥍)
}; // 2

static const unsigned char unifont_block237[][16] = {
	{ 0x00, 0x00, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x00, 0x00 },	// U+294F (⥏)
}; // 1

static const unsigned char unifont_block238[][16] = {
	{ 0x00, 0x00, 0x10, 0x18, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x18, 0x10, 0x00, 0x00 },	// U+2951 (⥑)
}; // 1

static const unsigned char unifont_block239[][16] = {
	{ 0x00, 0x00, 0x7c, 0x10, 0x30, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2954 (⥔)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x50, 0x30, 0x10, 0x7c, 0x00, 0x00 },	// U+2955 (⥕)
}; // 2

static const unsigned char unifont_block240[][16] = {
	{ 0x00, 0x00, 0x7c, 0x10, 0x18, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2958 (⥘)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x18, 0x10, 0x7c, 0x00, 0x00 },	// U+2959 (⥙)
}; // 2

static const unsigned char unifont_block241[][16] = {
	{ 0x00, 0x00, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+295C (⥜)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x18, 0x08, 0x00, 0x00 },	// U+295D (⥝)
}; // 2

static const unsigned char unifont_block242[][16] = {
	{ 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+2960 (⥠)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x0c, 0x08, 0x00, 0x00 },	// U+2961 (⥡)
}; // 2

static const unsigned char unifont_block243[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0xf8, 0x04, 0x02, 0x02, 0x04, 0x00, 0x00 },	// U+297C (⥼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x80, 0x40, 0x3e, 0x40, 0x80, 0x80, 0x40, 0x00, 0x00 },	// U+297D (⥽)
}; // 2

static const unsigned char unifont_block244[][16] = {
	{ 0x00, 0x00, 0x00, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x00 },	// U+2980 (⦀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2981 (⦁)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2982 (⦂)
	{ 0x00, 0x00, 0x78, 0x24, 0x24, 0x28, 0x28, 0x24, 0x22, 0x24, 0x28, 0x28, 0x24, 0x24, 0x78, 0x00 },	// U+2983 (⦃)
	{ 0x00, 0x00, 0x1e, 0x24, 0x24, 0x14, 0x14, 0x24, 0x44, 0x24, 0x14, 0x14, 0x24, 0x24, 0x1e, 0x00 },	// U+2984 (⦄)
	{ 0x00, 0x00, 0x00, 0x30, 0x18, 0x18, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x18, 0x18, 0x30, 0x00 },	// U+2985 (⦅)
	{ 0x00, 0x00, 0x00, 0x0c, 0x18, 0x18, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x18, 0x18, 0x0c, 0x00 },	// U+2986 (⦆)
	{ 0x00, 0x00, 0x00, 0x30, 0x28, 0x28, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x28, 0x28, 0x30, 0x00 },	// U+2987 (⦇)
	{ 0x00, 0x00, 0x00, 0x0c, 0x14, 0x14, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x14, 0x14, 0x0c, 0x00 },	// U+2988 (⦈)
	{ 0x00, 0x00, 0x00, 0x20, 0x30, 0x30, 0x28, 0x28, 0x24, 0x24, 0x28, 0x28, 0x30, 0x30, 0x20, 0x00 },	// U+2989 (⦉)
	{ 0x00, 0x00, 0x00, 0x04, 0x0c, 0x0c, 0x14, 0x14, 0x24, 0x24, 0x14, 0x14, 0x0c, 0x0c, 0x04, 0x00 },	// U+298A (⦊)
	{ 0x00, 0x00, 0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x70, 0x00, 0x70 },	// U+298B (⦋)
	{ 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00, 0x0e },	// U+298C (⦌)
	{ 0x00, 0x00, 0x00, 0x78, 0x18, 0x28, 0x48, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x00 },	// U+298D (⦍)
	{ 0x00, 0x00, 0x00, 0x1e, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x14, 0x18, 0x1e, 0x00 },	// U+298E (⦎)
	{ 0x00, 0x00, 0x00, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x48, 0x28, 0x18, 0x78, 0x00 },	// U+298F (⦏)
	{ 0x00, 0x00, 0x00, 0x1e, 0x18, 0x14, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x00 },	// U+2990 (⦐)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x08, 0x08, 0x64, 0x64, 0x08, 0x08, 0x10, 0x10, 0x20, 0x00 },	// U+2991 (⦑)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x10, 0x10, 0x26, 0x26, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00 },	// U+2992 (⦒)
}; // 19

static const unsigned char unifont_block245[][16] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x18, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x18, 0x30, 0x00 },	// U+2997 (⦗)
	{ 0x00, 0x00, 0x00, 0x0c, 0x18, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x18, 0x0c, 0x00 },	// U+2998 (⦘)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+2999 (⦙)
	{ 0x00, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10 },	// U+299A (⦚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x08, 0x14, 0x24, 0x7e, 0x04, 0x00 },	// U+299B (⦛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x0a, 0x7e, 0x00, 0x00 },	// U+299C (⦜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x2a, 0x22, 0xfe, 0x00, 0x00 },	// U+299D (⦝)
}; // 7

static const unsigned char unifont_block246[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x18, 0x04, 0x7e, 0x00, 0x00 },	// U+299F (⦟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0c, 0x14, 0x64, 0x14, 0x0c, 0x0a, 0x00, 0x00 },	// U+29A0 (⦠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x7c, 0xc6, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+29A1 (⦡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00 },	// U+29A2 (⦢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x7e, 0x00, 0x00 },	// U+29A3 (⦣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x7e, 0x00, 0x7e },	// U+29A4 (⦤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x7e, 0x00, 0x7e },	// U+29A5 (⦥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x78, 0x00, 0x00 },	// U+29A6 (⦦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x00, 0x00 },	// U+29A7 (⦧)
}; // 9

static const unsigned char unifont_block247[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xae, 0x9e, 0xae, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+29D1 (⧑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xea, 0xf2, 0xea, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+29D2 (⧒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xee, 0xfe, 0xee, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+29D3 (⧓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x46, 0x2e, 0x1e, 0x2e, 0x46, 0x82, 0x00, 0x00, 0x00 },	// U+29D4 (⧔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc4, 0xe8, 0xf0, 0xe8, 0xc4, 0x82, 0x00, 0x00, 0x00 },	// U+29D5 (⧕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x22, 0x14, 0x08, 0x14, 0x22, 0x7f, 0x00, 0x00 },	// U+29D6 (⧖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x3e, 0x1c, 0x08, 0x1c, 0x3e, 0x7f, 0x00, 0x00 },	// U+29D7 (⧗)
	{ 0x00, 0x00, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x00 },	// U+29D8 (⧘)
	{ 0x00, 0x00, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x00 },	// U+29D9 (⧙)
}; // 9

static const unsigned char unifont_block248[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+29DC (⧜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x6c, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+29DD (⧝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x54, 0xba, 0xba, 0x54, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+29DE (⧞)
}; // 3

static const unsigned char unifont_block249[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x58, 0x46, 0x7e, 0x00, 0x7e, 0x00, 0x00 },	// U+29E1 (⧡)
}; // 1

static const unsigned char unifont_block250[][16] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+29EB (⧫)
}; // 1

static const unsigned char unifont_block251[][16] = {
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x7f, 0x41, 0x41, 0x41, 0x41, 0x41, 0x7f, 0x08, 0x3e, 0x00, 0x00 },	// U+29EE (⧮)
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x08, 0x3e, 0x00, 0x00 },	// U+29EF (⧯)
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x14, 0x22, 0x41, 0x22, 0x14, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+29F0 (⧰)
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+29F1 (⧱)
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x1c, 0x22, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x08, 0x3e, 0x00, 0x00 },	// U+29F2 (⧲)
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x1c, 0x3e, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x3e, 0x00, 0x00 },	// U+29F3 (⧳)
}; // 6

static const unsigned char unifont_block252[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x00, 0x00 },	// U+29F5 (⧵)
	{ 0x00, 0x00, 0x1e, 0x00, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+29F6 (⧶)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x3e, 0x08, 0x10, 0x10, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+29F7 (⧷)
	{ 0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+29F8 (⧸)
	{ 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x00, 0x00 },	// U+29F9 (⧹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x7f, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+29FA (⧺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x7f, 0x2a, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+29FB (⧻)
	{ 0x00, 0x00, 0x40, 0x40, 0x20, 0x18, 0x06, 0x01, 0x06, 0x18, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+29FC (⧼)
	{ 0x00, 0x00, 0x01, 0x01, 0x02, 0x0c, 0x30, 0x40, 0x30, 0x0c, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+29FD (⧽)
}; // 9

static const unsigned char unifont_block253[][16] = {
	{ 0x00, 0x60, 0x50, 0x10, 0x7e, 0x52, 0x14, 0x18, 0x10, 0x18, 0x14, 0x52, 0x7e, 0x10, 0x14, 0x0c },	// U+2A0B (⨋)
}; // 1

static const unsigned char unifont_block254[][16] = {
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A0D (⨍)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A0E (⨎)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x50, 0x30, 0x10, 0x18, 0x14, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A0F (⨏)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x38, 0x54, 0x14, 0x38, 0x10, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A10 (⨐)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf4, 0xd4, 0xb8, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A11 (⨑)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x70, 0x40, 0x50, 0x40, 0x70, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A12 (⨒)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x30, 0x40, 0x50, 0x40, 0x30, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A13 (⨓)
	{ 0x00, 0x30, 0x28, 0x08, 0x08, 0x08, 0x78, 0x88, 0xa0, 0x88, 0x78, 0x08, 0x08, 0x0a, 0x06, 0x00 },	// U+2A14 (⨔)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x38, 0x44, 0x54, 0x44, 0x38, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A15 (⨕)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x7c, 0x54, 0x54, 0x54, 0x7c, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A16 (⨖)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x14, 0x12, 0x7f, 0x92, 0x54, 0x10, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A17 (⨗)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x92, 0x54, 0x38, 0x10, 0x38, 0x54, 0x92, 0x10, 0x14, 0x0c, 0x00 },	// U+2A18 (⨘)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x38, 0x54, 0x54, 0x54, 0x54, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A19 (⨙)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x54, 0x54, 0x54, 0x54, 0x38, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A1A (⨚)
	{ 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x0c, 0x00, 0x7c },	// U+2A1B (⨛)
	{ 0x7c, 0x00, 0x60, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x0c, 0x00 },	// U+2A1C (⨜)
}; // 16

static const unsigned char unifont_block255[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x50, 0x48, 0x44, 0x44, 0x48, 0x50, 0x60, 0x40, 0x00, 0x00 },	// U+2A1E (⨞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x18, 0x24, 0x24, 0x38, 0x20, 0x18 },	// U+2A1F (⨟)
}; // 2

static const unsigned char unifont_block256[][16] = {
	{ 0x04, 0x0c, 0x14, 0x24, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2A21 (⨡)
	{ 0x00, 0x00, 0x10, 0x28, 0x10, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2A22 (⨢)
	{ 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2A23 (⨣)
	{ 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2A24 (⨤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00 },	// U+2A25 (⨥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x4c, 0x32 },	// U+2A26 (⨦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x7f, 0x08, 0x68, 0x88, 0x40, 0x20, 0xe0 },	// U+2A27 (⨧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x38, 0x7c, 0x10, 0x00, 0x00 },	// U+2A28 (⨨)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2A29 (⨩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2A2A (⨪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x7e, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+2A2B (⨫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x7e, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2A2C (⨬)
}; // 12

static const unsigned char unifont_block257[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00 },	// U+2A2F (⨯)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x42, 0x24, 0x18, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00 },	// U+2A30 (⨰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x24, 0x42, 0x00, 0x7e, 0x00, 0x00 },	// U+2A31 (⨱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x24, 0x42, 0x7e, 0x00, 0x00, 0x00 },	// U+2A32 (⨲)
}; // 4

static const unsigned char unifont_block258[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2A3C (⨼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2A3D (⨽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x10, 0x00, 0x10, 0x28, 0x28, 0x30, 0x20, 0x18 },	// U+2A3E (⨾)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfe, 0x00, 0x00 },	// U+2A3F (⨿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+2A40 (⩀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0xba, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00 },	// U+2A41 (⩁)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+2A42 (⩂)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+2A43 (⩃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xaa, 0x00, 0x00 },	// U+2A44 (⩄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xaa, 0x92, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00 },	// U+2A45 (⩅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x18, 0x00, 0x18, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+2A46 (⩆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x00, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2A47 (⩇)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x18, 0x00, 0x3c, 0x00, 0x18, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+2A48 (⩈)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x00, 0x3c, 0x00, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2A49 (⩉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+2A4A (⩊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x49, 0x49, 0x00, 0x00 },	// U+2A4B (⩋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+2A4C (⩌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xff, 0x00, 0x00 },	// U+2A4D (⩍)
}; // 18

static const unsigned char unifont_block259[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2A66 (⩦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+2A67 (⩧)
}; // 2

static const unsigned char unifont_block260[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x26, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2A6A (⩪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x26, 0x19, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2A6B (⩫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x19, 0x00, 0x3f, 0x00, 0x26, 0x19, 0x00, 0x00 },	// U+2A6C (⩬)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x4c, 0x32, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2A6D (⩭)
	{ 0x00, 0x00, 0x00, 0x00, 0x54, 0x38, 0x10, 0x38, 0x54, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00 },	// U+2A6E (⩮)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x21, 0x00, 0x26, 0x19, 0x00, 0x26, 0x19, 0x00, 0x00, 0x00, 0x00 },	// U+2A6F (⩯)
	{ 0x00, 0x00, 0x00, 0x00, 0x26, 0x19, 0x00, 0x26, 0x19, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x00, 0x00 },	// U+2A70 (⩰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00 },	// U+2A71 (⩱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x00 },	// U+2A72 (⩲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x00 },	// U+2A73 (⩳)
}; // 10

static const unsigned char unifont_block261[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x24, 0x00, 0x00 },	// U+2A77 (⩷)
}; // 1

static const unsigned char unifont_block262[][16] = {
	{ 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x06, 0x18, 0x20, 0x18, 0x06 },	// U+2A8B (⪋)
	{ 0x00, 0x06, 0x18, 0x20, 0x18, 0x06, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18 },	// U+2A8C (⪌)
}; // 2

static const unsigned char unifont_block263[][16] = {
	{ 0x00, 0x60, 0x18, 0x04, 0x18, 0x60, 0x00, 0x4c, 0x32, 0x00, 0x06, 0x18, 0x20, 0x18, 0x06, 0x00 },	// U+2A8F (⪏)
	{ 0x00, 0x06, 0x18, 0x20, 0x18, 0x06, 0x00, 0x4c, 0x32, 0x00, 0x60, 0x18, 0x04, 0x18, 0x60, 0x00 },	// U+2A90 (⪐)
	{ 0x00, 0x30, 0x0c, 0x02, 0x0c, 0x30, 0x06, 0x18, 0x20, 0x18, 0x06, 0x00, 0x3e, 0x00, 0x3e, 0x00 },	// U+2A91 (⪑)
	{ 0x00, 0x06, 0x18, 0x20, 0x18, 0x06, 0x30, 0x0c, 0x02, 0x0c, 0x30, 0x00, 0x3e, 0x00, 0x3e, 0x00 },	// U+2A92 (⪒)
	{ 0x00, 0x30, 0x0c, 0x02, 0x0c, 0x30, 0x02, 0x0c, 0x30, 0x06, 0x18, 0x20, 0x18, 0x46, 0x30, 0x0c },	// U+2A93 (⪓)
	{ 0x00, 0x0c, 0x30, 0x40, 0x30, 0x0c, 0x40, 0x30, 0x0c, 0x60, 0x18, 0x04, 0x18, 0x62, 0x0c, 0x30 },	// U+2A94 (⪔)
}; // 6

static const unsigned char unifont_block264[][16] = {
	{ 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+2ABF (⪿)
	{ 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00 },	// U+2AC0 (⫀)
	{ 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00 },	// U+2AC1 (⫁)
	{ 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00 },	// U+2AC2 (⫂)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x7e, 0x00, 0x00 },	// U+2AC3 (⫃)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x7e, 0x00, 0x00 },	// U+2AC4 (⫄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00 },	// U+2AC5 (⫅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00 },	// U+2AC6 (⫆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x4c, 0x32, 0x00 },	// U+2AC7 (⫇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x4c, 0x32, 0x00 },	// U+2AC8 (⫈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x4c, 0x32, 0x4c, 0x32, 0x00 },	// U+2AC9 (⫉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x4c, 0x32, 0x4c, 0x32, 0x00 },	// U+2ACA (⫊)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x20, 0x7e, 0x10, 0x7e, 0x08, 0x00 },	// U+2ACB (⫋)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x20, 0x7e, 0x10, 0x7e, 0x08, 0x00 },	// U+2ACC (⫌)
}; // 14

static const unsigned char unifont_block265[][16] = {
	{ 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x00 },	// U+2AD3 (⫓)
	{ 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x00 },	// U+2AD4 (⫔)
	{ 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x00 },	// U+2AD5 (⫕)
	{ 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x00 },	// U+2AD6 (⫖)
}; // 4

static const unsigned char unifont_block266[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+2ADE (⫞)
}; // 1

static const unsigned char unifont_block267[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1a, 0x1c, 0x18, 0x18, 0x38, 0x58, 0x18, 0x18, 0x00, 0x00 },	// U+2AEE (⫮)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2AEF (⫯)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+2AF0 (⫰)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+2AF1 (⫱)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0xfe, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+2AF2 (⫲)
}; // 5

static const unsigned char unifont_block268[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+2AF6 (⫶)
}; // 1

static const unsigned char unifont_block269[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1c, 0x00, 0x00 },	// U+2AFE (⫾)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1c, 0x00 },	// U+2AFF (⫿)
}; // 2

static const unsigned char unifont_block270[][16] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x00 },	// U+2B06 (⬆)
	{ 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00 },	// U+2B07 (⬇)
}; // 2

static const unsigned char unifont_block271[][16] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x1c, 0x1c, 0x1c, 0x1c, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00 },	// U+2B0D (⬍)
}; // 1

static const unsigned char unifont_block272[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2B1D (⬝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2B1E (⬞)
}; // 2

static const unsigned char unifont_block273[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00 },	// U+2B25 (⬥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x41, 0x22, 0x14, 0x08, 0x00, 0x00 },	// U+2B26 (⬦)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x00, 0x00 },	// U+2B27 (⬧)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x22, 0x41, 0x22, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+2B28 (⬨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2B29 (⬩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x1c, 0x3e, 0x1c, 0x1c, 0x08, 0x00, 0x00 },	// U+2B2A (⬪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+2B2B (⬫)
}; // 7

static const unsigned char unifont_block274[][16] = {
	{ 0x00, 0x18, 0x3c, 0x3c, 0x3c, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x3c, 0x3c, 0x18, 0x00, 0x00 },	// U+2B2E (⬮)
	{ 0x00, 0x18, 0x24, 0x24, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2B2F (⬯)
}; // 2

static const unsigned char unifont_block275[][16] = {
	{ 0x04, 0x02, 0xff, 0x02, 0x04, 0x04, 0x02, 0xff, 0x02, 0x04, 0x04, 0x02, 0xff, 0x02, 0x04, 0x00 },	// U+2B31 (⬱)
}; // 1

static const unsigned char unifont_block276[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x30, 0x28, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2B4E (⭎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x28, 0x30, 0x38, 0x00, 0x00, 0x00 },	// U+2B4F (⭏)
}; // 2

static const unsigned char unifont_block277[][16] = {
	{ 0x00, 0x00, 0x02, 0x52, 0x32, 0x1a, 0x1e, 0x7e, 0x10, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+2BC9 (⯉)
}; // 1

static const unsigned char unifont_block278[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x08, 0x08, 0x38, 0x38, 0x08, 0x08, 0x3e, 0x3e, 0x00, 0x00 },	// U+2BFF (⯿)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x2a, 0x2a, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2C00 (Ⰰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x7f, 0x01, 0x01, 0x01, 0x01, 0x7f, 0x00, 0x00 },	// U+2C01 (Ⰱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x55, 0x36, 0x14, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+2C02 (Ⰲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x0e, 0x04, 0x04, 0x32, 0x4a, 0x49, 0x31, 0x00, 0x00 },	// U+2C03 (Ⰳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x14, 0x36, 0x55, 0x22, 0x00, 0x00 },	// U+2C04 (Ⰴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x38, 0x20, 0x38, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00 },	// U+2C05 (Ⰵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x22, 0x14, 0x14, 0x36, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+2C06 (Ⰶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x22, 0x1c, 0x7f, 0x49, 0x26, 0x14, 0x08, 0x00, 0x00 },	// U+2C07 (Ⰷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x11, 0xff, 0xb1, 0xb1, 0xaa, 0x44, 0x00, 0x00 },	// U+2C08 (Ⰸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x36, 0x49, 0x49, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+2C09 (Ⰹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x36, 0x49, 0x49, 0x36, 0x14, 0x22, 0x22, 0x41, 0x7f, 0x00, 0x00 },	// U+2C0A (Ⰺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x41, 0x22, 0x14, 0x2a, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x00, 0x00 },	// U+2C0B (Ⰻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x46, 0xa6, 0xa6, 0x66, 0x69, 0x69, 0x69, 0x99, 0x89, 0x00, 0x00, 0x00 },	// U+2C0C (Ⰼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x3c, 0x20, 0x20, 0x3c, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2C0D (Ⰽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x55, 0x55, 0x55, 0x22, 0x00, 0x00 },	// U+2C0E (Ⰾ)
}; // 16

static const unsigned char unifont_block279[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x44, 0x44, 0x44, 0x3f, 0x05, 0x05, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2C10 (Ⱀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x78, 0x40, 0x40, 0x40, 0x40, 0x78, 0x44, 0x38, 0x00, 0x00 },	// U+2C11 (Ⱁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x54, 0x54, 0x54, 0x27, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2C12 (Ⱂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+2C13 (Ⱃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x41, 0x41, 0x2a, 0x14, 0x22, 0x41, 0x7f, 0x00, 0x00 },	// U+2C14 (Ⱄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x22, 0x00, 0x00 },	// U+2C15 (Ⱅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x2d, 0x36, 0x24, 0xe4, 0x24, 0x24, 0x36, 0x2d, 0x12, 0x00, 0x00 },	// U+2C16 (Ⱆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x2a, 0x49, 0x49, 0x49, 0x49, 0x2a, 0x1c, 0x08, 0x08 },	// U+2C17 (Ⱇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x4a, 0x31, 0x00, 0x00 },	// U+2C18 (Ⱈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x55, 0x55, 0x49, 0x41, 0x41, 0x49, 0x55, 0x55, 0x3e, 0x00, 0x00 },	// U+2C19 (Ⱉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x4e, 0x49, 0x49, 0x49, 0x49, 0x4e, 0x00, 0x00 },	// U+2C1A (Ⱊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x7f, 0x22, 0x41, 0x41, 0x22, 0x1c, 0x00, 0x00 },	// U+2C1B (Ⱋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x8e, 0x89, 0x89, 0x56, 0x50, 0x50, 0x50, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+2C1C (Ⱌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x3e, 0x49, 0x7f, 0x22, 0x41, 0x41, 0x22, 0x1c, 0x00, 0x00 },	// U+2C1D (Ⱍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x7f, 0x00, 0x00 },	// U+2C1E (Ⱎ)
}; // 15

static const unsigned char unifont_block280[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x24, 0x18, 0x1f, 0x19, 0x25, 0x24, 0x42, 0x7e, 0x00, 0x00 },	// U+2C20 (Ⱐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x49, 0x49, 0x49, 0x7f, 0x00, 0x00 },	// U+2C21 (Ⱑ)
	{ 0x00, 0x00, 0x04, 0x09, 0x1e, 0x36, 0x22, 0x41, 0x41, 0x41, 0x41, 0x22, 0x36, 0x3c, 0x48, 0x10 },	// U+2C22 (Ⱒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x52, 0x52, 0x52, 0x32, 0x0a, 0x0a, 0x06, 0x06, 0x02, 0x00, 0x00 },	// U+2C23 (Ⱓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x04, 0x06, 0x1d, 0x06, 0x04, 0x04, 0x44, 0x38, 0x00, 0x00 },	// U+2C24 (Ⱔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x08, 0x0c, 0x3b, 0x0d, 0x08, 0x08, 0x48, 0x30, 0x00, 0x00 },	// U+2C25 (Ⱕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x32, 0x49, 0x7f, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+2C26 (Ⱖ)
}; // 7

static const unsigned char unifont_block281[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0xff, 0xa5, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2C2A (Ⱚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x0a, 0x0e, 0x71, 0x51, 0x0e, 0x0a, 0x11, 0x1f, 0x00, 0x00 },	// U+2C2B (Ⱛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00, 0x00 },	// U+2C2C (Ⱜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x41, 0x43, 0x4d, 0x51, 0x7f, 0x51, 0x4d, 0x43, 0x41, 0x40, 0x00, 0x00 },	// U+2C2D (Ⱝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x2a, 0x6a, 0x4a, 0x4a, 0x4a, 0x6a, 0x5a, 0x4a, 0x4a, 0x00, 0x00 },	// U+2C2E (Ⱞ)
}; // 5

static const unsigned char unifont_block282[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x2a, 0x2a, 0x08, 0x08, 0x00, 0x00 },	// U+2C30 (ⰰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x54, 0x54, 0x7c, 0x04, 0x04, 0x04, 0x7c, 0x00, 0x00 },	// U+2C31 (ⰱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x55, 0x36, 0x14, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+2C32 (ⰲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x0e, 0x34, 0x4a, 0x49, 0x31, 0x00, 0x00 },	// U+2C33 (ⰳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x55, 0x22, 0x00, 0x00 },	// U+2C34 (ⰴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x38, 0x20, 0x38, 0x20, 0x22, 0x1c, 0x00, 0x00 },	// U+2C35 (ⰵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x14, 0x36, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+2C36 (ⰶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x38, 0xfe, 0x92, 0x4c, 0x28, 0x10, 0x00, 0x00 },	// U+2C37 (ⰷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0xff, 0xb1, 0xaa, 0x44, 0x00, 0x00 },	// U+2C38 (ⰸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x36, 0x49, 0x49, 0x3e, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+2C39 (ⰹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x36, 0x49, 0x49, 0x36, 0x22, 0x41, 0x7f, 0x00, 0x00 },	// U+2C3A (ⰺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x41, 0x22, 0x14, 0x2a, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+2C3B (ⰻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x52, 0x52, 0x35, 0x35, 0x4d, 0x45, 0x00, 0x00, 0x00 },	// U+2C3C (ⰼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x3c, 0x20, 0x20, 0x3c, 0x04, 0x04, 0x00, 0x00 },	// U+2C3D (ⰽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x3c, 0x5a, 0x5a, 0x24, 0x00, 0x00 },	// U+2C3E (ⰾ)
}; // 15

static const unsigned char unifont_block283[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x48, 0x48, 0x3e, 0x0a, 0x0a, 0x08, 0x08, 0x00, 0x00 },	// U+2C40 (ⱀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x78, 0x40, 0x40, 0x78, 0x44, 0x38, 0x00, 0x00 },	// U+2C41 (ⱁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x54, 0x54, 0x54, 0x26, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2C42 (ⱂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00 },	// U+2C43 (ⱃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x2a, 0x14, 0x22, 0x41, 0x7f, 0x00, 0x00 },	// U+2C44 (ⱄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x22, 0x00, 0x00 },	// U+2C45 (ⱅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2d, 0x36, 0x64, 0x24, 0x36, 0x2d, 0x12, 0x00, 0x00 },	// U+2C46 (ⱆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x2a, 0x49, 0x49, 0x2a, 0x1c, 0x08, 0x08 },	// U+2C47 (ⱇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x4a, 0x31, 0x00, 0x00 },	// U+2C48 (ⱈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x55, 0x49, 0x41, 0x41, 0x49, 0x55, 0x3e, 0x00, 0x00 },	// U+2C49 (ⱉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x50, 0x50, 0x5c, 0x52, 0x52, 0x52, 0x5c, 0x00, 0x00 },	// U+2C4A (ⱊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x54, 0x54, 0x7c, 0x28, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+2C4B (ⱋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x45, 0x45, 0x2e, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+2C4C (ⱌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x3e, 0x49, 0x7f, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+2C4D (ⱍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x3e, 0x00, 0x00 },	// U+2C4E (ⱎ)
}; // 15

static const unsigned char unifont_block284[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x28, 0x1e, 0x12, 0x2a, 0x44, 0x7c, 0x00, 0x00 },	// U+2C50 (ⱐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x3e, 0x49, 0x49, 0x7f, 0x00, 0x00 },	// U+2C51 (ⱑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x09, 0x1e, 0x36, 0x22, 0x41, 0x41, 0x22, 0x36, 0x3c, 0x48, 0x10 },	// U+2C52 (ⱒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2a, 0x2a, 0x1a, 0x0a, 0x0a, 0x06, 0x02, 0x00, 0x00 },	// U+2C53 (ⱓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x0c, 0x3a, 0x0c, 0x08, 0x48, 0x30, 0x00, 0x00 },	// U+2C54 (ⱔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x18, 0x76, 0x1a, 0x10, 0x50, 0x20, 0x00, 0x00 },	// U+2C55 (ⱕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x32, 0x49, 0x7f, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+2C56 (ⱖ)
}; // 7

static const unsigned char unifont_block285[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x7f, 0x55, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+2C5A (ⱚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x0c, 0x72, 0x52, 0x0c, 0x12, 0x1e, 0x00, 0x00 },	// U+2C5B (ⱛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00, 0x00 },	// U+2C5C (ⱜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x46, 0x4a, 0x52, 0x7e, 0x52, 0x4a, 0x46, 0x00, 0x00 },	// U+2C5D (ⱝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x2a, 0x6a, 0x4a, 0x6a, 0x5a, 0x4a, 0x4a, 0x00, 0x00 },	// U+2C5E (ⱞ)
}; // 5

static const unsigned char unifont_block286[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x7c, 0x00, 0x00 },	// U+2C60 (Ⱡ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x38, 0x10, 0x38, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+2C61 (ⱡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x2c, 0x1a, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00 },	// U+2C62 (Ɫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x44, 0x4e, 0x44, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2C63 (Ᵽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x0a, 0x04 },	// U+2C64 (Ɽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x62, 0x20, 0x3c, 0x2a, 0x26, 0x32, 0x2d, 0x00, 0x00 },	// U+2C65 (ⱥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x88, 0x7e, 0x28, 0x18, 0x08, 0x0c, 0x0a, 0x31, 0x00, 0x00 },	// U+2C66 (ⱦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x62, 0x40, 0x40 },	// U+2C67 (Ⱨ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x22, 0x62, 0x40, 0x40 },	// U+2C68 (ⱨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0xc2, 0x80, 0x80 },	// U+2C69 (Ⱪ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0xc2, 0x80, 0x80 },	// U+2C6A (ⱪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x40, 0x40 },	// U+2C6B (Ⱬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x40, 0x40 },	// U+2C6C (ⱬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x58, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x00, 0x00 },	// U+2C6D (Ɑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x50, 0x20 },	// U+2C6E (Ɱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2C6F (Ɐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00 },	// U+2C70 (Ɒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0xa1, 0xa1, 0x12, 0x12, 0x12, 0x0c, 0x0c, 0x00, 0x00 },	// U+2C71 (ⱱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x21, 0x51, 0x51, 0x11, 0x15, 0x15, 0x1b, 0x1b, 0x11, 0x11, 0x00, 0x00 },	// U+2C72 (Ⱳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xaa, 0xaa, 0x2a, 0x2a, 0x2a, 0x2a, 0x14, 0x00, 0x00 },	// U+2C73 (ⱳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x4a, 0x46, 0x43, 0x24, 0x24, 0x24, 0x18, 0x18, 0x00, 0x00 },	// U+2C74 (ⱴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2C75 (Ⱶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2C76 (ⱶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10 },	// U+2C77 (ⱷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x02, 0xa2, 0xa2, 0x5c, 0x00, 0x00 },	// U+2C78 (ⱸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+2C79 (ⱹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xaa, 0x7c, 0x00, 0x00 },	// U+2C7A (ⱺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7c, 0x00, 0x00 },	// U+2C7B (ⱻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x30, 0x20, 0x20, 0x20, 0x28, 0x10 },	// U+2C7C (ⱼ)
	{ 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2C7D (ⱽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x0c, 0x30, 0x40, 0x40, 0x42, 0x3c, 0x90, 0x60 },	// U+2C7E (Ȿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x20, 0x10, 0x08, 0x04, 0x04, 0x02, 0x06, 0x08, 0x70 },	// U+2C7F (Ɀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x08, 0x08, 0x1c, 0x12, 0x22, 0x22, 0x52, 0x8c, 0x00, 0x00 },	// U+2C80 (Ⲁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x08, 0x1c, 0x22, 0x22, 0x52, 0x8c, 0x00, 0x00 },	// U+2C81 (ⲁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x12, 0x1e, 0x22, 0x22, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+2C82 (Ⲃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x22, 0x1e, 0x00, 0x00 },	// U+2C83 (ⲃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+2C84 (Ⲅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+2C85 (ⲅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x30, 0x30, 0x28, 0x48, 0x48, 0x48, 0x85, 0xff, 0x00, 0x00 },	// U+2C86 (Ⲇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x18, 0x18, 0x28, 0x28, 0x45, 0x7f, 0x00, 0x00 },	// U+2C87 (ⲇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x01, 0x7f, 0x01, 0x01, 0x42, 0x66, 0x3c, 0x00, 0x00 },	// U+2C88 (Ⲉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x01, 0x7f, 0x01, 0x01, 0x42, 0x3c, 0x00, 0x00 },	// U+2C89 (ⲉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x5c, 0x22, 0x02, 0x02, 0x02, 0x04, 0x08, 0x10, 0x20, 0x20, 0x10, 0x00 },	// U+2C8A (Ⲋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x22, 0x02, 0x02, 0x04, 0x18, 0x20, 0x20, 0x10, 0x00 },	// U+2C8B (ⲋ)
	{ 0x00, 0x00, 0x00, 0x01, 0x7f, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7f, 0x40, 0x00 },	// U+2C8C (Ⲍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7f, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7f, 0x40, 0x00 },	// U+2C8D (ⲍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+2C8E (Ⲏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+2C8F (ⲏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x25, 0xff, 0xa4, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2C90 (Ⲑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x25, 0xff, 0xa4, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2C91 (ⲑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00 },	// U+2C92 (Ⲓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00 },	// U+2C93 (ⲓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+2C94 (Ⲕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+2C95 (ⲕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x18, 0x10, 0x10, 0x30, 0x28, 0x24, 0x42, 0xc1, 0x00, 0x00 },	// U+2C96 (Ⲗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x08, 0x08, 0x18, 0x14, 0x22, 0x61, 0x00, 0x00 },	// U+2C97 (ⲗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x63, 0x55, 0x49, 0x41, 0x41, 0x41, 0x41, 0x41, 0x00, 0x00 },	// U+2C98 (Ⲙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x36, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+2C99 (ⲙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x43, 0x45, 0x49, 0x49, 0x51, 0x61, 0x41, 0x41, 0x00, 0x00 },	// U+2C9A (Ⲛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x00 },	// U+2C9B (ⲛ)
	{ 0x00, 0x00, 0x00, 0x01, 0xff, 0x40, 0x30, 0x0c, 0x1f, 0x20, 0x40, 0x40, 0x30, 0xfe, 0x80, 0x00 },	// U+2C9C (Ⲝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3f, 0x20, 0x18, 0x06, 0x0f, 0x10, 0x18, 0x7e, 0x40, 0x00 },	// U+2C9D (ⲝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x22, 0x41, 0x41, 0x41, 0x41, 0x22, 0x36, 0x1c, 0x00, 0x00 },	// U+2C9E (Ⲟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x22, 0x41, 0x41, 0x22, 0x36, 0x1c, 0x00, 0x00 },	// U+2C9F (ⲟ)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+2CA0 (Ⲡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+2CA1 (ⲡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+2CA2 (Ⲣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+2CA3 (ⲣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x44, 0x02, 0x02, 0x02, 0x02, 0x44, 0x6c, 0x38, 0x00, 0x00 },	// U+2CA4 (Ⲥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x44, 0x02, 0x02, 0x44, 0x6c, 0x38, 0x00, 0x00 },	// U+2CA5 (ⲥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2CA6 (Ⲧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2CA7 (ⲧ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc1, 0x41, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2CA8 (Ⲩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc1, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2CA9 (ⲩ)
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x3e, 0x2a, 0x49, 0x49, 0x49, 0x49, 0x2a, 0x3e, 0x1c, 0x08, 0x08 },	// U+2CAA (Ⲫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x3e, 0x2a, 0x49, 0x49, 0x2a, 0x3e, 0x1c, 0x08, 0x08 },	// U+2CAB (ⲫ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc2, 0x42, 0x24, 0x18, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+2CAC (Ⲭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+2CAD (ⲭ)
	{ 0x00, 0x00, 0x08, 0x08, 0xc9, 0x49, 0x2a, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+2CAE (Ⲯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0xc9, 0x2a, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+2CAF (ⲯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+2CB0 (Ⲱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+2CB1 (ⲱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2CB2 (Ⲳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2CB3 (ⲳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x62, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+2CB4 (Ⲵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x22, 0x04, 0x08, 0x10, 0x00, 0x00 },	// U+2CB5 (ⲵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x7f, 0x00, 0x00, 0x40, 0x7f, 0x00, 0x00, 0x40, 0x7f, 0x00, 0x00 },	// U+2CB6 (Ⲷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x7e, 0x00, 0x40, 0x7e, 0x00, 0x40, 0x7e, 0x00, 0x00 },	// U+2CB7 (ⲷ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x3e, 0x00, 0x00, 0x00 },	// U+2CB8 (Ⲹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x3c, 0x00, 0x00 },	// U+2CB9 (ⲹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2CBA (Ⲻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2CBB (ⲻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x00, 0x00 },	// U+2CBC (Ⲽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x00, 0x00 },	// U+2CBD (ⲽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0xff, 0x49, 0x49, 0x49, 0x49, 0x49, 0x00, 0x00 },	// U+2CBE (Ⲿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0xff, 0x49, 0x49, 0x49, 0x49, 0x00, 0x00 },	// U+2CBF (ⲿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x44, 0x44, 0x44, 0x3c, 0x04, 0x7f, 0x05, 0x04, 0x04, 0x04, 0x04 },	// U+2CC0 (Ⳁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x44, 0x44, 0x44, 0x3c, 0x04, 0x7f, 0x05, 0x04, 0x04 },	// U+2CC1 (ⳁ)
	{ 0x2a, 0x08, 0x3e, 0x08, 0x22, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x76, 0x40, 0x3e, 0x01 },	// U+2CC2 (Ⳃ)
	{ 0x00, 0x00, 0x2a, 0x08, 0x3e, 0x08, 0x22, 0x49, 0x49, 0x49, 0x49, 0x49, 0x76, 0x40, 0x3e, 0x01 },	// U+2CC3 (ⳃ)
	{ 0x00, 0x00, 0x00, 0x02, 0x7e, 0x40, 0x30, 0x0c, 0x1e, 0x20, 0x40, 0x40, 0x40, 0x20, 0x1e, 0x00 },	// U+2CC4 (Ⳅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3e, 0x20, 0x10, 0x08, 0x3c, 0x40, 0x40, 0x42, 0x3c, 0x00 },	// U+2CC5 (ⳅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x08, 0x04, 0x04 },	// U+2CC6 (Ⳇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x10, 0x10, 0x10, 0x08, 0x08, 0x08, 0x04, 0x04 },	// U+2CC7 (ⳇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x20, 0x7e, 0x08, 0x04, 0x42, 0x3c, 0x00, 0x00 },	// U+2CC8 (Ⳉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x20, 0x7e, 0x0c, 0x42, 0x3c, 0x00, 0x00 },	// U+2CC9 (ⳉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x52, 0x4c, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+2CCA (Ⳋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x52, 0x4c, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+2CCB (ⳋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x23, 0x43, 0x40, 0x20, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x41, 0x3e },	// U+2CCC (Ⳍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x23, 0x43, 0x40, 0x3c, 0x20, 0x40, 0x40, 0x41, 0x3e },	// U+2CCD (ⳍ)
}; // 110

static const unsigned char unifont_block287[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x42, 0x7e, 0x00, 0x00 },	// U+2CD0 (Ⳑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x3e, 0x00, 0x00 },	// U+2CD1 (ⳑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x32, 0x4a, 0x42, 0x3c, 0x00, 0x00 },	// U+2CD2 (Ⳓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x32, 0x4a, 0x42, 0x3c, 0x00, 0x00 },	// U+2CD3 (ⳓ)
	{ 0x00, 0x30, 0x08, 0x04, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x00, 0x00 },	// U+2CD4 (Ⳕ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x04, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x00, 0x00 },	// U+2CD5 (ⳕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x7e, 0x05, 0x02 },	// U+2CD6 (Ⳗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x48, 0x7c, 0x0a, 0x04 },	// U+2CD7 (ⳗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xff, 0x00, 0x00 },	// U+2CD8 (Ⳙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x7e, 0x00, 0x00 },	// U+2CD9 (ⳙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x30, 0x30, 0x2a, 0x4c, 0x58, 0x68, 0xc5, 0xff, 0x00, 0x00 },	// U+2CDA (Ⳛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x30, 0x34, 0x58, 0x70, 0xca, 0xfe, 0x00, 0x00 },	// U+2CDB (ⳛ)
	{ 0x00, 0x3c, 0x02, 0x02, 0x1c, 0x36, 0x22, 0x41, 0x41, 0x41, 0x41, 0x22, 0x36, 0x1c, 0x00, 0x00 },	// U+2CDC (Ⳝ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x1c, 0x36, 0x22, 0x41, 0x41, 0x22, 0x36, 0x1c, 0x00, 0x00 },	// U+2CDD (ⳝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x44, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x7c, 0x00, 0x00 },	// U+2CDE (Ⳟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x44, 0x04, 0x04, 0x04, 0x04, 0x24, 0x3c, 0x00, 0x00 },	// U+2CDF (ⳟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x64, 0x92, 0x8a, 0x46, 0x24, 0x1a, 0x02, 0x01, 0x01, 0x00, 0x00 },	// U+2CE0 (Ⳡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x64, 0x92, 0x4e, 0x24, 0x1a, 0x01, 0x01, 0x00, 0x00 },	// U+2CE1 (ⳡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x04, 0x3c, 0x44, 0x44, 0x44, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2CE2 (Ⳣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x04, 0x3c, 0x44, 0x44, 0x44, 0x3c, 0x04, 0x04, 0x04 },	// U+2CE3 (ⳣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x42, 0x40, 0x38 },	// U+2CE4 (ⳤ)
	{ 0x00, 0x00, 0x78, 0x88, 0x88, 0x78, 0x08, 0x49, 0x6b, 0x5d, 0x49, 0x49, 0x49, 0x49, 0x08, 0x08 },	// U+2CE5 (⳥)
	{ 0x00, 0x78, 0x88, 0x88, 0x78, 0x08, 0x7f, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x08, 0x08 },	// U+2CE6 (⳦)
}; // 23

static const unsigned char unifont_block288[][16] = {
	{ 0x00, 0x78, 0x88, 0x88, 0x78, 0x08, 0x7e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2CE8 (⳨)
	{ 0x78, 0x88, 0x88, 0x78, 0x08, 0x08, 0x6a, 0x2a, 0x2a, 0x1c, 0x1c, 0x1c, 0x2a, 0x2a, 0x08, 0x08 },	// U+2CE9 (⳩)
}; // 2

static const unsigned char unifont_block289[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x49, 0x49, 0x36, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2CEB (Ⳬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x49, 0x36, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+2CEC (ⳬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x66, 0x5a, 0x5a, 0x66, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+2CED (Ⳮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x5a, 0x5a, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+2CEE (ⳮ)
}; // 4

static const unsigned char unifont_block290[][16] = {
	{ 0x06, 0x7c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2CF0 (⳰)
	{ 0x60, 0x3e, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2CF1 (⳱)
	{ 0x00, 0x10, 0x08, 0x04, 0x3c, 0x41, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+2CF2 (Ⳳ)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x3c, 0x41, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+2CF3 (ⳳ)
}; // 4

static const unsigned char unifont_block291[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x12, 0x24, 0x24, 0x24, 0x24, 0x48, 0x48, 0x48, 0x00, 0x00 },	// U+2CF9 (⳹)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x08, 0x04, 0x04, 0x04, 0x04, 0x02, 0x32, 0x32, 0x00, 0x00 },	// U+2CFA (⳺)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x10, 0x10, 0x10, 0x10, 0x20, 0x26, 0x26, 0x00, 0x00 },	// U+2CFB (⳻)
	{ 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x24, 0x12, 0x12, 0x12, 0x12, 0x09, 0x09, 0x09, 0x00, 0x00 },	// U+2CFC (⳼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x08, 0x10, 0x20, 0x1c, 0x00, 0x00 },	// U+2CFD (⳽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x08, 0x08, 0x6b, 0x08, 0x08, 0x0c, 0x00, 0x00, 0x00 },	// U+2CFE (⳾)
	{ 0x00, 0x0c, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2CFF (⳿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x44, 0x04, 0x04, 0x04, 0x7c, 0x40, 0x00 },	// U+2D00 (ⴀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x22, 0x22, 0x3e, 0x20, 0x40, 0x42, 0x3c },	// U+2D01 (ⴁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x22, 0x22, 0x22, 0x22, 0x42, 0x40, 0x3c },	// U+2D02 (ⴂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3e, 0x28, 0x08, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+2D03 (ⴃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x22, 0x22, 0x22, 0x22, 0x62, 0x40, 0x40 },	// U+2D04 (ⴄ)
}; // 12

static const unsigned char unifont_block292[][16] = {
	{ 0x00, 0x00, 0x00, 0x02, 0x0e, 0x08, 0x08, 0x08, 0x38, 0x48, 0x48, 0x48, 0x48, 0x38, 0x00, 0x00 },	// U+2D06 (ⴆ)
}; // 1

static const unsigned char unifont_block293[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x4c, 0x44, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+2D08 (ⴈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x38, 0x20, 0x20, 0x20 },	// U+2D09 (ⴉ)
}; // 2

static const unsigned char unifont_block294[][16] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x3c, 0x20, 0x20, 0x20, 0x78, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2D0B (ⴋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x02, 0x02, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+2D0C (ⴌ)
}; // 2

static const unsigned char unifont_block295[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x4b, 0x48, 0x48, 0x48, 0xf8, 0x00, 0x00 },	// U+2D0E (ⴎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x4b, 0x48, 0x48, 0x48, 0xf8, 0x40, 0x40 },	// U+2D0F (ⴏ)
}; // 2

static const unsigned char unifont_block296[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x12, 0x12, 0x12, 0x12, 0x12, 0x3e, 0x20, 0x00 },	// U+2D11 (ⴑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x22, 0x22, 0x3e, 0x02, 0x02, 0x02, 0x3c },	// U+2D12 (ⴒ)
}; // 2

static const unsigned char unifont_block297[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x68, 0x5d, 0x0b, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2D15 (ⴕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x22, 0x22, 0x22, 0x22, 0x62, 0x00, 0x00 },	// U+2D16 (ⴖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x44, 0x44, 0x44, 0x7c, 0x40, 0x40, 0x40 },	// U+2D17 (ⴗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x44, 0x44, 0x44, 0x7c, 0x40, 0x40, 0x42, 0x3c },	// U+2D18 (ⴘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x3c, 0x24, 0x24, 0x24, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2D19 (ⴙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x22, 0x22, 0x22, 0x22, 0x22, 0x02, 0x1c },	// U+2D1A (ⴚ)
}; // 6

static const unsigned char unifont_block298[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x24, 0x04, 0x1c, 0x20, 0x24, 0x24, 0x18 },	// U+2D1D (ⴝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x44, 0x44, 0x44, 0x44, 0x7c, 0x04, 0x04 },	// U+2D1E (ⴞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x7f, 0x44, 0x28, 0x30, 0x48, 0x84, 0x02, 0x01 },	// U+2D1F (ⴟ)
}; // 3

static const unsigned char unifont_block299[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x1e, 0x32, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+2D21 (ⴡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1e, 0x20, 0x20, 0x20, 0x1e, 0x00, 0x00 },	// U+2D22 (ⴢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x26, 0x24, 0x24, 0x3c, 0x20, 0x20, 0x20, 0x20 },	// U+2D23 (ⴣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x44, 0x44, 0x7c, 0x10, 0x10 },	// U+2D24 (ⴤ)
}; // 4

static const unsigned char unifont_block300[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x10, 0x0c, 0x02, 0x22, 0x1c },	// U+2D27 (ⴧ)
}; // 1

static const unsigned char unifont_block301[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x20, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+2D2D (ⴭ)
}; // 1

static const unsigned char unifont_block302[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2D30 (ⴰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x7f, 0x41, 0x22, 0x1c, 0x00, 0x00 },	// U+2D31 (ⴱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x49, 0x7f, 0x49, 0x2a, 0x1c, 0x00, 0x00 },	// U+2D32 (ⴲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00 },	// U+2D33 (ⴳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x7f, 0x00, 0x00 },	// U+2D34 (ⴴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x7f, 0x00, 0x00 },	// U+2D35 (ⴵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x6b, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2D36 (ⴶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x14, 0x14, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+2D37 (ⴷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+2D38 (ⴸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+2D39 (ⴹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7e, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+2D3A (ⴺ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2D3B (ⴻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x14, 0x14, 0x14, 0x1c, 0x14, 0x14, 0x14, 0x77, 0x00 },	// U+2D3C (ⴼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x21, 0x11, 0x09, 0x09, 0x15, 0x23, 0x41, 0x00, 0x00 },	// U+2D3D (ⴽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2D3E (ⴾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x23, 0x15, 0x09, 0x09, 0x11, 0x21, 0x7f, 0x00, 0x00 },	// U+2D3F (ⴿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x49, 0x49, 0x49, 0x2a, 0x1c, 0x00, 0x00 },	// U+2D40 (ⵀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x22, 0x51, 0x49, 0x45, 0x22, 0x1d, 0x00, 0x00 },	// U+2D41 (ⵁ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18 },	// U+2D42 (ⵂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x18, 0x24, 0x42, 0x81, 0x00, 0x00 },	// U+2D43 (ⵃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+2D44 (ⵄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x2a, 0x1c, 0x08, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00 },	// U+2D45 (ⵅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00 },	// U+2D46 (ⵆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x21, 0x11, 0x09, 0x09, 0x05, 0x03, 0x7f, 0x00, 0x00 },	// U+2D47 (ⵇ)
}; // 24

static const unsigned char unifont_block303[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x08, 0x10, 0x00, 0x00 },	// U+2D49 (ⵉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+2D4A (ⵊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x14, 0x08, 0x08, 0x08, 0x14, 0x63, 0x00, 0x00 },	// U+2D4B (ⵋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x7f, 0x14, 0x7f, 0x14, 0x14, 0x14, 0x00 },	// U+2D4C (ⵌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x34, 0x2c, 0x24, 0x24, 0x24, 0x24, 0x00 },	// U+2D4D (ⵍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+2D4E (ⵎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+2D4F (ⵏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x7f, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x00 },	// U+2D50 (ⵐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08 },	// U+2D51 (ⵑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x20, 0x10, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2D52 (ⵒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2D53 (ⵓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x00, 0x00 },	// U+2D54 (ⵔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x49, 0x51, 0x22, 0x5c, 0x00, 0x00 },	// U+2D55 (ⵕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2D56 (ⵖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+2D57 (ⵗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0xc3, 0xc3, 0x00 },	// U+2D58 (ⵘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x5d, 0x5d, 0x5d, 0x22, 0x1c, 0x00, 0x00 },	// U+2D59 (ⵙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x22, 0x51, 0x49, 0x41, 0x22, 0x1c, 0x00, 0x00 },	// U+2D5A (ⵚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x94, 0x62, 0x02, 0x02, 0x02, 0x62, 0x94, 0x78, 0x00, 0x00 },	// U+2D5B (ⵛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+2D5C (ⵜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00 },	// U+2D5D (ⵝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x94, 0x62, 0x0a, 0x1e, 0x0a, 0x62, 0x94, 0x78, 0x00, 0x00 },	// U+2D5E (ⵞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x12, 0x12, 0x3e, 0x12, 0x12, 0x02, 0x7e, 0x00, 0x00 },	// U+2D5F (ⵟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+2D60 (ⵠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+2D61 (ⵡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+2D62 (ⵢ)
	{ 0x00, 0x00, 0x00, 0x49, 0x49, 0x2a, 0x1c, 0x08, 0x08, 0x08, 0x1c, 0x2a, 0x49, 0x49, 0x00, 0x00 },	// U+2D63 (ⵣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x14, 0x24, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2D64 (ⵤ)
	{ 0x00, 0x00, 0x00, 0x49, 0x49, 0x2a, 0x1c, 0x08, 0x7f, 0x08, 0x1c, 0x2a, 0x49, 0x49, 0x00, 0x00 },	// U+2D65 (ⵥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+2D66 (ⵦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2D67 (ⵧ)
}; // 31

static const unsigned char unifont_block304[][16] = {
	{ 0x00, 0x24, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2D6F (ⵯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x10, 0x08, 0x06, 0x00 },	// U+2D70 (⵰)
}; // 2

static const unsigned char unifont_block305[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf8, 0x20 },	// U+2D7F (⵿)
}; // 1

static const unsigned char unifont_block306[][16] = {
	{ 0x20, 0x18, 0x04, 0x1c, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE0 (ⷠ)
	{ 0x1c, 0x24, 0x1c, 0x24, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE1 (ⷡ)
	{ 0x1c, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE2 (ⷢ)
	{ 0x38, 0x28, 0x28, 0x24, 0x7c, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE3 (ⷣ)
	{ 0x2a, 0x2a, 0x1c, 0x2a, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE4 (ⷤ)
	{ 0x18, 0x24, 0x10, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE5 (ⷥ)
	{ 0x24, 0x14, 0x0c, 0x14, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE6 (ⷦ)
	{ 0x78, 0x48, 0x48, 0x4a, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE7 (ⷧ)
	{ 0x22, 0x36, 0x2a, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE8 (ⷨ)
	{ 0x24, 0x24, 0x3c, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE9 (ⷩ)
	{ 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DEA (ⷪ)
	{ 0x3c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DEB (ⷫ)
	{ 0x1c, 0x24, 0x1c, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DEC (ⷬ)
	{ 0x18, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DED (ⷭ)
	{ 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DEE (ⷮ)
	{ 0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DEF (ⷯ)
	{ 0x24, 0x24, 0x24, 0x24, 0x7c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF0 (ⷰ)
	{ 0x24, 0x24, 0x38, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF1 (ⷱ)
	{ 0x2a, 0x2a, 0x2a, 0x2a, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF2 (ⷲ)
	{ 0x2a, 0x2a, 0x2a, 0x2a, 0x7e, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF3 (ⷳ)
	{ 0x18, 0x24, 0x3c, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF4 (ⷴ)
	{ 0xfc, 0x22, 0x22, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF5 (ⷵ)
	{ 0x18, 0x20, 0x38, 0x24, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF6 (ⷶ)
	{ 0x18, 0x24, 0x3c, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF7 (ⷷ)
	{ 0x10, 0x38, 0x10, 0x38, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF8 (ⷸ)
	{ 0x20, 0x14, 0x08, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF9 (ⷹ)
	{ 0x08, 0x3e, 0x08, 0x38, 0x48, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFA (ⷺ)
	{ 0x32, 0x4a, 0x4e, 0x4a, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFB (ⷻ)
	{ 0x32, 0x42, 0x7e, 0x4a, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFC (ⷼ)
	{ 0x08, 0x14, 0x1c, 0x2a, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFD (ⷽ)
	{ 0x3e, 0x22, 0x14, 0x1c, 0x2a, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFE (ⷾ)
	{ 0xfa, 0x8a, 0x52, 0x7e, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFF (ⷿ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E00 (⸀)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x24, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E01 (⸁)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E02 (⸂)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E03 (⸃)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x24, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E04 (⸄)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x24, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E05 (⸅)
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E06 (⸆)
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x28, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E07 (⸇)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x24, 0x08, 0x11, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E08 (⸈)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x04, 0x08, 0x11, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E09 (⸉)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x08, 0x04, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E0A (⸊)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E0B (⸋)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E0C (⸌)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E0D (⸍)
}; // 46

static const unsigned char unifont_block307[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x08 },	// U+2E12 (⸒)
}; // 1

static const unsigned char unifont_block308[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x10, 0x00, 0x00 },	// U+2E16 (⸖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x18, 0x06, 0x60, 0x18, 0x06, 0x00, 0x00 },	// U+2E17 (⸗)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x08, 0x08, 0x0c, 0x0a, 0x4a, 0x4a, 0x3c, 0x00, 0x00 },	// U+2E18 (⸘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xd4, 0x35, 0xf5, 0x0d, 0x7e, 0x07, 0x3b, 0x00, 0x00 },	// U+2E19 (⸙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E1A (⸚)
	{ 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x8c, 0x92, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E1B (⸛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20 },	// U+2E1C (⸜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02 },	// U+2E1D (⸝)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x8c, 0x92, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E1E (⸞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x92, 0x62, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00 },	// U+2E1F (⸟)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2E20 (⸠)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2E21 (⸡)
	{ 0x00, 0x00, 0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E22 (⸢)
	{ 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E23 (⸣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x70, 0x00 },	// U+2E24 (⸤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00 },	// U+2E25 (⸥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+2E26 (⸦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2E27 (⸧)
	{ 0x00, 0x00, 0x00, 0x48, 0x24, 0x24, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0x24, 0x48, 0x00 },	// U+2E28 (⸨)
	{ 0x00, 0x00, 0x00, 0x09, 0x12, 0x12, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x12, 0x12, 0x09, 0x00 },	// U+2E29 (⸩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2E2A (⸪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00 },	// U+2E2B (⸫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00 },	// U+2E2C (⸬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0xdb, 0xdb, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+2E2D (⸭)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x04, 0x08, 0x08, 0x00, 0x08, 0x08, 0x00, 0x00 },	// U+2E2E (⸮)
	{ 0x10, 0x08, 0x08, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E2F (ⸯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E30 (⸰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E31 (⸱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x18, 0x00, 0x00 },	// U+2E32 (⸲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2E33 (⸳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08, 0x00, 0x00 },	// U+2E34 (⸴)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2E35 (⸵)
	{ 0x00, 0x00, 0x10, 0x18, 0x10, 0x14, 0x1e, 0x14, 0x10, 0x18, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2E36 (⸶)
	{ 0x00, 0x00, 0x10, 0x30, 0x10, 0x50, 0xf0, 0x50, 0x10, 0x30, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2E37 (⸷)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x38, 0x10, 0x54, 0xfe, 0x54, 0x10, 0x38, 0x10, 0x00, 0x00 },	// U+2E38 (⸸)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E39 (⸹)
}; // 36

static const unsigned char unifont_block309[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x28, 0x00, 0x00 },	// U+2E3C (⸼)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00 },	// U+2E3D (⸽)
	{ 0x00, 0x30, 0x08, 0x10, 0x20, 0x10, 0x08, 0x10, 0x20, 0x10, 0x08, 0x10, 0x20, 0x18, 0x00, 0x00 },	// U+2E3E (⸾)
	{ 0x00, 0x50, 0xfe, 0x51, 0x51, 0xff, 0x51, 0xfe, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x00, 0x00 },	// U+2E3F (⸿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2E40 (⹀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x08, 0x08, 0x10 },	// U+2E41 (⹁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x22, 0x22, 0x44 },	// U+2E42 (⹂)
}; // 7

static const unsigned char unifont_block310[][16] = {
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04 },	// U+2E44 (⹄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E45 (⹅)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x18, 0x00, 0x18, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E46 (⹆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E47 (⹇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E48 (⹈)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x10, 0x08, 0x00, 0x18, 0x24, 0x20, 0x10, 0x08, 0x00 },	// U+2E49 (⹉)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x18, 0x3c, 0x3c, 0x18, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+2E4A (⹊)
	{ 0x00, 0x10, 0x54, 0xfe, 0x54, 0x10, 0x10, 0x54, 0xfe, 0x54, 0x10, 0x10, 0x54, 0xfe, 0x54, 0x10 },	// U+2E4B (⹋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00 },	// U+2E4C (⹌)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x22, 0x12, 0x0a, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+2E4D (⹍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x16, 0x0e, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00 },	// U+2E4E (⹎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x26, 0x10, 0x48, 0x24, 0x10, 0x08, 0x64, 0x60, 0x00, 0x00 },	// U+2E4F (⹏)
}; // 12

static const unsigned char unifont_block311[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x44, 0x38, 0x00, 0x00 },	// U+2E52 (⹒)
}; // 1

static const unsigned char unifont_block312[][16] = {
	{ 0x00, 0x7f, 0x41, 0x63, 0x63, 0x55, 0x55, 0x49, 0x55, 0x55, 0x63, 0x63, 0x41, 0x7f, 0x00, 0x00 },	// U+303F (〿)
}; // 1

static const unsigned char unifont_block313[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+A4D0 (ꓐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A4D1 (ꓑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00 },	// U+A4D2 (ꓒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+A4D3 (ꓓ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+A4D4 (ꓔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x00, 0x00 },	// U+A4D5 (ꓕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+A4D6 (ꓖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+A4D7 (ꓗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x00 },	// U+A4D8 (ꓘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+A4D9 (ꓙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A4DA (ꓚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A4DB (ꓛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+A4DC (ꓜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A4DD (ꓝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+A4DE (ꓞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+A4DF (ꓟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x46, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x62, 0x42, 0x00, 0x00 },	// U+A4E0 (ꓠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+A4E1 (ꓡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A4E2 (ꓢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+A4E3 (ꓣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x44, 0x44, 0x48, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00 },	// U+A4E4 (ꓤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x44, 0x82, 0x82, 0x82, 0x00, 0x00 },	// U+A4E5 (ꓥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+A4E6 (ꓦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+A4E7 (ꓧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x4e, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A4E8 (ꓨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A4E9 (ꓩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+A4EA (ꓪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00 },	// U+A4EB (ꓫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+A4EC (ꓬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00 },	// U+A4ED (ꓭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+A4EE (ꓮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+A4EF (ꓯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+A4F0 (ꓰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+A4F1 (ꓱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+A4F2 (ꓲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A4F3 (ꓳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A4F4 (ꓴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+A4F5 (ꓵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+A4F6 (ꓶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x78, 0x00, 0x00 },	// U+A4F7 (ꓷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+A4F8 (ꓸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08 },	// U+A4F9 (ꓹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00 },	// U+A4FA (ꓺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x46, 0x40, 0x20 },	// U+A4FB (ꓻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x08, 0x00 },	// U+A4FC (ꓼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+A4FD (ꓽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00 },	// U+A4FE (꓾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+A4FF (꓿)
}; // 48

static const unsigned char unifont_block314[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x5c, 0x22 },	// U+A640 (Ꙁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x5c, 0x22 },	// U+A641 (ꙁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x3e, 0x04, 0x02, 0x02, 0x7e, 0x5c, 0x22 },	// U+A642 (Ꙃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x7e, 0x08, 0x04, 0x02, 0x7e, 0x5c, 0x22 },	// U+A643 (ꙃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x30, 0x0c, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A644 (Ꙅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x30, 0x0c, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+A645 (ꙅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+A646 (Ꙇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+A647 (ꙇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x08, 0x1c, 0x22, 0x41, 0x41, 0x41, 0x41, 0x00, 0x00 },	// U+A648 (Ꙉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+A649 (ꙉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x3c, 0x52, 0x4a, 0x52, 0x42, 0x3c },	// U+A64A (Ꙋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x22, 0x22, 0x14, 0x08, 0x14, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+A64B (ꙋ)
}; // 12

static const unsigned char unifont_block315[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x08, 0x78, 0x88, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00 },	// U+A64E (Ꙏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x78, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00 },	// U+A64F (ꙏ)
}; // 2

static const unsigned char unifont_block316[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x7e, 0x0a, 0x0a, 0x3a, 0x4a, 0x4a, 0x4a, 0x4a, 0x3a, 0x00, 0x00 },	// U+A652 (Ꙓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x7e, 0x0a, 0x0a, 0x3a, 0x4a, 0x4a, 0x3a, 0x00, 0x00 },	// U+A653 (ꙓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x52, 0x52, 0x72, 0x52, 0x52, 0x52, 0x52, 0x4c, 0x00, 0x00 },	// U+A654 (Ꙕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x52, 0x72, 0x52, 0x52, 0x52, 0x4c, 0x00, 0x00 },	// U+A655 (ꙕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x29, 0x45, 0x45, 0x7f, 0x45, 0x45, 0x45, 0x45, 0x45, 0x00, 0x00 },	// U+A656 (Ꙗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x42, 0x42, 0x72, 0x4e, 0x4a, 0x4a, 0x72, 0x00, 0x00 },	// U+A657 (ꙗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x7c, 0x44, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+A658 (Ꙙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x44, 0x7c, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+A659 (ꙙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x44, 0x28, 0x10, 0x38, 0x44, 0xfe, 0x92, 0x92, 0x00, 0x00 },	// U+A65A (Ꙛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x28, 0x7c, 0x82, 0xfe, 0x92, 0x92, 0x00, 0x00 },	// U+A65B (ꙛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x2a, 0x2a, 0x4a, 0x7e, 0x46, 0x82, 0x82, 0xfe, 0x00, 0x00 },	// U+A65C (Ꙝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x52, 0x52, 0x8a, 0xfe, 0x8a, 0x8a, 0xfa, 0x00, 0x00 },	// U+A65D (ꙝ)
}; // 12

static const unsigned char unifont_block317[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x54, 0x95, 0x92, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+A65F (ꙟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0xfe, 0x02, 0x02 },	// U+A660 (Ꙡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7e, 0x02, 0x02 },	// U+A661 (ꙡ)
}; // 3

static const unsigned char unifont_block318[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A668 (Ꙩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x5a, 0x5a, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A669 (ꙩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x41, 0x41, 0x41, 0x41, 0x55, 0x41, 0x41, 0x41, 0x3e, 0x00, 0x00 },	// U+A66A (Ꙫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0xaa, 0x82, 0x82, 0x7c, 0x00, 0x00 },	// U+A66B (ꙫ)
}; // 4

static const unsigned char unifont_block319[][16] = {
	{ 0x00, 0x7e, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A66F (꙯)
}; // 1

static const unsigned char unifont_block320[][16] = {
	{ 0x00, 0x7e, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x7e },	// U+A671 (꙱)
}; // 1

static const unsigned char unifont_block321[][16] = {
	{ 0x08, 0x14, 0x77, 0x41, 0x22, 0x41, 0x77, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A673 (꙳)
	{ 0x00, 0x38, 0x44, 0x1c, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A674 (ꙴ)
	{ 0x00, 0x44, 0x64, 0x54, 0x4c, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A675 (ꙵ)
	{ 0x00, 0x28, 0x00, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A676 (ꙶ)
	{ 0x00, 0x44, 0x28, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A677 (ꙷ)
	{ 0x00, 0x0c, 0x08, 0x38, 0x48, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A678 (ꙸ)
	{ 0x00, 0x42, 0x42, 0x4e, 0x52, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A679 (ꙹ)
	{ 0x00, 0x04, 0x04, 0x1c, 0x24, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A67A (ꙺ)
	{ 0x00, 0x2a, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A67B (ꙻ)
	{ 0x00, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A67C (꙼)
	{ 0x00, 0x50, 0x50, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A67D (꙽)
	{ 0x00, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A67E (꙾)
	{ 0x00, 0x50, 0x50, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A67F (ꙿ)
	{ 0x00, 0x08, 0x08, 0x08, 0x78, 0x48, 0x48, 0x48, 0x44, 0x44, 0x44, 0x42, 0x42, 0xff, 0x81, 0x81 },	// U+A680 (Ꚁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x78, 0x48, 0x44, 0x44, 0x42, 0x42, 0x42, 0xfe, 0x82, 0x00 },	// U+A681 (ꚁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x42, 0x42, 0x3c },	// U+A682 (Ꚃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x24, 0x24, 0x18 },	// U+A683 (ꚃ)
}; // 17

static const unsigned char unifont_block322[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x76, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+A686 (Ꚇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x76, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+A687 (ꚇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x28, 0x28, 0x28, 0x24, 0x24, 0x24, 0x62, 0x92, 0x5f, 0x81, 0x61 },	// U+A688 (Ꚉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x28, 0x24, 0x24, 0x22, 0x62, 0x92, 0x5e, 0x82, 0x60 },	// U+A689 (ꚉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x68, 0x98, 0x88, 0x88, 0x88, 0x88, 0xa0, 0x40 },	// U+A68A (Ꚋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x68, 0x98, 0x88, 0x88, 0x88, 0xa0, 0x40 },	// U+A68B (ꚋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x48, 0x30, 0x00, 0x00 },	// U+A68C (Ꚍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x48, 0x30, 0x00, 0x00 },	// U+A68D (ꚍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x9c, 0x82, 0x7c },	// U+A68E (Ꚏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x9c, 0x82, 0x7c },	// U+A68F (ꚏ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x02, 0x0c },	// U+A690 (Ꚑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x02, 0x0c },	// U+A691 (ꚑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x5f, 0x44, 0x44, 0x44, 0x44, 0x64, 0x58, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+A692 (Ꚓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x44, 0x44, 0x44, 0x64, 0x58, 0x40, 0x40, 0x00, 0x00 },	// U+A693 (ꚓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x02, 0x02, 0x1a, 0x26, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+A694 (Ꚕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x02, 0x02, 0x1a, 0x26, 0x22, 0x22, 0x00, 0x00 },	// U+A695 (ꚕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x7f, 0x9c, 0x82, 0x7c },	// U+A696 (Ꚗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x7f, 0x9c, 0x82, 0x7c },	// U+A697 (ꚗ)
}; // 18

static const unsigned char unifont_block323[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x49, 0x49, 0x49, 0x7f, 0x49, 0x49, 0x49, 0x49, 0x3e, 0x00, 0x00 },	// U+A69A (Ꚛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x92, 0xfe, 0x92, 0x92, 0x92, 0x7c, 0x00, 0x00 },	// U+A69B (ꚛ)
	{ 0x00, 0x0e, 0x0a, 0x38, 0x48, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A69C (ꚜ)
	{ 0x00, 0x04, 0x04, 0x1c, 0x24, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A69D (ꚝ)
	{ 0x10, 0x38, 0x54, 0x54, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A69E (ꚞ)
	{ 0x00, 0x32, 0x0a, 0x3e, 0x0a, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A69F (ꚟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x50, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+A6A0 (ꚠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x42, 0x00, 0x00 },	// U+A6A1 (ꚡ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x1c, 0x22, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x00, 0x00 },	// U+A6A2 (ꚢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x2c, 0x12, 0x12, 0x4a, 0x0a, 0x04, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+A6A3 (ꚣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x24, 0x44, 0x46, 0x4a, 0x31, 0x00, 0x00 },	// U+A6A4 (ꚤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x12, 0x02, 0x3e, 0x00, 0x10, 0x00, 0x00 },	// U+A6A5 (ꚥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x3e, 0x40, 0x40, 0x3e, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+A6A6 (ꚦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x10, 0x10, 0x08, 0x08, 0x0c, 0x0c, 0x12, 0x62, 0x00, 0x00 },	// U+A6A7 (ꚧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00 },	// U+A6A8 (ꚨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x31, 0x49, 0x45, 0x45, 0x21, 0x1e, 0x00, 0x00, 0x08, 0x00, 0x00 },	// U+A6A9 (ꚩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x25, 0x1e, 0x04, 0x24, 0x04, 0x24, 0x04, 0x00, 0x00 },	// U+A6AA (ꚪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x2a, 0x09, 0x08, 0x0a, 0x08, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+A6AB (ꚫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x38, 0x44, 0x44, 0x54, 0x54, 0x24, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+A6AC (ꚬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x44, 0x48, 0x44, 0x7e, 0x00, 0x00 },	// U+A6AD (ꚭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x0a, 0x02, 0x1e, 0x20, 0x20, 0x1e, 0x02, 0x0a, 0x02, 0x00, 0x00 },	// U+A6AE (ꚮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x06, 0x00, 0x12, 0x06, 0x0a, 0x12, 0x02, 0x02, 0x00, 0x00 },	// U+A6AF (ꚯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x32, 0x42, 0x32, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A6B0 (ꚰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A6B1 (ꚱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x41, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A6B2 (ꚲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+A6B3 (ꚳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x51, 0x11, 0x71, 0x0a, 0x4a, 0x04, 0x04, 0x00, 0x00 },	// U+A6B4 (ꚴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A6B5 (ꚵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x52, 0x12, 0x12, 0x52, 0x12, 0x1e, 0x12, 0x00 },	// U+A6B6 (ꚶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x34, 0x2c, 0x26, 0x65, 0x04, 0x14, 0x04, 0x04, 0x00, 0x00 },	// U+A6B7 (ꚷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x01, 0x19, 0x21, 0x42, 0x4c, 0x40, 0x20, 0x18, 0x00, 0x00 },	// U+A6B8 (ꚸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x48, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A6B9 (ꚹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x48, 0x18, 0x24, 0x22, 0x22, 0x24, 0x18, 0x08, 0x06, 0x00, 0x00 },	// U+A6BA (ꚺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x1e, 0x12, 0x12, 0x72, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A6BB (ꚻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x03, 0x0c, 0x30, 0x40, 0x30, 0x0c, 0x03, 0x08, 0x00, 0x00 },	// U+A6BC (ꚼ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x18, 0x24, 0x40, 0x40, 0x40, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+A6BD (ꚽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x3e, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+A6BE (ꚾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x44, 0x4e, 0x40, 0x40, 0x20, 0x20, 0x00, 0x00 },	// U+A6BF (ꚿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x40, 0x20, 0x20, 0x00, 0x00 },	// U+A6C0 (ꛀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x40, 0x40, 0x40, 0x20, 0x20, 0x00, 0x00 },	// U+A6C1 (ꛁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x7a, 0x02, 0x7a, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A6C2 (ꛂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x20, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x00 },	// U+A6C3 (ꛃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x62, 0x5a, 0x46, 0x46, 0x5a, 0x62, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A6C4 (ꛄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x52, 0x12, 0x1a, 0x16, 0x12, 0x12, 0x02, 0x02, 0x00, 0x00 },	// U+A6C5 (ꛅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x5e, 0x60, 0x60, 0x60, 0x5e, 0x00, 0x00 },	// U+A6C6 (ꛆ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x42, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00 },	// U+A6C7 (ꛇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x49, 0x49, 0x2a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A6C8 (ꛈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x3e, 0x00, 0x00 },	// U+A6C9 (ꛉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x24, 0x54, 0x44, 0x4a, 0x32, 0x01, 0x00, 0x00 },	// U+A6CA (ꛊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x18, 0x14, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+A6CB (ꛋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x1c, 0x22, 0x18, 0x20, 0x22, 0x1c, 0x00, 0x08, 0x00, 0x00 },	// U+A6CC (ꛌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x20, 0x20, 0x10, 0x0c, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+A6CD (ꛍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x14, 0x22, 0x22, 0x22, 0x22, 0x41, 0x41, 0x00, 0x00 },	// U+A6CE (ꛎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x41, 0x63, 0x55, 0x55, 0x49, 0x00, 0x08, 0x08, 0x00, 0x00 },	// U+A6CF (ꛏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+A6D0 (ꛐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x4c, 0x10, 0x20, 0x20, 0x20, 0x20, 0x10, 0x10, 0x08, 0x06, 0x00, 0x00 },	// U+A6D1 (ꛑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x40, 0x20, 0x20, 0x14, 0x08, 0x10, 0x00, 0x00 },	// U+A6D2 (ꛒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x25, 0x1e, 0x04, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+A6D3 (ꛓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x48, 0x08, 0x08, 0x1c, 0x2a, 0x49, 0x49, 0x49, 0x49, 0x00, 0x00 },	// U+A6D4 (ꛔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x0a, 0x12, 0x22, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x00, 0x00 },	// U+A6D5 (ꛕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x12, 0x12, 0x12, 0x12, 0x22, 0x00, 0x00 },	// U+A6D6 (ꛖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x49, 0x49, 0x49, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+A6D7 (ꛗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x43, 0x45, 0x49, 0x61, 0x61, 0x52, 0x52, 0x4a, 0x4a, 0x44, 0x00, 0x00 },	// U+A6D8 (ꛘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x14, 0x52, 0x30, 0x18, 0x14, 0x12, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+A6D9 (ꛙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x12, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+A6DA (ꛚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+A6DB (ꛛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x18, 0x24, 0x22, 0x2a, 0x2a, 0x24, 0x20, 0x20, 0x00, 0x00 },	// U+A6DC (ꛜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x11, 0x51, 0x12, 0x1c, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00 },	// U+A6DD (ꛝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A6DE (ꛞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x22, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+A6DF (ꛟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x14, 0x24, 0x44, 0x24, 0x14, 0x0c, 0x06, 0x05, 0x04, 0x00, 0x00 },	// U+A6E0 (ꛠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x29, 0x11, 0x51, 0x2e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00 },	// U+A6E1 (ꛡ)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x08, 0x04, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38, 0x00, 0x00 },	// U+A6E2 (ꛢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x3e, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+A6E3 (ꛣ)
	{ 0x00, 0x00, 0x00, 0x20, 0x46, 0x88, 0x90, 0x50, 0x10, 0x10, 0x08, 0x08, 0x04, 0x03, 0x00, 0x00 },	// U+A6E4 (ꛤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x08, 0x0e, 0x0a, 0x72, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A6E5 (ꛥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x1e, 0x20, 0x40, 0x40, 0x40, 0x20, 0x10, 0x00, 0x00 },	// U+A6E6 (ꛦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x1e, 0x20, 0x40, 0x40, 0x40, 0x20, 0x10, 0x00, 0x00 },	// U+A6E7 (ꛧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+A6E8 (ꛨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x1e, 0x20, 0x40, 0x40, 0x40, 0x20, 0x10, 0x00, 0x00 },	// U+A6E9 (ꛩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x14, 0x12, 0x10, 0x3c, 0x40, 0x40, 0x40, 0x20, 0x10, 0x00, 0x00 },	// U+A6EA (ꛪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x20, 0x20, 0x10, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+A6EB (ꛫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x28, 0x48, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+A6EC (ꛬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x20, 0x20, 0x12, 0x0c, 0x14, 0x24, 0x04, 0x04, 0x00, 0x00 },	// U+A6ED (ꛭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x4e, 0x00, 0x00 },	// U+A6EE (ꛮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x42, 0x44, 0x20, 0x18, 0x04, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A6EF (ꛯ)
	{ 0x00, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A6F0 (꛰)
	{ 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A6F1 (꛱)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x20, 0x20, 0x40, 0x40, 0x40, 0x22, 0x1c, 0x00, 0x00 },	// U+A6F2 (꛲)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x24, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+A6F3 (꛳)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x22, 0xaa, 0x22, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+A6F4 (꛴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00 },	// U+A6F5 (꛵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x24, 0x12, 0x52, 0x09, 0x09, 0x00, 0x00 },	// U+A6F6 (꛶)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x49, 0x2a, 0x1c, 0x08, 0x00, 0x08, 0x00, 0x00 },	// U+A6F7 (꛷)
}; // 94

static const unsigned char unifont_block324[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00 },	// U+A700 (꜀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x38, 0x00, 0x3c, 0x00 },	// U+A701 (꜁)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A702 (꜂)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x38, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A703 (꜃)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A704 (꜄)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x1c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A705 (꜅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x1c, 0x00, 0x00, 0x00 },	// U+A706 (꜆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x1c, 0x00, 0x3c, 0x00 },	// U+A707 (꜇)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A708 (꜈)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A709 (꜉)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A70A (꜊)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x08, 0x08, 0x00, 0x00 },	// U+A70B (꜋)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x00, 0x00 },	// U+A70C (꜌)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A70D (꜍)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A70E (꜎)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A70F (꜏)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x08, 0x08, 0x00, 0x00 },	// U+A710 (꜐)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x00, 0x00 },	// U+A711 (꜑)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A712 (꜒)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A713 (꜓)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A714 (꜔)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x08, 0x08, 0x00, 0x00 },	// U+A715 (꜕)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x00, 0x00 },	// U+A716 (꜖)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0a, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A717 (ꜗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A718 (ꜘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A719 (ꜙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A71A (ꜚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A71B (ꜛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A71C (ꜜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A71D (ꜝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A71E (ꜞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A71F (ꜟ)
	{ 0x00, 0x7e, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A720 (꜠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x7e, 0x00 },	// U+A721 (꜡)
	{ 0x00, 0x00, 0x0e, 0x1e, 0x20, 0x20, 0x1c, 0x00, 0x00, 0x0e, 0x1e, 0x20, 0x20, 0x1c, 0x00, 0x00 },	// U+A722 (Ꜣ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x1c, 0x20, 0x20, 0x18, 0x00, 0x0c, 0x1c, 0x20, 0x20, 0x18, 0x00, 0x00 },	// U+A723 (ꜣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x06, 0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A724 (Ꜥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x06, 0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00 },	// U+A725 (ꜥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x48, 0x30 },	// U+A726 (Ꜧ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x48, 0x30 },	// U+A727 (ꜧ)
}; // 40

static const unsigned char unifont_block325[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x12, 0x0a, 0x0c, 0x32, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+A72A (Ꜫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x04, 0x04, 0x18, 0x04, 0x04, 0x04, 0x44, 0x38, 0x00, 0x00 },	// U+A72B (ꜫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x28, 0x24, 0x22, 0x3e, 0x20, 0x20, 0x24, 0x18, 0x00, 0x00 },	// U+A72C (Ꜭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x28, 0x24, 0x3e, 0x20, 0x20, 0x20, 0x24, 0x18 },	// U+A72D (ꜭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x12, 0x11, 0x7f, 0x10, 0x10, 0xd2, 0x8c, 0x80, 0x40 },	// U+A72E (Ꜯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x12, 0x7f, 0x10, 0xd0, 0x90, 0x92, 0x4c },	// U+A72F (ꜯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A730 (ꜰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+A731 (ꜱ)
}; // 8

static const unsigned char unifont_block326[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x58, 0x58, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A73E (Ꜿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x58, 0x58, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+A73F (ꜿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x27, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+A740 (Ꝁ)
	{ 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00 },	// U+A741 (ꝁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x2a, 0x12, 0x2a, 0x42, 0x00, 0x00 },	// U+A742 (Ꝃ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x2a, 0x12, 0x2a, 0x42, 0x00, 0x00 },	// U+A743 (ꝃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x27, 0x12, 0x0a, 0x06, 0x06, 0x2a, 0x12, 0x2a, 0x42, 0x00, 0x00 },	// U+A744 (Ꝅ)
	{ 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x2a, 0x12, 0x2a, 0x42, 0x00, 0x00 },	// U+A745 (ꝅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x00, 0x00 },	// U+A746 (Ꝇ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+A747 (ꝇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+A748 (Ꝉ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+A749 (ꝉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0xff, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A74A (Ꝋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0xff, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A74B (ꝋ)
	{ 0x00, 0x00, 0x00, 0x40, 0xae, 0x91, 0x71, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+A74C (Ꝍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xae, 0x91, 0x71, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+A74D (ꝍ)
}; // 16

static const unsigned char unifont_block327[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x0f, 0x02, 0x00, 0x00 },	// U+A750 (Ꝑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x0f, 0x02 },	// U+A751 (ꝑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x88, 0x88, 0x88, 0x7e, 0x09, 0x09, 0x09, 0x0a, 0x08, 0x00, 0x00 },	// U+A752 (Ꝓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x98, 0x88, 0x88, 0x88, 0x88, 0x9e, 0x69, 0x09, 0x0a },	// U+A753 (ꝓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x72, 0x95, 0x94, 0x94, 0x78, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+A754 (Ꝕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xb5, 0x94, 0x94, 0x94, 0x94, 0xb8, 0x50, 0x10, 0x10 },	// U+A755 (ꝕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x26, 0xbc, 0x40, 0xa0 },	// U+A756 (Ꝗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0xe0, 0x40 },	// U+A757 (ꝗ)
}; // 8

static const unsigned char unifont_block328[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x20, 0x10, 0x10, 0x20, 0x20, 0x40, 0x00, 0x00 },	// U+A75A (Ꝛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x38, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+A75B (ꝛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x20, 0x20, 0x10, 0x08, 0x44, 0x42, 0x21, 0x7f, 0x20, 0x10 },	// U+A75C (Ꝝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x48, 0x44, 0x22, 0x7e, 0x20, 0x10 },	// U+A75D (ꝝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x4c, 0x4c, 0x44, 0x2a, 0x2a, 0x11, 0x11, 0x00, 0x00 },	// U+A75E (Ꝟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x4a, 0x2c, 0x26, 0x26, 0x19, 0x19, 0x00, 0x00 },	// U+A75F (ꝟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x40, 0x30 },	// U+A760 (Ꝡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xec, 0x80, 0x60 },	// U+A761 (ꝡ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x02, 0x7c, 0x20, 0x10, 0x08, 0x38, 0x40, 0x40, 0x42, 0x3c },	// U+A762 (Ꝣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x02, 0x3c, 0x10, 0x08, 0x04, 0x1c, 0x20, 0x22, 0x1c },	// U+A763 (ꝣ)
	{ 0x00, 0x00, 0x0a, 0x06, 0x03, 0x1e, 0x22, 0x42, 0x42, 0x22, 0x1e, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A764 (Ꝥ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x06, 0x02, 0x3b, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02 },	// U+A765 (ꝥ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x42, 0x42, 0x22, 0x1e, 0x02, 0x0f, 0x02, 0x00, 0x00 },	// U+A766 (Ꝧ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x0f, 0x02 },	// U+A767 (ꝧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x12, 0x12, 0x0a, 0x0a, 0x06, 0x02, 0x02, 0x00, 0x00 },	// U+A768 (Ꝩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x24, 0x24, 0x14, 0x0c, 0x04, 0x04, 0x00, 0x00 },	// U+A769 (ꝩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x18, 0x20, 0x20, 0x20, 0x20, 0x1c, 0x00, 0x00 },	// U+A76A (Ꝫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x18, 0x20, 0x20, 0x20, 0x20, 0x1c },	// U+A76B (ꝫ)
	{ 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x48, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x04, 0x00, 0x00 },	// U+A76C (Ꝭ)
	{ 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x48, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x04 },	// U+A76D (ꝭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x52, 0x4c, 0x40, 0x40, 0x20, 0x1c, 0x00, 0x00 },	// U+A76E (Ꝯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x52, 0x4c, 0x40, 0x40, 0x20, 0x1c },	// U+A76F (ꝯ)
	{ 0x00, 0x00, 0x18, 0x24, 0x42, 0x52, 0x4c, 0x40, 0x20, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A770 (ꝰ)
}; // 23

static const unsigned char unifont_block329[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x38, 0x44, 0x42, 0x40, 0x3f, 0x00, 0x00 },	// U+A778 (ꝸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A779 (Ꝺ)
	{ 0x00, 0x00, 0x02, 0x0c, 0x10, 0x20, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A77A (ꝺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02 },	// U+A77B (Ꝼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x04, 0x04, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x04 },	// U+A77C (ꝼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x08, 0x08, 0x10, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+A77D (Ᵹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x08, 0x10, 0x10, 0x08, 0x04, 0x7e, 0x00 },	// U+A77E (Ꝿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x3c, 0x08, 0x10, 0x10, 0x08, 0x04, 0x7e },	// U+A77F (ꝿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+A780 (Ꞁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30 },	// U+A781 (ꞁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x82, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+A782 (Ꞃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+A783 (ꞃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x74, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+A784 (Ꞅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+A785 (ꞅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x44, 0x38, 0x00, 0x00 },	// U+A786 (Ꞇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38, 0x00, 0x00 },	// U+A787 (ꞇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42 },	// U+A788 (ꞈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+A789 (꞉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+A78A (꞊)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A78B (Ꞌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A78C (ꞌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+A78D (Ɥ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x1c, 0x12, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x60, 0x00 },	// U+A78E (ꞎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A78F (ꞏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x22, 0x62, 0x40, 0x40 },	// U+A790 (Ꞑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x22, 0x62, 0x40, 0x40 },	// U+A791 (ꞑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x04, 0x0e, 0x04, 0x04, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+A792 (Ꞓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x04, 0x0e, 0x04, 0x04, 0x44, 0x38, 0x00, 0x00 },	// U+A793 (ꞓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x7c, 0x40, 0x30 },	// U+A794 (ꞔ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42, 0xc2, 0x80, 0x60 },	// U+A795 (ꞕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x48, 0x48, 0x48, 0x3c, 0x4a, 0x4a, 0x4a, 0x48, 0x38, 0x00, 0x00 },	// U+A796 (Ꞗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x38, 0x4c, 0x4a, 0x4a, 0x4a, 0x3a, 0x02, 0x0c },	// U+A797 (ꞗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06 },	// U+A798 (Ꞙ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+A799 (ꞙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x44, 0x48, 0x44, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+A79A (Ꞛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x4c, 0x44, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+A79B (ꞛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x42, 0x44, 0x48, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+A79C (Ꞝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x42, 0x4c, 0x44, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+A79D (ꞝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x44, 0x48, 0x44, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+A79E (Ꞟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x4c, 0x44, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+A79F (ꞟ)
	{ 0x00, 0x00, 0x00, 0x00, 0xbc, 0x42, 0x62, 0x12, 0x0a, 0x66, 0x42, 0x43, 0x62, 0x5c, 0x00, 0x00 },	// U+A7A0 (Ꞡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x5c, 0xe2, 0x3e, 0x23, 0x1c, 0x04, 0x3c, 0x42, 0x42, 0x3c },	// U+A7A1 (ꞡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x46, 0x26, 0x1a, 0x16, 0x23, 0x42, 0x00, 0x00 },	// U+A7A2 (Ꞣ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x6a, 0x1e, 0x23, 0x42, 0x00, 0x00 },	// U+A7A3 (ꞣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x46, 0xc6, 0x6a, 0x5a, 0x56, 0x53, 0x62, 0x62, 0x42, 0x00, 0x00 },	// U+A7A4 (Ꞥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xc6, 0x72, 0x4e, 0x43, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+A7A5 (ꞥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0xe2, 0x5a, 0x47, 0x3e, 0x12, 0x22, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+A7A6 (Ꞧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x0a, 0x06, 0x02, 0x03, 0x02, 0x00, 0x00 },	// U+A7A7 (ꞧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x32, 0x0c, 0x33, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A7A8 (Ꞩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x64, 0x18, 0x66, 0x80, 0x84, 0x78, 0x00, 0x00 },	// U+A7A9 (ꞩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x46, 0x45, 0x45, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+A7AA (Ɦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x38, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+A7AB (Ɜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4c, 0x20, 0x1e },	// U+A7AC (Ɡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0c, 0x0a, 0x2a, 0x1c, 0x08, 0x08, 0x78, 0x00, 0x00 },	// U+A7AD (Ɬ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x92, 0x92, 0x10, 0x10, 0x10, 0x10, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+A7AE (Ɪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x66, 0x3c, 0xc0, 0x00 },	// U+A7AF (ꞯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x00 },	// U+A7B0 (Ʞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x00, 0x00 },	// U+A7B1 (Ʇ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x2a, 0x32, 0x1c, 0x20, 0x00 },	// U+A7B2 (Ʝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00 },	// U+A7B3 (Ꭓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02 },	// U+A7B4 (Ꞵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x12, 0x1a, 0x22, 0x42, 0x42, 0x4a, 0x32, 0x02, 0x02 },	// U+A7B5 (ꞵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0xaa, 0x82, 0x82, 0x82, 0x82, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+A7B6 (Ꞷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xaa, 0x82, 0x82, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+A7B7 (ꞷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0xc2, 0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x3d, 0x00, 0x00 },	// U+A7B8 (Ꞹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x42, 0x62, 0x52, 0x4a, 0x46, 0x62, 0x5d, 0x00, 0x00 },	// U+A7B9 (ꞹ)
	{ 0x00, 0x00, 0x00, 0x06, 0x14, 0x2a, 0x28, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+A7BA (Ꞻ)
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x40, 0x7c, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+A7BB (ꞻ)
	{ 0x00, 0x00, 0x00, 0x06, 0x7c, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+A7BC (Ꞽ)
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+A7BD (ꞽ)
	{ 0x00, 0x00, 0x00, 0x03, 0x46, 0x45, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+A7BE (Ꞿ)
	{ 0x00, 0x00, 0x18, 0x10, 0x08, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+A7BF (ꞿ)
}; // 72

static const unsigned char unifont_block330[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x62, 0x5c, 0x40, 0x30 },	// U+A7C4 (Ꞔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x46, 0x3a, 0x02, 0x0c },	// U+A7C5 (Ʂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x42, 0x7e, 0x40, 0x30 },	// U+A7C6 (Ᶎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+A7C7 (Ꟈ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x7e, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+A7C8 (ꟈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x04, 0x08, 0x7e, 0x20, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+A7C9 (Ꟊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x0c, 0x7e, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+A7CA (ꟊ)
}; // 7

static const unsigned char unifont_block331[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x10, 0x7c, 0x00, 0x00 },	// U+A7F5 (Ꟶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x12, 0x1e, 0x12, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+A7F6 (ꟶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x7e, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A7F7 (ꟷ)
	{ 0x00, 0x00, 0x00, 0x42, 0xff, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A7F8 (ꟸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0xf2, 0x12, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A7F9 (ꟹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+A7FA (ꟺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+A7FB (ꟻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+A7FC (ꟼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00 },	// U+A7FD (ꟽ)
	{ 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+A7FE (ꟾ)
}; // 10

static const unsigned char unifont_block332[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+A828 (꠨)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+A829 (꠩)
}; // 2

static const unsigned char unifont_block333[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x32, 0x22, 0x7f, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+AB30 (ꬰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x49, 0x08, 0x0e, 0x79, 0x49, 0x49, 0x3e, 0x00, 0x00 },	// U+AB31 (ꬱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x22, 0x12, 0x4a, 0x24, 0x18, 0x00, 0x00 },	// U+AB32 (ꬲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x7f, 0x02, 0x7c, 0x00, 0x00 },	// U+AB33 (ꬳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x7e, 0x05, 0x05, 0x45, 0x38, 0x00, 0x00 },	// U+AB34 (ꬴ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+AB35 (ꬵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x7c, 0x40, 0x48, 0x54, 0x38, 0x10 },	// U+AB36 (ꬶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x28, 0x48, 0x3e, 0x09, 0x0a, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+AB37 (ꬷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x48, 0x3e, 0x09, 0x48, 0x3e, 0x09, 0x08, 0x3e, 0x00, 0x00 },	// U+AB38 (ꬸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x1c, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+AB39 (ꬹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x4a, 0x4a, 0x4a, 0x4a, 0xea, 0x5a, 0x2a, 0x00, 0x00 },	// U+AB3A (ꬺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0xe2, 0x52, 0x22, 0x00, 0x00 },	// U+AB3B (ꬻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x22, 0x22, 0x72, 0x28, 0x10 },	// U+AB3C (ꬼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x22, 0x22, 0x22, 0x14, 0x08, 0x00, 0x00 },	// U+AB3D (ꬽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x14, 0x32, 0x2a, 0x2a, 0x26, 0x14, 0x0a, 0x00, 0x00 },	// U+AB3E (ꬾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x3c, 0x62, 0x50, 0x50, 0x48, 0x48, 0x46, 0x3c, 0x02, 0x00 },	// U+AB3F (ꬿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x09, 0x09, 0x79, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+AB40 (ꭀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x3a, 0x65, 0x64, 0x54, 0x57, 0x4d, 0x4d, 0x3a, 0x00, 0x00 },	// U+AB41 (ꭁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x48, 0x48, 0x7f, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+AB42 (ꭂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+AB43 (ꭃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x39, 0x65, 0x65, 0x55, 0x55, 0x4d, 0x45, 0x3a, 0x00, 0x00 },	// U+AB44 (ꭄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+AB45 (ꭅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x0a, 0x0a, 0x12, 0x12, 0x90, 0x60 },	// U+AB46 (ꭆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+AB47 (ꭇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x56, 0x52, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+AB48 (ꭈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x44, 0x04, 0x04, 0x0e, 0x05, 0x05, 0x02, 0x00 },	// U+AB49 (ꭉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xac, 0xa4, 0x04, 0x04, 0x0e, 0x05, 0x05, 0x02, 0x00 },	// U+AB4A (ꭊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x5a, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+AB4B (ꭋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x2d, 0x21, 0x60, 0xa0, 0xa0, 0xa0, 0x40, 0x00, 0x00 },	// U+AB4C (ꭌ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06, 0x00, 0x00 },	// U+AB4D (ꭍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+AB4E (ꭎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x7f, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+AB4F (ꭏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x41, 0x41, 0x49, 0x49, 0x49, 0x49, 0x76, 0x00, 0x00 },	// U+AB50 (ꭐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x49, 0x49, 0x49, 0x49, 0x41, 0x41, 0x49, 0x00, 0x00 },	// U+AB51 (ꭑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x45, 0x45, 0x44, 0x44, 0x44, 0x64, 0x58, 0x00, 0x00 },	// U+AB52 (ꭒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42 },	// U+AB53 (ꭓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x12, 0x12, 0x0c, 0x0c, 0x32, 0x52, 0x51, 0x21 },	// U+AB54 (ꭔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x25, 0x43, 0x41 },	// U+AB55 (ꭕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x12, 0x0c, 0x0c, 0x52, 0xa1, 0xa1, 0x40, 0x00 },	// U+AB56 (ꭖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x84, 0x48, 0x30, 0x30, 0x48, 0x84, 0x82, 0x01, 0x00 },	// U+AB57 (ꭗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x58, 0xa4, 0xa2, 0x41, 0x00, 0x00 },	// U+AB58 (ꭘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x84, 0x48, 0x30, 0x30, 0x48, 0x84, 0x85, 0x03, 0x01 },	// U+AB59 (ꭙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x40, 0x3c },	// U+AB5A (ꭚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x1c, 0x00, 0x1c, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+AB5B (꭛)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+AB5C (ꭜ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x28, 0x48, 0x3e, 0x09, 0x0a, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+AB5D (ꭝ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x5c, 0x32, 0x10, 0x10, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+AB5E (ꭞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x45, 0x44, 0x64, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+AB5F (ꭟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x3a, 0x4a, 0x4a, 0x4a, 0x3a, 0x00, 0x00 },	// U+AB60 (ꭠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x4a, 0x7e, 0x0a, 0x0a, 0x4a, 0x32, 0x00, 0x00 },	// U+AB61 (ꭡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x48, 0x78, 0x08, 0x08, 0x49, 0x36, 0x00, 0x00 },	// U+AB62 (ꭢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00 },	// U+AB63 (ꭣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x62, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00 },	// U+AB64 (ꭤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x41, 0x41, 0x41, 0x22, 0x14, 0x14, 0x77, 0x00, 0x00 },	// U+AB65 (ꭥ)
}; // 54

static const unsigned char unifont_block334[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xa0, 0x78, 0x24, 0x20, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+AB68 (ꭨ)
	{ 0x00, 0x14, 0x2a, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+AB69 (ꭩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x3e, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+AB6A (꭪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+AB6B (꭫)
}; // 4

static const unsigned char unifont_block335[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x42, 0x42, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+AB70 (ꭰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x0a, 0x12, 0x22, 0xc2, 0x00, 0x00 },	// U+AB71 (ꭱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+AB72 (ꭲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x28, 0x48, 0x84, 0x8a, 0xaa, 0x64, 0x00, 0x00 },	// U+AB73 (ꭳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0xd2, 0x92, 0x72, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+AB74 (ꭴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+AB75 (ꭵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x04, 0xfe, 0x20, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+AB76 (ꭶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x40, 0x44, 0x4a, 0x4a, 0x46, 0x42, 0x3c, 0x00, 0x00 },	// U+AB77 (ꭷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x32, 0x2a, 0x6e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+AB78 (ꭸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0x3c, 0x00, 0x00 },	// U+AB79 (ꭹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+AB7A (ꭺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+AB7B (ꭻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+AB7C (ꭼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x12, 0x15, 0xdd, 0x92, 0x50, 0x30, 0x00, 0x00 },	// U+AB7D (ꭽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x40, 0x40, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+AB7E (ꭾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x55, 0x33, 0x00, 0x00 },	// U+AB7F (ꭿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x7c, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+AB80 (ꮀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+AB81 (ꮁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0xed, 0x2d, 0x12, 0x00, 0x00 },	// U+AB82 (ꮂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x00, 0x00 },	// U+AB83 (ꮃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x90, 0x10, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+AB84 (ꮄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x4a, 0x32, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+AB85 (ꮅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x0a, 0x3a, 0x4a, 0x22, 0x1c, 0x00, 0x00 },	// U+AB86 (ꮆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+AB87 (ꮇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x40, 0x40, 0x4e, 0x78, 0x40, 0x40, 0x00, 0x00 },	// U+AB88 (ꮈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x50, 0xa8, 0x04, 0x3c, 0x4a, 0x4a, 0x30, 0x00, 0x00 },	// U+AB89 (ꮉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x52, 0x52, 0x72, 0x52, 0x52, 0x52, 0x4c, 0x00, 0x00 },	// U+AB8A (ꮊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+AB8B (ꮋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x08, 0x1c, 0x22, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+AB8C (ꮌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0x42, 0x42, 0x64, 0x58, 0x40, 0x47, 0x22, 0x1c, 0x00 },	// U+AB8D (ꮍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+AB8E (ꮎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0f, 0x02, 0x02, 0x72, 0x22, 0x3c, 0x20, 0x18 },	// U+AB8F (ꮏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x01, 0x01, 0x79, 0x21, 0x21, 0x1e, 0x00, 0x00 },	// U+AB90 (ꮐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x48, 0x44, 0x45, 0x45, 0x42, 0x00, 0x00 },	// U+AB91 (ꮑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x00, 0x00 },	// U+AB92 (ꮒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x7e, 0x00, 0x00 },	// U+AB93 (ꮓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x27, 0x20, 0x27, 0x22, 0x3c, 0x20, 0x20, 0x00 },	// U+AB94 (ꮔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x52, 0xb2, 0x92, 0x12, 0x0c, 0x00, 0x00 },	// U+AB95 (ꮕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x00, 0x00 },	// U+AB96 (ꮖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x40, 0x42, 0x52, 0x52, 0x52, 0x2c, 0x00, 0x00 },	// U+AB97 (ꮗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x98, 0x94, 0x54, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+AB98 (ꮘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0x85, 0x44, 0x44, 0x24, 0x24, 0x14, 0x08, 0x00, 0x00 },	// U+AB99 (ꮙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x40, 0x59, 0x45, 0x45, 0x45, 0x3a, 0x00, 0x00 },	// U+AB9A (ꮚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3c, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+AB9B (ꮛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+AB9C (ꮜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x40, 0x58, 0x4b, 0x4d, 0x36, 0x00, 0x00 },	// U+AB9D (ꮝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x28, 0x24, 0x22, 0x7e, 0x20, 0x20, 0x00, 0x00 },	// U+AB9E (ꮞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x3e, 0x00, 0x00 },	// U+AB9F (ꮟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xd0, 0xba, 0x16, 0x10, 0x10, 0x00, 0x00 },	// U+ABA0 (ꮠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x59, 0x47, 0x02, 0x19, 0x21, 0x21, 0x1e, 0x00, 0x00 },	// U+ABA1 (ꮡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3a, 0x12, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+ABA2 (ꮢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+ABA3 (ꮣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x49, 0x4d, 0x53, 0x53, 0x61, 0x41, 0x00, 0x00 },	// U+ABA4 (ꮤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0xe2, 0x04, 0xf8, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+ABA5 (ꮥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x09, 0x08, 0x08, 0x48, 0x88, 0x88, 0x70, 0x00, 0x00 },	// U+ABA6 (ꮦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x30, 0x28, 0x24, 0x22, 0x00, 0x00 },	// U+ABA7 (ꮧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x30, 0x28, 0x24, 0x22, 0x00, 0x00 },	// U+ABA8 (ꮨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00 },	// U+ABA9 (ꮩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x3c, 0x00, 0x00 },	// U+ABAA (ꮪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x42, 0x06, 0x0a, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+ABAB (ꮫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x18, 0x24, 0x44, 0xaa, 0xaa, 0x44, 0x00, 0x00 },	// U+ABAC (ꮬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x42, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+ABAD (ꮭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+ABAE (ꮮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00 },	// U+ABAF (ꮯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x22, 0x25, 0x7e, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+ABB0 (ꮰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x99, 0x59, 0x14, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+ABB1 (ꮱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+ABB2 (ꮲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0xe2, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+ABB3 (ꮳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0x89, 0x48, 0x48, 0x28, 0x28, 0x18, 0x08, 0x00, 0x00 },	// U+ABB4 (ꮴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0xc2, 0xb2, 0x2e, 0x22, 0x22, 0x22, 0x00, 0x00 },	// U+ABB5 (ꮵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x00, 0x00 },	// U+ABB6 (ꮶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+ABB7 (ꮷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x52, 0xa2, 0x02, 0x02, 0xa2, 0x52, 0x0c, 0x00, 0x00 },	// U+ABB8 (ꮸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x02, 0x02, 0x72, 0x22, 0xdc, 0x00, 0x00 },	// U+ABB9 (ꮹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xaa, 0xca, 0x8a, 0x8c, 0x98, 0xa9, 0x46, 0x00, 0x00 },	// U+ABBA (ꮺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x4e, 0x4a, 0x7a, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+ABBB (ꮻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x92, 0x92, 0x8e, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00 },	// U+ABBC (ꮼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x50, 0x60, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+ABBD (ꮽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+ABBE (ꮾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x80, 0x80, 0xba, 0x92, 0x92, 0x6c, 0x00, 0x00 },	// U+ABBF (ꮿ)
}; // 80

static const unsigned char unifont_block336[][16] = {
	{ 0x00, 0x00, 0x00, 0xd8, 0x24, 0x24, 0x24, 0x7e, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+FB00 (ﬀ)
	{ 0x00, 0x00, 0x00, 0x58, 0x44, 0x04, 0x04, 0x7e, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+FB01 (ﬁ)
	{ 0x00, 0x00, 0x00, 0x78, 0x44, 0x44, 0x44, 0x5e, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+FB02 (ﬂ)
	{ 0x00, 0x00, 0x00, 0x68, 0x54, 0x14, 0x14, 0x7e, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x00, 0x00 },	// U+FB03 (ﬃ)
	{ 0x00, 0x00, 0x00, 0x78, 0x54, 0x54, 0x54, 0x7e, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x00, 0x00 },	// U+FB04 (ﬄ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x7a, 0x12, 0x12, 0x12, 0x12, 0x12, 0x62, 0x00, 0x00 },	// U+FB05 (ﬅ)
	{ 0x00, 0x00, 0x00, 0x38, 0x24, 0x24, 0x24, 0x6c, 0x22, 0x22, 0x24, 0x28, 0x28, 0x46, 0x00, 0x00 },	// U+FB06 (ﬆ)
}; // 7

static const unsigned char unifont_block337[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x0c, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xcc, 0x00, 0x00 },	// U+FB13 (ﬓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x28, 0x28, 0xea, 0x2a, 0x2a, 0xaa, 0xaa, 0xaa, 0x6c, 0x00, 0x00 },	// U+FB14 (ﬔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x28, 0x28, 0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xac, 0x20, 0x20 },	// U+FB15 (ﬕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x3c, 0x28, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xcc, 0x08, 0x38 },	// U+FB16 (ﬖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x14, 0x14, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0x56, 0x10, 0x10 },	// U+FB17 (ﬗ)
}; // 5

static const unsigned char unifont_block338[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB1D (יִ)
	{ 0x00, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB1E (ﬞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x88, 0x88, 0x88, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB1F (ײַ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x7f, 0x00, 0x00 },	// U+FB20 (ﬠ)
}; // 4

static const unsigned char unifont_block339[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+FB29 (﬩)
	{ 0x00, 0x00, 0x00, 0x80, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+FB2A (שׁ)
	{ 0x00, 0x00, 0x00, 0x02, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+FB2B (שׂ)
	{ 0x00, 0x00, 0x00, 0x80, 0x00, 0x92, 0x92, 0x92, 0x92, 0xb2, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+FB2C (שּׁ)
	{ 0x00, 0x00, 0x00, 0x02, 0x00, 0x92, 0x92, 0x92, 0x92, 0xb2, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+FB2D (שּׂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x42, 0x44, 0x48, 0x34, 0x12, 0x22, 0x42, 0x82, 0x38, 0x00 },	// U+FB2E (אַ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x42, 0x44, 0x48, 0x34, 0x12, 0x22, 0x42, 0x82, 0x38, 0x10 },	// U+FB2F (אָ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x44, 0x48, 0x34, 0x12, 0x22, 0x42, 0x82, 0x10, 0x00 },	// U+FB30 (אּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0xfe, 0x00, 0x00 },	// U+FB31 (בּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x22, 0x30, 0x28, 0x44, 0x42, 0x00, 0x00 },	// U+FB32 (גּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+FB33 (דּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x44, 0x54, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+FB34 (הּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+FB35 (וּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x50, 0x10, 0x14, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+FB36 (זּ)
}; // 14

static const unsigned char unifont_block340[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x52, 0x42, 0x42, 0x4a, 0x42, 0x42, 0x42, 0x7e, 0x00, 0x00 },	// U+FB38 (טּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB39 (יּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x48, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40 },	// U+FB3A (ךּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x48, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x00 },	// U+FB3B (כּ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x7c, 0x40, 0x40, 0x40, 0x48, 0x20, 0x20, 0x10, 0x0c, 0x00, 0x00 },	// U+FB3C (לּ)
}; // 5

static const unsigned char unifont_block341[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x8c, 0x84, 0x82, 0x92, 0x82, 0x82, 0x82, 0xe2, 0x00, 0x00 },	// U+FB3E (מּ)
}; // 1

static const unsigned char unifont_block342[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x3c, 0x00, 0x00 },	// U+FB40 (נּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x4a, 0x42, 0x42, 0x22, 0x1e, 0x00, 0x00 },	// U+FB41 (סּ)
}; // 2

static const unsigned char unifont_block343[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x4e, 0x40, 0x40, 0x48, 0x40, 0x40, 0x40 },	// U+FB43 (ףּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x4e, 0x40, 0x48, 0x40, 0x7e, 0x00, 0x00 },	// U+FB44 (פּ)
}; // 2

static const unsigned char unifont_block344[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x10, 0x22, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+FB46 (צּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x44, 0x54, 0x44, 0x24, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+FB47 (קּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x48, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+FB48 (רּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0xb2, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00 },	// U+FB49 (שּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x44, 0x44, 0x54, 0x44, 0x44, 0x44, 0x46, 0x00, 0x00 },	// U+FB4A (תּ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+FB4B (וֹ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xfe, 0x00, 0x00 },	// U+FB4C (בֿ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x00 },	// U+FB4D (כֿ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x4e, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+FB4E (פֿ)
	{ 0x00, 0x00, 0x06, 0x04, 0x04, 0x62, 0x42, 0x44, 0x48, 0x34, 0x12, 0x22, 0x42, 0x42, 0x00, 0x00 },	// U+FB4F (ﭏ)
	{ 0x20, 0x50, 0x78, 0x04, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB50 (ﭐ)
	{ 0x08, 0x14, 0x1e, 0x01, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB51 (ﭑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x10, 0x00, 0x10, 0x00 },	// U+FB52 (ﭒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0xfc, 0x00, 0x10, 0x00, 0x10, 0x00 },	// U+FB53 (ﭓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0x1f, 0x00, 0x10, 0x00, 0x10, 0x00 },	// U+FB54 (ﭔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0xff, 0x00, 0x10, 0x00, 0x10, 0x00 },	// U+FB55 (ﭕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x28, 0x00, 0x10, 0x00 },	// U+FB56 (ﭖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0xfc, 0x00, 0x28, 0x00, 0x10, 0x00 },	// U+FB57 (ﭗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0x1f, 0x00, 0x28, 0x00, 0x10, 0x00 },	// U+FB58 (ﭘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0xff, 0x00, 0x28, 0x00, 0x10, 0x00 },	// U+FB59 (ﭙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x28, 0x00, 0x28, 0x00 },	// U+FB5A (ﭚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0xfc, 0x00, 0x28, 0x00, 0x28, 0x00 },	// U+FB5B (ﭛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0x1f, 0x00, 0x28, 0x00, 0x28, 0x00 },	// U+FB5C (ﭜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0xff, 0x00, 0x28, 0x00, 0x28, 0x00 },	// U+FB5D (ﭝ)
	{ 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB5E (ﭞ)
	{ 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x20, 0x44, 0x42, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB5F (ﭟ)
	{ 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x10, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB60 (ﭠ)
	{ 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x10, 0x20, 0x20, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB61 (ﭡ)
	{ 0x00, 0x00, 0x28, 0x00, 0x28, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB62 (ﭢ)
	{ 0x00, 0x00, 0x28, 0x00, 0x28, 0x00, 0x00, 0x20, 0x44, 0x42, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB63 (ﭣ)
	{ 0x00, 0x00, 0x28, 0x00, 0x28, 0x00, 0x00, 0x10, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB64 (ﭤ)
	{ 0x00, 0x00, 0x28, 0x00, 0x28, 0x00, 0x00, 0x10, 0x20, 0x20, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB65 (ﭥ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1c, 0x1c, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB66 (ﭦ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1c, 0x1c, 0x00, 0x20, 0x44, 0x42, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB67 (ﭧ)
	{ 0x00, 0x00, 0x08, 0x08, 0x38, 0x38, 0x00, 0x10, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB68 (ﭨ)
	{ 0x00, 0x00, 0x08, 0x08, 0x38, 0x38, 0x00, 0x10, 0x20, 0x20, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB69 (ﭩ)
	{ 0x00, 0x10, 0x00, 0x48, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB6A (ﭪ)
	{ 0x00, 0x10, 0x00, 0x48, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB6B (ﭫ)
	{ 0x00, 0x08, 0x00, 0x24, 0x00, 0x00, 0x1c, 0x24, 0x28, 0x30, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB6C (ﭬ)
	{ 0x00, 0x08, 0x00, 0x24, 0x00, 0x00, 0x1c, 0x24, 0x28, 0x30, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB6D (ﭭ)
	{ 0x00, 0x50, 0x00, 0x50, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB6E (ﭮ)
	{ 0x00, 0x50, 0x00, 0x50, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB6F (ﭯ)
	{ 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x1c, 0x24, 0x28, 0x30, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB70 (ﭰ)
	{ 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x1c, 0x24, 0x28, 0x30, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB71 (ﭱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x12, 0x02, 0x12, 0x44, 0x38 },	// U+FB72 (ﭲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x28, 0xc4, 0x12, 0x02, 0x12, 0x84, 0x78 },	// U+FB73 (ﭳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0x3f, 0x00, 0x04, 0x00, 0x04, 0x00 },	// U+FB74 (ﭴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0xff, 0x00, 0x04, 0x00, 0x04, 0x00 },	// U+FB75 (ﭵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x2a, 0x02, 0x44, 0x38 },	// U+FB76 (ﭶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x28, 0xc4, 0x02, 0x2a, 0x02, 0x84, 0x78 },	// U+FB77 (ﭷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0x3f, 0x00, 0x0a, 0x00, 0x00, 0x00 },	// U+FB78 (ﭸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0xff, 0x00, 0x0a, 0x00, 0x00, 0x00 },	// U+FB79 (ﭹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x02, 0x2a, 0x02, 0x12, 0x44, 0x38 },	// U+FB7A (ﭺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x44, 0x82, 0x2a, 0x02, 0x12, 0x84, 0x78 },	// U+FB7B (ﭻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0x3f, 0x00, 0x14, 0x00, 0x08, 0x00 },	// U+FB7C (ﭼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0xff, 0x00, 0x14, 0x00, 0x08, 0x00 },	// U+FB7D (ﭽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x02, 0x2a, 0x02, 0x2a, 0x44, 0x38 },	// U+FB7E (ﭾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24, 0xc2, 0x2a, 0x02, 0x2a, 0x84, 0x78 },	// U+FB7F (ﭿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0x3f, 0x00, 0x0a, 0x00, 0x0a, 0x00 },	// U+FB80 (ﮀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0xff, 0x00, 0x0a, 0x00, 0x0a, 0x00 },	// U+FB81 (ﮁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x14, 0x00, 0x00, 0x00 },	// U+FB82 (ﮂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0xfe, 0x00, 0x14, 0x00, 0x00, 0x00 },	// U+FB83 (ﮃ)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB84 (ﮄ)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB85 (ﮅ)
	{ 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB86 (ﮆ)
	{ 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x10, 0x20, 0x40, 0x42, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB87 (ﮇ)
	{ 0x00, 0x04, 0x04, 0x1c, 0x1c, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB88 (ﮈ)
	{ 0x00, 0x04, 0x04, 0x1c, 0x1c, 0x00, 0x10, 0x20, 0x40, 0x42, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB89 (ﮉ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FB8A (ﮊ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x00, 0x20, 0x40, 0xc0, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FB8B (ﮋ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x70, 0x70, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FB8C (ﮌ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x70, 0x70, 0x00, 0x20, 0x40, 0xc0, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FB8D (ﮍ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB8E (ﮎ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x41, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB8F (ﮏ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x40, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB90 (ﮐ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x40, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB91 (ﮑ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB92 (ﮒ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x41, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB93 (ﮓ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x40, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB94 (ﮔ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x40, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB95 (ﮕ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x08, 0x00, 0x08, 0x00 },	// U+FB96 (ﮖ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x41, 0xfe, 0x00, 0x08, 0x00, 0x08, 0x00 },	// U+FB97 (ﮗ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x40, 0x7f, 0x00, 0x08, 0x00, 0x08, 0x00 },	// U+FB98 (ﮘ)
	{ 0x00, 0x10, 0x08, 0x24, 0x12, 0x08, 0x04, 0x02, 0x3c, 0x40, 0xff, 0x00, 0x08, 0x00, 0x08, 0x00 },	// U+FB99 (ﮙ)
	{ 0x00, 0x0a, 0x60, 0x18, 0x46, 0x30, 0x0c, 0x02, 0x3c, 0x41, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB9A (ﮚ)
	{ 0x00, 0x0a, 0x60, 0x18, 0x46, 0x30, 0x0c, 0x02, 0x3c, 0x41, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB9B (ﮛ)
	{ 0x00, 0x0a, 0x60, 0x18, 0x46, 0x30, 0x0c, 0x02, 0x3c, 0x40, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB9C (ﮜ)
	{ 0x00, 0x0a, 0x60, 0x18, 0x46, 0x30, 0x0c, 0x02, 0x3c, 0x40, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FB9D (ﮝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+FB9E (ﮞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0xc2, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+FB9F (ﮟ)
	{ 0x00, 0x00, 0x08, 0x08, 0x38, 0x38, 0x00, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+FBA0 (ﮠ)
	{ 0x00, 0x00, 0x08, 0x08, 0x38, 0x38, 0x00, 0x00, 0x20, 0x44, 0xc2, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+FBA1 (ﮡ)
	{ 0x00, 0x00, 0x08, 0x08, 0x38, 0x38, 0x00, 0x10, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBA2 (ﮢ)
	{ 0x00, 0x00, 0x08, 0x08, 0x38, 0x38, 0x00, 0x10, 0x20, 0x20, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBA3 (ﮣ)
	{ 0x00, 0x18, 0x04, 0x18, 0x04, 0x00, 0x08, 0x18, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBA4 (ﮤ)
	{ 0x18, 0x04, 0x18, 0x04, 0x20, 0x20, 0x30, 0x28, 0x24, 0x3c, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBA5 (ﮥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBA6 (ﮦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf4, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+FBA7 (ﮧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0f, 0x08, 0x08, 0x28, 0x10, 0x00 },	// U+FBA8 (ﮨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xcf, 0x28, 0x28, 0x28, 0x10, 0x10 },	// U+FBA9 (ﮩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x34, 0x54, 0x58, 0x24, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+FBAA (ﮪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x34, 0x54, 0x58, 0xe4, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+FBAB (ﮫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x34, 0x54, 0x58, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBAC (ﮬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x34, 0x54, 0x58, 0xe7, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBAD (ﮭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x08, 0x04, 0x02, 0xfe, 0x00 },	// U+FBAE (ﮮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x08, 0x04, 0x02, 0xfe, 0x00 },	// U+FBAF (ﮯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x0c, 0x02, 0x10, 0x28, 0x08, 0x04, 0x02, 0xfe, 0x00 },	// U+FBB0 (ﮰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x0c, 0x02, 0x00, 0xf0, 0x08, 0x04, 0x02, 0xfe, 0x00 },	// U+FBB1 (ﮱ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBB2 (﮲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+FBB3 (﮳)
	{ 0x00, 0x00, 0x30, 0x36, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBB4 (﮴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x36, 0x06 },	// U+FBB5 (﮵)
	{ 0x00, 0x0c, 0x0c, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBB6 (﮶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x36, 0x36 },	// U+FBB7 (﮷)
	{ 0x00, 0x36, 0x36, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBB8 (﮸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x18, 0x18 },	// U+FBB9 (﮹)
	{ 0x00, 0x30, 0x36, 0x06, 0xc0, 0xd8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBBA (﮺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x36, 0x06, 0xc0, 0xd8, 0x18 },	// U+FBBB (﮻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x48, 0x48 },	// U+FBBC (﮼)
	{ 0x00, 0x0c, 0x0c, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBBD (﮽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x30, 0x30, 0x00 },	// U+FBBE (﮾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x24, 0x14, 0x08 },	// U+FBBF (﮿)
	{ 0x00, 0x08, 0x08, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBC0 (﯀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x38, 0x38 },	// U+FBC1 (﯁)
}; // 124

static const unsigned char unifont_block345[][16] = {
	{ 0x08, 0x00, 0x14, 0x40, 0x50, 0x48, 0x50, 0x44, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBD3 (ﯓ)
	{ 0x08, 0x00, 0x14, 0x40, 0x50, 0x48, 0x50, 0x44, 0x42, 0x42, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBD4 (ﯔ)
	{ 0x04, 0x00, 0x0a, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x40, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBD5 (ﯕ)
	{ 0x04, 0x00, 0x0a, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x40, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBD6 (ﯖ)
	{ 0x00, 0x00, 0x18, 0x18, 0x10, 0x08, 0x04, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBD7 (ﯗ)
	{ 0x00, 0x00, 0x18, 0x18, 0x10, 0x08, 0x04, 0x30, 0x48, 0x48, 0xf8, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBD8 (ﯘ)
	{ 0x00, 0x00, 0x44, 0x28, 0x10, 0x10, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBD9 (ﯙ)
	{ 0x00, 0x00, 0x44, 0x28, 0x10, 0x10, 0x00, 0x30, 0x48, 0x48, 0xf8, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBDA (ﯚ)
	{ 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBDB (ﯛ)
	{ 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0x00, 0x30, 0x48, 0x48, 0xf8, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBDC (ﯜ)
	{ 0x00, 0x00, 0xcc, 0x2c, 0xc8, 0x24, 0x02, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBDD (ﯝ)
	{ 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBDE (ﯞ)
	{ 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x00, 0x30, 0x48, 0x48, 0xf8, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBDF (ﯟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x38, 0x12, 0x0c, 0x00 },	// U+FBE0 (ﯠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0xf8, 0x40, 0x38, 0x12, 0x0c, 0x00 },	// U+FBE1 (ﯡ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBE2 (ﯢ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x30, 0x48, 0x48, 0xf8, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FBE3 (ﯣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x4a, 0x12, 0x22, 0x1c, 0x00, 0x08, 0x00, 0x08 },	// U+FBE4 (ﯤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x92, 0x0c, 0x00, 0x08, 0x00, 0x08 },	// U+FBE5 (ﯥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x1f, 0x00, 0x10, 0x00, 0x10, 0x00 },	// U+FBE6 (ﯦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0xdf, 0x00, 0x10, 0x00, 0x10, 0x00 },	// U+FBE7 (ﯧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBE8 (ﯨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBE9 (ﯩ)
	{ 0x00, 0x00, 0x00, 0x32, 0x0a, 0x32, 0x0a, 0x02, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBEA (ﯪ)
	{ 0x00, 0x00, 0x00, 0x32, 0x0a, 0x32, 0x0a, 0x02, 0x22, 0x22, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBEB (ﯫ)
	{ 0x00, 0x00, 0x00, 0x60, 0x10, 0x60, 0x10, 0x00, 0x40, 0x48, 0x34, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+FBEC (ﯬ)
	{ 0x00, 0x00, 0x00, 0x60, 0x10, 0x60, 0x10, 0x00, 0x40, 0x48, 0xb4, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+FBED (ﯭ)
	{ 0x00, 0x00, 0x00, 0xc0, 0x20, 0xc0, 0x20, 0x08, 0x54, 0x54, 0x3c, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FBEE (ﯮ)
	{ 0x00, 0x00, 0x00, 0xc0, 0x20, 0xc0, 0x20, 0x08, 0x54, 0x54, 0xbc, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FBEF (ﯯ)
	{ 0x00, 0x00, 0x0c, 0xcc, 0x28, 0xc4, 0x22, 0x08, 0x54, 0x54, 0x3c, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FBF0 (ﯰ)
	{ 0x00, 0x00, 0x0c, 0xcc, 0x28, 0xc4, 0x22, 0x08, 0x54, 0x54, 0xbc, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FBF1 (ﯱ)
	{ 0x00, 0x00, 0x11, 0xca, 0x24, 0xc4, 0x20, 0x08, 0x54, 0x54, 0x3c, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FBF2 (ﯲ)
	{ 0x00, 0x00, 0x11, 0xca, 0x24, 0xc4, 0x20, 0x08, 0x54, 0x54, 0xbc, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FBF3 (ﯳ)
	{ 0x00, 0x00, 0x00, 0xc4, 0x28, 0xc8, 0x20, 0x08, 0x54, 0x54, 0x3c, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FBF4 (ﯴ)
	{ 0x00, 0x00, 0x00, 0xc4, 0x28, 0xc8, 0x20, 0x08, 0x54, 0x54, 0xbc, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FBF5 (ﯵ)
	{ 0x00, 0x30, 0x08, 0x30, 0x08, 0x20, 0x20, 0x30, 0x0a, 0x12, 0x22, 0x1c, 0x00, 0x08, 0x00, 0x08 },	// U+FBF6 (ﯶ)
	{ 0x00, 0x00, 0x30, 0x08, 0x30, 0x08, 0x00, 0x20, 0x32, 0x4a, 0x92, 0x0c, 0x00, 0x08, 0x00, 0x08 },	// U+FBF7 (ﯷ)
	{ 0x00, 0x00, 0x60, 0x10, 0x60, 0x10, 0x00, 0x44, 0x44, 0x48, 0x37, 0x00, 0x04, 0x00, 0x04, 0x00 },	// U+FBF8 (ﯸ)
	{ 0x00, 0x00, 0x60, 0x10, 0x60, 0x10, 0x40, 0x40, 0x40, 0x60, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+FBF9 (ﯹ)
	{ 0x00, 0x00, 0x60, 0x10, 0x60, 0x10, 0x00, 0x40, 0x40, 0xa0, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+FBFA (ﯺ)
	{ 0x00, 0x00, 0x60, 0x10, 0x60, 0x10, 0x00, 0x44, 0x44, 0x48, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FBFB (ﯻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x52, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+FBFC (ﯼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+FBFD (ﯽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x1f, 0x00, 0x14, 0x00, 0x00, 0x00 },	// U+FBFE (ﯾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0xdf, 0x00, 0x14, 0x00, 0x00, 0x00 },	// U+FBFF (ﯿ)
	{ 0x00, 0x00, 0x00, 0x06, 0x01, 0x06, 0x31, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC00 (ﰀ)
	{ 0x00, 0x00, 0x00, 0x06, 0x01, 0x06, 0x31, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC01 (ﰁ)
	{ 0x00, 0x00, 0x00, 0x18, 0x04, 0x18, 0xc4, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC02 (ﰂ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x02, 0x0c, 0x22, 0x40, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x00 },	// U+FC03 (ﰃ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x02, 0x0c, 0x22, 0x40, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x28 },	// U+FC04 (ﰄ)
	{ 0x00, 0x00, 0x00, 0x06, 0x01, 0x06, 0x31, 0x0c, 0x02, 0x7e, 0x04, 0x42, 0x12, 0x02, 0x44, 0x38 },	// U+FC05 (ﰅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x42, 0x02, 0x02, 0x44, 0x38 },	// U+FC06 (ﰆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x42, 0x02, 0x02, 0x44, 0x38 },	// U+FC07 (ﰇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10, 0x3c, 0x82, 0x02, 0x02, 0x02, 0x02 },	// U+FC08 (ﰈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x80, 0x00 },	// U+FC09 (ﰉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x80, 0x28 },	// U+FC0A (ﰊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x42, 0x02, 0x02, 0x44, 0x38 },	// U+FC0B (ﰋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC0C (ﰌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x31, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC0D (ﰍ)
	{ 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC0E (ﰎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x20, 0x40, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x00 },	// U+FC0F (ﰏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x20, 0x40, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x28 },	// U+FC10 (ﰐ)
	{ 0x00, 0x00, 0x00, 0x02, 0x00, 0x05, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC11 (ﰑ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x14, 0xc0, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC12 (ﰒ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0a, 0x20, 0x40, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x00 },	// U+FC13 (ﰓ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0a, 0x20, 0x40, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x28 },	// U+FC14 (ﰔ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x30, 0x40, 0x30, 0x0c, 0x02, 0x1e, 0x44, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC15 (ﰕ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x30, 0x40, 0xc0, 0x20, 0x10, 0x10, 0x3c, 0x82, 0x02, 0x02, 0x02, 0x02 },	// U+FC16 (ﰖ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x30, 0x40, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x42, 0x02, 0x02, 0x44, 0x38 },	// U+FC17 (ﰗ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x30, 0x40, 0xc0, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC18 (ﰘ)
	{ 0x00, 0x00, 0x20, 0x0e, 0x30, 0x40, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC19 (ﰙ)
	{ 0x00, 0x00, 0x20, 0x0e, 0x30, 0x40, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC1A (ﰚ)
	{ 0x00, 0x00, 0x00, 0x8c, 0x30, 0x40, 0xc0, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC1B (ﰛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0x5a, 0x02, 0x7e, 0x04, 0x42, 0x02, 0x02, 0x44, 0x38 },	// U+FC1C (ﰜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0x5a, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC1D (ﰝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xa4, 0x5a, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC1E (ﰞ)
}; // 76

static const unsigned char unifont_block346[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x90, 0x78, 0x14, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC20 (ﰠ)
}; // 1

static const unsigned char unifont_block347[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x64, 0x90, 0x78, 0x14, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC22 (ﰢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x64, 0x90, 0x78, 0x14, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC23 (ﰣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x64, 0x91, 0x78, 0x14, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC24 (ﰤ)
}; // 3

static const unsigned char unifont_block348[][16] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x34, 0x4c, 0x3c, 0x04, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC26 (ﰦ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x70, 0x90, 0x68, 0x08, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC27 (ﰧ)
	{ 0x00, 0x00, 0x00, 0x10, 0x50, 0x10, 0x70, 0x90, 0x68, 0x08, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC28 (ﰨ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x02, 0x1c, 0x08, 0x04, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC29 (ﰩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0xf0, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC2A (ﰪ)
	{ 0x00, 0x00, 0x01, 0x0c, 0x02, 0x1c, 0x08, 0x04, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC2B (ﰫ)
	{ 0x00, 0x00, 0x10, 0x00, 0x30, 0x08, 0xf0, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC2C (ﰬ)
	{ 0x00, 0x00, 0x01, 0x04, 0x0a, 0x0c, 0x08, 0x04, 0x7e, 0x08, 0x04, 0x02, 0x12, 0x02, 0x84, 0x78 },	// U+FC2D (ﰭ)
	{ 0x00, 0x00, 0x01, 0x04, 0x0a, 0x0c, 0x08, 0x04, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x84, 0x78 },	// U+FC2E (ﰮ)
	{ 0x00, 0x00, 0x01, 0x04, 0x0a, 0x0c, 0x09, 0x04, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x84, 0x78 },	// U+FC2F (ﰯ)
	{ 0x00, 0x00, 0x00, 0x02, 0x08, 0x14, 0x18, 0x10, 0x08, 0x04, 0x08, 0x1c, 0x02, 0x02, 0x02, 0x02 },	// U+FC30 (ﰰ)
	{ 0x00, 0x00, 0x20, 0x00, 0x00, 0x30, 0x50, 0x60, 0x40, 0x62, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FC31 (ﰱ)
	{ 0x00, 0x00, 0x20, 0x00, 0x00, 0x30, 0x50, 0x60, 0x40, 0x62, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FC32 (ﰲ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x04, 0x0a, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC33 (ﰳ)
	{ 0x00, 0x00, 0x14, 0x00, 0x08, 0x14, 0x18, 0x10, 0x08, 0x04, 0x08, 0x1c, 0x02, 0x02, 0x02, 0x02 },	// U+FC34 (ﰴ)
	{ 0x00, 0x00, 0x28, 0x00, 0x00, 0x30, 0x50, 0x60, 0x40, 0x62, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FC35 (ﰵ)
	{ 0x00, 0x00, 0x28, 0x00, 0x00, 0x30, 0x50, 0x60, 0x40, 0x62, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FC36 (ﰶ)
	{ 0x00, 0x00, 0x00, 0x20, 0x11, 0x09, 0x05, 0x03, 0x3d, 0x41, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC37 (ﰷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x08, 0x04, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC38 (ﰸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x08, 0x04, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC39 (ﰹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x09, 0x04, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC3A (ﰺ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x48, 0x28, 0x18, 0x28, 0x48, 0x38, 0x09, 0x09, 0x09, 0x09, 0x06 },	// U+FC3B (ﰻ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x08, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC3C (ﰼ)
}; // 23

static const unsigned char unifont_block349[][16] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x7e, 0x08, 0x04, 0x02, 0x12, 0x02, 0x84, 0x78 },	// U+FC3F (ﰿ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x84, 0x78 },	// U+FC40 (ﱀ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x0a, 0x08, 0x04, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x84, 0x78 },	// U+FC41 (ﱁ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC42 (ﱂ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+FC43 (ﱃ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FC44 (ﱄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC45 (ﱅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC46 (ﱆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC47 (ﱇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC48 (ﱈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x10, 0x22, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+FC49 (ﱉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x10, 0x22, 0x42, 0x42, 0x3c, 0x00, 0x14 },	// U+FC4A (ﱊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC4B (ﱋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC4C (ﱌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FC4D (ﱍ)
	{ 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC4E (ﱎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x20, 0x40, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x00 },	// U+FC4F (ﱏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x20, 0x40, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x28 },	// U+FC50 (ﱐ)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x4a, 0x3c, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FC51 (ﱑ)
	{ 0x00, 0x00, 0x00, 0x04, 0x18, 0x2c, 0x2a, 0x1c, 0x10, 0x08, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC52 (ﱒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0xb0, 0xa8, 0x70, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x00 },	// U+FC53 (ﱓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0xb0, 0xa8, 0x70, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x28 },	// U+FC54 (ﱔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x52, 0x02, 0x12, 0x44, 0x38 },	// U+FC55 (ﱕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x52, 0x02, 0x02, 0x44, 0x38 },	// U+FC56 (ﱖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x30, 0x0c, 0x02, 0x7e, 0x04, 0x52, 0x02, 0x02, 0x44, 0x38 },	// U+FC57 (ﱗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10, 0x3c, 0x82, 0x22, 0x02, 0x02, 0x02 },	// U+FC58 (ﱘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x80, 0x20, 0x00 },	// U+FC59 (ﱙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x44, 0x22, 0x62, 0x44, 0x38, 0x80, 0x20, 0x0a },	// U+FC5A (ﱚ)
	{ 0x08, 0x08, 0x08, 0x00, 0x04, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC5B (ﱛ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FC5C (ﱜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x00, 0x20, 0x50, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FC5D (ﱝ)
	{ 0x00, 0x20, 0x56, 0x24, 0x18, 0x00, 0x2a, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC5E (ﱞ)
	{ 0x00, 0x2a, 0x2a, 0x3e, 0x60, 0x18, 0x66, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC5F (ﱟ)
	{ 0x00, 0x00, 0x60, 0x18, 0x06, 0x00, 0x2a, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC60 (ﱠ)
	{ 0x00, 0x20, 0x50, 0x20, 0x5e, 0x00, 0x2a, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC61 (ﱡ)
	{ 0x00, 0x2a, 0x2a, 0x3e, 0x00, 0x60, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC62 (ﱢ)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x00, 0x2a, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC63 (ﱣ)
	{ 0x00, 0x00, 0x18, 0x04, 0x18, 0x44, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FC64 (ﱤ)
	{ 0x00, 0x00, 0x18, 0x04, 0x19, 0x44, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FC65 (ﱥ)
	{ 0x00, 0x00, 0x00, 0x18, 0x04, 0x18, 0xc4, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC66 (ﱦ)
	{ 0x00, 0x00, 0x00, 0x18, 0x04, 0x19, 0x40, 0x60, 0x50, 0x54, 0xa2, 0x22, 0x12, 0x0c, 0x00, 0x00 },	// U+FC67 (ﱧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0x30, 0x08, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FC68 (ﱨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0x30, 0x08, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FC69 (ﱩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x48, 0x06, 0x00 },	// U+FC6A (ﱪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x48, 0x06, 0x00 },	// U+FC6B (ﱫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10, 0xbc, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC6C (ﱬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x60, 0x50, 0x54, 0xa2, 0x22, 0x12, 0x4c, 0x00, 0x00 },	// U+FC6D (ﱭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x80, 0x00 },	// U+FC6E (ﱮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x80, 0x14 },	// U+FC6F (ﱯ)
	{ 0x00, 0x00, 0xa0, 0x00, 0x00, 0x40, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FC70 (ﱰ)
	{ 0x00, 0x00, 0xa0, 0x00, 0x04, 0x40, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FC71 (ﱱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x30, 0x48, 0x9c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC72 (ﱲ)
	{ 0x00, 0x00, 0x00, 0xa0, 0x00, 0x08, 0x40, 0x60, 0x50, 0x54, 0xa2, 0x22, 0x12, 0x0c, 0x00, 0x00 },	// U+FC73 (ﱳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FC74 (ﱴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FC75 (ﱵ)
	{ 0x00, 0x40, 0x00, 0xa0, 0x00, 0x40, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FC76 (ﱶ)
	{ 0x00, 0x40, 0x00, 0xa0, 0x00, 0x44, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FC77 (ﱷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x30, 0x48, 0x9c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FC78 (ﱸ)
	{ 0x00, 0x00, 0x40, 0x00, 0xa0, 0x00, 0x48, 0x60, 0x50, 0x54, 0xa2, 0x22, 0x12, 0x0c, 0x00, 0x00 },	// U+FC79 (ﱹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xa0, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FC7A (ﱺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xa0, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FC7B (ﱻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x30, 0x50, 0x62, 0x91, 0x31, 0x22, 0x1c, 0x00, 0x00 },	// U+FC7C (ﱼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x30, 0x50, 0x62, 0x91, 0x31, 0x22, 0x1c, 0x00, 0x14 },	// U+FC7D (ﱽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x20, 0x50, 0xe0, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x00 },	// U+FC7E (ﱾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x20, 0x50, 0xe0, 0x44, 0x22, 0x62, 0x44, 0x38, 0x00, 0x28 },	// U+FC7F (ﱿ)
	{ 0x00, 0x00, 0x84, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x34, 0x48, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC80 (ﲀ)
	{ 0x00, 0x00, 0x84, 0x44, 0x24, 0x14, 0x0c, 0x15, 0x35, 0x4d, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC81 (ﲁ)
	{ 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x10, 0x20, 0x50, 0x88, 0x10, 0x38, 0x04, 0x04, 0x04, 0x04 },	// U+FC82 (ﲂ)
	{ 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x10, 0x20, 0x62, 0x91, 0x31, 0x22, 0x1c, 0x00, 0x00 },	// U+FC83 (ﲃ)
	{ 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x10, 0x20, 0x62, 0x91, 0x31, 0x22, 0x1c, 0x00, 0x14 },	// U+FC84 (ﲄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0xf0, 0x10, 0x30, 0x08, 0x08, 0x08 },	// U+FC85 (ﲅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x42, 0xa1, 0x11, 0x22, 0x1c, 0x00, 0x00 },	// U+FC86 (ﲆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x42, 0xa1, 0x11, 0x22, 0x1c, 0x00, 0x14 },	// U+FC87 (ﲇ)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0xe4, 0x18, 0x70, 0x00, 0x00, 0x00 },	// U+FC88 (ﲈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0x1d, 0x75, 0x01, 0x01, 0x01 },	// U+FC89 (ﲉ)
	{ 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FC8A (ﲊ)
	{ 0x00, 0x00, 0x00, 0x40, 0x08, 0x40, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x08, 0x06, 0x00 },	// U+FC8B (ﲋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x60, 0x50, 0x48, 0x9e, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+FC8C (ﲌ)
	{ 0x00, 0x00, 0x00, 0x40, 0x08, 0x00, 0x40, 0x60, 0x50, 0x54, 0xa2, 0x22, 0x12, 0x0c, 0x00, 0x00 },	// U+FC8D (ﲍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FC8E (ﲎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FC8F (ﲏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FC90 (ﲐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x08, 0xa6, 0x00 },	// U+FC91 (ﲑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x60, 0x50, 0x48, 0x50, 0x90, 0x10, 0x10, 0x08, 0xa6, 0x00 },	// U+FC92 (ﲒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10, 0x3c, 0x02, 0x52, 0x02, 0x02, 0x02 },	// U+FC93 (ﲓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x60, 0x50, 0x54, 0xa2, 0x22, 0x12, 0x0c, 0xa0, 0x00 },	// U+FC94 (ﲔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x80, 0x20 },	// U+FC95 (ﲕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x80, 0x2a },	// U+FC96 (ﲖ)
	{ 0x40, 0x20, 0x60, 0x10, 0x00, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+FC97 (ﲗ)
	{ 0x40, 0x20, 0x60, 0x10, 0x00, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC98 (ﲘ)
	{ 0x40, 0x20, 0x60, 0x10, 0x00, 0x32, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC99 (ﲙ)
	{ 0x00, 0x40, 0x20, 0x60, 0x10, 0x00, 0x60, 0x10, 0x08, 0x08, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FC9A (ﲚ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x30, 0x08, 0x00, 0x64, 0x96, 0x17, 0x14, 0x24, 0x28, 0x30, 0x00 },	// U+FC9B (ﲛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x20, 0x04, 0x00, 0x00 },	// U+FC9C (ﲜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x20, 0x00, 0x00, 0x00 },	// U+FC9D (ﲝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x20, 0x00, 0x00, 0x00 },	// U+FC9E (ﲞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x10, 0x08, 0x08, 0x1f, 0x00, 0x20, 0x00, 0x00, 0x00 },	// U+FC9F (ﲟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x96, 0x17, 0x14, 0xa4, 0x28, 0x30, 0x00 },	// U+FCA0 (ﲠ)
	{ 0x00, 0x00, 0x50, 0x00, 0x00, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x04, 0x00, 0x00 },	// U+FCA1 (ﲡ)
	{ 0x00, 0x00, 0x50, 0x00, 0x00, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCA2 (ﲢ)
	{ 0x00, 0x00, 0x50, 0x00, 0x04, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCA3 (ﲣ)
	{ 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x60, 0x10, 0x08, 0x08, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCA4 (ﲤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x64, 0x96, 0x17, 0x14, 0x24, 0x28, 0x30, 0x00 },	// U+FCA5 (ﲥ)
	{ 0x00, 0x20, 0x00, 0x50, 0x00, 0x00, 0x60, 0x10, 0x08, 0x08, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCA6 (ﲦ)
	{ 0x00, 0x06, 0x1a, 0x20, 0x78, 0x04, 0x02, 0x7e, 0x18, 0x46, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCA7 (ﲧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x40, 0xf8, 0x14, 0x1b, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+FCA8 (ﲨ)
	{ 0x00, 0x06, 0x1a, 0x20, 0x78, 0x04, 0x02, 0x7e, 0x18, 0x06, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+FCA9 (ﲩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xc0, 0xf8, 0x14, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCAA (ﲪ)
	{ 0x10, 0x06, 0x1a, 0x20, 0x78, 0x04, 0x02, 0x7e, 0x18, 0x06, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+FCAB (ﲫ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x38, 0xc0, 0xf8, 0x14, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCAC (ﲬ)
}; // 110

static const unsigned char unifont_block350[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xa8, 0xa8, 0x7c, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCB0 (ﲰ)
}; // 1

static const unsigned char unifont_block351[][16] = {
	{ 0x08, 0x08, 0x68, 0x98, 0x78, 0x04, 0x1e, 0x60, 0x18, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCB8 (ﲸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x48, 0x08, 0x68, 0x98, 0x7c, 0x02, 0x0f, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+FCB9 (ﲹ)
	{ 0x00, 0x00, 0x0c, 0x42, 0x32, 0x0c, 0x02, 0x7e, 0x18, 0x06, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+FCBA (ﲺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x32, 0x0c, 0x02, 0x0f, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+FCBB (ﲻ)
	{ 0x04, 0x00, 0x0c, 0x42, 0x32, 0x0c, 0x02, 0x7e, 0x18, 0x06, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+FCBC (ﲼ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0c, 0x02, 0x32, 0x0c, 0x02, 0x0f, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+FCBD (ﲽ)
	{ 0x02, 0x08, 0x14, 0x1c, 0x10, 0x08, 0x04, 0x7c, 0x30, 0x0c, 0x03, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+FCBE (ﲾ)
	{ 0x02, 0x08, 0x14, 0x1c, 0x10, 0x08, 0x04, 0x7c, 0x30, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCBF (ﲿ)
	{ 0x00, 0x02, 0x08, 0x14, 0x1c, 0x11, 0x08, 0x04, 0x7c, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCC0 (ﳀ)
	{ 0x00, 0x08, 0x00, 0x08, 0x14, 0x1c, 0x10, 0x08, 0x04, 0x04, 0x0f, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+FCC1 (ﳁ)
	{ 0x14, 0x00, 0x08, 0x14, 0x1c, 0x10, 0x08, 0x04, 0x7c, 0x30, 0x0f, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+FCC2 (ﳂ)
	{ 0x00, 0x14, 0x00, 0x08, 0x14, 0x1c, 0x10, 0x08, 0x04, 0x04, 0x0f, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+FCC3 (ﳃ)
	{ 0x40, 0x20, 0x10, 0x08, 0x0c, 0x10, 0x08, 0x7e, 0x18, 0x06, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+FCC4 (ﳄ)
	{ 0x40, 0x20, 0x10, 0x08, 0x0c, 0x10, 0x08, 0x7e, 0x18, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCC5 (ﳅ)
	{ 0x40, 0x20, 0x10, 0x08, 0x0c, 0x11, 0x08, 0x7e, 0x18, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCC6 (ﳆ)
	{ 0x00, 0x40, 0x22, 0x12, 0x0a, 0x06, 0x1e, 0x22, 0x22, 0x24, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCC7 (ﳇ)
	{ 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x08, 0x04, 0x0f, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+FCC8 (ﳈ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x04, 0x00, 0x00 },	// U+FCC9 (ﳉ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCCA (ﳊ)
	{ 0x00, 0x00, 0x08, 0x08, 0x0a, 0x08, 0x08, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCCB (ﳋ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x3f, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+FCCC (ﳌ)
	{ 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38, 0x54, 0x5c, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCCD (ﳍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x38, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x04, 0x00, 0x00 },	// U+FCCE (ﳎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x38, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCCF (ﳏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x50, 0x38, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCD0 (ﳐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x78, 0x04, 0x04, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCD1 (ﳑ)
	{ 0x00, 0x00, 0x20, 0x00, 0x00, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x04, 0x00, 0x00 },	// U+FCD2 (ﳒ)
	{ 0x00, 0x00, 0x20, 0x00, 0x00, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCD3 (ﳓ)
	{ 0x00, 0x00, 0x20, 0x00, 0x04, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCD4 (ﳔ)
	{ 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x60, 0x10, 0x08, 0x08, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCD5 (ﳕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x64, 0x56, 0x17, 0x14, 0x24, 0x28, 0x30, 0x00 },	// U+FCD6 (ﳖ)
	{ 0x00, 0x3c, 0x48, 0x94, 0x94, 0x7c, 0x02, 0x7e, 0x18, 0x06, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+FCD7 (ﳗ)
	{ 0x00, 0x3c, 0x48, 0x94, 0x94, 0x78, 0x10, 0x08, 0x04, 0x02, 0x07, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+FCD8 (ﳘ)
	{ 0x04, 0x04, 0x00, 0x1e, 0x24, 0x4a, 0x4a, 0x3c, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCD9 (ﳙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x50, 0x04, 0x00, 0x00 },	// U+FCDA (ﳚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x50, 0x00, 0x00, 0x00 },	// U+FCDB (ﳛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x30, 0x28, 0x04, 0x1e, 0x30, 0x0f, 0x00, 0x50, 0x00, 0x00, 0x00 },	// U+FCDC (ﳜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x10, 0x08, 0x08, 0x1f, 0x00, 0x50, 0x00, 0x00, 0x00 },	// U+FCDD (ﳝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x0a, 0xab, 0x0a, 0x12, 0x14, 0x18, 0x00 },	// U+FCDE (ﳞ)
	{ 0x00, 0x00, 0x30, 0x08, 0x30, 0x0c, 0x00, 0x08, 0x14, 0x24, 0xcb, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCDF (ﳟ)
	{ 0x00, 0x00, 0x00, 0x60, 0x10, 0x60, 0x18, 0x00, 0x24, 0x56, 0x97, 0x14, 0x24, 0x28, 0x30, 0x00 },	// U+FCE0 (ﳠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x24, 0xcb, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+FCE1 (ﳡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x56, 0x97, 0x14, 0xa4, 0x28, 0x30, 0x00 },	// U+FCE2 (ﳢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x08, 0x14, 0x24, 0xcb, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCE3 (ﳣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x24, 0x56, 0x97, 0x14, 0x24, 0x28, 0x30, 0x00 },	// U+FCE4 (ﳤ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x08, 0x14, 0x24, 0xcb, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCE5 (ﳥ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x00, 0x24, 0x56, 0x97, 0x14, 0x24, 0x28, 0x30, 0x00 },	// U+FCE6 (ﳦ)
}; // 47

static const unsigned char unifont_block352[][16] = {
	{ 0x00, 0x40, 0x22, 0x12, 0x0a, 0x06, 0x0e, 0x12, 0x32, 0x52, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCEB (ﳫ)
	{ 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x18, 0x24, 0xcf, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+FCEC (ﳬ)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x24, 0xcf, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+FCED (ﳭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x14, 0x24, 0xcb, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCEE (ﳮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x30, 0x48, 0x4a, 0x8b, 0x0a, 0x12, 0x14, 0x18, 0x00 },	// U+FCEF (ﳯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x24, 0xcb, 0x00, 0x50, 0x00, 0x00, 0x00 },	// U+FCF0 (ﳰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x6a, 0x8b, 0x0a, 0x12, 0xd4, 0x18, 0x00 },	// U+FCF1 (ﳱ)
	{ 0x00, 0x30, 0x0c, 0x40, 0x54, 0x28, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCF2 (ﳲ)
	{ 0x20, 0x50, 0x20, 0x50, 0x0c, 0x40, 0x54, 0x28, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCF3 (ﳳ)
	{ 0x00, 0x50, 0x2a, 0x04, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FCF4 (ﳴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x70, 0x90, 0x70, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FCF5 (ﳵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x70, 0x90, 0x70, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FCF6 (ﳶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x10, 0x60, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FCF7 (ﳷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x10, 0x60, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FCF8 (ﳸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x60, 0x10, 0x60, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FCF9 (ﳹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x60, 0x10, 0x60, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FCFA (ﳺ)
}; // 16

static const unsigned char unifont_block353[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x1a, 0x20, 0x70, 0x08, 0x1c, 0x10, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FCFF (ﳿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x1a, 0x20, 0x70, 0x1c, 0x10, 0x10, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FD00 (ﴀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x1a, 0x20, 0x70, 0x1c, 0x90, 0x10, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FD01 (ﴁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x1a, 0x20, 0x70, 0x1c, 0x90, 0x10, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FD02 (ﴂ)
	{ 0x00, 0x00, 0x00, 0x20, 0x06, 0x1a, 0x20, 0x70, 0x1c, 0x10, 0x10, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FD03 (ﴃ)
	{ 0x00, 0x00, 0x00, 0x40, 0x06, 0x1a, 0x20, 0x70, 0x1c, 0x10, 0x10, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FD04 (ﴄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0xa0, 0xa0, 0x78, 0x28, 0x08, 0x10, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FD05 (ﴅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0xa0, 0xa0, 0x78, 0x28, 0x08, 0x10, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FD06 (ﴆ)
	{ 0x00, 0x00, 0x00, 0x10, 0x40, 0xa0, 0xa0, 0x78, 0x28, 0x08, 0x10, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FD07 (ﴇ)
	{ 0x00, 0x00, 0x00, 0x10, 0x40, 0xa0, 0xa0, 0x78, 0x28, 0x08, 0x10, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FD08 (ﴈ)
	{ 0x00, 0x00, 0x20, 0x00, 0x50, 0x00, 0xa4, 0x5a, 0x02, 0x7e, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FD09 (ﴉ)
	{ 0x00, 0x00, 0x20, 0x00, 0x50, 0x00, 0xa4, 0x5a, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FD0A (ﴊ)
	{ 0x00, 0x00, 0x20, 0x00, 0x50, 0x01, 0xa4, 0x5a, 0x02, 0x7e, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FD0B (ﴋ)
	{ 0x00, 0x00, 0x20, 0x00, 0x50, 0x00, 0xa4, 0x5a, 0x02, 0x06, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+FD0C (ﴌ)
	{ 0x00, 0x00, 0x00, 0x20, 0x00, 0x50, 0x00, 0xa8, 0x54, 0x04, 0x04, 0x04, 0x04, 0x02, 0x01, 0x00 },	// U+FD0D (ﴍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0x54, 0x04, 0x04, 0x04, 0x04, 0x02, 0x01, 0x00 },	// U+FD0E (ﴎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0xa0, 0xb0, 0x68, 0x24, 0x24, 0x04, 0x04, 0x04, 0x02, 0x01, 0x00 },	// U+FD0F (ﴏ)
	{ 0x00, 0x00, 0x00, 0x10, 0x40, 0xa0, 0xb0, 0x68, 0x24, 0x24, 0x04, 0x04, 0x04, 0x02, 0x01, 0x00 },	// U+FD10 (ﴐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x70, 0x90, 0x70, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FD11 (ﴑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x70, 0x90, 0x70, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FD12 (ﴒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xa0, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FD13 (ﴓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xa0, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FD14 (ﴔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x40, 0xa0, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x00 },	// U+FD15 (ﴕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x40, 0xa0, 0x60, 0x92, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FD16 (ﴖ)
}; // 24

static const unsigned char unifont_block354[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x50, 0x7c, 0x94, 0x04, 0x09, 0x11, 0x0e, 0x00, 0x00 },	// U+FD21 (ﴡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x50, 0x7c, 0x94, 0x04, 0x09, 0x11, 0x0e, 0x00, 0x0a },	// U+FD22 (ﴢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x20, 0x50, 0x50, 0x7c, 0x94, 0x04, 0x09, 0x11, 0x0e, 0x00, 0x00 },	// U+FD23 (ﴣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x20, 0x50, 0x50, 0x7c, 0x94, 0x04, 0x09, 0x11, 0x0e, 0x00, 0x0a },	// U+FD24 (ﴤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x2a, 0x55, 0x81, 0x3f, 0x02, 0x09, 0x22, 0x1c },	// U+FD25 (ﴥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x2a, 0x55, 0x81, 0x3f, 0x02, 0x01, 0x22, 0x1c },	// U+FD26 (ﴦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x15, 0x00, 0x2a, 0x55, 0x81, 0x3f, 0x02, 0x01, 0x22, 0x1c },	// U+FD27 (ﴧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x52, 0xad, 0x01, 0x03, 0x0e, 0x01, 0x01, 0x01 },	// U+FD28 (ﴨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x50, 0x00, 0xa8, 0x54, 0x04, 0x04, 0x02, 0x01 },	// U+FD29 (ﴩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0x54, 0x04, 0x04, 0x02, 0x01 },	// U+FD2A (ﴪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xa0, 0xb0, 0x68, 0x24, 0x24, 0x02, 0x01, 0x00 },	// U+FD2B (ﴫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xa0, 0xb0, 0x68, 0x24, 0x24, 0x02, 0x01, 0x00 },	// U+FD2C (ﴬ)
}; // 12

static const unsigned char unifont_block355[][16] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x68, 0x98, 0x78, 0x04, 0x0b, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+FD33 (ﴳ)
}; // 1

static const unsigned char unifont_block356[][16] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x68, 0x98, 0x78, 0x44, 0x8b, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+FD3A (ﴺ)
	{ 0x00, 0x00, 0x00, 0x08, 0x48, 0x08, 0x68, 0x98, 0x78, 0x44, 0x8b, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+FD3B (ﴻ)
	{ 0x80, 0x40, 0x20, 0x88, 0x48, 0x28, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FD3C (ﴼ)
	{ 0x80, 0x40, 0x20, 0x88, 0x48, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FD3D (ﴽ)
}; // 4

static const unsigned char unifont_block357[][16] = {
	{ 0x00, 0xf0, 0x0c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE20 (︠)
	{ 0x00, 0x0f, 0x30, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE21 (︡)
	{ 0x00, 0x78, 0x84, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE22 (︢)
	{ 0x00, 0x40, 0x21, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE23 (︣)
	{ 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE24 (︤)
	{ 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE25 (︥)
	{ 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE26 (︦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0c, 0xf0 },	// U+FE27 (︧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x30, 0x0f },	// U+FE28 (︨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0c },	// U+FE29 (︩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0f },	// U+FE2A (︪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8 },	// U+FE2B (︫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f },	// U+FE2C (︬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff },	// U+FE2D (︭)
	{ 0x00, 0xf8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE2E (︮)
	{ 0x00, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE2F (︯)
}; // 16

static const unsigned char unifont_block358[][16] = {
	{ 0x00, 0x30, 0x0c, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE70 (ﹰ)
	{ 0x00, 0x30, 0x0c, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE71 (ﹱ)
	{ 0x30, 0x30, 0x26, 0x14, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE72 (ﹲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x20, 0xc0, 0x00 },	// U+FE73 (ﹳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x30, 0x0c, 0x00, 0x00 },	// U+FE74 (ﹴ)
}; // 5

static const unsigned char unifont_block359[][16] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE76 (ﹶ)
	{ 0x00, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE77 (ﹷ)
	{ 0x30, 0x70, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE78 (ﹸ)
	{ 0x30, 0x70, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE79 (ﹹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c },	// U+FE7A (ﹺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x30, 0x0c },	// U+FE7B (ﹻ)
	{ 0x00, 0x00, 0x00, 0x20, 0x28, 0x1a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE7C (ﹼ)
	{ 0x00, 0x00, 0x00, 0x20, 0x28, 0x1a, 0x06, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE7D (ﹽ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE7E (ﹾ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE7F (ﹿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x3c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+FE80 (ﺀ)
	{ 0x00, 0x80, 0x7c, 0x02, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE81 (ﺁ)
	{ 0x00, 0x10, 0x0e, 0x01, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE82 (ﺂ)
	{ 0x18, 0x04, 0x18, 0x04, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE83 (ﺃ)
	{ 0x0c, 0x02, 0x0c, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE84 (ﺄ)
	{ 0x00, 0x00, 0x30, 0x08, 0x30, 0x08, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FE85 (ﺅ)
	{ 0x00, 0x00, 0x30, 0x08, 0x30, 0x08, 0x00, 0x30, 0x48, 0x48, 0xf8, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FE86 (ﺆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x30, 0x08, 0x30, 0x08 },	// U+FE87 (ﺇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xf8, 0x00, 0x0c, 0x02, 0x0c, 0x02 },	// U+FE88 (ﺈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x0c, 0x02, 0x00, 0x62, 0x12, 0x12, 0x62, 0x42, 0x3c, 0x00 },	// U+FE89 (ﺉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x0c, 0x02, 0x00, 0x02, 0xc2, 0x42, 0x42, 0x3c, 0x00, 0x00 },	// U+FE8A (ﺊ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x30, 0x08, 0x00, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE8B (ﺋ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x30, 0x08, 0x00, 0x20, 0x20, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE8C (ﺌ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE8D (ﺍ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE8E (ﺎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+FE8F (ﺏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x44, 0x42, 0xfc, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+FE90 (ﺐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0x3f, 0x00, 0x00, 0x08, 0x00, 0x00 },	// U+FE91 (ﺑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0xff, 0x00, 0x00, 0x08, 0x00, 0x00 },	// U+FE92 (ﺒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x08, 0x18, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE93 (ﺓ)
	{ 0x00, 0x00, 0x00, 0x48, 0x00, 0x20, 0x30, 0x28, 0x24, 0x3c, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE94 (ﺔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE95 (ﺕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x20, 0x44, 0x42, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE96 (ﺖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x10, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE97 (ﺗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x10, 0x20, 0x20, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE98 (ﺘ)
	{ 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x00, 0x20, 0x44, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE99 (ﺙ)
	{ 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x00, 0x20, 0x44, 0x42, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE9A (ﺚ)
	{ 0x00, 0x00, 0x04, 0x00, 0x12, 0x00, 0x00, 0x10, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE9B (ﺛ)
	{ 0x00, 0x00, 0x04, 0x00, 0x12, 0x00, 0x00, 0x10, 0x20, 0x20, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE9C (ﺜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x12, 0x02, 0x44, 0x38 },	// U+FE9D (ﺝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x28, 0xc4, 0x02, 0x12, 0x02, 0x84, 0x78 },	// U+FE9E (ﺞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x60, 0x7f, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+FE9F (ﺟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x60, 0xff, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+FEA0 (ﺠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FEA1 (ﺡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x28, 0xc4, 0x02, 0x02, 0x02, 0x84, 0x78 },	// U+FEA2 (ﺢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEA3 (ﺣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEA4 (ﺤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x7e, 0x08, 0x04, 0x02, 0x02, 0x02, 0x44, 0x38 },	// U+FEA5 (ﺥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x7e, 0x28, 0xc4, 0x02, 0x02, 0x02, 0x84, 0x78 },	// U+FEA6 (ﺦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0e, 0x30, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEA7 (ﺧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0e, 0x30, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEA8 (ﺨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEA9 (ﺩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x42, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEAA (ﺪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x20, 0x40, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEAB (ﺫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x20, 0x40, 0x42, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEAC (ﺬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FEAD (ﺭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0xc0, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FEAE (ﺮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FEAF (ﺯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x20, 0x40, 0xc0, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FEB0 (ﺰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+FEB1 (ﺱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xa8, 0xa8, 0xfa, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+FEB2 (ﺲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x54, 0x54, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEB3 (ﺳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x54, 0x54, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEB4 (ﺴ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x00, 0x80, 0xa8, 0xa8, 0x7a, 0x12, 0x12, 0x0c, 0x00 },	// U+FEB5 (ﺵ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x48, 0x00, 0x80, 0xa8, 0xa8, 0xfa, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+FEB6 (ﺶ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x40, 0x54, 0x54, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEB7 (ﺷ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x40, 0x54, 0x54, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEB8 (ﺸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x98, 0x72, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+FEB9 (ﺹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x98, 0xf2, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+FEBA (ﺺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x4a, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEBB (ﺻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x4a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEBC (ﺼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x60, 0x98, 0x72, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+FEBD (ﺽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x60, 0x98, 0xf2, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+FEBE (ﺾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x30, 0x4a, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEBF (ﺿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x30, 0x4a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEC0 (ﻀ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x44, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEC1 (ﻁ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x44, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEC2 (ﻂ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x44, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEC3 (ﻃ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x44, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEC4 (ﻄ)
	{ 0x00, 0x00, 0x00, 0x04, 0x24, 0x04, 0x04, 0x34, 0x4c, 0x44, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEC5 (ﻅ)
	{ 0x00, 0x00, 0x00, 0x04, 0x24, 0x04, 0x04, 0x34, 0x4c, 0x44, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEC6 (ﻆ)
	{ 0x00, 0x00, 0x00, 0x04, 0x24, 0x04, 0x04, 0x34, 0x4c, 0x44, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEC7 (ﻇ)
	{ 0x00, 0x00, 0x00, 0x04, 0x24, 0x04, 0x04, 0x34, 0x4c, 0x44, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEC8 (ﻈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+FEC9 (ﻉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0xf8, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+FECA (ﻊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FECB (ﻋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x10, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FECC (ﻌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x24, 0x04, 0x38, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+FECD (ﻍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x0c, 0x0c, 0xf8, 0x04, 0x02, 0x02, 0x42, 0x3c },	// U+FECE (ﻎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x24, 0x04, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FECF (ﻏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x18, 0x10, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FED0 (ﻐ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FED1 (ﻑ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x60, 0x50, 0x60, 0x42, 0x42, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FED2 (ﻒ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x1c, 0x24, 0x28, 0x30, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FED3 (ﻓ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x1c, 0x24, 0x28, 0x30, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FED4 (ﻔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x38, 0x48, 0x50, 0x64, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+FED5 (ﻕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x38, 0x48, 0x50, 0xe4, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+FED6 (ﻖ)
	{ 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x1c, 0x24, 0x28, 0x30, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FED7 (ﻗ)
	{ 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x1c, 0x24, 0x28, 0x30, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FED8 (ﻘ)
	{ 0x00, 0x00, 0x00, 0x40, 0x50, 0x48, 0x50, 0x44, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FED9 (ﻙ)
	{ 0x00, 0x00, 0x00, 0x40, 0x50, 0x48, 0x50, 0x44, 0x42, 0x42, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEDA (ﻚ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x40, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEDB (ﻛ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3c, 0x40, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEDC (ﻜ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x44, 0x42, 0x42, 0x22, 0x3c, 0x00, 0x00 },	// U+FEDD (ﻝ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xc4, 0x42, 0x42, 0x22, 0x3c, 0x00, 0x00 },	// U+FEDE (ﻞ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEDF (ﻟ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEE0 (ﻠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x60, 0x78, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+FEE1 (ﻡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x60, 0xf8, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+FEE2 (ﻢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x4c, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEE3 (ﻣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x4c, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEE4 (ﻤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x20, 0x44, 0x42, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+FEE5 (ﻥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x20, 0x44, 0xc2, 0x42, 0x22, 0x1c, 0x00, 0x00 },	// U+FEE6 (ﻦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x10, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEE7 (ﻧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x10, 0x20, 0x20, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEE8 (ﻨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEE9 (ﻩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x30, 0x28, 0x24, 0x3c, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEEA (ﻪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3c, 0x54, 0x5c, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FEEB (ﻫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x28, 0x28, 0xff, 0x28, 0x30, 0x00, 0x00, 0x00 },	// U+FEEC (ﻬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x78, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FEED (ﻭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0xf8, 0x40, 0x20, 0x12, 0x0c, 0x00 },	// U+FEEE (ﻮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x52, 0x12, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+FEEF (ﻯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x22, 0x42, 0x42, 0x3c, 0x00 },	// U+FEF0 (ﻰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x52, 0x12, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FEF1 (ﻱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x22, 0x42, 0x3c, 0x00, 0x14 },	// U+FEF2 (ﻲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x1f, 0x00, 0x14, 0x00, 0x00, 0x00 },	// U+FEF3 (ﻳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0xdf, 0x00, 0x14, 0x00, 0x00, 0x00 },	// U+FEF4 (ﻴ)
	{ 0x00, 0x00, 0x10, 0x4e, 0x41, 0x44, 0x48, 0x50, 0x20, 0x30, 0x28, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+FEF5 (ﻵ)
	{ 0x00, 0x00, 0x10, 0x4e, 0x41, 0x44, 0x48, 0x50, 0x70, 0x50, 0xc8, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+FEF6 (ﻶ)
	{ 0x00, 0x00, 0x0c, 0x42, 0x4c, 0x42, 0x48, 0x50, 0x20, 0x30, 0x28, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+FEF7 (ﻷ)
	{ 0x00, 0x00, 0x0c, 0x42, 0x4c, 0x42, 0x48, 0x50, 0x70, 0x50, 0xc8, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+FEF8 (ﻸ)
	{ 0x00, 0x00, 0x40, 0x40, 0x44, 0x48, 0x50, 0x20, 0x30, 0x28, 0x38, 0x00, 0x30, 0x08, 0x30, 0x08 },	// U+FEF9 (ﻹ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x44, 0x48, 0x50, 0x70, 0x50, 0xc8, 0x06, 0x30, 0x08, 0x30, 0x08 },	// U+FEFA (ﻺ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x44, 0x48, 0x50, 0x20, 0x30, 0x28, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+FEFB (ﻻ)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x44, 0x48, 0x50, 0x70, 0x50, 0xc8, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+FEFC (ﻼ)
}; // 135

static const unsigned char unifont_block360[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x04, 0x00 },	// U+FF61 (｡)
	{ 0x00, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+FF62 (｢)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x00 },	// U+FF63 (｣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0c, 0x18, 0x00, 0x00 },	// U+FF64 (､)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF65 (･)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+FF66 (ｦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x48, 0x28, 0x08, 0x08, 0x08, 0x04, 0x00 },	// U+FF67 (ｧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x10, 0x18, 0x16, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+FF68 (ｨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x7e, 0x42, 0x42, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00 },	// U+FF69 (ｩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7e, 0x00, 0x00 },	// U+FF6A (ｪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7e, 0x18, 0x18, 0x14, 0x12, 0x10, 0x18, 0x00 },	// U+FF6B (ｫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x44, 0x68, 0x58, 0x4c, 0x12, 0x10, 0x10, 0x20, 0x20, 0x00 },	// U+FF6C (ｬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7e, 0x00, 0x00 },	// U+FF6D (ｭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x3c, 0x00, 0x00 },	// U+FF6E (ｮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x4a, 0x52, 0x44, 0x20, 0x20, 0x10, 0x08, 0x04, 0x00 },	// U+FF6F (ｯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF70 (ｰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x48, 0x28, 0x28, 0x08, 0x08, 0x08, 0x04, 0x04, 0x02, 0x00 },	// U+FF71 (ｱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x10, 0x18, 0x14, 0x13, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+FF72 (ｲ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x7e, 0x42, 0x42, 0x42, 0x40, 0x20, 0x20, 0x10, 0x08, 0x04, 0x00 },	// U+FF73 (ｳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0x00 },	// U+FF74 (ｴ)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0xff, 0x10, 0x18, 0x18, 0x14, 0x12, 0x11, 0x14, 0x18, 0x00, 0x00 },	// U+FF75 (ｵ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x7e, 0x48, 0x48, 0x48, 0x44, 0x44, 0x44, 0x42, 0x72, 0x00, 0x00 },	// U+FF76 (ｶ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x68, 0x18, 0x0c, 0x0b, 0xc8, 0x30, 0x1c, 0x12, 0x20, 0x20, 0x00 },	// U+FF77 (ｷ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x78, 0x48, 0x44, 0x44, 0x20, 0x20, 0x10, 0x10, 0x08, 0x04, 0x00 },	// U+FF78 (ｸ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0xfc, 0x22, 0x22, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00 },	// U+FF79 (ｹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+FF7A (ｺ)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0xff, 0x24, 0x24, 0x24, 0x20, 0x10, 0x10, 0x08, 0x04, 0x00 },	// U+FF7B (ｻ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x42, 0x42, 0x44, 0x20, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00 },	// U+FF7C (ｼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x10, 0x10, 0x18, 0x28, 0x44, 0x42, 0x81, 0x00, 0x00 },	// U+FF7D (ｽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x74, 0x4c, 0x47, 0x24, 0x04, 0x04, 0x04, 0x7c, 0x00, 0x00 },	// U+FF7E (ｾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x44, 0x44, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x04, 0x00 },	// U+FF7F (ｿ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x78, 0x48, 0x44, 0x4c, 0x52, 0x20, 0x10, 0x10, 0x08, 0x04, 0x00 },	// U+FF80 (ﾀ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x1e, 0x10, 0x10, 0xff, 0x10, 0x10, 0x08, 0x08, 0x04, 0x02, 0x00 },	// U+FF81 (ﾁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x4a, 0x52, 0x44, 0x20, 0x20, 0x10, 0x08, 0x08, 0x04, 0x02, 0x00 },	// U+FF82 (ﾂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0xff, 0x10, 0x10, 0x08, 0x08, 0x08, 0x04, 0x02, 0x00 },	// U+FF83 (ﾃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x18, 0x28, 0x48, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+FF84 (ﾄ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xff, 0x10, 0x10, 0x08, 0x08, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+FF85 (ﾅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00 },	// U+FF86 (ﾆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x22, 0x14, 0x18, 0x10, 0x28, 0x48, 0x04, 0x04, 0x00 },	// U+FF87 (ﾇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x7e, 0x40, 0x20, 0x10, 0x18, 0x2c, 0x4a, 0x88, 0x08, 0x08 },	// U+FF88 (ﾈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+FF89 (ﾉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x44, 0x44, 0x44, 0x42, 0x82, 0x82, 0x81, 0x00, 0x00 },	// U+FF8A (ﾊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x62, 0x12, 0x0e, 0x02, 0x02, 0x02, 0x04, 0x78, 0x00, 0x00 },	// U+FF8B (ﾋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+FF8C (ﾌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x0c, 0x12, 0x22, 0x21, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+FF8D (ﾍ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0xff, 0x08, 0x08, 0x2a, 0x4a, 0x89, 0x08, 0x0c, 0x00, 0x00 },	// U+FF8E (ﾎ)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0x80, 0x40, 0x20, 0x14, 0x08, 0x18, 0x10, 0x20, 0x20, 0x00, 0x00 },	// U+FF8F (ﾏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x18, 0x20, 0x04, 0x08, 0x30, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+FF90 (ﾐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x04, 0x24, 0x24, 0x44, 0x72, 0x4e, 0x81, 0x00, 0x00 },	// U+FF91 (ﾑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x24, 0x24, 0x18, 0x10, 0x38, 0x28, 0x44, 0x04, 0x02, 0x00 },	// U+FF92 (ﾒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x08, 0x08, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x78, 0x00, 0x00 },	// U+FF93 (ﾓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0xc4, 0xb4, 0x8c, 0x4b, 0x08, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+FF94 (ﾔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7e, 0x00, 0x00 },	// U+FF95 (ﾕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00 },	// U+FF96 (ﾖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x20, 0x20, 0x10, 0x08, 0x04, 0x00 },	// U+FF97 (ﾗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00 },	// U+FF98 (ﾘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x14, 0x14, 0x94, 0x94, 0x94, 0x54, 0x52, 0x32, 0x11, 0x00, 0x00 },	// U+FF99 (ﾙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x44, 0x44, 0x24, 0x24, 0x14, 0x0c, 0x00, 0x00 },	// U+FF9A (ﾚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x00, 0x00, 0x00 },	// U+FF9B (ﾛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x40, 0x20, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+FF9C (ﾜ)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x48, 0x40, 0x40, 0x20, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+FF9D (ﾝ)
	{ 0x00, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF9E (ﾞ)
	{ 0x00, 0x08, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF9F (ﾟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FFA0 (ﾠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00 },	// U+FFA1 (ﾡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+FFA2 (ﾢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x28, 0x28, 0x58, 0x88, 0x00, 0x00, 0x00 },	// U+FFA3 (ﾣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+FFA4 (ﾤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x54, 0x9c, 0x00, 0x00 },	// U+FFA5 (ﾥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xe4, 0x44, 0xa4, 0x5c, 0x00, 0x00 },	// U+FFA6 (ﾦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00 },	// U+FFA7 (ﾧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x12, 0x12, 0x12, 0x36, 0x00, 0x00 },	// U+FFA8 (ﾨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x20, 0x3c, 0x04, 0x3c, 0x00, 0x00 },	// U+FFA9 (ﾩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x48, 0x4e, 0x42, 0x4e, 0x00, 0x00 },	// U+FFAA (ﾪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x54, 0x57, 0x51, 0x77, 0x00, 0x00 },	// U+FFAB (ﾫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x54, 0x77, 0x51, 0x77, 0x00, 0x00 },	// U+FFAC (ﾬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x24, 0x27, 0x51, 0x57, 0x00, 0x00 },	// U+FFAD (ﾭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x14, 0x77, 0x11, 0x77, 0x00, 0x00 },	// U+FFAE (ﾮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x54, 0x57, 0x51, 0xff, 0x00, 0x00 },	// U+FFAF (ﾯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x74, 0x27, 0x51, 0x27, 0x00, 0x00 },	// U+FFB0 (ﾰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+FFB1 (ﾱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x7e, 0x42, 0x7e, 0x00, 0x00 },	// U+FFB2 (ﾲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x77, 0x55, 0x77, 0x00, 0x00 },	// U+FFB3 (ﾳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2e, 0x5a, 0x8e, 0x00, 0x00 },	// U+FFB4 (ﾴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x14, 0x22, 0x00, 0x00 },	// U+FFB5 (ﾵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x5a, 0x89, 0x00, 0x00 },	// U+FFB6 (ﾶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+FFB7 (ﾷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x14, 0x22, 0x00, 0x00 },	// U+FFB8 (ﾸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24, 0x24, 0x5a, 0x89, 0x00, 0x00 },	// U+FFB9 (ﾹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x3e, 0x08, 0x14, 0x22, 0x00, 0x00 },	// U+FFBA (ﾺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x7e, 0x40, 0x40, 0x00, 0x00 },	// U+FFBB (ﾻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x7e, 0x02, 0x7e, 0x00, 0x00 },	// U+FFBC (ﾼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24, 0x24, 0x24, 0x7e, 0x00, 0x00 },	// U+FFBD (ﾽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x7f, 0x1c, 0x22, 0x1c, 0x00, 0x00 },	// U+FFBE (ﾾ)
}; // 94

static const unsigned char unifont_block361[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x00, 0x00 },	// U+FFC2 (ￂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x1c, 0x14, 0x14, 0x00, 0x00 },	// U+FFC3 (ￃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1c, 0x04, 0x1c, 0x04, 0x00, 0x00 },	// U+FFC4 (ￄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x1c, 0x14, 0x1c, 0x14, 0x00, 0x00 },	// U+FFC5 (ￅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1c, 0x10, 0x10, 0x00, 0x00 },	// U+FFC6 (ￆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x2e, 0x28, 0x28, 0x00, 0x00 },	// U+FFC7 (ￇ)
}; // 6

static const unsigned char unifont_block362[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1c, 0x10, 0x1c, 0x10, 0x00, 0x00 },	// U+FFCA (ￊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x2e, 0x28, 0x2e, 0x28, 0x00, 0x00 },	// U+FFCB (ￋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00 },	// U+FFCC (ￌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x28, 0x28, 0x7e, 0x00, 0x00 },	// U+FFCD (ￍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x50, 0x54, 0x54, 0x7f, 0x00, 0x00 },	// U+FFCE (ￎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x28, 0x28, 0x3e, 0x00, 0x00 },	// U+FFCF (ￏ)
}; // 6

static const unsigned char unifont_block363[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x3e, 0x00, 0x00 },	// U+FFD2 (ￒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+FFD3 (ￓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x3c, 0x28, 0x38, 0x28, 0x28, 0x00, 0x00 },	// U+FFD4 (ￔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x50, 0x5e, 0x54, 0x5c, 0x54, 0x54, 0x00, 0x00 },	// U+FFD5 (ￕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x3c, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+FFD6 (ￖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+FFD7 (ￗ)
}; // 6

static const unsigned char unifont_block364[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+FFDA (ￚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x18, 0x14, 0x10, 0x00, 0x00 },	// U+FFDB (ￛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+FFDC (ￜ)
}; // 3

static const unsigned char unifont_block365[][16] = {
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+FFE8 (￨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x7e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FFE9 (￩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FFEA (￪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x7e, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FFEB (￫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FFEC (￬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00, 0x00 },	// U+FFED (￭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+FFEE (￮)
}; // 7

static const unsigned char unifont_block366[][16] = {
	{ 0x00, 0x00, 0x00, 0x7e, 0x66, 0x5a, 0x5a, 0x5e, 0x6e, 0x6e, 0x7e, 0x6e, 0x6e, 0x7e, 0x00, 0x00 },	// U+FFFD (�)
}; // 1

