/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font TopazPlus-8x16.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char topaz_block1[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0000 (ESC)
	{ 0xc1, 0xc1, 0x9c, 0x9c, 0x84, 0x84, 0x94, 0x94, 0x84, 0x84, 0xfc, 0xfc, 0xe1, 0xe1, 0xff, 0xff },	// U+0001 (ESC)
	{ 0xc3, 0xc3, 0x99, 0x99, 0x99, 0x99, 0x81, 0x81, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xff, 0xff },	// U+0002 (ESC)
	{ 0xc1, 0xc1, 0x99, 0x99, 0x99, 0x99, 0xc1, 0xc1, 0x99, 0x99, 0x99, 0x99, 0xc1, 0xc1, 0xff, 0xff },	// U+0003 (ESC)
	{ 0x87, 0x87, 0xf3, 0xf3, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf3, 0xf3, 0x87, 0x87, 0xff, 0xff },	// U+0004 (ESC)
	{ 0xe1, 0xe1, 0xc9, 0xc9, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc9, 0xc9, 0xe1, 0xe1, 0xff, 0xff },	// U+0005 (ESC)
	{ 0x81, 0x81, 0xf9, 0xf9, 0xf9, 0xf9, 0xe1, 0xe1, 0xf9, 0xf9, 0xf9, 0xf9, 0x81, 0x81, 0xff, 0xff },	// U+0006 (ESC)
	{ 0x81, 0x81, 0xf9, 0xf9, 0xf9, 0xf9, 0xe1, 0xe1, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xff, 0xff },	// U+0007 (ESC)
	{ 0xc3, 0xc3, 0x99, 0x99, 0xf9, 0xf9, 0x89, 0x89, 0x99, 0x99, 0x99, 0x99, 0x83, 0x83, 0xff, 0xff },	// U+0008 (ESC)
	{ 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x81, 0x81, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xff, 0xff },	// U+0009 (ESC)
	{ 0xc3, 0xc3, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xc3, 0xc3, 0xff, 0xff },	// U+000A (ESC)
	{ 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+000B (ESC)
	{ 0x39, 0x39, 0x99, 0x99, 0xc9, 0xc9, 0xe1, 0xe1, 0xc9, 0xc9, 0x99, 0x99, 0x39, 0x39, 0xff, 0xff },	// U+000C (ESC)
	{ 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0x81, 0x81, 0xff, 0xff },	// U+000D (ESC)
	{ 0x39, 0x39, 0x11, 0x11, 0x01, 0x01, 0x29, 0x29, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0xff, 0xff },	// U+000E (ESC)
	{ 0x39, 0x39, 0x31, 0x31, 0x21, 0x21, 0x09, 0x09, 0x19, 0x19, 0x39, 0x39, 0x39, 0x39, 0xff, 0xff },	// U+000F (ESC)
	{ 0xc3, 0xc3, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+0010 (ESC)
	{ 0xc1, 0xc1, 0x99, 0x99, 0x99, 0x99, 0xc1, 0xc1, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xff, 0xff },	// U+0011 (ESC)
	{ 0xc3, 0xc3, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x89, 0x89, 0x03, 0x03, 0xff, 0xff },	// U+0012 (ESC)
	{ 0xc1, 0xc1, 0x99, 0x99, 0x99, 0x99, 0xc1, 0xc1, 0xc9, 0xc9, 0x99, 0x99, 0x99, 0x99, 0xff, 0xff },	// U+0013 (ESC)
	{ 0xc3, 0xc3, 0x99, 0x99, 0xf1, 0xf1, 0xc3, 0xc3, 0x8f, 0x8f, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+0014 (ESC)
	{ 0x81, 0x81, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xff, 0xff },	// U+0015 (ESC)
	{ 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+0016 (ESC)
	{ 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x81, 0xc3, 0xc3, 0xe7, 0xe7, 0xff, 0xff },	// U+0017 (ESC)
	{ 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x29, 0x29, 0x01, 0x01, 0x11, 0x11, 0x39, 0x39, 0xff, 0xff },	// U+0018 (ESC)
	{ 0x3c, 0x3c, 0x99, 0x99, 0xc3, 0xc3, 0xe7, 0xe7, 0xc3, 0xc3, 0x99, 0x99, 0x3c, 0x3c, 0xff, 0xff },	// U+0019 (ESC)
	{ 0x3c, 0x3c, 0x99, 0x99, 0xc3, 0xc3, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xff, 0xff },	// U+001A (ESC)
	{ 0x01, 0x01, 0x9f, 0x9f, 0xcf, 0xcf, 0xe7, 0xe7, 0xf3, 0xf3, 0xf9, 0xf9, 0x01, 0x01, 0xff, 0xff },	// U+001B (ESC)
	{ 0xc3, 0x03, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0x03, 0xc3, 0xff, 0xff },	// U+001C (ESC)
	{ 0xfc, 0xfc, 0xf9, 0xf9, 0xf3, 0xf3, 0xe7, 0xe7, 0xcf, 0xcf, 0x9f, 0x9f, 0x3f, 0x3f, 0x7f, 0x7f },	// U+001D (ESC)
	{ 0xc3, 0xc0, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xc0, 0xc3, 0xff, 0xff },	// U+001E (ESC)
	{ 0xef, 0xef, 0xc7, 0xc7, 0x93, 0x93, 0x39, 0x39, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+001F (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+0021 (!)
	{ 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x36, 0x36, 0x36, 0x36, 0x7f, 0x7f, 0x36, 0x36, 0x7f, 0x7f, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00 },	// U+0023 (#)
	{ 0x18, 0x18, 0x7c, 0x7c, 0x06, 0x06, 0x3c, 0x3c, 0x60, 0x60, 0x3e, 0x3e, 0x18, 0x18, 0x00, 0x00 },	// U+0024 ($)
	{ 0xc0, 0xc0, 0x66, 0x66, 0x35, 0x35, 0x1b, 0x1b, 0x6c, 0x6c, 0x56, 0x56, 0x33, 0x33, 0x00, 0x00 },	// U+0025 (%)
	{ 0x1c, 0x1c, 0x36, 0x36, 0x16, 0x16, 0x6e, 0x6e, 0x3b, 0x3b, 0x73, 0x73, 0xde, 0xde, 0x00, 0x00 },	// U+0026 (&)
	{ 0x18, 0x18, 0x18, 0x18, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0xc0, 0xe0, 0x70, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x70, 0xe0, 0xc0, 0x00, 0x00 },	// U+0028 (()
	{ 0x03, 0x07, 0x0e, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x0e, 0x07, 0x03, 0x00, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x66, 0x66, 0x3c, 0x3c, 0xff, 0xff, 0x3c, 0x3c, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x0c },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+002E (.)
	{ 0xc0, 0xc0, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x03, 0x03, 0x01, 0x01 },	// U+002F (/)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x76, 0x76, 0x7e, 0x7e, 0x6e, 0x6e, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+0030 (0)
	{ 0x18, 0x18, 0x1c, 0x1c, 0x1e, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+0031 (1)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x7e, 0x7e, 0x00, 0x00 },	// U+0032 (2)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x60, 0x60, 0x38, 0x38, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+0033 (3)
	{ 0x38, 0x38, 0x3c, 0x3c, 0x36, 0x36, 0x33, 0x33, 0x7f, 0x7f, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00 },	// U+0034 (4)
	{ 0x7e, 0x7e, 0x06, 0x06, 0x3e, 0x3e, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+0035 (5)
	{ 0x38, 0x38, 0x0c, 0x0c, 0x06, 0x06, 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+0036 (6)
	{ 0x7e, 0x7e, 0x60, 0x60, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+0037 (7)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+0038 (8)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x60, 0x60, 0x30, 0x30, 0x1c, 0x1c, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x0c },	// U+003B (;)
	{ 0xc0, 0xc0, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0xc0, 0xc0, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x03, 0x03, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x03, 0x03, 0x00, 0x00 },	// U+003E (>)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00 },	// U+003F (?)
	{ 0x3e, 0x3e, 0x63, 0x63, 0x7b, 0x7b, 0x6b, 0x6b, 0x7b, 0x7b, 0x03, 0x03, 0x1e, 0x1e, 0x00, 0x00 },	// U+0040 (@)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+0041 (A)
	{ 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x3e, 0x00, 0x00 },	// U+0042 (B)
	{ 0x78, 0x78, 0x0c, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x0c, 0x78, 0x78, 0x00, 0x00 },	// U+0043 (C)
	{ 0x1e, 0x1e, 0x36, 0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x36, 0x36, 0x1e, 0x1e, 0x00, 0x00 },	// U+0044 (D)
	{ 0x7e, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x1e, 0x1e, 0x06, 0x06, 0x06, 0x06, 0x7e, 0x7e, 0x00, 0x00 },	// U+0045 (E)
	{ 0x7e, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x1e, 0x1e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00 },	// U+0046 (F)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x06, 0x06, 0x76, 0x76, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+0047 (G)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+0048 (H)
	{ 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x00, 0x00 },	// U+0049 (I)
	{ 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+004A (J)
	{ 0x63, 0x63, 0x33, 0x33, 0x1b, 0x1b, 0x0f, 0x0f, 0x1b, 0x1b, 0x33, 0x33, 0x63, 0x63, 0x00, 0x00 },	// U+004B (K)
	{ 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7e, 0x7e, 0x00, 0x00 },	// U+004C (L)
	{ 0x63, 0x63, 0x77, 0x77, 0x7f, 0x7f, 0x6b, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00 },	// U+004D (M)
	{ 0x63, 0x63, 0x67, 0x67, 0x6f, 0x6f, 0x7b, 0x7b, 0x73, 0x73, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00 },	// U+004E (N)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+004F (O)
	{ 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x3e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00 },	// U+0050 (P)
	{ 0x1e, 0x1e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3b, 0x7e, 0x7e, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x3e, 0x36, 0x36, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+0052 (R)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x0e, 0x0e, 0x3c, 0x3c, 0x70, 0x70, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+0053 (S)
	{ 0x7e, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+0054 (T)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+0055 (U)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00 },	// U+0056 (V)
	{ 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x7f, 0x7f, 0x77, 0x77, 0x63, 0x63, 0x00, 0x00 },	// U+0057 (W)
	{ 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0xc3, 0xc3, 0x00, 0x00 },	// U+0058 (X)
	{ 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x7f, 0x7f, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x03, 0x03, 0x7f, 0x7f, 0x00, 0x00 },	// U+005A (Z)
	{ 0x3c, 0xfc, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xfc, 0x3c, 0x00, 0x00 },	// U+005B ([)
	{ 0x03, 0x03, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0xc0, 0xc0, 0x80, 0x80 },	// U+005C (\)
	{ 0x3c, 0x3f, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3f, 0x3c, 0x00, 0x00 },	// U+005D (])
	{ 0x08, 0x08, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff },	// U+005F (_)
	{ 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x60, 0x60, 0x7c, 0x7c, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+0061 (a)
	{ 0x06, 0x06, 0x06, 0x06, 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x3e, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3c, 0x3c, 0x00, 0x00 },	// U+0063 (c)
	{ 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x06, 0x06, 0x3c, 0x3c, 0x00, 0x00 },	// U+0065 (e)
	{ 0x38, 0x38, 0x0c, 0x0c, 0x3e, 0x3e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x60, 0x60, 0x3c, 0x3c },	// U+0067 (g)
	{ 0x06, 0x06, 0x06, 0x06, 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+0068 (h)
	{ 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00 },	// U+0069 (i)
	{ 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1e, 0x1e },	// U+006A (j)
	{ 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x36, 0x36, 0x1e, 0x1e, 0x36, 0x36, 0x66, 0x66, 0x00, 0x00 },	// U+006B (k)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x37, 0x37, 0x7f, 0x7f, 0x6b, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x3e, 0x06, 0x06, 0x06, 0x06 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x66, 0x66, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x06, 0x06, 0x3c, 0x3c, 0x60, 0x60, 0x3e, 0x3e, 0x00, 0x00 },	// U+0073 (s)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x3e, 0x3e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x38, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x7f, 0x7f, 0x36, 0x36, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0x63, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x0c, 0x0c },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x7e, 0x7e, 0x00, 0x00 },	// U+007A (z)
	{ 0x70, 0xf0, 0x98, 0x18, 0x18, 0x18, 0x0e, 0x0e, 0x18, 0x18, 0x18, 0x98, 0xf0, 0x70, 0x00, 0x00 },	// U+007B ({)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+007C (|)
	{ 0x0e, 0x0f, 0x19, 0x18, 0x18, 0x18, 0x70, 0x70, 0x18, 0x18, 0x18, 0x19, 0x0f, 0x0e, 0x00, 0x00 },	// U+007D (})
	{ 0x4e, 0x4e, 0x39, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
	{ 0xf0, 0xf0, 0x3c, 0x3c, 0x0f, 0x0f, 0xc3, 0xc3, 0xf0, 0xf0, 0x3c, 0x3c, 0x0f, 0x0f, 0x00, 0x00 },	// U+007F ()
	{ 0xf3, 0xf3, 0xe7, 0xe7, 0xc3, 0xc3, 0x99, 0x99, 0x81, 0x81, 0x99, 0x99, 0x99, 0x99, 0xff, 0xff },	// U+0080 ()
	{ 0xcf, 0xcf, 0xe7, 0xe7, 0xc3, 0xc3, 0x99, 0x99, 0x81, 0x81, 0x99, 0x99, 0x99, 0x99, 0xff, 0xff },	// U+0081 ()
	{ 0xe7, 0xe7, 0x99, 0x99, 0xc3, 0xc3, 0x99, 0x99, 0x81, 0x81, 0x99, 0x99, 0x99, 0x99, 0xff, 0xff },	// U+0082 ()
	{ 0x71, 0x71, 0x8e, 0x8e, 0xc3, 0xc3, 0x99, 0x99, 0x81, 0x81, 0x99, 0x99, 0x99, 0x99, 0xff, 0xff },	// U+0083 ()
	{ 0x99, 0x99, 0xff, 0xff, 0xc3, 0xc3, 0x99, 0x99, 0x81, 0x81, 0x99, 0x99, 0x99, 0x99, 0xff, 0xff },	// U+0084 ()
	{ 0xe7, 0xe7, 0xdb, 0xdb, 0xc3, 0xc3, 0x99, 0x99, 0x81, 0x81, 0x99, 0x99, 0x99, 0x99, 0xff, 0xff },	// U+0085 ()
	{ 0x07, 0x07, 0xc3, 0xc3, 0xc3, 0xc3, 0x09, 0x09, 0xc1, 0xc1, 0xcc, 0xcc, 0x0c, 0x0c, 0xff, 0xff },	// U+0086 ()
	{ 0x87, 0x87, 0xf3, 0xf3, 0xf9, 0xf9, 0xf9, 0xf9, 0xf3, 0xf3, 0x87, 0x87, 0xcf, 0xcf, 0xe7, 0xe7 },	// U+0087 ()
	{ 0xf3, 0xf3, 0xe7, 0xe7, 0x81, 0x81, 0xf9, 0xf9, 0xe1, 0xe1, 0xf9, 0xf9, 0x81, 0x81, 0xff, 0xff },	// U+0088 ()
	{ 0xcf, 0xcf, 0xe7, 0xe7, 0x81, 0x81, 0xf9, 0xf9, 0xe1, 0xe1, 0xf9, 0xf9, 0x81, 0x81, 0xff, 0xff },	// U+0089 ()
	{ 0xe7, 0xe7, 0x99, 0x99, 0x81, 0x81, 0xf9, 0xf9, 0xe1, 0xe1, 0xf9, 0xf9, 0x81, 0x81, 0xff, 0xff },	// U+008A ()
	{ 0x99, 0x99, 0xff, 0xff, 0x81, 0x81, 0xf9, 0xf9, 0xe1, 0xe1, 0xf9, 0xf9, 0x81, 0x81, 0xff, 0xff },	// U+008B ()
	{ 0xf3, 0xf3, 0xe7, 0xe7, 0xc3, 0xc3, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xc3, 0xc3, 0xff, 0xff },	// U+008C ()
	{ 0xcf, 0xcf, 0xe7, 0xe7, 0xc3, 0xc3, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xc3, 0xc3, 0xff, 0xff },	// U+008D ()
	{ 0xe7, 0xe7, 0x99, 0x99, 0xc3, 0xc3, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xc3, 0xc3, 0xff, 0xff },	// U+008E ()
	{ 0x99, 0x99, 0xff, 0xff, 0xc3, 0xc3, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xc3, 0xc3, 0xff, 0xff },	// U+008F ()
	{ 0xe1, 0xe1, 0xc9, 0xc9, 0x99, 0x99, 0x90, 0x90, 0x99, 0x99, 0xc9, 0xc9, 0xe1, 0xe1, 0xff, 0xff },	// U+0090 ()
	{ 0x71, 0x71, 0x8c, 0x8c, 0x98, 0x98, 0x90, 0x90, 0x84, 0x84, 0x8c, 0x8c, 0x9c, 0x9c, 0xff, 0xff },	// U+0091 ()
	{ 0xf3, 0xf3, 0xe7, 0xe7, 0xc3, 0xc3, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+0092 ()
	{ 0xcf, 0xcf, 0xe7, 0xe7, 0xc3, 0xc3, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+0093 ()
	{ 0xe7, 0xe7, 0x99, 0x99, 0xc3, 0xc3, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+0094 ()
	{ 0x71, 0x71, 0x8e, 0x8e, 0xc3, 0xc3, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+0095 ()
	{ 0x3c, 0x3c, 0xc3, 0xc3, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+0096 ()
	{ 0xff, 0xff, 0x9c, 0x9c, 0xc9, 0xc9, 0xe3, 0xe3, 0xc9, 0xc9, 0x9c, 0x9c, 0xff, 0xff, 0xff, 0xff },	// U+0097 ()
	{ 0x03, 0x03, 0x99, 0x99, 0x89, 0x89, 0x81, 0x81, 0x91, 0x91, 0x99, 0x99, 0xc0, 0xc0, 0xff, 0xff },	// U+0098 ()
	{ 0xf3, 0xf3, 0xe7, 0xe7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+0099 ()
	{ 0xcf, 0xcf, 0xe7, 0xe7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+009A ()
	{ 0xe7, 0xe7, 0xdb, 0xdb, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+009B ()
	{ 0x99, 0x99, 0xff, 0xff, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xc3, 0xff, 0xff },	// U+009C ()
	{ 0x9f, 0x9f, 0xef, 0xef, 0x3c, 0x3c, 0x99, 0x99, 0xc3, 0xc3, 0xe7, 0xe7, 0xe7, 0xe7, 0xff, 0xff },	// U+009D ()
	{ 0xfc, 0xfc, 0xfc, 0xfc, 0xc0, 0xc0, 0x9c, 0x9c, 0xc0, 0xc0, 0xfc, 0xfc, 0xfc, 0xfc, 0xff, 0xff },	// U+009E ()
	{ 0xc3, 0xc3, 0x99, 0x99, 0x99, 0x99, 0xc9, 0xc9, 0x99, 0x99, 0x99, 0x99, 0xc9, 0xc9, 0xf9, 0xf9 },	// U+009F ()
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x30, 0x30, 0x7c, 0x7c, 0x36, 0x36, 0x7c, 0x7c, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+00A2 (¢)
	{ 0x38, 0x38, 0x6c, 0x6c, 0x0c, 0x0c, 0x1e, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x7e, 0x7e, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x42, 0x42, 0x3c, 0x3c, 0x66, 0x66, 0x3c, 0x3c, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+00A6 (¦)
	{ 0x3c, 0x3c, 0x06, 0x06, 0x3c, 0x3c, 0x66, 0x66, 0x3c, 0x3c, 0x60, 0x60, 0x3c, 0x3c, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x7e, 0x7e, 0x81, 0x81, 0xb9, 0xb9, 0x8d, 0x8d, 0xb9, 0xb9, 0x81, 0x81, 0x7e, 0x7e, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x38, 0x38, 0x24, 0x24, 0x22, 0x22, 0x3c, 0x3c, 0x00, 0x00, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0xcc, 0xcc, 0x66, 0x66, 0x33, 0x33, 0x66, 0x66, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x7f, 0xfe, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x7e, 0x7e, 0x81, 0x81, 0x9d, 0x9d, 0xa5, 0xa5, 0x9d, 0x9d, 0xa5, 0xa5, 0x81, 0x81, 0x7e, 0x7e },	// U+00AE (®)
	{ 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x18, 0x18, 0x18, 0x18, 0x7e, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x7e, 0x7e, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x1e, 0x1e, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x1e, 0x1e, 0x30, 0x30, 0x18, 0x18, 0x30, 0x30, 0x1e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xfe, 0xfe, 0x06, 0x06 },	// U+00B5 (µ)
	{ 0x7c, 0x7c, 0x5e, 0x5e, 0x5e, 0x5e, 0x5c, 0x5c, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x00, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x0c },	// U+00B8 (¸)
	{ 0x0c, 0x0c, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x1c, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x1c, 0x00, 0x00, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x33, 0x33, 0x66, 0x66, 0xcc, 0xcc, 0x66, 0x66, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x02, 0x02, 0x63, 0x63, 0x32, 0x32, 0x1a, 0x1a, 0x0c, 0x4c, 0x46, 0x66, 0x63, 0xf3, 0x40, 0x40 },	// U+00BC (¼)
	{ 0x02, 0x02, 0x63, 0x63, 0x32, 0x32, 0x1a, 0x1a, 0x7c, 0x7c, 0x46, 0x46, 0x23, 0x23, 0x70, 0x70 },	// U+00BD (½)
	{ 0x03, 0x03, 0xc4, 0xc4, 0x66, 0x66, 0x34, 0x34, 0x1b, 0x58, 0x4c, 0x6c, 0x66, 0xf6, 0x43, 0x43 },	// U+00BE (¾)
	{ 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00BF (¿)
	{ 0x0c, 0x0c, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x30, 0x30, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x18, 0x18, 0x66, 0x66, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x8e, 0x8e, 0x71, 0x71, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x66, 0x66, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x18, 0x18, 0x24, 0x24, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0xf8, 0xf8, 0x3c, 0x3c, 0x3c, 0x3c, 0xf6, 0xf6, 0x3e, 0x3e, 0x33, 0x33, 0xf3, 0xf3, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x78, 0x78, 0x0c, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x0c, 0x78, 0x78, 0x30, 0x30, 0x18, 0x18 },	// U+00C7 (Ç)
	{ 0x0c, 0x0c, 0x18, 0x18, 0x7e, 0x7e, 0x06, 0x06, 0x1e, 0x1e, 0x06, 0x06, 0x7e, 0x7e, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x30, 0x30, 0x18, 0x18, 0x7e, 0x7e, 0x06, 0x06, 0x1e, 0x1e, 0x06, 0x06, 0x7e, 0x7e, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x18, 0x18, 0x66, 0x66, 0x7e, 0x7e, 0x06, 0x06, 0x1e, 0x1e, 0x06, 0x06, 0x7e, 0x7e, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x66, 0x66, 0x00, 0x00, 0x7e, 0x7e, 0x06, 0x06, 0x1e, 0x1e, 0x06, 0x06, 0x7e, 0x7e, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x0c, 0x0c, 0x18, 0x18, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x30, 0x30, 0x18, 0x18, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x18, 0x18, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x66, 0x66, 0x00, 0x00, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x1e, 0x1e, 0x36, 0x36, 0x66, 0x66, 0x6f, 0x6f, 0x66, 0x66, 0x36, 0x36, 0x1e, 0x1e, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x8e, 0x8e, 0x73, 0x73, 0x67, 0x67, 0x6f, 0x6f, 0x7b, 0x7b, 0x73, 0x73, 0x63, 0x63, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x0c, 0x0c, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x30, 0x30, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x18, 0x18, 0x66, 0x66, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x8e, 0x8e, 0x71, 0x71, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0xc3, 0xc3, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0xfc, 0xfc, 0x66, 0x66, 0x76, 0x76, 0x7e, 0x7e, 0x6e, 0x6e, 0x66, 0x66, 0x3f, 0x3f, 0x00, 0x00 },	// U+00D8 (Ø)
	{ 0x0c, 0x0c, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x30, 0x30, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x18, 0x18, 0x24, 0x24, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x60, 0x60, 0x10, 0x10, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x03, 0x03, 0x03, 0x03, 0x3f, 0x3f, 0x63, 0x63, 0x3f, 0x3f, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00 },	// U+00DE (Þ)
	{ 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x36, 0x36, 0x66, 0x66, 0x66, 0x66, 0x36, 0x36, 0x06, 0x06 },	// U+00DF (ß)
	{ 0x0c, 0x0c, 0x18, 0x18, 0x3c, 0x3c, 0x60, 0x60, 0x7c, 0x7c, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x30, 0x30, 0x18, 0x18, 0x3c, 0x3c, 0x60, 0x60, 0x7c, 0x7c, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x18, 0x18, 0x66, 0x66, 0x3c, 0x3c, 0x60, 0x60, 0x7c, 0x7c, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x8e, 0x8e, 0x71, 0x71, 0x3c, 0x3c, 0x60, 0x60, 0x7c, 0x7c, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x66, 0x66, 0x00, 0x00, 0x3c, 0x3c, 0x60, 0x60, 0x7c, 0x7c, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x18, 0x18, 0x24, 0x24, 0x3c, 0x3c, 0x60, 0x60, 0x7c, 0x7c, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0xd8, 0xd8, 0xfe, 0xfe, 0x1b, 0x1b, 0xee, 0xee, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3c, 0x3c, 0x18, 0x18 },	// U+00E7 (ç)
	{ 0x0c, 0x0c, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x06, 0x06, 0x3c, 0x3c, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x30, 0x30, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x06, 0x06, 0x3c, 0x3c, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x18, 0x18, 0x66, 0x66, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x06, 0x06, 0x3c, 0x3c, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x66, 0x66, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66, 0x7e, 0x7e, 0x06, 0x06, 0x3c, 0x3c, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x0c, 0x0c, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00 },	// U+00ED (í)
	{ 0x18, 0x18, 0x66, 0x66, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x06, 0x06, 0x3f, 0x3f, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x8e, 0x8e, 0x71, 0x71, 0x00, 0x00, 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x0c, 0x0c, 0x18, 0x18, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x18, 0x18, 0x66, 0x66, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x8e, 0x8e, 0x71, 0x71, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x3c, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x7e, 0x7e, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x40, 0x40, 0x3e, 0x3e, 0x73, 0x73, 0x6b, 0x6b, 0x67, 0x67, 0x3e, 0x3e, 0x01, 0x01 },	// U+00F8 (ø)
	{ 0x0c, 0x0c, 0x18, 0x18, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x18, 0x18, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x7c, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x30, 0x30, 0x18, 0x18, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x0c, 0x0c },	// U+00FD (ý)
	{ 0x06, 0x06, 0x06, 0x06, 0x3e, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x3e, 0x06, 0x06, 0x06, 0x06 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x0c, 0x0c },	// U+00FF (ÿ)
}; // 256

