/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font tewi-bold-11.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char tewib_block1[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x0c, 0x00, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x3f, 0x16, 0x3f, 0x16, 0x00, 0x00, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x00, 0x04, 0x0e, 0x17, 0x07, 0x0e, 0x14, 0x17, 0x0e, 0x04, 0x00, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x1e, 0x1d, 0x0b, 0x04, 0x1a, 0x17, 0x0f, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x00, 0x06, 0x0b, 0x07, 0x02, 0x1f, 0x0b, 0x1e, 0x00, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x00, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x00, 0x00 },	// U+0028 (()
	{ 0x00, 0x00, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x00, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1f, 0x0e, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0c, 0x06, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x03, 0x03, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x00, 0x0e, 0x13, 0x1b, 0x1f, 0x17, 0x13, 0x0e, 0x00, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x18, 0x0c, 0x06, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x18, 0x0c, 0x18, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0e, 0x0d, 0x1f, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x00, 0x1f, 0x03, 0x0f, 0x18, 0x18, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x00, 0x0e, 0x03, 0x0f, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x0c, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x0e, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00, 0x0e, 0x0e, 0x0c, 0x06, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x18, 0x0c, 0x06, 0x03, 0x06, 0x0c, 0x18, 0x00, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x03, 0x06, 0x0c, 0x18, 0x0c, 0x06, 0x03, 0x00, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x18, 0x0c, 0x06, 0x00, 0x06, 0x00, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x00, 0x0e, 0x13, 0x1f, 0x17, 0x1f, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x0f, 0x1b, 0x1b, 0x0f, 0x00, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x03, 0x03, 0x03, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0f, 0x00, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x00, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x00, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x00, 0x0e, 0x13, 0x03, 0x1b, 0x13, 0x13, 0x0e, 0x00, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x00, 0x1b, 0x0f, 0x07, 0x03, 0x07, 0x0f, 0x1b, 0x00, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x1f, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x17, 0x17, 0x1f, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x0f, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x18, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x0f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x03, 0x0e, 0x18, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x00, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1f, 0x1f, 0x1f, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x0e, 0x04, 0x0e, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x00, 0x37, 0x37, 0x16, 0x1e, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x00, 0x1f, 0x18, 0x1c, 0x0e, 0x07, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x00, 0x1e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1e, 0x00, 0x00 },	// U+005B ([)
	{ 0x00, 0x00, 0x03, 0x03, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x00 },	// U+005C (\)
	{ 0x00, 0x00, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1e, 0x00, 0x00 },	// U+005D (])
	{ 0x00, 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00 },	// U+005F (_)
	{ 0x00, 0x00, 0x03, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x0f, 0x1b, 0x1b, 0x1b, 0x0f, 0x00, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x03, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x1e, 0x1b, 0x1b, 0x1b, 0x1e, 0x00, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x00, 0x1c, 0x06, 0x06, 0x0f, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00 },	// U+0067 (g)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x0f, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x00, 0x06, 0x00, 0x07, 0x06, 0x06, 0x06, 0x0e, 0x00, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x07, 0x00 },	// U+006A (j)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x1b, 0x0f, 0x07, 0x0f, 0x1b, 0x00, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x00, 0x07, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0e, 0x00, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x2b, 0x2b, 0x2b, 0x2b, 0x00, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x1b, 0x0f, 0x03, 0x03, 0x00 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x18, 0x00 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1b, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x07, 0x0e, 0x1c, 0x0f, 0x00, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x1f, 0x06, 0x06, 0x06, 0x1c, 0x00, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x0e, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x2b, 0x2b, 0x2b, 0x16, 0x00, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x0e, 0x04, 0x0e, 0x1b, 0x00, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00 },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1c, 0x0e, 0x07, 0x1f, 0x00, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x00, 0x18, 0x0c, 0x0c, 0x0c, 0x07, 0x0c, 0x0c, 0x0c, 0x18, 0x00, 0x00 },	// U+007B ({)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00 },	// U+007C (|)
	{ 0x00, 0x00, 0x03, 0x06, 0x06, 0x06, 0x1c, 0x06, 0x06, 0x06, 0x03, 0x00, 0x00 },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
}; // 95

static const unsigned char tewib_block2[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x17, 0x07, 0x17, 0x0e, 0x04, 0x00, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x0c, 0x06, 0x06, 0x0f, 0x06, 0x06, 0x16, 0x0f, 0x00, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x0e, 0x0a, 0x0e, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x0e, 0x1f, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x0e, 0x13, 0x16, 0x0d, 0x1b, 0x16, 0x1c, 0x09, 0x13, 0x0e, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x0f, 0x10, 0x16, 0x13, 0x13, 0x16, 0x10, 0x0f, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x00, 0x00, 0x1c, 0x16, 0x1e, 0x14, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x1b, 0x1b, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x00, 0x00, 0x00, 0x0f, 0x10, 0x17, 0x1b, 0x17, 0x1b, 0x10, 0x0f, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x0c, 0x16, 0x16, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x00, 0x3f, 0x00, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x00, 0x00, 0x06, 0x0c, 0x04, 0x06, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x00, 0x00, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x00, 0x00, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x0b, 0x0b, 0x17, 0x03, 0x03, 0x00 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x3e, 0x17, 0x17, 0x17, 0x1e, 0x14, 0x14, 0x14, 0x34, 0x00, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x0c },	// U+00B8 (¸)
	{ 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x00, 0x00, 0x06, 0x0b, 0x0b, 0x06, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x36, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x00, 0x00, 0x03, 0x12, 0x1a, 0x0c, 0x16, 0x1b, 0x1d, 0x10, 0x00, 0x00, 0x00 },	// U+00BC (¼)
	{ 0x00, 0x03, 0x12, 0x1a, 0x0c, 0x06, 0x0f, 0x11, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+00BD (½)
	{ 0x00, 0x03, 0x02, 0x13, 0x1a, 0x0d, 0x16, 0x1b, 0x1d, 0x10, 0x00, 0x00, 0x00 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x06, 0x03, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00BF (¿)
	{ 0x00, 0x06, 0x0c, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x00, 0x0c, 0x06, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x00, 0x16, 0x0d, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x04, 0x0a, 0x04, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x00, 0x1e, 0x0b, 0x0b, 0x1f, 0x0b, 0x0b, 0x1b, 0x00, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x03, 0x03, 0x03, 0x1b, 0x0e, 0x0c, 0x06, 0x00 },	// U+00C7 (Ç)
	{ 0x00, 0x02, 0x04, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x00, 0x08, 0x04, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x00, 0x04, 0x0a, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x00, 0x0a, 0x00, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x00, 0x0c, 0x18, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x00, 0x0c, 0x06, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x00, 0x04, 0x0a, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x00, 0x0a, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x00, 0x0e, 0x16, 0x16, 0x1f, 0x16, 0x16, 0x0e, 0x00, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x00, 0x16, 0x0d, 0x13, 0x13, 0x13, 0x17, 0x17, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x00, 0x02, 0x04, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x18, 0x0c, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x00, 0x16, 0x0d, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x0e, 0x04, 0x0e, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x00, 0x10, 0x0e, 0x1b, 0x1f, 0x1f, 0x1f, 0x1b, 0x0e, 0x01, 0x00, 0x00 },	// U+00D8 (Ø)
	{ 0x00, 0x06, 0x0c, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x0c, 0x06, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x00, 0x04, 0x0a, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x00, 0x0a, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x00, 0x18, 0x0c, 0x37, 0x37, 0x16, 0x1e, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x00, 0x0f, 0x06, 0x0e, 0x16, 0x16, 0x16, 0x0e, 0x06, 0x0f, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x0f, 0x1b, 0x1b, 0x1b, 0x0d, 0x00, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x04, 0x0a, 0x04, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2b, 0x3b, 0x0b, 0x3e, 0x00, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x03, 0x03, 0x1e, 0x04, 0x02, 0x00 },	// U+00E7 (ç)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x00, 0x06, 0x0c, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x00, 0x0c, 0x1e, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x00, 0x1b, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x0b, 0x06, 0x0f, 0x0c, 0x1e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0d, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x06, 0x0c, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x0c, 0x06, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x3f, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1b, 0x1f, 0x1b, 0x0f, 0x00, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x00, 0x06, 0x0c, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x00, 0x0c, 0x06, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00 },	// U+00FD (ý)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x0f, 0x1b, 0x1b, 0x1b, 0x0f, 0x03, 0x03, 0x00 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00 },	// U+00FF (ÿ)
	{ 0x00, 0x1f, 0x00, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+0101 (ā)
	{ 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x30, 0x00, 0x00 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x20, 0x00, 0x00 },	// U+0105 (ą)
	{ 0x00, 0x08, 0x04, 0x0e, 0x1b, 0x03, 0x03, 0x03, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x1b, 0x03, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x1b, 0x03, 0x03, 0x03, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x1b, 0x03, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x1b, 0x03, 0x03, 0x03, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0e, 0x1b, 0x03, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+010B (ċ)
	{ 0x00, 0x0a, 0x04, 0x0e, 0x1b, 0x03, 0x03, 0x03, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x1b, 0x03, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+010D (č)
	{ 0x00, 0x0a, 0x04, 0x0f, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0f, 0x00, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x00, 0x00, 0x20, 0x38, 0x18, 0x1e, 0x1b, 0x1b, 0x1b, 0x1e, 0x00, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x00, 0x0e, 0x16, 0x16, 0x1f, 0x16, 0x16, 0x0e, 0x00, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x18, 0x1e, 0x1b, 0x1b, 0x1b, 0x1e, 0x00, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x00, 0x0e, 0x00, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+0113 (ē)
	{ 0x11, 0x0e, 0x00, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+0114 (Ĕ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+0115 (ĕ)
	{ 0x00, 0x0c, 0x00, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x00, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x30, 0x00, 0x00 },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x0c, 0x18, 0x00 },	// U+0119 (ę)
	{ 0x00, 0x0a, 0x04, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+011B (ě)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x13, 0x03, 0x1b, 0x13, 0x13, 0x0e, 0x00, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00 },	// U+011D (ĝ)
	{ 0x13, 0x0e, 0x00, 0x0e, 0x13, 0x03, 0x1b, 0x13, 0x13, 0x0e, 0x00, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x00, 0x13, 0x0e, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00 },	// U+011F (ğ)
	{ 0x00, 0x0c, 0x00, 0x0e, 0x13, 0x03, 0x1b, 0x13, 0x13, 0x0e, 0x00, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00 },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x13, 0x03, 0x1b, 0x13, 0x13, 0x0e, 0x0c, 0x06, 0x00 },	// U+0122 (Ģ)
	{ 0x00, 0x00, 0x0c, 0x06, 0x00, 0x1e, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00 },	// U+0123 (ģ)
	{ 0x00, 0x04, 0x0a, 0x1b, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x00, 0x04, 0x0a, 0x03, 0x03, 0x0f, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x00, 0x36, 0x3f, 0x36, 0x3e, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x06, 0x0e, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0x16, 0x0d, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x00, 0x1e, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+012B (ī)
	{ 0x13, 0x0e, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+012C (Ĭ)
	{ 0x00, 0x00, 0x13, 0x0e, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+012D (ĭ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x06, 0x0c, 0x00 },	// U+012E (Į)
	{ 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1c, 0x06, 0x0c, 0x00 },	// U+012F (į)
	{ 0x00, 0x0c, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+0131 (ı)
}; // 146

static const unsigned char tewib_block3[][13] = {
	{ 0x00, 0x04, 0x0a, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x07, 0x00 },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x00, 0x1b, 0x0f, 0x07, 0x03, 0x07, 0x0f, 0x1b, 0x0c, 0x06, 0x00 },	// U+0136 (Ķ)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x0b, 0x07, 0x07, 0x0f, 0x1b, 0x0c, 0x06, 0x00 },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x07, 0x03, 0x07, 0x0b, 0x00, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x00, 0x18, 0x0c, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x00, 0x18, 0x0c, 0x07, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0e, 0x00, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1f, 0x06, 0x03, 0x00 },	// U+013B (Ļ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1c, 0x18, 0x0c, 0x00 },	// U+013C (ļ)
	{ 0x00, 0x18, 0x10, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x00, 0x30, 0x20, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+013E (ľ)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x1b, 0x03, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+013F (Ŀ)
	{ 0x00, 0x00, 0x00, 0x07, 0x06, 0x06, 0x36, 0x06, 0x06, 0x0e, 0x00, 0x00, 0x00 },	// U+0140 (ŀ)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x0e, 0x07, 0x06, 0x06, 0x3e, 0x00, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0c, 0x1c, 0x0c, 0x0e, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x00, 0x18, 0x0c, 0x13, 0x13, 0x13, 0x17, 0x17, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x0d, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x13, 0x17, 0x17, 0x1b, 0x1b, 0x0c, 0x06, 0x00 },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1b, 0x1b, 0x1b, 0x1b, 0x0c, 0x06, 0x00 },	// U+0146 (ņ)
	{ 0x00, 0x0a, 0x04, 0x13, 0x13, 0x13, 0x17, 0x17, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0d, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0148 (ň)
	{ 0x00, 0x00, 0x03, 0x02, 0x00, 0x0d, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0149 (ŉ)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x13, 0x17, 0x17, 0x1b, 0x1b, 0x0c, 0x06, 0x00 },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1b, 0x1b, 0x1b, 0x1b, 0x0c, 0x06, 0x00 },	// U+014B (ŋ)
	{ 0x00, 0x1f, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+014D (ō)
	{ 0x13, 0x0e, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+014E (Ŏ)
	{ 0x00, 0x00, 0x13, 0x0e, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+014F (ŏ)
	{ 0x00, 0x36, 0x1b, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x00, 0x36, 0x1b, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x00, 0x3e, 0x0b, 0x0b, 0x1b, 0x0b, 0x0b, 0x3e, 0x00, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2b, 0x3b, 0x0b, 0x3e, 0x00, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x00, 0x0c, 0x06, 0x0f, 0x1b, 0x1b, 0x0f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x00, 0x0c, 0x06, 0x00, 0x0d, 0x1b, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x0f, 0x1b, 0x1b, 0x1b, 0x0c, 0x06, 0x00 },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1b, 0x03, 0x03, 0x03, 0x0c, 0x06, 0x00 },	// U+0157 (ŗ)
	{ 0x00, 0x0a, 0x04, 0x0f, 0x1b, 0x1b, 0x0f, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0d, 0x1b, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x00, 0x06, 0x03, 0x0e, 0x1b, 0x03, 0x0e, 0x18, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x00, 0x0c, 0x06, 0x00, 0x1e, 0x03, 0x0e, 0x18, 0x0f, 0x00, 0x00, 0x00 },	// U+015B (ś)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x13, 0x03, 0x0e, 0x18, 0x19, 0x0e, 0x00, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1e, 0x03, 0x0e, 0x18, 0x0f, 0x00, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x03, 0x0e, 0x18, 0x1b, 0x0e, 0x0c, 0x06, 0x00 },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x03, 0x0e, 0x18, 0x0f, 0x0c, 0x06, 0x00 },	// U+015F (ş)
	{ 0x00, 0x0a, 0x04, 0x0e, 0x13, 0x03, 0x0e, 0x18, 0x19, 0x0e, 0x00, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1e, 0x03, 0x0e, 0x18, 0x0f, 0x00, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0x00, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x0c, 0x00 },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x1e, 0x0c, 0x0c, 0x0c, 0x18, 0x0c, 0x06, 0x00 },	// U+0163 (ţ)
	{ 0x00, 0x0a, 0x04, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x00, 0x30, 0x20, 0x0c, 0x0c, 0x1e, 0x0c, 0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0x00, 0x3f, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x1e, 0x0c, 0x1e, 0x0c, 0x18, 0x00, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0x16, 0x0d, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x00, 0x1f, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+016B (ū)
	{ 0x11, 0x0e, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x00, 0x04, 0x0a, 0x1f, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+016F (ů)
	{ 0x00, 0x36, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x00, 0x36, 0x1b, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x06, 0x0c, 0x00 },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x0c, 0x18, 0x00 },	// U+0173 (ų)
	{ 0x00, 0x04, 0x0a, 0x1b, 0x1b, 0x1f, 0x1f, 0x1f, 0x1b, 0x11, 0x00, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x23, 0x2b, 0x2b, 0x2b, 0x16, 0x00, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x00, 0x04, 0x0a, 0x37, 0x16, 0x16, 0x1e, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00 },	// U+0177 (ŷ)
	{ 0x00, 0x0a, 0x00, 0x37, 0x16, 0x16, 0x1e, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x00, 0x08, 0x04, 0x1f, 0x18, 0x0c, 0x06, 0x06, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1f, 0x18, 0x0e, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+017A (ź)
	{ 0x00, 0x04, 0x00, 0x1f, 0x18, 0x0c, 0x06, 0x06, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x18, 0x0e, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+017C (ż)
	{ 0x00, 0x0a, 0x04, 0x1f, 0x18, 0x0c, 0x06, 0x06, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1f, 0x18, 0x0e, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+017E (ž)
	{ 0x00, 0x00, 0x00, 0x18, 0x0c, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+017F (ſ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x06, 0x0e, 0x16, 0x16, 0x16, 0x0e, 0x00, 0x00, 0x00 },	// U+0180 (ƀ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x16, 0x16, 0x0e, 0x16, 0x16, 0x0e, 0x00, 0x00, 0x00 },	// U+0181 (Ɓ)
	{ 0x00, 0x00, 0x1f, 0x13, 0x03, 0x1f, 0x33, 0x33, 0x33, 0x1f, 0x00, 0x00, 0x00 },	// U+0182 (Ƃ)
	{ 0x00, 0x00, 0x0f, 0x0b, 0x03, 0x0f, 0x1b, 0x1b, 0x1b, 0x0f, 0x00, 0x00, 0x00 },	// U+0183 (ƃ)
	{ 0x00, 0x00, 0x06, 0x07, 0x06, 0x1e, 0x36, 0x36, 0x36, 0x1e, 0x00, 0x00, 0x00 },	// U+0184 (Ƅ)
	{ 0x00, 0x00, 0x0c, 0x0e, 0x0c, 0x1c, 0x2c, 0x2c, 0x2c, 0x1c, 0x00, 0x00, 0x00 },	// U+0185 (ƅ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x18, 0x18, 0x18, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0186 (Ɔ)
	{ 0x00, 0x00, 0x00, 0x2e, 0x1b, 0x03, 0x03, 0x03, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0187 (Ƈ)
	{ 0x00, 0x00, 0x00, 0x30, 0x20, 0x0e, 0x1b, 0x03, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+0188 (ƈ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x16, 0x16, 0x1f, 0x16, 0x16, 0x0e, 0x00, 0x00, 0x00 },	// U+0189 (Ɖ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x16, 0x16, 0x16, 0x16, 0x16, 0x0e, 0x00, 0x00, 0x00 },	// U+018A (Ɗ)
	{ 0x00, 0x00, 0x3e, 0x32, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x3e, 0x00, 0x00, 0x00 },	// U+018B (Ƌ)
	{ 0x00, 0x00, 0x1e, 0x1a, 0x18, 0x1e, 0x1b, 0x1b, 0x1b, 0x1e, 0x00, 0x00, 0x00 },	// U+018C (ƌ)
	{ 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x06, 0x0c, 0x1f, 0x00, 0x00, 0x00 },	// U+018D (ƍ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x19, 0x19, 0x1e, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00 },	// U+018E (Ǝ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x18, 0x1f, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+018F (Ə)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x03, 0x0e, 0x03, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+0190 (Ɛ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x06, 0x06, 0x1e, 0x06, 0x06, 0x06, 0x06, 0x03, 0x00 },	// U+0191 (Ƒ)
	{ 0x00, 0x38, 0x0c, 0x0c, 0x0c, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x07, 0x00, 0x00 },	// U+0192 (ƒ)
	{ 0x00, 0x00, 0x00, 0x16, 0x2b, 0x03, 0x1b, 0x13, 0x13, 0x0e, 0x00, 0x00, 0x00 },	// U+0193 (Ɠ)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x13, 0x0e, 0x0e, 0x04, 0x0e, 0x0e, 0x04, 0x00 },	// U+0194 (Ɣ)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x07, 0x2f, 0x2b, 0x3b, 0x13, 0x00, 0x00, 0x00 },	// U+0195 (ƕ)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x16, 0x1e, 0x0c, 0x00, 0x00, 0x00 },	// U+0196 (Ɩ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x1e, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+0197 (Ɨ)
	{ 0x00, 0x00, 0x00, 0x1b, 0x2f, 0x07, 0x03, 0x07, 0x0f, 0x1b, 0x00, 0x00, 0x00 },	// U+0198 (Ƙ)
	{ 0x00, 0x00, 0x0e, 0x03, 0x03, 0x1b, 0x0f, 0x07, 0x0f, 0x1b, 0x00, 0x00, 0x00 },	// U+0199 (ƙ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x1e, 0x0c, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+019A (ƚ)
	{ 0x00, 0x00, 0x06, 0x06, 0x0f, 0x0c, 0x1e, 0x1e, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+019B (ƛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x2b, 0x2b, 0x2b, 0x3e, 0x00, 0x00, 0x00 },	// U+019C (Ɯ)
	{ 0x00, 0x00, 0x00, 0x26, 0x26, 0x2e, 0x2e, 0x3e, 0x36, 0x36, 0x01, 0x00, 0x00 },	// U+019D (Ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1b, 0x1b, 0x1b, 0x1b, 0x18, 0x18, 0x0c },	// U+019E (ƞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1f, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+019F (Ɵ)
	{ 0x00, 0x20, 0x20, 0x2e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+01A0 (Ơ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+01A1 (ơ)
	{ 0x00, 0x00, 0x00, 0x16, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x26, 0x00, 0x00, 0x00 },	// U+01A2 (Ƣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x2b, 0x2b, 0x2b, 0x26, 0x00, 0x00, 0x00 },	// U+01A3 (ƣ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x36, 0x36, 0x1e, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+01A4 (Ƥ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x36, 0x0f, 0x1b, 0x1b, 0x1b, 0x0f, 0x03, 0x03, 0x00 },	// U+01A5 (ƥ)
	{ 0x00, 0x00, 0x03, 0x03, 0x0f, 0x1b, 0x1b, 0x0f, 0x0f, 0x1b, 0x10, 0x00, 0x00 },	// U+01A6 (Ʀ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x18, 0x0e, 0x03, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+01A7 (Ƨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x18, 0x0e, 0x03, 0x1e, 0x00, 0x00, 0x00 },	// U+01A8 (ƨ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x03, 0x06, 0x0c, 0x06, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+01A9 (Ʃ)
	{ 0x00, 0x00, 0x02, 0x0d, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x00, 0x00 },	// U+01AA (ƪ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x1e, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x18, 0x00 },	// U+01AB (ƫ)
	{ 0x00, 0x00, 0x00, 0x3f, 0x2c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+01AC (Ƭ)
	{ 0x00, 0x00, 0x18, 0x0c, 0x0c, 0x1e, 0x0c, 0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00 },	// U+01AD (ƭ)
	{ 0x00, 0x00, 0x00, 0x3f, 0x2d, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+01AE (Ʈ)
	{ 0x00, 0x20, 0x20, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+01AF (Ư)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00, 0x00 },	// U+01B0 (ư)
	{ 0x00, 0x00, 0x00, 0x1f, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+01B1 (Ʊ)
	{ 0x00, 0x00, 0x0c, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+01B2 (Ʋ)
}; // 127

