/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font tewi-medium-11.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char tewi_block1[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x05, 0x0e, 0x14, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x12, 0x15, 0x0a, 0x04, 0x0a, 0x15, 0x09, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x05, 0x02, 0x15, 0x09, 0x16, 0x00, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x00, 0x08, 0x04, 0x04, 0x02, 0x02, 0x02, 0x04, 0x04, 0x08, 0x00, 0x00 },	// U+0028 (()
	{ 0x00, 0x00, 0x02, 0x04, 0x04, 0x08, 0x08, 0x08, 0x04, 0x04, 0x02, 0x00, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x15, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x04, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x19, 0x15, 0x13, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x00, 0x04, 0x06, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x09, 0x1f, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x0f, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x00, 0x0e, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x08, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0e, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x04, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x08, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1d, 0x15, 0x1d, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x00, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x10, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x00, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x00, 0x00 },	// U+005B ([)
	{ 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x00 },	// U+005C (\)
	{ 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00, 0x00 },	// U+005D (])
	{ 0x00, 0x00, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00 },	// U+005F (_)
	{ 0x00, 0x00, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x00, 0x0c, 0x02, 0x02, 0x07, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+0067 (g)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00 },	// U+006A (j)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x09, 0x05, 0x07, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x00 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x00, 0x18, 0x04, 0x04, 0x04, 0x03, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00 },	// U+007B ({)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+007C (|)
	{ 0x00, 0x00, 0x03, 0x04, 0x04, 0x04, 0x18, 0x04, 0x04, 0x04, 0x03, 0x00, 0x00 },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
}; // 95

static const unsigned char tewi_block2[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x05, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x0c, 0x12, 0x02, 0x07, 0x02, 0x02, 0x12, 0x0d, 0x00, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x0a, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x1f, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x00, 0x0e, 0x11, 0x12, 0x05, 0x09, 0x12, 0x14, 0x09, 0x11, 0x0e, 0x00 },	// U+00A7 (§)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x0f, 0x10, 0x16, 0x11, 0x11, 0x16, 0x10, 0x0f, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x00, 0x00, 0x1c, 0x12, 0x1a, 0x14, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x09, 0x09, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+00AC (¬)
}; // 12

static const unsigned char tewi_block3[][13] = {
	{ 0x00, 0x00, 0x00, 0x0f, 0x10, 0x13, 0x15, 0x13, 0x15, 0x10, 0x0f, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x00, 0x00, 0x06, 0x08, 0x04, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x00, 0x00, 0x06, 0x08, 0x04, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x00, 0x00, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x09, 0x17, 0x01, 0x01, 0x00 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x3e, 0x17, 0x17, 0x17, 0x1e, 0x14, 0x14, 0x14, 0x34, 0x00, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x04 },	// U+00B8 (¸)
	{ 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x00, 0x00, 0x00, 0x03, 0x12, 0x0a, 0x14, 0x1a, 0x1d, 0x10, 0x00, 0x00, 0x00 },	// U+00BC (¼)
	{ 0x00, 0x00, 0x00, 0x03, 0x12, 0x0a, 0x0c, 0x12, 0x09, 0x1c, 0x00, 0x00, 0x00 },	// U+00BD (½)
	{ 0x00, 0x00, 0x01, 0x02, 0x13, 0x0a, 0x15, 0x1a, 0x1d, 0x10, 0x00, 0x00, 0x00 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x02, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00BF (¿)
	{ 0x00, 0x02, 0x04, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x00, 0x08, 0x04, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x00, 0x16, 0x0d, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x00, 0x1e, 0x05, 0x05, 0x0f, 0x05, 0x05, 0x1d, 0x00, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x04, 0x02, 0x00 },	// U+00C7 (Ç)
	{ 0x00, 0x02, 0x04, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x00, 0x08, 0x04, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x00, 0x04, 0x0a, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x00, 0x0a, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x00, 0x04, 0x08, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x00, 0x04, 0x02, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x17, 0x12, 0x12, 0x0e, 0x00, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x00, 0x16, 0x0d, 0x11, 0x13, 0x15, 0x19, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x00, 0x02, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x00, 0x08, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x00, 0x16, 0x0d, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x00, 0x10, 0x0e, 0x19, 0x15, 0x15, 0x15, 0x13, 0x0e, 0x01, 0x00, 0x00 },	// U+00D8 (Ø)
	{ 0x00, 0x02, 0x04, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x00, 0x08, 0x04, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x00, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x00, 0x08, 0x04, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x00, 0x07, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x07, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x13, 0x0d, 0x00, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x04, 0x0a, 0x04, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x1d, 0x05, 0x1e, 0x00, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x1e, 0x04, 0x02, 0x00 },	// U+00E7 (ç)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x0a, 0x04, 0x0a, 0x08, 0x1e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x19, 0x15, 0x13, 0x0f, 0x00, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+00FD (ý)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+00FF (ÿ)
	{ 0x00, 0x1f, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0101 (ā)
	{ 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x20, 0x00, 0x00 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x20, 0x00, 0x00 },	// U+0105 (ą)
	{ 0x00, 0x08, 0x04, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+010B (ċ)
	{ 0x00, 0x0a, 0x04, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+010D (č)
	{ 0x00, 0x0a, 0x04, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x00, 0x00, 0x20, 0x28, 0x18, 0x0e, 0x09, 0x09, 0x09, 0x0e, 0x00, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x2f, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x00, 0x00, 0x38, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x00, 0x0e, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0113 (ē)
	{ 0x00, 0x11, 0x0e, 0x00, 0x1f, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0114 (Ĕ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0115 (ĕ)
	{ 0x00, 0x04, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x20, 0x00, 0x00 },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x08, 0x10, 0x00 },	// U+0119 (ę)
	{ 0x00, 0x0a, 0x04, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+011B (ě)
	{ 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+011D (ĝ)
	{ 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+011F (ğ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x11, 0x0e, 0x04, 0x02, 0x00 },	// U+0122 (Ģ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+0123 (ģ)
	{ 0x00, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x00, 0x04, 0x0a, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1f, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x00, 0x00, 0x07, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0x00, 0x16, 0x0d, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+012B (ī)
	{ 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+012C (Ĭ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+012D (ĭ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x02, 0x04, 0x00 },	// U+012E (Į)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x02, 0x04, 0x00 },	// U+012F (į)
	{ 0x00, 0x04, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+0131 (ı)
	{ 0x00, 0x00, 0x00, 0x27, 0x22, 0x22, 0x22, 0x22, 0x2a, 0x17, 0x00, 0x00, 0x00 },	// U+0132 (Ĳ)
	{ 0x00, 0x00, 0x00, 0x12, 0x00, 0x1b, 0x12, 0x12, 0x12, 0x16, 0x10, 0x0c, 0x00 },	// U+0133 (ĳ)
	{ 0x00, 0x04, 0x0a, 0x00, 0x10, 0x10, 0x10, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00 },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x04, 0x02, 0x00 },	// U+0136 (Ķ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x09, 0x05, 0x07, 0x09, 0x11, 0x04, 0x02, 0x00 },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x03, 0x05, 0x09, 0x00, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x00, 0x08, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x00, 0x10, 0x08, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x04, 0x02, 0x00 },	// U+013B (Ļ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x08, 0x04, 0x00 },	// U+013C (ļ)
	{ 0x00, 0x00, 0x0c, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x00, 0x18, 0x10, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+013E (ľ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+013F (Ŀ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x14, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+0140 (ŀ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x05, 0x03, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x0c, 0x04, 0x06, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x00, 0x08, 0x04, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x00, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x1d, 0x04, 0x02, 0x00 },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x15, 0x04, 0x02, 0x00 },	// U+0146 (ņ)
	{ 0x00, 0x0a, 0x04, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x00, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0148 (ň)
	{ 0x00, 0x00, 0x01, 0x01, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0149 (ŉ)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x10, 0x0c, 0x00 },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x0c, 0x00 },	// U+014B (ŋ)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+014D (ō)
	{ 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+014E (Ŏ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+014F (ŏ)
	{ 0x00, 0x14, 0x0a, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x00, 0x14, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x00, 0x1a, 0x05, 0x05, 0x0d, 0x05, 0x05, 0x1a, 0x00, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x1d, 0x05, 0x1a, 0x00, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x00, 0x08, 0x04, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x15, 0x04, 0x02, 0x00 },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x05, 0x04, 0x02, 0x00 },	// U+0157 (ŗ)
	{ 0x00, 0x0a, 0x04, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x00, 0x08, 0x04, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+015B (ś)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x04, 0x04, 0x00 },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x04, 0x04, 0x00 },	// U+015F (ş)
	{ 0x00, 0x0a, 0x04, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x00 },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x18, 0x08, 0x08, 0x00 },	// U+0163 (ţ)
	{ 0x00, 0x0a, 0x04, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x00, 0x30, 0x20, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x18, 0x00, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0x00, 0x16, 0x0d, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+016B (ū)
	{ 0x00, 0x11, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+016F (ů)
	{ 0x00, 0x14, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x00, 0x14, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x08, 0x00 },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+0173 (ų)
	{ 0x00, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x15, 0x1b, 0x11, 0x00, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x00, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+0177 (ŷ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x00, 0x08, 0x04, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+017A (ź)
	{ 0x00, 0x04, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+017C (ż)
	{ 0x00, 0x0a, 0x04, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+017E (ž)
	{ 0x00, 0x00, 0x00, 0x18, 0x04, 0x06, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+017F (ſ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0180 (ƀ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x22, 0x22, 0x1e, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0181 (Ɓ)
	{ 0x00, 0x00, 0x1f, 0x11, 0x01, 0x1f, 0x21, 0x21, 0x21, 0x1f, 0x00, 0x00, 0x00 },	// U+0182 (Ƃ)
	{ 0x00, 0x00, 0x0f, 0x09, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0183 (ƃ)
	{ 0x00, 0x00, 0x02, 0x03, 0x03, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0184 (Ƅ)
	{ 0x00, 0x00, 0x02, 0x03, 0x03, 0x0e, 0x12, 0x12, 0x12, 0x0e, 0x00, 0x00, 0x00 },	// U+0185 (ƅ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0186 (Ɔ)
	{ 0x00, 0x00, 0x00, 0x2e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0187 (Ƈ)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x0e, 0x11, 0x01, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0188 (ƈ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x2f, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0189 (Ɖ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x25, 0x24, 0x24, 0x24, 0x24, 0x1c, 0x00, 0x00, 0x00 },	// U+018A (Ɗ)
	{ 0x00, 0x00, 0x3e, 0x22, 0x20, 0x3e, 0x21, 0x21, 0x21, 0x3e, 0x00, 0x00, 0x00 },	// U+018B (Ƌ)
	{ 0x00, 0x00, 0x1e, 0x12, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00, 0x00 },	// U+018C (ƌ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x08, 0x1f, 0x00, 0x00, 0x00 },	// U+018D (ƍ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x1f, 0x00, 0x00, 0x00 },	// U+018E (Ǝ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+018F (Ə)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0190 (Ɛ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x01, 0x00 },	// U+0191 (Ƒ)
	{ 0x00, 0x18, 0x04, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00, 0x00 },	// U+0192 (ƒ)
	{ 0x00, 0x00, 0x00, 0x16, 0x29, 0x01, 0x19, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0193 (Ɠ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x0a, 0x0a, 0x04, 0x00 },	// U+0194 (Ɣ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x13, 0x15, 0x15, 0x09, 0x00, 0x00, 0x00 },	// U+0195 (ƕ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+0196 (Ɩ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+0197 (Ɨ)
	{ 0x00, 0x00, 0x00, 0x11, 0x29, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+0198 (Ƙ)
	{ 0x00, 0x00, 0x06, 0x01, 0x01, 0x09, 0x05, 0x07, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+0199 (ƙ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+019A (ƚ)
	{ 0x00, 0x00, 0x02, 0x02, 0x07, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+019B (ƛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x1e, 0x00, 0x00, 0x00 },	// U+019C (Ɯ)
	{ 0x00, 0x00, 0x00, 0x26, 0x26, 0x2a, 0x2a, 0x2a, 0x32, 0x32, 0x01, 0x00, 0x00 },	// U+019D (Ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x08, 0x00 },	// U+019E (ƞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+019F (Ɵ)
	{ 0x00, 0x20, 0x20, 0x2e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01A0 (Ơ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01A1 (ơ)
	{ 0x00, 0x00, 0x00, 0x16, 0x29, 0x29, 0x29, 0x29, 0x29, 0x26, 0x00, 0x00, 0x00 },	// U+01A2 (Ƣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x29, 0x29, 0x29, 0x26, 0x00, 0x00, 0x00 },	// U+01A3 (ƣ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x25, 0x24, 0x1c, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+01A4 (Ƥ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+01A5 (ƥ)
	{ 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x0f, 0x05, 0x09, 0x10, 0x00, 0x00 },	// U+01A6 (Ʀ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0e, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01A7 (Ƨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x0e, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+01A8 (ƨ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x02, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+01A9 (Ʃ)
	{ 0x00, 0x00, 0x02, 0x05, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00 },	// U+01AA (ƪ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x0f, 0x02, 0x02, 0x02, 0x0c, 0x10, 0x0c, 0x00 },	// U+01AB (ƫ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+01AC (Ƭ)
	{ 0x00, 0x00, 0x18, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00 },	// U+01AD (ƭ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x15, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+01AE (Ʈ)
	{ 0x00, 0x20, 0x20, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01AF (Ư)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+01B0 (ư)
	{ 0x00, 0x00, 0x00, 0x1b, 0x0a, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01B1 (Ʊ)
	{ 0x00, 0x00, 0x00, 0x09, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01B2 (Ʋ)
	{ 0x00, 0x00, 0x20, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+01B3 (Ƴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+01B4 (ƴ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x1f, 0x02, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+01B5 (Ƶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x1f, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+01B6 (ƶ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x08, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01B7 (Ʒ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x02, 0x04, 0x02, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01B8 (Ƹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x04, 0x02, 0x01, 0x11, 0x0e, 0x00 },	// U+01B9 (ƹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x08, 0x10, 0x0e, 0x21, 0x1e },	// U+01BA (ƺ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x1f, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+01BB (ƻ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x02, 0x0e, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01BC (Ƽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01BD (ƽ)
	{ 0x00, 0x00, 0x04, 0x0e, 0x04, 0x08, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+01BE (ƾ)
	{ 0x00, 0x00, 0x00, 0x05, 0x0b, 0x09, 0x05, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+01BF (ƿ)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+01C0 (ǀ)
	{ 0x00, 0x00, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x00 },	// U+01C1 (ǁ)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x00 },	// U+01C2 (ǂ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+01C3 (ǃ)
	{ 0x00, 0x28, 0x10, 0x03, 0x3d, 0x25, 0x15, 0x15, 0x0d, 0x3b, 0x00, 0x00, 0x00 },	// U+01C4 (Ǆ)
	{ 0x00, 0x00, 0x28, 0x13, 0x05, 0x3d, 0x25, 0x15, 0x0d, 0x3b, 0x00, 0x00, 0x00 },	// U+01C5 (ǅ)
	{ 0x00, 0x04, 0x2c, 0x14, 0x04, 0x3e, 0x25, 0x15, 0x0d, 0x3e, 0x00, 0x00, 0x00 },	// U+01C6 (ǆ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x15, 0x0b, 0x00, 0x00, 0x00 },	// U+01C7 (Ǉ)
	{ 0x00, 0x00, 0x00, 0x11, 0x01, 0x19, 0x11, 0x11, 0x11, 0x17, 0x10, 0x0c, 0x00 },	// U+01C8 (ǈ)
	{ 0x00, 0x00, 0x00, 0x13, 0x02, 0x1a, 0x12, 0x12, 0x12, 0x16, 0x10, 0x0c, 0x00 },	// U+01C9 (ǉ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x17, 0x17, 0x17, 0x15, 0x0d, 0x00, 0x00, 0x00 },	// U+01CA (Ǌ)
	{ 0x00, 0x00, 0x00, 0x15, 0x05, 0x1f, 0x17, 0x17, 0x15, 0x15, 0x10, 0x0c, 0x00 },	// U+01CB (ǋ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x1b, 0x15, 0x15, 0x15, 0x15, 0x10, 0x0c, 0x00 },	// U+01CC (ǌ)
	{ 0x00, 0x0a, 0x04, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+01CD (Ǎ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+01CE (ǎ)
	{ 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+01CF (Ǐ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+01D0 (ǐ)
	{ 0x00, 0x0a, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01D1 (Ǒ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01D2 (ǒ)
	{ 0x00, 0x0a, 0x04, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01D3 (Ǔ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+01D4 (ǔ)
	{ 0x00, 0x0e, 0x00, 0x0a, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01D5 (Ǖ)
	{ 0x00, 0x0e, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+01D6 (ǖ)
	{ 0x00, 0x08, 0x04, 0x1b, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01D7 (Ǘ)
	{ 0x00, 0x08, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+01D8 (ǘ)
	{ 0x00, 0x0a, 0x04, 0x1b, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01D9 (Ǚ)
	{ 0x00, 0x0a, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+01DA (ǚ)
	{ 0x00, 0x02, 0x04, 0x1b, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01DB (Ǜ)
	{ 0x00, 0x02, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+01DC (ǜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01DD (ǝ)
	{ 0x00, 0x0e, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+01DE (Ǟ)
	{ 0x00, 0x0e, 0x00, 0x0a, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+01DF (ǟ)
	{ 0x00, 0x0e, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+01E0 (Ǡ)
	{ 0x00, 0x0e, 0x00, 0x04, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+01E1 (ǡ)
	{ 0x00, 0x0e, 0x00, 0x1e, 0x05, 0x05, 0x0f, 0x05, 0x05, 0x1d, 0x00, 0x00, 0x00 },	// U+01E2 (Ǣ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x15, 0x1d, 0x05, 0x1e, 0x00, 0x00, 0x00 },	// U+01E3 (ǣ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x19, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01E4 (Ǥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x1f, 0x0e, 0x00 },	// U+01E5 (ǥ)
	{ 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01E6 (Ǧ)
	{ 0x00, 0x0a, 0x04, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+01E7 (ǧ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+01E8 (Ǩ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x09, 0x05, 0x07, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+01E9 (ǩ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x02, 0x0c, 0x00 },	// U+01EA (Ǫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x02, 0x0c, 0x00 },	// U+01EB (ǫ)
	{ 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x02, 0x0c, 0x00 },	// U+01EC (Ǭ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x02, 0x0c, 0x00 },	// U+01ED (ǭ)
	{ 0x00, 0x0a, 0x04, 0x00, 0x1f, 0x08, 0x04, 0x08, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01EE (Ǯ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1f, 0x08, 0x04, 0x08, 0x11, 0x0e, 0x00 },	// U+01EF (ǯ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00 },	// U+01F0 (ǰ)
	{ 0x00, 0x00, 0x00, 0x3b, 0x25, 0x15, 0x15, 0x15, 0x0d, 0x3b, 0x00, 0x00, 0x00 },	// U+01F1 (Ǳ)
	{ 0x00, 0x00, 0x00, 0x03, 0x05, 0x3d, 0x25, 0x15, 0x0d, 0x3b, 0x00, 0x00, 0x00 },	// U+01F2 (ǲ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x3e, 0x25, 0x15, 0x0d, 0x3e, 0x00, 0x00, 0x00 },	// U+01F3 (ǳ)
	{ 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+01F4 (Ǵ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+01F5 (ǵ)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x15, 0x17, 0x15, 0x15, 0x09, 0x00, 0x00, 0x00 },	// U+01F6 (Ƕ)
	{ 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x09, 0x05, 0x03, 0x01, 0x00, 0x00, 0x00 },	// U+01F7 (Ƿ)
	{ 0x00, 0x02, 0x04, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x00, 0x00, 0x00 },	// U+01F8 (Ǹ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+01F9 (ǹ)
	{ 0x00, 0x08, 0x04, 0x0a, 0x04, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+01FA (Ǻ)
	{ 0x00, 0x08, 0x04, 0x0a, 0x04, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+01FB (ǻ)
	{ 0x00, 0x08, 0x04, 0x1e, 0x05, 0x05, 0x0f, 0x05, 0x05, 0x1d, 0x00, 0x00, 0x00 },	// U+01FC (Ǽ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x15, 0x1d, 0x05, 0x1e, 0x00, 0x00, 0x00 },	// U+01FD (ǽ)
	{ 0x00, 0x08, 0x14, 0x0e, 0x19, 0x15, 0x15, 0x15, 0x13, 0x0e, 0x01, 0x00, 0x00 },	// U+01FE (Ǿ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1e, 0x19, 0x15, 0x13, 0x0f, 0x00, 0x00, 0x00 },	// U+01FF (ǿ)
	{ 0x00, 0x05, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0200 (Ȁ)
	{ 0x00, 0x00, 0x05, 0x0a, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0201 (ȁ)
	{ 0x00, 0x0e, 0x11, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0202 (Ȃ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0203 (ȃ)
	{ 0x00, 0x05, 0x0a, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0204 (Ȅ)
	{ 0x00, 0x00, 0x05, 0x0a, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0205 (ȅ)
	{ 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0206 (Ȇ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0207 (ȇ)
	{ 0x00, 0x05, 0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+0208 (Ȉ)
	{ 0x00, 0x00, 0x05, 0x0a, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+0209 (ȉ)
	{ 0x00, 0x0e, 0x11, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+020A (Ȋ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+020B (ȋ)
	{ 0x00, 0x05, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+020C (Ȍ)
	{ 0x00, 0x00, 0x05, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+020D (ȍ)
	{ 0x00, 0x0e, 0x11, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+020E (Ȏ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+020F (ȏ)
	{ 0x00, 0x05, 0x0a, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0210 (Ȑ)
	{ 0x00, 0x00, 0x05, 0x0a, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0211 (ȑ)
	{ 0x00, 0x0e, 0x11, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0212 (Ȓ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0213 (ȓ)
	{ 0x00, 0x05, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0214 (Ȕ)
	{ 0x00, 0x00, 0x05, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0215 (ȕ)
	{ 0x00, 0x0e, 0x11, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0216 (Ȗ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0217 (ȗ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x04, 0x02, 0x00 },	// U+0218 (Ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x04, 0x02, 0x00 },	// U+0219 (ș)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x00 },	// U+021A (Ț)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x18, 0x04, 0x02, 0x00 },	// U+021B (ț)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x13, 0x10, 0x0c, 0x03, 0x00, 0x00 },	// U+021C (Ȝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0c, 0x13, 0x08, 0x07, 0x00, 0x00, 0x00 },	// U+021D (ȝ)
	{ 0x00, 0x0a, 0x04, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+021E (Ȟ)
	{ 0x00, 0x0a, 0x04, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+021F (ȟ)
	{ 0x00, 0x00, 0x00, 0x01, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+0220 (Ƞ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x0e, 0x09, 0x09, 0x19, 0x2e, 0x14, 0x00, 0x00 },	// U+0221 (ȡ)
	{ 0x00, 0x00, 0x0c, 0x10, 0x12, 0x11, 0x0e, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0222 (Ȣ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x11, 0x11, 0x0e, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0223 (ȣ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x20, 0x00, 0x00 },	// U+0224 (Ȥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x20, 0x00, 0x00 },	// U+0225 (ȥ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0226 (Ȧ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0227 (ȧ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x04, 0x02, 0x00 },	// U+0228 (Ȩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x0e, 0x04, 0x02, 0x00 },	// U+0229 (ȩ)
	{ 0x00, 0x0e, 0x00, 0x0a, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+022A (Ȫ)
	{ 0x00, 0x0e, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+022B (ȫ)
	{ 0x00, 0x0e, 0x16, 0x0d, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+022C (Ȭ)
	{ 0x00, 0x0e, 0x00, 0x16, 0x0d, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+022D (ȭ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+022E (Ȯ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+022F (ȯ)
	{ 0x00, 0x0e, 0x00, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0230 (Ȱ)
	{ 0x00, 0x0e, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0231 (ȱ)
	{ 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0232 (Ȳ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+0233 (ȳ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x16, 0x0c, 0x00, 0x00, 0x00 },	// U+0234 (ȴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x19, 0x2d, 0x10, 0x00, 0x00 },	// U+0235 (ȵ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x1e, 0x04, 0x14, 0x2c, 0x1c, 0x00, 0x00, 0x00 },	// U+0236 (ȶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00 },	// U+0237 (ȷ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+0238 (ȸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00 },	// U+0239 (ȹ)
	{ 0x00, 0x00, 0x08, 0x0e, 0x15, 0x15, 0x1f, 0x13, 0x13, 0x11, 0x00, 0x00, 0x00 },	// U+023A (Ⱥ)
	{ 0x00, 0x10, 0x10, 0x0e, 0x19, 0x05, 0x05, 0x03, 0x13, 0x0f, 0x01, 0x00, 0x00 },	// U+023B (Ȼ)
	{ 0x00, 0x00, 0x10, 0x10, 0x08, 0x0e, 0x15, 0x05, 0x03, 0x1e, 0x01, 0x01, 0x00 },	// U+023C (ȼ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x0f, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+023D (Ƚ)
	{ 0x00, 0x00, 0x10, 0x1f, 0x0c, 0x0c, 0x06, 0x06, 0x05, 0x05, 0x00, 0x00, 0x00 },	// U+023E (Ⱦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x26, 0x18, 0x00 },	// U+023F (ȿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x02, 0x0c, 0x00 },	// U+0240 (ɀ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x10, 0x08, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+0241 (Ɂ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+0242 (ɂ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x2f, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0243 (Ƀ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0244 (Ʉ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0245 (Ʌ)
	{ 0x00, 0x00, 0x10, 0x1f, 0x09, 0x09, 0x0f, 0x05, 0x03, 0x1f, 0x01, 0x01, 0x00 },	// U+0246 (Ɇ)
	{ 0x00, 0x00, 0x10, 0x10, 0x08, 0x0e, 0x15, 0x1f, 0x03, 0x0e, 0x01, 0x01, 0x00 },	// U+0247 (ɇ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x38, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0248 (Ɉ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x03, 0x00 },	// U+0249 (ɉ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x20, 0x00, 0x00 },	// U+024A (Ɋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x20, 0x00 },	// U+024B (ɋ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1f, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+024C (Ɍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x07, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+024D (ɍ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+024E (Ɏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+024F (ɏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0250 (ɐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0251 (ɑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x13, 0x0d, 0x00, 0x00, 0x00 },	// U+0252 (ɒ)
	{ 0x00, 0x00, 0x06, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0253 (ɓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0254 (ɔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x09, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+0255 (ɕ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x20, 0x00 },	// U+0256 (ɖ)
	{ 0x00, 0x00, 0x20, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00, 0x00 },	// U+0257 (ɗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+0258 (ɘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0259 (ə)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x10, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+025A (ɚ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x06, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+025B (ɛ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+025C (ɜ)
	{ 0x00, 0x00, 0x00, 0x2e, 0x11, 0x10, 0x0c, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+025D (ɝ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0d, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+025E (ɞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x03, 0x00 },	// U+025F (ɟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+0260 (ɠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+0261 (ɡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x19, 0x11, 0x1e, 0x00, 0x00, 0x00 },	// U+0262 (ɢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x0a, 0x04, 0x00 },	// U+0263 (ɣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x0a, 0x04, 0x0a, 0x04, 0x00, 0x00 },	// U+0264 (ɤ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0265 (ɥ)
	{ 0x00, 0x00, 0x06, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0266 (ɦ)
	{ 0x00, 0x00, 0x06, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x08, 0x00 },	// U+0267 (ɧ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x0e, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+0268 (ɨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00 },	// U+0269 (ɩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+026A (ɪ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x16, 0x0d, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+026B (ɫ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x06, 0x05, 0x0e, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+026C (ɬ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00 },	// U+026D (ɭ)
	{ 0x00, 0x00, 0x00, 0x01, 0x1f, 0x11, 0x09, 0x0d, 0x11, 0x12, 0x0c, 0x00, 0x00 },	// U+026E (ɮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x1e, 0x00, 0x00, 0x00 },	// U+026F (ɯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x1e, 0x10, 0x10, 0x00 },	// U+0270 (ɰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x10, 0x08, 0x00 },	// U+0271 (ɱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x16, 0x12, 0x12, 0x12, 0x02, 0x01, 0x00 },	// U+0272 (ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0b, 0x09, 0x09, 0x09, 0x08, 0x10, 0x00 },	// U+0273 (ɳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x13, 0x15, 0x19, 0x19, 0x00, 0x00, 0x00 },	// U+0274 (ɴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0275 (ɵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x05, 0x1d, 0x05, 0x1e, 0x00, 0x00, 0x00 },	// U+0276 (ɶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x15, 0x1b, 0x00, 0x00, 0x00 },	// U+0277 (ɷ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00 },	// U+0278 (ɸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0279 (ɹ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+027A (ɺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x19, 0x16, 0x20, 0x00, 0x00 },	// U+027B (ɻ)
	{ 0x00, 0x00, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+027C (ɼ)
	{ 0x00, 0x00, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00 },	// U+027D (ɽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+027E (ɾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+027F (ɿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x0f, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+0280 (ʀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x09, 0x0f, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0281 (ʁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x01, 0x02, 0x00 },	// U+0282 (ʂ)
	{ 0x00, 0x00, 0x18, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00, 0x00 },	// U+0283 (ʃ)
	{ 0x00, 0x00, 0x18, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x03, 0x00, 0x00 },	// U+0284 (ʄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00 },	// U+0285 (ʅ)
	{ 0x00, 0x00, 0x18, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x2d, 0x12, 0x00, 0x00 },	// U+0286 (ʆ)
	{ 0x00, 0x00, 0x00, 0x03, 0x04, 0x04, 0x04, 0x0f, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0287 (ʇ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x0f, 0x02, 0x02, 0x02, 0x02, 0x0c, 0x00, 0x00 },	// U+0288 (ʈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1f, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0289 (ʉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+028A (ʊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+028B (ʋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+028C (ʌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x15, 0x15, 0x11, 0x00, 0x00, 0x00 },	// U+028D (ʍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00 },	// U+028E (ʎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+028F (ʏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x10, 0x08, 0x00 },	// U+0290 (ʐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x0c, 0x16, 0x1f, 0x04, 0x00, 0x00 },	// U+0291 (ʑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x08, 0x10, 0x11, 0x0e, 0x00 },	// U+0292 (ʒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x08, 0x16, 0x19, 0x1e, 0x00 },	// U+0293 (ʓ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x10, 0x08, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+0294 (ʔ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x02, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+0295 (ʕ)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x08, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+0296 (ʖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00 },	// U+0297 (ʗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0298 (ʘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x0f, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0299 (ʙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x16, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+029A (ʚ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x1e, 0x01, 0x19, 0x11, 0x1e, 0x00, 0x00, 0x00 },	// U+029B (ʛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+029C (ʜ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x05, 0x02, 0x00 },	// U+029D (ʝ)
	{ 0x00, 0x00, 0x00, 0x11, 0x12, 0x1c, 0x14, 0x12, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+029E (ʞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00 },	// U+029F (ʟ)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x00 },	// U+02A0 (ʠ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x10, 0x08, 0x04, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+02A1 (ʡ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x02, 0x04, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+02A2 (ʢ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x3e, 0x25, 0x15, 0x0d, 0x3e, 0x00, 0x00, 0x00 },	// U+02A3 (ʣ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x3e, 0x25, 0x15, 0x25, 0x2e, 0x10, 0x00, 0x00 },	// U+02A4 (ʤ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x3e, 0x25, 0x15, 0x2d, 0x3e, 0x08, 0x00, 0x00 },	// U+02A5 (ʥ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x3f, 0x06, 0x1a, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+02A6 (ʦ)
	{ 0x00, 0x00, 0x00, 0x12, 0x0a, 0x0f, 0x0a, 0x0a, 0x0a, 0x0c, 0x08, 0x04, 0x00 },	// U+02A7 (ʧ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x37, 0x0a, 0x1a, 0x2a, 0x3c, 0x08, 0x00, 0x00 },	// U+02A8 (ʨ)
	{ 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x1f, 0x2a, 0x2a, 0x2a, 0x10, 0x08, 0x00 },	// U+02A9 (ʩ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x1d, 0x03, 0x0d, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+02AA (ʪ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x1f, 0x09, 0x05, 0x03, 0x1f, 0x00, 0x00, 0x00 },	// U+02AB (ʫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x0a, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+02AC (ʬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x00, 0x1f, 0x11, 0x00, 0x00, 0x00 },	// U+02AD (ʭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x12, 0x12, 0x12, 0x1c, 0x10, 0x10, 0x00 },	// U+02AE (ʮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x12, 0x12, 0x12, 0x1c, 0x10, 0x20, 0x00 },	// U+02AF (ʯ)
	{ 0x00, 0x00, 0x00, 0x01, 0x03, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B0 (ʰ)
	{ 0x00, 0x00, 0x06, 0x01, 0x03, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B1 (ʱ)
	{ 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B2 (ʲ)
	{ 0x00, 0x00, 0x00, 0x05, 0x0b, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B3 (ʳ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x0d, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B4 (ʴ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x0d, 0x0a, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B5 (ʵ)
	{ 0x00, 0x00, 0x05, 0x05, 0x03, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B6 (ʶ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B7 (ʷ)
	{ 0x00, 0x00, 0x05, 0x05, 0x06, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B8 (ʸ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B9 (ʹ)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BA (ʺ)
	{ 0x00, 0x00, 0x04, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BB (ʻ)
	{ 0x00, 0x00, 0x06, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BC (ʼ)
	{ 0x00, 0x00, 0x06, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BD (ʽ)
}; // 528

static const unsigned char tewi_block4[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x03, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+02C2 (˂)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x30, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+02C3 (˃)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+02C4 (˄)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+02C5 (˅)
	{ 0x00, 0x00, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C6 (ˆ)
	{ 0x00, 0x00, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C7 (ˇ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C8 (ˈ)
	{ 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C9 (ˉ)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02CA (ˊ)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02CB (ˋ)
}; // 10

static const unsigned char tewi_block5[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x00, 0x00, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+02D0 (ː)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D1 (ˑ)
}; // 2

static const unsigned char tewi_block6[][13] = {
	{ 0x00, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D8 (˘)
	{ 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D9 (˙)
	{ 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DA (˚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x08, 0x00 },	// U+02DB (˛)
	{ 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DC (˜)
	{ 0x00, 0x22, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DD (˝)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DE (˞)
}; // 7

static const unsigned char tewi_block7[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+02E0 (ˠ)
}; // 1

static const unsigned char tewi_block8[][13] = {
	{ 0x00, 0x00, 0x0c, 0x02, 0x02, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E4 (ˤ)
}; // 1

static const unsigned char tewi_block9[][13] = {
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02EE (ˮ)
}; // 1

static const unsigned char tewi_block10[][13] = {
	{ 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0300 (̀)
	{ 0x00, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0301 (́)
	{ 0x00, 0x06, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0302 (̂)
	{ 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0303 (̃)
	{ 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0304 (̄)
	{ 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0305 (̅)
	{ 0x00, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0306 (̆)
	{ 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0307 (̇)
	{ 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0308 (̈)
	{ 0x06, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0309 (̉)
	{ 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030A (̊)
	{ 0x00, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030B (̋)
	{ 0x00, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030C (̌)
	{ 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030D (̍)
	{ 0x00, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030E (̎)
}; // 15

static const unsigned char tewi_block11[][13] = {
	{ 0x00, 0x04, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0310 (̐)
	{ 0x00, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0311 (̑)
	{ 0x00, 0x04, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0312 (̒)
	{ 0x00, 0x06, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0313 (̓)
	{ 0x00, 0x06, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0314 (̔)
	{ 0x00, 0x06, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0315 (̕)
}; // 6

static const unsigned char tewi_block12[][13] = {
	{ 0x00, 0x1e, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+031A (̚)
}; // 1

static const unsigned char tewi_block13[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x04 },	// U+031C (̜)
}; // 1

static const unsigned char tewi_block14[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04 },	// U+031F (̟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00 },	// U+0320 (̠)
}; // 2

static const unsigned char tewi_block15[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00 },	// U+0324 (̤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04 },	// U+0325 (̥)
}; // 2

static const unsigned char tewi_block16[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x00 },	// U+032A (̪)
}; // 1

static const unsigned char tewi_block17[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x04, 0x00 },	// U+032C (̬)
}; // 1

static const unsigned char tewi_block18[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a },	// U+0330 (̰)
}; // 1

static const unsigned char tewi_block19[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x04 },	// U+0339 (̹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0e },	// U+033A (̺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0e },	// U+033B (̻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15 },	// U+033C (̼)
}; // 4

static const unsigned char tewi_block20[][13] = {
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0343 (̓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0344 (̈́)
}; // 2

static const unsigned char tewi_block21[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x00 },	// U+035C (͜)
}; // 1

static const unsigned char tewi_block22[][13] = {
	{ 0x00, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0361 (͡)
}; // 1

static const unsigned char tewi_block23[][13] = {
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0370 (Ͱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0371 (ͱ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x15, 0x15, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0372 (Ͳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0373 (ͳ)
	{ 0x00, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0374 (ʹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0x03, 0x00, 0x00 },	// U+0375 (͵)
	{ 0x00, 0x00, 0x00, 0x00, 0x19, 0x19, 0x15, 0x15, 0x13, 0x13, 0x00, 0x00, 0x00 },	// U+0376 (Ͷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x20, 0x00, 0x00 },	// U+0377 (ͷ)
}; // 8

static const unsigned char tewi_block24[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x00 },	// U+037A (ͺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+037B (ͻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x05, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+037C (ͼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x14, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+037D (ͽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x04, 0x00 },	// U+037E (;)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+037F (Ϳ)
}; // 6

static const unsigned char tewi_block25[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0384 (΄)
	{ 0x00, 0x08, 0x04, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0385 (΅)
	{ 0x00, 0x00, 0x02, 0x0d, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+0386 (Ά)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0387 (·)
	{ 0x00, 0x00, 0x02, 0x3d, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+0388 (Έ)
	{ 0x00, 0x00, 0x02, 0x25, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+0389 (Ή)
	{ 0x00, 0x00, 0x02, 0x1d, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+038A (Ί)
}; // 7

static const unsigned char tewi_block26[][13] = {
	{ 0x00, 0x00, 0x02, 0x0d, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+038C (Ό)
}; // 1

static const unsigned char tewi_block27[][13] = {
	{ 0x00, 0x00, 0x02, 0x15, 0x14, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+038E (Ύ)
	{ 0x00, 0x02, 0x01, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00, 0x00 },	// U+038F (Ώ)
	{ 0x00, 0x08, 0x04, 0x11, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+0390 (ΐ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0391 (Α)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0392 (Β)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0393 (Γ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+0394 (Δ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0395 (Ε)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0396 (Ζ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0397 (Η)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0398 (Θ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+0399 (Ι)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+039A (Κ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+039B (Λ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+039C (Μ)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x00, 0x00, 0x00 },	// U+039D (Ν)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+039E (Ξ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+039F (Ο)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+03A0 (Π)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+03A1 (Ρ)
}; // 20

static const unsigned char tewi_block28[][13] = {
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x02, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+03A3 (Σ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+03A4 (Τ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+03A5 (Υ)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+03A6 (Φ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+03A7 (Χ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+03A8 (Ψ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00, 0x00 },	// U+03A9 (Ω)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+03AA (Ϊ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+03AB (Ϋ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+03AC (ά)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03AD (έ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+03AE (ή)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+03AF (ί)
	{ 0x00, 0x08, 0x04, 0x11, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03B0 (ΰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+03B1 (α)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x0d, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+03B2 (β)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x04, 0x00 },	// U+03B3 (γ)
	{ 0x00, 0x00, 0x1f, 0x02, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03B4 (δ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03B5 (ε)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x01, 0x01, 0x01, 0x0e, 0x10, 0x08, 0x00 },	// U+03B6 (ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+03B7 (η)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x0f, 0x09, 0x09, 0x06, 0x00, 0x00, 0x00 },	// U+03B8 (θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+03B9 (ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x09, 0x07, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+03BA (κ)
	{ 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+03BB (λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x09, 0x17, 0x01, 0x01, 0x00 },	// U+03BC (μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+03BD (ν)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x01, 0x01, 0x0e, 0x10, 0x0c, 0x00 },	// U+03BE (ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03BF (ο)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x0a, 0x0a, 0x12, 0x00, 0x00, 0x00 },	// U+03C0 (π)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+03C1 (ρ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x0e, 0x10, 0x0c, 0x00 },	// U+03C2 (ς)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x09, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03C3 (σ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00 },	// U+03C4 (τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03C5 (υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00 },	// U+03C6 (φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00 },	// U+03C7 (χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x04, 0x00 },	// U+03C8 (ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+03C9 (ω)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+03CA (ϊ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03CB (ϋ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03CC (ό)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03CD (ύ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+03CE (ώ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x08, 0x00, 0x00 },	// U+03CF (Ϗ)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x05, 0x0f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03D0 (ϐ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03D1 (ϑ)
	{ 0x00, 0x00, 0x00, 0x11, 0x31, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+03D2 (ϒ)
	{ 0x00, 0x00, 0x02, 0x11, 0x31, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+03D3 (ϓ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x31, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+03D4 (ϔ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00 },	// U+03D5 (ϕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+03D6 (ϖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x05, 0x07, 0x09, 0x11, 0x08, 0x04, 0x00 },	// U+03D7 (ϗ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x04, 0x00 },	// U+03D8 (Ϙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x04, 0x00 },	// U+03D9 (ϙ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x10, 0x0c, 0x00 },	// U+03DA (Ϛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x0e, 0x10, 0x0c, 0x00 },	// U+03DB (ϛ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+03DC (Ϝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x01, 0x01, 0x07, 0x01, 0x01, 0x01, 0x00 },	// U+03DD (ϝ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x01, 0x1f, 0x10, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+03DE (Ϟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x01, 0x0f, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+03DF (ϟ)
	{ 0x00, 0x00, 0x00, 0x03, 0x04, 0x0c, 0x0a, 0x19, 0x14, 0x12, 0x10, 0x10, 0x00 },	// U+03E0 (Ϡ)
	{ 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x06, 0x09, 0x0c, 0x0a, 0x08, 0x08, 0x00 },	// U+03E1 (ϡ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1a, 0x10, 0x0f, 0x00 },	// U+03E2 (Ϣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x1a, 0x10, 0x0f, 0x00 },	// U+03E3 (ϣ)
	{ 0x00, 0x00, 0x00, 0x16, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+03E4 (Ϥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x09, 0x09, 0x0e, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+03E5 (ϥ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x10, 0x0f, 0x00 },	// U+03E6 (Ϧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0e, 0x15, 0x12, 0x10, 0x0e, 0x01, 0x00, 0x00 },	// U+03E7 (ϧ)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x08, 0x06, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03E8 (Ϩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x08, 0x06, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03E9 (ϩ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x15, 0x04, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+03EA (Ϫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x04, 0x0a, 0x1f, 0x00, 0x00, 0x00 },	// U+03EB (ϫ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03EC (Ϭ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03ED (ϭ)
	{ 0x00, 0x00, 0x00, 0x04, 0x1e, 0x05, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+03EE (Ϯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1e, 0x05, 0x04, 0x04, 0x04, 0x04, 0x02, 0x00 },	// U+03EF (ϯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x0a, 0x0e, 0x0a, 0x19, 0x00, 0x00, 0x00 },	// U+03F0 (ϰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x0e, 0x10 },	// U+03F1 (ϱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03F2 (ϲ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00 },	// U+03F3 (ϳ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03F4 (ϴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x01, 0x07, 0x01, 0x0e, 0x00, 0x00, 0x00 },	// U+03F5 (ϵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x0e, 0x08, 0x07, 0x00, 0x00, 0x00 },	// U+03F6 (϶)
	{ 0x00, 0x00, 0x00, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x00, 0x00, 0x00 },	// U+03F7 (Ϸ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+03F8 (ϸ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03F9 (Ϲ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+03FA (Ϻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x15, 0x01, 0x01, 0x00 },	// U+03FB (ϻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x12, 0x0e, 0x02, 0x0f, 0x02 },	// U+03FC (ϼ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03FD (Ͻ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x05, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03FE (Ͼ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x14, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+03FF (Ͽ)
	{ 0x00, 0x02, 0x04, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0400 (Ѐ)
	{ 0x00, 0x0a, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0401 (Ё)
	{ 0x00, 0x00, 0x00, 0x0f, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x12, 0x08, 0x00, 0x00 },	// U+0402 (Ђ)
	{ 0x00, 0x08, 0x04, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0403 (Ѓ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x07, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0404 (Є)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0405 (Ѕ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0406 (І)
	{ 0x00, 0x0a, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0407 (Ї)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0408 (Ј)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x0a, 0x1a, 0x2a, 0x2a, 0x19, 0x00, 0x00, 0x00 },	// U+0409 (Љ)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x0f, 0x15, 0x15, 0x0d, 0x00, 0x00, 0x00 },	// U+040A (Њ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+040B (Ћ)
	{ 0x00, 0x08, 0x04, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+040C (Ќ)
	{ 0x00, 0x02, 0x04, 0x19, 0x19, 0x15, 0x15, 0x15, 0x13, 0x13, 0x00, 0x00, 0x00 },	// U+040D (Ѝ)
	{ 0x00, 0x0a, 0x04, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+040E (Ў)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x04, 0x04, 0x00 },	// U+040F (Џ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0410 (А)
	{ 0x00, 0x00, 0x00, 0x0f, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0411 (Б)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0412 (В)
	{ 0x00, 0x00, 0x00, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0413 (Г)
	{ 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x12, 0x3f, 0x21, 0x21, 0x00 },	// U+0414 (Д)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+0415 (Е)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+0416 (Ж)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0417 (З)
	{ 0x00, 0x00, 0x00, 0x19, 0x19, 0x15, 0x15, 0x15, 0x13, 0x13, 0x00, 0x00, 0x00 },	// U+0418 (И)
	{ 0x00, 0x0a, 0x04, 0x19, 0x19, 0x15, 0x15, 0x15, 0x13, 0x13, 0x00, 0x00, 0x00 },	// U+0419 (Й)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+041A (К)
	{ 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x00, 0x00, 0x00 },	// U+041B (Л)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+041C (М)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+041D (Н)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+041E (О)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+041F (П)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0420 (Р)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0421 (С)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0422 (Т)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0423 (У)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+0424 (Ф)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+0425 (Х)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3f, 0x20, 0x20, 0x00 },	// U+0426 (Ц)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0427 (Ч)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+0428 (Ш)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x3f, 0x20, 0x20, 0x00 },	// U+0429 (Щ)
	{ 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00, 0x00 },	// U+042A (Ъ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x17, 0x19, 0x19, 0x17, 0x00, 0x00, 0x00 },	// U+042B (Ы)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+042C (Ь)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x1e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+042D (Э)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x15, 0x17, 0x15, 0x15, 0x09, 0x00, 0x00, 0x00 },	// U+042E (Ю)
	{ 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x1c, 0x14, 0x12, 0x11, 0x00, 0x00, 0x00 },	// U+042F (Я)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+0430 (а)
	{ 0x00, 0x00, 0x10, 0x0e, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0431 (б)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x0f, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0432 (в)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0433 (г)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x3f, 0x21, 0x21, 0x00 },	// U+0434 (д)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0435 (е)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+0436 (ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0c, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0437 (з)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x00, 0x00, 0x00 },	// U+0438 (и)
	{ 0x00, 0x00, 0x00, 0x0a, 0x04, 0x11, 0x19, 0x15, 0x13, 0x11, 0x00, 0x00, 0x00 },	// U+0439 (й)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x09, 0x07, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+043A (к)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x11, 0x00, 0x00, 0x00 },	// U+043B (л)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+043C (м)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+043D (н)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+043E (о)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+043F (п)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+0440 (р)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0441 (с)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0442 (т)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+0443 (у)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00 },	// U+0444 (ф)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+0445 (х)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x3f, 0x20, 0x20, 0x00 },	// U+0446 (ц)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0447 (ч)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+0448 (ш)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x3f, 0x20, 0x20, 0x00 },	// U+0449 (щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x02, 0x0e, 0x12, 0x0e, 0x00, 0x00, 0x00 },	// U+044A (ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x17, 0x19, 0x17, 0x00, 0x00, 0x00 },	// U+044B (ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+044C (ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x1e, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+044D (э)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x15, 0x17, 0x15, 0x09, 0x00, 0x00, 0x00 },	// U+044E (ю)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x1e, 0x12, 0x11, 0x00, 0x00, 0x00 },	// U+044F (я)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0450 (ѐ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0451 (ё)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x0f, 0x02, 0x0e, 0x12, 0x12, 0x08, 0x00, 0x00 },	// U+0452 (ђ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0453 (ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x07, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0454 (є)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+0455 (ѕ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0456 (і)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0457 (ї)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00 },	// U+0458 (ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x1a, 0x2a, 0x19, 0x00, 0x00, 0x00 },	// U+0459 (љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0f, 0x15, 0x0d, 0x00, 0x00, 0x00 },	// U+045A (њ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x0f, 0x02, 0x0e, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+045B (ћ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x09, 0x07, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+045C (ќ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x00, 0x00, 0x00 },	// U+045D (ѝ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x04, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+045E (ў)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x04, 0x04, 0x00 },	// U+045F (џ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+0460 (Ѡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+0461 (ѡ)
	{ 0x00, 0x00, 0x02, 0x07, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x0e, 0x00, 0x00, 0x00 },	// U+0462 (Ѣ)
	{ 0x00, 0x00, 0x00, 0x02, 0x07, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00, 0x00 },	// U+0463 (ѣ)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x05, 0x0f, 0x05, 0x15, 0x09, 0x00, 0x00, 0x00 },	// U+0464 (Ѥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x05, 0x0f, 0x05, 0x19, 0x00, 0x00, 0x00 },	// U+0465 (ѥ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x1f, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+0466 (Ѧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0e, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+0467 (ѧ)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x0b, 0x0b, 0x1f, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+0468 (Ѩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0b, 0x0f, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+0469 (ѩ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x0a, 0x0e, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+046A (Ѫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x04, 0x0e, 0x15, 0x00, 0x00, 0x00 },	// U+046B (ѫ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x0b, 0x05, 0x0f, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+046C (Ѭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0b, 0x05, 0x0f, 0x15, 0x00, 0x00, 0x00 },	// U+046D (ѭ)
	{ 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x10, 0x0c, 0x10, 0x10, 0x0c, 0x02, 0x0c, 0x00 },	// U+046E (Ѯ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x10, 0x0c, 0x10, 0x0c, 0x02, 0x04, 0x00 },	// U+046F (ѯ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0470 (Ѱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0471 (ѱ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0472 (Ѳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+0473 (ѳ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x09, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0474 (Ѵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x09, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+0475 (ѵ)
	{ 0x00, 0x05, 0x0a, 0x00, 0x11, 0x09, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0476 (Ѷ)
	{ 0x00, 0x00, 0x05, 0x0a, 0x00, 0x11, 0x09, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+0477 (ѷ)
	{ 0x00, 0x00, 0x00, 0x02, 0x05, 0x05, 0x15, 0x15, 0x15, 0x1a, 0x10, 0x0c, 0x00 },	// U+0478 (Ѹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x15, 0x15, 0x15, 0x1a, 0x10, 0x0c, 0x00 },	// U+0479 (ѹ)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x11, 0x11, 0x11, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+047A (Ѻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x11, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+047B (ѻ)
	{ 0x00, 0x06, 0x09, 0x10, 0x04, 0x11, 0x11, 0x11, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+047C (Ѽ)
	{ 0x00, 0x00, 0x06, 0x09, 0x10, 0x04, 0x11, 0x11, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+047D (ѽ)
	{ 0x00, 0x1f, 0x15, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+047E (Ѿ)
	{ 0x00, 0x00, 0x1f, 0x15, 0x00, 0x15, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+047F (ѿ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x08, 0x08, 0x00 },	// U+0480 (Ҁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x0e, 0x08, 0x08, 0x00 },	// U+0481 (ҁ)
	{ 0x00, 0x00, 0x08, 0x08, 0x06, 0x0c, 0x03, 0x06, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0482 (҂)
	{ 0x00, 0x10, 0x0e, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0483 (҃)
	{ 0x00, 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0484 (҄)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0485 (҅)
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0486 (҆)
}; // 228

static const unsigned char tewi_block29[][13] = {
	{ 0x00, 0x0a, 0x04, 0x19, 0x19, 0x15, 0x15, 0x15, 0x13, 0x33, 0x10, 0x08, 0x00 },	// U+048A (Ҋ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x04, 0x11, 0x19, 0x15, 0x13, 0x31, 0x10, 0x08, 0x00 },	// U+048B (ҋ)
	{ 0x00, 0x00, 0x02, 0x07, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+048C (Ҍ)
	{ 0x00, 0x00, 0x00, 0x02, 0x07, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00, 0x00 },	// U+048D (ҍ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x15, 0x0f, 0x09, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+048E (Ҏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x15, 0x0f, 0x09, 0x01, 0x00 },	// U+048F (ҏ)
	{ 0x00, 0x08, 0x08, 0x0f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0490 (Ґ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x0f, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0491 (ґ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x02, 0x02, 0x0f, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0492 (Ғ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x0f, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0493 (ғ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x10, 0x11, 0x0e, 0x00 },	// U+0494 (Ҕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x01, 0x01, 0x0f, 0x11, 0x10, 0x11, 0x0e },	// U+0495 (ҕ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x35, 0x20, 0x20, 0x00 },	// U+0496 (Җ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x0e, 0x15, 0x35, 0x20, 0x20, 0x00 },	// U+0497 (җ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x10, 0x11, 0x0e, 0x04, 0x04, 0x00 },	// U+0498 (Ҙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0c, 0x11, 0x0e, 0x04, 0x04, 0x00 },	// U+0499 (ҙ)
	{ 0x00, 0x00, 0x00, 0x19, 0x05, 0x03, 0x03, 0x05, 0x09, 0x11, 0x10, 0x10, 0x00 },	// U+049A (Қ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x19, 0x05, 0x03, 0x05, 0x09, 0x10, 0x10, 0x00 },	// U+049B (қ)
	{ 0x00, 0x00, 0x00, 0x11, 0x15, 0x15, 0x0f, 0x15, 0x15, 0x11, 0x00, 0x00, 0x00 },	// U+049C (Ҝ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x15, 0x15, 0x0f, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+049D (ҝ)
	{ 0x00, 0x00, 0x00, 0x11, 0x0b, 0x09, 0x07, 0x05, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+049E (Ҟ)
	{ 0x00, 0x00, 0x00, 0x01, 0x13, 0x09, 0x09, 0x07, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+049F (ҟ)
	{ 0x00, 0x00, 0x00, 0x13, 0x0a, 0x0a, 0x06, 0x0a, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+04A0 (Ҡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x0a, 0x06, 0x0a, 0x12, 0x00, 0x00, 0x00 },	// U+04A1 (ҡ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x31, 0x20, 0x20, 0x00 },	// U+04A2 (Ң)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x31, 0x20, 0x20, 0x00 },	// U+04A3 (ң)
	{ 0x00, 0x00, 0x00, 0x19, 0x09, 0x09, 0x0f, 0x09, 0x09, 0x09, 0x00, 0x00, 0x00 },	// U+04A4 (Ҥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x09, 0x0f, 0x09, 0x09, 0x00, 0x00, 0x00 },	// U+04A5 (ҥ)
	{ 0x00, 0x00, 0x00, 0x07, 0x05, 0x05, 0x0d, 0x15, 0x15, 0x15, 0x10, 0x0c, 0x00 },	// U+04A6 (Ҧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x05, 0x0d, 0x15, 0x15, 0x10, 0x0c, 0x00 },	// U+04A7 (ҧ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x01, 0x09, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x18, 0x00 },	// U+04A8 (Ҩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x01, 0x09, 0x15, 0x0e, 0x04, 0x18, 0x00 },	// U+04A9 (ҩ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x04, 0x04, 0x00 },	// U+04AA (Ҫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x1e, 0x04, 0x04, 0x00 },	// U+04AB (ҫ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x08, 0x08, 0x00 },	// U+04AC (Ҭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x0c, 0x08, 0x08, 0x00 },	// U+04AD (ҭ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+04AE (Ү)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00 },	// U+04AF (ү)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x1f, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+04B0 (Ұ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x1f, 0x04, 0x04, 0x00 },	// U+04B1 (ұ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x31, 0x20, 0x20, 0x00 },	// U+04B2 (Ҳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x31, 0x20, 0x20, 0x00 },	// U+04B3 (ҳ)
	{ 0x00, 0x00, 0x00, 0x17, 0x12, 0x12, 0x12, 0x12, 0x12, 0x3e, 0x20, 0x20, 0x00 },	// U+04B4 (Ҵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x12, 0x12, 0x12, 0x3e, 0x20, 0x20, 0x00 },	// U+04B5 (ҵ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x30, 0x20, 0x20, 0x00 },	// U+04B6 (Ҷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x30, 0x20, 0x20 },	// U+04B7 (ҷ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x15, 0x1e, 0x14, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+04B8 (Ҹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x15, 0x1e, 0x14, 0x10, 0x10, 0x00 },	// U+04B9 (ҹ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+04BA (Һ)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x07, 0x09, 0x09, 0x09, 0x00, 0x00, 0x00 },	// U+04BB (һ)
	{ 0x00, 0x00, 0x00, 0x08, 0x15, 0x15, 0x1e, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+04BC (Ҽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x15, 0x1e, 0x04, 0x18, 0x00, 0x00, 0x00 },	// U+04BD (ҽ)
	{ 0x00, 0x00, 0x00, 0x08, 0x15, 0x15, 0x1e, 0x04, 0x14, 0x08, 0x10, 0x00, 0x00 },	// U+04BE (Ҿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x15, 0x1e, 0x04, 0x18, 0x08, 0x10, 0x00 },	// U+04BF (ҿ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+04C0 (Ӏ)
	{ 0x00, 0x11, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+04C1 (Ӂ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+04C2 (ӂ)
	{ 0x00, 0x00, 0x00, 0x19, 0x05, 0x05, 0x03, 0x0f, 0x11, 0x11, 0x10, 0x0e, 0x00 },	// U+04C3 (Ӄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x05, 0x03, 0x0f, 0x11, 0x10, 0x0e, 0x00 },	// U+04C4 (ӄ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x19, 0x10, 0x08, 0x00 },	// U+04C5 (Ӆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x0a, 0x19, 0x10, 0x08, 0x00 },	// U+04C6 (ӆ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x10, 0x0e, 0x00 },	// U+04C7 (Ӈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x10, 0x0c, 0x00 },	// U+04C8 (ӈ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x31, 0x20, 0x10, 0x00 },	// U+04C9 (Ӊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x31, 0x20, 0x10, 0x00 },	// U+04CA (ӊ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x18, 0x08, 0x08, 0x00 },	// U+04CB (Ӌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x18, 0x08, 0x08 },	// U+04CC (ӌ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x31, 0x20, 0x10, 0x00 },	// U+04CD (Ӎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x31, 0x20, 0x10, 0x00 },	// U+04CE (ӎ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+04CF (ӏ)
	{ 0x00, 0x11, 0x0e, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+04D0 (Ӑ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+04D1 (ӑ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+04D2 (Ӓ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+04D3 (ӓ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x05, 0x05, 0x0f, 0x05, 0x05, 0x1d, 0x00, 0x00, 0x00 },	// U+04D4 (Ӕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x14, 0x1e, 0x05, 0x1a, 0x00, 0x00, 0x00 },	// U+04D5 (ӕ)
	{ 0x00, 0x11, 0x0e, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+04D6 (Ӗ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+04D7 (ӗ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04D8 (Ә)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x1e, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04D9 (ә)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x10, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04DA (Ӛ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0f, 0x10, 0x1e, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04DB (ӛ)
	{ 0x00, 0x0a, 0x00, 0x15, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+04DC (Ӝ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+04DD (ӝ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04DE (Ӟ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x0c, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04DF (ӟ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04E0 (Ӡ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x04, 0x02, 0x07, 0x08, 0x09, 0x06, 0x00, 0x00, 0x00 },	// U+04E1 (ӡ)
	{ 0x00, 0x0e, 0x00, 0x19, 0x19, 0x15, 0x15, 0x15, 0x13, 0x13, 0x00, 0x00, 0x00 },	// U+04E2 (Ӣ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x00, 0x00, 0x00 },	// U+04E3 (ӣ)
	{ 0x00, 0x0a, 0x00, 0x19, 0x19, 0x15, 0x15, 0x15, 0x13, 0x13, 0x00, 0x00, 0x00 },	// U+04E4 (Ӥ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x00, 0x00, 0x00 },	// U+04E5 (ӥ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04E6 (Ӧ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04E7 (ӧ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04E8 (Ө)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04E9 (ө)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04EA (Ӫ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04EB (ӫ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x10, 0x1c, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04EC (Ӭ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x1c, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+04ED (ӭ)
	{ 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x03, 0x00, 0x00, 0x00 },	// U+04EE (Ӯ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+04EF (ӯ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x03, 0x00, 0x00, 0x00 },	// U+04F0 (Ӱ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+04F1 (ӱ)
	{ 0x00, 0x14, 0x0a, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x03, 0x00, 0x00, 0x00 },	// U+04F2 (Ӳ)
	{ 0x00, 0x00, 0x14, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+04F3 (ӳ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+04F4 (Ӵ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x00, 0x00 },	// U+04F5 (ӵ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x02, 0x00 },	// U+04F6 (Ӷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x01, 0x01, 0x01, 0x03, 0x02, 0x02, 0x00 },	// U+04F7 (ӷ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x13, 0x15, 0x15, 0x15, 0x13, 0x00, 0x00, 0x00 },	// U+04F8 (Ӹ)
	{ 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x13, 0x15, 0x15, 0x13, 0x00, 0x00, 0x00 },	// U+04F9 (ӹ)
	{ 0x00, 0x00, 0x1e, 0x02, 0x02, 0x0f, 0x02, 0x02, 0x02, 0x06, 0x04, 0x02, 0x00 },	// U+04FA (Ӻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x07, 0x02, 0x06, 0x04, 0x02, 0x00 },	// U+04FB (ӻ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x10, 0x08, 0x00 },	// U+04FC (Ӽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x10, 0x08, 0x00 },	// U+04FD (ӽ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x1f, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+04FE (Ӿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x1f, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+04FF (ӿ)
}; // 118

static const unsigned char tewi_block30[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05BE (־)
}; // 1

static const unsigned char tewi_block31[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+05C0 (׀)
}; // 1

static const unsigned char tewi_block32[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+05C3 (׃)
}; // 1

static const unsigned char tewi_block33[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00 },	// U+05C6 (׆)
}; // 1

static const unsigned char tewi_block34[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x12, 0x15, 0x09, 0x13, 0x00, 0x00, 0x00 },	// U+05D0 (א)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x08, 0x08, 0x1f, 0x00, 0x00, 0x00 },	// U+05D1 (ב)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x16, 0x00, 0x00, 0x00 },	// U+05D2 (ג)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+05D3 (ד)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+05D4 (ה)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+05D5 (ו)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+05D6 (ז)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+05D7 (ח)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x15, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+05D8 (ט)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05D9 (י)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+05DA (ך)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+05DB (כ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x1f, 0x10, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00 },	// U+05DC (ל)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+05DD (ם)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x12, 0x11, 0x11, 0x1d, 0x00, 0x00, 0x00 },	// U+05DE (מ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+05DF (ן)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x08, 0x0e, 0x00, 0x00, 0x00 },	// U+05E0 (נ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+05E1 (ס)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x0f, 0x00, 0x00, 0x00 },	// U+05E2 (ע)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x16, 0x10, 0x10, 0x10, 0x00 },	// U+05E3 (ף)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x13, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+05E4 (פ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x06, 0x02, 0x02, 0x02, 0x00 },	// U+05E5 (ץ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x08, 0x1f, 0x00, 0x00, 0x00 },	// U+05E6 (צ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x11, 0x09, 0x05, 0x05, 0x01, 0x00 },	// U+05E7 (ק)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+05E8 (ר)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x13, 0x0e, 0x00, 0x00, 0x00 },	// U+05E9 (ש)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x11, 0x00, 0x00, 0x00 },	// U+05EA (ת)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+05EB (׫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+05EC (׬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05ED (׭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05EE (׮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05EF (ׯ)
}; // 32

static const unsigned char tewi_block35[][13] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x1f, 0x22, 0x2a, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0CA0 (ಠ)
}; // 1

static const unsigned char tewi_block36[][13] = {
	{ 0x00, 0x00, 0x04, 0x0f, 0x15, 0x15, 0x0f, 0x15, 0x15, 0x0f, 0x04, 0x00, 0x00 },	// U+0E3F (฿)
}; // 1

static const unsigned char tewi_block37[][13] = {
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x0b, 0x05, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+16A0 (ᚠ)
}; // 1

static const unsigned char tewi_block38[][13] = {
	{ 0x00, 0x00, 0x00, 0x03, 0x05, 0x09, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+16A2 (ᚢ)
	{ 0x00, 0x00, 0x00, 0x03, 0x05, 0x09, 0x11, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+16A3 (ᚣ)
}; // 2

static const unsigned char tewi_block39[][13] = {
	{ 0x00, 0x00, 0x00, 0x03, 0x05, 0x09, 0x13, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+16A5 (ᚥ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0c, 0x14, 0x0c, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+16A6 (ᚦ)
}; // 2

static const unsigned char tewi_block40[][13] = {
	{ 0x00, 0x00, 0x00, 0x06, 0x0a, 0x06, 0x0a, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+16A8 (ᚨ)
	{ 0x00, 0x00, 0x00, 0x11, 0x0b, 0x15, 0x0b, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+16A9 (ᚩ)
	{ 0x00, 0x00, 0x00, 0x11, 0x0b, 0x05, 0x03, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+16AA (ᚪ)
	{ 0x00, 0x00, 0x00, 0x03, 0x05, 0x0b, 0x05, 0x09, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+16AB (ᚫ)
	{ 0x00, 0x00, 0x00, 0x05, 0x06, 0x05, 0x0e, 0x14, 0x0c, 0x14, 0x00, 0x00, 0x00 },	// U+16AC (ᚬ)
}; // 5

static const unsigned char tewi_block41[][13] = {
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x0a, 0x04 },	// U+1E00 (Ḁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x04, 0x0a, 0x04 },	// U+1E01 (ḁ)
	{ 0x00, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+1E02 (Ḃ)
	{ 0x00, 0x00, 0x04, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+1E03 (ḃ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x04, 0x00 },	// U+1E04 (Ḅ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x04, 0x00 },	// U+1E05 (ḅ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x0e, 0x00 },	// U+1E06 (Ḇ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x0e, 0x00 },	// U+1E07 (ḇ)
	{ 0x00, 0x08, 0x04, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x04, 0x08, 0x04 },	// U+1E08 (Ḉ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x1e, 0x04, 0x08, 0x04 },	// U+1E09 (ḉ)
	{ 0x00, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+1E0A (Ḋ)
	{ 0x00, 0x00, 0x04, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00, 0x00 },	// U+1E0B (ḋ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x04, 0x00 },	// U+1E0C (Ḍ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x04, 0x00 },	// U+1E0D (ḍ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x0e, 0x00 },	// U+1E0E (Ḏ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x0e, 0x00 },	// U+1E0F (ḏ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0f, 0x04, 0x04, 0x02 },	// U+1E10 (Ḑ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x04, 0x04, 0x02 },	// U+1E11 (ḑ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x04, 0x0a },	// U+1E12 (Ḓ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x04, 0x0a },	// U+1E13 (ḓ)
	{ 0x00, 0x02, 0x0e, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+1E14 (Ḕ)
	{ 0x00, 0x02, 0x04, 0x0e, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+1E15 (ḕ)
	{ 0x00, 0x08, 0x0e, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+1E16 (Ḗ)
	{ 0x00, 0x08, 0x04, 0x0e, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+1E17 (ḗ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x04, 0x0a },	// U+1E18 (Ḙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x04, 0x0a },	// U+1E19 (ḙ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x16, 0x0d },	// U+1E1A (Ḛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x16, 0x0d },	// U+1E1B (ḛ)
	{ 0x00, 0x11, 0x0e, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x04, 0x08, 0x04 },	// U+1E1C (Ḝ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x04, 0x08, 0x04 },	// U+1E1D (ḝ)
	{ 0x00, 0x04, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+1E1E (Ḟ)
	{ 0x00, 0x04, 0x00, 0x0c, 0x02, 0x02, 0x07, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+1E1F (ḟ)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E20 (Ḡ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+1E21 (ḡ)
	{ 0x00, 0x04, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1E22 (Ḣ)
	{ 0x00, 0x00, 0x04, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1E23 (ḣ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x04, 0x00 },	// U+1E24 (Ḥ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x04, 0x00 },	// U+1E25 (ḥ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1E26 (Ḧ)
	{ 0x00, 0x0a, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1E27 (ḧ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x02, 0x01, 0x00 },	// U+1E28 (Ḩ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x02, 0x01, 0x00 },	// U+1E29 (ḩ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x11, 0x0e },	// U+1E2A (Ḫ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x11, 0x0e },	// U+1E2B (ḫ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x16, 0x0d },	// U+1E2C (Ḭ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x16, 0x0d },	// U+1E2D (ḭ)
	{ 0x00, 0x08, 0x0e, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+1E2E (Ḯ)
	{ 0x00, 0x08, 0x04, 0x0a, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+1E2F (ḯ)
	{ 0x00, 0x08, 0x04, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+1E30 (Ḱ)
	{ 0x00, 0x08, 0x04, 0x01, 0x01, 0x09, 0x05, 0x07, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+1E31 (ḱ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x04, 0x00 },	// U+1E32 (Ḳ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x09, 0x05, 0x07, 0x09, 0x11, 0x00, 0x04, 0x00 },	// U+1E33 (ḳ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x0e, 0x00 },	// U+1E34 (Ḵ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x09, 0x05, 0x07, 0x09, 0x11, 0x00, 0x0e, 0x00 },	// U+1E35 (ḵ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x04, 0x00 },	// U+1E36 (Ḷ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x04, 0x00 },	// U+1E37 (ḷ)
	{ 0x00, 0x0e, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x04, 0x00 },	// U+1E38 (Ḹ)
	{ 0x00, 0x0e, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x04, 0x00 },	// U+1E39 (ḹ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x0e, 0x00 },	// U+1E3A (Ḻ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x0e, 0x00 },	// U+1E3B (ḻ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x04, 0x0a },	// U+1E3C (Ḽ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x04, 0x0a },	// U+1E3D (ḽ)
	{ 0x00, 0x08, 0x04, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1E3E (Ḿ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+1E3F (ḿ)
	{ 0x00, 0x04, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1E40 (Ṁ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+1E41 (ṁ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x04, 0x00 },	// U+1E42 (Ṃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x00, 0x04, 0x00 },	// U+1E43 (ṃ)
	{ 0x00, 0x04, 0x00, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x00, 0x00, 0x00 },	// U+1E44 (Ṅ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1E45 (ṅ)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x00, 0x04, 0x00 },	// U+1E46 (Ṇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x04, 0x00 },	// U+1E47 (ṇ)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x00, 0x0e, 0x00 },	// U+1E48 (Ṉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x0e, 0x00 },	// U+1E49 (ṉ)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x00, 0x04, 0x0a },	// U+1E4A (Ṋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x04, 0x0a },	// U+1E4B (ṋ)
	{ 0x00, 0x08, 0x16, 0x0d, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E4C (Ṍ)
	{ 0x00, 0x08, 0x04, 0x16, 0x09, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E4D (ṍ)
	{ 0x00, 0x0a, 0x16, 0x09, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E4E (Ṏ)
	{ 0x00, 0x0a, 0x00, 0x16, 0x09, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E4F (ṏ)
	{ 0x00, 0x02, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E50 (Ṑ)
	{ 0x00, 0x02, 0x04, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E51 (ṑ)
	{ 0x00, 0x08, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E52 (Ṓ)
	{ 0x00, 0x08, 0x04, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E53 (ṓ)
	{ 0x00, 0x08, 0x04, 0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+1E54 (Ṕ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+1E55 (ṕ)
	{ 0x00, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+1E56 (Ṗ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+1E57 (ṗ)
	{ 0x00, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1E58 (Ṙ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+1E59 (ṙ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x11, 0x00, 0x04, 0x00 },	// U+1E5A (Ṛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x04, 0x00 },	// U+1E5B (ṛ)
	{ 0x00, 0x0e, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x11, 0x00, 0x04, 0x00 },	// U+1E5C (Ṝ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x04, 0x00 },	// U+1E5D (ṝ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x11, 0x00, 0x0e, 0x00 },	// U+1E5E (Ṟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x0e, 0x00 },	// U+1E5F (ṟ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E60 (Ṡ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+1E61 (ṡ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x04, 0x00 },	// U+1E62 (Ṣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x04, 0x00 },	// U+1E63 (ṣ)
	{ 0x00, 0x0c, 0x04, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E64 (Ṥ)
	{ 0x00, 0x02, 0x08, 0x04, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+1E65 (ṥ)
	{ 0x00, 0x0e, 0x04, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E66 (Ṧ)
	{ 0x00, 0x04, 0x00, 0x0a, 0x04, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+1E67 (ṧ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x04, 0x00 },	// U+1E68 (Ṩ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x04, 0x00 },	// U+1E69 (ṩ)
	{ 0x00, 0x04, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1E6A (Ṫ)
	{ 0x00, 0x04, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00 },	// U+1E6B (ṫ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04, 0x00 },	// U+1E6C (Ṭ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x18, 0x00, 0x04, 0x00 },	// U+1E6D (ṭ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x0e, 0x00 },	// U+1E6E (Ṯ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x18, 0x00, 0x0e, 0x00 },	// U+1E6F (ṯ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04, 0x0a },	// U+1E70 (Ṱ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x18, 0x00, 0x04, 0x0a },	// U+1E71 (ṱ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x0a, 0x00 },	// U+1E72 (Ṳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x0a, 0x00 },	// U+1E73 (ṳ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x16, 0x09 },	// U+1E74 (Ṵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x16, 0x09 },	// U+1E75 (ṵ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x04, 0x0a },	// U+1E76 (Ṷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x04, 0x0a },	// U+1E77 (ṷ)
	{ 0x00, 0x08, 0x16, 0x0d, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E78 (Ṹ)
	{ 0x00, 0x08, 0x16, 0x0d, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1E79 (ṹ)
	{ 0x00, 0x0a, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E7A (Ṻ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1E7B (ṻ)
	{ 0x00, 0x16, 0x0d, 0x11, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1E7C (Ṽ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+1E7D (ṽ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x04, 0x00 },	// U+1E7E (Ṿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x04, 0x00 },	// U+1E7F (ṿ)
	{ 0x00, 0x02, 0x04, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+1E80 (Ẁ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1E81 (ẁ)
	{ 0x00, 0x08, 0x04, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+1E82 (Ẃ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1E83 (ẃ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+1E84 (Ẅ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1E85 (ẅ)
	{ 0x00, 0x04, 0x00, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+1E86 (Ẇ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1E87 (ẇ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x0a, 0x00, 0x04, 0x00 },	// U+1E88 (Ẉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x00 },	// U+1E89 (ẉ)
	{ 0x00, 0x04, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1E8A (Ẋ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+1E8B (ẋ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1E8C (Ẍ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+1E8D (ẍ)
	{ 0x00, 0x04, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1E8E (Ẏ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+1E8F (ẏ)
	{ 0x00, 0x04, 0x0a, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+1E90 (Ẑ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+1E91 (ẑ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x04, 0x00 },	// U+1E92 (Ẓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x04, 0x00 },	// U+1E93 (ẓ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x0e, 0x00 },	// U+1E94 (Ẕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x0e, 0x00 },	// U+1E95 (ẕ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x0e, 0x00 },	// U+1E96 (ẖ)
	{ 0x00, 0x0a, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00 },	// U+1E97 (ẗ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1E98 (ẘ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+1E99 (ẙ)
	{ 0x00, 0x04, 0x08, 0x04, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1E9A (ẚ)
	{ 0x00, 0x08, 0x00, 0x18, 0x04, 0x06, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1E9B (ẛ)
	{ 0x00, 0x00, 0x00, 0x18, 0x04, 0x06, 0x0c, 0x06, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1E9C (ẜ)
	{ 0x00, 0x00, 0x00, 0x18, 0x0e, 0x04, 0x06, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1E9D (ẝ)
	{ 0x00, 0x00, 0x0c, 0x12, 0x11, 0x09, 0x09, 0x11, 0x11, 0x0d, 0x01, 0x00, 0x00 },	// U+1E9E (ẞ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1E9F (ẟ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x00, 0x00 },	// U+1EA0 (Ạ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x04, 0x00 },	// U+1EA1 (ạ)
	{ 0x00, 0x02, 0x04, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1EA2 (Ả)
	{ 0x00, 0x00, 0x04, 0x08, 0x04, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EA3 (ả)
	{ 0x00, 0x16, 0x0d, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1EA4 (Ấ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EA5 (ấ)
	{ 0x00, 0x0d, 0x16, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1EA6 (Ầ)
	{ 0x00, 0x00, 0x0d, 0x16, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EA7 (ầ)
	{ 0x00, 0x12, 0x25, 0x1e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1EA8 (Ẩ)
	{ 0x00, 0x00, 0x12, 0x25, 0x10, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EA9 (ẩ)
}; // 170

static const unsigned char tewi_block42[][13] = {
	{ 0x00, 0x16, 0x0d, 0x04, 0x0a, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EAB (ẫ)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x04, 0x00 },	// U+1EAC (Ậ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x04, 0x00 },	// U+1EAD (ậ)
	{ 0x00, 0x19, 0x0e, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1EAE (Ắ)
	{ 0x00, 0x08, 0x15, 0x0e, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EAF (ắ)
	{ 0x00, 0x13, 0x0e, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1EB0 (Ằ)
	{ 0x00, 0x02, 0x15, 0x0e, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EB1 (ằ)
	{ 0x00, 0x04, 0x19, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1EB2 (Ẳ)
	{ 0x00, 0x04, 0x19, 0x0e, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EB3 (ẳ)
}; // 9

static const unsigned char tewi_block43[][13] = {
	{ 0x00, 0x16, 0x0d, 0x11, 0x0e, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EB5 (ẵ)
	{ 0x00, 0x11, 0x0e, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x04, 0x00 },	// U+1EB6 (Ặ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x04, 0x00 },	// U+1EB7 (ặ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x04, 0x00 },	// U+1EB8 (Ẹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x04, 0x00 },	// U+1EB9 (ẹ)
	{ 0x00, 0x04, 0x08, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+1EBA (Ẻ)
	{ 0x00, 0x00, 0x04, 0x08, 0x04, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+1EBB (ẻ)
	{ 0x00, 0x16, 0x0d, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+1EBC (Ẽ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+1EBD (ẽ)
	{ 0x00, 0x22, 0x15, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+1EBE (Ế)
	{ 0x00, 0x00, 0x22, 0x15, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+1EBF (ế)
	{ 0x00, 0x11, 0x2a, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+1EC0 (Ề)
	{ 0x00, 0x00, 0x11, 0x2a, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+1EC1 (ề)
	{ 0x00, 0x12, 0x25, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+1EC2 (Ể)
	{ 0x00, 0x00, 0x12, 0x25, 0x10, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+1EC3 (ể)
}; // 15

static const unsigned char tewi_block44[][13] = {
	{ 0x00, 0x16, 0x0d, 0x04, 0x0a, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+1EC5 (ễ)
	{ 0x00, 0x04, 0x0a, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x04, 0x00 },	// U+1EC6 (Ệ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x1e, 0x00, 0x04, 0x00 },	// U+1EC7 (ệ)
	{ 0x00, 0x04, 0x08, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+1EC8 (Ỉ)
	{ 0x00, 0x00, 0x04, 0x08, 0x06, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+1EC9 (ỉ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x04, 0x00 },	// U+1ECA (Ị)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x04, 0x00 },	// U+1ECB (ị)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x04, 0x00 },	// U+1ECC (Ọ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x04, 0x00 },	// U+1ECD (ọ)
	{ 0x00, 0x04, 0x08, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1ECE (Ỏ)
	{ 0x00, 0x00, 0x04, 0x08, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1ECF (ỏ)
	{ 0x00, 0x22, 0x15, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1ED0 (Ố)
	{ 0x00, 0x00, 0x22, 0x15, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1ED1 (ố)
	{ 0x00, 0x11, 0x2a, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1ED2 (Ồ)
	{ 0x00, 0x02, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1ED3 (ồ)
	{ 0x00, 0x0a, 0x15, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1ED4 (Ổ)
	{ 0x00, 0x00, 0x02, 0x0d, 0x10, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1ED5 (ổ)
	{ 0x00, 0x16, 0x0d, 0x0a, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1ED6 (Ỗ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x0a, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1ED7 (ỗ)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x04, 0x00 },	// U+1ED8 (Ộ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x04, 0x00 },	// U+1ED9 (ộ)
	{ 0x00, 0x08, 0x24, 0x2e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EDA (Ớ)
	{ 0x00, 0x00, 0x04, 0x02, 0x20, 0x2e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EDB (ớ)
	{ 0x00, 0x02, 0x24, 0x2e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EDC (Ờ)
	{ 0x00, 0x00, 0x02, 0x04, 0x20, 0x2e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EDD (ờ)
	{ 0x00, 0x04, 0x28, 0x2e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EDE (Ở)
	{ 0x00, 0x00, 0x04, 0x08, 0x24, 0x2e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EDF (ở)
	{ 0x00, 0x16, 0x2d, 0x2e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EE0 (Ỡ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x20, 0x2e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EE1 (ỡ)
	{ 0x00, 0x00, 0x20, 0x2e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x04, 0x00 },	// U+1EE2 (Ợ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x2e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x04, 0x00 },	// U+1EE3 (ợ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x04, 0x00 },	// U+1EE4 (Ụ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x04, 0x00 },	// U+1EE5 (ụ)
	{ 0x00, 0x06, 0x08, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EE6 (Ủ)
	{ 0x00, 0x00, 0x06, 0x08, 0x04, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EE7 (ủ)
	{ 0x00, 0x28, 0x24, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EE8 (Ứ)
	{ 0x00, 0x00, 0x08, 0x24, 0x20, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EE9 (ứ)
	{ 0x00, 0x22, 0x24, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EEA (Ừ)
	{ 0x00, 0x00, 0x02, 0x24, 0x20, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EEB (ừ)
	{ 0x00, 0x26, 0x28, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EEC (Ử)
	{ 0x00, 0x00, 0x06, 0x28, 0x24, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EED (ử)
	{ 0x00, 0x36, 0x2d, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EEE (Ữ)
	{ 0x00, 0x00, 0x16, 0x2d, 0x20, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1EEF (ữ)
	{ 0x00, 0x20, 0x20, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x04, 0x00 },	// U+1EF0 (Ự)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x04, 0x00 },	// U+1EF1 (ự)
	{ 0x00, 0x02, 0x04, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1EF2 (Ỳ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+1EF3 (ỳ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x04, 0x00 },	// U+1EF4 (Ỵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x04 },	// U+1EF5 (ỵ)
	{ 0x00, 0x06, 0x08, 0x15, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1EF6 (Ỷ)
	{ 0x00, 0x00, 0x06, 0x08, 0x04, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+1EF7 (ỷ)
	{ 0x00, 0x16, 0x0d, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1EF8 (Ỹ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00 },	// U+1EF9 (ỹ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3f, 0x00, 0x00, 0x00 },	// U+1EFA (Ỻ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x0a, 0x1f, 0x0a, 0x0a, 0x0a, 0x1e, 0x00, 0x00, 0x00 },	// U+1EFB (ỻ)
	{ 0x00, 0x00, 0x00, 0x04, 0x02, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EFC (Ỽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x09, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1EFD (ỽ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x06, 0x05, 0x02, 0x00, 0x00 },	// U+1EFE (Ỿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x12, 0x0c, 0x00 },	// U+1EFF (ỿ)
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1F00 (ἀ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1F01 (ἁ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1F02 (ἂ)
	{ 0x00, 0x03, 0x09, 0x12, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1F03 (ἃ)
	{ 0x00, 0x03, 0x12, 0x09, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1F04 (ἄ)
	{ 0x00, 0x03, 0x11, 0x0a, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1F05 (ἅ)
	{ 0x00, 0x16, 0x0d, 0x08, 0x04, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1F06 (ἆ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x08, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1F07 (ἇ)
	{ 0x00, 0x03, 0x02, 0x0d, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+1F08 (Ἀ)
	{ 0x00, 0x03, 0x01, 0x0e, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+1F09 (Ἁ)
	{ 0x00, 0x0b, 0x12, 0x0d, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+1F0A (Ἂ)
	{ 0x00, 0x0b, 0x11, 0x0e, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+1F0B (Ἃ)
	{ 0x00, 0x13, 0x0a, 0x0d, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+1F0C (Ἄ)
	{ 0x00, 0x13, 0x09, 0x0e, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+1F0D (Ἅ)
	{ 0x00, 0x16, 0x0d, 0x18, 0x27, 0x26, 0x3d, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F0E (Ἆ)
	{ 0x00, 0x16, 0x0d, 0x18, 0x27, 0x25, 0x3e, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F0F (Ἇ)
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x07, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F10 (ἐ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x0e, 0x11, 0x07, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F11 (ἑ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x0e, 0x11, 0x07, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F12 (ἒ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x0e, 0x11, 0x07, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F13 (ἓ)
	{ 0x00, 0x03, 0x09, 0x12, 0x00, 0x0e, 0x11, 0x07, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F14 (ἔ)
	{ 0x00, 0x03, 0x11, 0x0a, 0x00, 0x0e, 0x11, 0x07, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F15 (ἕ)
}; // 81

static const unsigned char tewi_block45[][13] = {
	{ 0x00, 0x00, 0x03, 0x3e, 0x05, 0x04, 0x1c, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+1F18 (Ἐ)
	{ 0x00, 0x00, 0x03, 0x3d, 0x06, 0x04, 0x1c, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+1F19 (Ἑ)
	{ 0x00, 0x00, 0x03, 0x3e, 0x05, 0x05, 0x1e, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+1F1A (Ἒ)
	{ 0x00, 0x00, 0x03, 0x3d, 0x06, 0x05, 0x1e, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+1F1B (Ἓ)
	{ 0x00, 0x00, 0x03, 0x3e, 0x05, 0x06, 0x1d, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+1F1C (Ἔ)
	{ 0x00, 0x00, 0x03, 0x3d, 0x06, 0x06, 0x1d, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+1F1D (Ἕ)
}; // 6

static const unsigned char tewi_block46[][13] = {
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1F20 (ἠ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1F21 (ἡ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1F22 (ἢ)
	{ 0x00, 0x03, 0x09, 0x12, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1F23 (ἣ)
	{ 0x00, 0x03, 0x12, 0x09, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1F24 (ἤ)
	{ 0x00, 0x03, 0x11, 0x0a, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1F25 (ἥ)
	{ 0x00, 0x16, 0x0d, 0x08, 0x04, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1F26 (ἦ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x08, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1F27 (ἧ)
	{ 0x00, 0x00, 0x03, 0x26, 0x25, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F28 (Ἠ)
	{ 0x00, 0x00, 0x03, 0x25, 0x26, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F29 (Ἡ)
	{ 0x00, 0x00, 0x03, 0x26, 0x25, 0x25, 0x3e, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F2A (Ἢ)
	{ 0x00, 0x00, 0x03, 0x25, 0x26, 0x25, 0x3e, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F2B (Ἣ)
	{ 0x00, 0x00, 0x03, 0x26, 0x25, 0x26, 0x3d, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F2C (Ἤ)
	{ 0x00, 0x00, 0x03, 0x25, 0x26, 0x26, 0x3d, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F2D (Ἥ)
	{ 0x00, 0x16, 0x0d, 0x27, 0x26, 0x25, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F2E (Ἦ)
	{ 0x00, 0x16, 0x0d, 0x27, 0x25, 0x26, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F2F (Ἧ)
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1F30 (ἰ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1F31 (ἱ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1F32 (ἲ)
	{ 0x00, 0x03, 0x09, 0x12, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1F33 (ἳ)
	{ 0x00, 0x03, 0x12, 0x09, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1F34 (ἴ)
	{ 0x00, 0x03, 0x11, 0x0a, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1F35 (ἵ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x02, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1F36 (ἶ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x08, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1F37 (ἷ)
	{ 0x00, 0x00, 0x03, 0x1e, 0x09, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F38 (Ἰ)
	{ 0x00, 0x00, 0x03, 0x1d, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F39 (Ἱ)
	{ 0x00, 0x00, 0x03, 0x1e, 0x09, 0x09, 0x0a, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F3A (Ἲ)
	{ 0x00, 0x00, 0x03, 0x1d, 0x0a, 0x09, 0x0a, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F3B (Ἳ)
	{ 0x00, 0x00, 0x03, 0x1e, 0x09, 0x0a, 0x09, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F3C (Ἴ)
	{ 0x00, 0x00, 0x03, 0x1d, 0x0a, 0x0a, 0x09, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F3D (Ἵ)
	{ 0x00, 0x16, 0x0d, 0x1f, 0x0a, 0x09, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F3E (Ἶ)
	{ 0x00, 0x16, 0x0d, 0x1f, 0x09, 0x0a, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F3F (Ἷ)
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F40 (ὀ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F41 (ὁ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F42 (ὂ)
	{ 0x00, 0x03, 0x09, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F43 (ὃ)
	{ 0x00, 0x03, 0x12, 0x09, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F44 (ὄ)
	{ 0x00, 0x03, 0x11, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F45 (ὅ)
}; // 38

static const unsigned char tewi_block47[][13] = {
	{ 0x00, 0x00, 0x03, 0x1a, 0x25, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+1F48 (Ὀ)
	{ 0x00, 0x00, 0x03, 0x19, 0x26, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+1F49 (Ὁ)
	{ 0x00, 0x00, 0x03, 0x1a, 0x25, 0x25, 0x26, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+1F4A (Ὂ)
	{ 0x00, 0x00, 0x03, 0x19, 0x26, 0x25, 0x26, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+1F4B (Ὃ)
	{ 0x00, 0x00, 0x03, 0x1a, 0x25, 0x26, 0x25, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+1F4C (Ὄ)
	{ 0x00, 0x00, 0x03, 0x19, 0x26, 0x26, 0x25, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+1F4D (Ὅ)
}; // 6

static const unsigned char tewi_block48[][13] = {
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F50 (ὐ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F51 (ὑ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F52 (ὒ)
	{ 0x00, 0x03, 0x09, 0x12, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F53 (ὓ)
	{ 0x00, 0x03, 0x12, 0x09, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F54 (ὔ)
	{ 0x00, 0x03, 0x11, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F55 (ὕ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x02, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F56 (ὖ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x08, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F57 (ὗ)
}; // 8

static const unsigned char tewi_block49[][13] = {
	{ 0x00, 0x00, 0x03, 0x15, 0x16, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1F59 (Ὑ)
}; // 1

static const unsigned char tewi_block50[][13] = {
	{ 0x00, 0x00, 0x03, 0x15, 0x16, 0x15, 0x0a, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1F5B (Ὓ)
}; // 1

static const unsigned char tewi_block51[][13] = {
	{ 0x00, 0x00, 0x03, 0x15, 0x16, 0x16, 0x09, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1F5D (Ὕ)
}; // 1

static const unsigned char tewi_block52[][13] = {
	{ 0x00, 0x16, 0x0d, 0x17, 0x15, 0x16, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1F5F (Ὗ)
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1F60 (ὠ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1F61 (ὡ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1F62 (ὢ)
	{ 0x00, 0x03, 0x09, 0x12, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1F63 (ὣ)
	{ 0x00, 0x03, 0x12, 0x09, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1F64 (ὤ)
	{ 0x00, 0x03, 0x11, 0x0a, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1F65 (ὥ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x02, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1F66 (ὦ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x08, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1F67 (ὧ)
	{ 0x00, 0x00, 0x03, 0x1a, 0x25, 0x24, 0x24, 0x24, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+1F68 (Ὠ)
	{ 0x00, 0x00, 0x03, 0x19, 0x26, 0x24, 0x24, 0x24, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+1F69 (Ὡ)
	{ 0x00, 0x00, 0x03, 0x1a, 0x25, 0x25, 0x26, 0x24, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+1F6A (Ὢ)
	{ 0x00, 0x00, 0x03, 0x19, 0x26, 0x25, 0x26, 0x24, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+1F6B (Ὣ)
	{ 0x00, 0x00, 0x03, 0x1a, 0x25, 0x26, 0x25, 0x24, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+1F6C (Ὤ)
	{ 0x00, 0x00, 0x03, 0x19, 0x26, 0x26, 0x25, 0x24, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+1F6D (Ὥ)
	{ 0x00, 0x16, 0x0d, 0x1b, 0x26, 0x25, 0x24, 0x24, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+1F6E (Ὦ)
	{ 0x00, 0x16, 0x0d, 0x1b, 0x25, 0x26, 0x24, 0x24, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+1F6F (Ὧ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1F70 (ὰ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1F71 (ά)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x11, 0x07, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F72 (ὲ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x07, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F73 (έ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1F74 (ὴ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1F75 (ή)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1F76 (ὶ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1F77 (ί)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F78 (ὸ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F79 (ό)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F7A (ὺ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1F7B (ύ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1F7C (ὼ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1F7D (ώ)
}; // 31

static const unsigned char tewi_block53[][13] = {
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1F80 (ᾀ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1F81 (ᾁ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1F82 (ᾂ)
	{ 0x00, 0x03, 0x09, 0x12, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1F83 (ᾃ)
	{ 0x00, 0x03, 0x12, 0x09, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1F84 (ᾄ)
	{ 0x00, 0x03, 0x11, 0x0a, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1F85 (ᾅ)
	{ 0x00, 0x16, 0x0d, 0x08, 0x04, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1F86 (ᾆ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x08, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1F87 (ᾇ)
	{ 0x00, 0x03, 0x02, 0x0d, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x02, 0x04, 0x00 },	// U+1F88 (ᾈ)
	{ 0x00, 0x03, 0x01, 0x0e, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x02, 0x04, 0x00 },	// U+1F89 (ᾉ)
	{ 0x00, 0x0b, 0x12, 0x0d, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x02, 0x04, 0x00 },	// U+1F8A (ᾊ)
	{ 0x00, 0x0b, 0x11, 0x0e, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x02, 0x04, 0x00 },	// U+1F8B (ᾋ)
	{ 0x00, 0x13, 0x0a, 0x0d, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x02, 0x04, 0x00 },	// U+1F8C (ᾌ)
	{ 0x00, 0x13, 0x09, 0x0e, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x02, 0x04, 0x00 },	// U+1F8D (ᾍ)
	{ 0x00, 0x16, 0x0d, 0x18, 0x27, 0x26, 0x3d, 0x24, 0x24, 0x24, 0x04, 0x08, 0x00 },	// U+1F8E (ᾎ)
	{ 0x00, 0x16, 0x0d, 0x18, 0x27, 0x25, 0x3e, 0x24, 0x24, 0x24, 0x04, 0x08, 0x00 },	// U+1F8F (ᾏ)
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1F90 (ᾐ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1F91 (ᾑ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1F92 (ᾒ)
	{ 0x00, 0x03, 0x09, 0x12, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1F93 (ᾓ)
	{ 0x00, 0x03, 0x12, 0x09, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1F94 (ᾔ)
	{ 0x00, 0x03, 0x11, 0x0a, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1F95 (ᾕ)
	{ 0x00, 0x16, 0x0d, 0x08, 0x04, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1F96 (ᾖ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x08, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1F97 (ᾗ)
	{ 0x00, 0x00, 0x03, 0x26, 0x25, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x04, 0x08, 0x00 },	// U+1F98 (ᾘ)
	{ 0x00, 0x00, 0x03, 0x25, 0x26, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x04, 0x08, 0x00 },	// U+1F99 (ᾙ)
	{ 0x00, 0x00, 0x03, 0x26, 0x25, 0x25, 0x3e, 0x24, 0x24, 0x24, 0x04, 0x08, 0x00 },	// U+1F9A (ᾚ)
	{ 0x00, 0x00, 0x03, 0x25, 0x26, 0x25, 0x3e, 0x24, 0x24, 0x24, 0x04, 0x08, 0x00 },	// U+1F9B (ᾛ)
	{ 0x00, 0x00, 0x03, 0x26, 0x25, 0x26, 0x3d, 0x24, 0x24, 0x24, 0x04, 0x08, 0x00 },	// U+1F9C (ᾜ)
	{ 0x00, 0x00, 0x03, 0x25, 0x26, 0x26, 0x3d, 0x24, 0x24, 0x24, 0x04, 0x08, 0x00 },	// U+1F9D (ᾝ)
	{ 0x00, 0x16, 0x0d, 0x27, 0x26, 0x25, 0x3c, 0x24, 0x24, 0x24, 0x04, 0x08, 0x00 },	// U+1F9E (ᾞ)
	{ 0x00, 0x16, 0x0d, 0x27, 0x25, 0x26, 0x3c, 0x24, 0x24, 0x24, 0x04, 0x08, 0x00 },	// U+1F9F (ᾟ)
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FA0 (ᾠ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FA1 (ᾡ)
	{ 0x00, 0x03, 0x0a, 0x11, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FA2 (ᾢ)
	{ 0x00, 0x03, 0x09, 0x12, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FA3 (ᾣ)
	{ 0x00, 0x03, 0x12, 0x09, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FA4 (ᾤ)
	{ 0x00, 0x03, 0x11, 0x0a, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FA5 (ᾥ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x02, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FA6 (ᾦ)
	{ 0x00, 0x16, 0x0d, 0x04, 0x08, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FA7 (ᾧ)
	{ 0x00, 0x00, 0x03, 0x1a, 0x25, 0x24, 0x24, 0x24, 0x18, 0x3c, 0x04, 0x08, 0x00 },	// U+1FA8 (ᾨ)
	{ 0x00, 0x00, 0x03, 0x19, 0x26, 0x24, 0x24, 0x24, 0x18, 0x3c, 0x04, 0x08, 0x00 },	// U+1FA9 (ᾩ)
	{ 0x00, 0x00, 0x03, 0x1a, 0x25, 0x25, 0x26, 0x24, 0x18, 0x3c, 0x04, 0x08, 0x00 },	// U+1FAA (ᾪ)
	{ 0x00, 0x00, 0x03, 0x19, 0x26, 0x25, 0x26, 0x24, 0x18, 0x3c, 0x04, 0x08, 0x00 },	// U+1FAB (ᾫ)
	{ 0x00, 0x00, 0x03, 0x1a, 0x25, 0x26, 0x25, 0x24, 0x18, 0x3c, 0x04, 0x08, 0x00 },	// U+1FAC (ᾬ)
	{ 0x00, 0x00, 0x03, 0x19, 0x26, 0x26, 0x25, 0x24, 0x18, 0x3c, 0x04, 0x08, 0x00 },	// U+1FAD (ᾭ)
	{ 0x00, 0x16, 0x0d, 0x1b, 0x26, 0x25, 0x24, 0x24, 0x18, 0x3c, 0x04, 0x08, 0x00 },	// U+1FAE (ᾮ)
	{ 0x00, 0x16, 0x0d, 0x1b, 0x25, 0x26, 0x24, 0x24, 0x18, 0x3c, 0x04, 0x08, 0x00 },	// U+1FAF (ᾯ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1FB0 (ᾰ)
	{ 0x00, 0x00, 0x0e, 0x00, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1FB1 (ᾱ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1FB2 (ᾲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1FB3 (ᾳ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1FB4 (ᾴ)
}; // 53

static const unsigned char tewi_block54[][13] = {
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+1FB6 (ᾶ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x04, 0x08, 0x00 },	// U+1FB7 (ᾷ)
	{ 0x00, 0x11, 0x0e, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1FB8 (Ᾰ)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+1FB9 (Ᾱ)
	{ 0x00, 0x01, 0x02, 0x0c, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+1FBA (Ὰ)
	{ 0x00, 0x02, 0x01, 0x0c, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+1FBB (Ά)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x01, 0x02, 0x00 },	// U+1FBC (ᾼ)
	{ 0x00, 0x00, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FBD (᾽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00 },	// U+1FBE (ι)
	{ 0x00, 0x00, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FBF (᾿)
}; // 10

static const unsigned char tewi_block55[][13] = {
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1FC2 (ῂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1FC3 (ῃ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1FC4 (ῄ)
}; // 3

static const unsigned char tewi_block56[][13] = {
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00 },	// U+1FC6 (ῆ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00 },	// U+1FC7 (ῇ)
	{ 0x00, 0x00, 0x01, 0x3e, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+1FC8 (Ὲ)
	{ 0x00, 0x00, 0x02, 0x3d, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+1FC9 (Έ)
	{ 0x00, 0x00, 0x01, 0x26, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1FCA (Ὴ)
	{ 0x00, 0x00, 0x02, 0x25, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1FCB (Ή)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x01, 0x02, 0x00 },	// U+1FCC (ῌ)
	{ 0x00, 0x00, 0x03, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FCD (῍)
	{ 0x00, 0x00, 0x03, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FCE (῎)
	{ 0x00, 0x16, 0x0d, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FCF (῏)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1FD0 (ῐ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1FD1 (ῑ)
	{ 0x00, 0x02, 0x04, 0x11, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1FD2 (ῒ)
	{ 0x00, 0x08, 0x04, 0x11, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1FD3 (ΐ)
}; // 14

static const unsigned char tewi_block57[][13] = {
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1FD6 (ῖ)
	{ 0x00, 0x16, 0x0d, 0x00, 0x11, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+1FD7 (ῗ)
	{ 0x00, 0x16, 0x0d, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+1FD8 (Ῐ)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+1FD9 (Ῑ)
	{ 0x00, 0x00, 0x01, 0x1e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1FDA (Ὶ)
	{ 0x00, 0x00, 0x02, 0x1d, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1FDB (Ί)
}; // 6

static const unsigned char tewi_block58[][13] = {
	{ 0x00, 0x00, 0x03, 0x09, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FDD (῝)
	{ 0x00, 0x00, 0x03, 0x11, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FDE (῞)
	{ 0x00, 0x16, 0x0d, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FDF (῟)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1FE0 (ῠ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1FE1 (ῡ)
	{ 0x00, 0x02, 0x04, 0x11, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1FE2 (ῢ)
	{ 0x00, 0x08, 0x04, 0x11, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1FE3 (ΰ)
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+1FE4 (ῤ)
	{ 0x00, 0x0c, 0x04, 0x08, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+1FE5 (ῥ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1FE6 (ῦ)
	{ 0x00, 0x16, 0x0d, 0x11, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+1FE7 (ῧ)
	{ 0x00, 0x11, 0x0e, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1FE8 (Ῠ)
	{ 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1FE9 (Ῡ)
	{ 0x00, 0x00, 0x01, 0x16, 0x14, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1FEA (Ὺ)
	{ 0x00, 0x00, 0x02, 0x15, 0x14, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1FEB (Ύ)
	{ 0x00, 0x00, 0x03, 0x1d, 0x26, 0x24, 0x24, 0x1c, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1FEC (Ῥ)
	{ 0x00, 0x02, 0x04, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FED (῭)
	{ 0x00, 0x08, 0x04, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FEE (΅)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FEF (`)
}; // 19

static const unsigned char tewi_block59[][13] = {
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FF2 (ῲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FF3 (ῳ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FF4 (ῴ)
}; // 3

static const unsigned char tewi_block60[][13] = {
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+1FF6 (ῶ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x04, 0x08, 0x00 },	// U+1FF7 (ῷ)
	{ 0x00, 0x00, 0x01, 0x0e, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1FF8 (Ὸ)
	{ 0x00, 0x00, 0x02, 0x0d, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1FF9 (Ό)
	{ 0x00, 0x00, 0x01, 0x0e, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+1FFA (Ὼ)
	{ 0x00, 0x00, 0x02, 0x0d, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x1e, 0x00, 0x00, 0x00 },	// U+1FFB (Ώ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x04, 0x08, 0x00 },	// U+1FFC (ῼ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FFD (´)
	{ 0x00, 0x00, 0x0c, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FFE (῾)
}; // 9

static const unsigned char tewi_block61[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2010 (‐)
}; // 1

static const unsigned char tewi_block62[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2012 (‒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2013 (–)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2014 (—)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2015 (―)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00 },	// U+2016 (‖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x3f },	// U+2017 (‗)
	{ 0x00, 0x00, 0x08, 0x04, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2018 (‘)
	{ 0x00, 0x00, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2019 (’)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x04, 0x00 },	// U+201A (‚)
	{ 0x00, 0x00, 0x0c, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201B (‛)
	{ 0x00, 0x00, 0x14, 0x0a, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201C (“)
	{ 0x00, 0x00, 0x1e, 0x14, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201D (”)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x14, 0x0a, 0x00 },	// U+201E („)
	{ 0x00, 0x00, 0x1e, 0x0a, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201F (‟)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+2020 (†)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00 },	// U+2021 (‡)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x1f, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2022 (•)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x1f, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2023 (‣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+2024 (․)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2025 (‥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00 },	// U+2026 (…)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2027 (‧)
}; // 22

static const unsigned char tewi_block63[][13] = {
	{ 0x00, 0x00, 0x00, 0x12, 0x15, 0x0a, 0x04, 0x0a, 0x15, 0x0b, 0x00, 0x00, 0x00 },	// U+2030 (‰)
}; // 1

static const unsigned char tewi_block64[][13] = {
	{ 0x00, 0x00, 0x04, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2032 (′)
	{ 0x00, 0x00, 0x14, 0x14, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2033 (″)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2034 (‴)
	{ 0x00, 0x00, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2035 (‵)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2036 (‶)
	{ 0x00, 0x00, 0x15, 0x15, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2037 (‷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+2038 (‸)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x02, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2039 (‹)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+203A (›)
}; // 9

static const unsigned char tewi_block65[][13] = {
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x00 },	// U+203C (‼)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x14, 0x0c, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+203D (‽)
	{ 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+203E (‾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x00 },	// U+203F (‿)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2040 (⁀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x0a, 0x11, 0x00 },	// U+2041 (⁁)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x0a, 0x1f, 0x0a, 0x00, 0x00, 0x00 },	// U+2042 (⁂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2043 (⁃)
	{ 0x00, 0x00, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01, 0x00 },	// U+2044 (⁄)
	{ 0x00, 0x00, 0x0e, 0x02, 0x02, 0x02, 0x0e, 0x02, 0x02, 0x02, 0x0e, 0x00, 0x00 },	// U+2045 (⁅)
	{ 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x0e, 0x08, 0x08, 0x08, 0x0e, 0x00, 0x00 },	// U+2046 (⁆)
	{ 0x00, 0x00, 0x00, 0x0a, 0x15, 0x14, 0x0a, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x00 },	// U+2047 (⁇)
	{ 0x00, 0x00, 0x00, 0x12, 0x15, 0x14, 0x12, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00 },	// U+2048 (⁈)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x11, 0x09, 0x09, 0x00, 0x09, 0x00, 0x00, 0x00 },	// U+2049 (⁉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00 },	// U+204A (⁊)
	{ 0x00, 0x00, 0x1f, 0x3a, 0x3a, 0x3a, 0x1e, 0x0a, 0x0a, 0x0a, 0x0b, 0x00, 0x00 },	// U+204B (⁋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1b, 0x1b, 0x1a, 0x00, 0x00, 0x00, 0x00 },	// U+204C (⁌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x1b, 0x1b, 0x0b, 0x00, 0x00, 0x00, 0x00 },	// U+204D (⁍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+204E (⁎)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x04, 0x08, 0x00 },	// U+204F (⁏)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2050 (⁐)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x15, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2051 (⁑)
	{ 0x00, 0x00, 0x00, 0x09, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x09, 0x00, 0x00 },	// U+2052 (⁒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2053 (⁓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x00 },	// U+2054 (⁔)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+2055 (⁕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2056 (⁖)
}; // 27

static const unsigned char tewi_block66[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x11, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2058 (⁘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x04, 0x00, 0x11, 0x00, 0x00, 0x00 },	// U+2059 (⁙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00 },	// U+205A (⁚)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x11, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+205B (⁛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x04, 0x1f, 0x04, 0x15, 0x00, 0x00, 0x00 },	// U+205C (⁜)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x00 },	// U+205D (⁝)
	{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00 },	// U+205E (⁞)
}; // 7

static const unsigned char tewi_block67[][13] = {
	{ 0x00, 0x00, 0x04, 0x0a, 0x0e, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2070 (⁰)
	{ 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2071 (ⁱ)
}; // 2

static const unsigned char tewi_block68[][13] = {
	{ 0x00, 0x00, 0x02, 0x0a, 0x0e, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2074 (⁴)
	{ 0x00, 0x00, 0x0e, 0x02, 0x06, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2075 (⁵)
	{ 0x00, 0x00, 0x04, 0x02, 0x06, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2076 (⁶)
	{ 0x00, 0x00, 0x0e, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2077 (⁷)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2078 (⁸)
	{ 0x00, 0x00, 0x04, 0x0a, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2079 (⁹)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207A (⁺)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207B (⁻)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207C (⁼)
	{ 0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207D (⁽)
	{ 0x00, 0x00, 0x04, 0x08, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207E (⁾)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207F (ⁿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0e, 0x0a, 0x04, 0x00 },	// U+2080 (₀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x04, 0x04, 0x0e, 0x00 },	// U+2081 (₁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x04, 0x02, 0x0e, 0x00 },	// U+2082 (₂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x04, 0x08, 0x06, 0x00 },	// U+2083 (₃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0a, 0x0e, 0x08, 0x08, 0x00 },	// U+2084 (₄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x02, 0x06, 0x08, 0x06, 0x00 },	// U+2085 (₅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x06, 0x0a, 0x04, 0x00 },	// U+2086 (₆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x04, 0x04, 0x00 },	// U+2087 (₇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x00 },	// U+2088 (₈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0c, 0x08, 0x04, 0x00 },	// U+2089 (₉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+208A (₊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00 },	// U+208B (₋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x00 },	// U+208C (₌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x04, 0x00 },	// U+208D (₍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x08, 0x04, 0x00 },	// U+208E (₎)
}; // 27

static const unsigned char tewi_block69[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x0c, 0x0a, 0x0c, 0x00, 0x00 },	// U+2090 (ₐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0e, 0x02, 0x0c, 0x00, 0x00 },	// U+2091 (ₑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+2092 (ₒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x04, 0x04, 0x04, 0x0a, 0x00, 0x00 },	// U+2093 (ₓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x0e, 0x0a, 0x04, 0x00, 0x00 },	// U+2094 (ₔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x06, 0x0a, 0x0a, 0x00, 0x00 },	// U+2095 (ₕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0a, 0x06, 0x0a, 0x00, 0x00 },	// U+2096 (ₖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00 },	// U+2097 (ₗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2098 (ₘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2099 (ₙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0a, 0x0a, 0x06, 0x02, 0x02 },	// U+209A (ₚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0x08, 0x06, 0x00, 0x00 },	// U+209B (ₛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x04, 0x08, 0x00, 0x00 },	// U+209C (ₜ)
}; // 13

static const unsigned char tewi_block70[][13] = {
	{ 0x00, 0x00, 0x00, 0x0e, 0x01, 0x1d, 0x05, 0x1e, 0x04, 0x1c, 0x00, 0x00, 0x00 },	// U+20A0 (₠)
	{ 0x00, 0x00, 0x28, 0x2e, 0x15, 0x15, 0x15, 0x0b, 0x1b, 0x0e, 0x05, 0x05, 0x00 },	// U+20A1 (₡)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x15, 0x0d, 0x05, 0x1e, 0x00, 0x00, 0x00 },	// U+20A2 (₢)
	{ 0x00, 0x00, 0x00, 0x1e, 0x02, 0x0f, 0x02, 0x0f, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+20A3 (₣)
	{ 0x00, 0x00, 0x0c, 0x12, 0x07, 0x02, 0x07, 0x02, 0x12, 0x0d, 0x00, 0x00, 0x00 },	// U+20A4 (₤)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0b, 0x15, 0x15, 0x15, 0x17, 0x02, 0x00, 0x00 },	// U+20A5 (₥)
	{ 0x00, 0x00, 0x00, 0x13, 0x13, 0x1f, 0x15, 0x1f, 0x19, 0x19, 0x00, 0x00, 0x00 },	// U+20A6 (₦)
}; // 7

static const unsigned char tewi_block71[][13] = {
	{ 0x00, 0x00, 0x00, 0x03, 0x15, 0x0d, 0x0b, 0x15, 0x15, 0x0d, 0x00, 0x00, 0x00 },	// U+20A8 (₨)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x15, 0x1f, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+20A9 (₩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x29, 0x2d, 0x25, 0x3d, 0x00, 0x00, 0x00 },	// U+20AA (₪)
	{ 0x00, 0x00, 0x08, 0x1c, 0x08, 0x0e, 0x09, 0x09, 0x09, 0x0e, 0x00, 0x0e, 0x00 },	// U+20AB (₫)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x07, 0x02, 0x07, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+20AC (€)
	{ 0x00, 0x00, 0x00, 0x12, 0x12, 0x0a, 0x1f, 0x0a, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+20AD (₭)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x0c, 0x06, 0x0c, 0x06, 0x04, 0x00, 0x00, 0x00 },	// U+20AE (₮)
	{ 0x00, 0x00, 0x00, 0x03, 0x05, 0x05, 0x0d, 0x15, 0x15, 0x0f, 0x04, 0x04, 0x04 },	// U+20AF (₯)
}; // 8

static const unsigned char tewi_block72[][13] = {
	{ 0x00, 0x00, 0x0e, 0x3f, 0x12, 0x3f, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+20B1 (₱)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x05, 0x1d, 0x15, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+20B2 (₲)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+20B3 (₳)
}; // 3

static const unsigned char tewi_block73[][13] = {
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x05, 0x05, 0x05, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+20B5 (₵)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x1f, 0x0a, 0x0a, 0x0a, 0x12, 0x00, 0x00, 0x00 },	// U+20B6 (₶)
}; // 2

static const unsigned char tewi_block74[][13] = {
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+20B8 (₸)
	{ 0x00, 0x00, 0x00, 0x1f, 0x08, 0x1f, 0x08, 0x07, 0x02, 0x04, 0x08, 0x00, 0x00 },	// U+20B9 (₹)
	{ 0x00, 0x00, 0x00, 0x02, 0x06, 0x03, 0x16, 0x13, 0x0a, 0x06, 0x00, 0x00, 0x00 },	// U+20BA (₺)
}; // 3

static const unsigned char tewi_block75[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+20BC (₼)
	{ 0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x0f, 0x02, 0x07, 0x02, 0x00, 0x00, 0x00 },	// U+20BD (₽)
}; // 2

static const unsigned char tewi_block76[][13] = {
	{ 0x00, 0x00, 0x00, 0x0e, 0x09, 0x1d, 0x0b, 0x04, 0x1a, 0x05, 0x04, 0x18, 0x00 },	// U+2100 (℀)
	{ 0x00, 0x00, 0x00, 0x0e, 0x09, 0x1d, 0x0b, 0x04, 0x1a, 0x05, 0x08, 0x10, 0x0c },	// U+2101 (℁)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x05, 0x05, 0x05, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+2102 (ℂ)
	{ 0x00, 0x02, 0x05, 0x1a, 0x24, 0x04, 0x04, 0x04, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+2103 (℃)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x05, 0x05, 0x1e, 0x04, 0x1c, 0x00, 0x00, 0x00 },	// U+2104 (℄)
	{ 0x00, 0x00, 0x00, 0x06, 0x01, 0x11, 0x0e, 0x04, 0x0a, 0x15, 0x14, 0x08, 0x00 },	// U+2105 (℅)
	{ 0x00, 0x00, 0x00, 0x06, 0x01, 0x11, 0x0e, 0x04, 0x02, 0x15, 0x14, 0x14, 0x08 },	// U+2106 (℆)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x06, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2107 (ℇ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x1c, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2108 (℈)
	{ 0x00, 0x02, 0x05, 0x3e, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2109 (℉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x19, 0x11, 0x11, 0x1e, 0x11, 0x11, 0x0e },	// U+210A (ℊ)
	{ 0x00, 0x00, 0x00, 0x0b, 0x1a, 0x1a, 0x0e, 0x0b, 0x0b, 0x12, 0x00, 0x00, 0x00 },	// U+210B (ℋ)
}; // 12

static const unsigned char tewi_block77[][13] = {
	{ 0x00, 0x00, 0x00, 0x09, 0x09, 0x1b, 0x2f, 0x1d, 0x09, 0x39, 0x00, 0x00, 0x00 },	// U+2116 (№)
	{ 0x00, 0x00, 0x00, 0x0f, 0x10, 0x13, 0x15, 0x13, 0x11, 0x10, 0x0f, 0x00, 0x00 },	// U+2117 (℗)
}; // 2

static const unsigned char tewi_block78[][13] = {
	{ 0x00, 0x00, 0x00, 0x2f, 0x3a, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2122 (™)
}; // 1

static const unsigned char tewi_block79[][13] = {
	{ 0x00, 0x00, 0x1f, 0x08, 0x04, 0x1f, 0x08, 0x04, 0x0e, 0x10, 0x10, 0x11, 0x0e },	// U+2125 (℥)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00, 0x00 },	// U+2126 (Ω)
	{ 0x00, 0x00, 0x00, 0x1b, 0x0a, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2127 (℧)
}; // 3

static const unsigned char tewi_block80[][13] = {
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00, 0x00 },	// U+212A (K)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+212B (Å)
}; // 2

static const unsigned char tewi_block81[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x07, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+212F (ℯ)
}; // 1

static const unsigned char tewi_block82[][13] = {
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x1e, 0x1e, 0x16, 0x15, 0x31, 0x00, 0x00, 0x00 },	// U+2133 (ℳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x29, 0x19, 0x09, 0x06, 0x00, 0x00, 0x00 },	// U+2134 (ℴ)
}; // 2

static const unsigned char tewi_block83[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2160 (Ⅰ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+2161 (Ⅱ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+2162 (Ⅲ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x09, 0x09, 0x00, 0x00, 0x00 },	// U+2163 (Ⅳ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2164 (Ⅴ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+2165 (Ⅵ)
	{ 0x00, 0x00, 0x00, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+2166 (Ⅶ)
}; // 7

static const unsigned char tewi_block84[][13] = {
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x09, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+2168 (Ⅸ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x04, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+2169 (Ⅹ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x12, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+216A (Ⅺ)
	{ 0x00, 0x00, 0x00, 0x2d, 0x2d, 0x2d, 0x2a, 0x2d, 0x2d, 0x2d, 0x00, 0x00, 0x00 },	// U+216B (Ⅻ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+216C (Ⅼ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+216D (Ⅽ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+216E (Ⅾ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+216F (Ⅿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2170 (ⅰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+2171 (ⅱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+2172 (ⅲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x14, 0x15, 0x15, 0x09, 0x09, 0x00, 0x00, 0x00 },	// U+2173 (ⅳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2174 (ⅴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x05, 0x15, 0x15, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+2175 (ⅵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2d, 0x05, 0x2d, 0x2d, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+2176 (ⅶ)
}; // 15

static const unsigned char tewi_block85[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x14, 0x15, 0x09, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+2178 (ⅸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x04, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+2179 (ⅹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x05, 0x15, 0x12, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+217A (ⅺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x05, 0x2d, 0x2a, 0x2d, 0x2d, 0x00, 0x00, 0x00 },	// U+217B (ⅻ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+217C (ⅼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+217D (ⅽ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00, 0x00 },	// U+217E (ⅾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+217F (ⅿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+2180 (ↀ)
}; // 9

static const unsigned char tewi_block86[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+2183 (Ↄ)
}; // 1

static const unsigned char tewi_block87[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2190 (←)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2191 (↑)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2192 (→)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2193 (↓)
}; // 4

static const unsigned char tewi_block88[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2195 (↕)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x05, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2196 (↖)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x14, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+2197 (↗)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x14, 0x18, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2198 (↘)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x05, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+2199 (↙)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x22, 0x3f, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+219A (↚)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x12, 0x3f, 0x11, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+219B (↛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x13, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+219C (↜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x32, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+219D (↝)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x3f, 0x0a, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+219E (↞)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x0e, 0x15, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+219F (↟)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x14, 0x3f, 0x14, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+21A0 (↠)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x15, 0x0e, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+21A1 (↡)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x12, 0x0f, 0x12, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+21A2 (↢)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x3c, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+21A3 (↣)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x12, 0x1f, 0x12, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+21A4 (↤)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+21A5 (↥)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x09, 0x1f, 0x09, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+21A6 (↦)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21A7 (↧)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x15, 0x0e, 0x1f, 0x00, 0x00, 0x00 },	// U+21A8 (↨)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x22, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21A9 (↩)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x3e, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21AA (↪)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x1f, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21AB (↫)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x3e, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21AC (↬)
}; // 24

static const unsigned char tewi_block89[][13] = {
	{ 0x00, 0x00, 0x10, 0x08, 0x04, 0x1e, 0x08, 0x05, 0x03, 0x07, 0x00, 0x00, 0x00 },	// U+21AF (↯)
	{ 0x00, 0x00, 0x00, 0x04, 0x02, 0x1f, 0x12, 0x14, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+21B0 (↰)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x09, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+21B1 (↱)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x12, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+21B2 (↲)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x05, 0x09, 0x1f, 0x08, 0x04, 0x00, 0x00, 0x00 },	// U+21B3 (↳)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21B4 (↴)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x12, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21B5 (↵)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21B6 (↶)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21B7 (↷)
	{ 0x00, 0x00, 0x1f, 0x00, 0x07, 0x03, 0x05, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+21B8 (↸)
	{ 0x00, 0x00, 0x14, 0x18, 0x1f, 0x18, 0x15, 0x03, 0x1f, 0x03, 0x05, 0x00, 0x00 },	// U+21B9 (↹)
	{ 0x00, 0x00, 0x00, 0x1c, 0x0c, 0x15, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+21BA (↺)
	{ 0x00, 0x00, 0x00, 0x07, 0x06, 0x15, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+21BB (↻)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21BC (↼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21BD (↽)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21BE (↾)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x05, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21BF (↿)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21C0 (⇀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21C1 (⇁)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21C2 (⇂)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x05, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21C3 (⇃)
	{ 0x00, 0x00, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+21C4 (⇄)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x17, 0x12, 0x3a, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+21C5 (⇅)
	{ 0x00, 0x00, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+21C6 (⇆)
	{ 0x00, 0x00, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+21C7 (⇇)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x3f, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+21C8 (⇈)
	{ 0x00, 0x00, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+21C9 (⇉)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x3f, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+21CA (⇊)
	{ 0x00, 0x00, 0x00, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+21CB (⇋)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x00, 0x00, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+21CC (⇌)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x1e, 0x09, 0x1e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21CD (⇍)
}; // 31

static const unsigned char tewi_block90[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0f, 0x12, 0x0f, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+21CF (⇏)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1e, 0x01, 0x1e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21D0 (⇐)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+21D1 (⇑)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0f, 0x10, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21D2 (⇒)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x1b, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21D3 (⇓)
}; // 5

static const unsigned char tewi_block91[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x1b, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+21D5 (⇕)
	{ 0x00, 0x00, 0x00, 0x07, 0x05, 0x0b, 0x14, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+21D6 (⇖)
	{ 0x00, 0x00, 0x00, 0x1c, 0x14, 0x1a, 0x05, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+21D7 (⇗)
	{ 0x00, 0x00, 0x00, 0x01, 0x02, 0x05, 0x1a, 0x14, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+21D8 (⇘)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x14, 0x0b, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+21D9 (⇙)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x02, 0x1f, 0x02, 0x1c, 0x08, 0x00, 0x00 },	// U+21DA (⇚)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x10, 0x3e, 0x10, 0x0e, 0x04, 0x00, 0x00 },	// U+21DB (⇛)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x12, 0x2f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21DC (⇜)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x12, 0x3d, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21DD (⇝)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x1f, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+21DE (⇞)
	{ 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x1f, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+21DF (⇟)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x2b, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21E0 (⇠)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x11, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21E1 (⇡)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x35, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21E2 (⇢)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x11, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21E3 (⇣)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x03, 0x1f, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+21E4 (⇤)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x18, 0x1f, 0x18, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+21E5 (⇥)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1e, 0x11, 0x1e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21E6 (⇦)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+21E7 (⇧)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0f, 0x11, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21E8 (⇨)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x1b, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21E9 (⇩)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x0e, 0x00, 0x0e, 0x0a, 0x0e, 0x00, 0x00 },	// U+21EA (⇪)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x1b, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+21EB (⇫)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1f, 0x0a, 0x1b, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+21EC (⇬)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x0e, 0x1f, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+21ED (⇭)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1f, 0x0a, 0x1b, 0x0a, 0x0e, 0x00, 0x00, 0x00 },	// U+21EE (⇮)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1f, 0x0a, 0x1b, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+21EF (⇯)
}; // 27

static const unsigned char tewi_block92[][13] = {
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x1d, 0x0d, 0x15, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+21F1 (⇱)
	{ 0x00, 0x00, 0x00, 0x01, 0x2a, 0x2c, 0x2e, 0x20, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+21F2 (⇲)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x1b, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+21F3 (⇳)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x12, 0x3d, 0x12, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21F4 (⇴)
	{ 0x00, 0x00, 0x00, 0x12, 0x3a, 0x12, 0x12, 0x17, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+21F5 (⇵)
	{ 0x00, 0x00, 0x04, 0x08, 0x1f, 0x08, 0x1f, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+21F6 (⇶)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x12, 0x3f, 0x12, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+21F7 (⇷)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x12, 0x3f, 0x12, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+21F8 (⇸)
}; // 8

static const unsigned char tewi_block93[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x2a, 0x3f, 0x2a, 0x04, 0x00, 0x00, 0x00 },	// U+21FA (⇺)
}; // 1

static const unsigned char tewi_block94[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x1d, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21FD (⇽)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x17, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21FE (⇾)
}; // 2

static const unsigned char tewi_block95[][13] = {
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2200 (∀)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x01, 0x09, 0x09, 0x06, 0x00, 0x00, 0x00 },	// U+2201 (∁)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x10, 0x16, 0x19, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2202 (∂)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x1f, 0x00, 0x00, 0x00 },	// U+2203 (∃)
	{ 0x00, 0x10, 0x10, 0x1f, 0x18, 0x18, 0x1f, 0x14, 0x14, 0x1f, 0x02, 0x02, 0x00 },	// U+2204 (∄)
	{ 0x00, 0x00, 0x00, 0x16, 0x09, 0x19, 0x15, 0x13, 0x12, 0x0d, 0x00, 0x00, 0x00 },	// U+2205 (∅)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+2206 (∆)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2207 (∇)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x01, 0x1f, 0x01, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+2208 (∈)
	{ 0x00, 0x10, 0x10, 0x1c, 0x0a, 0x09, 0x1f, 0x05, 0x06, 0x1e, 0x02, 0x02, 0x00 },	// U+2209 (∉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x1f, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+220A (∊)
	{ 0x00, 0x00, 0x00, 0x07, 0x08, 0x10, 0x1f, 0x10, 0x08, 0x07, 0x00, 0x00, 0x00 },	// U+220B (∋)
	{ 0x00, 0x10, 0x10, 0x17, 0x08, 0x18, 0x1f, 0x14, 0x0c, 0x07, 0x02, 0x02, 0x00 },	// U+220C (∌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x1e, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+220D (∍)
	{ 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+220E (∎)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+220F (∏)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+2210 (∐)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x02, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+2211 (∑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2212 (−)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2213 (∓)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+2214 (∔)
	{ 0x00, 0x00, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01, 0x00 },	// U+2215 (∕)
	{ 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x00 },	// U+2216 (∖)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x15, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2217 (∗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2218 (∘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0f, 0x0f, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2219 (∙)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x08, 0x0b, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+221A (√)
	{ 0x00, 0x03, 0x04, 0x13, 0x14, 0x13, 0x08, 0x0b, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+221B (∛)
	{ 0x00, 0x01, 0x05, 0x17, 0x14, 0x14, 0x08, 0x0b, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+221C (∜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x09, 0x09, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+221D (∝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+221E (∞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+221F (∟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+2220 (∠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0c, 0x0c, 0x0a, 0x1f, 0x08, 0x00, 0x00 },	// U+2221 (∡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x06, 0x06, 0x05, 0x06, 0x06, 0x08 },	// U+2222 (∢)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2223 (∣)
	{ 0x00, 0x00, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x06, 0x05, 0x04, 0x04, 0x00, 0x00 },	// U+2224 (∤)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2225 (∥)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x1a, 0x0e, 0x0b, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2226 (∦)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+2227 (∧)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2228 (∨)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+2229 (∩)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+222A (∪)
	{ 0x00, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x00 },	// U+222B (∫)
	{ 0x00, 0x14, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x05, 0x00 },	// U+222C (∬)
}; // 45

static const unsigned char tewi_block96[][13] = {
	{ 0x00, 0x08, 0x04, 0x04, 0x04, 0x0e, 0x15, 0x0e, 0x04, 0x04, 0x04, 0x02, 0x00 },	// U+222E (∮)
	{ 0x00, 0x14, 0x0a, 0x0a, 0x0a, 0x0e, 0x1b, 0x0e, 0x0a, 0x0a, 0x0a, 0x05, 0x00 },	// U+222F (∯)
}; // 2

static const unsigned char tewi_block97[][13] = {
	{ 0x00, 0x08, 0x04, 0x04, 0x04, 0x2e, 0x35, 0x3c, 0x04, 0x04, 0x04, 0x02, 0x00 },	// U+2231 (∱)
	{ 0x00, 0x08, 0x04, 0x04, 0x04, 0x2e, 0x35, 0x3e, 0x04, 0x04, 0x04, 0x02, 0x00 },	// U+2232 (∲)
	{ 0x00, 0x08, 0x04, 0x04, 0x04, 0x3e, 0x35, 0x2e, 0x04, 0x04, 0x04, 0x02, 0x00 },	// U+2233 (∳)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2234 (∴)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2235 (∵)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2236 (∶)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2237 (∷)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2238 (∸)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x07, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2239 (∹)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x1f, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+223A (∺)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x16, 0x0d, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+223B (∻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+223C (∼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+223D (∽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x25, 0x29, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+223E (∾)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x15, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+223F (∿)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x04, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+2240 (≀)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x16, 0x0d, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2241 (≁)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2242 (≂)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2243 (≃)
	{ 0x00, 0x00, 0x08, 0x08, 0x16, 0x0d, 0x04, 0x1f, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+2244 (≄)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+2245 (≅)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x04, 0x1f, 0x02, 0x00, 0x00 },	// U+2246 (≆)
	{ 0x00, 0x00, 0x08, 0x08, 0x16, 0x0d, 0x04, 0x1f, 0x02, 0x1f, 0x02, 0x00, 0x00 },	// U+2247 (≇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x09, 0x16, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+2248 (≈)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x16, 0x0d, 0x16, 0x0b, 0x02, 0x00, 0x00, 0x00 },	// U+2249 (≉)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x09, 0x16, 0x09, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+224A (≊)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x09, 0x16, 0x09, 0x16, 0x09, 0x00, 0x00, 0x00 },	// U+224B (≋)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+224C (≌)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+224D (≍)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1b, 0x00, 0x1b, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+224E (≎)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1b, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+224F (≏)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2250 (≐)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2251 (≑)
	{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+2252 (≒)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x01, 0x00, 0x00, 0x00 },	// U+2253 (≓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2254 (≔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2255 (≕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2256 (≖)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2257 (≗)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2258 (≘)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2259 (≙)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+225A (≚)
	{ 0x00, 0x15, 0x0e, 0x15, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+225B (≛)
	{ 0x00, 0x04, 0x0a, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+225C (≜)
}; // 44

static const unsigned char tewi_block98[][13] = {
	{ 0x00, 0x00, 0x0f, 0x15, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+225E (≞)
	{ 0x00, 0x04, 0x08, 0x04, 0x00, 0x04, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+225F (≟)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x04, 0x1f, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2260 (≠)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2261 (≡)
	{ 0x00, 0x00, 0x00, 0x10, 0x1f, 0x08, 0x1f, 0x02, 0x1f, 0x01, 0x00, 0x00, 0x00 },	// U+2262 (≢)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+2263 (≣)
	{ 0x00, 0x00, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+2264 (≤)
	{ 0x00, 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+2265 (≥)
	{ 0x00, 0x00, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2266 (≦)
	{ 0x00, 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2267 (≧)
	{ 0x00, 0x00, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x08, 0x1f, 0x04, 0x1f, 0x02 },	// U+2268 (≨)
	{ 0x00, 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x08, 0x1f, 0x04, 0x1f, 0x02 },	// U+2269 (≩)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x05, 0x0a, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+226A (≪)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x14, 0x0a, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+226B (≫)
	{ 0x00, 0x00, 0x0a, 0x04, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x04, 0x0a, 0x00, 0x00 },	// U+226C (≬)
	{ 0x00, 0x00, 0x00, 0x08, 0x19, 0x0e, 0x04, 0x0e, 0x13, 0x02, 0x00, 0x00, 0x00 },	// U+226D (≭)
	{ 0x00, 0x00, 0x08, 0x08, 0x18, 0x06, 0x05, 0x06, 0x1a, 0x02, 0x02, 0x00, 0x00 },	// U+226E (≮)
	{ 0x00, 0x00, 0x08, 0x08, 0x0b, 0x0c, 0x14, 0x0c, 0x03, 0x02, 0x02, 0x00, 0x00 },	// U+226F (≯)
	{ 0x00, 0x08, 0x08, 0x18, 0x06, 0x05, 0x06, 0x1a, 0x02, 0x1f, 0x01, 0x01, 0x00 },	// U+2270 (≰)
	{ 0x00, 0x00, 0x08, 0x0b, 0x0c, 0x14, 0x0c, 0x03, 0x02, 0x1f, 0x01, 0x01, 0x00 },	// U+2271 (≱)
	{ 0x00, 0x00, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2272 (≲)
	{ 0x00, 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2273 (≳)
	{ 0x00, 0x00, 0x08, 0x18, 0x06, 0x05, 0x06, 0x1a, 0x02, 0x16, 0x0d, 0x01, 0x00 },	// U+2274 (≴)
	{ 0x00, 0x00, 0x08, 0x0b, 0x0c, 0x14, 0x0c, 0x03, 0x02, 0x16, 0x0d, 0x01, 0x00 },	// U+2275 (≵)
	{ 0x00, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00 },	// U+2276 (≶)
	{ 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00 },	// U+2277 (≷)
	{ 0x00, 0x04, 0x1c, 0x06, 0x05, 0x06, 0x1c, 0x07, 0x0c, 0x14, 0x0c, 0x07, 0x04 },	// U+2278 (≸)
	{ 0x00, 0x04, 0x07, 0x0c, 0x14, 0x0c, 0x07, 0x1c, 0x06, 0x05, 0x06, 0x1c, 0x04 },	// U+2279 (≹)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x0c, 0x03, 0x0c, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+227A (≺)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x18, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+227B (≻)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x0c, 0x03, 0x0c, 0x13, 0x0c, 0x10, 0x00, 0x00 },	// U+227C (≼)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x18, 0x06, 0x19, 0x06, 0x01, 0x00, 0x00 },	// U+227D (≽)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x0c, 0x03, 0x0c, 0x10, 0x00, 0x16, 0x0d, 0x00 },	// U+227E (≾)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x18, 0x06, 0x01, 0x00, 0x16, 0x0d, 0x00 },	// U+227F (≿)
	{ 0x00, 0x00, 0x08, 0x08, 0x18, 0x0c, 0x07, 0x0c, 0x12, 0x02, 0x02, 0x00, 0x00 },	// U+2280 (⊀)
	{ 0x00, 0x00, 0x08, 0x08, 0x09, 0x06, 0x1c, 0x06, 0x03, 0x02, 0x02, 0x00, 0x00 },	// U+2281 (⊁)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2282 (⊂)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+2283 (⊃)
	{ 0x00, 0x00, 0x08, 0x08, 0x1e, 0x05, 0x05, 0x05, 0x1e, 0x02, 0x02, 0x00, 0x00 },	// U+2284 (⊄)
	{ 0x00, 0x00, 0x08, 0x08, 0x0f, 0x14, 0x14, 0x14, 0x0f, 0x02, 0x02, 0x00, 0x00 },	// U+2285 (⊅)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x1e, 0x00, 0x1f, 0x00, 0x00 },	// U+2286 (⊆)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x1f, 0x00, 0x00 },	// U+2287 (⊇)
	{ 0x00, 0x00, 0x08, 0x08, 0x1e, 0x05, 0x05, 0x05, 0x1e, 0x02, 0x1f, 0x00, 0x00 },	// U+2288 (⊈)
	{ 0x00, 0x00, 0x08, 0x08, 0x0f, 0x14, 0x14, 0x14, 0x0f, 0x02, 0x1f, 0x00, 0x00 },	// U+2289 (⊉)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x1e, 0x08, 0x1f, 0x02, 0x00 },	// U+228A (⊊)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x0f, 0x08, 0x1f, 0x02, 0x00 },	// U+228B (⊋)
	{ 0x00, 0x00, 0x00, 0x15, 0x17, 0x1f, 0x17, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+228C (⊌)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x15, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+228D (⊍)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x15, 0x1f, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+228E (⊎)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+228F (⊏)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2290 (⊐)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2291 (⊑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x1f, 0x00 },	// U+2292 (⊒)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2293 (⊓)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2294 (⊔)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x1f, 0x15, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2295 (⊕)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2296 (⊖)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x15, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2297 (⊗)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x19, 0x15, 0x13, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2298 (⊘)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2299 (⊙)
}; // 60

static const unsigned char tewi_block99[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+229B (⊛)
}; // 1

static const unsigned char tewi_block100[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+229D (⊝)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x1f, 0x15, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+229E (⊞)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x1f, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+229F (⊟)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1b, 0x15, 0x1b, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+22A0 (⊠)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+22A1 (⊡)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x1f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+22A2 (⊢)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+22A3 (⊣)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+22A4 (⊤)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+22A5 (⊥)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+22A6 (⊦)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x0e, 0x02, 0x0e, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+22A7 (⊧)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x1f, 0x01, 0x1f, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+22A8 (⊨)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x1d, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+22A9 (⊩)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x35, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+22AA (⊪)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x1d, 0x05, 0x1d, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+22AB (⊫)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x1f, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+22AC (⊬)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x1f, 0x09, 0x1f, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+22AD (⊭)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x3d, 0x0d, 0x0d, 0x00, 0x00, 0x00, 0x00 },	// U+22AE (⊮)
	{ 0x00, 0x00, 0x00, 0x00, 0x25, 0x3d, 0x15, 0x3d, 0x0d, 0x00, 0x00, 0x00, 0x00 },	// U+22AF (⊯)
	{ 0x00, 0x00, 0x00, 0x08, 0x10, 0x08, 0x07, 0x08, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+22B0 (⊰)
	{ 0x00, 0x00, 0x00, 0x02, 0x01, 0x02, 0x1c, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00 },	// U+22B1 (⊱)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x16, 0x11, 0x16, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+22B2 (⊲)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x11, 0x0d, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+22B3 (⊳)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x16, 0x11, 0x16, 0x18, 0x00, 0x1f, 0x00, 0x00 },	// U+22B4 (⊴)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x11, 0x0d, 0x03, 0x00, 0x1f, 0x00, 0x00 },	// U+22B5 (⊵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1d, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22B6 (⊶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x17, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22B7 (⊷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x17, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22B8 (⊸)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1b, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+22B9 (⊹)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+22BA (⊺)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x1f, 0x00 },	// U+22BB (⊻)
	{ 0x00, 0x00, 0x1f, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+22BC (⊼)
	{ 0x00, 0x00, 0x1f, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+22BD (⊽)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x05, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+22BE (⊾)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x12, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+22BF (⊿)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x0a, 0x0a, 0x0a, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+22C0 (⋀)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x0a, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+22C1 (⋁)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+22C2 (⋂)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+22C3 (⋃)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+22C4 (⋄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22C5 (⋅)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+22C6 (⋆)
	{ 0x00, 0x00, 0x00, 0x04, 0x11, 0x0a, 0x1f, 0x0a, 0x11, 0x04, 0x00, 0x00, 0x00 },	// U+22C7 (⋇)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+22C8 (⋈)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0b, 0x05, 0x0b, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+22C9 (⋉)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x1a, 0x14, 0x1a, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+22CA (⋊)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+22CB (⋋)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+22CC (⋌)
	{ 0x00, 0x00, 0x00, 0x00, 0x0d, 0x16, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22CD (⋍)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+22CE (⋎)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+22CF (⋏)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x19, 0x05, 0x19, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+22D0 (⋐)
	{ 0x00, 0x00, 0x00, 0x07, 0x08, 0x13, 0x14, 0x13, 0x08, 0x07, 0x00, 0x00, 0x00 },	// U+22D1 (⋑)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+22D2 (⋒)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+22D3 (⋓)
	{ 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+22D4 (⋔)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+22D5 (⋕)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x06, 0x11, 0x06, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+22D6 (⋖)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x11, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+22D7 (⋗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x15, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22D8 (⋘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x2a, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22D9 (⋙)
	{ 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x1f, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00 },	// U+22DA (⋚)
	{ 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x1f, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00 },	// U+22DB (⋛)
	{ 0x00, 0x00, 0x1f, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+22DC (⋜)
	{ 0x00, 0x00, 0x1f, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+22DD (⋝)
	{ 0x00, 0x00, 0x10, 0x0c, 0x13, 0x0c, 0x03, 0x0c, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+22DE (⋞)
	{ 0x00, 0x00, 0x01, 0x06, 0x19, 0x06, 0x18, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+22DF (⋟)
	{ 0x00, 0x00, 0x10, 0x10, 0x18, 0x0c, 0x07, 0x0c, 0x13, 0x0e, 0x11, 0x01, 0x00 },	// U+22E0 (⋠)
	{ 0x00, 0x00, 0x10, 0x10, 0x09, 0x0e, 0x1c, 0x06, 0x1b, 0x06, 0x01, 0x01, 0x00 },	// U+22E1 (⋡)
	{ 0x00, 0x00, 0x10, 0x10, 0x1f, 0x09, 0x05, 0x05, 0x1f, 0x02, 0x1f, 0x01, 0x00 },	// U+22E2 (⋢)
	{ 0x00, 0x00, 0x10, 0x10, 0x1f, 0x18, 0x14, 0x14, 0x1f, 0x02, 0x1f, 0x01, 0x00 },	// U+22E3 (⋣)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x1f, 0x08, 0x1f, 0x02, 0x00 },	// U+22E4 (⋤)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x1f, 0x08, 0x1f, 0x02, 0x00 },	// U+22E5 (⋥)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x08, 0x16, 0x0d, 0x02 },	// U+22E6 (⋦)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x08, 0x16, 0x0d, 0x02 },	// U+22E7 (⋧)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x0c, 0x03, 0x0c, 0x10, 0x08, 0x16, 0x0d, 0x02 },	// U+22E8 (⋨)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x18, 0x06, 0x01, 0x08, 0x16, 0x0d, 0x02 },	// U+22E9 (⋩)
	{ 0x00, 0x00, 0x10, 0x10, 0x18, 0x1e, 0x15, 0x16, 0x1a, 0x02, 0x01, 0x01, 0x00 },	// U+22EA (⋪)
	{ 0x00, 0x00, 0x10, 0x10, 0x0b, 0x0d, 0x15, 0x0d, 0x03, 0x02, 0x01, 0x01, 0x00 },	// U+22EB (⋫)
	{ 0x00, 0x00, 0x10, 0x10, 0x18, 0x1e, 0x15, 0x16, 0x1a, 0x02, 0x1f, 0x01, 0x00 },	// U+22EC (⋬)
	{ 0x00, 0x00, 0x10, 0x10, 0x0b, 0x0d, 0x15, 0x0d, 0x03, 0x02, 0x1f, 0x01, 0x00 },	// U+22ED (⋭)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+22EE (⋮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22EF (⋯)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+22F0 (⋰)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+22F1 (⋱)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x02, 0x1f, 0x02, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+22F2 (⋲)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x11, 0x1f, 0x11, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+22F3 (⋳)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x11, 0x1f, 0x11, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+22F4 (⋴)
	{ 0x00, 0x04, 0x00, 0x1c, 0x02, 0x01, 0x1f, 0x01, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+22F5 (⋵)
	{ 0x00, 0x1f, 0x00, 0x1c, 0x02, 0x01, 0x1f, 0x01, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+22F6 (⋶)
	{ 0x00, 0x00, 0x0f, 0x00, 0x0e, 0x01, 0x0f, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+22F7 (⋷)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x01, 0x1f, 0x01, 0x02, 0x1c, 0x00, 0x1f, 0x00 },	// U+22F8 (⋸)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x1f, 0x01, 0x1f, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+22F9 (⋹)
	{ 0x00, 0x00, 0x00, 0x07, 0x08, 0x08, 0x1f, 0x08, 0x08, 0x07, 0x00, 0x00, 0x00 },	// U+22FA (⋺)
	{ 0x00, 0x00, 0x00, 0x07, 0x08, 0x11, 0x1f, 0x11, 0x08, 0x07, 0x00, 0x00, 0x00 },	// U+22FB (⋻)
	{ 0x00, 0x00, 0x00, 0x07, 0x08, 0x11, 0x1f, 0x11, 0x08, 0x07, 0x00, 0x00, 0x00 },	// U+22FC (⋼)
	{ 0x00, 0x1f, 0x00, 0x07, 0x08, 0x10, 0x1f, 0x10, 0x08, 0x07, 0x00, 0x00, 0x00 },	// U+22FD (⋽)
	{ 0x00, 0x00, 0x0f, 0x00, 0x07, 0x08, 0x0f, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+22FE (⋾)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x1f, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+22FF (⋿)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x19, 0x15, 0x13, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+2300 (⌀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0e, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+2301 (⌁)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+2302 (⌂)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2303 (⌃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2304 (⌄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2305 (⌅)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2306 (⌆)
	{ 0x00, 0x02, 0x04, 0x08, 0x08, 0x04, 0x02, 0x02, 0x04, 0x08, 0x08, 0x04, 0x02 },	// U+2307 (⌇)
	{ 0x00, 0x00, 0x00, 0x0f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+2308 (⌈)
	{ 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2309 (⌉)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00 },	// U+230A (⌊)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00 },	// U+230B (⌋)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+230C (⌌)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+230D (⌍)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+230E (⌎)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+230F (⌏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+2310 (⌐)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x0a, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2311 (⌑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2312 (⌒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2313 (⌓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2314 (⌔)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x26, 0x1e, 0x01, 0x00, 0x00, 0x00 },	// U+2315 (⌕)
	{ 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x1f, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+2316 (⌖)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+2317 (⌗)
	{ 0x00, 0x00, 0x00, 0x1b, 0x15, 0x1f, 0x0a, 0x1f, 0x15, 0x1b, 0x00, 0x00, 0x00 },	// U+2318 (⌘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2319 (⌙)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x19, 0x15, 0x15, 0x0e, 0x0e, 0x00, 0x00, 0x00 },	// U+231A (⌚)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x04, 0x04, 0x0e, 0x1f, 0x00, 0x00, 0x00 },	// U+231B (⌛)
	{ 0x00, 0x00, 0x00, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+231C (⌜)
	{ 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+231D (⌝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00 },	// U+231E (⌞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1c, 0x00, 0x00, 0x00 },	// U+231F (⌟)
	{ 0x00, 0x00, 0x08, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+2320 (⌠)
}; // 132

static const unsigned char tewi_block101[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x21, 0x00, 0x00, 0x00, 0x00 },	// U+2322 (⌢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2323 (⌣)
	{ 0x00, 0x00, 0x1b, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2324 (⌤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x04, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2325 (⌥)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x25, 0x1b, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+2326 (⌦)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x33, 0x2d, 0x33, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+2327 (⌧)
	{ 0x00, 0x00, 0x00, 0x3e, 0x26, 0x3a, 0x37, 0x3a, 0x36, 0x2a, 0x3e, 0x00, 0x00 },	// U+2328 (⌨)
}; // 7

static const unsigned char tewi_block102[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x36, 0x29, 0x36, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+232B (⌫)
}; // 1

static const unsigned char tewi_block103[][13] = {
	{ 0x00, 0x00, 0x20, 0x10, 0x08, 0x0c, 0x32, 0x13, 0x0c, 0x04, 0x02, 0x01, 0x00 },	// U+232D (⌭)
}; // 1

static const unsigned char tewi_block104[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x3f, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+232F (⌯)
	{ 0x00, 0x00, 0x00, 0x12, 0x3f, 0x12, 0x12, 0x09, 0x09, 0x0f, 0x00, 0x00, 0x00 },	// U+2330 (⌰)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x3d, 0x15, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2331 (⌱)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x19, 0x3f, 0x19, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+2332 (⌲)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2333 (⌳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+2334 (⌴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2335 (⌵)
	{ 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00 },	// U+2336 (⌶)
	{ 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2337 (⌷)
	{ 0x00, 0x00, 0x1f, 0x11, 0x11, 0x1f, 0x11, 0x1f, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2338 (⌸)
	{ 0x00, 0x00, 0x1f, 0x11, 0x15, 0x11, 0x1f, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2339 (⌹)
	{ 0x00, 0x00, 0x1f, 0x11, 0x15, 0x1b, 0x11, 0x1b, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+233A (⌺)
	{ 0x00, 0x00, 0x1f, 0x11, 0x11, 0x15, 0x1b, 0x15, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+233B (⌻)
	{ 0x00, 0x00, 0x1f, 0x11, 0x1f, 0x1b, 0x11, 0x1b, 0x1f, 0x11, 0x1f, 0x00, 0x00 },	// U+233C (⌼)
	{ 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+233D (⌽)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+233E (⌾)
	{ 0x00, 0x00, 0x10, 0x10, 0x08, 0x08, 0x04, 0x1f, 0x02, 0x02, 0x01, 0x01, 0x00 },	// U+233F (⌿)
	{ 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x04, 0x1f, 0x08, 0x08, 0x10, 0x10, 0x00 },	// U+2340 (⍀)
	{ 0x00, 0x00, 0x1f, 0x19, 0x19, 0x15, 0x15, 0x15, 0x13, 0x13, 0x1f, 0x00, 0x00 },	// U+2341 (⍁)
	{ 0x00, 0x00, 0x1f, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x1f, 0x00, 0x00 },	// U+2342 (⍂)
	{ 0x00, 0x00, 0x1f, 0x11, 0x19, 0x15, 0x13, 0x15, 0x19, 0x11, 0x1f, 0x00, 0x00 },	// U+2343 (⍃)
	{ 0x00, 0x00, 0x1f, 0x11, 0x13, 0x15, 0x19, 0x15, 0x13, 0x11, 0x1f, 0x00, 0x00 },	// U+2344 (⍄)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x0a, 0x3f, 0x0a, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2345 (⍅)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x14, 0x3f, 0x14, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2346 (⍆)
	{ 0x00, 0x00, 0x1f, 0x11, 0x15, 0x13, 0x1f, 0x13, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2347 (⍇)
	{ 0x00, 0x00, 0x1f, 0x11, 0x15, 0x19, 0x1f, 0x19, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2348 (⍈)
	{ 0x00, 0x00, 0x01, 0x01, 0x02, 0x0e, 0x15, 0x15, 0x19, 0x0e, 0x10, 0x10, 0x00 },	// U+2349 (⍉)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+234A (⍊)
	{ 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x0e, 0x15, 0x15, 0x1f, 0x04, 0x00, 0x00 },	// U+234B (⍋)
	{ 0x00, 0x00, 0x1f, 0x11, 0x11, 0x1b, 0x1b, 0x15, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+234C (⍌)
	{ 0x00, 0x00, 0x1f, 0x11, 0x15, 0x15, 0x1b, 0x1b, 0x1f, 0x11, 0x1f, 0x00, 0x00 },	// U+234D (⍍)
	{ 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x1f, 0x00, 0x00 },	// U+234E (⍎)
	{ 0x00, 0x00, 0x04, 0x0e, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+234F (⍏)
	{ 0x00, 0x00, 0x1f, 0x15, 0x1f, 0x1f, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00 },	// U+2350 (⍐)
	{ 0x00, 0x00, 0x1f, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2351 (⍑)
	{ 0x00, 0x00, 0x04, 0x1f, 0x15, 0x15, 0x0e, 0x0e, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2352 (⍒)
	{ 0x00, 0x00, 0x1f, 0x11, 0x15, 0x15, 0x1b, 0x1b, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2353 (⍓)
	{ 0x00, 0x00, 0x1f, 0x11, 0x1f, 0x1b, 0x1b, 0x15, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2354 (⍔)
	{ 0x00, 0x00, 0x1f, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+2355 (⍕)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+2356 (⍖)
	{ 0x00, 0x00, 0x1f, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x1f, 0x15, 0x1f, 0x00, 0x00 },	// U+2357 (⍗)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00 },	// U+2358 (⍘)
	{ 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2359 (⍙)
	{ 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x1f, 0x00, 0x00 },	// U+235A (⍚)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00 },	// U+235B (⍛)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00 },	// U+235C (⍜)
	{ 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+235D (⍝)
	{ 0x00, 0x00, 0x1f, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+235E (⍞)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x1f, 0x15, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+235F (⍟)
	{ 0x00, 0x00, 0x1f, 0x11, 0x11, 0x15, 0x11, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2360 (⍠)
	{ 0x00, 0x00, 0x0a, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2361 (⍡)
	{ 0x00, 0x00, 0x0a, 0x00, 0x1f, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+2362 (⍢)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x04, 0x04, 0x1f, 0x0e, 0x0a, 0x00, 0x00, 0x00 },	// U+2363 (⍣)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2364 (⍤)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2365 (⍥)
	{ 0x00, 0x00, 0x04, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+2366 (⍦)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x05, 0x05, 0x05, 0x05, 0x1e, 0x04, 0x00, 0x00 },	// U+2367 (⍧)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00 },	// U+2368 (⍨)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00, 0x00, 0x00 },	// U+2369 (⍩)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x04, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+236A (⍪)
	{ 0x00, 0x00, 0x1f, 0x11, 0x11, 0x2e, 0x1b, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+236B (⍫)
	{ 0x00, 0x00, 0x0c, 0x12, 0x12, 0x36, 0x1b, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+236C (⍬)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x16, 0x0d, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+236D (⍭)
	{ 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x02, 0x00, 0x1f, 0x00, 0x00 },	// U+236E (⍮)
	{ 0x00, 0x00, 0x1f, 0x11, 0x19, 0x1f, 0x15, 0x1f, 0x13, 0x11, 0x1f, 0x00, 0x00 },	// U+236F (⍯)
	{ 0x00, 0x00, 0x1f, 0x15, 0x1b, 0x19, 0x15, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2370 (⍰)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x0a, 0x2e, 0x1d, 0x04, 0x04, 0x00, 0x00 },	// U+2371 (⍱)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x2e, 0x1b, 0x0a, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+2372 (⍲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00 },	// U+2373 (⍳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x00 },	// U+2374 (⍴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+2375 (⍵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x1f, 0x00 },	// U+2376 (⍶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x1f, 0x01, 0x1e, 0x00, 0x1f, 0x00 },	// U+2377 (⍷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x08, 0x00, 0x1f, 0x00 },	// U+2378 (⍸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x1f, 0x00 },	// U+2379 (⍹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x1f, 0x00 },	// U+237A (⍺)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x3c, 0x08, 0x05, 0x05, 0x02, 0x02, 0x00, 0x00 },	// U+237B (⍻)
	{ 0x00, 0x00, 0x0a, 0x06, 0x02, 0x03, 0x06, 0x0a, 0x1e, 0x05, 0x03, 0x07, 0x00 },	// U+237C (⍼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x0a, 0x0e, 0x00, 0x00, 0x00 },	// U+237D (⍽)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x0a, 0x0a, 0x1b, 0x00, 0x00, 0x00 },	// U+237E (⍾)
}; // 80

static const unsigned char tewi_block105[][13] = {
	{ 0x00, 0x1e, 0x11, 0x11, 0x19, 0x16, 0x00, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00 },	// U+2380 (⎀)
}; // 1

static const unsigned char tewi_block106[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x00, 0x00, 0x00 },	// U+2388 (⎈)
}; // 1

static const unsigned char tewi_block107[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x13, 0x14, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+238B (⎋)
}; // 1

static const unsigned char tewi_block108[][13] = {
	{ 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BA (⎺)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BB (⎻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00 },	// U+23BC (⎼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00 },	// U+23BD (⎽)
}; // 4

static const unsigned char tewi_block109[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x1b, 0x3f, 0x1b, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+23E9 (⏩)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x36, 0x3f, 0x36, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+23EA (⏪)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x04, 0x0e, 0x1f, 0x00, 0x00, 0x00 },	// U+23EB (⏫)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0e, 0x04, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+23EC (⏬)
	{ 0x00, 0x00, 0x00, 0x00, 0x29, 0x3b, 0x3f, 0x3b, 0x29, 0x00, 0x00, 0x00, 0x00 },	// U+23ED (⏭)
	{ 0x00, 0x00, 0x00, 0x00, 0x25, 0x37, 0x3f, 0x37, 0x25, 0x00, 0x00, 0x00, 0x00 },	// U+23EE (⏮)
	{ 0x00, 0x00, 0x00, 0x00, 0x29, 0x2b, 0x2f, 0x2b, 0x29, 0x00, 0x00, 0x00, 0x00 },	// U+23EF (⏯)
}; // 7

static const unsigned char tewi_block110[][13] = {
	{ 0x00, 0x00, 0x03, 0x05, 0x03, 0x05, 0x03, 0x1c, 0x0c, 0x10, 0x1c, 0x00, 0x00 },	// U+2408 (␈)
	{ 0x00, 0x00, 0x05, 0x07, 0x05, 0x05, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2409 (␉)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x07, 0x00, 0x1c, 0x04, 0x0c, 0x04, 0x00, 0x00 },	// U+240A (␊)
	{ 0x00, 0x00, 0x05, 0x05, 0x05, 0x02, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+240B (␋)
	{ 0x00, 0x00, 0x07, 0x01, 0x03, 0x01, 0x00, 0x1c, 0x04, 0x0c, 0x04, 0x00, 0x00 },	// U+240C (␌)
	{ 0x00, 0x00, 0x06, 0x01, 0x01, 0x06, 0x00, 0x0c, 0x14, 0x0c, 0x14, 0x00, 0x00 },	// U+240D (␍)
	{ 0x00, 0x00, 0x07, 0x02, 0x04, 0x03, 0x00, 0x1c, 0x08, 0x10, 0x0c, 0x00, 0x00 },	// U+240E (␎)
	{ 0x00, 0x00, 0x07, 0x02, 0x04, 0x03, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+240F (␏)
}; // 8

static const unsigned char tewi_block111[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2423 (␣)
	{ 0x00, 0x00, 0x09, 0x0b, 0x0d, 0x09, 0x00, 0x04, 0x04, 0x04, 0x1c, 0x00, 0x00 },	// U+2424 (␤)
	{ 0x00, 0x00, 0x24, 0x12, 0x09, 0x24, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2425 (␥)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x02, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2426 (␦)
}; // 4

static const unsigned char tewi_block112[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x14, 0x14, 0x04, 0x05, 0x05, 0x07, 0x00, 0x00, 0x00 },	// U+2440 (⑀)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+2441 (⑁)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2442 (⑂)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+2443 (⑃)
	{ 0x00, 0x00, 0x00, 0x1f, 0x15, 0x15, 0x04, 0x15, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+2444 (⑄)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2445 (⑅)
	{ 0x00, 0x00, 0x00, 0x18, 0x1b, 0x03, 0x03, 0x1b, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2446 (⑆)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x04, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+2447 (⑇)
	{ 0x00, 0x00, 0x00, 0x30, 0x35, 0x35, 0x35, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00 },	// U+2448 (⑈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x2b, 0x2b, 0x2b, 0x00, 0x00, 0x00, 0x00 },	// U+2449 (⑉)
	{ 0x00, 0x08, 0x18, 0x14, 0x0c, 0x0a, 0x06, 0x05, 0x03, 0x02, 0x00, 0x00, 0x00 },	// U+244A (⑊)
}; // 11

static const unsigned char tewi_block113[][13] = {
	{ 0x00, 0x00, 0x0e, 0x11, 0x15, 0x17, 0x15, 0x15, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+2460 (①)
	{ 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x19, 0x15, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+2461 (②)
	{ 0x00, 0x00, 0x0e, 0x11, 0x17, 0x19, 0x15, 0x19, 0x17, 0x11, 0x0e, 0x00, 0x00 },	// U+2462 (③)
	{ 0x00, 0x00, 0x0e, 0x11, 0x13, 0x13, 0x17, 0x1f, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2463 (④)
	{ 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x13, 0x17, 0x19, 0x17, 0x11, 0x0e, 0x00, 0x00 },	// U+2464 (⑤)
	{ 0x00, 0x00, 0x0e, 0x11, 0x1d, 0x13, 0x17, 0x1b, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2465 (⑥)
	{ 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x19, 0x19, 0x15, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2466 (⑦)
	{ 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x15, 0x1b, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2467 (⑧)
	{ 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x1d, 0x19, 0x17, 0x11, 0x0e, 0x00, 0x00 },	// U+2468 (⑨)
	{ 0x00, 0x00, 0x1e, 0x21, 0x2b, 0x37, 0x37, 0x37, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+2469 (⑩)
	{ 0x00, 0x00, 0x1e, 0x21, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+246A (⑪)
	{ 0x00, 0x00, 0x1e, 0x21, 0x2b, 0x33, 0x33, 0x2b, 0x3b, 0x21, 0x1e, 0x00, 0x00 },	// U+246B (⑫)
	{ 0x00, 0x00, 0x1e, 0x21, 0x2b, 0x33, 0x2b, 0x33, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+246C (⑬)
	{ 0x00, 0x00, 0x1e, 0x21, 0x2b, 0x2b, 0x3b, 0x3b, 0x33, 0x21, 0x1e, 0x00, 0x00 },	// U+246D (⑭)
	{ 0x00, 0x00, 0x1e, 0x21, 0x3b, 0x2b, 0x3b, 0x33, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+246E (⑮)
	{ 0x00, 0x00, 0x1e, 0x21, 0x2b, 0x2b, 0x3b, 0x2b, 0x33, 0x21, 0x1e, 0x00, 0x00 },	// U+246F (⑯)
	{ 0x00, 0x00, 0x1e, 0x21, 0x3b, 0x33, 0x33, 0x2b, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+2470 (⑰)
	{ 0x00, 0x00, 0x1e, 0x21, 0x33, 0x2b, 0x33, 0x2b, 0x33, 0x21, 0x1e, 0x00, 0x00 },	// U+2471 (⑱)
	{ 0x00, 0x00, 0x1e, 0x21, 0x33, 0x2b, 0x33, 0x23, 0x3b, 0x21, 0x1e, 0x00, 0x00 },	// U+2472 (⑲)
	{ 0x00, 0x00, 0x1e, 0x21, 0x33, 0x2d, 0x2d, 0x2b, 0x37, 0x21, 0x1e, 0x00, 0x00 },	// U+2473 (⑳)
	{ 0x00, 0x00, 0x0a, 0x11, 0x15, 0x17, 0x15, 0x15, 0x1f, 0x11, 0x0a, 0x00, 0x00 },	// U+2474 (⑴)
	{ 0x00, 0x00, 0x0a, 0x11, 0x15, 0x1b, 0x19, 0x15, 0x1f, 0x11, 0x0a, 0x00, 0x00 },	// U+2475 (⑵)
	{ 0x00, 0x00, 0x0a, 0x11, 0x17, 0x19, 0x15, 0x19, 0x17, 0x11, 0x0a, 0x00, 0x00 },	// U+2476 (⑶)
	{ 0x00, 0x00, 0x0a, 0x11, 0x13, 0x17, 0x17, 0x1f, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+2477 (⑷)
	{ 0x00, 0x00, 0x0a, 0x11, 0x1f, 0x13, 0x17, 0x19, 0x17, 0x11, 0x0a, 0x00, 0x00 },	// U+2478 (⑸)
	{ 0x00, 0x00, 0x0a, 0x11, 0x1d, 0x13, 0x17, 0x1b, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+2479 (⑹)
	{ 0x00, 0x00, 0x0a, 0x11, 0x1f, 0x19, 0x19, 0x15, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+247A (⑺)
	{ 0x00, 0x00, 0x0a, 0x11, 0x15, 0x1b, 0x15, 0x1b, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+247B (⑻)
	{ 0x00, 0x00, 0x0a, 0x11, 0x15, 0x1b, 0x1d, 0x19, 0x17, 0x11, 0x0a, 0x00, 0x00 },	// U+247C (⑼)
	{ 0x00, 0x00, 0x12, 0x21, 0x2b, 0x37, 0x37, 0x37, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+247D (⑽)
	{ 0x00, 0x00, 0x12, 0x21, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+247E (⑾)
	{ 0x00, 0x00, 0x12, 0x21, 0x2b, 0x33, 0x33, 0x2b, 0x3b, 0x21, 0x12, 0x00, 0x00 },	// U+247F (⑿)
	{ 0x00, 0x00, 0x12, 0x21, 0x2b, 0x33, 0x2b, 0x33, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+2480 (⒀)
	{ 0x00, 0x00, 0x12, 0x21, 0x2b, 0x2b, 0x3b, 0x3b, 0x33, 0x21, 0x12, 0x00, 0x00 },	// U+2481 (⒁)
	{ 0x00, 0x00, 0x12, 0x21, 0x3b, 0x2b, 0x3b, 0x33, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+2482 (⒂)
	{ 0x00, 0x00, 0x12, 0x21, 0x2b, 0x2b, 0x3b, 0x2b, 0x33, 0x21, 0x12, 0x00, 0x00 },	// U+2483 (⒃)
	{ 0x00, 0x00, 0x12, 0x21, 0x3b, 0x33, 0x33, 0x2b, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+2484 (⒄)
	{ 0x00, 0x00, 0x12, 0x21, 0x33, 0x2b, 0x33, 0x2b, 0x33, 0x21, 0x12, 0x00, 0x00 },	// U+2485 (⒅)
	{ 0x00, 0x00, 0x12, 0x21, 0x33, 0x2b, 0x33, 0x23, 0x3b, 0x21, 0x12, 0x00, 0x00 },	// U+2486 (⒆)
	{ 0x00, 0x00, 0x12, 0x21, 0x33, 0x2d, 0x2d, 0x2b, 0x37, 0x21, 0x12, 0x00, 0x00 },	// U+2487 (⒇)
	{ 0x00, 0x00, 0x00, 0x02, 0x03, 0x02, 0x02, 0x02, 0x02, 0x17, 0x00, 0x00, 0x00 },	// U+2488 (⒈)
	{ 0x00, 0x00, 0x00, 0x02, 0x05, 0x04, 0x02, 0x02, 0x01, 0x17, 0x00, 0x00, 0x00 },	// U+2489 (⒉)
	{ 0x00, 0x00, 0x00, 0x03, 0x04, 0x04, 0x03, 0x04, 0x04, 0x13, 0x00, 0x00, 0x00 },	// U+248A (⒊)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x09, 0x1f, 0x08, 0x28, 0x00, 0x00, 0x00 },	// U+248B (⒋)
	{ 0x00, 0x00, 0x00, 0x0f, 0x01, 0x07, 0x08, 0x08, 0x09, 0x26, 0x00, 0x00, 0x00 },	// U+248C (⒌)
	{ 0x00, 0x00, 0x00, 0x06, 0x01, 0x07, 0x09, 0x09, 0x09, 0x26, 0x00, 0x00, 0x00 },	// U+248D (⒍)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x08, 0x04, 0x04, 0x24, 0x00, 0x00, 0x00 },	// U+248E (⒎)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x06, 0x09, 0x09, 0x26, 0x00, 0x00, 0x00 },	// U+248F (⒏)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x09, 0x0e, 0x08, 0x26, 0x00, 0x00, 0x00 },	// U+2490 (⒐)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x15, 0x15, 0x15, 0x15, 0x29, 0x00, 0x00, 0x00 },	// U+2491 (⒑)
	{ 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x29, 0x00, 0x00, 0x00 },	// U+2492 (⒒)
	{ 0x00, 0x00, 0x00, 0x05, 0x09, 0x09, 0x09, 0x05, 0x05, 0x2d, 0x00, 0x00, 0x00 },	// U+2493 (⒓)
	{ 0x00, 0x00, 0x00, 0x0d, 0x11, 0x11, 0x0d, 0x11, 0x11, 0x2d, 0x00, 0x00, 0x00 },	// U+2494 (⒔)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x0d, 0x0d, 0x1d, 0x09, 0x29, 0x00, 0x00, 0x00 },	// U+2495 (⒕)
	{ 0x00, 0x00, 0x00, 0x1d, 0x05, 0x0d, 0x11, 0x11, 0x15, 0x29, 0x00, 0x00, 0x00 },	// U+2496 (⒖)
	{ 0x00, 0x00, 0x00, 0x09, 0x05, 0x0d, 0x15, 0x15, 0x15, 0x29, 0x00, 0x00, 0x00 },	// U+2497 (⒗)
	{ 0x00, 0x00, 0x00, 0x1d, 0x11, 0x11, 0x09, 0x09, 0x09, 0x29, 0x00, 0x00, 0x00 },	// U+2498 (⒘)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x15, 0x09, 0x15, 0x15, 0x29, 0x00, 0x00, 0x00 },	// U+2499 (⒙)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x15, 0x15, 0x19, 0x11, 0x29, 0x00, 0x00, 0x00 },	// U+249A (⒚)
	{ 0x00, 0x00, 0x00, 0x09, 0x16, 0x16, 0x16, 0x15, 0x15, 0x2b, 0x00, 0x00, 0x00 },	// U+249B (⒛)
	{ 0x00, 0x00, 0x0a, 0x11, 0x15, 0x19, 0x1d, 0x1b, 0x1d, 0x11, 0x0a, 0x00, 0x00 },	// U+249C (⒜)
	{ 0x00, 0x00, 0x0a, 0x11, 0x13, 0x13, 0x17, 0x1b, 0x17, 0x11, 0x0a, 0x00, 0x00 },	// U+249D (⒝)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x1d, 0x13, 0x13, 0x1d, 0x11, 0x0a, 0x00, 0x00 },	// U+249E (⒞)
	{ 0x00, 0x00, 0x0a, 0x11, 0x19, 0x19, 0x1d, 0x1b, 0x1d, 0x11, 0x0a, 0x00, 0x00 },	// U+249F (⒟)
	{ 0x00, 0x00, 0x0a, 0x11, 0x15, 0x1b, 0x1f, 0x13, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+24A0 (⒠)
	{ 0x00, 0x00, 0x0a, 0x11, 0x19, 0x15, 0x1f, 0x15, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+24A1 (⒡)
	{ 0x00, 0x00, 0x0a, 0x11, 0x1d, 0x1b, 0x1d, 0x19, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+24A2 (⒢)
	{ 0x00, 0x00, 0x0a, 0x11, 0x13, 0x13, 0x17, 0x1b, 0x1b, 0x11, 0x0a, 0x00, 0x00 },	// U+24A3 (⒣)
	{ 0x00, 0x00, 0x0a, 0x11, 0x15, 0x11, 0x1d, 0x15, 0x17, 0x11, 0x0a, 0x00, 0x00 },	// U+24A4 (⒤)
	{ 0x00, 0x00, 0x0a, 0x11, 0x15, 0x11, 0x15, 0x15, 0x13, 0x11, 0x0a, 0x00, 0x00 },	// U+24A5 (⒥)
	{ 0x00, 0x00, 0x0a, 0x11, 0x13, 0x13, 0x1b, 0x17, 0x1b, 0x11, 0x0a, 0x00, 0x00 },	// U+24A6 (⒦)
	{ 0x00, 0x00, 0x0a, 0x11, 0x1d, 0x15, 0x15, 0x15, 0x17, 0x11, 0x0a, 0x00, 0x00 },	// U+24A7 (⒧)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x1b, 0x1f, 0x1b, 0x1b, 0x11, 0x0a, 0x00, 0x00 },	// U+24A8 (⒨)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x17, 0x1b, 0x1b, 0x1b, 0x11, 0x0a, 0x00, 0x00 },	// U+24A9 (⒩)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x15, 0x1b, 0x1b, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+24AA (⒪)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x17, 0x1b, 0x17, 0x13, 0x11, 0x0a, 0x00, 0x00 },	// U+24AB (⒫)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x1d, 0x1b, 0x1d, 0x19, 0x11, 0x0a, 0x00, 0x00 },	// U+24AC (⒬)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x1b, 0x17, 0x13, 0x13, 0x11, 0x0a, 0x00, 0x00 },	// U+24AD (⒭)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x1d, 0x15, 0x19, 0x1d, 0x11, 0x0a, 0x00, 0x00 },	// U+24AE (⒮)
	{ 0x00, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x1f, 0x15, 0x19, 0x11, 0x0a, 0x00, 0x00 },	// U+24AF (⒯)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x11, 0x1b, 0x1b, 0x1d, 0x11, 0x0a, 0x00, 0x00 },	// U+24B0 (⒰)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x11, 0x1b, 0x1b, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+24B1 (⒱)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x1b, 0x1b, 0x1f, 0x1b, 0x11, 0x0a, 0x00, 0x00 },	// U+24B2 (⒲)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x0a, 0x00, 0x00 },	// U+24B3 (⒳)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x11, 0x1b, 0x15, 0x15, 0x13, 0x0a, 0x00, 0x00 },	// U+24B4 (⒴)
	{ 0x00, 0x00, 0x0a, 0x11, 0x11, 0x1f, 0x19, 0x13, 0x1f, 0x11, 0x0a, 0x00, 0x00 },	// U+24B5 (⒵)
}; // 86

static const unsigned char tewi_block114[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2500 (─)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2501 (━)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2502 (│)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2503 (┃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2504 (┄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x2d, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2505 (┅)
	{ 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04 },	// U+2506 (┆)
	{ 0x00, 0x0e, 0x0e, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x0e, 0x0e },	// U+2507 (┇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2508 (┈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2509 (┉)
	{ 0x00, 0x04, 0x00, 0x04, 0x04, 0x00, 0x04, 0x04, 0x00, 0x04, 0x04, 0x00, 0x04 },	// U+250A (┊)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x00, 0x0e },	// U+250B (┋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+250C (┌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+250D (┍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+250E (┎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+250F (┏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2510 (┐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2511 (┑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2512 (┒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2513 (┓)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2514 (└)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2515 (┕)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2516 (┖)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2517 (┗)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2518 (┘)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2519 (┙)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251A (┚)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251B (┛)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+251C (├)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x3c, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+251D (┝)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x3e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+251E (┞)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+251F (┟)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x3e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2520 (┠)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x3e, 0x3e, 0x3e, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2521 (┡)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3e, 0x3e, 0x3e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2522 (┢)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x3e, 0x3e, 0x3e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2523 (┣)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2524 (┤)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x07, 0x07, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2525 (┥)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2526 (┦)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2527 (┧)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2528 (┨)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x0f, 0x0f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2529 (┩)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x0f, 0x0f, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+252A (┪)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x0f, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+252B (┫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+252C (┬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3f, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+252D (┭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3f, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+252E (┮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+252F (┯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2530 (┰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x3f, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2531 (┱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3f, 0x3e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2532 (┲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2533 (┳)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2534 (┴)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x07, 0x3f, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2535 (┵)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x3f, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2536 (┶)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2537 (┷)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2538 (┸)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x3f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2539 (┹)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x3e, 0x3f, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253A (┺)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253B (┻)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+253C (┼)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x07, 0x3f, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+253D (┽)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x3f, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+253E (┾)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x3f, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+253F (┿)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2540 (╀)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2541 (╁)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x3f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2542 (╂)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x3f, 0x0f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2543 (╃)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x3e, 0x3f, 0x3e, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2544 (╄)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x0f, 0x3f, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2545 (╅)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3e, 0x3f, 0x3e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2546 (╆)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x3f, 0x3f, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2547 (╇)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x3f, 0x3f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2548 (╈)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x3f, 0x0f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+2549 (╉)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x3e, 0x3f, 0x3e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+254A (╊)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x3f, 0x3f, 0x3f, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+254B (╋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+254C (╌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+254D (╍)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+254E (╎)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+254F (╏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2550 (═)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2551 (║)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2552 (╒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2553 (╓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x3a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2554 (╔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2555 (╕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2556 (╖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x0b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2557 (╗)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x04, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2558 (╘)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2559 (╙)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x3a, 0x02, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255A (╚)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x07, 0x04, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255B (╛)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255C (╜)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0b, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255D (╝)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+255E (╞)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+255F (╟)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x3a, 0x02, 0x3a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2560 (╠)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x07, 0x04, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2561 (╡)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2562 (╢)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0b, 0x08, 0x0b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2563 (╣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2564 (╤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2565 (╥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x3b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2566 (╦)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2567 (╧)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2568 (╨)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x3b, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2569 (╩)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x00, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+256A (╪)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+256B (╫)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x3b, 0x00, 0x3b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+256C (╬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+256D (╭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+256E (╮)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+256F (╯)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2570 (╰)
	{ 0x00, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01 },	// U+2571 (╱)
	{ 0x00, 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20 },	// U+2572 (╲)
	{ 0x00, 0x21, 0x21, 0x12, 0x12, 0x0c, 0x0c, 0x0c, 0x0c, 0x12, 0x12, 0x21, 0x21 },	// U+2573 (╳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2574 (╴)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2575 (╵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2576 (╶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2577 (╷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2578 (╸)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2579 (╹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257A (╺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+257B (╻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3f, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257C (╼)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e },	// U+257D (╽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3f, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257E (╾)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+257F (╿)
	{ 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2580 (▀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f },	// U+2581 (▁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f },	// U+2582 (▂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2583 (▃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2584 (▄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2585 (▅)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2586 (▆)
	{ 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2587 (▇)
	{ 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2588 (█)
	{ 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2589 (▉)
	{ 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f },	// U+258A (▊)
	{ 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+258B (▋)
	{ 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+258C (▌)
	{ 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+258D (▍)
	{ 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 },	// U+258E (▎)
	{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+258F (▏)
	{ 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2590 (▐)
	{ 0x00, 0x15, 0x00, 0x15, 0x00, 0x15, 0x00, 0x15, 0x00, 0x15, 0x00, 0x15, 0x00 },	// U+2591 (░)
	{ 0x00, 0x15, 0x2a, 0x15, 0x2a, 0x15, 0x2a, 0x15, 0x2a, 0x15, 0x2a, 0x15, 0x2a },	// U+2592 (▒)
	{ 0x00, 0x3f, 0x15, 0x3f, 0x15, 0x3f, 0x15, 0x3f, 0x15, 0x3f, 0x15, 0x3f, 0x15 },	// U+2593 (▓)
	{ 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2594 (▔)
	{ 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },	// U+2595 (▕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+2596 (▖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2597 (▗)
	{ 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2598 (▘)
	{ 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2599 (▙)
	{ 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+259A (▚)
	{ 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+259B (▛)
	{ 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+259C (▜)
	{ 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+259D (▝)
	{ 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+259E (▞)
	{ 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+259F (▟)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+25A0 (■)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+25A1 (□)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+25A2 (▢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+25A3 (▣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x1f, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+25A4 (▤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+25A5 (▥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x1f, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+25A6 (▦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x13, 0x15, 0x19, 0x1f, 0x00, 0x00, 0x00 },	// U+25A7 (▧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x19, 0x15, 0x13, 0x1f, 0x00, 0x00, 0x00 },	// U+25A8 (▨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x1b, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+25A9 (▩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+25AA (▪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+25AB (▫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+25AC (▬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+25AD (▭)
	{ 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00 },	// U+25AE (▮)
	{ 0x00, 0x00, 0x00, 0x0f, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0f, 0x00, 0x00, 0x00 },	// U+25AF (▯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3f, 0x1f, 0x00, 0x00, 0x00 },	// U+25B0 (▰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x21, 0x1f, 0x00, 0x00, 0x00 },	// U+25B1 (▱)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+25B2 (▲)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+25B3 (△)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+25B4 (▴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+25B5 (▵)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x3f, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+25B6 (▶)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x31, 0x0d, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+25B7 (▷)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x0f, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+25B8 (▸)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x05, 0x09, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+25B9 (▹)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x3f, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+25BA (►)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x31, 0x0d, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+25BB (▻)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+25BC (▼)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+25BD (▽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+25BE (▾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+25BF (▿)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x3c, 0x3f, 0x3c, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+25C0 (◀)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x2c, 0x23, 0x2c, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+25C1 (◁)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0e, 0x0f, 0x0e, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+25C2 (◂)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x09, 0x0a, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+25C3 (◃)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x3c, 0x3f, 0x3c, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+25C4 (◄)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x2c, 0x23, 0x2c, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+25C5 (◅)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+25C6 (◆)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+25C7 (◇)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x15, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+25C8 (◈)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+25C9 (◉)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+25CA (◊)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+25CB (○)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x00, 0x11, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+25CC (◌)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+25CD (◍)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+25CE (◎)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25CF (●)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x16, 0x16, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25D0 (◐)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1a, 0x1a, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25D1 (◑)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25D2 (◒)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25D3 (◓)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1a, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25D4 (◔)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1a, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25D5 (◕)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25D6 (◖)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25D7 (◗)
	{ 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x33, 0x21, 0x21, 0x33, 0x3f, 0x3f, 0x3f, 0x00 },	// U+25D8 (◘)
	{ 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x33, 0x2d, 0x2d, 0x33, 0x3f, 0x3f, 0x3f, 0x00 },	// U+25D9 (◙)
	{ 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x33, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25DA (◚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x33, 0x3f, 0x3f, 0x3f, 0x00 },	// U+25DB (◛)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25DC (◜)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25DD (◝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+25DE (◞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+25DF (◟)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25E0 (◠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+25E1 (◡)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x38, 0x3c, 0x3e, 0x3f, 0x00, 0x00, 0x00 },	// U+25E2 (◢)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x00, 0x00, 0x00 },	// U+25E3 (◣)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00 },	// U+25E4 (◤)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3e, 0x3c, 0x38, 0x30, 0x20, 0x00, 0x00, 0x00 },	// U+25E5 (◥)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+25E6 (◦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x13, 0x13, 0x13, 0x1f, 0x00, 0x00, 0x00 },	// U+25E7 (◧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x19, 0x19, 0x19, 0x1f, 0x00, 0x00, 0x00 },	// U+25E8 (◨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x17, 0x13, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+25E9 (◩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x19, 0x1d, 0x1f, 0x00, 0x00, 0x00 },	// U+25EA (◪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+25EB (◫)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x15, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+25EC (◬)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x17, 0x17, 0x1f, 0x00, 0x00, 0x00 },	// U+25ED (◭)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x1d, 0x1d, 0x1f, 0x00, 0x00, 0x00 },	// U+25EE (◮)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+25EF (◯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x17, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+25F0 (◰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x17, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+25F1 (◱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x1d, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+25F2 (◲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x1d, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+25F3 (◳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x17, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+25F4 (◴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x17, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+25F5 (◵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1d, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+25F6 (◶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x1d, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+25F7 (◷)
	{ 0x00, 0x00, 0x00, 0x0f, 0x05, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25F8 (◸)
	{ 0x00, 0x00, 0x00, 0x3c, 0x28, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25F9 (◹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x05, 0x0f, 0x00, 0x00, 0x00 },	// U+25FA (◺)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+25FB (◻)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+25FC (◼)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+25FD (◽)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+25FE (◾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x28, 0x3c, 0x00, 0x00, 0x00 },	// U+25FF (◿)
	{ 0x00, 0x00, 0x00, 0x04, 0x11, 0x0e, 0x1f, 0x0e, 0x11, 0x04, 0x00, 0x00, 0x00 },	// U+2600 (☀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x3e, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2601 (☁)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x04, 0x04, 0x04, 0x02, 0x00, 0x00, 0x00 },	// U+2602 (☂)
	{ 0x00, 0x02, 0x00, 0x25, 0x0e, 0x0a, 0x15, 0x0a, 0x0e, 0x11, 0x11, 0x0e, 0x00 },	// U+2603 (☃)
	{ 0x00, 0x00, 0x24, 0x12, 0x12, 0x0a, 0x08, 0x22, 0x15, 0x02, 0x00, 0x00, 0x00 },	// U+2604 (☄)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2605 (★)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1b, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2606 (☆)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x01, 0x0a, 0x0c, 0x0e, 0x00, 0x00, 0x00 },	// U+2607 (☇)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x09, 0x05, 0x15, 0x19, 0x1d, 0x00, 0x00, 0x00 },	// U+2608 (☈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2609 (☉)
}; // 266

static const unsigned char tewi_block115[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+2610 (☐)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x31, 0x29, 0x2b, 0x25, 0x3f, 0x00, 0x00, 0x00 },	// U+2611 (☑)
}; // 2

static const unsigned char tewi_block116[][13] = {
	{ 0x00, 0x04, 0x15, 0x11, 0x0e, 0x1f, 0x04, 0x04, 0x04, 0x02, 0x00, 0x00, 0x00 },	// U+2614 (☔)
}; // 1

static const unsigned char tewi_block117[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+2616 (☖)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+2617 (☗)
}; // 2

static const unsigned char tewi_block118[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0b, 0x0b, 0x07, 0x00, 0x00, 0x00 },	// U+261E (☞)
}; // 1

static const unsigned char tewi_block119[][13] = {
	{ 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+2630 (☰)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+2631 (☱)
	{ 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1b, 0x1b, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+2632 (☲)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+2633 (☳)
	{ 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2634 (☴)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1f, 0x1f, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2635 (☵)
	{ 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2636 (☶)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2637 (☷)
}; // 8

static const unsigned char tewi_block120[][13] = {
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1b, 0x11, 0x1b, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+263A (☺)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x15, 0x1f, 0x15, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+263B (☻)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0a, 0x11, 0x0a, 0x15, 0x04, 0x00, 0x00, 0x00 },	// U+263C (☼)
}; // 3

static const unsigned char tewi_block121[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x0e, 0x04 },	// U+263F (☿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x0e, 0x04 },	// U+2640 (♀)
	{ 0x00, 0x00, 0x04, 0x0e, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2641 (♁)
	{ 0x00, 0x00, 0x00, 0x38, 0x30, 0x2e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2642 (♂)
}; // 4

static const unsigned char tewi_block122[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x1f, 0x1f, 0x0e, 0x04, 0x0e, 0x00, 0x00 },	// U+2660 (♠)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2661 (♡)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2662 (♢)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x04, 0x1f, 0x1f, 0x1f, 0x04, 0x0e, 0x00, 0x00 },	// U+2663 (♣)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x11, 0x11, 0x0e, 0x04, 0x0e, 0x00, 0x00 },	// U+2664 (♤)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2665 (♥)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x1f, 0x0e, 0x0e, 0x04, 0x04, 0x00 },	// U+2666 (♦)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x04, 0x1f, 0x15, 0x1f, 0x04, 0x0e, 0x00, 0x00 },	// U+2667 (♧)
	{ 0x00, 0x00, 0x09, 0x12, 0x09, 0x12, 0x00, 0x0a, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2668 (♨)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x06, 0x07, 0x06, 0x00, 0x00, 0x00 },	// U+2669 (♩)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x14, 0x04, 0x06, 0x07, 0x06, 0x00, 0x00, 0x00 },	// U+266A (♪)
	{ 0x00, 0x00, 0x00, 0x06, 0x0a, 0x12, 0x12, 0x13, 0x1b, 0x18, 0x00, 0x00, 0x00 },	// U+266B (♫)
	{ 0x00, 0x00, 0x00, 0x06, 0x0a, 0x16, 0x1a, 0x13, 0x1b, 0x18, 0x00, 0x00, 0x00 },	// U+266C (♬)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x0a, 0x16, 0x12, 0x0a, 0x06, 0x00, 0x00, 0x00 },	// U+266D (♭)
	{ 0x00, 0x00, 0x00, 0x02, 0x12, 0x1a, 0x16, 0x1a, 0x16, 0x12, 0x10, 0x00, 0x00 },	// U+266E (♮)
	{ 0x00, 0x00, 0x00, 0x08, 0x1a, 0x0e, 0x0b, 0x1a, 0x0e, 0x0b, 0x02, 0x00, 0x00 },	// U+266F (♯)
}; // 16

static const unsigned char tewi_block123[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x0e, 0x0a, 0x1f, 0x0a, 0x00 },	// U+26A2 (⚢)
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x36, 0x29, 0x15, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+26A3 (⚣)
	{ 0x00, 0x00, 0x38, 0x30, 0x2c, 0x12, 0x15, 0x09, 0x06, 0x02, 0x07, 0x02, 0x00 },	// U+26A4 (⚤)
	{ 0x00, 0x00, 0x38, 0x30, 0x2e, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x0e, 0x04, 0x00 },	// U+26A5 (⚥)
	{ 0x00, 0x00, 0x00, 0x38, 0x34, 0x28, 0x16, 0x09, 0x09, 0x06, 0x00, 0x00, 0x00 },	// U+26A6 (⚦)
	{ 0x00, 0x03, 0x37, 0x32, 0x1d, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x1c, 0x08, 0x00 },	// U+26A7 (⚧)
	{ 0x00, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+26A8 (⚨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x15, 0x3d, 0x15, 0x02, 0x00, 0x00, 0x00 },	// U+26A9 (⚩)
}; // 8

static const unsigned char tewi_block124[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0d, 0x3f, 0x0d, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2708 (✈)
}; // 1

static const unsigned char tewi_block125[][13] = {
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x05, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+2713 (✓)
	{ 0x00, 0x00, 0x00, 0x20, 0x30, 0x10, 0x1b, 0x0a, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2714 (✔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+2715 (✕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x0a, 0x04, 0x0a, 0x1b, 0x00, 0x00, 0x00 },	// U+2716 (✖)
	{ 0x00, 0x00, 0x00, 0x10, 0x12, 0x0a, 0x04, 0x0a, 0x09, 0x01, 0x00, 0x00, 0x00 },	// U+2717 (✗)
	{ 0x00, 0x00, 0x00, 0x10, 0x1a, 0x0e, 0x04, 0x0e, 0x0b, 0x01, 0x00, 0x00, 0x00 },	// U+2718 (✘)
}; // 6

static const unsigned char tewi_block126[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x3f, 0x3f, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+271A (✚)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1b, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+271B (✛)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x33, 0x33, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+271C (✜)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+271D (✝)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+271E (✞)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x11, 0x1b, 0x0a, 0x0a, 0x0e, 0x00, 0x00, 0x00 },	// U+271F (✟)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x15, 0x1f, 0x15, 0x04, 0x0e, 0x00, 0x00 },	// U+2720 (✠)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1f, 0x0a, 0x0a, 0x1f, 0x04, 0x00, 0x00, 0x00 },	// U+2721 (✡)
}; // 8

static const unsigned char tewi_block127[][13] = {
	{ 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x0c, 0x3f, 0x3f, 0x0c, 0x1e, 0x0c, 0x00, 0x00 },	// U+2724 (✤)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x1f, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+2725 (✥)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2726 (✦)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2727 (✧)
}; // 4

static const unsigned char tewi_block128[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1b, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2729 (✩)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x11, 0x1b, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+272A (✪)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1b, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+272B (✫)
}; // 3

static const unsigned char tewi_block129[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x04, 0x00, 0x00, 0x00 },	// U+2733 (✳)
}; // 1

static const unsigned char tewi_block130[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00, 0x00 },	// U+2736 (✶)
}; // 1

static const unsigned char tewi_block131[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1f, 0x0a, 0x1f, 0x1b, 0x00, 0x00, 0x00 },	// U+273F (✿)
}; // 1

static const unsigned char tewi_block132[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x0e, 0x1b, 0x0e, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+2741 (❁)
}; // 1

static const unsigned char tewi_block133[][13] = {
	{ 0x00, 0x00, 0x00, 0x1f, 0x31, 0x31, 0x31, 0x3f, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+274F (❏)
	{ 0x00, 0x00, 0x00, 0x3e, 0x3f, 0x31, 0x31, 0x31, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2750 (❐)
	{ 0x00, 0x00, 0x00, 0x1f, 0x31, 0x31, 0x31, 0x3f, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2751 (❑)
	{ 0x00, 0x00, 0x00, 0x3e, 0x3f, 0x31, 0x31, 0x31, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2752 (❒)
}; // 4

static const unsigned char tewi_block134[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+275B (❛)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+275C (❜)
	{ 0x00, 0x00, 0x00, 0x12, 0x09, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+275D (❝)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+275E (❞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x01, 0x00 },	// U+275F (❟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x12, 0x09, 0x00 },	// U+2760 (❠)
}; // 6

static const unsigned char tewi_block135[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2764 (❤)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x0f, 0x1e, 0x0f, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2765 (❥)
	{ 0x00, 0x00, 0x26, 0x1d, 0x04, 0x1b, 0x1f, 0x0f, 0x27, 0x1e, 0x00, 0x00, 0x00 },	// U+2766 (❦)
}; // 3

static const unsigned char tewi_block136[][13] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x0c, 0x06, 0x03, 0x06, 0x0c, 0x18, 0x00, 0x00, 0x00 },	// U+276C (❬)
	{ 0x00, 0x00, 0x00, 0x03, 0x06, 0x0c, 0x18, 0x0c, 0x06, 0x03, 0x00, 0x00, 0x00 },	// U+276D (❭)
	{ 0x00, 0x00, 0x00, 0x38, 0x1c, 0x0e, 0x07, 0x07, 0x0e, 0x1c, 0x38, 0x00, 0x00 },	// U+276E (❮)
	{ 0x00, 0x00, 0x00, 0x07, 0x0e, 0x1c, 0x38, 0x38, 0x1c, 0x0e, 0x07, 0x00, 0x00 },	// U+276F (❯)
	{ 0x00, 0x00, 0x00, 0x3c, 0x1e, 0x0f, 0x07, 0x0f, 0x1e, 0x3c, 0x00, 0x00, 0x00 },	// U+2770 (❰)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1e, 0x3c, 0x38, 0x3c, 0x1e, 0x0f, 0x00, 0x00, 0x00 },	// U+2771 (❱)
}; // 6

static const unsigned char tewi_block137[][13] = {
	{ 0x00, 0x00, 0x00, 0x1e, 0x33, 0x37, 0x37, 0x37, 0x37, 0x23, 0x1e, 0x00, 0x00 },	// U+278A (➊)
	{ 0x00, 0x00, 0x00, 0x1e, 0x33, 0x2d, 0x2f, 0x37, 0x3b, 0x21, 0x1e, 0x00, 0x00 },	// U+278B (➋)
	{ 0x00, 0x00, 0x00, 0x1e, 0x31, 0x2f, 0x33, 0x2f, 0x2f, 0x31, 0x1e, 0x00, 0x00 },	// U+278C (➌)
	{ 0x00, 0x00, 0x00, 0x1e, 0x27, 0x2b, 0x2d, 0x21, 0x2f, 0x2f, 0x1e, 0x00, 0x00 },	// U+278D (➍)
	{ 0x00, 0x00, 0x00, 0x1e, 0x21, 0x3d, 0x31, 0x2f, 0x2f, 0x31, 0x1e, 0x00, 0x00 },	// U+278E (➎)
	{ 0x00, 0x00, 0x00, 0x1e, 0x33, 0x3d, 0x31, 0x2d, 0x2d, 0x33, 0x1e, 0x00, 0x00 },	// U+278F (➏)
	{ 0x00, 0x00, 0x00, 0x1e, 0x21, 0x2f, 0x2f, 0x37, 0x3b, 0x3b, 0x1e, 0x00, 0x00 },	// U+2790 (➐)
	{ 0x00, 0x00, 0x00, 0x1e, 0x33, 0x2d, 0x33, 0x2d, 0x2d, 0x33, 0x1e, 0x00, 0x00 },	// U+2791 (➑)
	{ 0x00, 0x00, 0x00, 0x1e, 0x33, 0x2d, 0x2d, 0x23, 0x2f, 0x33, 0x1e, 0x00, 0x00 },	// U+2792 (➒)
	{ 0x00, 0x00, 0x00, 0x1e, 0x35, 0x29, 0x29, 0x29, 0x29, 0x35, 0x1e, 0x00, 0x00 },	// U+2793 (➓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00, 0x00 },	// U+2794 (➔)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x3f, 0x3f, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+2795 (➕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2796 (➖)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x3f, 0x3f, 0x00, 0x0c, 0x00, 0x00, 0x00 },	// U+2797 (➗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x14, 0x18, 0x1c, 0x00, 0x00, 0x00 },	// U+2798 (➘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2799 (➙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x14, 0x02, 0x01, 0x00, 0x00, 0x00 },	// U+279A (➚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x3f, 0x0c, 0x02, 0x00, 0x00, 0x00 },	// U+279B (➛)
}; // 18

static const unsigned char tewi_block138[][13] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x00 },	// U+27E8 (⟨)
	{ 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x00 },	// U+27E9 (⟩)
}; // 2

static const unsigned char tewi_block139[][13] = {
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x15, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+27F2 (⟲)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x15, 0x0c, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+27F3 (⟳)
}; // 2

static const unsigned char tewi_block140[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x3f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+27F5 (⟵)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3f, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+27F6 (⟶)
}; // 2

static const unsigned char tewi_block141[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x3e, 0x01, 0x3e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+27F8 (⟸)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x20, 0x1f, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+27F9 (⟹)
}; // 2

static const unsigned char tewi_block142[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x22, 0x3f, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+27FB (⟻)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x11, 0x3f, 0x11, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+27FC (⟼)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x3e, 0x21, 0x3e, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+27FD (⟽)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x1f, 0x21, 0x1f, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+27FE (⟾)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3d, 0x12, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+27FF (⟿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2800 (⠀)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2801 (⠁)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2802 (⠂)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2803 (⠃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2804 (⠄)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2805 (⠅)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2806 (⠆)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2807 (⠇)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2808 (⠈)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2809 (⠉)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280A (⠊)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280B (⠋)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+280C (⠌)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+280D (⠍)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+280E (⠎)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+280F (⠏)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2810 (⠐)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2811 (⠑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2812 (⠒)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2813 (⠓)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2814 (⠔)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2815 (⠕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2816 (⠖)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2817 (⠗)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2818 (⠘)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2819 (⠙)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281A (⠚)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281B (⠛)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+281C (⠜)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+281D (⠝)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+281E (⠞)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+281F (⠟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2820 (⠠)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2821 (⠡)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2822 (⠢)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2823 (⠣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+2824 (⠤)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+2825 (⠥)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+2826 (⠦)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+2827 (⠧)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2828 (⠨)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2829 (⠩)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+282A (⠪)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+282B (⠫)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+282C (⠬)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+282D (⠭)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+282E (⠮)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+282F (⠯)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2830 (⠰)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2831 (⠱)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2832 (⠲)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2833 (⠳)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+2834 (⠴)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+2835 (⠵)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+2836 (⠶)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+2837 (⠷)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2838 (⠸)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2839 (⠹)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+283A (⠺)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+283B (⠻)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+283C (⠼)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+283D (⠽)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+283E (⠾)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+283F (⠿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2840 (⡀)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2841 (⡁)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2842 (⡂)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2843 (⡃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+2844 (⡄)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+2845 (⡅)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+2846 (⡆)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+2847 (⡇)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2848 (⡈)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2849 (⡉)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+284A (⡊)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+284B (⡋)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+284C (⡌)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+284D (⡍)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+284E (⡎)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+284F (⡏)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2850 (⡐)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2851 (⡑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2852 (⡒)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2853 (⡓)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+2854 (⡔)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+2855 (⡕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+2856 (⡖)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+2857 (⡗)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2858 (⡘)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+2859 (⡙)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+285A (⡚)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00 },	// U+285B (⡛)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+285C (⡜)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+285D (⡝)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+285E (⡞)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00 },	// U+285F (⡟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2860 (⡠)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2861 (⡡)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2862 (⡢)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2863 (⡣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+2864 (⡤)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+2865 (⡥)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+2866 (⡦)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+2867 (⡧)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2868 (⡨)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2869 (⡩)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+286A (⡪)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+286B (⡫)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+286C (⡬)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+286D (⡭)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+286E (⡮)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+286F (⡯)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2870 (⡰)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2871 (⡱)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2872 (⡲)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2873 (⡳)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+2874 (⡴)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+2875 (⡵)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+2876 (⡶)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+2877 (⡷)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2878 (⡸)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+2879 (⡹)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+287A (⡺)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00 },	// U+287B (⡻)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+287C (⡼)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+287D (⡽)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+287E (⡾)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00 },	// U+287F (⡿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2880 (⢀)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2881 (⢁)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2882 (⢂)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2883 (⢃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+2884 (⢄)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+2885 (⢅)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+2886 (⢆)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+2887 (⢇)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2888 (⢈)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2889 (⢉)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+288A (⢊)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+288B (⢋)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+288C (⢌)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+288D (⢍)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+288E (⢎)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x19, 0x00 },	// U+288F (⢏)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2890 (⢐)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2891 (⢑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2892 (⢒)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2893 (⢓)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+2894 (⢔)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+2895 (⢕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+2896 (⢖)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+2897 (⢗)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2898 (⢘)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+2899 (⢙)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+289A (⢚)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+289B (⢛)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+289C (⢜)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+289D (⢝)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+289E (⢞)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00 },	// U+289F (⢟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28A0 (⢠)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28A1 (⢡)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28A2 (⢢)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28A3 (⢣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28A4 (⢤)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28A5 (⢥)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28A6 (⢦)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28A7 (⢧)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28A8 (⢨)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28A9 (⢩)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28AA (⢪)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28AB (⢫)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28AC (⢬)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28AD (⢭)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28AE (⢮)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28AF (⢯)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28B0 (⢰)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28B1 (⢱)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28B2 (⢲)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28B3 (⢳)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28B4 (⢴)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28B5 (⢵)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28B6 (⢶)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28B7 (⢷)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28B8 (⢸)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28B9 (⢹)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28BA (⢺)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+28BB (⢻)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28BC (⢼)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28BD (⢽)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28BE (⢾)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00 },	// U+28BF (⢿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28C0 (⣀)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28C1 (⣁)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28C2 (⣂)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28C3 (⣃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28C4 (⣄)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28C5 (⣅)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28C6 (⣆)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28C7 (⣇)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28C8 (⣈)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28C9 (⣉)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28CA (⣊)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28CB (⣋)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28CC (⣌)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28CD (⣍)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28CE (⣎)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28CF (⣏)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28D0 (⣐)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28D1 (⣑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28D2 (⣒)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28D3 (⣓)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28D4 (⣔)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28D5 (⣕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28D6 (⣖)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28D7 (⣗)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28D8 (⣘)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28D9 (⣙)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28DA (⣚)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00 },	// U+28DB (⣛)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28DC (⣜)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28DD (⣝)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28DE (⣞)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00 },	// U+28DF (⣟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28E0 (⣠)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28E1 (⣡)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28E2 (⣢)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28E3 (⣣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28E4 (⣤)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28E5 (⣥)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28E6 (⣦)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28E7 (⣧)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28E8 (⣨)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28E9 (⣩)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28EA (⣪)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28EB (⣫)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28EC (⣬)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28ED (⣭)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28EE (⣮)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28EF (⣯)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28F0 (⣰)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28F1 (⣱)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28F2 (⣲)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28F3 (⣳)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28F4 (⣴)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28F5 (⣵)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28F6 (⣶)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28F7 (⣷)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28F8 (⣸)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28F9 (⣹)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28FA (⣺)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00 },	// U+28FB (⣻)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28FC (⣼)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28FD (⣽)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28FE (⣾)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00 },	// U+28FF (⣿)
}; // 261

static const unsigned char tewi_block143[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x3e, 0x11, 0x3e, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+2902 (⤂)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x22, 0x1f, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+2903 (⤃)
}; // 2

static const unsigned char tewi_block144[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x1e, 0x11, 0x1e, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+2906 (⤆)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0x11, 0x0f, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+2907 (⤇)
	{ 0x00, 0x00, 0x00, 0x04, 0x1f, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2908 (⤈)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2909 (⤉)
}; // 4

static const unsigned char tewi_block145[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x37, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+290C (⤌)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3b, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+290D (⤍)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x2b, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+290E (⤎)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x35, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+290F (⤏)
}; // 4

static const unsigned char tewi_block146[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0e, 0x15, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2912 (⤒)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x15, 0x0e, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2913 (⤓)
}; // 2

static const unsigned char tewi_block147[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x07, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2919 (⤙)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x1c, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+291A (⤚)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x14, 0x0f, 0x14, 0x28, 0x00, 0x00, 0x00, 0x00 },	// U+291B (⤛)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x3c, 0x0a, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+291C (⤜)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x0a, 0x3f, 0x0a, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+291D (⤝)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x3f, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+291E (⤞)
}; // 6

static const unsigned char tewi_block148[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x15, 0x18, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2921 (⤡)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x15, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+2922 (⤢)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x05, 0x08, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2923 (⤣)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x14, 0x02, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2924 (⤤)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x02, 0x14, 0x18, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2925 (⤥)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x08, 0x05, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+2926 (⤦)
}; // 6

static const unsigned char tewi_block149[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x16, 0x39, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2933 (⤳)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x08, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2934 (⤴)
	{ 0x00, 0x00, 0x00, 0x03, 0x04, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2935 (⤵)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x24, 0x12, 0x0f, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+2936 (⤶)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x12, 0x3c, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+2937 (⤷)
	{ 0x00, 0x00, 0x04, 0x08, 0x08, 0x08, 0x05, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+2938 (⤸)
	{ 0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x14, 0x18, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2939 (⤹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x25, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+293A (⤺)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x30, 0x29, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+293B (⤻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x29, 0x30, 0x3b, 0x00, 0x00, 0x00, 0x00 },	// U+293C (⤼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x25, 0x13, 0x3f, 0x10, 0x00, 0x00, 0x00 },	// U+293D (⤽)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x17, 0x13, 0x0d, 0x00, 0x00, 0x00, 0x00 },	// U+293E (⤾)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x1d, 0x19, 0x16, 0x00, 0x00, 0x00, 0x00 },	// U+293F (⤿)
	{ 0x00, 0x00, 0x00, 0x04, 0x02, 0x0f, 0x13, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2940 (⥀)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x1e, 0x19, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2941 (⥁)
	{ 0x00, 0x00, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x02, 0x07, 0x02, 0x04, 0x00, 0x00 },	// U+2942 (⥂)
	{ 0x00, 0x00, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x08, 0x1c, 0x08, 0x04, 0x00, 0x00 },	// U+2943 (⥃)
	{ 0x00, 0x00, 0x04, 0x08, 0x1c, 0x08, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+2944 (⥄)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x0a, 0x07, 0x02, 0x00, 0x00, 0x00 },	// U+2945 (⥅)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x1f, 0x0a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+2946 (⥆)
}; // 20

static const unsigned char tewi_block150[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x0e, 0x15, 0x04, 0x0a, 0x04, 0x00, 0x00 },	// U+2949 (⥉)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x1f, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+294A (⥊)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+294B (⥋)
	{ 0x00, 0x00, 0x00, 0x04, 0x0c, 0x14, 0x05, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+294C (⥌)
	{ 0x00, 0x00, 0x00, 0x04, 0x06, 0x05, 0x14, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+294D (⥍)
}; // 5

static const unsigned char tewi_block151[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x0c, 0x14, 0x04, 0x14, 0x0c, 0x04, 0x00, 0x00, 0x00 },	// U+294F (⥏)
}; // 1

static const unsigned char tewi_block152[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x06, 0x05, 0x04, 0x05, 0x06, 0x04, 0x00, 0x00, 0x00 },	// U+2951 (⥑)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x03, 0x1f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+2952 (⥒)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x18, 0x1f, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2953 (⥓)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0c, 0x14, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2954 (⥔)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x14, 0x0c, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2955 (⥕)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x1f, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+2956 (⥖)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x18, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+2957 (⥗)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x06, 0x05, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2958 (⥘)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x05, 0x06, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2959 (⥙)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x12, 0x1f, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+295A (⥚)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x09, 0x1f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+295B (⥛)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x14, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+295C (⥜)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x14, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+295D (⥝)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x12, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+295E (⥞)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x1f, 0x09, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+295F (⥟)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x05, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2960 (⥠)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x05, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2961 (⥡)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x00, 0x1f, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2962 (⥢)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1b, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+2963 (⥣)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x00, 0x1f, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2964 (⥤)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x1b, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+2965 (⥥)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x08, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2966 (⥦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x1f, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2967 (⥧)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x02, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2968 (⥨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x1f, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2969 (⥩)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+296A (⥪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+296B (⥫)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+296C (⥬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+296D (⥭)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0b, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+296E (⥮)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1a, 0x0a, 0x0b, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+296F (⥯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2970 (⥰)
	{ 0x00, 0x00, 0x03, 0x00, 0x0b, 0x10, 0x3f, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2971 (⥱)
	{ 0x00, 0x00, 0x00, 0x0a, 0x05, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2972 (⥲)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x1f, 0x02, 0x2c, 0x14, 0x00, 0x00, 0x00 },	// U+2973 (⥳)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x08, 0x0e, 0x05, 0x00, 0x00, 0x00 },	// U+2974 (⥴)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x08, 0x0e, 0x05, 0x0a, 0x05, 0x00 },	// U+2975 (⥵)
	{ 0x00, 0x00, 0x18, 0x06, 0x01, 0x06, 0x1c, 0x02, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+2976 (⥶)
}; // 38

static const unsigned char tewi_block153[][13] = {
	{ 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x07, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+2978 (⥸)
	{ 0x00, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+2979 (⥹)
	{ 0x00, 0x00, 0x00, 0x00, 0x34, 0x0a, 0x3f, 0x0a, 0x34, 0x00, 0x00, 0x00, 0x00 },	// U+297A (⥺)
	{ 0x00, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+297B (⥻)
	{ 0x00, 0x00, 0x00, 0x02, 0x01, 0x02, 0x1c, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00 },	// U+297C (⥼)
	{ 0x00, 0x00, 0x00, 0x08, 0x10, 0x08, 0x07, 0x08, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+297D (⥽)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+297E (⥾)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x15, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+297F (⥿)
}; // 8

static const unsigned char tewi_block154[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x14, 0x1a, 0x15, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2B00 (⬀)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x05, 0x0b, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2B01 (⬁)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x15, 0x1a, 0x14, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2B02 (⬂)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x15, 0x0b, 0x05, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+2B03 (⬃)
}; // 4

static const unsigned char tewi_block155[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1e, 0x1f, 0x1e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B05 (⬅)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B06 (⬆)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B07 (⬇)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1c, 0x1e, 0x17, 0x03, 0x01, 0x00, 0x00, 0x00 },	// U+2B08 (⬈)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x07, 0x0f, 0x1d, 0x18, 0x10, 0x00, 0x00, 0x00 },	// U+2B09 (⬉)
	{ 0x00, 0x00, 0x00, 0x01, 0x03, 0x17, 0x1e, 0x1c, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2B0A (⬊)
	{ 0x00, 0x00, 0x00, 0x10, 0x18, 0x1d, 0x0f, 0x07, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+2B0B (⬋)
}; // 7

static const unsigned char tewi_block156[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2B0D (⬍)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2B0E (⬎)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+2B0F (⬏)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B10 (⬐)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2B11 (⬑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2B12 (⬒)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2B13 (⬓)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1d, 0x19, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2B14 (⬔)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x13, 0x17, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2B15 (⬕)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x13, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B16 (⬖)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x19, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B17 (⬗)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B18 (⬘)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B19 (⬙)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x11, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+2B1A (⬚)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2B1B (⬛)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2B1C (⬜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2B1D (⬝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2B1E (⬞)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x1f, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B1F (⬟)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B20 (⬠)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B21 (⬡)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B22 (⬢)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2B23 (⬣)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x1f, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B24 (⬤)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B25 (⬥)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B26 (⬦)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x0e, 0x1f, 0x0e, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2B27 (⬧)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2B28 (⬨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2B29 (⬩)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x0e, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B2A (⬪)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B2B (⬫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B2C (⬬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B2D (⬭)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x0f, 0x0f, 0x0f, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2B2E (⬮)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2B2F (⬯)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x12, 0x2f, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B30 (⬰)
	{ 0x00, 0x00, 0x04, 0x02, 0x1f, 0x02, 0x1f, 0x02, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+2B31 (⬱)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x12, 0x2f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B32 (⬲)
}; // 38

static const unsigned char tewi_block157[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x2b, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B38 (⬸)
}; // 1

static const unsigned char tewi_block158[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1a, 0x27, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B3F (⬿)
	{ 0x00, 0x00, 0x30, 0x00, 0x34, 0x02, 0x3f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B40 (⭀)
	{ 0x00, 0x00, 0x00, 0x14, 0x2c, 0x02, 0x3f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B41 (⭁)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x3f, 0x02, 0x14, 0x28, 0x14, 0x28, 0x00 },	// U+2B42 (⭂)
	{ 0x00, 0x00, 0x00, 0x01, 0x0a, 0x14, 0x3f, 0x14, 0x0a, 0x01, 0x00, 0x00, 0x00 },	// U+2B43 (⭃)
	{ 0x00, 0x00, 0x00, 0x00, 0x0b, 0x14, 0x3f, 0x14, 0x0b, 0x00, 0x00, 0x00, 0x00 },	// U+2B44 (⭄)
	{ 0x00, 0x00, 0x00, 0x08, 0x3c, 0x02, 0x3f, 0x02, 0x3c, 0x08, 0x00, 0x00, 0x00 },	// U+2B45 (⭅)
	{ 0x00, 0x00, 0x00, 0x04, 0x0f, 0x10, 0x3f, 0x10, 0x0f, 0x04, 0x00, 0x00, 0x00 },	// U+2B46 (⭆)
	{ 0x00, 0x00, 0x00, 0x05, 0x0a, 0x10, 0x3f, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2B47 (⭇)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3f, 0x10, 0x0d, 0x0a, 0x05, 0x0a, 0x00 },	// U+2B48 (⭈)
	{ 0x00, 0x00, 0x00, 0x28, 0x14, 0x02, 0x3f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B49 (⭉)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x3f, 0x02, 0x2c, 0x14, 0x28, 0x14, 0x00 },	// U+2B4A (⭊)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x3f, 0x02, 0x14, 0x28, 0x00, 0x00, 0x00 },	// U+2B4B (⭋)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3f, 0x10, 0x0d, 0x0a, 0x00, 0x00, 0x00 },	// U+2B4C (⭌)
	{ 0x00, 0x00, 0x08, 0x04, 0x02, 0x1f, 0x08, 0x05, 0x03, 0x07, 0x00, 0x00, 0x00 },	// U+2B4D (⭍)
	{ 0x00, 0x00, 0x00, 0x1c, 0x18, 0x18, 0x04, 0x04, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+2B4E (⭎)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x18, 0x18, 0x1c, 0x00, 0x00, 0x00 },	// U+2B4F (⭏)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0a, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2B50 (⭐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+2B51 (⭑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+2B52 (⭒)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x0f, 0x1f, 0x0f, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2B53 (⭓)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x11, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2B54 (⭔)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B55 (⭕)
}; // 23

static const unsigned char tewi_block159[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B58 (⭘)
}; // 1

static const unsigned char tewi_block160[][13] = {
	{ 0x00, 0x00, 0x1c, 0x22, 0x2a, 0x1a, 0x3a, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+2B5A (⭚)
	{ 0x00, 0x00, 0x00, 0x02, 0x05, 0x05, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+2B5B (⭛)
	{ 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x08, 0x04, 0x04, 0x04, 0x03, 0x00, 0x00, 0x00 },	// U+2B5C (⭜)
	{ 0x00, 0x00, 0x02, 0x05, 0x05, 0x04, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+2B5D (⭝)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x1e, 0x1a, 0x15, 0x03, 0x01, 0x00, 0x00 },	// U+2B5E (⭞)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x1e, 0x19, 0x15, 0x03, 0x01, 0x00, 0x00 },	// U+2B5F (⭟)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x1f, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B60 (⭠)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B61 (⭡)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x1f, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B62 (⭢)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B63 (⭣)
}; // 10

static const unsigned char tewi_block161[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x04, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2B65 (⭥)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x07, 0x07, 0x09, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2B66 (⭦)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1c, 0x1c, 0x12, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+2B67 (⭧)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x12, 0x1c, 0x1c, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2B68 (⭨)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x09, 0x07, 0x07, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+2B69 (⭩)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x2f, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B6A (⭪)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2B6B (⭫)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x3d, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2B6C (⭬)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2B6D (⭭)
	{ 0x00, 0x00, 0x00, 0x07, 0x06, 0x15, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B6E (⭮)
	{ 0x00, 0x00, 0x00, 0x1c, 0x0c, 0x15, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B6F (⭯)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x07, 0x1f, 0x07, 0x05, 0x00, 0x00, 0x00, 0x00 },	// U+2B70 (⭰)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0e, 0x1f, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B71 (⭱)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x1c, 0x1f, 0x1c, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+2B72 (⭲)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0e, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2B73 (⭳)
}; // 15

static const unsigned char tewi_block162[][13] = {
	{ 0x00, 0x00, 0x0f, 0x00, 0x0f, 0x07, 0x07, 0x09, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2B76 (⭶)
	{ 0x00, 0x00, 0x1e, 0x00, 0x1e, 0x1c, 0x1c, 0x12, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+2B77 (⭷)
	{ 0x00, 0x00, 0x01, 0x12, 0x1c, 0x1c, 0x1e, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2B78 (⭸)
	{ 0x00, 0x00, 0x10, 0x09, 0x07, 0x07, 0x0f, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+2B79 (⭹)
}; // 4

static const unsigned char tewi_block163[][13] = {
	{ 0x00, 0x00, 0x05, 0x07, 0x1f, 0x07, 0x15, 0x1c, 0x1f, 0x1c, 0x14, 0x00, 0x00 },	// U+2B7E (⭾)
}; // 1

static const unsigned char tewi_block164[][13] = {
	{ 0x00, 0x00, 0x04, 0x06, 0x1f, 0x06, 0x04, 0x0c, 0x1f, 0x0c, 0x04, 0x00, 0x00 },	// U+2B80 (⮀)
}; // 1

static const unsigned char tewi_block165[][13] = {
	{ 0x00, 0x00, 0x04, 0x0c, 0x1f, 0x0c, 0x04, 0x06, 0x1f, 0x06, 0x04, 0x00, 0x00 },	// U+2B82 (⮂)
}; // 1

static const unsigned char tewi_block166[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1d, 0x00, 0x1d, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B88 (⮈)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x1b, 0x1b, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+2B89 (⮉)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x17, 0x00, 0x17, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B8A (⮊)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1b, 0x1b, 0x11, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+2B8B (⮋)
	{ 0x00, 0x00, 0x00, 0x04, 0x06, 0x0f, 0x16, 0x14, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+2B8C (⮌)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x1d, 0x3f, 0x09, 0x09, 0x06, 0x00, 0x00, 0x00 },	// U+2B8D (⮍)
	{ 0x00, 0x00, 0x00, 0x1e, 0x01, 0x05, 0x09, 0x1e, 0x08, 0x04, 0x00, 0x00, 0x00 },	// U+2B8E (⮎)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x35, 0x2e, 0x24, 0x00, 0x00, 0x00 },	// U+2B8F (⮏)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x24, 0x26, 0x1f, 0x06, 0x04, 0x00, 0x00, 0x00 },	// U+2B90 (⮐)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x09, 0x19, 0x3e, 0x18, 0x08, 0x00, 0x00, 0x00 },	// U+2B91 (⮑)
	{ 0x00, 0x00, 0x00, 0x33, 0x20, 0x28, 0x2c, 0x3f, 0x0c, 0x08, 0x00, 0x00, 0x00 },	// U+2B92 (⮒)
	{ 0x00, 0x00, 0x00, 0x33, 0x01, 0x05, 0x0d, 0x3f, 0x0c, 0x04, 0x00, 0x00, 0x00 },	// U+2B93 (⮓)
}; // 12

static const unsigned char tewi_block167[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0f, 0x1f, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B95 (⮕)
}; // 1

static const unsigned char tewi_block168[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x26, 0x3f, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2BA0 (⮠)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x19, 0x3f, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2BA1 (⮡)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x3f, 0x26, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+2BA2 (⮢)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x3f, 0x19, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+2BA3 (⮣)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x04, 0x04, 0x04, 0x1c, 0x00, 0x00, 0x00 },	// U+2BA4 (⮤)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x04, 0x04, 0x04, 0x07, 0x00, 0x00, 0x00 },	// U+2BA5 (⮥)
	{ 0x00, 0x00, 0x00, 0x1c, 0x04, 0x04, 0x04, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2BA6 (⮦)
	{ 0x00, 0x00, 0x00, 0x07, 0x04, 0x04, 0x04, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2BA7 (⮧)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x3e, 0x3f, 0x1e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2BA8 (⮨)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x1f, 0x3f, 0x1e, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2BA9 (⮩)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1e, 0x3f, 0x3e, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+2BAA (⮪)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1e, 0x3f, 0x1f, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+2BAB (⮫)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x0e, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2BAC (⮬)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x0e, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+2BAD (⮭)
	{ 0x00, 0x00, 0x00, 0x1c, 0x0e, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2BAE (⮮)
	{ 0x00, 0x00, 0x00, 0x07, 0x0e, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2BAF (⮯)
}; // 16

static const unsigned char tewi_block169[][13] = {
	{ 0x00, 0x00, 0x04, 0x0a, 0x1f, 0x0a, 0x0e, 0x00, 0x0e, 0x0a, 0x0e, 0x00, 0x00 },	// U+2BB8 (⮸)
}; // 1

static const unsigned char tewi_block170[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2BC0 (⯀)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2BC1 (⯁)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2BC2 (⯂)
}; // 3

static const unsigned char tewi_block171[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+2BC5 (⯅)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2BC6 (⯆)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x1e, 0x1f, 0x1e, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2BC7 (⯇)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x1f, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2BC8 (⯈)
}; // 4

static const unsigned char tewi_block172[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2BCA (⯊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2BCB (⯋)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2BCC (⯌)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x0e, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2BCD (⯍)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2BCE (⯎)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x0a, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2BCF (⯏)
}; // 6

static const unsigned char tewi_block173[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x1e, 0x3f, 0x1e, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+2BEC (⯬)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x04, 0x0e, 0x1f, 0x04, 0x00, 0x00, 0x00 },	// U+2BED (⯭)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1e, 0x3f, 0x1e, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+2BEE (⯮)
	{ 0x00, 0x00, 0x00, 0x04, 0x1f, 0x0e, 0x04, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2BEF (⯯)
}; // 4

static const unsigned char tewi_block174[][13] = {
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x07, 0x02, 0x07, 0x02, 0x1e, 0x00, 0x00, 0x00 },	// U+2C60 (Ⱡ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x0c, 0x00, 0x00, 0x00 },	// U+2C61 (ⱡ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x16, 0x0b, 0x02, 0x02, 0x1e, 0x00, 0x00, 0x00 },	// U+2C62 (Ɫ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x17, 0x12, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+2C63 (Ᵽ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x11, 0x01, 0x06, 0x00 },	// U+2C64 (Ɽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x1e, 0x19, 0x15, 0x1b, 0x17, 0x00, 0x00, 0x00 },	// U+2C65 (ⱥ)
	{ 0x00, 0x00, 0x00, 0x04, 0x14, 0x1e, 0x0c, 0x04, 0x06, 0x18, 0x00, 0x00, 0x00 },	// U+2C66 (ⱦ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x31, 0x20, 0x20, 0x00 },	// U+2C67 (Ⱨ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x31, 0x20, 0x20, 0x00 },	// U+2C68 (ⱨ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x31, 0x20, 0x20, 0x00 },	// U+2C69 (Ⱪ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x09, 0x05, 0x07, 0x09, 0x31, 0x20, 0x20, 0x00 },	// U+2C6A (ⱪ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x3f, 0x20, 0x20, 0x00 },	// U+2C6B (Ⱬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x3f, 0x20, 0x20, 0x00 },	// U+2C6C (ⱬ)
	{ 0x00, 0x00, 0x00, 0x16, 0x19, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00, 0x00 },	// U+2C6D (Ɑ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x10, 0x0c, 0x00 },	// U+2C6E (Ɱ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2C6F (Ɐ)
	{ 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+2C70 (Ɒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x29, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2C71 (ⱱ)
	{ 0x00, 0x00, 0x20, 0x11, 0x11, 0x11, 0x11, 0x15, 0x1b, 0x11, 0x00, 0x00, 0x00 },	// U+2C72 (Ⱳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+2C73 (ⱳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x15, 0x13, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2C74 (ⱴ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+2C75 (Ⱶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+2C76 (ⱶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x09, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+2C77 (ⱷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x01, 0x2e, 0x10, 0x00, 0x00 },	// U+2C78 (ⱸ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x10, 0x18, 0x16, 0x00, 0x00, 0x00 },	// U+2C79 (ⱹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+2C7A (ⱺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1e, 0x10, 0x1f, 0x00, 0x00, 0x00 },	// U+2C7B (ⱻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03 },	// U+2C7C (ⱼ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2C7D (ⱽ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x02, 0x0c, 0x00 },	// U+2C7E (Ȿ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x03, 0x24, 0x18, 0x00 },	// U+2C7F (Ɀ)
}; // 32

static const unsigned char tewi_block175[][13] = {
	{ 0x00, 0x00, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E00 (⸀)
	{ 0x00, 0x00, 0x0e, 0x02, 0x0a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E01 (⸁)
	{ 0x00, 0x00, 0x0c, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E02 (⸂)
	{ 0x00, 0x00, 0x06, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E03 (⸃)
	{ 0x00, 0x00, 0x0c, 0x02, 0x0a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E04 (⸄)
	{ 0x00, 0x00, 0x06, 0x08, 0x0a, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E05 (⸅)
	{ 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E06 (⸆)
	{ 0x00, 0x00, 0x1f, 0x04, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E07 (⸇)
	{ 0x00, 0x00, 0x0c, 0x12, 0x02, 0x24, 0x08, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2E08 (⸈)
	{ 0x00, 0x00, 0x0c, 0x12, 0x02, 0x04, 0x08, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2E09 (⸉)
	{ 0x00, 0x00, 0x06, 0x09, 0x08, 0x04, 0x02, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2E0A (⸊)
	{ 0x00, 0x00, 0x1e, 0x12, 0x12, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E0B (⸋)
	{ 0x00, 0x00, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E0C (⸌)
	{ 0x00, 0x00, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E0D (⸍)
}; // 14

static const unsigned char tewi_block176[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00 },	// U+2E0F (⸏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x02, 0x01, 0x00 },	// U+2E10 (⸐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x10, 0x20, 0x00 },	// U+2E11 (⸑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0x00, 0x00 },	// U+2E12 (⸒)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x12, 0x08, 0x04, 0x12, 0x01, 0x00, 0x00, 0x00 },	// U+2E13 (⸓)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x11, 0x09, 0x05, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+2E14 (⸔)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x28, 0x24, 0x22, 0x01, 0x00, 0x00, 0x00 },	// U+2E15 (⸕)
	{ 0x00, 0x00, 0x00, 0x12, 0x04, 0x08, 0x10, 0x08, 0x04, 0x12, 0x00, 0x00, 0x00 },	// U+2E16 (⸖)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x06, 0x00, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2E17 (⸗)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x0c, 0x14, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+2E18 (⸘)
}; // 10

static const unsigned char tewi_block177[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2E1A (⸚)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00 },	// U+2E1B (⸛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x00 },	// U+2E1C (⸜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x00 },	// U+2E1D (⸝)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E1E (⸞)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E1F (⸟)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+2E20 (⸠)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2E21 (⸡)
	{ 0x00, 0x00, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E22 (⸢)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2E23 (⸣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x00, 0x00 },	// U+2E24 (⸤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00, 0x00 },	// U+2E25 (⸥)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x01, 0x01, 0x01, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2E26 (⸦)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x20, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2E27 (⸧)
	{ 0x00, 0x00, 0x14, 0x0a, 0x0a, 0x05, 0x05, 0x05, 0x0a, 0x0a, 0x14, 0x00, 0x00 },	// U+2E28 (⸨)
	{ 0x00, 0x00, 0x0a, 0x14, 0x14, 0x28, 0x28, 0x28, 0x14, 0x14, 0x0a, 0x00, 0x00 },	// U+2E29 (⸩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2E2A (⸪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E2B (⸫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00 },	// U+2E2C (⸬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x15, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2E2D (⸭)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x02, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2E2E (⸮)
	{ 0x00, 0x00, 0x08, 0x04, 0x04, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E2F (ⸯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2E30 (⸰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2E31 (⸱)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E32 (⸲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E33 (⸳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00 },	// U+2E34 (⸴)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x0c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2E35 (⸵)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+2E36 (⸶)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+2E37 (⸷)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00 },	// U+2E38 (⸸)
	{ 0x00, 0x00, 0x0c, 0x12, 0x02, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2E39 (⸹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x04, 0x0a, 0x00, 0x00, 0x00 },	// U+2E3A (⸺)
	{ 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04 },	// U+2E3B (⸻)
	{ 0x00, 0x0c, 0x02, 0x04, 0x08, 0x04, 0x02, 0x04, 0x08, 0x04, 0x02, 0x0c, 0x00 },	// U+2E3C (⸼)
	{ 0x00, 0x00, 0x14, 0x1e, 0x35, 0x15, 0x3f, 0x15, 0x1e, 0x14, 0x14, 0x14, 0x14 },	// U+2E3D (⸽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2E3E (⸾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x04, 0x08, 0x00 },	// U+2E3F (⸿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x0a, 0x14, 0x00 },	// U+2E40 (⹀)
}; // 39

static const unsigned char tewi_block178[][13] = {
	{ 0x00, 0x00, 0x03, 0x13, 0x3b, 0x13, 0x13, 0x0b, 0x07, 0x03, 0x03, 0x00, 0x00 },	// U+E0A0 ()
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x1e, 0x00, 0x16, 0x1e, 0x1a, 0x00, 0x00, 0x00 },	// U+E0A1 ()
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x3f, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+E0A2 ()
}; // 3

static const unsigned char tewi_block179[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+E0A5 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x01, 0x1c, 0x01, 0x1d, 0x00, 0x00, 0x00, 0x00 },	// U+E0A6 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x13, 0x13, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+E0A7 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x11, 0x04, 0x11, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+E0A8 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x17, 0x10, 0x11, 0x01, 0x1d, 0x00, 0x00, 0x00, 0x00 },	// U+E0A9 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00 },	// U+E0AA ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1c, 0x1d, 0x00, 0x00, 0x00, 0x00 },	// U+E0AB ()
	{ 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x07, 0x17, 0x00, 0x00, 0x00, 0x00 },	// U+E0AC ()
}; // 8

static const unsigned char tewi_block180[][13] = {
	{ 0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 0x00 },	// U+E0B0 ()
	{ 0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00 },	// U+E0B1 ()
	{ 0x00, 0x20, 0x30, 0x38, 0x3c, 0x3e, 0x3f, 0x3e, 0x3c, 0x38, 0x30, 0x20, 0x00 },	// U+E0B2 ()
	{ 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00 },	// U+E0B3 ()
}; // 4

static const unsigned char tewi_block181[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+E0B5 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x2a, 0x15, 0x2a, 0x00, 0x00, 0x00 },	// U+E0B6 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x1b, 0x3f, 0x1b, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+E0B7 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1f, 0x19, 0x19, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+E0B8 ()
}; // 4

static const unsigned char tewi_block182[][13] = {
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x21, 0x21, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+E0C0 ()
	{ 0x00, 0x00, 0x00, 0x0c, 0x16, 0x23, 0x23, 0x16, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+E0C1 ()
	{ 0x00, 0x00, 0x00, 0x0c, 0x16, 0x27, 0x27, 0x16, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+E0C2 ()
	{ 0x00, 0x00, 0x00, 0x0c, 0x16, 0x2f, 0x2f, 0x16, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+E0C3 ()
	{ 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x3f, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+E0C4 ()
	{ 0x00, 0x00, 0x00, 0x0c, 0x1a, 0x3d, 0x3d, 0x1a, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+E0C5 ()
	{ 0x00, 0x00, 0x00, 0x0c, 0x1a, 0x39, 0x39, 0x1a, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+E0C6 ()
	{ 0x00, 0x00, 0x00, 0x0c, 0x1a, 0x31, 0x31, 0x1a, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+E0C7 ()
}; // 8

static const unsigned char tewi_block183[][13] = {
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x02, 0x17, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+FB01 (ﬁ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x17, 0x12, 0x12, 0x32, 0x00, 0x00, 0x00 },	// U+FB02 (ﬂ)
}; // 2

static const unsigned char tewi_block184[][13] = {
	{ 0x00, 0x00, 0x04, 0x0e, 0x1b, 0x15, 0x17, 0x1b, 0x1f, 0x1b, 0x0e, 0x04, 0x00 },	// U+FFFD (�)
}; // 1

