/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font ter-u16b.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char terminusb_block1[][16] = {
	{ 0x00, 0x00, 0x77, 0x63, 0x00, 0x63, 0x63, 0x63, 0x00, 0x63, 0x63, 0x77, 0x00, 0x00, 0x00, 0x00 },	// U+0000 (ESC)
}; // 1

static const unsigned char terminusb_block2[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x36, 0x36, 0x36, 0x7f, 0x36, 0x36, 0x7f, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x08, 0x08, 0x3e, 0x6b, 0x0b, 0x0b, 0x3e, 0x68, 0x68, 0x6b, 0x3e, 0x08, 0x08, 0x00, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x66, 0x6b, 0x36, 0x30, 0x18, 0x18, 0x0c, 0x6c, 0xd6, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x6e, 0x3b, 0x33, 0x33, 0x3b, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+0028 (()
	{ 0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x1c, 0x7f, 0x1c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x18, 0x1c, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x60, 0x3c, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x60, 0x70, 0x78, 0x6c, 0x66, 0x63, 0x7f, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x3f, 0x60, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x3c, 0x06, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x7f, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x30, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x30, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x3e, 0x63, 0x73, 0x6b, 0x6b, 0x6b, 0x6b, 0x73, 0x03, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x03, 0x03, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x1f, 0x33, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x7b, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x63, 0x63, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x41, 0x63, 0x77, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7b, 0x3e, 0x60, 0x00, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x36, 0x36, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6b, 0x7f, 0x77, 0x63, 0x41, 0x00, 0x00, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x7f, 0x60, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+005B ([)
	{ 0x00, 0x00, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+005C (\)
	{ 0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+005D (])
	{ 0x00, 0x18, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00 },	// U+005F (_)
	{ 0x00, 0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x60, 0x60, 0x60, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x78, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+0067 (g)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x00 },	// U+006A (j)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x63, 0x33, 0x1b, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x03, 0x00 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x00 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0x0f, 0x07, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x36, 0x1c, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x00, 0x38, 0x0c, 0x0c, 0x0c, 0x06, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+007B ({)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+007C (|)
	{ 0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x30, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xdb, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
}; // 95

static const unsigned char terminusb_block3[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x6b, 0x0b, 0x0b, 0x0b, 0x6b, 0x3e, 0x08, 0x08, 0x00, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x1c, 0x36, 0x06, 0x06, 0x1f, 0x06, 0x06, 0x06, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x3c, 0x66, 0x06, 0x1c, 0x36, 0x66, 0x66, 0x6c, 0x38, 0x60, 0x66, 0x3c, 0x00, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x7e, 0x81, 0x99, 0xa5, 0x85, 0xa5, 0x99, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x3c, 0x60, 0x7c, 0x66, 0x7c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x6c, 0x36, 0x1b, 0x36, 0x6c, 0xd8, 0x00, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x00, 0x00, 0x00, 0x7e, 0x81, 0x9d, 0xa5, 0x9d, 0x95, 0xa5, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00AE (®)
	{ 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x00, 0x1c, 0x36, 0x30, 0x18, 0x0c, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x00, 0x1e, 0x30, 0x1c, 0x30, 0x30, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6f, 0x03, 0x03, 0x03, 0x00 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x7e, 0x6b, 0x6b, 0x6b, 0x6b, 0x6e, 0x68, 0x68, 0x68, 0x68, 0x00, 0x00, 0x00, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x06, 0x00 },	// U+00B8 (¸)
	{ 0x00, 0x18, 0x1c, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x00, 0x06, 0x07, 0x46, 0x66, 0x36, 0x18, 0x0c, 0x66, 0x73, 0x59, 0x7c, 0x60, 0x60, 0x00, 0x00 },	// U+00BC (¼)
	{ 0x00, 0x06, 0x07, 0x46, 0x66, 0x36, 0x18, 0x0c, 0x06, 0x3b, 0x6d, 0x30, 0x18, 0x7c, 0x00, 0x00 },	// U+00BD (½)
	{ 0x00, 0x07, 0x0c, 0x46, 0x6c, 0x37, 0x18, 0x0c, 0x66, 0x73, 0x59, 0x7c, 0x60, 0x60, 0x00, 0x00 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x06, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00BF (¿)
	{ 0x0c, 0x18, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x6e, 0x3b, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x1c, 0x36, 0x1c, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x7e, 0x1b, 0x1b, 0x1b, 0x7f, 0x1b, 0x1b, 0x1b, 0x1b, 0x7b, 0x00, 0x00, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x03, 0x03, 0x63, 0x63, 0x3e, 0x0c, 0x0c, 0x06, 0x00 },	// U+00C7 (Ç)
	{ 0x0c, 0x18, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x18, 0x0c, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x1c, 0x36, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x36, 0x36, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x0c, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x30, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x1c, 0x36, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x1e, 0x36, 0x66, 0x66, 0x6f, 0x66, 0x66, 0x66, 0x36, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x6e, 0x3b, 0x00, 0x63, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x0c, 0x18, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x6e, 0x3b, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x36, 0x1c, 0x1c, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x00, 0x3e, 0xe3, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D8 (Ø)
	{ 0x0c, 0x18, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x18, 0x0c, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x1c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x30, 0x18, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x1e, 0x33, 0x33, 0x13, 0x3f, 0x63, 0x63, 0x63, 0x67, 0x3b, 0x00, 0x00, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x00, 0x0c, 0x18, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x5e, 0x00, 0x00, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x00, 0x1c, 0x36, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x00, 0x1c, 0x36, 0x1c, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x68, 0x68, 0x7e, 0x0b, 0x0b, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x0c, 0x0c, 0x06, 0x00 },	// U+00E7 (ç)
	{ 0x00, 0x00, 0x0c, 0x18, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x00, 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x00, 0x0c, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x00, 0x1c, 0x36, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x00, 0x16, 0x0c, 0x1a, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x0c, 0x18, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x00, 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xe6, 0x76, 0x7e, 0x6e, 0x67, 0x3d, 0x00, 0x00, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x00, 0x0c, 0x18, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x00, 0x1c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+00FD (ý)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x03, 0x00 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+00FF (ÿ)
	{ 0x3e, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0101 (ā)
	{ 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x60, 0x30, 0xe0, 0x00 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x60, 0x30, 0xe0, 0x00 },	// U+0105 (ą)
	{ 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x03, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x03, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x00, 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x18, 0x18, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x03, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+010B (ċ)
	{ 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x03, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+010D (č)
	{ 0x36, 0x1c, 0x00, 0x1f, 0x33, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x36, 0x1c, 0x60, 0x60, 0x60, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x1e, 0x36, 0x66, 0x66, 0x6f, 0x66, 0x66, 0x66, 0x36, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x00, 0x60, 0xf8, 0x60, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x3e, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0113 (ē)
	{ 0x36, 0x1c, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0114 (Ĕ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0115 (ĕ)
	{ 0x18, 0x18, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x60, 0x30, 0xe0, 0x00 },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x18, 0x0c, 0x38, 0x00 },	// U+0119 (ę)
	{ 0x36, 0x1c, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+011B (ě)
	{ 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x7b, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x00, 0x1c, 0x36, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+011D (ĝ)
	{ 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x7b, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+011F (ğ)
	{ 0x18, 0x18, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x7b, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x7b, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x0c, 0x0c, 0x06 },	// U+0122 (Ģ)
	{ 0x00, 0x30, 0x18, 0x18, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+0123 (ģ)
	{ 0x1c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x38, 0x6c, 0x03, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x66, 0xff, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x00, 0x06, 0x1f, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0x6e, 0x3b, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x7e, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+012B (ī)
	{ 0x36, 0x1c, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+012C (Ĭ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+012D (ĭ)
	{ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x0c, 0x38, 0x00 },	// U+012E (Į)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x0c, 0x38, 0x00 },	// U+012F (į)
	{ 0x18, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0131 (ı)
	{ 0x00, 0x00, 0xf3, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6f, 0x6f, 0x3b, 0x00, 0x00, 0x00, 0x00 },	// U+0132 (Ĳ)
	{ 0x00, 0x00, 0x63, 0x63, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6c, 0x6c, 0x38, 0x00 },	// U+0133 (ĳ)
	{ 0x38, 0x6c, 0x00, 0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x00, 0x70, 0xd8, 0x00, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x00 },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x63, 0x63, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x63, 0x63, 0x00, 0x0c, 0x0c, 0x06 },	// U+0136 (Ķ)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x63, 0x33, 0x1b, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x0c, 0x0c, 0x06 },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x33, 0x1b, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x06, 0x03, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x18, 0x0c, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x0c, 0x0c, 0x06 },	// U+013B (Ļ)
	{ 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x18, 0x18, 0x0c },	// U+013C (ļ)
	{ 0x36, 0x1c, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x1b, 0x0e, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+013E (ľ)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+013F (Ŀ)
	{ 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+0140 (ŀ)
	{ 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x0e, 0x07, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x1c, 0x0e, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x18, 0x0c, 0x63, 0x63, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x0c, 0x0c, 0x06 },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x0c, 0x0c, 0x06 },	// U+0146 (ņ)
	{ 0x36, 0x1c, 0x63, 0x63, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0148 (ň)
	{ 0x00, 0x06, 0x06, 0x03, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0149 (ŉ)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x60, 0x60, 0x38, 0x00 },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x60, 0x60, 0x38, 0x00 },	// U+014B (ŋ)
	{ 0x3e, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+014D (ō)
	{ 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+014E (Ŏ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+014F (ŏ)
	{ 0x6c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x00, 0x6c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x7e, 0x1b, 0x1b, 0x1b, 0x7b, 0x1b, 0x1b, 0x1b, 0x1b, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x6b, 0x6b, 0x7b, 0x0b, 0x0b, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x18, 0x0c, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x3f, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x7b, 0x0f, 0x07, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x0c, 0x0c, 0x06 },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x1e, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x06, 0x03 },	// U+0157 (ŗ)
	{ 0x36, 0x1c, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x3f, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x7b, 0x0f, 0x07, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x7e, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+015B (ś)
	{ 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x00, 0x1c, 0x36, 0x00, 0x7e, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x0c, 0x0c, 0x06, 0x00 },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x3f, 0x0c, 0x0c, 0x06, 0x00 },	// U+015F (ş)
	{ 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x7e, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x18, 0x00 },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x78, 0x30, 0x30, 0x18, 0x00 },	// U+0163 (ţ)
	{ 0x36, 0x1c, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x36, 0x1c, 0x00, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x3f, 0x0c, 0x1e, 0x0c, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0x6e, 0x3b, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x3e, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+016B (ū)
	{ 0x36, 0x1c, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x1c, 0x36, 0x1c, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x00, 0x00, 0x1c, 0x36, 0x1c, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+016F (ů)
	{ 0x6c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x00, 0x6c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x18, 0x0c, 0x38, 0x00 },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x30, 0xe0, 0x00 },	// U+0173 (ų)
	{ 0x1c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x6b, 0x7f, 0x77, 0x63, 0x41, 0x00, 0x00, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x00, 0x1c, 0x36, 0x00, 0x63, 0x63, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x1c, 0x36, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x00, 0x1c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+0177 (ŷ)
	{ 0x66, 0x66, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x18, 0x0c, 0x00, 0x7f, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x7f, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+017A (ź)
	{ 0x18, 0x18, 0x00, 0x7f, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x7f, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+017C (ż)
	{ 0x36, 0x1c, 0x00, 0x7f, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x7f, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+017E (ž)
	{ 0x00, 0x00, 0x78, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+017F (ſ)
}; // 224

static const unsigned char terminusb_block4[][16] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x60, 0x60, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0186 (Ɔ)
}; // 1

static const unsigned char terminusb_block5[][16] = {
	{ 0x00, 0x00, 0x7f, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+018E (Ǝ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x60, 0x60, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+018F (Ə)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x1e, 0x03, 0x03, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0190 (Ɛ)
}; // 3

static const unsigned char terminusb_block6[][16] = {
	{ 0x00, 0x00, 0x70, 0xd8, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x0e, 0x00 },	// U+0192 (ƒ)
}; // 1

static const unsigned char terminusb_block7[][16] = {
	{ 0x00, 0x00, 0x66, 0x66, 0x66, 0x6e, 0x7e, 0x76, 0x66, 0x66, 0x66, 0x66, 0x06, 0x06, 0x03, 0x00 },	// U+019D (Ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x60, 0x60, 0x60, 0x00 },	// U+019E (ƞ)
}; // 2

static const unsigned char terminusb_block8[][16] = {
	{ 0x00, 0x00, 0x7f, 0x60, 0x30, 0x18, 0x7f, 0x0c, 0x06, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+01B5 (Ƶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x30, 0x18, 0x3f, 0x0c, 0x06, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+01B6 (ƶ)
	{ 0x00, 0x00, 0x7f, 0x60, 0x30, 0x18, 0x3c, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01B7 (Ʒ)
}; // 3

static const unsigned char terminusb_block9[][16] = {
	{ 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+01CD (Ǎ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3e, 0x60, 0x7e, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+01CE (ǎ)
	{ 0x36, 0x1c, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+01CF (Ǐ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+01D0 (ǐ)
	{ 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01D1 (Ǒ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01D2 (ǒ)
	{ 0x36, 0x1c, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01D3 (Ǔ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+01D4 (ǔ)
}; // 8

static const unsigned char terminusb_block10[][16] = {
	{ 0x3e, 0x00, 0x7e, 0x1b, 0x1b, 0x1b, 0x7f, 0x1b, 0x1b, 0x1b, 0x1b, 0x7b, 0x00, 0x00, 0x00, 0x00 },	// U+01E2 (Ǣ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x36, 0x68, 0x68, 0x7e, 0x0b, 0x0b, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+01E3 (ǣ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x7b, 0x63, 0xfb, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01E4 (Ǥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x63, 0x63, 0xfb, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+01E5 (ǥ)
	{ 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x7b, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01E6 (Ǧ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+01E7 (ǧ)
	{ 0x36, 0x1c, 0x63, 0x63, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+01E8 (Ǩ)
	{ 0x36, 0x1c, 0x03, 0x03, 0x03, 0x63, 0x33, 0x1b, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+01E9 (ǩ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x18, 0x0c, 0x38, 0x00 },	// U+01EA (Ǫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x18, 0x0c, 0x38, 0x00 },	// U+01EB (ǫ)
	{ 0x3e, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x18, 0x0c, 0x38, 0x00 },	// U+01EC (Ǭ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x18, 0x0c, 0x38, 0x00 },	// U+01ED (ǭ)
	{ 0x36, 0x1c, 0x00, 0x7f, 0x30, 0x18, 0x3c, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01EE (Ǯ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x7f, 0x60, 0x30, 0x18, 0x3c, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x00 },	// U+01EF (ǯ)
	{ 0x00, 0x00, 0xd8, 0x70, 0x00, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x00 },	// U+01F0 (ǰ)
}; // 15

static const unsigned char terminusb_block11[][16] = {
	{ 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x7b, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01F4 (Ǵ)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+01F5 (ǵ)
}; // 2

static const unsigned char terminusb_block12[][16] = {
	{ 0x30, 0x18, 0x00, 0x7e, 0x1b, 0x1b, 0x1b, 0x7f, 0x1b, 0x1b, 0x1b, 0x7b, 0x00, 0x00, 0x00, 0x00 },	// U+01FC (Ǽ)
	{ 0x00, 0x00, 0x30, 0x18, 0x00, 0x36, 0x68, 0x68, 0x7e, 0x0b, 0x0b, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+01FD (ǽ)
	{ 0x18, 0x0c, 0x00, 0x3e, 0xe3, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+01FE (Ǿ)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0xbc, 0xe6, 0x76, 0x7e, 0x6e, 0x67, 0x3d, 0x00, 0x00, 0x00, 0x00 },	// U+01FF (ǿ)
}; // 4

static const unsigned char terminusb_block13[][16] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x0c, 0x0c, 0x06 },	// U+0218 (Ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x3f, 0x00, 0x0c, 0x0c, 0x06 },	// U+0219 (ș)
	{ 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x0c },	// U+021A (Ț)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x78, 0x00, 0x30, 0x30, 0x18 },	// U+021B (ț)
}; // 4

static const unsigned char terminusb_block14[][16] = {
	{ 0x7e, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0232 (Ȳ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+0233 (ȳ)
}; // 2

static const unsigned char terminusb_block15[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x00 },	// U+0237 (ȷ)
}; // 1

static const unsigned char terminusb_block16[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x60, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0254 (ɔ)
}; // 1

static const unsigned char terminusb_block17[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x60, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0258 (ɘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0x60, 0x7f, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0259 (ə)
}; // 2

static const unsigned char terminusb_block18[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x1e, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+025B (ɛ)
}; // 1

static const unsigned char terminusb_block19[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x06, 0x06, 0x03, 0x00 },	// U+0272 (ɲ)
}; // 1

static const unsigned char terminusb_block20[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x60, 0x30, 0x18, 0x3c, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x00 },	// U+0292 (ʒ)
}; // 1

static const unsigned char terminusb_block21[][16] = {
	{ 0x18, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BB (ʻ)
	{ 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BC (ʼ)
	{ 0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BD (ʽ)
}; // 3

static const unsigned char terminusb_block22[][16] = {
	{ 0x1c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C6 (ˆ)
	{ 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C7 (ˇ)
}; // 2

static const unsigned char terminusb_block23[][16] = {
	{ 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D8 (˘)
	{ 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D9 (˙)
}; // 2

static const unsigned char terminusb_block24[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0c, 0x38, 0x00 },	// U+02DB (˛)
	{ 0x6e, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DC (˜)
	{ 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DD (˝)
}; // 3

static const unsigned char terminusb_block25[][16] = {
	{ 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0300 (̀)
	{ 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0301 (́)
	{ 0x1c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0302 (̂)
	{ 0x6e, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0303 (̃)
	{ 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0304 (̄)
	{ 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0305 (̅)
	{ 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0306 (̆)
	{ 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0307 (̇)
	{ 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0308 (̈)
}; // 9

static const unsigned char terminusb_block26[][16] = {
	{ 0x1c, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030A (̊)
	{ 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030B (̋)
	{ 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030C (̌)
}; // 3

static const unsigned char terminusb_block27[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },	// U+0329 (̩)
}; // 1

static const unsigned char terminusb_block28[][16] = {
	{ 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0384 (΄)
	{ 0x18, 0x0c, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0385 (΅)
	{ 0x06, 0x03, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0386 (Ά)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0387 (·)
	{ 0x06, 0x03, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0388 (Έ)
	{ 0x06, 0x03, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0389 (Ή)
	{ 0x06, 0x03, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+038A (Ί)
}; // 7

static const unsigned char terminusb_block29[][16] = {
	{ 0x06, 0x03, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+038C (Ό)
}; // 1

static const unsigned char terminusb_block30[][16] = {
	{ 0x06, 0x03, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+038E (Ύ)
	{ 0x06, 0x03, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x36, 0x77, 0x00, 0x00, 0x00, 0x00 },	// U+038F (Ώ)
	{ 0x18, 0x0c, 0x1b, 0x1b, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+0390 (ΐ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0391 (Α)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0392 (Β)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0393 (Γ)
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x1c, 0x36, 0x36, 0x36, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0394 (Δ)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0395 (Ε)
	{ 0x00, 0x00, 0x7f, 0x60, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0396 (Ζ)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0397 (Η)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0398 (Θ)
	{ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0399 (Ι)
	{ 0x00, 0x00, 0x63, 0x63, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+039A (Κ)
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x1c, 0x36, 0x36, 0x36, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+039B (Λ)
	{ 0x00, 0x00, 0x41, 0x63, 0x77, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+039C (Μ)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+039D (Ν)
	{ 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+039E (Ξ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+039F (Ο)
	{ 0x00, 0x00, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+03A0 (Π)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+03A1 (Ρ)
}; // 20

static const unsigned char terminusb_block31[][16] = {
	{ 0x00, 0x00, 0x7f, 0x03, 0x06, 0x0c, 0x18, 0x18, 0x0c, 0x06, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+03A3 (Σ)
	{ 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+03A4 (Τ)
	{ 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+03A5 (Υ)
	{ 0x00, 0x00, 0x08, 0x3e, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+03A6 (Φ)
	{ 0x00, 0x00, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+03A7 (Χ)
	{ 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+03A8 (Ψ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x36, 0x77, 0x00, 0x00, 0x00, 0x00 },	// U+03A9 (Ω)
	{ 0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+03AA (Ϊ)
	{ 0x66, 0x66, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+03AB (Ϋ)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x5e, 0x73, 0x33, 0x33, 0x33, 0x73, 0x5e, 0x00, 0x00, 0x00, 0x00 },	// U+03AC (ά)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x03, 0x1e, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03AD (έ)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x60, 0x60, 0x60, 0x00 },	// U+03AE (ή)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+03AF (ί)
	{ 0x18, 0x0c, 0x00, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03B0 (ΰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x73, 0x33, 0x33, 0x33, 0x73, 0x5e, 0x00, 0x00, 0x00, 0x00 },	// U+03B1 (α)
	{ 0x00, 0x00, 0x1e, 0x33, 0x33, 0x13, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x03, 0x00 },	// U+03B2 (β)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00 },	// U+03B3 (γ)
	{ 0x00, 0x00, 0x7e, 0x0c, 0x18, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03B4 (δ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x1e, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03B5 (ε)
	{ 0x00, 0x00, 0x7f, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x03, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x30, 0x00 },	// U+03B6 (ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x60, 0x60, 0x60, 0x00 },	// U+03B7 (η)
	{ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+03B8 (θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+03B9 (ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x33, 0x1b, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+03BA (κ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0xc3, 0xc3, 0x00, 0x00, 0x00, 0x00 },	// U+03BB (λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6f, 0x03, 0x03, 0x03, 0x00 },	// U+03BC (μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+03BD (ν)
	{ 0x00, 0x00, 0x7e, 0x03, 0x03, 0x03, 0x3e, 0x03, 0x03, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x30, 0x00 },	// U+03BE (ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03BF (ο)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+03C0 (π)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x03, 0x00 },	// U+03C1 (ρ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x30, 0x00 },	// U+03C2 (ς)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+03C3 (σ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00 },	// U+03C4 (τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03C5 (υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x08, 0x08, 0x00 },	// U+03C6 (φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0x63, 0x00 },	// U+03C7 (χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x08, 0x08, 0x00 },	// U+03C8 (ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+03C9 (ω)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+03CA (ϊ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03CB (ϋ)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03CC (ό)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03CD (ύ)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x22, 0x63, 0x6b, 0x6b, 0x6b, 0x7f, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+03CE (ώ)
}; // 44

static const unsigned char terminusb_block32[][16] = {
	{ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0xfc, 0x60, 0x67, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+03D1 (ϑ)
}; // 1

static const unsigned char terminusb_block33[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x00, 0x00, 0x00 },	// U+03D5 (ϕ)
}; // 1

static const unsigned char terminusb_block34[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc7, 0x6c, 0x38, 0x18, 0x1c, 0x36, 0xe3, 0x00, 0x00, 0x00, 0x00 },	// U+03F0 (ϰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x3e, 0x00 },	// U+03F1 (ϱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03F2 (ϲ)
	{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x00 },	// U+03F3 (ϳ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+03F4 (ϴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x06, 0x03, 0x3f, 0x03, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+03F5 (ϵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x30, 0x60, 0x7e, 0x60, 0x30, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+03F6 (϶)
}; // 7

static const unsigned char terminusb_block35[][16] = {
	{ 0x0c, 0x18, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0400 (Ѐ)
	{ 0x36, 0x36, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0401 (Ё)
	{ 0x00, 0x00, 0x0f, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+0402 (Ђ)
	{ 0x18, 0x0c, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0403 (Ѓ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0404 (Є)
	{ 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0405 (Ѕ)
	{ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0406 (І)
	{ 0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0407 (Ї)
	{ 0x00, 0x00, 0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0408 (Ј)
	{ 0x00, 0x00, 0x0c, 0x0e, 0x0b, 0x3b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x39, 0x00, 0x00, 0x00, 0x00 },	// U+0409 (Љ)
	{ 0x00, 0x00, 0x0b, 0x0b, 0x0b, 0x3b, 0x6f, 0x6b, 0x6b, 0x6b, 0x6b, 0x3b, 0x00, 0x00, 0x00, 0x00 },	// U+040A (Њ)
	{ 0x00, 0x00, 0x0f, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+040B (Ћ)
	{ 0x18, 0x0c, 0x63, 0x63, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+040C (Ќ)
	{ 0x0c, 0x18, 0x63, 0x63, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+040D (Ѝ)
	{ 0x36, 0x1c, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+040E (Ў)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x1c, 0x1c, 0x00, 0x00 },	// U+040F (Џ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0410 (А)
	{ 0x00, 0x00, 0x3f, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0411 (Б)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0412 (В)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0413 (Г)
	{ 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0xc3, 0x00, 0x00, 0x00 },	// U+0414 (Д)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0415 (Е)
	{ 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x3e, 0x1c, 0x3e, 0x6b, 0x6b, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+0416 (Ж)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x60, 0x3c, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0417 (З)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0418 (И)
	{ 0x36, 0x1c, 0x63, 0x63, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0419 (Й)
	{ 0x00, 0x00, 0x63, 0x63, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+041A (К)
	{ 0x00, 0x00, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+041B (Л)
	{ 0x00, 0x00, 0x41, 0x63, 0x77, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+041C (М)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+041D (Н)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+041E (О)
	{ 0x00, 0x00, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+041F (П)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0420 (Р)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x03, 0x03, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0421 (С)
	{ 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0422 (Т)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0423 (У)
	{ 0x00, 0x08, 0x3e, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x00, 0x00, 0x00 },	// U+0424 (Ф)
	{ 0x00, 0x00, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0425 (Х)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0xfe, 0xc0, 0xc0, 0x00, 0x00 },	// U+0426 (Ц)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+0427 (Ч)
	{ 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0428 (Ш)
	{ 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0xfe, 0xc0, 0xc0, 0x00, 0x00 },	// U+0429 (Щ)
	{ 0x00, 0x00, 0x07, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+042A (Ъ)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x67, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+042B (Ы)
	{ 0x00, 0x00, 0x06, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+042C (Ь)
	{ 0x00, 0x00, 0x3e, 0x63, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+042D (Э)
	{ 0x00, 0x00, 0x33, 0x6b, 0x6b, 0x6b, 0x6b, 0x6f, 0x6b, 0x6b, 0x6b, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+042E (Ю)
	{ 0x00, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x78, 0x6c, 0x66, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+042F (Я)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0430 (а)
	{ 0x00, 0x00, 0x3e, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0431 (б)
	{ 0x00, 0x00, 0x1e, 0x33, 0x33, 0x13, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0432 (в)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0433 (г)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+0434 (д)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0435 (е)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x6b, 0x3e, 0x1c, 0x3e, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+0436 (ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x60, 0x3c, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0437 (з)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0438 (и)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0439 (й)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x33, 0x1b, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+043A (к)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+043B (л)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x77, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+043C (м)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+043D (н)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+043E (о)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+043F (п)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x03, 0x00 },	// U+0440 (р)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0441 (с)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0442 (т)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+0443 (у)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x3e, 0x08, 0x00, 0x00, 0x00 },	// U+0444 (ф)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x36, 0x1c, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0445 (х)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0xfe, 0xc0, 0xc0, 0x00, 0x00 },	// U+0446 (ц)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+0447 (ч)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0448 (ш)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0xfe, 0xc0, 0xc0, 0x00, 0x00 },	// U+0449 (щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+044A (ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x67, 0x6b, 0x6b, 0x6b, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+044B (ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+044C (ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x60, 0x7c, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+044D (э)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x6b, 0x6b, 0x6f, 0x6b, 0x6b, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+044E (ю)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x63, 0x63, 0x7e, 0x6c, 0x66, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+044F (я)
	{ 0x00, 0x00, 0x0c, 0x18, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0450 (ѐ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0451 (ё)
	{ 0x00, 0x00, 0x06, 0x1f, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x38, 0x00 },	// U+0452 (ђ)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0453 (ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x1f, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0454 (є)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0455 (ѕ)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0456 (і)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0457 (ї)
	{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x00 },	// U+0458 (ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0b, 0x3b, 0x6b, 0x6b, 0x6b, 0x39, 0x00, 0x00, 0x00, 0x00 },	// U+0459 (љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x3b, 0x6f, 0x6b, 0x6b, 0x3b, 0x00, 0x00, 0x00, 0x00 },	// U+045A (њ)
	{ 0x00, 0x00, 0x06, 0x1f, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+045B (ћ)
	{ 0x00, 0x00, 0x18, 0x0c, 0x00, 0x63, 0x33, 0x1b, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+045C (ќ)
	{ 0x00, 0x00, 0x0c, 0x18, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+045D (ѝ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+045E (ў)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x1c, 0x1c, 0x00, 0x00 },	// U+045F (џ)
}; // 96

static const unsigned char terminusb_block36[][16] = {
	{ 0x00, 0x00, 0x06, 0x1f, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0462 (Ѣ)
	{ 0x00, 0x00, 0x06, 0x06, 0x1f, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0463 (ѣ)
}; // 2

static const unsigned char terminusb_block37[][16] = {
	{ 0x00, 0x00, 0x7f, 0x63, 0x36, 0x36, 0x1c, 0x3e, 0x6b, 0x6b, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+046A (Ѫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x36, 0x14, 0x1c, 0x3e, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+046B (ѫ)
}; // 2

static const unsigned char terminusb_block38[][16] = {
	{ 0x60, 0x60, 0x7f, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0490 (Ґ)
	{ 0x00, 0x00, 0x00, 0x60, 0x60, 0x7f, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0491 (ґ)
	{ 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3f, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+0492 (Ғ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x3f, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+0493 (ғ)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x60, 0x30, 0x00, 0x00 },	// U+0494 (Ҕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x03, 0x03, 0x1f, 0x33, 0x33, 0x33, 0x30, 0x18, 0x00, 0x00 },	// U+0495 (ҕ)
	{ 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x3e, 0x1c, 0x3e, 0x6b, 0x6b, 0x6b, 0xeb, 0xc0, 0xc0, 0x00, 0x00 },	// U+0496 (Җ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x6b, 0x3e, 0x1c, 0x3e, 0x6b, 0xeb, 0xc0, 0xc0, 0x00, 0x00 },	// U+0497 (җ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x60, 0x3c, 0x60, 0x60, 0x63, 0x63, 0x3e, 0x0c, 0x0c, 0x0c, 0x00 },	// U+0498 (Ҙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x60, 0x3c, 0x60, 0x63, 0x3e, 0x0c, 0x0c, 0x0c, 0x00 },	// U+0499 (ҙ)
	{ 0x00, 0x00, 0x63, 0x63, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x63, 0xe3, 0xc0, 0xc0, 0x00, 0x00 },	// U+049A (Қ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x33, 0x1b, 0x0f, 0x1b, 0x33, 0xe3, 0xc0, 0xc0, 0x00, 0x00 },	// U+049B (қ)
	{ 0x00, 0x00, 0x63, 0x63, 0x6b, 0x3b, 0x1f, 0x1f, 0x3b, 0x6b, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+049C (Ҝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x6b, 0x3b, 0x1f, 0x3b, 0x6b, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+049D (ҝ)
}; // 14

static const unsigned char terminusb_block39[][16] = {
	{ 0x00, 0x00, 0xc7, 0xc7, 0x66, 0x36, 0x1e, 0x1e, 0x36, 0x66, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00 },	// U+04A0 (Ҡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc7, 0x66, 0x36, 0x1e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00, 0x00 },	// U+04A1 (ҡ)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0xe3, 0xc0, 0xc0, 0x00, 0x00 },	// U+04A2 (Ң)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0xe3, 0xc0, 0xc0, 0x00, 0x00 },	// U+04A3 (ң)
	{ 0x00, 0x00, 0xf3, 0x33, 0x33, 0x33, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+04A4 (Ҥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xf3, 0x33, 0x33, 0x3f, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+04A5 (ҥ)
}; // 6

static const unsigned char terminusb_block40[][16] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x03, 0x03, 0x03, 0x03, 0x63, 0x63, 0x3e, 0x0c, 0x0c, 0x0c, 0x00 },	// U+04AA (Ҫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x0c, 0x0c, 0x0c, 0x00 },	// U+04AB (ҫ)
}; // 2

static const unsigned char terminusb_block41[][16] = {
	{ 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+04AE (Ү)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00 },	// U+04AF (ү)
	{ 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+04B0 (Ұ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x00 },	// U+04B1 (ұ)
	{ 0x00, 0x00, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0xe3, 0xc0, 0xc0, 0x00, 0x00 },	// U+04B2 (Ҳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x36, 0x1c, 0x36, 0x63, 0xe3, 0xc0, 0xc0, 0x00, 0x00 },	// U+04B3 (ҳ)
}; // 6

static const unsigned char terminusb_block42[][16] = {
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0xe0, 0xc0, 0xc0, 0x00, 0x00 },	// U+04B6 (Ҷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0xe0, 0xc0, 0xc0, 0x00, 0x00 },	// U+04B7 (ҷ)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x7e, 0x68, 0x68, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+04B8 (Ҹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x6b, 0x6b, 0x7e, 0x68, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+04B9 (ҹ)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+04BA (Һ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+04BB (һ)
}; // 6

static const unsigned char terminusb_block43[][16] = {
	{ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+04C0 (Ӏ)
	{ 0x36, 0x1c, 0x00, 0x6b, 0x6b, 0x6b, 0x3e, 0x1c, 0x3e, 0x6b, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+04C1 (Ӂ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x6b, 0x6b, 0x3e, 0x1c, 0x3e, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+04C2 (ӂ)
}; // 3

static const unsigned char terminusb_block44[][16] = {
	{ 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+04CF (ӏ)
	{ 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+04D0 (Ӑ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+04D1 (ӑ)
	{ 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+04D2 (Ӓ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x73, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+04D3 (ӓ)
	{ 0x00, 0x00, 0x7e, 0x1b, 0x1b, 0x1b, 0x7f, 0x1b, 0x1b, 0x1b, 0x1b, 0x7b, 0x00, 0x00, 0x00, 0x00 },	// U+04D4 (Ӕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x68, 0x68, 0x7e, 0x0b, 0x0b, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+04D5 (ӕ)
	{ 0x36, 0x1c, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+04D6 (Ӗ)
	{ 0x00, 0x00, 0x36, 0x1c, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04D7 (ӗ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x60, 0x60, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04D8 (Ә)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0x60, 0x7f, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04D9 (ә)
	{ 0x36, 0x36, 0x00, 0x3e, 0x63, 0x60, 0x60, 0x7f, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04DA (Ӛ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3e, 0x60, 0x60, 0x7f, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04DB (ӛ)
	{ 0x36, 0x36, 0x00, 0x6b, 0x6b, 0x6b, 0x3e, 0x1c, 0x3e, 0x6b, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+04DC (Ӝ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x6b, 0x6b, 0x3e, 0x1c, 0x3e, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+04DD (ӝ)
	{ 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x60, 0x3c, 0x60, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04DE (Ӟ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3e, 0x63, 0x60, 0x3c, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04DF (ӟ)
}; // 17

static const unsigned char terminusb_block45[][16] = {
	{ 0x3e, 0x00, 0x63, 0x63, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+04E2 (Ӣ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+04E3 (ӣ)
	{ 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+04E4 (Ӥ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+04E5 (ӥ)
	{ 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04E6 (Ӧ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04E7 (ӧ)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04E8 (Ө)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04E9 (ө)
	{ 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04EA (Ӫ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04EB (ӫ)
	{ 0x36, 0x36, 0x00, 0x3e, 0x63, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04EC (Ӭ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3e, 0x63, 0x60, 0x7c, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04ED (ӭ)
	{ 0x3e, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04EE (Ӯ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+04EF (ӯ)
	{ 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04F0 (Ӱ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+04F1 (ӱ)
	{ 0x6c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+04F2 (Ӳ)
	{ 0x00, 0x00, 0x6c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+04F3 (ӳ)
	{ 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+04F4 (Ӵ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+04F5 (ӵ)
}; // 20

static const unsigned char terminusb_block46[][16] = {
	{ 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x67, 0x6b, 0x6b, 0x6b, 0x6b, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+04F8 (Ӹ)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x63, 0x63, 0x67, 0x6b, 0x6b, 0x6b, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+04F9 (ӹ)
}; // 2

static const unsigned char terminusb_block47[][16] = {
	{ 0x00, 0x00, 0x63, 0x63, 0x66, 0x66, 0x3c, 0x1e, 0x33, 0x33, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+05D0 (א)
	{ 0x00, 0x00, 0x3f, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xff, 0x00, 0x00, 0x00, 0x00 },	// U+05D1 (ב)
	{ 0x00, 0x00, 0x1e, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x6c, 0xc6, 0xc3, 0x00, 0x00, 0x00, 0x00 },	// U+05D2 (ג)
	{ 0x00, 0x00, 0xff, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+05D3 (ד)
	{ 0x00, 0x00, 0x3f, 0x60, 0x60, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+05D4 (ה)
	{ 0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+05D5 (ו)
	{ 0x00, 0x00, 0x7e, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+05D6 (ז)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+05D7 (ח)
	{ 0x00, 0x00, 0x33, 0x73, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+05D8 (ט)
	{ 0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05D9 (י)
	{ 0x00, 0x00, 0x3f, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00 },	// U+05DA (ך)
	{ 0x00, 0x00, 0x3f, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+05DB (כ)
	{ 0x03, 0x03, 0x7f, 0x60, 0x60, 0x60, 0x60, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+05DC (ל)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+05DD (ם)
	{ 0x00, 0x00, 0x3b, 0x6e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x76, 0x00, 0x00, 0x00, 0x00 },	// U+05DE (מ)
	{ 0x00, 0x00, 0x0f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+05DF (ן)
	{ 0x00, 0x00, 0x1e, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+05E0 (נ)
	{ 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+05E1 (ס)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x66, 0x66, 0x6c, 0x6c, 0x38, 0x1c, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+05E2 (ע)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x66, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00 },	// U+05E3 (ף)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x66, 0x60, 0x60, 0x60, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+05E4 (פ)
	{ 0x00, 0x00, 0xc6, 0xc6, 0xcc, 0x6c, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00 },	// U+05E5 (ץ)
	{ 0x00, 0x00, 0x63, 0x63, 0x66, 0x36, 0x1c, 0x0c, 0x18, 0x18, 0x30, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+05E6 (צ)
	{ 0x00, 0x00, 0x7f, 0x60, 0x60, 0x63, 0x63, 0x33, 0x1b, 0x1b, 0x1b, 0x1b, 0x03, 0x03, 0x03, 0x00 },	// U+05E7 (ק)
	{ 0x00, 0x00, 0x3f, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+05E8 (ר)
	{ 0x00, 0x00, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x67, 0x63, 0x63, 0x33, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+05E9 (ש)
	{ 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+05EA (ת)
}; // 27

static const unsigned char terminusb_block48[][16] = {
	{ 0x00, 0x00, 0x1f, 0x33, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1f, 0x00, 0x0c, 0x0c, 0x00 },	// U+1E0C (Ḍ)
	{ 0x00, 0x00, 0x60, 0x60, 0x60, 0x7e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x18, 0x18, 0x00 },	// U+1E0D (ḍ)
}; // 2

static const unsigned char terminusb_block49[][16] = {
	{ 0x00, 0x00, 0x63, 0x63, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x63, 0x63, 0x00, 0x3e, 0x00, 0x00 },	// U+1E34 (Ḵ)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x63, 0x33, 0x1b, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x3e, 0x00, 0x00 },	// U+1E35 (ḵ)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x18, 0x18, 0x00 },	// U+1E36 (Ḷ)
	{ 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x18, 0x18, 0x00 },	// U+1E37 (ḷ)
}; // 4

static const unsigned char terminusb_block50[][16] = {
	{ 0x18, 0x18, 0x41, 0x63, 0x77, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+1E40 (Ṁ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x3f, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00 },	// U+1E41 (ṁ)
	{ 0x00, 0x00, 0x41, 0x63, 0x77, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x18, 0x18, 0x00 },	// U+1E42 (Ṃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x00, 0x18, 0x18, 0x00 },	// U+1E43 (ṃ)
	{ 0x18, 0x18, 0x63, 0x63, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+1E44 (Ṅ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+1E45 (ṅ)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x18, 0x18, 0x00 },	// U+1E46 (Ṇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x18, 0x18, 0x00 },	// U+1E47 (ṇ)
}; // 8

static const unsigned char terminusb_block51[][16] = {
	{ 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 },	// U+1E6C (Ṭ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x78, 0x00, 0x30, 0x30, 0x00 },	// U+1E6D (ṭ)
}; // 2

static const unsigned char terminusb_block52[][16] = {
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x18, 0x18, 0x00 },	// U+1EB8 (Ẹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x18, 0x18, 0x00 },	// U+1EB9 (ẹ)
}; // 2

static const unsigned char terminusb_block53[][16] = {
	{ 0x6e, 0x3b, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x1f, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+1EBC (Ẽ)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x3e, 0x63, 0x63, 0x7f, 0x03, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+1EBD (ẽ)
}; // 2

static const unsigned char terminusb_block54[][16] = {
	{ 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00 },	// U+1ECA (Ị)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00 },	// U+1ECB (ị)
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x18, 0x18, 0x00 },	// U+1ECC (Ọ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x18, 0x18, 0x00 },	// U+1ECD (ọ)
}; // 4

static const unsigned char terminusb_block55[][16] = {
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x18, 0x18, 0x00 },	// U+1EE4 (Ụ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x18, 0x18, 0x00 },	// U+1EE5 (ụ)
}; // 2

static const unsigned char terminusb_block56[][16] = {
	{ 0x6e, 0x3b, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+1EF8 (Ỹ)
	{ 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x3e, 0x00 },	// U+1EF9 (ỹ)
}; // 2

static const unsigned char terminusb_block57[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2000 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2001 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2002 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2003 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2004 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2005 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2006 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2007 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2008 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2009 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+200A ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+200B (​)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+200C (‌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+200D (‍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+200E (‎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+200F (‏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2010 (‐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2011 (‑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2012 (‒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2013 (–)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2014 (—)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2015 (―)
	{ 0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2016 (‖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x7f },	// U+2017 (‗)
	{ 0x00, 0x18, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2018 (‘)
	{ 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2019 (’)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00 },	// U+201A (‚)
	{ 0x00, 0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201B (‛)
	{ 0x00, 0x66, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201C (“)
	{ 0x00, 0xcc, 0xcc, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201D (”)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x33, 0x00, 0x00, 0x00 },	// U+201E („)
	{ 0x00, 0x33, 0x33, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201F (‟)
	{ 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2020 (†)
	{ 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2021 (‡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2022 (•)
}; // 35

static const unsigned char terminusb_block58[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00 },	// U+2026 (…)
}; // 1

static const unsigned char terminusb_block59[][16] = {
	{ 0x00, 0x00, 0x37, 0x35, 0x1f, 0x18, 0x0c, 0x0c, 0x06, 0xfe, 0xab, 0xfb, 0x00, 0x00, 0x00, 0x00 },	// U+2030 (‰)
}; // 1

static const unsigned char terminusb_block60[][16] = {
	{ 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2032 (′)
	{ 0x00, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2033 (″)
}; // 2

static const unsigned char terminusb_block61[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2039 (‹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+203A (›)
}; // 2

static const unsigned char terminusb_block62[][16] = {
	{ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+203C (‼)
}; // 1

static const unsigned char terminusb_block63[][16] = {
	{ 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+203E (‾)
}; // 1

static const unsigned char terminusb_block64[][16] = {
	{ 0x00, 0x1c, 0x36, 0x36, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2070 (⁰)
	{ 0x18, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2071 (ⁱ)
}; // 2

static const unsigned char terminusb_block65[][16] = {
	{ 0x00, 0x30, 0x38, 0x2c, 0x7e, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2074 (⁴)
	{ 0x00, 0x1e, 0x06, 0x1e, 0x30, 0x30, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2075 (⁵)
	{ 0x00, 0x1c, 0x06, 0x1e, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2076 (⁶)
	{ 0x00, 0x3e, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2077 (⁷)
	{ 0x00, 0x1c, 0x36, 0x1c, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2078 (⁸)
	{ 0x00, 0x1c, 0x36, 0x36, 0x3c, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2079 (⁹)
	{ 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207A (⁺)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207B (⁻)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207C (⁼)
	{ 0x00, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207D (⁽)
	{ 0x00, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207E (⁾)
	{ 0x00, 0x00, 0x1e, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207F (ⁿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x36, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+2080 (₀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1c, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00 },	// U+2081 (₁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x30, 0x18, 0x0c, 0x3e, 0x00, 0x00, 0x00 },	// U+2082 (₂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x30, 0x1c, 0x30, 0x30, 0x1e, 0x00, 0x00, 0x00 },	// U+2083 (₃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x38, 0x2c, 0x7e, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2084 (₄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x06, 0x1e, 0x30, 0x30, 0x1e, 0x00, 0x00, 0x00 },	// U+2085 (₅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x06, 0x1e, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+2086 (₆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+2087 (₇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x1c, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+2088 (₈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x36, 0x3c, 0x30, 0x1c, 0x00, 0x00, 0x00 },	// U+2089 (₉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+208A (₊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+208B (₋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+208C (₌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00 },	// U+208D (₍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00 },	// U+208E (₎)
}; // 27

static const unsigned char terminusb_block66[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x36, 0x36, 0x36, 0x2c, 0x00, 0x00, 0x00 },	// U+2090 (ₐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x3e, 0x06, 0x3c, 0x00, 0x00, 0x00 },	// U+2091 (ₑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+2092 (ₒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0x00, 0x00, 0x00 },	// U+2093 (ₓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x30, 0x3e, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+2094 (ₔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x1e, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+2095 (ₕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x66, 0x36, 0x1e, 0x36, 0x66, 0x00, 0x00, 0x00 },	// U+2096 (ₖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00 },	// U+2097 (ₗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x6b, 0x6b, 0x6b, 0x6b, 0x00, 0x00, 0x00 },	// U+2098 (ₘ)
}; // 9

static const unsigned char terminusb_block67[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x36, 0x36, 0x36, 0x1e, 0x06, 0x06, 0x00 },	// U+209A (ₚ)
}; // 1

static const unsigned char terminusb_block68[][16] = {
	{ 0x00, 0x00, 0x1f, 0x33, 0x33, 0x33, 0x5f, 0x63, 0xf3, 0x63, 0x63, 0xc3, 0x00, 0x00, 0x00, 0x00 },	// U+20A7 (₧)
}; // 1

static const unsigned char terminusb_block69[][16] = {
	{ 0x00, 0x00, 0x4f, 0x51, 0x51, 0x55, 0x55, 0x55, 0x55, 0x45, 0x45, 0x3d, 0x00, 0x00, 0x00, 0x00 },	// U+20AA (₪)
}; // 1

static const unsigned char terminusb_block70[][16] = {
	{ 0x00, 0x00, 0x00, 0x78, 0xcc, 0x06, 0x3f, 0x06, 0x3f, 0x06, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00 },	// U+20AC (€)
}; // 1

static const unsigned char terminusb_block71[][16] = {
	{ 0x00, 0x00, 0xff, 0x18, 0x18, 0x78, 0x1e, 0x78, 0x1e, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+20AE (₮)
}; // 1

static const unsigned char terminusb_block72[][16] = {
	{ 0x00, 0x00, 0x3c, 0x4a, 0x4a, 0x0a, 0x0a, 0x0a, 0x0a, 0x4a, 0x4a, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2102 (ℂ)
}; // 1

static const unsigned char terminusb_block73[][16] = {
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+210E (ℎ)
	{ 0x00, 0x00, 0x06, 0x1f, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+210F (ℏ)
}; // 2

static const unsigned char terminusb_block74[][16] = {
	{ 0x00, 0x00, 0x42, 0x42, 0x46, 0x4a, 0x56, 0x6a, 0x52, 0x62, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00 },	// U+2115 (ℕ)
	{ 0x00, 0x00, 0x69, 0x69, 0x69, 0x0b, 0x0f, 0x0f, 0x0d, 0x69, 0x09, 0x69, 0x00, 0x00, 0x00, 0x00 },	// U+2116 (№)
}; // 2

static const unsigned char terminusb_block75[][16] = {
	{ 0x00, 0x00, 0x3c, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x5a, 0x3c, 0x60, 0x00, 0x00, 0x00 },	// U+211A (ℚ)
}; // 1

static const unsigned char terminusb_block76[][16] = {
	{ 0x00, 0x00, 0x1f, 0x25, 0x25, 0x25, 0x25, 0x1d, 0x15, 0x2d, 0x55, 0x67, 0x00, 0x00, 0x00, 0x00 },	// U+211D (ℝ)
}; // 1

static const unsigned char terminusb_block77[][16] = {
	{ 0x00, 0x00, 0xdf, 0xaa, 0xaa, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2122 (™)
}; // 1

static const unsigned char terminusb_block78[][16] = {
	{ 0x00, 0x00, 0x7e, 0x40, 0x60, 0x50, 0x28, 0x14, 0x0a, 0x06, 0x02, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2124 (ℤ)
}; // 1

static const unsigned char terminusb_block79[][16] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x36, 0x77, 0x00, 0x00, 0x00, 0x00 },	// U+2126 (Ω)
}; // 1

static const unsigned char terminusb_block80[][16] = {
	{ 0x00, 0x00, 0x66, 0x66, 0xcc, 0xcc, 0x7c, 0x3e, 0x33, 0x33, 0x63, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+2135 (ℵ)
}; // 1

static const unsigned char terminusb_block81[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x7f, 0x7f, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2190 (←)
	{ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2191 (↑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x7f, 0x7f, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2192 (→)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2193 (↓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0xff, 0xff, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2194 (↔)
	{ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2195 (↕)
}; // 6

static const unsigned char terminusb_block82[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x7f, 0x7f, 0x46, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A4 (↤)
}; // 1

static const unsigned char terminusb_block83[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x31, 0x7f, 0x7f, 0x31, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A6 (↦)
}; // 1

static const unsigned char terminusb_block84[][16] = {
	{ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+21A8 (↨)
}; // 1

static const unsigned char terminusb_block85[][16] = {
	{ 0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x64, 0x66, 0x7f, 0x7f, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21B5 (↵)
}; // 1

static const unsigned char terminusb_block86[][16] = {
	{ 0x00, 0x00, 0x00, 0x1f, 0x1c, 0x16, 0xd3, 0xc3, 0xc3, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21BB (↻)
}; // 1

static const unsigned char terminusb_block87[][16] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x06, 0x7f, 0x7f, 0x00, 0x7f, 0x7f, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+21CB (⇋)
	{ 0x00, 0x00, 0x00, 0x10, 0x30, 0x7f, 0x7f, 0x00, 0x7f, 0x7f, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21CC (⇌)
}; // 2

static const unsigned char terminusb_block88[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0x7e, 0x07, 0x7e, 0x7c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D0 (⇐)
	{ 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x77, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+21D1 (⇑)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x3f, 0x70, 0x3f, 0x1f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D2 (⇒)
	{ 0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x77, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21D3 (⇓)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x7e, 0xff, 0xc3, 0xff, 0x7e, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D4 (⇔)
	{ 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x77, 0x36, 0x36, 0x77, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21D5 (⇕)
}; // 6

static const unsigned char terminusb_block89[][16] = {
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x7f, 0x36, 0x36, 0x36, 0x1c, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2200 (∀)
}; // 1

static const unsigned char terminusb_block90[][16] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x60, 0x60, 0x60, 0x7f, 0x60, 0x60, 0x60, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+2203 (∃)
	{ 0x00, 0x00, 0x30, 0x7f, 0x78, 0x68, 0x6c, 0x7f, 0x6c, 0x66, 0x66, 0x7f, 0x03, 0x00, 0x00, 0x00 },	// U+2204 (∄)
	{ 0x00, 0x00, 0x60, 0x30, 0x3e, 0x73, 0x7b, 0x6f, 0x67, 0x3e, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2205 (∅)
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x1c, 0x36, 0x36, 0x36, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+2206 (∆)
	{ 0x00, 0x00, 0x7f, 0x63, 0x63, 0x36, 0x36, 0x36, 0x1c, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2207 (∇)
	{ 0x00, 0x00, 0x00, 0x7c, 0x06, 0x03, 0x03, 0x7f, 0x03, 0x03, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+2208 (∈)
	{ 0x00, 0x00, 0x60, 0x7c, 0x36, 0x33, 0x1b, 0x7f, 0x1b, 0x0f, 0x0e, 0x7e, 0x06, 0x00, 0x00, 0x00 },	// U+2209 (∉)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x06, 0x03, 0x7f, 0x03, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+220A (∊)
	{ 0x00, 0x00, 0x00, 0x1f, 0x30, 0x60, 0x60, 0x7f, 0x60, 0x60, 0x30, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+220B (∋)
	{ 0x00, 0x00, 0x03, 0x1f, 0x36, 0x66, 0x6c, 0x7f, 0x6c, 0x78, 0x38, 0x3f, 0x30, 0x00, 0x00, 0x00 },	// U+220C (∌)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x30, 0x60, 0x7f, 0x60, 0x30, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+220D (∍)
}; // 11

static const unsigned char terminusb_block91[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2212 (−)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2213 (∓)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2214 (∔)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+2215 (∕)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+2216 (∖)
}; // 5

static const unsigned char terminusb_block92[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2219 (∙)
	{ 0x00, 0x70, 0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x33, 0x36, 0x3c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+221A (√)
}; // 2

static const unsigned char terminusb_block93[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x6b, 0x6b, 0x6b, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+221E (∞)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+221F (∟)
}; // 2

static const unsigned char terminusb_block94[][16] = {
	{ 0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2225 (∥)
}; // 1

static const unsigned char terminusb_block95[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0xc3, 0xc3, 0x00, 0x00, 0x00, 0x00 },	// U+2227 (∧)
	{ 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2228 (∨)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+2229 (∩)
	{ 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+222A (∪)
}; // 4

static const unsigned char terminusb_block96[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x6e, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2248 (≈)
}; // 1

static const unsigned char terminusb_block97[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x7f, 0x18, 0x0c, 0x7f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2260 (≠)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2261 (≡)
}; // 2

static const unsigned char terminusb_block98[][16] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2264 (≤)
	{ 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+2265 (≥)
}; // 2

static const unsigned char terminusb_block99[][16] = {
	{ 0x00, 0x00, 0x00, 0x90, 0xd8, 0x6c, 0x36, 0x1b, 0x36, 0x6c, 0xd8, 0x90, 0x00, 0x00, 0x00, 0x00 },	// U+226A (≪)
	{ 0x00, 0x00, 0x00, 0x09, 0x1b, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x1b, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+226B (≫)
}; // 2

static const unsigned char terminusb_block100[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x03, 0x03, 0x03, 0x03, 0x03, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2282 (⊂)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x60, 0x60, 0x60, 0x60, 0x60, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2283 (⊃)
}; // 2

static const unsigned char terminusb_block101[][16] = {
	{ 0x00, 0x00, 0x00, 0x7e, 0x03, 0x03, 0x03, 0x03, 0x03, 0x7e, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+2286 (⊆)
	{ 0x00, 0x00, 0x00, 0x3f, 0x60, 0x60, 0x60, 0x60, 0x60, 0x3f, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+2287 (⊇)
}; // 2

static const unsigned char terminusb_block102[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00 },	// U+22A5 (⊥)
}; // 1

static const unsigned char terminusb_block103[][16] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+22C2 (⋂)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+22C3 (⋃)
}; // 2

static const unsigned char terminusb_block104[][16] = {
	{ 0x00, 0x00, 0x60, 0x30, 0x3e, 0x73, 0x7b, 0x6f, 0x67, 0x3e, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2300 (⌀)
}; // 1

static const unsigned char terminusb_block105[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+2302 (⌂)
}; // 1

static const unsigned char terminusb_block106[][16] = {
	{ 0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2308 (⌈)
	{ 0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2309 (⌉)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+230A (⌊)
	{ 0x00, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+230B (⌋)
}; // 4

static const unsigned char terminusb_block107[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2310 (⌐)
}; // 1

static const unsigned char terminusb_block108[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2319 (⌙)
}; // 1

static const unsigned char terminusb_block109[][16] = {
	{ 0x00, 0x00, 0x70, 0xd8, 0xd8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2320 (⌠)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2321 (⌡)
}; // 2

static const unsigned char terminusb_block110[][16] = {
	{ 0x60, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06 },	// U+239B (⎛)
	{ 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06 },	// U+239C (⎜)
	{ 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x60 },	// U+239D (⎝)
	{ 0x06, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x30, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },	// U+239E (⎞)
	{ 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },	// U+239F (⎟)
	{ 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x30, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x06 },	// U+23A0 (⎠)
	{ 0x7e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06 },	// U+23A1 (⎡)
	{ 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06 },	// U+23A2 (⎢)
	{ 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7e },	// U+23A3 (⎣)
	{ 0x7e, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },	// U+23A4 (⎤)
	{ 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60 },	// U+23A5 (⎥)
	{ 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7e },	// U+23A6 (⎦)
	{ 0xf0, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+23A7 (⎧)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x07, 0x07, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+23A8 (⎨)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0xf0 },	// U+23A9 (⎩)
}; // 15

static const unsigned char terminusb_block111[][16] = {
	{ 0x0f, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },	// U+23AB (⎫)
	{ 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xe0, 0xe0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30 },	// U+23AC (⎬)
	{ 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0f },	// U+23AD (⎭)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+23AE (⎮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23AF (⎯)
}; // 5

static const unsigned char terminusb_block112[][16] = {
	{ 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BA (⎺)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BB (⎻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00 },	// U+23BC (⎼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff },	// U+23BD (⎽)
}; // 4

static const unsigned char terminusb_block113[][16] = {
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+23D0 (⏐)
}; // 1

static const unsigned char terminusb_block114[][16] = {
	{ 0x00, 0x33, 0x33, 0x3f, 0x33, 0x33, 0x33, 0x00, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00 },	// U+2409 (␉)
	{ 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1f, 0x00, 0xfc, 0x0c, 0x3c, 0x0c, 0x0c, 0x0c, 0x00, 0x00 },	// U+240A (␊)
	{ 0x00, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x0c, 0x00, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00 },	// U+240B (␋)
	{ 0x00, 0x3f, 0x03, 0x0f, 0x03, 0x03, 0x03, 0x00, 0xfc, 0x0c, 0x3c, 0x0c, 0x0c, 0x0c, 0x00, 0x00 },	// U+240C (␌)
	{ 0x00, 0x1e, 0x33, 0x03, 0x03, 0x33, 0x1e, 0x00, 0x7c, 0xcc, 0xcc, 0x7c, 0x6c, 0xcc, 0x00, 0x00 },	// U+240D (␍)
}; // 5

static const unsigned char terminusb_block115[][16] = {
	{ 0x00, 0x33, 0x37, 0x3f, 0x3b, 0x33, 0x33, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xfc, 0x00, 0x00 },	// U+2424 (␤)
}; // 1

static const unsigned char terminusb_block116[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2500 (─)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2501 (━)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2502 (│)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2503 (┃)
}; // 4

static const unsigned char terminusb_block117[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2508 (┈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2509 (┉)
	{ 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00 },	// U+250A (┊)
	{ 0x1c, 0x1c, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x00 },	// U+250B (┋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+250C (┌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+250D (┍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+250E (┎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+250F (┏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2510 (┐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2511 (┑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2512 (┒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2513 (┓)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2514 (└)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2515 (┕)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2516 (┖)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2517 (┗)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2518 (┘)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2519 (┙)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251A (┚)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251B (┛)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+251C (├)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+251D (┝)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xfc, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+251E (┞)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+251F (┟)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2520 (┠)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xfc, 0xfc, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2521 (┡)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xfc, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2522 (┢)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2523 (┣)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2524 (┤)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2525 (┥)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2526 (┦)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2527 (┧)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2528 (┨)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2529 (┩)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+252A (┪)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x1f, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+252B (┫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+252C (┬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+252D (┭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+252E (┮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+252F (┯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2530 (┰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2531 (┱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2532 (┲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2533 (┳)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2534 (┴)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2535 (┵)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2536 (┶)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2537 (┷)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2538 (┸)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2539 (┹)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253A (┺)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253B (┻)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+253C (┼)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+253D (┽)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+253E (┾)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+253F (┿)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2540 (╀)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2541 (╁)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2542 (╂)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2543 (╃)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2544 (╄)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2545 (╅)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2546 (╆)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2547 (╇)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2548 (╈)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2549 (╉)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+254A (╊)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+254B (╋)
}; // 68

static const unsigned char terminusb_block118[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2550 (═)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+2551 (║)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2552 (╒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+2553 (╓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x06, 0xf6, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+2554 (╔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2555 (╕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+2556 (╖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x30, 0x37, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+2557 (╗)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2558 (╘)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2559 (╙)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0xf6, 0x06, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255A (╚)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255B (╛)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255C (╜)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x37, 0x30, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255D (╝)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+255E (╞)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+255F (╟)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0xf6, 0x06, 0xf6, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+2560 (╠)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2561 (╡)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+2562 (╢)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x37, 0x30, 0x37, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+2563 (╣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2564 (╤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+2565 (╥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xf7, 0xf7, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+2566 (╦)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2567 (╧)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2568 (╨)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0xf7, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2569 (╩)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+256A (╪)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff, 0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+256B (╫)
	{ 0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0xf7, 0x00, 0xf7, 0xf7, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },	// U+256C (╬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xf0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+256D (╭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0f, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+256E (╮)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x0f, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+256F (╯)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2570 (╰)
	{ 0x80, 0x80, 0xc0, 0x40, 0x60, 0x20, 0x30, 0x10, 0x18, 0x08, 0x0c, 0x04, 0x06, 0x02, 0x03, 0x01 },	// U+2571 (╱)
	{ 0x01, 0x03, 0x02, 0x06, 0x04, 0x0c, 0x08, 0x18, 0x10, 0x30, 0x20, 0x60, 0x40, 0xc0, 0x80, 0x80 },	// U+2572 (╲)
	{ 0x81, 0x83, 0xc2, 0x46, 0x64, 0x2c, 0x38, 0x18, 0x18, 0x38, 0x2c, 0x64, 0x46, 0xc2, 0x83, 0x81 },	// U+2573 (╳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2574 (╴)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2575 (╵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2576 (╶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2577 (╷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2578 (╸)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2579 (╹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257A (╺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+257B (╻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257C (╼)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+257D (╽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257E (╾)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+257F (╿)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2580 (▀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff },	// U+2581 (▁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff },	// U+2582 (▂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2583 (▃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2584 (▄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2585 (▅)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2586 (▆)
	{ 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2587 (▇)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2588 (█)
	{ 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f },	// U+2589 (▉)
	{ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+258A (▊)
	{ 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f },	// U+258B (▋)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+258C (▌)
	{ 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+258D (▍)
	{ 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 },	// U+258E (▎)
	{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+258F (▏)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+2590 (▐)
	{ 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44 },	// U+2591 (░)
	{ 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa },	// U+2592 (▒)
	{ 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd },	// U+2593 (▓)
}; // 68

static const unsigned char terminusb_block119[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+2596 (▖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+2597 (▗)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2598 (▘)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2599 (▙)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+259A (▚)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+259B (▛)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+259C (▜)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+259D (▝)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+259E (▞)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+259F (▟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25A0 (■)
}; // 11

static const unsigned char terminusb_block120[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+25AC (▬)
}; // 1

static const unsigned char terminusb_block121[][16] = {
	{ 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+25AE (▮)
}; // 1

static const unsigned char terminusb_block122[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x7e, 0x7e, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00 },	// U+25B2 (▲)
}; // 1

static const unsigned char terminusb_block123[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x3f, 0xff, 0xff, 0x3f, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+25B6 (▶)
}; // 1

static const unsigned char terminusb_block124[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x3f, 0xff, 0xff, 0x3f, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+25BA (►)
}; // 1

static const unsigned char terminusb_block125[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x7e, 0x7e, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+25BC (▼)
}; // 1

static const unsigned char terminusb_block126[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf0, 0xfc, 0xff, 0xff, 0xfc, 0xf0, 0xc0, 0x00, 0x00, 0x00, 0x00 },	// U+25C0 (◀)
}; // 1

static const unsigned char terminusb_block127[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf0, 0xfc, 0xff, 0xff, 0xfc, 0xf0, 0xc0, 0x00, 0x00, 0x00, 0x00 },	// U+25C4 (◄)
}; // 1

static const unsigned char terminusb_block128[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25C6 (◆)
}; // 1

static const unsigned char terminusb_block129[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x66, 0xc3, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25CA (◊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25CB (○)
}; // 2

static const unsigned char terminusb_block130[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25CF (●)
}; // 1

static const unsigned char terminusb_block131[][16] = {
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25D8 (◘)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25D9 (◙)
}; // 2

static const unsigned char terminusb_block132[][16] = {
	{ 0x00, 0x00, 0x3e, 0x41, 0x55, 0x41, 0x41, 0x5d, 0x49, 0x41, 0x41, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+263A (☺)
	{ 0x00, 0x00, 0x3e, 0x7f, 0x6b, 0x7f, 0x7f, 0x63, 0x77, 0x7f, 0x7f, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+263B (☻)
	{ 0x00, 0x00, 0x00, 0x18, 0xdb, 0x7e, 0x3c, 0xe7, 0x3c, 0x7e, 0xdb, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+263C (☼)
}; // 3

static const unsigned char terminusb_block133[][16] = {
	{ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+2640 (♀)
}; // 1

static const unsigned char terminusb_block134[][16] = {
	{ 0x00, 0x00, 0x7c, 0x70, 0x58, 0x4c, 0x1e, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2642 (♂)
}; // 1

static const unsigned char terminusb_block135[][16] = {
	{ 0x00, 0x00, 0x18, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2660 (♠)
}; // 1

static const unsigned char terminusb_block136[][16] = {
	{ 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x5a, 0xff, 0xff, 0x5a, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2663 (♣)
}; // 1

static const unsigned char terminusb_block137[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x7f, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2665 (♥)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2666 (♦)
}; // 2

static const unsigned char terminusb_block138[][16] = {
	{ 0x00, 0x00, 0x7e, 0x66, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+266A (♪)
	{ 0x00, 0x00, 0x7e, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x76, 0x37, 0x03, 0x00, 0x00, 0x00 },	// U+266B (♫)
}; // 2

static const unsigned char terminusb_block139[][16] = {
	{ 0x00, 0x00, 0xc0, 0xc0, 0x60, 0x60, 0x33, 0x33, 0x1e, 0x1e, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2713 (✓)
	{ 0x00, 0x00, 0xe0, 0xe0, 0x70, 0x70, 0x3b, 0x3f, 0x1e, 0x1e, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2714 (✔)
}; // 2

static const unsigned char terminusb_block140[][16] = {
	{ 0x00, 0x00, 0x30, 0x33, 0x1e, 0x1c, 0x1c, 0x3c, 0x66, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2717 (✗)
	{ 0x00, 0x00, 0x70, 0x77, 0x3e, 0x3c, 0x3c, 0x7c, 0xee, 0xce, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+2718 (✘)
}; // 2

static const unsigned char terminusb_block141[][16] = {
	{ 0x00, 0x00, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+27E8 (⟨)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+27E9 (⟩)
	{ 0x00, 0x00, 0x6c, 0x6c, 0x36, 0x36, 0x1b, 0x1b, 0x36, 0x36, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00 },	// U+27EA (⟪)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x36, 0x36, 0x6c, 0x6c, 0x36, 0x36, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+27EB (⟫)
}; // 4

static const unsigned char terminusb_block142[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2800 (⠀)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2801 (⠁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2802 (⠂)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2803 (⠃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2804 (⠄)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2805 (⠅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2806 (⠆)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2807 (⠇)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2808 (⠈)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2809 (⠉)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280A (⠊)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280B (⠋)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280C (⠌)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280D (⠍)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280E (⠎)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280F (⠏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2810 (⠐)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2811 (⠑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2812 (⠒)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2813 (⠓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2814 (⠔)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2815 (⠕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2816 (⠖)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2817 (⠗)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2818 (⠘)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2819 (⠙)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281A (⠚)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281B (⠛)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281C (⠜)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281D (⠝)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281E (⠞)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281F (⠟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2820 (⠠)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2821 (⠡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2822 (⠢)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2823 (⠣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2824 (⠤)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2825 (⠥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2826 (⠦)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2827 (⠧)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2828 (⠨)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2829 (⠩)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282A (⠪)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282B (⠫)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282C (⠬)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282D (⠭)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282E (⠮)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282F (⠯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2830 (⠰)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2831 (⠱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2832 (⠲)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2833 (⠳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2834 (⠴)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2835 (⠵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2836 (⠶)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2837 (⠷)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2838 (⠸)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2839 (⠹)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283A (⠺)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283B (⠻)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283C (⠼)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283D (⠽)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283E (⠾)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283F (⠿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2840 (⡀)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2841 (⡁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2842 (⡂)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2843 (⡃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2844 (⡄)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2845 (⡅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2846 (⡆)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2847 (⡇)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2848 (⡈)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2849 (⡉)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+284A (⡊)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+284B (⡋)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+284C (⡌)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+284D (⡍)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+284E (⡎)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+284F (⡏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2850 (⡐)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2851 (⡑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2852 (⡒)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2853 (⡓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2854 (⡔)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2855 (⡕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2856 (⡖)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2857 (⡗)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2858 (⡘)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2859 (⡙)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+285A (⡚)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+285B (⡛)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+285C (⡜)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+285D (⡝)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+285E (⡞)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+285F (⡟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2860 (⡠)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2861 (⡡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2862 (⡢)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2863 (⡣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2864 (⡤)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2865 (⡥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2866 (⡦)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2867 (⡧)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2868 (⡨)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2869 (⡩)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+286A (⡪)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+286B (⡫)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+286C (⡬)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+286D (⡭)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+286E (⡮)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+286F (⡯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2870 (⡰)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2871 (⡱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2872 (⡲)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2873 (⡳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2874 (⡴)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2875 (⡵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2876 (⡶)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2877 (⡷)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2878 (⡸)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2879 (⡹)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+287A (⡺)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+287B (⡻)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+287C (⡼)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+287D (⡽)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+287E (⡾)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+287F (⡿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2880 (⢀)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2881 (⢁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2882 (⢂)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2883 (⢃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2884 (⢄)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2885 (⢅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2886 (⢆)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2887 (⢇)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2888 (⢈)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2889 (⢉)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+288A (⢊)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+288B (⢋)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+288C (⢌)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+288D (⢍)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+288E (⢎)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+288F (⢏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2890 (⢐)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2891 (⢑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2892 (⢒)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2893 (⢓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2894 (⢔)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2895 (⢕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2896 (⢖)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2897 (⢗)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2898 (⢘)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+2899 (⢙)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+289A (⢚)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+289B (⢛)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+289C (⢜)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+289D (⢝)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+289E (⢞)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+289F (⢟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28A0 (⢠)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28A1 (⢡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28A2 (⢢)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28A3 (⢣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28A4 (⢤)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28A5 (⢥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28A6 (⢦)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28A7 (⢧)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28A8 (⢨)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28A9 (⢩)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28AA (⢪)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28AB (⢫)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28AC (⢬)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28AD (⢭)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28AE (⢮)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28AF (⢯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28B0 (⢰)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28B1 (⢱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28B2 (⢲)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28B3 (⢳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28B4 (⢴)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28B5 (⢵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28B6 (⢶)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28B7 (⢷)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28B8 (⢸)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28B9 (⢹)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28BA (⢺)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28BB (⢻)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28BC (⢼)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28BD (⢽)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28BE (⢾)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00 },	// U+28BF (⢿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28C0 (⣀)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28C1 (⣁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28C2 (⣂)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28C3 (⣃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28C4 (⣄)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28C5 (⣅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28C6 (⣆)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28C7 (⣇)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28C8 (⣈)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28C9 (⣉)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28CA (⣊)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28CB (⣋)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28CC (⣌)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28CD (⣍)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28CE (⣎)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28CF (⣏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28D0 (⣐)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28D1 (⣑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28D2 (⣒)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28D3 (⣓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28D4 (⣔)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28D5 (⣕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28D6 (⣖)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28D7 (⣗)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28D8 (⣘)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28D9 (⣙)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28DA (⣚)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28DB (⣛)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28DC (⣜)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28DD (⣝)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28DE (⣞)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28DF (⣟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28E0 (⣠)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28E1 (⣡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28E2 (⣢)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28E3 (⣣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28E4 (⣤)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28E5 (⣥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28E6 (⣦)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28E7 (⣧)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28E8 (⣨)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28E9 (⣩)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28EA (⣪)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28EB (⣫)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28EC (⣬)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28ED (⣭)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28EE (⣮)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28EF (⣯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28F0 (⣰)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28F1 (⣱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28F2 (⣲)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28F3 (⣳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28F4 (⣴)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28F5 (⣵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28F6 (⣶)
	{ 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28F7 (⣷)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28F8 (⣸)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28F9 (⣹)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28FA (⣺)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28FB (⣻)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28FC (⣼)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28FD (⣽)
	{ 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28FE (⣾)
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+28FF (⣿)
}; // 256

static const unsigned char terminusb_block143[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x00, 0x00, 0x00, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+2E2C (⸬)
}; // 1

static const unsigned char terminusb_block144[][16] = {
	{ 0x03, 0x03, 0x33, 0x7b, 0xff, 0x33, 0x33, 0x33, 0x19, 0x0c, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03 },	// U+E0A0 ()
	{ 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x3f, 0x00, 0xcc, 0xdc, 0xfc, 0xec, 0xcc, 0xcc, 0x00, 0x00 },	// U+E0A1 ()
	{ 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0xff, 0xff, 0xe7, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0x00, 0x00 },	// U+E0A2 ()
}; // 3

static const unsigned char terminusb_block145[][16] = {
	{ 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff, 0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01 },	// U+E0B0 ()
	{ 0x01, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x01 },	// U+E0B1 ()
	{ 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff, 0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80 },	// U+E0B2 ()
	{ 0x80, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80 },	// U+E0B3 ()
}; // 4

static const unsigned char terminusb_block146[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x00 },	// U+F6BE ()
}; // 1

static const unsigned char terminusb_block147[][16] = {
	{ 0x00, 0x00, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+FFFD (�)
}; // 1

