/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font scientifica-7x12i.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char scientificai_block1[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x7c, 0x28, 0x7c, 0x28, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x00, 0x10, 0x10, 0x38, 0x08, 0x38, 0x20, 0x38, 0x10, 0x10, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x08, 0x24, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x00, 0x38, 0x04, 0x24, 0x78, 0x24, 0x24, 0x5c, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x00, 0x30, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x30, 0x00 },	// U+0028 (()
	{ 0x00, 0x00, 0x0c, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x0c, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x7c, 0x10, 0x28, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x34, 0x2c, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x00, 0x10, 0x18, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x00, 0x3c, 0x20, 0x10, 0x28, 0x20, 0x24, 0x18, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x3c, 0x10, 0x10, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x1c, 0x20, 0x20, 0x24, 0x18, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x1c, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x00, 0x3c, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x38, 0x20, 0x24, 0x18, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x08, 0x10, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x10, 0x08, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x10, 0x08, 0x00, 0x08, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x00, 0x38, 0x24, 0x34, 0x34, 0x04, 0x24, 0x1c, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x00, 0x38, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x00, 0x1c, 0x26, 0x24, 0x1c, 0x24, 0x24, 0x1c, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x00, 0x38, 0x26, 0x04, 0x04, 0x04, 0x44, 0x38, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x00, 0x1c, 0x26, 0x24, 0x24, 0x24, 0x24, 0x1c, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x00, 0x38, 0x24, 0x04, 0x1c, 0x04, 0x04, 0x38, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x40, 0x7c, 0x14, 0x10, 0x38, 0x10, 0x14, 0x18, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x00, 0x38, 0x24, 0x04, 0x34, 0x24, 0x24, 0x1c, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x00, 0x24, 0x26, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x00, 0x38, 0x14, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x00, 0x78, 0x24, 0x20, 0x20, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x00, 0x24, 0x16, 0x0c, 0x14, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2c, 0x34, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x00, 0x24, 0x3e, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x00, 0x36, 0x2d, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x40, 0x78, 0x24, 0x24, 0x24, 0x24, 0x24, 0x1c, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x30, 0x4c, 0x4a, 0x48, 0x38, 0x08, 0x08, 0x04, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x10, 0x60 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x1c, 0x14, 0x54, 0x24, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x00, 0x38, 0x24, 0x04, 0x18, 0x20, 0x20, 0x1c, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x40, 0x38, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x00, 0x24, 0x64, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x40, 0x34, 0x24, 0x24, 0x24, 0x14, 0x0c, 0x04, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x00, 0x48, 0x4c, 0x48, 0x48, 0x78, 0x78, 0x48, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x14, 0x18, 0x28, 0x24, 0x24, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x00, 0x24, 0x26, 0x24, 0x3c, 0x20, 0x24, 0x38, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x00, 0x3c, 0x24, 0x10, 0x18, 0x08, 0x24, 0x3c, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x00, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00 },	// U+005B ([)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x00 },	// U+005C (\)
	{ 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38, 0x00 },	// U+005D (])
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00 },	// U+005F (_)
	{ 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x24, 0x24, 0x74, 0x28, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x00, 0x18, 0x14, 0x14, 0x6c, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x24, 0x04, 0x44, 0x38, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x38, 0x24, 0x24, 0x64, 0x38, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x24, 0x1c, 0x44, 0x38, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x00, 0x60, 0x10, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x0c },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x24, 0x24, 0x64, 0x38, 0x28, 0x18 },	// U+0067 (g)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x34, 0x2c, 0x64, 0x24, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x08, 0x48, 0x30, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x18, 0x10, 0x30, 0x18, 0x14, 0x14, 0x0c },	// U+006A (j)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1c, 0x14, 0x0c, 0x54, 0x24, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x00, 0x30, 0x28, 0x28, 0x18, 0x0c, 0x48, 0x30, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x3c, 0x24, 0x64, 0x24, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x64, 0x24, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x64, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x2c, 0x24, 0x64, 0x1c, 0x04, 0x04 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x24, 0x24, 0x24, 0x38, 0x60, 0x20 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x38, 0x24, 0x62, 0x20, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x18, 0x20, 0x1c, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3c, 0x08, 0x0c, 0x48, 0x30, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x64, 0x38, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x34, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x64, 0x24, 0x3c, 0x24, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x18, 0x64, 0x24, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x64, 0x38, 0x24, 0x18 },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x10, 0x28, 0x24, 0x24, 0x18 },	// U+007A (z)
	{ 0x00, 0x00, 0x20, 0x10, 0x10, 0x10, 0x0c, 0x10, 0x10, 0x10, 0x20, 0x00 },	// U+007B ({)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+007C (|)
	{ 0x00, 0x00, 0x08, 0x10, 0x10, 0x10, 0x60, 0x10, 0x10, 0x10, 0x08, 0x00 },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x54, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
}; // 95

static const unsigned char scientificai_block2[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x00, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x2c, 0x0c, 0x2c, 0x18, 0x08, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x0c, 0x04, 0x2c, 0x34, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x38, 0x28, 0x38, 0x44, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0x00, 0x28, 0x28, 0x7c, 0x28, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x1c, 0x24, 0x38, 0x24, 0x18, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x30, 0x48, 0x34, 0x14, 0x34, 0x48, 0x30, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x38, 0x24, 0x24, 0x24, 0x38, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x24, 0x48, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x00, 0x00, 0x00, 0x30, 0x48, 0x34, 0x14, 0x14, 0x48, 0x30, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x7c, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x00, 0x00, 0x00, 0x38, 0x10, 0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x3c, 0x44, 0x04 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x2c, 0x2c, 0x2c, 0x28, 0x28, 0x28, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18 },	// U+00B8 (¸)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x08, 0x00, 0x1c, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x48, 0x24, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x3c, 0x00, 0x08, 0x28, 0x38, 0x20 },	// U+00BC (¼)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x3c, 0x00, 0x38, 0x30, 0x08, 0x38 },	// U+00BD (½)
	{ 0x00, 0x38, 0x30, 0x20, 0x38, 0x00, 0x3c, 0x00, 0x08, 0x28, 0x38, 0x20 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x10, 0x0c, 0x04, 0x38, 0x00, 0x00 },	// U+00BF (¿)
	{ 0x00, 0x08, 0x10, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x00, 0x10, 0x08, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x00, 0x10, 0x28, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x00, 0x28, 0x14, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x00, 0x24, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x00, 0x08, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x00, 0x38, 0x14, 0x14, 0x3c, 0x14, 0x14, 0x34, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x04, 0x04, 0x24, 0x18, 0x10, 0x18 },	// U+00C7 (Ç)
	{ 0x00, 0x08, 0x10, 0x3c, 0x04, 0x04, 0x0c, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x00, 0x10, 0x08, 0x3c, 0x04, 0x04, 0x0c, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x00, 0x10, 0x28, 0x00, 0x3c, 0x04, 0x0c, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x00, 0x28, 0x00, 0x3c, 0x04, 0x04, 0x0c, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x00, 0x04, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x00, 0x10, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x00, 0x08, 0x14, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x00, 0x14, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x00, 0x38, 0x48, 0x48, 0x5c, 0x48, 0x48, 0x38, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x00, 0x28, 0x14, 0x24, 0x24, 0x2c, 0x2c, 0x34, 0x34, 0x24, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x00, 0x08, 0x10, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x00, 0x10, 0x08, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x00, 0x10, 0x28, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x00, 0x28, 0x14, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x00, 0x24, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x00, 0x00, 0x58, 0x64, 0x34, 0x2c, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00D8 (Ø)
	{ 0x00, 0x08, 0x10, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x00, 0x10, 0x08, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x00, 0x10, 0x28, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x00, 0x24, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x00, 0x10, 0x08, 0x24, 0x24, 0x24, 0x38, 0x20, 0x24, 0x38, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x00, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x1c, 0x04, 0x00, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x14, 0x14, 0x2c, 0x24, 0x1c, 0x04, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x00, 0x08, 0x10, 0x00, 0x38, 0x24, 0x24, 0x34, 0x28, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x38, 0x24, 0x24, 0x34, 0x28, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x00, 0x10, 0x28, 0x00, 0x38, 0x24, 0x24, 0x34, 0x28, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x50, 0x28, 0x00, 0x38, 0x24, 0x24, 0x34, 0x28, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x00, 0x24, 0x00, 0x38, 0x24, 0x24, 0x34, 0x28, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x38, 0x24, 0x24, 0x34, 0x28, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x14, 0x3c, 0x14, 0x34, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x24, 0x18, 0x10, 0x18 },	// U+00E7 (ç)
	{ 0x00, 0x00, 0x08, 0x10, 0x00, 0x18, 0x24, 0x3c, 0x04, 0x38, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x18, 0x24, 0x3c, 0x04, 0x38, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x00, 0x10, 0x28, 0x00, 0x18, 0x24, 0x3c, 0x04, 0x38, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x00, 0x24, 0x00, 0x18, 0x24, 0x3c, 0x04, 0x38, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x00, 0x08, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x38, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x28, 0x14, 0x00, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x08, 0x10, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x00, 0x10, 0x28, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0x28, 0x14, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x00, 0x24, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x3c, 0x00, 0x18, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x38, 0x34, 0x2c, 0x24, 0x18, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x00, 0x08, 0x10, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x00, 0x10, 0x28, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x00, 0x24, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x24, 0x18 },	// U+00FD (ý)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x1c, 0x04, 0x04 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x00, 0x24, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x24, 0x18 },	// U+00FF (ÿ)
	{ 0x00, 0x3c, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x24, 0x24, 0x34, 0x28, 0x00, 0x00 },	// U+0101 (ā)
	{ 0x00, 0x24, 0x18, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x38, 0x24, 0x24, 0x34, 0x28, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x10, 0x30 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x24, 0x24, 0x34, 0x28, 0x08, 0x18 },	// U+0105 (ą)
	{ 0x00, 0x20, 0x10, 0x18, 0x24, 0x04, 0x04, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x18, 0x24, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x00, 0x10, 0x28, 0x18, 0x24, 0x04, 0x04, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x00, 0x10, 0x28, 0x00, 0x18, 0x24, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x00, 0x10, 0x00, 0x18, 0x24, 0x04, 0x04, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x18, 0x24, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+010B (ċ)
	{ 0x00, 0x28, 0x10, 0x18, 0x24, 0x04, 0x04, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0x00, 0x28, 0x10, 0x00, 0x18, 0x24, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+010D (č)
	{ 0x00, 0x28, 0x10, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x1c, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x00, 0x00, 0x00, 0x50, 0x50, 0x18, 0x14, 0x14, 0x14, 0x18, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x2c, 0x24, 0x24, 0x1c, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x00, 0x20, 0x38, 0x20, 0x38, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x00, 0x3c, 0x00, 0x3c, 0x04, 0x04, 0x0c, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x18, 0x24, 0x3c, 0x04, 0x38, 0x00, 0x00 },	// U+0113 (ē)
	{ 0x00, 0x24, 0x18, 0x3c, 0x04, 0x04, 0x0c, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+0114 (Ĕ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x18, 0x24, 0x3c, 0x04, 0x38, 0x00, 0x00 },	// U+0115 (ĕ)
	{ 0x00, 0x10, 0x00, 0x3c, 0x04, 0x04, 0x0c, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x18, 0x24, 0x3c, 0x04, 0x38, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x0c, 0x04, 0x04, 0x3c, 0x10, 0x30 },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x3c, 0x04, 0x38, 0x10, 0x30 },	// U+0119 (ę)
	{ 0x00, 0x28, 0x10, 0x3c, 0x04, 0x04, 0x0c, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0x00, 0x28, 0x10, 0x00, 0x18, 0x24, 0x3c, 0x04, 0x38, 0x00, 0x00 },	// U+011B (ě)
	{ 0x00, 0x10, 0x28, 0x18, 0x24, 0x04, 0x04, 0x34, 0x24, 0x18, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x00, 0x10, 0x28, 0x00, 0x38, 0x24, 0x24, 0x24, 0x38, 0x20, 0x18 },	// U+011D (ĝ)
	{ 0x00, 0x24, 0x18, 0x18, 0x24, 0x04, 0x04, 0x34, 0x24, 0x18, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x38, 0x24, 0x24, 0x24, 0x38, 0x20, 0x18 },	// U+011F (ğ)
	{ 0x00, 0x08, 0x00, 0x18, 0x24, 0x04, 0x04, 0x34, 0x24, 0x18, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x38, 0x24, 0x24, 0x24, 0x38, 0x20, 0x38 },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x04, 0x34, 0x24, 0x18, 0x10, 0x18 },	// U+0122 (Ģ)
	{ 0x00, 0x00, 0x20, 0x10, 0x00, 0x38, 0x24, 0x24, 0x24, 0x38, 0x20, 0x38 },	// U+0123 (ģ)
	{ 0x00, 0x10, 0x28, 0x00, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x00, 0x08, 0x14, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x00, 0x24, 0x3c, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x00, 0x04, 0x1c, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0x00, 0x28, 0x14, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x00, 0x28, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x00, 0x1c, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+012B (ī)
	{ 0x00, 0x24, 0x18, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+012C (Ĭ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+012D (ĭ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x10, 0x30 },	// U+012E (Į)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x04, 0x0c },	// U+012F (į)
	{ 0x00, 0x08, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+0131 (ı)
	{ 0x00, 0x00, 0x00, 0x34, 0x24, 0x24, 0x24, 0x24, 0x2c, 0x34, 0x00, 0x00 },	// U+0132 (Ĳ)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x08 },	// U+0133 (ĳ)
	{ 0x00, 0x10, 0x28, 0x00, 0x38, 0x20, 0x20, 0x20, 0x24, 0x38, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x00, 0x08, 0x14, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08 },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x00, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x24, 0x24, 0x10, 0x18 },	// U+0136 (Ķ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x10, 0x18 },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x1c, 0x14, 0x24, 0x24, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x00, 0x10, 0x08, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x00, 0x10, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x10, 0x18 },	// U+013B (Ļ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x08, 0x0c },	// U+013C (ļ)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x00, 0x00, 0x00, 0x2c, 0x28, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+013E (ľ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x24, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+013F (Ŀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x28, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+0140 (ŀ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x00, 0x00, 0x0c, 0x28, 0x18, 0x08, 0x0c, 0x08, 0x30, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x00, 0x20, 0x10, 0x24, 0x24, 0x2c, 0x34, 0x34, 0x24, 0x24, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x2c, 0x34, 0x34, 0x24, 0x24, 0x10, 0x30 },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x10, 0x30 },	// U+0146 (ņ)
	{ 0x00, 0x28, 0x10, 0x24, 0x2c, 0x2c, 0x34, 0x34, 0x24, 0x24, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0x00, 0x28, 0x10, 0x00, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0148 (ň)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0149 (ŉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x2c, 0x24, 0x24, 0x24, 0x24, 0x20, 0x18 },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x20, 0x10 },	// U+014B (ŋ)
	{ 0x00, 0x3c, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+014D (ō)
	{ 0x00, 0x24, 0x18, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+014E (Ŏ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+014F (ŏ)
	{ 0x00, 0x28, 0x14, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x00, 0x28, 0x14, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x00, 0x78, 0x14, 0x14, 0x74, 0x14, 0x14, 0x78, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x54, 0x74, 0x14, 0x78, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x00, 0x10, 0x08, 0x1c, 0x24, 0x24, 0x1c, 0x14, 0x14, 0x24, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x1c, 0x24, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x1c, 0x14, 0x24, 0x24, 0x08, 0x04 },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x24, 0x04, 0x04, 0x04, 0x08, 0x04 },	// U+0157 (ŗ)
	{ 0x00, 0x28, 0x10, 0x1c, 0x24, 0x24, 0x1c, 0x14, 0x14, 0x24, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0x28, 0x10, 0x00, 0x00, 0x1c, 0x24, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x00, 0x10, 0x08, 0x18, 0x24, 0x04, 0x18, 0x20, 0x24, 0x18, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x38, 0x04, 0x18, 0x20, 0x1c, 0x00, 0x00 },	// U+015B (ś)
	{ 0x00, 0x10, 0x28, 0x18, 0x24, 0x04, 0x18, 0x20, 0x24, 0x18, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x00, 0x10, 0x28, 0x00, 0x38, 0x04, 0x18, 0x20, 0x1c, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x18, 0x20, 0x24, 0x18, 0x10, 0x18 },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x18, 0x20, 0x1c, 0x10, 0x18 },	// U+015F (ş)
	{ 0x00, 0x28, 0x10, 0x18, 0x24, 0x04, 0x18, 0x20, 0x24, 0x18, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0x00, 0x28, 0x10, 0x00, 0x38, 0x04, 0x18, 0x20, 0x1c, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x18 },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x10, 0x08, 0x0c },	// U+0163 (ţ)
	{ 0x00, 0x14, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x00, 0x00, 0x00, 0x48, 0x48, 0x1c, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x08, 0x1c, 0x08, 0x10, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0x00, 0x14, 0x28, 0x04, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x00, 0x28, 0x14, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x00, 0x1c, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x00, 0x1c, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+016B (ū)
	{ 0x00, 0x24, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x00, 0x24, 0x18, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x00, 0x10, 0x28, 0x34, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x00, 0x00, 0x10, 0x28, 0x10, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+016F (ů)
	{ 0x00, 0x24, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x00, 0x28, 0x14, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x10, 0x20 },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x60 },	// U+0173 (ų)
	{ 0x00, 0x10, 0x28, 0x00, 0x24, 0x24, 0x24, 0x24, 0x3c, 0x24, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x00, 0x10, 0x28, 0x00, 0x24, 0x24, 0x24, 0x3c, 0x24, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x00, 0x10, 0x28, 0x04, 0x24, 0x24, 0x38, 0x20, 0x24, 0x38, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x00, 0x08, 0x14, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x24, 0x18 },	// U+0177 (ŷ)
	{ 0x00, 0x24, 0x00, 0x24, 0x24, 0x24, 0x38, 0x20, 0x24, 0x38, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x00, 0x08, 0x00, 0x3c, 0x20, 0x20, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+017A (ź)
	{ 0x00, 0x08, 0x00, 0x3c, 0x20, 0x20, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x3c, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+017C (ż)
	{ 0x00, 0x28, 0x10, 0x3c, 0x20, 0x20, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0x28, 0x10, 0x00, 0x00, 0x3c, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+017E (ž)
	{ 0x00, 0x00, 0x00, 0x30, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+017F (ſ)
	{ 0x00, 0x00, 0x04, 0x1c, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x1c, 0x00, 0x00 },	// U+0180 (ƀ)
	{ 0x00, 0x00, 0x00, 0x38, 0x54, 0x50, 0x30, 0x50, 0x50, 0x30, 0x00, 0x00 },	// U+0181 (Ɓ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x1c, 0x00, 0x00 },	// U+0182 (Ƃ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x1c, 0x00, 0x00 },	// U+0183 (ƃ)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x08, 0x18, 0x28, 0x28, 0x18, 0x00, 0x00 },	// U+0184 (Ƅ)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x18, 0x28, 0x28, 0x28, 0x18, 0x00, 0x00 },	// U+0185 (ƅ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x20, 0x20, 0x24, 0x18, 0x00, 0x00 },	// U+0186 (Ɔ)
	{ 0x00, 0x60, 0x10, 0x18, 0x24, 0x04, 0x04, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+0187 (Ƈ)
	{ 0x00, 0x00, 0x00, 0x60, 0x10, 0x18, 0x24, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+0188 (ƈ)
	{ 0x00, 0x00, 0x00, 0x18, 0x28, 0x28, 0x3c, 0x28, 0x28, 0x18, 0x00, 0x00 },	// U+0189 (Ɖ)
	{ 0x00, 0x00, 0x00, 0x38, 0x54, 0x50, 0x50, 0x50, 0x50, 0x30, 0x00, 0x00 },	// U+018A (Ɗ)
	{ 0x00, 0x00, 0x3c, 0x20, 0x20, 0x20, 0x38, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+018B (Ƌ)
	{ 0x00, 0x00, 0x3c, 0x20, 0x20, 0x38, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+018C (ƌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x20, 0x1c },	// U+018D (ƍ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x20, 0x20, 0x30, 0x20, 0x20, 0x3c, 0x00, 0x00 },	// U+018E (Ǝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x3c, 0x24, 0x18, 0x00, 0x00 },	// U+018F (Ə)
	{ 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x18, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+0190 (Ɛ)
	{ 0x00, 0x00, 0x00, 0x38, 0x08, 0x08, 0x18, 0x08, 0x08, 0x08, 0x08, 0x04 },	// U+0191 (Ƒ)
	{ 0x00, 0x00, 0x10, 0x28, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x04 },	// U+0192 (ƒ)
	{ 0x00, 0x30, 0x08, 0x18, 0x24, 0x04, 0x04, 0x34, 0x24, 0x18, 0x00, 0x00 },	// U+0193 (Ɠ)
	{ 0x00, 0x00, 0x00, 0x24, 0x28, 0x10, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0194 (Ɣ)
	{ 0x00, 0x00, 0x00, 0x04, 0x24, 0x4c, 0x54, 0x54, 0x54, 0x34, 0x00, 0x00 },	// U+0195 (ƕ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00 },	// U+0196 (Ɩ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x08, 0x00, 0x00 },	// U+0197 (Ɨ)
	{ 0x00, 0x00, 0x00, 0x24, 0x54, 0x0c, 0x14, 0x14, 0x24, 0x24, 0x00, 0x00 },	// U+0198 (Ƙ)
	{ 0x00, 0x00, 0x08, 0x14, 0x04, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x00, 0x00 },	// U+0199 (ƙ)
	{ 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x38, 0x10, 0x10, 0x20, 0x00, 0x00 },	// U+019A (ƚ)
	{ 0x00, 0x00, 0x00, 0x28, 0x14, 0x10, 0x10, 0x18, 0x24, 0x24, 0x00, 0x00 },	// U+019B (ƛ)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x3c, 0x24, 0x00, 0x00 },	// U+019C (Ɯ)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x2c, 0x34, 0x34, 0x24, 0x24, 0x04, 0x02 },	// U+019D (Ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x20, 0x20 },	// U+019E (ƞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x3c, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+019F (Ɵ)
	{ 0x00, 0x20, 0x20, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+01A0 (Ơ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+01A1 (ơ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x54, 0x54, 0x54, 0x54, 0x58, 0x00, 0x00 },	// U+01A2 (Ƣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x54, 0x54, 0x54, 0x58, 0x40, 0x40, 0x20 },	// U+01A3 (ƣ)
	{ 0x00, 0x00, 0x00, 0x18, 0x2c, 0x28, 0x18, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+01A4 (Ƥ)
	{ 0x00, 0x00, 0x00, 0x18, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x1c, 0x04, 0x04 },	// U+01A5 (ƥ)
	{ 0x00, 0x00, 0x04, 0x1c, 0x24, 0x24, 0x1c, 0x24, 0x24, 0x24, 0x20, 0x40 },	// U+01A6 (Ʀ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x18, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+01A7 (Ƨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x18, 0x04, 0x38, 0x00, 0x00 },	// U+01A8 (ƨ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x08, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+01A9 (Ʃ)
	{ 0x00, 0x08, 0x14, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00 },	// U+01AA (ƪ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x30, 0x20, 0x10 },	// U+01AB (ƫ)
	{ 0x00, 0x00, 0x00, 0x38, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+01AC (Ƭ)
	{ 0x00, 0x10, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+01AD (ƭ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10 },	// U+01AE (Ʈ)
	{ 0x00, 0x40, 0x40, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+01AF (Ư)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+01B0 (ư)
	{ 0x00, 0x00, 0x00, 0x00, 0x6c, 0x28, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+01B1 (Ʊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x24, 0x24, 0x24, 0x14, 0x0c, 0x00, 0x00 },	// U+01B2 (Ʋ)
	{ 0x00, 0x00, 0x20, 0x54, 0x14, 0x14, 0x18, 0x10, 0x14, 0x18, 0x00, 0x00 },	// U+01B3 (Ƴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x54, 0x14, 0x14, 0x14, 0x18, 0x14, 0x18 },	// U+01B4 (ƴ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x20, 0x10, 0x3c, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+01B5 (Ƶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x20, 0x10, 0x3c, 0x08, 0x3c, 0x00, 0x00 },	// U+01B6 (ƶ)
}; // 279

static const unsigned char scientificai_block3[][12] = {
	{ 0x00, 0x00, 0x00, 0x34, 0x24, 0x24, 0x24, 0x24, 0x24, 0x2c, 0x20, 0x18 },	// U+01C7 (Ǉ)
	{ 0x00, 0x00, 0x00, 0x24, 0x04, 0x24, 0x24, 0x24, 0x24, 0x2c, 0x20, 0x10 },	// U+01C8 (ǈ)
	{ 0x00, 0x00, 0x00, 0x2c, 0x08, 0x28, 0x28, 0x28, 0x28, 0x28, 0x20, 0x10 },	// U+01C9 (ǉ)
	{ 0x00, 0x00, 0x00, 0x54, 0x5c, 0x5c, 0x54, 0x54, 0x54, 0x54, 0x40, 0x30 },	// U+01CA (Ǌ)
	{ 0x00, 0x00, 0x00, 0x54, 0x1c, 0x5c, 0x54, 0x54, 0x54, 0x54, 0x40, 0x20 },	// U+01CB (ǋ)
	{ 0x00, 0x00, 0x00, 0x40, 0x00, 0x4c, 0x54, 0x54, 0x54, 0x54, 0x40, 0x20 },	// U+01CC (ǌ)
	{ 0x00, 0x14, 0x08, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+01CD (Ǎ)
	{ 0x00, 0x00, 0x14, 0x08, 0x00, 0x38, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+01CE (ǎ)
	{ 0x00, 0x14, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+01CF (Ǐ)
	{ 0x00, 0x00, 0x14, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+01D0 (ǐ)
	{ 0x00, 0x14, 0x08, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+01D1 (Ǒ)
	{ 0x00, 0x00, 0x14, 0x08, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+01D2 (ǒ)
	{ 0x00, 0x14, 0x08, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+01D3 (Ǔ)
	{ 0x00, 0x00, 0x14, 0x08, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+01D4 (ǔ)
}; // 14

static const unsigned char scientificai_block4[][12] = {
	{ 0x00, 0x14, 0x28, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+020C (Ȍ)
	{ 0x00, 0x00, 0x14, 0x28, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+020D (ȍ)
	{ 0x00, 0x18, 0x24, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+020E (Ȏ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+020F (ȏ)
	{ 0x00, 0x14, 0x28, 0x00, 0x1c, 0x24, 0x1c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0210 (Ȑ)
	{ 0x00, 0x00, 0x14, 0x28, 0x00, 0x1c, 0x24, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0211 (ȑ)
	{ 0x00, 0x18, 0x24, 0x00, 0x1c, 0x24, 0x1c, 0x14, 0x14, 0x24, 0x00, 0x00 },	// U+0212 (Ȓ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x1c, 0x24, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0213 (ȓ)
	{ 0x00, 0x14, 0x28, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+0214 (Ȕ)
	{ 0x00, 0x00, 0x14, 0x28, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+0215 (ȕ)
	{ 0x00, 0x18, 0x24, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+0216 (Ȗ)
	{ 0x00, 0x00, 0x18, 0x24, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+0217 (ȗ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x18, 0x20, 0x24, 0x18, 0x10, 0x08 },	// U+0218 (Ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x18, 0x20, 0x1c, 0x10, 0x08 },	// U+0219 (ș)
	{ 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04 },	// U+021A (Ț)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x30, 0x10, 0x08 },	// U+021B (ț)
}; // 16

static const unsigned char scientificai_block5[][12] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x20, 0x20, 0x24, 0x18, 0x00, 0x00 },	// U+0296 (ʖ)
}; // 1

static const unsigned char scientificai_block6[][12] = {
	{ 0x00, 0x00, 0x38, 0x44, 0x44, 0x54, 0x54, 0x44, 0x44, 0x38, 0x00, 0x00 },	// U+0298 (ʘ)
}; // 1

static const unsigned char scientificai_block7[][12] = {
	{ 0x00, 0x00, 0x00, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C7 (ˇ)
}; // 1

static const unsigned char scientificai_block8[][12] = {
	{ 0x00, 0x00, 0x10, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DA (˚)
}; // 1

static const unsigned char scientificai_block9[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x20, 0x10, 0x00, 0x00 },	// U+0364 (ͤ)
}; // 1

static const unsigned char scientificai_block10[][12] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0391 (Α)
	{ 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x1c, 0x24, 0x24, 0x1c, 0x00, 0x00 },	// U+0392 (Β)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0393 (Γ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x7c, 0x00, 0x00 },	// U+0394 (Δ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x3c, 0x00, 0x00 },	// U+0395 (Ε)
	{ 0x00, 0x00, 0x00, 0x3c, 0x20, 0x20, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+0396 (Ζ)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+0397 (Η)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+0398 (Θ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+0399 (Ι)
	{ 0x00, 0x00, 0x00, 0x24, 0x14, 0x0c, 0x14, 0x14, 0x24, 0x24, 0x00, 0x00 },	// U+039A (Κ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x44, 0x00, 0x00 },	// U+039B (Λ)
	{ 0x00, 0x00, 0x00, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+039C (Μ)
	{ 0x00, 0x00, 0x00, 0x24, 0x2c, 0x2c, 0x34, 0x34, 0x24, 0x24, 0x00, 0x00 },	// U+039D (Ν)
	{ 0x00, 0x00, 0x00, 0x3c, 0x24, 0x00, 0x18, 0x00, 0x24, 0x3c, 0x00, 0x00 },	// U+039E (Ξ)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+039F (Ο)
	{ 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+03A0 (Π)
	{ 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x1c, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+03A1 (Ρ)
	{ 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c },	// U+03A2 (΢)
	{ 0x00, 0x00, 0x00, 0x3c, 0x04, 0x08, 0x10, 0x08, 0x04, 0x3c, 0x00, 0x00 },	// U+03A3 (Σ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+03A4 (Τ)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x38, 0x20, 0x24, 0x18, 0x00, 0x00 },	// U+03A5 (Υ)
	{ 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x54, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+03A6 (Φ)
	{ 0x00, 0x00, 0x00, 0x24, 0x24, 0x18, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+03A7 (Χ)
	{ 0x00, 0x00, 0x00, 0x54, 0x54, 0x54, 0x38, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+03A8 (Ψ)
	{ 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x6c, 0x28, 0x6c, 0x00, 0x00 },	// U+03A9 (Ω)
}; // 25

static const unsigned char scientificai_block11[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x14, 0x14, 0x28, 0x00, 0x00 },	// U+03B1 (α)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x14, 0x14, 0x2c, 0x24, 0x1c, 0x04, 0x04 },	// U+03B2 (β)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x10, 0x28, 0x28, 0x10 },	// U+03B3 (γ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+03B4 (δ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x08, 0x04, 0x24, 0x18, 0x00, 0x00 },	// U+03B5 (ε)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x10, 0x08, 0x04, 0x04, 0x38, 0x20 },	// U+03B6 (ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x20, 0x20 },	// U+03B7 (η)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x3c, 0x24, 0x18, 0x00, 0x00 },	// U+03B8 (θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00 },	// U+03B9 (ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x0c, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+03BA (κ)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x10, 0x10, 0x28, 0x24, 0x24, 0x00, 0x00 },	// U+03BB (λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x3c, 0x44, 0x04 },	// U+03BC (μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x24, 0x28, 0x28, 0x28, 0x10, 0x00, 0x00 },	// U+03BD (ν)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x24, 0x08, 0x04, 0x04, 0x38, 0x20, 0x18 },	// U+03BE (ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+03BF (ο)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+03C0 (π)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x18, 0x08, 0x08 },	// U+03C1 (ρ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x04, 0x18, 0x20, 0x10 },	// U+03C2 (ς)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+03C3 (σ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x08, 0x08, 0x28, 0x10, 0x00, 0x00 },	// U+03C4 (τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x38, 0x00, 0x00 },	// U+03C5 (υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x24, 0x3c, 0x08, 0x08 },	// U+03C6 (φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x08, 0x14, 0x20, 0x00 },	// U+03C7 (χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x54, 0x54, 0x38, 0x10, 0x10 },	// U+03C8 (ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x44, 0x44, 0x54, 0x28, 0x00, 0x00 },	// U+03C9 (ω)
}; // 25

static const unsigned char scientificai_block12[][12] = {
	{ 0x00, 0x00, 0x20, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x04 },	// U+0F3C (༼)
	{ 0x00, 0x00, 0x08, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x40 },	// U+0F3D (༽)
}; // 2

static const unsigned char scientificai_block13[][12] = {
	{ 0x00, 0x00, 0x00, 0x38, 0x24, 0x24, 0x14, 0x24, 0x24, 0x3c, 0x04, 0x04 },	// U+1E9E (ẞ)
}; // 1

static const unsigned char scientificai_block14[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2010 (‐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2011 (‑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2012 (‒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2013 (–)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+2014 (—)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+2015 (―)
	{ 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+2016 (‖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00 },	// U+2017 (‗)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2018 (‘)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2019 (’)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x10 },	// U+201A (‚)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201B (‛)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201C (“)
	{ 0x00, 0x00, 0x00, 0x28, 0x28, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201D (”)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x14, 0x00, 0x00 },	// U+201E („)
	{ 0x00, 0x00, 0x00, 0x28, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201F (‟)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2020 (†)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x08, 0x1c, 0x08, 0x08, 0x00, 0x00 },	// U+2021 (‡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+2022 (•)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x04, 0x00, 0x00, 0x00 },	// U+2023 (‣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+2024 (․)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00 },	// U+2025 (‥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00 },	// U+2026 (…)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2027 (‧)
}; // 24

static const unsigned char scientificai_block15[][12] = {
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2032 (′)
	{ 0x00, 0x00, 0x00, 0x50, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2033 (″)
	{ 0x00, 0x00, 0x00, 0x28, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2034 (‴)
	{ 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2035 (‵)
	{ 0x00, 0x00, 0x00, 0x28, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2036 (‶)
	{ 0x00, 0x00, 0x00, 0x54, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2037 (‷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x00, 0x00 },	// U+2038 (‸)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x00 },	// U+2039 (‹)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+203A (›)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x28, 0x00, 0x00, 0x00 },	// U+203B (※)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x00, 0x00 },	// U+203C (‼)
}; // 11

static const unsigned char scientificai_block16[][12] = {
	{ 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+203E (‾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00 },	// U+203F (‿)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2040 (⁀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x14, 0x00, 0x00 },	// U+2041 (⁁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+2042 (⁂)
}; // 5

static const unsigned char scientificai_block17[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x10, 0x00 },	// U+204F (⁏)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x24, 0x18, 0x00, 0x00 },	// U+2050 (⁐)
	{ 0x00, 0x00, 0x00, 0x14, 0x08, 0x14, 0x00, 0x14, 0x08, 0x14, 0x00, 0x00 },	// U+2051 (⁑)
}; // 3

static const unsigned char scientificai_block18[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x10, 0x7c, 0x10, 0x54, 0x00, 0x00 },	// U+205C (⁜)
}; // 1

static const unsigned char scientificai_block19[][12] = {
	{ 0x00, 0x00, 0x7c, 0x20, 0x7c, 0x20, 0x1c, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+20A8 (₨)
}; // 1

static const unsigned char scientificai_block20[][12] = {
	{ 0x00, 0x00, 0x00, 0x5c, 0x54, 0x54, 0x44, 0x54, 0x54, 0x74, 0x00, 0x00 },	// U+20AA (₪)
}; // 1

static const unsigned char scientificai_block21[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x1c, 0x1c, 0x04, 0x38, 0x00, 0x00 },	// U+20AC (€)
}; // 1

static const unsigned char scientificai_block22[][12] = {
	{ 0x00, 0x38, 0x10, 0x10, 0x10, 0x28, 0x38, 0x28, 0x28, 0x00, 0x00, 0x00 },	// U+2122 (™)
}; // 1

static const unsigned char scientificai_block23[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x7c, 0x08, 0x10, 0x00, 0x00 },	// U+2190 (←)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x00, 0x00 },	// U+2191 (↑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x7c, 0x20, 0x10, 0x00, 0x00 },	// U+2192 (→)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00 },	// U+2193 (↓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x7c, 0x28, 0x00, 0x00, 0x00 },	// U+2194 (↔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x08, 0x1c, 0x08, 0x00 },	// U+2195 (↕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x10, 0x20, 0x00, 0x00 },	// U+2196 (↖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x08, 0x04, 0x00, 0x00 },	// U+2197 (↗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x30, 0x30, 0x00, 0x00 },	// U+2198 (↘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x0c, 0x0c, 0x00, 0x00 },	// U+2199 (↙)
}; // 10

static const unsigned char scientificai_block24[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x50, 0x48, 0x7c, 0x48, 0x50, 0x00, 0x00, 0x00 },	// U+21A4 (↤)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x7c, 0x00, 0x00, 0x00 },	// U+21A5 (↥)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x24, 0x7c, 0x24, 0x14, 0x00, 0x00, 0x00 },	// U+21A6 (↦)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+21A7 (↧)
}; // 4

static const unsigned char scientificai_block25[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x7c, 0x08, 0x00, 0x00, 0x00 },	// U+21A9 (↩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x7c, 0x20, 0x00, 0x00, 0x00 },	// U+21AA (↪)
}; // 2

static const unsigned char scientificai_block26[][12] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x3c, 0x28, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+21B0 (↰)
	{ 0x00, 0x00, 0x00, 0x10, 0x3c, 0x14, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+21B1 (↱)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x28, 0x3c, 0x08, 0x00, 0x00 },	// U+21B2 (↲)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x14, 0x3c, 0x10, 0x00, 0x00 },	// U+21B3 (↳)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x38, 0x10, 0x00, 0x00 },	// U+21B4 (↴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x48, 0x7c, 0x08, 0x00, 0x00 },	// U+21B5 (↵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x5c, 0x08, 0x00, 0x00 },	// U+21B6 (↶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x74, 0x24, 0x00, 0x00 },	// U+21B7 (↷)
}; // 8

static const unsigned char scientificai_block27[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21B9 (↹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x64, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+21BA (↺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x4c, 0x48, 0x48, 0x30, 0x00, 0x00 },	// U+21BB (↻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+21BC (↼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x08, 0x00, 0x00 },	// U+21BD (↽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+21BE (↾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+21BF (↿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+21C0 (⇀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x20, 0x00, 0x00 },	// U+21C1 (⇁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x30, 0x10, 0x00, 0x00 },	// U+21C2 (⇂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0c, 0x08, 0x00, 0x00 },	// U+21C3 (⇃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x7c, 0x28, 0x7c, 0x08, 0x00, 0x00 },	// U+21C4 (⇄)
}; // 12

static const unsigned char scientificai_block28[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0x28, 0x7c, 0x20, 0x00, 0x00 },	// U+21C6 (⇆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0x08, 0x7c, 0x08, 0x00, 0x00 },	// U+21C7 (⇇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x7c, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+21C8 (⇈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x00, 0x00 },	// U+21C9 (⇉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x7c, 0x28, 0x00, 0x00 },	// U+21CA (⇊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0x00, 0x7c, 0x20, 0x00, 0x00 },	// U+21CB (⇋)
}; // 6

static const unsigned char scientificai_block29[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x78, 0x04, 0x78, 0x10, 0x00, 0x00 },	// U+21D0 (⇐)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x6c, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+21D1 (⇑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3c, 0x40, 0x3c, 0x10, 0x00, 0x00 },	// U+21D2 (⇒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x6c, 0x28, 0x10, 0x00 },	// U+21D3 (⇓)
}; // 4

static const unsigned char scientificai_block30[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x18, 0x00 },	// U+2200 (∀)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x14, 0x04, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2201 (∁)
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x38, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+2202 (∂)
	{ 0x00, 0x00, 0x00, 0x3c, 0x20, 0x20, 0x38, 0x20, 0x20, 0x3c, 0x00, 0x00 },	// U+2203 (∃)
	{ 0x00, 0x00, 0x20, 0x3c, 0x30, 0x28, 0x38, 0x24, 0x24, 0x3c, 0x00, 0x00 },	// U+2204 (∄)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x54, 0x54, 0x38, 0x10, 0x10, 0x00 },	// U+2205 (∅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x7c, 0x00, 0x00, 0x00 },	// U+2206 (∆)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2207 (∇)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x3c, 0x04, 0x78, 0x00, 0x00, 0x00 },	// U+2208 (∈)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x38, 0x14, 0x1c, 0x04, 0x38, 0x00, 0x00 },	// U+2209 (∉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x1c, 0x04, 0x38, 0x00, 0x00 },	// U+220A (∊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x38, 0x20, 0x1c, 0x00, 0x00 },	// U+220B (∋)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x3c, 0x30, 0x38, 0x24, 0x1c, 0x00, 0x00 },	// U+220C (∌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x38, 0x20, 0x1c, 0x00, 0x00 },	// U+220D (∍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00 },	// U+220E (∎)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+220F (∏)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x3c, 0x00, 0x00 },	// U+2210 (∐)
	{ 0x00, 0x00, 0x3c, 0x24, 0x04, 0x08, 0x10, 0x08, 0x04, 0x24, 0x3c, 0x00 },	// U+2211 (∑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2212 (−)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+2213 (∓)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00 },	// U+2214 (∔)
}; // 21

static const unsigned char scientificai_block31[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x7c, 0x10, 0x28, 0x00, 0x00 },	// U+2217 (∗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+2218 (∘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+2219 (∙)
	{ 0x00, 0x00, 0x40, 0x40, 0x20, 0x20, 0x10, 0x14, 0x08, 0x08, 0x00, 0x00 },	// U+221A (√)
}; // 4

static const unsigned char scientificai_block32[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x14, 0x14, 0x28, 0x00, 0x00 },	// U+221D (∝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x54, 0x54, 0x54, 0x28, 0x00, 0x00 },	// U+221E (∞)
}; // 2

static const unsigned char scientificai_block33[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x00, 0x00 },	// U+2227 (∧)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00 },	// U+2228 (∨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00 },	// U+2229 (∩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+222A (∪)
	{ 0x00, 0x00, 0x20, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x08 },	// U+222B (∫)
}; // 5

static const unsigned char scientificai_block34[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00 },	// U+2234 (∴)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+2235 (∵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+2236 (∶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00 },	// U+2237 (∷)
}; // 4

static const unsigned char scientificai_block35[][12] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x54, 0x20, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+2243 (≃)
}; // 1

static const unsigned char scientificai_block36[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x54, 0x20, 0x08, 0x54, 0x20, 0x00, 0x00 },	// U+2248 (≈)
}; // 1

static const unsigned char scientificai_block37[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00 },	// U+2254 (≔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00, 0x00, 0x00 },	// U+2255 (≕)
}; // 2

static const unsigned char scientificai_block38[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x7c, 0x10, 0x7c, 0x08, 0x08, 0x00 },	// U+2260 (≠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x00 },	// U+2261 (≡)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x7c, 0x20, 0x7c, 0x08, 0x7c, 0x04, 0x00 },	// U+2262 (≢)
}; // 3

static const unsigned char scientificai_block39[][12] = {
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x10, 0x20, 0x00, 0x7c, 0x00, 0x00 },	// U+2264 (≤)
	{ 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x10, 0x08, 0x00, 0x7c, 0x00, 0x00 },	// U+2265 (≥)
}; // 2

static const unsigned char scientificai_block40[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00 },	// U+2282 (⊂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x1c, 0x00, 0x00, 0x00 },	// U+2283 (⊃)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x38, 0x14, 0x14, 0x38, 0x08, 0x00, 0x00 },	// U+2284 (⊄)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1c, 0x28, 0x28, 0x1c, 0x10, 0x00, 0x00 },	// U+2285 (⊅)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x38, 0x00, 0x3c, 0x00, 0x00 },	// U+2286 (⊆)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x1c, 0x00, 0x3c, 0x00, 0x00 },	// U+2287 (⊇)
}; // 6

static const unsigned char scientificai_block41[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x54, 0x7c, 0x54, 0x38, 0x00, 0x00 },	// U+2295 (⊕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x7c, 0x44, 0x38, 0x00, 0x00 },	// U+2296 (⊖)
}; // 2

static const unsigned char scientificai_block42[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x54, 0x44, 0x38, 0x00, 0x00 },	// U+2299 (⊙)
}; // 1

static const unsigned char scientificai_block43[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x54, 0x7c, 0x54, 0x7c, 0x00, 0x00 },	// U+229E (⊞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x7c, 0x44, 0x7c, 0x00, 0x00 },	// U+229F (⊟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x28, 0x54, 0x28, 0x54, 0x00, 0x00 },	// U+22A0 (⊠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x54, 0x44, 0x7c, 0x00, 0x00 },	// U+22A1 (⊡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x7c, 0x04, 0x04, 0x00, 0x00 },	// U+22A2 (⊢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x00, 0x00 },	// U+22A3 (⊣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+22A4 (⊤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+22A5 (⊥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x00, 0x00 },	// U+22A6 (⊦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1c, 0x04, 0x1c, 0x04, 0x00, 0x00 },	// U+22A7 (⊧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0x04, 0x7c, 0x04, 0x00, 0x00 },	// U+22A8 (⊨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x74, 0x14, 0x14, 0x00, 0x00 },	// U+22A9 (⊩)
}; // 12

static const unsigned char scientificai_block44[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x74, 0x14, 0x74, 0x14, 0x00, 0x00 },	// U+22AB (⊫)
}; // 1

static const unsigned char scientificai_block45[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+22C4 (⋄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+22C5 (⋅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x08, 0x14, 0x00, 0x00, 0x00 },	// U+22C6 (⋆)
}; // 3

static const unsigned char scientificai_block46[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x6c, 0x08, 0x10, 0x10, 0x20, 0x60, 0x00, 0x00 },	// U+2325 (⌥)
}; // 1

static const unsigned char scientificai_block47[][12] = {
	{ 0x00, 0x40, 0x20, 0x10, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+239B (⎛)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+239C (⎜)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x40 },	// U+239D (⎝)
	{ 0x00, 0x04, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },	// U+239E (⎞)
	{ 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },	// U+239F (⎟)
	{ 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x10, 0x08, 0x04 },	// U+23A0 (⎠)
	{ 0x00, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+23A1 (⎡)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+23A2 (⎢)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38 },	// U+23A3 (⎣)
	{ 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },	// U+23A4 (⎤)
	{ 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },	// U+23A5 (⎥)
	{ 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38 },	// U+23A6 (⎦)
	{ 0x00, 0x60, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+23A7 (⎧)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+23A8 (⎨)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x60 },	// U+23A9 (⎩)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+23AA (⎪)
	{ 0x00, 0x0c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+23AB (⎫)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x60, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+23AC (⎬)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c },	// U+23AD (⎭)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+23AE (⎮)
}; // 20

static const unsigned char scientificai_block48[][12] = {
	{ 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BA (⎺)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BB (⎻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00 },	// U+23BC (⎼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00 },	// U+23BD (⎽)
}; // 4

static const unsigned char scientificai_block49[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x3c, 0x7c, 0x3c, 0x14, 0x00, 0x00 },	// U+23E9 (⏩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x78, 0x7c, 0x78, 0x50, 0x00, 0x00 },	// U+23EA (⏪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0x38, 0x7c, 0x00, 0x00 },	// U+23EB (⏫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x38, 0x7c, 0x38, 0x10, 0x00, 0x00 },	// U+23EC (⏬)
}; // 4

static const unsigned char scientificai_block50[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x1c, 0x18, 0x10, 0x00, 0x00 },	// U+23F4 (⏴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x1c, 0x0c, 0x04, 0x00, 0x00 },	// U+23F5 (⏵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0x00, 0x00 },	// U+23F6 (⏶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x38, 0x10, 0x00, 0x00 },	// U+23F7 (⏷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+23F8 (⏸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00 },	// U+23F9 (⏹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00 },	// U+23FA (⏺)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x54, 0x44, 0x38, 0x00, 0x00 },	// U+23FB (⏻)
}; // 8

static const unsigned char scientificai_block51[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2500 (─)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2501 (━)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2502 (│)
	{ 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2503 (┃)
}; // 4

static const unsigned char scientificai_block52[][12] = {
	{ 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10 },	// U+2506 (┆)
	{ 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18 },	// U+2507 (┇)
}; // 2

static const unsigned char scientificai_block53[][12] = {
	{ 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10 },	// U+250A (┊)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+250B (┋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+250C (┌)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+250D (┍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+250E (┎)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x78, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+250F (┏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2510 (┐)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2511 (┑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2512 (┒)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2513 (┓)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2514 (└)
	{ 0x00, 0x10, 0x10, 0x10, 0x70, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2515 (┕)
	{ 0x00, 0x38, 0x38, 0x38, 0x38, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2516 (┖)
	{ 0x00, 0x38, 0x38, 0x38, 0x78, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2517 (┗)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2518 (┘)
	{ 0x00, 0x10, 0x10, 0x10, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2519 (┙)
	{ 0x00, 0x38, 0x38, 0x38, 0x38, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251A (┚)
	{ 0x00, 0x38, 0x38, 0x38, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251B (┛)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+251C (├)
	{ 0x00, 0x10, 0x10, 0x10, 0x70, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+251D (┝)
}; // 20

static const unsigned char scientificai_block54[][12] = {
	{ 0x00, 0x38, 0x38, 0x38, 0x38, 0x78, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2520 (┠)
}; // 1

static const unsigned char scientificai_block55[][12] = {
	{ 0x00, 0x38, 0x38, 0x38, 0x78, 0x78, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2523 (┣)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2524 (┤)
	{ 0x00, 0x10, 0x10, 0x10, 0x1c, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2525 (┥)
}; // 3

static const unsigned char scientificai_block56[][12] = {
	{ 0x00, 0x38, 0x38, 0x38, 0x38, 0x3c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2528 (┨)
}; // 1

static const unsigned char scientificai_block57[][12] = {
	{ 0x00, 0x38, 0x38, 0x38, 0x3c, 0x3c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+252B (┫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+252C (┬)
}; // 2

static const unsigned char scientificai_block58[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+252F (┯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2530 (┰)
}; // 2

static const unsigned char scientificai_block59[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2533 (┳)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2534 (┴)
}; // 2

static const unsigned char scientificai_block60[][12] = {
	{ 0x00, 0x10, 0x10, 0x10, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2537 (┷)
	{ 0x00, 0x38, 0x38, 0x38, 0x38, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2538 (┸)
}; // 2

static const unsigned char scientificai_block61[][12] = {
	{ 0x00, 0x38, 0x38, 0x38, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253B (┻)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+253C (┼)
}; // 2

static const unsigned char scientificai_block62[][12] = {
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+253F (┿)
}; // 1

static const unsigned char scientificai_block63[][12] = {
	{ 0x00, 0x38, 0x38, 0x38, 0x38, 0x7c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2542 (╂)
}; // 1

static const unsigned char scientificai_block64[][12] = {
	{ 0x00, 0x38, 0x38, 0x38, 0x7c, 0x7c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+254B (╋)
}; // 1

static const unsigned char scientificai_block65[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2550 (═)
	{ 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2551 (║)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x10, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2552 (╒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2553 (╓)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x08, 0x68, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2554 (╔)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x10, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2555 (╕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2556 (╖)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x20, 0x2c, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2557 (╗)
	{ 0x00, 0x10, 0x10, 0x10, 0x70, 0x10, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2558 (╘)
	{ 0x00, 0x28, 0x28, 0x28, 0x28, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2559 (╙)
	{ 0x00, 0x28, 0x28, 0x28, 0x68, 0x08, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255A (╚)
	{ 0x00, 0x10, 0x10, 0x10, 0x1c, 0x10, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255B (╛)
	{ 0x00, 0x28, 0x28, 0x28, 0x28, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255C (╜)
	{ 0x00, 0x28, 0x28, 0x28, 0x2c, 0x20, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255D (╝)
	{ 0x00, 0x10, 0x10, 0x10, 0x70, 0x10, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+255E (╞)
	{ 0x00, 0x28, 0x28, 0x28, 0x28, 0x68, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+255F (╟)
	{ 0x00, 0x28, 0x28, 0x28, 0x68, 0x08, 0x68, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2560 (╠)
	{ 0x00, 0x10, 0x10, 0x10, 0x1c, 0x10, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2561 (╡)
	{ 0x00, 0x28, 0x28, 0x28, 0x28, 0x2c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2562 (╢)
	{ 0x00, 0x28, 0x28, 0x28, 0x2c, 0x20, 0x2c, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2563 (╣)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2564 (╤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2565 (╥)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x6c, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2566 (╦)
	{ 0x00, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2567 (╧)
	{ 0x00, 0x28, 0x28, 0x28, 0x28, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2568 (╨)
	{ 0x00, 0x28, 0x28, 0x28, 0x6c, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2569 (╩)
	{ 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+256A (╪)
	{ 0x00, 0x28, 0x28, 0x28, 0x28, 0x7c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+256B (╫)
	{ 0x00, 0x28, 0x28, 0x28, 0x6c, 0x00, 0x6c, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+256C (╬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+256D (╭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+256E (╮)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+256F (╯)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2570 (╰)
	{ 0x00, 0x40, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04 },	// U+2571 (╱)
	{ 0x00, 0x04, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40 },	// U+2572 (╲)
	{ 0x00, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44 },	// U+2573 (╳)
}; // 36

static const unsigned char scientificai_block66[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x7c, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257C (╼)
}; // 1

static const unsigned char scientificai_block67[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x7c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257E (╾)
}; // 1

static const unsigned char scientificai_block68[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00 },	// U+2581 (▁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x00, 0x00 },	// U+2582 (▂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00 },	// U+2583 (▃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00 },	// U+2584 (▄)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00 },	// U+2585 (▅)
	{ 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00 },	// U+2586 (▆)
	{ 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00 },	// U+2587 (▇)
	{ 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00 },	// U+2588 (█)
	{ 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00 },	// U+2589 (▉)
	{ 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00 },	// U+258A (▊)
}; // 10

static const unsigned char scientificai_block69[][12] = {
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+258F (▏)
}; // 1

static const unsigned char scientificai_block70[][12] = {
	{ 0x00, 0x44, 0x10, 0x44, 0x10, 0x44, 0x10, 0x44, 0x10, 0x44, 0x00, 0x00 },	// U+2591 (░)
	{ 0x00, 0x54, 0x28, 0x54, 0x28, 0x54, 0x28, 0x54, 0x28, 0x54, 0x00, 0x00 },	// U+2592 (▒)
	{ 0x00, 0x54, 0x7c, 0x54, 0x7c, 0x54, 0x7c, 0x54, 0x7c, 0x54, 0x00, 0x00 },	// U+2593 (▓)
}; // 3

static const unsigned char scientificai_block71[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00 },	// U+25A1 (□)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+25A2 (▢)
}; // 2

static const unsigned char scientificai_block72[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00 },	// U+25AA (▪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x3c, 0x00, 0x00, 0x00 },	// U+25AB (▫)
}; // 2

static const unsigned char scientificai_block73[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x7c, 0x00, 0x00, 0x00 },	// U+25B2 (▲)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x7c, 0x00, 0x00, 0x00 },	// U+25B3 (△)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0x00, 0x00, 0x00 },	// U+25B4 (▴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x7c, 0x00, 0x00, 0x00 },	// U+25B5 (▵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1c, 0x7c, 0x1c, 0x04, 0x00, 0x00 },	// U+25B6 (▶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1c, 0x64, 0x1c, 0x04, 0x00, 0x00 },	// U+25B7 (▷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x1c, 0x0c, 0x04, 0x00, 0x00 },	// U+25B8 (▸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x14, 0x0c, 0x04, 0x00, 0x00 },	// U+25B9 (▹)
}; // 8

static const unsigned char scientificai_block74[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+25BC (▼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+25BD (▽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+25BE (▾)
}; // 3

static const unsigned char scientificai_block75[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x70, 0x7c, 0x70, 0x40, 0x00, 0x00 },	// U+25C0 (◀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x70, 0x4c, 0x70, 0x40, 0x00, 0x00 },	// U+25C1 (◁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x1c, 0x18, 0x10, 0x00, 0x00 },	// U+25C2 (◂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x18, 0x10, 0x00, 0x00 },	// U+25C3 (◃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25C4 (◄)
}; // 5

static const unsigned char scientificai_block76[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+25CB (○)
}; // 1

static const unsigned char scientificai_block77[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x54, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+25CE (◎)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x7c, 0x7c, 0x7c, 0x38, 0x00, 0x00, 0x00 },	// U+25CF (●)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x5c, 0x5c, 0x5c, 0x38, 0x00, 0x00, 0x00 },	// U+25D0 (◐)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x74, 0x74, 0x74, 0x38, 0x00, 0x00, 0x00 },	// U+25D1 (◑)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x7c, 0x7c, 0x38, 0x00, 0x00, 0x00 },	// U+25D2 (◒)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x7c, 0x7c, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+25D3 (◓)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x74, 0x74, 0x44, 0x38, 0x00, 0x00, 0x00 },	// U+25D4 (◔)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x64, 0x64, 0x7c, 0x38, 0x00, 0x00, 0x00 },	// U+25D5 (◕)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0c, 0x0c, 0x08, 0x00, 0x00, 0x00 },	// U+25D6 (◖)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x60, 0x60, 0x60, 0x20, 0x00, 0x00, 0x00 },	// U+25D7 (◗)
}; // 10

static const unsigned char scientificai_block78[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x5c, 0x5c, 0x5c, 0x7c, 0x00, 0x00 },	// U+25E7 (◧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x74, 0x74, 0x74, 0x7c, 0x00, 0x00 },	// U+25E8 (◨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x5c, 0x4c, 0x7c, 0x00, 0x00 },	// U+25E9 (◩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x64, 0x74, 0x7c, 0x7c, 0x00, 0x00 },	// U+25EA (◪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x54, 0x54, 0x54, 0x7c, 0x00, 0x00 },	// U+25EB (◫)
}; // 5

static const unsigned char scientificai_block79[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x54, 0x5c, 0x44, 0x7c, 0x00, 0x00 },	// U+25F0 (◰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x5c, 0x54, 0x7c, 0x00, 0x00 },	// U+25F1 (◱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x74, 0x54, 0x7c, 0x00, 0x00 },	// U+25F2 (◲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x54, 0x74, 0x44, 0x7c, 0x00, 0x00 },	// U+25F3 (◳)
}; // 4

static const unsigned char scientificai_block80[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x54, 0x38, 0x7c, 0x38, 0x54, 0x10, 0x00 },	// U+2600 (☀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x38, 0x7c, 0x7c, 0x00, 0x00, 0x00 },	// U+2601 (☁)
	{ 0x00, 0x00, 0x00, 0x38, 0x7c, 0x7c, 0x10, 0x10, 0x14, 0x14, 0x08, 0x00 },	// U+2602 (☂)
}; // 3

static const unsigned char scientificai_block81[][12] = {
	{ 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x7c, 0x00, 0x00 },	// U+2630 (☰)
	{ 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x7c, 0x00, 0x00 },	// U+2631 (☱)
	{ 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x7c, 0x00, 0x00 },	// U+2632 (☲)
	{ 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x7c, 0x00, 0x00 },	// U+2633 (☳)
	{ 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x6c, 0x00, 0x00 },	// U+2634 (☴)
	{ 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x6c, 0x00, 0x00 },	// U+2635 (☵)
	{ 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x6c, 0x00, 0x00 },	// U+2636 (☶)
	{ 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x6c, 0x00, 0x00 },	// U+2637 (☷)
}; // 8

static const unsigned char scientificai_block82[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x54, 0x44, 0x28, 0x10, 0x00, 0x00 },	// U+2661 (♡)
}; // 1

static const unsigned char scientificai_block83[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x7c, 0x7c, 0x38, 0x10, 0x00, 0x00 },	// U+2665 (♥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0x38, 0x10, 0x00, 0x00 },	// U+2666 (♦)
}; // 2

static const unsigned char scientificai_block84[][12] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0c, 0x0c, 0x00, 0x00 },	// U+2669 (♩)
	{ 0x00, 0x00, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x0c, 0x0c, 0x00, 0x00 },	// U+266A (♪)
	{ 0x00, 0x00, 0x18, 0x68, 0x48, 0x48, 0x48, 0x4c, 0x6c, 0x60, 0x00, 0x00 },	// U+266B (♫)
	{ 0x00, 0x00, 0x48, 0x78, 0x48, 0x78, 0x48, 0x48, 0x6c, 0x6c, 0x00, 0x00 },	// U+266C (♬)
}; // 4

static const unsigned char scientificai_block85[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x00, 0x44, 0x44, 0x28, 0x00, 0x00 },	// U+267A (♺)
}; // 1

static const unsigned char scientificai_block86[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+26AA (⚪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00 },	// U+26AB (⚫)
}; // 2

static const unsigned char scientificai_block87[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x24, 0x18, 0x10, 0x00, 0x00 },	// U+2713 (✓)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x60, 0x24, 0x3c, 0x18, 0x10, 0x00, 0x00 },	// U+2714 (✔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00 },	// U+2715 (✕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x7c, 0x38, 0x7c, 0x6c, 0x00, 0x00 },	// U+2716 (✖)
	{ 0x00, 0x00, 0x20, 0x20, 0x14, 0x18, 0x18, 0x18, 0x24, 0x24, 0x00, 0x00 },	// U+2717 (✗)
	{ 0x00, 0x00, 0x20, 0x20, 0x14, 0x14, 0x18, 0x18, 0x24, 0x24, 0x00, 0x00 },	// U+2718 (✘)
}; // 6

static const unsigned char scientificai_block88[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x38, 0x38, 0x44, 0x00, 0x00 },	// U+272E (✮)
}; // 1

static const unsigned char scientificai_block89[][12] = {
	{ 0x00, 0x00, 0x00, 0x10, 0x6c, 0x54, 0x38, 0x54, 0x6c, 0x10, 0x00, 0x00 },	// U+2744 (❄)
}; // 1

static const unsigned char scientificai_block90[][12] = {
	{ 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00 },	// U+276E (❮)
	{ 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x00 },	// U+276F (❯)
	{ 0x00, 0x00, 0x00, 0x70, 0x38, 0x1c, 0x0c, 0x1c, 0x38, 0x70, 0x00, 0x00 },	// U+2770 (❰)
	{ 0x00, 0x00, 0x00, 0x1c, 0x38, 0x70, 0x60, 0x70, 0x38, 0x1c, 0x00, 0x00 },	// U+2771 (❱)
}; // 4

static const unsigned char scientificai_block91[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+27C2 (⟂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x14, 0x04, 0x38, 0x00, 0x00 },	// U+27C3 (⟃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x28, 0x20, 0x1c, 0x00, 0x00 },	// U+27C4 (⟄)
}; // 3

static const unsigned char scientificai_block92[][12] = {
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00 },	// U+27D8 (⟘)
	{ 0x00, 0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+27D9 (⟙)
}; // 2

static const unsigned char scientificai_block93[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x74, 0x08, 0x00, 0x00, 0x00 },	// U+27DC (⟜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0x04, 0x00, 0x00, 0x00 },	// U+27DD (⟝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x7c, 0x40, 0x00, 0x00, 0x00 },	// U+27DE (⟞)
}; // 3

static const unsigned char scientificai_block94[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04 },	// U+2864 (⡤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04 },	// U+2865 (⡥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x04 },	// U+2866 (⡦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x14, 0x00, 0x04 },	// U+2867 (⡧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04 },	// U+2868 (⡨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04 },	// U+2869 (⡩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x10, 0x00, 0x04 },	// U+286A (⡪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x10, 0x00, 0x04 },	// U+286B (⡫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04 },	// U+286C (⡬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x14, 0x00, 0x04 },	// U+286D (⡭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x14, 0x00, 0x04 },	// U+286E (⡮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x14, 0x00, 0x04 },	// U+286F (⡯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x04 },	// U+2870 (⡰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x10, 0x00, 0x04 },	// U+2871 (⡱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x04 },	// U+2872 (⡲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x10, 0x00, 0x04 },	// U+2873 (⡳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x04 },	// U+2874 (⡴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x14, 0x00, 0x04 },	// U+2875 (⡵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x04 },	// U+2876 (⡶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x14, 0x00, 0x04 },	// U+2877 (⡷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x04 },	// U+2878 (⡸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x10, 0x00, 0x04 },	// U+2879 (⡹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x10, 0x00, 0x04 },	// U+287A (⡺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x10, 0x00, 0x04 },	// U+287B (⡻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x14, 0x00, 0x04 },	// U+287C (⡼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x14, 0x00, 0x04 },	// U+287D (⡽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x14, 0x00, 0x04 },	// U+287E (⡾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x14, 0x00, 0x04 },	// U+287F (⡿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10 },	// U+2880 (⢀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10 },	// U+2881 (⢁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x10 },	// U+2882 (⢂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x10 },	// U+2883 (⢃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10 },	// U+2884 (⢄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10 },	// U+2885 (⢅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x10 },	// U+2886 (⢆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x10 },	// U+2887 (⢇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04 },	// U+2888 (⢈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10 },	// U+2889 (⢉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00, 0x10 },	// U+288A (⢊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x00, 0x00, 0x10 },	// U+288B (⢋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10 },	// U+288C (⢌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x04, 0x00, 0x10 },	// U+288D (⢍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x04, 0x00, 0x10 },	// U+288E (⢎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x04, 0x00, 0x10 },	// U+288F (⢏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04 },	// U+2890 (⢐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10 },	// U+2891 (⢑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x10 },	// U+2892 (⢒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x00, 0x00, 0x10 },	// U+2893 (⢓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x10 },	// U+2894 (⢔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x04, 0x00, 0x10 },	// U+2895 (⢕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x10 },	// U+2896 (⢖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x04, 0x00, 0x10 },	// U+2897 (⢗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04 },	// U+2898 (⢘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10 },	// U+2899 (⢙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x00, 0x00, 0x10 },	// U+289A (⢚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00, 0x10 },	// U+289B (⢛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x04, 0x00, 0x10 },	// U+289C (⢜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x04, 0x00, 0x10 },	// U+289D (⢝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x04, 0x00, 0x10 },	// U+289E (⢞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x04, 0x00, 0x10 },	// U+289F (⢟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04 },	// U+28A0 (⢠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10 },	// U+28A1 (⢡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x10 },	// U+28A2 (⢢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x10, 0x00, 0x10 },	// U+28A3 (⢣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10 },	// U+28A4 (⢤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10 },	// U+28A5 (⢥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x10 },	// U+28A6 (⢦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x14, 0x00, 0x10 },	// U+28A7 (⢧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04 },	// U+28A8 (⢨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10 },	// U+28A9 (⢩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x10, 0x00, 0x10 },	// U+28AA (⢪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x10, 0x00, 0x10 },	// U+28AB (⢫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10 },	// U+28AC (⢬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10 },	// U+28AD (⢭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x14, 0x00, 0x10 },	// U+28AE (⢮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x14, 0x00, 0x10 },	// U+28AF (⢯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10 },	// U+28B0 (⢰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10 },	// U+28B1 (⢱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x10 },	// U+28B2 (⢲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x10, 0x00, 0x10 },	// U+28B3 (⢳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x10 },	// U+28B4 (⢴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x14, 0x00, 0x10 },	// U+28B5 (⢵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x10 },	// U+28B6 (⢶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x14, 0x00, 0x10 },	// U+28B7 (⢷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04 },	// U+28B8 (⢸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10 },	// U+28B9 (⢹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x10, 0x00, 0x10 },	// U+28BA (⢺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x10, 0x00, 0x10 },	// U+28BB (⢻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x14, 0x00, 0x10 },	// U+28BC (⢼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x14, 0x00, 0x10 },	// U+28BD (⢽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x14, 0x00, 0x10 },	// U+28BE (⢾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x14, 0x00, 0x10 },	// U+28BF (⢿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14 },	// U+28C0 (⣀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14 },	// U+28C1 (⣁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x14 },	// U+28C2 (⣂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x14 },	// U+28C3 (⣃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14 },	// U+28C4 (⣄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14 },	// U+28C5 (⣅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x14 },	// U+28C6 (⣆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x14 },	// U+28C7 (⣇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14 },	// U+28C8 (⣈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14 },	// U+28C9 (⣉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00, 0x14 },	// U+28CA (⣊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x00, 0x00, 0x14 },	// U+28CB (⣋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14 },	// U+28CC (⣌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14 },	// U+28CD (⣍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x04, 0x00, 0x14 },	// U+28CE (⣎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x04, 0x00, 0x14 },	// U+28CF (⣏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x14 },	// U+28D0 (⣐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x00, 0x00, 0x14 },	// U+28D1 (⣑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14 },	// U+28D2 (⣒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14 },	// U+28D3 (⣓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x14 },	// U+28D4 (⣔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x04, 0x00, 0x14 },	// U+28D5 (⣕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x14 },	// U+28D6 (⣖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x04, 0x00, 0x14 },	// U+28D7 (⣗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x14 },	// U+28D8 (⣘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x00, 0x00, 0x14 },	// U+28D9 (⣙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14 },	// U+28DA (⣚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14 },	// U+28DB (⣛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x04, 0x00, 0x14 },	// U+28DC (⣜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x04, 0x00, 0x14 },	// U+28DD (⣝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x04, 0x00, 0x14 },	// U+28DE (⣞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x04, 0x00, 0x14 },	// U+28DF (⣟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14 },	// U+28E0 (⣠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14 },	// U+28E1 (⣡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x14 },	// U+28E2 (⣢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x10, 0x00, 0x14 },	// U+28E3 (⣣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14 },	// U+28E4 (⣤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x14, 0x00, 0x14 },	// U+28E5 (⣥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x14 },	// U+28E6 (⣦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x14, 0x00, 0x14 },	// U+28E7 (⣧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14 },	// U+28E8 (⣨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14 },	// U+28E9 (⣩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x10, 0x00, 0x14 },	// U+28EA (⣪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x10, 0x00, 0x14 },	// U+28EB (⣫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14 },	// U+28EC (⣬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x14, 0x00, 0x14 },	// U+28ED (⣭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x00, 0x14, 0x00, 0x14 },	// U+28EE (⣮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x14, 0x00, 0x14 },	// U+28EF (⣯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x14 },	// U+28F0 (⣰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x10, 0x00, 0x14 },	// U+28F1 (⣱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x14 },	// U+28F2 (⣲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x10, 0x00, 0x14 },	// U+28F3 (⣳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x14 },	// U+28F4 (⣴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x14, 0x00, 0x14 },	// U+28F5 (⣵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x14 },	// U+28F6 (⣶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x14, 0x00, 0x14, 0x00, 0x14 },	// U+28F7 (⣷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x14 },	// U+28F8 (⣸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x10, 0x00, 0x14 },	// U+28F9 (⣹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x10, 0x00, 0x14 },	// U+28FA (⣺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x10, 0x00, 0x14 },	// U+28FB (⣻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x14, 0x00, 0x14 },	// U+28FC (⣼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x10, 0x00, 0x14, 0x00, 0x14 },	// U+28FD (⣽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x14, 0x00, 0x14, 0x00, 0x14 },	// U+28FE (⣾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x14, 0x00, 0x14 },	// U+28FF (⣿)
}; // 156

static const unsigned char scientificai_block95[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x1c, 0x20, 0x40, 0x00, 0x00 },	// U+2919 (⤙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x70, 0x08, 0x04, 0x00, 0x00 },	// U+291A (⤚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x24, 0x10, 0x24, 0x48, 0x00, 0x00 },	// U+291B (⤛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x48, 0x10, 0x48, 0x24, 0x00, 0x00 },	// U+291C (⤜)
}; // 4

static const unsigned char scientificai_block96[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+2B5E (⭞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+2B5F (⭟)
	{ 0x00, 0x04, 0x04, 0x14, 0x3c, 0x14, 0x14, 0x1c, 0x04, 0x04, 0x00, 0x00 },	// U+2B60 (⭠)
	{ 0x00, 0x04, 0x04, 0x04, 0x1c, 0x00, 0x18, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+2B61 (⭡)
	{ 0x00, 0x00, 0x18, 0x08, 0x0c, 0x28, 0x68, 0x2c, 0x20, 0x60, 0x00, 0x00 },	// U+2B62 (⭢)
}; // 5

static const unsigned char scientificai_block97[][12] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x3c, 0x2c, 0x3c, 0x00, 0x00 },	// U+2B64 (⭤)
}; // 1

static const unsigned char scientificai_block98[][12] = {
	{ 0x00, 0x04, 0x0c, 0x1c, 0x3c, 0x7c, 0x3c, 0x1c, 0x0c, 0x04, 0x00, 0x00 },	// U+2B80 (⮀)
	{ 0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00 },	// U+2B81 (⮁)
	{ 0x00, 0x40, 0x60, 0x70, 0x78, 0x7c, 0x78, 0x70, 0x60, 0x40, 0x00, 0x00 },	// U+2B82 (⮂)
	{ 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00 },	// U+2B83 (⮃)
}; // 4

static const unsigned char scientificai_block99[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x24, 0x18, 0x00, 0x00 },	// U+30C3 (ッ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x24, 0x24, 0x18, 0x00, 0x00 },	// U+30C4 (ツ)
}; // 2

static const unsigned char scientificai_block100[][12] = {
	{ 0x00, 0x00, 0x00, 0x74, 0x14, 0x14, 0x7c, 0x50, 0x50, 0x5c, 0x00, 0x00 },	// U+5350 (卐)
}; // 1

static const unsigned char scientificai_block101[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x00, 0x00 },	// U+E09E ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+E09F ()
	{ 0x00, 0x00, 0x04, 0x14, 0x34, 0x14, 0x14, 0x0c, 0x04, 0x04, 0x00, 0x00 },	// U+E0A0 ()
	{ 0x00, 0x04, 0x04, 0x04, 0x1c, 0x00, 0x18, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+E0A1 ()
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x2c, 0x2c, 0x3c, 0x00, 0x00 },	// U+E0A2 ()
}; // 5

static const unsigned char scientificai_block102[][12] = {
	{ 0x00, 0x00, 0x04, 0x0c, 0x1c, 0x3c, 0x7c, 0x3c, 0x1c, 0x0c, 0x04, 0x00 },	// U+E0B0 ()
	{ 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00 },	// U+E0B1 ()
	{ 0x00, 0x00, 0x40, 0x60, 0x70, 0x78, 0x7c, 0x78, 0x70, 0x60, 0x40, 0x00 },	// U+E0B2 ()
	{ 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00 },	// U+E0B3 ()
	{ 0x00, 0x7c, 0x78, 0x70, 0x60, 0x40, 0x00, 0x40, 0x60, 0x70, 0x78, 0x7c },	// U+E0B4 ()
	{ 0x00, 0x7c, 0x3c, 0x1c, 0x0c, 0x04, 0x00, 0x04, 0x0c, 0x1c, 0x3c, 0x7c },	// U+E0B5 ()
}; // 6

static const unsigned char scientificai_block103[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x28, 0x54, 0x48, 0x00, 0x00 },	// U+E0C0 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x20, 0x10, 0x00, 0x00 },	// U+E0C1 ()
	{ 0x00, 0x00, 0x00, 0x28, 0x28, 0x7c, 0x38, 0x38, 0x10, 0x10, 0x10, 0x00 },	// U+E0C2 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x78, 0x00, 0x78, 0x04, 0x00, 0x00 },	// U+E0C3 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x68, 0x10, 0x68, 0x14, 0x00, 0x00 },	// U+E0C4 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x3c, 0x00, 0x3c, 0x40, 0x00, 0x00 },	// U+E0C5 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x2c, 0x10, 0x2c, 0x50, 0x00, 0x00 },	// U+E0C6 ()
}; // 7

static const unsigned char scientificai_block104[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x08, 0x10, 0x00, 0x00 },	// U+E0D1 ()
}; // 1

static const unsigned char scientificai_block105[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x24, 0x24, 0x3c, 0x00, 0x00 },	// U+F031 ()
}; // 1

static const unsigned char scientificai_block106[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x1c, 0x18, 0x10, 0x00, 0x00 },	// U+F033 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x1c, 0x0c, 0x04, 0x00, 0x00 },	// U+F034 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0x00, 0x00, 0x00 },	// U+F035 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+F036 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x3c, 0x28, 0x00, 0x00, 0x00 },	// U+F037 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x3c, 0x14, 0x00, 0x00, 0x00 },	// U+F038 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x54, 0x7c, 0x54, 0x04, 0x00, 0x00 },	// U+F039 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x54, 0x7c, 0x54, 0x40, 0x00, 0x00 },	// U+F03A ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+F03B ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00 },	// U+F03C ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00 },	// U+F03D ()
}; // 11

static const unsigned char scientificai_block107[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x3c, 0x3c, 0x3c, 0x0c, 0x04, 0x00 },	// U+F057 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x3c, 0x3c, 0x3c, 0x30, 0x20, 0x00 },	// U+F058 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x7c, 0x7c, 0x38, 0x10, 0x00, 0x00 },	// U+F059 ()
}; // 3

static const unsigned char scientificai_block108[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x6c, 0x38, 0x10, 0x00, 0x00 },	// U+F061 ()
}; // 1

static const unsigned char scientificai_block109[][12] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x3c, 0x64, 0x64, 0x30, 0x18, 0x18, 0x00, 0x18 },	// U+F073 ()
}; // 1

static const unsigned char scientificai_block110[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x4c, 0x54, 0x64, 0x38, 0x00, 0x00 },	// U+F078 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x7c, 0x44, 0x38, 0x00, 0x00 },	// U+F079 ()
}; // 2

static const unsigned char scientificai_block111[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x38, 0x1c, 0x08, 0x04, 0x00, 0x00 },	// U+F07E ()
}; // 1

static const unsigned char scientificai_block112[][12] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x3c, 0x2c, 0x2c, 0x3c, 0x00, 0x00 },	// U+F0CF ()
	{ 0x00, 0x00, 0x18, 0x24, 0x20, 0x20, 0x3c, 0x2c, 0x2c, 0x3c, 0x00, 0x00 },	// U+F0D0 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x08, 0x08, 0x08, 0x14, 0x08, 0x00 },	// U+F0D1 ()
}; // 3

static const unsigned char scientificai_block113[][12] = {
	{ 0x00, 0x00, 0x00, 0x10, 0x48, 0x3c, 0x64, 0x24, 0x3c, 0x54, 0x00, 0x00 },	// U+F0D5 ()
	{ 0x00, 0x00, 0x20, 0x14, 0x48, 0x3c, 0x64, 0x74, 0x7c, 0x7c, 0x00, 0x00 },	// U+F0D6 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x64, 0x74, 0x78, 0x00, 0x00, 0x00, 0x00 },	// U+F0D7 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x64, 0x74, 0x78, 0x00, 0x50, 0x28, 0x00 },	// U+F0D8 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x78, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F0D9 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x78, 0x7c, 0x00, 0x54, 0x00, 0x28, 0x00 },	// U+F0DA ()
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x78, 0x7c, 0x00, 0x54, 0x28, 0x00, 0x00 },	// U+F0DB ()
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x78, 0x7c, 0x20, 0x30, 0x10, 0x08, 0x00 },	// U+F0DC ()
}; // 8

static const unsigned char scientificai_block114[][12] = {
	{ 0x00, 0x00, 0x28, 0x14, 0x00, 0x20, 0x50, 0x00, 0x28, 0x14, 0x00, 0x00 },	// U+F0DE ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x28, 0x54, 0x28, 0x54, 0x00, 0x00 },	// U+F0DF ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x74, 0x64, 0x64, 0x38, 0x00, 0x00 },	// U+F0E0 ()
}; // 3

static const unsigned char scientificai_block115[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x44, 0x28, 0x00, 0x00 },	// U+F0ED ()
	{ 0x00, 0x00, 0x28, 0x44, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F0EE ()
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x00, 0x18, 0x00, 0x20, 0x10, 0x00 },	// U+F0EF ()
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x18, 0x00, 0x04, 0x08, 0x00 },	// U+F0F0 ()
}; // 4

