/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font orp-6x12b.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char orpb_block1[][12] = {
	{ 0x00, 0x00, 0x00, 0x15, 0x00, 0x11, 0x00, 0x11, 0x00, 0x15, 0x00, 0x00 },	// U+0000 (ESC)
}; // 1

static const unsigned char orpb_block2[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x00, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x00, 0x00, 0x04, 0x1e, 0x07, 0x0e, 0x1c, 0x0f, 0x04, 0x00, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x00, 0x13, 0x1b, 0x0c, 0x06, 0x1b, 0x19, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x00, 0x02, 0x05, 0x05, 0x02, 0x15, 0x09, 0x16, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x00, 0x18, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x18, 0x00 },	// U+0028 (()
	{ 0x00, 0x00, 0x06, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x06, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x3f, 0x3f, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x03, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x03, 0x00, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x11, 0x15, 0x11, 0x1f, 0x0e, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0e, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x18, 0x18, 0x0c, 0x06, 0x1f, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x00, 0x1f, 0x18, 0x0c, 0x1e, 0x18, 0x1b, 0x0e, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0e, 0x0b, 0x1f, 0x0c, 0x1e, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x00, 0x1f, 0x03, 0x0f, 0x18, 0x18, 0x1b, 0x0e, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x00, 0x1e, 0x03, 0x0f, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x00, 0x1f, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x06, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x0e, 0x1b, 0x1b, 0x0e, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x0e, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x03, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0x03, 0x06, 0x0c, 0x00, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x18, 0x0c, 0x0c, 0x00, 0x0c, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1d, 0x15, 0x1d, 0x01, 0x0e, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x0f, 0x1b, 0x1b, 0x0f, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x03, 0x03, 0x03, 0x1b, 0x0e, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0f, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x00, 0x1f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x1f, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x00, 0x3f, 0x03, 0x03, 0x0f, 0x03, 0x03, 0x03, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x03, 0x1b, 0x1b, 0x1b, 0x1e, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1f, 0x1b, 0x1b, 0x1b, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0f, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x00, 0x1b, 0x0f, 0x07, 0x07, 0x0f, 0x1b, 0x1b, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1f, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1f, 0x1f, 0x15, 0x1b, 0x1b, 0x1b, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x00, 0x11, 0x13, 0x17, 0x1b, 0x13, 0x13, 0x13, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x0f, 0x03, 0x03, 0x03, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x1b, 0x1f, 0x0e, 0x10, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x1b, 0x1f, 0x0b, 0x1b, 0x1b, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x03, 0x0e, 0x18, 0x1b, 0x0e, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x00, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x04, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x15, 0x1f, 0x1b, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x0e, 0x04, 0x0e, 0x1b, 0x1b, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x00, 0x12, 0x12, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x00, 0x1f, 0x18, 0x1c, 0x0e, 0x07, 0x03, 0x1f, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x00, 0x1e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1e, 0x00 },	// U+005B ([)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x30, 0x00, 0x00 },	// U+005C (\)
	{ 0x00, 0x00, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1e, 0x00 },	// U+005D (])
	{ 0x00, 0x00, 0x04, 0x0e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f },	// U+005F (_)
	{ 0x00, 0x00, 0x02, 0x06, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1b, 0x1b, 0x1f, 0x16, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x0f, 0x1b, 0x1b, 0x1b, 0x0d, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x13, 0x03, 0x03, 0x1e, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x1e, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1f, 0x03, 0x1e, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x3c, 0x06, 0x06, 0x1f, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x1b, 0x1b, 0x1b, 0x1e, 0x19, 0x0e },	// U+0067 (g)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x0f, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x00, 0x06, 0x00, 0x07, 0x06, 0x06, 0x06, 0x1c, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x07 },	// U+006A (j)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x1b, 0x1b, 0x0f, 0x1f, 0x1b, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x00, 0x07, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1c, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1b, 0x1b, 0x1b, 0x0f, 0x03, 0x03 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x1b, 0x1b, 0x1b, 0x1e, 0x18, 0x18 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1b, 0x03, 0x03, 0x03, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x03, 0x1f, 0x18, 0x0f, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x1f, 0x06, 0x06, 0x06, 0x1c, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x16, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x0e, 0x0e, 0x04, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x1f, 0x0e, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x0e, 0x04, 0x0e, 0x1b, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x06, 0x03 },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x0e, 0x03, 0x1f, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x00, 0x18, 0x0c, 0x0c, 0x0c, 0x07, 0x0c, 0x0c, 0x0c, 0x18, 0x00 },	// U+007B ({)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00 },	// U+007C (|)
	{ 0x00, 0x00, 0x06, 0x0c, 0x0c, 0x0c, 0x38, 0x0c, 0x0c, 0x0c, 0x06, 0x00 },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x3f, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
}; // 95

static const unsigned char orpb_block3[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x05, 0x15, 0x0e, 0x04, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x02, 0x07, 0x02, 0x12, 0x0d, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0a, 0x11, 0x0a, 0x15, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0x00, 0x11, 0x0a, 0x1f, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x00, 0x1c, 0x02, 0x0c, 0x12, 0x12, 0x0c, 0x10, 0x0e, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x1e, 0x21, 0x29, 0x25, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x0c, 0x0a, 0x0c, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x05, 0x0a, 0x14, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x00, 0x00, 0x00, 0x1e, 0x21, 0x2d, 0x25, 0x25, 0x21, 0x1e, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x1f, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x04, 0x0a, 0x08, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x06, 0x08, 0x04, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x00, 0x00, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x19, 0x17, 0x01, 0x01 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x1e, 0x17, 0x17, 0x17, 0x16, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x06 },	// U+00B8 (¸)
	{ 0x04, 0x06, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x04, 0x0a, 0x04, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x14, 0x0a, 0x05, 0x00, 0x00 },	// U+00BB (»)
	{ 0x02, 0x03, 0x02, 0x02, 0x0a, 0x0c, 0x0a, 0x1e, 0x08, 0x08, 0x00, 0x00 },	// U+00BC (¼)
	{ 0x02, 0x03, 0x02, 0x02, 0x0a, 0x14, 0x10, 0x08, 0x04, 0x1c, 0x00, 0x00 },	// U+00BD (½)
	{ 0x03, 0x04, 0x02, 0x04, 0x0b, 0x0c, 0x0a, 0x1e, 0x08, 0x08, 0x00, 0x00 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x02, 0x11, 0x0e, 0x00, 0x00 },	// U+00BF (¿)
	{ 0x02, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x16, 0x0d, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x04, 0x0a, 0x04, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x00, 0x1e, 0x05, 0x05, 0x0f, 0x05, 0x05, 0x1d, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x08, 0x06 },	// U+00C7 (Ç)
	{ 0x02, 0x04, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x08, 0x04, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x04, 0x0a, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x00, 0x0a, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x02, 0x04, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x08, 0x04, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x04, 0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x17, 0x12, 0x12, 0x0e, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x16, 0x0d, 0x00, 0x11, 0x11, 0x13, 0x15, 0x19, 0x11, 0x11, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x02, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x16, 0x0d, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x00, 0x10, 0x0e, 0x19, 0x15, 0x15, 0x15, 0x13, 0x0e, 0x01, 0x00 },	// U+00D8 (Ø)
	{ 0x02, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x08, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x08, 0x04, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x00, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x0e, 0x02, 0x00, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x09, 0x05, 0x09, 0x11, 0x0d, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x14, 0x0e, 0x05, 0x1e, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x11, 0x0e, 0x08, 0x06 },	// U+00E7 (ç)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x0a, 0x04, 0x0a, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x19, 0x15, 0x13, 0x0f, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x02, 0x01 },	// U+00FD (ý)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x02, 0x01 },	// U+00FF (ÿ)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+0101 (ā)
	{ 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x08, 0x10 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x04, 0x0c },	// U+0105 (ą)
	{ 0x08, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x1e, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+010B (ċ)
	{ 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+010D (č)
	{ 0x0a, 0x04, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0f, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x28, 0x10, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x17, 0x12, 0x12, 0x0f, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x00, 0x10, 0x38, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x00, 0x0e, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+0113 (ē)
	{ 0x11, 0x0e, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0114 (Ĕ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+0115 (ĕ)
	{ 0x00, 0x04, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x04, 0x0c },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x04, 0x0c },	// U+0119 (ę)
	{ 0x0a, 0x04, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+011B (ě)
	{ 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e },	// U+011D (ĝ)
	{ 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e },	// U+011F (ğ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x19, 0x11, 0x0e, 0x08, 0x06 },	// U+0122 (Ģ)
	{ 0x00, 0x04, 0x02, 0x06, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e },	// U+0123 (ģ)
	{ 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x04, 0x0a, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x00, 0x12, 0x3f, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0x14, 0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x00, 0x0a, 0x05, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+012B (ī)
	{ 0x11, 0x0e, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+012C (Ĭ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+012D (ĭ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x04, 0x0c },	// U+012E (Į)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x04, 0x0c },	// U+012F (į)
	{ 0x00, 0x04, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0131 (ı)
	{ 0x00, 0x00, 0x00, 0x19, 0x11, 0x11, 0x11, 0x11, 0x15, 0x09, 0x00, 0x00 },	// U+0132 (Ĳ)
	{ 0x00, 0x00, 0x00, 0x11, 0x00, 0x19, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0c },	// U+0133 (ĳ)
	{ 0x08, 0x14, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x07, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x00, 0x08, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06 },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x08, 0x06 },	// U+0136 (Ķ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x11, 0x09, 0x07, 0x09, 0x11, 0x08, 0x06 },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x08, 0x04, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x08, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x08, 0x06 },	// U+013B (Ļ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x08, 0x06 },	// U+013C (ļ)
	{ 0x0a, 0x04, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x0a, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+013E (ľ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x09, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+013F (Ŀ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x14, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0140 (ŀ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x06, 0x03, 0x02, 0x02, 0x1e, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x0c, 0x06, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x08, 0x04, 0x00, 0x11, 0x11, 0x13, 0x15, 0x19, 0x11, 0x11, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x13, 0x15, 0x19, 0x11, 0x11, 0x04, 0x02 },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x04, 0x02 },	// U+0146 (ņ)
	{ 0x0a, 0x04, 0x00, 0x11, 0x11, 0x13, 0x15, 0x19, 0x11, 0x11, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0148 (ň)
	{ 0x00, 0x00, 0x03, 0x02, 0x01, 0x0a, 0x16, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+0149 (ŉ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x13, 0x15, 0x19, 0x11, 0x11, 0x10, 0x0c },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x0c },	// U+014B (ŋ)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+014D (ō)
	{ 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+014E (Ŏ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+014F (ŏ)
	{ 0x12, 0x09, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x00, 0x12, 0x09, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x00, 0x1e, 0x05, 0x05, 0x0d, 0x05, 0x05, 0x1e, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x0d, 0x05, 0x1e, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x08, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x05, 0x09, 0x11, 0x04, 0x02 },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x04, 0x02 },	// U+0157 (ŗ)
	{ 0x0a, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x08, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00 },	// U+015B (ś)
	{ 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x08, 0x06 },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x08, 0x06 },	// U+015F (ş)
	{ 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x06 },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x18, 0x10, 0x0c },	// U+0163 (ţ)
	{ 0x0a, 0x04, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x0a, 0x04, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x00, 0x04, 0x1f, 0x04, 0x1f, 0x04, 0x04, 0x18, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0x16, 0x0d, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+016B (ū)
	{ 0x11, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x04, 0x0a, 0x04, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+016F (ů)
	{ 0x12, 0x09, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x00, 0x12, 0x09, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x0c },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x0c },	// U+0173 (ų)
	{ 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x04, 0x0a, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x02, 0x01 },	// U+0177 (ŷ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x08, 0x04, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00 },	// U+017A (ź)
	{ 0x00, 0x04, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00 },	// U+017C (ż)
	{ 0x0a, 0x04, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00 },	// U+017E (ž)
	{ 0x00, 0x00, 0x00, 0x0c, 0x02, 0x02, 0x03, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+017F (ſ)
	{ 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00 },	// U+0180 (ƀ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x14, 0x0c, 0x14, 0x14, 0x0c, 0x00, 0x00 },	// U+0181 (Ɓ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x0f, 0x00, 0x00 },	// U+0182 (Ƃ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00 },	// U+0183 (ƃ)
	{ 0x00, 0x00, 0x00, 0x02, 0x03, 0x03, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00 },	// U+0184 (Ƅ)
	{ 0x00, 0x00, 0x00, 0x02, 0x03, 0x0e, 0x12, 0x12, 0x12, 0x0e, 0x00, 0x00 },	// U+0185 (ƅ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+0186 (Ɔ)
	{ 0x00, 0x00, 0x30, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+0187 (Ƈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x06, 0x09, 0x01, 0x09, 0x06, 0x00, 0x00 },	// U+0188 (ƈ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x17, 0x12, 0x12, 0x0f, 0x00, 0x00 },	// U+0189 (Ɖ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x14, 0x14, 0x14, 0x14, 0x0c, 0x00, 0x00 },	// U+018A (Ɗ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x1e, 0x00, 0x00 },	// U+018B (Ƌ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00 },	// U+018C (ƌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0e, 0x10, 0x11, 0x0e },	// U+018D (ƍ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x1e, 0x10, 0x10, 0x1f, 0x00, 0x00 },	// U+018E (Ǝ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+018F (Ə)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+0190 (Ɛ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x02, 0x02, 0x0e, 0x02, 0x02, 0x02, 0x01, 0x00 },	// U+0191 (Ƒ)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x04, 0x0e, 0x04, 0x04, 0x05, 0x02, 0x00 },	// U+0192 (ƒ)
	{ 0x00, 0x00, 0x30, 0x0e, 0x11, 0x01, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00 },	// U+0193 (Ɠ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x0a, 0x04, 0x00, 0x00 },	// U+0194 (Ɣ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x13, 0x15, 0x15, 0x15, 0x09, 0x00, 0x00 },	// U+0195 (ƕ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x00, 0x00 },	// U+0196 (Ɩ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0197 (Ɨ)
	{ 0x00, 0x00, 0x00, 0x19, 0x05, 0x03, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+0198 (Ƙ)
	{ 0x00, 0x00, 0x02, 0x05, 0x01, 0x11, 0x09, 0x07, 0x09, 0x11, 0x00, 0x00 },	// U+0199 (ƙ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+019A (ƚ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x04, 0x06, 0x04, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+019B (ƛ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1a, 0x00, 0x00 },	// U+019C (Ɯ)
	{ 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x16, 0x1a, 0x12, 0x12, 0x01, 0x00 },	// U+019D (Ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+019E (ƞ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+019F (Ɵ)
	{ 0x00, 0x00, 0x10, 0x16, 0x09, 0x09, 0x09, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+01A0 (Ơ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01A1 (ơ)
	{ 0x00, 0x00, 0x00, 0x02, 0x0d, 0x15, 0x15, 0x15, 0x15, 0x12, 0x00, 0x00 },	// U+01A2 (Ƣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x15, 0x15, 0x12, 0x00, 0x00 },	// U+01A3 (ƣ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+01A4 (Ƥ)
	{ 0x00, 0x00, 0x00, 0x02, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01 },	// U+01A5 (ƥ)
	{ 0x00, 0x00, 0x00, 0x01, 0x0f, 0x11, 0x11, 0x0f, 0x05, 0x09, 0x10, 0x00 },	// U+01A6 (Ʀ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0e, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+01A7 (Ƨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x0e, 0x01, 0x1e, 0x00, 0x00 },	// U+01A8 (ƨ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x02, 0x04, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00 },	// U+01A9 (Ʃ)
	{ 0x00, 0x00, 0x00, 0x02, 0x05, 0x0e, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00 },	// U+01AA (ƪ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x18, 0x10, 0x0c },	// U+01AB (ƫ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x05, 0x05, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+01AC (Ƭ)
	{ 0x00, 0x00, 0x18, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00 },	// U+01AD (ƭ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x18, 0x00 },	// U+01AE (Ʈ)
	{ 0x00, 0x00, 0x10, 0x19, 0x09, 0x09, 0x09, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+01AF (Ư)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x19, 0x09, 0x09, 0x0d, 0x0a, 0x00, 0x00 },	// U+01B0 (ư)
	{ 0x00, 0x00, 0x00, 0x0a, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01B1 (Ʊ)
	{ 0x00, 0x00, 0x00, 0x09, 0x09, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01B2 (Ʋ)
	{ 0x00, 0x00, 0x00, 0x11, 0x12, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+01B3 (Ƴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x15, 0x05, 0x05, 0x05, 0x06, 0x02, 0x01 },	// U+01B4 (ƴ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x1f, 0x02, 0x01, 0x1f, 0x00, 0x00 },	// U+01B5 (Ƶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x1f, 0x02, 0x1f, 0x00, 0x00 },	// U+01B6 (ƶ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+01B7 (Ʒ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x02, 0x04, 0x0e, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+01B8 (Ƹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x04, 0x0e, 0x01, 0x11, 0x0e },	// U+01B9 (ƹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x0c, 0x10, 0x0e, 0x11, 0x0e },	// U+01BA (ƺ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x08, 0x1e, 0x04, 0x02, 0x1f, 0x00, 0x00 },	// U+01BB (ƻ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x07, 0x08, 0x10, 0x10, 0x0f, 0x00, 0x00 },	// U+01BC (Ƽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x0e, 0x10, 0x0e, 0x00, 0x00 },	// U+01BD (ƽ)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x0c, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+01BE (ƾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x09, 0x05, 0x03, 0x01, 0x01 },	// U+01BF (ƿ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+01C0 (ǀ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+01C1 (ǁ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+01C2 (ǂ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00 },	// U+01C3 (ǃ)
	{ 0x14, 0x08, 0x00, 0x1b, 0x15, 0x15, 0x0d, 0x0d, 0x0d, 0x1b, 0x00, 0x00 },	// U+01C4 (Ǆ)
	{ 0x00, 0x14, 0x08, 0x03, 0x05, 0x1d, 0x15, 0x0d, 0x0d, 0x1b, 0x00, 0x00 },	// U+01C5 (ǅ)
	{ 0x14, 0x08, 0x00, 0x04, 0x04, 0x1e, 0x15, 0x0d, 0x0d, 0x1e, 0x00, 0x00 },	// U+01C6 (ǆ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x15, 0x0b, 0x00, 0x00 },	// U+01C7 (Ǉ)
	{ 0x00, 0x00, 0x00, 0x11, 0x01, 0x19, 0x11, 0x11, 0x11, 0x17, 0x10, 0x0c },	// U+01C8 (ǈ)
	{ 0x00, 0x00, 0x00, 0x13, 0x02, 0x1a, 0x12, 0x12, 0x12, 0x17, 0x10, 0x0c },	// U+01C9 (ǉ)
	{ 0x00, 0x00, 0x00, 0x13, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0d, 0x00, 0x00 },	// U+01CA (Ǌ)
	{ 0x00, 0x00, 0x00, 0x13, 0x05, 0x1d, 0x15, 0x15, 0x15, 0x15, 0x10, 0x0c },	// U+01CB (ǋ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x1b, 0x15, 0x15, 0x15, 0x15, 0x10, 0x0c },	// U+01CC (ǌ)
	{ 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+01CD (Ǎ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+01CE (ǎ)
	{ 0x0a, 0x04, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+01CF (Ǐ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+01D0 (ǐ)
	{ 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01D1 (Ǒ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01D2 (ǒ)
	{ 0x0a, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01D3 (Ǔ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01D4 (ǔ)
	{ 0x0e, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01D5 (Ǖ)
	{ 0x00, 0x0e, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01D6 (ǖ)
	{ 0x08, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01D7 (Ǘ)
	{ 0x08, 0x04, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01D8 (ǘ)
	{ 0x0a, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01D9 (Ǚ)
	{ 0x0a, 0x04, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01DA (ǚ)
	{ 0x02, 0x04, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01DB (Ǜ)
	{ 0x02, 0x04, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+01DC (ǜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x0e, 0x00, 0x00 },	// U+01DD (ǝ)
	{ 0x0e, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00 },	// U+01DE (Ǟ)
	{ 0x00, 0x0e, 0x00, 0x0a, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+01DF (ǟ)
	{ 0x0e, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00 },	// U+01E0 (Ǡ)
	{ 0x00, 0x0e, 0x00, 0x04, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+01E1 (ǡ)
	{ 0x00, 0x1e, 0x00, 0x1e, 0x05, 0x05, 0x0f, 0x05, 0x05, 0x1d, 0x00, 0x00 },	// U+01E2 (Ǣ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x14, 0x0e, 0x05, 0x1e, 0x00, 0x00 },	// U+01E3 (ǣ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x19, 0x11, 0x0e, 0x00, 0x00 },	// U+01E4 (Ǥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0x1f, 0x0e },	// U+01E5 (ǥ)
	{ 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00 },	// U+01E6 (Ǧ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e },	// U+01E7 (ǧ)
	{ 0x0a, 0x04, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+01E8 (Ǩ)
	{ 0x00, 0x0a, 0x04, 0x01, 0x01, 0x11, 0x09, 0x07, 0x09, 0x11, 0x00, 0x00 },	// U+01E9 (ǩ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x02, 0x0c },	// U+01EA (Ǫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x02, 0x0c },	// U+01EB (ǫ)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x02, 0x0c },	// U+01EC (Ǭ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x02, 0x0c },	// U+01ED (ǭ)
	{ 0x0a, 0x04, 0x00, 0x1f, 0x08, 0x04, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+01EE (Ǯ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1f, 0x08, 0x04, 0x0e, 0x10, 0x11, 0x0e },	// U+01EF (ǯ)
	{ 0x00, 0x00, 0x14, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x09, 0x06 },	// U+01F0 (ǰ)
	{ 0x00, 0x00, 0x00, 0x1b, 0x15, 0x15, 0x0d, 0x0d, 0x0d, 0x1b, 0x00, 0x00 },	// U+01F1 (Ǳ)
	{ 0x00, 0x00, 0x00, 0x03, 0x05, 0x1d, 0x15, 0x0d, 0x0d, 0x1b, 0x00, 0x00 },	// U+01F2 (ǲ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x15, 0x0d, 0x0d, 0x1e, 0x00, 0x00 },	// U+01F3 (ǳ)
	{ 0x08, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00 },	// U+01F4 (Ǵ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e },	// U+01F5 (ǵ)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x17, 0x15, 0x15, 0x15, 0x09, 0x00, 0x00 },	// U+01F6 (Ƕ)
	{ 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x09, 0x05, 0x03, 0x01, 0x00, 0x00 },	// U+01F7 (Ƿ)
	{ 0x02, 0x04, 0x00, 0x11, 0x11, 0x13, 0x15, 0x19, 0x11, 0x11, 0x00, 0x00 },	// U+01F8 (Ǹ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+01F9 (ǹ)
	{ 0x08, 0x04, 0x04, 0x0a, 0x04, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00 },	// U+01FA (Ǻ)
	{ 0x08, 0x04, 0x04, 0x0a, 0x04, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+01FB (ǻ)
	{ 0x08, 0x04, 0x00, 0x1e, 0x05, 0x05, 0x0f, 0x05, 0x05, 0x1d, 0x00, 0x00 },	// U+01FC (Ǽ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x14, 0x0e, 0x05, 0x1e, 0x00, 0x00 },	// U+01FD (ǽ)
	{ 0x08, 0x04, 0x10, 0x0e, 0x19, 0x15, 0x15, 0x15, 0x13, 0x0e, 0x01, 0x00 },	// U+01FE (Ǿ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1e, 0x19, 0x15, 0x13, 0x0f, 0x00, 0x00 },	// U+01FF (ǿ)
	{ 0x09, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0200 (Ȁ)
	{ 0x00, 0x00, 0x09, 0x12, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+0201 (ȁ)
	{ 0x0e, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0202 (Ȃ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+0203 (ȃ)
	{ 0x09, 0x12, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0204 (Ȅ)
	{ 0x00, 0x00, 0x09, 0x12, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+0205 (ȅ)
	{ 0x09, 0x12, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0206 (Ȇ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+0207 (ȇ)
	{ 0x09, 0x12, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0208 (Ȉ)
	{ 0x00, 0x00, 0x09, 0x12, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0209 (ȉ)
	{ 0x0e, 0x11, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+020A (Ȋ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+020B (ȋ)
	{ 0x09, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+020C (Ȍ)
	{ 0x00, 0x00, 0x09, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+020D (ȍ)
	{ 0x0e, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+020E (Ȏ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+020F (ȏ)
	{ 0x09, 0x12, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+0210 (Ȑ)
	{ 0x00, 0x00, 0x09, 0x12, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0211 (ȑ)
	{ 0x0e, 0x11, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+0212 (Ȓ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0213 (ȓ)
	{ 0x09, 0x12, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0214 (Ȕ)
	{ 0x00, 0x00, 0x09, 0x12, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0215 (ȕ)
	{ 0x0e, 0x11, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0216 (Ȗ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0217 (ȗ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x08, 0x04 },	// U+0218 (Ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x08, 0x04 },	// U+0219 (ș)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x04 },	// U+021A (Ț)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x18, 0x08, 0x04 },	// U+021B (ț)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x08, 0x14, 0x10, 0x10, 0x0f, 0x00, 0x00 },	// U+021C (Ȝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x08, 0x14, 0x10, 0x10, 0x0f },	// U+021D (ȝ)
	{ 0x0a, 0x04, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+021E (Ȟ)
	{ 0x00, 0x0a, 0x04, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+021F (ȟ)
	{ 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00 },	// U+0220 (Ƞ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x0e, 0x09, 0x19, 0x29, 0x1e, 0x04, 0x00 },	// U+0221 (ȡ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x11, 0x11, 0x0e, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0222 (Ȣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x0e, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0223 (ȣ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x10, 0x0c },	// U+0224 (Ȥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x10, 0x0c },	// U+0225 (ȥ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0226 (Ȧ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+0227 (ȧ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x10, 0x0c },	// U+0228 (Ȩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x10, 0x0c },	// U+0229 (ȩ)
	{ 0x0e, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+022A (Ȫ)
	{ 0x00, 0x0e, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+022B (ȫ)
	{ 0x0e, 0x16, 0x0d, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+022C (Ȭ)
	{ 0x0e, 0x00, 0x16, 0x0d, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+022D (ȭ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+022E (Ȯ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+022F (ȯ)
	{ 0x0e, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0230 (Ȱ)
	{ 0x00, 0x0e, 0x00, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0231 (ȱ)
	{ 0x00, 0x0e, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0232 (Ȳ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x02, 0x01 },	// U+0233 (ȳ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x14, 0x0c, 0x02, 0x00 },	// U+0234 (ȴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x19, 0x29, 0x19, 0x04, 0x00 },	// U+0235 (ȵ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x0c, 0x14, 0x0a, 0x00, 0x00 },	// U+0236 (ȶ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x06 },	// U+0237 (ȷ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+0238 (ȸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x04 },	// U+0239 (ȹ)
	{ 0x00, 0x00, 0x00, 0x2e, 0x11, 0x19, 0x1f, 0x15, 0x13, 0x11, 0x00, 0x00 },	// U+023A (Ⱥ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x12, 0x09, 0x09, 0x05, 0x02, 0x1d, 0x00, 0x00 },	// U+023B (Ȼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x19, 0x05, 0x13, 0x0f, 0x00, 0x00 },	// U+023C (ȼ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x07, 0x02, 0x02, 0x1e, 0x00, 0x00 },	// U+023D (Ƚ)
	{ 0x00, 0x00, 0x00, 0x3f, 0x14, 0x0c, 0x04, 0x04, 0x06, 0x05, 0x00, 0x00 },	// U+023E (Ⱦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x04, 0x08 },	// U+023F (ȿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x01, 0x02, 0x1c },	// U+0240 (ɀ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0241 (Ɂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x10, 0x0c, 0x04, 0x00, 0x00 },	// U+0242 (ɂ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x12, 0x0e, 0x12, 0x17, 0x12, 0x0e, 0x00, 0x00 },	// U+0243 (Ƀ)
	{ 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x3f, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+0244 (Ʉ)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x0a, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0245 (Ʌ)
	{ 0x00, 0x00, 0x00, 0x3f, 0x11, 0x09, 0x0f, 0x05, 0x03, 0x1f, 0x00, 0x00 },	// U+0246 (Ɇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0e, 0x15, 0x0f, 0x03, 0x0f, 0x00, 0x00 },	// U+0247 (ɇ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x08, 0x09, 0x06 },	// U+0248 (Ɉ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x08, 0x1c, 0x08, 0x09, 0x06 },	// U+0249 (ɉ)
	{ 0x00, 0x00, 0x00, 0x16, 0x19, 0x11, 0x11, 0x19, 0x16, 0x10, 0x10, 0x20 },	// U+024A (Ɋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x10, 0x20 },	// U+024B (ɋ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x0f, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+024C (Ɍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x06, 0x02, 0x07, 0x02, 0x00, 0x00 },	// U+024D (ɍ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1f, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+024E (Ɏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x0a, 0x04, 0x02, 0x01 },	// U+024F (ɏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+0250 (ɐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x19, 0x11, 0x19, 0x16, 0x00, 0x00 },	// U+0251 (ɑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x13, 0x0d, 0x00, 0x00 },	// U+0252 (ɒ)
	{ 0x00, 0x00, 0x06, 0x09, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00 },	// U+0253 (ɓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+0254 (ɔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x09, 0x15, 0x0e, 0x04, 0x00 },	// U+0255 (ɕ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x0e, 0x09, 0x09, 0x09, 0x0e, 0x10, 0x00 },	// U+0256 (ɖ)
	{ 0x00, 0x00, 0x10, 0x08, 0x08, 0x0e, 0x09, 0x09, 0x09, 0x0e, 0x00, 0x00 },	// U+0257 (ɗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1e, 0x10, 0x0e, 0x00, 0x00 },	// U+0258 (ɘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x0e, 0x00, 0x00 },	// U+0259 (ə)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x2e, 0x09, 0x06, 0x00, 0x00 },	// U+025A (ɚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+025B (ɛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0c, 0x11, 0x0e, 0x00, 0x00 },	// U+025C (ɜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x29, 0x04, 0x09, 0x06, 0x00, 0x00 },	// U+025D (ɝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0d, 0x11, 0x0e, 0x00, 0x00 },	// U+025E (ɞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x1c, 0x08, 0x09, 0x06 },	// U+025F (ɟ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x0e, 0x09, 0x09, 0x09, 0x0e, 0x08, 0x06 },	// U+0260 (ɠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e },	// U+0261 (ɡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00 },	// U+0262 (ɢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x0a, 0x04 },	// U+0263 (ɣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x04, 0x0a, 0x04, 0x00, 0x00 },	// U+0264 (ɤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10 },	// U+0265 (ɥ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0266 (ɦ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x0c },	// U+0267 (ɧ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x0e, 0x04, 0x0e, 0x00, 0x00 },	// U+0268 (ɨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+0269 (ɩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+026A (ɪ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x16, 0x0d, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+026B (ɫ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x06, 0x05, 0x0e, 0x04, 0x0e, 0x00, 0x00 },	// U+026C (ɬ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x14, 0x08 },	// U+026D (ɭ)
	{ 0x00, 0x00, 0x00, 0x03, 0x02, 0x1e, 0x12, 0x0a, 0x0e, 0x17, 0x12, 0x0c },	// U+026E (ɮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x1a, 0x00, 0x00 },	// U+026F (ɯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x1a, 0x10, 0x10 },	// U+0270 (ɰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x15, 0x15, 0x15, 0x15, 0x10, 0x0c },	// U+0271 (ɱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x12, 0x12, 0x02, 0x01 },	// U+0272 (ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x09, 0x09, 0x09, 0x08, 0x10 },	// U+0273 (ɳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x13, 0x15, 0x19, 0x11, 0x00, 0x00 },	// U+0274 (ɴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+0275 (ɵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x05, 0x0d, 0x05, 0x1e, 0x00, 0x00 },	// U+0276 (ɶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+0277 (ɷ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04 },	// U+0278 (ɸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x19, 0x16, 0x00, 0x00 },	// U+0279 (ɹ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x19, 0x16, 0x00, 0x00 },	// U+027A (ɺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x09, 0x0e, 0x08, 0x10 },	// U+027B (ɻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+027C (ɼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x01, 0x01, 0x01, 0x05, 0x02 },	// U+027D (ɽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+027E (ɾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+027F (ɿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x0f, 0x11, 0x11, 0x00, 0x00 },	// U+0280 (ʀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0f, 0x11, 0x0f, 0x00, 0x00 },	// U+0281 (ʁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x01, 0x06 },	// U+0282 (ʂ)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x04, 0x04, 0x04, 0x04, 0x05, 0x02, 0x00 },	// U+0283 (ʃ)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x04, 0x04, 0x0e, 0x04, 0x05, 0x02, 0x00 },	// U+0284 (ʄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+0285 (ʅ)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x04, 0x04, 0x04, 0x0e, 0x05, 0x02, 0x00 },	// U+0286 (ʆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x04, 0x04, 0x1f, 0x04, 0x04 },	// U+0287 (ʇ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x18 },	// U+0288 (ʈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1f, 0x11, 0x19, 0x16, 0x00, 0x00 },	// U+0289 (ʉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x0a, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+028A (ʊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x11, 0x11, 0x09, 0x06, 0x00, 0x00 },	// U+028B (ʋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+028C (ʌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x15, 0x11, 0x11, 0x00, 0x00 },	// U+028D (ʍ)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x0a, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+028E (ʎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+028F (ʏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x04, 0x18 },	// U+0290 (ʐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x0a, 0x1f, 0x04, 0x02 },	// U+0291 (ʑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x0e, 0x10, 0x11, 0x0e },	// U+0292 (ʒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x0c, 0x10, 0x1e, 0x11, 0x2e },	// U+0293 (ʓ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0294 (ʔ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x06, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0295 (ʕ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x0c, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+0296 (ʖ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x0e },	// U+0297 (ʗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+0298 (ʘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x0f, 0x11, 0x0f, 0x00, 0x00 },	// U+0299 (ʙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x16, 0x11, 0x0e, 0x00, 0x00 },	// U+029A (ʚ)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x1e, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00 },	// U+029B (ʛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00 },	// U+029C (ʜ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x1e, 0x09, 0x06 },	// U+029D (ʝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x12, 0x1c, 0x12, 0x11, 0x10, 0x10 },	// U+029E (ʞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+029F (ʟ)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x0e, 0x09, 0x09, 0x09, 0x0e, 0x08, 0x08 },	// U+02A0 (ʠ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+02A1 (ʡ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x06, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+02A2 (ʢ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x15, 0x0d, 0x0d, 0x1e, 0x00, 0x00 },	// U+02A3 (ʣ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x15, 0x0d, 0x1d, 0x16, 0x10, 0x0c },	// U+02A4 (ʤ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1e, 0x15, 0x0d, 0x0d, 0x1e, 0x08, 0x00 },	// U+02A5 (ʥ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x1f, 0x0a, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+02A6 (ʦ)
	{ 0x00, 0x00, 0x10, 0x2a, 0x0a, 0x0f, 0x0a, 0x0a, 0x0a, 0x0c, 0x0a, 0x04 },	// U+02A7 (ʧ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x17, 0x0a, 0x0a, 0x0a, 0x14, 0x08, 0x00 },	// U+02A8 (ʨ)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x01, 0x0f, 0x15, 0x15, 0x15, 0x10, 0x0c },	// U+02A9 (ʩ)
	{ 0x00, 0x00, 0x00, 0x03, 0x02, 0x1a, 0x06, 0x0a, 0x12, 0x0f, 0x00, 0x00 },	// U+02AA (ʪ)
	{ 0x00, 0x00, 0x00, 0x03, 0x02, 0x1e, 0x12, 0x0a, 0x06, 0x1f, 0x00, 0x00 },	// U+02AB (ʫ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x0a, 0x00, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+02AC (ʬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x00, 0x1f, 0x11, 0x00, 0x00, 0x00 },	// U+02AD (ʭ)
	{ 0x00, 0x00, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x1c, 0x10, 0x10 },	// U+02AE (ʮ)
	{ 0x00, 0x00, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x1c, 0x10, 0x20 },	// U+02AF (ʯ)
	{ 0x00, 0x02, 0x02, 0x06, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B0 (ʰ)
	{ 0x00, 0x04, 0x02, 0x06, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B1 (ʱ)
	{ 0x00, 0x08, 0x00, 0x08, 0x08, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B2 (ʲ)
	{ 0x00, 0x00, 0x06, 0x0a, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B3 (ʳ)
	{ 0x00, 0x00, 0x08, 0x08, 0x0a, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B4 (ʴ)
	{ 0x00, 0x00, 0x08, 0x08, 0x0a, 0x0c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B5 (ʵ)
	{ 0x00, 0x0a, 0x0a, 0x06, 0x0a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B6 (ʶ)
	{ 0x00, 0x00, 0x15, 0x15, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B7 (ʷ)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B8 (ʸ)
	{ 0x00, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B9 (ʹ)
	{ 0x00, 0x12, 0x12, 0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BA (ʺ)
	{ 0x00, 0x00, 0x08, 0x04, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BB (ʻ)
	{ 0x00, 0x00, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BC (ʼ)
	{ 0x00, 0x00, 0x0c, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BD (ʽ)
	{ 0x00, 0x00, 0x04, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BE (ʾ)
	{ 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BF (ʿ)
	{ 0x00, 0x04, 0x0a, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C0 (ˀ)
	{ 0x00, 0x04, 0x0a, 0x02, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C1 (ˁ)
	{ 0x00, 0x08, 0x04, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C2 (˂)
	{ 0x00, 0x02, 0x04, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C3 (˃)
	{ 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C4 (˄)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C5 (˅)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C6 (ˆ)
	{ 0x00, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C7 (ˇ)
	{ 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C8 (ˈ)
	{ 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C9 (ˉ)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02CA (ˊ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02CB (ˋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00 },	// U+02CC (ˌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00 },	// U+02CD (ˍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00 },	// U+02CE (ˎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00 },	// U+02CF (ˏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x00, 0x04, 0x0e, 0x00, 0x00 },	// U+02D0 (ː)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D1 (ˑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x0c, 0x00, 0x00 },	// U+02D2 (˒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x02, 0x0c, 0x00, 0x00 },	// U+02D3 (˓)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D4 (˔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+02D5 (˕)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+02D6 (˖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1f, 0x11, 0x00, 0x00, 0x00 },	// U+02D7 (˗)
	{ 0x00, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D8 (˘)
	{ 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D9 (˙)
	{ 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DA (˚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c },	// U+02DB (˛)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DC (˜)
	{ 0x00, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DD (˝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x15, 0x08, 0x00, 0x00, 0x00 },	// U+02DE (˞)
	{ 0x00, 0x0a, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DF (˟)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E0 (ˠ)
	{ 0x00, 0x06, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E1 (ˡ)
	{ 0x00, 0x00, 0x0c, 0x06, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E2 (ˢ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E3 (ˣ)
	{ 0x00, 0x0c, 0x02, 0x06, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E4 (ˤ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+02E5 (˥)
	{ 0x00, 0x00, 0x00, 0x08, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+02E6 (˦)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0e, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+02E7 (˧)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x08, 0x00, 0x00 },	// U+02E8 (˨)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00, 0x00 },	// U+02E9 (˩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08 },	// U+02EA (˪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x02, 0x02 },	// U+02EB (˫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x04 },	// U+02EC (ˬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02ED (˭)
	{ 0x00, 0x00, 0x00, 0x1b, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02EE (ˮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x0a, 0x04 },	// U+02EF (˯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11 },	// U+02F0 (˰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x06, 0x08 },	// U+02F1 (˱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x08, 0x06, 0x01 },	// U+02F2 (˲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12 },	// U+02F3 (˳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F4 (˴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F5 (˵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F6 (˶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d },	// U+02F7 (˷)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00 },	// U+02F8 (˸)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F9 (˹)
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02FA (˺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0c, 0x00, 0x00 },	// U+02FB (˻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0c, 0x00, 0x00 },	// U+02FC (˼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1f, 0x00, 0x00 },	// U+02FD (˽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0f, 0x00, 0x00 },	// U+02FE (˾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x02, 0x00 },	// U+02FF (˿)
	{ 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0300 (̀)
	{ 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0301 (́)
	{ 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0302 (̂)
	{ 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0303 (̃)
	{ 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0304 (̄)
	{ 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0305 (̅)
	{ 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0306 (̆)
	{ 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0307 (̇)
	{ 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0308 (̈)
	{ 0x06, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0309 (̉)
	{ 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030A (̊)
	{ 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030B (̋)
	{ 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030C (̌)
	{ 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030D (̍)
	{ 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030E (̎)
	{ 0x09, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030F (̏)
	{ 0x04, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0310 (̐)
	{ 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0311 (̑)
	{ 0x08, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0312 (̒)
	{ 0x0c, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0313 (̓)
	{ 0x06, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0314 (̔)
	{ 0x30, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0315 (̕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08 },	// U+0316 (̖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04 },	// U+0317 (̗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x08 },	// U+0318 (̘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x04 },	// U+0319 (̙)
	{ 0x38, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+031A (̚)
	{ 0x20, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+031B (̛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x08 },	// U+031C (̜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e },	// U+031D (̝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04 },	// U+031E (̞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04 },	// U+031F (̟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e },	// U+0320 (̠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x14, 0x08 },	// U+0321 (̡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20 },	// U+0322 (̢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04 },	// U+0323 (̣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a },	// U+0324 (̤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04 },	// U+0325 (̥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04 },	// U+0326 (̦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04 },	// U+0327 (̧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08 },	// U+0328 (̨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04 },	// U+0329 (̩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12 },	// U+032A (̪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0a },	// U+032B (̫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0c },	// U+032C (̬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12 },	// U+032D (̭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e },	// U+032E (̮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11 },	// U+032F (̯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a },	// U+0330 (̰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f },	// U+0331 (̱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f },	// U+0332 (̲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x3f },	// U+0333 (̳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+0334 (̴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0335 (̵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0336 (̶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+0337 (̷)
	{ 0x00, 0x10, 0x10, 0x08, 0x08, 0x04, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00 },	// U+0338 (̸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x04 },	// U+0339 (̹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x1e },	// U+033A (̺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0e },	// U+033B (̻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15 },	// U+033C (̼)
	{ 0x0a, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+033D (̽)
	{ 0x08, 0x04, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+033E (̾)
	{ 0x3f, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+033F (̿)
	{ 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0340 (̀)
	{ 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0341 (́)
	{ 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0342 (͂)
	{ 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0343 (̓)
	{ 0x08, 0x04, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0344 (̈́)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04 },	// U+0345 (ͅ)
	{ 0x0e, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0346 (͆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f },	// U+0347 (͇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a },	// U+0348 (͈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08 },	// U+0349 (͉)
	{ 0x00, 0x04, 0x16, 0x0d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+034A (͊)
	{ 0x08, 0x00, 0x16, 0x0d, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+034B (͋)
	{ 0x16, 0x0d, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+034C (͌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x0a },	// U+034D (͍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e },	// U+034E (͎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+034F (͏)
	{ 0x07, 0x1c, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0350 (͐)
	{ 0x04, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0351 (͑)
	{ 0x0e, 0x11, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0352 (͒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x04, 0x0a },	// U+0353 (͓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x07, 0x1c },	// U+0354 (͔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1c, 0x07 },	// U+0355 (͕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x13, 0x2c, 0x2b },	// U+0356 (͖)
	{ 0x04, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0357 (͗)
	{ 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0358 (͘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x0e },	// U+0359 (͙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x0a },	// U+035A (͚)
	{ 0x02, 0x0e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+035B (͛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x1c },	// U+035C (͜)
	{ 0x1c, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+035D (͝)
	{ 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+035E (͞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e },	// U+035F (͟)
	{ 0x0c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0360 (͠)
	{ 0x1c, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0361 (͡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3e, 0x10 },	// U+0362 (͢)
	{ 0x04, 0x0a, 0x0a, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0363 (ͣ)
	{ 0x04, 0x0e, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0364 (ͤ)
	{ 0x04, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0365 (ͥ)
	{ 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0366 (ͦ)
	{ 0x0a, 0x0a, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0367 (ͧ)
	{ 0x0c, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0368 (ͨ)
	{ 0x08, 0x0c, 0x0a, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0369 (ͩ)
	{ 0x02, 0x06, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036A (ͪ)
	{ 0x0b, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036B (ͫ)
	{ 0x0a, 0x06, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036C (ͬ)
	{ 0x04, 0x0e, 0x04, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036D (ͭ)
	{ 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036E (ͮ)
	{ 0x0a, 0x04, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+036F (ͯ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0370 (Ͱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x1c, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0371 (ͱ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x15, 0x15, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0372 (Ͳ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x15, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0373 (ͳ)
	{ 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0374 (ʹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04 },	// U+0375 (͵)
	{ 0x00, 0x00, 0x00, 0x11, 0x19, 0x19, 0x15, 0x13, 0x13, 0x11, 0x00, 0x00 },	// U+0376 (Ͷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0d, 0x0b, 0x09, 0x09, 0x10, 0x00 },	// U+0377 (ͷ)
}; // 728

static const unsigned char orpb_block4[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c },	// U+037A (ͺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+037B (ͻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x05, 0x11, 0x0e, 0x00, 0x00 },	// U+037C (ͼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x14, 0x11, 0x0e, 0x00, 0x00 },	// U+037D (ͽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x0c, 0x04, 0x02, 0x00 },	// U+037E (;)
}; // 5

static const unsigned char orpb_block5[][12] = {
	{ 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0384 (΄)
	{ 0x08, 0x04, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0385 (΅)
	{ 0x02, 0x01, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0386 (Ά)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0387 (·)
	{ 0x02, 0x01, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0388 (Έ)
	{ 0x02, 0x01, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0389 (Ή)
	{ 0x02, 0x01, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+038A (Ί)
}; // 7

static const unsigned char orpb_block6[][12] = {
	{ 0x02, 0x01, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+038C (Ό)
}; // 1

static const unsigned char orpb_block7[][12] = {
	{ 0x02, 0x01, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+038E (Ύ)
	{ 0x02, 0x01, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+038F (Ώ)
	{ 0x08, 0x04, 0x00, 0x0a, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+0390 (ΐ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0391 (Α)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x00 },	// U+0392 (Β)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0393 (Γ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+0394 (Δ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0395 (Ε)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00, 0x00 },	// U+0396 (Ζ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0397 (Η)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0398 (Θ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0399 (Ι)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+039A (Κ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+039B (Λ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+039C (Μ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x13, 0x15, 0x19, 0x11, 0x11, 0x00, 0x00 },	// U+039D (Ν)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x1f, 0x00, 0x00 },	// U+039E (Ξ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+039F (Ο)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+03A0 (Π)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+03A1 (Ρ)
}; // 20

static const unsigned char orpb_block8[][12] = {
	{ 0x00, 0x00, 0x00, 0x1f, 0x02, 0x04, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00 },	// U+03A3 (Σ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+03A4 (Τ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+03A5 (Υ)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+03A6 (Φ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+03A7 (Χ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+03A8 (Ψ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+03A9 (Ω)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+03AA (Ϊ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+03AB (Ϋ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+03AC (ά)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+03AD (έ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+03AE (ή)
	{ 0x00, 0x00, 0x04, 0x02, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+03AF (ί)
	{ 0x08, 0x04, 0x00, 0x0a, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+03B0 (ΰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+03B1 (α)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x0d, 0x11, 0x11, 0x0f, 0x01, 0x01 },	// U+03B2 (β)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x04 },	// U+03B3 (γ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x01, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+03B4 (δ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+03B5 (ε)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x02, 0x02, 0x0c, 0x10, 0x0c, 0x00 },	// U+03B6 (ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+03B7 (η)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+03B8 (θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+03B9 (ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x00, 0x00 },	// U+03BA (κ)
	{ 0x00, 0x01, 0x02, 0x02, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+03BB (λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x19, 0x17, 0x01, 0x01 },	// U+03BC (μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+03BD (ν)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x02, 0x0e, 0x01, 0x01, 0x0e, 0x10, 0x08 },	// U+03BE (ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+03BF (ο)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x0a, 0x2a, 0x12, 0x00, 0x00 },	// U+03C0 (π)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x13, 0x0d, 0x01, 0x01 },	// U+03C1 (ρ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x0e, 0x10, 0x0c },	// U+03C2 (ς)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x09, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+03C3 (σ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+03C4 (τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+03C5 (υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04 },	// U+03C6 (φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11 },	// U+03C7 (χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04 },	// U+03C8 (ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+03C9 (ω)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+03CA (ϊ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+03CB (ϋ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+03CC (ό)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+03CD (ύ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+03CE (ώ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x0c, 0x08 },	// U+03CF (Ϗ)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x0d, 0x13, 0x11, 0x0e, 0x00, 0x00 },	// U+03D0 (ϐ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x3c, 0x10, 0x13, 0x12, 0x0c, 0x00, 0x00 },	// U+03D1 (ϑ)
	{ 0x00, 0x00, 0x00, 0x11, 0x2a, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+03D2 (ϒ)
	{ 0x02, 0x01, 0x00, 0x11, 0x2a, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+03D3 (ϓ)
	{ 0x00, 0x1b, 0x00, 0x11, 0x2a, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+03D4 (ϔ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04 },	// U+03D5 (ϕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+03D6 (ϖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x12, 0x0e, 0x0a, 0x11, 0x10, 0x0c },	// U+03D7 (ϗ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x04 },	// U+03D8 (Ϙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x04 },	// U+03D9 (ϙ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x01, 0x01, 0x0e, 0x08, 0x00, 0x00 },	// U+03DA (Ϛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x01, 0x01, 0x01, 0x0e, 0x10, 0x0c },	// U+03DB (ϛ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x07, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+03DC (Ϝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x02, 0x0e, 0x02, 0x02, 0x02 },	// U+03DD (ϝ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x01, 0x1f, 0x10, 0x08, 0x08, 0x00, 0x00 },	// U+03DE (Ϟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x12, 0x1a, 0x16, 0x12, 0x10, 0x20 },	// U+03DF (ϟ)
	{ 0x00, 0x00, 0x00, 0x07, 0x0c, 0x12, 0x18, 0x14, 0x10, 0x08, 0x00, 0x00 },	// U+03E0 (Ϡ)
	{ 0x00, 0x00, 0x00, 0x03, 0x04, 0x08, 0x0c, 0x12, 0x18, 0x14, 0x10, 0x10 },	// U+03E1 (ϡ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1a, 0x10, 0x0f, 0x00 },	// U+03E2 (Ϣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x1a, 0x10, 0x0f, 0x00 },	// U+03E3 (ϣ)
	{ 0x00, 0x00, 0x00, 0x12, 0x11, 0x11, 0x11, 0x11, 0x19, 0x16, 0x10, 0x10 },	// U+03E4 (Ϥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10 },	// U+03E5 (ϥ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0d, 0x13, 0x11, 0x11, 0x10, 0x0e, 0x00 },	// U+03E6 (Ϧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x09, 0x16, 0x10, 0x13, 0x0d, 0x00, 0x00 },	// U+03E7 (ϧ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x08, 0x04, 0x02, 0x11, 0x0e, 0x00 },	// U+03E8 (Ϩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x08, 0x06, 0x01, 0x1e, 0x00 },	// U+03E9 (ϩ)
	{ 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x00 },	// U+03EA (Ϫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x1f, 0x00, 0x00 },	// U+03EB (ϫ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x01, 0x07, 0x09, 0x11, 0x0f, 0x00, 0x00 },	// U+03EC (Ϭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x01, 0x07, 0x09, 0x07, 0x00, 0x00 },	// U+03ED (ϭ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x15, 0x04, 0x04, 0x0c, 0x00, 0x00 },	// U+03EE (Ϯ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x05, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+03EF (ϯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x12, 0x0e, 0x0a, 0x11, 0x00, 0x00 },	// U+03F0 (ϰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x1e },	// U+03F1 (ϱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+03F2 (ϲ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x04 },	// U+03F3 (ϳ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+03F4 (ϴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x0e, 0x02, 0x1c, 0x00, 0x00 },	// U+03F5 (ϵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x1c, 0x10, 0x0e, 0x00, 0x00 },	// U+03F6 (϶)
	{ 0x00, 0x00, 0x07, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x02, 0x07, 0x00, 0x00 },	// U+03F7 (Ϸ)
	{ 0x00, 0x00, 0x01, 0x0d, 0x13, 0x11, 0x11, 0x13, 0x0d, 0x01, 0x00, 0x00 },	// U+03F8 (ϸ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+03F9 (Ϲ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+03FA (Ϻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x01, 0x01 },	// U+03FB (ϻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0e, 0x02, 0x0f, 0x02 },	// U+03FC (ϼ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+03FD (Ͻ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x05, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+03FE (Ͼ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x14, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+03FF (Ͽ)
	{ 0x02, 0x04, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0400 (Ѐ)
	{ 0x00, 0x0a, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0401 (Ё)
	{ 0x00, 0x00, 0x00, 0x07, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x10, 0x0c },	// U+0402 (Ђ)
	{ 0x08, 0x04, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0403 (Ѓ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0f, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+0404 (Є)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+0405 (Ѕ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0406 (І)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0407 (Ї)
	{ 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x09, 0x06, 0x00, 0x00 },	// U+0408 (Ј)
	{ 0x00, 0x00, 0x00, 0x06, 0x05, 0x05, 0x0d, 0x15, 0x15, 0x0d, 0x00, 0x00 },	// U+0409 (Љ)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x0f, 0x15, 0x15, 0x0d, 0x00, 0x00 },	// U+040A (Њ)
	{ 0x00, 0x00, 0x00, 0x07, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+040B (Ћ)
	{ 0x08, 0x04, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+040C (Ќ)
	{ 0x02, 0x04, 0x00, 0x11, 0x11, 0x19, 0x15, 0x13, 0x11, 0x11, 0x00, 0x00 },	// U+040D (Ѝ)
	{ 0x11, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00, 0x00 },	// U+040E (Ў)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x04, 0x04 },	// U+040F (Џ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0410 (А)
	{ 0x00, 0x00, 0x00, 0x0f, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x00 },	// U+0411 (Б)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x0f, 0x00, 0x00 },	// U+0412 (В)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0413 (Г)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x1f, 0x11, 0x00 },	// U+0414 (Д)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+0415 (Е)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x0e, 0x04, 0x0e, 0x15, 0x15, 0x00, 0x00 },	// U+0416 (Ж)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+0417 (З)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x19, 0x15, 0x13, 0x11, 0x11, 0x00, 0x00 },	// U+0418 (И)
	{ 0x11, 0x0e, 0x00, 0x11, 0x11, 0x19, 0x15, 0x13, 0x11, 0x11, 0x00, 0x00 },	// U+0419 (Й)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+041A (К)
	{ 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x00, 0x00 },	// U+041B (Л)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+041C (М)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+041D (Н)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+041E (О)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+041F (П)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0420 (Р)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+0421 (С)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0422 (Т)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e, 0x00, 0x00 },	// U+0423 (У)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+0424 (Ф)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+0425 (Х)
	{ 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1f, 0x10, 0x10 },	// U+0426 (Ц)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+0427 (Ч)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00 },	// U+0428 (Ш)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x10, 0x10 },	// U+0429 (Щ)
	{ 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00 },	// U+042A (Ъ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x13, 0x15, 0x15, 0x13, 0x00, 0x00 },	// U+042B (Ы)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00 },	// U+042C (Ь)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x1e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+042D (Э)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x15, 0x17, 0x15, 0x15, 0x09, 0x00, 0x00 },	// U+042E (Ю)
	{ 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x1e, 0x14, 0x12, 0x11, 0x00, 0x00 },	// U+042F (Я)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+0430 (а)
	{ 0x00, 0x00, 0x00, 0x0e, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0431 (б)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x0f, 0x11, 0x0f, 0x00, 0x00 },	// U+0432 (в)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0433 (г)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x0a, 0x0a, 0x1f, 0x11, 0x00 },	// U+0434 (д)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+0435 (е)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0e, 0x04, 0x0e, 0x15, 0x00, 0x00 },	// U+0436 (ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0c, 0x11, 0x0e, 0x00, 0x00 },	// U+0437 (з)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x00, 0x00 },	// U+0438 (и)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x00, 0x00 },	// U+0439 (й)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x00, 0x00 },	// U+043A (к)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x11, 0x00, 0x00 },	// U+043B (л)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x00, 0x00 },	// U+043C (м)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00 },	// U+043D (н)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+043E (о)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+043F (п)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01 },	// U+0440 (р)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+0441 (с)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0442 (т)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e },	// U+0443 (у)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04 },	// U+0444 (ф)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+0445 (х)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x09, 0x1f, 0x10, 0x10 },	// U+0446 (ц)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x00, 0x00 },	// U+0447 (ч)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00 },	// U+0448 (ш)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x10, 0x10 },	// U+0449 (щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x02, 0x0e, 0x12, 0x0e, 0x00, 0x00 },	// U+044A (ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x13, 0x15, 0x13, 0x00, 0x00 },	// U+044B (ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x12, 0x0e, 0x00, 0x00 },	// U+044C (ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x1c, 0x10, 0x0e, 0x00, 0x00 },	// U+044D (э)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x15, 0x17, 0x15, 0x09, 0x00, 0x00 },	// U+044E (ю)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x1c, 0x14, 0x12, 0x00, 0x00 },	// U+044F (я)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+0450 (ѐ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+0451 (ё)
	{ 0x00, 0x00, 0x00, 0x02, 0x07, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x10, 0x08 },	// U+0452 (ђ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0453 (ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x0e, 0x02, 0x1c, 0x00, 0x00 },	// U+0454 (є)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00 },	// U+0455 (ѕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0456 (і)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x06, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+0457 (ї)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x12, 0x0c },	// U+0458 (ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x0d, 0x15, 0x0d, 0x00, 0x00 },	// U+0459 (љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0f, 0x15, 0x0d, 0x00, 0x00 },	// U+045A (њ)
	{ 0x00, 0x00, 0x00, 0x02, 0x07, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+045B (ћ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x00, 0x00 },	// U+045C (ќ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x00, 0x00 },	// U+045D (ѝ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x0e },	// U+045E (ў)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x04, 0x04 },	// U+045F (џ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x11, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+0460 (Ѡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+0461 (ѡ)
	{ 0x00, 0x00, 0x00, 0x02, 0x0f, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00 },	// U+0462 (Ѣ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x0f, 0x02, 0x0e, 0x12, 0x0e, 0x00, 0x00 },	// U+0463 (ѣ)
	{ 0x00, 0x00, 0x00, 0x19, 0x05, 0x05, 0x1f, 0x05, 0x05, 0x19, 0x00, 0x00 },	// U+0464 (Ѥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x05, 0x1f, 0x05, 0x19, 0x00, 0x00 },	// U+0465 (ѥ)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x1f, 0x15, 0x15, 0x00, 0x00 },	// U+0466 (Ѧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x1f, 0x15, 0x00, 0x00 },	// U+0467 (ѧ)
	{ 0x00, 0x00, 0x00, 0x09, 0x09, 0x1d, 0x1f, 0x1d, 0x1d, 0x1d, 0x00, 0x00 },	// U+0468 (Ѩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x1f, 0x1d, 0x1d, 0x00, 0x00 },	// U+0469 (ѩ)
	{ 0x00, 0x00, 0x1f, 0x11, 0x0a, 0x0a, 0x0e, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+046A (Ѫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x0a, 0x0e, 0x15, 0x15, 0x00, 0x00 },	// U+046B (ѫ)
	{ 0x00, 0x00, 0x3f, 0x23, 0x15, 0x09, 0x1f, 0x1d, 0x1d, 0x15, 0x00, 0x00 },	// U+046C (Ѭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x15, 0x09, 0x1f, 0x1d, 0x15, 0x00, 0x00 },	// U+046D (ѭ)
	{ 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x10, 0x10, 0x0e, 0x01, 0x0e },	// U+046E (Ѯ)
	{ 0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x0c, 0x10, 0x0e, 0x01, 0x0e },	// U+046F (ѯ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+0470 (Ѱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+0471 (ѱ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0472 (Ѳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+0473 (ѳ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x09, 0x0a, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+0474 (Ѵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x09, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+0475 (ѵ)
	{ 0x09, 0x12, 0x00, 0x11, 0x09, 0x09, 0x0a, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+0476 (Ѷ)
	{ 0x00, 0x00, 0x09, 0x12, 0x00, 0x11, 0x09, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+0477 (ѷ)
	{ 0x00, 0x00, 0x00, 0x02, 0x05, 0x05, 0x1d, 0x1d, 0x1d, 0x1a, 0x10, 0x08 },	// U+0478 (Ѹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x1d, 0x1d, 0x1d, 0x1a, 0x10, 0x08 },	// U+0479 (ѹ)
	{ 0x00, 0x04, 0x0e, 0x15, 0x11, 0x11, 0x11, 0x11, 0x15, 0x0e, 0x04, 0x00 },	// U+047A (Ѻ)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x11, 0x11, 0x15, 0x0e, 0x04, 0x00 },	// U+047B (ѻ)
	{ 0x00, 0x0e, 0x00, 0x04, 0x04, 0x11, 0x11, 0x11, 0x15, 0x0a, 0x00, 0x00 },	// U+047C (Ѽ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x04, 0x15, 0x11, 0x15, 0x0a, 0x00, 0x00 },	// U+047D (ѽ)
	{ 0x1f, 0x15, 0x00, 0x0a, 0x11, 0x11, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+047E (Ѿ)
	{ 0x00, 0x00, 0x1f, 0x15, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+047F (ѿ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x08, 0x08 },	// U+0480 (Ҁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x0e, 0x08, 0x08, 0x00 },	// U+0481 (ҁ)
	{ 0x00, 0x00, 0x00, 0x14, 0x08, 0x0d, 0x12, 0x02, 0x05, 0x00, 0x00, 0x00 },	// U+0482 (҂)
	{ 0x20, 0x3f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0483 (҃)
	{ 0x0e, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0484 (҄)
	{ 0x0e, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0485 (҅)
	{ 0x0e, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0486 (҆)
	{ 0x06, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0487 (҇)
	{ 0x02, 0x05, 0x10, 0x28, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x10, 0x28 },	// U+0488 (҈)
	{ 0x02, 0x21, 0x13, 0x30, 0x00, 0x00, 0x00, 0x00, 0x02, 0x21, 0x13, 0x30 },	// U+0489 (҉)
	{ 0x11, 0x0e, 0x00, 0x11, 0x19, 0x19, 0x15, 0x13, 0x13, 0x11, 0x08, 0x08 },	// U+048A (Ҋ)
	{ 0x00, 0x11, 0x0e, 0x00, 0x11, 0x11, 0x19, 0x15, 0x13, 0x11, 0x08, 0x08 },	// U+048B (ҋ)
	{ 0x00, 0x00, 0x02, 0x02, 0x07, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00 },	// U+048C (Ҍ)
	{ 0x00, 0x00, 0x00, 0x02, 0x07, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00 },	// U+048D (ҍ)
	{ 0x00, 0x00, 0x0f, 0x11, 0x11, 0x15, 0x0f, 0x11, 0x01, 0x01, 0x00, 0x00 },	// U+048E (Ҏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x15, 0x0f, 0x11, 0x01, 0x01 },	// U+048F (ҏ)
	{ 0x00, 0x10, 0x10, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0490 (Ґ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0491 (ґ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x02, 0x02, 0x0f, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+0492 (Ғ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x0f, 0x02, 0x02, 0x00, 0x00 },	// U+0493 (ғ)
	{ 0x00, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x08, 0x00 },	// U+0494 (Ҕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x08, 0x00 },	// U+0495 (ҕ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x35, 0x20, 0x20 },	// U+0496 (Җ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0e, 0x04, 0x0e, 0x35, 0x20, 0x20 },	// U+0497 (җ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x10, 0x08, 0x10, 0x10, 0x11, 0x0e, 0x04, 0x02 },	// U+0498 (Ҙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x08, 0x10, 0x11, 0x0e, 0x04, 0x02 },	// U+0499 (ҙ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x20, 0x20 },	// U+049A (Қ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x03, 0x05, 0x09, 0x10, 0x10 },	// U+049B (қ)
	{ 0x00, 0x00, 0x00, 0x15, 0x0d, 0x05, 0x03, 0x05, 0x0d, 0x15, 0x00, 0x00 },	// U+049C (Ҝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0d, 0x07, 0x0d, 0x15, 0x00, 0x00 },	// U+049D (ҝ)
	{ 0x00, 0x00, 0x00, 0x12, 0x17, 0x0a, 0x06, 0x0a, 0x12, 0x12, 0x00, 0x00 },	// U+049E (Ҟ)
	{ 0x00, 0x00, 0x02, 0x02, 0x07, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x00, 0x00 },	// U+049F (ҟ)
	{ 0x00, 0x00, 0x13, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x12, 0x00, 0x00 },	// U+04A0 (Ҡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x0a, 0x06, 0x0a, 0x12, 0x00, 0x00 },	// U+04A1 (ҡ)
	{ 0x00, 0x00, 0x09, 0x09, 0x09, 0x0f, 0x09, 0x09, 0x09, 0x19, 0x10, 0x10 },	// U+04A2 (Ң)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x0f, 0x09, 0x19, 0x10, 0x10 },	// U+04A3 (ң)
	{ 0x00, 0x00, 0x1d, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x00, 0x00 },	// U+04A4 (Ҥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x05, 0x07, 0x05, 0x05, 0x00, 0x00 },	// U+04A5 (ҥ)
	{ 0x00, 0x00, 0x07, 0x05, 0x05, 0x0d, 0x15, 0x15, 0x15, 0x15, 0x10, 0x08 },	// U+04A6 (Ҧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x05, 0x0d, 0x15, 0x15, 0x10, 0x08 },	// U+04A7 (ҧ)
	{ 0x00, 0x00, 0x1e, 0x01, 0x09, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x18, 0x00 },	// U+04A8 (Ҩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x01, 0x09, 0x15, 0x0e, 0x04, 0x18, 0x00 },	// U+04A9 (ҩ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x04, 0x08 },	// U+04AA (Ҫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x11, 0x0e, 0x04, 0x08 },	// U+04AB (ҫ)
	{ 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x08, 0x08 },	// U+04AC (Ҭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x04, 0x04, 0x0c, 0x08, 0x08 },	// U+04AD (ҭ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+04AE (Ү)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04 },	// U+04AF (ү)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x1f, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+04B0 (Ұ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x1f, 0x04, 0x04, 0x04 },	// U+04B1 (ұ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x20, 0x20 },	// U+04B2 (Ҳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x20, 0x20 },	// U+04B3 (ҳ)
	{ 0x00, 0x00, 0x17, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x1e, 0x10, 0x10 },	// U+04B4 (Ҵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x17, 0x12, 0x12, 0x12, 0x12, 0x1e, 0x10, 0x10 },	// U+04B5 (ҵ)
	{ 0x00, 0x00, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0e, 0x08, 0x18, 0x10, 0x10 },	// U+04B6 (Ҷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x0e, 0x08, 0x18, 0x10, 0x10 },	// U+04B7 (ҷ)
	{ 0x00, 0x00, 0x11, 0x11, 0x15, 0x15, 0x1e, 0x14, 0x14, 0x10, 0x00, 0x00 },	// U+04B8 (Ҹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x15, 0x1e, 0x14, 0x10, 0x00, 0x00 },	// U+04B9 (ҹ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+04BA (Һ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+04BB (һ)
	{ 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x1f, 0x02, 0x12, 0x0c, 0x00, 0x00 },	// U+04BC (Ҽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1f, 0x02, 0x12, 0x0c, 0x00, 0x00 },	// U+04BD (ҽ)
	{ 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x1f, 0x02, 0x12, 0x0c, 0x04, 0x08 },	// U+04BE (Ҿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1f, 0x02, 0x12, 0x0c, 0x04, 0x08 },	// U+04BF (ҿ)
	{ 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+04C0 (Ӏ)
	{ 0x11, 0x0e, 0x00, 0x15, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+04C1 (Ӂ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x15, 0x0e, 0x04, 0x0e, 0x15, 0x00, 0x00 },	// U+04C2 (ӂ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x10, 0x0c },	// U+04C3 (Ӄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x03, 0x05, 0x09, 0x08, 0x06 },	// U+04C4 (ӄ)
	{ 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x11, 0x08, 0x08 },	// U+04C5 (Ӆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x11, 0x08, 0x08 },	// U+04C6 (ӆ)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x10, 0x0c },	// U+04C7 (Ӈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x10, 0x0c },	// U+04C8 (ӈ)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x08, 0x08 },	// U+04C9 (Ӊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x08, 0x08 },	// U+04CA (ӊ)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x18, 0x08, 0x08 },	// U+04CB (Ӌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x18, 0x08, 0x08 },	// U+04CC (ӌ)
	{ 0x00, 0x00, 0x11, 0x1b, 0x1b, 0x15, 0x15, 0x11, 0x11, 0x11, 0x08, 0x08 },	// U+04CD (Ӎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x08, 0x08 },	// U+04CE (ӎ)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+04CF (ӏ)
	{ 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00 },	// U+04D0 (Ӑ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+04D1 (ӑ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+04D2 (Ӓ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x00 },	// U+04D3 (ӓ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x05, 0x05, 0x0f, 0x05, 0x05, 0x1d, 0x00, 0x00 },	// U+04D4 (Ӕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x14, 0x0e, 0x15, 0x0e, 0x00, 0x00 },	// U+04D5 (ӕ)
	{ 0x00, 0x11, 0x0e, 0x00, 0x1f, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+04D6 (Ӗ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x0e, 0x00, 0x00 },	// U+04D7 (ӗ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+04D8 (Ә)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+04D9 (ә)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x10, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+04DA (Ӛ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x10, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+04DB (ӛ)
	{ 0x00, 0x0a, 0x00, 0x15, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+04DC (Ӝ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x15, 0x0e, 0x04, 0x0e, 0x15, 0x00, 0x00 },	// U+04DD (ӝ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x10, 0x0c, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+04DE (Ӟ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x0c, 0x11, 0x0e, 0x00, 0x00 },	// U+04DF (ӟ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+04E0 (Ӡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x0e, 0x10, 0x11, 0x0e },	// U+04E1 (ӡ)
	{ 0x00, 0x1f, 0x00, 0x11, 0x11, 0x19, 0x15, 0x13, 0x11, 0x11, 0x00, 0x00 },	// U+04E2 (Ӣ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x00, 0x00 },	// U+04E3 (ӣ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x19, 0x15, 0x13, 0x11, 0x11, 0x00, 0x00 },	// U+04E4 (Ӥ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x00, 0x00 },	// U+04E5 (ӥ)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+04E6 (Ӧ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+04E7 (ӧ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+04E8 (Ө)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+04E9 (ө)
	{ 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+04EA (Ӫ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+04EB (ӫ)
	{ 0x00, 0x0a, 0x00, 0x07, 0x08, 0x10, 0x1e, 0x10, 0x08, 0x07, 0x00, 0x00 },	// U+04EC (Ӭ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0e, 0x10, 0x1c, 0x10, 0x0e, 0x00, 0x00 },	// U+04ED (ӭ)
	{ 0x00, 0x1f, 0x00, 0x11, 0x11, 0x19, 0x16, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+04EE (Ӯ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x11, 0x0e },	// U+04EF (ӯ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x19, 0x16, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+04F0 (Ӱ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x11, 0x0e },	// U+04F1 (ӱ)
	{ 0x12, 0x09, 0x00, 0x11, 0x11, 0x19, 0x16, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+04F2 (Ӳ)
	{ 0x00, 0x00, 0x12, 0x09, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x11, 0x0e },	// U+04F3 (ӳ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+04F4 (Ӵ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x00, 0x00 },	// U+04F5 (ӵ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x00 },	// U+04F6 (Ӷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x02, 0x02, 0x06, 0x04, 0x00 },	// U+04F7 (ӷ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x13, 0x15, 0x15, 0x13, 0x00, 0x00 },	// U+04F8 (Ӹ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x13, 0x15, 0x13, 0x00, 0x00 },	// U+04F9 (ӹ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x02, 0x02, 0x07, 0x02, 0x02, 0x06, 0x04, 0x02 },	// U+04FA (Ӻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x07, 0x02, 0x06, 0x04, 0x02 },	// U+04FB (ӻ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x10, 0x08 },	// U+04FC (Ӽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x10, 0x08 },	// U+04FD (ӽ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x1f, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+04FE (Ӿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x1f, 0x0a, 0x11, 0x00, 0x00 },	// U+04FF (ӿ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00 },	// U+0500 (Ԁ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1c, 0x12, 0x12, 0x12, 0x1c, 0x00, 0x00 },	// U+0501 (ԁ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x06, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+0502 (Ԃ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x06, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+0503 (ԃ)
	{ 0x00, 0x00, 0x00, 0x03, 0x04, 0x04, 0x03, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+0504 (Ԅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x04, 0x12, 0x14, 0x08, 0x00, 0x00 },	// U+0505 (ԅ)
	{ 0x00, 0x00, 0x00, 0x03, 0x04, 0x04, 0x03, 0x04, 0x04, 0x0c, 0x08, 0x08 },	// U+0506 (Ԇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x04, 0x02, 0x04, 0x0c, 0x08, 0x08 },	// U+0507 (ԇ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x05, 0x05, 0x15, 0x15, 0x15, 0x09, 0x00, 0x00 },	// U+0508 (Ԉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x05, 0x05, 0x15, 0x09, 0x00, 0x00 },	// U+0509 (ԉ)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x17, 0x15, 0x15, 0x09, 0x00, 0x00 },	// U+050A (Ԋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x17, 0x15, 0x09, 0x00, 0x00 },	// U+050B (ԋ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+050C (Ԍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x19, 0x11, 0x0e, 0x00, 0x00 },	// U+050D (ԍ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x14, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+050E (Ԏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+050F (ԏ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x11, 0x01, 0x06, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+0510 (Ԑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+0511 (ԑ)
	{ 0x00, 0x00, 0x00, 0x3f, 0x12, 0x12, 0x12, 0x12, 0x15, 0x08, 0x00, 0x00 },	// U+0512 (Ԓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x12, 0x12, 0x12, 0x11, 0x08, 0x00 },	// U+0513 (ԓ)
	{ 0x00, 0x00, 0x00, 0x2b, 0x2a, 0x2a, 0x12, 0x2a, 0x2a, 0x29, 0x00, 0x00 },	// U+0514 (Ԕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x2a, 0x12, 0x2a, 0x29, 0x00, 0x00 },	// U+0515 (ԕ)
	{ 0x00, 0x00, 0x00, 0x13, 0x15, 0x0d, 0x0b, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0516 (Ԗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x0d, 0x05, 0x0b, 0x11, 0x01, 0x00 },	// U+0517 (ԗ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x05, 0x05, 0x0e, 0x05, 0x05, 0x1d, 0x00, 0x00 },	// U+0518 (Ԙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x0e, 0x05, 0x19, 0x00, 0x00 },	// U+0519 (ԙ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x15, 0x09, 0x16, 0x00, 0x00 },	// U+051A (Ԛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10 },	// U+051B (ԛ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+051C (Ԝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+051D (ԝ)
	{ 0x00, 0x00, 0x00, 0x15, 0x09, 0x15, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+051E (Ԟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x09, 0x17, 0x09, 0x11, 0x00, 0x00 },	// U+051F (ԟ)
	{ 0x00, 0x00, 0x00, 0x0b, 0x0a, 0x0a, 0x1a, 0x2a, 0x2a, 0x29, 0x20, 0x10 },	// U+0520 (Ԡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0a, 0x1a, 0x2a, 0x29, 0x20, 0x00 },	// U+0521 (ԡ)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x0f, 0x15, 0x15, 0x15, 0x10, 0x08 },	// U+0522 (Ԣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x0f, 0x15, 0x15, 0x10, 0x08 },	// U+0523 (ԣ)
}; // 385

static const unsigned char orpb_block9[][12] = {
	{ 0x00, 0x00, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0d, 0x12, 0x00, 0x00 },	// U+0531 (Ա)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x01, 0x01, 0x0f, 0x11, 0x01, 0x00, 0x00 },	// U+0532 (Բ)
	{ 0x00, 0x00, 0x02, 0x05, 0x05, 0x05, 0x0e, 0x14, 0x04, 0x04, 0x00, 0x00 },	// U+0533 (Գ)
	{ 0x00, 0x00, 0x02, 0x05, 0x05, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x00, 0x00 },	// U+0534 (Դ)
	{ 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x01, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0535 (Ե)
	{ 0x00, 0x00, 0x06, 0x09, 0x09, 0x0e, 0x08, 0x05, 0x0f, 0x11, 0x00, 0x00 },	// U+0536 (Զ)
	{ 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x01, 0x01, 0x01, 0x0e, 0x10, 0x08 },	// U+0537 (Է)
	{ 0x00, 0x00, 0x06, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x10, 0x00 },	// U+0538 (Ը)
	{ 0x00, 0x00, 0x06, 0x09, 0x1d, 0x0b, 0x0b, 0x05, 0x01, 0x01, 0x00, 0x00 },	// U+0539 (Թ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x1e, 0x09, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+053A (Ժ)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x01, 0x01, 0x00, 0x00 },	// U+053B (Ի)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x10, 0x08 },	// U+053C (Լ)
	{ 0x00, 0x00, 0x01, 0x01, 0x17, 0x15, 0x15, 0x09, 0x01, 0x01, 0x00, 0x00 },	// U+053D (Խ)
	{ 0x00, 0x00, 0x1f, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+053E (Ծ)
	{ 0x00, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x00, 0x00 },	// U+053F (Կ)
	{ 0x00, 0x00, 0x08, 0x04, 0x08, 0x04, 0x02, 0x01, 0x03, 0x0c, 0x10, 0x00 },	// U+0540 (Հ)
	{ 0x00, 0x00, 0x0c, 0x12, 0x12, 0x1c, 0x10, 0x0e, 0x09, 0x16, 0x00, 0x00 },	// U+0541 (Ձ)
	{ 0x00, 0x00, 0x02, 0x05, 0x05, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x10, 0x00 },	// U+0542 (Ղ)
	{ 0x00, 0x00, 0x08, 0x0a, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+0543 (Ճ)
	{ 0x00, 0x00, 0x1d, 0x15, 0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x00, 0x00 },	// U+0544 (Մ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x15, 0x0c, 0x14, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0545 (Յ)
	{ 0x00, 0x00, 0x02, 0x01, 0x03, 0x02, 0x02, 0x02, 0x12, 0x0c, 0x00, 0x00 },	// U+0546 (Ն)
	{ 0x00, 0x00, 0x10, 0x0f, 0x02, 0x01, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0547 (Շ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0548 (Ո)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x1e, 0x08, 0x04, 0x1f, 0x00, 0x00 },	// U+0549 (Չ)
	{ 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x14, 0x14, 0x10, 0x10, 0x00, 0x00 },	// U+054A (Պ)
	{ 0x00, 0x00, 0x06, 0x09, 0x09, 0x0a, 0x0c, 0x05, 0x0f, 0x11, 0x00, 0x00 },	// U+054B (Ջ)
	{ 0x00, 0x00, 0x02, 0x05, 0x05, 0x0d, 0x15, 0x15, 0x05, 0x05, 0x00, 0x00 },	// U+054C (Ռ)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+054D (Ս)
	{ 0x00, 0x00, 0x04, 0x05, 0x05, 0x05, 0x05, 0x06, 0x04, 0x0c, 0x10, 0x00 },	// U+054E (Վ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+054F (Տ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+0550 (Ր)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0e, 0x11, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+0551 (Ց)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x07, 0x09, 0x09, 0x11, 0x01, 0x00, 0x00 },	// U+0552 (Ւ)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+0553 (Փ)
	{ 0x00, 0x00, 0x08, 0x14, 0x14, 0x0c, 0x05, 0x0e, 0x14, 0x04, 0x00, 0x00 },	// U+0554 (Ք)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0555 (Օ)
	{ 0x00, 0x00, 0x02, 0x05, 0x05, 0x0e, 0x14, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+0556 (Ֆ)
}; // 38

static const unsigned char orpb_block10[][12] = {
	{ 0x04, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0559 (ՙ)
	{ 0x00, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055A (՚)
	{ 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055B (՛)
	{ 0x10, 0x0e, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055C (՜)
	{ 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055D (՝)
	{ 0x00, 0x0e, 0x11, 0x15, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055E (՞)
	{ 0x00, 0x03, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055F (՟)
}; // 7

static const unsigned char orpb_block11[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x15, 0x15, 0x1a, 0x00, 0x00 },	// U+0561 (ա)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x01, 0x1f, 0x01, 0x01 },	// U+0562 (բ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x09, 0x09, 0x09, 0x1e, 0x08, 0x08 },	// U+0563 (գ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0b, 0x09, 0x09, 0x19, 0x08, 0x08 },	// U+0564 (դ)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x1f, 0x01, 0x11, 0x13, 0x0d, 0x00, 0x00 },	// U+0565 (ե)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x09, 0x09, 0x09, 0x0e, 0x08, 0x18 },	// U+0566 (զ)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x1f, 0x01, 0x01, 0x01, 0x0e, 0x10, 0x00 },	// U+0567 (է)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x01, 0x1f },	// U+0568 (ը)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0b, 0x09, 0x1d, 0x0b, 0x05, 0x01 },	// U+0569 (թ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x1e, 0x09, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+056A (ժ)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x05, 0x0b, 0x09, 0x09, 0x09, 0x01, 0x01 },	// U+056B (ի)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0c },	// U+056C (լ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x17, 0x15, 0x15, 0x15, 0x09, 0x01, 0x01 },	// U+056D (խ)
	{ 0x00, 0x00, 0x01, 0x02, 0x04, 0x1e, 0x09, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+056E (ծ)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x11, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10 },	// U+056F (կ)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0570 (հ)
	{ 0x00, 0x00, 0x04, 0x02, 0x04, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00 },	// U+0571 (ձ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0b, 0x09, 0x09, 0x09, 0x08, 0x18 },	// U+0572 (ղ)
	{ 0x00, 0x00, 0x0c, 0x12, 0x02, 0x1f, 0x12, 0x12, 0x1a, 0x14, 0x00, 0x00 },	// U+0573 (ճ)
	{ 0x00, 0x00, 0x10, 0x08, 0x08, 0x09, 0x09, 0x09, 0x0d, 0x0a, 0x00, 0x00 },	// U+0574 (մ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x11, 0x11, 0x0e },	// U+0575 (յ)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x19, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00 },	// U+0576 (ն)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x10, 0x10, 0x08, 0x04, 0x02, 0x1c },	// U+0577 (շ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+0578 (ո)
	{ 0x00, 0x00, 0x04, 0x02, 0x04, 0x04, 0x02, 0x02, 0x01, 0x1f, 0x00, 0x00 },	// U+0579 (չ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x15, 0x15, 0x15, 0x1a, 0x10, 0x10 },	// U+057A (պ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0a, 0x04, 0x02, 0x1c },	// U+057B (ջ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0b, 0x09, 0x09, 0x19, 0x00, 0x00 },	// U+057C (ռ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x19, 0x16, 0x00, 0x00 },	// U+057D (ս)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x09, 0x09, 0x09, 0x09, 0x0e, 0x08, 0x18 },	// U+057E (վ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x15, 0x15, 0x15, 0x16, 0x00, 0x00 },	// U+057F (տ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x01, 0x01 },	// U+0580 (ր)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1e, 0x10, 0x11, 0x0e },	// U+0581 (ց)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x1c, 0x00, 0x00 },	// U+0582 (ւ)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x0d, 0x15, 0x15, 0x15, 0x16, 0x04, 0x04 },	// U+0583 (փ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0e, 0x02, 0x1f, 0x02 },	// U+0584 (ք)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+0585 (օ)
	{ 0x00, 0x00, 0x06, 0x05, 0x05, 0x0e, 0x14, 0x14, 0x15, 0x0e, 0x04, 0x04 },	// U+0586 (ֆ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x09, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+0587 (և)
}; // 39

static const unsigned char orpb_block12[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0589 (։)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+058A (֊)
}; // 2

static const unsigned char orpb_block13[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a },	// U+0591 (֑)
	{ 0x00, 0x04, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0592 (֒)
	{ 0x08, 0x04, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0593 (֓)
	{ 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0594 (֔)
	{ 0x00, 0x0a, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0595 (֕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08 },	// U+0596 (֖)
	{ 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0597 (֗)
	{ 0x00, 0x12, 0x15, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0598 (֘)
	{ 0x00, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0599 (֙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x20 },	// U+059A (֚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x08 },	// U+059B (֛)
	{ 0x00, 0x18, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+059C (֜)
	{ 0x00, 0x20, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+059D (֝)
	{ 0x08, 0x24, 0x14, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+059E (֞)
	{ 0x00, 0x0a, 0x15, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+059F (֟)
	{ 0x00, 0x08, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05A0 (֠)
	{ 0x00, 0x0a, 0x0b, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05A1 (֡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x04 },	// U+05A2 (֢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0e },	// U+05A3 (֣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x04 },	// U+05A4 (֤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04 },	// U+05A5 (֥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x09 },	// U+05A6 (֦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x08, 0x04 },	// U+05A7 (֧)
	{ 0x00, 0x02, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05A8 (֨)
	{ 0x00, 0x02, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05A9 (֩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x04 },	// U+05AA (֪)
	{ 0x00, 0x04, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05AB (֫)
	{ 0x00, 0x08, 0x08, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05AC (֬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20 },	// U+05AD (֭)
	{ 0x08, 0x0a, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05AE (֮)
	{ 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05AF (֯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04 },	// U+05B0 (ְ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x12 },	// U+05B1 (ֱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x10 },	// U+05B2 (ֲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x12 },	// U+05B3 (ֳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04 },	// U+05B4 (ִ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a },	// U+05B5 (ֵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x04 },	// U+05B6 (ֶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e },	// U+05B7 (ַ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04 },	// U+05B8 (ָ)
	{ 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05B9 (ֹ)
	{ 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05BA (ֺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x10 },	// U+05BB (ֻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05BC (ּ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04 },	// U+05BD (ֽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05BE (־)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05BF (ֿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+05C0 (׀)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05C1 (ׁ)
	{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05C2 (ׂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00 },	// U+05C3 (׃)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05C4 (ׄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06 },	// U+05C5 (ׅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x0e, 0x00, 0x00 },	// U+05C6 (׆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04 },	// U+05C7 (ׇ)
}; // 55

static const unsigned char orpb_block14[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x16, 0x09, 0x13, 0x00, 0x00 },	// U+05D0 (א)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 0x1f, 0x00, 0x00 },	// U+05D1 (ב)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x14, 0x12, 0x00, 0x00 },	// U+05D2 (ג)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+05D3 (ד)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x11, 0x11, 0x00, 0x00 },	// U+05D4 (ה)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+05D5 (ו)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+05D6 (ז)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+05D7 (ח)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x15, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+05D8 (ט)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+05D9 (י)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+05DA (ך)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00 },	// U+05DB (כ)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x1f, 0x10, 0x10, 0x08, 0x06, 0x00, 0x00 },	// U+05DC (ל)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x12, 0x1e, 0x00, 0x00 },	// U+05DD (ם)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x15, 0x12, 0x11, 0x1d, 0x00, 0x00 },	// U+05DE (מ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+05DF (ן)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x1e, 0x00, 0x00 },	// U+05E0 (נ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x0a, 0x06, 0x00, 0x00 },	// U+05E1 (ס)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x12, 0x12, 0x0a, 0x07, 0x00, 0x00 },	// U+05E2 (ע)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10 },	// U+05E3 (ף)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x10, 0x0f, 0x00, 0x00 },	// U+05E4 (פ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x12, 0x0a, 0x06, 0x02, 0x02 },	// U+05E5 (ץ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x14, 0x08, 0x1f, 0x00, 0x00 },	// U+05E6 (צ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x11, 0x11, 0x0d, 0x01, 0x01 },	// U+05E7 (ק)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+05E8 (ר)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x17, 0x11, 0x0f, 0x00, 0x00 },	// U+05E9 (ש)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x12, 0x12, 0x13, 0x00, 0x00 },	// U+05EA (ת)
}; // 27

static const unsigned char orpb_block15[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+05F0 (װ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x12, 0x12, 0x10, 0x10, 0x00, 0x00 },	// U+05F1 (ױ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+05F2 (ײ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05F3 (׳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05F4 (״)
}; // 5

static const unsigned char orpb_block16[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1680 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1681 (ᚁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+1682 (ᚂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x1c, 0x1c, 0x1c, 0x00, 0x00 },	// U+1683 (ᚃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x1e, 0x1e, 0x1e, 0x00, 0x00 },	// U+1684 (ᚄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x1f, 0x1f, 0x1f, 0x00, 0x00 },	// U+1685 (ᚅ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1686 (ᚆ)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1687 (ᚇ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1688 (ᚈ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1689 (ᚉ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+168A (ᚊ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3f, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+168B (ᚋ)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x3f, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+168C (ᚌ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x3f, 0x0e, 0x0e, 0x0e, 0x00, 0x00 },	// U+168D (ᚍ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3f, 0x1e, 0x1e, 0x1e, 0x00, 0x00 },	// U+168E (ᚎ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x3f, 0x1f, 0x1f, 0x1f, 0x00, 0x00 },	// U+168F (ᚏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3f, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+1690 (ᚐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x3f, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+1691 (ᚑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3f, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+1692 (ᚒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+1693 (ᚓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+1694 (ᚔ)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x08, 0x3f, 0x08, 0x14, 0x14, 0x00, 0x00 },	// U+1695 (ᚕ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x21, 0x3f, 0x21, 0x12, 0x0c, 0x00, 0x00 },	// U+1696 (ᚖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x02, 0x1a, 0x12, 0x1e, 0x00 },	// U+1697 (ᚗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x1b, 0x0e, 0x1b, 0x00, 0x00 },	// U+1698 (ᚘ)
	{ 0x00, 0x14, 0x3e, 0x14, 0x3e, 0x14, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1699 (ᚙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x1e, 0x00, 0x00, 0x00 },	// U+169A (ᚚ)
	{ 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x38, 0x04, 0x02, 0x01, 0x00, 0x00 },	// U+169B (᚛)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x0f, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+169C (᚜)
}; // 29

static const unsigned char orpb_block17[][12] = {
	{ 0x00, 0x12, 0x0a, 0x06, 0x12, 0x0a, 0x06, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+16A0 (ᚠ)
	{ 0x08, 0x02, 0x12, 0x0a, 0x06, 0x12, 0x0a, 0x06, 0x02, 0x02, 0x00, 0x00 },	// U+16A1 (ᚡ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+16A2 (ᚢ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+16A3 (ᚣ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x11, 0x15, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+16A4 (ᚤ)
	{ 0x00, 0x01, 0x03, 0x05, 0x09, 0x13, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+16A5 (ᚥ)
	{ 0x00, 0x02, 0x02, 0x06, 0x0a, 0x12, 0x0a, 0x06, 0x02, 0x02, 0x00, 0x00 },	// U+16A6 (ᚦ)
	{ 0x00, 0x02, 0x02, 0x06, 0x0a, 0x16, 0x0a, 0x06, 0x02, 0x02, 0x00, 0x00 },	// U+16A7 (ᚧ)
	{ 0x00, 0x02, 0x06, 0x0a, 0x12, 0x06, 0x0a, 0x12, 0x02, 0x02, 0x00, 0x00 },	// U+16A8 (ᚨ)
	{ 0x00, 0x13, 0x0d, 0x01, 0x13, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+16A9 (ᚩ)
	{ 0x00, 0x11, 0x0b, 0x05, 0x01, 0x03, 0x0d, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+16AA (ᚪ)
	{ 0x00, 0x02, 0x06, 0x0a, 0x12, 0x06, 0x0a, 0x12, 0x02, 0x02, 0x00, 0x00 },	// U+16AB (ᚫ)
	{ 0x00, 0x04, 0x05, 0x06, 0x0c, 0x15, 0x06, 0x0c, 0x14, 0x04, 0x00, 0x00 },	// U+16AC (ᚬ)
	{ 0x00, 0x02, 0x02, 0x02, 0x06, 0x0a, 0x02, 0x06, 0x0a, 0x02, 0x00, 0x00 },	// U+16AD (ᚭ)
	{ 0x00, 0x04, 0x04, 0x04, 0x06, 0x05, 0x04, 0x06, 0x05, 0x04, 0x00, 0x00 },	// U+16AE (ᚮ)
	{ 0x00, 0x04, 0x14, 0x0c, 0x06, 0x15, 0x0c, 0x06, 0x05, 0x04, 0x00, 0x00 },	// U+16AF (ᚯ)
	{ 0x00, 0x04, 0x14, 0x0c, 0x06, 0x05, 0x04, 0x06, 0x05, 0x04, 0x00, 0x00 },	// U+16B0 (ᚰ)
	{ 0x00, 0x03, 0x0d, 0x11, 0x0d, 0x03, 0x05, 0x09, 0x11, 0x01, 0x00, 0x00 },	// U+16B1 (ᚱ)
	{ 0x00, 0x00, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+16B2 (ᚲ)
	{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+16B3 (ᚳ)
	{ 0x00, 0x11, 0x09, 0x05, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+16B4 (ᚴ)
	{ 0x04, 0x11, 0x09, 0x05, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+16B5 (ᚵ)
	{ 0x00, 0x22, 0x12, 0x0a, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+16B6 (ᚶ)
	{ 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+16B7 (ᚷ)
	{ 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x15, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+16B8 (ᚸ)
	{ 0x00, 0x03, 0x0d, 0x11, 0x0d, 0x03, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+16B9 (ᚹ)
	{ 0x00, 0x11, 0x11, 0x11, 0x13, 0x15, 0x19, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+16BA (ᚺ)
	{ 0x00, 0x11, 0x11, 0x13, 0x15, 0x1b, 0x15, 0x19, 0x11, 0x11, 0x00, 0x00 },	// U+16BB (ᚻ)
	{ 0x00, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x00, 0x00 },	// U+16BC (ᚼ)
	{ 0x00, 0x04, 0x04, 0x04, 0x0e, 0x0e, 0x0e, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16BD (ᚽ)
	{ 0x00, 0x04, 0x04, 0x05, 0x06, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x00, 0x00 },	// U+16BE (ᚾ)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16BF (ᚿ)
	{ 0x00, 0x04, 0x04, 0x05, 0x0e, 0x0e, 0x0e, 0x14, 0x04, 0x04, 0x00, 0x00 },	// U+16C0 (ᛀ)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16C1 (ᛁ)
	{ 0x00, 0x04, 0x04, 0x04, 0x0e, 0x0e, 0x0e, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16C2 (ᛂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x09, 0x12, 0x08, 0x04, 0x00, 0x00 },	// U+16C3 (ᛃ)
	{ 0x00, 0x04, 0x04, 0x04, 0x0e, 0x15, 0x0e, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16C4 (ᛄ)
	{ 0x00, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x06, 0x05, 0x04, 0x04, 0x00, 0x00 },	// U+16C5 (ᛅ)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x05, 0x04, 0x04, 0x00, 0x00 },	// U+16C6 (ᛆ)
	{ 0x00, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x05, 0x06, 0x04, 0x00, 0x00 },	// U+16C7 (ᛇ)
	{ 0x00, 0x11, 0x0b, 0x05, 0x01, 0x01, 0x01, 0x05, 0x0b, 0x11, 0x00, 0x00 },	// U+16C8 (ᛈ)
	{ 0x00, 0x15, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16C9 (ᛉ)
	{ 0x00, 0x08, 0x04, 0x02, 0x04, 0x08, 0x04, 0x02, 0x04, 0x08, 0x00, 0x00 },	// U+16CA (ᛊ)
	{ 0x00, 0x01, 0x01, 0x11, 0x19, 0x15, 0x13, 0x11, 0x10, 0x10, 0x00, 0x00 },	// U+16CB (ᛋ)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+16CC (ᛌ)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+16CD (ᛍ)
	{ 0x00, 0x04, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+16CE (ᛎ)
	{ 0x00, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16CF (ᛏ)
	{ 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+16D0 (ᛐ)
	{ 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x1c, 0x1c, 0x08, 0x08, 0x00, 0x00 },	// U+16D1 (ᛑ)
	{ 0x00, 0x03, 0x05, 0x09, 0x05, 0x03, 0x05, 0x09, 0x05, 0x03, 0x00, 0x00 },	// U+16D2 (ᛒ)
	{ 0x00, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x14, 0x0c, 0x04, 0x04, 0x00, 0x00 },	// U+16D3 (ᛓ)
	{ 0x00, 0x0f, 0x11, 0x15, 0x11, 0x0f, 0x11, 0x15, 0x11, 0x0f, 0x00, 0x00 },	// U+16D4 (ᛔ)
	{ 0x00, 0x11, 0x09, 0x05, 0x03, 0x01, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+16D5 (ᛕ)
	{ 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+16D6 (ᛖ)
	{ 0x00, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+16D7 (ᛗ)
	{ 0x00, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16D8 (ᛘ)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16D9 (ᛙ)
	{ 0x00, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16DA (ᛚ)
	{ 0x00, 0x04, 0x0c, 0x14, 0x04, 0x0e, 0x0e, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16DB (ᛛ)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+16DC (ᛜ)
	{ 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+16DD (ᛝ)
	{ 0x00, 0x11, 0x1b, 0x1b, 0x15, 0x15, 0x15, 0x1b, 0x1b, 0x11, 0x00, 0x00 },	// U+16DE (ᛞ)
	{ 0x00, 0x04, 0x0a, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+16DF (ᛟ)
	{ 0x00, 0x1f, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16E0 (ᛠ)
	{ 0x00, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x00, 0x00 },	// U+16E1 (ᛡ)
	{ 0x00, 0x14, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x05, 0x00, 0x00 },	// U+16E2 (ᛢ)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x15, 0x00, 0x00 },	// U+16E3 (ᛣ)
	{ 0x00, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x15, 0x15, 0x00, 0x00 },	// U+16E4 (ᛤ)
	{ 0x00, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x00, 0x00 },	// U+16E5 (ᛥ)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x00, 0x00 },	// U+16E6 (ᛦ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16E7 (ᛧ)
	{ 0x00, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+16E8 (ᛨ)
	{ 0x00, 0x18, 0x16, 0x11, 0x16, 0x18, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+16E9 (ᛩ)
	{ 0x00, 0x02, 0x07, 0x02, 0x0a, 0x0e, 0x0a, 0x08, 0x1c, 0x08, 0x00, 0x00 },	// U+16EA (ᛪ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+16EB (᛫)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+16EC (᛬)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+16ED (᛭)
	{ 0x00, 0x04, 0x0c, 0x14, 0x04, 0x06, 0x05, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+16EE (ᛮ)
	{ 0x00, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x00, 0x00 },	// U+16EF (ᛯ)
	{ 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+16F0 (ᛰ)
}; // 81

static const unsigned char orpb_block18[][12] = {
	{ 0x00, 0x04, 0x00, 0x0f, 0x12, 0x12, 0x0e, 0x12, 0x12, 0x0f, 0x00, 0x00 },	// U+1E02 (Ḃ)
	{ 0x00, 0x04, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x00 },	// U+1E03 (ḃ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x0e, 0x12, 0x12, 0x0f, 0x00, 0x04 },	// U+1E04 (Ḅ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x04 },	// U+1E05 (ḅ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x0e, 0x12, 0x12, 0x0f, 0x00, 0x1f },	// U+1E06 (Ḇ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x00, 0x1f },	// U+1E07 (ḇ)
}; // 6

static const unsigned char orpb_block19[][12] = {
	{ 0x00, 0x04, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0f, 0x00, 0x00 },	// U+1E0A (Ḋ)
	{ 0x00, 0x04, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x00 },	// U+1E0B (ḋ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0f, 0x00, 0x04 },	// U+1E0C (Ḍ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x04 },	// U+1E0D (ḍ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0f, 0x00, 0x1f },	// U+1E0E (Ḏ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x1f },	// U+1E0F (ḏ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0f, 0x04, 0x02 },	// U+1E10 (Ḑ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x04, 0x02 },	// U+1E11 (ḑ)
	{ 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0f, 0x00, 0x04, 0x0a },	// U+1E12 (Ḓ)
	{ 0x00, 0x00, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x04, 0x0a },	// U+1E13 (ḓ)
}; // 10

static const unsigned char orpb_block20[][12] = {
	{ 0x00, 0x04, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+1E1E (Ḟ)
	{ 0x00, 0x04, 0x00, 0x0c, 0x12, 0x02, 0x07, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+1E1F (ḟ)
}; // 2

static const unsigned char orpb_block21[][12] = {
	{ 0x08, 0x04, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+1E30 (Ḱ)
	{ 0x00, 0x08, 0x04, 0x01, 0x01, 0x11, 0x09, 0x07, 0x09, 0x11, 0x00, 0x00 },	// U+1E31 (ḱ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x04 },	// U+1E32 (Ḳ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x11, 0x09, 0x07, 0x09, 0x11, 0x00, 0x04 },	// U+1E33 (ḳ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x1f },	// U+1E34 (Ḵ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x11, 0x09, 0x07, 0x09, 0x11, 0x00, 0x1f },	// U+1E35 (ḵ)
}; // 6

static const unsigned char orpb_block22[][12] = {
	{ 0x08, 0x04, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1E3E (Ḿ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0b, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+1E3F (ḿ)
	{ 0x00, 0x04, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1E40 (Ṁ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0b, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+1E41 (ṁ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x04 },	// U+1E42 (Ṃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x15, 0x15, 0x15, 0x15, 0x00, 0x04 },	// U+1E43 (ṃ)
}; // 6

static const unsigned char orpb_block23[][12] = {
	{ 0x08, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+1E54 (Ṕ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01 },	// U+1E55 (ṕ)
	{ 0x00, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+1E56 (Ṗ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01 },	// U+1E57 (ṗ)
}; // 4

static const unsigned char orpb_block24[][12] = {
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+1E60 (Ṡ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00 },	// U+1E61 (ṡ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x04 },	// U+1E62 (Ṣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x04 },	// U+1E63 (ṣ)
	{ 0x12, 0x08, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+1E64 (Ṥ)
	{ 0x00, 0x00, 0x12, 0x08, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00 },	// U+1E65 (ṥ)
	{ 0x04, 0x00, 0x0a, 0x04, 0x1e, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+1E66 (Ṧ)
	{ 0x04, 0x00, 0x0a, 0x04, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x00 },	// U+1E67 (ṧ)
	{ 0x00, 0x04, 0x00, 0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00, 0x04 },	// U+1E68 (Ṩ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1e, 0x01, 0x0e, 0x10, 0x0f, 0x00, 0x04 },	// U+1E69 (ṩ)
	{ 0x00, 0x04, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1E6A (Ṫ)
	{ 0x00, 0x04, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00 },	// U+1E6B (ṫ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04 },	// U+1E6C (Ṭ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x18, 0x00, 0x04 },	// U+1E6D (ṭ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x1f },	// U+1E6E (Ṯ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x18, 0x00, 0x1f },	// U+1E6F (ṯ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04, 0x0a },	// U+1E70 (Ṱ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x18, 0x00, 0x04, 0x0a },	// U+1E71 (ṱ)
}; // 18

static const unsigned char orpb_block25[][12] = {
	{ 0x02, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1E80 (Ẁ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1E81 (ẁ)
	{ 0x08, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1E82 (Ẃ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1E83 (ẃ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1E84 (Ẅ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1E85 (ẅ)
	{ 0x00, 0x04, 0x00, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1E86 (Ẇ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1E87 (ẇ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04 },	// U+1E88 (Ẉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04 },	// U+1E89 (ẉ)
	{ 0x00, 0x04, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+1E8A (Ẋ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+1E8B (ẋ)
	{ 0x00, 0x0a, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+1E8C (Ẍ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+1E8D (ẍ)
	{ 0x00, 0x04, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1E8E (Ẏ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x02, 0x01 },	// U+1E8F (ẏ)
}; // 16

static const unsigned char orpb_block26[][12] = {
	{ 0x02, 0x04, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1EF2 (Ỳ)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x02, 0x01 },	// U+1EF3 (ỳ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04 },	// U+1EF4 (Ỵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x02, 0x11 },	// U+1EF5 (ỵ)
	{ 0x04, 0x0a, 0x08, 0x04, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1EF6 (Ỷ)
	{ 0x04, 0x0a, 0x08, 0x04, 0x04, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x02, 0x01 },	// U+1EF7 (ỷ)
	{ 0x16, 0x0d, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1EF8 (Ỹ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x02, 0x01 },	// U+1EF9 (ỹ)
}; // 8

static const unsigned char orpb_block27[][12] = {
	{ 0x00, 0x00, 0x06, 0x04, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1F00 (ἀ)
	{ 0x00, 0x00, 0x0c, 0x04, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1F01 (ἁ)
	{ 0x00, 0x00, 0x0b, 0x12, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1F02 (ἂ)
	{ 0x00, 0x00, 0x0b, 0x11, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1F03 (ἃ)
	{ 0x00, 0x00, 0x13, 0x0a, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1F04 (ἄ)
	{ 0x00, 0x00, 0x13, 0x09, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1F05 (ἅ)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x08, 0x00, 0x16, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1F06 (ἆ)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x04, 0x00, 0x16, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1F07 (ἇ)
	{ 0x03, 0x02, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F08 (Ἀ)
	{ 0x03, 0x01, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F09 (Ἁ)
	{ 0x0b, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F0A (Ἂ)
	{ 0x0b, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F0B (Ἃ)
	{ 0x13, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F0C (Ἄ)
	{ 0x13, 0x09, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F0D (Ἅ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x01, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, 0x00 },	// U+1F0E (Ἆ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x02, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, 0x00 },	// U+1F0F (Ἇ)
	{ 0x00, 0x00, 0x06, 0x04, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+1F10 (ἐ)
	{ 0x00, 0x00, 0x0c, 0x04, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+1F11 (ἑ)
	{ 0x00, 0x00, 0x0b, 0x12, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+1F12 (ἒ)
	{ 0x00, 0x00, 0x0b, 0x11, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+1F13 (ἓ)
	{ 0x00, 0x00, 0x13, 0x0a, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+1F14 (ἔ)
	{ 0x00, 0x00, 0x13, 0x09, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+1F15 (ἕ)
}; // 22

static const unsigned char orpb_block28[][12] = {
	{ 0x03, 0x02, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+1F18 (Ἐ)
	{ 0x03, 0x01, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+1F19 (Ἑ)
	{ 0x0b, 0x12, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+1F1A (Ἒ)
	{ 0x0b, 0x11, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+1F1B (Ἓ)
	{ 0x13, 0x0a, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+1F1C (Ἔ)
	{ 0x13, 0x09, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+1F1D (Ἕ)
}; // 6

static const unsigned char orpb_block29[][12] = {
	{ 0x00, 0x00, 0x06, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+1F20 (ἠ)
	{ 0x00, 0x00, 0x0c, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+1F21 (ἡ)
	{ 0x00, 0x00, 0x0b, 0x12, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+1F22 (ἢ)
	{ 0x00, 0x00, 0x0b, 0x11, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+1F23 (ἣ)
	{ 0x00, 0x00, 0x13, 0x0a, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+1F24 (ἤ)
	{ 0x00, 0x00, 0x13, 0x09, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+1F25 (ἥ)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x08, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x10, 0x10 },	// U+1F26 (ἦ)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x10, 0x10 },	// U+1F27 (ἧ)
	{ 0x03, 0x02, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F28 (Ἠ)
	{ 0x03, 0x01, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F29 (Ἡ)
	{ 0x0b, 0x12, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F2A (Ἢ)
	{ 0x0b, 0x11, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F2B (Ἣ)
	{ 0x13, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F2C (Ἤ)
	{ 0x13, 0x09, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1F2D (Ἥ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x01, 0x14, 0x14, 0x1c, 0x14, 0x14, 0x00, 0x00 },	// U+1F2E (Ἦ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x02, 0x14, 0x14, 0x1c, 0x14, 0x14, 0x00, 0x00 },	// U+1F2F (Ἧ)
	{ 0x00, 0x00, 0x06, 0x04, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+1F30 (ἰ)
	{ 0x00, 0x00, 0x06, 0x02, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+1F31 (ἱ)
	{ 0x00, 0x00, 0x0b, 0x12, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+1F32 (ἲ)
	{ 0x00, 0x00, 0x0b, 0x11, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+1F33 (ἳ)
	{ 0x00, 0x00, 0x13, 0x0a, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+1F34 (ἴ)
	{ 0x00, 0x00, 0x13, 0x09, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+1F35 (ἵ)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x08, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+1F36 (ἶ)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x04, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+1F37 (ἷ)
	{ 0x03, 0x02, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+1F38 (Ἰ)
	{ 0x03, 0x01, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+1F39 (Ἱ)
	{ 0x0b, 0x12, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+1F3A (Ἲ)
	{ 0x0b, 0x11, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+1F3B (Ἳ)
	{ 0x13, 0x0a, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+1F3C (Ἴ)
	{ 0x13, 0x09, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+1F3D (Ἵ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x39, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+1F3E (Ἶ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x3a, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00 },	// U+1F3F (Ἷ)
	{ 0x00, 0x00, 0x06, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F40 (ὀ)
	{ 0x00, 0x00, 0x0c, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F41 (ὁ)
	{ 0x00, 0x00, 0x0b, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F42 (ὂ)
	{ 0x00, 0x00, 0x0b, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F43 (ὃ)
	{ 0x00, 0x00, 0x13, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F44 (ὄ)
	{ 0x00, 0x00, 0x13, 0x09, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F45 (ὅ)
}; // 38

static const unsigned char orpb_block30[][12] = {
	{ 0x03, 0x02, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F48 (Ὀ)
	{ 0x03, 0x01, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F49 (Ὁ)
	{ 0x0b, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F4A (Ὂ)
	{ 0x0b, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F4B (Ὃ)
	{ 0x13, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F4C (Ὄ)
	{ 0x13, 0x09, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F4D (Ὅ)
}; // 6

static const unsigned char orpb_block31[][12] = {
	{ 0x00, 0x00, 0x06, 0x04, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F50 (ὐ)
	{ 0x00, 0x00, 0x0c, 0x04, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F51 (ὑ)
	{ 0x00, 0x00, 0x0b, 0x12, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F52 (ὒ)
	{ 0x00, 0x00, 0x0b, 0x11, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F53 (ὓ)
	{ 0x00, 0x00, 0x13, 0x0a, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F54 (ὔ)
	{ 0x00, 0x00, 0x13, 0x09, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F55 (ὕ)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x08, 0x00, 0x09, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F56 (ὖ)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x04, 0x00, 0x09, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F57 (ὗ)
}; // 8

static const unsigned char orpb_block32[][12] = {
	{ 0x03, 0x01, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1F59 (Ὑ)
}; // 1

static const unsigned char orpb_block33[][12] = {
	{ 0x0b, 0x11, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1F5B (Ὓ)
}; // 1

static const unsigned char orpb_block34[][12] = {
	{ 0x13, 0x09, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1F5D (Ὕ)
}; // 1

static const unsigned char orpb_block35[][12] = {
	{ 0x16, 0x0d, 0x00, 0x03, 0x2a, 0x28, 0x28, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+1F5F (Ὗ)
	{ 0x00, 0x00, 0x06, 0x04, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1F60 (ὠ)
	{ 0x00, 0x00, 0x0c, 0x04, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1F61 (ὡ)
	{ 0x00, 0x00, 0x0b, 0x12, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1F62 (ὢ)
	{ 0x00, 0x00, 0x0b, 0x11, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1F63 (ὣ)
	{ 0x00, 0x00, 0x13, 0x0a, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1F64 (ὤ)
	{ 0x00, 0x00, 0x13, 0x09, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1F65 (ὥ)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x08, 0x00, 0x0a, 0x11, 0x15, 0x0a, 0x00, 0x00 },	// U+1F66 (ὦ)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x04, 0x00, 0x0a, 0x11, 0x15, 0x0a, 0x00, 0x00 },	// U+1F67 (ὧ)
	{ 0x03, 0x02, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+1F68 (Ὠ)
	{ 0x03, 0x01, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+1F69 (Ὡ)
	{ 0x0b, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+1F6A (Ὢ)
	{ 0x0b, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+1F6B (Ὣ)
	{ 0x13, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+1F6C (Ὤ)
	{ 0x13, 0x09, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+1F6D (Ὥ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x01, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00 },	// U+1F6E (Ὦ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x02, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00 },	// U+1F6F (Ὧ)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1F70 (ὰ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1F71 (ά)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+1F72 (ὲ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x00 },	// U+1F73 (έ)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+1F74 (ὴ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+1F75 (ή)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+1F76 (ὶ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+1F77 (ί)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F78 (ὸ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F79 (ό)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F7A (ὺ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1F7B (ύ)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1F7C (ὼ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1F7D (ώ)
}; // 31

static const unsigned char orpb_block36[][12] = {
	{ 0x00, 0x06, 0x04, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1F80 (ᾀ)
	{ 0x00, 0x0c, 0x04, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1F81 (ᾁ)
	{ 0x00, 0x0b, 0x12, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1F82 (ᾂ)
	{ 0x00, 0x0b, 0x11, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1F83 (ᾃ)
	{ 0x00, 0x13, 0x0a, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1F84 (ᾄ)
	{ 0x00, 0x13, 0x09, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1F85 (ᾅ)
	{ 0x16, 0x0d, 0x08, 0x04, 0x00, 0x16, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1F86 (ᾆ)
	{ 0x16, 0x0d, 0x04, 0x08, 0x00, 0x16, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1F87 (ᾇ)
	{ 0x03, 0x02, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F88 (ᾈ)
	{ 0x03, 0x01, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F89 (ᾉ)
	{ 0x0b, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F8A (ᾊ)
	{ 0x0b, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F8B (ᾋ)
	{ 0x13, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F8C (ᾌ)
	{ 0x13, 0x09, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F8D (ᾍ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x02, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x04, 0x08 },	// U+1F8E (ᾎ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x01, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x04, 0x08 },	// U+1F8F (ᾏ)
	{ 0x00, 0x06, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1F90 (ᾐ)
	{ 0x00, 0x0c, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1F91 (ᾑ)
	{ 0x00, 0x0b, 0x12, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1F92 (ᾒ)
	{ 0x00, 0x0b, 0x11, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1F93 (ᾓ)
	{ 0x00, 0x13, 0x0a, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1F94 (ᾔ)
	{ 0x00, 0x13, 0x09, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1F95 (ᾕ)
	{ 0x16, 0x0d, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1F96 (ᾖ)
	{ 0x16, 0x0d, 0x04, 0x08, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1F97 (ᾗ)
	{ 0x03, 0x02, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F98 (ᾘ)
	{ 0x03, 0x01, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F99 (ᾙ)
	{ 0x0b, 0x12, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F9A (ᾚ)
	{ 0x0b, 0x11, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F9B (ᾛ)
	{ 0x13, 0x0a, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F9C (ᾜ)
	{ 0x13, 0x09, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1F9D (ᾝ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x02, 0x14, 0x14, 0x1c, 0x14, 0x14, 0x04, 0x08 },	// U+1F9E (ᾞ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x01, 0x14, 0x14, 0x1c, 0x14, 0x14, 0x04, 0x08 },	// U+1F9F (ᾟ)
	{ 0x00, 0x06, 0x04, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FA0 (ᾠ)
	{ 0x00, 0x0c, 0x04, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FA1 (ᾡ)
	{ 0x00, 0x0b, 0x12, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FA2 (ᾢ)
	{ 0x00, 0x0b, 0x11, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FA3 (ᾣ)
	{ 0x00, 0x13, 0x0a, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FA4 (ᾤ)
	{ 0x00, 0x13, 0x09, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FA5 (ᾥ)
	{ 0x16, 0x0d, 0x08, 0x04, 0x00, 0x0a, 0x11, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FA6 (ᾦ)
	{ 0x16, 0x0d, 0x04, 0x08, 0x00, 0x0a, 0x11, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FA7 (ᾧ)
	{ 0x03, 0x02, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x04, 0x08 },	// U+1FA8 (ᾨ)
	{ 0x03, 0x01, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x04, 0x08 },	// U+1FA9 (ᾩ)
	{ 0x0b, 0x12, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x04, 0x08 },	// U+1FAA (ᾪ)
	{ 0x0b, 0x11, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x04, 0x08 },	// U+1FAB (ᾫ)
	{ 0x13, 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x04, 0x08 },	// U+1FAC (ᾬ)
	{ 0x13, 0x09, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x04, 0x08 },	// U+1FAD (ᾭ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x02, 0x1c, 0x22, 0x22, 0x14, 0x36, 0x08, 0x10 },	// U+1FAE (ᾮ)
	{ 0x16, 0x0d, 0x00, 0x03, 0x01, 0x1c, 0x22, 0x22, 0x14, 0x36, 0x08, 0x10 },	// U+1FAF (ᾯ)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1FB0 (ᾰ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1FB1 (ᾱ)
	{ 0x00, 0x02, 0x04, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1FB2 (ᾲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1FB3 (ᾳ)
	{ 0x00, 0x08, 0x04, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1FB4 (ᾴ)
}; // 53

static const unsigned char orpb_block37[][12] = {
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+1FB6 (ᾶ)
	{ 0x00, 0x16, 0x0d, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x08 },	// U+1FB7 (ᾷ)
	{ 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1FB8 (Ᾰ)
	{ 0x00, 0x1f, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1FB9 (Ᾱ)
	{ 0x01, 0x02, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1FBA (Ὰ)
	{ 0x02, 0x01, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1FBB (Ά)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1FBC (ᾼ)
	{ 0x00, 0x00, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FBD (᾽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08 },	// U+1FBE (ι)
	{ 0x00, 0x00, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FBF (᾿)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FC0 (῀)
	{ 0x16, 0x0d, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FC1 (῁)
	{ 0x00, 0x02, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1FC2 (ῂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1FC3 (ῃ)
	{ 0x00, 0x08, 0x04, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1FC4 (ῄ)
}; // 15

static const unsigned char orpb_block38[][12] = {
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x10 },	// U+1FC6 (ῆ)
	{ 0x00, 0x16, 0x0d, 0x00, 0x0d, 0x13, 0x11, 0x11, 0x11, 0x10, 0x11, 0x02 },	// U+1FC7 (ῇ)
	{ 0x01, 0x02, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+1FC8 (Ὲ)
	{ 0x02, 0x01, 0x00, 0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+1FC9 (Έ)
	{ 0x01, 0x02, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1FCA (Ὴ)
	{ 0x02, 0x01, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+1FCB (Ή)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x04, 0x08 },	// U+1FCC (ῌ)
	{ 0x00, 0x00, 0x0b, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FCD (῍)
	{ 0x00, 0x00, 0x13, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FCE (῎)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FCF (῏)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+1FD0 (ῐ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+1FD1 (ῑ)
	{ 0x02, 0x04, 0x00, 0x0a, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+1FD2 (ῒ)
	{ 0x02, 0x04, 0x00, 0x0a, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+1FD3 (ΐ)
}; // 14

static const unsigned char orpb_block39[][12] = {
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+1FD6 (ῖ)
	{ 0x16, 0x0d, 0x00, 0x0a, 0x00, 0x04, 0x04, 0x04, 0x14, 0x08, 0x00, 0x00 },	// U+1FD7 (ῗ)
	{ 0x11, 0x0e, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+1FD8 (Ῐ)
	{ 0x00, 0x1f, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+1FD9 (Ῑ)
	{ 0x01, 0x02, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+1FDA (Ὶ)
	{ 0x02, 0x01, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+1FDB (Ί)
}; // 6

static const unsigned char orpb_block40[][12] = {
	{ 0x00, 0x00, 0x0b, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FDD (῝)
	{ 0x00, 0x00, 0x13, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FDE (῞)
	{ 0x16, 0x0d, 0x00, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FDF (῟)
	{ 0x00, 0x00, 0x11, 0x0e, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1FE0 (ῠ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1FE1 (ῡ)
	{ 0x02, 0x04, 0x00, 0x0a, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1FE2 (ῢ)
	{ 0x02, 0x04, 0x00, 0x0a, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1FE3 (ΰ)
	{ 0x00, 0x00, 0x06, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x13, 0x0d, 0x01, 0x01 },	// U+1FE4 (ῤ)
	{ 0x00, 0x00, 0x0c, 0x04, 0x00, 0x0e, 0x11, 0x11, 0x13, 0x0d, 0x01, 0x01 },	// U+1FE5 (ῥ)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1FE6 (ῦ)
	{ 0x16, 0x0d, 0x00, 0x0a, 0x00, 0x09, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1FE7 (ῧ)
	{ 0x11, 0x0e, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1FE8 (Ῠ)
	{ 0x00, 0x1f, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1FE9 (Ῡ)
	{ 0x01, 0x02, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1FEA (Ὺ)
	{ 0x02, 0x01, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+1FEB (Ύ)
	{ 0x03, 0x01, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+1FEC (Ῥ)
	{ 0x02, 0x04, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FED (῭)
	{ 0x08, 0x04, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FEE (΅)
	{ 0x00, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FEF (`)
}; // 19

static const unsigned char orpb_block41[][12] = {
	{ 0x00, 0x02, 0x04, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FF2 (ῲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FF3 (ῳ)
	{ 0x00, 0x08, 0x04, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FF4 (ῴ)
}; // 3

static const unsigned char orpb_block42[][12] = {
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+1FF6 (ῶ)
	{ 0x00, 0x16, 0x0d, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x04, 0x08 },	// U+1FF7 (ῷ)
	{ 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1FF8 (Ὸ)
	{ 0x00, 0x1f, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+1FF9 (Ό)
	{ 0x01, 0x02, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+1FFA (Ὼ)
	{ 0x02, 0x01, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+1FFB (Ώ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x04, 0x08 },	// U+1FFC (ῼ)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FFD (´)
	{ 0x00, 0x00, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1FFE (῾)
}; // 9

static const unsigned char orpb_block43[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2010 (‐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2011 (‑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2012 (‒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2013 (–)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2014 (—)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2015 (―)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2016 (‖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x3f },	// U+2017 (‗)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2018 (‘)
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2019 (’)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x04, 0x00 },	// U+201A (‚)
	{ 0x00, 0x00, 0x00, 0x0c, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201B (‛)
	{ 0x00, 0x00, 0x00, 0x12, 0x09, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201C (“)
	{ 0x00, 0x00, 0x00, 0x1b, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201D (”)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x12, 0x09, 0x00 },	// U+201E („)
	{ 0x00, 0x00, 0x00, 0x1b, 0x09, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201F (‟)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2020 (†)
	{ 0x00, 0x00, 0x00, 0x04, 0x1f, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2021 (‡)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2022 (•)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00 },	// U+2023 (‣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00 },	// U+2024 (․)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00 },	// U+2025 (‥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00 },	// U+2026 (…)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2027 (‧)
}; // 24

static const unsigned char orpb_block44[][12] = {
	{ 0x00, 0x00, 0x00, 0x12, 0x15, 0x0a, 0x04, 0x16, 0x2b, 0x15, 0x00, 0x00 },	// U+2030 (‰)
	{ 0x00, 0x00, 0x00, 0x12, 0x15, 0x1a, 0x2c, 0x16, 0x2b, 0x15, 0x00, 0x00 },	// U+2031 (‱)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2032 (′)
	{ 0x00, 0x00, 0x00, 0x12, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2033 (″)
	{ 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2034 (‴)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2035 (‵)
	{ 0x00, 0x00, 0x00, 0x09, 0x09, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2036 (‶)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2037 (‷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a },	// U+2038 (‸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x04, 0x08, 0x00, 0x00 },	// U+2039 (‹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+203A (›)
	{ 0x00, 0x00, 0x04, 0x11, 0x0a, 0x04, 0x15, 0x04, 0x0a, 0x11, 0x04, 0x00 },	// U+203B (※)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x0a, 0x00, 0x00 },	// U+203C (‼)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x14, 0x0c, 0x04, 0x00, 0x04, 0x00, 0x00 },	// U+203D (‽)
	{ 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+203E (‾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e },	// U+203F (‿)
	{ 0x00, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2040 (⁀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x04, 0x04, 0x0a, 0x0a },	// U+2041 (⁁)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x0a, 0x1f, 0x0a, 0x00, 0x00 },	// U+2042 (⁂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2043 (⁃)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+2044 (⁄)
	{ 0x00, 0x00, 0x00, 0x0e, 0x02, 0x02, 0x0e, 0x02, 0x02, 0x0e, 0x00, 0x00 },	// U+2045 (⁅)
	{ 0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x0e, 0x08, 0x08, 0x0e, 0x00, 0x00 },	// U+2046 (⁆)
	{ 0x00, 0x00, 0x00, 0x12, 0x2d, 0x24, 0x12, 0x12, 0x00, 0x12, 0x00, 0x00 },	// U+2047 (⁇)
	{ 0x00, 0x00, 0x00, 0x12, 0x15, 0x14, 0x12, 0x12, 0x00, 0x12, 0x00, 0x00 },	// U+2048 (⁈)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x11, 0x09, 0x09, 0x00, 0x09, 0x00, 0x00 },	// U+2049 (⁉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+204A (⁊)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1d, 0x1d, 0x0d, 0x05, 0x05, 0x05, 0x00, 0x00 },	// U+204B (⁋)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x17, 0x17, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+204C (⁌)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1d, 0x1d, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+204D (⁍)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+204E (⁎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x06, 0x04, 0x08 },	// U+204F (⁏)
	{ 0x00, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x00 },	// U+2050 (⁐)
	{ 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2051 (⁑)
	{ 0x00, 0x00, 0x09, 0x08, 0x04, 0x04, 0x02, 0x02, 0x09, 0x01, 0x00, 0x00 },	// U+2052 (⁒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2053 (⁓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x00 },	// U+2054 (⁔)
	{ 0x00, 0x00, 0x00, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+2055 (⁕)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2056 (⁖)
	{ 0x00, 0x3e, 0x3e, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2057 (⁗)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x11, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2058 (⁘)
	{ 0x00, 0x00, 0x00, 0x11, 0x00, 0x04, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2059 (⁙)
	{ 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00 },	// U+205A (⁚)
	{ 0x00, 0x00, 0x04, 0x04, 0x00, 0x11, 0x11, 0x00, 0x04, 0x04, 0x00, 0x00 },	// U+205B (⁛)
	{ 0x00, 0x00, 0x00, 0x15, 0x04, 0x1f, 0x04, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+205C (⁜)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00 },	// U+205D (⁝)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00 },	// U+205E (⁞)
}; // 47

static const unsigned char orpb_block45[][12] = {
	{ 0x04, 0x0a, 0x0a, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2070 (⁰)
	{ 0x04, 0x00, 0x06, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2071 (ⁱ)
}; // 2

static const unsigned char orpb_block46[][12] = {
	{ 0x02, 0x02, 0x0a, 0x0e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2074 (⁴)
	{ 0x0e, 0x02, 0x06, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2075 (⁵)
	{ 0x0c, 0x02, 0x06, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2076 (⁶)
	{ 0x0e, 0x08, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2077 (⁷)
	{ 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2078 (⁸)
	{ 0x04, 0x0a, 0x0c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2079 (⁹)
	{ 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207A (⁺)
	{ 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207B (⁻)
	{ 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207C (⁼)
	{ 0x04, 0x02, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207D (⁽)
	{ 0x02, 0x04, 0x04, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207E (⁾)
	{ 0x00, 0x06, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207F (ⁿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x0a, 0x04 },	// U+2080 (₀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x04, 0x04, 0x0e },	// U+2081 (₁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x04, 0x02, 0x0e },	// U+2082 (₂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x04, 0x08, 0x06 },	// U+2083 (₃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0a, 0x0e, 0x08 },	// U+2084 (₄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x02, 0x06, 0x08, 0x06 },	// U+2085 (₅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x06, 0x0a, 0x04 },	// U+2086 (₆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x04, 0x04, 0x04 },	// U+2087 (₇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x0a, 0x04 },	// U+2088 (₈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0c, 0x08, 0x06 },	// U+2089 (₉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x00 },	// U+208A (₊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00 },	// U+208B (₋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x00 },	// U+208C (₌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x04 },	// U+208D (₍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x04, 0x04, 0x02 },	// U+208E (₎)
}; // 27

static const unsigned char orpb_block47[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x06, 0x05, 0x06, 0x00 },	// U+2090 (ₐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x07, 0x01, 0x06 },	// U+2091 (ₑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x06 },	// U+2092 (ₒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x05 },	// U+2093 (ₓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x07, 0x05, 0x02 },	// U+2094 (ₔ)
}; // 5

static const unsigned char orpb_block48[][12] = {
	{ 0x00, 0x00, 0x00, 0x06, 0x01, 0x1d, 0x05, 0x0e, 0x04, 0x1c, 0x00, 0x00 },	// U+20A0 (₠)
	{ 0x00, 0x00, 0x00, 0x1e, 0x15, 0x15, 0x0b, 0x0b, 0x1b, 0x0e, 0x00, 0x00 },	// U+20A1 (₡)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x0d, 0x05, 0x15, 0x0e, 0x00, 0x00 },	// U+20A2 (₢)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x17, 0x0d, 0x05, 0x05, 0x00, 0x00 },	// U+20A3 (₣)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x07, 0x02, 0x07, 0x12, 0x0d, 0x00, 0x00 },	// U+20A4 (₤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0f, 0x15, 0x15, 0x15, 0x02, 0x00 },	// U+20A5 (₥)
	{ 0x00, 0x00, 0x00, 0x11, 0x13, 0x3f, 0x15, 0x3f, 0x19, 0x11, 0x00, 0x00 },	// U+20A6 (₦)
	{ 0x00, 0x00, 0x00, 0x06, 0x0a, 0x1f, 0x0a, 0x06, 0x02, 0x02, 0x00, 0x00 },	// U+20A7 (₧)
	{ 0x00, 0x00, 0x03, 0x05, 0x05, 0x1b, 0x05, 0x0d, 0x15, 0x0d, 0x00, 0x00 },	// U+20A8 (₨)
	{ 0x00, 0x00, 0x00, 0x3f, 0x11, 0x3f, 0x15, 0x15, 0x1b, 0x11, 0x00, 0x00 },	// U+20A9 (₩)
	{ 0x00, 0x00, 0x06, 0x29, 0x2d, 0x2d, 0x2d, 0x2d, 0x25, 0x19, 0x00, 0x00 },	// U+20AA (₪)
	{ 0x00, 0x00, 0x10, 0x3c, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x1e },	// U+20AB (₫)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x0f, 0x02, 0x0f, 0x02, 0x1c, 0x00, 0x00 },	// U+20AC (€)
	{ 0x00, 0x00, 0x00, 0x12, 0x12, 0x0a, 0x1f, 0x0a, 0x12, 0x12, 0x00, 0x00 },	// U+20AD (₭)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x0c, 0x06, 0x0c, 0x06, 0x04, 0x00, 0x00 },	// U+20AE (₮)
	{ 0x00, 0x00, 0x02, 0x07, 0x0a, 0x12, 0x12, 0x12, 0x17, 0x0b, 0x00, 0x00 },	// U+20AF (₯)
	{ 0x00, 0x00, 0x08, 0x14, 0x14, 0x08, 0x08, 0x0a, 0x16, 0x15, 0x10, 0x08 },	// U+20B0 (₰)
	{ 0x00, 0x00, 0x06, 0x0a, 0x1f, 0x1f, 0x0a, 0x06, 0x02, 0x02, 0x00, 0x00 },	// U+20B1 (₱)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x05, 0x05, 0x1d, 0x15, 0x0e, 0x04, 0x00 },	// U+20B2 (₲)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x1f, 0x11, 0x11, 0x00, 0x00 },	// U+20B3 (₳)
	{ 0x00, 0x00, 0x00, 0x06, 0x08, 0x1f, 0x04, 0x1f, 0x02, 0x0c, 0x00, 0x00 },	// U+20B4 (₴)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x05, 0x05, 0x05, 0x15, 0x0e, 0x04, 0x00 },	// U+20B5 (₵)
}; // 22

static const unsigned char orpb_block49[][12] = {
	{ 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D0 (⃐)
	{ 0x04, 0x08, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D1 (⃑)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+20D2 (⃒)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+20D3 (⃓)
	{ 0x00, 0x0d, 0x13, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D4 (⃔)
	{ 0x00, 0x16, 0x19, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D5 (⃕)
	{ 0x00, 0x02, 0x1f, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D6 (⃖)
	{ 0x00, 0x08, 0x1f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20D7 (⃗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+20D8 (⃘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x17, 0x12, 0x0c, 0x00, 0x00 },	// U+20D9 (⃙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x1d, 0x09, 0x06, 0x00, 0x00 },	// U+20DA (⃚)
	{ 0x00, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20DB (⃛)
	{ 0x00, 0x2d, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20DC (⃜)
	{ 0x1e, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e },	// U+20DD (⃝)
	{ 0x3f, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x3f },	// U+20DE (⃞)
	{ 0x0c, 0x12, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x12, 0x0c },	// U+20DF (⃟)
	{ 0x1e, 0x23, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x31, 0x1e },	// U+20E0 (⃠)
	{ 0x00, 0x0a, 0x1f, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20E1 (⃡)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00 },	// U+20E2 (⃢)
	{ 0x3f, 0x3f, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x3f },	// U+20E3 (⃣)
	{ 0x04, 0x04, 0x04, 0x0a, 0x0a, 0x0a, 0x0a, 0x11, 0x11, 0x11, 0x11, 0x1f },	// U+20E4 (⃤)
	{ 0x00, 0x00, 0x01, 0x01, 0x02, 0x04, 0x04, 0x08, 0x10, 0x10, 0x00, 0x00 },	// U+20E5 (⃥)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+20E6 (⃦)
	{ 0x00, 0x3f, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+20E7 (⃧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15 },	// U+20E8 (⃨)
	{ 0x1f, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20E9 (⃩)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x3f, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+20EA (⃪)
	{ 0x00, 0x00, 0x24, 0x24, 0x24, 0x12, 0x12, 0x09, 0x09, 0x09, 0x00, 0x00 },	// U+20EB (⃫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08 },	// U+20EC (⃬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02 },	// U+20ED (⃭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x02 },	// U+20EE (⃮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x08 },	// U+20EF (⃯)
	{ 0x05, 0x02, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+20F0 (⃰)
}; // 33

static const unsigned char orpb_block50[][12] = {
	{ 0x00, 0x16, 0x15, 0x0e, 0x08, 0x04, 0x02, 0x1a, 0x05, 0x19, 0x00, 0x00 },	// U+2100 (℀)
	{ 0x00, 0x16, 0x15, 0x0e, 0x08, 0x04, 0x1a, 0x06, 0x09, 0x11, 0x0c, 0x00 },	// U+2101 (℁)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x05, 0x05, 0x05, 0x15, 0x0e, 0x00, 0x00 },	// U+2102 (ℂ)
	{ 0x02, 0x05, 0x02, 0x1c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1c, 0x00, 0x00 },	// U+2103 (℃)
	{ 0x00, 0x04, 0x04, 0x0e, 0x05, 0x05, 0x05, 0x0e, 0x04, 0x1c, 0x00, 0x00 },	// U+2104 (℄)
	{ 0x00, 0x12, 0x11, 0x0a, 0x08, 0x04, 0x02, 0x0a, 0x15, 0x09, 0x00, 0x00 },	// U+2105 (℅)
	{ 0x00, 0x12, 0x11, 0x0a, 0x08, 0x04, 0x02, 0x16, 0x15, 0x19, 0x00, 0x00 },	// U+2106 (℆)
	{ 0x00, 0x00, 0x00, 0x1e, 0x11, 0x01, 0x06, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+2107 (ℇ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x1e, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+2108 (℈)
	{ 0x02, 0x05, 0x02, 0x3c, 0x04, 0x04, 0x1c, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2109 (℉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x0c, 0x09, 0x06 },	// U+210A (ℊ)
	{ 0x00, 0x00, 0x00, 0x13, 0x12, 0x12, 0x0e, 0x09, 0x09, 0x09, 0x10, 0x00 },	// U+210B (ℋ)
	{ 0x00, 0x16, 0x09, 0x01, 0x0d, 0x13, 0x12, 0x14, 0x15, 0x12, 0x08, 0x04 },	// U+210C (ℌ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x1d, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+210D (ℍ)
	{ 0x00, 0x00, 0x04, 0x04, 0x02, 0x0e, 0x12, 0x12, 0x09, 0x09, 0x00, 0x00 },	// U+210E (ℎ)
	{ 0x00, 0x00, 0x04, 0x0f, 0x02, 0x0e, 0x12, 0x12, 0x09, 0x09, 0x00, 0x00 },	// U+210F (ℏ)
	{ 0x00, 0x00, 0x1c, 0x10, 0x10, 0x08, 0x08, 0x04, 0x05, 0x02, 0x00, 0x00 },	// U+2110 (ℐ)
	{ 0x00, 0x00, 0x1f, 0x11, 0x12, 0x08, 0x08, 0x10, 0x13, 0x0c, 0x00, 0x00 },	// U+2111 (ℑ)
	{ 0x00, 0x00, 0x08, 0x14, 0x04, 0x04, 0x02, 0x02, 0x26, 0x19, 0x00, 0x00 },	// U+2112 (ℒ)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x14, 0x08, 0x0c, 0x12, 0x00, 0x00 },	// U+2113 (ℓ)
	{ 0x00, 0x00, 0x00, 0x05, 0x0f, 0x05, 0x0d, 0x15, 0x15, 0x0d, 0x00, 0x00 },	// U+2114 (℔)
	{ 0x00, 0x00, 0x00, 0x23, 0x23, 0x25, 0x2d, 0x2d, 0x35, 0x25, 0x00, 0x00 },	// U+2115 (ℕ)
	{ 0x00, 0x00, 0x00, 0x09, 0x09, 0x1b, 0x2d, 0x19, 0x09, 0x39, 0x00, 0x00 },	// U+2116 (№)
	{ 0x00, 0x00, 0x0e, 0x11, 0x17, 0x1b, 0x17, 0x13, 0x11, 0x0e, 0x00, 0x00 },	// U+2117 (℗)
	{ 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x26, 0x1e, 0x05, 0x05, 0x02, 0x00 },	// U+2118 (℘)
	{ 0x00, 0x00, 0x00, 0x0f, 0x15, 0x15, 0x0d, 0x05, 0x05, 0x05, 0x00, 0x00 },	// U+2119 (ℙ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x15, 0x0d, 0x16, 0x00, 0x00 },	// U+211A (ℚ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x0e, 0x05, 0x09, 0x09, 0x00, 0x00 },	// U+211B (ℛ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x15, 0x16, 0x0c, 0x0c, 0x15, 0x12, 0x00, 0x00 },	// U+211C (ℜ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x15, 0x15, 0x0d, 0x0d, 0x15, 0x15, 0x00, 0x00 },	// U+211D (ℝ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x15, 0x09, 0x15, 0x00, 0x00 },	// U+211E (℞)
	{ 0x00, 0x06, 0x04, 0x0f, 0x15, 0x15, 0x0f, 0x05, 0x0d, 0x15, 0x04, 0x00 },	// U+211F (℟)
	{ 0x2a, 0x39, 0x2a, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2120 (℠)
	{ 0x07, 0x02, 0x02, 0x0e, 0x04, 0x0c, 0x04, 0x0c, 0x08, 0x08, 0x08, 0x18 },	// U+2121 (℡)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3a, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2122 (™)
	{ 0x07, 0x04, 0x15, 0x15, 0x15, 0x0a, 0x0a, 0x0a, 0x05, 0x05, 0x01, 0x00 },	// U+2123 (℣)
	{ 0x00, 0x00, 0x00, 0x1f, 0x14, 0x12, 0x0a, 0x09, 0x05, 0x1f, 0x00, 0x00 },	// U+2124 (ℤ)
	{ 0x00, 0x00, 0x1e, 0x08, 0x04, 0x1e, 0x08, 0x04, 0x0e, 0x10, 0x11, 0x0e },	// U+2125 (℥)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x00 },	// U+2126 (Ω)
	{ 0x00, 0x00, 0x00, 0x1b, 0x0a, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+2127 (℧)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x14, 0x1c, 0x14, 0x11, 0x0e, 0x00, 0x00 },	// U+2128 (ℨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2129 (℩)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00, 0x00 },	// U+212A (K)
	{ 0x04, 0x0a, 0x04, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+212B (Å)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x0e, 0x09, 0x09, 0x07, 0x00, 0x00 },	// U+212C (ℬ)
	{ 0x00, 0x00, 0x10, 0x2e, 0x09, 0x09, 0x05, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+212D (ℭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x0f, 0x03, 0x0e, 0x00, 0x00 },	// U+212E (℮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x0e, 0x01, 0x06, 0x00, 0x00 },	// U+212F (ℯ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x06, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+2130 (ℰ)
	{ 0x00, 0x00, 0x3e, 0x05, 0x04, 0x1e, 0x04, 0x04, 0x05, 0x02, 0x00, 0x00 },	// U+2131 (ℱ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x1e, 0x10, 0x10, 0x1f, 0x00, 0x00 },	// U+2132 (Ⅎ)
	{ 0x00, 0x00, 0x00, 0x23, 0x36, 0x2a, 0x22, 0x12, 0x12, 0x21, 0x00, 0x00 },	// U+2133 (ℳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+2134 (ℴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x16, 0x09, 0x13, 0x00, 0x00 },	// U+2135 (ℵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 0x1f, 0x00, 0x00 },	// U+2136 (ℶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x14, 0x12, 0x00, 0x00 },	// U+2137 (ℷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2138 (ℸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0e, 0x0c, 0x0c, 0x0e, 0x00, 0x00 },	// U+2139 (ℹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x3e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+213A (℺)
	{ 0x07, 0x01, 0x03, 0x01, 0x0e, 0x0a, 0x0e, 0x0a, 0x28, 0x10, 0x28, 0x00 },	// U+213B (℻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00 },	// U+213C (ℼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x12, 0x15, 0x0a, 0x0a, 0x0a, 0x0a },	// U+213D (ℽ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x15, 0x05, 0x05, 0x05, 0x05, 0x05, 0x00, 0x00 },	// U+213E (ℾ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+213F (ℿ)
	{ 0x00, 0x1f, 0x05, 0x0a, 0x0a, 0x14, 0x0a, 0x0a, 0x05, 0x1f, 0x00, 0x00 },	// U+2140 (⅀)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x13, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+2141 (⅁)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+2142 (⅂)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x00 },	// U+2143 (⅃)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+2144 (⅄)
	{ 0x00, 0x00, 0x1e, 0x2a, 0x2a, 0x2a, 0x15, 0x15, 0x15, 0x0f, 0x00, 0x00 },	// U+2145 (ⅅ)
	{ 0x00, 0x00, 0x00, 0x38, 0x28, 0x28, 0x16, 0x15, 0x15, 0x1e, 0x00, 0x00 },	// U+2146 (ⅆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x2a, 0x1d, 0x05, 0x1e, 0x00, 0x00 },	// U+2147 (ⅇ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x1e, 0x14, 0x14, 0x0a, 0x0a, 0x00, 0x00 },	// U+2148 (ⅈ)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x1e, 0x14, 0x14, 0x0a, 0x0a, 0x0a, 0x07 },	// U+2149 (ⅉ)
	{ 0x00, 0x00, 0x04, 0x04, 0x0f, 0x15, 0x15, 0x0d, 0x04, 0x1c, 0x00, 0x00 },	// U+214A (⅊)
	{ 0x00, 0x00, 0x00, 0x0d, 0x12, 0x17, 0x08, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+214B (⅋)
	{ 0x00, 0x1d, 0x25, 0x2f, 0x35, 0x1f, 0x15, 0x05, 0x05, 0x02, 0x00, 0x00 },	// U+214C (⅌)
	{ 0x02, 0x15, 0x17, 0x0d, 0x08, 0x04, 0x12, 0x0a, 0x11, 0x09, 0x00, 0x00 },	// U+214D (⅍)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x1c, 0x10, 0x1e, 0x00, 0x00 },	// U+214E (ⅎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x15, 0x00, 0x00, 0x00 },	// U+214F (⅏)
}; // 80

static const unsigned char orpb_block51[][12] = {
	{ 0x02, 0x12, 0x12, 0x0a, 0x08, 0x1c, 0x22, 0x12, 0x21, 0x19, 0x00, 0x00 },	// U+2153 (⅓)
	{ 0x02, 0x15, 0x12, 0x0f, 0x08, 0x1c, 0x22, 0x12, 0x21, 0x19, 0x00, 0x00 },	// U+2154 (⅔)
	{ 0x02, 0x12, 0x12, 0x0a, 0x08, 0x04, 0x1a, 0x0a, 0x11, 0x09, 0x00, 0x00 },	// U+2155 (⅕)
	{ 0x02, 0x15, 0x12, 0x0f, 0x08, 0x04, 0x1a, 0x0a, 0x11, 0x09, 0x00, 0x00 },	// U+2156 (⅖)
	{ 0x03, 0x14, 0x12, 0x0c, 0x0b, 0x04, 0x1a, 0x0a, 0x11, 0x09, 0x00, 0x00 },	// U+2157 (⅗)
	{ 0x01, 0x13, 0x17, 0x0a, 0x08, 0x04, 0x1a, 0x0a, 0x11, 0x09, 0x00, 0x00 },	// U+2158 (⅘)
	{ 0x02, 0x12, 0x12, 0x0a, 0x08, 0x14, 0x0a, 0x1a, 0x29, 0x11, 0x00, 0x00 },	// U+2159 (⅙)
	{ 0x03, 0x11, 0x12, 0x09, 0x08, 0x14, 0x0a, 0x1a, 0x29, 0x11, 0x00, 0x00 },	// U+215A (⅚)
	{ 0x02, 0x12, 0x12, 0x0a, 0x08, 0x14, 0x2a, 0x12, 0x29, 0x11, 0x00, 0x00 },	// U+215B (⅛)
	{ 0x03, 0x14, 0x12, 0x0c, 0x0b, 0x14, 0x2a, 0x12, 0x29, 0x11, 0x00, 0x00 },	// U+215C (⅜)
	{ 0x03, 0x11, 0x12, 0x09, 0x08, 0x14, 0x2a, 0x12, 0x29, 0x11, 0x00, 0x00 },	// U+215D (⅝)
	{ 0x07, 0x14, 0x12, 0x0a, 0x08, 0x14, 0x2a, 0x12, 0x29, 0x11, 0x00, 0x00 },	// U+215E (⅞)
	{ 0x02, 0x12, 0x12, 0x0a, 0x08, 0x04, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00 },	// U+215F (⅟)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2160 (Ⅰ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2161 (Ⅱ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2162 (Ⅲ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x09, 0x09, 0x09, 0x00, 0x00 },	// U+2163 (Ⅳ)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+2164 (Ⅴ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+2165 (Ⅵ)
	{ 0x00, 0x00, 0x00, 0x2b, 0x2b, 0x2b, 0x2b, 0x2a, 0x2a, 0x2a, 0x00, 0x00 },	// U+2166 (Ⅶ)
	{ 0x00, 0x00, 0x00, 0x3b, 0x3b, 0x3b, 0x3b, 0x3a, 0x3a, 0x3a, 0x00, 0x00 },	// U+2167 (Ⅷ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x09, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2168 (Ⅸ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+2169 (Ⅹ)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x12, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+216A (Ⅺ)
	{ 0x00, 0x00, 0x00, 0x35, 0x35, 0x35, 0x32, 0x35, 0x35, 0x35, 0x00, 0x00 },	// U+216B (Ⅻ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+216C (Ⅼ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+216D (Ⅽ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0f, 0x00, 0x00 },	// U+216E (Ⅾ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+216F (Ⅿ)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2170 (ⅰ)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2171 (ⅱ)
	{ 0x00, 0x00, 0x00, 0x15, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2172 (ⅲ)
	{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x15, 0x15, 0x15, 0x09, 0x09, 0x00, 0x00 },	// U+2173 (ⅳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+2174 (ⅴ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x15, 0x15, 0x15, 0x12, 0x12, 0x00, 0x00 },	// U+2175 (ⅵ)
	{ 0x00, 0x00, 0x00, 0x28, 0x00, 0x2b, 0x2b, 0x2b, 0x2b, 0x2a, 0x00, 0x00 },	// U+2176 (ⅶ)
	{ 0x00, 0x00, 0x00, 0x38, 0x00, 0x3b, 0x3b, 0x3b, 0x3b, 0x3a, 0x00, 0x00 },	// U+2177 (ⅷ)
	{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x15, 0x15, 0x09, 0x15, 0x15, 0x00, 0x00 },	// U+2178 (ⅸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+2179 (ⅹ)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x15, 0x15, 0x12, 0x15, 0x15, 0x00, 0x00 },	// U+217A (ⅺ)
	{ 0x00, 0x00, 0x00, 0x30, 0x00, 0x35, 0x35, 0x32, 0x35, 0x35, 0x00, 0x00 },	// U+217B (ⅻ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+217C (ⅼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+217D (ⅽ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x1e, 0x00, 0x00 },	// U+217E (ⅾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x15, 0x15, 0x15, 0x11, 0x00, 0x00 },	// U+217F (ⅿ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+2180 (ↀ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x17, 0x15, 0x17, 0x11, 0x0f, 0x00, 0x00 },	// U+2181 (ↁ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x1f, 0x15, 0x1f, 0x15, 0x0e, 0x00, 0x00 },	// U+2182 (ↂ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x10, 0x10, 0x10, 0x11, 0x0e, 0x00, 0x00 },	// U+2183 (Ↄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x10, 0x12, 0x0c, 0x00, 0x00 },	// U+2184 (ↄ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x01, 0x01, 0x11, 0x1e, 0x10, 0x10, 0x00 },	// U+2185 (ↅ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+2186 (ↆ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x3f, 0x39, 0x3f, 0x3f, 0x1f, 0x00, 0x00 },	// U+2187 (ↇ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x15, 0x1f, 0x1f, 0x0e, 0x00, 0x00 },	// U+2188 (ↈ)
}; // 54

static const unsigned char orpb_block52[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+2190 (←)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2191 (↑)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00, 0x00 },	// U+2192 (→)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+2193 (↓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+2194 (↔)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+2195 (↕)
	{ 0x00, 0x03, 0x0f, 0x07, 0x05, 0x04, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00 },	// U+2196 (↖)
	{ 0x00, 0x18, 0x1e, 0x1c, 0x14, 0x04, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00 },	// U+2197 (↗)
	{ 0x00, 0x01, 0x01, 0x02, 0x02, 0x04, 0x14, 0x1c, 0x1e, 0x18, 0x00, 0x00 },	// U+2198 (↘)
	{ 0x00, 0x10, 0x10, 0x08, 0x08, 0x04, 0x05, 0x07, 0x0f, 0x03, 0x00, 0x00 },	// U+2199 (↙)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x12, 0x3f, 0x0a, 0x0c, 0x00, 0x00, 0x00 },	// U+219A (↚)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x14, 0x3f, 0x12, 0x0a, 0x00, 0x00, 0x00 },	// U+219B (↛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x1b, 0x26, 0x00, 0x00, 0x00, 0x00 },	// U+219C (↜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x36, 0x19, 0x00, 0x00, 0x00, 0x00 },	// U+219D (↝)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x3f, 0x0a, 0x14, 0x00, 0x00, 0x00 },	// U+219E (↞)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x0e, 0x15, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+219F (↟)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x14, 0x3f, 0x14, 0x0a, 0x00, 0x00, 0x00 },	// U+21A0 (↠)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x15, 0x0e, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+21A1 (↡)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x12, 0x0f, 0x12, 0x24, 0x00, 0x00, 0x00 },	// U+21A2 (↢)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x3c, 0x12, 0x09, 0x00, 0x00, 0x00 },	// U+21A3 (↣)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x12, 0x1f, 0x12, 0x14, 0x00, 0x00, 0x00 },	// U+21A4 (↤)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00 },	// U+21A5 (↥)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x09, 0x1f, 0x09, 0x05, 0x00, 0x00, 0x00 },	// U+21A6 (↦)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+21A7 (↧)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x15, 0x0e, 0x1f, 0x00, 0x00 },	// U+21A8 (↨)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x22, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+21A9 (↩)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x3e, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+21AA (↪)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x32, 0x3f, 0x12, 0x14, 0x00, 0x00, 0x00 },	// U+21AB (↫)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x13, 0x3f, 0x12, 0x0a, 0x00, 0x00, 0x00 },	// U+21AC (↬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x3b, 0x37, 0x12, 0x00, 0x00, 0x00 },	// U+21AD (↭)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x1a, 0x3f, 0x16, 0x02, 0x00, 0x00, 0x00 },	// U+21AE (↮)
	{ 0x00, 0x00, 0x00, 0x01, 0x09, 0x0d, 0x0b, 0x09, 0x1c, 0x08, 0x00, 0x00 },	// U+21AF (↯)
	{ 0x00, 0x00, 0x04, 0x02, 0x1f, 0x12, 0x14, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+21B0 (↰)
	{ 0x00, 0x00, 0x04, 0x08, 0x1f, 0x09, 0x05, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+21B1 (↱)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x14, 0x12, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+21B2 (↲)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x05, 0x09, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+21B3 (↳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+21B4 (↴)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x12, 0x1f, 0x02, 0x00, 0x00, 0x00 },	// U+21B5 (↵)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x17, 0x12, 0x00, 0x00, 0x00 },	// U+21B6 (↶)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x1d, 0x08, 0x00, 0x00, 0x00 },	// U+21B7 (↷)
	{ 0x00, 0x00, 0x1f, 0x01, 0x07, 0x03, 0x05, 0x04, 0x08, 0x08, 0x00, 0x00 },	// U+21B8 (↸)
	{ 0x00, 0x05, 0x03, 0x1f, 0x03, 0x15, 0x18, 0x1f, 0x18, 0x14, 0x00, 0x00 },	// U+21B9 (↹)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x0c, 0x15, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+21BA (↺)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x06, 0x15, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+21BB (↻)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21BC (↼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+21BD (↽)
	{ 0x00, 0x00, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+21BE (↾)
	{ 0x00, 0x00, 0x04, 0x06, 0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+21BF (↿)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21C0 (⇀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x00, 0x00, 0x00 },	// U+21C1 (⇁)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x00, 0x00 },	// U+21C2 (⇂)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x06, 0x04, 0x00, 0x00 },	// U+21C3 (⇃)
	{ 0x00, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+21C4 (⇄)
	{ 0x00, 0x00, 0x0a, 0x0f, 0x0a, 0x0a, 0x0a, 0x0a, 0x1e, 0x0a, 0x00, 0x00 },	// U+21C5 (⇅)
	{ 0x00, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+21C6 (⇆)
	{ 0x00, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+21C7 (⇇)
	{ 0x00, 0x00, 0x0a, 0x1f, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+21C8 (⇈)
	{ 0x00, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+21C9 (⇉)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x1f, 0x0a, 0x00, 0x00 },	// U+21CA (⇊)
	{ 0x00, 0x00, 0x00, 0x04, 0x02, 0x1f, 0x00, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+21CB (⇋)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x00, 0x1f, 0x02, 0x04, 0x00, 0x00 },	// U+21CC (⇌)
	{ 0x00, 0x00, 0x00, 0x28, 0x14, 0x3e, 0x09, 0x3e, 0x04, 0x0a, 0x00, 0x00 },	// U+21CD (⇍)
	{ 0x00, 0x00, 0x00, 0x10, 0x1a, 0x3f, 0x25, 0x3f, 0x16, 0x02, 0x00, 0x00 },	// U+21CE (⇎)
	{ 0x00, 0x00, 0x00, 0x05, 0x0a, 0x1f, 0x24, 0x1f, 0x08, 0x14, 0x00, 0x00 },	// U+21CF (⇏)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1e, 0x01, 0x1e, 0x04, 0x00, 0x00, 0x00 },	// U+21D0 (⇐)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+21D1 (⇑)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0f, 0x10, 0x0f, 0x04, 0x00, 0x00, 0x00 },	// U+21D2 (⇒)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x1b, 0x0a, 0x04, 0x00, 0x00 },	// U+21D3 (⇓)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x3f, 0x21, 0x3f, 0x12, 0x00, 0x00, 0x00 },	// U+21D4 (⇔)
	{ 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x0a, 0x1b, 0x0a, 0x04, 0x00, 0x00 },	// U+21D5 (⇕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x05, 0x0b, 0x15, 0x29, 0x10, 0x00, 0x00 },	// U+21D6 (⇖)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x28, 0x34, 0x2a, 0x25, 0x02, 0x00, 0x00 },	// U+21D7 (⇗)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x25, 0x2a, 0x34, 0x28, 0x3e, 0x00, 0x00 },	// U+21D8 (⇘)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x29, 0x15, 0x0b, 0x05, 0x1f, 0x00, 0x00 },	// U+21D9 (⇙)
	{ 0x00, 0x00, 0x00, 0x08, 0x3c, 0x02, 0x3f, 0x02, 0x3c, 0x08, 0x00, 0x00 },	// U+21DA (⇚)
	{ 0x00, 0x00, 0x00, 0x04, 0x0f, 0x10, 0x3f, 0x10, 0x0f, 0x04, 0x00, 0x00 },	// U+21DB (⇛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x17, 0x2b, 0x02, 0x00, 0x00, 0x00 },	// U+21DC (⇜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3a, 0x35, 0x10, 0x00, 0x00, 0x00 },	// U+21DD (⇝)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+21DE (⇞)
	{ 0x00, 0x00, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+21DF (⇟)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x2b, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+21E0 (⇠)
	{ 0x00, 0x00, 0x04, 0x0e, 0x11, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00 },	// U+21E1 (⇡)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x35, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+21E2 (⇢)
	{ 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x11, 0x0e, 0x04, 0x00, 0x00 },	// U+21E3 (⇣)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x03, 0x1f, 0x03, 0x05, 0x00, 0x00, 0x00 },	// U+21E4 (⇤)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x18, 0x1f, 0x18, 0x14, 0x00, 0x00, 0x00 },	// U+21E5 (⇥)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1e, 0x11, 0x1e, 0x04, 0x00, 0x00, 0x00 },	// U+21E6 (⇦)
	{ 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0e, 0x00, 0x00 },	// U+21E7 (⇧)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0f, 0x11, 0x0f, 0x04, 0x00, 0x00, 0x00 },	// U+21E8 (⇨)
	{ 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x0a, 0x0a, 0x1b, 0x0a, 0x04, 0x00, 0x00 },	// U+21E9 (⇩)
	{ 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x0e, 0x00, 0x0e, 0x0a, 0x0e, 0x00, 0x00 },	// U+21EA (⇪)
	{ 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x0a, 0x0a, 0x1b, 0x11, 0x1f, 0x00, 0x00 },	// U+21EB (⇫)
	{ 0x00, 0x04, 0x0a, 0x1f, 0x11, 0x0a, 0x0a, 0x1b, 0x11, 0x1f, 0x00, 0x00 },	// U+21EC (⇬)
	{ 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x0e, 0x0e, 0x1f, 0x15, 0x1f, 0x00, 0x00 },	// U+21ED (⇭)
	{ 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x1b, 0x0a, 0x0a, 0x0a, 0x0e, 0x00, 0x00 },	// U+21EE (⇮)
	{ 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x1b, 0x0a, 0x1b, 0x11, 0x1f, 0x00, 0x00 },	// U+21EF (⇯)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0x11, 0x0f, 0x05, 0x00, 0x00, 0x00 },	// U+21F0 (⇰)
	{ 0x00, 0x00, 0x1f, 0x01, 0x0d, 0x05, 0x09, 0x08, 0x10, 0x10, 0x00, 0x00 },	// U+21F1 (⇱)
	{ 0x00, 0x00, 0x01, 0x01, 0x02, 0x12, 0x14, 0x16, 0x10, 0x1f, 0x00, 0x00 },	// U+21F2 (⇲)
	{ 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x0a, 0x0a, 0x1b, 0x0a, 0x04, 0x00, 0x00 },	// U+21F3 (⇳)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x16, 0x3f, 0x16, 0x08, 0x00, 0x00, 0x00 },	// U+21F4 (⇴)
	{ 0x00, 0x00, 0x0a, 0x1e, 0x0a, 0x0a, 0x0a, 0x0a, 0x0f, 0x0a, 0x00, 0x00 },	// U+21F5 (⇵)
	{ 0x00, 0x08, 0x1f, 0x08, 0x08, 0x1f, 0x08, 0x08, 0x1f, 0x08, 0x00, 0x00 },	// U+21F6 (⇶)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x12, 0x3f, 0x12, 0x14, 0x00, 0x00, 0x00 },	// U+21F7 (⇷)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x12, 0x3f, 0x12, 0x0a, 0x00, 0x00, 0x00 },	// U+21F8 (⇸)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x1e, 0x0c, 0x00, 0x00, 0x00 },	// U+21F9 (⇹)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1a, 0x3f, 0x1a, 0x1c, 0x00, 0x00, 0x00 },	// U+21FA (⇺)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x16, 0x3f, 0x16, 0x0e, 0x00, 0x00, 0x00 },	// U+21FB (⇻)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x1e, 0x0c, 0x00, 0x00, 0x00 },	// U+21FC (⇼)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x1d, 0x06, 0x04, 0x00, 0x00, 0x00 },	// U+21FD (⇽)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x17, 0x0c, 0x04, 0x00, 0x00, 0x00 },	// U+21FE (⇾)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x2d, 0x1e, 0x0c, 0x00, 0x00, 0x00 },	// U+21FF (⇿)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+2200 (∀)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x02, 0x02, 0x02, 0x0a, 0x04, 0x00, 0x00 },	// U+2201 (∁)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x10, 0x1c, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+2202 (∂)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x1e, 0x10, 0x10, 0x1f, 0x00, 0x00 },	// U+2203 (∃)
	{ 0x00, 0x08, 0x08, 0x1f, 0x18, 0x14, 0x1e, 0x14, 0x12, 0x1f, 0x02, 0x02 },	// U+2204 (∄)
	{ 0x00, 0x00, 0x08, 0x08, 0x0e, 0x19, 0x15, 0x13, 0x0e, 0x02, 0x02, 0x00 },	// U+2205 (∅)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2206 (∆)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+2207 (∇)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x01, 0x0f, 0x01, 0x02, 0x1c, 0x00, 0x00 },	// U+2208 (∈)
	{ 0x00, 0x04, 0x04, 0x1c, 0x06, 0x05, 0x0f, 0x05, 0x06, 0x1c, 0x04, 0x04 },	// U+2209 (∉)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x0e, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+220A (∊)
	{ 0x00, 0x00, 0x00, 0x07, 0x08, 0x10, 0x1e, 0x10, 0x08, 0x07, 0x00, 0x00 },	// U+220B (∋)
	{ 0x00, 0x04, 0x04, 0x07, 0x0c, 0x14, 0x1e, 0x14, 0x0c, 0x07, 0x04, 0x04 },	// U+220C (∌)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x1c, 0x10, 0x0e, 0x00, 0x00, 0x00 },	// U+220D (∍)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+220E (∎)
	{ 0x00, 0x00, 0x3f, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x37, 0x00 },	// U+220F (∏)
	{ 0x00, 0x00, 0x37, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x3f, 0x00 },	// U+2210 (∐)
	{ 0x00, 0x00, 0x1f, 0x01, 0x02, 0x04, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00 },	// U+2211 (∑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2212 (−)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+2213 (∓)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+2214 (∔)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x04, 0x02, 0x02, 0x01, 0x00, 0x00 },	// U+2215 (∕)
	{ 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x04, 0x08, 0x08, 0x10, 0x00, 0x00 },	// U+2216 (∖)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x15, 0x04, 0x00, 0x00, 0x00 },	// U+2217 (∗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2218 (∘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2219 (∙)
	{ 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x08, 0x0b, 0x0a, 0x0a, 0x04, 0x04 },	// U+221A (√)
	{ 0x20, 0x23, 0x24, 0x12, 0x14, 0x13, 0x08, 0x09, 0x09, 0x06, 0x06, 0x04 },	// U+221B (∛)
	{ 0x20, 0x21, 0x25, 0x17, 0x14, 0x14, 0x08, 0x09, 0x09, 0x06, 0x06, 0x04 },	// U+221C (∜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x05, 0x05, 0x1a, 0x00, 0x00, 0x00 },	// U+221D (∝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+221E (∞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+221F (∟)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+2220 (∠)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x1f, 0x08, 0x08, 0x00 },	// U+2221 (∡)
	{ 0x00, 0x10, 0x08, 0x0c, 0x12, 0x11, 0x12, 0x0c, 0x08, 0x10, 0x00, 0x00 },	// U+2222 (∢)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+2223 (∣)
	{ 0x00, 0x00, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x06, 0x05, 0x04, 0x04, 0x00 },	// U+2224 (∤)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00 },	// U+2225 (∥)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x1a, 0x0a, 0x0e, 0x0a, 0x0b, 0x0a, 0x0a, 0x00 },	// U+2226 (∦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x00, 0x00 },	// U+2227 (∧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+2228 (∨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+2229 (∩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+222A (∪)
	{ 0x00, 0x08, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x02, 0x00 },	// U+222B (∫)
	{ 0x00, 0x24, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x09 },	// U+222C (∬)
	{ 0x00, 0x2a, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0b },	// U+222D (∭)
	{ 0x00, 0x08, 0x14, 0x04, 0x0e, 0x15, 0x15, 0x0e, 0x04, 0x05, 0x02, 0x00 },	// U+222E (∮)
	{ 0x00, 0x24, 0x12, 0x12, 0x1e, 0x33, 0x33, 0x33, 0x1e, 0x12, 0x12, 0x09 },	// U+222F (∯)
	{ 0x00, 0x2a, 0x15, 0x15, 0x1f, 0x35, 0x35, 0x35, 0x1f, 0x15, 0x15, 0x0b },	// U+2230 (∰)
	{ 0x08, 0x14, 0x04, 0x04, 0x2e, 0x35, 0x3c, 0x04, 0x04, 0x04, 0x05, 0x02 },	// U+2231 (∱)
	{ 0x08, 0x14, 0x04, 0x04, 0x2e, 0x35, 0x3d, 0x15, 0x0e, 0x04, 0x05, 0x02 },	// U+2232 (∲)
	{ 0x08, 0x14, 0x04, 0x04, 0x0e, 0x15, 0x3d, 0x35, 0x2e, 0x04, 0x05, 0x02 },	// U+2233 (∳)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2234 (∴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2235 (∵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2236 (∶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00 },	// U+2237 (∷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2238 (∸)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x07, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+2239 (∹)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x1f, 0x00, 0x11, 0x00, 0x00, 0x00 },	// U+223A (∺)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x16, 0x0d, 0x00, 0x02, 0x00, 0x00 },	// U+223B (∻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00 },	// U+223C (∼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x16, 0x00, 0x00, 0x00, 0x00 },	// U+223D (∽)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x25, 0x29, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+223E (∾)
	{ 0x00, 0x00, 0x00, 0x02, 0x05, 0x05, 0x15, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+223F (∿)
	{ 0x00, 0x04, 0x08, 0x08, 0x08, 0x04, 0x02, 0x02, 0x02, 0x04, 0x00, 0x00 },	// U+2240 (≀)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x16, 0x0d, 0x04, 0x04, 0x00, 0x00 },	// U+2241 (≁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00 },	// U+2242 (≂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+2243 (≃)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x16, 0x0d, 0x04, 0x1f, 0x04, 0x00, 0x00 },	// U+2244 (≄)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2245 (≅)
	{ 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x04, 0x1f, 0x04, 0x00, 0x00 },	// U+2246 (≆)
	{ 0x00, 0x00, 0x04, 0x16, 0x0d, 0x04, 0x1f, 0x04, 0x1f, 0x04, 0x00, 0x00 },	// U+2247 (≇)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00 },	// U+2248 (≈)
	{ 0x00, 0x00, 0x00, 0x04, 0x16, 0x0d, 0x04, 0x16, 0x0d, 0x04, 0x00, 0x00 },	// U+2249 (≉)
	{ 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x00 },	// U+224A (≊)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+224B (≋)
	{ 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+224C (≌)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x00, 0x0e, 0x11, 0x00, 0x00, 0x00 },	// U+224D (≍)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1b, 0x00, 0x1b, 0x04, 0x00, 0x00, 0x00 },	// U+224E (≎)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1b, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+224F (≏)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2250 (≐)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x04, 0x00, 0x00 },	// U+2251 (≑)
	{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x10, 0x00, 0x00 },	// U+2252 (≒)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x01, 0x00, 0x00 },	// U+2253 (≓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00 },	// U+2254 (≔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00 },	// U+2255 (≕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2256 (≖)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+2257 (≗)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+2258 (≘)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+2259 (≙)
	{ 0x00, 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+225A (≚)
	{ 0x00, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+225B (≛)
	{ 0x00, 0x00, 0x04, 0x0a, 0x11, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+225C (≜)
	{ 0x00, 0x00, 0x32, 0x1f, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+225D (≝)
	{ 0x00, 0x00, 0x0b, 0x15, 0x15, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+225E (≞)
	{ 0x00, 0x04, 0x0a, 0x08, 0x04, 0x00, 0x04, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+225F (≟)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x1f, 0x04, 0x1f, 0x02, 0x02, 0x00, 0x00 },	// U+2260 (≠)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+2261 (≡)
	{ 0x00, 0x00, 0x00, 0x08, 0x1f, 0x04, 0x1f, 0x04, 0x1f, 0x02, 0x00, 0x00 },	// U+2262 (≢)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2263 (≣)
	{ 0x00, 0x00, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00, 0x1f, 0x00, 0x00 },	// U+2264 (≤)
	{ 0x00, 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00, 0x1f, 0x00, 0x00 },	// U+2265 (≥)
	{ 0x00, 0x00, 0x10, 0x0c, 0x03, 0x0c, 0x10, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2266 (≦)
	{ 0x00, 0x00, 0x01, 0x06, 0x18, 0x06, 0x01, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2267 (≧)
	{ 0x00, 0x00, 0x10, 0x0c, 0x03, 0x0c, 0x18, 0x1f, 0x04, 0x1f, 0x02, 0x00 },	// U+2268 (≨)
	{ 0x00, 0x00, 0x01, 0x06, 0x18, 0x06, 0x09, 0x1f, 0x04, 0x1f, 0x02, 0x00 },	// U+2269 (≩)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x05, 0x0a, 0x14, 0x00, 0x00, 0x00 },	// U+226A (≪)
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x14, 0x0a, 0x05, 0x00, 0x00, 0x00 },	// U+226B (≫)
	{ 0x00, 0x00, 0x0a, 0x04, 0x0a, 0x0a, 0x0a, 0x0a, 0x04, 0x0a, 0x00, 0x00 },	// U+226C (≬)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x04, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+226D (≭)
	{ 0x00, 0x14, 0x0c, 0x04, 0x06, 0x05, 0x06, 0x04, 0x0c, 0x14, 0x00, 0x00 },	// U+226E (≮)
	{ 0x00, 0x05, 0x06, 0x04, 0x0c, 0x14, 0x0c, 0x04, 0x06, 0x05, 0x00, 0x00 },	// U+226F (≯)
	{ 0x00, 0x04, 0x1c, 0x06, 0x05, 0x06, 0x1c, 0x04, 0x1f, 0x04, 0x00, 0x00 },	// U+2270 (≰)
	{ 0x00, 0x04, 0x07, 0x0c, 0x14, 0x0c, 0x07, 0x04, 0x1f, 0x04, 0x00, 0x00 },	// U+2271 (≱)
	{ 0x00, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2272 (≲)
	{ 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2273 (≳)
	{ 0x00, 0x04, 0x1c, 0x06, 0x05, 0x06, 0x1c, 0x04, 0x16, 0x0d, 0x04, 0x00 },	// U+2274 (≴)
	{ 0x00, 0x04, 0x07, 0x0c, 0x14, 0x0c, 0x07, 0x04, 0x16, 0x0d, 0x04, 0x00 },	// U+2275 (≵)
	{ 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00 },	// U+2276 (≶)
	{ 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00 },	// U+2277 (≷)
	{ 0x08, 0x18, 0x0e, 0x09, 0x06, 0x1c, 0x07, 0x0c, 0x12, 0x0e, 0x03, 0x02 },	// U+2278 (≸)
	{ 0x08, 0x0b, 0x0c, 0x18, 0x0c, 0x07, 0x1c, 0x06, 0x03, 0x06, 0x1a, 0x02 },	// U+2279 (≹)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x07, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+227A (≺)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x1c, 0x02, 0x01, 0x00, 0x00, 0x00 },	// U+227B (≻)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x07, 0x08, 0x17, 0x08, 0x10, 0x00, 0x00 },	// U+227C (≼)
	{ 0x00, 0x00, 0x00, 0x01, 0x02, 0x1c, 0x02, 0x1d, 0x02, 0x01, 0x00, 0x00 },	// U+227D (≽)
	{ 0x00, 0x00, 0x10, 0x08, 0x07, 0x08, 0x10, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+227E (≾)
	{ 0x00, 0x00, 0x01, 0x02, 0x1c, 0x02, 0x01, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+227F (≿)
	{ 0x00, 0x00, 0x00, 0x04, 0x14, 0x0c, 0x07, 0x0c, 0x14, 0x04, 0x00, 0x00 },	// U+2280 (⊀)
	{ 0x00, 0x00, 0x00, 0x04, 0x05, 0x06, 0x1c, 0x06, 0x05, 0x04, 0x00, 0x00 },	// U+2281 (⊁)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+2282 (⊂)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+2283 (⊃)
	{ 0x00, 0x00, 0x00, 0x08, 0x1e, 0x05, 0x05, 0x05, 0x1e, 0x02, 0x00, 0x00 },	// U+2284 (⊄)
	{ 0x00, 0x00, 0x00, 0x08, 0x0f, 0x14, 0x14, 0x14, 0x0f, 0x02, 0x00, 0x00 },	// U+2285 (⊅)
	{ 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x1e, 0x00, 0x1f, 0x00, 0x00 },	// U+2286 (⊆)
	{ 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x1f, 0x00, 0x00 },	// U+2287 (⊇)
	{ 0x00, 0x00, 0x04, 0x1e, 0x05, 0x05, 0x05, 0x1e, 0x04, 0x1f, 0x04, 0x00 },	// U+2288 (⊈)
	{ 0x00, 0x00, 0x04, 0x0f, 0x14, 0x14, 0x14, 0x0f, 0x04, 0x1f, 0x04, 0x00 },	// U+2289 (⊉)
	{ 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x1e, 0x08, 0x1f, 0x02, 0x00 },	// U+228A (⊊)
	{ 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x0f, 0x08, 0x1f, 0x02, 0x00 },	// U+228B (⊋)
	{ 0x00, 0x00, 0x11, 0x15, 0x17, 0x1f, 0x17, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+228C (⊌)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x15, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+228D (⊍)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x15, 0x1f, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+228E (⊎)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+228F (⊏)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x00, 0x00 },	// U+2290 (⊐)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2291 (⊑)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2292 (⊒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+2293 (⊓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2294 (⊔)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x1f, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+2295 (⊕)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2296 (⊖)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x15, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+2297 (⊗)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x19, 0x15, 0x13, 0x0e, 0x00, 0x00, 0x00 },	// U+2298 (⊘)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2299 (⊙)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+229A (⊚)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x0e, 0x00, 0x00 },	// U+229B (⊛)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+229C (⊜)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+229D (⊝)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x1f, 0x15, 0x1f, 0x00, 0x00, 0x00 },	// U+229E (⊞)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x1f, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+229F (⊟)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1b, 0x15, 0x1b, 0x1f, 0x00, 0x00, 0x00 },	// U+22A0 (⊠)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+22A1 (⊡)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x1f, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+22A2 (⊢)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+22A3 (⊣)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+22A4 (⊤)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00 },	// U+22A5 (⊥)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+22A6 (⊦)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x02, 0x0e, 0x02, 0x02, 0x00, 0x00 },	// U+22A7 (⊧)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x1f, 0x01, 0x1f, 0x01, 0x01, 0x00, 0x00 },	// U+22A8 (⊨)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x1d, 0x05, 0x05, 0x05, 0x00, 0x00 },	// U+22A9 (⊩)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x35, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+22AA (⊪)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x3d, 0x05, 0x3d, 0x05, 0x05, 0x00, 0x00 },	// U+22AB (⊫)
	{ 0x00, 0x00, 0x00, 0x01, 0x09, 0x09, 0x1f, 0x05, 0x05, 0x01, 0x00, 0x00 },	// U+22AC (⊬)
	{ 0x00, 0x00, 0x00, 0x01, 0x09, 0x1f, 0x05, 0x1f, 0x03, 0x01, 0x00, 0x00 },	// U+22AD (⊭)
	{ 0x00, 0x00, 0x00, 0x05, 0x15, 0x15, 0x3d, 0x0d, 0x0d, 0x05, 0x00, 0x00 },	// U+22AE (⊮)
	{ 0x00, 0x00, 0x00, 0x25, 0x25, 0x3d, 0x15, 0x3d, 0x0d, 0x0d, 0x00, 0x00 },	// U+22AF (⊯)
	{ 0x00, 0x00, 0x00, 0x08, 0x10, 0x08, 0x07, 0x08, 0x10, 0x08, 0x00, 0x00 },	// U+22B0 (⊰)
	{ 0x00, 0x00, 0x00, 0x02, 0x01, 0x02, 0x1c, 0x02, 0x01, 0x02, 0x00, 0x00 },	// U+22B1 (⊱)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x16, 0x11, 0x16, 0x18, 0x00, 0x00, 0x00 },	// U+22B2 (⊲)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x11, 0x0d, 0x03, 0x00, 0x00, 0x00 },	// U+22B3 (⊳)
	{ 0x00, 0x00, 0x00, 0x18, 0x16, 0x11, 0x16, 0x18, 0x00, 0x1f, 0x00, 0x00 },	// U+22B4 (⊴)
	{ 0x00, 0x00, 0x00, 0x03, 0x0d, 0x11, 0x0d, 0x03, 0x00, 0x1f, 0x00, 0x00 },	// U+22B5 (⊵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1d, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+22B6 (⊶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x17, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+22B7 (⊷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x17, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+22B8 (⊸)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1b, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+22B9 (⊹)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+22BA (⊺)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x1f, 0x00, 0x00 },	// U+22BB (⊻)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x00, 0x00 },	// U+22BC (⊼)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+22BD (⊽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x05, 0x1f, 0x00, 0x00 },	// U+22BE (⊾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x12, 0x1f, 0x00, 0x00 },	// U+22BF (⊿)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x0a, 0x0a, 0x0a, 0x11, 0x11, 0x11, 0x00 },	// U+22C0 (⋀)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x0a, 0x0a, 0x04, 0x04, 0x04, 0x00 },	// U+22C1 (⋁)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00 },	// U+22C2 (⋂)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00 },	// U+22C3 (⋃)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+22C4 (⋄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22C5 (⋅)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0e, 0x0e, 0x11, 0x00, 0x00, 0x00 },	// U+22C6 (⋆)
	{ 0x00, 0x00, 0x00, 0x04, 0x11, 0x0a, 0x1f, 0x0a, 0x11, 0x04, 0x00, 0x00 },	// U+22C7 (⋇)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x00, 0x00, 0x00 },	// U+22C8 (⋈)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0b, 0x05, 0x0b, 0x11, 0x00, 0x00, 0x00 },	// U+22C9 (⋉)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x1a, 0x14, 0x1a, 0x11, 0x00, 0x00, 0x00 },	// U+22CA (⋊)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+22CB (⋋)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+22CC (⋌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x16, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+22CD (⋍)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+22CE (⋎)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x00, 0x00 },	// U+22CF (⋏)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x19, 0x05, 0x19, 0x02, 0x1c, 0x00, 0x00 },	// U+22D0 (⋐)
	{ 0x00, 0x00, 0x00, 0x07, 0x08, 0x13, 0x14, 0x13, 0x08, 0x07, 0x00, 0x00 },	// U+22D1 (⋑)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+22D2 (⋒)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+22D3 (⋓)
	{ 0x00, 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+22D4 (⋔)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x1f, 0x0a, 0x0a, 0x1f, 0x0a, 0x0a, 0x00, 0x00 },	// U+22D5 (⋕)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x06, 0x11, 0x06, 0x18, 0x00, 0x00, 0x00 },	// U+22D6 (⋖)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x11, 0x0c, 0x03, 0x00, 0x00, 0x00 },	// U+22D7 (⋗)
	{ 0x00, 0x00, 0x00, 0x28, 0x14, 0x2a, 0x15, 0x2a, 0x14, 0x28, 0x00, 0x00 },	// U+22D8 (⋘)
	{ 0x00, 0x00, 0x00, 0x05, 0x0a, 0x15, 0x2a, 0x15, 0x0a, 0x05, 0x00, 0x00 },	// U+22D9 (⋙)
	{ 0x18, 0x06, 0x01, 0x06, 0x18, 0x00, 0x1f, 0x03, 0x0c, 0x10, 0x0c, 0x03 },	// U+22DA (⋚)
	{ 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00, 0x1f, 0x18, 0x06, 0x01, 0x06, 0x18 },	// U+22DB (⋛)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00, 0x00 },	// U+22DC (⋜)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00, 0x00 },	// U+22DD (⋝)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x17, 0x08, 0x07, 0x08, 0x10, 0x00, 0x00 },	// U+22DE (⋞)
	{ 0x00, 0x00, 0x00, 0x01, 0x02, 0x1d, 0x02, 0x1c, 0x02, 0x01, 0x00, 0x00 },	// U+22DF (⋟)
	{ 0x00, 0x00, 0x04, 0x14, 0x0c, 0x07, 0x0c, 0x17, 0x0c, 0x14, 0x04, 0x00 },	// U+22E0 (⋠)
	{ 0x00, 0x00, 0x04, 0x05, 0x06, 0x1c, 0x06, 0x1d, 0x06, 0x05, 0x04, 0x00 },	// U+22E1 (⋡)
	{ 0x00, 0x00, 0x04, 0x1f, 0x05, 0x05, 0x1f, 0x04, 0x1f, 0x04, 0x00, 0x00 },	// U+22E2 (⋢)
	{ 0x00, 0x00, 0x04, 0x1f, 0x14, 0x14, 0x1f, 0x04, 0x1f, 0x04, 0x00, 0x00 },	// U+22E3 (⋣)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x1f, 0x08, 0x1f, 0x02, 0x00, 0x00 },	// U+22E4 (⋤)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x1f, 0x08, 0x1f, 0x02, 0x00, 0x00 },	// U+22E5 (⋥)
	{ 0x00, 0x18, 0x06, 0x01, 0x06, 0x1c, 0x04, 0x16, 0x0d, 0x04, 0x04, 0x00 },	// U+22E6 (⋦)
	{ 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x07, 0x04, 0x16, 0x0d, 0x04, 0x04, 0x00 },	// U+22E7 (⋧)
	{ 0x00, 0x00, 0x10, 0x08, 0x07, 0x08, 0x14, 0x04, 0x16, 0x0d, 0x04, 0x04 },	// U+22E8 (⋨)
	{ 0x00, 0x00, 0x01, 0x02, 0x1c, 0x02, 0x05, 0x04, 0x16, 0x0d, 0x04, 0x04 },	// U+22E9 (⋩)
	{ 0x00, 0x00, 0x04, 0x04, 0x1c, 0x16, 0x15, 0x16, 0x1c, 0x04, 0x04, 0x00 },	// U+22EA (⋪)
	{ 0x00, 0x00, 0x04, 0x04, 0x07, 0x0d, 0x15, 0x0d, 0x07, 0x04, 0x04, 0x00 },	// U+22EB (⋫)
	{ 0x00, 0x00, 0x04, 0x1c, 0x16, 0x15, 0x16, 0x1c, 0x04, 0x1f, 0x04, 0x00 },	// U+22EC (⋬)
	{ 0x00, 0x00, 0x04, 0x07, 0x0d, 0x15, 0x0d, 0x07, 0x04, 0x1f, 0x04, 0x00 },	// U+22ED (⋭)
	{ 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00 },	// U+22EE (⋮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22EF (⋯)
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00 },	// U+22F0 (⋰)
	{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+22F1 (⋱)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x02, 0x0f, 0x02, 0x02, 0x1c, 0x00, 0x00 },	// U+22F2 (⋲)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x11, 0x1f, 0x11, 0x02, 0x1c, 0x00, 0x00 },	// U+22F3 (⋳)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x11, 0x1f, 0x11, 0x02, 0x1c, 0x00, 0x00 },	// U+22F4 (⋴)
	{ 0x00, 0x08, 0x00, 0x1c, 0x02, 0x01, 0x0f, 0x01, 0x02, 0x1c, 0x00, 0x00 },	// U+22F5 (⋵)
	{ 0x00, 0x1f, 0x00, 0x1c, 0x02, 0x01, 0x0f, 0x01, 0x02, 0x1c, 0x00, 0x00 },	// U+22F6 (⋶)
	{ 0x00, 0x00, 0x1e, 0x00, 0x1c, 0x02, 0x0e, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+22F7 (⋷)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x01, 0x0f, 0x01, 0x02, 0x1c, 0x00, 0x1f },	// U+22F8 (⋸)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x0f, 0x01, 0x0f, 0x02, 0x1c, 0x00, 0x00 },	// U+22F9 (⋹)
	{ 0x00, 0x00, 0x00, 0x07, 0x08, 0x08, 0x1e, 0x08, 0x08, 0x07, 0x00, 0x00 },	// U+22FA (⋺)
	{ 0x00, 0x00, 0x00, 0x07, 0x08, 0x11, 0x1f, 0x11, 0x08, 0x07, 0x00, 0x00 },	// U+22FB (⋻)
	{ 0x00, 0x00, 0x00, 0x0e, 0x10, 0x12, 0x1e, 0x12, 0x10, 0x0e, 0x00, 0x00 },	// U+22FC (⋼)
	{ 0x00, 0x1f, 0x00, 0x07, 0x08, 0x10, 0x1e, 0x10, 0x08, 0x07, 0x00, 0x00 },	// U+22FD (⋽)
	{ 0x00, 0x00, 0x1e, 0x00, 0x0e, 0x10, 0x1c, 0x10, 0x0e, 0x00, 0x00, 0x00 },	// U+22FE (⋾)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x1f, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+22FF (⋿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x09, 0x15, 0x12, 0x0d, 0x00, 0x00 },	// U+2300 (⌀)
	{ 0x00, 0x00, 0x00, 0x04, 0x0c, 0x15, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2301 (⌁)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2302 (⌂)
	{ 0x00, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2303 (⌃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x00, 0x00 },	// U+2304 (⌄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+2305 (⌅)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+2306 (⌆)
	{ 0x00, 0x08, 0x08, 0x04, 0x04, 0x08, 0x08, 0x04, 0x04, 0x08, 0x00, 0x00 },	// U+2307 (⌇)
	{ 0x00, 0x00, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00 },	// U+2308 (⌈)
	{ 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+2309 (⌉)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x00 },	// U+230A (⌊)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00 },	// U+230B (⌋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+230C (⌌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+230D (⌍)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+230E (⌎)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+230F (⌏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+2310 (⌐)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x0a, 0x0e, 0x11, 0x00, 0x00, 0x00 },	// U+2311 (⌑)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2312 (⌒)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2313 (⌓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2314 (⌔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x13, 0x0f, 0x00, 0x00 },	// U+2315 (⌕)
	{ 0x00, 0x04, 0x04, 0x0e, 0x15, 0x1f, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+2316 (⌖)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x1f, 0x0a, 0x0a, 0x1f, 0x0a, 0x0a, 0x00, 0x00 },	// U+2317 (⌗)
	{ 0x00, 0x00, 0x00, 0x0a, 0x15, 0x0e, 0x04, 0x0e, 0x15, 0x0a, 0x00, 0x00 },	// U+2318 (⌘)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2319 (⌙)
	{ 0x0e, 0x0a, 0x0a, 0x0e, 0x15, 0x1d, 0x11, 0x0e, 0x0a, 0x0a, 0x0e, 0x00 },	// U+231A (⌚)
	{ 0x00, 0x00, 0x1f, 0x11, 0x0e, 0x04, 0x04, 0x0a, 0x15, 0x1f, 0x00, 0x00 },	// U+231B (⌛)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+231C (⌜)
	{ 0x00, 0x00, 0x00, 0x1c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+231D (⌝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+231E (⌞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+231F (⌟)
	{ 0x00, 0x08, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2320 (⌠)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x02, 0x00 },	// U+2321 (⌡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2322 (⌢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2323 (⌣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+2324 (⌤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x03, 0x04, 0x18, 0x00, 0x00, 0x00 },	// U+2325 (⌥)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1b, 0x25, 0x1b, 0x0f, 0x00, 0x00, 0x00 },	// U+2326 (⌦)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1b, 0x15, 0x1b, 0x1f, 0x00, 0x00, 0x00 },	// U+2327 (⌧)
	{ 0x3f, 0x21, 0x35, 0x21, 0x35, 0x21, 0x35, 0x21, 0x35, 0x21, 0x3f, 0x00 },	// U+2328 (⌨)
}; // 409

static const unsigned char orpb_block53[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x36, 0x29, 0x36, 0x3c, 0x00, 0x00, 0x00 },	// U+232B (⌫)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1b, 0x13, 0x1b, 0x0e, 0x04, 0x00, 0x00 },	// U+232C (⌬)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x06, 0x1b, 0x0c, 0x04, 0x02, 0x00, 0x00 },	// U+232D (⌭)
	{ 0x00, 0x00, 0x1c, 0x22, 0x3a, 0x26, 0x1c, 0x05, 0x03, 0x07, 0x00, 0x00 },	// U+232E (⌮)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x1f, 0x00, 0x0e, 0x00, 0x00, 0x00 },	// U+232F (⌯)
	{ 0x00, 0x00, 0x12, 0x3f, 0x12, 0x12, 0x09, 0x09, 0x09, 0x0f, 0x00, 0x00 },	// U+2330 (⌰)
	{ 0x00, 0x00, 0x02, 0x02, 0x15, 0x3f, 0x15, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+2331 (⌱)
	{ 0x00, 0x00, 0x01, 0x07, 0x19, 0x3f, 0x19, 0x07, 0x01, 0x00, 0x00, 0x00 },	// U+2332 (⌲)
	{ 0x00, 0x00, 0x00, 0x01, 0x03, 0x05, 0x09, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2333 (⌳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00 },	// U+2334 (⌴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x00, 0x00 },	// U+2335 (⌵)
	{ 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00 },	// U+2336 (⌶)
	{ 0x00, 0x1e, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x1e, 0x00 },	// U+2337 (⌷)
	{ 0x00, 0x1f, 0x11, 0x11, 0x1f, 0x11, 0x1f, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2338 (⌸)
	{ 0x00, 0x1f, 0x11, 0x15, 0x11, 0x1f, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2339 (⌹)
	{ 0x00, 0x1f, 0x11, 0x15, 0x1b, 0x11, 0x1b, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+233A (⌺)
	{ 0x00, 0x1f, 0x11, 0x11, 0x15, 0x1b, 0x15, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+233B (⌻)
	{ 0x00, 0x1f, 0x11, 0x1f, 0x1b, 0x11, 0x1b, 0x1f, 0x11, 0x1f, 0x00, 0x00 },	// U+233C (⌼)
	{ 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+233D (⌽)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+233E (⌾)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x1f, 0x02, 0x02, 0x01, 0x00, 0x00 },	// U+233F (⌿)
	{ 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x1f, 0x08, 0x08, 0x10, 0x00, 0x00 },	// U+2340 (⍀)
	{ 0x00, 0x1f, 0x19, 0x19, 0x15, 0x15, 0x15, 0x13, 0x13, 0x1f, 0x00, 0x00 },	// U+2341 (⍁)
	{ 0x00, 0x1f, 0x13, 0x13, 0x15, 0x15, 0x15, 0x19, 0x19, 0x1f, 0x00, 0x00 },	// U+2342 (⍂)
	{ 0x00, 0x1f, 0x11, 0x19, 0x15, 0x13, 0x15, 0x19, 0x11, 0x1f, 0x00, 0x00 },	// U+2343 (⍃)
	{ 0x00, 0x1f, 0x11, 0x13, 0x15, 0x19, 0x15, 0x13, 0x11, 0x1f, 0x00, 0x00 },	// U+2344 (⍄)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x0a, 0x1f, 0x0a, 0x08, 0x08, 0x00, 0x00 },	// U+2345 (⍅)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x0a, 0x1f, 0x0a, 0x02, 0x02, 0x00, 0x00 },	// U+2346 (⍆)
	{ 0x00, 0x1f, 0x11, 0x15, 0x13, 0x1f, 0x13, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2347 (⍇)
	{ 0x00, 0x1f, 0x11, 0x15, 0x19, 0x1f, 0x19, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2348 (⍈)
	{ 0x00, 0x01, 0x01, 0x0e, 0x13, 0x15, 0x19, 0x0e, 0x10, 0x10, 0x00, 0x00 },	// U+2349 (⍉)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x1f, 0x00 },	// U+234A (⍊)
	{ 0x00, 0x04, 0x04, 0x04, 0x0e, 0x0e, 0x15, 0x15, 0x1f, 0x04, 0x04, 0x00 },	// U+234B (⍋)
	{ 0x00, 0x1f, 0x11, 0x11, 0x1b, 0x1b, 0x15, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+234C (⍌)
	{ 0x00, 0x1f, 0x11, 0x15, 0x15, 0x1b, 0x1b, 0x1f, 0x11, 0x1f, 0x00, 0x00 },	// U+234D (⍍)
	{ 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x1f, 0x00, 0x00 },	// U+234E (⍎)
	{ 0x00, 0x04, 0x0e, 0x15, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+234F (⍏)
	{ 0x00, 0x1f, 0x15, 0x1f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00 },	// U+2350 (⍐)
	{ 0x00, 0x1f, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2351 (⍑)
	{ 0x00, 0x04, 0x04, 0x1f, 0x15, 0x0e, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+2352 (⍒)
	{ 0x00, 0x1f, 0x11, 0x15, 0x15, 0x1b, 0x1b, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2353 (⍓)
	{ 0x00, 0x1f, 0x11, 0x1f, 0x1b, 0x1b, 0x15, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2354 (⍔)
	{ 0x00, 0x1f, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+2355 (⍕)
	{ 0x00, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+2356 (⍖)
	{ 0x00, 0x1f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x15, 0x1f, 0x00, 0x00 },	// U+2357 (⍗)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00 },	// U+2358 (⍘)
	{ 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x1f, 0x00, 0x1f, 0x00 },	// U+2359 (⍙)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x00, 0x1f, 0x00 },	// U+235A (⍚)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x1f, 0x00 },	// U+235B (⍛)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x1f, 0x00 },	// U+235C (⍜)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x15, 0x11, 0x11, 0x00, 0x00 },	// U+235D (⍝)
	{ 0x00, 0x1f, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+235E (⍞)
	{ 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1f, 0x15, 0x1b, 0x11, 0x0e, 0x00, 0x00 },	// U+235F (⍟)
	{ 0x00, 0x1f, 0x11, 0x15, 0x11, 0x11, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2360 (⍠)
	{ 0x00, 0x0a, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2361 (⍡)
	{ 0x00, 0x0a, 0x00, 0x1f, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+2362 (⍢)
	{ 0x00, 0x0a, 0x00, 0x04, 0x04, 0x1f, 0x0e, 0x0e, 0x11, 0x00, 0x00, 0x00 },	// U+2363 (⍣)
	{ 0x00, 0x0a, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2364 (⍤)
	{ 0x00, 0x0a, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2365 (⍥)
	{ 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+2366 (⍦)
	{ 0x00, 0x00, 0x08, 0x08, 0x1e, 0x09, 0x09, 0x09, 0x1e, 0x08, 0x08, 0x00 },	// U+2367 (⍧)
	{ 0x00, 0x0a, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2368 (⍨)
	{ 0x00, 0x0a, 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x00, 0x00, 0x00 },	// U+2369 (⍩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x0c, 0x04, 0x02, 0x00 },	// U+236A (⍪)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x3e, 0x1b, 0x05, 0x04, 0x00, 0x00 },	// U+236B (⍫)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x17, 0x1d, 0x11, 0x0e, 0x00, 0x00 },	// U+236C (⍬)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x16, 0x0d, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+236D (⍭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x0c, 0x1f, 0x02 },	// U+236E (⍮)
	{ 0x00, 0x1f, 0x11, 0x19, 0x1f, 0x15, 0x1f, 0x13, 0x11, 0x1f, 0x00, 0x00 },	// U+236F (⍯)
	{ 0x00, 0x1f, 0x15, 0x1b, 0x19, 0x15, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+2370 (⍰)
	{ 0x00, 0x00, 0x11, 0x1d, 0x17, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+2371 (⍱)
	{ 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x17, 0x1d, 0x11, 0x00, 0x00 },	// U+2372 (⍲)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x00, 0x00 },	// U+2373 (⍳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0f, 0x01, 0x01 },	// U+2374 (⍴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+2375 (⍵)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x1f, 0x00 },	// U+2376 (⍶)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x06, 0x11, 0x0e, 0x00, 0x1f, 0x00 },	// U+2377 (⍷)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x00, 0x1f, 0x00 },	// U+2378 (⍸)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x1f, 0x00 },	// U+2379 (⍹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x09, 0x09, 0x09, 0x16, 0x00, 0x00 },	// U+237A (⍺)
	{ 0x00, 0x00, 0x20, 0x20, 0x10, 0x3c, 0x08, 0x09, 0x06, 0x04, 0x00, 0x00 },	// U+237B (⍻)
	{ 0x06, 0x02, 0x03, 0x06, 0x02, 0x03, 0x06, 0x0a, 0x3f, 0x03, 0x07, 0x00 },	// U+237C (⍼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x12, 0x1e, 0x00, 0x00 },	// U+237D (⍽)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x1f, 0x0a, 0x1b, 0x00, 0x00 },	// U+237E (⍾)
	{ 0x00, 0x04, 0x04, 0x0e, 0x1f, 0x1f, 0x1f, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+237F (⍿)
	{ 0x00, 0x00, 0x00, 0x0e, 0x10, 0x1e, 0x11, 0x1e, 0x00, 0x11, 0x0a, 0x04 },	// U+2380 (⎀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x0e, 0x09, 0x2e, 0x00, 0x3f },	// U+2381 (⎁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x36, 0x2d, 0x36, 0x00, 0x36 },	// U+2382 (⎂)
	{ 0x00, 0x00, 0x00, 0x00, 0x21, 0x25, 0x08, 0x2d, 0x0a, 0x2d, 0x21, 0x00 },	// U+2383 (⎃)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x2b, 0x2b, 0x2b, 0x1f, 0x00, 0x00, 0x00 },	// U+2384 (⎄)
	{ 0x00, 0x00, 0x04, 0x1f, 0x15, 0x15, 0x15, 0x15, 0x1f, 0x04, 0x00, 0x00 },	// U+2385 (⎅)
	{ 0x00, 0x00, 0x04, 0x0a, 0x11, 0x24, 0x2f, 0x24, 0x11, 0x0a, 0x04, 0x00 },	// U+2386 (⎆)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x14, 0x02, 0x39, 0x00, 0x00, 0x00 },	// U+2387 (⎇)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x15, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2388 (⎈)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x21, 0x33, 0x2d, 0x1e, 0x00, 0x00 },	// U+2389 (⎉)
	{ 0x00, 0x00, 0x00, 0x1e, 0x21, 0x3f, 0x33, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+238A (⎊)
	{ 0x00, 0x00, 0x00, 0x00, 0x17, 0x23, 0x25, 0x28, 0x21, 0x1e, 0x00, 0x00 },	// U+238B (⎋)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x13, 0x00, 0x0a, 0x15, 0x0a, 0x00, 0x00 },	// U+238C (⎌)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x0a, 0x1b, 0x00, 0x00, 0x00 },	// U+238D (⎍)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x0a, 0x0a, 0x0a, 0x0f, 0x00, 0x00, 0x00 },	// U+238E (⎎)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+238F (⎏)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x1f, 0x00, 0x00, 0x00 },	// U+2390 (⎐)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x0a, 0x1f, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2391 (⎑)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1f, 0x0a, 0x04, 0x1f, 0x00, 0x00, 0x00 },	// U+2392 (⎒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+2393 (⎓)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x21, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+2394 (⎔)
	{ 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00 },	// U+2395 (⎕)
	{ 0x00, 0x00, 0x1e, 0x0e, 0x0e, 0x06, 0x06, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+2396 (⎖)
	{ 0x15, 0x00, 0x3d, 0x24, 0x21, 0x24, 0x3f, 0x24, 0x21, 0x24, 0x3c, 0x00 },	// U+2397 (⎗)
	{ 0x1f, 0x01, 0x2b, 0x01, 0x21, 0x09, 0x3f, 0x09, 0x21, 0x01, 0x2a, 0x00 },	// U+2398 (⎘)
	{ 0x00, 0x00, 0x1c, 0x16, 0x12, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x00, 0x00 },	// U+2399 (⎙)
	{ 0x00, 0x00, 0x00, 0x1e, 0x25, 0x2b, 0x35, 0x29, 0x1e, 0x00, 0x00, 0x00 },	// U+239A (⎚)
	{ 0x00, 0x08, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+239B (⎛)
	{ 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+239C (⎜)
	{ 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x04, 0x08, 0x00 },	// U+239D (⎝)
	{ 0x00, 0x02, 0x04, 0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+239E (⎞)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+239F (⎟)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x04, 0x02, 0x00 },	// U+23A0 (⎠)
	{ 0x00, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+23A1 (⎡)
	{ 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+23A2 (⎢)
	{ 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x00 },	// U+23A3 (⎣)
	{ 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+23A4 (⎤)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+23A5 (⎥)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00 },	// U+23A6 (⎦)
	{ 0x00, 0x18, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+23A7 (⎧)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+23A8 (⎨)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x18, 0x00 },	// U+23A9 (⎩)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+23AA (⎪)
	{ 0x00, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+23AB (⎫)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x18, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+23AC (⎬)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00 },	// U+23AD (⎭)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+23AE (⎮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23AF (⎯)
	{ 0x18, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03 },	// U+23B0 (⎰)
	{ 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x18 },	// U+23B1 (⎱)
	{ 0x00, 0x3f, 0x01, 0x01, 0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x08, 0x08 },	// U+23B2 (⎲)
	{ 0x08, 0x08, 0x04, 0x04, 0x04, 0x02, 0x02, 0x02, 0x01, 0x01, 0x3f, 0x00 },	// U+23B3 (⎳)
	{ 0x00, 0x1f, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23B4 (⎴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1f, 0x00, 0x00 },	// U+23B5 (⎵)
	{ 0x00, 0x00, 0x00, 0x11, 0x1f, 0x00, 0x00, 0x1f, 0x11, 0x00, 0x00, 0x00 },	// U+23B6 (⎶)
	{ 0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06, 0x04, 0x04, 0x00, 0x00 },	// U+23B7 (⎷)
	{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+23B8 (⎸)
	{ 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },	// U+23B9 (⎹)
	{ 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BA (⎺)
	{ 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BB (⎻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00 },	// U+23BC (⎼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f },	// U+23BD (⎽)
	{ 0x00, 0x00, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+23BE (⎾)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00, 0x00 },	// U+23BF (⎿)
	{ 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+23C0 (⏀)
	{ 0x00, 0x1f, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+23C1 (⏁)
	{ 0x00, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x1f, 0x00, 0x00 },	// U+23C2 (⏂)
	{ 0x00, 0x04, 0x04, 0x04, 0x0e, 0x0e, 0x15, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+23C3 (⏃)
	{ 0x00, 0x1f, 0x04, 0x04, 0x0e, 0x0e, 0x15, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+23C4 (⏄)
	{ 0x00, 0x04, 0x04, 0x04, 0x0e, 0x0e, 0x15, 0x1f, 0x04, 0x1f, 0x00, 0x00 },	// U+23C5 (⏅)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x16, 0x0d, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+23C6 (⏆)
	{ 0x00, 0x00, 0x1f, 0x04, 0x04, 0x16, 0x0d, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+23C7 (⏇)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x16, 0x0d, 0x04, 0x04, 0x1f, 0x00, 0x00 },	// U+23C8 (⏈)
	{ 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+23C9 (⏉)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00 },	// U+23CA (⏊)
	{ 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+23CB (⏋)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x00 },	// U+23CC (⏌)
	{ 0x00, 0x00, 0x04, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+23CD (⏍)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x1a, 0x1f, 0x0f, 0x02, 0x00, 0x00 },	// U+23CE (⏎)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+23CF (⏏)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+23D0 (⏐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+23D1 (⏑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+23D2 (⏒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0e, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+23D3 (⏓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x2d, 0x12, 0x00, 0x00, 0x00 },	// U+23D4 (⏔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x12, 0x00, 0x3f, 0x00, 0x00, 0x00 },	// U+23D5 (⏕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+23D6 (⏖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+23D7 (⏗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+23D8 (⏘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+23D9 (⏙)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x0e, 0x00, 0x04, 0x00 },	// U+23DA (⏚)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x3f, 0x12, 0x1e, 0x00, 0x00, 0x00 },	// U+23DB (⏛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x00, 0x00 },	// U+23DC (⏜)
	{ 0x00, 0x00, 0x00, 0x21, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23DD (⏝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x33, 0x21, 0x00, 0x00 },	// U+23DE (⏞)
	{ 0x00, 0x00, 0x00, 0x21, 0x33, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23DF (⏟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x00, 0x00 },	// U+23E0 (⏠)
	{ 0x00, 0x00, 0x00, 0x21, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23E1 (⏡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x11, 0x21, 0x3f, 0x00, 0x00 },	// U+23E2 (⏢)
	{ 0x00, 0x00, 0x0c, 0x1e, 0x33, 0x21, 0x33, 0x1e, 0x0c, 0x00, 0x00, 0x00 },	// U+23E3 (⏣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23E4 (⏤)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x11, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+23E5 (⏥)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x3f, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+23E6 (⏦)
	{ 0x00, 0x00, 0x00, 0x05, 0x25, 0x15, 0x0d, 0x0c, 0x12, 0x21, 0x00, 0x00 },	// U+23E7 (⏧)
}; // 189

static const unsigned char orpb_block54[][12] = {
	{ 0x09, 0x0b, 0x0d, 0x09, 0x0a, 0x0a, 0x0e, 0x04, 0x04, 0x04, 0x1c, 0x00 },	// U+2400 (␀)
	{ 0x06, 0x01, 0x02, 0x04, 0x07, 0x0a, 0x0a, 0x04, 0x14, 0x1c, 0x14, 0x00 },	// U+2401 (␁)
	{ 0x06, 0x01, 0x02, 0x04, 0x03, 0x0e, 0x04, 0x04, 0x14, 0x08, 0x14, 0x00 },	// U+2402 (␂)
	{ 0x07, 0x01, 0x03, 0x01, 0x07, 0x0e, 0x04, 0x04, 0x14, 0x08, 0x14, 0x00 },	// U+2403 (␃)
	{ 0x07, 0x01, 0x03, 0x01, 0x07, 0x0a, 0x0a, 0x04, 0x1c, 0x08, 0x08, 0x00 },	// U+2404 (␄)
	{ 0x07, 0x01, 0x03, 0x01, 0x17, 0x16, 0x1a, 0x12, 0x08, 0x14, 0x14, 0x18 },	// U+2405 (␅)
	{ 0x02, 0x05, 0x07, 0x05, 0x0c, 0x02, 0x0c, 0x00, 0x14, 0x0c, 0x14, 0x00 },	// U+2406 (␆)
	{ 0x03, 0x05, 0x03, 0x05, 0x0f, 0x02, 0x06, 0x02, 0x0e, 0x04, 0x04, 0x1c },	// U+2407 (␇)
	{ 0x00, 0x03, 0x05, 0x03, 0x05, 0x03, 0x18, 0x04, 0x08, 0x10, 0x0c, 0x00 },	// U+2408 (␈)
	{ 0x00, 0x05, 0x05, 0x07, 0x05, 0x1d, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2409 (␉)
	{ 0x00, 0x01, 0x01, 0x01, 0x07, 0x00, 0x1c, 0x04, 0x0c, 0x04, 0x00, 0x00 },	// U+240A (␊)
	{ 0x00, 0x05, 0x05, 0x05, 0x02, 0x1e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+240B (␋)
	{ 0x00, 0x00, 0x07, 0x01, 0x03, 0x1d, 0x05, 0x0c, 0x04, 0x04, 0x00, 0x00 },	// U+240C (␌)
	{ 0x00, 0x06, 0x01, 0x01, 0x01, 0x0e, 0x14, 0x0c, 0x14, 0x14, 0x00, 0x00 },	// U+240D (␍)
	{ 0x00, 0x06, 0x01, 0x02, 0x04, 0x0b, 0x14, 0x14, 0x14, 0x08, 0x00, 0x00 },	// U+240E (␎)
	{ 0x00, 0x06, 0x01, 0x02, 0x04, 0x03, 0x1c, 0x08, 0x08, 0x1c, 0x00, 0x00 },	// U+240F (␏)
	{ 0x03, 0x05, 0x05, 0x03, 0x02, 0x02, 0x0e, 0x1c, 0x04, 0x0c, 0x04, 0x1c },	// U+2410 (␐)
	{ 0x03, 0x05, 0x05, 0x03, 0x0c, 0x02, 0x0c, 0x00, 0x08, 0x0c, 0x08, 0x1c },	// U+2411 (␑)
	{ 0x03, 0x05, 0x05, 0x03, 0x0c, 0x02, 0x0c, 0x00, 0x0c, 0x10, 0x08, 0x1c },	// U+2412 (␒)
	{ 0x03, 0x05, 0x05, 0x03, 0x0c, 0x02, 0x0c, 0x0c, 0x10, 0x08, 0x10, 0x0c },	// U+2413 (␓)
	{ 0x03, 0x05, 0x05, 0x03, 0x0c, 0x02, 0x0c, 0x00, 0x04, 0x14, 0x1c, 0x10 },	// U+2414 (␔)
	{ 0x09, 0x0b, 0x0d, 0x00, 0x04, 0x0a, 0x0e, 0x0a, 0x00, 0x14, 0x0c, 0x14 },	// U+2415 (␕)
	{ 0x06, 0x01, 0x02, 0x04, 0x03, 0x0a, 0x0a, 0x04, 0x04, 0x12, 0x16, 0x1a },	// U+2416 (␖)
	{ 0x07, 0x01, 0x03, 0x01, 0x07, 0x0e, 0x04, 0x1c, 0x2c, 0x18, 0x28, 0x18 },	// U+2417 (␗)
	{ 0x06, 0x01, 0x06, 0x00, 0x04, 0x0a, 0x0e, 0x0a, 0x00, 0x16, 0x1a, 0x12 },	// U+2418 (␘)
	{ 0x00, 0x07, 0x01, 0x03, 0x01, 0x07, 0x00, 0x0a, 0x0e, 0x0a, 0x0a, 0x00 },	// U+2419 (␙)
	{ 0x06, 0x01, 0x02, 0x07, 0x0a, 0x0a, 0x04, 0x1c, 0x28, 0x18, 0x28, 0x18 },	// U+241A (␚)
	{ 0x07, 0x01, 0x03, 0x01, 0x0f, 0x02, 0x04, 0x0e, 0x00, 0x18, 0x04, 0x18 },	// U+241B (␛)
	{ 0x00, 0x07, 0x01, 0x03, 0x01, 0x19, 0x04, 0x08, 0x10, 0x0c, 0x00, 0x00 },	// U+241C (␜)
	{ 0x0e, 0x01, 0x0d, 0x09, 0x06, 0x18, 0x04, 0x08, 0x10, 0x0c, 0x00, 0x00 },	// U+241D (␝)
	{ 0x03, 0x05, 0x03, 0x05, 0x05, 0x18, 0x04, 0x08, 0x10, 0x0c, 0x00, 0x00 },	// U+241E (␞)
	{ 0x00, 0x09, 0x09, 0x09, 0x06, 0x18, 0x04, 0x08, 0x10, 0x0c, 0x00, 0x00 },	// U+241F (␟)
	{ 0x00, 0x06, 0x01, 0x02, 0x04, 0x03, 0x0c, 0x14, 0x0c, 0x04, 0x00, 0x00 },	// U+2420 (␠)
	{ 0x03, 0x05, 0x05, 0x0f, 0x02, 0x06, 0x02, 0x0e, 0x04, 0x04, 0x1c, 0x00 },	// U+2421 (␡)
	{ 0x00, 0x00, 0x0a, 0x06, 0x02, 0x0f, 0x12, 0x12, 0x12, 0x0e, 0x00, 0x00 },	// U+2422 (␢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1f, 0x00, 0x00 },	// U+2423 (␣)
	{ 0x00, 0x00, 0x09, 0x0b, 0x0d, 0x09, 0x0d, 0x04, 0x04, 0x1c, 0x00, 0x00 },	// U+2424 (␤)
	{ 0x00, 0x00, 0x12, 0x12, 0x09, 0x05, 0x14, 0x12, 0x09, 0x09, 0x00, 0x00 },	// U+2425 (␥)
	{ 0x00, 0x00, 0x0e, 0x11, 0x01, 0x02, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00 },	// U+2426 (␦)
}; // 39

static const unsigned char orpb_block55[][12] = {
	{ 0x00, 0x00, 0x1c, 0x14, 0x14, 0x04, 0x04, 0x05, 0x05, 0x07, 0x00, 0x00 },	// U+2440 (⑀)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+2441 (⑁)
	{ 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2442 (⑂)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+2443 (⑃)
	{ 0x00, 0x00, 0x1f, 0x15, 0x15, 0x04, 0x04, 0x15, 0x15, 0x1f, 0x00, 0x00 },	// U+2444 (⑄)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+2445 (⑅)
	{ 0x00, 0x00, 0x18, 0x18, 0x1b, 0x03, 0x03, 0x1b, 0x18, 0x18, 0x00, 0x00 },	// U+2446 (⑆)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x04, 0x04, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+2447 (⑇)
	{ 0x00, 0x00, 0x00, 0x30, 0x35, 0x35, 0x35, 0x05, 0x05, 0x00, 0x00, 0x00 },	// U+2448 (⑈)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+2449 (⑉)
	{ 0x00, 0x00, 0x05, 0x05, 0x0a, 0x0a, 0x14, 0x14, 0x28, 0x28, 0x00, 0x00 },	// U+244A (⑊)
}; // 11

static const unsigned char orpb_block56[][12] = {
	{ 0x00, 0x0e, 0x11, 0x15, 0x17, 0x15, 0x15, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+2460 (①)
	{ 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x19, 0x15, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+2461 (②)
	{ 0x00, 0x0e, 0x11, 0x17, 0x19, 0x15, 0x19, 0x17, 0x11, 0x0e, 0x00, 0x00 },	// U+2462 (③)
	{ 0x00, 0x0e, 0x11, 0x13, 0x13, 0x17, 0x1f, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2463 (④)
	{ 0x00, 0x0e, 0x11, 0x1f, 0x13, 0x17, 0x19, 0x17, 0x11, 0x0e, 0x00, 0x00 },	// U+2464 (⑤)
	{ 0x00, 0x0e, 0x11, 0x1d, 0x13, 0x17, 0x1b, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2465 (⑥)
	{ 0x00, 0x0e, 0x11, 0x1f, 0x19, 0x15, 0x15, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2466 (⑦)
	{ 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x15, 0x1b, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2467 (⑧)
	{ 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x1d, 0x19, 0x17, 0x11, 0x0e, 0x00, 0x00 },	// U+2468 (⑨)
	{ 0x00, 0x1e, 0x21, 0x2b, 0x37, 0x37, 0x37, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+2469 (⑩)
	{ 0x00, 0x1e, 0x21, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+246A (⑪)
	{ 0x00, 0x1e, 0x21, 0x2b, 0x33, 0x33, 0x2b, 0x3b, 0x21, 0x1e, 0x00, 0x00 },	// U+246B (⑫)
	{ 0x00, 0x1e, 0x21, 0x2b, 0x33, 0x2b, 0x33, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+246C (⑬)
	{ 0x00, 0x1e, 0x21, 0x2b, 0x2b, 0x3b, 0x3b, 0x33, 0x21, 0x1e, 0x00, 0x00 },	// U+246D (⑭)
	{ 0x00, 0x1e, 0x21, 0x3b, 0x2b, 0x3b, 0x33, 0x3b, 0x21, 0x1e, 0x00, 0x00 },	// U+246E (⑮)
	{ 0x00, 0x1e, 0x21, 0x2b, 0x2b, 0x3b, 0x2b, 0x33, 0x21, 0x1e, 0x00, 0x00 },	// U+246F (⑯)
	{ 0x00, 0x1e, 0x21, 0x3b, 0x33, 0x2b, 0x2b, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+2470 (⑰)
	{ 0x00, 0x1e, 0x21, 0x33, 0x2b, 0x33, 0x2b, 0x33, 0x21, 0x1e, 0x00, 0x00 },	// U+2471 (⑱)
	{ 0x00, 0x1e, 0x21, 0x33, 0x2b, 0x33, 0x23, 0x3b, 0x21, 0x1e, 0x00, 0x00 },	// U+2472 (⑲)
	{ 0x00, 0x1e, 0x21, 0x37, 0x2d, 0x2d, 0x2b, 0x37, 0x21, 0x1e, 0x00, 0x00 },	// U+2473 (⑳)
	{ 0x00, 0x0a, 0x11, 0x15, 0x17, 0x15, 0x15, 0x1f, 0x11, 0x0a, 0x00, 0x00 },	// U+2474 (⑴)
	{ 0x00, 0x0a, 0x11, 0x15, 0x1b, 0x19, 0x15, 0x1f, 0x11, 0x0a, 0x00, 0x00 },	// U+2475 (⑵)
	{ 0x00, 0x0a, 0x11, 0x17, 0x19, 0x15, 0x19, 0x17, 0x11, 0x0a, 0x00, 0x00 },	// U+2476 (⑶)
	{ 0x00, 0x0a, 0x11, 0x13, 0x13, 0x17, 0x1f, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+2477 (⑷)
	{ 0x00, 0x0a, 0x11, 0x1f, 0x13, 0x17, 0x19, 0x17, 0x11, 0x0a, 0x00, 0x00 },	// U+2478 (⑸)
	{ 0x00, 0x0a, 0x11, 0x1d, 0x13, 0x17, 0x1b, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+2479 (⑹)
	{ 0x00, 0x0a, 0x11, 0x1f, 0x19, 0x15, 0x15, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+247A (⑺)
	{ 0x00, 0x0a, 0x11, 0x15, 0x1b, 0x15, 0x1b, 0x15, 0x11, 0x0a, 0x00, 0x00 },	// U+247B (⑻)
	{ 0x00, 0x0a, 0x11, 0x15, 0x1b, 0x1d, 0x19, 0x17, 0x11, 0x0a, 0x00, 0x00 },	// U+247C (⑼)
	{ 0x00, 0x12, 0x21, 0x2b, 0x37, 0x37, 0x37, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+247D (⑽)
	{ 0x00, 0x12, 0x21, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+247E (⑾)
	{ 0x00, 0x12, 0x21, 0x2b, 0x33, 0x33, 0x2b, 0x3b, 0x21, 0x12, 0x00, 0x00 },	// U+247F (⑿)
	{ 0x00, 0x12, 0x21, 0x2b, 0x33, 0x2b, 0x33, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+2480 (⒀)
	{ 0x00, 0x12, 0x21, 0x2b, 0x2b, 0x3b, 0x3b, 0x33, 0x21, 0x12, 0x00, 0x00 },	// U+2481 (⒁)
	{ 0x00, 0x12, 0x21, 0x3b, 0x2b, 0x3b, 0x33, 0x3b, 0x21, 0x12, 0x00, 0x00 },	// U+2482 (⒂)
	{ 0x00, 0x12, 0x21, 0x2b, 0x2b, 0x3b, 0x2b, 0x33, 0x21, 0x12, 0x00, 0x00 },	// U+2483 (⒃)
	{ 0x00, 0x12, 0x21, 0x3b, 0x33, 0x2b, 0x2b, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+2484 (⒄)
	{ 0x00, 0x12, 0x21, 0x33, 0x2b, 0x33, 0x2b, 0x33, 0x21, 0x12, 0x00, 0x00 },	// U+2485 (⒅)
	{ 0x00, 0x12, 0x21, 0x33, 0x2b, 0x33, 0x23, 0x3b, 0x21, 0x12, 0x00, 0x00 },	// U+2486 (⒆)
	{ 0x00, 0x12, 0x21, 0x37, 0x2d, 0x2d, 0x2b, 0x37, 0x21, 0x12, 0x00, 0x00 },	// U+2487 (⒇)
	{ 0x00, 0x00, 0x00, 0x04, 0x06, 0x04, 0x04, 0x04, 0x04, 0x2e, 0x00, 0x00 },	// U+2488 (⒈)
	{ 0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x04, 0x04, 0x02, 0x2f, 0x00, 0x00 },	// U+2489 (⒉)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x08, 0x06, 0x08, 0x08, 0x27, 0x00, 0x00 },	// U+248A (⒊)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x09, 0x09, 0x1f, 0x08, 0x28, 0x00, 0x00 },	// U+248B (⒋)
	{ 0x00, 0x00, 0x00, 0x0f, 0x01, 0x07, 0x08, 0x08, 0x09, 0x26, 0x00, 0x00 },	// U+248C (⒌)
	{ 0x00, 0x00, 0x00, 0x0c, 0x02, 0x01, 0x07, 0x09, 0x09, 0x26, 0x00, 0x00 },	// U+248D (⒍)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x08, 0x08, 0x04, 0x24, 0x00, 0x00 },	// U+248E (⒎)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x06, 0x09, 0x09, 0x26, 0x00, 0x00 },	// U+248F (⒏)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x0e, 0x08, 0x08, 0x26, 0x00, 0x00 },	// U+2490 (⒐)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x15, 0x15, 0x15, 0x15, 0x29, 0x00, 0x00 },	// U+2491 (⒑)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x2a, 0x00, 0x00 },	// U+2492 (⒒)
	{ 0x00, 0x00, 0x00, 0x0d, 0x11, 0x11, 0x09, 0x05, 0x05, 0x2d, 0x00, 0x00 },	// U+2493 (⒓)
	{ 0x00, 0x00, 0x00, 0x0d, 0x11, 0x11, 0x09, 0x11, 0x11, 0x2d, 0x00, 0x00 },	// U+2494 (⒔)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x0d, 0x0d, 0x1d, 0x09, 0x29, 0x00, 0x00 },	// U+2495 (⒕)
	{ 0x00, 0x00, 0x00, 0x1d, 0x05, 0x05, 0x09, 0x09, 0x09, 0x25, 0x00, 0x00 },	// U+2496 (⒖)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x0d, 0x15, 0x15, 0x29, 0x00, 0x00 },	// U+2497 (⒗)
	{ 0x00, 0x00, 0x00, 0x1d, 0x11, 0x11, 0x11, 0x09, 0x09, 0x29, 0x00, 0x00 },	// U+2498 (⒘)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x15, 0x09, 0x15, 0x15, 0x29, 0x00, 0x00 },	// U+2499 (⒙)
	{ 0x00, 0x00, 0x00, 0x09, 0x15, 0x15, 0x19, 0x11, 0x09, 0x25, 0x00, 0x00 },	// U+249A (⒚)
	{ 0x00, 0x00, 0x00, 0x09, 0x16, 0x16, 0x16, 0x15, 0x15, 0x2b, 0x00, 0x00 },	// U+249B (⒛)
	{ 0x00, 0x12, 0x21, 0x25, 0x29, 0x2d, 0x2b, 0x2d, 0x21, 0x12, 0x00, 0x00 },	// U+249C (⒜)
	{ 0x00, 0x12, 0x21, 0x25, 0x25, 0x2d, 0x35, 0x2d, 0x21, 0x12, 0x00, 0x00 },	// U+249D (⒝)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x29, 0x25, 0x29, 0x21, 0x12, 0x00, 0x00 },	// U+249E (⒞)
	{ 0x00, 0x12, 0x21, 0x29, 0x29, 0x2d, 0x2b, 0x2d, 0x21, 0x12, 0x00, 0x00 },	// U+249F (⒟)
	{ 0x00, 0x12, 0x21, 0x29, 0x35, 0x3d, 0x25, 0x29, 0x21, 0x12, 0x00, 0x00 },	// U+24A0 (⒠)
	{ 0x00, 0x12, 0x21, 0x29, 0x25, 0x2f, 0x25, 0x25, 0x21, 0x12, 0x00, 0x00 },	// U+24A1 (⒡)
	{ 0x00, 0x12, 0x21, 0x21, 0x2d, 0x2b, 0x2d, 0x29, 0x25, 0x12, 0x00, 0x00 },	// U+24A2 (⒢)
	{ 0x00, 0x12, 0x21, 0x25, 0x25, 0x2d, 0x35, 0x35, 0x21, 0x12, 0x00, 0x00 },	// U+24A3 (⒣)
	{ 0x00, 0x12, 0x21, 0x21, 0x29, 0x21, 0x29, 0x29, 0x21, 0x12, 0x00, 0x00 },	// U+24A4 (⒤)
	{ 0x00, 0x12, 0x21, 0x21, 0x29, 0x21, 0x29, 0x29, 0x25, 0x12, 0x00, 0x00 },	// U+24A5 (⒥)
	{ 0x00, 0x12, 0x21, 0x25, 0x25, 0x2d, 0x25, 0x2d, 0x21, 0x12, 0x00, 0x00 },	// U+24A6 (⒦)
	{ 0x00, 0x12, 0x21, 0x29, 0x29, 0x29, 0x29, 0x29, 0x21, 0x12, 0x00, 0x00 },	// U+24A7 (⒧)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x37, 0x2b, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+24A8 (⒨)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x27, 0x2b, 0x2b, 0x21, 0x12, 0x00, 0x00 },	// U+24A9 (⒩)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x29, 0x35, 0x29, 0x21, 0x12, 0x00, 0x00 },	// U+24AA (⒪)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x2d, 0x35, 0x2d, 0x25, 0x12, 0x00, 0x00 },	// U+24AB (⒫)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x2d, 0x2b, 0x2d, 0x29, 0x12, 0x00, 0x00 },	// U+24AC (⒬)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x2d, 0x25, 0x25, 0x21, 0x12, 0x00, 0x00 },	// U+24AD (⒭)
	{ 0x00, 0x12, 0x21, 0x21, 0x2d, 0x25, 0x29, 0x2d, 0x21, 0x12, 0x00, 0x00 },	// U+24AE (⒮)
	{ 0x00, 0x12, 0x21, 0x25, 0x25, 0x2f, 0x25, 0x29, 0x21, 0x12, 0x00, 0x00 },	// U+24AF (⒯)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x2b, 0x2b, 0x2d, 0x21, 0x12, 0x00, 0x00 },	// U+24B0 (⒰)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x35, 0x35, 0x29, 0x21, 0x12, 0x00, 0x00 },	// U+24B1 (⒱)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x23, 0x2b, 0x3d, 0x21, 0x12, 0x00, 0x00 },	// U+24B2 (⒲)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x35, 0x29, 0x35, 0x21, 0x12, 0x00, 0x00 },	// U+24B3 (⒳)
	{ 0x00, 0x12, 0x21, 0x21, 0x21, 0x35, 0x35, 0x29, 0x25, 0x12, 0x00, 0x00 },	// U+24B4 (⒴)
	{ 0x00, 0x12, 0x21, 0x21, 0x2d, 0x29, 0x25, 0x2d, 0x21, 0x12, 0x00, 0x00 },	// U+24B5 (⒵)
	{ 0x00, 0x1e, 0x21, 0x29, 0x35, 0x3d, 0x35, 0x35, 0x21, 0x1e, 0x00, 0x00 },	// U+24B6 (Ⓐ)
	{ 0x00, 0x1e, 0x21, 0x2d, 0x35, 0x2d, 0x35, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24B7 (Ⓑ)
	{ 0x00, 0x1e, 0x21, 0x29, 0x25, 0x25, 0x25, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24B8 (Ⓒ)
	{ 0x00, 0x1e, 0x21, 0x2d, 0x35, 0x35, 0x35, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24B9 (Ⓓ)
	{ 0x00, 0x1e, 0x21, 0x2d, 0x25, 0x2d, 0x25, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24BA (Ⓔ)
	{ 0x00, 0x1e, 0x21, 0x2d, 0x25, 0x2d, 0x25, 0x25, 0x21, 0x1e, 0x00, 0x00 },	// U+24BB (Ⓕ)
	{ 0x00, 0x1e, 0x21, 0x2d, 0x23, 0x2b, 0x2b, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24BC (Ⓖ)
	{ 0x00, 0x1e, 0x21, 0x35, 0x35, 0x3d, 0x35, 0x35, 0x21, 0x1e, 0x00, 0x00 },	// U+24BD (Ⓗ)
	{ 0x00, 0x1e, 0x21, 0x29, 0x29, 0x29, 0x29, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24BE (Ⓘ)
	{ 0x00, 0x1e, 0x21, 0x2d, 0x29, 0x29, 0x29, 0x25, 0x21, 0x1e, 0x00, 0x00 },	// U+24BF (Ⓙ)
	{ 0x00, 0x1e, 0x21, 0x35, 0x35, 0x2d, 0x35, 0x35, 0x21, 0x1e, 0x00, 0x00 },	// U+24C0 (Ⓚ)
	{ 0x00, 0x1e, 0x21, 0x25, 0x25, 0x25, 0x25, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24C1 (Ⓛ)
	{ 0x00, 0x1e, 0x21, 0x35, 0x3d, 0x35, 0x35, 0x35, 0x21, 0x1e, 0x00, 0x00 },	// U+24C2 (Ⓜ)
	{ 0x00, 0x1e, 0x21, 0x35, 0x3d, 0x3d, 0x35, 0x35, 0x21, 0x1e, 0x00, 0x00 },	// U+24C3 (Ⓝ)
	{ 0x00, 0x1e, 0x21, 0x29, 0x35, 0x35, 0x35, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24C4 (Ⓞ)
	{ 0x00, 0x1e, 0x21, 0x2d, 0x35, 0x2d, 0x25, 0x25, 0x21, 0x1e, 0x00, 0x00 },	// U+24C5 (Ⓟ)
	{ 0x00, 0x1e, 0x21, 0x25, 0x2b, 0x2b, 0x2b, 0x2d, 0x29, 0x1e, 0x00, 0x00 },	// U+24C6 (Ⓠ)
	{ 0x00, 0x1e, 0x21, 0x2d, 0x35, 0x2d, 0x35, 0x35, 0x21, 0x1e, 0x00, 0x00 },	// U+24C7 (Ⓡ)
	{ 0x00, 0x1e, 0x21, 0x39, 0x25, 0x29, 0x31, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24C8 (Ⓢ)
	{ 0x00, 0x1e, 0x21, 0x3d, 0x29, 0x29, 0x29, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24C9 (Ⓣ)
	{ 0x00, 0x1e, 0x21, 0x35, 0x35, 0x35, 0x35, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24CA (Ⓤ)
	{ 0x00, 0x1e, 0x21, 0x35, 0x35, 0x35, 0x29, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24CB (Ⓥ)
	{ 0x00, 0x1e, 0x21, 0x23, 0x2b, 0x2b, 0x35, 0x35, 0x21, 0x1e, 0x00, 0x00 },	// U+24CC (Ⓦ)
	{ 0x00, 0x1e, 0x21, 0x35, 0x35, 0x29, 0x35, 0x35, 0x21, 0x1e, 0x00, 0x00 },	// U+24CD (Ⓧ)
	{ 0x00, 0x1e, 0x21, 0x35, 0x35, 0x29, 0x29, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24CE (Ⓨ)
	{ 0x00, 0x1e, 0x21, 0x3d, 0x31, 0x29, 0x25, 0x3d, 0x21, 0x1e, 0x00, 0x00 },	// U+24CF (Ⓩ)
	{ 0x00, 0x1e, 0x21, 0x25, 0x29, 0x2d, 0x2b, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24D0 (ⓐ)
	{ 0x00, 0x1e, 0x21, 0x25, 0x25, 0x2d, 0x35, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24D1 (ⓑ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x29, 0x25, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24D2 (ⓒ)
	{ 0x00, 0x1e, 0x21, 0x29, 0x29, 0x2d, 0x2b, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24D3 (ⓓ)
	{ 0x00, 0x1e, 0x21, 0x29, 0x35, 0x3d, 0x25, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24D4 (ⓔ)
	{ 0x00, 0x1e, 0x21, 0x29, 0x25, 0x2f, 0x25, 0x25, 0x21, 0x1e, 0x00, 0x00 },	// U+24D5 (ⓕ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x2d, 0x2b, 0x2d, 0x29, 0x25, 0x1e, 0x00, 0x00 },	// U+24D6 (ⓖ)
	{ 0x00, 0x1e, 0x21, 0x25, 0x25, 0x2d, 0x35, 0x35, 0x21, 0x1e, 0x00, 0x00 },	// U+24D7 (ⓗ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x29, 0x21, 0x29, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24D8 (ⓘ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x29, 0x21, 0x29, 0x29, 0x25, 0x1e, 0x00, 0x00 },	// U+24D9 (ⓙ)
	{ 0x00, 0x1e, 0x21, 0x25, 0x25, 0x2d, 0x25, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24DA (ⓚ)
	{ 0x00, 0x1e, 0x21, 0x29, 0x29, 0x29, 0x29, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24DB (ⓛ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x37, 0x2b, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+24DC (ⓜ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x27, 0x2b, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+24DD (ⓝ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x29, 0x35, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24DE (ⓞ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x2d, 0x35, 0x2d, 0x25, 0x1e, 0x00, 0x00 },	// U+24DF (ⓟ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x2d, 0x2b, 0x2d, 0x29, 0x1e, 0x00, 0x00 },	// U+24E0 (ⓠ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x2d, 0x25, 0x25, 0x21, 0x1e, 0x00, 0x00 },	// U+24E1 (ⓡ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x2d, 0x25, 0x29, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24E2 (ⓢ)
	{ 0x00, 0x1e, 0x21, 0x25, 0x25, 0x2f, 0x25, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24E3 (ⓣ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x2b, 0x2b, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24E4 (ⓤ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x35, 0x35, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24E5 (ⓥ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x23, 0x2b, 0x3d, 0x21, 0x1e, 0x00, 0x00 },	// U+24E6 (ⓦ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x35, 0x29, 0x35, 0x21, 0x1e, 0x00, 0x00 },	// U+24E7 (ⓧ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x21, 0x35, 0x35, 0x29, 0x25, 0x1e, 0x00, 0x00 },	// U+24E8 (ⓨ)
	{ 0x00, 0x1e, 0x21, 0x21, 0x2d, 0x29, 0x25, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+24E9 (ⓩ)
	{ 0x00, 0x1e, 0x21, 0x29, 0x35, 0x35, 0x35, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+24EA (⓪)
	{ 0x00, 0x1e, 0x3f, 0x35, 0x35, 0x35, 0x35, 0x35, 0x3f, 0x1e, 0x00, 0x00 },	// U+24EB (⓫)
	{ 0x00, 0x1e, 0x3f, 0x35, 0x2d, 0x2d, 0x35, 0x25, 0x3f, 0x1e, 0x00, 0x00 },	// U+24EC (⓬)
	{ 0x00, 0x1e, 0x3f, 0x35, 0x2d, 0x35, 0x2d, 0x35, 0x3f, 0x1e, 0x00, 0x00 },	// U+24ED (⓭)
	{ 0x00, 0x1e, 0x3f, 0x35, 0x35, 0x25, 0x25, 0x2d, 0x3f, 0x1e, 0x00, 0x00 },	// U+24EE (⓮)
	{ 0x00, 0x1e, 0x3f, 0x25, 0x35, 0x25, 0x2d, 0x25, 0x3f, 0x1e, 0x00, 0x00 },	// U+24EF (⓯)
	{ 0x00, 0x1e, 0x3f, 0x35, 0x35, 0x25, 0x15, 0x2d, 0x3f, 0x1e, 0x00, 0x00 },	// U+24F0 (⓰)
	{ 0x00, 0x1e, 0x3f, 0x25, 0x2d, 0x35, 0x35, 0x35, 0x3f, 0x1e, 0x00, 0x00 },	// U+24F1 (⓱)
	{ 0x00, 0x1e, 0x3f, 0x2d, 0x15, 0x2d, 0x15, 0x2d, 0x3f, 0x1e, 0x00, 0x00 },	// U+24F2 (⓲)
	{ 0x00, 0x1e, 0x3f, 0x2d, 0x15, 0x0d, 0x1d, 0x2d, 0x3f, 0x1e, 0x00, 0x00 },	// U+24F3 (⓳)
	{ 0x00, 0x1e, 0x3f, 0x2d, 0x13, 0x13, 0x15, 0x29, 0x3f, 0x1e, 0x00, 0x00 },	// U+24F4 (⓴)
	{ 0x0e, 0x1f, 0x11, 0x15, 0x17, 0x15, 0x15, 0x1f, 0x11, 0x1f, 0x0e, 0x00 },	// U+24F5 (⓵)
	{ 0x0e, 0x1f, 0x11, 0x15, 0x1b, 0x19, 0x15, 0x1f, 0x11, 0x1f, 0x0e, 0x00 },	// U+24F6 (⓶)
	{ 0x0e, 0x1f, 0x11, 0x17, 0x19, 0x15, 0x19, 0x17, 0x11, 0x1f, 0x0e, 0x00 },	// U+24F7 (⓷)
	{ 0x0e, 0x1f, 0x11, 0x13, 0x13, 0x17, 0x1f, 0x15, 0x11, 0x1f, 0x0e, 0x00 },	// U+24F8 (⓸)
	{ 0x0e, 0x1f, 0x11, 0x1f, 0x13, 0x17, 0x19, 0x17, 0x11, 0x1f, 0x0e, 0x00 },	// U+24F9 (⓹)
	{ 0x0e, 0x1f, 0x11, 0x1d, 0x13, 0x17, 0x1b, 0x15, 0x11, 0x1f, 0x0e, 0x00 },	// U+24FA (⓺)
	{ 0x0e, 0x1f, 0x11, 0x1f, 0x19, 0x15, 0x15, 0x15, 0x11, 0x1f, 0x0e, 0x00 },	// U+24FB (⓻)
	{ 0x0e, 0x1f, 0x11, 0x15, 0x1b, 0x15, 0x1b, 0x15, 0x11, 0x1f, 0x0e, 0x00 },	// U+24FC (⓼)
	{ 0x0e, 0x1f, 0x11, 0x15, 0x1b, 0x1d, 0x19, 0x17, 0x11, 0x1f, 0x0e, 0x00 },	// U+24FD (⓽)
	{ 0x1e, 0x3f, 0x21, 0x2b, 0x37, 0x37, 0x37, 0x2b, 0x21, 0x3f, 0x1e, 0x00 },	// U+24FE (⓾)
	{ 0x00, 0x1e, 0x3f, 0x33, 0x2d, 0x2d, 0x2d, 0x33, 0x3f, 0x1e, 0x00, 0x00 },	// U+24FF (⓿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2500 (─)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2501 (━)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2502 (│)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2503 (┃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2504 (┄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2505 (┅)
	{ 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00 },	// U+2506 (┆)
	{ 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x00 },	// U+2507 (┇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2508 (┈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2509 (┉)
	{ 0x00, 0x04, 0x04, 0x00, 0x04, 0x04, 0x00, 0x04, 0x04, 0x00, 0x04, 0x04 },	// U+250A (┊)
	{ 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c },	// U+250B (┋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+250C (┌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+250D (┍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+250E (┎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+250F (┏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2510 (┐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2511 (┑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2512 (┒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2513 (┓)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2514 (└)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2515 (┕)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2516 (┖)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2517 (┗)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2518 (┘)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2519 (┙)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251A (┚)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251B (┛)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+251C (├)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+251D (┝)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+251E (┞)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+251F (┟)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2520 (┠)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2521 (┡)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2522 (┢)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2523 (┣)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2524 (┤)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2525 (┥)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2526 (┦)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2527 (┧)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2528 (┨)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2529 (┩)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+252A (┪)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+252B (┫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+252C (┬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+252D (┭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+252E (┮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+252F (┯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2530 (┰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2531 (┱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2532 (┲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2533 (┳)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2534 (┴)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2535 (┵)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2536 (┶)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2537 (┷)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2538 (┸)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2539 (┹)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253A (┺)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253B (┻)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+253C (┼)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+253D (┽)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+253E (┾)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+253F (┿)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2540 (╀)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2541 (╁)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2542 (╂)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2543 (╃)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2544 (╄)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x0f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2545 (╅)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2546 (╆)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2547 (╇)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2548 (╈)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+2549 (╉)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+254A (╊)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+254B (╋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+254C (╌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+254D (╍)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00 },	// U+254E (╎)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00 },	// U+254F (╏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+2550 (═)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2551 (║)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04 },	// U+2552 (╒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2553 (╓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x3a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2554 (╔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x07, 0x04, 0x04, 0x04, 0x04 },	// U+2555 (╕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2556 (╖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x0b, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2557 (╗)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x04, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2558 (╘)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2559 (╙)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3a, 0x02, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+255A (╚)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x04, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+255B (╛)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255C (╜)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0b, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+255D (╝)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04 },	// U+255E (╞)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+255F (╟)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3a, 0x02, 0x3a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2560 (╠)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x04, 0x07, 0x04, 0x04, 0x04, 0x04 },	// U+2561 (╡)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2562 (╢)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0b, 0x08, 0x0b, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2563 (╣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x3f, 0x04, 0x04, 0x04, 0x04 },	// U+2564 (╤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2565 (╥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x3b, 0x0a, 0x0a, 0x0a, 0x0a },	// U+2566 (╦)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+2567 (╧)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2568 (╨)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3b, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+2569 (╩)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x3f, 0x04, 0x3f, 0x04, 0x04, 0x04, 0x04 },	// U+256A (╪)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3f, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a },	// U+256B (╫)
	{ 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3b, 0x00, 0x3b, 0x0a, 0x0a, 0x0a, 0x0a },	// U+256C (╬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0x04, 0x04, 0x04, 0x04 },	// U+256D (╭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x04, 0x04, 0x04 },	// U+256E (╮)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+256F (╯)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2570 (╰)
	{ 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01 },	// U+2571 (╱)
	{ 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20 },	// U+2572 (╲)
	{ 0x21, 0x21, 0x12, 0x12, 0x0c, 0x0c, 0x0c, 0x0c, 0x12, 0x12, 0x21, 0x21 },	// U+2573 (╳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2574 (╴)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2575 (╵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2576 (╶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+2577 (╷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2578 (╸)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2579 (╹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257A (╺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+257B (╻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257C (╼)
	{ 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },	// U+257D (╽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257E (╾)
	{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04 },	// U+257F (╿)
	{ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2580 (▀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f },	// U+2581 (▁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f },	// U+2582 (▂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2583 (▃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2584 (▄)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2585 (▅)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2586 (▆)
	{ 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2587 (▇)
	{ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2588 (█)
	{ 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f },	// U+2589 (▉)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+258A (▊)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+258B (▋)
	{ 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+258C (▌)
	{ 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 },	// U+258D (▍)
	{ 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 },	// U+258E (▎)
	{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+258F (▏)
	{ 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2590 (▐)
	{ 0x15, 0x00, 0x2a, 0x00, 0x15, 0x00, 0x2a, 0x00, 0x15, 0x00, 0x2a, 0x00 },	// U+2591 (░)
	{ 0x15, 0x2a, 0x15, 0x2a, 0x15, 0x2a, 0x15, 0x2a, 0x15, 0x2a, 0x15, 0x2a },	// U+2592 (▒)
	{ 0x2a, 0x3f, 0x15, 0x3f, 0x2a, 0x3f, 0x15, 0x3f, 0x2a, 0x3f, 0x15, 0x3f },	// U+2593 (▓)
	{ 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2594 (▔)
	{ 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 },	// U+2595 (▕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+2596 (▖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+2597 (▗)
	{ 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2598 (▘)
	{ 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2599 (▙)
	{ 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+259A (▚)
	{ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+259B (▛)
	{ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38 },	// U+259C (▜)
	{ 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+259D (▝)
	{ 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+259E (▞)
	{ 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+259F (▟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00 },	// U+25A0 (■)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+25A1 (□)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+25A2 (▢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+25A3 (▣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x1f, 0x11, 0x1f, 0x00, 0x00 },	// U+25A4 (▤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00 },	// U+25A5 (▥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x1f, 0x15, 0x1f, 0x00, 0x00 },	// U+25A6 (▦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x13, 0x15, 0x19, 0x1f, 0x00, 0x00 },	// U+25A7 (▧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x19, 0x15, 0x13, 0x1f, 0x00, 0x00 },	// U+25A8 (▨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1b, 0x15, 0x1b, 0x1f, 0x00, 0x00 },	// U+25A9 (▩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+25AA (▪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+25AB (▫)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+25AC (▬)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+25AD (▭)
	{ 0x00, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x00 },	// U+25AE (▮)
	{ 0x00, 0x1e, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x1e, 0x00 },	// U+25AF (▯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x1e, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+25B0 (▰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x12, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+25B1 (▱)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x1f, 0x1f, 0x1f, 0x00, 0x00 },	// U+25B2 (▲)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+25B3 (△)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x1f, 0x00, 0x00, 0x00 },	// U+25B4 (▴)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x1f, 0x00, 0x00, 0x00 },	// U+25B5 (▵)
	{ 0x00, 0x00, 0x00, 0x02, 0x06, 0x0e, 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00 },	// U+25B6 (▶)
	{ 0x00, 0x00, 0x00, 0x02, 0x06, 0x0a, 0x12, 0x0a, 0x06, 0x02, 0x00, 0x00 },	// U+25B7 (▷)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00 },	// U+25B8 (▸)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0a, 0x06, 0x02, 0x00, 0x00, 0x00 },	// U+25B9 (▹)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x3f, 0x0f, 0x03, 0x00, 0x00, 0x00 },	// U+25BA (►)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0d, 0x31, 0x0d, 0x03, 0x00, 0x00, 0x00 },	// U+25BB (▻)
	{ 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+25BC (▼)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+25BD (▽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+25BE (▾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+25BF (▿)
	{ 0x00, 0x00, 0x00, 0x10, 0x18, 0x1c, 0x1e, 0x1c, 0x18, 0x10, 0x00, 0x00 },	// U+25C0 (◀)
	{ 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x12, 0x14, 0x18, 0x10, 0x00, 0x00 },	// U+25C1 (◁)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0e, 0x0c, 0x08, 0x00, 0x00, 0x00 },	// U+25C2 (◂)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x0c, 0x08, 0x00, 0x00, 0x00 },	// U+25C3 (◃)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x3c, 0x3f, 0x3c, 0x30, 0x00, 0x00, 0x00 },	// U+25C4 (◄)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x2c, 0x23, 0x2c, 0x30, 0x00, 0x00, 0x00 },	// U+25C5 (◅)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+25C6 (◆)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+25C7 (◇)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x15, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+25C8 (◈)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x2d, 0x2d, 0x12, 0x0c, 0x00, 0x00 },	// U+25C9 (◉)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+25CA (◊)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x21, 0x21, 0x12, 0x0c, 0x00, 0x00 },	// U+25CB (○)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x10, 0x01, 0x20, 0x02, 0x08, 0x00, 0x00 },	// U+25CC (◌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+25CD (◍)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+25CE (◎)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x3f, 0x1e, 0x0c, 0x00, 0x00 },	// U+25CF (●)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x16, 0x27, 0x27, 0x16, 0x0c, 0x00, 0x00 },	// U+25D0 (◐)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1a, 0x39, 0x39, 0x1a, 0x0c, 0x00, 0x00 },	// U+25D1 (◑)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x21, 0x3f, 0x1e, 0x0c, 0x00, 0x00 },	// U+25D2 (◒)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x21, 0x12, 0x0c, 0x00, 0x00 },	// U+25D3 (◓)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1a, 0x39, 0x21, 0x12, 0x0c, 0x00, 0x00 },	// U+25D4 (◔)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x16, 0x27, 0x21, 0x12, 0x0c, 0x00, 0x00 },	// U+25D5 (◕)
	{ 0x00, 0x20, 0x38, 0x3c, 0x3c, 0x3e, 0x3c, 0x3c, 0x38, 0x20, 0x00, 0x00 },	// U+25D6 (◖)
	{ 0x00, 0x01, 0x07, 0x0f, 0x0f, 0x1f, 0x0f, 0x0f, 0x07, 0x01, 0x00, 0x00 },	// U+25D7 (◗)
	{ 0x3f, 0x3f, 0x3f, 0x3f, 0x33, 0x21, 0x21, 0x33, 0x3f, 0x3f, 0x3f, 0x3f },	// U+25D8 (◘)
	{ 0x3f, 0x3f, 0x3f, 0x33, 0x2d, 0x1e, 0x1e, 0x2d, 0x33, 0x3f, 0x3f, 0x3f },	// U+25D9 (◙)
	{ 0x3f, 0x3f, 0x3f, 0x33, 0x2d, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25DA (◚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2d, 0x33, 0x3f, 0x3f, 0x3f },	// U+25DB (◛)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25DC (◜)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25DD (◝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x00, 0x00 },	// U+25DE (◞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x00, 0x00 },	// U+25DF (◟)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25E0 (◠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x12, 0x0c, 0x00, 0x00 },	// U+25E1 (◡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x1c, 0x1e, 0x1f, 0x00, 0x00 },	// U+25E2 (◢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x00, 0x00 },	// U+25E3 (◣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0f, 0x07, 0x03, 0x01, 0x00, 0x00 },	// U+25E4 (◤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1e, 0x1c, 0x18, 0x10, 0x00, 0x00 },	// U+25E5 (◥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+25E6 (◦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x17, 0x17, 0x17, 0x1f, 0x00, 0x00 },	// U+25E7 (◧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1d, 0x1d, 0x1d, 0x1f, 0x00, 0x00 },	// U+25E8 (◨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x17, 0x13, 0x1f, 0x00, 0x00 },	// U+25E9 (◩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x19, 0x1d, 0x1f, 0x1f, 0x00, 0x00 },	// U+25EA (◪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00 },	// U+25EB (◫)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0e, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+25EC (◬)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x17, 0x17, 0x1f, 0x00, 0x00 },	// U+25ED (◭)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x1d, 0x1d, 0x1f, 0x00, 0x00 },	// U+25EE (◮)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x21, 0x21, 0x21, 0x12, 0x0c, 0x00, 0x00 },	// U+25EF (◯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x17, 0x11, 0x1f, 0x00, 0x00 },	// U+25F0 (◰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x17, 0x15, 0x1f, 0x00, 0x00 },	// U+25F1 (◱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x1d, 0x15, 0x1f, 0x00, 0x00 },	// U+25F2 (◲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x15, 0x1d, 0x11, 0x1f, 0x00, 0x00 },	// U+25F3 (◳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x17, 0x11, 0x0e, 0x00, 0x00 },	// U+25F4 (◴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x17, 0x15, 0x0e, 0x00, 0x00 },	// U+25F5 (◵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1d, 0x15, 0x0e, 0x00, 0x00 },	// U+25F6 (◶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x1d, 0x11, 0x0e, 0x00, 0x00 },	// U+25F7 (◷)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x09, 0x05, 0x03, 0x01, 0x00, 0x00, 0x00 },	// U+25F8 (◸)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x14, 0x18, 0x10, 0x00, 0x00, 0x00 },	// U+25F9 (◹)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x05, 0x09, 0x1f, 0x00, 0x00, 0x00 },	// U+25FA (◺)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x12, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+25FB (◻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+25FC (◼)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x12, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+25FD (◽)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+25FE (◾)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x12, 0x1f, 0x00, 0x00, 0x00 },	// U+25FF (◿)
	{ 0x00, 0x04, 0x04, 0x11, 0x04, 0x0e, 0x04, 0x11, 0x04, 0x04, 0x00, 0x00 },	// U+2600 (☀)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x1f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2601 (☁)
	{ 0x00, 0x04, 0x0e, 0x1f, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x02, 0x00, 0x00 },	// U+2602 (☂)
	{ 0x05, 0x2e, 0x0a, 0x15, 0x0a, 0x2a, 0x0e, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+2603 (☃)
	{ 0x10, 0x12, 0x0a, 0x2a, 0x22, 0x10, 0x06, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+2604 (☄)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0e, 0x0e, 0x11, 0x00, 0x00, 0x00 },	// U+2605 (★)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0a, 0x0e, 0x11, 0x00, 0x00, 0x00 },	// U+2606 (☆)
	{ 0x00, 0x10, 0x08, 0x04, 0x02, 0x01, 0x02, 0x14, 0x18, 0x1c, 0x00, 0x00 },	// U+2607 (☇)
	{ 0x00, 0x1f, 0x11, 0x09, 0x09, 0x05, 0x05, 0x19, 0x19, 0x1d, 0x00, 0x00 },	// U+2608 (☈)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2609 (☉)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0a, 0x0a, 0x15, 0x0a, 0x00, 0x00 },	// U+260A (☊)
	{ 0x00, 0x00, 0x00, 0x0a, 0x15, 0x0a, 0x0a, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+260B (☋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+260C (☌)
	{ 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x04, 0x06, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+260D (☍)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x15, 0x0e, 0x1f, 0x1f, 0x1f, 0x00, 0x00 },	// U+260E (☎)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x0e, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+260F (☏)
	{ 0x00, 0x3f, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00 },	// U+2610 (☐)
	{ 0x00, 0x3f, 0x21, 0x31, 0x31, 0x29, 0x29, 0x2b, 0x25, 0x3f, 0x00, 0x00 },	// U+2611 (☑)
	{ 0x00, 0x3f, 0x33, 0x33, 0x2d, 0x2d, 0x2d, 0x33, 0x33, 0x3f, 0x00, 0x00 },	// U+2612 (☒)
	{ 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+2613 (☓)
}; // 436

static const unsigned char orpb_block57[][12] = {
	{ 0x00, 0x00, 0x04, 0x0a, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2616 (☖)
	{ 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00 },	// U+2617 (☗)
}; // 2

static const unsigned char orpb_block58[][12] = {
	{ 0x00, 0x00, 0x10, 0x24, 0x2e, 0x1f, 0x17, 0x2f, 0x2e, 0x14, 0x00, 0x00 },	// U+2619 (☙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3e, 0x3e, 0x3c, 0x00, 0x00, 0x00 },	// U+261A (☚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x1f, 0x1f, 0x0f, 0x00, 0x00, 0x00 },	// U+261B (☛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x32, 0x32, 0x3c, 0x00, 0x00, 0x00 },	// U+261C (☜)
	{ 0x00, 0x00, 0x10, 0x18, 0x1e, 0x16, 0x12, 0x12, 0x1e, 0x1e, 0x00, 0x00 },	// U+261D (☝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x13, 0x13, 0x0f, 0x00, 0x00, 0x00 },	// U+261E (☞)
	{ 0x00, 0x1e, 0x1e, 0x12, 0x12, 0x16, 0x1e, 0x18, 0x10, 0x10, 0x00, 0x00 },	// U+261F (☟)
	{ 0x00, 0x0e, 0x15, 0x1f, 0x0e, 0x0a, 0x04, 0x11, 0x0e, 0x11, 0x00, 0x00 },	// U+2620 (☠)
	{ 0x00, 0x00, 0x0e, 0x10, 0x10, 0x08, 0x04, 0x02, 0x02, 0x1c, 0x00, 0x00 },	// U+2621 (☡)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+2622 (☢)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x3f, 0x12, 0x12, 0x0c, 0x12, 0x00, 0x00 },	// U+2623 (☣)
	{ 0x00, 0x04, 0x1f, 0x0e, 0x0a, 0x0e, 0x0a, 0x0e, 0x0a, 0x04, 0x00, 0x00 },	// U+2624 (☤)
	{ 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2625 (☥)
	{ 0x00, 0x00, 0x04, 0x0e, 0x04, 0x1f, 0x04, 0x06, 0x0c, 0x04, 0x00, 0x00 },	// U+2626 (☦)
	{ 0x00, 0x00, 0x0c, 0x14, 0x0c, 0x15, 0x0e, 0x04, 0x0e, 0x15, 0x00, 0x00 },	// U+2627 (☧)
	{ 0x00, 0x00, 0x04, 0x0e, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2628 (☨)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x15, 0x1f, 0x15, 0x04, 0x0e, 0x00, 0x00 },	// U+2629 (☩)
	{ 0x00, 0x1e, 0x27, 0x13, 0x3b, 0x13, 0x2b, 0x03, 0x27, 0x1e, 0x00, 0x00 },	// U+262A (☪)
	{ 0x00, 0x15, 0x0a, 0x00, 0x04, 0x15, 0x15, 0x15, 0x0e, 0x0e, 0x00, 0x00 },	// U+262B (☫)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x0e, 0x11, 0x0e, 0x0e, 0x15, 0x00, 0x00 },	// U+262C (☬)
	{ 0x00, 0x0e, 0x11, 0x14, 0x16, 0x13, 0x15, 0x18, 0x12, 0x2d, 0x00, 0x00 },	// U+262D (☭)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x1f, 0x15, 0x0e, 0x00, 0x00 },	// U+262E (☮)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x37, 0x25, 0x3f, 0x1e, 0x00, 0x00 },	// U+262F (☯)
	{ 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x00 },	// U+2630 (☰)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x00 },	// U+2631 (☱)
	{ 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1b, 0x1b, 0x00, 0x1f, 0x1f, 0x00, 0x00 },	// U+2632 (☲)
	{ 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x1b, 0x1b, 0x00, 0x00 },	// U+2633 (☳)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1f, 0x1f, 0x00, 0x00 },	// U+2634 (☴)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1f, 0x1f, 0x00, 0x1b, 0x1b, 0x00, 0x00 },	// U+2635 (☵)
	{ 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00 },	// U+2636 (☶)
	{ 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00 },	// U+2637 (☷)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x1b, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2638 (☸)
	{ 0x00, 0x00, 0x0e, 0x11, 0x1b, 0x1b, 0x11, 0x15, 0x1b, 0x11, 0x0e, 0x00 },	// U+2639 (☹)
	{ 0x00, 0x00, 0x0e, 0x11, 0x1b, 0x1b, 0x11, 0x1b, 0x15, 0x11, 0x0e, 0x00 },	// U+263A (☺)
	{ 0x00, 0x00, 0x0e, 0x1f, 0x15, 0x15, 0x1f, 0x15, 0x1b, 0x1f, 0x0e, 0x00 },	// U+263B (☻)
	{ 0x00, 0x00, 0x04, 0x04, 0x11, 0x04, 0x0a, 0x04, 0x11, 0x04, 0x04, 0x00 },	// U+263C (☼)
	{ 0x00, 0x00, 0x00, 0x0e, 0x13, 0x14, 0x14, 0x14, 0x13, 0x0e, 0x00, 0x00 },	// U+263D (☽)
	{ 0x00, 0x00, 0x00, 0x0e, 0x19, 0x05, 0x05, 0x05, 0x19, 0x0e, 0x00, 0x00 },	// U+263E (☾)
	{ 0x00, 0x00, 0x11, 0x0e, 0x11, 0x11, 0x0e, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+263F (☿)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x0e, 0x04 },	// U+2640 (♀)
	{ 0x00, 0x00, 0x04, 0x0e, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+2641 (♁)
	{ 0x00, 0x00, 0x00, 0x38, 0x30, 0x2e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+2642 (♂)
	{ 0x00, 0x00, 0x00, 0x12, 0x15, 0x14, 0x14, 0x12, 0x1f, 0x10, 0x00, 0x00 },	// U+2643 (♃)
	{ 0x00, 0x00, 0x00, 0x02, 0x07, 0x02, 0x0a, 0x16, 0x12, 0x12, 0x00, 0x00 },	// U+2644 (♄)
	{ 0x00, 0x00, 0x00, 0x11, 0x15, 0x1f, 0x15, 0x15, 0x04, 0x0a, 0x04, 0x00 },	// U+2645 (♅)
	{ 0x00, 0x00, 0x15, 0x3f, 0x15, 0x15, 0x0e, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+2646 (♆)
	{ 0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x02, 0x02, 0x1e, 0x00, 0x00 },	// U+2647 (♇)
	{ 0x00, 0x00, 0x00, 0x0a, 0x15, 0x15, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2648 (♈)
	{ 0x00, 0x00, 0x00, 0x00, 0x21, 0x12, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+2649 (♉)
	{ 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x1f, 0x00, 0x00 },	// U+264A (♊)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x05, 0x12, 0x28, 0x11, 0x0e, 0x00, 0x00 },	// U+264B (♋)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x12, 0x14, 0x16, 0x15, 0x12, 0x20, 0x00 },	// U+264C (♌)
	{ 0x00, 0x00, 0x00, 0x35, 0x3f, 0x35, 0x35, 0x35, 0x15, 0x15, 0x18, 0x14 },	// U+264D (♍)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0a, 0x1b, 0x00, 0x1f, 0x00, 0x00 },	// U+264E (♎)
	{ 0x00, 0x00, 0x00, 0x15, 0x1f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x30, 0x00 },	// U+264F (♏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x15, 0x02, 0x05, 0x00, 0x00 },	// U+2650 (♐)
	{ 0x00, 0x00, 0x00, 0x01, 0x09, 0x15, 0x0d, 0x13, 0x11, 0x0c, 0x00, 0x00 },	// U+2651 (♑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x15, 0x00, 0x2a, 0x15, 0x00, 0x00 },	// U+2652 (♒)
	{ 0x00, 0x00, 0x00, 0x11, 0x0a, 0x0a, 0x1f, 0x0a, 0x0a, 0x11, 0x00, 0x00 },	// U+2653 (♓)
	{ 0x04, 0x0e, 0x0e, 0x15, 0x1f, 0x11, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x00 },	// U+2654 (♔)
	{ 0x00, 0x15, 0x1f, 0x11, 0x1f, 0x0a, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x00 },	// U+2655 (♕)
	{ 0x00, 0x00, 0x00, 0x15, 0x1f, 0x0a, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x00 },	// U+2656 (♖)
	{ 0x00, 0x04, 0x0a, 0x0e, 0x1b, 0x11, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x00 },	// U+2657 (♗)
	{ 0x00, 0x08, 0x1c, 0x16, 0x11, 0x17, 0x14, 0x14, 0x22, 0x3e, 0x00, 0x00 },	// U+2658 (♘)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x0a, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x00 },	// U+2659 (♙)
	{ 0x04, 0x0e, 0x0e, 0x15, 0x1f, 0x1f, 0x0e, 0x0e, 0x1f, 0x1f, 0x00, 0x00 },	// U+265A (♚)
	{ 0x00, 0x15, 0x1f, 0x1f, 0x1f, 0x0e, 0x0e, 0x0e, 0x1f, 0x1f, 0x00, 0x00 },	// U+265B (♛)
	{ 0x00, 0x00, 0x00, 0x15, 0x1f, 0x0e, 0x0e, 0x0e, 0x1f, 0x1f, 0x00, 0x00 },	// U+265C (♜)
	{ 0x00, 0x04, 0x0e, 0x0e, 0x1b, 0x11, 0x0a, 0x0e, 0x1f, 0x1f, 0x00, 0x00 },	// U+265D (♝)
	{ 0x00, 0x08, 0x1c, 0x1a, 0x1f, 0x1f, 0x1c, 0x1c, 0x3e, 0x3e, 0x00, 0x00 },	// U+265E (♞)
	{ 0x00, 0x00, 0x04, 0x0e, 0x04, 0x0e, 0x0e, 0x0e, 0x1f, 0x1f, 0x00, 0x00 },	// U+265F (♟)
	{ 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x1f, 0x1f, 0x04, 0x0e, 0x00, 0x00 },	// U+2660 (♠)
	{ 0x00, 0x00, 0x00, 0x0a, 0x15, 0x15, 0x11, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+2661 (♡)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+2662 (♢)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x15, 0x1f, 0x1f, 0x15, 0x04, 0x0e, 0x00, 0x00 },	// U+2663 (♣)
	{ 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x1f, 0x1f, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+2664 (♤)
	{ 0x00, 0x00, 0x0a, 0x1f, 0x1f, 0x1f, 0x1f, 0x0e, 0x0e, 0x04, 0x00, 0x00 },	// U+2665 (♥)
	{ 0x00, 0x00, 0x04, 0x0e, 0x0e, 0x1f, 0x1f, 0x0e, 0x0e, 0x04, 0x00, 0x00 },	// U+2666 (♦)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x0e, 0x15, 0x0e, 0x04, 0x0e, 0x00, 0x00 },	// U+2667 (♧)
	{ 0x00, 0x00, 0x09, 0x12, 0x09, 0x12, 0x00, 0x0a, 0x11, 0x0e, 0x00, 0x00 },	// U+2668 (♨)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, 0x03, 0x00, 0x00 },	// U+2669 (♩)
	{ 0x00, 0x00, 0x00, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x07, 0x03, 0x00, 0x00 },	// U+266A (♪)
	{ 0x00, 0x00, 0x06, 0x1a, 0x12, 0x12, 0x12, 0x13, 0x1b, 0x18, 0x00, 0x00 },	// U+266B (♫)
	{ 0x00, 0x00, 0x06, 0x1a, 0x16, 0x1a, 0x12, 0x13, 0x1b, 0x18, 0x00, 0x00 },	// U+266C (♬)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x0a, 0x16, 0x12, 0x0a, 0x06, 0x00, 0x00 },	// U+266D (♭)
	{ 0x00, 0x00, 0x02, 0x12, 0x1a, 0x16, 0x12, 0x1a, 0x16, 0x12, 0x10, 0x00 },	// U+266E (♮)
	{ 0x00, 0x00, 0x08, 0x1a, 0x0e, 0x0b, 0x1a, 0x0e, 0x0b, 0x02, 0x00, 0x00 },	// U+266F (♯)
	{ 0x00, 0x00, 0x0a, 0x04, 0x15, 0x0e, 0x15, 0x04, 0x04, 0x0a, 0x00, 0x00 },	// U+2670 (♰)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x1b, 0x15, 0x04, 0x04, 0x0a, 0x04, 0x00 },	// U+2671 (♱)
	{ 0x00, 0x00, 0x08, 0x13, 0x22, 0x31, 0x01, 0x29, 0x1c, 0x08, 0x00, 0x00 },	// U+2672 (♲)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1a, 0x08, 0x29, 0x21, 0x3b, 0x00, 0x00 },	// U+2673 (♳)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1e, 0x08, 0x2d, 0x21, 0x3b, 0x00, 0x00 },	// U+2674 (♴)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1e, 0x0c, 0x2d, 0x21, 0x3b, 0x00, 0x00 },	// U+2675 (♵)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1e, 0x0c, 0x29, 0x21, 0x3b, 0x00, 0x00 },	// U+2676 (♶)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1e, 0x04, 0x2d, 0x21, 0x3b, 0x00, 0x00 },	// U+2677 (♷)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x16, 0x0c, 0x2d, 0x21, 0x3b, 0x00, 0x00 },	// U+2678 (♸)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1e, 0x08, 0x29, 0x21, 0x3b, 0x00, 0x00 },	// U+2679 (♹)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x00, 0x21, 0x21, 0x3b, 0x00, 0x00 },	// U+267A (♺)
	{ 0x00, 0x00, 0x0c, 0x14, 0x33, 0x33, 0x01, 0x29, 0x1d, 0x08, 0x00, 0x00 },	// U+267B (♻)
	{ 0x1e, 0x3f, 0x23, 0x2b, 0x0c, 0x0c, 0x3e, 0x16, 0x22, 0x37, 0x3f, 0x1e },	// U+267C (♼)
	{ 0x1e, 0x21, 0x0c, 0x14, 0x33, 0x33, 0x01, 0x29, 0x1d, 0x08, 0x21, 0x1e },	// U+267D (♽)
	{ 0x00, 0x00, 0x0e, 0x11, 0x00, 0x0a, 0x15, 0x0a, 0x00, 0x11, 0x0e, 0x00 },	// U+267E (♾)
	{ 0x00, 0x00, 0x06, 0x06, 0x02, 0x1e, 0x02, 0x0f, 0x19, 0x26, 0x00, 0x00 },	// U+267F (♿)
	{ 0x00, 0x1f, 0x11, 0x11, 0x11, 0x15, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2680 (⚀)
	{ 0x00, 0x1f, 0x11, 0x13, 0x11, 0x11, 0x11, 0x19, 0x11, 0x1f, 0x00, 0x00 },	// U+2681 (⚁)
	{ 0x00, 0x1f, 0x11, 0x13, 0x11, 0x15, 0x11, 0x19, 0x11, 0x1f, 0x00, 0x00 },	// U+2682 (⚂)
	{ 0x00, 0x1f, 0x11, 0x1b, 0x11, 0x11, 0x11, 0x1b, 0x11, 0x1f, 0x00, 0x00 },	// U+2683 (⚃)
	{ 0x00, 0x1f, 0x11, 0x1b, 0x11, 0x15, 0x11, 0x1b, 0x11, 0x1f, 0x00, 0x00 },	// U+2684 (⚄)
	{ 0x00, 0x1f, 0x11, 0x1b, 0x11, 0x1b, 0x11, 0x1b, 0x11, 0x1f, 0x00, 0x00 },	// U+2685 (⚅)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x19, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2686 (⚆)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1b, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2687 (⚇)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x17, 0x1f, 0x0e, 0x00, 0x00, 0x00 },	// U+2688 (⚈)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x15, 0x1f, 0x0e, 0x00, 0x00, 0x00 },	// U+2689 (⚉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+268A (⚊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00 },	// U+268B (⚋)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+268C (⚌)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+268D (⚍)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+268E (⚎)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+268F (⚏)
	{ 0x00, 0x00, 0x00, 0x07, 0x19, 0x11, 0x13, 0x1d, 0x01, 0x01, 0x00, 0x00 },	// U+2690 (⚐)
	{ 0x00, 0x00, 0x00, 0x07, 0x1f, 0x1f, 0x1f, 0x1d, 0x01, 0x01, 0x00, 0x00 },	// U+2691 (⚑)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x33, 0x2d, 0x0c, 0x12, 0x21, 0x00, 0x00 },	// U+2692 (⚒)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x1f, 0x04, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+2693 (⚓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x1b, 0x11, 0x00, 0x00 },	// U+2694 (⚔)
	{ 0x00, 0x00, 0x04, 0x0e, 0x05, 0x0e, 0x14, 0x0c, 0x06, 0x0c, 0x04, 0x00 },	// U+2695 (⚕)
	{ 0x00, 0x00, 0x00, 0x04, 0x1f, 0x15, 0x11, 0x11, 0x1b, 0x1b, 0x00, 0x00 },	// U+2696 (⚖)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3a, 0x11, 0x00, 0x38, 0x28, 0x00, 0x00 },	// U+2697 (⚗)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x15, 0x1f, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+2698 (⚘)
	{ 0x00, 0x00, 0x00, 0x04, 0x1f, 0x11, 0x15, 0x11, 0x1f, 0x04, 0x00, 0x00 },	// U+2699 (⚙)
	{ 0x00, 0x04, 0x0a, 0x04, 0x15, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+269A (⚚)
	{ 0x00, 0x00, 0x00, 0x15, 0x0e, 0x1b, 0x0e, 0x1b, 0x0e, 0x15, 0x00, 0x00 },	// U+269B (⚛)
	{ 0x00, 0x00, 0x04, 0x0a, 0x1b, 0x11, 0x15, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+269C (⚜)
}; // 132

static const unsigned char orpb_block59[][12] = {
	{ 0x00, 0x04, 0x0a, 0x11, 0x15, 0x15, 0x11, 0x15, 0x11, 0x1f, 0x00, 0x00 },	// U+26A0 (⚠)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x1e, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+26A1 (⚡)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x0e, 0x0a, 0x1f, 0x0a, 0x00 },	// U+26A2 (⚢)
	{ 0x00, 0x00, 0x00, 0x0c, 0x04, 0x36, 0x19, 0x15, 0x12, 0x0c, 0x00, 0x00 },	// U+26A3 (⚣)
	{ 0x00, 0x00, 0x30, 0x30, 0x18, 0x26, 0x25, 0x19, 0x06, 0x02, 0x07, 0x02 },	// U+26A4 (⚤)
	{ 0x00, 0x30, 0x30, 0x08, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x0e, 0x04 },	// U+26A5 (⚥)
	{ 0x00, 0x30, 0x30, 0x18, 0x18, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+26A6 (⚦)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x0c, 0x12, 0x12, 0x0c, 0x04, 0x0e, 0x04 },	// U+26A7 (⚧)
	{ 0x00, 0x04, 0x0e, 0x15, 0x04, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+26A8 (⚨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x3d, 0x12, 0x00, 0x00, 0x00 },	// U+26A9 (⚩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+26AA (⚪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x1f, 0x0e, 0x00, 0x00 },	// U+26AB (⚫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+26AC (⚬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+26AD (⚭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+26AE (⚮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2d, 0x12, 0x00, 0x00, 0x00 },	// U+26AF (⚯)
	{ 0x00, 0x0e, 0x0a, 0x11, 0x11, 0x11, 0x0a, 0x0a, 0x0a, 0x0e, 0x00, 0x00 },	// U+26B0 (⚰)
	{ 0x00, 0x1f, 0x0a, 0x0e, 0x11, 0x11, 0x11, 0x0a, 0x0a, 0x0e, 0x00, 0x00 },	// U+26B1 (⚱)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+26B2 (⚲)
	{ 0x00, 0x00, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x0c, 0x04, 0x0e, 0x04, 0x00 },	// U+26B3 (⚳)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x04, 0x0e, 0x04, 0x00 },	// U+26B4 (⚴)
	{ 0x00, 0x00, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x04, 0x04, 0x0e, 0x04, 0x00 },	// U+26B5 (⚵)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x11, 0x0a, 0x04, 0x00, 0x1b, 0x04, 0x00 },	// U+26B6 (⚶)
	{ 0x00, 0x00, 0x14, 0x0c, 0x04, 0x0c, 0x14, 0x04, 0x0e, 0x11, 0x0e, 0x00 },	// U+26B7 (⚷)
	{ 0x00, 0x00, 0x0e, 0x03, 0x03, 0x03, 0x03, 0x0e, 0x04, 0x0e, 0x04, 0x00 },	// U+26B8 (⚸)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x1f, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+26B9 (⚹)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x1f, 0x00, 0x00 },	// U+26BA (⚺)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+26BB (⚻)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x15, 0x1f, 0x04, 0x0c, 0x00, 0x00 },	// U+26BC (⚼)
}; // 29

static const unsigned char orpb_block60[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+26C0 (⛀)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+26C1 (⛁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x1f, 0x0e, 0x00, 0x00 },	// U+26C2 (⛂)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x0e, 0x11, 0x1f, 0x0e, 0x00, 0x00 },	// U+26C3 (⛃)
}; // 4

static const unsigned char orpb_block61[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x3f, 0x04, 0x02, 0x06, 0x00, 0x00, 0x00 },	// U+2701 (✁)
	{ 0x00, 0x00, 0x00, 0x00, 0x23, 0x13, 0x0c, 0x13, 0x23, 0x00, 0x00, 0x00 },	// U+2702 (✂)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x02, 0x04, 0x3f, 0x09, 0x00, 0x00, 0x00 },	// U+2703 (✃)
	{ 0x00, 0x00, 0x00, 0x33, 0x29, 0x17, 0x0c, 0x17, 0x29, 0x33, 0x00, 0x00 },	// U+2704 (✄)
}; // 4

static const unsigned char orpb_block62[][12] = {
	{ 0x00, 0x00, 0x1e, 0x21, 0x2d, 0x2d, 0x25, 0x2d, 0x2d, 0x21, 0x1e, 0x00 },	// U+2706 (✆)
	{ 0x00, 0x00, 0x1e, 0x21, 0x2d, 0x21, 0x2d, 0x21, 0x33, 0x21, 0x1e, 0x00 },	// U+2707 (✇)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0d, 0x3f, 0x0d, 0x04, 0x00, 0x00, 0x00 },	// U+2708 (✈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x33, 0x2d, 0x21, 0x3f, 0x00, 0x00 },	// U+2709 (✉)
}; // 4

static const unsigned char orpb_block63[][12] = {
	{ 0x00, 0x00, 0x12, 0x12, 0x14, 0x1c, 0x1e, 0x1e, 0x1e, 0x1c, 0x00, 0x00 },	// U+270C (✌)
	{ 0x00, 0x00, 0x00, 0x20, 0x1c, 0x3e, 0x3e, 0x02, 0x01, 0x00, 0x00, 0x00 },	// U+270D (✍)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0a, 0x14, 0x28, 0x30, 0x00, 0x00 },	// U+270E (✎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x31, 0x1f, 0x00, 0x00, 0x00 },	// U+270F (✏)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x28, 0x14, 0x0a, 0x07, 0x02, 0x00, 0x00 },	// U+2710 (✐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x21, 0x21, 0x1f, 0x00, 0x00, 0x00 },	// U+2711 (✑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x2f, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2712 (✒)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x08, 0x05, 0x07, 0x02, 0x00, 0x00 },	// U+2713 (✓)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x38, 0x1b, 0x1f, 0x0e, 0x0c, 0x00, 0x00 },	// U+2714 (✔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+2715 (✕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1f, 0x04, 0x1f, 0x1b, 0x00, 0x00, 0x00 },	// U+2716 (✖)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x01, 0x00, 0x00 },	// U+2717 (✗)
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x1e, 0x0e, 0x3f, 0x33, 0x03, 0x00 },	// U+2718 (✘)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x33, 0x25, 0x2f, 0x25, 0x33, 0x1e, 0x00 },	// U+2719 (✙)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x3f, 0x3f, 0x0c, 0x0c, 0x00, 0x00 },	// U+271A (✚)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1b, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+271B (✛)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x33, 0x33, 0x0c, 0x0c, 0x00, 0x00 },	// U+271C (✜)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+271D (✝)
	{ 0x00, 0x0e, 0x0a, 0x1b, 0x11, 0x1b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0e, 0x00 },	// U+271E (✞)
	{ 0x00, 0x1e, 0x3b, 0x3d, 0x3b, 0x1a, 0x1a, 0x1a, 0x1e, 0x1e, 0x00, 0x00 },	// U+271F (✟)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x15, 0x1f, 0x15, 0x04, 0x0e, 0x00, 0x00 },	// U+2720 (✠)
	{ 0x00, 0x00, 0x00, 0x04, 0x1f, 0x0a, 0x0a, 0x0a, 0x1f, 0x04, 0x00, 0x00 },	// U+2721 (✡)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2722 (✢)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x3f, 0x3f, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+2723 (✣)
	{ 0x00, 0x00, 0x0c, 0x1e, 0x0c, 0x3f, 0x3f, 0x0c, 0x1e, 0x0c, 0x00, 0x00 },	// U+2724 (✤)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x1f, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+2725 (✥)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2726 (✦)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1b, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2727 (✧)
}; // 28

static const unsigned char orpb_block64[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1b, 0x0a, 0x04, 0x0a, 0x00, 0x00, 0x00 },	// U+2729 (✩)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x11, 0x1b, 0x15, 0x1f, 0x0e, 0x00, 0x00 },	// U+272A (✪)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0a, 0x0e, 0x11, 0x00, 0x00, 0x00 },	// U+272B (✫)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1b, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+272C (✬)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0e, 0x0e, 0x11, 0x00, 0x00, 0x00 },	// U+272D (✭)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x0e, 0x0e, 0x11, 0x00, 0x00, 0x00 },	// U+272E (✮)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x17, 0x0c, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+272F (✯)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1a, 0x31, 0x1a, 0x35, 0x1a, 0x00, 0x00 },	// U+2730 (✰)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2731 (✱)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0a, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2732 (✲)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2733 (✳)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2734 (✴)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2735 (✵)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2736 (✶)
	{ 0x00, 0x00, 0x00, 0x0a, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x0a, 0x00 },	// U+2737 (✷)
	{ 0x00, 0x00, 0x00, 0x0a, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x0a, 0x00 },	// U+2738 (✸)
	{ 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x3e, 0x1f, 0x3e, 0x1f, 0x0a, 0x00, 0x00 },	// U+2739 (✹)
	{ 0x00, 0x00, 0x00, 0x0a, 0x15, 0x2e, 0x1f, 0x2e, 0x15, 0x0a, 0x00, 0x00 },	// U+273A (✺)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+273B (✻)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0a, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+273C (✼)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+273D (✽)
	{ 0x00, 0x00, 0x00, 0x15, 0x1b, 0x0a, 0x15, 0x2e, 0x15, 0x04, 0x00, 0x00 },	// U+273E (✾)
	{ 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x1b, 0x0e, 0x1f, 0x1b, 0x00, 0x00, 0x00 },	// U+273F (✿)
	{ 0x00, 0x00, 0x04, 0x0e, 0x1b, 0x15, 0x0a, 0x1f, 0x1b, 0x00, 0x00, 0x00 },	// U+2740 (❀)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1b, 0x0e, 0x1f, 0x04, 0x00, 0x00, 0x00 },	// U+2741 (❁)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x15, 0x1b, 0x15, 0x1f, 0x0e, 0x00, 0x00 },	// U+2742 (❂)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2743 (❃)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2744 (❄)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2745 (❅)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2746 (❆)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2747 (❇)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2748 (❈)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+2749 (❉)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+274A (❊)
	{ 0x00, 0x00, 0x00, 0x04, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x04, 0x00, 0x00 },	// U+274B (❋)
}; // 35

static const unsigned char orpb_block65[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x31, 0x31, 0x31, 0x1e, 0x00, 0x00, 0x00 },	// U+274D (❍)
}; // 1

static const unsigned char orpb_block66[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x31, 0x31, 0x31, 0x3f, 0x3e, 0x00, 0x00 },	// U+274F (❏)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3f, 0x31, 0x31, 0x31, 0x1f, 0x00, 0x00 },	// U+2750 (❐)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x31, 0x31, 0x31, 0x3f, 0x3e, 0x00, 0x00 },	// U+2751 (❑)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3f, 0x31, 0x31, 0x31, 0x1f, 0x00, 0x00 },	// U+2752 (❒)
}; // 4

static const unsigned char orpb_block67[][12] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x37, 0x2a, 0x1c, 0x08, 0x00, 0x00 },	// U+2756 (❖)
}; // 1

static const unsigned char orpb_block68[][12] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2758 (❘)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00 },	// U+2759 (❙)
	{ 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x00, 0x00 },	// U+275A (❚)
	{ 0x00, 0x0c, 0x02, 0x0e, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+275B (❛)
	{ 0x00, 0x0c, 0x1e, 0x1c, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+275C (❜)
	{ 0x00, 0x12, 0x09, 0x1b, 0x3f, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+275D (❝)
	{ 0x00, 0x12, 0x3f, 0x36, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+275E (❞)
}; // 7

static const unsigned char orpb_block69[][12] = {
	{ 0x00, 0x10, 0x3e, 0x13, 0x13, 0x13, 0x1e, 0x10, 0x13, 0x11, 0x0e, 0x00 },	// U+2761 (❡)
	{ 0x00, 0x0e, 0x1f, 0x1f, 0x0e, 0x04, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+2762 (❢)
	{ 0x00, 0x00, 0x1b, 0x1f, 0x0e, 0x04, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+2763 (❣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1f, 0x1f, 0x0e, 0x04, 0x00, 0x00 },	// U+2764 (❤)
	{ 0x00, 0x00, 0x00, 0x06, 0x0f, 0x0f, 0x1e, 0x0f, 0x0f, 0x06, 0x00, 0x00 },	// U+2765 (❥)
	{ 0x00, 0x00, 0x26, 0x1d, 0x04, 0x1b, 0x1f, 0x0f, 0x27, 0x1e, 0x00, 0x00 },	// U+2766 (❦)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x1a, 0x1e, 0x3b, 0x19, 0x02, 0x00, 0x00 },	// U+2767 (❧)
	{ 0x00, 0x00, 0x08, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x08, 0x00, 0x00 },	// U+2768 (❨)
	{ 0x00, 0x00, 0x02, 0x04, 0x0c, 0x0c, 0x0c, 0x0c, 0x04, 0x02, 0x00, 0x00 },	// U+2769 (❩)
	{ 0x00, 0x00, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x00, 0x00 },	// U+276A (❪)
	{ 0x00, 0x00, 0x02, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x02, 0x00, 0x00 },	// U+276B (❫)
	{ 0x00, 0x00, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x00 },	// U+276C (❬)
	{ 0x00, 0x00, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x00 },	// U+276D (❭)
	{ 0x00, 0x00, 0x00, 0x18, 0x0c, 0x06, 0x03, 0x06, 0x0c, 0x18, 0x00, 0x00 },	// U+276E (❮)
	{ 0x00, 0x00, 0x00, 0x03, 0x06, 0x0c, 0x18, 0x0c, 0x06, 0x03, 0x00, 0x00 },	// U+276F (❯)
	{ 0x00, 0x00, 0x1c, 0x1c, 0x0e, 0x0e, 0x07, 0x0e, 0x0e, 0x1c, 0x1c, 0x00 },	// U+2770 (❰)
	{ 0x00, 0x00, 0x07, 0x07, 0x0e, 0x0e, 0x1c, 0x0e, 0x0e, 0x07, 0x07, 0x00 },	// U+2771 (❱)
	{ 0x00, 0x00, 0x08, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x08, 0x00 },	// U+2772 (❲)
	{ 0x00, 0x00, 0x02, 0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x02, 0x00 },	// U+2773 (❳)
	{ 0x00, 0x00, 0x18, 0x0c, 0x0c, 0x0c, 0x06, 0x0c, 0x0c, 0x0c, 0x18, 0x00 },	// U+2774 (❴)
	{ 0x00, 0x00, 0x06, 0x0c, 0x0c, 0x0c, 0x18, 0x0c, 0x0c, 0x0c, 0x06, 0x00 },	// U+2775 (❵)
	{ 0x00, 0x0e, 0x1f, 0x1b, 0x19, 0x1b, 0x1b, 0x11, 0x1f, 0x0e, 0x00, 0x00 },	// U+2776 (❶)
	{ 0x00, 0x0e, 0x1f, 0x1b, 0x15, 0x17, 0x1b, 0x11, 0x1f, 0x0e, 0x00, 0x00 },	// U+2777 (❷)
	{ 0x00, 0x0e, 0x1f, 0x19, 0x17, 0x1b, 0x17, 0x19, 0x1f, 0x0e, 0x00, 0x00 },	// U+2778 (❸)
	{ 0x00, 0x0e, 0x1f, 0x1d, 0x1d, 0x19, 0x11, 0x1b, 0x1f, 0x0e, 0x00, 0x00 },	// U+2779 (❹)
	{ 0x00, 0x0e, 0x1f, 0x11, 0x1d, 0x19, 0x17, 0x19, 0x1f, 0x0e, 0x00, 0x00 },	// U+277A (❺)
	{ 0x00, 0x0e, 0x1f, 0x13, 0x1d, 0x19, 0x15, 0x1b, 0x1f, 0x0e, 0x00, 0x00 },	// U+277B (❻)
	{ 0x00, 0x0e, 0x1f, 0x11, 0x17, 0x1b, 0x1b, 0x1b, 0x1f, 0x0e, 0x00, 0x00 },	// U+277C (❼)
	{ 0x00, 0x0e, 0x1f, 0x1b, 0x15, 0x1b, 0x15, 0x1b, 0x1f, 0x0e, 0x00, 0x00 },	// U+277D (❽)
	{ 0x00, 0x0e, 0x1f, 0x1b, 0x15, 0x13, 0x17, 0x19, 0x1f, 0x0e, 0x00, 0x00 },	// U+277E (❾)
	{ 0x00, 0x1e, 0x3f, 0x35, 0x29, 0x29, 0x29, 0x35, 0x3f, 0x1e, 0x00, 0x00 },	// U+277F (❿)
	{ 0x00, 0x0e, 0x11, 0x15, 0x17, 0x15, 0x15, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+2780 (➀)
	{ 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x19, 0x15, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+2781 (➁)
	{ 0x00, 0x0e, 0x11, 0x17, 0x19, 0x15, 0x19, 0x17, 0x11, 0x0e, 0x00, 0x00 },	// U+2782 (➂)
	{ 0x00, 0x0e, 0x11, 0x13, 0x13, 0x17, 0x1f, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2783 (➃)
	{ 0x00, 0x0e, 0x11, 0x1f, 0x13, 0x17, 0x19, 0x17, 0x11, 0x0e, 0x00, 0x00 },	// U+2784 (➄)
	{ 0x00, 0x0e, 0x11, 0x1d, 0x13, 0x17, 0x1b, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2785 (➅)
	{ 0x00, 0x0e, 0x11, 0x1f, 0x19, 0x15, 0x15, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2786 (➆)
	{ 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x15, 0x1b, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2787 (➇)
	{ 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x1d, 0x19, 0x17, 0x11, 0x0e, 0x00, 0x00 },	// U+2788 (➈)
	{ 0x00, 0x1e, 0x21, 0x2b, 0x37, 0x37, 0x37, 0x2b, 0x21, 0x1e, 0x00, 0x00 },	// U+2789 (➉)
	{ 0x00, 0x0e, 0x1f, 0x1b, 0x19, 0x1b, 0x1b, 0x1b, 0x1f, 0x0e, 0x00, 0x00 },	// U+278A (➊)
	{ 0x00, 0x0e, 0x1f, 0x1b, 0x15, 0x17, 0x1b, 0x11, 0x1f, 0x0e, 0x00, 0x00 },	// U+278B (➋)
	{ 0x00, 0x0e, 0x1f, 0x19, 0x17, 0x1b, 0x17, 0x19, 0x1f, 0x0e, 0x00, 0x00 },	// U+278C (➌)
	{ 0x00, 0x0e, 0x1f, 0x1d, 0x1d, 0x19, 0x11, 0x1b, 0x1f, 0x0e, 0x00, 0x00 },	// U+278D (➍)
	{ 0x00, 0x0e, 0x1f, 0x11, 0x1d, 0x19, 0x17, 0x19, 0x1f, 0x0e, 0x00, 0x00 },	// U+278E (➎)
	{ 0x00, 0x0e, 0x1f, 0x13, 0x1d, 0x19, 0x15, 0x1b, 0x1f, 0x0e, 0x00, 0x00 },	// U+278F (➏)
	{ 0x00, 0x0e, 0x1f, 0x11, 0x17, 0x1b, 0x1b, 0x1b, 0x1f, 0x0e, 0x00, 0x00 },	// U+2790 (➐)
	{ 0x00, 0x0e, 0x1f, 0x1b, 0x15, 0x1b, 0x15, 0x1b, 0x1f, 0x0e, 0x00, 0x00 },	// U+2791 (➑)
	{ 0x00, 0x0e, 0x1f, 0x1b, 0x15, 0x13, 0x17, 0x19, 0x1f, 0x0e, 0x00, 0x00 },	// U+2792 (➒)
	{ 0x00, 0x1e, 0x3f, 0x35, 0x29, 0x29, 0x29, 0x35, 0x3f, 0x1e, 0x00, 0x00 },	// U+2793 (➓)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x3f, 0x18, 0x0c, 0x00, 0x00, 0x00 },	// U+2794 (➔)
}; // 52

static const unsigned char orpb_block70[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x14, 0x18, 0x1c, 0x00, 0x00 },	// U+2798 (➘)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x1f, 0x0c, 0x04, 0x00, 0x00, 0x00 },	// U+2799 (➙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x14, 0x02, 0x01, 0x00, 0x00 },	// U+279A (➚)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x3f, 0x0c, 0x02, 0x00, 0x00, 0x00 },	// U+279B (➛)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1c, 0x3f, 0x3f, 0x1c, 0x0c, 0x00, 0x00 },	// U+279C (➜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3f, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+279D (➝)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x3f, 0x3f, 0x18, 0x08, 0x00, 0x00 },	// U+279E (➞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3d, 0x10, 0x00, 0x00, 0x00 },	// U+279F (➟)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x3d, 0x3d, 0x18, 0x08, 0x00, 0x00 },	// U+27A0 (➠)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x3f, 0x1f, 0x08, 0x00, 0x00, 0x00 },	// U+27A1 (➡)
	{ 0x00, 0x00, 0x00, 0x03, 0x0d, 0x12, 0x3c, 0x1e, 0x0f, 0x03, 0x00, 0x00 },	// U+27A2 (➢)
	{ 0x00, 0x00, 0x00, 0x03, 0x0f, 0x1e, 0x3c, 0x12, 0x0d, 0x03, 0x00, 0x00 },	// U+27A3 (➣)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x1e, 0x3c, 0x1e, 0x07, 0x00, 0x00, 0x00 },	// U+27A4 (➤)
	{ 0x00, 0x00, 0x00, 0x01, 0x09, 0x1f, 0x3f, 0x1e, 0x08, 0x00, 0x00, 0x00 },	// U+27A5 (➥)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1e, 0x3f, 0x1f, 0x09, 0x01, 0x00, 0x00 },	// U+27A6 (➦)
	{ 0x00, 0x00, 0x00, 0x04, 0x0f, 0x1f, 0x3f, 0x1f, 0x0f, 0x04, 0x00, 0x00 },	// U+27A7 (➧)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0f, 0x3f, 0x0f, 0x04, 0x00, 0x00, 0x00 },	// U+27A8 (➨)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x17, 0x21, 0x17, 0x08, 0x00, 0x00, 0x00 },	// U+27A9 (➩)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x17, 0x21, 0x17, 0x08, 0x00, 0x00, 0x00 },	// U+27AA (➪)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x17, 0x21, 0x17, 0x08, 0x00, 0x00, 0x00 },	// U+27AB (➫)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x17, 0x21, 0x17, 0x08, 0x00, 0x00, 0x00 },	// U+27AC (➬)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x17, 0x21, 0x21, 0x17, 0x08, 0x00, 0x00 },	// U+27AD (➭)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x17, 0x21, 0x21, 0x17, 0x08, 0x00, 0x00 },	// U+27AE (➮)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x17, 0x21, 0x17, 0x08, 0x00, 0x00, 0x00 },	// U+27AF (➯)
}; // 24

static const unsigned char orpb_block71[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x17, 0x21, 0x17, 0x08, 0x00, 0x00, 0x00 },	// U+27B1 (➱)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3b, 0x30, 0x20, 0x30, 0x3b, 0x1e, 0x00, 0x00 },	// U+27B2 (➲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x3e, 0x17, 0x00, 0x00, 0x00 },	// U+27B3 (➳)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x06, 0x08, 0x30, 0x30, 0x00, 0x00 },	// U+27B4 (➴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x3e, 0x17, 0x00, 0x00, 0x00 },	// U+27B5 (➵)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x08, 0x06, 0x07, 0x02, 0x00, 0x00 },	// U+27B6 (➶)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x07, 0x07, 0x28, 0x30, 0x38, 0x00, 0x00 },	// U+27B7 (➷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x17, 0x3e, 0x17, 0x03, 0x00, 0x00 },	// U+27B8 (➸)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x30, 0x28, 0x07, 0x07, 0x06, 0x00, 0x00 },	// U+27B9 (➹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x13, 0x3f, 0x13, 0x08, 0x00, 0x00 },	// U+27BA (➺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x13, 0x3f, 0x13, 0x08, 0x00, 0x00 },	// U+27BB (➻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x3e, 0x17, 0x00, 0x00, 0x00 },	// U+27BC (➼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x3f, 0x3f, 0x17, 0x00, 0x00, 0x00 },	// U+27BD (➽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x17, 0x20, 0x17, 0x0a, 0x00, 0x00 },	// U+27BE (➾)
}; // 14

static const unsigned char orpb_block72[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x1f, 0x00, 0x00 },	// U+27C0 (⟀)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0e, 0x15, 0x1f, 0x00, 0x00 },	// U+27C1 (⟁)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00 },	// U+27C2 (⟂)
	{ 0x00, 0x00, 0x00, 0x1e, 0x01, 0x09, 0x15, 0x09, 0x01, 0x1e, 0x00, 0x00 },	// U+27C3 (⟃)
	{ 0x00, 0x00, 0x00, 0x0f, 0x10, 0x12, 0x15, 0x12, 0x10, 0x0f, 0x00, 0x00 },	// U+27C4 (⟄)
	{ 0x00, 0x04, 0x0a, 0x0a, 0x08, 0x08, 0x04, 0x04, 0x04, 0x18, 0x00, 0x00 },	// U+27C5 (⟅)
	{ 0x00, 0x08, 0x14, 0x14, 0x04, 0x04, 0x08, 0x08, 0x08, 0x06, 0x00, 0x00 },	// U+27C6 (⟆)
	{ 0x00, 0x00, 0x00, 0x11, 0x15, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+27C7 (⟇)
	{ 0x00, 0x00, 0x01, 0x39, 0x05, 0x05, 0x05, 0x3a, 0x02, 0x02, 0x00, 0x00 },	// U+27C8 (⟈)
	{ 0x00, 0x00, 0x20, 0x27, 0x28, 0x28, 0x28, 0x17, 0x10, 0x10, 0x00, 0x00 },	// U+27C9 (⟉)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+27CA (⟊)
}; // 11

static const unsigned char orpb_block73[][12] = {
	{ 0x00, 0x00, 0x00, 0x3f, 0x02, 0x04, 0x04, 0x04, 0x04, 0x02, 0x00, 0x00 },	// U+27CC (⟌)
}; // 1

static const unsigned char orpb_block74[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x15, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+27D0 (⟐)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x15, 0x11, 0x00, 0x00 },	// U+27D1 (⟑)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+27D2 (⟒)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x10, 0x1f, 0x00, 0x00, 0x00 },	// U+27D3 (⟓)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x01, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+27D4 (⟔)
	{ 0x00, 0x00, 0x00, 0x00, 0x23, 0x36, 0x2a, 0x36, 0x23, 0x00, 0x00, 0x00 },	// U+27D5 (⟕)
	{ 0x00, 0x00, 0x00, 0x00, 0x31, 0x1b, 0x15, 0x1b, 0x31, 0x00, 0x00, 0x00 },	// U+27D6 (⟖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x1e, 0x12, 0x1e, 0x33, 0x00, 0x00 },	// U+27D7 (⟗)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00 },	// U+27D8 (⟘)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+27D9 (⟙)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1b, 0x0a, 0x1b, 0x0a, 0x00, 0x00, 0x00 },	// U+27DA (⟚)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x1b, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+27DB (⟛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3d, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+27DC (⟜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3f, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+27DD (⟝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+27DE (⟞)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+27DF (⟟)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1f, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+27E0 (⟠)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+27E1 (⟡)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x23, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+27E2 (⟢)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x31, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+27E3 (⟣)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x23, 0x22, 0x3e, 0x00, 0x00, 0x00 },	// U+27E4 (⟤)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x31, 0x11, 0x1f, 0x00, 0x00, 0x00 },	// U+27E5 (⟥)
	{ 0x00, 0x1f, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1f, 0x00 },	// U+27E6 (⟦)
	{ 0x00, 0x1f, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1f, 0x00 },	// U+27E7 (⟧)
	{ 0x00, 0x00, 0x08, 0x08, 0x04, 0x04, 0x02, 0x04, 0x04, 0x08, 0x08, 0x00 },	// U+27E8 (⟨)
	{ 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00 },	// U+27E9 (⟩)
	{ 0x00, 0x28, 0x14, 0x14, 0x0a, 0x0a, 0x05, 0x0a, 0x0a, 0x14, 0x14, 0x28 },	// U+27EA (⟪)
	{ 0x00, 0x05, 0x0a, 0x0a, 0x14, 0x14, 0x28, 0x14, 0x14, 0x0a, 0x0a, 0x05 },	// U+27EB (⟫)
	{ 0x00, 0x10, 0x08, 0x0c, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0c, 0x08, 0x10 },	// U+27EC (⟬)
	{ 0x02, 0x04, 0x0c, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0c, 0x04, 0x02 },	// U+27ED (⟭)
	{ 0x00, 0x00, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x00 },	// U+27EE (⟮)
	{ 0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x00 },	// U+27EF (⟯)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+27F0 (⟰)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+27F1 (⟱)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x27, 0x22, 0x20, 0x22, 0x1c, 0x00, 0x00 },	// U+27F2 (⟲)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x39, 0x11, 0x01, 0x11, 0x0e, 0x00, 0x00 },	// U+27F3 (⟳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x3f, 0x16, 0x00, 0x00, 0x00, 0x00 },	// U+27F4 (⟴)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x3f, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+27F5 (⟵)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3f, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+27F6 (⟶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x3f, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+27F7 (⟷)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x3e, 0x01, 0x3e, 0x04, 0x08, 0x00, 0x00 },	// U+27F8 (⟸)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x1f, 0x20, 0x1f, 0x08, 0x04, 0x00, 0x00 },	// U+27F9 (⟹)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x3f, 0x21, 0x3f, 0x12, 0x00, 0x00, 0x00 },	// U+27FA (⟺)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x22, 0x3f, 0x22, 0x24, 0x00, 0x00, 0x00 },	// U+27FB (⟻)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x11, 0x3f, 0x11, 0x09, 0x00, 0x00, 0x00 },	// U+27FC (⟼)
	{ 0x00, 0x00, 0x00, 0x28, 0x24, 0x3e, 0x21, 0x3e, 0x24, 0x28, 0x00, 0x00 },	// U+27FD (⟽)
	{ 0x00, 0x00, 0x00, 0x05, 0x09, 0x1f, 0x21, 0x1f, 0x09, 0x05, 0x00, 0x00 },	// U+27FE (⟾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3a, 0x35, 0x10, 0x00, 0x00, 0x00 },	// U+27FF (⟿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2800 (⠀)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2801 (⠁)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2802 (⠂)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2803 (⠃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+2804 (⠄)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+2805 (⠅)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+2806 (⠆)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+2807 (⠇)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2808 (⠈)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2809 (⠉)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280A (⠊)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280B (⠋)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+280C (⠌)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+280D (⠍)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+280E (⠎)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+280F (⠏)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2810 (⠐)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2811 (⠑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2812 (⠒)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2813 (⠓)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+2814 (⠔)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+2815 (⠕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+2816 (⠖)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+2817 (⠗)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2818 (⠘)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2819 (⠙)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281A (⠚)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281B (⠛)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+281C (⠜)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+281D (⠝)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+281E (⠞)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+281F (⠟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2820 (⠠)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2821 (⠡)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2822 (⠢)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2823 (⠣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2824 (⠤)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2825 (⠥)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2826 (⠦)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2827 (⠧)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2828 (⠨)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2829 (⠩)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+282A (⠪)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+282B (⠫)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+282C (⠬)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+282D (⠭)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+282E (⠮)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+282F (⠯)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2830 (⠰)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2831 (⠱)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2832 (⠲)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2833 (⠳)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2834 (⠴)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2835 (⠵)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2836 (⠶)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+2837 (⠷)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2838 (⠸)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+2839 (⠹)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+283A (⠺)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+283B (⠻)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+283C (⠼)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+283D (⠽)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+283E (⠾)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00 },	// U+283F (⠿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2840 (⡀)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2841 (⡁)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2842 (⡂)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2843 (⡃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+2844 (⡄)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+2845 (⡅)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+2846 (⡆)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+2847 (⡇)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2848 (⡈)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2849 (⡉)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+284A (⡊)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+284B (⡋)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+284C (⡌)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+284D (⡍)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+284E (⡎)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+284F (⡏)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2850 (⡐)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2851 (⡑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2852 (⡒)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2853 (⡓)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+2854 (⡔)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+2855 (⡕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+2856 (⡖)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+2857 (⡗)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2858 (⡘)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+2859 (⡙)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+285A (⡚)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03 },	// U+285B (⡛)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+285C (⡜)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+285D (⡝)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+285E (⡞)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03 },	// U+285F (⡟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2860 (⡠)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2861 (⡡)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2862 (⡢)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2863 (⡣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+2864 (⡤)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+2865 (⡥)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+2866 (⡦)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+2867 (⡧)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2868 (⡨)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2869 (⡩)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+286A (⡪)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+286B (⡫)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+286C (⡬)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+286D (⡭)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+286E (⡮)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+286F (⡯)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2870 (⡰)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2871 (⡱)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2872 (⡲)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2873 (⡳)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+2874 (⡴)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+2875 (⡵)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+2876 (⡶)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+2877 (⡷)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2878 (⡸)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+2879 (⡹)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+287A (⡺)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03 },	// U+287B (⡻)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+287C (⡼)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+287D (⡽)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+287E (⡾)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03 },	// U+287F (⡿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2880 (⢀)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2881 (⢁)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2882 (⢂)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2883 (⢃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+2884 (⢄)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+2885 (⢅)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+2886 (⢆)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+2887 (⢇)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2888 (⢈)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2889 (⢉)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+288A (⢊)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+288B (⢋)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+288C (⢌)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+288D (⢍)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+288E (⢎)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+288F (⢏)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2890 (⢐)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2891 (⢑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2892 (⢒)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2893 (⢓)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+2894 (⢔)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+2895 (⢕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+2896 (⢖)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+2897 (⢗)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2898 (⢘)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+2899 (⢙)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+289A (⢚)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18 },	// U+289B (⢛)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+289C (⢜)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+289D (⢝)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+289E (⢞)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18 },	// U+289F (⢟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28A0 (⢠)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28A1 (⢡)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28A2 (⢢)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28A3 (⢣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28A4 (⢤)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28A5 (⢥)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28A6 (⢦)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28A7 (⢧)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28A8 (⢨)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28A9 (⢩)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28AA (⢪)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28AB (⢫)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28AC (⢬)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28AD (⢭)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28AE (⢮)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28AF (⢯)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28B0 (⢰)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28B1 (⢱)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28B2 (⢲)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28B3 (⢳)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28B4 (⢴)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28B5 (⢵)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28B6 (⢶)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28B7 (⢷)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28B8 (⢸)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28B9 (⢹)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28BA (⢺)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+28BB (⢻)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28BC (⢼)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28BD (⢽)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28BE (⢾)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18 },	// U+28BF (⢿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28C0 (⣀)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28C1 (⣁)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28C2 (⣂)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28C3 (⣃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28C4 (⣄)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28C5 (⣅)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28C6 (⣆)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28C7 (⣇)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28C8 (⣈)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28C9 (⣉)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28CA (⣊)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28CB (⣋)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28CC (⣌)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28CD (⣍)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28CE (⣎)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28CF (⣏)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28D0 (⣐)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28D1 (⣑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28D2 (⣒)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28D3 (⣓)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28D4 (⣔)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28D5 (⣕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28D6 (⣖)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28D7 (⣗)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28D8 (⣘)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28D9 (⣙)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28DA (⣚)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b },	// U+28DB (⣛)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28DC (⣜)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28DD (⣝)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28DE (⣞)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b },	// U+28DF (⣟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28E0 (⣠)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28E1 (⣡)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28E2 (⣢)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28E3 (⣣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28E4 (⣤)
	{ 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28E5 (⣥)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28E6 (⣦)
	{ 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28E7 (⣧)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28E8 (⣨)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28E9 (⣩)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28EA (⣪)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28EB (⣫)
	{ 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28EC (⣬)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28ED (⣭)
	{ 0x00, 0x18, 0x18, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28EE (⣮)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28EF (⣯)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28F0 (⣰)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28F1 (⣱)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28F2 (⣲)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28F3 (⣳)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28F4 (⣴)
	{ 0x00, 0x03, 0x03, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28F5 (⣵)
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28F6 (⣶)
	{ 0x00, 0x03, 0x03, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28F7 (⣷)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28F8 (⣸)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28F9 (⣹)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28FA (⣺)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b },	// U+28FB (⣻)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28FC (⣼)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28FD (⣽)
	{ 0x00, 0x18, 0x18, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28FE (⣾)
	{ 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b, 0x00, 0x1b, 0x1b },	// U+28FF (⣿)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x1a, 0x3f, 0x1a, 0x02, 0x00, 0x00, 0x00 },	// U+2900 (⤀)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x16, 0x3f, 0x16, 0x06, 0x00, 0x00, 0x00 },	// U+2901 (⤁)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x3e, 0x11, 0x3e, 0x14, 0x00, 0x00, 0x00 },	// U+2902 (⤂)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x22, 0x1f, 0x0a, 0x00, 0x00, 0x00 },	// U+2903 (⤃)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1e, 0x25, 0x1e, 0x04, 0x00, 0x00, 0x00 },	// U+2904 (⤄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x3f, 0x19, 0x00, 0x00, 0x00, 0x00 },	// U+2905 (⤅)
	{ 0x00, 0x00, 0x00, 0x28, 0x24, 0x3e, 0x21, 0x3e, 0x24, 0x28, 0x00, 0x00 },	// U+2906 (⤆)
	{ 0x00, 0x00, 0x00, 0x05, 0x09, 0x1f, 0x21, 0x1f, 0x09, 0x05, 0x00, 0x00 },	// U+2907 (⤇)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+2908 (⤈)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+2909 (⤉)
	{ 0x00, 0x00, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+290A (⤊)
	{ 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+290B (⤋)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x37, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+290C (⤌)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3b, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+290D (⤍)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x2b, 0x02, 0x04, 0x00, 0x00, 0x00 },	// U+290E (⤎)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x35, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+290F (⤏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x36, 0x19, 0x00, 0x00, 0x00 },	// U+2910 (⤐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x15, 0x08, 0x04, 0x00, 0x00 },	// U+2911 (⤑)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2912 (⤒)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x1f, 0x00, 0x00 },	// U+2913 (⤓)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x3e, 0x15, 0x04, 0x00, 0x00, 0x00 },	// U+2914 (⤔)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1d, 0x3e, 0x1d, 0x0c, 0x00, 0x00, 0x00 },	// U+2915 (⤕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x3e, 0x19, 0x00, 0x00, 0x00, 0x00 },	// U+2916 (⤖)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1d, 0x3e, 0x1d, 0x04, 0x00, 0x00, 0x00 },	// U+2917 (⤗)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x1f, 0x3e, 0x1f, 0x06, 0x00, 0x00, 0x00 },	// U+2918 (⤘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x07, 0x08, 0x10, 0x00, 0x00 },	// U+2919 (⤙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x3c, 0x02, 0x01, 0x00, 0x00 },	// U+291A (⤚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x0a, 0x0f, 0x0a, 0x14, 0x00, 0x00 },	// U+291B (⤛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x3c, 0x0a, 0x05, 0x00, 0x00 },	// U+291C (⤜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3d, 0x08, 0x00, 0x00, 0x00 },	// U+291D (⤝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x2f, 0x04, 0x00, 0x00, 0x00 },	// U+291E (⤞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x3d, 0x28, 0x00, 0x00, 0x00 },	// U+291F (⤟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x2f, 0x05, 0x00, 0x00, 0x00 },	// U+2920 (⤠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x15, 0x18, 0x1c, 0x00, 0x00 },	// U+2921 (⤡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x15, 0x03, 0x07, 0x00, 0x00 },	// U+2922 (⤢)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x05, 0x08, 0x10, 0x18, 0x00, 0x00 },	// U+2923 (⤣)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x14, 0x02, 0x01, 0x03, 0x00, 0x00 },	// U+2924 (⤤)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x01, 0x02, 0x14, 0x18, 0x1c, 0x00, 0x00 },	// U+2925 (⤥)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x08, 0x05, 0x03, 0x07, 0x00, 0x00 },	// U+2926 (⤦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+2927 (⤧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x04, 0x1a, 0x19, 0x00, 0x00 },	// U+2928 (⤨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x1b, 0x1b, 0x00, 0x00 },	// U+2929 (⤩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x0b, 0x04, 0x0b, 0x13, 0x00, 0x00 },	// U+292A (⤪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+292B (⤫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+292C (⤬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x04, 0x1a, 0x19, 0x00, 0x00 },	// U+292D (⤭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x04, 0x1a, 0x19, 0x00, 0x00 },	// U+292E (⤮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+292F (⤯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x1a, 0x19, 0x00, 0x00 },	// U+2930 (⤰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+2931 (⤱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+2932 (⤲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x3d, 0x10, 0x00, 0x00, 0x00 },	// U+2933 (⤳)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+2934 (⤴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+2935 (⤵)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x12, 0x0f, 0x02, 0x04, 0x00, 0x00 },	// U+2936 (⤶)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x05, 0x09, 0x1e, 0x08, 0x04, 0x00, 0x00 },	// U+2937 (⤷)
	{ 0x00, 0x00, 0x04, 0x08, 0x10, 0x10, 0x10, 0x0a, 0x06, 0x0e, 0x00, 0x00 },	// U+2938 (⤸)
	{ 0x00, 0x00, 0x08, 0x04, 0x02, 0x02, 0x02, 0x14, 0x18, 0x1c, 0x00, 0x00 },	// U+2939 (⤹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x13, 0x07, 0x00, 0x00, 0x00, 0x00 },	// U+293A (⤺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x19, 0x16, 0x00, 0x00, 0x00, 0x00 },	// U+293B (⤻)
	{ 0x00, 0x00, 0x00, 0x16, 0x19, 0x1c, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+293C (⤼)
	{ 0x00, 0x0d, 0x13, 0x07, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+293D (⤽)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x17, 0x13, 0x0d, 0x00, 0x00, 0x00 },	// U+293E (⤾)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x1d, 0x19, 0x16, 0x00, 0x00, 0x00 },	// U+293F (⤿)
	{ 0x00, 0x00, 0x08, 0x04, 0x1e, 0x25, 0x29, 0x21, 0x21, 0x1e, 0x00, 0x00 },	// U+2940 (⥀)
	{ 0x00, 0x00, 0x04, 0x08, 0x1e, 0x29, 0x25, 0x21, 0x21, 0x1e, 0x00, 0x00 },	// U+2941 (⥁)
	{ 0x00, 0x08, 0x10, 0x3f, 0x10, 0x08, 0x00, 0x02, 0x0f, 0x02, 0x00, 0x00 },	// U+2942 (⥂)
	{ 0x00, 0x00, 0x04, 0x02, 0x3f, 0x02, 0x04, 0x10, 0x3c, 0x10, 0x00, 0x00 },	// U+2943 (⥃)
	{ 0x00, 0x00, 0x10, 0x3c, 0x10, 0x04, 0x02, 0x3f, 0x02, 0x04, 0x00, 0x00 },	// U+2944 (⥄)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x08, 0x02, 0x07, 0x02, 0x00, 0x00 },	// U+2945 (⥅)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x02, 0x08, 0x1c, 0x08, 0x00, 0x00 },	// U+2946 (⥆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x3f, 0x16, 0x00, 0x00, 0x00 },	// U+2947 (⥇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+2948 (⥈)
	{ 0x00, 0x04, 0x0e, 0x15, 0x0e, 0x15, 0x04, 0x04, 0x04, 0x0a, 0x04, 0x00 },	// U+2949 (⥉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+294A (⥊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+294B (⥋)
	{ 0x00, 0x00, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x05, 0x06, 0x04, 0x00 },	// U+294C (⥌)
	{ 0x00, 0x00, 0x04, 0x06, 0x05, 0x04, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x00 },	// U+294D (⥍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+294E (⥎)
	{ 0x00, 0x00, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x00 },	// U+294F (⥏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x00, 0x00, 0x00 },	// U+2950 (⥐)
	{ 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x0a, 0x0c, 0x08, 0x00 },	// U+2951 (⥑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x3f, 0x01, 0x01, 0x00, 0x00 },	// U+2952 (⥒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x28, 0x3f, 0x20, 0x20, 0x00, 0x00 },	// U+2953 (⥓)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2954 (⥔)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x1f, 0x00, 0x00 },	// U+2955 (⥕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x3f, 0x05, 0x09, 0x00, 0x00 },	// U+2956 (⥖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x3f, 0x28, 0x24, 0x00, 0x00 },	// U+2957 (⥗)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x06, 0x05, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2958 (⥘)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x05, 0x06, 0x04, 0x1f, 0x00, 0x00 },	// U+2959 (⥙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x1f, 0x10, 0x00, 0x00, 0x00 },	// U+295A (⥚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x1f, 0x01, 0x00, 0x00, 0x00 },	// U+295B (⥛)
	{ 0x00, 0x00, 0x00, 0x04, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00 },	// U+295C (⥜)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x00, 0x00 },	// U+295D (⥝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1f, 0x12, 0x00, 0x00, 0x00 },	// U+295E (⥞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x1f, 0x09, 0x00, 0x00, 0x00 },	// U+295F (⥟)
	{ 0x00, 0x00, 0x00, 0x04, 0x06, 0x05, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00 },	// U+2960 (⥠)
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x05, 0x06, 0x04, 0x00, 0x00 },	// U+2961 (⥡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x00, 0x1f, 0x02, 0x00, 0x00 },	// U+2962 (⥢)
	{ 0x00, 0x00, 0x00, 0x0a, 0x1b, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2963 (⥣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x00, 0x1f, 0x08, 0x00, 0x00 },	// U+2964 (⥤)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x1b, 0x0a, 0x00, 0x00 },	// U+2965 (⥥)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x00, 0x08, 0x1f, 0x00, 0x00, 0x00 },	// U+2966 (⥦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x00, 0x1f, 0x08, 0x00, 0x00 },	// U+2967 (⥧)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x00, 0x02, 0x1f, 0x00, 0x00, 0x00 },	// U+2968 (⥨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x00, 0x1f, 0x02, 0x00, 0x00 },	// U+2969 (⥩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+296A (⥪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x02, 0x00, 0x00 },	// U+296B (⥫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+296C (⥬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x08, 0x00, 0x00 },	// U+296D (⥭)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0b, 0x0a, 0x0a, 0x0a, 0x1a, 0x0a, 0x00, 0x00 },	// U+296E (⥮)
	{ 0x00, 0x00, 0x00, 0x0a, 0x1a, 0x0a, 0x0a, 0x0a, 0x0b, 0x0a, 0x00, 0x00 },	// U+296F (⥯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+2970 (⥰)
	{ 0x00, 0x00, 0x07, 0x00, 0x07, 0x00, 0x08, 0x1f, 0x08, 0x00, 0x00, 0x00 },	// U+2971 (⥱)
	{ 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x08, 0x1f, 0x08, 0x00, 0x00, 0x00 },	// U+2972 (⥲)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x02, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2973 (⥳)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x08, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2974 (⥴)
	{ 0x00, 0x00, 0x08, 0x1f, 0x08, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00 },	// U+2975 (⥵)
	{ 0x00, 0x00, 0x18, 0x06, 0x01, 0x06, 0x18, 0x00, 0x02, 0x1f, 0x02, 0x00 },	// U+2976 (⥶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0a, 0x1f, 0x0a, 0x10, 0x00, 0x00 },	// U+2977 (⥷)
	{ 0x00, 0x00, 0x03, 0x0c, 0x10, 0x0c, 0x03, 0x08, 0x1f, 0x08, 0x00, 0x00 },	// U+2978 (⥸)
	{ 0x00, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00, 0x08, 0x1f, 0x08, 0x00, 0x00 },	// U+2979 (⥹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0a, 0x1f, 0x0a, 0x30, 0x00, 0x00 },	// U+297A (⥺)
	{ 0x00, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x02, 0x1f, 0x02, 0x00, 0x00 },	// U+297B (⥻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x1e, 0x01, 0x02, 0x00, 0x00 },	// U+297C (⥼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x0f, 0x10, 0x08, 0x00, 0x00 },	// U+297D (⥽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+297E (⥾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x15, 0x0a, 0x00, 0x00 },	// U+297F (⥿)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2980 (⦀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x1e, 0x0c, 0x00, 0x00, 0x00 },	// U+2981 (⦁)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00 },	// U+2982 (⦂)
	{ 0x00, 0x00, 0x1c, 0x0a, 0x0a, 0x0a, 0x09, 0x0a, 0x0a, 0x0a, 0x1c, 0x00 },	// U+2983 (⦃)
	{ 0x00, 0x00, 0x07, 0x0a, 0x0a, 0x0a, 0x12, 0x0a, 0x0a, 0x0a, 0x07, 0x00 },	// U+2984 (⦄)
	{ 0x00, 0x10, 0x08, 0x0c, 0x0c, 0x0a, 0x0a, 0x0c, 0x0c, 0x08, 0x10, 0x00 },	// U+2985 (⦅)
	{ 0x00, 0x02, 0x04, 0x0c, 0x0c, 0x14, 0x14, 0x0c, 0x0c, 0x04, 0x02, 0x00 },	// U+2986 (⦆)
	{ 0x00, 0x08, 0x0c, 0x0c, 0x0a, 0x0a, 0x0a, 0x0a, 0x0c, 0x0c, 0x08, 0x00 },	// U+2987 (⦇)
	{ 0x00, 0x02, 0x06, 0x06, 0x0a, 0x0a, 0x0a, 0x0a, 0x06, 0x06, 0x02, 0x00 },	// U+2988 (⦈)
	{ 0x00, 0x10, 0x18, 0x18, 0x14, 0x14, 0x12, 0x14, 0x14, 0x18, 0x18, 0x10 },	// U+2989 (⦉)
	{ 0x00, 0x02, 0x06, 0x06, 0x0a, 0x0a, 0x12, 0x0a, 0x0a, 0x06, 0x06, 0x02 },	// U+298A (⦊)
	{ 0x00, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x00, 0x0e },	// U+298B (⦋)
	{ 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00, 0x0e },	// U+298C (⦌)
	{ 0x00, 0x0e, 0x06, 0x0a, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x00 },	// U+298D (⦍)
	{ 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x0c, 0x0e, 0x00 },	// U+298E (⦎)
	{ 0x00, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0a, 0x06, 0x0e, 0x00 },	// U+298F (⦏)
	{ 0x00, 0x0e, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00 },	// U+2990 (⦐)
	{ 0x00, 0x10, 0x08, 0x08, 0x04, 0x04, 0x12, 0x04, 0x04, 0x08, 0x08, 0x10 },	// U+2991 (⦑)
	{ 0x00, 0x02, 0x04, 0x04, 0x08, 0x08, 0x12, 0x08, 0x08, 0x04, 0x04, 0x02 },	// U+2992 (⦒)
	{ 0x00, 0x00, 0x08, 0x04, 0x1c, 0x06, 0x05, 0x06, 0x1c, 0x04, 0x08, 0x00 },	// U+2993 (⦓)
	{ 0x00, 0x00, 0x02, 0x04, 0x07, 0x0c, 0x14, 0x0c, 0x07, 0x04, 0x02, 0x00 },	// U+2994 (⦔)
	{ 0x00, 0x00, 0x14, 0x0a, 0x0b, 0x0e, 0x1a, 0x0e, 0x0b, 0x0a, 0x14, 0x00 },	// U+2995 (⦕)
	{ 0x00, 0x00, 0x05, 0x0a, 0x1a, 0x0e, 0x0b, 0x0e, 0x1a, 0x0a, 0x05, 0x00 },	// U+2996 (⦖)
	{ 0x00, 0x08, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x08, 0x00 },	// U+2997 (⦗)
	{ 0x00, 0x02, 0x04, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x04, 0x02, 0x00 },	// U+2998 (⦘)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00 },	// U+2999 (⦙)
	{ 0x00, 0x00, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x00, 0x00 },	// U+299A (⦚)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x14, 0x3f, 0x00, 0x00, 0x00 },	// U+299B (⦛)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x07, 0x05, 0x1f, 0x00, 0x00 },	// U+299C (⦜)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x07, 0x09, 0x15, 0x11, 0x3f, 0x00, 0x00 },	// U+299D (⦝)
	{ 0x00, 0x08, 0x08, 0x04, 0x34, 0x12, 0x22, 0x31, 0x01, 0x3f, 0x00, 0x00 },	// U+299E (⦞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x18, 0x06, 0x3f, 0x00, 0x00 },	// U+299F (⦟)
	{ 0x00, 0x00, 0x00, 0x09, 0x06, 0x1c, 0x24, 0x1c, 0x06, 0x09, 0x00, 0x00 },	// U+29A0 (⦠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0e, 0x1b, 0x04, 0x00, 0x00 },	// U+29A1 (⦡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+29A2 (⦢)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x3f, 0x00, 0x00, 0x00 },	// U+29A3 (⦣)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x02, 0x3f, 0x00, 0x3f, 0x00, 0x00 },	// U+29A4 (⦤)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x3f, 0x00, 0x3f, 0x00, 0x00 },	// U+29A5 (⦥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+29A6 (⦦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x01, 0x00, 0x00, 0x00 },	// U+29A7 (⦧)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x04, 0x0a, 0x3f, 0x00, 0x00, 0x00 },	// U+29A8 (⦨)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x08, 0x14, 0x3f, 0x00, 0x00, 0x00 },	// U+29A9 (⦩)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x0a, 0x04, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+29AA (⦪)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x14, 0x08, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+29AB (⦫)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x19, 0x1b, 0x05, 0x03, 0x01, 0x00, 0x00 },	// U+29AC (⦬)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x13, 0x1b, 0x14, 0x18, 0x10, 0x00, 0x00 },	// U+29AD (⦭)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x05, 0x1b, 0x19, 0x01, 0x00, 0x00 },	// U+29AE (⦮)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x1b, 0x13, 0x10, 0x00, 0x00 },	// U+29AF (⦯)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x16, 0x1a, 0x1c, 0x20, 0x00, 0x00 },	// U+29B0 (⦰)
	{ 0x00, 0x00, 0x1e, 0x00, 0x20, 0x1c, 0x1a, 0x16, 0x0e, 0x01, 0x00, 0x00 },	// U+29B1 (⦱)
	{ 0x00, 0x04, 0x0a, 0x04, 0x20, 0x1c, 0x1a, 0x16, 0x0e, 0x01, 0x00, 0x00 },	// U+29B2 (⦲)
	{ 0x00, 0x08, 0x1e, 0x08, 0x20, 0x1c, 0x1a, 0x16, 0x0e, 0x01, 0x00, 0x00 },	// U+29B3 (⦳)
	{ 0x00, 0x04, 0x1e, 0x04, 0x20, 0x1c, 0x1a, 0x16, 0x0e, 0x01, 0x00, 0x00 },	// U+29B4 (⦴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+29B5 (⦵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+29B6 (⦶)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2d, 0x2d, 0x2d, 0x2d, 0x1e, 0x00, 0x00 },	// U+29B7 (⦷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x13, 0x15, 0x19, 0x0e, 0x00, 0x00 },	// U+29B8 (⦸)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+29B9 (⦹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x1f, 0x11, 0x0e, 0x00, 0x00 },	// U+29BA (⦺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x15, 0x1b, 0x0e, 0x00, 0x00 },	// U+29BB (⦻)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x33, 0x29, 0x25, 0x33, 0x1e, 0x00, 0x00 },	// U+29BC (⦼)
	{ 0x00, 0x00, 0x04, 0x0e, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x00 },	// U+29BD (⦽)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x2d, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+29BE (⦾)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x2d, 0x2d, 0x21, 0x1e, 0x00, 0x00 },	// U+29BF (⦿)
	{ 0x00, 0x00, 0x00, 0x1e, 0x21, 0x25, 0x29, 0x25, 0x21, 0x1e, 0x00, 0x00 },	// U+29C0 (⧀)
	{ 0x00, 0x00, 0x00, 0x1e, 0x21, 0x29, 0x25, 0x29, 0x21, 0x1e, 0x00, 0x00 },	// U+29C1 (⧁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x19, 0x29, 0x19, 0x06, 0x00, 0x00 },	// U+29C2 (⧂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x39, 0x09, 0x39, 0x06, 0x00, 0x00 },	// U+29C3 (⧃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x19, 0x15, 0x13, 0x1f, 0x00, 0x00 },	// U+29C4 (⧄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x13, 0x15, 0x19, 0x1f, 0x00, 0x00 },	// U+29C5 (⧅)
	{ 0x00, 0x00, 0x00, 0x3f, 0x21, 0x25, 0x2f, 0x25, 0x21, 0x3f, 0x00, 0x00 },	// U+29C6 (⧆)
	{ 0x00, 0x00, 0x00, 0x3f, 0x21, 0x25, 0x2b, 0x25, 0x21, 0x3f, 0x00, 0x00 },	// U+29C7 (⧇)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x33, 0x33, 0x3f, 0x3f, 0x00, 0x00 },	// U+29C8 (⧈)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x09, 0x3d, 0x27, 0x24, 0x3c, 0x00, 0x00 },	// U+29C9 (⧉)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x00 },	// U+29CA (⧊)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+29CB (⧋)
	{ 0x00, 0x00, 0x0c, 0x12, 0x2d, 0x25, 0x29, 0x2d, 0x21, 0x3f, 0x00, 0x00 },	// U+29CC (⧌)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x3f, 0x00, 0x00 },	// U+29CD (⧍)
	{ 0x00, 0x03, 0x0d, 0x11, 0x0d, 0x03, 0x18, 0x16, 0x11, 0x16, 0x18, 0x00 },	// U+29CE (⧎)
	{ 0x00, 0x00, 0x00, 0x28, 0x2c, 0x2a, 0x29, 0x2a, 0x2c, 0x28, 0x00, 0x00 },	// U+29CF (⧏)
	{ 0x00, 0x00, 0x00, 0x05, 0x0d, 0x15, 0x25, 0x15, 0x0d, 0x05, 0x00, 0x00 },	// U+29D0 (⧐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x17, 0x1b, 0x11, 0x00, 0x00 },	// U+29D1 (⧑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x1d, 0x1b, 0x11, 0x00, 0x00 },	// U+29D2 (⧒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1b, 0x1f, 0x1b, 0x11, 0x00, 0x00 },	// U+29D3 (⧓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0b, 0x07, 0x0b, 0x11, 0x00, 0x00 },	// U+29D4 (⧔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1a, 0x1c, 0x1a, 0x11, 0x00, 0x00 },	// U+29D5 (⧕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x04, 0x0a, 0x1f, 0x00, 0x00 },	// U+29D6 (⧖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0e, 0x04, 0x0e, 0x1f, 0x00, 0x00 },	// U+29D7 (⧗)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x00, 0x00 },	// U+29D8 (⧘)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x00, 0x00 },	// U+29D9 (⧙)
	{ 0x00, 0x00, 0x00, 0x09, 0x12, 0x09, 0x12, 0x09, 0x12, 0x09, 0x00, 0x00 },	// U+29DA (⧚)
	{ 0x00, 0x00, 0x00, 0x12, 0x09, 0x12, 0x09, 0x12, 0x09, 0x12, 0x00, 0x00 },	// U+29DB (⧛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+29DC (⧜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+29DD (⧝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+29DE (⧞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2d, 0x12, 0x00, 0x00, 0x00 },	// U+29DF (⧟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x13, 0x13, 0x1f, 0x00, 0x00 },	// U+29E0 (⧠)
	{ 0x00, 0x00, 0x00, 0x10, 0x18, 0x14, 0x12, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+29E1 (⧡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x1f, 0x00, 0x00 },	// U+29E2 (⧢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x04, 0x1f, 0x02, 0x00, 0x00 },	// U+29E3 (⧣)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x08, 0x1f, 0x04, 0x1f, 0x02, 0x00, 0x00 },	// U+29E4 (⧤)
	{ 0x00, 0x00, 0x08, 0x08, 0x1f, 0x04, 0x1f, 0x04, 0x1f, 0x02, 0x02, 0x00 },	// U+29E5 (⧥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1f, 0x11, 0x1f, 0x11, 0x00, 0x00 },	// U+29E6 (⧦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+29E7 (⧧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x13, 0x0a, 0x04, 0x00, 0x00 },	// U+29E8 (⧨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x19, 0x0a, 0x04, 0x00, 0x00 },	// U+29E9 (⧩)
	{ 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+29EA (⧪)
	{ 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x1f, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+29EB (⧫)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0e, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+29EC (⧬)
	{ 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x0e, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+29ED (⧭)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x0e, 0x0a, 0x0e, 0x04, 0x0e, 0x00, 0x00 },	// U+29EE (⧮)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x0e, 0x0e, 0x0e, 0x04, 0x0e, 0x00, 0x00 },	// U+29EF (⧯)
	{ 0x00, 0x0e, 0x04, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+29F0 (⧰)
	{ 0x00, 0x0e, 0x04, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x04, 0x0e, 0x00, 0x00 },	// U+29F1 (⧱)
	{ 0x00, 0x00, 0x0e, 0x04, 0x0e, 0x11, 0x11, 0x0e, 0x04, 0x0e, 0x00, 0x00 },	// U+29F2 (⧲)
	{ 0x00, 0x00, 0x0e, 0x04, 0x0e, 0x1f, 0x1f, 0x0e, 0x04, 0x0e, 0x00, 0x00 },	// U+29F3 (⧳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x08, 0x1f, 0x08, 0x05, 0x00, 0x00 },	// U+29F4 (⧴)
	{ 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00 },	// U+29F5 (⧵)
	{ 0x00, 0x1e, 0x00, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00 },	// U+29F6 (⧶)
	{ 0x00, 0x00, 0x02, 0x02, 0x04, 0x1e, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00 },	// U+29F7 (⧷)
	{ 0x00, 0x00, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+29F8 (⧸)
	{ 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00 },	// U+29F9 (⧹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x1f, 0x0a, 0x0a, 0x00, 0x00 },	// U+29FA (⧺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x3f, 0x2a, 0x2a, 0x00, 0x00 },	// U+29FB (⧻)
	{ 0x00, 0x00, 0x08, 0x08, 0x04, 0x04, 0x02, 0x04, 0x04, 0x08, 0x08, 0x00 },	// U+29FC (⧼)
	{ 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00 },	// U+29FD (⧽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+29FE (⧾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1f, 0x11, 0x00, 0x00, 0x00, 0x00 },	// U+29FF (⧿)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2A00 (⨀)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x15, 0x1f, 0x15, 0x0e, 0x00, 0x00, 0x00 },	// U+2A01 (⨁)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x15, 0x1b, 0x0e, 0x00, 0x00, 0x00 },	// U+2A02 (⨂)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2A03 (⨃)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x15, 0x1f, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2A04 (⨄)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+2A05 (⨅)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2A06 (⨆)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x1e, 0x1e, 0x33, 0x33, 0x00, 0x00 },	// U+2A07 (⨇)
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x1e, 0x1e, 0x0c, 0x0c, 0x00, 0x00 },	// U+2A08 (⨈)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00, 0x00 },	// U+2A09 (⨉)
	{ 0x00, 0x00, 0x00, 0x1f, 0x01, 0x06, 0x0a, 0x06, 0x01, 0x1f, 0x00, 0x00 },	// U+2A0A (⨊)
	{ 0x08, 0x14, 0x04, 0x04, 0x1f, 0x06, 0x04, 0x06, 0x1f, 0x04, 0x05, 0x02 },	// U+2A0B (⨋)
	{ 0x00, 0x1c, 0x3e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1f, 0x0e, 0x00 },	// U+2A0C (⨌)
	{ 0x08, 0x14, 0x04, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x05, 0x02 },	// U+2A0D (⨍)
	{ 0x08, 0x14, 0x04, 0x04, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x04, 0x05, 0x02 },	// U+2A0E (⨎)
	{ 0x08, 0x14, 0x04, 0x04, 0x14, 0x0c, 0x06, 0x05, 0x04, 0x04, 0x05, 0x02 },	// U+2A0F (⨏)
	{ 0x08, 0x14, 0x04, 0x04, 0x0e, 0x05, 0x05, 0x05, 0x06, 0x04, 0x05, 0x02 },	// U+2A10 (⨐)
	{ 0x08, 0x14, 0x04, 0x04, 0x04, 0x3c, 0x35, 0x2e, 0x04, 0x04, 0x05, 0x02 },	// U+2A11 (⨑)
	{ 0x08, 0x14, 0x04, 0x04, 0x1c, 0x10, 0x14, 0x10, 0x1c, 0x04, 0x05, 0x02 },	// U+2A12 (⨒)
	{ 0x08, 0x14, 0x04, 0x04, 0x0c, 0x10, 0x14, 0x10, 0x0c, 0x04, 0x05, 0x02 },	// U+2A13 (⨓)
	{ 0x08, 0x14, 0x04, 0x04, 0x1c, 0x20, 0x28, 0x20, 0x1c, 0x04, 0x05, 0x02 },	// U+2A14 (⨔)
	{ 0x08, 0x14, 0x04, 0x04, 0x0e, 0x11, 0x15, 0x11, 0x0e, 0x04, 0x05, 0x02 },	// U+2A15 (⨕)
	{ 0x08, 0x14, 0x04, 0x04, 0x1f, 0x15, 0x15, 0x1f, 0x04, 0x04, 0x05, 0x02 },	// U+2A16 (⨖)
	{ 0x10, 0x28, 0x08, 0x08, 0x0a, 0x3f, 0x2a, 0x08, 0x08, 0x08, 0x0a, 0x04 },	// U+2A17 (⨗)
	{ 0x08, 0x14, 0x04, 0x15, 0x0e, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x05, 0x02 },	// U+2A18 (⨘)
	{ 0x08, 0x14, 0x04, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x04, 0x04, 0x05, 0x02 },	// U+2A19 (⨙)
	{ 0x08, 0x14, 0x04, 0x04, 0x15, 0x15, 0x15, 0x0e, 0x04, 0x04, 0x05, 0x02 },	// U+2A1A (⨚)
	{ 0x1e, 0x00, 0x08, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x02 },	// U+2A1B (⨛)
	{ 0x08, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x02, 0x00, 0x1f },	// U+2A1C (⨜)
	{ 0x00, 0x00, 0x00, 0x21, 0x33, 0x2d, 0x2d, 0x2d, 0x33, 0x21, 0x00, 0x00 },	// U+2A1D (⨝)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x09, 0x0a, 0x0c, 0x08, 0x00, 0x00 },	// U+2A1E (⨞)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x04, 0x0a, 0x04, 0x02, 0x00 },	// U+2A1F (⨟)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x24, 0x12, 0x09, 0x00, 0x00, 0x00 },	// U+2A20 (⨠)
	{ 0x00, 0x00, 0x00, 0x02, 0x06, 0x0a, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+2A21 (⨡)
	{ 0x00, 0x04, 0x0a, 0x04, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+2A22 (⨢)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+2A23 (⨣)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+2A24 (⨤)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00 },	// U+2A25 (⨥)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x16, 0x0d, 0x00 },	// U+2A26 (⨦)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x34, 0x20, 0x10, 0x38, 0x00 },	// U+2A27 (⨧)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+2A28 (⨨)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x04, 0x00, 0x1f, 0x00, 0x00 },	// U+2A29 (⨩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2A2A (⨪)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1f, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+2A2B (⨫)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x1f, 0x00, 0x02, 0x00, 0x00, 0x00 },	// U+2A2C (⨬)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x09, 0x1d, 0x09, 0x02, 0x1c, 0x00, 0x00 },	// U+2A2D (⨭)
	{ 0x00, 0x00, 0x00, 0x06, 0x08, 0x12, 0x17, 0x12, 0x08, 0x06, 0x00, 0x00 },	// U+2A2E (⨮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+2A2F (⨯)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x00 },	// U+2A30 (⨰)
	{ 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00, 0x1f, 0x00, 0x00 },	// U+2A31 (⨱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x1f, 0x00, 0x00 },	// U+2A32 (⨲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x1e, 0x0c, 0x1e, 0x33, 0x00, 0x00 },	// U+2A33 (⨳)
	{ 0x00, 0x00, 0x00, 0x0e, 0x01, 0x15, 0x09, 0x15, 0x01, 0x0e, 0x00, 0x00 },	// U+2A34 (⨴)
	{ 0x00, 0x00, 0x00, 0x0e, 0x10, 0x15, 0x12, 0x15, 0x10, 0x0e, 0x00, 0x00 },	// U+2A35 (⨵)
	{ 0x04, 0x0a, 0x00, 0x0e, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x0e, 0x00, 0x00 },	// U+2A36 (⨶)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x0e, 0x00, 0x00 },	// U+2A37 (⨷)
	{ 0x00, 0x0e, 0x11, 0x15, 0x11, 0x1f, 0x11, 0x15, 0x11, 0x0e, 0x00, 0x00 },	// U+2A38 (⨸)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x1e, 0x2d, 0x21, 0x3f, 0x00, 0x00 },	// U+2A39 (⨹)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x2d, 0x21, 0x3f, 0x00, 0x00 },	// U+2A3A (⨺)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x1e, 0x2d, 0x21, 0x3f, 0x00, 0x00 },	// U+2A3B (⨻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2A3C (⨼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+2A3D (⨽)
	{ 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x04, 0x0a, 0x0c, 0x08, 0x04, 0x00 },	// U+2A3E (⨾)
	{ 0x00, 0x00, 0x00, 0x3b, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3f, 0x00, 0x00 },	// U+2A3F (⨿)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00 },	// U+2A40 (⩀)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+2A41 (⩁)
	{ 0x00, 0x1f, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+2A42 (⩂)
	{ 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x1f, 0x00 },	// U+2A43 (⩃)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x15, 0x1b, 0x00, 0x00 },	// U+2A44 (⩄)
	{ 0x00, 0x00, 0x00, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+2A45 (⩅)
	{ 0x00, 0x00, 0x00, 0x09, 0x09, 0x06, 0x00, 0x06, 0x09, 0x09, 0x00, 0x00 },	// U+2A46 (⩆)
	{ 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x00, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+2A47 (⩇)
	{ 0x00, 0x00, 0x09, 0x09, 0x06, 0x00, 0x0f, 0x00, 0x06, 0x09, 0x09, 0x00 },	// U+2A48 (⩈)
	{ 0x00, 0x00, 0x06, 0x09, 0x09, 0x00, 0x0f, 0x00, 0x09, 0x09, 0x06, 0x00 },	// U+2A49 (⩉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x0a, 0x00, 0x00, 0x00 },	// U+2A4A (⩊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+2A4B (⩋)
	{ 0x00, 0x00, 0x00, 0x3f, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00 },	// U+2A4C (⩌)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x12, 0x3f, 0x00, 0x00 },	// U+2A4D (⩍)
	{ 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00 },	// U+2A4E (⩎)
	{ 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1f, 0x1f, 0x00, 0x00 },	// U+2A4F (⩏)
	{ 0x00, 0x00, 0x00, 0x1f, 0x11, 0x1b, 0x15, 0x1b, 0x11, 0x0e, 0x00, 0x00 },	// U+2A50 (⩐)
	{ 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+2A51 (⩑)
	{ 0x00, 0x00, 0x00, 0x04, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+2A52 (⩒)
	{ 0x00, 0x0a, 0x0a, 0x04, 0x15, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+2A53 (⩓)
	{ 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x15, 0x04, 0x0a, 0x0a, 0x00, 0x00 },	// U+2A54 (⩔)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x1e, 0x1e, 0x1e, 0x33, 0x33, 0x00, 0x00 },	// U+2A55 (⩕)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x1e, 0x1e, 0x1e, 0x0c, 0x0c, 0x00, 0x00 },	// U+2A56 (⩖)
	{ 0x00, 0x00, 0x00, 0x00, 0x21, 0x11, 0x09, 0x05, 0x03, 0x01, 0x00, 0x00 },	// U+2A57 (⩗)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x28, 0x24, 0x22, 0x21, 0x00, 0x00 },	// U+2A58 (⩘)
	{ 0x00, 0x00, 0x00, 0x11, 0x15, 0x0e, 0x0a, 0x0e, 0x15, 0x11, 0x00, 0x00 },	// U+2A59 (⩙)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x15, 0x15, 0x00, 0x00 },	// U+2A5A (⩚)
	{ 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+2A5B (⩛)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x1f, 0x0a, 0x11, 0x11, 0x00, 0x00 },	// U+2A5C (⩜)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x0a, 0x1f, 0x0a, 0x04, 0x04, 0x00, 0x00 },	// U+2A5D (⩝)
	{ 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00 },	// U+2A5E (⩞)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x1f, 0x00 },	// U+2A5F (⩟)
	{ 0x00, 0x04, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2A60 (⩠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x04, 0x00, 0x1f, 0x00, 0x00 },	// U+2A61 (⩡)
	{ 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00 },	// U+2A62 (⩢)
	{ 0x00, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2A63 (⩣)
	{ 0x00, 0x00, 0x10, 0x18, 0x14, 0x12, 0x1f, 0x12, 0x14, 0x18, 0x10, 0x00 },	// U+2A64 (⩤)
	{ 0x00, 0x00, 0x01, 0x03, 0x05, 0x09, 0x1f, 0x09, 0x05, 0x03, 0x01, 0x00 },	// U+2A65 (⩥)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2A66 (⩦)
	{ 0x00, 0x00, 0x00, 0x04, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2A67 (⩧)
	{ 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x00, 0x00 },	// U+2A68 (⩨)
	{ 0x00, 0x00, 0x00, 0x15, 0x3f, 0x15, 0x3f, 0x15, 0x3f, 0x15, 0x00, 0x00 },	// U+2A69 (⩩)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x16, 0x0d, 0x00, 0x00, 0x00, 0x00 },	// U+2A6A (⩪)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x16, 0x0d, 0x00, 0x02, 0x00, 0x00 },	// U+2A6B (⩫)
	{ 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2A6C (⩬)
	{ 0x00, 0x00, 0x04, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2A6D (⩭)
	{ 0x00, 0x00, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2A6E (⩮)
	{ 0x00, 0x00, 0x04, 0x0a, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2A6F (⩯)
	{ 0x00, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2A70 (⩰)
	{ 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00 },	// U+2A71 (⩱)
	{ 0x00, 0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2A72 (⩲)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2A73 (⩳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x00, 0x35, 0x00, 0x00, 0x00 },	// U+2A74 (⩴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x1b, 0x00, 0x00, 0x00 },	// U+2A75 (⩵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x15, 0x00, 0x00, 0x00 },	// U+2A76 (⩶)
	{ 0x00, 0x00, 0x00, 0x0a, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x0a, 0x00, 0x00 },	// U+2A77 (⩷)
	{ 0x00, 0x00, 0x00, 0x15, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2A78 (⩸)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x12, 0x29, 0x12, 0x04, 0x08, 0x00, 0x00 },	// U+2A79 (⩹)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x12, 0x25, 0x12, 0x08, 0x04, 0x00, 0x00 },	// U+2A7A (⩺)
	{ 0x03, 0x04, 0x02, 0x00, 0x02, 0x30, 0x0c, 0x03, 0x0c, 0x30, 0x00, 0x00 },	// U+2A7B (⩻)
	{ 0x18, 0x20, 0x10, 0x00, 0x10, 0x03, 0x0c, 0x30, 0x0c, 0x03, 0x00, 0x00 },	// U+2A7C (⩼)
	{ 0x00, 0x00, 0x00, 0x30, 0x0c, 0x03, 0x0c, 0x33, 0x0c, 0x30, 0x00, 0x00 },	// U+2A7D (⩽)
	{ 0x00, 0x00, 0x00, 0x03, 0x0c, 0x30, 0x0c, 0x33, 0x0c, 0x03, 0x00, 0x00 },	// U+2A7E (⩾)
	{ 0x00, 0x00, 0x00, 0x30, 0x0c, 0x23, 0x0c, 0x33, 0x0c, 0x30, 0x00, 0x00 },	// U+2A7F (⩿)
	{ 0x00, 0x00, 0x00, 0x03, 0x0c, 0x31, 0x0c, 0x33, 0x0c, 0x03, 0x00, 0x00 },	// U+2A80 (⪀)
	{ 0x00, 0x00, 0x02, 0x30, 0x0c, 0x03, 0x0c, 0x33, 0x0c, 0x30, 0x00, 0x00 },	// U+2A81 (⪁)
	{ 0x00, 0x00, 0x10, 0x03, 0x0c, 0x30, 0x0c, 0x33, 0x0c, 0x03, 0x00, 0x00 },	// U+2A82 (⪂)
	{ 0x00, 0x20, 0x00, 0x30, 0x0c, 0x03, 0x0c, 0x33, 0x0c, 0x30, 0x00, 0x00 },	// U+2A83 (⪃)
	{ 0x00, 0x01, 0x00, 0x03, 0x0c, 0x30, 0x0c, 0x33, 0x0c, 0x03, 0x00, 0x00 },	// U+2A84 (⪄)
	{ 0x00, 0x00, 0x1c, 0x03, 0x1c, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00 },	// U+2A85 (⪅)
	{ 0x00, 0x07, 0x18, 0x07, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2A86 (⪆)
	{ 0x00, 0x00, 0x30, 0x0c, 0x03, 0x0c, 0x30, 0x00, 0x08, 0x3f, 0x02, 0x00 },	// U+2A87 (⪇)
	{ 0x00, 0x00, 0x03, 0x0c, 0x30, 0x0c, 0x03, 0x00, 0x08, 0x3f, 0x02, 0x00 },	// U+2A88 (⪈)
	{ 0x00, 0x1c, 0x03, 0x1c, 0x00, 0x08, 0x1e, 0x0d, 0x04, 0x16, 0x0f, 0x02 },	// U+2A89 (⪉)
	{ 0x00, 0x07, 0x18, 0x07, 0x00, 0x08, 0x1e, 0x0d, 0x04, 0x16, 0x0f, 0x02 },	// U+2A8A (⪊)
	{ 0x00, 0x1c, 0x03, 0x1c, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x07, 0x18, 0x07 },	// U+2A8B (⪋)
	{ 0x00, 0x07, 0x18, 0x07, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1c, 0x03, 0x1c },	// U+2A8C (⪌)
	{ 0x00, 0x00, 0x1c, 0x03, 0x1c, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x00 },	// U+2A8D (⪍)
	{ 0x00, 0x00, 0x07, 0x18, 0x07, 0x00, 0x16, 0x0d, 0x00, 0x1f, 0x00, 0x00 },	// U+2A8E (⪎)
	{ 0x00, 0x1c, 0x03, 0x1c, 0x00, 0x16, 0x0d, 0x00, 0x07, 0x18, 0x07, 0x00 },	// U+2A8F (⪏)
	{ 0x00, 0x07, 0x18, 0x07, 0x00, 0x16, 0x0d, 0x00, 0x1c, 0x03, 0x1c, 0x00 },	// U+2A90 (⪐)
	{ 0x00, 0x1c, 0x03, 0x1c, 0x07, 0x18, 0x07, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2A91 (⪑)
	{ 0x00, 0x07, 0x18, 0x07, 0x1c, 0x03, 0x1c, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2A92 (⪒)
	{ 0x00, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x00 },	// U+2A93 (⪓)
	{ 0x00, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x00 },	// U+2A94 (⪔)
	{ 0x00, 0x00, 0x00, 0x30, 0x0c, 0x33, 0x0c, 0x03, 0x0c, 0x30, 0x00, 0x00 },	// U+2A95 (⪕)
	{ 0x00, 0x00, 0x00, 0x03, 0x0c, 0x33, 0x0c, 0x30, 0x0c, 0x03, 0x00, 0x00 },	// U+2A96 (⪖)
	{ 0x00, 0x00, 0x00, 0x30, 0x0c, 0x33, 0x0c, 0x23, 0x0c, 0x30, 0x00, 0x00 },	// U+2A97 (⪗)
	{ 0x00, 0x00, 0x00, 0x03, 0x0c, 0x33, 0x0c, 0x31, 0x0c, 0x03, 0x00, 0x00 },	// U+2A98 (⪘)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x07, 0x18, 0x07, 0x00, 0x00 },	// U+2A99 (⪙)
	{ 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x07, 0x18, 0x07, 0x00, 0x00 },	// U+2A9A (⪚)
	{ 0x00, 0x00, 0x30, 0x0c, 0x33, 0x0c, 0x33, 0x0c, 0x03, 0x0c, 0x30, 0x00 },	// U+2A9B (⪛)
	{ 0x00, 0x00, 0x03, 0x0c, 0x33, 0x0c, 0x33, 0x0c, 0x30, 0x0c, 0x03, 0x00 },	// U+2A9C (⪜)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x1c, 0x03, 0x1c, 0x00, 0x00 },	// U+2A9D (⪝)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x07, 0x18, 0x07, 0x00, 0x00 },	// U+2A9E (⪞)
	{ 0x00, 0x16, 0x0d, 0x00, 0x1c, 0x03, 0x1c, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2A9F (⪟)
	{ 0x00, 0x16, 0x0d, 0x00, 0x07, 0x18, 0x07, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2AA0 (⪠)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x12, 0x09, 0x12, 0x04, 0x08, 0x00, 0x00 },	// U+2AA1 (⪡)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x09, 0x12, 0x09, 0x04, 0x02, 0x00, 0x00 },	// U+2AA2 (⪢)
	{ 0x00, 0x00, 0x00, 0x24, 0x12, 0x09, 0x12, 0x24, 0x00, 0x3f, 0x00, 0x00 },	// U+2AA3 (⪣)
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x0c, 0x12, 0x0c, 0x33, 0x00, 0x00, 0x00 },	// U+2AA4 (⪤)
	{ 0x00, 0x00, 0x00, 0x00, 0x21, 0x12, 0x0c, 0x12, 0x21, 0x00, 0x00, 0x00 },	// U+2AA5 (⪥)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x2c, 0x23, 0x2c, 0x10, 0x00, 0x00, 0x00 },	// U+2AA6 (⪦)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x0d, 0x31, 0x0d, 0x02, 0x00, 0x00, 0x00 },	// U+2AA7 (⪧)
	{ 0x00, 0x00, 0x00, 0x10, 0x2c, 0x23, 0x2c, 0x13, 0x0c, 0x30, 0x00, 0x00 },	// U+2AA8 (⪨)
	{ 0x00, 0x00, 0x00, 0x02, 0x0d, 0x31, 0x0d, 0x32, 0x0c, 0x03, 0x00, 0x00 },	// U+2AA9 (⪩)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x3f, 0x0c, 0x30, 0x00, 0x00, 0x00 },	// U+2AAA (⪪)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x3f, 0x0c, 0x03, 0x00, 0x00, 0x00 },	// U+2AAB (⪫)
	{ 0x00, 0x00, 0x00, 0x30, 0x0c, 0x3f, 0x0c, 0x30, 0x00, 0x3f, 0x00, 0x00 },	// U+2AAC (⪬)
	{ 0x00, 0x00, 0x00, 0x03, 0x0c, 0x3f, 0x0c, 0x03, 0x00, 0x3f, 0x00, 0x00 },	// U+2AAD (⪭)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x1b, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2AAE (⪮)
	{ 0x00, 0x00, 0x00, 0x10, 0x0c, 0x03, 0x0c, 0x10, 0x00, 0x1f, 0x00, 0x00 },	// U+2AAF (⪯)
	{ 0x00, 0x00, 0x00, 0x01, 0x06, 0x18, 0x06, 0x01, 0x00, 0x1f, 0x00, 0x00 },	// U+2AB0 (⪰)
	{ 0x00, 0x00, 0x00, 0x10, 0x0c, 0x03, 0x0c, 0x10, 0x08, 0x1f, 0x02, 0x00 },	// U+2AB1 (⪱)
	{ 0x00, 0x00, 0x00, 0x01, 0x06, 0x18, 0x06, 0x01, 0x08, 0x1f, 0x02, 0x00 },	// U+2AB2 (⪲)
	{ 0x00, 0x00, 0x10, 0x0c, 0x03, 0x0c, 0x10, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2AB3 (⪳)
	{ 0x00, 0x00, 0x01, 0x06, 0x18, 0x06, 0x01, 0x00, 0x1f, 0x00, 0x1f, 0x00 },	// U+2AB4 (⪴)
	{ 0x00, 0x10, 0x0c, 0x03, 0x0c, 0x10, 0x08, 0x1f, 0x04, 0x1f, 0x02, 0x00 },	// U+2AB5 (⪵)
	{ 0x00, 0x01, 0x06, 0x18, 0x06, 0x01, 0x08, 0x1f, 0x04, 0x1f, 0x02, 0x00 },	// U+2AB6 (⪶)
	{ 0x10, 0x0c, 0x03, 0x0c, 0x10, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00 },	// U+2AB7 (⪷)
	{ 0x01, 0x06, 0x18, 0x06, 0x01, 0x00, 0x0d, 0x16, 0x00, 0x0d, 0x16, 0x00 },	// U+2AB8 (⪸)
	{ 0x10, 0x0c, 0x03, 0x0c, 0x10, 0x08, 0x1e, 0x0d, 0x04, 0x16, 0x0f, 0x02 },	// U+2AB9 (⪹)
	{ 0x01, 0x06, 0x18, 0x06, 0x01, 0x08, 0x1e, 0x0d, 0x04, 0x16, 0x0f, 0x02 },	// U+2ABA (⪺)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x0a, 0x05, 0x0a, 0x14, 0x14, 0x00, 0x00 },	// U+2ABB (⪻)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x0a, 0x14, 0x0a, 0x05, 0x05, 0x00, 0x00 },	// U+2ABC (⪼)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x05, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+2ABD (⪽)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x14, 0x10, 0x0f, 0x00, 0x00, 0x00 },	// U+2ABE (⪾)
	{ 0x00, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+2ABF (⪿)
	{ 0x00, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+2AC0 (⫀)
	{ 0x00, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00, 0x0a, 0x04, 0x0a, 0x00, 0x00 },	// U+2AC1 (⫁)
	{ 0x00, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x0a, 0x04, 0x0a, 0x00, 0x00 },	// U+2AC2 (⫂)
	{ 0x00, 0x00, 0x04, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00, 0x1f, 0x00, 0x00 },	// U+2AC3 (⫃)
	{ 0x00, 0x00, 0x04, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x1f, 0x00, 0x00 },	// U+2AC4 (⫄)
	{ 0x00, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2AC5 (⫅)
	{ 0x00, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2AC6 (⫆)
	{ 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2AC7 (⫇)
	{ 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2AC8 (⫈)
	{ 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00 },	// U+2AC9 (⫉)
	{ 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00 },	// U+2ACA (⫊)
	{ 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00, 0x08, 0x1f, 0x04, 0x1f, 0x02, 0x00 },	// U+2ACB (⫋)
	{ 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x08, 0x1f, 0x04, 0x1f, 0x02, 0x00 },	// U+2ACC (⫌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x01, 0x01, 0x0f, 0x00, 0x00, 0x00 },	// U+2ACD (⫍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x20, 0x20, 0x3c, 0x00, 0x00, 0x00 },	// U+2ACE (⫎)
	{ 0x00, 0x00, 0x00, 0x1c, 0x12, 0x11, 0x11, 0x11, 0x12, 0x1c, 0x00, 0x00 },	// U+2ACF (⫏)
	{ 0x00, 0x00, 0x00, 0x07, 0x09, 0x11, 0x11, 0x11, 0x09, 0x07, 0x00, 0x00 },	// U+2AD0 (⫐)
	{ 0x00, 0x00, 0x1c, 0x12, 0x11, 0x11, 0x11, 0x12, 0x1c, 0x00, 0x1f, 0x00 },	// U+2AD1 (⫑)
	{ 0x00, 0x00, 0x07, 0x09, 0x11, 0x11, 0x11, 0x09, 0x07, 0x00, 0x1f, 0x00 },	// U+2AD2 (⫒)
	{ 0x00, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00 },	// U+2AD3 (⫓)
	{ 0x00, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00 },	// U+2AD4 (⫔)
	{ 0x00, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00, 0x1e, 0x01, 0x01, 0x1e, 0x00 },	// U+2AD5 (⫕)
	{ 0x00, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00, 0x0f, 0x10, 0x10, 0x0f, 0x00 },	// U+2AD6 (⫖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x0c, 0x0c, 0x33, 0x00, 0x00, 0x00 },	// U+2AD7 (⫗)
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x0c, 0x1e, 0x0c, 0x33, 0x00, 0x00, 0x00 },	// U+2AD8 (⫘)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2AD9 (⫙)
	{ 0x00, 0x00, 0x0e, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2ADA (⫚)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x15, 0x15, 0x15, 0x04, 0x00, 0x00 },	// U+2ADB (⫛)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x0c, 0x15, 0x17, 0x0f, 0x00, 0x00 },	// U+2ADC (⫝̸)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+2ADD (⫝)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2ADE (⫞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2ADF (⫟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00, 0x00 },	// U+2AE0 (⫠)
	{ 0x00, 0x00, 0x00, 0x04, 0x24, 0x14, 0x24, 0x14, 0x04, 0x3f, 0x00, 0x00 },	// U+2AE1 (⫡)
	{ 0x00, 0x00, 0x00, 0x01, 0x1f, 0x01, 0x1f, 0x01, 0x1f, 0x01, 0x00, 0x00 },	// U+2AE2 (⫢)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x17, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+2AE3 (⫣)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x1f, 0x10, 0x1f, 0x10, 0x10, 0x00, 0x00 },	// U+2AE4 (⫤)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x17, 0x14, 0x17, 0x14, 0x14, 0x00, 0x00 },	// U+2AE5 (⫥)
	{ 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x1f, 0x05, 0x05, 0x05, 0x00, 0x00 },	// U+2AE6 (⫦)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2AE7 (⫧)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x1f, 0x00, 0x00 },	// U+2AE8 (⫨)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1f, 0x00, 0x1f, 0x04, 0x04, 0x00, 0x00 },	// U+2AE9 (⫩)
	{ 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2AEA (⫪)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x1f, 0x00, 0x00 },	// U+2AEB (⫫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x00, 0x00, 0x00 },	// U+2AEC (⫬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x3e, 0x02, 0x00, 0x00, 0x00 },	// U+2AED (⫭)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x06, 0x04, 0x0c, 0x04, 0x04, 0x00, 0x00 },	// U+2AEE (⫮)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00 },	// U+2AEF (⫯)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0a, 0x04, 0x00, 0x00 },	// U+2AF0 (⫰)
	{ 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x0a, 0x04, 0x00, 0x00 },	// U+2AF1 (⫱)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x1f, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2AF2 (⫲)
	{ 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x1e, 0x0f, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+2AF3 (⫳)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2AF4 (⫴)
	{ 0x00, 0x00, 0x00, 0x15, 0x15, 0x15, 0x3f, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2AF5 (⫵)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+2AF6 (⫶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x15, 0x2a, 0x00, 0x00, 0x00, 0x00 },	// U+2AF7 (⫷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x2a, 0x15, 0x00, 0x00, 0x00, 0x00 },	// U+2AF8 (⫸)
	{ 0x00, 0x00, 0x30, 0x0c, 0x03, 0x0c, 0x33, 0x0c, 0x33, 0x0c, 0x30, 0x00 },	// U+2AF9 (⫹)
	{ 0x00, 0x00, 0x03, 0x0c, 0x30, 0x0c, 0x33, 0x0c, 0x33, 0x0c, 0x03, 0x00 },	// U+2AFA (⫺)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2AFB (⫻)
	{ 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+2AFC (⫼)
	{ 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x09, 0x09, 0x09, 0x09, 0x00, 0x00 },	// U+2AFD (⫽)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x0a, 0x0a, 0x0e, 0x00, 0x00 },	// U+2AFE (⫾)
	{ 0x00, 0x0e, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0e, 0x00, 0x00 },	// U+2AFF (⫿)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x28, 0x34, 0x0a, 0x05, 0x02, 0x00, 0x00 },	// U+2B00 (⬀)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x05, 0x0b, 0x14, 0x28, 0x10, 0x00, 0x00 },	// U+2B01 (⬁)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x0a, 0x34, 0x28, 0x38, 0x00, 0x00 },	// U+2B02 (⬂)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x14, 0x0b, 0x05, 0x07, 0x00, 0x00 },	// U+2B03 (⬃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2d, 0x21, 0x2d, 0x12, 0x00, 0x00 },	// U+2B04 (⬄)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x1f, 0x1f, 0x06, 0x04, 0x00, 0x00 },	// U+2B05 (⬅)
	{ 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00 },	// U+2B06 (⬆)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x1e, 0x0c, 0x00, 0x00 },	// U+2B07 (⬇)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x3c, 0x0e, 0x07, 0x02, 0x00, 0x00 },	// U+2B08 (⬈)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x0f, 0x1c, 0x38, 0x10, 0x00, 0x00 },	// U+2B09 (⬉)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x0e, 0x3c, 0x38, 0x38, 0x00, 0x00 },	// U+2B0A (⬊)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x1c, 0x0f, 0x07, 0x07, 0x00, 0x00 },	// U+2B0B (⬋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x3f, 0x12, 0x00, 0x00, 0x00 },	// U+2B0C (⬌)
	{ 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x0c, 0x0c, 0x0c, 0x3f, 0x1e, 0x0c, 0x00 },	// U+2B0D (⬍)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+2B0E (⬎)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x07, 0x00, 0x00 },	// U+2B0F (⬏)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x04, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00 },	// U+2B10 (⬐)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x15, 0x04, 0x04, 0x1c, 0x00, 0x00 },	// U+2B11 (⬑)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2B12 (⬒)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x1f, 0x1f, 0x1f, 0x00, 0x00 },	// U+2B13 (⬓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1d, 0x19, 0x11, 0x1f, 0x00, 0x00 },	// U+2B14 (⬔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x13, 0x17, 0x1f, 0x00, 0x00 },	// U+2B15 (⬕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x16, 0x37, 0x16, 0x0c, 0x00, 0x00 },	// U+2B16 (⬖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1a, 0x39, 0x1a, 0x0c, 0x00, 0x00 },	// U+2B17 (⬗)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x11, 0x0a, 0x04, 0x00, 0x00 },	// U+2B18 (⬘)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x1f, 0x0e, 0x04, 0x00, 0x00 },	// U+2B19 (⬙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x11, 0x00, 0x15, 0x00, 0x00 },	// U+2B1A (⬚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00 },	// U+2B1B (⬛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x11, 0x11, 0x11, 0x1f, 0x00, 0x00 },	// U+2B1C (⬜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2B1D (⬝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0e, 0x00, 0x00, 0x00 },	// U+2B1E (⬞)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x1f, 0x0e, 0x0e, 0x00, 0x00 },	// U+2B1F (⬟)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x11, 0x0a, 0x0e, 0x00, 0x00 },	// U+2B20 (⬠)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x00, 0x00 },	// U+2B21 (⬡)
	{ 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x1f, 0x1f, 0x0e, 0x04, 0x00, 0x00 },	// U+2B22 (⬢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x0e, 0x00, 0x00, 0x00 },	// U+2B23 (⬣)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x3f, 0x3f, 0x3f, 0x1e, 0x00, 0x00 },	// U+2B24 (⬤)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2B25 (⬥)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00 },	// U+2B26 (⬦)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x00 },	// U+2B27 (⬧)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x11, 0x0a, 0x0a, 0x04, 0x00 },	// U+2B28 (⬨)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x1f, 0x0e, 0x04, 0x00, 0x00, 0x00 },	// U+2B29 (⬩)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2B2A (⬪)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x0a, 0x11, 0x0a, 0x0a, 0x04, 0x00, 0x00 },	// U+2B2B (⬫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x0e, 0x00, 0x00, 0x00 },	// U+2B2C (⬬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x0e, 0x00, 0x00, 0x00 },	// U+2B2D (⬭)
	{ 0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x0e, 0x00, 0x00 },	// U+2B2E (⬮)
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+2B2F (⬯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x3f, 0x1a, 0x00, 0x00, 0x00 },	// U+2B30 (⬰)
	{ 0x02, 0x1f, 0x02, 0x00, 0x02, 0x1f, 0x02, 0x00, 0x02, 0x1f, 0x02, 0x00 },	// U+2B31 (⬱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x3f, 0x1a, 0x00, 0x00, 0x00 },	// U+2B32 (⬲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x17, 0x02, 0x00, 0x00, 0x00 },	// U+2B33 (⬳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x3f, 0x16, 0x10, 0x00, 0x00 },	// U+2B34 (⬴)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1e, 0x3f, 0x1e, 0x18, 0x00, 0x00 },	// U+2B35 (⬵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x1f, 0x16, 0x10, 0x00, 0x00 },	// U+2B36 (⬶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x1b, 0x26, 0x00, 0x00, 0x00 },	// U+2B37 (⬷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x15, 0x02, 0x04, 0x00, 0x00 },	// U+2B38 (⬸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x2a, 0x1f, 0x2a, 0x08, 0x00, 0x00 },	// U+2B39 (⬹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x2e, 0x1f, 0x2e, 0x0c, 0x00, 0x00 },	// U+2B3A (⬺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x1f, 0x26, 0x00, 0x00, 0x00 },	// U+2B3B (⬻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x2e, 0x1f, 0x2e, 0x08, 0x00, 0x00 },	// U+2B3C (⬼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3e, 0x1f, 0x3e, 0x18, 0x00, 0x00 },	// U+2B3D (⬽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x3f, 0x1a, 0x00, 0x00, 0x00 },	// U+2B3E (⬾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2f, 0x02, 0x00, 0x00, 0x00 },	// U+2B3F (⬿)
	{ 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x02, 0x1f, 0x02, 0x00, 0x00, 0x00 },	// U+2B40 (⭀)
	{ 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x02, 0x1f, 0x02, 0x00, 0x00, 0x00 },	// U+2B41 (⭁)
	{ 0x00, 0x00, 0x02, 0x1f, 0x02, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00 },	// U+2B42 (⭂)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x14, 0x3f, 0x14, 0x02, 0x01, 0x00 },	// U+2B43 (⭃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x14, 0x3f, 0x14, 0x03, 0x00, 0x00 },	// U+2B44 (⭄)
	{ 0x00, 0x00, 0x00, 0x08, 0x3c, 0x02, 0x3f, 0x02, 0x3c, 0x08, 0x00, 0x00 },	// U+2B45 (⭅)
	{ 0x00, 0x00, 0x00, 0x04, 0x0f, 0x10, 0x3f, 0x10, 0x0f, 0x04, 0x00, 0x00 },	// U+2B46 (⭆)
	{ 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x08, 0x1f, 0x08, 0x00, 0x00, 0x00 },	// U+2B47 (⭇)
	{ 0x00, 0x00, 0x08, 0x1f, 0x08, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00 },	// U+2B48 (⭈)
	{ 0x00, 0x00, 0x00, 0x16, 0x0d, 0x00, 0x02, 0x1f, 0x02, 0x00, 0x00, 0x00 },	// U+2B49 (⭉)
	{ 0x00, 0x00, 0x02, 0x1f, 0x02, 0x00, 0x16, 0x0d, 0x00, 0x16, 0x0d, 0x00 },	// U+2B4A (⭊)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x02, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2B4B (⭋)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1f, 0x08, 0x00, 0x16, 0x0d, 0x00, 0x00 },	// U+2B4C (⭌)
}; // 893

static const unsigned char orpb_block75[][12] = {
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x07, 0x02, 0x07, 0x02, 0x1e, 0x00, 0x00 },	// U+2C60 (Ⱡ)
	{ 0x00, 0x00, 0x00, 0x04, 0x06, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+2C61 (ⱡ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x16, 0x0d, 0x04, 0x04, 0x1c, 0x00, 0x00 },	// U+2C62 (Ɫ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x12, 0x17, 0x12, 0x0e, 0x02, 0x02, 0x00, 0x00 },	// U+2C63 (Ᵽ)
	{ 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x0f, 0x05, 0x09, 0x11, 0x05, 0x02 },	// U+2C64 (Ɽ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x0e, 0x18, 0x1e, 0x15, 0x1e, 0x02, 0x00 },	// U+2C65 (ⱥ)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x1f, 0x0c, 0x04, 0x04, 0x1a, 0x02, 0x00 },	// U+2C66 (ⱦ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x31, 0x20, 0x00 },	// U+2C67 (Ⱨ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x11, 0x31, 0x20, 0x00 },	// U+2C68 (ⱨ)
	{ 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x31, 0x20, 0x00 },	// U+2C69 (Ⱪ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x11, 0x09, 0x07, 0x09, 0x31, 0x20, 0x00 },	// U+2C6A (ⱪ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x3f, 0x20, 0x00 },	// U+2C6B (Ⱬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x08, 0x04, 0x02, 0x3f, 0x20, 0x00 },	// U+2C6C (ⱬ)
	{ 0x00, 0x00, 0x00, 0x16, 0x19, 0x11, 0x11, 0x11, 0x11, 0x2e, 0x00, 0x00 },	// U+2C6D (Ɑ)
	{ 0x00, 0x00, 0x00, 0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11, 0x14, 0x08 },	// U+2C6E (Ɱ)
	{ 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x0e, 0x00, 0x00 },	// U+2C6F (Ɐ)
}; // 16

static const unsigned char orpb_block76[][12] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x11, 0x11, 0x0a, 0x04, 0x00, 0x00 },	// U+2C71 (ⱱ)
	{ 0x00, 0x00, 0x00, 0x21, 0x11, 0x11, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+2C72 (Ⱳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x11, 0x15, 0x15, 0x0a, 0x00, 0x00 },	// U+2C73 (ⱳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x15, 0x13, 0x0a, 0x04, 0x00, 0x00 },	// U+2C74 (ⱴ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+2C75 (Ⱶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x02, 0x02, 0x00, 0x00 },	// U+2C76 (ⱶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x15, 0x15, 0x15, 0x0e, 0x00, 0x00 },	// U+2C77 (ⱷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0f, 0x01, 0x2e, 0x18, 0x00 },	// U+2C78 (ⱸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0c, 0x00, 0x00 },	// U+2C79 (ⱹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x15, 0x1b, 0x0e, 0x00, 0x00 },	// U+2C7A (ⱺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x10, 0x1c, 0x10, 0x1e, 0x00, 0x00 },	// U+2C7B (ⱻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x04, 0x04, 0x04, 0x05, 0x02 },	// U+2C7C (ⱼ)
	{ 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2C7D (ⱽ)
}; // 13

static const unsigned char orpb_block77[][12] = {
	{ 0x06, 0x03, 0x05, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE0 (ⷠ)
	{ 0x03, 0x05, 0x03, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE1 (ⷡ)
	{ 0x07, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE2 (ⷢ)
	{ 0x0e, 0x0a, 0x0a, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE3 (ⷣ)
	{ 0x15, 0x0e, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE4 (ⷤ)
	{ 0x03, 0x04, 0x02, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE5 (ⷥ)
	{ 0x05, 0x03, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE6 (ⷦ)
	{ 0x0e, 0x0a, 0x0a, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE7 (ⷧ)
	{ 0x05, 0x07, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE8 (ⷨ)
	{ 0x09, 0x0f, 0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DE9 (ⷩ)
	{ 0x06, 0x09, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DEA (ⷪ)
	{ 0x05, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DEB (ⷫ)
	{ 0x03, 0x05, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DEC (ⷬ)
	{ 0x06, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DED (ⷭ)
	{ 0x07, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DEE (ⷮ)
	{ 0x05, 0x02, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DEF (ⷯ)
	{ 0x05, 0x05, 0x05, 0x0d, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF0 (ⷰ)
	{ 0x05, 0x06, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF1 (ⷱ)
	{ 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF2 (ⷲ)
	{ 0x15, 0x15, 0x15, 0x35, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF3 (ⷳ)
	{ 0x06, 0x0b, 0x0d, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF4 (ⷴ)
	{ 0x3e, 0x11, 0x11, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF5 (ⷵ)
	{ 0x03, 0x06, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF6 (ⷶ)
	{ 0x06, 0x05, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF7 (ⷷ)
	{ 0x02, 0x07, 0x02, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF8 (ⷸ)
	{ 0x04, 0x05, 0x05, 0x02, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DF9 (ⷹ)
	{ 0x02, 0x07, 0x02, 0x06, 0x0a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFA (ⷺ)
	{ 0x19, 0x25, 0x27, 0x25, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFB (ⷻ)
	{ 0x0d, 0x11, 0x1f, 0x15, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFC (ⷼ)
	{ 0x04, 0x0a, 0x1f, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFD (ⷽ)
	{ 0x1f, 0x0a, 0x0e, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFE (ⷾ)
	{ 0x3f, 0x15, 0x1d, 0x2b, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2DFF (ⷿ)
}; // 32

static const unsigned char orpb_block78[][12] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x0a, 0x0a, 0x1f, 0x0a, 0x0a, 0x0a, 0x00, 0x00 },	// U+FB00 (ﬀ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x02, 0x1f, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+FB01 (ﬁ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x1f, 0x12, 0x12, 0x12, 0x00, 0x00 },	// U+FB02 (ﬂ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x15, 0x05, 0x1f, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+FB03 (ﬃ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x15, 0x15, 0x1f, 0x15, 0x15, 0x15, 0x00, 0x00 },	// U+FB04 (ﬄ)
	{ 0x00, 0x00, 0x00, 0x04, 0x0a, 0x1e, 0x0b, 0x0a, 0x0a, 0x12, 0x00, 0x00 },	// U+FB05 (ﬅ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x1e, 0x09, 0x0a, 0x0a, 0x11, 0x00, 0x00 },	// U+FB06 (ﬆ)
}; // 7

static const unsigned char orpb_block79[][12] = {
	{ 0x38, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE20 (︠)
	{ 0x07, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE21 (︡)
	{ 0x3e, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE22 (︢)
	{ 0x10, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE23 (︣)
}; // 4

static const unsigned char orpb_block80[][12] = {
	{ 0x00, 0x00, 0x0e, 0x1b, 0x15, 0x17, 0x1b, 0x1b, 0x1f, 0x1b, 0x0e, 0x00 },	// U+FFFD (�)
}; // 1

