/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font leggie-8x18.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char leggie_block1[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x00, 0x20, 0x20, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x08, 0x08, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x92, 0x4c, 0x20, 0x10, 0x08, 0x64, 0x92, 0x90, 0x60, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x22, 0x1c, 0x82, 0x42, 0x22, 0x52, 0x8c, 0x00, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x20, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x20 },	// U+0028 (()
	{ 0x00, 0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0xfe, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x50, 0x48, 0x44, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0xfe, 0x00, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x70, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xa0, 0x90, 0x88, 0x84, 0xfe, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x80, 0x40, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x7c, 0x00, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x40, 0x20, 0x10, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfa, 0x86, 0x86, 0x86, 0x86, 0x7a, 0x02, 0x02, 0x7c, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0xe2, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x82, 0x00, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x86, 0x8a, 0x92, 0xa2, 0xc2, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0xa2, 0x42, 0xbc, 0x00, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x42, 0x42, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x00, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38 },	// U+005B ([)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x80, 0x80, 0x00 },	// U+005C (\)
	{ 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38 },	// U+005D (])
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00 },	// U+005F (_)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x00, 0x70, 0x08, 0x08, 0x08, 0x08, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+0067 (g)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08 },	// U+006A (j)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x00, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x82, 0x00, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfa, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x08, 0x04, 0xfe, 0x00, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x00, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20 },	// U+007B ({)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+007C (|)
	{ 0x00, 0x00, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08 },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
}; // 95

static const unsigned char leggie_block2[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x10, 0x10, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x04, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0xfe, 0x00, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x54, 0x28, 0x44, 0x28, 0x54, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x7c, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+00A6 (¦)
	{ 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e },	// U+00A7 (§)
	{ 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xb2, 0x8a, 0x8a, 0x8a, 0xb2, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x48, 0x24, 0x12, 0x24, 0x48, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x7c, 0x82, 0x82, 0x9a, 0xaa, 0xaa, 0x9a, 0xaa, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x7e, 0x80, 0x80, 0x80, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x7e, 0x80, 0x80, 0x80, 0x80, 0x70, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x9e, 0x9e, 0x9e, 0x9e, 0x9c, 0x90, 0x90, 0x90, 0x90, 0x90, 0x00, 0x00, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x18 },	// U+00B8 (¸)
	{ 0x40, 0x60, 0x50, 0x48, 0x44, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x48, 0x90, 0x48, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x80, 0xc0, 0xa0, 0x90, 0xf8, 0x80, 0x80, 0x80 },	// U+00BC (¼)
	{ 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x7c, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0xfc },	// U+00BD (½)
	{ 0x00, 0x1e, 0x20, 0x20, 0x18, 0x20, 0x20, 0x20, 0x1e, 0x00, 0x80, 0xc0, 0xa0, 0x90, 0xf8, 0x80, 0x80, 0x80 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x10, 0x08, 0x04, 0x02, 0x02, 0xfc },	// U+00BF (¿)
	{ 0x04, 0x08, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x40, 0x20, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x0c, 0x92, 0x60, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x00, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x10, 0x28, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x11, 0x11, 0x11, 0x11, 0x71, 0x1f, 0x11, 0x11, 0x11, 0xf1, 0x00, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x10, 0x20, 0x18 },	// U+00C7 (Ç)
	{ 0x04, 0x08, 0x10, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x40, 0x20, 0x10, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x10, 0x28, 0x44, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x00, 0x44, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x04, 0x08, 0x10, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x40, 0x20, 0x10, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x10, 0x28, 0x44, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x00, 0x44, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x9f, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x0c, 0x92, 0x60, 0x00, 0x82, 0x82, 0x82, 0x86, 0x8a, 0x92, 0xa2, 0xc2, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x04, 0x08, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x40, 0x20, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x0c, 0x92, 0x60, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x00, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc2, 0xc2, 0xa2, 0xa2, 0x92, 0x8a, 0x8a, 0x86, 0x86, 0x7e, 0x00, 0x00, 0x00 },	// U+00D8 (Ø)
	{ 0x04, 0x08, 0x10, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x40, 0x20, 0x10, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x10, 0x28, 0x44, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x40, 0x20, 0x10, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x32, 0x42, 0x82, 0x82, 0x82, 0x82, 0x7a, 0x00, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x10, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x10, 0x10, 0xfe, 0x11, 0x11, 0xee, 0x00, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x10, 0x20, 0x18 },	// U+00E7 (ç)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x80, 0x4c, 0x30, 0x48, 0x44, 0x80, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x7e, 0x00, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+00FD (ý)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+00FF (ÿ)
	{ 0x00, 0x7c, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0101 (ā)
	{ 0x44, 0x44, 0x38, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x40, 0x40, 0x80 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x00 },	// U+0105 (ą)
	{ 0x40, 0x20, 0x10, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x10, 0x28, 0x44, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x00, 0x10, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+010B (ċ)
	{ 0x44, 0x28, 0x10, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+010D (č)
	{ 0x44, 0x28, 0x10, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0xc0, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x9f, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x00, 0x00, 0x80, 0x80, 0xf0, 0x80, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x00, 0x7c, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+0113 (ē)
	{ 0x44, 0x44, 0x38, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0114 (Ĕ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+0115 (ĕ)
	{ 0x00, 0x10, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x80, 0x80, 0x00 },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x40, 0x40, 0x80 },	// U+0119 (ę)
	{ 0x44, 0x28, 0x10, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+011B (ě)
	{ 0x10, 0x28, 0x44, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0xe2, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+011D (ĝ)
	{ 0x44, 0x44, 0x38, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0xe2, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+011F (ğ)
	{ 0x00, 0x10, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0xe2, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0xe2, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x10, 0x20, 0x18 },	// U+0122 (Ģ)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0x10, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+0123 (ģ)
	{ 0x10, 0x28, 0x44, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x00, 0x20, 0x50, 0x8a, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0xff, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x1f, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0x0c, 0x92, 0x60, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x00, 0x7c, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+012B (ī)
	{ 0x44, 0x44, 0x38, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+012C (Ĭ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+012D (ĭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x10, 0x10, 0x20 },	// U+012E (Į)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20 },	// U+012F (į)
	{ 0x00, 0x10, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0131 (ı)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0a, 0xf7, 0x00, 0x00, 0x00 },	// U+0132 (Ĳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x00, 0xc6, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x80, 0x80, 0x40 },	// U+0133 (ĳ)
	{ 0x40, 0xa0, 0x10, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08 },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x82, 0x10, 0x20, 0x18 },	// U+0136 (Ķ)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x10, 0x20, 0x18 },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x00, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x08, 0x04, 0x02, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x20, 0x10, 0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x10, 0x20, 0x18 },	// U+013B (Ļ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x10, 0x20, 0x18 },	// U+013C (ļ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x12, 0x0a, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x00, 0x00, 0x00, 0x88, 0x48, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+013E (ľ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x12, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+013F (Ŀ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+0140 (ŀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x12, 0x0a, 0x06, 0x02, 0x03, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x28, 0x18, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x40, 0x20, 0x10, 0x00, 0x82, 0x82, 0x82, 0x86, 0x8a, 0x92, 0xa2, 0xc2, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x86, 0x8a, 0x92, 0xa2, 0xc2, 0x82, 0x82, 0x82, 0x10, 0x20, 0x18 },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x10, 0x20, 0x18 },	// U+0146 (ņ)
	{ 0x44, 0x28, 0x10, 0x00, 0x82, 0x82, 0x82, 0x86, 0x8a, 0x92, 0xa2, 0xc2, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0148 (ň)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x01, 0x00, 0xfc, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0149 (ŉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x86, 0x8a, 0x92, 0xa2, 0xc2, 0x82, 0x82, 0x82, 0x80, 0x60, 0x00 },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x80, 0x60, 0x00 },	// U+014B (ŋ)
	{ 0x00, 0x7c, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+014D (ō)
	{ 0x44, 0x44, 0x38, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+014E (Ŏ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+014F (ŏ)
	{ 0x90, 0x48, 0x24, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x00, 0x00, 0x90, 0x48, 0x24, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x11, 0x11, 0x11, 0x11, 0x71, 0x11, 0x11, 0x11, 0x11, 0xfe, 0x00, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x11, 0x11, 0xf1, 0x11, 0x11, 0xee, 0x00, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x40, 0x20, 0x10, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x42, 0x42, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0xfa, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x42, 0x42, 0x82, 0x82, 0x10, 0x20, 0x18 },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfa, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x03 },	// U+0157 (ŗ)
	{ 0x44, 0x28, 0x10, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x42, 0x42, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0xfa, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x40, 0x20, 0x10, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+015B (ś)
	{ 0x10, 0x28, 0x44, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x10, 0x20, 0x18 },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x10, 0x20, 0x18 },	// U+015F (ş)
	{ 0x44, 0x28, 0x10, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x18 },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x10, 0x20, 0x18 },	// U+0163 (ţ)
	{ 0x44, 0x28, 0x10, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x00, 0x00, 0x80, 0x48, 0x28, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0x0c, 0x92, 0x60, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x00, 0x7c, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+016B (ū)
	{ 0x44, 0x44, 0x38, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x10, 0x28, 0x10, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+016F (ů)
	{ 0x90, 0x48, 0x24, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x00, 0x00, 0x90, 0x48, 0x24, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x10, 0x20, 0x18 },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x00 },	// U+0173 (ų)
	{ 0x10, 0x28, 0x44, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x10, 0x28, 0x44, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+0177 (ŷ)
	{ 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x40, 0x20, 0x10, 0x00, 0xfe, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x7e, 0x00, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x08, 0x04, 0xfe, 0x00, 0x00, 0x00 },	// U+017A (ź)
	{ 0x00, 0x10, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x08, 0x04, 0xfe, 0x00, 0x00, 0x00 },	// U+017C (ż)
	{ 0x44, 0x28, 0x10, 0x00, 0xfe, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x08, 0x04, 0xfe, 0x00, 0x00, 0x00 },	// U+017E (ž)
	{ 0x00, 0x00, 0x00, 0x00, 0x70, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+017F (ſ)
}; // 224

static const unsigned char leggie_block3[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x80, 0x80, 0xf0, 0x80, 0x80, 0x80, 0x80, 0xfe, 0x00, 0x00, 0x00 },	// U+018E (Ǝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0x80, 0x80, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+018F (Ə)
}; // 2

static const unsigned char leggie_block4[][18] = {
	{ 0x00, 0x00, 0x00, 0x70, 0x08, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06, 0x00 },	// U+0192 (ƒ)
}; // 1

static const unsigned char leggie_block5[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01A0 (Ơ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01A1 (ơ)
}; // 2

static const unsigned char leggie_block6[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01AF (Ư)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+01B0 (ư)
}; // 2

static const unsigned char leggie_block7[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x40, 0x20, 0x7c, 0x08, 0x04, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+01B5 (Ƶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x7c, 0x08, 0x04, 0xfe, 0x00, 0x00, 0x00 },	// U+01B6 (ƶ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x78, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+01B7 (Ʒ)
}; // 3

static const unsigned char leggie_block8[][18] = {
	{ 0x44, 0x28, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+01CD (Ǎ)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+01CE (ǎ)
	{ 0x44, 0x28, 0x10, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+01CF (Ǐ)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+01D0 (ǐ)
	{ 0x44, 0x28, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01D1 (Ǒ)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01D2 (ǒ)
	{ 0x44, 0x28, 0x10, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01D3 (Ǔ)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+01D4 (ǔ)
	{ 0x7c, 0x00, 0x44, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01D5 (Ǖ)
	{ 0x00, 0x00, 0x7c, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+01D6 (ǖ)
	{ 0x40, 0x20, 0x92, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01D7 (Ǘ)
	{ 0x40, 0x20, 0x10, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+01D8 (ǘ)
	{ 0x44, 0x28, 0x92, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01D9 (Ǚ)
	{ 0x44, 0x28, 0x10, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+01DA (ǚ)
	{ 0x04, 0x08, 0x92, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01DB (Ǜ)
	{ 0x04, 0x08, 0x10, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+01DC (ǜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfe, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+01DD (ǝ)
}; // 17

static const unsigned char leggie_block9[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0xe2, 0x82, 0xf2, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+01E4 (Ǥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x82, 0x82, 0xff, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+01E5 (ǥ)
	{ 0x44, 0x28, 0x10, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0xe2, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+01E6 (Ǧ)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+01E7 (ǧ)
	{ 0x44, 0x28, 0x10, 0x00, 0x82, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x82, 0x00, 0x00, 0x00 },	// U+01E8 (Ǩ)
	{ 0x44, 0x28, 0x10, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x00, 0x00, 0x00 },	// U+01E9 (ǩ)
}; // 6

static const unsigned char leggie_block10[][18] = {
	{ 0x44, 0x28, 0x10, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x78, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+01EE (Ǯ)
	{ 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x78, 0x80, 0x80, 0x80, 0x80, 0x7e },	// U+01EF (ǯ)
}; // 2

static const unsigned char leggie_block11[][18] = {
	{ 0x20, 0x10, 0x28, 0x10, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+01FA (Ǻ)
	{ 0x40, 0x20, 0x10, 0x00, 0x10, 0x28, 0x10, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+01FB (ǻ)
	{ 0x40, 0x20, 0x10, 0x00, 0xfe, 0x11, 0x11, 0x11, 0x11, 0x71, 0x1f, 0x11, 0x11, 0x11, 0xf1, 0x00, 0x00, 0x00 },	// U+01FC (Ǽ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0xee, 0x10, 0x10, 0xfe, 0x11, 0x11, 0xee, 0x00, 0x00, 0x00 },	// U+01FD (ǽ)
	{ 0x40, 0x20, 0x10, 0x00, 0xfc, 0xc2, 0xc2, 0xa2, 0xa2, 0x92, 0x8a, 0x8a, 0x86, 0x86, 0x7e, 0x00, 0x00, 0x00 },	// U+01FE (Ǿ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0xfc, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x7e, 0x00, 0x00, 0x00 },	// U+01FF (ǿ)
}; // 6

static const unsigned char leggie_block12[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x10, 0x08 },	// U+0218 (Ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x00, 0x10, 0x08 },	// U+0219 (ș)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x08 },	// U+021A (Ț)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x10, 0x08 },	// U+021B (ț)
}; // 4

static const unsigned char leggie_block13[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+0250 (ɐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0251 (ɑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0252 (ɒ)
	{ 0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0253 (ɓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0254 (ɔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x42, 0xa2, 0x7c, 0x20, 0x20, 0x00 },	// U+0255 (ɕ)
	{ 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x00, 0x00 },	// U+0256 (ɖ)
	{ 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0257 (ɗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x80, 0x80, 0x7c, 0x00, 0x00, 0x00 },	// U+0258 (ɘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfe, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0259 (ə)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0xff, 0x41, 0x41, 0x3e, 0x00, 0x00, 0x00 },	// U+025A (ɚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x1c, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+025B (ɛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x70, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+025C (ɜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x40, 0xc0, 0x38, 0x40, 0x40, 0x3f, 0x00, 0x00, 0x00 },	// U+025D (ɝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x72, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+025E (ɞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08 },	// U+025F (ɟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+0260 (ɠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0xc2, 0xa2, 0x9c, 0x80, 0x80, 0x78 },	// U+0261 (ɡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0xe2, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0262 (ɢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x28, 0x28, 0x10 },	// U+0263 (ɣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0264 (ɤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80 },	// U+0265 (ɥ)
	{ 0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0266 (ɦ)
	{ 0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x60, 0x00, 0x00 },	// U+0267 (ɧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0268 (ɨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+0269 (ɩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+026A (ɪ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x9c, 0x72, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+026B (ɫ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x1c, 0x12, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+026C (ɬ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x40, 0x40, 0x80 },	// U+026D (ɭ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x42, 0x22, 0x12, 0x7a, 0x82, 0x8c, 0x80, 0x84, 0x78 },	// U+026E (ɮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0xec, 0x00, 0x00, 0x00 },	// U+026F (ɯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0xec, 0x80, 0x80, 0x80 },	// U+0270 (ɰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x82, 0x80, 0x40, 0x00 },	// U+0271 (ɱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x02, 0x01, 0x00 },	// U+0272 (ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x80, 0x00, 0x00 },	// U+0273 (ɳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x86, 0x8a, 0x92, 0xa2, 0xc2, 0x82, 0x00, 0x00, 0x00 },	// U+0274 (ɴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0275 (ɵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x11, 0x11, 0x71, 0x11, 0x11, 0xfe, 0x00, 0x00, 0x00 },	// U+0276 (ɶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00 },	// U+0277 (ɷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10 },	// U+0278 (ɸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xbe, 0x00, 0x00, 0x00 },	// U+0279 (ɹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xbe, 0x00, 0x00, 0x00 },	// U+027A (ɺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xbe, 0x80, 0x00, 0x00 },	// U+027B (ɻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfa, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02 },	// U+027C (ɼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfa, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x00 },	// U+027D (ɽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00 },	// U+027E (ɾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x40, 0xe0, 0x00, 0x00, 0x00 },	// U+027F (ɿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x7e, 0x22, 0x42, 0x82, 0x00, 0x00, 0x00 },	// U+0280 (ʀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x42, 0x22, 0x7e, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0281 (ʁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x02, 0x04, 0x00 },	// U+0282 (ʂ)
	{ 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e },	// U+0283 (ʃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x18, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08 },	// U+0284 (ʄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xe0 },	// U+0285 (ʅ)
	{ 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x12, 0x0c },	// U+0286 (ʆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x78, 0x20, 0x20, 0x20 },	// U+0287 (ʇ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x40, 0x40, 0x80 },	// U+0288 (ʈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0xff, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0289 (ʉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+028A (ʊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+028B (ʋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+028C (ʌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+028D (ʍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+028E (ʎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+028F (ʏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x08, 0x04, 0xfe, 0x80, 0x80, 0x00 },	// U+0290 (ʐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x48, 0xa4, 0x7e, 0x20, 0x20, 0x00 },	// U+0291 (ʑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x78, 0x80, 0x80, 0x80, 0x80, 0x7e },	// U+0292 (ʒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x78, 0x80, 0x84, 0x8a, 0x7c, 0x08 },	// U+0293 (ʓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x40, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0294 (ʔ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0295 (ʕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x40, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0296 (ʖ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc },	// U+0297 (ʗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x92, 0xba, 0x92, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0298 (ʘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x7e, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0299 (ʙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x9c, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+029A (ʚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xfc, 0x02, 0x02, 0xe2, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+029B (ʛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+029C (ʜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x08 },	// U+029D (ʝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0x40, 0x40, 0x40 },	// U+029E (ʞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+029F (ʟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80 },	// U+02A0 (ʠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x40, 0x20, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+02A1 (ʡ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x04, 0x08, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+02A2 (ʢ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x11, 0x91, 0x51, 0x31, 0x11, 0xfe, 0x00, 0x00, 0x00 },	// U+02A3 (ʣ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x11, 0x91, 0x51, 0xf1, 0x11, 0x1e, 0x00, 0x00, 0xf0 },	// U+02A4 (ʤ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x11, 0x91, 0x51, 0xb1, 0x51, 0xfe, 0x40, 0x40, 0x00 },	// U+02A5 (ʥ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0xef, 0x12, 0x12, 0xe2, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+02A6 (ʦ)
	{ 0x00, 0x00, 0x00, 0xc2, 0x22, 0x22, 0x22, 0x22, 0x2f, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+02A7 (ʧ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0xef, 0x12, 0x12, 0x12, 0x92, 0x52, 0xfc, 0x40, 0x40, 0x00 },	// U+02A8 (ʨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x82, 0x60, 0x00, 0x00 },	// U+02A9 (ʩ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0xe1, 0x11, 0x11, 0xe1, 0x01, 0x01, 0xfe, 0x00, 0x00, 0x00 },	// U+02AA (ʪ)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0xf1, 0x01, 0x81, 0x41, 0x21, 0x11, 0xfe, 0x00, 0x00, 0x00 },	// U+02AB (ʫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x54, 0x28, 0x00, 0x82, 0x54, 0x28, 0x00, 0x00, 0x00 },	// U+02AC (ʬ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x00, 0xfe, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+02AD (ʭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80 },	// U+02AE (ʮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x00 },	// U+02AF (ʯ)
	{ 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B0 (ʰ)
	{ 0x04, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B1 (ʱ)
	{ 0x00, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+02B2 (ʲ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfa, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B3 (ʳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B4 (ʴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B5 (ʵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x42, 0x22, 0x7e, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B6 (ʶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B7 (ʷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78, 0x00, 0x00, 0x00, 0x00 },	// U+02B8 (ʸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B9 (ʹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x48, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BA (ʺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BB (ʻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BC (ʼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BD (ʽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BE (ʾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BF (ʿ)
	{ 0x7e, 0x80, 0x80, 0x80, 0x40, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C0 (ˀ)
	{ 0xfc, 0x02, 0x02, 0x02, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C1 (ˁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x30, 0x0e, 0x30, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C2 (˂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0xe0, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C3 (˃)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C4 (˄)
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C5 (˅)
	{ 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C6 (ˆ)
	{ 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C7 (ˇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C8 (ˈ)
	{ 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C9 (ˉ)
	{ 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02CA (ˊ)
	{ 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02CB (ˋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10 },	// U+02CC (ˌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc },	// U+02CD (ˍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40 },	// U+02CE (ˎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04 },	// U+02CF (ˏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x00, 0x00, 0x00, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+02D0 (ː)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D1 (ˑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+02D2 (˒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+02D3 (˓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D4 (˔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+02D5 (˕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+02D6 (˖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D7 (˗)
	{ 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D8 (˘)
	{ 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D9 (˙)
	{ 0x10, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DA (˚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20 },	// U+02DB (˛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DC (˜)
	{ 0x90, 0x48, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DD (˝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+02DE (˞)
	{ 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DF (˟)
	{ 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E0 (ˠ)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E1 (ˡ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E2 (ˢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E3 (ˣ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x04, 0x08, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E4 (ˤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+02E5 (˥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xfe, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+02E6 (˦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0xfe, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+02E7 (˧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xfe, 0x80, 0x00, 0x00, 0x00 },	// U+02E8 (˨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xfe, 0x00, 0x00, 0x00 },	// U+02E9 (˩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+02EA (˪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0xfe, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+02EB (˫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x00 },	// U+02EC (ˬ)
	{ 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02ED (˭)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02EE (ˮ)
}; // 159

static const unsigned char leggie_block14[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10 },	// U+037A (ͺ)
}; // 1

static const unsigned char leggie_block15[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00 },	// U+037E (;)
}; // 1

static const unsigned char leggie_block16[][18] = {
	{ 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0384 (΄)
	{ 0x40, 0x20, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0385 (΅)
	{ 0x00, 0x00, 0x04, 0x02, 0x7d, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0386 (Ά)
}; // 3

static const unsigned char leggie_block17[][18] = {
	{ 0x00, 0x00, 0x04, 0x02, 0xfd, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0388 (Έ)
	{ 0x00, 0x00, 0x04, 0x02, 0x81, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0389 (Ή)
	{ 0x00, 0x00, 0x08, 0x04, 0x3a, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+038A (Ί)
}; // 3

static const unsigned char leggie_block18[][18] = {
	{ 0x00, 0x00, 0x04, 0x02, 0x7d, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+038C (Ό)
}; // 1

static const unsigned char leggie_block19[][18] = {
	{ 0x00, 0x00, 0x04, 0x02, 0x81, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+038E (Ύ)
	{ 0x00, 0x00, 0x04, 0x02, 0x7d, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0xee, 0x00, 0x00, 0x00 },	// U+038F (Ώ)
	{ 0x40, 0x20, 0x10, 0x00, 0x00, 0x28, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+0390 (ΐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0391 (Α)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0392 (Β)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0393 (Γ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x44, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+0394 (Δ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0395 (Ε)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0396 (Ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0397 (Η)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0398 (Θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+0399 (Ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x82, 0x00, 0x00, 0x00 },	// U+039A (Κ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x44, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+039B (Λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+039C (Μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x86, 0x8a, 0x92, 0xa2, 0xc2, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+039D (Ν)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00 },	// U+039E (Ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+039F (Ο)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+03A0 (Π)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+03A1 (Ρ)
}; // 20

static const unsigned char leggie_block20[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+03A3 (Σ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+03A4 (Τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+03A5 (Υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x00, 0x00, 0x00 },	// U+03A6 (Φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+03A7 (Χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+03A8 (Ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0xee, 0x00, 0x00, 0x00 },	// U+03A9 (Ω)
	{ 0x00, 0x44, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+03AA (Ϊ)
	{ 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+03AB (Ϋ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0xbc, 0x42, 0x42, 0x42, 0x42, 0x42, 0xbc, 0x00, 0x00, 0x00 },	// U+03AC (ά)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x1c, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+03AD (έ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x80, 0x80, 0x80 },	// U+03AE (ή)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+03AF (ί)
	{ 0x40, 0x20, 0x10, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+03B0 (ΰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0x42, 0x42, 0x42, 0x42, 0x42, 0xbc, 0x00, 0x00, 0x00 },	// U+03B1 (α)
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x32, 0x42, 0x82, 0x82, 0x82, 0x82, 0x7a, 0x02, 0x02, 0x02 },	// U+03B2 (β)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10 },	// U+03B3 (γ)
	{ 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x04, 0x08, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+03B4 (δ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x1c, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+03B5 (ε)
	{ 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x00 },	// U+03B6 (ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x80, 0x80, 0x80 },	// U+03B7 (η)
	{ 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+03B8 (θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+03B9 (ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x00, 0x00, 0x00 },	// U+03BA (κ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+03BB (λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02 },	// U+03BC (μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x82, 0x84, 0x84, 0x48, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+03BD (ν)
	{ 0x00, 0x00, 0x00, 0xfc, 0x08, 0x04, 0x04, 0x78, 0x08, 0x04, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x00 },	// U+03BE (ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+03BF (ο)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x44, 0x44, 0x44, 0x44, 0xc2, 0x00, 0x00, 0x00 },	// U+03C0 (π)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02 },	// U+03C1 (ρ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x00 },	// U+03C2 (ς)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x32, 0x42, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+03C3 (σ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+03C4 (τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+03C5 (υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10 },	// U+03C6 (φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0x90, 0x50, 0x50, 0x30, 0x18, 0x14, 0x14, 0x12, 0xe2 },	// U+03C7 (χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10 },	// U+03C8 (ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x82, 0x82, 0x82, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00 },	// U+03C9 (ω)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+03CA (ϊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+03CB (ϋ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+03CC (ό)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+03CD (ύ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x44, 0x82, 0x82, 0x82, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00 },	// U+03CE (ώ)
}; // 44

static const unsigned char leggie_block21[][18] = {
	{ 0x04, 0x08, 0x10, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0400 (Ѐ)
	{ 0x00, 0x44, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0401 (Ё)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x60, 0x00, 0x00 },	// U+0402 (Ђ)
	{ 0x40, 0x20, 0x10, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0403 (Ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0404 (Є)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0405 (Ѕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+0406 (І)
	{ 0x00, 0x44, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+0407 (Ї)
	{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0408 (Ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0xe2, 0x22, 0x22, 0x22, 0x22, 0xe1, 0x00, 0x00, 0x00 },	// U+0409 (Љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0xff, 0x11, 0x11, 0x11, 0x11, 0xf1, 0x00, 0x00, 0x00 },	// U+040A (Њ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+040B (Ћ)
	{ 0x40, 0x20, 0x10, 0x00, 0x82, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x82, 0x00, 0x00, 0x00 },	// U+040C (Ќ)
	{ 0x04, 0x08, 0x10, 0x00, 0x82, 0x82, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+040D (Ѝ)
	{ 0x44, 0x44, 0x38, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x80, 0x70, 0x00, 0x00, 0x00 },	// U+040E (Ў)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x10, 0x10, 0x00 },	// U+040F (Џ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0410 (А)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0411 (Б)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0412 (В)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0413 (Г)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xff, 0x01, 0x01, 0x00 },	// U+0414 (Д)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0415 (Е)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x11, 0x00, 0x00, 0x00 },	// U+0416 (Ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x70, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0417 (З)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0418 (И)
	{ 0x44, 0x44, 0x38, 0x00, 0x82, 0x82, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0419 (Й)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x82, 0x00, 0x00, 0x00 },	// U+041A (К)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x82, 0x00, 0x00, 0x00 },	// U+041B (Л)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+041C (М)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+041D (Н)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+041E (О)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+041F (П)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0420 (Р)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0421 (С)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0422 (Т)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x80, 0x70, 0x00, 0x00, 0x00 },	// U+0423 (У)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x00, 0x00, 0x00 },	// U+0424 (Ф)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0425 (Х)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+0426 (Ц)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+0427 (Ч)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00, 0x00 },	// U+0428 (Ш)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00, 0x00 },	// U+0429 (Щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+042A (Ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x9e, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0x9e, 0x00, 0x00, 0x00 },	// U+042B (Ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+042C (Ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0xf0, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+042D (Э)
	{ 0x00, 0x00, 0x00, 0x00, 0x72, 0x8a, 0x8a, 0x8a, 0x8a, 0x8e, 0x8a, 0x8a, 0x8a, 0x8a, 0x72, 0x00, 0x00, 0x00 },	// U+042E (Ю)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x84, 0x84, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+042F (Я)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0430 (а)
	{ 0x00, 0x00, 0x00, 0x80, 0x78, 0x04, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0431 (б)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x7e, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0432 (в)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0433 (г)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfe, 0x82, 0x00, 0x00 },	// U+0434 (д)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+0435 (е)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x92, 0x92, 0x7c, 0x92, 0x92, 0x11, 0x00, 0x00, 0x00 },	// U+0436 (ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x70, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0437 (з)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x00, 0x00, 0x00 },	// U+0438 (и)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x00, 0x00, 0x00 },	// U+0439 (й)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x00, 0x00, 0x00 },	// U+043A (к)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x84, 0x84, 0x84, 0x84, 0x84, 0x82, 0x00, 0x00, 0x00 },	// U+043B (л)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+043C (м)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+043D (н)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+043E (о)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+043F (п)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02 },	// U+0440 (р)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0441 (с)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0442 (т)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+0443 (у)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10 },	// U+0444 (ф)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00 },	// U+0445 (х)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xfe, 0x80, 0x80, 0x00 },	// U+0446 (ц)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+0447 (ч)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00, 0x00 },	// U+0448 (ш)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00, 0x00 },	// U+0449 (щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+044A (ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x9e, 0xa2, 0xa2, 0x9e, 0x00, 0x00, 0x00 },	// U+044B (ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+044C (ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0xf0, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+044D (э)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x8a, 0x8a, 0x8e, 0x8a, 0x8a, 0x72, 0x00, 0x00, 0x00 },	// U+044E (ю)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0xfc, 0x84, 0x82, 0x00, 0x00, 0x00 },	// U+044F (я)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+0450 (ѐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+0451 (ё)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x1f, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x80, 0x60, 0x00 },	// U+0452 (ђ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0453 (ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x1e, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0454 (є)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0455 (ѕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0456 (і)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0457 (ї)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08 },	// U+0458 (ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0xf2, 0x12, 0x12, 0xf1, 0x00, 0x00, 0x00 },	// U+0459 (љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0xff, 0x11, 0x11, 0xf1, 0x00, 0x00, 0x00 },	// U+045A (њ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x1f, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+045B (ћ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x00, 0x00, 0x00 },	// U+045C (ќ)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x00, 0x00, 0x00 },	// U+045D (ѝ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+045E (ў)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x10, 0x10, 0x10 },	// U+045F (џ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00 },	// U+0460 (Ѡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00 },	// U+0461 (ѡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0462 (Ѣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x02, 0x7e, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+0463 (ѣ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf2, 0x0a, 0x0a, 0x0a, 0x0a, 0x3e, 0x0a, 0x0a, 0x0a, 0x0a, 0xf2, 0x00, 0x00, 0x00 },	// U+0464 (Ѥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf2, 0x0a, 0x0a, 0x3e, 0x0a, 0x0a, 0xf2, 0x00, 0x00, 0x00 },	// U+0465 (ѥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00 },	// U+0466 (Ѧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00 },	// U+0467 (ѧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x72, 0x8a, 0x8a, 0x8a, 0x8a, 0xfe, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00 },	// U+0468 (Ѩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x8a, 0x8a, 0xfe, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00 },	// U+0469 (ѩ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x28, 0x10, 0x38, 0x54, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00 },	// U+046A (Ѫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x28, 0x10, 0x38, 0x54, 0x92, 0x92, 0x00, 0x00, 0x00 },	// U+046B (ѫ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfa, 0x8a, 0x52, 0x22, 0x7e, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00 },	// U+046C (Ѭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfa, 0x52, 0x22, 0x7e, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00 },	// U+046D (ѭ)
	{ 0x00, 0x00, 0x28, 0x10, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x70, 0x80, 0x80, 0x80, 0x80, 0x7c, 0x02, 0x02, 0xfc },	// U+046E (Ѯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x7e, 0x80, 0x80, 0x70, 0x80, 0x80, 0x7c, 0x02, 0x02, 0xfc },	// U+046F (ѯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0470 (Ѱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10 },	// U+0471 (ѱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0472 (Ѳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0473 (ѳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0474 (Ѵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0475 (ѵ)
	{ 0x12, 0x24, 0x48, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0476 (Ѷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x48, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0477 (ѷ)
}; // 120

static const unsigned char leggie_block22[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x80, 0x80, 0x80 },	// U+0480 (Ҁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x80, 0x80, 0x80 },	// U+0481 (ҁ)
}; // 2

static const unsigned char leggie_block23[][18] = {
	{ 0x44, 0x44, 0x38, 0x00, 0x82, 0x82, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+048A (Ҋ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x00, 0x00, 0x00 },	// U+048B (ҋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+048C (Ҍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x02, 0x7e, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+048D (ҍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0xa2, 0x42, 0xbe, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+048E (Ҏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0xa2, 0x42, 0xbe, 0x02, 0x02, 0x02 },	// U+048F (ҏ)
	{ 0x00, 0x00, 0x80, 0x80, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0490 (Ґ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0491 (ґ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1f, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0492 (Ғ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x1f, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0493 (ғ)
}; // 10

static const unsigned char leggie_block24[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x11, 0x00, 0x00, 0x00 },	// U+0496 (Җ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x92, 0x92, 0x7c, 0x92, 0x92, 0x11, 0x00, 0x00, 0x00 },	// U+0497 (җ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x70, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x10, 0x10, 0x00 },	// U+0498 (Ҙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x70, 0x80, 0x80, 0x7e, 0x10, 0x10, 0x00 },	// U+0499 (ҙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x82, 0x80, 0x80, 0x00 },	// U+049A (Қ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x40, 0x40, 0x00 },	// U+049B (қ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x42, 0x2a, 0x1a, 0x0a, 0x0e, 0x0a, 0x1a, 0x2a, 0x42, 0x82, 0x00, 0x00, 0x00 },	// U+049C (Ҝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x2a, 0x1a, 0x0e, 0x1a, 0x2a, 0x42, 0x00, 0x00, 0x00 },	// U+049D (ҝ)
}; // 8

static const unsigned char leggie_block25[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x84, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x84, 0x04, 0x00, 0x00, 0x00 },	// U+04A0 (Ҡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0x48, 0x28, 0x18, 0x28, 0x48, 0x88, 0x00, 0x00, 0x00 },	// U+04A1 (ҡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+04A2 (Ң)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0xc2, 0x80, 0x80, 0x00 },	// U+04A3 (ң)
}; // 4

static const unsigned char leggie_block26[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x10, 0x10, 0x00 },	// U+04AA (Ҫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x10, 0x10, 0x00 },	// U+04AB (ҫ)
}; // 2

static const unsigned char leggie_block27[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+04AE (Ү)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10 },	// U+04AF (ү)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+04B0 (Ұ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x7c, 0x10, 0x10 },	// U+04B1 (ұ)
}; // 4

static const unsigned char leggie_block28[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+04BA (Һ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+04BB (һ)
}; // 2

static const unsigned char leggie_block29[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+04C0 (Ӏ)
}; // 1

static const unsigned char leggie_block30[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x82, 0x00, 0x00, 0x00 },	// U+04C5 (Ӆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x84, 0x84, 0x84, 0x84, 0x84, 0x82, 0x00, 0x00, 0x00 },	// U+04C6 (ӆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x80, 0x60, 0x00 },	// U+04C7 (Ӈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x80, 0x60, 0x00 },	// U+04C8 (ӈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+04C9 (Ӊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+04CA (ӊ)
}; // 6

static const unsigned char leggie_block31[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+04CD (Ӎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+04CE (ӎ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+04CF (ӏ)
	{ 0x44, 0x44, 0x38, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+04D0 (Ӑ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+04D1 (ӑ)
	{ 0x00, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+04D2 (Ӓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+04D3 (ӓ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x11, 0x11, 0x11, 0x11, 0x71, 0x1f, 0x11, 0x11, 0x11, 0xf1, 0x00, 0x00, 0x00 },	// U+04D4 (Ӕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x10, 0x10, 0xfe, 0x11, 0x11, 0xee, 0x00, 0x00, 0x00 },	// U+04D5 (ӕ)
	{ 0x44, 0x44, 0x38, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+04D6 (Ӗ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+04D7 (ӗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0x80, 0x80, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+04D8 (Ә)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfe, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+04D9 (ә)
}; // 13

static const unsigned char leggie_block32[][18] = {
	{ 0x00, 0x7c, 0x00, 0x00, 0x82, 0x82, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+04E2 (Ӣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x00, 0x00, 0x00 },	// U+04E3 (ӣ)
}; // 2

static const unsigned char leggie_block33[][18] = {
	{ 0x00, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+04E6 (Ӧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+04E7 (ӧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+04E8 (Ө)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+04E9 (ө)
}; // 4

static const unsigned char leggie_block34[][18] = {
	{ 0x00, 0x44, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0xf0, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+04EC (Ӭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x7e, 0x80, 0x80, 0xf0, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+04ED (ӭ)
	{ 0x00, 0x7c, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x80, 0x70, 0x00, 0x00, 0x00 },	// U+04EE (Ӯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+04EF (ӯ)
	{ 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x80, 0x70, 0x00, 0x00, 0x00 },	// U+04F0 (Ӱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+04F1 (ӱ)
	{ 0x90, 0x48, 0x24, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x80, 0x70, 0x00, 0x00, 0x00 },	// U+04F2 (Ӳ)
	{ 0x00, 0x00, 0x00, 0x90, 0x48, 0x24, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+04F3 (ӳ)
}; // 8

static const unsigned char leggie_block35[][18] = {
	{ 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x9e, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0x9e, 0x00, 0x00, 0x00 },	// U+04F8 (Ӹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x9e, 0xa2, 0xa2, 0x9e, 0x00, 0x00, 0x00 },	// U+04F9 (ӹ)
}; // 2

static const unsigned char leggie_block36[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0xa2, 0x42, 0xbc, 0x00, 0x00, 0x00 },	// U+0531 (Ա)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0532 (Բ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xfc, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+0533 (Գ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+0534 (Դ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+0535 (Ե)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x80, 0x80, 0x80, 0x82, 0x42, 0xfe, 0x00, 0x00, 0x00 },	// U+0536 (Զ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0537 (Է)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+0538 (Ը)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0xe2, 0x92, 0x92, 0x92, 0x92, 0x62, 0x00, 0x00, 0x00 },	// U+0539 (Թ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0xfc, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00 },	// U+053A (Ժ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+053B (Ի)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+053C (Լ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x9e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x62, 0x00, 0x00, 0x00 },	// U+053D (Խ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe2, 0x12, 0x12, 0x7e, 0x88, 0x84, 0x84, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+053E (Ծ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+053F (Կ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x80, 0xc0, 0x30, 0x0c, 0x02, 0x0c, 0x30, 0xc0, 0x00, 0x00, 0x00 },	// U+0540 (Հ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x80, 0x80, 0x80, 0x80, 0x9c, 0xa2, 0x42, 0xbc, 0x00, 0x00, 0x00 },	// U+0541 (Ձ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xe0, 0x00, 0x00, 0x00 },	// U+0542 (Ղ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc4, 0x28, 0x28, 0x10, 0x18, 0x28, 0x24, 0x44, 0x42, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+0543 (Ճ)
	{ 0x00, 0x00, 0x00, 0x00, 0xc2, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00 },	// U+0544 (Մ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0545 (Յ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x84, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00 },	// U+0546 (Ն)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x60, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0547 (Շ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0548 (Ո)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x80, 0x80, 0x80, 0x80, 0x7c, 0x06, 0x18, 0x60, 0x00, 0x00, 0x00 },	// U+0549 (Չ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+054A (Պ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x84, 0x88, 0x90, 0x62, 0xfe, 0x00, 0x00, 0x00 },	// U+054B (Ջ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xc2, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00 },	// U+054C (Ռ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+054D (Ս)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0xc0, 0x00, 0x00, 0x00 },	// U+054E (Վ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+054F (Տ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0550 (Ր)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+0551 (Ց)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0552 (Ւ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x00, 0x00, 0x00 },	// U+0553 (Փ)
	{ 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x84, 0x84, 0x84, 0x7c, 0x04, 0x04, 0xfe, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0554 (Ք)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0555 (Օ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x7c, 0x90, 0x90, 0x90, 0x90, 0x7e, 0x00, 0x00, 0x00 },	// U+0556 (Ֆ)
}; // 38

static const unsigned char leggie_block37[][18] = {
	{ 0x00, 0x10, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0559 (ՙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055A (՚)
	{ 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055B (՛)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x38, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055C (՜)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055D (՝)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055E (՞)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+055F (՟)
}; // 7

static const unsigned char leggie_block38[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xec, 0x00, 0x00, 0x00 },	// U+0561 (ա)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x02, 0x02, 0x02, 0xfe, 0x02, 0x02, 0x02 },	// U+0562 (բ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0xfc, 0x20, 0x20, 0x20 },	// U+0563 (գ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0xc2, 0x40, 0x40, 0x40 },	// U+0564 (դ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x02, 0x02, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0565 (ե)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0xe0 },	// U+0566 (զ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0567 (է)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x02, 0x02, 0xfe },	// U+0568 (ը)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0xf2, 0x8a, 0x8a, 0x8a, 0x72, 0x02, 0x02, 0x02 },	// U+0569 (թ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0xfc, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+056A (ժ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x02, 0x02, 0x02 },	// U+056B (ի)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38 },	// U+056C (լ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x62, 0x02, 0x02, 0x02 },	// U+056D (խ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x02, 0x02, 0x04, 0x08, 0xfc, 0x22, 0x42, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+056E (ծ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80 },	// U+056F (կ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0570 (հ)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x18, 0x20, 0x10, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+0571 (ձ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40, 0xc0 },	// U+0572 (ղ)
	{ 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x08, 0x08, 0x7e, 0x84, 0x84, 0x82, 0x82, 0xc2, 0xbc, 0x00, 0x00, 0x00 },	// U+0573 (ճ)
	{ 0x00, 0x00, 0x00, 0xc0, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00 },	// U+0574 (մ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08 },	// U+0575 (յ)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0xf8, 0x00, 0x00, 0x00 },	// U+0576 (ն)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0xfe },	// U+0577 (շ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+0578 (ո)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0xfc, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0xfe },	// U+0579 (չ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0xec, 0x80, 0x80, 0x80 },	// U+057A (պ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x08, 0x04, 0xfe },	// U+057B (ջ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x42, 0x22, 0xf2, 0x00, 0x00, 0x00 },	// U+057C (ռ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+057D (ս)
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x40, 0xc0, 0x00 },	// U+057E (վ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x92, 0x92, 0x92, 0x92, 0x92, 0x9c, 0x00, 0x00, 0x00 },	// U+057F (տ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x02, 0x02, 0x02 },	// U+0580 (ր)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x7c },	// U+0581 (ց)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x00, 0x00, 0x00 },	// U+0582 (ւ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x72, 0x92, 0x92, 0x92, 0x92, 0x92, 0x9c, 0x10, 0x10, 0x10 },	// U+0583 (փ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x78, 0x08, 0x08, 0xfe },	// U+0584 (ք)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0585 (օ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x7c, 0x90, 0x90, 0x90, 0x90, 0x7e, 0x10, 0x10, 0x10 },	// U+0586 (ֆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0xfc, 0x00, 0x00, 0x00 },	// U+0587 (և)
}; // 39

static const unsigned char leggie_block39[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+0589 (։)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+058A (֊)
}; // 2

static const unsigned char leggie_block40[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x09, 0x09, 0xf9, 0x29, 0x3f, 0x21, 0x21, 0xfe, 0x00, 0x00, 0x00 },	// U+058D (֍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x21, 0x21, 0x3f, 0x29, 0xf9, 0x09, 0x09, 0xfe, 0x00, 0x00, 0x00 },	// U+058E (֎)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x20, 0x20, 0x20, 0xf8, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+058F (֏)
}; // 3

static const unsigned char leggie_block41[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x84, 0x88, 0x54, 0x22, 0x42, 0x82, 0x00, 0x00, 0x00 },	// U+05D0 (א)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x40, 0xfe, 0x00, 0x00, 0x00 },	// U+05D1 (ב)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x40, 0xbe, 0x00, 0x00, 0x00 },	// U+05D2 (ג)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+05D3 (ד)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+05D4 (ה)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+05D5 (ו)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x40, 0x20, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+05D6 (ז)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+05D7 (ח)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+05D8 (ט)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+05D9 (י)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },	// U+05DA (ך)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+05DB (כ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xfe, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00 },	// U+05DC (ל)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+05DD (ם)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x8c, 0x88, 0x84, 0x84, 0x82, 0xfa, 0x00, 0x00, 0x00 },	// U+05DE (מ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+05DF (ן)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0xfe, 0x00, 0x00, 0x00 },	// U+05E0 (נ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+05E1 (ס)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x84, 0x84, 0x88, 0x88, 0x7e, 0x00, 0x00, 0x00 },	// U+05E2 (ע)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x9c, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },	// U+05E3 (ף)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x9c, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+05E4 (פ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x84, 0x88, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+05E5 (ץ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x84, 0x88, 0x50, 0x20, 0x20, 0xfe, 0x00, 0x00, 0x00 },	// U+05E6 (צ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x80, 0x42, 0x22, 0x12, 0x02, 0x02, 0x02 },	// U+05E7 (ק)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+05E8 (ר)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x8e, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+05E9 (ש)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x88, 0x88, 0x88, 0x88, 0x88, 0x86, 0x00, 0x00, 0x00 },	// U+05EA (ת)
}; // 27

static const unsigned char leggie_block42[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x7e, 0x82, 0x82, 0x92, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+0CA0 (ಠ)
}; // 1

static const unsigned char leggie_block43[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x60, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+10D0 (ა)
	{ 0x00, 0x00, 0x00, 0x1e, 0x10, 0x10, 0x10, 0x10, 0x6c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+10D1 (ბ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x10, 0x6c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c },	// U+10D2 (გ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x64, 0x08, 0x36, 0xc0 },	// U+10D3 (დ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e },	// U+10D4 (ე)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x70, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e },	// U+10D5 (ვ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x92, 0x52, 0x3c, 0x70, 0x90, 0x90, 0x90, 0x90, 0x90, 0x60, 0x00, 0x00, 0x00 },	// U+10D6 (ზ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x8c, 0x00, 0x00, 0x00 },	// U+10D7 (თ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+10D8 (ი)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x70, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e },	// U+10D9 (კ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xaa, 0xaa, 0x82, 0x82, 0x82, 0x84, 0x08, 0x36, 0xc0 },	// U+10DA (ლ)
	{ 0x00, 0x00, 0x00, 0x7c, 0x82, 0x80, 0x80, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+10DB (მ)
	{ 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+10DC (ნ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x82, 0x00, 0x00, 0x00 },	// U+10DD (ო)
	{ 0x00, 0x00, 0x00, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x70, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+10DE (პ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xf0, 0x90, 0x92, 0x8c, 0x80, 0x80, 0x80, 0x80, 0x7e },	// U+10DF (ჟ)
	{ 0x00, 0x00, 0x00, 0x20, 0x18, 0x04, 0x02, 0x02, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x82, 0x00, 0x00, 0x00 },	// U+10E0 (რ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x82, 0x42, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+10E1 (ს)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0xc6, 0xba, 0x92, 0x92, 0x82, 0x82, 0x7c },	// U+10E2 (ტ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x96, 0x90, 0x90, 0x90, 0x90, 0x80, 0x80, 0x80, 0x7e },	// U+10E3 (უ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x8c, 0x80, 0x80, 0x7e },	// U+10E4 (ფ)
	{ 0x00, 0x00, 0x00, 0x80, 0xc0, 0xa0, 0x80, 0x80, 0xfe, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e },	// U+10E5 (ქ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x84, 0x08, 0x36, 0xc0 },	// U+10E6 (ღ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x7e },	// U+10E7 (ყ)
	{ 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x80, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+10E8 (შ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0e, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+10E9 (ჩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x32, 0x42, 0x82, 0x82, 0x72, 0x82, 0x82, 0x82, 0x7c },	// U+10EA (ც)
	{ 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+10EB (ძ)
	{ 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x02, 0x02, 0xfe, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+10EC (წ)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x5c, 0xe2, 0x42, 0xe2, 0x5c, 0x40, 0x40, 0x40, 0x3e },	// U+10ED (ჭ)
	{ 0x00, 0x00, 0x00, 0x02, 0x22, 0x12, 0x0a, 0x06, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+10EE (ხ)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x20, 0x40, 0x80, 0x80, 0x80, 0x80, 0x7e },	// U+10EF (ჯ)
	{ 0x00, 0x00, 0x00, 0x02, 0x7c, 0x80, 0x80, 0x70, 0x80, 0x80, 0x70, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+10F0 (ჰ)
}; // 33

static const unsigned char leggie_block44[][18] = {
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10 },	// U+10F6 (ჶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x7c, 0x02, 0x02, 0x02, 0x02, 0xfc },	// U+10F7 (ჷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02, 0xfc },	// U+10F8 (ჸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x6c, 0x10, 0x90, 0x60 },	// U+10F9 (ჹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x84, 0x08, 0x36, 0xc0 },	// U+10FA (ჺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x80, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00 },	// U+10FB (჻)
	{ 0xfe, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+10FC (ჼ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+10FD (ჽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x10, 0x6c, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+10FE (ჾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+10FF (ჿ)
}; // 10

static const unsigned char leggie_block45[][18] = {
	{ 0x00, 0x10, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+1E02 (Ḃ)
	{ 0x02, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+1E03 (ḃ)
}; // 2

static const unsigned char leggie_block46[][18] = {
	{ 0x00, 0x10, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+1E0A (Ḋ)
	{ 0x80, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1E0B (ḋ)
}; // 2

static const unsigned char leggie_block47[][18] = {
	{ 0x00, 0x10, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+1E1E (Ḟ)
	{ 0x20, 0x00, 0x00, 0x70, 0x08, 0x08, 0x08, 0x08, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1E1F (ḟ)
}; // 2

static const unsigned char leggie_block48[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x10, 0x00 },	// U+1E24 (Ḥ)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x10, 0x00 },	// U+1E25 (ḥ)
}; // 2

static const unsigned char leggie_block49[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x10, 0x00 },	// U+1E36 (Ḷ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x10, 0x00 },	// U+1E37 (ḷ)
}; // 2

static const unsigned char leggie_block50[][18] = {
	{ 0x00, 0x10, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1E40 (Ṁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x82, 0x00, 0x00, 0x00 },	// U+1E41 (ṁ)
}; // 2

static const unsigned char leggie_block51[][18] = {
	{ 0x00, 0x10, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+1E56 (Ṗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02 },	// U+1E57 (ṗ)
}; // 2

static const unsigned char leggie_block52[][18] = {
	{ 0x00, 0x10, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+1E60 (Ṡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00 },	// U+1E61 (ṡ)
}; // 2

static const unsigned char leggie_block53[][18] = {
	{ 0x00, 0x10, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+1E6A (Ṫ)
	{ 0x08, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+1E6B (ṫ)
}; // 2

static const unsigned char leggie_block54[][18] = {
	{ 0x04, 0x08, 0x10, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+1E80 (Ẁ)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+1E81 (ẁ)
	{ 0x40, 0x20, 0x10, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+1E82 (Ẃ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+1E83 (ẃ)
	{ 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+1E84 (Ẅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x82, 0x82, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+1E85 (ẅ)
}; // 6

static const unsigned char leggie_block55[][18] = {
	{ 0x00, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1E8A (Ẋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00 },	// U+1E8B (ẋ)
}; // 2

static const unsigned char leggie_block56[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x10, 0x00 },	// U+1EA0 (Ạ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x10, 0x00 },	// U+1EA1 (ạ)
	{ 0x18, 0x20, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1EA2 (Ả)
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x10, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EA3 (ả)
	{ 0x04, 0x8a, 0x51, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1EA4 (Ấ)
	{ 0x40, 0x20, 0x10, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EA5 (ấ)
	{ 0x41, 0xa2, 0x14, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1EA6 (Ầ)
	{ 0x04, 0x08, 0x10, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EA7 (ầ)
	{ 0xc4, 0x0a, 0x91, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1EA8 (Ẩ)
	{ 0x18, 0x20, 0x10, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EA9 (ẩ)
	{ 0x26, 0x59, 0xa0, 0x10, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1EAA (Ẫ)
	{ 0x0c, 0x92, 0x60, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EAB (ẫ)
	{ 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x10, 0x00 },	// U+1EAC (Ậ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x10, 0x00 },	// U+1EAD (ậ)
	{ 0x20, 0x10, 0x44, 0x38, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1EAE (Ắ)
	{ 0x40, 0x20, 0x10, 0x00, 0x44, 0x44, 0x38, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EAF (ắ)
	{ 0x08, 0x10, 0x44, 0x38, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1EB0 (Ằ)
	{ 0x04, 0x08, 0x10, 0x00, 0x44, 0x44, 0x38, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EB1 (ằ)
	{ 0x18, 0x20, 0x92, 0x7c, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1EB2 (Ẳ)
	{ 0x18, 0x20, 0x10, 0x00, 0x44, 0x44, 0x38, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EB3 (ẳ)
	{ 0x4c, 0x32, 0x44, 0x38, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+1EB4 (Ẵ)
	{ 0x0c, 0x92, 0x60, 0x00, 0x44, 0x44, 0x38, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EB5 (ẵ)
	{ 0x44, 0x44, 0x38, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x10, 0x00 },	// U+1EB6 (Ặ)
	{ 0x00, 0x00, 0x00, 0x44, 0x44, 0x38, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00, 0x10, 0x00 },	// U+1EB7 (ặ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x10, 0x00 },	// U+1EB8 (Ẹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x10, 0x00 },	// U+1EB9 (ẹ)
	{ 0x18, 0x20, 0x10, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+1EBA (Ẻ)
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+1EBB (ẻ)
	{ 0x0c, 0x92, 0x60, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+1EBC (Ẽ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+1EBD (ẽ)
	{ 0x04, 0x8a, 0x51, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+1EBE (Ế)
	{ 0x40, 0x20, 0x10, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+1EBF (ế)
	{ 0x41, 0xa2, 0x14, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+1EC0 (Ề)
	{ 0x04, 0x08, 0x10, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+1EC1 (ề)
	{ 0xc4, 0x0a, 0x91, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+1EC2 (Ể)
	{ 0x18, 0x20, 0x10, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+1EC3 (ể)
	{ 0x26, 0x59, 0xa0, 0x10, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00 },	// U+1EC4 (Ễ)
	{ 0x0c, 0x92, 0x60, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00 },	// U+1EC5 (ễ)
	{ 0x10, 0x28, 0x44, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x10, 0x00 },	// U+1EC6 (Ệ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00, 0x10, 0x00 },	// U+1EC7 (ệ)
	{ 0x18, 0x20, 0x10, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00 },	// U+1EC8 (Ỉ)
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+1EC9 (ỉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x10, 0x00 },	// U+1ECA (Ị)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00 },	// U+1ECB (ị)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x10, 0x00 },	// U+1ECC (Ọ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x10, 0x00 },	// U+1ECD (ọ)
	{ 0x18, 0x20, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1ECE (Ỏ)
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1ECF (ỏ)
	{ 0x04, 0x8a, 0x51, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1ED0 (Ố)
	{ 0x40, 0x20, 0x10, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1ED1 (ố)
	{ 0x41, 0xa2, 0x14, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1ED2 (Ồ)
	{ 0x04, 0x08, 0x10, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1ED3 (ồ)
	{ 0xc4, 0x0a, 0x91, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1ED4 (Ổ)
	{ 0x18, 0x20, 0x10, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1ED5 (ổ)
	{ 0x26, 0x59, 0xa0, 0x10, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1ED6 (Ỗ)
	{ 0x0c, 0x92, 0x60, 0x00, 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1ED7 (ỗ)
	{ 0x10, 0x28, 0x44, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x10, 0x00 },	// U+1ED8 (Ộ)
	{ 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x10, 0x00 },	// U+1ED9 (ộ)
	{ 0x40, 0x20, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EDA (Ớ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EDB (ớ)
	{ 0x04, 0x08, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EDC (Ờ)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EDD (ờ)
	{ 0x18, 0x20, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EDE (Ở)
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x10, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EDF (ở)
	{ 0x0c, 0x92, 0x60, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EE0 (Ỡ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EE1 (ỡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x10, 0x00 },	// U+1EE2 (Ợ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x10, 0x00 },	// U+1EE3 (ợ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x10, 0x00 },	// U+1EE4 (Ụ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x10, 0x00 },	// U+1EE5 (ụ)
	{ 0x18, 0x20, 0x10, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EE6 (Ủ)
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EE7 (ủ)
	{ 0x40, 0x20, 0x10, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EE8 (Ứ)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EE9 (ứ)
	{ 0x04, 0x08, 0x10, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EEA (Ừ)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EEB (ừ)
	{ 0x18, 0x20, 0x10, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EEC (Ử)
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EED (ử)
	{ 0x0c, 0x92, 0x60, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+1EEE (Ữ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x00, 0x00 },	// U+1EEF (ữ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x10, 0x00 },	// U+1EF0 (Ự)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0x10, 0x00 },	// U+1EF1 (ự)
	{ 0x04, 0x08, 0x10, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+1EF2 (Ỳ)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+1EF3 (ỳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00 },	// U+1EF4 (Ỵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x78, 0x00, 0x10 },	// U+1EF5 (ỵ)
	{ 0x18, 0x20, 0x10, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+1EF6 (Ỷ)
	{ 0x00, 0x00, 0x00, 0x18, 0x20, 0x10, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+1EF7 (ỷ)
	{ 0x0c, 0x92, 0x60, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+1EF8 (Ỹ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x78 },	// U+1EF9 (ỹ)
}; // 90

static const unsigned char leggie_block57[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2010 (‐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2011 (‑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2012 (‒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2013 (–)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2014 (—)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2015 (―)
	{ 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2016 (‖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe },	// U+2017 (‗)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2018 (‘)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2019 (’)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00 },	// U+201A (‚)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201B (‛)
	{ 0x00, 0x00, 0x00, 0x00, 0x50, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201C (“)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201D (”)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x14, 0x00 },	// U+201E („)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201F (‟)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2020 (†)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2021 (‡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x7c, 0x7c, 0x7c, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+2022 (•)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x3c, 0x7c, 0x3c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+2023 (‣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+2024 (․)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00 },	// U+2025 (‥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00 },	// U+2026 (…)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2027 (‧)
}; // 24

static const unsigned char leggie_block58[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x49, 0x26, 0x10, 0x08, 0x04, 0xda, 0x25, 0x24, 0xd8, 0x00, 0x00, 0x00 },	// U+2030 (‰)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x49, 0x26, 0x10, 0x08, 0x04, 0xaa, 0x55, 0x54, 0xa8, 0x00, 0x00, 0x00 },	// U+2031 (‱)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2032 (′)
	{ 0x00, 0x00, 0x00, 0x00, 0x50, 0x28, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2033 (″)
	{ 0x00, 0x00, 0x00, 0x00, 0xa8, 0x54, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2034 (‴)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2035 (‵)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x28, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2036 (‶)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x54, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2037 (‷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44 },	// U+2038 (‸)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+2039 (‹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+203A (›)
}; // 11

static const unsigned char leggie_block59[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+203C (‼)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x90, 0x90, 0x90, 0x50, 0x30, 0x10, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+203D (‽)
	{ 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+203E (‾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x38 },	// U+203F (‿)
	{ 0x00, 0x38, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2040 (⁀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x28, 0x44 },	// U+2041 (⁁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x28, 0x00, 0xaa, 0x44, 0xaa, 0x00, 0x00, 0x00 },	// U+2042 (⁂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2043 (⁃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00 },	// U+2044 (⁄)
	{ 0x00, 0x00, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38 },	// U+2045 (⁅)
	{ 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38 },	// U+2046 (⁆)
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x10, 0x10, 0x88, 0x44, 0x44, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00 },	// U+2047 (⁇)
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x40, 0x40, 0x40, 0x20, 0x10, 0x08, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+2048 (⁈)
	{ 0x00, 0x00, 0x00, 0x00, 0xfd, 0x01, 0x01, 0x01, 0x81, 0x41, 0x21, 0x21, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00 },	// U+2049 (⁉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x40, 0x20, 0x10, 0x08 },	// U+204A (⁊)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xf2, 0xf2, 0xf2, 0xf2, 0x72, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+204B (⁋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xbe, 0xbe, 0xbe, 0xbc, 0x00, 0x00, 0x00, 0x00 },	// U+204C (⁌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xfa, 0xfa, 0xfa, 0x7a, 0x00, 0x00, 0x00, 0x00 },	// U+204D (⁍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0xfe, 0x10, 0x28, 0x44 },	// U+204E (⁎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x00 },	// U+204F (⁏)
	{ 0x00, 0x38, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x38 },	// U+2050 (⁐)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x7c, 0x10, 0x28, 0x00, 0x28, 0x10, 0x7c, 0x10, 0x28, 0x00, 0x00, 0x00 },	// U+2051 (⁑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x46, 0x26, 0x20, 0x10, 0x10, 0x08, 0xc8, 0xc4, 0x04, 0x00, 0x00, 0x00 },	// U+2052 (⁒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2053 (⁓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44 },	// U+2054 (⁔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x92, 0x54, 0x38, 0xfe, 0x38, 0x54, 0x92, 0x10, 0x00, 0x00, 0x00 },	// U+2055 (⁕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x02, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00 },	// U+2056 (⁖)
	{ 0x00, 0x00, 0x00, 0x00, 0x54, 0xaa, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2057 (⁗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x82, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+2058 (⁘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0x00, 0x10, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00 },	// U+2059 (⁙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+205A (⁚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00 },	// U+205B (⁛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x54, 0x10, 0xfe, 0x10, 0x54, 0x10, 0x00, 0x00, 0x00 },	// U+205C (⁜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+205D (⁝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+205E (⁞)
}; // 35

static const unsigned char leggie_block60[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x01, 0xa1, 0x11, 0x17, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xa0, 0x00, 0x00 },	// U+2061 (⁡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00 },	// U+2062 (⁢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00 },	// U+2063 (⁣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2064 (⁤)
}; // 4

static const unsigned char leggie_block61[][18] = {
	{ 0x7c, 0x82, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2070 (⁰)
	{ 0x00, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2071 (ⁱ)
}; // 2

static const unsigned char leggie_block62[][18] = {
	{ 0x80, 0xc0, 0xa0, 0x90, 0x88, 0x84, 0xfe, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2074 (⁴)
	{ 0xfe, 0x02, 0x02, 0x02, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2075 (⁵)
	{ 0x7c, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2076 (⁶)
	{ 0xfe, 0x80, 0x80, 0x80, 0x40, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2077 (⁷)
	{ 0x7c, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2078 (⁸)
	{ 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2079 (⁹)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207A (⁺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207B (⁻)
	{ 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207C (⁼)
	{ 0x20, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+207D (⁽)
	{ 0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207E (⁾)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207F (ⁿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xc2, 0xa2, 0x92, 0x8a, 0x86, 0x82, 0x82, 0x7c, 0x00 },	// U+2080 (₀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x50, 0x48, 0x44, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00 },	// U+2081 (₁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x40, 0x40, 0x20, 0x10, 0x08, 0x04, 0xfe, 0x00 },	// U+2082 (₂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x70, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00 },	// U+2083 (₃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xa0, 0x90, 0x88, 0x84, 0xfe, 0x80, 0x80, 0x80, 0x80, 0x00 },	// U+2084 (₄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x02, 0x02, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x00 },	// U+2085 (₅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00 },	// U+2086 (₆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x80, 0x40, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00 },	// U+2087 (₇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00 },	// U+2088 (₈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x7c, 0x00 },	// U+2089 (₉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+208A (₊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+208B (₋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+208C (₌)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x20 },	// U+208D (₍)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08 },	// U+208E (₎)
}; // 27

static const unsigned char leggie_block63[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfc, 0x82, 0x82, 0xfc, 0x00 },	// U+2090 (ₐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0xfe, 0x02, 0x02, 0x7c, 0x00 },	// U+2091 (ₑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00 },	// U+2092 (ₒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x00 },	// U+2093 (ₓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x80, 0xfe, 0x82, 0x82, 0x7c, 0x00 },	// U+2094 (ₔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00 },	// U+2095 (ₕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x24, 0x14, 0x0c, 0x14, 0x24, 0x44, 0x00 },	// U+2096 (ₖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00 },	// U+2097 (ₗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x92, 0x92, 0x92, 0x92, 0x92, 0x82, 0x00 },	// U+2098 (ₘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00 },	// U+2099 (ₙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x02 },	// U+209A (ₚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x7c, 0x80, 0x80, 0x7e, 0x00 },	// U+209B (ₛ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00 },	// U+209C (ₜ)
}; // 13

static const unsigned char leggie_block64[][18] = {
	{ 0x00, 0x00, 0x50, 0x50, 0xfc, 0x52, 0x52, 0x52, 0x52, 0x4a, 0x2a, 0x2a, 0x2a, 0x2a, 0xfc, 0x28, 0x28, 0x00 },	// U+20A1 (₡)
}; // 1

static const unsigned char leggie_block65[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x20, 0x6e, 0xb2, 0x92, 0x92, 0x9a, 0x9a, 0x8a, 0x04, 0x04, 0x04 },	// U+20A5 (₥)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0xff, 0x8a, 0x92, 0xa2, 0xff, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+20A6 (₦)
	{ 0x00, 0x00, 0x00, 0x40, 0x4f, 0x51, 0x51, 0x51, 0xf1, 0x51, 0x4f, 0x41, 0x41, 0x41, 0x81, 0x00, 0x00, 0x00 },	// U+20A7 (₧)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x20, 0x20, 0xfe, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00 },	// U+20A8 (₨)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0xff, 0x82, 0x82, 0xff, 0x82, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00 },	// U+20A9 (₩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xa2, 0xaa, 0xaa, 0xaa, 0x8a, 0xf2, 0x00, 0x00, 0x00 },	// U+20AA (₪)
	{ 0x00, 0x00, 0x00, 0x80, 0x80, 0xf0, 0x80, 0x80, 0xfc, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfc, 0x00, 0xfc, 0x00 },	// U+20AB (₫)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x04, 0x04, 0x04, 0x3e, 0x04, 0x1e, 0x04, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00 },	// U+20AC (€)
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x42, 0x22, 0x12, 0x0a, 0x7f, 0x0a, 0x12, 0x22, 0x42, 0x82, 0x00, 0x00, 0x00 },	// U+20AD (₭)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x70, 0x1c, 0x10, 0x70, 0x1c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+20AE (₮)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x11, 0x11, 0xf1, 0x31, 0x31, 0x31, 0x31, 0x31, 0xef, 0x20, 0x20, 0x20 },	// U+20AF (₯)
}; // 11

static const unsigned char leggie_block66[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0xff, 0x82, 0x82, 0x7e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+20B1 (₱)
	{ 0x00, 0x00, 0x10, 0x10, 0xfc, 0x12, 0x12, 0x12, 0x12, 0xf2, 0x92, 0x92, 0x92, 0x92, 0xfc, 0x10, 0x10, 0x00 },	// U+20B2 (₲)
}; // 2

static const unsigned char leggie_block67[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0xff, 0x80, 0x7c, 0x02, 0xff, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+20B4 (₴)
	{ 0x00, 0x00, 0x10, 0x10, 0xfc, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0xfc, 0x10, 0x10, 0x00 },	// U+20B5 (₵)
}; // 2

static const unsigned char leggie_block68[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+20B8 (₸)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x20, 0x20, 0xfe, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00 },	// U+20B9 (₹)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x1c, 0x06, 0x04, 0x1c, 0x06, 0x04, 0x84, 0x7c, 0x00, 0x00, 0x00 },	// U+20BA (₺)
}; // 3

static const unsigned char leggie_block69[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x82, 0x00, 0x00, 0x00 },	// U+20BC (₼)
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x02, 0x3f, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+20BD (₽)
}; // 2

static const unsigned char leggie_block70[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0xd3, 0x35, 0x39, 0xd1, 0x11, 0xf1, 0x11, 0x00, 0x00, 0x00 },	// U+2116 (№)
}; // 1

static const unsigned char leggie_block71[][18] = {
	{ 0x00, 0x00, 0x00, 0x1f, 0xb4, 0x54, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2122 (™)
}; // 1

static const unsigned char leggie_block72[][18] = {
	{ 0x10, 0x28, 0x10, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+212B (Å)
}; // 1

static const unsigned char leggie_block73[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0xff, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2190 (←)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x92, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2191 (↑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x80, 0xff, 0x80, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2192 (→)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x92, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+2193 (↓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x44, 0x82, 0xff, 0x82, 0x44, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2194 (↔)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x92, 0x10, 0x10, 0x10, 0x92, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+2195 (↕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x03, 0x05, 0x09, 0x11, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+2196 (↖)
}; // 7

static const unsigned char leggie_block74[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0xf0, 0x00, 0x00, 0x00 },	// U+2198 (↘)
}; // 1

static const unsigned char leggie_block75[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0xff, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A4 (↤)
}; // 1

static const unsigned char leggie_block76[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x41, 0x81, 0xff, 0x81, 0x41, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A6 (↦)
}; // 1

static const unsigned char leggie_block77[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x92, 0x10, 0x10, 0x10, 0x92, 0x54, 0x38, 0x10, 0xfe, 0x00, 0x00 },	// U+21A8 (↨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x84, 0x02, 0xff, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21A9 (↩)
}; // 2

static const unsigned char leggie_block78[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0xff, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21B5 (↵)
}; // 1

static const unsigned char leggie_block79[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x1f, 0x03, 0x05, 0x09, 0x11, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+21B8 (↸)
	{ 0x00, 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0xff, 0x25, 0x49, 0x90, 0xff, 0x80, 0x40, 0x20, 0x00, 0x00, 0x00 },	// U+21B9 (↹)
}; // 2

static const unsigned char leggie_block80[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0xff, 0x22, 0x44, 0x88, 0xff, 0x80, 0x40, 0x20, 0x00, 0x00, 0x00 },	// U+21C6 (⇆)
}; // 1

static const unsigned char leggie_block81[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0xfe, 0x01, 0xfe, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D0 (⇐)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x6c, 0xaa, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00 },	// U+21D1 (⇑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0xff, 0x00, 0xff, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D2 (⇒)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xaa, 0x6c, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+21D3 (⇓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x44, 0xfe, 0x01, 0xfe, 0x44, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21D4 (⇔)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x6c, 0xaa, 0x28, 0x28, 0x28, 0xaa, 0x6c, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+21D5 (⇕)
}; // 6

static const unsigned char leggie_block82[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x92, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x7c, 0x10, 0x00, 0x00, 0x00 },	// U+21DE (⇞)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x92, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+21DF (⇟)
}; // 2

static const unsigned char leggie_block83[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x09, 0x05, 0xff, 0x05, 0x09, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21E4 (⇤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0xff, 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21E5 (⇥)
}; // 2

static const unsigned char leggie_block84[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0xee, 0x28, 0x28, 0x28, 0x28, 0x28, 0x38, 0x00, 0x00, 0x00 },	// U+21E7 (⇧)
}; // 1

static const unsigned char leggie_block85[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0xee, 0x28, 0x28, 0x28, 0x7c, 0x44, 0x7c, 0x00, 0x00, 0x00 },	// U+21EA (⇪)
}; // 1

static const unsigned char leggie_block86[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x01, 0x3d, 0x0d, 0x15, 0x25, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+21F1 (⇱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x48, 0x50, 0x60, 0x78, 0x00, 0xf8, 0x00, 0x00, 0x00 },	// U+21F2 (⇲)
}; // 2

static const unsigned char leggie_block87[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x80, 0x80, 0xf0, 0x80, 0x80, 0x80, 0x80, 0xfe, 0x00, 0x00, 0x00 },	// U+2203 (∃)
}; // 1

static const unsigned char leggie_block88[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x41, 0x21, 0x11, 0x09, 0x05, 0x82, 0x7d, 0x00, 0x00, 0x00 },	// U+2205 (∅)
}; // 1

static const unsigned char leggie_block89[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0xfe, 0x02, 0x02, 0xfc, 0x00, 0x00, 0x00 },	// U+2208 (∈)
}; // 1

static const unsigned char leggie_block90[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2219 (∙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x20, 0x21, 0x12, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+221A (√)
}; // 2

static const unsigned char leggie_block91[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x11, 0x11, 0x11, 0x11, 0x11, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+221E (∞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xff, 0x00, 0x00, 0x00 },	// U+221F (∟)
}; // 2

static const unsigned char leggie_block92[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+2227 (∧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2228 (∨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+2229 (∩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+222A (∪)
}; // 4

static const unsigned char leggie_block93[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x0c, 0x92, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2248 (≈)
}; // 1

static const unsigned char leggie_block94[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xfe, 0x20, 0x10, 0x08, 0xfe, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+2260 (≠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2261 (≡)
}; // 2

static const unsigned char leggie_block95[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x60, 0x18, 0x06, 0x18, 0x60, 0x80, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+2264 (≤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x30, 0xc0, 0x30, 0x0c, 0x02, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+2265 (≥)
}; // 2

static const unsigned char leggie_block96[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x01, 0x01, 0x7d, 0x01, 0x01, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+2296 (⊖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x45, 0x29, 0x11, 0x29, 0x45, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00 },	// U+2297 (⊗)
}; // 2

static const unsigned char leggie_block97[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x01, 0x01, 0x7d, 0x01, 0x01, 0x01, 0xfe, 0x00, 0x00 },	// U+229D (⊝)
}; // 1

static const unsigned char leggie_block98[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+2302 (⌂)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2303 (⌃)
}; // 2

static const unsigned char leggie_block99[][18] = {
	{ 0x00, 0x00, 0x00, 0xfe, 0x00, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2305 (⌅)
}; // 1

static const unsigned char leggie_block100[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2310 (⌐)
}; // 1

static const unsigned char leggie_block101[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x45, 0xfe, 0x44, 0x44, 0x44, 0xfe, 0x45, 0x82, 0x00, 0x00, 0x00 },	// U+2318 (⌘)
}; // 1

static const unsigned char leggie_block102[][18] = {
	{ 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2320 (⌠)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e, 0x00 },	// U+2321 (⌡)
}; // 2

static const unsigned char leggie_block103[][18] = {
	{ 0x00, 0x00, 0x00, 0xee, 0x00, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2324 (⌤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc7, 0x08, 0x10, 0x20, 0xc0, 0x00, 0x00, 0x00, 0x00 },	// U+2325 (⌥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x5d, 0xeb, 0xf7, 0xeb, 0x5d, 0x3f, 0x00, 0x00, 0x00 },	// U+2326 (⌦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x01, 0x45, 0x29, 0x11, 0x29, 0x45, 0x01, 0xff, 0x00, 0x00, 0x00 },	// U+2327 (⌧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x00, 0x55, 0x00, 0xaa, 0x00, 0x7c, 0x00, 0x00, 0x00 },	// U+2328 (⌨)
}; // 5

static const unsigned char leggie_block104[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x74, 0xae, 0xdf, 0xae, 0x74, 0xf8, 0x00, 0x00, 0x00 },	// U+232B (⌫)
}; // 1

static const unsigned char leggie_block105[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10 },	// U+233D (⌽)
}; // 1

static const unsigned char leggie_block106[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x7c, 0x00, 0x82, 0x44, 0x28, 0x10 },	// U+2380 (⎀)
}; // 1

static const unsigned char leggie_block107[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x13, 0x13, 0x13, 0x13, 0x13, 0xef, 0x00, 0x00, 0x00 },	// U+2384 (⎄)
}; // 1

static const unsigned char leggie_block108[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0xff, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00 },	// U+2386 (⎆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x08, 0xc7, 0x00, 0x00, 0x00, 0x00 },	// U+2387 (⎇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x92, 0x7c, 0xba, 0x92, 0xba, 0x7c, 0x92, 0x10, 0x00, 0x00 },	// U+2388 (⎈)
}; // 3

static const unsigned char leggie_block109[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x63, 0x85, 0x89, 0x90, 0xa2, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+238B (⎋)
}; // 1

static const unsigned char leggie_block110[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BA (⎺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23BB (⎻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00 },	// U+23BC (⎼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff },	// U+23BD (⎽)
}; // 4

static const unsigned char leggie_block111[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x40, 0x40, 0x58, 0x54, 0x72, 0x01, 0xf2, 0x14, 0x18, 0x00, 0x00 },	// U+23CE (⏎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00 },	// U+23CF (⏏)
}; // 2

static const unsigned char leggie_block112[][18] = {
	{ 0x09, 0x09, 0x0b, 0x0d, 0x09, 0x09, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x20, 0x20, 0x20, 0x20, 0x20, 0xe0 },	// U+2400 (␀)
	{ 0x0e, 0x01, 0x06, 0x08, 0x08, 0x07, 0x18, 0x24, 0x24, 0x24, 0x24, 0x18, 0x20, 0x20, 0x20, 0xe0, 0x20, 0x20 },	// U+2401 (␁)
	{ 0x0e, 0x01, 0x06, 0x08, 0x08, 0x07, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0xe0, 0x20, 0x20 },	// U+2402 (␂)
	{ 0x0f, 0x01, 0x07, 0x01, 0x01, 0x0f, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0xc0, 0xc0, 0x20, 0x20 },	// U+2403 (␃)
	{ 0x0f, 0x01, 0x07, 0x01, 0x01, 0x0f, 0x18, 0x24, 0x24, 0x24, 0x24, 0x18, 0xf0, 0x40, 0x40, 0x40, 0x40, 0x40 },	// U+2404 (␄)
	{ 0x0f, 0x01, 0x07, 0x01, 0x01, 0x0f, 0x48, 0x48, 0x58, 0x68, 0x48, 0x48, 0xc0, 0x20, 0x20, 0x20, 0xa0, 0x40 },	// U+2405 (␅)
	{ 0x06, 0x09, 0x09, 0x0f, 0x09, 0x09, 0x70, 0x08, 0x08, 0x08, 0x08, 0x70, 0x20, 0xa0, 0x60, 0x60, 0xa0, 0x20 },	// U+2406 (␆)
	{ 0x07, 0x09, 0x07, 0x09, 0x09, 0x07, 0x78, 0x08, 0x38, 0x08, 0x08, 0x78, 0x20, 0x20, 0x20, 0x20, 0x20, 0xe0 },	// U+2407 (␇)
	{ 0x00, 0x00, 0x0e, 0x12, 0x0e, 0x12, 0x12, 0x0e, 0x00, 0x00, 0xe0, 0x10, 0x60, 0x80, 0x80, 0x70, 0x00, 0x00 },	// U+2408 (␈)
	{ 0x00, 0x00, 0x12, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+2409 (␉)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x00, 0x00, 0xf0, 0x10, 0x70, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+240A (␊)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x14, 0x08, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00 },	// U+240B (␋)
	{ 0x00, 0x00, 0x1e, 0x02, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00, 0xf0, 0x10, 0x70, 0x10, 0x10, 0x10, 0x00, 0x00 },	// U+240C (␌)
	{ 0x00, 0x00, 0x1c, 0x02, 0x02, 0x02, 0x02, 0x1c, 0x00, 0x00, 0x70, 0x90, 0x90, 0x70, 0x50, 0x90, 0x00, 0x00 },	// U+240D (␍)
	{ 0x00, 0x00, 0x1c, 0x02, 0x0c, 0x10, 0x10, 0x0e, 0x00, 0x00, 0xe0, 0x10, 0x60, 0x80, 0x80, 0x70, 0x00, 0x00 },	// U+240E (␎)
	{ 0x00, 0x00, 0x1c, 0x02, 0x0c, 0x10, 0x10, 0x0e, 0x00, 0x00, 0xe0, 0x40, 0x40, 0x40, 0x40, 0xe0, 0x00, 0x00 },	// U+240F (␏)
	{ 0x07, 0x09, 0x09, 0x09, 0x09, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0xe0, 0x20, 0xe0, 0x20, 0x20, 0xe0 },	// U+2410 (␐)
	{ 0x07, 0x09, 0x09, 0x09, 0x09, 0x07, 0x70, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x80, 0x40, 0x00, 0x00, 0x00 },	// U+2411 (␑)
	{ 0x07, 0x09, 0x09, 0x09, 0x09, 0x07, 0x38, 0x04, 0x04, 0x04, 0x04, 0x38, 0xe0, 0x00, 0x00, 0x80, 0x40, 0xe0 },	// U+2412 (␒)
	{ 0x07, 0x09, 0x09, 0x09, 0x09, 0x07, 0x38, 0x04, 0x04, 0x04, 0x04, 0x38, 0xe0, 0x00, 0xc0, 0x00, 0x00, 0xe0 },	// U+2413 (␓)
	{ 0x07, 0x09, 0x09, 0x09, 0x09, 0x07, 0x70, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x80, 0x40, 0xe0, 0x00, 0x00 },	// U+2414 (␔)
	{ 0x09, 0x09, 0x0b, 0x0d, 0x09, 0x09, 0x30, 0x48, 0x48, 0x78, 0x48, 0x48, 0x20, 0xa0, 0x60, 0x60, 0xa0, 0x20 },	// U+2415 (␕)
	{ 0x0e, 0x01, 0x06, 0x08, 0x08, 0x07, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x20, 0x20, 0x60, 0xa0, 0x20, 0x20 },	// U+2416 (␖)
	{ 0x0f, 0x01, 0x03, 0x01, 0x01, 0x0f, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x20, 0xe0, 0x20, 0x20, 0xe0 },	// U+2417 (␗)
	{ 0x0e, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x30, 0x48, 0x48, 0x78, 0x48, 0x48, 0x20, 0x20, 0x60, 0xa0, 0x20, 0x20 },	// U+2418 (␘)
	{ 0x00, 0x00, 0x1e, 0x02, 0x0e, 0x02, 0x02, 0x1e, 0x00, 0x00, 0x88, 0xd8, 0xa8, 0x88, 0x88, 0x88, 0x00, 0x00 },	// U+2419 (␙)
	{ 0x0e, 0x01, 0x06, 0x08, 0x08, 0x07, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0xe0, 0x20, 0xe0, 0x20, 0x20, 0xe0 },	// U+241A (␚)
	{ 0x0f, 0x01, 0x07, 0x01, 0x01, 0x0f, 0x70, 0x08, 0x30, 0x40, 0x40, 0x38, 0xc0, 0x20, 0x20, 0x20, 0x20, 0xc0 },	// U+241B (␛)
	{ 0x00, 0x00, 0x1e, 0x02, 0x0e, 0x02, 0x02, 0x02, 0x00, 0x00, 0xe0, 0x10, 0x60, 0x80, 0x80, 0x70, 0x00, 0x00 },	// U+241C (␜)
	{ 0x00, 0x00, 0x1c, 0x02, 0x1a, 0x12, 0x12, 0x1c, 0x00, 0x00, 0xe0, 0x10, 0x60, 0x80, 0x80, 0x70, 0x00, 0x00 },	// U+241D (␝)
	{ 0x00, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x0a, 0x12, 0x00, 0x00, 0xe0, 0x10, 0x60, 0x80, 0x80, 0x70, 0x00, 0x00 },	// U+241E (␞)
	{ 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0xe0, 0x10, 0x60, 0x80, 0x80, 0x70, 0x00, 0x00 },	// U+241F (␟)
	{ 0x00, 0x00, 0x1c, 0x02, 0x0c, 0x10, 0x10, 0x0e, 0x00, 0x00, 0x70, 0x90, 0x90, 0x70, 0x10, 0x10, 0x10, 0x00 },	// U+2420 (␠)
	{ 0x07, 0x09, 0x09, 0x09, 0x09, 0x07, 0x3c, 0x04, 0x1c, 0x04, 0x04, 0x3c, 0x20, 0x20, 0x20, 0x20, 0x20, 0xe0 },	// U+2421 (␡)
	{ 0x00, 0x00, 0x00, 0x02, 0x1a, 0x06, 0x03, 0x02, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7e, 0x00, 0x00, 0x00 },	// U+2422 (␢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xfe, 0x00 },	// U+2423 (␣)
	{ 0x00, 0x00, 0x12, 0x12, 0x16, 0x1a, 0x12, 0x12, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x00, 0x00 },	// U+2424 (␤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x42, 0x20, 0x10, 0x08, 0x84, 0x42, 0x20, 0x00, 0x00, 0x00 },	// U+2425 (␥)
	{ 0x00, 0x00, 0x00, 0x00, 0xfc, 0x02, 0x02, 0x02, 0x04, 0x08, 0x10, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+2426 (␦)
}; // 39

static const unsigned char leggie_block113[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2500 (─)
}; // 1

static const unsigned char leggie_block114[][18] = {
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2502 (│)
}; // 1

static const unsigned char leggie_block115[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+250C (┌)
}; // 1

static const unsigned char leggie_block116[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2510 (┐)
}; // 1

static const unsigned char leggie_block117[][18] = {
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2514 (└)
}; // 1

static const unsigned char leggie_block118[][18] = {
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2518 (┘)
}; // 1

static const unsigned char leggie_block119[][18] = {
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+251C (├)
}; // 1

static const unsigned char leggie_block120[][18] = {
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2524 (┤)
}; // 1

static const unsigned char leggie_block121[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+252C (┬)
}; // 1

static const unsigned char leggie_block122[][18] = {
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2534 (┴)
}; // 1

static const unsigned char leggie_block123[][18] = {
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+253C (┼)
}; // 1

static const unsigned char leggie_block124[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2550 (═)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2551 (║)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2552 (╒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2553 (╓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0xc8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2554 (╔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2555 (╕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2556 (╖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x27, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2557 (╗)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2558 (╘)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2559 (╙)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xc8, 0x10, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255A (╚)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255B (╛)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255C (╜)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x27, 0x10, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255D (╝)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+255E (╞)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xe8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+255F (╟)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xc8, 0x08, 0xc8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2560 (╠)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x10, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2561 (╡)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2f, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2562 (╢)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x27, 0x20, 0x27, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2563 (╣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+2564 (╤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2565 (╥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xc7, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+2566 (╦)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2567 (╧)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2568 (╨)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xc7, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2569 (╩)
	{ 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x00, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },	// U+256A (╪)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xef, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+256B (╫)
	{ 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xc7, 0x10, 0xc7, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28 },	// U+256C (╬)
}; // 29

static const unsigned char leggie_block125[][18] = {
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2580 (▀)
}; // 1

static const unsigned char leggie_block126[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2584 (▄)
}; // 1

static const unsigned char leggie_block127[][18] = {
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+2588 (█)
}; // 1

static const unsigned char leggie_block128[][18] = {
	{ 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f },	// U+258C (▌)
}; // 1

static const unsigned char leggie_block129[][18] = {
	{ 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0 },	// U+2590 (▐)
	{ 0x00, 0x24, 0x00, 0x49, 0x00, 0x92, 0x00, 0x24, 0x00, 0x49, 0x00, 0x92, 0x00, 0x24, 0x00, 0x49, 0x00, 0x92 },	// U+2591 (░)
	{ 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa },	// U+2592 (▒)
	{ 0xff, 0xdb, 0xff, 0xb6, 0xff, 0x6d, 0xff, 0xdb, 0xff, 0xb6, 0xff, 0x6d, 0xff, 0xdb, 0xff, 0xb6, 0xff, 0x6d },	// U+2593 (▓)
}; // 4

static const unsigned char leggie_block130[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25A0 (■)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25A1 (□)
}; // 2

static const unsigned char leggie_block131[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0xfe, 0x82, 0xfe, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25A4 (▤)
}; // 1

static const unsigned char leggie_block132[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25AA (▪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x44, 0x44, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25AB (▫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25AC (▬)
}; // 3

static const unsigned char leggie_block133[][18] = {
	{ 0x10, 0x10, 0x10, 0x38, 0x38, 0x38, 0x38, 0x7c, 0x7c, 0x7c, 0x7c, 0xfe, 0xfe, 0xfe, 0xfe, 0xff, 0xff, 0xff },	// U+25B2 (▲)
}; // 1

static const unsigned char leggie_block134[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x3f, 0x7f, 0xff, 0xff, 0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x00, 0x00, 0x00 },	// U+25B6 (▶)
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x11, 0x21, 0x41, 0x81, 0x01, 0x81, 0x41, 0x21, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+25B7 (▷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1e, 0x3e, 0x7e, 0xfe, 0x7e, 0x3e, 0x1e, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+25B8 (▸)
}; // 3

static const unsigned char leggie_block135[][18] = {
	{ 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01 },	// U+25BA (►)
}; // 1

static const unsigned char leggie_block136[][18] = {
	{ 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0x7c, 0x7c, 0x7c, 0x7c, 0x38, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10 },	// U+25BC (▼)
}; // 1

static const unsigned char leggie_block137[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x08, 0x04, 0x02, 0x01, 0x02, 0x04, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+25C1 (◁)
}; // 1

static const unsigned char leggie_block138[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0x00, 0x00, 0x00 },	// U+25C4 (◄)
}; // 1

static const unsigned char leggie_block139[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0xff, 0xff, 0xff, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+25C6 (◆)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0x01, 0x01, 0x01, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+25C7 (◇)
}; // 2

static const unsigned char leggie_block140[][18] = {
	{ 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x01, 0x01, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10 },	// U+25CA (◊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25CB (○)
}; // 2

static const unsigned char leggie_block141[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x7c, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25CF (●)
}; // 1

static const unsigned char leggie_block142[][18] = {
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x83, 0x01, 0x01, 0x01, 0x83, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25D8 (◘)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xbb, 0x7d, 0x7d, 0x7d, 0xbb, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+25D9 (◙)
}; // 2

static const unsigned char leggie_block143[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x01, 0x01, 0x01, 0x01, 0x01, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+25EF (◯)
}; // 1

static const unsigned char leggie_block144[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xff, 0x00, 0x00, 0x00 },	// U+2610 (☐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x01, 0x81, 0x41, 0x23, 0x15, 0x09, 0x01, 0xff, 0x00, 0x00, 0x00 },	// U+2611 (☑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x01, 0x45, 0x29, 0x11, 0x29, 0x45, 0x01, 0xff, 0x00, 0x00, 0x00 },	// U+2612 (☒)
}; // 3

static const unsigned char leggie_block145[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+263A (☺)
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0xfe, 0xff, 0xbb, 0xff, 0xff, 0xff, 0xff, 0x7d, 0x83, 0xff, 0xfe, 0x7c, 0x00 },	// U+263B (☻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x92, 0x38, 0x44, 0xc7, 0x44, 0x38, 0x92, 0x11, 0x00, 0x00, 0x00 },	// U+263C (☼)
}; // 3

static const unsigned char leggie_block146[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x10, 0x10, 0x7c, 0x10, 0x00, 0x00, 0x00 },	// U+2640 (♀)
}; // 1

static const unsigned char leggie_block147[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0xc0, 0xb0, 0x0c, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+2642 (♂)
}; // 1

static const unsigned char leggie_block148[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0xfe, 0xfe, 0x6c, 0x10, 0x7c, 0x00, 0x00, 0x00 },	// U+2660 (♠)
}; // 1

static const unsigned char leggie_block149[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x54, 0xfe, 0xfe, 0x6c, 0x10, 0x7c, 0x00, 0x00, 0x00 },	// U+2663 (♣)
}; // 1

static const unsigned char leggie_block150[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xee, 0xfe, 0xfe, 0x7c, 0x7c, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+2665 (♥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+2666 (♦)
}; // 2

static const unsigned char leggie_block151[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x60, 0xa0, 0x20, 0x20, 0xa0, 0x20, 0x3c, 0x3e, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+266A (♪)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x38, 0xc8, 0x08, 0x08, 0x08, 0x08, 0x0e, 0xcf, 0xef, 0xee, 0xc0, 0x00, 0x00 },	// U+266B (♫)
}; // 2

static const unsigned char leggie_block152[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x12, 0x0a, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2713 (✓)
}; // 1

static const unsigned char leggie_block153[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00 },	// U+2717 (✗)
}; // 1

static const unsigned char leggie_block154[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x38, 0x38, 0xfe, 0x38, 0x38, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2726 (✦)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x28, 0x28, 0xc6, 0x28, 0x28, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2727 (✧)
}; // 2

static const unsigned char leggie_block155[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0xee, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2732 (✲)
}; // 1

static const unsigned char leggie_block156[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xba, 0xd7, 0xef, 0xd7, 0xba, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+2756 (❖)
}; // 1

static const unsigned char leggie_block157[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2800 (⠀)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2801 (⠁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2802 (⠂)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2803 (⠃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2804 (⠄)
	{ 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2805 (⠅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2806 (⠆)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2807 (⠇)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2808 (⠈)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2809 (⠉)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280A (⠊)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280B (⠋)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280C (⠌)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280D (⠍)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280E (⠎)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280F (⠏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2810 (⠐)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2811 (⠑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2812 (⠒)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2813 (⠓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2814 (⠔)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2815 (⠕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2816 (⠖)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2817 (⠗)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2818 (⠘)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2819 (⠙)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281A (⠚)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281B (⠛)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281C (⠜)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281D (⠝)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281E (⠞)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281F (⠟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2820 (⠠)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2821 (⠡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2822 (⠢)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2823 (⠣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2824 (⠤)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2825 (⠥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2826 (⠦)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2827 (⠧)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2828 (⠨)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2829 (⠩)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282A (⠪)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282B (⠫)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282C (⠬)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282D (⠭)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282E (⠮)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282F (⠯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2830 (⠰)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2831 (⠱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2832 (⠲)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2833 (⠳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2834 (⠴)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2835 (⠵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2836 (⠶)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2837 (⠷)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2838 (⠸)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2839 (⠹)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283A (⠺)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283B (⠻)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283C (⠼)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283D (⠽)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283E (⠾)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283F (⠿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2840 (⡀)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2841 (⡁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2842 (⡂)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2843 (⡃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2844 (⡄)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2845 (⡅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2846 (⡆)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2847 (⡇)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2848 (⡈)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2849 (⡉)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+284A (⡊)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+284B (⡋)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+284C (⡌)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+284D (⡍)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+284E (⡎)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+284F (⡏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2850 (⡐)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2851 (⡑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2852 (⡒)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2853 (⡓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2854 (⡔)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2855 (⡕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2856 (⡖)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2857 (⡗)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2858 (⡘)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2859 (⡙)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+285A (⡚)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+285B (⡛)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+285C (⡜)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+285D (⡝)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+285E (⡞)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+285F (⡟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2860 (⡠)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2861 (⡡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2862 (⡢)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2863 (⡣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2864 (⡤)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2865 (⡥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2866 (⡦)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2867 (⡧)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2868 (⡨)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2869 (⡩)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+286A (⡪)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+286B (⡫)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+286C (⡬)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+286D (⡭)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+286E (⡮)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+286F (⡯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2870 (⡰)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2871 (⡱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2872 (⡲)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2873 (⡳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2874 (⡴)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2875 (⡵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2876 (⡶)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2877 (⡷)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2878 (⡸)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+2879 (⡹)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+287A (⡺)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+287B (⡻)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+287C (⡼)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+287D (⡽)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+287E (⡾)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00 },	// U+287F (⡿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2880 (⢀)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2881 (⢁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2882 (⢂)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2883 (⢃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2884 (⢄)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2885 (⢅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2886 (⢆)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2887 (⢇)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2888 (⢈)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2889 (⢉)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+288A (⢊)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+288B (⢋)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+288C (⢌)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+288D (⢍)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+288E (⢎)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+288F (⢏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2890 (⢐)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2891 (⢑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2892 (⢒)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2893 (⢓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2894 (⢔)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2895 (⢕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2896 (⢖)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2897 (⢗)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2898 (⢘)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+2899 (⢙)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+289A (⢚)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+289B (⢛)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+289C (⢜)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+289D (⢝)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+289E (⢞)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+289F (⢟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28A0 (⢠)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28A1 (⢡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28A2 (⢢)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28A3 (⢣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28A4 (⢤)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28A5 (⢥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28A6 (⢦)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28A7 (⢧)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28A8 (⢨)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28A9 (⢩)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28AA (⢪)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28AB (⢫)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28AC (⢬)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28AD (⢭)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28AE (⢮)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28AF (⢯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28B0 (⢰)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28B1 (⢱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28B2 (⢲)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28B3 (⢳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28B4 (⢴)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28B5 (⢵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28B6 (⢶)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28B7 (⢷)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28B8 (⢸)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28B9 (⢹)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28BA (⢺)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28BB (⢻)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28BC (⢼)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28BD (⢽)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28BE (⢾)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00 },	// U+28BF (⢿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28C0 (⣀)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28C1 (⣁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28C2 (⣂)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28C3 (⣃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28C4 (⣄)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28C5 (⣅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28C6 (⣆)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28C7 (⣇)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28C8 (⣈)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28C9 (⣉)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28CA (⣊)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28CB (⣋)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28CC (⣌)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28CD (⣍)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28CE (⣎)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28CF (⣏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28D0 (⣐)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28D1 (⣑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28D2 (⣒)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28D3 (⣓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28D4 (⣔)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28D5 (⣕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28D6 (⣖)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28D7 (⣗)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28D8 (⣘)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28D9 (⣙)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28DA (⣚)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28DB (⣛)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28DC (⣜)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28DD (⣝)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28DE (⣞)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28DF (⣟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28E0 (⣠)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28E1 (⣡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28E2 (⣢)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28E3 (⣣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28E4 (⣤)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28E5 (⣥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28E6 (⣦)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28E7 (⣧)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28E8 (⣨)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28E9 (⣩)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28EA (⣪)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28EB (⣫)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28EC (⣬)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28ED (⣭)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28EE (⣮)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28EF (⣯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28F0 (⣰)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28F1 (⣱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28F2 (⣲)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28F3 (⣳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28F4 (⣴)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28F5 (⣵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28F6 (⣶)
	{ 0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28F7 (⣷)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28F8 (⣸)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28F9 (⣹)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28FA (⣺)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28FB (⣻)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28FC (⣼)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28FD (⣽)
	{ 0x00, 0x00, 0xe0, 0xe0, 0xe0, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28FE (⣾)
	{ 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00 },	// U+28FF (⣿)
}; // 256

static const unsigned char leggie_block158[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0xfe, 0x80, 0x80, 0x78 },	// U+A640 (Ꙁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x40, 0x20, 0x10, 0x08, 0x04, 0xfe, 0x80, 0x80, 0x78 },	// U+A641 (ꙁ)
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0x80, 0x80, 0x40, 0x20, 0xfe, 0x08, 0x04, 0x02, 0x02, 0xfe, 0x80, 0x80, 0x78 },	// U+A642 (Ꙃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x40, 0x20, 0xfe, 0x08, 0x04, 0xfe, 0x80, 0x80, 0x78 },	// U+A643 (ꙃ)
}; // 4

static const unsigned char leggie_block159[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x28, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+A64A (Ꙋ)
	{ 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+A64B (ꙋ)
}; // 2

static const unsigned char leggie_block160[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x83, 0x82, 0x82, 0x82, 0x9e, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0x9e, 0x00, 0x00, 0x00 },	// U+A650 (Ꙑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x82, 0x82, 0x9e, 0xa2, 0xa2, 0x9e, 0x00, 0x00, 0x00 },	// U+A651 (ꙑ)
}; // 2

static const unsigned char leggie_block161[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x72, 0x8a, 0x8a, 0x8a, 0x8a, 0x8e, 0xfa, 0x8a, 0x8a, 0x8a, 0x8a, 0x00, 0x00, 0x00 },	// U+A656 (Ꙗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x82, 0x82, 0xfe, 0x8a, 0x8a, 0xf2, 0x00, 0x00, 0x00 },	// U+A657 (ꙗ)
}; // 2

static const unsigned char leggie_block162[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x86, 0x8a, 0x92, 0xa2, 0xc2, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+A790 (Ꞑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+A791 (ꞑ)
}; // 2

static const unsigned char leggie_block163[][18] = {
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81, 0x41, 0x41, 0xc1, 0x41, 0x41, 0x8e, 0x00, 0x00, 0x00 },	// U+E000 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0x48, 0x48, 0x4f, 0x40, 0x40, 0x87, 0x00, 0x00, 0x00 },	// U+E001 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0x48, 0x48, 0x48, 0x48, 0x48, 0x8f, 0x08, 0x08, 0x07 },	// U+E002 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0xcf, 0x88, 0x88, 0x88, 0x88, 0x88, 0x8f, 0x08, 0x08, 0x07 },	// U+E003 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00 },	// U+E004 ()
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xee, 0xee, 0x00, 0x00, 0x10, 0x00, 0x00, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00 },	// U+E005 ()
}; // 6

static const unsigned char leggie_block164[][18] = {
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00 },	// U+E010 ()
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+E011 ()
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+E012 ()
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+E013 ()
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+E014 ()
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0x82, 0x82, 0x82, 0x82, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+E015 ()
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0x82, 0x82, 0x82, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+E016 ()
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0x82, 0x82, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+E017 ()
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0x82, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+E018 ()
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+E019 ()
	{ 0x00, 0x00, 0x00, 0x38, 0xfe, 0xfe, 0xfe, 0xd6, 0xfe, 0xfe, 0xba, 0xc6, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00 },	// U+E01A ()
}; // 11

static const unsigned char leggie_block165[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x10, 0x55, 0x00, 0x00, 0x00 },	// U+E020 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00 },	// U+E021 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x05, 0x00, 0x00, 0x00 },	// U+E022 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x14, 0x15, 0x00, 0x00, 0x00 },	// U+E023 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x50, 0x50, 0x54, 0x54, 0x55, 0x00, 0x00, 0x00 },	// U+E024 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x50, 0x50, 0x54, 0x54, 0x55, 0x00, 0x00, 0x00 },	// U+E025 ()
}; // 6

static const unsigned char leggie_block166[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x44, 0x28, 0x10, 0x29, 0x44, 0x10, 0x48, 0x20, 0x80, 0x00 },	// U+E030 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+E031 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x05, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+E032 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x12, 0x14, 0x15, 0x14, 0x12, 0x08, 0x00, 0x00, 0x00 },	// U+E033 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x48, 0x52, 0x54, 0x55, 0x54, 0x52, 0x48, 0x20, 0x00, 0x00 },	// U+E034 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0x48, 0x52, 0x54, 0x55, 0x54, 0x52, 0x48, 0x20, 0x80, 0x00 },	// U+E035 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x45, 0x29, 0x11, 0x29, 0x45, 0x00, 0x6c, 0x00, 0x00, 0x00 },	// U+E036 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x82, 0x01, 0x01, 0x01, 0x01, 0x6d, 0xee, 0x6c, 0x00, 0x00, 0x00 },	// U+E037 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x44, 0x28, 0x92, 0x28, 0x44, 0x10, 0xa0, 0xc0, 0x80, 0x00 },	// U+E038 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xa0, 0x90, 0x8e, 0x86, 0x8e, 0x90, 0xa0, 0xc0, 0x80, 0x00 },	// U+E039 ()
}; // 10

static const unsigned char leggie_block167[][18] = {
	{ 0x01, 0x21, 0x71, 0xa9, 0x25, 0x21, 0x21, 0x21, 0x21, 0x11, 0x09, 0x04, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+E0A0 ()
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x00, 0x00, 0x90, 0x90, 0xb0, 0xd0, 0x90, 0x90, 0x00, 0x00 },	// U+E0A1 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0xfe, 0xee, 0xee, 0xee, 0xfe, 0xfe, 0x7c, 0x00, 0x00, 0x00 },	// U+E0A2 ()
}; // 3

static const unsigned char leggie_block168[][18] = {
	{ 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01 },	// U+E0B0 ()
	{ 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01 },	// U+E0B1 ()
	{ 0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff, 0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x00 },	// U+E0B2 ()
	{ 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00 },	// U+E0B3 ()
}; // 4

static const unsigned char leggie_block169[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00 },	// U+F000 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x82, 0x02, 0x02, 0xce, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+F001 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x2e, 0x22, 0x22, 0x22, 0x22, 0x22, 0xc2, 0x00, 0x00, 0x00 },	// U+F002 ()
}; // 3

static const unsigned char leggie_block170[][18] = {
	{ 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F800 ()
	{ 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F801 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00 },	// U+F802 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff },	// U+F803 ()
}; // 4

static const unsigned char leggie_block171[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0xee, 0x00, 0xee, 0xee, 0xee, 0x00, 0x00, 0x00 },	// U+F810 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00 },	// U+F811 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x6c, 0x92, 0x42, 0x42, 0x42, 0x92, 0x6c, 0x00, 0x00, 0x00 },	// U+F812 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x6c, 0xfe, 0x7e, 0x7e, 0x7e, 0xfe, 0x6c, 0x00, 0x00, 0x00 },	// U+F813 ()
}; // 4

static const unsigned char leggie_block172[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x6c, 0xfe, 0x7e, 0x7e, 0x7e, 0xfe, 0x6c, 0x00, 0x00, 0x00 },	// U+F8FF ()
}; // 1

static const unsigned char leggie_block173[][18] = {
	{ 0x00, 0x00, 0x00, 0xdc, 0x22, 0x22, 0x22, 0x22, 0xee, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+FB00 (ﬀ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x82, 0x02, 0x02, 0xce, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00 },	// U+FB01 (ﬁ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x2e, 0x22, 0x22, 0x22, 0x22, 0x22, 0xc2, 0x00, 0x00, 0x00 },	// U+FB02 (ﬂ)
	{ 0x00, 0x00, 0x00, 0xee, 0x11, 0x11, 0x11, 0x11, 0xf7, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00 },	// U+FB03 (ﬃ)
	{ 0x00, 0x00, 0x00, 0x36, 0x49, 0x49, 0x49, 0x49, 0x5b, 0x49, 0x49, 0x49, 0x49, 0x49, 0x89, 0x00, 0x00, 0x00 },	// U+FB04 (ﬄ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x7a, 0x12, 0x12, 0x12, 0x12, 0x12, 0xe2, 0x00, 0x00, 0x00 },	// U+FB05 (ﬅ)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0xfe, 0x21, 0x21, 0x26, 0x28, 0x28, 0xc7, 0x00, 0x00, 0x00 },	// U+FB06 (ﬆ)
}; // 7

static const unsigned char leggie_block174[][18] = {
	{ 0x00, 0x00, 0x00, 0x1e, 0x09, 0x3e, 0x28, 0x28, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0xce, 0x00, 0x00, 0x00 },	// U+FB13 (ﬓ)
	{ 0x00, 0x00, 0x00, 0x38, 0x28, 0x28, 0x28, 0x28, 0xe9, 0x29, 0x29, 0x29, 0x29, 0x29, 0xce, 0x00, 0x00, 0x00 },	// U+FB14 (ﬔ)
	{ 0x00, 0x00, 0x00, 0x38, 0x28, 0x28, 0x28, 0x28, 0xe9, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2e, 0x20, 0x20, 0x20 },	// U+FB15 (ﬕ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x09, 0x3e, 0x28, 0x28, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0xce, 0x08, 0x08, 0x18 },	// U+FB16 (ﬖ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x14, 0x14, 0x14, 0x14, 0x35, 0x55, 0x55, 0x55, 0x55, 0x55, 0x96, 0x10, 0x10, 0x30 },	// U+FB17 (ﬗ)
}; // 5

static const unsigned char leggie_block175[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+FE50 (﹐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE51 (﹑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+FE52 (﹒)
}; // 3

static const unsigned char leggie_block176[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+FE54 (﹔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+FE55 (﹕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x80, 0x60, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+FE56 (﹖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00 },	// U+FE57 (﹗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE58 (﹘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+FE59 (﹙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+FE5A (﹚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x08, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+FE5B (﹛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x10, 0x20, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+FE5C (﹜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0x00, 0x00, 0x00 },	// U+FE5D (﹝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x00, 0x00, 0x00 },	// U+FE5E (﹞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xfe, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x00, 0x00, 0x00 },	// U+FE5F (﹟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x3c, 0x82, 0x42, 0xbc, 0x00, 0x00, 0x00 },	// U+FE60 (﹠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x7c, 0x10, 0x28, 0x00, 0x00, 0x00, 0x00 },	// U+FE61 (﹡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+FE62 (﹢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE63 (﹣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00 },	// U+FE64 (﹤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00 },	// U+FE65 (﹥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FE66 (﹦)
}; // 19

static const unsigned char leggie_block177[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00 },	// U+FE68 (﹨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xfc, 0x02, 0x7c, 0x80, 0x7e, 0x10, 0x00, 0x00, 0x00 },	// U+FE69 (﹩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x4a, 0x24, 0x10, 0x48, 0xa4, 0x42, 0x00, 0x00, 0x00 },	// U+FE6A (﹪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0xf2, 0x8a, 0x72, 0x04, 0x78, 0x00, 0x00, 0x00 },	// U+FE6B (﹫)
}; // 4

static const unsigned char leggie_block178[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x44, 0xbe, 0xbf, 0xdf, 0xef, 0xfe, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+FFFD (�)
}; // 1

static const unsigned char leggie_block179[][18] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xaa, 0xaa, 0x92, 0x92, 0xaa, 0xaa, 0xc6, 0xc6, 0xfe, 0x00, 0x00 },	// U+FFFF (￿)
}; // 1

