/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font kates-7x15.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char kates_block1[][15] = {
	{ 0x00, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+0000 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+0001 (ESC)
	{ 0x00, 0x2a, 0x14, 0x2a, 0x14, 0x2a, 0x14, 0x2a, 0x14, 0x2a, 0x14, 0x2a, 0x14, 0x00, 0x00 },	// U+0002 (ESC)
}; // 3

static const unsigned char kates_block2[][15] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0009 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+000A (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+000B (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+000C (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+000D (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+000E (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+000F (ESC)
	{ 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0010 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0011 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0012 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0013 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00 },	// U+0014 (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+0015 (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+0016 (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0017 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+0018 (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+0019 (ESC)
}; // 17

static const unsigned char kates_block3[][15] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001B (ESC)
}; // 1

static const unsigned char kates_block4[][15] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x7f, 0x14, 0x14, 0x7f, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x49, 0x09, 0x3e, 0x48, 0x49, 0x3e, 0x08, 0x08, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x00, 0x26, 0x22, 0x10, 0x08, 0x08, 0x04, 0x22, 0x32, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x09, 0x06, 0x05, 0x29, 0x31, 0x1e, 0x00, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x08, 0x00, 0x00 },	// U+0028 (()
	{ 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x2a, 0x36, 0x08, 0x36, 0x2a, 0x08, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x04, 0x02, 0x00, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x20, 0x1c, 0x02, 0x02, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x0e, 0x10, 0x10, 0x10, 0x0e, 0x00, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x02, 0x02, 0x1c, 0x20, 0x20, 0x20, 0x1c, 0x00, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x00, 0x1c, 0x02, 0x02, 0x02, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x20, 0x00, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x04, 0x00, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x20, 0x20, 0x1c, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x32, 0x2a, 0x2a, 0x1a, 0x02, 0x3c, 0x00, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x03, 0x04, 0x08, 0x10, 0x21, 0x21, 0x21, 0x3f, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x0f, 0x10, 0x10, 0x1f, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1f, 0x00, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x3c, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3e, 0x00, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x03, 0x04, 0x08, 0x11, 0x21, 0x21, 0x21, 0x21, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x3f, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x3f, 0x00, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x3f, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x1e, 0x21, 0x01, 0x01, 0x01, 0x01, 0x39, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x21, 0x21, 0x21, 0x20, 0x20, 0x3f, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x1f, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x1f, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x08, 0x04, 0x03, 0x00, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x01, 0x11, 0x09, 0x05, 0x02, 0x05, 0x09, 0x11, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3f, 0x00, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x21, 0x33, 0x3e, 0x2c, 0x2d, 0x29, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x21, 0x23, 0x22, 0x24, 0x25, 0x29, 0x29, 0x31, 0x31, 0x21, 0x00, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x1e, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x1f, 0x20, 0x20, 0x20, 0x1f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x1e, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x25, 0x29, 0x1e, 0x20, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x1f, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x1e, 0x21, 0x21, 0x01, 0x0e, 0x10, 0x20, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x3f, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x21, 0x21, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x21, 0x21, 0x20, 0x20, 0x21, 0x11, 0x09, 0x05, 0x03, 0x01, 0x00, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x21, 0x21, 0x20, 0x20, 0x21, 0x21, 0x25, 0x23, 0x39, 0x21, 0x00, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x21, 0x21, 0x21, 0x12, 0x0c, 0x0c, 0x12, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x21, 0x21, 0x21, 0x22, 0x14, 0x18, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x3f, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x3f, 0x00, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x00, 0x00, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x00, 0x00, 0x00 },	// U+005B ([)
	{ 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+005C (\)
	{ 0x00, 0x00, 0x00, 0x3c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x00, 0x00, 0x00 },	// U+005D (])
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00 },	// U+005F (_)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x21, 0x21, 0x11, 0x2e, 0x00, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x1e, 0x20, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x01, 0x1e, 0x00, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x1e, 0x01, 0x21, 0x21, 0x21, 0x3e, 0x00, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x2b, 0x15, 0x01, 0x3e, 0x00, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x38, 0x04, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x21, 0x21, 0x21, 0x3e, 0x20, 0x20, 0x1f, 0x00 },	// U+0067 (g)
	{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x1e, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x0f, 0x00 },	// U+006A (j)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x09, 0x04, 0x02, 0x05, 0x09, 0x11, 0x31, 0x00, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x1e, 0x00, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x14, 0x29, 0x25, 0x29, 0x25, 0x00, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x20, 0x20, 0x20, 0x1f, 0x01, 0x01, 0x01, 0x00 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x01, 0x01, 0x01, 0x3e, 0x20, 0x20, 0x20, 0x00 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x01, 0x1e, 0x20, 0x20, 0x1f, 0x00, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x3f, 0x04, 0x04, 0x04, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x11, 0x09, 0x05, 0x03, 0x01, 0x00, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x29, 0x2d, 0x3b, 0x29, 0x00, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x14, 0x2b, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x10, 0x0f, 0x00 },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x20, 0x34, 0x0a, 0x01, 0x3f, 0x00, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x00, 0x00, 0x38, 0x04, 0x04, 0x04, 0x02, 0x02, 0x04, 0x04, 0x04, 0x38, 0x00, 0x00 },	// U+007B ({)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+007C (|)
	{ 0x00, 0x00, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x20, 0x20, 0x10, 0x10, 0x10, 0x0e, 0x00, 0x00 },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
}; // 95

static const unsigned char kates_block5[][15] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0x09, 0x09, 0x09, 0x09, 0x3e, 0x08, 0x00, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x02, 0x02, 0x02, 0x1f, 0x02, 0x02, 0x3d, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x42, 0x3c, 0x24, 0x24, 0x3c, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x3e, 0x08, 0x3e, 0x08, 0x1c, 0x08, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x00, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x00, 0x30, 0x48, 0x08, 0x1c, 0x22, 0x22, 0x1c, 0x08, 0x09, 0x06, 0x00, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x0e, 0x21, 0x28, 0x25, 0x25, 0x25, 0x09, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x00, 0x1f, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x12, 0x09, 0x12, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+00AC (¬)
}; // 12

static const unsigned char kates_block6[][15] = {
	{ 0x00, 0x00, 0x00, 0x0e, 0x21, 0x2e, 0x2a, 0x26, 0x2a, 0x0a, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x00, 0x00, 0x0e, 0x08, 0x0e, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x00, 0x00, 0x0e, 0x08, 0x0c, 0x08, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1f, 0x01, 0x01, 0x00 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x09, 0x09, 0x09, 0x3e, 0x28, 0x28, 0x28, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x1c, 0x00, 0x00 },	// U+00B8 (¸)
	{ 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x12, 0x09, 0x12, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x3e, 0x00, 0x14, 0x14, 0x1c, 0x10, 0x10, 0x00, 0x00 },	// U+00BC (¼)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x3e, 0x00, 0x1c, 0x10, 0x1c, 0x04, 0x1c, 0x00, 0x00 },	// U+00BD (½)
	{ 0x1c, 0x10, 0x18, 0x10, 0x1c, 0x00, 0x3e, 0x00, 0x14, 0x14, 0x1c, 0x10, 0x10, 0x00, 0x00 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x04, 0x02, 0x02, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+00BF (¿)
	{ 0x04, 0x08, 0x13, 0x04, 0x08, 0x10, 0x21, 0x21, 0x21, 0x3f, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x40, 0x20, 0x13, 0x04, 0x08, 0x10, 0x21, 0x21, 0x21, 0x3f, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x10, 0x28, 0x43, 0x04, 0x08, 0x10, 0x21, 0x21, 0x21, 0x3f, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x50, 0x28, 0x03, 0x04, 0x08, 0x10, 0x21, 0x21, 0x21, 0x3f, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x12, 0x00, 0x03, 0x04, 0x08, 0x10, 0x21, 0x21, 0x21, 0x3f, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x10, 0x28, 0x13, 0x04, 0x08, 0x10, 0x21, 0x21, 0x21, 0x3f, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x34, 0x09, 0x09, 0x19, 0x0f, 0x09, 0x39, 0x00, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x3c, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x36, 0x08, 0x00, 0x00 },	// U+00C7 (Ç)
	{ 0x04, 0x08, 0x3f, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x3f, 0x00, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x08, 0x04, 0x3f, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x3f, 0x00, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x08, 0x14, 0x00, 0x3f, 0x00, 0x00, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x3f, 0x00, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x14, 0x00, 0x3f, 0x00, 0x00, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x3f, 0x00, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x02, 0x04, 0x1f, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x08, 0x04, 0x1f, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x04, 0x0a, 0x00, 0x1f, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x0a, 0x00, 0x1f, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x03, 0x04, 0x08, 0x11, 0x21, 0x21, 0x23, 0x21, 0x11, 0x0f, 0x00, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x28, 0x14, 0x01, 0x23, 0x22, 0x24, 0x25, 0x29, 0x29, 0x31, 0x31, 0x21, 0x00, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x02, 0x04, 0x1e, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x10, 0x08, 0x1e, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x04, 0x0a, 0x00, 0x1e, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x14, 0x0a, 0x00, 0x1e, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x00, 0x0a, 0x00, 0x1e, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x1e, 0x29, 0x25, 0x29, 0x25, 0x1e, 0x01, 0x01, 0x00 },	// U+00D8 (Ø)
	{ 0x04, 0x08, 0x21, 0x21, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x08, 0x04, 0x21, 0x21, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x08, 0x14, 0x01, 0x21, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x14, 0x14, 0x01, 0x21, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x08, 0x04, 0x21, 0x21, 0x21, 0x22, 0x14, 0x18, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x1f, 0x20, 0x20, 0x1f, 0x01, 0x01, 0x01, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x11, 0x09, 0x05, 0x09, 0x05, 0x01, 0x01, 0x01, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x1c, 0x20, 0x21, 0x21, 0x11, 0x2e, 0x00, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x00, 0x20, 0x10, 0x08, 0x00, 0x1c, 0x20, 0x21, 0x21, 0x11, 0x2e, 0x00, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x00, 0x08, 0x14, 0x20, 0x00, 0x1c, 0x20, 0x21, 0x21, 0x11, 0x2e, 0x00, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x00, 0x28, 0x14, 0x00, 0x1c, 0x20, 0x21, 0x21, 0x11, 0x2e, 0x00, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x1c, 0x20, 0x21, 0x21, 0x11, 0x2e, 0x00, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x00, 0x08, 0x14, 0x08, 0x00, 0x1c, 0x20, 0x21, 0x21, 0x11, 0x2e, 0x00, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x25, 0x2d, 0x15, 0x05, 0x3e, 0x00, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x01, 0x01, 0x05, 0x1a, 0x04, 0x00, 0x00 },	// U+00E7 (ç)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x1e, 0x21, 0x2b, 0x15, 0x01, 0x3e, 0x00, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x1e, 0x21, 0x2b, 0x15, 0x01, 0x3e, 0x00, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x00, 0x1e, 0x21, 0x2b, 0x15, 0x01, 0x3e, 0x00, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x1e, 0x21, 0x2b, 0x15, 0x01, 0x3e, 0x00, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x00, 0x08, 0x14, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x00, 0x00, 0x12, 0x12, 0x0e, 0x21, 0x3e, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x00, 0x14, 0x0a, 0x00, 0x1e, 0x20, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x1e, 0x20, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x1e, 0x20, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x00, 0x1e, 0x20, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0x00, 0x28, 0x14, 0x00, 0x1e, 0x20, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x1e, 0x20, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x36, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x1e, 0x25, 0x29, 0x25, 0x29, 0x1e, 0x01, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x12, 0x12, 0x00, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x00, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x10, 0x0f, 0x00 },	// U+00FD (ý)
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x1f, 0x20, 0x20, 0x20, 0x1f, 0x01, 0x01, 0x01, 0x00 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x10, 0x0f, 0x00 },	// U+00FF (ÿ)
}; // 82

