/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font fkp-8x16.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char fkp_block1[][16] = {
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+0000 (ESC)
	{ 0x00, 0x00, 0x3c, 0x42, 0x81, 0xa5, 0x81, 0x81, 0xa5, 0x99, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0001 (ESC)
	{ 0x00, 0x00, 0x3c, 0x7e, 0xff, 0xdb, 0xff, 0xff, 0xdb, 0xe7, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0002 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0003 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0004 (ESC)
	{ 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x5a, 0xff, 0xff, 0x5a, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0005 (ESC)
	{ 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0xff, 0x5a, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0006 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0007 (ESC)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+0008 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0009 (ESC)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+000A (ESC)
	{ 0x00, 0x00, 0xf0, 0xe0, 0xb0, 0x18, 0x7e, 0xc3, 0xc3, 0xc3, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+000B (ESC)
	{ 0x00, 0x00, 0x7e, 0xc3, 0xc3, 0x63, 0x3e, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+000C (ESC)
	{ 0x00, 0x00, 0x20, 0x60, 0xe0, 0xa0, 0x20, 0x20, 0x20, 0x3c, 0x3e, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+000D (ESC)
	{ 0x00, 0x08, 0x18, 0x38, 0x78, 0x68, 0x48, 0x48, 0x4e, 0x4f, 0x46, 0x70, 0x78, 0x30, 0x00, 0x00 },	// U+000E (ESC)
	{ 0x00, 0x00, 0x18, 0x18, 0xdb, 0x7e, 0x3c, 0xff, 0x3c, 0x7e, 0xdb, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+000F (ESC)
	{ 0x00, 0x02, 0x06, 0x0e, 0x1e, 0x3e, 0x7e, 0x3e, 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+0010 (ESC)
	{ 0x00, 0x40, 0x60, 0x70, 0x78, 0x7c, 0x7e, 0x7c, 0x78, 0x70, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+0011 (ESC)
	{ 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00 },	// U+0012 (ESC)
	{ 0x00, 0x00, 0x66, 0xff, 0xff, 0xff, 0xff, 0x66, 0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00 },	// U+0013 (ESC)
	{ 0x00, 0x00, 0xfe, 0xdb, 0xdb, 0xdb, 0xde, 0xdc, 0xf8, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00 },	// U+0014 (ESC)
	{ 0x00, 0x78, 0x0c, 0x1e, 0x3b, 0x73, 0xe7, 0xce, 0xdc, 0x78, 0x30, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0015 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0016 (ESC)
	{ 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x7e, 0x00, 0x00 },	// U+0017 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+0018 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x1c, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+0019 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x3f, 0x7f, 0x3f, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+001A (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x7e, 0x7f, 0x7e, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+001B (ESC)
	{ 0x00, 0x00, 0xcc, 0x66, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001C (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0xff, 0xff, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001D (ESC)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001E (ESC)
	{ 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001F (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x00, 0x7e, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x36, 0x36, 0x7f, 0x36, 0x36, 0x36, 0x36, 0x7f, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x08, 0x3e, 0x6b, 0x0b, 0x0e, 0x1c, 0x38, 0x68, 0x68, 0x6b, 0x3e, 0x08, 0x00, 0x00, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x0e, 0xdb, 0x6e, 0x30, 0x18, 0x0c, 0x76, 0xdb, 0x70, 0x00, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x0e, 0x1b, 0x73, 0x33, 0x3b, 0x6e, 0x00, 0x00, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x00, 0x38, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x60, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00 },	// U+0028 (()
	{ 0x00, 0x06, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7f, 0x1c, 0x1c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18, 0x0c, 0x04, 0x00, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x60, 0x20, 0x30, 0x10, 0x18, 0x08, 0x0c, 0x04, 0x06, 0x02, 0x03, 0x00, 0x00, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x6b, 0x6b, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x18, 0x1c, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x3e, 0x63, 0x60, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x3e, 0x63, 0x60, 0x60, 0x38, 0x60, 0x60, 0x60, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x30, 0x38, 0x3c, 0x36, 0x33, 0x33, 0x7f, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x7f, 0x03, 0x03, 0x3f, 0x60, 0x60, 0x60, 0x60, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x3c, 0x06, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x7f, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x3e, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x30, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x0c, 0x04, 0x00, 0x00, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x3e, 0x63, 0x60, 0x60, 0x30, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x3c, 0x66, 0x73, 0x7b, 0x7b, 0x7b, 0x7b, 0x33, 0x06, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x1f, 0x33, 0x33, 0x33, 0x3f, 0x63, 0x63, 0x63, 0x33, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x3c, 0x66, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x3f, 0x03, 0x03, 0x03, 0x3f, 0x03, 0x03, 0x03, 0x03, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x3f, 0x03, 0x03, 0x03, 0x3f, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x3c, 0x66, 0x03, 0x03, 0x03, 0x7b, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x63, 0x33, 0x1b, 0x0f, 0x07, 0x07, 0x0f, 0x1b, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x41, 0x63, 0x77, 0x7f, 0x6b, 0x6b, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x61, 0x63, 0x67, 0x6f, 0x7f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x33, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6f, 0x3b, 0x1e, 0x30, 0x60, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x33, 0x1f, 0x33, 0x33, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x3c, 0x66, 0x03, 0x03, 0x3e, 0x60, 0x60, 0x60, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x7f, 0x77, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x1c, 0x36, 0x36, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x63, 0x63, 0x36, 0x36, 0x1c, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x7f, 0x60, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x7c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x7c, 0x00, 0x00, 0x00 },	// U+005B ([)
	{ 0x00, 0x00, 0x03, 0x02, 0x06, 0x04, 0x0c, 0x08, 0x18, 0x10, 0x30, 0x20, 0x60, 0x00, 0x00, 0x00 },	// U+005C (\)
	{ 0x00, 0x3e, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3e, 0x00, 0x00, 0x00 },	// U+005D (])
	{ 0x00, 0x08, 0x1c, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00 },	// U+005F (_)
	{ 0x00, 0x00, 0x1c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x7c, 0x66, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x60, 0x60, 0x60, 0x7c, 0x66, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x63, 0x33, 0x1f, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x06, 0x0f, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x30, 0x1e, 0x00 },	// U+0067 (g)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x33, 0x1e, 0x00 },	// U+006A (j)
	{ 0x00, 0x00, 0x03, 0x03, 0x03, 0x33, 0x1b, 0x0f, 0x0f, 0x1f, 0x33, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x6b, 0x6b, 0x6b, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x33, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x00 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x60, 0x60, 0x00 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x03, 0x3e, 0x60, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x10, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x36, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x6b, 0x6b, 0x7f, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x36, 0x1c, 0x08, 0x1c, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x30, 0x1e, 0x00 },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00 },	// U+007B ({)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+007C (|)
	{ 0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x70, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00 },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007F ()
	{ 0x00, 0x00, 0x3c, 0x66, 0x03, 0x03, 0x03, 0x03, 0x03, 0x63, 0x3e, 0x18, 0x0e, 0x00, 0x00, 0x00 },	// U+0080 ()
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0081 ()
	{ 0x00, 0x30, 0x18, 0x08, 0x00, 0x3e, 0x63, 0x63, 0x33, 0x1f, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0082 ()
	{ 0x00, 0x10, 0x38, 0x64, 0x00, 0x3c, 0x60, 0x7c, 0x66, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0083 ()
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3c, 0x60, 0x7c, 0x66, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0084 ()
	{ 0x00, 0x04, 0x08, 0x18, 0x00, 0x3c, 0x60, 0x7c, 0x66, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0085 ()
	{ 0x18, 0x34, 0x34, 0x18, 0x00, 0x3c, 0x60, 0x7c, 0x66, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0086 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x03, 0x03, 0x63, 0x3e, 0x18, 0x0e, 0x00, 0x00, 0x00 },	// U+0087 ()
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x33, 0x1f, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0088 ()
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3e, 0x63, 0x63, 0x33, 0x1f, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0089 ()
	{ 0x00, 0x06, 0x04, 0x08, 0x00, 0x3e, 0x63, 0x63, 0x33, 0x1f, 0x03, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+008A ()
	{ 0x00, 0x00, 0x66, 0x66, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+008B ()
	{ 0x00, 0x18, 0x3c, 0x66, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+008C ()
	{ 0x00, 0x06, 0x0c, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+008D ()
	{ 0x36, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+008E ()
	{ 0x1c, 0x36, 0x36, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+008F ()
	{ 0x18, 0x08, 0x04, 0x3f, 0x03, 0x03, 0x3f, 0x03, 0x03, 0x03, 0x03, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+0090 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd8, 0xde, 0xfb, 0x1b, 0x1b, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+0091 ()
	{ 0x00, 0x00, 0x7c, 0x1c, 0x1c, 0x1e, 0x7a, 0x1a, 0x1f, 0x1b, 0x1b, 0x7b, 0x00, 0x00, 0x00, 0x00 },	// U+0092 ()
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0093 ()
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0094 ()
	{ 0x00, 0x06, 0x04, 0x08, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0095 ()
	{ 0x00, 0x08, 0x1c, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0096 ()
	{ 0x00, 0x06, 0x04, 0x08, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0097 ()
	{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7e, 0x60, 0x60, 0x30, 0x1e, 0x00 },	// U+0098 ()
	{ 0x36, 0x36, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+0099 ()
	{ 0x36, 0x36, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+009A ()
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3c, 0x6e, 0x0b, 0x0b, 0x0b, 0x6b, 0x3e, 0x08, 0x08, 0x00, 0x00 },	// U+009B ()
	{ 0x00, 0x00, 0x78, 0x4c, 0x0c, 0x0c, 0x1e, 0x0c, 0x0c, 0x0c, 0x0f, 0x7b, 0x00, 0x00, 0x00, 0x00 },	// U+009C ()
	{ 0x00, 0x00, 0x00, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+009D ()
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x33, 0x1f, 0x33, 0x7b, 0x33, 0x33, 0x60, 0x00, 0x00, 0x00 },	// U+009E ()
	{ 0x00, 0x00, 0x38, 0x6c, 0x6c, 0x0c, 0x7e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x00, 0x00, 0x00 },	// U+009F ()
	{ 0x00, 0x30, 0x18, 0x08, 0x00, 0x3c, 0x60, 0x7c, 0x66, 0x63, 0x63, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x60, 0x30, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x30, 0x18, 0x08, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x18, 0x08, 0x04, 0x00, 0x63, 0x63, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x36, 0x1b, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x36, 0x1b, 0x00, 0x63, 0x67, 0x6f, 0x7f, 0x7b, 0x73, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x00, 0x1c, 0x30, 0x3c, 0x36, 0x33, 0x33, 0x3e, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x00, 0x1c, 0x36, 0x33, 0x33, 0x33, 0x1b, 0x0e, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x0e, 0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x06, 0x07, 0x46, 0x66, 0x36, 0x18, 0x0c, 0x06, 0x03, 0x39, 0x6c, 0x30, 0x18, 0x7c, 0x00 },	// U+00AB («)
	{ 0x00, 0x06, 0x87, 0xc6, 0x66, 0x36, 0x18, 0x0c, 0x66, 0x73, 0x69, 0x7c, 0x60, 0x60, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x36, 0x1b, 0x36, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x36, 0x6c, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22 },	// U+00B0 (°)
	{ 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55 },	// U+00B1 (±)
	{ 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee },	// U+00B2 (²)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00B3 (³)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00B4 (´)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00B5 (µ)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00B8 (¸)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x60, 0x60, 0x67, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00B9 (¹)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x60, 0x60, 0x67, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00BB (»)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x60, 0x60, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BC (¼)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BD (½)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00BF (¿)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00C2 (Â)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00C3 (Ã)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00C5 (Å)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00C6 (Æ)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00C7 (Ç)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0xe6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00C9 (É)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xe7, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xe7, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00CB (Ë)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x06, 0x06, 0xe6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00CC (Ì)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xe7, 0x00, 0x00, 0xe7, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00CE (Î)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00D1 (Ñ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00D2 (Ò)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00D5 (Õ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00D6 (Ö)
	{ 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66 },	// U+00D7 (×)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00D8 (Ø)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00DA (Ú)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+00DB (Û)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff },	// U+00DC (Ü)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+00DD (Ý)
	{ 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0 },	// U+00DE (Þ)
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x33, 0x33, 0x7b, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x00, 0x00, 0x3c, 0x66, 0x63, 0x33, 0x63, 0x63, 0x63, 0x33, 0x1b, 0x03, 0x03, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x00, 0x00, 0x7f, 0x66, 0x46, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0x7f, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x7f, 0x63, 0x46, 0x0c, 0x18, 0x18, 0x0c, 0x46, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x36, 0x33, 0x33, 0x33, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x36, 0x1e, 0x06, 0x06, 0x03, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00E7 (ç)
	{ 0x00, 0x00, 0x18, 0x18, 0x7e, 0xdb, 0xdb, 0xdb, 0xdb, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x63, 0x36, 0x14, 0x55, 0x77, 0x00, 0x00, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x78, 0x0c, 0x18, 0x30, 0x7c, 0x66, 0x63, 0x63, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xdb, 0xdb, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x00, 0x00, 0xc0, 0x60, 0x7e, 0xf3, 0xdb, 0xcf, 0x7e, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x00, 0x78, 0x0c, 0x06, 0x06, 0x7e, 0x06, 0x06, 0x06, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x00, 0x3c, 0x66, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x00, 0x00, 0x70, 0xd8, 0xd8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+00F4 (ô)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x00, 0x6e, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x3c, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x00, 0xc0, 0x40, 0x60, 0x20, 0x30, 0x10, 0x1b, 0x0f, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x3f, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x00, 0x1e, 0x33, 0x18, 0x0c, 0x06, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00FD (ý)
	{ 0x00, 0x00, 0x00, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00FF (ÿ)
}; // 256

