/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font fatty7x16-iso10646-1.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char fatty_block1[][16] = {
	{ 0x00, 0x00, 0x00, 0x2a, 0x00, 0x22, 0x00, 0x22, 0x00, 0x22, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x00 },	// U+0000 (ESC)
}; // 1

static const unsigned char fatty_block2[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x00, 0x12, 0x12, 0x3f, 0x3f, 0x12, 0x12, 0x3f, 0x3f, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x00, 0x00, 0x0c, 0x3e, 0x3d, 0x0d, 0x1f, 0x3e, 0x2c, 0x2f, 0x1f, 0x0c, 0x00, 0x00, 0x00 },	// U+0024 ($)
	{ 0x00, 0x00, 0x00, 0x26, 0x39, 0x19, 0x1e, 0x0c, 0x0c, 0x1e, 0x26, 0x27, 0x19, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x0e, 0x2e, 0x3b, 0x1b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x30, 0x00 },	// U+0028 (()
	{ 0x00, 0x00, 0x06, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x06, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x2a, 0x1c, 0x3e, 0x1c, 0x2a, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x3f, 0x3f, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0e, 0x06, 0x03, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x0c, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x00, 0x20, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x03, 0x03, 0x01, 0x00, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x33, 0x33, 0x3b, 0x37, 0x33, 0x33, 0x1e, 0x0c, 0x00, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0e, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x30, 0x30, 0x18, 0x0c, 0x06, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x18, 0x0c, 0x1c, 0x38, 0x30, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x00, 0x18, 0x1c, 0x1e, 0x1e, 0x1b, 0x1b, 0x3f, 0x3f, 0x18, 0x18, 0x00, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x03, 0x1f, 0x3f, 0x30, 0x30, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x1f, 0x3f, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x1e, 0x1e, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x3e, 0x30, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x0c, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x1c, 0x0e, 0x06, 0x03, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x00, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x31, 0x30, 0x18, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x33, 0x3b, 0x29, 0x29, 0x2b, 0x33, 0x0e, 0x1c, 0x00, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x33, 0x33, 0x1f, 0x1f, 0x33, 0x33, 0x3f, 0x1f, 0x00, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x03, 0x03, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1f, 0x0f, 0x00, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x03, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x03, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x3b, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x00, 0x21, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x00, 0x31, 0x33, 0x33, 0x37, 0x37, 0x3b, 0x3b, 0x33, 0x33, 0x23, 0x00, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x33, 0x33, 0x3f, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x1e, 0x30, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x33, 0x33, 0x3f, 0x1f, 0x1b, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x0e, 0x1c, 0x30, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x1e, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x00, 0x21, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x21, 0x00, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x1e, 0x1e, 0x0c, 0x0c, 0x1e, 0x1e, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x30, 0x18, 0x0c, 0x0c, 0x06, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x00, 0x1e, 0x1e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1e, 0x1e, 0x00 },	// U+005B ([)
	{ 0x00, 0x00, 0x01, 0x03, 0x03, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x20, 0x00, 0x00 },	// U+005C (\)
	{ 0x00, 0x00, 0x1e, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1e, 0x1e, 0x00 },	// U+005D (])
	{ 0x00, 0x00, 0x0c, 0x1e, 0x33, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00 },	// U+005F (_)
	{ 0x00, 0x00, 0x0e, 0x1c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3e, 0x30, 0x3e, 0x3f, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x1b, 0x3f, 0x37, 0x33, 0x33, 0x37, 0x3f, 0x1d, 0x00, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x00, 0x00, 0x30, 0x30, 0x36, 0x3f, 0x3b, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x03, 0x07, 0x1e, 0x00, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x26, 0x06, 0x1f, 0x1f, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x36, 0x30, 0x33, 0x3f, 0x1e },	// U+0067 (g)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x1b, 0x3f, 0x37, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x18, 0x18, 0x00, 0x1c, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x19, 0x1f, 0x0e, 0x00 },	// U+006A (j)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x33, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x3f, 0x37, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1b, 0x03, 0x03, 0x03, 0x03 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x36, 0x30, 0x30, 0x30, 0x30 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x3f, 0x27, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x37, 0x03, 0x1f, 0x3e, 0x30, 0x3b, 0x1e, 0x00, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x1f, 0x1f, 0x06, 0x06, 0x06, 0x26, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x1e, 0x1e, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x00, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x1e, 0x0c, 0x0c, 0x1e, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x36, 0x30, 0x31, 0x3f, 0x1e },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x30, 0x1c, 0x0e, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x38, 0x1c, 0x0c, 0x0c, 0x0c, 0x0c, 0x07, 0x07, 0x0c, 0x0c, 0x0c, 0x0c, 0x1c, 0x38, 0x00 },	// U+007B ({)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00 },	// U+007C (|)
	{ 0x00, 0x07, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x38, 0x38, 0x0c, 0x0c, 0x0c, 0x0c, 0x0e, 0x07, 0x00 },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x3f, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
	{ 0x00, 0x03, 0x05, 0x05, 0x05, 0x03, 0x1c, 0x04, 0x0c, 0x04, 0x1c, 0x00, 0x10, 0x10, 0x10, 0x70 },	// U+007F ()
}; // 96

static const unsigned char fatty_block3[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x3e, 0x2b, 0x0b, 0x0b, 0x0b, 0x2b, 0x3e, 0x18, 0x00, 0x00, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x26, 0x06, 0x1f, 0x1f, 0x06, 0x06, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x3f, 0x12, 0x12, 0x3f, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x00, 0x00, 0x21, 0x21, 0x33, 0x1e, 0x0c, 0x3f, 0x0c, 0x3f, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x00, 0x00, 0x3c, 0x3e, 0x06, 0x1c, 0x36, 0x22, 0x36, 0x1c, 0x30, 0x3e, 0x1e, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x1c, 0x3e, 0x63, 0x59, 0x4d, 0x45, 0x4d, 0x59, 0x63, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x00, 0x1c, 0x3c, 0x30, 0x3c, 0x36, 0x3e, 0x2c, 0x00, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x6c, 0x36, 0x1b, 0x36, 0x6c, 0x58, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x00, 0x00, 0x1c, 0x3e, 0x63, 0x55, 0x5d, 0x4d, 0x4d, 0x4d, 0x63, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+00AE (®)
	{ 0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x00, 0x3f, 0x3f, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x00, 0x00, 0x1c, 0x3e, 0x30, 0x18, 0x0c, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x00, 0x00, 0x3e, 0x30, 0x1c, 0x30, 0x32, 0x3e, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x00, 0x00, 0x38, 0x1c, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x3f, 0x2f, 0x03, 0x03, 0x00, 0x00 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x00, 0x7e, 0x6b, 0x69, 0x69, 0x6b, 0x6e, 0x68, 0x68, 0x68, 0x68, 0x00, 0x00, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x0d, 0x06, 0x00 },	// U+00B8 (¸)
	{ 0x00, 0x00, 0x38, 0x3c, 0x36, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x1b, 0x36, 0x6c, 0x36, 0x1b, 0x0d, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x00, 0x00, 0x06, 0x07, 0x06, 0x06, 0x06, 0x06, 0x60, 0x70, 0x68, 0x64, 0x7c, 0x60, 0x00, 0x00 },	// U+00BC (¼)
	{ 0x00, 0x00, 0x06, 0x07, 0x06, 0x06, 0x06, 0x06, 0x38, 0x7c, 0x60, 0x30, 0x18, 0x7c, 0x7c, 0x00 },	// U+00BD (½)
	{ 0x00, 0x00, 0x1f, 0x18, 0x0e, 0x18, 0x19, 0x1f, 0x6e, 0x70, 0x68, 0x64, 0x7c, 0x60, 0x00, 0x00 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x06, 0x03, 0x23, 0x3f, 0x1e, 0x00 },	// U+00BF (¿)
	{ 0x06, 0x0c, 0x08, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x18, 0x0c, 0x04, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x2e, 0x1d, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x33, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x1e, 0x33, 0x1e, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x00, 0x3e, 0x3f, 0x09, 0x09, 0x3f, 0x3f, 0x09, 0x09, 0x39, 0x39, 0x00, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x03, 0x03, 0x33, 0x3f, 0x1e, 0x08, 0x1a, 0x0c },	// U+00C7 (Ç)
	{ 0x06, 0x0c, 0x08, 0x00, 0x3f, 0x3f, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x18, 0x0c, 0x04, 0x00, 0x3f, 0x3f, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x3f, 0x3f, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x33, 0x33, 0x00, 0x3f, 0x3f, 0x03, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x06, 0x0c, 0x08, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x18, 0x0c, 0x04, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x33, 0x33, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3e, 0x66, 0x66, 0x6f, 0x6f, 0x66, 0x66, 0x3e, 0x1e, 0x00, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x2e, 0x1d, 0x00, 0x31, 0x33, 0x33, 0x37, 0x37, 0x3b, 0x3b, 0x33, 0x33, 0x23, 0x00, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x06, 0x0c, 0x08, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x18, 0x0c, 0x04, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x2e, 0x1d, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x33, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x33, 0x1e, 0x0c, 0x1e, 0x33, 0x21, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x00, 0x20, 0x3e, 0x1f, 0x33, 0x3b, 0x3b, 0x37, 0x37, 0x33, 0x3e, 0x1f, 0x01, 0x00, 0x00 },	// U+00D8 (Ø)
	{ 0x06, 0x0c, 0x08, 0x23, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x18, 0x0c, 0x04, 0x31, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x33, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x18, 0x0c, 0x04, 0x31, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x00, 0x07, 0x03, 0x1f, 0x3f, 0x33, 0x33, 0x3f, 0x1f, 0x03, 0x07, 0x00, 0x00, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x13, 0x13, 0x0b, 0x0b, 0x13, 0x23, 0x23, 0x2b, 0x13, 0x03, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x06, 0x0c, 0x08, 0x00, 0x1e, 0x3e, 0x30, 0x3e, 0x3f, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x18, 0x0c, 0x04, 0x00, 0x1e, 0x3e, 0x30, 0x3e, 0x3f, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x1e, 0x3e, 0x30, 0x3e, 0x3f, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x00, 0x2e, 0x1d, 0x00, 0x1e, 0x3e, 0x30, 0x3e, 0x3f, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x33, 0x33, 0x00, 0x1e, 0x3e, 0x30, 0x3e, 0x3f, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x00, 0x1e, 0x33, 0x1e, 0x00, 0x1e, 0x3e, 0x30, 0x3e, 0x3f, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x7e, 0x4c, 0x4f, 0x79, 0x19, 0x3f, 0x66, 0x00, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x33, 0x3f, 0x1e, 0x08, 0x1a, 0x0c },	// U+00E7 (ç)
	{ 0x00, 0x06, 0x0c, 0x08, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x03, 0x07, 0x1e, 0x00, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x18, 0x0c, 0x04, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x03, 0x07, 0x1e, 0x00, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x03, 0x07, 0x1e, 0x00, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x33, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x03, 0x07, 0x1e, 0x00, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x06, 0x0c, 0x08, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x18, 0x0c, 0x04, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x33, 0x33, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x00, 0x1b, 0x1e, 0x0e, 0x1b, 0x1b, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x00, 0x2e, 0x1d, 0x00, 0x1d, 0x3f, 0x37, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x00, 0x06, 0x0c, 0x08, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x00, 0x18, 0x0c, 0x04, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x00, 0x00, 0x2e, 0x1d, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x3f, 0x3f, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x1e, 0x3f, 0x3b, 0x2d, 0x37, 0x3f, 0x1e, 0x01, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x06, 0x0c, 0x08, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x18, 0x0c, 0x04, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x33, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x18, 0x0c, 0x04, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3e, 0x30, 0x31, 0x3f, 0x1e },	// U+00FD (ý)
	{ 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x1f, 0x3f, 0x33, 0x33, 0x3f, 0x1f, 0x03, 0x03, 0x07 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x33, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3e, 0x30, 0x31, 0x3f, 0x1e },	// U+00FF (ÿ)
	{ 0x1e, 0x1e, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x3e, 0x30, 0x3e, 0x3f, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+0101 (ā)
	{ 0x21, 0x3f, 0x1e, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x21, 0x3f, 0x1e, 0x00, 0x1e, 0x3e, 0x30, 0x3e, 0x3f, 0x33, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x30, 0x70, 0x00 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3e, 0x30, 0x3e, 0x3f, 0x33, 0x3f, 0x2e, 0x30, 0x70, 0x00 },	// U+0105 (ą)
	{ 0x18, 0x0c, 0x04, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x03, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x00, 0x18, 0x0c, 0x04, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x03, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x0c, 0x0c, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x03, 0x03, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+010B (ċ)
	{ 0x33, 0x1e, 0x0c, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x03, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0x00, 0x33, 0x1e, 0x0c, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+010D (č)
	{ 0x33, 0x1e, 0x0c, 0x00, 0x0f, 0x1f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1f, 0x0f, 0x00, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x33, 0x1e, 0x0c, 0x20, 0x30, 0x36, 0x3f, 0x3b, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x1f, 0x0f, 0x00, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x00, 0x00, 0x30, 0x3c, 0x30, 0x36, 0x3f, 0x3b, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x1e, 0x1e, 0x00, 0x3f, 0x3f, 0x03, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x03, 0x07, 0x1e, 0x00, 0x00, 0x00 },	// U+0113 (ē)
	{ 0x21, 0x3f, 0x1e, 0x00, 0x3f, 0x3f, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+0114 (Ĕ)
	{ 0x00, 0x21, 0x3f, 0x1e, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x03, 0x07, 0x1e, 0x00, 0x00, 0x00 },	// U+0115 (ĕ)
	{ 0x0c, 0x0c, 0x00, 0x3f, 0x3f, 0x03, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x03, 0x07, 0x1e, 0x00, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x03, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x3f, 0x3f, 0x18, 0x38, 0x00 },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x03, 0x07, 0x1e, 0x0c, 0x1c, 0x00 },	// U+0119 (ę)
	{ 0x33, 0x1e, 0x0c, 0x00, 0x3f, 0x3f, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0x33, 0x1e, 0x0c, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x3f, 0x03, 0x07, 0x1e, 0x00, 0x00, 0x00 },	// U+011B (ě)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x3b, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x36, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x36, 0x30, 0x33, 0x3f, 0x1e },	// U+011D (ĝ)
	{ 0x21, 0x3f, 0x1e, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x3b, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x21, 0x3f, 0x1e, 0x00, 0x36, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x36, 0x30, 0x33, 0x3f, 0x1e },	// U+011F (ğ)
	{ 0x0c, 0x0c, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x3b, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x36, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x36, 0x30, 0x33, 0x3f, 0x1e },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x03, 0x3b, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x0c, 0x06 },	// U+0122 (Ģ)
	{ 0x00, 0x18, 0x0c, 0x0c, 0x00, 0x36, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x36, 0x30, 0x33, 0x3f, 0x1e },	// U+0123 (ģ)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x03, 0x03, 0x1b, 0x3f, 0x37, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x00, 0x33, 0x7f, 0x33, 0x33, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x00, 0x03, 0x0f, 0x03, 0x1b, 0x3f, 0x37, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0x2e, 0x1d, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x00, 0x2e, 0x1d, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x1e, 0x1e, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x1e, 0x1e, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+012B (ī)
	{ 0x21, 0x3f, 0x1e, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+012C (Ĭ)
	{ 0x00, 0x21, 0x3f, 0x1e, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+012D (ĭ)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x18, 0x38, 0x00 },	// U+012E (Į)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x0c, 0x1c, 0x00 },	// U+012F (į)
	{ 0x0c, 0x0c, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+0131 (ı)
	{ 0x00, 0x00, 0x00, 0x73, 0x73, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6b, 0x7b, 0x33, 0x00, 0x00, 0x00 },	// U+0132 (Ĳ)
	{ 0x00, 0x00, 0x33, 0x33, 0x00, 0x3b, 0x3b, 0x33, 0x33, 0x33, 0x37, 0x30, 0x32, 0x3e, 0x1c, 0x00 },	// U+0133 (ĳ)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x3c, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x1c, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x19, 0x1f, 0x0e, 0x00 },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x33, 0x33, 0x00, 0x0c, 0x06 },	// U+0136 (Ķ)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x33, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x33, 0x00, 0x0c, 0x06 },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x1b, 0x0f, 0x0f, 0x1b, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x18, 0x0c, 0x04, 0x01, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x18, 0x0c, 0x04, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x0c, 0x06 },	// U+013B (Ļ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x0c, 0x06 },	// U+013C (ļ)
	{ 0x33, 0x1e, 0x0c, 0x01, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x33, 0x1e, 0x0c, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+013E (ľ)
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x1b, 0x1b, 0x03, 0x03, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+013F (Ŀ)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x0c, 0x0c, 0x6c, 0x6c, 0x0c, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+0140 (ŀ)
	{ 0x00, 0x00, 0x00, 0x06, 0x16, 0x1e, 0x0e, 0x06, 0x07, 0x07, 0x06, 0x3e, 0x3e, 0x00, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x00, 0x00, 0x0e, 0x2e, 0x3c, 0x1c, 0x0c, 0x0e, 0x0e, 0x0c, 0x1e, 0x1e, 0x00, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x18, 0x0c, 0x04, 0x31, 0x33, 0x33, 0x37, 0x37, 0x3b, 0x3b, 0x33, 0x33, 0x23, 0x00, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x18, 0x0c, 0x04, 0x00, 0x1d, 0x3f, 0x37, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x00, 0x31, 0x33, 0x33, 0x37, 0x37, 0x3b, 0x3b, 0x33, 0x33, 0x23, 0x00, 0x0c, 0x06 },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x3f, 0x37, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x0c, 0x06 },	// U+0146 (ņ)
	{ 0x33, 0x1e, 0x0c, 0x00, 0x31, 0x33, 0x33, 0x37, 0x3f, 0x3b, 0x33, 0x33, 0x23, 0x00, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0x33, 0x1e, 0x0c, 0x00, 0x1d, 0x3f, 0x37, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0148 (ň)
	{ 0x00, 0x06, 0x06, 0x03, 0x00, 0x1d, 0x3f, 0x37, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0149 (ŉ)
	{ 0x00, 0x00, 0x00, 0x31, 0x33, 0x33, 0x37, 0x37, 0x3b, 0x3b, 0x33, 0x33, 0x33, 0x30, 0x30, 0x18 },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x3f, 0x37, 0x33, 0x33, 0x33, 0x33, 0x33, 0x30, 0x30, 0x18 },	// U+014B (ŋ)
	{ 0x1e, 0x1e, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+014D (ō)
	{ 0x21, 0x3f, 0x1e, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+014E (Ŏ)
	{ 0x00, 0x00, 0x21, 0x3f, 0x1e, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+014F (ŏ)
	{ 0x36, 0x36, 0x12, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x00, 0x36, 0x36, 0x12, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x00, 0x36, 0x3f, 0x0d, 0x09, 0x39, 0x39, 0x09, 0x0d, 0x3f, 0x36, 0x00, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x7f, 0x49, 0x49, 0x79, 0x19, 0x3f, 0x66, 0x00, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x18, 0x0c, 0x04, 0x00, 0x1f, 0x3f, 0x33, 0x33, 0x3f, 0x1f, 0x1b, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x18, 0x0c, 0x04, 0x00, 0x1d, 0x3f, 0x27, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x33, 0x33, 0x3f, 0x1f, 0x1b, 0x33, 0x33, 0x33, 0x00, 0x0c, 0x06 },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x3f, 0x27, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x0c, 0x06 },	// U+0157 (ŗ)
	{ 0x33, 0x1e, 0x0c, 0x00, 0x1f, 0x3f, 0x33, 0x33, 0x3f, 0x1f, 0x1b, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0x33, 0x1e, 0x0c, 0x00, 0x1d, 0x3f, 0x27, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x18, 0x0c, 0x04, 0x00, 0x1e, 0x3f, 0x33, 0x07, 0x1e, 0x38, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x18, 0x0c, 0x04, 0x00, 0x1e, 0x37, 0x03, 0x1f, 0x3e, 0x30, 0x3b, 0x1e, 0x00, 0x00, 0x00 },	// U+015B (ś)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x1e, 0x3f, 0x33, 0x07, 0x1e, 0x38, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x1e, 0x37, 0x03, 0x1f, 0x3e, 0x30, 0x3b, 0x1e, 0x00, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x0e, 0x1c, 0x30, 0x33, 0x3f, 0x1e, 0x08, 0x1a, 0x0c },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x37, 0x03, 0x1f, 0x3e, 0x30, 0x3b, 0x1e, 0x08, 0x1a, 0x0c },	// U+015F (ş)
	{ 0x33, 0x1e, 0x0c, 0x00, 0x1e, 0x3f, 0x33, 0x07, 0x1e, 0x38, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0x33, 0x1e, 0x0c, 0x00, 0x1e, 0x37, 0x03, 0x1f, 0x3e, 0x30, 0x3b, 0x1e, 0x00, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x08, 0x1a, 0x0c },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x1f, 0x1f, 0x06, 0x06, 0x06, 0x26, 0x3e, 0x1c, 0x08, 0x1a, 0x0c },	// U+0163 (ţ)
	{ 0x33, 0x1e, 0x0c, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x33, 0x1e, 0x0c, 0x00, 0x06, 0x06, 0x1f, 0x1f, 0x06, 0x06, 0x26, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x1f, 0x1f, 0x06, 0x1f, 0x06, 0x26, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0x2e, 0x1d, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x00, 0x2e, 0x1d, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x1e, 0x1e, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x1e, 0x1e, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+016B (ū)
	{ 0x21, 0x3f, 0x1e, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x21, 0x3f, 0x1e, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x1e, 0x33, 0x1e, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x00, 0x1e, 0x33, 0x1e, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+016F (ů)
	{ 0x36, 0x36, 0x12, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x36, 0x36, 0x12, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x18, 0x38, 0x00 },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x0c, 0x1c, 0x00 },	// U+0173 (ų)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x21, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x21, 0x00, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x00, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x0c, 0x1e, 0x33, 0x00, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x0c, 0x1e, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x36, 0x30, 0x31, 0x3f, 0x1e },	// U+0177 (ŷ)
	{ 0x33, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x18, 0x0c, 0x04, 0x00, 0x3f, 0x3f, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x18, 0x0c, 0x04, 0x00, 0x3f, 0x3f, 0x30, 0x1c, 0x0e, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+017A (ź)
	{ 0x0c, 0x0c, 0x00, 0x3f, 0x3f, 0x30, 0x18, 0x0c, 0x0c, 0x06, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x3f, 0x3f, 0x30, 0x1c, 0x0e, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+017C (ż)
	{ 0x33, 0x1e, 0x0c, 0x00, 0x3f, 0x3f, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0x33, 0x1e, 0x0c, 0x00, 0x3f, 0x3f, 0x30, 0x1c, 0x0e, 0x03, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+017E (ž)
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x26, 0x06, 0x07, 0x07, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+017F (ſ)
}; // 224

static const unsigned char fatty_block4[][16] = {
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x0e, 0x1c, 0x30, 0x33, 0x3f, 0x1e, 0x00, 0x0c, 0x06 },	// U+0218 (Ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x37, 0x03, 0x1f, 0x3e, 0x30, 0x3b, 0x1e, 0x00, 0x0c, 0x06 },	// U+0219 (ș)
	{ 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x0c, 0x06 },	// U+021A (Ț)
	{ 0x00, 0x00, 0x00, 0x06, 0x06, 0x1f, 0x1f, 0x06, 0x06, 0x06, 0x26, 0x3e, 0x1c, 0x00, 0x0c, 0x06 },	// U+021B (ț)
}; // 4

static const unsigned char fatty_block5[][16] = {
	{ 0x00, 0x00, 0x33, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C7 (ˇ)
}; // 1

static const unsigned char fatty_block6[][16] = {
	{ 0x00, 0x00, 0x21, 0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D8 (˘)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D9 (˙)
}; // 2

static const unsigned char fatty_block7[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0x16, 0x0c, 0x00 },	// U+02DB (˛)
}; // 1

static const unsigned char fatty_block8[][16] = {
	{ 0x00, 0x00, 0x36, 0x36, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DD (˝)
}; // 1

static const unsigned char fatty_block9[][16] = {
	{ 0x0c, 0x0c, 0x00, 0x1f, 0x3f, 0x33, 0x33, 0x1f, 0x1f, 0x33, 0x33, 0x3f, 0x1f, 0x00, 0x00, 0x00 },	// U+1E02 (Ḃ)
	{ 0x0c, 0x0c, 0x00, 0x03, 0x03, 0x1b, 0x3f, 0x37, 0x33, 0x33, 0x37, 0x3f, 0x1d, 0x00, 0x00, 0x00 },	// U+1E03 (ḃ)
}; // 2

static const unsigned char fatty_block10[][16] = {
	{ 0x0c, 0x0c, 0x00, 0x0f, 0x1f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1f, 0x0f, 0x00, 0x00, 0x00 },	// U+1E0A (Ḋ)
	{ 0x0c, 0x0c, 0x00, 0x30, 0x30, 0x36, 0x3f, 0x3b, 0x33, 0x33, 0x3b, 0x3f, 0x2e, 0x00, 0x00, 0x00 },	// U+1E0B (ḋ)
}; // 2

static const unsigned char fatty_block11[][16] = {
	{ 0x0c, 0x0c, 0x00, 0x3f, 0x3f, 0x03, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+1E1E (Ḟ)
	{ 0x0c, 0x0c, 0x00, 0x1c, 0x3e, 0x26, 0x06, 0x1f, 0x1f, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+1E1F (ḟ)
}; // 2

static const unsigned char fatty_block12[][16] = {
	{ 0x0c, 0x0c, 0x00, 0x21, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+1E40 (Ṁ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+1E41 (ṁ)
}; // 2

static const unsigned char fatty_block13[][16] = {
	{ 0x0c, 0x0c, 0x00, 0x1f, 0x3f, 0x33, 0x33, 0x3f, 0x1f, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00 },	// U+1E56 (Ṗ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x1d, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1b, 0x03, 0x03, 0x03, 0x03 },	// U+1E57 (ṗ)
}; // 2

static const unsigned char fatty_block14[][16] = {
	{ 0x0c, 0x0c, 0x00, 0x1e, 0x3f, 0x33, 0x03, 0x0e, 0x1c, 0x30, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+1E60 (Ṡ)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x1e, 0x37, 0x03, 0x1f, 0x3e, 0x30, 0x3b, 0x1e, 0x00, 0x00, 0x00 },	// U+1E61 (ṡ)
}; // 2

static const unsigned char fatty_block15[][16] = {
	{ 0x0c, 0x0c, 0x00, 0x3f, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+1E6A (Ṫ)
	{ 0x0c, 0x0c, 0x00, 0x06, 0x06, 0x1f, 0x1f, 0x06, 0x06, 0x06, 0x26, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+1E6B (ṫ)
}; // 2

static const unsigned char fatty_block16[][16] = {
	{ 0x06, 0x0c, 0x08, 0x21, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x21, 0x00, 0x00, 0x00 },	// U+1E80 (Ẁ)
	{ 0x00, 0x06, 0x0c, 0x08, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x00, 0x00, 0x00 },	// U+1E81 (ẁ)
	{ 0x18, 0x0c, 0x04, 0x21, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x21, 0x00, 0x00, 0x00 },	// U+1E82 (Ẃ)
	{ 0x00, 0x18, 0x0c, 0x04, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x00, 0x00, 0x00 },	// U+1E83 (ẃ)
	{ 0x33, 0x33, 0x00, 0x21, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x21, 0x00, 0x00, 0x00 },	// U+1E84 (Ẅ)
	{ 0x00, 0x00, 0x33, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x3f, 0x33, 0x00, 0x00, 0x00 },	// U+1E85 (ẅ)
}; // 6

static const unsigned char fatty_block17[][16] = {
	{ 0x06, 0x0c, 0x08, 0x23, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+1EF2 (Ỳ)
	{ 0x00, 0x06, 0x0c, 0x08, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3b, 0x3f, 0x36, 0x30, 0x31, 0x3f, 0x1e },	// U+1EF3 (ỳ)
}; // 2

static const unsigned char fatty_block18[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2010 (‐)
}; // 1

static const unsigned char fatty_block19[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2013 (–)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2014 (—)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2015 (―)
}; // 3

static const unsigned char fatty_block20[][16] = {
	{ 0x00, 0x00, 0x18, 0x0c, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2018 (‘)
	{ 0x00, 0x00, 0x1c, 0x1c, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2019 (’)
}; // 2

static const unsigned char fatty_block21[][16] = {
	{ 0x00, 0x00, 0x1c, 0x1c, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201B (‛)
	{ 0x00, 0x00, 0x36, 0x1b, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201C (“)
	{ 0x00, 0x00, 0x3f, 0x3f, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201D (”)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x36, 0x1b, 0x00 },	// U+201E („)
	{ 0x00, 0x00, 0x3f, 0x3f, 0x1b, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201F (‟)
}; // 5

static const unsigned char fatty_block22[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x3f, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2022 (•)
}; // 1

static const unsigned char fatty_block23[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+2026 (…)
}; // 1

static const unsigned char fatty_block24[][16] = {
	{ 0x00, 0x00, 0x00, 0x26, 0x39, 0x19, 0x1e, 0x0c, 0x0c, 0x3e, 0x56, 0x57, 0x3d, 0x00, 0x00, 0x00 },	// U+2030 (‰)
}; // 1

static const unsigned char fatty_block25[][16] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x33, 0x1b, 0x18, 0x0c, 0x0c, 0x06, 0x36, 0x33, 0x03, 0x00, 0x00, 0x00 },	// U+2052 (⁒)
}; // 1

static const unsigned char fatty_block26[][16] = {
	{ 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x66, 0x06, 0x3f, 0x06, 0x1f, 0x06, 0x66, 0x7e, 0x3c, 0x00, 0x00 },	// U+20AC (€)
}; // 1

static const unsigned char fatty_block27[][16] = {
	{ 0x00, 0x00, 0x00, 0x2f, 0x3a, 0x3a, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2122 (™)
}; // 1

static const unsigned char fatty_block28[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x3f, 0x3f, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2192 (→)
}; // 1

static const unsigned char fatty_block29[][16] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x18, 0x3f, 0x3f, 0x0c, 0x0c, 0x3f, 0x3f, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+2260 (≠)
}; // 1

static const unsigned char fatty_block30[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2500 (─)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2501 (━)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2502 (│)
	{ 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c },	// U+2503 (┃)
}; // 4

static const unsigned char fatty_block31[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+250C (┌)
}; // 1

static const unsigned char fatty_block32[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2510 (┐)
}; // 1

static const unsigned char fatty_block33[][16] = {
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2514 (└)
}; // 1

static const unsigned char fatty_block34[][16] = {
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2518 (┘)
}; // 1

static const unsigned char fatty_block35[][16] = {
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+251C (├)
}; // 1

static const unsigned char fatty_block36[][16] = {
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2524 (┤)
}; // 1

static const unsigned char fatty_block37[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+252C (┬)
}; // 1

static const unsigned char fatty_block38[][16] = {
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2534 (┴)
}; // 1

static const unsigned char fatty_block39[][16] = {
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+253C (┼)
}; // 1

static const unsigned char fatty_block40[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+25A0 (■)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+25A1 (□)
}; // 2

static const unsigned char fatty_block41[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0e, 0x0e, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25B2 (▲)
}; // 1

static const unsigned char fatty_block42[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x3f, 0x3f, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25BA (►)
}; // 1

static const unsigned char fatty_block43[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+25BC (▼)
}; // 1

static const unsigned char fatty_block44[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+25CB (○)
}; // 1

static const unsigned char fatty_block45[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+25CF (●)
}; // 1

static const unsigned char fatty_block46[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1e, 0x1e, 0x0c, 0x1e, 0x3f, 0x3f, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+2603 (☃)
}; // 1

static const unsigned char fatty_block47[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x1c, 0x1c, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2605 (★)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x14, 0x1c, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2606 (☆)
}; // 2

static const unsigned char fatty_block48[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x55, 0x41, 0x55, 0x5d, 0x49, 0x22, 0x1c, 0x00, 0x00 },	// U+263A (☺)
}; // 1

static const unsigned char fatty_block49[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x77, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2665 (♥)
}; // 1

static const unsigned char fatty_block50[][16] = {
	{ 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x33, 0x21, 0x0c, 0x0c, 0x21, 0x33, 0x00, 0x0c, 0x0c, 0x00, 0x00 },	// U+269B (⚛)
}; // 1

static const unsigned char fatty_block51[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x50, 0x53, 0x4d, 0x21, 0x11, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2705 (✅)
}; // 1

static const unsigned char fatty_block52[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x18, 0x19, 0x3f, 0x19, 0x18, 0x0c, 0x04, 0x00, 0x00, 0x00 },	// U+2708 (✈)
}; // 1

static const unsigned char fatty_block53[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x31, 0x1b, 0x1b, 0x0e, 0x0e, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2713 (✓)
}; // 1

static const unsigned char fatty_block54[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x15, 0x0e, 0x15, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2744 (❄)
}; // 1

static const unsigned char fatty_block55[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2800 (⠀)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2801 (⠁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2802 (⠂)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2803 (⠃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2804 (⠄)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2805 (⠅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2806 (⠆)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2807 (⠇)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2808 (⠈)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2809 (⠉)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280A (⠊)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280B (⠋)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280C (⠌)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280D (⠍)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280E (⠎)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280F (⠏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2810 (⠐)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2811 (⠑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2812 (⠒)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2813 (⠓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2814 (⠔)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2815 (⠕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2816 (⠖)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2817 (⠗)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2818 (⠘)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2819 (⠙)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281A (⠚)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281B (⠛)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281C (⠜)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281D (⠝)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281E (⠞)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281F (⠟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2820 (⠠)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2821 (⠡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2822 (⠢)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2823 (⠣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2824 (⠤)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2825 (⠥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2826 (⠦)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2827 (⠧)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2828 (⠨)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2829 (⠩)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282A (⠪)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282B (⠫)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282C (⠬)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282D (⠭)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282E (⠮)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+282F (⠯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2830 (⠰)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2831 (⠱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2832 (⠲)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2833 (⠳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2834 (⠴)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2835 (⠵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2836 (⠶)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2837 (⠷)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2838 (⠸)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2839 (⠹)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283A (⠺)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283B (⠻)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283C (⠼)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283D (⠽)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283E (⠾)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+283F (⠿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2840 (⡀)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2841 (⡁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2842 (⡂)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2843 (⡃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2844 (⡄)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2845 (⡅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2846 (⡆)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2847 (⡇)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2848 (⡈)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2849 (⡉)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+284A (⡊)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+284B (⡋)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+284C (⡌)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+284D (⡍)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+284E (⡎)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+284F (⡏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2850 (⡐)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2851 (⡑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2852 (⡒)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2853 (⡓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2854 (⡔)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2855 (⡕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2856 (⡖)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2857 (⡗)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2858 (⡘)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2859 (⡙)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+285A (⡚)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+285B (⡛)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+285C (⡜)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+285D (⡝)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+285E (⡞)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+285F (⡟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2860 (⡠)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2861 (⡡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2862 (⡢)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2863 (⡣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2864 (⡤)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2865 (⡥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2866 (⡦)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2867 (⡧)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2868 (⡨)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2869 (⡩)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+286A (⡪)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+286B (⡫)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+286C (⡬)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+286D (⡭)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+286E (⡮)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+286F (⡯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2870 (⡰)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2871 (⡱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2872 (⡲)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2873 (⡳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2874 (⡴)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2875 (⡵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2876 (⡶)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2877 (⡷)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2878 (⡸)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2879 (⡹)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+287A (⡺)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+287B (⡻)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+287C (⡼)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+287D (⡽)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+287E (⡾)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+287F (⡿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2880 (⢀)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2881 (⢁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2882 (⢂)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2883 (⢃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2884 (⢄)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2885 (⢅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2886 (⢆)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2887 (⢇)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2888 (⢈)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2889 (⢉)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+288A (⢊)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+288B (⢋)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+288C (⢌)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+288D (⢍)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+288E (⢎)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+288F (⢏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2890 (⢐)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2891 (⢑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2892 (⢒)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2893 (⢓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2894 (⢔)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2895 (⢕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2896 (⢖)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2897 (⢗)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2898 (⢘)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2899 (⢙)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+289A (⢚)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+289B (⢛)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+289C (⢜)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+289D (⢝)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+289E (⢞)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+289F (⢟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28A0 (⢠)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28A1 (⢡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28A2 (⢢)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28A3 (⢣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28A4 (⢤)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28A5 (⢥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28A6 (⢦)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28A7 (⢧)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28A8 (⢨)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28A9 (⢩)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28AA (⢪)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28AB (⢫)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28AC (⢬)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28AD (⢭)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28AE (⢮)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28AF (⢯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28B0 (⢰)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28B1 (⢱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28B2 (⢲)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28B3 (⢳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28B4 (⢴)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28B5 (⢵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28B6 (⢶)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28B7 (⢷)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28B8 (⢸)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28B9 (⢹)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28BA (⢺)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28BB (⢻)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28BC (⢼)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28BD (⢽)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28BE (⢾)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+28BF (⢿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C0 (⣀)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C1 (⣁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C2 (⣂)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C3 (⣃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C4 (⣄)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C5 (⣅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C6 (⣆)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C7 (⣇)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C8 (⣈)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C9 (⣉)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28CA (⣊)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28CB (⣋)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28CC (⣌)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28CD (⣍)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28CE (⣎)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28CF (⣏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D0 (⣐)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D1 (⣑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D2 (⣒)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D3 (⣓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D4 (⣔)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D5 (⣕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D6 (⣖)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D7 (⣗)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D8 (⣘)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D9 (⣙)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28DA (⣚)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28DB (⣛)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28DC (⣜)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28DD (⣝)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28DE (⣞)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28DF (⣟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28E0 (⣠)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28E1 (⣡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28E2 (⣢)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28E3 (⣣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28E4 (⣤)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28E5 (⣥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28E6 (⣦)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28E7 (⣧)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28E8 (⣨)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28E9 (⣩)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28EA (⣪)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28EB (⣫)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28EC (⣬)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28ED (⣭)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28EE (⣮)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28EF (⣯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28F0 (⣰)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28F1 (⣱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28F2 (⣲)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28F3 (⣳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28F4 (⣴)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28F5 (⣵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28F6 (⣶)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28F7 (⣷)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28F8 (⣸)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28F9 (⣹)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28FA (⣺)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28FB (⣻)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28FC (⣼)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28FD (⣽)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28FE (⣾)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28FF (⣿)
}; // 256

static const unsigned char fatty_block56[][16] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+30FB (・)
}; // 1

static const unsigned char fatty_block57[][16] = {
	{ 0x00, 0x00, 0x0c, 0x1e, 0x33, 0x21, 0x2d, 0x2f, 0x23, 0x33, 0x3f, 0x12, 0x1e, 0x0c, 0x00, 0x00 },	// U+FFFD (�)
}; // 1

