/*
* C Header for use with https://github.com/NiLuJe/FBInk
* Converted from Hex font cozette-8x13.hex
* With FBInk's tools/hextoc.py
*/

#pragma once

static const unsigned char cozette_block1[][13] = {
	{ 0x55, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x55 },	// U+0000 (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0001 (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0002 (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0003 (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0004 (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0005 (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0006 (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0007 (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+0008 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0009 (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+000A (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+000B (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+000C (ESC)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+000D (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+000E (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+000F (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+0010 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+0011 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0012 (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+0013 (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+0014 (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0015 (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+0016 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+0017 (ESC)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+0018 (ESC)
	{ 0x55, 0x2a, 0x55, 0x2a, 0x55, 0x2a, 0x55, 0x2a, 0x55, 0x2a, 0x55, 0x2a, 0x55 },	// U+0019 (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x3e, 0x08, 0x3e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+001A (ESC)
	{ 0x00, 0x00, 0x00, 0x30, 0x0c, 0x02, 0x0c, 0x30, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+001B (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+001C (ESC)
	{ 0x00, 0x00, 0x00, 0x06, 0x18, 0x20, 0x18, 0x06, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+001D (ESC)
	{ 0x00, 0x00, 0x18, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+001E (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+001F (ESC)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0020 ( )
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+0021 (!)
	{ 0x00, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0022 (")
	{ 0x00, 0x00, 0x14, 0x14, 0x3e, 0x14, 0x14, 0x3e, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+0023 (#)
	{ 0x00, 0x08, 0x1c, 0x2a, 0x0a, 0x1c, 0x28, 0x28, 0x2a, 0x1c, 0x08, 0x00, 0x00 },	// U+0024 ($)
	{ 0x00, 0x04, 0x0a, 0x24, 0x10, 0x08, 0x04, 0x12, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0025 (%)
	{ 0x00, 0x08, 0x14, 0x14, 0x08, 0x2c, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+0026 (&)
	{ 0x00, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0027 (')
	{ 0x00, 0x10, 0x08, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x08, 0x10, 0x00 },	// U+0028 (()
	{ 0x00, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00 },	// U+0029 ())
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x08, 0x3e, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+002A (*)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+002B (+)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x04, 0x00 },	// U+002C (,)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+002D (-)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+002E (.)
	{ 0x00, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00, 0x00 },	// U+002F (/)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x2a, 0x2a, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0030 (0)
	{ 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00 },	// U+0031 (1)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0032 (2)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x18, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0033 (3)
	{ 0x00, 0x00, 0x20, 0x30, 0x28, 0x24, 0x22, 0x7e, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+0034 (4)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0035 (5)
	{ 0x00, 0x00, 0x18, 0x04, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0036 (6)
	{ 0x00, 0x00, 0x3e, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0037 (7)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0038 (8)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x10, 0x0c, 0x00, 0x00, 0x00 },	// U+0039 (9)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+003A (:)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x04, 0x00 },	// U+003B (;)
	{ 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00 },	// U+003C (<)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+003D (=)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00 },	// U+003E (>)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x08, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+003F (?)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x3a, 0x2a, 0x3a, 0x02, 0x3c, 0x00, 0x00, 0x00 },	// U+0040 (@)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0041 (A)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0042 (B)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0043 (C)
	{ 0x00, 0x00, 0x0e, 0x12, 0x22, 0x22, 0x22, 0x22, 0x12, 0x0e, 0x00, 0x00, 0x00 },	// U+0044 (D)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0045 (E)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0046 (F)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x32, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0047 (G)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0048 (H)
	{ 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0049 (I)
	{ 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+004A (J)
	{ 0x00, 0x00, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+004B (K)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+004C (L)
	{ 0x00, 0x00, 0x22, 0x36, 0x2a, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+004D (M)
	{ 0x00, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x00, 0x00 },	// U+004E (N)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+004F (O)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0050 (P)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x12, 0x2c, 0x20, 0x00, 0x00 },	// U+0051 (Q)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x12, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0052 (R)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0053 (S)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0054 (T)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0055 (U)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0056 (V)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x1c, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+0057 (W)
	{ 0x00, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0058 (X)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0059 (Y)
	{ 0x00, 0x00, 0x3e, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+005A (Z)
	{ 0x00, 0x1c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1c, 0x00 },	// U+005B ([)
	{ 0x00, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x00, 0x00 },	// U+005C (\)
	{ 0x00, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x00 },	// U+005D (])
	{ 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+005E (^)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00 },	// U+005F (_)
	{ 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0060 (`)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+0061 (a)
	{ 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0062 (b)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0063 (c)
	{ 0x00, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+0064 (d)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0065 (e)
	{ 0x00, 0x38, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0066 (f)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+0067 (g)
	{ 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0068 (h)
	{ 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+0069 (i)
	{ 0x00, 0x00, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x08, 0x00 },	// U+006A (j)
	{ 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+006B (k)
	{ 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00 },	// U+006C (l)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+006D (m)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+006E (n)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+006F (o)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02 },	// U+0070 (p)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x60 },	// U+0071 (q)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0072 (r)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+0073 (s)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00 },	// U+0074 (t)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+0075 (u)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0076 (v)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+0077 (w)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00 },	// U+0078 (x)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+0079 (y)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+007A (z)
	{ 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x06, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00 },	// U+007B ({)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+007C (|)
	{ 0x00, 0x06, 0x08, 0x08, 0x08, 0x08, 0x30, 0x08, 0x08, 0x08, 0x08, 0x06, 0x00 },	// U+007D (})
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x2a, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007E (~)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+007F ()
}; // 128

static const unsigned char cozette_block2[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A0 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+00A1 (¡)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x0a, 0x0a, 0x2a, 0x1c, 0x08, 0x00, 0x00 },	// U+00A2 (¢)
	{ 0x00, 0x00, 0x18, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x3a, 0x00, 0x00, 0x00 },	// U+00A3 (£)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x1c, 0x14, 0x14, 0x1c, 0x22, 0x00, 0x00, 0x00 },	// U+00A4 (¤)
	{ 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x3e, 0x08, 0x3e, 0x08, 0x00, 0x00, 0x00 },	// U+00A5 (¥)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+00A6 (¦)
	{ 0x00, 0x1c, 0x22, 0x02, 0x0c, 0x14, 0x14, 0x18, 0x20, 0x22, 0x1c, 0x00, 0x00 },	// U+00A7 (§)
	{ 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00A8 (¨)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x5d, 0x45, 0x5d, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00A9 (©)
	{ 0x00, 0x00, 0x18, 0x20, 0x38, 0x24, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AA (ª)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x14, 0x0a, 0x14, 0x28, 0x00, 0x00, 0x00, 0x00 },	// U+00AB («)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+00AC (¬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AD (­)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x5d, 0x45, 0x45, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00AE (®)
	{ 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00AF (¯)
	{ 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B0 (°)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+00B1 (±)
	{ 0x00, 0x0c, 0x12, 0x08, 0x04, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B2 (²)
	{ 0x00, 0x0e, 0x10, 0x0c, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B3 (³)
	{ 0x00, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B4 (´)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x2c, 0x14, 0x04, 0x02, 0x00 },	// U+00B5 (µ)
	{ 0x00, 0x00, 0x3c, 0x2e, 0x2e, 0x2c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00 },	// U+00B6 (¶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B7 (·)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x0c, 0x00 },	// U+00B8 (¸)
	{ 0x00, 0x04, 0x06, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00B9 (¹)
	{ 0x00, 0x00, 0x10, 0x28, 0x10, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+00BA (º)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x14, 0x28, 0x14, 0x0a, 0x00, 0x00, 0x00, 0x00 },	// U+00BB (»)
	{ 0x00, 0x22, 0x12, 0x12, 0x0a, 0x08, 0x24, 0x34, 0x3a, 0x22, 0x00, 0x00, 0x00 },	// U+00BC (¼)
	{ 0x00, 0x22, 0x12, 0x12, 0x0a, 0x08, 0x14, 0x24, 0x12, 0x32, 0x00, 0x00, 0x00 },	// U+00BD (½)
	{ 0x00, 0x26, 0x14, 0x12, 0x0c, 0x0e, 0x24, 0x34, 0x3a, 0x22, 0x00, 0x00, 0x00 },	// U+00BE (¾)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x04, 0x02, 0x22, 0x1c, 0x00 },	// U+00BF (¿)
	{ 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+00C0 (À)
	{ 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+00C1 (Á)
	{ 0x08, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+00C2 (Â)
	{ 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+00C3 (Ã)
	{ 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+00C4 (Ä)
	{ 0x08, 0x14, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+00C5 (Å)
	{ 0x00, 0x00, 0x3c, 0x0a, 0x0a, 0x3a, 0x0e, 0x0a, 0x0a, 0x3a, 0x00, 0x00, 0x00 },	// U+00C6 (Æ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x08, 0x08, 0x04 },	// U+00C7 (Ç)
	{ 0x04, 0x08, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+00C8 (È)
	{ 0x10, 0x08, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+00C9 (É)
	{ 0x08, 0x14, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+00CA (Ê)
	{ 0x14, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+00CB (Ë)
	{ 0x04, 0x08, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+00CC (Ì)
	{ 0x10, 0x08, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+00CD (Í)
	{ 0x08, 0x14, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+00CE (Î)
	{ 0x14, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+00CF (Ï)
	{ 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x2e, 0x24, 0x24, 0x1c, 0x00, 0x00, 0x00 },	// U+00D0 (Ð)
	{ 0x2c, 0x1a, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x00, 0x00 },	// U+00D1 (Ñ)
	{ 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00D2 (Ò)
	{ 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00D3 (Ó)
	{ 0x08, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00D4 (Ô)
	{ 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00D5 (Õ)
	{ 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00D6 (Ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+00D7 (×)
	{ 0x00, 0x20, 0x1c, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x1c, 0x02, 0x00, 0x00 },	// U+00D8 (Ø)
	{ 0x04, 0x08, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00D9 (Ù)
	{ 0x10, 0x08, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00DA (Ú)
	{ 0x08, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00DB (Û)
	{ 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00DC (Ü)
	{ 0x10, 0x08, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+00DD (Ý)
	{ 0x00, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+00DE (Þ)
	{ 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0a, 0x12, 0x22, 0x22, 0x1a, 0x00, 0x00, 0x00 },	// U+00DF (ß)
	{ 0x00, 0x04, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+00E0 (à)
	{ 0x00, 0x10, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+00E1 (á)
	{ 0x00, 0x08, 0x14, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+00E2 (â)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+00E3 (ã)
	{ 0x00, 0x00, 0x14, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+00E4 (ä)
	{ 0x08, 0x14, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+00E5 (å)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x3a, 0x0a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+00E6 (æ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x22, 0x1c, 0x08, 0x10, 0x0c },	// U+00E7 (ç)
	{ 0x00, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00E8 (è)
	{ 0x00, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00E9 (é)
	{ 0x00, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00EA (ê)
	{ 0x00, 0x00, 0x14, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00EB (ë)
	{ 0x00, 0x04, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+00EC (ì)
	{ 0x00, 0x10, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+00ED (í)
	{ 0x00, 0x08, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+00EE (î)
	{ 0x00, 0x00, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+00EF (ï)
	{ 0x00, 0x2c, 0x10, 0x28, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00F0 (ð)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+00F1 (ñ)
	{ 0x00, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00F2 (ò)
	{ 0x00, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00F3 (ó)
	{ 0x00, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00F4 (ô)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00F5 (õ)
	{ 0x00, 0x00, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+00F6 (ö)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x3e, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+00F7 (÷)
	{ 0x00, 0x00, 0x00, 0x20, 0x1c, 0x32, 0x2a, 0x2a, 0x26, 0x1c, 0x02, 0x00, 0x00 },	// U+00F8 (ø)
	{ 0x00, 0x04, 0x08, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+00F9 (ù)
	{ 0x00, 0x10, 0x08, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+00FA (ú)
	{ 0x00, 0x08, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+00FB (û)
	{ 0x00, 0x00, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+00FC (ü)
	{ 0x00, 0x10, 0x08, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+00FD (ý)
	{ 0x00, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x00 },	// U+00FE (þ)
	{ 0x00, 0x00, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+00FF (ÿ)
	{ 0x00, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0100 (Ā)
	{ 0x00, 0x00, 0x1c, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+0101 (ā)
	{ 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0102 (Ă)
	{ 0x00, 0x14, 0x1c, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+0103 (ă)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x10, 0x30, 0x00 },	// U+0104 (Ą)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x10, 0x30, 0x00 },	// U+0105 (ą)
	{ 0x10, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0106 (Ć)
	{ 0x00, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0107 (ć)
	{ 0x08, 0x14, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0108 (Ĉ)
	{ 0x00, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0109 (ĉ)
	{ 0x08, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+010A (Ċ)
	{ 0x00, 0x00, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+010B (ċ)
	{ 0x14, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+010C (Č)
	{ 0x00, 0x14, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+010D (č)
	{ 0x14, 0x08, 0x00, 0x0e, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0e, 0x00, 0x00, 0x00 },	// U+010E (Ď)
	{ 0x00, 0x50, 0x30, 0x10, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x1c, 0x00, 0x00, 0x00 },	// U+010F (ď)
	{ 0x00, 0x00, 0x0c, 0x14, 0x24, 0x24, 0x2e, 0x24, 0x14, 0x0c, 0x00, 0x00, 0x00 },	// U+0110 (Đ)
	{ 0x00, 0x10, 0x3c, 0x10, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x1c, 0x00, 0x00, 0x00 },	// U+0111 (đ)
	{ 0x1c, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0112 (Ē)
	{ 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0113 (ē)
	{ 0x14, 0x1c, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0114 (Ĕ)
	{ 0x00, 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0115 (ĕ)
	{ 0x08, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0116 (Ė)
	{ 0x00, 0x00, 0x08, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0117 (ė)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x10, 0x30, 0x00 },	// U+0118 (Ę)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x10, 0x30, 0x00 },	// U+0119 (ę)
	{ 0x14, 0x08, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+011A (Ě)
	{ 0x00, 0x14, 0x08, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+011B (ě)
	{ 0x08, 0x14, 0x00, 0x1c, 0x22, 0x02, 0x32, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+011C (Ĝ)
	{ 0x00, 0x08, 0x14, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+011D (ĝ)
	{ 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x02, 0x32, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+011E (Ğ)
	{ 0x00, 0x14, 0x1c, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+011F (ğ)
	{ 0x08, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x32, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0120 (Ġ)
	{ 0x00, 0x00, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+0121 (ġ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x32, 0x22, 0x22, 0x1c, 0x00, 0x08, 0x04 },	// U+0122 (Ģ)
	{ 0x00, 0x10, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+0123 (ģ)
	{ 0x08, 0x14, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0124 (Ĥ)
	{ 0x08, 0x14, 0x00, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+0125 (ĥ)
	{ 0x00, 0x00, 0x22, 0x7f, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0126 (Ħ)
	{ 0x00, 0x04, 0x0e, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+0127 (ħ)
	{ 0x2c, 0x1a, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0128 (Ĩ)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+0129 (ĩ)
	{ 0x1c, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+012A (Ī)
	{ 0x00, 0x00, 0x1c, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+012B (ī)
	{ 0x14, 0x1c, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+012C (Ĭ)
	{ 0x00, 0x14, 0x1c, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+012D (ĭ)
	{ 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x08, 0x18, 0x00 },	// U+012E (Į)
	{ 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x10, 0x30, 0x00 },	// U+012F (į)
	{ 0x08, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0130 (İ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+0131 (ı)
	{ 0x00, 0x3e, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x2e, 0x20, 0x10, 0x00 },	// U+0132 (Ĳ)
	{ 0x00, 0x00, 0x24, 0x00, 0x36, 0x24, 0x24, 0x24, 0x24, 0x28, 0x20, 0x10, 0x00 },	// U+0133 (ĳ)
	{ 0x10, 0x28, 0x00, 0x38, 0x20, 0x20, 0x20, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0134 (Ĵ)
	{ 0x00, 0x10, 0x28, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e, 0x00 },	// U+0135 (ĵ)
	{ 0x00, 0x00, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x12, 0x22, 0x22, 0x08, 0x04, 0x00 },	// U+0136 (Ķ)
	{ 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x08, 0x04, 0x00 },	// U+0137 (ķ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+0138 (ĸ)
	{ 0x04, 0x02, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0139 (Ĺ)
	{ 0x10, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00 },	// U+013A (ĺ)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x08, 0x04 },	// U+013B (Ļ)
	{ 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x08, 0x04 },	// U+013C (ļ)
	{ 0x00, 0x08, 0x0a, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+013D (Ľ)
	{ 0x20, 0x2c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00 },	// U+013E (ľ)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x0a, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+013F (Ŀ)
	{ 0x00, 0x0c, 0x08, 0x08, 0x08, 0x28, 0x08, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00 },	// U+0140 (ŀ)
	{ 0x00, 0x00, 0x04, 0x04, 0x14, 0x0c, 0x04, 0x06, 0x04, 0x3c, 0x00, 0x00, 0x00 },	// U+0141 (Ł)
	{ 0x00, 0x0c, 0x08, 0x08, 0x18, 0x0c, 0x08, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00 },	// U+0142 (ł)
	{ 0x10, 0x08, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x00, 0x00 },	// U+0143 (Ń)
	{ 0x00, 0x10, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0144 (ń)
	{ 0x00, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x08, 0x04 },	// U+0145 (Ņ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x08, 0x04, 0x00 },	// U+0146 (ņ)
	{ 0x14, 0x08, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x00, 0x00 },	// U+0147 (Ň)
	{ 0x00, 0x14, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0148 (ň)
	{ 0x03, 0x02, 0x01, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0149 (ŉ)
	{ 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x10, 0x00 },	// U+014A (Ŋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x20, 0x10, 0x00 },	// U+014B (ŋ)
	{ 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+014C (Ō)
	{ 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+014D (ō)
	{ 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+014E (Ŏ)
	{ 0x00, 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+014F (ŏ)
	{ 0x24, 0x12, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0150 (Ő)
	{ 0x00, 0x24, 0x12, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0151 (ő)
	{ 0x00, 0x00, 0x3c, 0x0a, 0x0a, 0x1a, 0x0a, 0x0a, 0x0a, 0x3c, 0x00, 0x00, 0x00 },	// U+0152 (Œ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x3a, 0x0a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+0153 (œ)
	{ 0x10, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0154 (Ŕ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0155 (ŕ)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x12, 0x22, 0x22, 0x22, 0x08, 0x04, 0x00 },	// U+0156 (Ŗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x02, 0x01 },	// U+0157 (ŗ)
	{ 0x14, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0158 (Ř)
	{ 0x00, 0x14, 0x08, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0159 (ř)
	{ 0x10, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+015A (Ś)
	{ 0x00, 0x10, 0x08, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+015B (ś)
	{ 0x08, 0x14, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+015C (Ŝ)
	{ 0x00, 0x08, 0x14, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+015D (ŝ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x08, 0x10, 0x0c },	// U+015E (Ş)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x08, 0x10, 0x0c },	// U+015F (ş)
	{ 0x14, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0160 (Š)
	{ 0x00, 0x14, 0x08, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+0161 (š)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x0c, 0x00 },	// U+0162 (Ţ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x38, 0x08, 0x10, 0x0c },	// U+0163 (ţ)
	{ 0x14, 0x08, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0164 (Ť)
	{ 0x00, 0x10, 0x14, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00 },	// U+0165 (ť)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0166 (Ŧ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x1e, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00 },	// U+0167 (ŧ)
	{ 0x2c, 0x1a, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0168 (Ũ)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+0169 (ũ)
	{ 0x1c, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+016A (Ū)
	{ 0x00, 0x00, 0x1c, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+016B (ū)
	{ 0x14, 0x1c, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+016C (Ŭ)
	{ 0x00, 0x14, 0x1c, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+016D (ŭ)
	{ 0x08, 0x14, 0x08, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+016E (Ů)
	{ 0x08, 0x14, 0x08, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+016F (ů)
	{ 0x24, 0x12, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0170 (Ű)
	{ 0x00, 0x24, 0x12, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+0171 (ű)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x18, 0x00 },	// U+0172 (Ų)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x10, 0x30, 0x00 },	// U+0173 (ų)
	{ 0x08, 0x14, 0x00, 0x22, 0x22, 0x2a, 0x2a, 0x1c, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+0174 (Ŵ)
	{ 0x00, 0x08, 0x14, 0x00, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+0175 (ŵ)
	{ 0x08, 0x14, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0176 (Ŷ)
	{ 0x00, 0x08, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+0177 (ŷ)
	{ 0x00, 0x14, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0178 (Ÿ)
	{ 0x10, 0x08, 0x00, 0x3e, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0179 (Ź)
	{ 0x00, 0x10, 0x08, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+017A (ź)
	{ 0x08, 0x00, 0x3e, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+017B (Ż)
	{ 0x00, 0x00, 0x08, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+017C (ż)
	{ 0x14, 0x08, 0x00, 0x3e, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+017D (Ž)
	{ 0x00, 0x14, 0x08, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+017E (ž)
	{ 0x00, 0x00, 0x30, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+017F (ſ)
	{ 0x00, 0x02, 0x1e, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0180 (ƀ)
	{ 0x00, 0x00, 0x1e, 0x24, 0x24, 0x1c, 0x24, 0x24, 0x24, 0x1c, 0x00, 0x00, 0x00 },	// U+0181 (Ɓ)
	{ 0x00, 0x00, 0x3e, 0x22, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0182 (Ƃ)
	{ 0x00, 0x1e, 0x12, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0183 (ƃ)
	{ 0x00, 0x00, 0x04, 0x06, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x1c, 0x00, 0x00, 0x00 },	// U+0184 (Ƅ)
	{ 0x00, 0x04, 0x06, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x1c, 0x00, 0x00, 0x00 },	// U+0185 (ƅ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0186 (Ɔ)
	{ 0x20, 0x20, 0x1c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0187 (Ƈ)
	{ 0x00, 0x00, 0x20, 0x20, 0x1c, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0188 (ƈ)
	{ 0x00, 0x00, 0x0c, 0x14, 0x24, 0x2e, 0x24, 0x24, 0x14, 0x0c, 0x00, 0x00, 0x00 },	// U+0189 (Ɖ)
	{ 0x00, 0x00, 0x0e, 0x14, 0x24, 0x24, 0x24, 0x24, 0x14, 0x0c, 0x00, 0x00, 0x00 },	// U+018A (Ɗ)
	{ 0x00, 0x3e, 0x22, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+018B (Ƌ)
	{ 0x00, 0x3c, 0x24, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+018C (ƌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x10, 0x0c },	// U+018D (ƍ)
	{ 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x3e, 0x00, 0x00, 0x00 },	// U+018E (Ǝ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x3e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+018F (Ə)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0190 (Ɛ)
	{ 0x00, 0x00, 0x7c, 0x04, 0x04, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03 },	// U+0191 (Ƒ)
	{ 0x00, 0x30, 0x08, 0x08, 0x3c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06, 0x00 },	// U+0192 (ƒ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x32, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0193 (Ɠ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x14, 0x14, 0x08, 0x00 },	// U+0194 (Ɣ)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x26, 0x2a, 0x2a, 0x2a, 0x12, 0x00, 0x00, 0x00 },	// U+0195 (ƕ)
	{ 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0196 (Ɩ)
	{ 0x00, 0x00, 0x1c, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0197 (Ɨ)
	{ 0x00, 0x00, 0x12, 0x2a, 0x2a, 0x0e, 0x12, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0198 (Ƙ)
	{ 0x00, 0x04, 0x0a, 0x02, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+0199 (ƙ)
	{ 0x00, 0x0c, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00 },	// U+019A (ƚ)
	{ 0x00, 0x00, 0x06, 0x08, 0x3e, 0x08, 0x14, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+019B (ƛ)
	{ 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x34, 0x00, 0x00, 0x00 },	// U+019C (Ɯ)
	{ 0x00, 0x00, 0x44, 0x4c, 0x4c, 0x54, 0x54, 0x64, 0x64, 0x44, 0x04, 0x04, 0x03 },	// U+019D (Ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+019E (ƞ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+019F (Ɵ)
	{ 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01A0 (Ơ)
	{ 0x00, 0x00, 0x00, 0x40, 0x5c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01A1 (ơ)
	{ 0x00, 0x00, 0x3c, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x4c, 0x00, 0x00, 0x00 },	// U+01A2 (Ƣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x52, 0x52, 0x52, 0x52, 0x4c, 0x40, 0x40, 0x00 },	// U+01A3 (ƣ)
	{ 0x00, 0x00, 0x3e, 0x45, 0x44, 0x44, 0x3c, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+01A4 (Ƥ)
	{ 0x00, 0x0c, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02 },	// U+01A5 (ƥ)
	{ 0x00, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x1e, 0x0a, 0x12, 0x20, 0x00, 0x00 },	// U+01A6 (Ʀ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x1c, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01A7 (Ƨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x1c, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00 },	// U+01A8 (ƨ)
	{ 0x00, 0x00, 0x3e, 0x22, 0x04, 0x08, 0x08, 0x04, 0x22, 0x3e, 0x00, 0x00, 0x00 },	// U+01A9 (Ʃ)
	{ 0x00, 0x04, 0x0a, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+01AA (ƪ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x38, 0x20, 0x18, 0x00 },	// U+01AB (ƫ)
	{ 0x00, 0x00, 0x3c, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+01AC (Ƭ)
	{ 0x00, 0x00, 0x08, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+01AD (ƭ)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00 },	// U+01AE (Ʈ)
	{ 0x30, 0x20, 0x12, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01AF (Ư)
	{ 0x00, 0x30, 0x20, 0x10, 0x02, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+01B0 (ư)
	{ 0x00, 0x00, 0x36, 0x14, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01B1 (Ʊ)
	{ 0x00, 0x00, 0x02, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01B2 (Ʋ)
	{ 0x00, 0x00, 0x42, 0xa2, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+01B3 (Ƴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x42, 0xa2, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+01B4 (ƴ)
	{ 0x00, 0x00, 0x3e, 0x10, 0x08, 0x1e, 0x04, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+01B5 (Ƶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x3e, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+01B6 (ƶ)
	{ 0x00, 0x00, 0x3e, 0x10, 0x08, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01B7 (Ʒ)
	{ 0x00, 0x00, 0x3e, 0x04, 0x08, 0x1c, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01B8 (Ƹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x04, 0x08, 0x1c, 0x02, 0x02, 0x22, 0x1c, 0x00 },	// U+01B9 (ƹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x1c, 0x20, 0x20, 0x1e, 0x02, 0x0c },	// U+01BA (ƺ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x3e, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+01BB (ƻ)
	{ 0x00, 0x00, 0x3c, 0x04, 0x04, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01BC (Ƽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x1c, 0x20, 0x22, 0x22, 0x1c, 0x00 },	// U+01BD (ƽ)
	{ 0x00, 0x00, 0x08, 0x1c, 0x08, 0x08, 0x10, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01BE (ƾ)
	{ 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x12, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+01BF (ƿ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+01C0 (ǀ)
	{ 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+01C1 (ǁ)
	{ 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+01C2 (ǂ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+01C3 (ǃ)
}; // 292

static const unsigned char cozette_block3[][13] = {
	{ 0x14, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+01CD (Ǎ)
	{ 0x00, 0x14, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+01CE (ǎ)
	{ 0x14, 0x08, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+01CF (Ǐ)
	{ 0x00, 0x14, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+01D0 (ǐ)
	{ 0x14, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01D1 (Ǒ)
	{ 0x00, 0x14, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01D2 (ǒ)
	{ 0x14, 0x08, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01D3 (Ǔ)
	{ 0x00, 0x00, 0x14, 0x08, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+01D4 (ǔ)
	{ 0x1c, 0x00, 0x22, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01D5 (Ǖ)
	{ 0x1c, 0x00, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+01D6 (ǖ)
	{ 0x10, 0x08, 0x22, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01D7 (Ǘ)
	{ 0x10, 0x08, 0x00, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+01D8 (ǘ)
	{ 0x14, 0x08, 0x22, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01D9 (Ǚ)
	{ 0x14, 0x08, 0x00, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+01DA (ǚ)
	{ 0x04, 0x08, 0x22, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01DB (Ǜ)
	{ 0x04, 0x08, 0x00, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+01DC (ǜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x3e, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01DD (ǝ)
	{ 0x1c, 0x00, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+01DE (Ǟ)
	{ 0x1c, 0x00, 0x14, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+01DF (ǟ)
	{ 0x1c, 0x00, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+01E0 (Ǡ)
	{ 0x1c, 0x00, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+01E1 (ǡ)
	{ 0x1c, 0x00, 0x3c, 0x0a, 0x0a, 0x3a, 0x0e, 0x0a, 0x0a, 0x3a, 0x00, 0x00, 0x00 },	// U+01E2 (Ǣ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x3c, 0x2a, 0x2a, 0x1a, 0x0a, 0x34, 0x00, 0x00, 0x00 },	// U+01E3 (ǣ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x32, 0x22, 0x7a, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01E4 (Ǥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x7a, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+01E5 (ǥ)
	{ 0x14, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x32, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01E6 (Ǧ)
	{ 0x00, 0x14, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+01E7 (ǧ)
	{ 0x14, 0x08, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+01E8 (Ǩ)
	{ 0x00, 0x2a, 0x12, 0x02, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+01E9 (ǩ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x18, 0x00 },	// U+01EA (Ǫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x10, 0x30, 0x00 },	// U+01EB (ǫ)
	{ 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x18, 0x00 },	// U+01EC (Ǭ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x10, 0x30, 0x00 },	// U+01ED (ǭ)
	{ 0x14, 0x08, 0x3e, 0x10, 0x08, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01EE (Ǯ)
	{ 0x00, 0x14, 0x08, 0x00, 0x3e, 0x10, 0x08, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00 },	// U+01EF (ǯ)
	{ 0x00, 0x14, 0x08, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x08, 0x00 },	// U+01F0 (ǰ)
}; // 36

static const unsigned char cozette_block4[][13] = {
	{ 0x10, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x32, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+01F4 (Ǵ)
	{ 0x00, 0x10, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+01F5 (ǵ)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x2e, 0x2a, 0x2a, 0x2a, 0x12, 0x00, 0x00, 0x00 },	// U+01F6 (Ƕ)
	{ 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x1a, 0x06, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+01F7 (Ƿ)
	{ 0x04, 0x08, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x00, 0x00 },	// U+01F8 (Ǹ)
	{ 0x00, 0x04, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+01F9 (ǹ)
	{ 0x04, 0x2a, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+01FA (Ǻ)
	{ 0x04, 0x2a, 0x14, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+01FB (ǻ)
	{ 0x10, 0x08, 0x00, 0x3c, 0x0a, 0x3a, 0x0e, 0x0a, 0x0a, 0x3a, 0x00, 0x00, 0x00 },	// U+01FC (Ǽ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1c, 0x2a, 0x3a, 0x0a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+01FD (ǽ)
	{ 0x10, 0x08, 0x20, 0x1c, 0x32, 0x2a, 0x2a, 0x2a, 0x26, 0x1c, 0x02, 0x00, 0x00 },	// U+01FE (Ǿ)
	{ 0x00, 0x10, 0x08, 0x20, 0x1c, 0x32, 0x2a, 0x2a, 0x26, 0x1c, 0x02, 0x00, 0x00 },	// U+01FF (ǿ)
	{ 0x12, 0x24, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0200 (Ȁ)
	{ 0x00, 0x12, 0x24, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+0201 (ȁ)
	{ 0x1c, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0202 (Ȃ)
	{ 0x00, 0x1c, 0x14, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+0203 (ȃ)
	{ 0x12, 0x24, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0204 (Ȅ)
	{ 0x00, 0x12, 0x24, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0205 (ȅ)
	{ 0x1c, 0x14, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0206 (Ȇ)
	{ 0x00, 0x1c, 0x14, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0207 (ȇ)
	{ 0x12, 0x24, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0208 (Ȉ)
	{ 0x00, 0x12, 0x24, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+0209 (ȉ)
	{ 0x1c, 0x14, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+020A (Ȋ)
	{ 0x00, 0x1c, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+020B (ȋ)
	{ 0x12, 0x24, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+020C (Ȍ)
	{ 0x00, 0x12, 0x24, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+020D (ȍ)
	{ 0x1c, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+020E (Ȏ)
	{ 0x00, 0x1c, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+020F (ȏ)
	{ 0x12, 0x24, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0210 (Ȑ)
	{ 0x00, 0x12, 0x24, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0211 (ȑ)
	{ 0x1c, 0x14, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0212 (Ȓ)
	{ 0x00, 0x1c, 0x14, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0213 (ȓ)
	{ 0x12, 0x24, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0214 (Ȕ)
	{ 0x00, 0x12, 0x24, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+0215 (ȕ)
	{ 0x1c, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0216 (Ȗ)
	{ 0x00, 0x1c, 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+0217 (ȗ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x18, 0x10, 0x08 },	// U+0218 (Ș)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x18, 0x10, 0x08 },	// U+0219 (ș)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x10, 0x08 },	// U+021A (Ț)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x38, 0x18, 0x10, 0x08 },	// U+021B (ț)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x2c, 0x20, 0x20, 0x10, 0x0e, 0x00, 0x00 },	// U+021C (Ȝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x2c, 0x20, 0x10, 0x0e, 0x00 },	// U+021D (ȝ)
	{ 0x14, 0x08, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+021E (Ȟ)
	{ 0x14, 0x08, 0x00, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+021F (ȟ)
	{ 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+0220 (Ƞ)
	{ 0x00, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x7c, 0xb0, 0x48, 0x00 },	// U+0221 (ȡ)
}; // 46

static const unsigned char cozette_block5[][13] = {
	{ 0x00, 0x00, 0x3e, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x3e, 0x20, 0x18, 0x00 },	// U+0224 (Ȥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x20, 0x18, 0x00 },	// U+0225 (ȥ)
	{ 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0226 (Ȧ)
	{ 0x00, 0x00, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+0227 (ȧ)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x08, 0x10, 0x0c },	// U+0228 (Ȩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x08, 0x10, 0x0c },	// U+0229 (ȩ)
}; // 6

static const unsigned char cozette_block6[][13] = {
	{ 0x1c, 0x00, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+022B (ȫ)
}; // 1

static const unsigned char cozette_block7[][13] = {
	{ 0x1c, 0x00, 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+022D (ȭ)
	{ 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+022E (Ȯ)
	{ 0x00, 0x00, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+022F (ȯ)
}; // 3

static const unsigned char cozette_block8[][13] = {
	{ 0x1c, 0x00, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0231 (ȱ)
	{ 0x1c, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0232 (Ȳ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+0233 (ȳ)
	{ 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x14, 0x2c, 0x1c, 0x02, 0x00, 0x00 },	// U+0234 (ȴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x62, 0xb0, 0x48, 0x00 },	// U+0235 (ȵ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x14, 0x2c, 0x1c, 0x02, 0x00, 0x00 },	// U+0236 (ȶ)
}; // 6

static const unsigned char cozette_block9[][13] = {
	{ 0x00, 0x08, 0x08, 0x08, 0x1c, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+0238 (ȸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x08 },	// U+0239 (ȹ)
}; // 2

static const unsigned char cozette_block10[][13] = {
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0241 (Ɂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0242 (ɂ)
}; // 2

static const unsigned char cozette_block11[][13] = {
	{ 0x00, 0x10, 0x3e, 0x12, 0x0a, 0x3e, 0x0a, 0x0a, 0x06, 0x3e, 0x04, 0x00, 0x00 },	// U+0246 (Ɇ)
	{ 0x00, 0x00, 0x10, 0x10, 0x1c, 0x2a, 0x3e, 0x0a, 0x26, 0x1c, 0x04, 0x00, 0x00 },	// U+0247 (ɇ)
}; // 2

static const unsigned char cozette_block12[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x1e, 0x02, 0x1c, 0x00, 0x00, 0x00 },	// U+0250 (ɐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2c, 0x32, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+0251 (ɑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x26, 0x1a, 0x00, 0x00, 0x00 },	// U+0252 (ɒ)
	{ 0x00, 0x0c, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0253 (ɓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0254 (ɔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x1a, 0x24, 0x1a, 0x00, 0x00, 0x00 },	// U+0255 (ɕ)
	{ 0x00, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0xc0 },	// U+0256 (ɖ)
	{ 0x00, 0x60, 0x10, 0x10, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x1c, 0x00, 0x00, 0x00 },	// U+0257 (ɗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0258 (ɘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x3e, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0259 (ə)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0xe0, 0xbe, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+025A (ɚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1c, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00 },	// U+025B (ɛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x1c, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+025C (ɜ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0xe0, 0x9c, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+025D (ɝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x1a, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+025E (ɞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x38, 0x10, 0x10, 0x10, 0x14, 0x08, 0x00 },	// U+025F (ɟ)
	{ 0x00, 0x20, 0x50, 0x10, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x1c, 0x10, 0x10, 0x0c },	// U+0260 (ɠ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+0261 (ɡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x32, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0262 (ɢ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x14, 0x14, 0x08 },	// U+0263 (ɣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x14, 0x08, 0x00, 0x00 },	// U+0264 (ɤ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x20 },	// U+0265 (ɥ)
	{ 0x00, 0x0c, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0266 (ɦ)
	{ 0x00, 0x0c, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x18 },	// U+0267 (ɧ)
	{ 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x1c, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+0268 (ɨ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+0269 (ɩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+026A (ɪ)
	{ 0x00, 0x0c, 0x08, 0x08, 0x08, 0x2c, 0x1a, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00 },	// U+026B (ɫ)
	{ 0x00, 0x0c, 0x08, 0x08, 0x0c, 0x0a, 0x1c, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00 },	// U+026C (ɬ)
	{ 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30 },	// U+026D (ɭ)
	{ 0x00, 0x06, 0x04, 0x04, 0x7c, 0x24, 0x14, 0x34, 0x44, 0x44, 0x40, 0x38, 0x00 },	// U+026E (ɮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x34, 0x00, 0x00, 0x00 },	// U+026F (ɯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x34, 0x20, 0x20, 0x00 },	// U+0270 (ɰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x20, 0x20, 0x10 },	// U+0271 (ɱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x44, 0x44, 0x44, 0x44, 0x44, 0x04, 0x04, 0x03 },	// U+0272 (ɲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0xc0 },	// U+0273 (ɳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x26, 0x2a, 0x32, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0274 (ɴ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0275 (ɵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x0a, 0x3a, 0x0a, 0x0a, 0x3c, 0x00, 0x00, 0x00 },	// U+0276 (ɶ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+0277 (ɷ)
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x00 },	// U+0278 (ɸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+0279 (ɹ)
	{ 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+027A (ɺ)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x22, 0x3c, 0x20, 0x20, 0xc0 },	// U+027B (ɻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00 },	// U+027C (ɼ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0c },	// U+027D (ɽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+027E (ɾ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+027F (ɿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x1e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0280 (ʀ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x1e, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0281 (ʁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x02, 0x02, 0x0c },	// U+0282 (ʂ)
	{ 0x00, 0x60, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c },	// U+0283 (ʃ)
	{ 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x0a, 0x04, 0x00 },	// U+0284 (ʄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30 },	// U+0285 (ʅ)
	{ 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x0a, 0x04 },	// U+0286 (ʆ)
	{ 0x00, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x10, 0x3c, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+0287 (ʇ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x38, 0x00 },	// U+0288 (ʈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x7f, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+0289 (ʉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x14, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+028A (ʊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+028B (ʋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x14, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+028C (ʌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x2a, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+028D (ʍ)
	{ 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x14, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+028E (ʎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+028F (ʏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x20, 0x20, 0xc0 },	// U+0290 (ʐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x24, 0x52, 0x3e, 0x08, 0x00, 0x00 },	// U+0291 (ʑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00 },	// U+0292 (ʒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x1c, 0x20, 0x2c, 0x12, 0x2c, 0x00 },	// U+0293 (ʓ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x18, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0294 (ʔ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x0c, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0295 (ʕ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x18, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0296 (ʖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1c },	// U+0297 (ʗ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x2a, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0298 (ʘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x1e, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0299 (ʙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x2c, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+029A (ʚ)
	{ 0x00, 0x60, 0x10, 0x10, 0x1c, 0x02, 0x02, 0x1a, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+029B (ʛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+029C (ʜ)
	{ 0x00, 0x00, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x38, 0x14, 0x08, 0x00 },	// U+029D (ʝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x24, 0x38, 0x28, 0x24, 0x22, 0x20, 0x20, 0x20 },	// U+029E (ʞ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x00, 0x00, 0x00 },	// U+029F (ʟ)
	{ 0x00, 0x60, 0x10, 0x10, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x1c, 0x10, 0x10, 0x30 },	// U+02A0 (ʠ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x08, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+02A1 (ʡ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x04, 0x08, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+02A2 (ʢ)
	{ 0x00, 0x08, 0x08, 0x08, 0x3c, 0x2a, 0x2a, 0x1a, 0x1a, 0x3c, 0x00, 0x00, 0x00 },	// U+02A3 (ʣ)
	{ 0x00, 0x08, 0x08, 0x08, 0x7c, 0x4a, 0x2a, 0x7a, 0x4a, 0x4c, 0x40, 0x30, 0x00 },	// U+02A4 (ʤ)
	{ 0x00, 0x08, 0x08, 0x08, 0x3c, 0x2a, 0x2a, 0x1a, 0x5a, 0xbc, 0x70, 0x08, 0x00 },	// U+02A5 (ʥ)
	{ 0x00, 0x00, 0x04, 0x04, 0x3e, 0x14, 0x14, 0x24, 0x24, 0x38, 0x00, 0x00, 0x00 },	// U+02A6 (ʦ)
	{ 0x00, 0x00, 0x24, 0x14, 0x1e, 0x14, 0x14, 0x14, 0x14, 0x18, 0x10, 0x08, 0x00 },	// U+02A7 (ʧ)
	{ 0x00, 0x04, 0x04, 0x0e, 0x24, 0x54, 0x14, 0x14, 0x54, 0xa8, 0x60, 0x10, 0x00 },	// U+02A8 (ʨ)
}; // 89

static const unsigned char cozette_block13[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x24, 0x24, 0x24, 0x24, 0x38, 0x20, 0x20, 0x00 },	// U+02AE (ʮ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x24, 0x24, 0x24, 0x24, 0x38, 0x20, 0x20, 0xc0 },	// U+02AF (ʯ)
	{ 0x04, 0x04, 0x0c, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B0 (ʰ)
	{ 0x08, 0x04, 0x0c, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B1 (ʱ)
	{ 0x00, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B2 (ʲ)
	{ 0x00, 0x18, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B3 (ʳ)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B4 (ʴ)
	{ 0x00, 0x08, 0x08, 0x08, 0x0e, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B5 (ʵ)
	{ 0x00, 0x12, 0x0a, 0x0e, 0x12, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B6 (ʶ)
	{ 0x00, 0x12, 0x12, 0x16, 0x16, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B7 (ʷ)
}; // 10

static const unsigned char cozette_block14[][13] = {
	{ 0x10, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02B9 (ʹ)
	{ 0x28, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BA (ʺ)
	{ 0x10, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BB (ʻ)
	{ 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BC (ʼ)
	{ 0x18, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BD (ʽ)
	{ 0x08, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BE (ʾ)
	{ 0x10, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02BF (ʿ)
	{ 0x00, 0x0c, 0x10, 0x10, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C0 (ˀ)
	{ 0x00, 0x18, 0x04, 0x04, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C1 (ˁ)
	{ 0x00, 0x10, 0x08, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C2 (˂)
	{ 0x00, 0x04, 0x08, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C3 (˃)
	{ 0x00, 0x00, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C4 (˄)
	{ 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C5 (˅)
	{ 0x00, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C6 (ˆ)
	{ 0x00, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C7 (ˇ)
	{ 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C8 (ˈ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02C9 (ˉ)
	{ 0x00, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02CA (ˊ)
	{ 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02CB (ˋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+02CC (ˌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00 },	// U+02CD (ˍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00 },	// U+02CE (ˎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+02CF (ˏ)
	{ 0x00, 0x00, 0x1c, 0x1c, 0x08, 0x00, 0x00, 0x08, 0x1c, 0x1c, 0x00, 0x00, 0x00 },	// U+02D0 (ː)
	{ 0x00, 0x00, 0x1c, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D1 (ˑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+02D2 (˒)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+02D3 (˓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+02D4 (˔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+02D5 (˕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+02D6 (˖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D7 (˗)
	{ 0x00, 0x14, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D8 (˘)
	{ 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02D9 (˙)
	{ 0x08, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DA (˚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x00 },	// U+02DB (˛)
	{ 0x00, 0x00, 0x2c, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DC (˜)
	{ 0x00, 0x48, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DD (˝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+02DE (˞)
	{ 0x14, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02DF (˟)
	{ 0x00, 0x14, 0x14, 0x08, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E0 (ˠ)
	{ 0x00, 0x0c, 0x08, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E1 (ˡ)
	{ 0x00, 0x18, 0x04, 0x1c, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E2 (ˢ)
	{ 0x00, 0x14, 0x14, 0x08, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E3 (ˣ)
	{ 0x00, 0x18, 0x04, 0x04, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02E4 (ˤ)
	{ 0x00, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+02E5 (˥)
	{ 0x00, 0x10, 0x10, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+02E6 (˦)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+02E7 (˧)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+02E8 (˨)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x00, 0x00, 0x00 },	// U+02E9 (˩)
}; // 49

static const unsigned char cozette_block15[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x08, 0x00 },	// U+02EC (ˬ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02ED (˭)
}; // 2

static const unsigned char cozette_block16[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x00 },	// U+02EF (˯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x00, 0x00 },	// U+02F0 (˰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x08, 0x10, 0x00 },	// U+02F1 (˱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x08, 0x04, 0x00 },	// U+02F2 (˲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x08 },	// U+02F3 (˳)
	{ 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F4 (˴)
	{ 0x00, 0x00, 0x00, 0x12, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F5 (˵)
	{ 0x00, 0x00, 0x00, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F6 (˶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x1a, 0x00 },	// U+02F7 (˷)
}; // 9

static const unsigned char cozette_block17[][13] = {
	{ 0x00, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02F9 (˹)
	{ 0x00, 0x38, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+02FA (˺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x00, 0x00 },	// U+02FB (˻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x38, 0x00, 0x00 },	// U+02FC (˼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x3e, 0x00 },	// U+02FD (˽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3e, 0x00 },	// U+02FE (˾)
}; // 6

static const unsigned char cozette_block18[][13] = {
	{ 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0300 (̀)
	{ 0x00, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0301 (́)
	{ 0x00, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0302 (̂)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0303 (̃)
	{ 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0304 (̄)
	{ 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0305 (̅)
	{ 0x00, 0x14, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0306 (̆)
	{ 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0307 (̇)
	{ 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0308 (̈)
	{ 0x1c, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0309 (̉)
	{ 0x08, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030A (̊)
	{ 0x00, 0x48, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030B (̋)
	{ 0x00, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030C (̌)
	{ 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030D (̍)
	{ 0x00, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030E (̎)
	{ 0x00, 0x12, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+030F (̏)
	{ 0x08, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0310 (̐)
	{ 0x00, 0x1c, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0311 (̑)
	{ 0x10, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0312 (̒)
	{ 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0313 (̓)
	{ 0x18, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0314 (̔)
	{ 0x60, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0315 (̕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10 },	// U+0316 (̖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04 },	// U+0317 (̗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x08 },	// U+0318 (̘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x08 },	// U+0319 (̙)
	{ 0x00, 0x1c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+031A (̚)
	{ 0x00, 0x40, 0x40, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+031B (̛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x08 },	// U+031C (̜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c },	// U+031D (̝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x08 },	// U+031E (̞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08 },	// U+031F (̟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00 },	// U+0320 (̠)
}; // 33

static const unsigned char cozette_block19[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00 },	// U+0323 (̣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00 },	// U+0324 (̤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x08 },	// U+0325 (̥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x08 },	// U+0326 (̦)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x0c },	// U+0327 (̧)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x00 },	// U+0328 (̨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08 },	// U+0329 (̩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22 },	// U+032A (̪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x14 },	// U+032B (̫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x08 },	// U+032C (̬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14 },	// U+032D (̭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x1c },	// U+032E (̮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x14 },	// U+032F (̯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x1a },	// U+0330 (̰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00 },	// U+0331 (̱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00 },	// U+0332 (̲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e },	// U+0333 (̳)
}; // 17

static const unsigned char cozette_block20[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x04 },	// U+0339 (̹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x3e },	// U+033A (̺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x14, 0x1c },	// U+033B (̻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x08 },	// U+033C (̼)
	{ 0x14, 0x08, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+033D (̽)
	{ 0x18, 0x08, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+033E (̾)
	{ 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+033F (̿)
	{ 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0340 (̀)
	{ 0x00, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0341 (́)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0342 (͂)
	{ 0x0c, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0343 (̓)
}; // 11

static const unsigned char cozette_block21[][13] = {
	{ 0x00, 0x3e, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0346 (͆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c },	// U+0347 (͇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14 },	// U+0348 (͈)
}; // 3

static const unsigned char cozette_block22[][13] = {
	{ 0x04, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0351 (͑)
}; // 1

static const unsigned char cozette_block23[][13] = {
	{ 0x08, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+0357 (͗)
}; // 1

static const unsigned char cozette_block24[][13] = {
	{ 0x00, 0x00, 0x0a, 0x09, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0386 (Ά)
}; // 1

static const unsigned char cozette_block25[][13] = {
	{ 0x00, 0x00, 0x3a, 0x09, 0x08, 0x18, 0x08, 0x08, 0x08, 0x38, 0x00, 0x00, 0x00 },	// U+0388 (Έ)
	{ 0x00, 0x02, 0x25, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+0389 (Ή)
	{ 0x00, 0x02, 0x1d, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+038A (Ί)
}; // 3

static const unsigned char cozette_block26[][13] = {
	{ 0x00, 0x00, 0x1a, 0x25, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+038C (Ό)
}; // 1

static const unsigned char cozette_block27[][13] = {
	{ 0x00, 0x00, 0x2a, 0x29, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+038E (Ύ)
	{ 0x00, 0x00, 0x02, 0x1d, 0x14, 0x22, 0x22, 0x14, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+038F (Ώ)
	{ 0x10, 0x08, 0x00, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+0390 (ΐ)
	{ 0x00, 0x00, 0x08, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0391 (Α)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0392 (Β)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0393 (Γ)
	{ 0x00, 0x00, 0x08, 0x08, 0x14, 0x14, 0x14, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00 },	// U+0394 (Δ)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0395 (Ε)
	{ 0x00, 0x00, 0x3e, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0396 (Ζ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0397 (Η)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0398 (Θ)
	{ 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0399 (Ι)
	{ 0x00, 0x00, 0x22, 0x12, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+039A (Κ)
	{ 0x00, 0x00, 0x08, 0x08, 0x14, 0x14, 0x14, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+039B (Λ)
	{ 0x00, 0x00, 0x22, 0x22, 0x36, 0x36, 0x2a, 0x2a, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+039C (Μ)
	{ 0x00, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x00, 0x00 },	// U+039D (Ν)
	{ 0x00, 0x00, 0x3e, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+039E (Ξ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+039F (Ο)
	{ 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+03A0 (Π)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+03A1 (Ρ)
}; // 20

static const unsigned char cozette_block28[][13] = {
	{ 0x00, 0x00, 0x3e, 0x22, 0x04, 0x08, 0x08, 0x04, 0x22, 0x3e, 0x00, 0x00, 0x00 },	// U+03A3 (Σ)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+03A4 (Τ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+03A5 (Υ)
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x00, 0x00 },	// U+03A6 (Φ)
	{ 0x00, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+03A7 (Χ)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+03A8 (Ψ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x36, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+03A9 (Ω)
	{ 0x00, 0x14, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+03AA (Ϊ)
	{ 0x00, 0x14, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+03AB (Ϋ)
	{ 0x00, 0x10, 0x08, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+03AC (ά)
	{ 0x00, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+03AD (έ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+03AE (ή)
	{ 0x00, 0x10, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+03AF (ί)
	{ 0x00, 0x00, 0x14, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+03B0 (ΰ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+03B1 (α)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1a, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02 },	// U+03B2 (β)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x1c, 0x12, 0x18, 0x18, 0x14, 0x14, 0x14, 0x08 },	// U+03B3 (γ)
	{ 0x00, 0x00, 0x00, 0x3e, 0x02, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+03B4 (δ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+03B5 (ε)
	{ 0x00, 0x00, 0x00, 0x3e, 0x18, 0x04, 0x02, 0x02, 0x02, 0x3c, 0x20, 0x10, 0x00 },	// U+03B6 (ζ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+03B7 (η)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+03B8 (θ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+03B9 (ι)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+03BA (κ)
	{ 0x00, 0x00, 0x06, 0x08, 0x08, 0x08, 0x14, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+03BB (λ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x32, 0x2e, 0x02, 0x02, 0x02 },	// U+03BC (μ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1a, 0x22, 0x24, 0x24, 0x18, 0x08, 0x00, 0x00, 0x00 },	// U+03BD (ν)
	{ 0x00, 0x00, 0x00, 0x3e, 0x04, 0x3c, 0x02, 0x02, 0x02, 0x3c, 0x20, 0x10, 0x00 },	// U+03BE (ξ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+03BF (ο)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x14, 0x14, 0x14, 0x14, 0x24, 0x00, 0x00, 0x00 },	// U+03C0 (π)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x26, 0x1a, 0x02, 0x02, 0x02 },	// U+03C1 (ρ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x3c, 0x20, 0x20, 0x10 },	// U+03C2 (ς)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x12, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+03C3 (σ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+03C4 (τ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+03C5 (υ)
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x08 },	// U+03C6 (φ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x24, 0x14, 0x08, 0x08, 0x14, 0x12, 0x22, 0x00 },	// U+03C7 (χ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x08 },	// U+03C8 (ψ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+03C9 (ω)
	{ 0x00, 0x00, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+03CA (ϊ)
	{ 0x10, 0x08, 0x00, 0x14, 0x00, 0x12, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+03CB (ϋ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+03CC (ό)
	{ 0x00, 0x10, 0x08, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+03CD (ύ)
	{ 0x00, 0x10, 0x08, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+03CE (ώ)
}; // 44

static const unsigned char cozette_block29[][13] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x00 },	// U+03D5 (ϕ)
}; // 1

static const unsigned char cozette_block30[][13] = {
	{ 0x00, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3c, 0x20, 0x20, 0x10 },	// U+03DA (Ϛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x02, 0x02, 0x3c, 0x20, 0x20, 0x10 },	// U+03DB (ϛ)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+03DC (Ϝ)
	{ 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06 },	// U+03DD (ϝ)
}; // 4

static const unsigned char cozette_block31[][13] = {
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+03F4 (ϴ)
}; // 1

static const unsigned char cozette_block32[][13] = {
	{ 0x00, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+03F7 (Ϸ)
	{ 0x00, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x00 },	// U+03F8 (ϸ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+03F9 (Ϲ)
}; // 3

static const unsigned char cozette_block33[][13] = {
	{ 0x04, 0x08, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0400 (Ѐ)
	{ 0x14, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0401 (Ё)
	{ 0x00, 0x00, 0x1e, 0x04, 0x04, 0x34, 0x2c, 0x24, 0x24, 0x24, 0x20, 0x18, 0x00 },	// U+0402 (Ђ)
	{ 0x10, 0x08, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0403 (Ѓ)
	{ 0x00, 0x00, 0x18, 0x24, 0x02, 0x1e, 0x02, 0x02, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+0404 (Є)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0405 (Ѕ)
	{ 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0406 (І)
	{ 0x14, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0407 (Ї)
	{ 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00 },	// U+0408 (Ј)
	{ 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x1a, 0x2a, 0x2a, 0x2a, 0x19, 0x00, 0x00, 0x00 },	// U+0409 (Љ)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x1e, 0x2a, 0x2a, 0x2a, 0x1a, 0x00, 0x00, 0x00 },	// U+040A (Њ)
	{ 0x00, 0x00, 0x1e, 0x04, 0x04, 0x34, 0x2c, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+040B (Ћ)
	{ 0x10, 0x08, 0x22, 0x22, 0x12, 0x0a, 0x16, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+040C (Ќ)
	{ 0x04, 0x08, 0x22, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x22, 0x00, 0x00, 0x00 },	// U+040D (Ѝ)
	{ 0x14, 0x08, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x06, 0x00, 0x00, 0x00 },	// U+040E (Ў)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x08, 0x08, 0x00 },	// U+040F (Џ)
	{ 0x00, 0x00, 0x08, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0410 (А)
	{ 0x00, 0x00, 0x1e, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0411 (Б)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0412 (В)
	{ 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0413 (Г)
	{ 0x00, 0x00, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x7e, 0x42, 0x00, 0x00 },	// U+0414 (Д)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+0415 (Е)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x1c, 0x1c, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+0416 (Ж)
	{ 0x00, 0x00, 0x1e, 0x22, 0x20, 0x18, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0417 (З)
	{ 0x00, 0x00, 0x22, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x22, 0x00, 0x00, 0x00 },	// U+0418 (И)
	{ 0x14, 0x08, 0x22, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x22, 0x00, 0x00, 0x00 },	// U+0419 (Й)
	{ 0x00, 0x00, 0x22, 0x22, 0x12, 0x0a, 0x16, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+041A (К)
	{ 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x00, 0x00, 0x00 },	// U+041B (Л)
	{ 0x00, 0x00, 0x22, 0x22, 0x36, 0x36, 0x2a, 0x2a, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+041C (М)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+041D (Н)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+041E (О)
	{ 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+041F (П)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+0420 (Р)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0421 (С)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0422 (Т)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x06, 0x00, 0x00, 0x00 },	// U+0423 (У)
	{ 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+0424 (Ф)
	{ 0x00, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0425 (Х)
	{ 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x3e, 0x20, 0x00, 0x00 },	// U+0426 (Ц)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+0427 (Ч)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x3e, 0x00, 0x00, 0x00 },	// U+0428 (Ш)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x3e, 0x40, 0x70, 0x00 },	// U+0429 (Щ)
	{ 0x00, 0x00, 0x07, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x1c, 0x00, 0x00, 0x00 },	// U+042A (Ъ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x26, 0x2a, 0x2a, 0x2a, 0x26, 0x00, 0x00, 0x00 },	// U+042B (Ы)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+042C (Ь)
	{ 0x00, 0x00, 0x0c, 0x12, 0x20, 0x3c, 0x20, 0x20, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+042D (Э)
	{ 0x00, 0x00, 0x12, 0x2a, 0x2a, 0x2e, 0x2a, 0x2a, 0x2a, 0x12, 0x00, 0x00, 0x00 },	// U+042E (Ю)
	{ 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x3c, 0x28, 0x24, 0x22, 0x00, 0x00, 0x00 },	// U+042F (Я)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x3c, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+0430 (а)
	{ 0x00, 0x20, 0x1c, 0x02, 0x1a, 0x26, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0431 (б)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x1e, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+0432 (в)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0433 (г)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x22, 0x7e, 0x42, 0x00, 0x00 },	// U+0434 (д)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0435 (е)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x1c, 0x1c, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+0436 (ж)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x18, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0437 (з)
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x00, 0x00, 0x00 },	// U+0438 (и)
	{ 0x00, 0x14, 0x08, 0x00, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x00, 0x00, 0x00 },	// U+0439 (й)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+043A (к)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x22, 0x00, 0x00, 0x00 },	// U+043B (л)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x36, 0x36, 0x2a, 0x2a, 0x22, 0x00, 0x00, 0x00 },	// U+043C (м)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+043D (н)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+043E (о)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+043F (п)
	{ 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x26, 0x1a, 0x02, 0x02, 0x02 },	// U+0440 (р)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0441 (с)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0442 (т)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x06, 0x00 },	// U+0443 (у)
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x00 },	// U+0444 (ф)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00 },	// U+0445 (х)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x3e, 0x20, 0x00, 0x00 },	// U+0446 (ц)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+0447 (ч)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x3e, 0x00, 0x00, 0x00 },	// U+0448 (ш)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x3e, 0x40, 0x70, 0x00 },	// U+0449 (щ)
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x1c, 0x24, 0x24, 0x1c, 0x00, 0x00, 0x00 },	// U+044A (ъ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x26, 0x2a, 0x2a, 0x26, 0x00, 0x00, 0x00 },	// U+044B (ы)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+044C (ь)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x3c, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+044D (э)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x2a, 0x2e, 0x2a, 0x2a, 0x12, 0x00, 0x00, 0x00 },	// U+044E (ю)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x3c, 0x24, 0x22, 0x00, 0x00, 0x00 },	// U+044F (я)
	{ 0x00, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0450 (ѐ)
	{ 0x00, 0x00, 0x14, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0451 (ё)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x34, 0x2c, 0x24, 0x24, 0x20, 0x18, 0x00 },	// U+0452 (ђ)
	{ 0x00, 0x10, 0x08, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0453 (ѓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x0e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0454 (є)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x0c, 0x10, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0455 (ѕ)
	{ 0x00, 0x00, 0x08, 0x00, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0456 (і)
	{ 0x00, 0x00, 0x14, 0x00, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+0457 (ї)
	{ 0x00, 0x00, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x08, 0x00 },	// U+0458 (ј)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x1a, 0x2a, 0x2a, 0x19, 0x00, 0x00, 0x00 },	// U+0459 (љ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x1e, 0x2a, 0x2a, 0x1a, 0x00, 0x00, 0x00 },	// U+045A (њ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x34, 0x2c, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+045B (ћ)
	{ 0x00, 0x10, 0x08, 0x00, 0x22, 0x12, 0x0a, 0x16, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+045C (ќ)
	{ 0x00, 0x04, 0x08, 0x00, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x00, 0x00, 0x00 },	// U+045D (ѝ)
	{ 0x00, 0x14, 0x08, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x06, 0x00 },	// U+045E (ў)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x08, 0x08, 0x00 },	// U+045F (џ)
	{ 0x00, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+0460 (Ѡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+0461 (ѡ)
	{ 0x00, 0x00, 0x04, 0x1e, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x1e, 0x00, 0x00, 0x00 },	// U+0462 (Ѣ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x1c, 0x24, 0x24, 0x1c, 0x00, 0x00, 0x00 },	// U+0463 (ѣ)
	{ 0x00, 0x00, 0x32, 0x0a, 0x0a, 0x1e, 0x0a, 0x0a, 0x0a, 0x32, 0x00, 0x00, 0x00 },	// U+0464 (Ѥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x32, 0x0a, 0x1e, 0x0a, 0x0a, 0x32, 0x00, 0x00, 0x00 },	// U+0465 (ѥ)
	{ 0x00, 0x00, 0x08, 0x08, 0x14, 0x14, 0x1c, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+0466 (Ѧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x3e, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+0467 (ѧ)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x16, 0x16, 0x1e, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+0468 (Ѩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x16, 0x1e, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+0469 (ѩ)
	{ 0x00, 0x00, 0x3e, 0x22, 0x14, 0x14, 0x1c, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+046A (Ѫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x14, 0x1c, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+046B (ѫ)
	{ 0x00, 0x00, 0x3e, 0x22, 0x16, 0x16, 0x1e, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+046C (Ѭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x16, 0x1e, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+046D (ѭ)
	{ 0x14, 0x08, 0x1c, 0x22, 0x20, 0x18, 0x20, 0x20, 0x20, 0x1c, 0x02, 0x1c, 0x00 },	// U+046E (Ѯ)
	{ 0x00, 0x00, 0x14, 0x08, 0x1c, 0x22, 0x18, 0x20, 0x20, 0x1c, 0x02, 0x1c, 0x00 },	// U+046F (ѯ)
	{ 0x00, 0x00, 0x6a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+0470 (Ѱ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x08, 0x08, 0x00 },	// U+0471 (ѱ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0472 (Ѳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0473 (ѳ)
	{ 0x00, 0x00, 0x62, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0474 (Ѵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0475 (ѵ)
	{ 0x0a, 0x14, 0x00, 0x62, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0476 (Ѷ)
	{ 0x00, 0x0a, 0x14, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+0477 (ѷ)
	{ 0x00, 0x00, 0x22, 0x22, 0x14, 0x08, 0x1c, 0x2a, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0478 (Ѹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0479 (ѹ)
	{ 0x00, 0x00, 0x1c, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+047A (Ѻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x22, 0x22, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+047B (ѻ)
	{ 0x1c, 0x00, 0x08, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+047C (Ѽ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x2a, 0x22, 0x22, 0x22, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+047D (ѽ)
	{ 0x3e, 0x2a, 0x00, 0x22, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+047E (Ѿ)
	{ 0x00, 0x3e, 0x2a, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x14, 0x00, 0x00, 0x00 },	// U+047F (ѿ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1c, 0x10, 0x10, 0x00 },	// U+0480 (Ҁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x1c, 0x10, 0x10, 0x00 },	// U+0481 (ҁ)
	{ 0x00, 0x00, 0x10, 0x10, 0x0e, 0x38, 0x0e, 0x38, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0482 (҂)
}; // 131

static const unsigned char cozette_block34[][13] = {
	{ 0x14, 0x08, 0x22, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x22, 0x20, 0x10, 0x00 },	// U+048A (Ҋ)
	{ 0x00, 0x14, 0x08, 0x00, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x20, 0x10, 0x00 },	// U+048B (ҋ)
	{ 0x00, 0x00, 0x04, 0x04, 0x0e, 0x04, 0x1c, 0x24, 0x24, 0x1e, 0x00, 0x00, 0x00 },	// U+048C (Ҍ)
	{ 0x00, 0x00, 0x04, 0x04, 0x04, 0x0e, 0x04, 0x1c, 0x24, 0x1c, 0x00, 0x00, 0x00 },	// U+048D (ҍ)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x2a, 0x1e, 0x22, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+048E (Ҏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1a, 0x26, 0x22, 0x22, 0x2a, 0x1e, 0x22, 0x02, 0x02 },	// U+048F (ҏ)
	{ 0x00, 0x20, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0490 (Ґ)
	{ 0x00, 0x00, 0x00, 0x20, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0491 (ґ)
	{ 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0492 (Ғ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+0493 (ғ)
	{ 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x24, 0x20, 0x10, 0x00 },	// U+0494 (Ҕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x1c, 0x24, 0x24, 0x20, 0x10, 0x00 },	// U+0495 (ҕ)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x1c, 0x1c, 0x2a, 0x2a, 0x2a, 0x20, 0x20, 0x00 },	// U+0496 (Җ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x1c, 0x1c, 0x2a, 0x2a, 0x20, 0x20, 0x00 },	// U+0497 (җ)
	{ 0x00, 0x00, 0x1e, 0x22, 0x20, 0x18, 0x20, 0x20, 0x22, 0x1c, 0x08, 0x0c, 0x00 },	// U+0498 (Ҙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x18, 0x20, 0x22, 0x1c, 0x08, 0x0c, 0x00 },	// U+0499 (ҙ)
	{ 0x00, 0x00, 0x12, 0x12, 0x12, 0x0a, 0x0e, 0x0a, 0x12, 0x32, 0x20, 0x20, 0x00 },	// U+049A (Қ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x12, 0x32, 0x20, 0x20, 0x00 },	// U+049B (қ)
	{ 0x00, 0x00, 0x22, 0x2a, 0x1a, 0x0a, 0x1e, 0x1a, 0x2a, 0x22, 0x00, 0x00, 0x00 },	// U+049C (Ҝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x2a, 0x1a, 0x1e, 0x2a, 0x22, 0x00, 0x00, 0x00 },	// U+049D (ҝ)
	{ 0x00, 0x00, 0x22, 0x27, 0x12, 0x0a, 0x16, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+049E (Ҟ)
	{ 0x00, 0x00, 0x02, 0x0f, 0x22, 0x12, 0x0a, 0x16, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+049F (ҟ)
	{ 0x00, 0x00, 0x27, 0x24, 0x14, 0x14, 0x1c, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+04A0 (Ҡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x27, 0x14, 0x14, 0x1c, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+04A1 (ҡ)
	{ 0x00, 0x00, 0x12, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x32, 0x20, 0x20, 0x00 },	// U+04A2 (Ң)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x32, 0x20, 0x20, 0x00 },	// U+04A3 (ң)
	{ 0x00, 0x00, 0x72, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+04A4 (Ҥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x72, 0x12, 0x1e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+04A5 (ҥ)
	{ 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x0a, 0x1a, 0x2a, 0x2a, 0x2a, 0x20, 0x10, 0x00 },	// U+04A6 (Ҧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x1a, 0x2a, 0x2a, 0x20, 0x10, 0x00 },	// U+04A7 (ҧ)
	{ 0x00, 0x00, 0x04, 0x12, 0x2a, 0x2a, 0x2a, 0x2a, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+04A8 (Ҩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x12, 0x2a, 0x2a, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+04A9 (ҩ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x10, 0x18, 0x00 },	// U+04AA (Ҫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x22, 0x1c, 0x10, 0x18, 0x00 },	// U+04AB (ҫ)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x10, 0x10, 0x00 },	// U+04AC (Ҭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x18, 0x10, 0x10, 0x00 },	// U+04AD (ҭ)
	{ 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+04AE (Ү)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+04AF (ү)
	{ 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+04B0 (Ұ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x1c, 0x08, 0x08, 0x00 },	// U+04B1 (ұ)
	{ 0x00, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+04B2 (Ҳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x20, 0x20, 0x00 },	// U+04B3 (ҳ)
	{ 0x00, 0x00, 0x2e, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x7c, 0x40, 0x00, 0x00 },	// U+04B4 (Ҵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2e, 0x24, 0x24, 0x24, 0x24, 0x7c, 0x40, 0x00, 0x00 },	// U+04B5 (ҵ)
	{ 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x1c, 0x10, 0x10, 0x30, 0x20, 0x20, 0x00 },	// U+04B6 (Ҷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x1c, 0x10, 0x30, 0x20, 0x20, 0x00 },	// U+04B7 (ҷ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x2a, 0x3c, 0x28, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+04B8 (Ҹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x2a, 0x3c, 0x28, 0x20, 0x00, 0x00, 0x00 },	// U+04B9 (ҹ)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+04BA (Һ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+04BB (һ)
	{ 0x00, 0x00, 0x10, 0x28, 0x2a, 0x3c, 0x08, 0x08, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+04BC (Ҽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x2a, 0x3c, 0x08, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+04BD (ҽ)
	{ 0x00, 0x00, 0x10, 0x28, 0x2a, 0x3c, 0x08, 0x08, 0x28, 0x10, 0x10, 0x10, 0x00 },	// U+04BE (Ҿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x2a, 0x3c, 0x08, 0x28, 0x10, 0x10, 0x10, 0x00 },	// U+04BF (ҿ)
	{ 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+04C0 (Ӏ)
	{ 0x14, 0x08, 0x00, 0x2a, 0x2a, 0x2a, 0x1c, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+04C1 (Ӂ)
	{ 0x00, 0x14, 0x08, 0x00, 0x2a, 0x2a, 0x1c, 0x1c, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+04C2 (ӂ)
	{ 0x00, 0x00, 0x22, 0x22, 0x12, 0x0a, 0x16, 0x12, 0x22, 0x22, 0x20, 0x18, 0x00 },	// U+04C3 (Ӄ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x12, 0x0a, 0x16, 0x12, 0x22, 0x20, 0x18, 0x00 },	// U+04C4 (ӄ)
	{ 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x20, 0x10, 0x00 },	// U+04C5 (Ӆ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x22, 0x20, 0x10, 0x00 },	// U+04C6 (ӆ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x18, 0x00, 0x00 },	// U+04C7 (Ӈ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x18, 0x00, 0x00 },	// U+04C8 (ӈ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x10, 0x00 },	// U+04C9 (Ӊ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x20, 0x10, 0x00 },	// U+04CA (ӊ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x30, 0x10, 0x10, 0x00 },	// U+04CB (Ӌ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x30, 0x10, 0x10, 0x00 },	// U+04CC (ӌ)
	{ 0x00, 0x00, 0x22, 0x22, 0x36, 0x36, 0x2a, 0x2a, 0x22, 0x22, 0x20, 0x10, 0x00 },	// U+04CD (Ӎ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x36, 0x36, 0x2a, 0x2a, 0x22, 0x20, 0x10, 0x00 },	// U+04CE (ӎ)
	{ 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+04CF (ӏ)
	{ 0x14, 0x08, 0x00, 0x08, 0x08, 0x14, 0x1c, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+04D0 (Ӑ)
	{ 0x00, 0x14, 0x08, 0x00, 0x1c, 0x20, 0x3c, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+04D1 (ӑ)
	{ 0x14, 0x00, 0x08, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+04D2 (Ӓ)
	{ 0x00, 0x00, 0x14, 0x00, 0x1c, 0x20, 0x3c, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+04D3 (ӓ)
	{ 0x00, 0x00, 0x38, 0x18, 0x14, 0x34, 0x1c, 0x14, 0x12, 0x32, 0x00, 0x00, 0x00 },	// U+04D4 (Ӕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x28, 0x3c, 0x0a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+04D5 (ӕ)
	{ 0x14, 0x08, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+04D6 (Ӗ)
	{ 0x00, 0x14, 0x08, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04D7 (ӗ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x3e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04D8 (Ә)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x3e, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04D9 (ә)
	{ 0x14, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x3e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04DA (Ӛ)
	{ 0x00, 0x00, 0x14, 0x00, 0x1c, 0x22, 0x20, 0x3e, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04DB (ӛ)
	{ 0x14, 0x00, 0x2a, 0x2a, 0x2a, 0x1c, 0x1c, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+04DC (Ӝ)
	{ 0x00, 0x00, 0x14, 0x00, 0x2a, 0x2a, 0x1c, 0x1c, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+04DD (ӝ)
	{ 0x14, 0x00, 0x1e, 0x22, 0x20, 0x18, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04DE (Ӟ)
	{ 0x00, 0x00, 0x14, 0x00, 0x1c, 0x22, 0x18, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04DF (ӟ)
	{ 0x00, 0x00, 0x3e, 0x20, 0x10, 0x18, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04E0 (Ӡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x10, 0x08, 0x1c, 0x20, 0x22, 0x1c, 0x00 },	// U+04E1 (ӡ)
	{ 0x1c, 0x00, 0x22, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x22, 0x00, 0x00, 0x00 },	// U+04E2 (Ӣ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x00, 0x00, 0x00 },	// U+04E3 (ӣ)
	{ 0x14, 0x00, 0x22, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x22, 0x00, 0x00, 0x00 },	// U+04E4 (Ӥ)
	{ 0x00, 0x00, 0x14, 0x00, 0x32, 0x32, 0x2a, 0x2a, 0x26, 0x26, 0x00, 0x00, 0x00 },	// U+04E5 (ӥ)
	{ 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04E6 (Ӧ)
	{ 0x00, 0x00, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04E7 (ӧ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04E8 (Ө)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04E9 (ө)
	{ 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04EA (Ӫ)
	{ 0x00, 0x00, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+04EB (ӫ)
	{ 0x14, 0x00, 0x0c, 0x12, 0x20, 0x3c, 0x20, 0x20, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+04EC (Ӭ)
	{ 0x00, 0x00, 0x14, 0x00, 0x1e, 0x20, 0x3c, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+04ED (ӭ)
	{ 0x1c, 0x00, 0x22, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x06, 0x00, 0x00, 0x00 },	// U+04EE (Ӯ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x06, 0x00 },	// U+04EF (ӯ)
	{ 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x06, 0x00, 0x00, 0x00 },	// U+04F0 (Ӱ)
	{ 0x00, 0x00, 0x14, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x06, 0x00 },	// U+04F1 (ӱ)
	{ 0x28, 0x14, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x06, 0x00, 0x00, 0x00 },	// U+04F2 (Ӳ)
	{ 0x00, 0x28, 0x14, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x06, 0x00 },	// U+04F3 (ӳ)
	{ 0x14, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+04F4 (Ӵ)
	{ 0x00, 0x00, 0x14, 0x00, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+04F5 (ӵ)
	{ 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x08, 0x08, 0x00 },	// U+04F6 (Ӷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x08, 0x08, 0x00 },	// U+04F7 (ӷ)
	{ 0x14, 0x00, 0x22, 0x22, 0x22, 0x26, 0x2a, 0x2a, 0x2a, 0x26, 0x00, 0x00, 0x00 },	// U+04F8 (Ӹ)
	{ 0x00, 0x00, 0x14, 0x00, 0x22, 0x22, 0x26, 0x2a, 0x2a, 0x26, 0x00, 0x00, 0x00 },	// U+04F9 (ӹ)
	{ 0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x1c, 0x10, 0x0c, 0x00 },	// U+04FA (Ӻ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x1e, 0x04, 0x04, 0x1c, 0x10, 0x0c, 0x00 },	// U+04FB (ӻ)
	{ 0x00, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x22, 0x20, 0x18, 0x00 },	// U+04FC (Ӽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x20, 0x18, 0x00 },	// U+04FD (ӽ)
	{ 0x00, 0x00, 0x22, 0x22, 0x14, 0x3e, 0x1c, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+04FE (Ӿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x3e, 0x1c, 0x14, 0x22, 0x00, 0x00, 0x00 },	// U+04FF (ӿ)
	{ 0x00, 0x00, 0x38, 0x10, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x3c, 0x00, 0x00, 0x00 },	// U+0500 (Ԁ)
	{ 0x00, 0x00, 0x20, 0x2c, 0x32, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+0501 (ԁ)
	{ 0x00, 0x00, 0x1c, 0x08, 0x0c, 0x2a, 0x2a, 0x2a, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+0502 (Ԃ)
	{ 0x00, 0x00, 0x08, 0x08, 0x0c, 0x0a, 0x0a, 0x2a, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+0503 (ԃ)
	{ 0x00, 0x00, 0x06, 0x08, 0x08, 0x26, 0x28, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0504 (Ԅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x28, 0x26, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+0505 (ԅ)
	{ 0x00, 0x00, 0x0c, 0x12, 0x10, 0x08, 0x0c, 0x10, 0x10, 0x30, 0x20, 0x20, 0x00 },	// U+0506 (Ԇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x10, 0x0c, 0x10, 0x30, 0x20, 0x20, 0x00 },	// U+0507 (ԇ)
	{ 0x00, 0x00, 0x0e, 0x0a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x11, 0x00, 0x00, 0x00 },	// U+0508 (Ԉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x2a, 0x2a, 0x2a, 0x11, 0x00, 0x00, 0x00 },	// U+0509 (ԉ)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x2a, 0x2e, 0x2a, 0x2a, 0x2a, 0x12, 0x00, 0x00, 0x00 },	// U+050A (Ԋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x2e, 0x2a, 0x2a, 0x12, 0x00, 0x00, 0x00 },	// U+050B (ԋ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+050C (Ԍ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x02, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+050D (ԍ)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x28, 0x28, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+050E (Ԏ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x28, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00 },	// U+050F (ԏ)
	{ 0x00, 0x00, 0x3c, 0x22, 0x02, 0x0c, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0510 (Ԑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+0511 (ԑ)
	{ 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x18, 0x00, 0x00 },	// U+0512 (Ԓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x22, 0x18, 0x00, 0x00 },	// U+0513 (ԓ)
	{ 0x00, 0x00, 0x2e, 0x2a, 0x2a, 0x12, 0x12, 0x2a, 0x2a, 0x29, 0x00, 0x00, 0x00 },	// U+0514 (Ԕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2e, 0x2a, 0x12, 0x12, 0x2a, 0x29, 0x00, 0x00, 0x00 },	// U+0515 (ԕ)
	{ 0x00, 0x00, 0x26, 0x2a, 0x1a, 0x0a, 0x0e, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+0516 (Ԗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x26, 0x2a, 0x1a, 0x1a, 0x2a, 0x26, 0x02, 0x02, 0x02 },	// U+0517 (ԗ)
	{ 0x00, 0x00, 0x3c, 0x12, 0x12, 0x3c, 0x18, 0x14, 0x14, 0x32, 0x00, 0x00, 0x00 },	// U+0518 (Ԙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x3c, 0x0c, 0x2a, 0x12, 0x00, 0x00, 0x00 },	// U+0519 (ԙ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x10, 0x00 },	// U+051A (Ԛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x60 },	// U+051B (ԛ)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+051C (Ԝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+051D (ԝ)
	{ 0x00, 0x00, 0x22, 0x2a, 0x12, 0x2a, 0x0e, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+051E (Ԟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x12, 0x2a, 0x0e, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+051F (ԟ)
	{ 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x0a, 0x1a, 0x2a, 0x2a, 0x29, 0x20, 0x10, 0x00 },	// U+0520 (Ԡ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0a, 0x0a, 0x1a, 0x2a, 0x29, 0x20, 0x10, 0x00 },	// U+0521 (ԡ)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x1e, 0x2a, 0x2a, 0x2a, 0x2a, 0x20, 0x10, 0x00 },	// U+0522 (Ԣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x1e, 0x2a, 0x2a, 0x20, 0x10, 0x00 },	// U+0523 (ԣ)
	{ 0x00, 0x00, 0x1e, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x32, 0x20, 0x20, 0x00 },	// U+0524 (Ԥ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x12, 0x12, 0x12, 0x32, 0x20, 0x20, 0x00 },	// U+0525 (ԥ)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x32, 0x20, 0x20, 0x00 },	// U+0526 (Ԧ)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x32, 0x20, 0x20, 0x00 },	// U+0527 (ԧ)
	{ 0x00, 0x00, 0x24, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x24, 0x24, 0x05, 0x02, 0x00 },	// U+0528 (Ԩ)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x3c, 0x24, 0x24, 0x05, 0x02, 0x00 },	// U+0529 (ԩ)
	{ 0x00, 0x00, 0x28, 0x2c, 0x2c, 0x2a, 0x1a, 0x2a, 0x2a, 0x2e, 0x0a, 0x00, 0x00 },	// U+052A (Ԫ)
	{ 0x00, 0x00, 0x00, 0x00, 0x28, 0x2c, 0x2c, 0x1a, 0x2a, 0x2e, 0x0a, 0x00, 0x00 },	// U+052B (ԫ)
	{ 0x00, 0x00, 0x12, 0x1a, 0x1a, 0x16, 0x1c, 0x14, 0x12, 0x3e, 0x22, 0x00, 0x00 },	// U+052C (Ԭ)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x1a, 0x1c, 0x18, 0x14, 0x3e, 0x22, 0x00, 0x00 },	// U+052D (ԭ)
	{ 0x00, 0x00, 0x1c, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x32, 0x20, 0x20, 0x00 },	// U+052E (Ԯ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x14, 0x14, 0x14, 0x14, 0x32, 0x20, 0x20, 0x00 },	// U+052F (ԯ)
}; // 166

static const unsigned char cozette_block35[][13] = {
	{ 0x00, 0x20, 0x40, 0x3e, 0x1c, 0x22, 0x2a, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+0CA0 (ಠ)
}; // 1

static const unsigned char cozette_block36[][13] = {
	{ 0x00, 0x00, 0x12, 0x0a, 0x16, 0x0a, 0x06, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+16A0 (ᚠ)
}; // 1

static const unsigned char cozette_block37[][13] = {
	{ 0x00, 0x00, 0x06, 0x0a, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+16A2 (ᚢ)
	{ 0x00, 0x00, 0x06, 0x0a, 0x0a, 0x12, 0x12, 0x12, 0x22, 0x2a, 0x00, 0x00, 0x00 },	// U+16A3 (ᚣ)
	{ 0x00, 0x00, 0x06, 0x0a, 0x12, 0x22, 0x2a, 0x2a, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+16A4 (ᚤ)
	{ 0x00, 0x00, 0x06, 0x0a, 0x12, 0x26, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+16A5 (ᚥ)
	{ 0x00, 0x00, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+16A6 (ᚦ)
}; // 5

static const unsigned char cozette_block38[][13] = {
	{ 0x00, 0x00, 0x04, 0x0c, 0x14, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+16A8 (ᚨ)
	{ 0x00, 0x00, 0x04, 0x2c, 0x14, 0x2c, 0x14, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+16A9 (ᚩ)
	{ 0x00, 0x00, 0x04, 0x2c, 0x14, 0x0c, 0x14, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+16AA (ᚪ)
	{ 0x00, 0x00, 0x04, 0x0c, 0x34, 0x0c, 0x34, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+16AB (ᚫ)
	{ 0x00, 0x00, 0x08, 0x0c, 0x18, 0x08, 0x0c, 0x18, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+16AC (ᚬ)
}; // 5

static const unsigned char cozette_block39[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+1D00 (ᴀ)
}; // 1

static const unsigned char cozette_block40[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x1e, 0x02, 0x02, 0x1e, 0x00, 0x00, 0x00 },	// U+1D07 (ᴇ)
}; // 1

static const unsigned char cozette_block41[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x08, 0x08, 0x36, 0x00, 0x00, 0x00 },	// U+1D25 (ᴥ)
}; // 1

static const unsigned char cozette_block42[][13] = {
	{ 0x00, 0x0c, 0x10, 0x1c, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+1D4A (ᵊ)
}; // 1

static const unsigned char cozette_block43[][13] = {
	{ 0x00, 0x60, 0x10, 0x10, 0x1c, 0x12, 0x12, 0x12, 0x12, 0x1c, 0x10, 0x10, 0x60 },	// U+1D91 (ᶑ)
}; // 1

static const unsigned char cozette_block44[][13] = {
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x08, 0x14, 0x08 },	// U+1E00 (Ḁ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x08, 0x14, 0x08 },	// U+1E01 (ḁ)
	{ 0x08, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+1E02 (Ḃ)
	{ 0x08, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x00, 0x00 },	// U+1E03 (ḃ)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x08, 0x00 },	// U+1E04 (Ḅ)
	{ 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x08, 0x00 },	// U+1E05 (ḅ)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x3e, 0x00 },	// U+1E06 (Ḇ)
	{ 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x00, 0x3e, 0x00 },	// U+1E07 (ḇ)
	{ 0x10, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x02, 0x22, 0x1c, 0x08, 0x10, 0x0c },	// U+1E08 (Ḉ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x22, 0x1c, 0x08, 0x10, 0x0c },	// U+1E09 (ḉ)
	{ 0x08, 0x00, 0x0e, 0x12, 0x22, 0x22, 0x22, 0x22, 0x12, 0x0e, 0x00, 0x00, 0x00 },	// U+1E0A (Ḋ)
	{ 0x08, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+1E0B (ḋ)
	{ 0x00, 0x00, 0x0e, 0x12, 0x22, 0x22, 0x22, 0x22, 0x12, 0x0e, 0x00, 0x08, 0x00 },	// U+1E0C (Ḍ)
	{ 0x00, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x08, 0x00 },	// U+1E0D (ḍ)
	{ 0x00, 0x00, 0x0e, 0x12, 0x22, 0x22, 0x22, 0x22, 0x12, 0x0e, 0x00, 0x3e, 0x00 },	// U+1E0E (Ḏ)
	{ 0x00, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x3e, 0x00 },	// U+1E0F (ḏ)
	{ 0x00, 0x00, 0x0e, 0x12, 0x22, 0x22, 0x22, 0x22, 0x12, 0x0e, 0x08, 0x10, 0x0c },	// U+1E10 (Ḑ)
	{ 0x00, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x08, 0x10, 0x0c },	// U+1E11 (ḑ)
	{ 0x00, 0x00, 0x0e, 0x12, 0x22, 0x22, 0x22, 0x22, 0x12, 0x0e, 0x00, 0x08, 0x14 },	// U+1E12 (Ḓ)
	{ 0x00, 0x20, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x08, 0x14 },	// U+1E13 (ḓ)
	{ 0x04, 0x08, 0x00, 0x1c, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00 },	// U+1E14 (Ḕ)
	{ 0x04, 0x08, 0x00, 0x1c, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00 },	// U+1E15 (ḕ)
	{ 0x10, 0x08, 0x00, 0x1c, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00 },	// U+1E16 (Ḗ)
	{ 0x10, 0x08, 0x00, 0x1c, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00 },	// U+1E17 (ḗ)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x08, 0x14 },	// U+1E18 (Ḙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x08, 0x14 },	// U+1E19 (ḙ)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x2c, 0x1a },	// U+1E1A (Ḛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x2c, 0x1a },	// U+1E1B (ḛ)
	{ 0x14, 0x1c, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x08, 0x10, 0x0c },	// U+1E1C (Ḝ)
	{ 0x00, 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x08, 0x10, 0x0c },	// U+1E1D (ḝ)
	{ 0x08, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+1E1E (Ḟ)
	{ 0x08, 0x00, 0x38, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+1E1F (ḟ)
	{ 0x1c, 0x00, 0x1c, 0x22, 0x02, 0x02, 0x32, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1E20 (Ḡ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+1E21 (ḡ)
	{ 0x08, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1E22 (Ḣ)
	{ 0x08, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1E23 (ḣ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1E24 (Ḥ)
	{ 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1E25 (ḥ)
	{ 0x14, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1E26 (Ḧ)
	{ 0x14, 0x00, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1E27 (ḧ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x04, 0x03, 0x00 },	// U+1E28 (Ḩ)
	{ 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x04, 0x03, 0x00 },	// U+1E29 (ḩ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x14, 0x1c },	// U+1E2A (Ḫ)
	{ 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x14, 0x1c },	// U+1E2B (ḫ)
	{ 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x2c, 0x1a },	// U+1E2C (Ḭ)
	{ 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x2c, 0x1a },	// U+1E2D (ḭ)
	{ 0x10, 0x08, 0x00, 0x14, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1E2E (Ḯ)
	{ 0x10, 0x08, 0x00, 0x14, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+1E2F (ḯ)
	{ 0x10, 0x08, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x12, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1E30 (Ḱ)
	{ 0x00, 0x12, 0x0a, 0x02, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x00, 0x00, 0x00 },	// U+1E31 (ḱ)
	{ 0x00, 0x00, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x12, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1E32 (Ḳ)
	{ 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x00, 0x08, 0x00 },	// U+1E33 (ḳ)
	{ 0x00, 0x00, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x12, 0x22, 0x22, 0x00, 0x3e, 0x00 },	// U+1E34 (Ḵ)
	{ 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x00, 0x3e, 0x00 },	// U+1E35 (ḵ)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x08, 0x00 },	// U+1E36 (Ḷ)
	{ 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x08, 0x00 },	// U+1E37 (ḷ)
	{ 0x1c, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x08, 0x00 },	// U+1E38 (Ḹ)
	{ 0x1c, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x08, 0x00 },	// U+1E39 (ḹ)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x3e, 0x00 },	// U+1E3A (Ḻ)
	{ 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x3e, 0x00 },	// U+1E3B (ḻ)
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x08, 0x14 },	// U+1E3C (Ḽ)
	{ 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x08, 0x14 },	// U+1E3D (ḽ)
	{ 0x10, 0x08, 0x22, 0x36, 0x2a, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1E3E (Ḿ)
	{ 0x00, 0x10, 0x08, 0x00, 0x16, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+1E3F (ḿ)
	{ 0x08, 0x00, 0x22, 0x36, 0x2a, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1E40 (Ṁ)
	{ 0x00, 0x00, 0x08, 0x00, 0x16, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+1E41 (ṁ)
	{ 0x00, 0x00, 0x22, 0x36, 0x2a, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1E42 (Ṃ)
	{ 0x00, 0x00, 0x00, 0x00, 0x16, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x08, 0x00 },	// U+1E43 (ṃ)
	{ 0x08, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x00, 0x00 },	// U+1E44 (Ṅ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1E45 (ṅ)
	{ 0x00, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x08, 0x00 },	// U+1E46 (Ṇ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1E47 (ṇ)
	{ 0x00, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x3e, 0x00 },	// U+1E48 (Ṉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x3e, 0x00 },	// U+1E49 (ṉ)
	{ 0x00, 0x00, 0x22, 0x26, 0x26, 0x2a, 0x2a, 0x32, 0x32, 0x22, 0x00, 0x08, 0x14 },	// U+1E4A (Ṋ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x08, 0x14 },	// U+1E4B (ṋ)
	{ 0x10, 0x08, 0x00, 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1E4C (Ṍ)
	{ 0x10, 0x08, 0x00, 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1E4D (ṍ)
	{ 0x14, 0x00, 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1E4E (Ṏ)
	{ 0x14, 0x00, 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1E4F (ṏ)
	{ 0x04, 0x08, 0x00, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1E50 (Ṑ)
	{ 0x04, 0x08, 0x00, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1E51 (ṑ)
	{ 0x10, 0x08, 0x00, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1E52 (Ṓ)
	{ 0x10, 0x08, 0x00, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1E53 (ṓ)
	{ 0x10, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+1E54 (Ṕ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02 },	// U+1E55 (ṕ)
	{ 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+1E56 (Ṗ)
	{ 0x00, 0x00, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02 },	// U+1E57 (ṗ)
	{ 0x08, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x12, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1E58 (Ṙ)
	{ 0x00, 0x00, 0x08, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+1E59 (ṙ)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x12, 0x22, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1E5A (Ṛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x08, 0x00 },	// U+1E5B (ṛ)
	{ 0x1c, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x12, 0x22, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1E5C (Ṝ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x08, 0x00 },	// U+1E5D (ṝ)
	{ 0x00, 0x00, 0x1e, 0x22, 0x22, 0x1e, 0x12, 0x22, 0x22, 0x22, 0x00, 0x3e, 0x00 },	// U+1E5E (Ṟ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x3e, 0x00 },	// U+1E5F (ṟ)
	{ 0x08, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1E60 (Ṡ)
	{ 0x00, 0x00, 0x08, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+1E61 (ṡ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1E62 (Ṣ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x00, 0x08, 0x00 },	// U+1E63 (ṣ)
	{ 0x20, 0x14, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x00 },	// U+1E64 (Ṥ)
	{ 0x00, 0x20, 0x14, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+1E65 (ṥ)
	{ 0x08, 0x00, 0x14, 0x08, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x22, 0x1c, 0x00 },	// U+1E66 (Ṧ)
	{ 0x08, 0x00, 0x14, 0x08, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x00, 0x00 },	// U+1E67 (ṧ)
	{ 0x08, 0x00, 0x1c, 0x22, 0x02, 0x1c, 0x20, 0x20, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1E68 (Ṩ)
	{ 0x00, 0x00, 0x08, 0x00, 0x3c, 0x02, 0x1c, 0x20, 0x20, 0x1e, 0x00, 0x08, 0x00 },	// U+1E69 (ṩ)
	{ 0x08, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1E6A (Ṫ)
	{ 0x08, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00 },	// U+1E6B (ṫ)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x00 },	// U+1E6C (Ṭ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x38, 0x00, 0x08, 0x00 },	// U+1E6D (ṭ)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x3e, 0x00 },	// U+1E6E (Ṯ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x38, 0x00, 0x3e, 0x00 },	// U+1E6F (ṯ)
	{ 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x14 },	// U+1E70 (Ṱ)
	{ 0x00, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x38, 0x00, 0x08, 0x14 },	// U+1E71 (ṱ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x14, 0x00 },	// U+1E72 (Ṳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x14, 0x00 },	// U+1E73 (ṳ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x2c, 0x1a },	// U+1E74 (Ṵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x2c, 0x1a },	// U+1E75 (ṵ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08, 0x14 },	// U+1E76 (Ṷ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x08, 0x14 },	// U+1E77 (ṷ)
	{ 0x10, 0x08, 0x00, 0x2c, 0x1a, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1E78 (Ṹ)
	{ 0x10, 0x08, 0x00, 0x2c, 0x1a, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00 },	// U+1E79 (ṹ)
	{ 0x14, 0x00, 0x1c, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1E7A (Ṻ)
	{ 0x14, 0x00, 0x1c, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+1E7B (ṻ)
	{ 0x2c, 0x1a, 0x00, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1E7C (Ṽ)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1E7D (ṽ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x08, 0x00 },	// U+1E7E (Ṿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x00, 0x08, 0x00 },	// U+1E7F (ṿ)
	{ 0x04, 0x08, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x1c, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1E80 (Ẁ)
	{ 0x00, 0x04, 0x08, 0x00, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1E81 (ẁ)
	{ 0x10, 0x08, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x1c, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1E82 (Ẃ)
	{ 0x00, 0x10, 0x08, 0x00, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1E83 (ẃ)
	{ 0x14, 0x00, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x1c, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1E84 (Ẅ)
	{ 0x00, 0x00, 0x14, 0x00, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1E85 (ẅ)
	{ 0x08, 0x00, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x1c, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1E86 (Ẇ)
	{ 0x00, 0x00, 0x08, 0x00, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1E87 (ẇ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x1c, 0x14, 0x14, 0x00, 0x08, 0x00 },	// U+1E88 (Ẉ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x08, 0x00 },	// U+1E89 (ẉ)
	{ 0x08, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1E8A (Ẋ)
	{ 0x00, 0x00, 0x08, 0x00, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00 },	// U+1E8B (ẋ)
	{ 0x14, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1E8C (Ẍ)
	{ 0x00, 0x00, 0x14, 0x00, 0x22, 0x14, 0x08, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00 },	// U+1E8D (ẍ)
	{ 0x08, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1E8E (Ẏ)
	{ 0x00, 0x00, 0x08, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+1E8F (ẏ)
	{ 0x08, 0x14, 0x00, 0x3e, 0x20, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1E90 (Ẑ)
	{ 0x00, 0x08, 0x14, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1E91 (ẑ)
	{ 0x00, 0x00, 0x3e, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x3e, 0x00, 0x08, 0x00 },	// U+1E92 (Ẓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x08, 0x00 },	// U+1E93 (ẓ)
	{ 0x00, 0x00, 0x3e, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x3e, 0x00, 0x3e, 0x00 },	// U+1E94 (Ẕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x04, 0x02, 0x3e, 0x00, 0x3e, 0x00 },	// U+1E95 (ẕ)
	{ 0x00, 0x02, 0x02, 0x02, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x3e, 0x00 },	// U+1E96 (ẖ)
	{ 0x14, 0x00, 0x04, 0x04, 0x1e, 0x04, 0x04, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00 },	// U+1E97 (ẗ)
	{ 0x08, 0x14, 0x08, 0x00, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1E98 (ẘ)
	{ 0x08, 0x14, 0x08, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+1E99 (ẙ)
	{ 0x10, 0x20, 0x20, 0x10, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+1E9A (ẚ)
	{ 0x08, 0x00, 0x30, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1E9B (ẛ)
	{ 0x00, 0x00, 0x30, 0x08, 0x0c, 0x28, 0x18, 0x0c, 0x0a, 0x08, 0x00, 0x00, 0x00 },	// U+1E9C (ẜ)
	{ 0x00, 0x00, 0x30, 0x08, 0x3e, 0x08, 0x0c, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1E9D (ẝ)
	{ 0x00, 0x00, 0x3c, 0x22, 0x22, 0x1a, 0x22, 0x22, 0x22, 0x1a, 0x02, 0x00, 0x00 },	// U+1E9E (ẞ)
	{ 0x00, 0x00, 0x00, 0x3c, 0x02, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1E9F (ẟ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1EA0 (Ạ)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x08, 0x00 },	// U+1EA1 (ạ)
	{ 0x1c, 0x10, 0x08, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1EA2 (Ả)
	{ 0x1c, 0x10, 0x08, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+1EA3 (ả)
	{ 0x22, 0x15, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1EA4 (Ấ)
	{ 0x20, 0x12, 0x05, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+1EA5 (ấ)
	{ 0x11, 0x2a, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1EA6 (Ầ)
	{ 0x10, 0x24, 0x0a, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+1EA7 (ầ)
	{ 0x1c, 0x10, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00 },	// U+1EA8 (Ẩ)
	{ 0x00, 0x1c, 0x10, 0x08, 0x14, 0x00, 0x3c, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+1EA9 (ẩ)
	{ 0x2c, 0x1a, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00 },	// U+1EAA (Ẫ)
	{ 0x08, 0x14, 0x00, 0x2c, 0x1a, 0x00, 0x3c, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+1EAB (ẫ)
	{ 0x08, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1EAC (Ậ)
	{ 0x00, 0x08, 0x14, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x08, 0x00 },	// U+1EAD (ậ)
	{ 0x10, 0x08, 0x00, 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x00 },	// U+1EAE (Ắ)
	{ 0x10, 0x08, 0x00, 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+1EAF (ắ)
	{ 0x04, 0x08, 0x00, 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x00 },	// U+1EB0 (Ằ)
	{ 0x04, 0x08, 0x00, 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+1EB1 (ằ)
	{ 0x38, 0x20, 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x00, 0x00 },	// U+1EB2 (Ẳ)
	{ 0x38, 0x20, 0x14, 0x1c, 0x00, 0x3c, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00, 0x00 },	// U+1EB3 (ẳ)
	{ 0x14, 0x1c, 0x00, 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x00 },	// U+1EB4 (Ẵ)
	{ 0x14, 0x1c, 0x00, 0x2c, 0x1a, 0x00, 0x3c, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x00 },	// U+1EB5 (ẵ)
	{ 0x14, 0x1c, 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x08, 0x00 },	// U+1EB6 (Ặ)
	{ 0x00, 0x14, 0x1c, 0x00, 0x3c, 0x22, 0x22, 0x22, 0x32, 0x2c, 0x00, 0x08, 0x00 },	// U+1EB7 (ặ)
	{ 0x00, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x08, 0x00 },	// U+1EB8 (Ẹ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1EB9 (ẹ)
	{ 0x1c, 0x10, 0x08, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1EBA (Ẻ)
	{ 0x1c, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EBB (ẻ)
	{ 0x2c, 0x1a, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1EBC (Ẽ)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EBD (ẽ)
	{ 0x22, 0x15, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1EBE (Ế)
	{ 0x00, 0x22, 0x15, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EBF (ế)
	{ 0x11, 0x2a, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1EC0 (Ề)
	{ 0x00, 0x11, 0x2a, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EC1 (ề)
	{ 0x1c, 0x10, 0x08, 0x14, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00 },	// U+1EC2 (Ể)
	{ 0x1c, 0x10, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00 },	// U+1EC3 (ể)
	{ 0x2c, 0x1a, 0x08, 0x14, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00 },	// U+1EC4 (Ễ)
	{ 0x2c, 0x1a, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x00 },	// U+1EC5 (ễ)
	{ 0x08, 0x14, 0x00, 0x3e, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x3e, 0x00, 0x08, 0x00 },	// U+1EC6 (Ệ)
	{ 0x00, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x3e, 0x02, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1EC7 (ệ)
	{ 0x1c, 0x10, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1EC8 (Ỉ)
	{ 0x1c, 0x10, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00 },	// U+1EC9 (ỉ)
	{ 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x08, 0x00 },	// U+1ECA (Ị)
	{ 0x00, 0x00, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x08, 0x00 },	// U+1ECB (ị)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1ECC (Ọ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1ECD (ọ)
	{ 0x1c, 0x10, 0x08, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1ECE (Ỏ)
	{ 0x1c, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1ECF (ỏ)
	{ 0x22, 0x15, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1ED0 (Ố)
	{ 0x00, 0x22, 0x15, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1ED1 (ố)
	{ 0x01, 0x12, 0x28, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1ED2 (Ồ)
	{ 0x10, 0x24, 0x0a, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1ED3 (ồ)
	{ 0x1c, 0x10, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1ED4 (Ổ)
	{ 0x1c, 0x10, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1ED5 (ổ)
	{ 0x08, 0x14, 0x00, 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1ED6 (Ỗ)
	{ 0x08, 0x14, 0x00, 0x2c, 0x1a, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00 },	// U+1ED7 (ỗ)
	{ 0x08, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1ED8 (Ộ)
	{ 0x00, 0x08, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1ED9 (ộ)
	{ 0x10, 0x48, 0x40, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EDA (Ớ)
	{ 0x00, 0x10, 0x48, 0x40, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EDB (ớ)
	{ 0x04, 0x48, 0x40, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EDC (Ờ)
	{ 0x00, 0x04, 0x48, 0x40, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EDD (ờ)
	{ 0x00, 0x5c, 0x50, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EDE (Ở)
	{ 0x00, 0x1c, 0x50, 0x48, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EDF (ở)
	{ 0x2c, 0x5a, 0x40, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EE0 (Ỡ)
	{ 0x00, 0x2c, 0x5a, 0x40, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EE1 (ỡ)
	{ 0x40, 0x40, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1EE2 (Ợ)
	{ 0x00, 0x00, 0x40, 0x40, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1EE3 (ợ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1EE4 (Ụ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x08, 0x00 },	// U+1EE5 (ụ)
	{ 0x1c, 0x10, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EE6 (Ủ)
	{ 0x00, 0x1c, 0x10, 0x08, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+1EE7 (ủ)
	{ 0x50, 0x48, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EE8 (Ứ)
	{ 0x00, 0x00, 0x50, 0x48, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+1EE9 (ứ)
	{ 0x44, 0x48, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EEA (Ừ)
	{ 0x00, 0x00, 0x44, 0x48, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+1EEB (ừ)
	{ 0x5c, 0x50, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EEC (Ử)
	{ 0x00, 0x00, 0x5c, 0x50, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+1EED (ử)
	{ 0x2c, 0x5a, 0x40, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1EEE (Ữ)
	{ 0x00, 0x2c, 0x5a, 0x40, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00 },	// U+1EEF (ữ)
	{ 0x40, 0x40, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x08, 0x00 },	// U+1EF0 (Ự)
	{ 0x00, 0x00, 0x40, 0x40, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x08, 0x00 },	// U+1EF1 (ự)
	{ 0x04, 0x08, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1EF2 (Ỳ)
	{ 0x00, 0x00, 0x04, 0x08, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+1EF3 (ỳ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x00 },	// U+1EF4 (Ỵ)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x28, 0x20, 0x1c },	// U+1EF5 (ỵ)
	{ 0x1c, 0x10, 0x2a, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1EF6 (Ỷ)
	{ 0x00, 0x1c, 0x10, 0x08, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+1EF7 (ỷ)
	{ 0x2c, 0x1a, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1EF8 (Ỹ)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x1c },	// U+1EF9 (ỹ)
}; // 250

static const unsigned char cozette_block45[][13] = {
	{ 0x18, 0x10, 0x08, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1F00 (ἀ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1F01 (ἁ)
	{ 0x06, 0x14, 0x22, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1F02 (ἂ)
	{ 0x06, 0x12, 0x24, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1F03 (ἃ)
	{ 0x06, 0x24, 0x12, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1F04 (ἄ)
	{ 0x06, 0x22, 0x14, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1F05 (ἅ)
}; // 6

static const unsigned char cozette_block46[][13] = {
	{ 0x03, 0x02, 0x09, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F08 (Ἀ)
	{ 0x03, 0x01, 0x0a, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F09 (Ἁ)
	{ 0x13, 0x22, 0x09, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F0A (Ἂ)
	{ 0x13, 0x21, 0x0a, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F0B (Ἃ)
	{ 0x23, 0x12, 0x09, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F0C (Ἄ)
	{ 0x23, 0x11, 0x0a, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F0D (Ἅ)
}; // 6

static const unsigned char cozette_block47[][13] = {
	{ 0x18, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F10 (ἐ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F11 (ἑ)
	{ 0x06, 0x14, 0x22, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F12 (ἒ)
	{ 0x06, 0x12, 0x24, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F13 (ἓ)
	{ 0x06, 0x24, 0x12, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F14 (ἔ)
	{ 0x06, 0x22, 0x14, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F15 (ἕ)
}; // 6

static const unsigned char cozette_block48[][13] = {
	{ 0x03, 0x02, 0x3d, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1F18 (Ἐ)
	{ 0x03, 0x01, 0x3a, 0x00, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1F19 (Ἑ)
	{ 0x0b, 0x12, 0x01, 0x3e, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1F1A (Ἒ)
	{ 0x0b, 0x11, 0x02, 0x3c, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1F1B (Ἓ)
	{ 0x13, 0x0a, 0x01, 0x3e, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1F1C (Ἔ)
	{ 0x13, 0x0a, 0x01, 0x3e, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1F1D (Ἕ)
}; // 6

static const unsigned char cozette_block49[][13] = {
	{ 0x0c, 0x08, 0x04, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+1F20 (ἠ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+1F21 (ἡ)
	{ 0x06, 0x14, 0x22, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+1F22 (ἢ)
	{ 0x06, 0x12, 0x24, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+1F23 (ἣ)
	{ 0x06, 0x24, 0x12, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+1F24 (ἤ)
	{ 0x06, 0x22, 0x14, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+1F25 (ἥ)
}; // 6

static const unsigned char cozette_block50[][13] = {
	{ 0x18, 0x10, 0x2a, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F28 (Ἠ)
	{ 0x0c, 0x04, 0x2a, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F29 (Ἡ)
	{ 0x06, 0x14, 0x22, 0x00, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F2A (Ἢ)
	{ 0x06, 0x12, 0x24, 0x00, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F2B (Ἣ)
	{ 0x06, 0x24, 0x12, 0x00, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F2C (Ἤ)
	{ 0x06, 0x22, 0x14, 0x00, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1F2D (Ἥ)
}; // 6

static const unsigned char cozette_block51[][13] = {
	{ 0x0c, 0x08, 0x04, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1F30 (ἰ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1F31 (ἱ)
	{ 0x06, 0x14, 0x22, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1F32 (ἲ)
	{ 0x06, 0x12, 0x24, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1F33 (ἳ)
	{ 0x06, 0x24, 0x12, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1F34 (ἴ)
	{ 0x06, 0x24, 0x12, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1F35 (ἵ)
}; // 6

static const unsigned char cozette_block52[][13] = {
	{ 0x18, 0x10, 0x08, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F38 (Ἰ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F39 (Ἱ)
	{ 0x06, 0x14, 0x22, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F3A (Ἲ)
	{ 0x06, 0x12, 0x24, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F3B (Ἳ)
	{ 0x06, 0x24, 0x12, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F3C (Ἴ)
	{ 0x06, 0x22, 0x14, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1F3D (Ἵ)
}; // 6

static const unsigned char cozette_block53[][13] = {
	{ 0x18, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F40 (ὀ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F41 (ὁ)
	{ 0x06, 0x14, 0x22, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F42 (ὂ)
	{ 0x06, 0x12, 0x24, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F43 (ὃ)
	{ 0x06, 0x24, 0x12, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F44 (ὄ)
	{ 0x06, 0x22, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F45 (ὅ)
}; // 6

static const unsigned char cozette_block54[][13] = {
	{ 0x18, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1F48 (Ὀ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1F49 (Ὁ)
	{ 0x06, 0x14, 0x22, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1F4A (Ὂ)
	{ 0x06, 0x12, 0x24, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1F4B (Ὃ)
	{ 0x06, 0x24, 0x12, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1F4C (Ὄ)
	{ 0x06, 0x22, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+1F4D (Ὅ)
}; // 6

static const unsigned char cozette_block55[][13] = {
	{ 0x0c, 0x08, 0x04, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1F50 (ὐ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1F51 (ὑ)
	{ 0x06, 0x14, 0x22, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1F52 (ὒ)
	{ 0x06, 0x12, 0x24, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1F53 (ὓ)
	{ 0x06, 0x24, 0x12, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1F54 (ὔ)
	{ 0x06, 0x22, 0x14, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1F55 (ὕ)
}; // 6

static const unsigned char cozette_block56[][13] = {
	{ 0x0c, 0x04, 0x2a, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1F59 (Ὑ)
}; // 1

static const unsigned char cozette_block57[][13] = {
	{ 0x06, 0x12, 0x24, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1F5B (Ὓ)
}; // 1

static const unsigned char cozette_block58[][13] = {
	{ 0x06, 0x22, 0x14, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1F5D (Ὕ)
}; // 1

static const unsigned char cozette_block59[][13] = {
	{ 0x18, 0x10, 0x08, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+1F60 (ὠ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+1F61 (ὡ)
	{ 0x06, 0x14, 0x22, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+1F62 (ὢ)
	{ 0x06, 0x12, 0x24, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+1F63 (ὣ)
	{ 0x06, 0x24, 0x12, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+1F64 (ὤ)
	{ 0x06, 0x22, 0x14, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+1F65 (ὥ)
}; // 6

static const unsigned char cozette_block60[][13] = {
	{ 0x18, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+1F68 (Ὠ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+1F69 (Ὡ)
	{ 0x06, 0x24, 0x12, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+1F6A (Ὢ)
	{ 0x06, 0x22, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+1F6B (Ὣ)
	{ 0x06, 0x24, 0x12, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+1F6C (Ὤ)
	{ 0x06, 0x12, 0x24, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+1F6D (Ὥ)
}; // 6

static const unsigned char cozette_block61[][13] = {
	{ 0x00, 0x04, 0x08, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1F70 (ὰ)
	{ 0x00, 0x10, 0x08, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1F71 (ά)
	{ 0x00, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F72 (ὲ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x0c, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F73 (έ)
	{ 0x00, 0x04, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+1F74 (ὴ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+1F75 (ή)
	{ 0x00, 0x04, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1F76 (ὶ)
	{ 0x00, 0x10, 0x08, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1F77 (ί)
	{ 0x00, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F78 (ὸ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1F79 (ό)
	{ 0x00, 0x04, 0x08, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1F7A (ὺ)
	{ 0x00, 0x10, 0x08, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1F7B (ύ)
	{ 0x00, 0x04, 0x08, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+1F7C (ὼ)
	{ 0x00, 0x10, 0x08, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+1F7D (ώ)
}; // 14

static const unsigned char cozette_block62[][13] = {
	{ 0x18, 0x10, 0x08, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1F80 (ᾀ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1F81 (ᾁ)
	{ 0x06, 0x14, 0x22, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1F82 (ᾂ)
	{ 0x06, 0x12, 0x24, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1F83 (ᾃ)
	{ 0x06, 0x24, 0x12, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1F84 (ᾄ)
	{ 0x06, 0x22, 0x14, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1F85 (ᾅ)
}; // 6

static const unsigned char cozette_block63[][13] = {
	{ 0x03, 0x02, 0x09, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F88 (ᾈ)
	{ 0x03, 0x01, 0x0a, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F89 (ᾉ)
	{ 0x13, 0x22, 0x09, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F8A (ᾊ)
	{ 0x13, 0x21, 0x0a, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F8B (ᾋ)
	{ 0x23, 0x12, 0x09, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F8C (ᾌ)
	{ 0x23, 0x11, 0x0a, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F8D (ᾍ)
}; // 6

static const unsigned char cozette_block64[][13] = {
	{ 0x0c, 0x08, 0x04, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x06 },	// U+1F90 (ᾐ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x06 },	// U+1F91 (ᾑ)
	{ 0x06, 0x14, 0x22, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x06 },	// U+1F92 (ᾒ)
	{ 0x06, 0x12, 0x24, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x06 },	// U+1F93 (ᾓ)
	{ 0x06, 0x24, 0x12, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x06 },	// U+1F94 (ᾔ)
	{ 0x06, 0x22, 0x14, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x06 },	// U+1F95 (ᾕ)
}; // 6

static const unsigned char cozette_block65[][13] = {
	{ 0x18, 0x10, 0x2a, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F98 (ᾘ)
	{ 0x0c, 0x04, 0x2a, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F99 (ᾙ)
	{ 0x06, 0x14, 0x22, 0x00, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F9A (ᾚ)
	{ 0x06, 0x12, 0x24, 0x00, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F9B (ᾛ)
	{ 0x06, 0x24, 0x12, 0x00, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F9C (ᾜ)
	{ 0x06, 0x22, 0x14, 0x00, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1F9D (ᾝ)
}; // 6

static const unsigned char cozette_block66[][13] = {
	{ 0x18, 0x10, 0x08, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x08, 0x08, 0x18 },	// U+1FA0 (ᾠ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x08, 0x08, 0x18 },	// U+1FA1 (ᾡ)
	{ 0x06, 0x14, 0x22, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x08, 0x08, 0x18 },	// U+1FA2 (ᾢ)
	{ 0x06, 0x12, 0x24, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x08, 0x08, 0x18 },	// U+1FA3 (ᾣ)
	{ 0x06, 0x24, 0x12, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x08, 0x08, 0x18 },	// U+1FA4 (ᾤ)
	{ 0x06, 0x22, 0x14, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x08, 0x08, 0x18 },	// U+1FA5 (ᾥ)
}; // 6

static const unsigned char cozette_block67[][13] = {
	{ 0x18, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x08, 0x08, 0x18 },	// U+1FA8 (ᾨ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x08, 0x08, 0x18 },	// U+1FA9 (ᾩ)
	{ 0x06, 0x14, 0x22, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x08, 0x08, 0x18 },	// U+1FAA (ᾪ)
	{ 0x06, 0x12, 0x24, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x08, 0x08, 0x18 },	// U+1FAB (ᾫ)
	{ 0x06, 0x24, 0x12, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x08, 0x08, 0x18 },	// U+1FAC (ᾬ)
	{ 0x06, 0x22, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x08, 0x08, 0x18 },	// U+1FAD (ᾭ)
}; // 6

static const unsigned char cozette_block68[][13] = {
	{ 0x00, 0x12, 0x0c, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1FB0 (ᾰ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1FB1 (ᾱ)
	{ 0x00, 0x04, 0x08, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1FB2 (ᾲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1FB3 (ᾳ)
	{ 0x00, 0x10, 0x08, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1FB4 (ᾴ)
}; // 5

static const unsigned char cozette_block69[][13] = {
	{ 0x00, 0x2c, 0x1a, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00 },	// U+1FB6 (ᾶ)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1FB7 (ᾷ)
	{ 0x00, 0x04, 0x08, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x08, 0x08, 0x18 },	// U+1FB8 (Ᾰ)
	{ 0x1c, 0x00, 0x08, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1FB9 (Ᾱ)
	{ 0x00, 0x01, 0x0a, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1FBA (Ὰ)
	{ 0x00, 0x02, 0x09, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1FBB (Ά)
	{ 0x00, 0x00, 0x08, 0x08, 0x14, 0x14, 0x1c, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1FBC (ᾼ)
}; // 7

static const unsigned char cozette_block70[][13] = {
	{ 0x00, 0x04, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x06 },	// U+1FC2 (ῂ)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x06 },	// U+1FC3 (ῃ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x06 },	// U+1FC4 (ῄ)
}; // 3

static const unsigned char cozette_block71[][13] = {
	{ 0x00, 0x2c, 0x1a, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x00 },	// U+1FC6 (ῆ)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x06 },	// U+1FC7 (ῇ)
	{ 0x01, 0x02, 0x38, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1FC8 (Ὲ)
	{ 0x02, 0x01, 0x3c, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00 },	// U+1FC9 (Έ)
	{ 0x04, 0x08, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1FCA (Ὴ)
	{ 0x10, 0x08, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+1FCB (Ή)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x08, 0x08, 0x18 },	// U+1FCC (ῌ)
}; // 7

static const unsigned char cozette_block72[][13] = {
	{ 0x00, 0x24, 0x18, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1FD0 (ῐ)
	{ 0x00, 0x00, 0x3c, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1FD1 (ῑ)
	{ 0x04, 0x08, 0x00, 0x14, 0x00, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1FD2 (ῒ)
	{ 0x10, 0x08, 0x00, 0x14, 0x00, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1FD3 (ΐ)
}; // 4

static const unsigned char cozette_block73[][13] = {
	{ 0x00, 0x2c, 0x1a, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1FD6 (ῖ)
	{ 0x2c, 0x1a, 0x00, 0x14, 0x00, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00 },	// U+1FD7 (ῗ)
	{ 0x00, 0x22, 0x1c, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1FD8 (Ῐ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1FD9 (Ῑ)
	{ 0x00, 0x04, 0x08, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1FDA (Ὶ)
	{ 0x00, 0x10, 0x08, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+1FDB (Ί)
}; // 6

static const unsigned char cozette_block74[][13] = {
	{ 0x00, 0x12, 0x0c, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1FE0 (ῠ)
	{ 0x00, 0x00, 0x1c, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1FE1 (ῡ)
	{ 0x04, 0x08, 0x00, 0x14, 0x00, 0x12, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1FE2 (ῢ)
	{ 0x10, 0x08, 0x00, 0x14, 0x00, 0x12, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1FE3 (ΰ)
	{ 0x18, 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x26, 0x1a, 0x02, 0x02, 0x02 },	// U+1FE4 (ῤ)
	{ 0x0c, 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x26, 0x1a, 0x02, 0x02, 0x02 },	// U+1FE5 (ῥ)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x12, 0x22, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+1FE6 (ῦ)
}; // 7

static const unsigned char cozette_block75[][13] = {
	{ 0x22, 0x1c, 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1FE8 (Ῠ)
	{ 0x1c, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1FE9 (Ῡ)
	{ 0x04, 0x08, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1FEA (Ὺ)
	{ 0x10, 0x08, 0x22, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1FEB (Ύ)
	{ 0x03, 0x01, 0x1a, 0x20, 0x22, 0x22, 0x1e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+1FEC (Ῥ)
}; // 5

static const unsigned char cozette_block76[][13] = {
	{ 0x00, 0x04, 0x08, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x08, 0x08, 0x18 },	// U+1FF2 (ῲ)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x08, 0x08, 0x18 },	// U+1FF3 (ῳ)
	{ 0x00, 0x10, 0x08, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x08, 0x08, 0x18 },	// U+1FF4 (ῴ)
}; // 3

static const unsigned char cozette_block77[][13] = {
	{ 0x00, 0x2c, 0x1a, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+1FF6 (ῶ)
	{ 0x00, 0x2c, 0x1a, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x08, 0x08, 0x18 },	// U+1FF7 (ῷ)
	{ 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1FF8 (Ὸ)
	{ 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+1FF9 (Ό)
	{ 0x04, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+1FFA (Ὼ)
	{ 0x10, 0x08, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+1FFB (Ώ)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x14, 0x36, 0x08, 0x08, 0x18 },	// U+1FFC (ῼ)
}; // 7

static const unsigned char cozette_block78[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2000 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2001 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2002 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2003 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2004 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2005 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2006 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2007 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2008 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2009 ( )
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+200A ( )
}; // 11

static const unsigned char cozette_block79[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2010 (‐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2011 (‑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2012 (‒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2013 (–)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2014 (—)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2015 (―)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2016 (‖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x7f, 0x00 },	// U+2017 (‗)
	{ 0x00, 0x10, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2018 (‘)
	{ 0x00, 0x0c, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2019 (’)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x04, 0x00 },	// U+201A (‚)
	{ 0x00, 0x0c, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201B (‛)
	{ 0x00, 0x24, 0x12, 0x12, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201C (“)
	{ 0x00, 0x36, 0x24, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201D (”)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x24, 0x24, 0x12, 0x00 },	// U+201E („)
	{ 0x00, 0x36, 0x12, 0x12, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+201F (‟)
	{ 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2020 (†)
	{ 0x00, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00 },	// U+2021 (‡)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2022 (•)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2023 (‣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+2024 (․)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00 },	// U+2025 (‥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00 },	// U+2026 (…)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2027 (‧)
}; // 24

static const unsigned char cozette_block80[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+202F ( )
	{ 0x00, 0x04, 0x0a, 0x24, 0x10, 0x08, 0x04, 0x2a, 0x54, 0x28, 0x00, 0x00, 0x00 },	// U+2030 (‰)
}; // 2

static const unsigned char cozette_block81[][13] = {
	{ 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2032 (′)
	{ 0x00, 0x28, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2033 (″)
	{ 0x00, 0x2a, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2034 (‴)
	{ 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2035 (‵)
	{ 0x00, 0x14, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2036 (‶)
	{ 0x00, 0x15, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2037 (‷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x00 },	// U+2038 (‸)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2039 (‹)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+203A (›)
	{ 0x00, 0x00, 0x00, 0x08, 0x22, 0x14, 0x49, 0x14, 0x22, 0x08, 0x00, 0x00, 0x00 },	// U+203B (※)
	{ 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x24, 0x00, 0x00, 0x00 },	// U+203C (‼)
	{ 0x00, 0x00, 0x1c, 0x2a, 0x28, 0x18, 0x08, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+203D (‽)
	{ 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+203E (‾)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x1c, 0x00 },	// U+203F (‿)
}; // 14

static const unsigned char cozette_block82[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2043 (⁃)
	{ 0x00, 0x00, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00 },	// U+2044 (⁄)
	{ 0x00, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00 },	// U+2045 (⁅)
	{ 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x18, 0x10, 0x10, 0x10, 0x10, 0x18, 0x00 },	// U+2046 (⁆)
}; // 4

static const unsigned char cozette_block83[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2056 (⁖)
}; // 1

static const unsigned char cozette_block84[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x22, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2058 (⁘)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x08, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+2059 (⁙)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+205A (⁚)
	{ 0x00, 0x00, 0x08, 0x00, 0x00, 0x22, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+205B (⁛)
	{ 0x00, 0x00, 0x2a, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x2a, 0x00, 0x00, 0x00, 0x00 },	// U+205C (⁜)
	{ 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+205D (⁝)
	{ 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+205E (⁞)
}; // 7

static const unsigned char cozette_block85[][13] = {
	{ 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2070 (⁰)
	{ 0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2071 (ⁱ)
}; // 2

static const unsigned char cozette_block86[][13] = {
	{ 0x00, 0x08, 0x0c, 0x0a, 0x1e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2074 (⁴)
	{ 0x00, 0x1e, 0x02, 0x0e, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2075 (⁵)
	{ 0x00, 0x0c, 0x02, 0x0e, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2076 (⁶)
	{ 0x00, 0x1e, 0x12, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2077 (⁷)
	{ 0x00, 0x0c, 0x12, 0x0c, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2078 (⁸)
	{ 0x00, 0x0c, 0x12, 0x1c, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2079 (⁹)
	{ 0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207A (⁺)
	{ 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207B (⁻)
	{ 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207C (⁼)
	{ 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207D (⁽)
	{ 0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207E (⁾)
	{ 0x00, 0x0a, 0x16, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+207F (ⁿ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00 },	// U+2080 (₀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x04, 0x04, 0x0e, 0x00 },	// U+2081 (₁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x08, 0x04, 0x1e, 0x00 },	// U+2082 (₂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x0c, 0x10, 0x0e, 0x00 },	// U+2083 (₃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x1e, 0x08, 0x00 },	// U+2084 (₄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x0e, 0x10, 0x0e, 0x00 },	// U+2085 (₅)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x0e, 0x12, 0x0c, 0x00 },	// U+2086 (₆)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x08, 0x04, 0x04, 0x00 },	// U+2087 (₇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0c, 0x12, 0x0c, 0x00 },	// U+2088 (₈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1c, 0x10, 0x0c, 0x00 },	// U+2089 (₉)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+208A (₊)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00 },	// U+208B (₋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x00 },	// U+208C (₌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08 },	// U+208D (₍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04 },	// U+208E (₎)
}; // 27

static const unsigned char cozette_block87[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x1a, 0x14, 0x00 },	// U+2090 (ₐ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1e, 0x02, 0x1c, 0x00 },	// U+2091 (ₑ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00 },	// U+2092 (ₒ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x0c, 0x12, 0x12, 0x00 },	// U+2093 (ₓ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x1e, 0x12, 0x0c, 0x00 },	// U+2094 (ₔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x00 },	// U+2095 (ₕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x12, 0x12, 0x0e, 0x12, 0x12, 0x00 },	// U+2096 (ₖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0c, 0x00 },	// U+2097 (ₗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x2a, 0x2a, 0x2a, 0x2a, 0x00 },	// U+2098 (ₘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x16, 0x12, 0x12, 0x12, 0x00 },	// U+2099 (ₙ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x12, 0x12, 0x0e, 0x02, 0x02 },	// U+209A (ₚ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x0c, 0x10, 0x0e, 0x00 },	// U+209B (ₛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x02, 0x02, 0x0c, 0x00 },	// U+209C (ₜ)
}; // 13

static const unsigned char cozette_block88[][13] = {
	{ 0x00, 0x00, 0x18, 0x24, 0x0e, 0x04, 0x0e, 0x04, 0x04, 0x3e, 0x00, 0x00, 0x00 },	// U+20A4 (₤)
}; // 1

static const unsigned char cozette_block89[][13] = {
	{ 0x00, 0x00, 0x00, 0x2f, 0x29, 0x29, 0x25, 0x25, 0x3d, 0x00, 0x00, 0x00, 0x00 },	// U+20AA (₪)
}; // 1

static const unsigned char cozette_block90[][13] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x24, 0x0e, 0x04, 0x0e, 0x24, 0x18, 0x00, 0x00, 0x00 },	// U+20AC (€)
}; // 1

static const unsigned char cozette_block91[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x24, 0x24, 0x1e, 0x04, 0x1e, 0x04, 0x00, 0x00, 0x00 },	// U+20BD (₽)
}; // 1

static const unsigned char cozette_block92[][13] = {
	{ 0x00, 0x14, 0x1e, 0x22, 0x22, 0x1e, 0x22, 0x22, 0x22, 0x1e, 0x14, 0x14, 0x00 },	// U+20BF (₿)
}; // 1

static const unsigned char cozette_block93[][13] = {
	{ 0x00, 0x00, 0x39, 0x29, 0x3b, 0x03, 0x3d, 0x0d, 0x09, 0x09, 0x00, 0x00, 0x00 },	// U+2116 (№)
}; // 1

static const unsigned char cozette_block94[][13] = {
	{ 0x00, 0x00, 0x7f, 0x7a, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2122 (™)
}; // 1

static const unsigned char cozette_block95[][13] = {
	{ 0x00, 0x00, 0x18, 0x24, 0x04, 0x1c, 0x02, 0x02, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+2130 (ℰ)
}; // 1

static const unsigned char cozette_block96[][13] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2160 (Ⅰ)
	{ 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+2161 (Ⅱ)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+2162 (Ⅲ)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+2163 (Ⅳ)
	{ 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2164 (Ⅴ)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+2165 (Ⅵ)
}; // 6

static const unsigned char cozette_block97[][13] = {
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x12, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+2168 (Ⅸ)
	{ 0x00, 0x00, 0x22, 0x22, 0x14, 0x08, 0x14, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+2169 (Ⅹ)
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2a, 0x24, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+216A (Ⅺ)
}; // 3

static const unsigned char cozette_block98[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2170 (ⅰ)
	{ 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+2171 (ⅱ)
	{ 0x00, 0x00, 0x00, 0x2a, 0x00, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+2172 (ⅲ)
	{ 0x00, 0x00, 0x00, 0x02, 0x00, 0x2a, 0x2a, 0x2a, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+2173 (ⅳ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2174 (ⅴ)
	{ 0x00, 0x00, 0x00, 0x20, 0x00, 0x2a, 0x2a, 0x2a, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+2175 (ⅵ)
	{ 0x00, 0x00, 0x00, 0x50, 0x00, 0x55, 0x55, 0x55, 0x52, 0x52, 0x00, 0x00, 0x00 },	// U+2176 (ⅶ)
	{ 0x00, 0x00, 0x00, 0x70, 0x00, 0x75, 0x75, 0x75, 0x72, 0x72, 0x00, 0x00, 0x00 },	// U+2177 (ⅷ)
	{ 0x00, 0x00, 0x00, 0x02, 0x00, 0x2a, 0x2a, 0x12, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+2178 (ⅸ)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x08, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+2179 (ⅹ)
	{ 0x00, 0x00, 0x00, 0x20, 0x00, 0x2a, 0x2a, 0x24, 0x2a, 0x2a, 0x00, 0x00, 0x00 },	// U+217A (ⅺ)
	{ 0x00, 0x00, 0x00, 0x50, 0x00, 0x55, 0x55, 0x52, 0x55, 0x55, 0x00, 0x00, 0x00 },	// U+217B (ⅻ)
}; // 12

static const unsigned char cozette_block99[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x3e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2190 (←)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2191 (↑)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3e, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2192 (→)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+2193 (↓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x3e, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2194 (↔)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2195 (↕)
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x06, 0x0a, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+2196 (↖)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x30, 0x28, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2197 (↗)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x28, 0x30, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+2198 (↘)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x0a, 0x06, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2199 (↙)
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x26, 0x7f, 0x16, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+219A (↚)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x34, 0x7f, 0x32, 0x12, 0x00, 0x00, 0x00, 0x00 },	// U+219B (↛)
}; // 12

static const unsigned char cozette_block100[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x24, 0x1e, 0x24, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21A2 (↢)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x12, 0x3c, 0x12, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21A3 (↣)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x24, 0x3e, 0x24, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21A4 (↤)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+21A5 (↥)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x12, 0x3e, 0x12, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21A6 (↦)
	{ 0x00, 0x00, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+21A7 (↧)
}; // 6

static const unsigned char cozette_block101[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x22, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21A9 (↩)
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x11, 0x3e, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21AA (↪)
	{ 0x00, 0x00, 0x00, 0x00, 0x34, 0x2a, 0x1f, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21AB (↫)
	{ 0x00, 0x00, 0x00, 0x00, 0x0b, 0x15, 0x3e, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21AC (↬)
}; // 4

static const unsigned char cozette_block102[][13] = {
	{ 0x04, 0x04, 0x32, 0x2a, 0x15, 0x13, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+21AF (↯)
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x3e, 0x24, 0x28, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+21B0 (↰)
	{ 0x00, 0x00, 0x00, 0x08, 0x10, 0x3e, 0x12, 0x0a, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+21B1 (↱)
	{ 0x00, 0x00, 0x00, 0x20, 0x28, 0x24, 0x3e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21B2 (↲)
	{ 0x00, 0x00, 0x00, 0x02, 0x0a, 0x12, 0x3e, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21B3 (↳)
	{ 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21B4 (↴)
	{ 0x00, 0x00, 0x00, 0x20, 0x28, 0x24, 0x3e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21B5 (↵)
	{ 0x00, 0x00, 0x18, 0x24, 0x24, 0x04, 0x15, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+21B6 (↶)
	{ 0x00, 0x00, 0x06, 0x09, 0x09, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21B7 (↷)
	{ 0x00, 0x00, 0x3e, 0x00, 0x1e, 0x06, 0x0a, 0x12, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+21B8 (↸)
	{ 0x00, 0x00, 0x00, 0x00, 0x25, 0x3f, 0x25, 0x29, 0x3f, 0x29, 0x00, 0x00, 0x00 },	// U+21B9 (↹)
	{ 0x00, 0x00, 0x00, 0x38, 0x18, 0x2a, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+21BA (↺)
	{ 0x00, 0x00, 0x00, 0x0e, 0x0c, 0x2a, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+21BB (↻)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21BC (↼)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21BD (↽)
	{ 0x00, 0x00, 0x00, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21BE (↾)
	{ 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21BF (↿)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+21C0 (⇀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21C1 (⇁)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x28, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21C2 (⇂)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0a, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21C3 (⇃)
}; // 21

static const unsigned char cozette_block103[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x04, 0x3e, 0x00, 0x3e, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+21CB (⇋)
	{ 0x00, 0x00, 0x00, 0x08, 0x10, 0x3e, 0x00, 0x3e, 0x04, 0x08, 0x00, 0x00, 0x00 },	// U+21CC (⇌)
}; // 2

static const unsigned char cozette_block104[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x3c, 0x06, 0x3c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21D0 (⇐)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+21D1 (⇑)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1e, 0x30, 0x1e, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21D2 (⇒)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x36, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+21D3 (⇓)
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x3e, 0x63, 0x3e, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+21D4 (⇔)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 0x14, 0x36, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+21D5 (⇕)
}; // 6

static const unsigned char cozette_block105[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x2a, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21E0 (⇠)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x2a, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00 },	// U+21E1 (⇡)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x2a, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+21E2 (⇢)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x2a, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+21E3 (⇣)
}; // 4

static const unsigned char cozette_block106[][13] = {
	{ 0x00, 0x00, 0x7f, 0x01, 0x3d, 0x0d, 0x15, 0x25, 0x01, 0x00, 0x00, 0x00, 0x00 },	// U+21F1 (⇱)
	{ 0x00, 0x00, 0x40, 0x52, 0x54, 0x58, 0x5e, 0x40, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+21F2 (⇲)
}; // 2

static const unsigned char cozette_block107[][13] = {
	{ 0x00, 0x00, 0x00, 0x22, 0x22, 0x1c, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2200 (∀)
	{ 0x00, 0x00, 0x0c, 0x12, 0x02, 0x02, 0x02, 0x02, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+2201 (∁)
	{ 0x00, 0x0c, 0x10, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+2202 (∂)
	{ 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x3e, 0x00, 0x00, 0x00 },	// U+2203 (∃)
	{ 0x00, 0x00, 0x20, 0x3e, 0x30, 0x28, 0x3c, 0x28, 0x24, 0x3e, 0x02, 0x00, 0x00 },	// U+2204 (∄)
	{ 0x00, 0x00, 0x00, 0x20, 0x1c, 0x32, 0x2a, 0x26, 0x1c, 0x02, 0x00, 0x00, 0x00 },	// U+2205 (∅)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2206 (∆)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2207 (∇)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x3e, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2208 (∈)
	{ 0x00, 0x00, 0x00, 0x10, 0x3c, 0x12, 0x3e, 0x0a, 0x3c, 0x08, 0x00, 0x00, 0x00 },	// U+2209 (∉)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x1e, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+220A (∊)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x3e, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+220B (∋)
	{ 0x00, 0x00, 0x00, 0x08, 0x1e, 0x28, 0x3e, 0x24, 0x1e, 0x04, 0x00, 0x00, 0x00 },	// U+220C (∌)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x3c, 0x20, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+220D (∍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x00, 0x00 },	// U+220E (∎)
	{ 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+220F (∏)
	{ 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00 },	// U+2210 (∐)
	{ 0x00, 0x3e, 0x22, 0x04, 0x08, 0x08, 0x04, 0x04, 0x22, 0x3e, 0x00, 0x00, 0x00 },	// U+2211 (∑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2212 (−)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2213 (∓)
	{ 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2214 (∔)
	{ 0x00, 0x10, 0x10, 0x10, 0x08, 0x08, 0x08, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00 },	// U+2215 (∕)
	{ 0x00, 0x04, 0x04, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+2216 (∖)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x2a, 0x1c, 0x2a, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2217 (∗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2218 (∘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2219 (∙)
	{ 0x38, 0x08, 0x08, 0x08, 0x04, 0x04, 0x05, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00 },	// U+221A (√)
	{ 0x33, 0x14, 0x13, 0x14, 0x0b, 0x08, 0x09, 0x09, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+221B (∛)
	{ 0x32, 0x13, 0x17, 0x12, 0x08, 0x08, 0x09, 0x09, 0x06, 0x06, 0x00, 0x00, 0x00 },	// U+221C (∜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00, 0x00 },	// U+221D (∝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x49, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+221E (∞)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+221F (∟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x04, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2220 (∠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x14, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2221 (∡)
	{ 0x00, 0x00, 0x20, 0x14, 0x08, 0x14, 0x12, 0x14, 0x08, 0x14, 0x20, 0x00, 0x00 },	// U+2222 (∢)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2223 (∣)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x38, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+2224 (∤)
	{ 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+2225 (∥)
	{ 0x00, 0x14, 0x14, 0x14, 0x34, 0x1c, 0x16, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00 },	// U+2226 (∦)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x14, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+2227 (∧)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+2228 (∨)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+2229 (∩)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+222A (∪)
	{ 0x00, 0x30, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x06, 0x00 },	// U+222B (∫)
	{ 0x00, 0x68, 0x54, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x15, 0x0b, 0x00 },	// U+222C (∬)
}; // 45

static const unsigned char cozette_block108[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+2234 (∴)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2235 (∵)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2236 (∶)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+2237 (∷)
}; // 4

static const unsigned char cozette_block109[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x3e, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+223A (∺)
}; // 1

static const unsigned char cozette_block110[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x2d, 0x19, 0x00, 0x00, 0x00, 0x00 },	// U+223E (∾)
}; // 1

static const unsigned char cozette_block111[][13] = {
	{ 0x00, 0x00, 0x2c, 0x1a, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2245 (≅)
}; // 1

static const unsigned char cozette_block112[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x2a, 0x14, 0x2a, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+2248 (≈)
	{ 0x00, 0x00, 0x00, 0x20, 0x24, 0x1a, 0x54, 0x2a, 0x58, 0x24, 0x04, 0x00, 0x00 },	// U+2249 (≉)
}; // 2

static const unsigned char cozette_block113[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x1c, 0x00, 0x1c, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+224D (≍)
}; // 1

static const unsigned char cozette_block114[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x3e, 0x08, 0x3e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2260 (≠)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2261 (≡)
	{ 0x00, 0x00, 0x00, 0x10, 0x1e, 0x08, 0x1e, 0x04, 0x1e, 0x02, 0x00, 0x00, 0x00 },	// U+2262 (≢)
}; // 3

static const unsigned char cozette_block115[][13] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x0c, 0x02, 0x0c, 0x30, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+2264 (≤)
	{ 0x00, 0x00, 0x00, 0x06, 0x18, 0x20, 0x18, 0x06, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+2265 (≥)
}; // 2

static const unsigned char cozette_block116[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+2282 (⊂)
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+2283 (⊃)
	{ 0x00, 0x00, 0x00, 0x20, 0x3c, 0x12, 0x0a, 0x0a, 0x3c, 0x04, 0x00, 0x00, 0x00 },	// U+2284 (⊄)
	{ 0x00, 0x00, 0x00, 0x10, 0x1e, 0x28, 0x24, 0x24, 0x1e, 0x02, 0x00, 0x00, 0x00 },	// U+2285 (⊅)
	{ 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x02, 0x3c, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+2286 (⊆)
	{ 0x00, 0x00, 0x00, 0x1e, 0x20, 0x20, 0x20, 0x1e, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+2287 (⊇)
	{ 0x00, 0x00, 0x20, 0x3c, 0x12, 0x0a, 0x0a, 0x3c, 0x04, 0x3e, 0x02, 0x00, 0x00 },	// U+2288 (⊈)
	{ 0x00, 0x20, 0x20, 0x1e, 0x30, 0x28, 0x28, 0x1e, 0x04, 0x3e, 0x02, 0x00, 0x00 },	// U+2289 (⊉)
	{ 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x02, 0x3c, 0x10, 0x3e, 0x04, 0x00, 0x00 },	// U+228A (⊊)
	{ 0x00, 0x00, 0x00, 0x1e, 0x20, 0x20, 0x20, 0x1e, 0x10, 0x3e, 0x04, 0x00, 0x00 },	// U+228B (⊋)
}; // 10

static const unsigned char cozette_block117[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+228F (⊏)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2290 (⊐)
	{ 0x00, 0x00, 0x00, 0x3e, 0x02, 0x02, 0x02, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+2291 (⊑)
	{ 0x00, 0x00, 0x00, 0x3e, 0x20, 0x20, 0x20, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+2292 (⊒)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+2293 (⊓)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00 },	// U+2294 (⊔)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x3e, 0x2a, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2295 (⊕)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3e, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2296 (⊖)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x55, 0x49, 0x55, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+2297 (⊗)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x32, 0x2a, 0x26, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2298 (⊘)
}; // 10

static const unsigned char cozette_block118[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x5d, 0x7f, 0x5d, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+229B (⊛)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x5d, 0x41, 0x5d, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+229C (⊜)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x7f, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+229D (⊝)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x2a, 0x3e, 0x2a, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+229E (⊞)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x3e, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+229F (⊟)
	{ 0x00, 0x00, 0x00, 0x7f, 0x63, 0x55, 0x49, 0x55, 0x63, 0x7f, 0x00, 0x00, 0x00 },	// U+22A0 (⊠)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x2a, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+22A1 (⊡)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x3e, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+22A2 (⊢)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x3e, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+22A3 (⊣)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+22A4 (⊤)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+22A5 (⊥)
}; // 11

static const unsigned char cozette_block119[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x3e, 0x02, 0x3e, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+22A8 (⊨)
}; // 1

static const unsigned char cozette_block120[][13] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x2c, 0x22, 0x2c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22B2 (⊲)
	{ 0x00, 0x00, 0x00, 0x06, 0x1a, 0x22, 0x1a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22B3 (⊳)
	{ 0x00, 0x00, 0x00, 0x30, 0x2c, 0x22, 0x2c, 0x30, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+22B4 (⊴)
	{ 0x00, 0x00, 0x00, 0x06, 0x1a, 0x22, 0x1a, 0x06, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+22B5 (⊵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x3d, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22B6 (⊶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2f, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22B7 (⊷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x2e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22B8 (⊸)
}; // 7

static const unsigned char cozette_block121[][13] = {
	{ 0x00, 0x08, 0x08, 0x08, 0x14, 0x14, 0x14, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+22C0 (⋀)
	{ 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+22C1 (⋁)
	{ 0x00, 0x1c, 0x36, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+22C2 (⋂)
	{ 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+22C3 (⋃)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+22C4 (⋄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22C5 (⋅)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x1c, 0x1c, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+22C6 (⋆)
}; // 7

static const unsigned char cozette_block122[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x36, 0x2a, 0x36, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+22C8 (⋈)
}; // 1

static const unsigned char cozette_block123[][13] = {
	{ 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+22EE (⋮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+22EF (⋯)
	{ 0x00, 0x00, 0x20, 0x00, 0x00, 0x08, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+22F0 (⋰)
	{ 0x00, 0x00, 0x02, 0x00, 0x00, 0x08, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+22F1 (⋱)
}; // 4

static const unsigned char cozette_block124[][13] = {
	{ 0x00, 0x00, 0x20, 0x1e, 0x33, 0x29, 0x25, 0x33, 0x1e, 0x01, 0x00, 0x00, 0x00 },	// U+2300 (⌀)
}; // 1

static const unsigned char cozette_block125[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2302 (⌂)
}; // 1

static const unsigned char cozette_block126[][13] = {
	{ 0x00, 0x00, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2308 (⌈)
	{ 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2309 (⌉)
	{ 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+230A (⌊)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+230B (⌋)
	{ 0x00, 0x00, 0x38, 0x00, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+230C (⌌)
	{ 0x00, 0x00, 0x0e, 0x00, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+230D (⌍)
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+230E (⌎)
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+230F (⌏)
}; // 8

static const unsigned char cozette_block127[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x1c, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2315 (⌕)
}; // 1

static const unsigned char cozette_block128[][13] = {
	{ 0x00, 0x00, 0x00, 0x22, 0x55, 0x3e, 0x14, 0x3e, 0x55, 0x22, 0x00, 0x00, 0x00 },	// U+2318 (⌘)
}; // 1

static const unsigned char cozette_block129[][13] = {
	{ 0x00, 0x00, 0x0e, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+231C (⌜)
	{ 0x00, 0x00, 0x38, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+231D (⌝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+231E (⌞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+231F (⌟)
	{ 0x00, 0x00, 0x30, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2320 (⌠)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0a, 0x06, 0x00 },	// U+2321 (⌡)
}; // 6

static const unsigned char cozette_block130[][13] = {
	{ 0x00, 0x00, 0x10, 0x10, 0x08, 0x08, 0x04, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00 },	// U+2329 (〈)
	{ 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00 },	// U+232A (〉)
}; // 2

static const unsigned char cozette_block131[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+2335 (⌵)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+2336 (⌶)
	{ 0x00, 0x00, 0x1c, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1c, 0x00, 0x00 },	// U+2337 (⌷)
	{ 0x00, 0x00, 0x3e, 0x22, 0x22, 0x3e, 0x22, 0x3e, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+2338 (⌸)
	{ 0x00, 0x00, 0x3e, 0x22, 0x2a, 0x22, 0x3e, 0x22, 0x2a, 0x22, 0x3e, 0x00, 0x00 },	// U+2339 (⌹)
	{ 0x00, 0x00, 0x3e, 0x22, 0x22, 0x2a, 0x36, 0x2a, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+233A (⌺)
}; // 6

static const unsigned char cozette_block132[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x2a, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+233D (⌽)
	{ 0x00, 0x00, 0x00, 0x1e, 0x33, 0x2d, 0x33, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+233E (⌾)
	{ 0x00, 0x00, 0x10, 0x10, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00 },	// U+233F (⌿)
	{ 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00 },	// U+2340 (⍀)
	{ 0x00, 0x00, 0x3e, 0x32, 0x32, 0x2a, 0x2a, 0x2a, 0x26, 0x26, 0x3e, 0x00, 0x00 },	// U+2341 (⍁)
	{ 0x00, 0x00, 0x3e, 0x26, 0x26, 0x2a, 0x2a, 0x2a, 0x32, 0x32, 0x3e, 0x00, 0x00 },	// U+2342 (⍂)
}; // 6

static const unsigned char cozette_block133[][13] = {
	{ 0x00, 0x00, 0x01, 0x1e, 0x33, 0x25, 0x29, 0x33, 0x1e, 0x20, 0x00, 0x00, 0x00 },	// U+2349 (⍉)
}; // 1

static const unsigned char cozette_block134[][13] = {
	{ 0x00, 0x08, 0x08, 0x08, 0x1c, 0x1c, 0x1c, 0x2a, 0x2a, 0x3e, 0x08, 0x08, 0x00 },	// U+234B (⍋)
}; // 1

static const unsigned char cozette_block135[][13] = {
	{ 0x00, 0x00, 0x3e, 0x22, 0x2a, 0x2a, 0x2a, 0x3e, 0x3e, 0x22, 0x3e, 0x00, 0x00 },	// U+234D (⍍)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x2a, 0x1c, 0x08, 0x3e, 0x00, 0x00, 0x00 },	// U+234E (⍎)
}; // 2

static const unsigned char cozette_block136[][13] = {
	{ 0x00, 0x08, 0x08, 0x3e, 0x2a, 0x2a, 0x1c, 0x1c, 0x1c, 0x08, 0x08, 0x08, 0x00 },	// U+2352 (⍒)
}; // 1

static const unsigned char cozette_block137[][13] = {
	{ 0x00, 0x00, 0x00, 0x3e, 0x08, 0x1c, 0x2a, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+2355 (⍕)
}; // 1

static const unsigned char cozette_block138[][13] = {
	{ 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00 },	// U+2358 (⍘)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x14, 0x14, 0x22, 0x3e, 0x00, 0x3e, 0x00, 0x00 },	// U+2359 (⍙)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x14, 0x08, 0x00, 0x3e, 0x00, 0x00 },	// U+235A (⍚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x08, 0x00, 0x00, 0x3e, 0x00, 0x00 },	// U+235B (⍛)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x3e, 0x00, 0x00 },	// U+235C (⍜)
	{ 0x00, 0x00, 0x00, 0x1c, 0x36, 0x22, 0x36, 0x3e, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+235D (⍝)
	{ 0x00, 0x00, 0x3e, 0x22, 0x2a, 0x2a, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+235E (⍞)
	{ 0x00, 0x00, 0x1c, 0x22, 0x49, 0x5d, 0x49, 0x55, 0x41, 0x22, 0x1c, 0x00, 0x00 },	// U+235F (⍟)
	{ 0x00, 0x00, 0x3e, 0x22, 0x22, 0x2a, 0x22, 0x2a, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+2360 (⍠)
	{ 0x00, 0x00, 0x14, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2361 (⍡)
	{ 0x00, 0x14, 0x00, 0x3e, 0x22, 0x22, 0x14, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00 },	// U+2362 (⍢)
	{ 0x00, 0x00, 0x14, 0x00, 0x08, 0x08, 0x3e, 0x1c, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+2363 (⍣)
	{ 0x00, 0x00, 0x14, 0x00, 0x00, 0x08, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2364 (⍤)
	{ 0x00, 0x00, 0x14, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+2365 (⍥)
}; // 14

static const unsigned char cozette_block139[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x2c, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2368 (⍨)
}; // 1

static const unsigned char cozette_block140[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x0c, 0x0c, 0x08, 0x04, 0x00 },	// U+236A (⍪)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x14, 0x3c, 0x1e, 0x08, 0x08, 0x00, 0x00 },	// U+236B (⍫)
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x6e, 0x3b, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+236C (⍬)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x2c, 0x1a, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+236D (⍭)
	{ 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x0c, 0x0c, 0x08, 0x1e, 0x00 },	// U+236E (⍮)
	{ 0x00, 0x00, 0x3e, 0x22, 0x32, 0x3e, 0x2a, 0x3e, 0x26, 0x22, 0x3e, 0x00, 0x00 },	// U+236F (⍯)
}; // 6

static const unsigned char cozette_block141[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x3c, 0x1e, 0x08, 0x08, 0x00, 0x00 },	// U+2371 (⍱)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x3c, 0x1e, 0x14, 0x14, 0x00, 0x00 },	// U+2372 (⍲)
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2373 (⍳)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x26, 0x1a, 0x02, 0x02, 0x02, 0x00 },	// U+2374 (⍴)
	{ 0x00, 0x00, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+2375 (⍵)
	{ 0x00, 0x00, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x3e, 0x00, 0x00 },	// U+2376 (⍶)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x02, 0x1e, 0x02, 0x1c, 0x00, 0x3e, 0x00, 0x00 },	// U+2377 (⍷)
	{ 0x00, 0x00, 0x00, 0x0c, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00, 0x3e, 0x00, 0x00 },	// U+2378 (⍸)
	{ 0x00, 0x00, 0x00, 0x14, 0x22, 0x22, 0x2a, 0x2a, 0x14, 0x00, 0x3e, 0x00, 0x00 },	// U+2379 (⍹)
	{ 0x00, 0x00, 0x00, 0x2c, 0x32, 0x12, 0x12, 0x12, 0x2c, 0x00, 0x00, 0x00, 0x00 },	// U+237A (⍺)
}; // 10

static const unsigned char cozette_block142[][13] = {
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x1c, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+237F (⍿)
}; // 1

static const unsigned char cozette_block143[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x70, 0x28, 0x08, 0x04, 0x77, 0x00, 0x00, 0x00 },	// U+2387 (⎇)
	{ 0x00, 0x00, 0x00, 0x49, 0x3e, 0x36, 0x6b, 0x36, 0x3e, 0x49, 0x00, 0x00, 0x00 },	// U+2388 (⎈)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x77, 0x5d, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+2389 (⎉)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x7f, 0x63, 0x55, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+238A (⎊)
	{ 0x00, 0x00, 0x00, 0x07, 0x13, 0x25, 0x28, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+238B (⎋)
}; // 5

static const unsigned char cozette_block144[][13] = {
	{ 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00 },	// U+2395 (⎕)
}; // 1

static const unsigned char cozette_block145[][13] = {
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x24, 0x3e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+23CE (⏎)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+23CF (⏏)
}; // 2

static const unsigned char cozette_block146[][13] = {
	{ 0x00, 0x12, 0x2b, 0x2a, 0x2a, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23E8 (⏨)
}; // 1

static const unsigned char cozette_block147[][13] = {
	{ 0x00, 0x7f, 0x41, 0x41, 0x3e, 0x1c, 0x1c, 0x2a, 0x49, 0x7f, 0x7f, 0x00, 0x00 },	// U+23F3 (⏳)
	{ 0x00, 0x00, 0x10, 0x18, 0x1c, 0x1e, 0x1c, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00 },	// U+23F4 (⏴)
	{ 0x00, 0x00, 0x02, 0x06, 0x0e, 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+23F5 (⏵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23F6 (⏶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+23F7 (⏷)
	{ 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+23F8 (⏸)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+23F9 (⏹)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+23FA (⏺)
	{ 0x00, 0x00, 0x00, 0x08, 0x2a, 0x49, 0x49, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+23FB (⏻)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x49, 0x49, 0x49, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+23FC (⏼)
}; // 10

static const unsigned char cozette_block148[][13] = {
	{ 0x00, 0x03, 0x05, 0x05, 0x00, 0x0a, 0x0a, 0x0c, 0x00, 0x08, 0x08, 0x38, 0x00 },	// U+2400 (␀)
}; // 1

static const unsigned char cozette_block149[][13] = {
	{ 0x00, 0x06, 0x0a, 0x06, 0x0a, 0x06, 0x00, 0x18, 0x04, 0x08, 0x10, 0x0c, 0x00 },	// U+2408 (␈)
	{ 0x00, 0x0a, 0x0a, 0x0e, 0x0a, 0x0a, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+2409 (␉)
	{ 0x00, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x00, 0x1c, 0x04, 0x1c, 0x04, 0x04, 0x00 },	// U+240A (␊)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x04, 0x04, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x00 },	// U+240B (␋)
	{ 0x00, 0x0e, 0x02, 0x0e, 0x02, 0x02, 0x00, 0x1c, 0x04, 0x1c, 0x04, 0x04, 0x00 },	// U+240C (␌)
	{ 0x00, 0x0c, 0x02, 0x02, 0x02, 0x0c, 0x00, 0x0c, 0x14, 0x0c, 0x14, 0x14, 0x00 },	// U+240D (␍)
	{ 0x00, 0x0c, 0x02, 0x04, 0x08, 0x06, 0x00, 0x08, 0x14, 0x14, 0x14, 0x08, 0x00 },	// U+240E (␎)
	{ 0x00, 0x0c, 0x02, 0x04, 0x08, 0x06, 0x00, 0x1c, 0x08, 0x08, 0x08, 0x1c, 0x00 },	// U+240F (␏)
}; // 8

static const unsigned char cozette_block150[][13] = {
	{ 0x00, 0x0e, 0x02, 0x0e, 0x02, 0x02, 0x00, 0x18, 0x04, 0x08, 0x10, 0x0c, 0x00 },	// U+241C (␜)
	{ 0x00, 0x0c, 0x02, 0x0a, 0x0a, 0x04, 0x00, 0x18, 0x04, 0x08, 0x10, 0x0c, 0x00 },	// U+241D (␝)
	{ 0x00, 0x06, 0x0a, 0x06, 0x0a, 0x0a, 0x00, 0x18, 0x04, 0x08, 0x10, 0x0c, 0x00 },	// U+241E (␞)
	{ 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0e, 0x00, 0x18, 0x04, 0x08, 0x10, 0x0c, 0x00 },	// U+241F (␟)
	{ 0x00, 0x0c, 0x02, 0x04, 0x08, 0x06, 0x00, 0x0c, 0x14, 0x0c, 0x04, 0x04, 0x00 },	// U+2420 (␠)
}; // 5

static const unsigned char cozette_block151[][13] = {
	{ 0x00, 0x12, 0x16, 0x1a, 0x12, 0x12, 0x00, 0x04, 0x04, 0x04, 0x04, 0x1c, 0x00 },	// U+2424 (␤)
}; // 1

static const unsigned char cozette_block152[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2500 (─)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2501 (━)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2502 (│)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2503 (┃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2504 (┄)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2505 (┅)
	{ 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08 },	// U+2506 (┆)
	{ 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18 },	// U+2507 (┇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2508 (┈)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2509 (┉)
	{ 0x00, 0x08, 0x08, 0x00, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08 },	// U+250A (┊)
	{ 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18 },	// U+250B (┋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+250C (┌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+250D (┍)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+250E (┎)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+250F (┏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2510 (┐)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2511 (┑)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2512 (┒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2513 (┓)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2514 (└)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2515 (┕)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2516 (┖)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2517 (┗)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2518 (┘)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2519 (┙)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251A (┚)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+251B (┛)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+251C (├)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+251D (┝)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+251E (┞)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+251F (┟)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2520 (┠)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2521 (┡)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2522 (┢)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2523 (┣)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2524 (┤)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2525 (┥)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2526 (┦)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2527 (┧)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2528 (┨)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2529 (┩)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+252A (┪)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+252B (┫)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+252C (┬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+252D (┭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+252E (┮)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+252F (┯)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2530 (┰)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2531 (┱)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2532 (┲)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2533 (┳)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2534 (┴)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2535 (┵)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2536 (┶)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2537 (┷)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2538 (┸)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2539 (┹)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253A (┺)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+253B (┻)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+253C (┼)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+253D (┽)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+253E (┾)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+253F (┿)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2540 (╀)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2541 (╁)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2542 (╂)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2543 (╃)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2544 (╄)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x1f, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2545 (╅)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2546 (╆)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x7f, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2547 (╇)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2548 (╈)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+2549 (╉)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+254A (╊)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x7f, 0x7f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+254B (╋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+254C (╌)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+254D (╍)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+254E (╎)
	{ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+254F (╏)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2550 (═)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2551 (║)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x08, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2552 (╒)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2553 (╓)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x04, 0x74, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2554 (╔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2555 (╕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2556 (╖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2557 (╗)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x08, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2558 (╘)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2559 (╙)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x74, 0x04, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255A (╚)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255B (╛)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255C (╜)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+255D (╝)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x08, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+255E (╞)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x74, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+255F (╟)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x74, 0x04, 0x74, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2560 (╠)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2561 (╡)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2562 (╢)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x10, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2563 (╣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2564 (╤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2565 (╥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x77, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+2566 (╦)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2567 (╧)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2568 (╨)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x77, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2569 (╩)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x7f, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+256A (╪)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x7f, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+256B (╫)
	{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x77, 0x00, 0x77, 0x14, 0x14, 0x14, 0x14, 0x14 },	// U+256C (╬)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+256D (╭)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+256E (╮)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+256F (╯)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2570 (╰)
	{ 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01 },	// U+2571 (╱)
	{ 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40 },	// U+2572 (╲)
	{ 0x41, 0x41, 0x22, 0x22, 0x14, 0x14, 0x08, 0x14, 0x14, 0x22, 0x22, 0x41, 0x41 },	// U+2573 (╳)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2574 (╴)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2575 (╵)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2576 (╶)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+2577 (╷)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2578 (╸)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2579 (╹)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257A (╺)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+257B (╻)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257C (╼)
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },	// U+257D (╽)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+257E (╾)
	{ 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },	// U+257F (╿)
	{ 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2580 (▀)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f },	// U+2581 (▁)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f },	// U+2582 (▂)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f },	// U+2583 (▃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f },	// U+2584 (▄)
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f },	// U+2585 (▅)
	{ 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f },	// U+2586 (▆)
	{ 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f },	// U+2587 (▇)
	{ 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f },	// U+2588 (█)
	{ 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f },	// U+2589 (▉)
	{ 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f },	// U+258A (▊)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+258B (▋)
	{ 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f },	// U+258C (▌)
	{ 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 },	// U+258D (▍)
	{ 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 },	// U+258E (▎)
	{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },	// U+258F (▏)
	{ 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78 },	// U+2590 (▐)
	{ 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11 },	// U+2591 (░)
	{ 0x55, 0x2a, 0x55, 0x2a, 0x55, 0x2a, 0x55, 0x2a, 0x55, 0x2a, 0x55, 0x2a, 0x55 },	// U+2592 (▒)
	{ 0x5d, 0x77, 0x5d, 0x77, 0x5d, 0x77, 0x5d, 0x77, 0x5d, 0x77, 0x5d, 0x77, 0x5d },	// U+2593 (▓)
	{ 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2594 (▔)
}; // 149

static const unsigned char cozette_block153[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x7f, 0x8f, 0x37, 0xff, 0xcf },	// U+2596 (▖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0x78, 0x78, 0x78, 0xf8, 0x78 },	// U+2597 (▗)
	{ 0x37, 0x6f, 0x4f, 0xef, 0x5f, 0x6f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2598 (▘)
	{ 0x47, 0x47, 0x47, 0x07, 0x47, 0x07, 0xc7, 0xbf, 0x3f, 0xff, 0xff, 0xff, 0xff },	// U+2599 (▙)
	{ 0x87, 0x87, 0x07, 0x07, 0x47, 0xc7, 0xc7, 0x78, 0x78, 0xf8, 0xb8, 0x78, 0x38 },	// U+259A (▚)
	{ 0xbf, 0xbf, 0x3f, 0x3f, 0x7f, 0xff, 0xff, 0x47, 0x47, 0xc7, 0x87, 0x47, 0x07 },	// U+259B (▛)
	{ 0x7f, 0x7f, 0x7f, 0x3f, 0x7f, 0x3f, 0xff, 0xb8, 0x38, 0xf8, 0x38, 0xf8, 0x38 },	// U+259C (▜)
	{ 0x78, 0xf8, 0x78, 0xf8, 0xf8, 0x78, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+259D (▝)
	{ 0xb8, 0xb8, 0x38, 0x38, 0x78, 0xf8, 0xf8, 0x47, 0x47, 0xc7, 0x87, 0x47, 0x07 },	// U+259E (▞)
	{ 0x38, 0x78, 0xf8, 0x78, 0x78, 0x38, 0xf8, 0x7f, 0xff, 0xff, 0x3f, 0xff, 0x3f },	// U+259F (▟)
	{ 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00 },	// U+25A0 (■)
	{ 0x00, 0x00, 0x00, 0x7f, 0x41, 0x41, 0x41, 0x41, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+25A1 (□)
	{ 0x00, 0x00, 0x00, 0x3e, 0x41, 0x41, 0x41, 0x41, 0x41, 0x3e, 0x00, 0x00, 0x00 },	// U+25A2 (▢)
	{ 0x00, 0x00, 0x00, 0x7f, 0x41, 0x5d, 0x5d, 0x5d, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+25A3 (▣)
}; // 14

static const unsigned char cozette_block154[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+25AA (▪)
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+25AB (▫)
}; // 2

static const unsigned char cozette_block155[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x7f, 0x00, 0x00, 0x00 },	// U+25B2 (▲)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x22, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+25B3 (△)
}; // 2

static const unsigned char cozette_block156[][13] = {
	{ 0x00, 0x00, 0x02, 0x06, 0x0e, 0x1e, 0x3e, 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00 },	// U+25B6 (▶)
}; // 1

static const unsigned char cozette_block157[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+25BC (▼)
	{ 0x00, 0x00, 0x00, 0x7f, 0x41, 0x22, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+25BD (▽)
}; // 2

static const unsigned char cozette_block158[][13] = {
	{ 0x00, 0x00, 0x20, 0x30, 0x38, 0x3c, 0x3e, 0x3c, 0x38, 0x30, 0x20, 0x00, 0x00 },	// U+25C0 (◀)
}; // 1

static const unsigned char cozette_block159[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+25C6 (◆)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x41, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+25C7 (◇)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x2a, 0x5d, 0x2a, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+25C8 (◈)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x5d, 0x5d, 0x5d, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+25C9 (◉)
}; // 4

static const unsigned char cozette_block160[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+25CB (○)
}; // 1

static const unsigned char cozette_block161[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x49, 0x55, 0x49, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+25CE (◎)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+25CF (●)
	{ 0x00, 0x00, 0x00, 0x1c, 0x2e, 0x4f, 0x4f, 0x4f, 0x2e, 0x1c, 0x00, 0x00, 0x00 },	// U+25D0 (◐)
	{ 0x00, 0x00, 0x00, 0x1c, 0x3a, 0x79, 0x79, 0x79, 0x3a, 0x1c, 0x00, 0x00, 0x00 },	// U+25D1 (◑)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x7f, 0x7f, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+25D2 (◒)
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x7f, 0x7f, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+25D3 (◓)
	{ 0x00, 0x00, 0x00, 0x1c, 0x3a, 0x79, 0x79, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+25D4 (◔)
	{ 0x00, 0x00, 0x00, 0x1c, 0x32, 0x71, 0x71, 0x7f, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+25D5 (◕)
}; // 8

static const unsigned char cozette_block162[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x49, 0x49, 0x49, 0x49, 0x49, 0x7f, 0x00, 0x00, 0x00 },	// U+25EB (◫)
}; // 1

static const unsigned char cozette_block163[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x49, 0x49, 0x4f, 0x41, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+25F0 (◰)
	{ 0x00, 0x00, 0x00, 0x7f, 0x41, 0x41, 0x4f, 0x49, 0x49, 0x7f, 0x00, 0x00, 0x00 },	// U+25F1 (◱)
	{ 0x00, 0x00, 0x00, 0x7f, 0x41, 0x41, 0x79, 0x49, 0x49, 0x7f, 0x00, 0x00, 0x00 },	// U+25F2 (◲)
	{ 0x00, 0x00, 0x00, 0x7f, 0x49, 0x49, 0x79, 0x41, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+25F3 (◳)
	{ 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x49, 0x4f, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+25F4 (◴)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x4f, 0x49, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+25F5 (◵)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x79, 0x49, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+25F6 (◶)
	{ 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x49, 0x79, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+25F7 (◷)
}; // 8

static const unsigned char cozette_block164[][13] = {
	{ 0x00, 0x00, 0x00, 0x40, 0x60, 0x50, 0x48, 0x44, 0x42, 0x7f, 0x00, 0x00, 0x00 },	// U+25FF (◿)
}; // 1

static const unsigned char cozette_block165[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2601 (☁)
}; // 1

static const unsigned char cozette_block166[][13] = {
	{ 0x09, 0x20, 0x0a, 0x5c, 0x15, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+2603 (☃)
}; // 1

static const unsigned char cozette_block167[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x41, 0x41, 0x41, 0x41, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+2610 (☐)
	{ 0x00, 0x00, 0x00, 0x7f, 0x61, 0x71, 0x5b, 0x4f, 0x45, 0x7f, 0x00, 0x00, 0x00 },	// U+2611 (☑)
	{ 0x00, 0x00, 0x00, 0x7f, 0x41, 0x55, 0x49, 0x55, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+2612 (☒)
}; // 3

static const unsigned char cozette_block168[][13] = {
	{ 0x08, 0x04, 0x04, 0x08, 0x0e, 0x75, 0x51, 0x3f, 0x1f, 0x0e, 0x00, 0x00, 0x00 },	// U+2615 (☕)
}; // 1

static const unsigned char cozette_block169[][13] = {
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+2630 (☰)
	{ 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+2631 (☱)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x36, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+2632 (☲)
	{ 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x36, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+2633 (☳)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00 },	// U+2634 (☴)
	{ 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00 },	// U+2635 (☵)
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x36, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00 },	// U+2636 (☶)
	{ 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x36, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00 },	// U+2637 (☷)
	{ 0x00, 0x00, 0x00, 0x5d, 0x2a, 0x5d, 0x77, 0x5d, 0x2a, 0x5d, 0x00, 0x00, 0x00 },	// U+2638 (☸)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x1e, 0x21, 0x00, 0x00, 0x00, 0x00 },	// U+2639 (☹)
	{ 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x21, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+263A (☺)
	{ 0x00, 0x00, 0x00, 0x3f, 0x6d, 0x7f, 0xff, 0x5e, 0x61, 0xff, 0x00, 0x00, 0x00 },	// U+263B (☻)
}; // 12

static const unsigned char cozette_block170[][13] = {
	{ 0x00, 0x00, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x1c, 0x08, 0x00 },	// U+263F (☿)
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x1c, 0x08, 0x00 },	// U+2640 (♀)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+2641 (♁)
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x30, 0x2e, 0x09, 0x09, 0x06, 0x00, 0x00, 0x00 },	// U+2642 (♂)
}; // 4

static const unsigned char cozette_block171[][13] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x7f, 0x2a, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+2660 (♠)
	{ 0x00, 0x00, 0x00, 0x36, 0x49, 0x41, 0x41, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+2661 (♡)
	{ 0x00, 0x00, 0x08, 0x14, 0x14, 0x22, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+2662 (♢)
	{ 0x00, 0x00, 0x08, 0x1c, 0x08, 0x2a, 0x7f, 0x2a, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+2663 (♣)
	{ 0x00, 0x00, 0x08, 0x14, 0x22, 0x41, 0x55, 0x2a, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+2664 (♤)
	{ 0x00, 0x00, 0x00, 0x36, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+2665 (♥)
	{ 0x00, 0x00, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+2666 (♦)
	{ 0x00, 0x00, 0x08, 0x14, 0x08, 0x2a, 0x55, 0x2a, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+2667 (♧)
}; // 8

static const unsigned char cozette_block172[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+2669 (♩)
	{ 0x00, 0x00, 0x00, 0x18, 0x28, 0x08, 0x08, 0x08, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+266A (♪)
	{ 0x00, 0x00, 0x0e, 0x32, 0x22, 0x22, 0x22, 0x23, 0x33, 0x30, 0x00, 0x00, 0x00 },	// U+266B (♫)
	{ 0x00, 0x00, 0x00, 0x3e, 0x22, 0x3e, 0x22, 0x22, 0x33, 0x33, 0x00, 0x00, 0x00 },	// U+266C (♬)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x1c, 0x14, 0x14, 0x0c, 0x00, 0x00, 0x00 },	// U+266D (♭)
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x1c, 0x14, 0x14, 0x1c, 0x10, 0x10, 0x00, 0x00 },	// U+266E (♮)
	{ 0x00, 0x00, 0x00, 0x10, 0x34, 0x1c, 0x16, 0x34, 0x1c, 0x16, 0x04, 0x00, 0x00 },	// U+266F (♯)
}; // 7

static const unsigned char cozette_block173[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x77, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00 },	// U+2680 (⚀)
	{ 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x6f, 0x7f, 0x7b, 0x7f, 0x7f, 0x00, 0x00, 0x00 },	// U+2681 (⚁)
	{ 0x00, 0x00, 0x00, 0x7f, 0x5f, 0x7f, 0x77, 0x7f, 0x7d, 0x7f, 0x00, 0x00, 0x00 },	// U+2682 (⚂)
	{ 0x00, 0x00, 0x00, 0x7f, 0x5d, 0x7f, 0x7f, 0x7f, 0x5d, 0x7f, 0x00, 0x00, 0x00 },	// U+2683 (⚃)
	{ 0x00, 0x00, 0x00, 0x7f, 0x5d, 0x7f, 0x77, 0x7f, 0x5d, 0x7f, 0x00, 0x00, 0x00 },	// U+2684 (⚄)
	{ 0x00, 0x00, 0x00, 0x7f, 0x6b, 0x7f, 0x6b, 0x7f, 0x6b, 0x7f, 0x00, 0x00, 0x00 },	// U+2685 (⚅)
}; // 6

static const unsigned char cozette_block174[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x55, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+2687 (⚇)
}; // 1

static const unsigned char cozette_block175[][13] = {
	{ 0x00, 0x00, 0x07, 0x79, 0x41, 0x41, 0x41, 0x47, 0x79, 0x01, 0x01, 0x01, 0x00 },	// U+2690 (⚐)
	{ 0x00, 0x00, 0x07, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x79, 0x01, 0x01, 0x01, 0x00 },	// U+2691 (⚑)
}; // 2

static const unsigned char cozette_block176[][13] = {
	{ 0x00, 0x00, 0x00, 0x12, 0x5c, 0x23, 0x2a, 0x62, 0x1d, 0x24, 0x00, 0x00, 0x00 },	// U+2699 (⚙)
}; // 1

static const unsigned char cozette_block177[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x14, 0x36, 0x3e, 0x77, 0x7f, 0x00, 0x00, 0x00 },	// U+26A0 (⚠)
	{ 0x00, 0x00, 0x00, 0x10, 0x0c, 0x06, 0x1c, 0x30, 0x18, 0x04, 0x00, 0x00, 0x00 },	// U+26A1 (⚡)
	{ 0x00, 0x00, 0x00, 0x1e, 0x2d, 0x2d, 0x1e, 0x12, 0x3f, 0x12, 0x00, 0x00, 0x00 },	// U+26A2 (⚢)
	{ 0x00, 0x00, 0x38, 0x30, 0x2e, 0x79, 0x6d, 0x56, 0x12, 0x0c, 0x00, 0x00, 0x00 },	// U+26A3 (⚣)
}; // 4

static const unsigned char cozette_block178[][13] = {
	{ 0x00, 0x00, 0x38, 0x30, 0x2e, 0x29, 0x09, 0x06, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+26A5 (⚥)
	{ 0x00, 0x10, 0x1c, 0x3a, 0x28, 0x0e, 0x1c, 0x06, 0x09, 0x09, 0x06, 0x00, 0x00 },	// U+26A6 (⚦)
}; // 2

static const unsigned char cozette_block179[][13] = {
	{ 0x00, 0x08, 0x1c, 0x2a, 0x08, 0x3e, 0x08, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00 },	// U+26A8 (⚨)
}; // 1

static const unsigned char cozette_block180[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x00, 0x00 },	// U+26B2 (⚲)
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x18, 0x08, 0x1c, 0x08, 0x00, 0x00 },	// U+26B3 (⚳)
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x14, 0x08, 0x08, 0x1c, 0x08, 0x00, 0x00 },	// U+26B4 (⚴)
	{ 0x00, 0x00, 0x00, 0x2a, 0x1c, 0x3e, 0x1c, 0x2a, 0x08, 0x1c, 0x08, 0x00, 0x00 },	// U+26B5 (⚵)
}; // 4

static const unsigned char cozette_block181[][13] = {
	{ 0x00, 0x00, 0x38, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x38, 0x08, 0x1c, 0x08 },	// U+26B8 (⚸)
}; // 1

static const unsigned char cozette_block182[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x10, 0x12, 0x0c, 0x08, 0x00, 0x00, 0x00 },	// U+2713 (✓)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x30, 0x12, 0x1e, 0x0c, 0x08, 0x00, 0x00, 0x00 },	// U+2714 (✔)
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+2715 (✕)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x3e, 0x1c, 0x3e, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2716 (✖)
	{ 0x00, 0x00, 0x00, 0x24, 0x14, 0x1c, 0x08, 0x1c, 0x14, 0x22, 0x02, 0x00, 0x00 },	// U+2717 (✗)
	{ 0x00, 0x00, 0x22, 0x36, 0x14, 0x1c, 0x1c, 0x1c, 0x36, 0x22, 0x02, 0x00, 0x00 },	// U+2718 (✘)
	{ 0x00, 0x00, 0x00, 0x1c, 0x14, 0x77, 0x41, 0x77, 0x14, 0x1c, 0x00, 0x00, 0x00 },	// U+2719 (✙)
	{ 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x7f, 0x7f, 0x7f, 0x1c, 0x1c, 0x00, 0x00, 0x00 },	// U+271A (✚)
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x36, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+271B (✛)
	{ 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x63, 0x63, 0x63, 0x1c, 0x1c, 0x00, 0x00, 0x00 },	// U+271C (✜)
}; // 10

static const unsigned char cozette_block183[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2726 (✦)
}; // 1

static const unsigned char cozette_block184[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x1c, 0x1c, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+272D (✭)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x1c, 0x1c, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+272E (✮)
}; // 2

static const unsigned char cozette_block185[][13] = {
	{ 0x00, 0x00, 0x00, 0x55, 0x3e, 0x7f, 0x3e, 0x7f, 0x3e, 0x55, 0x00, 0x00, 0x00 },	// U+2739 (✹)
}; // 1

static const unsigned char cozette_block186[][13] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x6b, 0x6b, 0x1c, 0x6b, 0x6b, 0x1c, 0x08, 0x00, 0x00 },	// U+2744 (❄)
}; // 1

static const unsigned char cozette_block187[][13] = {
	{ 0x00, 0x00, 0x04, 0x0c, 0x98, 0xf0, 0x60, 0xf0, 0x98, 0x0c, 0x04, 0x00, 0x00 },	// U+274C (❌)
}; // 1

static const unsigned char cozette_block188[][13] = {
	{ 0x00, 0xf0, 0xf8, 0x98, 0x80, 0xc0, 0xe0, 0x60, 0x60, 0x00, 0x60, 0x60, 0x00 },	// U+2753 (❓)
}; // 1

static const unsigned char cozette_block189[][13] = {
	{ 0x00, 0x00, 0x10, 0x10, 0x18, 0x08, 0x0c, 0x08, 0x18, 0x10, 0x10, 0x00, 0x00 },	// U+276C (❬)
	{ 0x00, 0x00, 0x08, 0x08, 0x18, 0x10, 0x30, 0x10, 0x18, 0x08, 0x08, 0x00, 0x00 },	// U+276D (❭)
	{ 0x00, 0x00, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x00, 0x00 },	// U+276E (❮)
	{ 0x00, 0x00, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x00, 0x00 },	// U+276F (❯)
}; // 4

static const unsigned char cozette_block190[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x7e, 0x7e, 0x30, 0x18, 0x00, 0x00, 0x00 },	// U+279C (➜)
}; // 1

static const unsigned char cozette_block191[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x3a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+27DC (⟜)
}; // 1

static const unsigned char cozette_block192[][13] = {
	{ 0x00, 0x00, 0x3e, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x3e, 0x00, 0x00 },	// U+27E6 (⟦)
	{ 0x00, 0x00, 0x3e, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x3e, 0x00, 0x00 },	// U+27E7 (⟧)
	{ 0x00, 0x00, 0x10, 0x10, 0x08, 0x08, 0x04, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00 },	// U+27E8 (⟨)
	{ 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00 },	// U+27E9 (⟩)
	{ 0x00, 0x00, 0x28, 0x28, 0x14, 0x14, 0x0a, 0x14, 0x14, 0x28, 0x28, 0x00, 0x00 },	// U+27EA (⟪)
	{ 0x00, 0x00, 0x0a, 0x0a, 0x14, 0x14, 0x28, 0x14, 0x14, 0x0a, 0x0a, 0x00, 0x00 },	// U+27EB (⟫)
}; // 6

static const unsigned char cozette_block193[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2800 (⠀)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2801 (⠁)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2802 (⠂)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2803 (⠃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2804 (⠄)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2805 (⠅)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2806 (⠆)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2807 (⠇)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2808 (⠈)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2809 (⠉)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280A (⠊)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+280B (⠋)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+280C (⠌)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+280D (⠍)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+280E (⠎)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+280F (⠏)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2810 (⠐)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2811 (⠑)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2812 (⠒)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2813 (⠓)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2814 (⠔)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2815 (⠕)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2816 (⠖)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+2817 (⠗)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2818 (⠘)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2819 (⠙)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281A (⠚)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+281B (⠛)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+281C (⠜)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+281D (⠝)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+281E (⠞)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+281F (⠟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2820 (⠠)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2821 (⠡)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2822 (⠢)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2823 (⠣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2824 (⠤)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2825 (⠥)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2826 (⠦)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2827 (⠧)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2828 (⠨)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2829 (⠩)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+282A (⠪)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+282B (⠫)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+282C (⠬)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+282D (⠭)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+282E (⠮)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+282F (⠯)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2830 (⠰)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2831 (⠱)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2832 (⠲)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2833 (⠳)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2834 (⠴)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2835 (⠵)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2836 (⠶)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+2837 (⠷)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2838 (⠸)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+2839 (⠹)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+283A (⠺)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+283B (⠻)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+283C (⠼)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+283D (⠽)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+283E (⠾)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+283F (⠿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2840 (⡀)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2841 (⡁)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2842 (⡂)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2843 (⡃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+2844 (⡄)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+2845 (⡅)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+2846 (⡆)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+2847 (⡇)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2848 (⡈)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2849 (⡉)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+284A (⡊)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+284B (⡋)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+284C (⡌)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+284D (⡍)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+284E (⡎)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+284F (⡏)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2850 (⡐)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2851 (⡑)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2852 (⡒)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2853 (⡓)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+2854 (⡔)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+2855 (⡕)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+2856 (⡖)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+2857 (⡗)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2858 (⡘)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+2859 (⡙)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+285A (⡚)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00 },	// U+285B (⡛)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+285C (⡜)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+285D (⡝)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+285E (⡞)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+285F (⡟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00 },	// U+2860 (⡠)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2861 (⡡)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2862 (⡢)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2863 (⡣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+2864 (⡤)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+2865 (⡥)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+2866 (⡦)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+2867 (⡧)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2868 (⡨)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2869 (⡩)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+286A (⡪)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+286B (⡫)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+286C (⡬)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+286D (⡭)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+286E (⡮)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+286F (⡯)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2870 (⡰)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2871 (⡱)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2872 (⡲)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2873 (⡳)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+2874 (⡴)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+2875 (⡵)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+2876 (⡶)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+2877 (⡷)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2878 (⡸)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+2879 (⡹)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+287A (⡺)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00 },	// U+287B (⡻)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+287C (⡼)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+287D (⡽)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+287E (⡾)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00 },	// U+287F (⡿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2880 (⢀)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2881 (⢁)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2882 (⢂)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2883 (⢃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+2884 (⢄)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+2885 (⢅)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+2886 (⢆)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+2887 (⢇)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2888 (⢈)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2889 (⢉)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+288A (⢊)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+288B (⢋)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+288C (⢌)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+288D (⢍)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+288E (⢎)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+288F (⢏)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2890 (⢐)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2891 (⢑)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2892 (⢒)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2893 (⢓)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+2894 (⢔)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+2895 (⢕)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+2896 (⢖)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+2897 (⢗)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2898 (⢘)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+2899 (⢙)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+289A (⢚)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },	// U+289B (⢛)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+289C (⢜)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+289D (⢝)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+289E (⢞)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00 },	// U+289F (⢟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28A0 (⢠)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28A1 (⢡)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28A2 (⢢)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28A3 (⢣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28A4 (⢤)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28A5 (⢥)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28A6 (⢦)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28A7 (⢧)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28A8 (⢨)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28A9 (⢩)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28AA (⢪)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28AB (⢫)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28AC (⢬)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28AD (⢭)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28AE (⢮)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28AF (⢯)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28B0 (⢰)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28B1 (⢱)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28B2 (⢲)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28B3 (⢳)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28B4 (⢴)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28B5 (⢵)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28B6 (⢶)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28B7 (⢷)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28B8 (⢸)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28B9 (⢹)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28BA (⢺)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00 },	// U+28BB (⢻)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28BC (⢼)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28BD (⢽)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28BE (⢾)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00 },	// U+28BF (⢿)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C0 (⣀)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C1 (⣁)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C2 (⣂)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C3 (⣃)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28C4 (⣄)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28C5 (⣅)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28C6 (⣆)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28C7 (⣇)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C8 (⣈)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28C9 (⣉)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28CA (⣊)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28CB (⣋)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28CC (⣌)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28CD (⣍)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28CE (⣎)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28CF (⣏)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D0 (⣐)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D1 (⣑)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D2 (⣒)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D3 (⣓)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28D4 (⣔)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28D5 (⣕)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28D6 (⣖)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28D7 (⣗)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D8 (⣘)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28D9 (⣙)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28DA (⣚)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00 },	// U+28DB (⣛)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28DC (⣜)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28DD (⣝)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28DE (⣞)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00 },	// U+28DF (⣟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28E0 (⣠)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28E1 (⣡)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28E2 (⣢)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28E3 (⣣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28E4 (⣤)
	{ 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28E5 (⣥)
	{ 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28E6 (⣦)
	{ 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28E7 (⣧)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28E8 (⣨)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28E9 (⣩)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28EA (⣪)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28EB (⣫)
	{ 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28EC (⣬)
	{ 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28ED (⣭)
	{ 0x00, 0x30, 0x30, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28EE (⣮)
	{ 0x00, 0x36, 0x36, 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28EF (⣯)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28F0 (⣰)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28F1 (⣱)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28F2 (⣲)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28F3 (⣳)
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28F4 (⣴)
	{ 0x00, 0x06, 0x06, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28F5 (⣵)
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28F6 (⣶)
	{ 0x00, 0x06, 0x06, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28F7 (⣷)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28F8 (⣸)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28F9 (⣹)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28FA (⣺)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00 },	// U+28FB (⣻)
	{ 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28FC (⣼)
	{ 0x00, 0x36, 0x36, 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28FD (⣽)
	{ 0x00, 0x30, 0x30, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28FE (⣾)
	{ 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x36, 0x36, 0x00 },	// U+28FF (⣿)
}; // 256

static const unsigned char cozette_block194[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x3f, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+294A (⥊)
}; // 1

static const unsigned char cozette_block195[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x5d, 0x5d, 0x5d, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+29BF (⦿)
}; // 1

static const unsigned char cozette_block196[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2a, 0x7f, 0x2a, 0x2a, 0x00, 0x00, 0x00, 0x00 },	// U+29FB (⧻)
}; // 1

static const unsigned char cozette_block197[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+2B22 (⬢)
}; // 1

static const unsigned char cozette_block198[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x14, 0x1c, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+2B50 (⭐)
}; // 1

static const unsigned char cozette_block199[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2B60 (⭠)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2B61 (⭡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x7e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2B62 (⭢)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2B63 (⭣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x7e, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+2B64 (⭤)
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+2B65 (⭥)
	{ 0x00, 0x00, 0x00, 0x0e, 0x06, 0x0a, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+2B66 (⭦)
	{ 0x00, 0x00, 0x00, 0x70, 0x60, 0x50, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+2B67 (⭧)
	{ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x50, 0x60, 0x70, 0x00, 0x00, 0x00, 0x00 },	// U+2B68 (⭨)
	{ 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x0a, 0x06, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+2B69 (⭩)
}; // 10

static const unsigned char cozette_block200[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x7e, 0x04, 0x20, 0x7e, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+2B80 (⮀)
	{ 0x00, 0x00, 0x00, 0x24, 0x2e, 0x24, 0x24, 0x74, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+2B81 (⮁)
	{ 0x00, 0x00, 0x00, 0x20, 0x7e, 0x20, 0x04, 0x7e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+2B82 (⮂)
	{ 0x00, 0x00, 0x00, 0x24, 0x74, 0x24, 0x24, 0x2e, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+2B83 (⮃)
}; // 4

static const unsigned char cozette_block201[][13] = {
	{ 0x00, 0x00, 0x00, 0x20, 0x52, 0x12, 0x12, 0x12, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+2C71 (ⱱ)
}; // 1

static const unsigned char cozette_block202[][13] = {
	{ 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00 },	// U+2E3D (⸽)
}; // 1

static const unsigned char cozette_block203[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+3000 (　)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+3001 (、)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00 },	// U+3002 (。)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x10, 0x10, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00 },	// U+3003 (〃)
}; // 4

static const unsigned char cozette_block204[][13] = {
	{ 0x00, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x08, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+3005 (々)
}; // 1

static const unsigned char cozette_block205[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+3008 (〈)
	{ 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00 },	// U+3009 (〉)
	{ 0x80, 0x80, 0x40, 0x40, 0xa0, 0xa0, 0xa0, 0x40, 0x40, 0x80, 0x80, 0x00, 0x00 },	// U+300A (《)
	{ 0x14, 0x14, 0x28, 0x28, 0x50, 0x50, 0x50, 0x28, 0x28, 0x14, 0x14, 0x00, 0x00 },	// U+300B (》)
	{ 0x00, 0xc0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+300C (「)
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+300D (」)
	{ 0xe0, 0x20, 0xa0, 0xa0, 0xa0, 0xa0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+300E (『)
	{ 0x00, 0x00, 0x00, 0x70, 0x50, 0x50, 0x50, 0x5c, 0x44, 0x7c, 0x00, 0x00, 0x00 },	// U+300F (』)
	{ 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00 },	// U+3010 (【)
	{ 0x1c, 0x18, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x18, 0x1c, 0x00, 0x00 },	// U+3011 (】)
}; // 10

static const unsigned char cozette_block206[][13] = {
	{ 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+3014 (〔)
	{ 0x0c, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x0c, 0x00, 0x00 },	// U+3015 (〕)
	{ 0xc0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x00, 0x00 },	// U+3016 (〖)
	{ 0x3e, 0x24, 0x24, 0x28, 0x28, 0x28, 0x28, 0x28, 0x24, 0x24, 0x3e, 0x00, 0x00 },	// U+3017 (〗)
	{ 0x80, 0xc0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x80, 0x00, 0x00 },	// U+3018 (〘)
	{ 0x1e, 0x34, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x34, 0x1e, 0x00, 0x00 },	// U+3019 (〙)
	{ 0xc0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x00, 0x00 },	// U+301A (〚)
	{ 0x3e, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x3e, 0x00, 0x00 },	// U+301B (〛)
}; // 8

static const unsigned char cozette_block207[][13] = {
	{ 0x00, 0x00, 0x00, 0x20, 0xf0, 0x20, 0xf0, 0xa8, 0x68, 0x30, 0x00, 0x00, 0x00 },	// U+3041 (ぁ)
}; // 1

static const unsigned char cozette_block208[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x50, 0x20, 0x00, 0x00, 0x00 },	// U+3043 (ぃ)
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x50, 0x20, 0x00, 0x00, 0x00 },	// U+3044 (い)
	{ 0x00, 0x00, 0x00, 0xe0, 0x00, 0xf0, 0x00, 0x00, 0x80, 0x60, 0x00, 0x00, 0x00 },	// U+3045 (ぅ)
	{ 0x00, 0x00, 0xf0, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x80, 0x70, 0x00, 0x00, 0x00 },	// U+3046 (う)
	{ 0x00, 0x00, 0x00, 0x60, 0x00, 0x70, 0x40, 0x20, 0x60, 0x90, 0x00, 0x00, 0x00 },	// U+3047 (ぇ)
	{ 0x00, 0x70, 0x00, 0x78, 0x40, 0x20, 0x20, 0x70, 0x90, 0x08, 0x00, 0x00, 0x00 },	// U+3048 (え)
	{ 0x00, 0x00, 0x00, 0x20, 0x7c, 0x20, 0xf0, 0xa8, 0x68, 0x30, 0x00, 0x00, 0x00 },	// U+3049 (ぉ)
}; // 7

static const unsigned char cozette_block209[][13] = {
	{ 0x00, 0x00, 0x10, 0x10, 0xfc, 0x10, 0x90, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+304D (き)
}; // 1

static const unsigned char cozette_block210[][13] = {
	{ 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00 },	// U+304F (く)
	{ 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00 },	// U+3050 (ぐ)
	{ 0x00, 0x04, 0x04, 0x04, 0xc4, 0x04, 0x04, 0x14, 0x14, 0xc8, 0x00, 0x00, 0x00 },	// U+3051 (け)
}; // 3

static const unsigned char cozette_block211[][13] = {
	{ 0x00, 0x00, 0xf8, 0x00, 0x80, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00 },	// U+3053 (こ)
}; // 1

static const unsigned char cozette_block212[][13] = {
	{ 0x00, 0x40, 0x40, 0xf0, 0x80, 0x00, 0x80, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00 },	// U+3055 (さ)
}; // 1

static const unsigned char cozette_block213[][13] = {
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00 },	// U+3057 (し)
	{ 0x00, 0x08, 0x48, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00 },	// U+3058 (じ)
	{ 0x00, 0x40, 0xfc, 0x40, 0x70, 0x48, 0x48, 0x70, 0x40, 0x20, 0x00, 0x00, 0x00 },	// U+3059 (す)
}; // 3

static const unsigned char cozette_block214[][13] = {
	{ 0x00, 0x40, 0xf0, 0x80, 0xf0, 0x00, 0x80, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00 },	// U+305B (せ)
}; // 1

static const unsigned char cozette_block215[][13] = {
	{ 0x00, 0xfc, 0x40, 0x20, 0xf0, 0x80, 0x40, 0x20, 0x20, 0xc0, 0x00, 0x00, 0x00 },	// U+305D (そ)
}; // 1

static const unsigned char cozette_block216[][13] = {
	{ 0x00, 0x40, 0x40, 0xf8, 0x20, 0x10, 0xf0, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00 },	// U+3061 (ち)
}; // 1

static const unsigned char cozette_block217[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x08, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00 },	// U+3063 (っ)
}; // 1

static const unsigned char cozette_block218[][13] = {
	{ 0x00, 0x00, 0xfc, 0x00, 0x80, 0x40, 0x20, 0x20, 0x20, 0xc0, 0x00, 0x00, 0x00 },	// U+3066 (て)
}; // 1

static const unsigned char cozette_block219[][13] = {
	{ 0x00, 0x08, 0x10, 0xa0, 0x40, 0x20, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+3068 (と)
	{ 0x00, 0x08, 0x10, 0xa0, 0x40, 0x20, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+3069 (ど)
}; // 2

static const unsigned char cozette_block220[][13] = {
	{ 0x00, 0x84, 0x84, 0xe4, 0x84, 0x84, 0x84, 0xc4, 0x24, 0xc8, 0x00, 0x00, 0x00 },	// U+306F (は)
}; // 1

static const unsigned char cozette_block221[][13] = {
	{ 0x00, 0xe4, 0x84, 0xe4, 0x84, 0x84, 0x84, 0xc4, 0x24, 0xc8, 0x00, 0x00, 0x00 },	// U+307B (ほ)
}; // 1

static const unsigned char cozette_block222[][13] = {
	{ 0x00, 0xf0, 0x80, 0xf0, 0x80, 0x80, 0x80, 0xe0, 0x90, 0x60, 0x00, 0x00, 0x00 },	// U+307E (ま)
}; // 1

static const unsigned char cozette_block223[][13] = {
	{ 0x00, 0x20, 0xf8, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x20, 0xc0, 0x00, 0x00, 0x00 },	// U+3082 (も)
	{ 0x00, 0x00, 0x00, 0x80, 0xd0, 0xb8, 0x10, 0x90, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+3083 (ゃ)
	{ 0x00, 0x80, 0xd0, 0xb8, 0x10, 0x20, 0x20, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+3084 (や)
	{ 0x00, 0x00, 0x00, 0x88, 0xe8, 0x98, 0x88, 0x88, 0xe8, 0x40, 0x00, 0x00, 0x00 },	// U+3085 (ゅ)
}; // 4

static const unsigned char cozette_block224[][13] = {
	{ 0x00, 0x00, 0x00, 0x40, 0x40, 0xc0, 0x40, 0x60, 0x90, 0x60, 0x00, 0x00, 0x00 },	// U+3087 (ょ)
	{ 0x00, 0x40, 0x40, 0xc0, 0x40, 0x40, 0x40, 0x70, 0x88, 0x70, 0x00, 0x00, 0x00 },	// U+3088 (よ)
	{ 0x00, 0x60, 0x80, 0x10, 0x10, 0x08, 0xf8, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00 },	// U+3089 (ら)
	{ 0x00, 0x10, 0xd0, 0x30, 0x30, 0x10, 0x10, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00 },	// U+308A (り)
	{ 0x00, 0xf8, 0x40, 0x20, 0xf0, 0x00, 0x00, 0x30, 0x48, 0xf0, 0x00, 0x00, 0x00 },	// U+308B (る)
}; // 5

static const unsigned char cozette_block225[][13] = {
	{ 0x00, 0xf8, 0x40, 0x20, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00 },	// U+308D (ろ)
	{ 0x00, 0x00, 0x00, 0x10, 0x38, 0xb0, 0x50, 0x38, 0x18, 0x98, 0x00, 0x00, 0x00 },	// U+308E (ゎ)
}; // 2

static const unsigned char cozette_block226[][13] = {
	{ 0x00, 0x10, 0x7c, 0x10, 0xb0, 0x40, 0xa0, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+3092 (を)
	{ 0x00, 0x20, 0x20, 0x20, 0x10, 0x10, 0x30, 0x48, 0x48, 0x88, 0x00, 0x00, 0x00 },	// U+3093 (ん)
	{ 0x00, 0xf0, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x70, 0x00, 0x00, 0x00 },	// U+3094 (ゔ)
	{ 0x00, 0x00, 0x00, 0x20, 0xf8, 0x20, 0x20, 0x10, 0x10, 0xd0, 0x00, 0x00, 0x00 },	// U+3095 (ゕ)
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x88, 0x08, 0x08, 0x28, 0x90, 0x00, 0x00, 0x00 },	// U+3096 (ゖ)
}; // 5

static const unsigned char cozette_block227[][13] = {
	{ 0x00, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+309B (゛)
	{ 0x00, 0x04, 0x0a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+309C (゜)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x80, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+309D (ゝ)
	{ 0x00, 0x00, 0x00, 0x00, 0x90, 0x20, 0x40, 0x80, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+309E (ゞ)
	{ 0x00, 0x80, 0x80, 0xc0, 0x40, 0xe0, 0x20, 0x10, 0x10, 0xc8, 0x00, 0x00, 0x00 },	// U+309F (ゟ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+30A0 (゠)
	{ 0x00, 0x00, 0x00, 0xf8, 0x00, 0x40, 0x40, 0x40, 0x20, 0x10, 0x00, 0x00, 0x00 },	// U+30A1 (ァ)
}; // 7

static const unsigned char cozette_block228[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x78, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+30A3 (ィ)
}; // 1

static const unsigned char cozette_block229[][13] = {
	{ 0x00, 0x00, 0x00, 0x40, 0xf8, 0x08, 0x08, 0x00, 0x80, 0x60, 0x00, 0x00, 0x00 },	// U+30A5 (ゥ)
	{ 0x00, 0x40, 0x40, 0xf8, 0x08, 0x08, 0x00, 0x00, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+30A6 (ウ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf0, 0x40, 0x40, 0x40, 0x40, 0xf8, 0x00, 0x00, 0x00 },	// U+30A7 (ェ)
}; // 3

static const unsigned char cozette_block230[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xf0, 0x80, 0x40, 0x20, 0x10, 0x80, 0x00, 0x00, 0x00 },	// U+30A9 (ォ)
	{ 0x00, 0x00, 0x00, 0xfc, 0x80, 0x40, 0x20, 0x10, 0x08, 0xc0, 0x00, 0x00, 0x00 },	// U+30AA (オ)
	{ 0x00, 0x10, 0x10, 0xfc, 0x10, 0x10, 0x10, 0x10, 0x08, 0xc8, 0x00, 0x00, 0x00 },	// U+30AB (カ)
}; // 3

static const unsigned char cozette_block231[][13] = {
	{ 0x00, 0x20, 0xe0, 0x38, 0x40, 0x40, 0xc0, 0x78, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+30AD (キ)
}; // 1

static const unsigned char cozette_block232[][13] = {
	{ 0x00, 0x10, 0xf0, 0x08, 0x04, 0x00, 0x00, 0x00, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+30AF (ク)
}; // 1

static const unsigned char cozette_block233[][13] = {
	{ 0x00, 0x10, 0xf0, 0x48, 0x44, 0x40, 0x40, 0x20, 0x20, 0x10, 0x00, 0x00, 0x00 },	// U+30B1 (ケ)
}; // 1

static const unsigned char cozette_block234[][13] = {
	{ 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00 },	// U+30B3 (コ)
}; // 1

static const unsigned char cozette_block235[][13] = {
	{ 0x00, 0x00, 0x18, 0x20, 0x00, 0x0c, 0x10, 0x00, 0xc0, 0x38, 0x00, 0x00, 0x00 },	// U+30B7 (シ)
}; // 1

static const unsigned char cozette_block236[][13] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0xc0, 0x38, 0x00, 0x00, 0x00 },	// U+30BD (ソ)
}; // 1

static const unsigned char cozette_block237[][13] = {
	{ 0x00, 0x10, 0xf0, 0x08, 0x04, 0x10, 0x20, 0x40, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+30BF (タ)
}; // 1

static const unsigned char cozette_block238[][13] = {
	{ 0x00, 0xf8, 0x40, 0x40, 0xfc, 0x40, 0x40, 0x40, 0x40, 0x30, 0x00, 0x00, 0x00 },	// U+30C1 (チ)
}; // 1

static const unsigned char cozette_block239[][13] = {
	{ 0x00, 0x00, 0x00, 0x20, 0x28, 0x48, 0x10, 0x00, 0xc0, 0x38, 0x00, 0x00, 0x00 },	// U+30C3 (ッ)
	{ 0x00, 0x00, 0x20, 0x20, 0x44, 0x04, 0x08, 0x00, 0xc0, 0x38, 0x00, 0x00, 0x00 },	// U+30C4 (ツ)
}; // 2

static const unsigned char cozette_block240[][13] = {
	{ 0x00, 0xf8, 0x00, 0x00, 0xfc, 0x40, 0x40, 0x40, 0x40, 0x30, 0x00, 0x00, 0x00 },	// U+30C6 (テ)
}; // 1

static const unsigned char cozette_block241[][13] = {
	{ 0x00, 0x20, 0x20, 0x20, 0xe0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+30C8 (ト)
	{ 0x00, 0x10, 0x90, 0x10, 0x70, 0x90, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+30C9 (ド)
	{ 0x00, 0x40, 0x40, 0x40, 0xfc, 0x40, 0x40, 0x40, 0x40, 0x30, 0x00, 0x00, 0x00 },	// U+30CA (ナ)
}; // 3

static const unsigned char cozette_block242[][13] = {
	{ 0x00, 0x00, 0xfc, 0x00, 0x00, 0x10, 0x20, 0x40, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+30CC (ヌ)
}; // 1

static const unsigned char cozette_block243[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x38, 0x00, 0x00, 0x00 },	// U+30CE (ノ)
	{ 0x00, 0x00, 0x90, 0x90, 0x10, 0x10, 0x08, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00 },	// U+30CF (ハ)
}; // 2

static const unsigned char cozette_block244[][13] = {
	{ 0x00, 0x08, 0x08, 0x08, 0xc8, 0x38, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00 },	// U+30D2 (ヒ)
	{ 0x00, 0x08, 0x08, 0x08, 0xc8, 0x38, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00 },	// U+30D3 (ビ)
}; // 2

static const unsigned char cozette_block245[][13] = {
	{ 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+30D5 (フ)
}; // 1

static const unsigned char cozette_block246[][13] = {
	{ 0x00, 0x00, 0xfc, 0x00, 0x00, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+30DE (マ)
	{ 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x78, 0x80, 0x00, 0x00, 0x00 },	// U+30DF (ミ)
}; // 2

static const unsigned char cozette_block247[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+30E1 (メ)
	{ 0x00, 0x00, 0xf8, 0x20, 0x20, 0xfc, 0x20, 0x20, 0x20, 0xc0, 0x00, 0x00, 0x00 },	// U+30E2 (モ)
	{ 0x00, 0x00, 0x00, 0x10, 0x90, 0x78, 0x20, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+30E3 (ャ)
}; // 3

static const unsigned char cozette_block248[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00 },	// U+30E5 (ュ)
}; // 1

static const unsigned char cozette_block249[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00 },	// U+30E7 (ョ)
	{ 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00 },	// U+30E8 (ヨ)
	{ 0x00, 0xf8, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+30E9 (ラ)
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x80, 0x60, 0x00, 0x00, 0x00 },	// U+30EA (リ)
}; // 4

static const unsigned char cozette_block250[][13] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xc8, 0x38, 0x00, 0x00, 0x00 },	// U+30EC (レ)
}; // 1

static const unsigned char cozette_block251[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x00, 0x80, 0x60, 0x00, 0x00, 0x00 },	// U+30EE (ヮ)
	{ 0x00, 0x00, 0xfc, 0x04, 0x04, 0x00, 0x00, 0x00, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+30EF (ワ)
	{ 0x00, 0x00, 0x80, 0xf8, 0x90, 0x90, 0x90, 0xfc, 0x80, 0x80, 0x00, 0x00, 0x00 },	// U+30F0 (ヰ)
}; // 3

static const unsigned char cozette_block252[][13] = {
	{ 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xc0, 0x30, 0x00, 0x00, 0x00 },	// U+30F2 (ヲ)
	{ 0x00, 0x00, 0x00, 0x1c, 0x20, 0x00, 0x00, 0x00, 0xc0, 0x38, 0x00, 0x00, 0x00 },	// U+30F3 (ン)
}; // 2

static const unsigned char cozette_block253[][13] = {
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x20, 0x90, 0x00, 0x00, 0x00 },	// U+30F5 (ヵ)
	{ 0x00, 0x00, 0x00, 0x10, 0xf0, 0x50, 0x48, 0x40, 0x40, 0x20, 0x00, 0x00, 0x00 },	// U+30F6 (ヶ)
}; // 2

static const unsigned char cozette_block254[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xe0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+30FB (・)
}; // 1

static const unsigned char cozette_block255[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+30FD (ヽ)
	{ 0x00, 0x00, 0x00, 0x00, 0x90, 0x20, 0x40, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00 },	// U+30FE (ヾ)
}; // 2

static const unsigned char cozette_block256[][13] = {
	{ 0x00, 0x00, 0x03, 0x02, 0x02, 0x1a, 0x2a, 0x2a, 0x2a, 0x2f, 0x00, 0x00, 0x00 },	// U+33D1 (㏑)
}; // 1

static const unsigned char cozette_block257[][13] = {
	{ 0x00, 0x00, 0x3c, 0x02, 0x32, 0x1c, 0x26, 0x20, 0x20, 0x1e, 0x00, 0x00, 0x00 },	// U+A7A8 (Ꞩ)
}; // 1

static const unsigned char cozette_block258[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x36, 0x00, 0x00, 0x00 },	// U+AB65 (ꭥ)
}; // 1

static const unsigned char cozette_block259[][13] = {
	{ 0x00, 0x00, 0x22, 0x7f, 0x2a, 0x7f, 0x22, 0x22, 0x41, 0x41, 0x41, 0x00, 0x00 },	// U+E000 ()
	{ 0x00, 0x00, 0x04, 0x08, 0x3e, 0x4f, 0x5f, 0x7f, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+E001 ()
	{ 0x00, 0x00, 0x04, 0x08, 0x3e, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+E002 ()
	{ 0x00, 0x00, 0x04, 0x08, 0x3e, 0x7f, 0x7b, 0x77, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+E003 ()
	{ 0x00, 0x00, 0x04, 0x08, 0x3e, 0x41, 0x41, 0x7f, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+E004 ()
	{ 0x00, 0x04, 0x02, 0x04, 0x00, 0x7f, 0x5f, 0x7f, 0x1f, 0x0e, 0x00, 0x00, 0x00 },	// U+E005 ()
	{ 0x00, 0x00, 0x3e, 0x7c, 0x1a, 0x28, 0x04, 0x04, 0x1e, 0x3f, 0x00, 0x00, 0x00 },	// U+E006 ()
	{ 0x00, 0x00, 0x06, 0x0f, 0x0a, 0x0f, 0x1f, 0x7f, 0x3e, 0x1e, 0x0c, 0x00, 0x00 },	// U+E007 ()
	{ 0x00, 0x00, 0x04, 0x00, 0x36, 0x73, 0x7b, 0x73, 0x36, 0x14, 0x00, 0x00, 0x00 },	// U+E008 ()
	{ 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x00 },	// U+E009 ()
	{ 0x00, 0x00, 0x3c, 0x1c, 0x0c, 0x3e, 0x3e, 0x18, 0x0c, 0x04, 0x00, 0x00, 0x00 },	// U+E00A ()
}; // 11

static const unsigned char cozette_block260[][13] = {
	{ 0x00, 0x00, 0x02, 0x12, 0x3a, 0x12, 0x12, 0x0a, 0x04, 0x02, 0x02, 0x02, 0x00 },	// U+E0A0 ()
	{ 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x1e, 0x00, 0x24, 0x2c, 0x34, 0x24, 0x00 },	// U+E0A1 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x14, 0x14, 0x3e, 0x36, 0x36, 0x3e, 0x3e, 0x00, 0x00 },	// U+E0A2 ()
	{ 0x00, 0x00, 0x0c, 0x12, 0x02, 0x12, 0x0c, 0x00, 0x24, 0x2c, 0x34, 0x24, 0x00 },	// U+E0A3 ()
}; // 4

static const unsigned char cozette_block261[][13] = {
	{ 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01 },	// U+E0B0 ()
	{ 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01 },	// U+E0B1 ()
	{ 0x40, 0x60, 0x70, 0x78, 0x7c, 0x7e, 0x7f, 0x7e, 0x7c, 0x78, 0x70, 0x60, 0x40 },	// U+E0B2 ()
	{ 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40 },	// U+E0B3 ()
	{ 0x07, 0x1f, 0x3f, 0x3f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x3f, 0x3f, 0x1f, 0x07 },	// U+E0B4 ()
	{ 0x07, 0x1c, 0x38, 0x30, 0x60, 0x60, 0x60, 0x60, 0x60, 0x30, 0x38, 0x1c, 0x07 },	// U+E0B5 ()
	{ 0x70, 0x7c, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7c, 0x70 },	// U+E0B6 ()
	{ 0x70, 0x1c, 0x0e, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x0e, 0x1c, 0x70 },	// U+E0B7 ()
	{ 0x01, 0x01, 0x03, 0x03, 0x07, 0x07, 0x0f, 0x0f, 0x0f, 0x1f, 0x1f, 0x3f, 0x3f },	// U+E0B8 ()
	{ 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40 },	// U+E0B9 ()
	{ 0x20, 0x20, 0x30, 0x30, 0x38, 0x38, 0x3c, 0x3c, 0x3c, 0x3e, 0x3e, 0x3f, 0x3f },	// U+E0BA ()
	{ 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01 },	// U+E0BB ()
	{ 0x3f, 0x3f, 0x1f, 0x1f, 0x0f, 0x0f, 0x07, 0x07, 0x07, 0x03, 0x03, 0x01, 0x01 },	// U+E0BC ()
	{ 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01 },	// U+E0BD ()
	{ 0x3f, 0x3f, 0x3e, 0x3e, 0x3c, 0x3c, 0x38, 0x38, 0x38, 0x30, 0x30, 0x20, 0x20 },	// U+E0BE ()
	{ 0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40 },	// U+E0BF ()
}; // 16

static const unsigned char cozette_block262[][13] = {
	{ 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f },	// U+E0D2 ()
}; // 1

static const unsigned char cozette_block263[][13] = {
	{ 0x7e, 0x7c, 0x78, 0x70, 0x60, 0x40, 0x00, 0x40, 0x60, 0x70, 0x78, 0x7c, 0x7e },	// U+E0D4 ()
}; // 1

static const unsigned char cozette_block264[][13] = {
	{ 0x08, 0x08, 0x14, 0x0a, 0x14, 0x61, 0xbf, 0x7e, 0x1e, 0x41, 0x3e, 0x00, 0x00 },	// U+E204 ()
}; // 1

static const unsigned char cozette_block265[][13] = {
	{ 0x08, 0x14, 0x14, 0x14, 0x14, 0x1c, 0x1c, 0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x00 },	// U+E20A ()
	{ 0x08, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x00 },	// U+E20B ()
	{ 0x08, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x00 },	// U+E20C ()
}; // 3

static const unsigned char cozette_block266[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x13, 0x0c, 0x1c, 0x36, 0x23, 0x00, 0x00, 0x00 },	// U+E20F ()
}; // 1

static const unsigned char cozette_block267[][13] = {
	{ 0x00, 0x00, 0x00, 0x28, 0x0c, 0x2e, 0x37, 0x38, 0x3d, 0x00, 0x00, 0x00, 0x00 },	// U+E21E ()
}; // 1

static const unsigned char cozette_block268[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x15, 0x14, 0x14, 0x14, 0x26, 0x00, 0x00, 0x00 },	// U+E22C ()
}; // 1

static const unsigned char cozette_block269[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x18, 0x5f, 0x63, 0x7d, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+E235 ()
}; // 1

static const unsigned char cozette_block270[][13] = {
	{ 0x00, 0x00, 0x00, 0x7e, 0x7f, 0x61, 0x69, 0x61, 0x75, 0x3f, 0x00, 0x00, 0x00 },	// U+E244 ()
}; // 1

static const unsigned char cozette_block271[][13] = {
	{ 0x08, 0x08, 0x14, 0x0a, 0x14, 0x61, 0xbf, 0x7e, 0x1e, 0x41, 0x3e, 0x00, 0x00 },	// U+E256 ()
}; // 1

static const unsigned char cozette_block272[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x77, 0x6b, 0x77, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+E271 ()
}; // 1

static const unsigned char cozette_block273[][13] = {
	{ 0x00, 0x00, 0x00, 0x7e, 0x52, 0x5e, 0x5f, 0x2f, 0x2f, 0x3f, 0x00, 0x00, 0x00 },	// U+E28A ()
	{ 0x00, 0x00, 0x00, 0x7e, 0x52, 0x5e, 0x5f, 0x2f, 0x2f, 0x3f, 0x00, 0x00, 0x00 },	// U+E28B ()
}; // 2

static const unsigned char cozette_block274[][13] = {
	{ 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x21, 0x29, 0x29, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+E5FA ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x36, 0x2a, 0x36, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+E5FB ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2a, 0x36, 0x2a, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+E5FC ()
	{ 0x00, 0x00, 0x00, 0x1f, 0x2d, 0x21, 0x2d, 0x33, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+E5FD ()
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x01, 0x3e, 0x3f, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+E5FE ()
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+E5FF ()
	{ 0x40, 0x20, 0x10, 0x10, 0x10, 0x16, 0x14, 0x34, 0x04, 0x04, 0x04, 0x02, 0x01 },	// U+E600 ()
	{ 0x00, 0x00, 0x00, 0x0f, 0x00, 0x36, 0x00, 0x6c, 0x00, 0x2e, 0x00, 0x00, 0x00 },	// U+E601 ()
	{ 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01 },	// U+E602 ()
	{ 0x00, 0x00, 0x38, 0x46, 0x41, 0x25, 0x19, 0x02, 0x34, 0x0c, 0x0a, 0x06, 0x00 },	// U+E603 ()
	{ 0x00, 0x00, 0x20, 0x38, 0x5a, 0x0c, 0x1d, 0x0e, 0x1e, 0x0f, 0x1e, 0x00, 0x00 },	// U+E604 ()
	{ 0x00, 0x00, 0x00, 0x38, 0x3c, 0x3e, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+E605 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x18, 0x5f, 0x63, 0x7d, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+E606 ()
	{ 0x00, 0x00, 0x63, 0x33, 0x03, 0x3b, 0x7f, 0x67, 0x60, 0x61, 0x63, 0x61, 0x00 },	// U+E607 ()
	{ 0x00, 0x00, 0x00, 0x2e, 0x6f, 0x75, 0x7f, 0x3a, 0x2a, 0x29, 0x00, 0x00, 0x00 },	// U+E608 ()
	{ 0x00, 0x00, 0x22, 0x36, 0x3e, 0x3e, 0x3e, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00 },	// U+E609 ()
	{ 0x00, 0x00, 0x1c, 0x22, 0x26, 0x2b, 0x1f, 0x1f, 0x1e, 0x33, 0x33, 0x21, 0x00 },	// U+E60A ()
	{ 0x00, 0x00, 0x14, 0x22, 0x22, 0x22, 0x41, 0x22, 0x22, 0x22, 0x14, 0x00, 0x00 },	// U+E60B ()
	{ 0x00, 0x00, 0x00, 0x32, 0x4a, 0x0a, 0x32, 0x42, 0x4a, 0x31, 0x00, 0x00, 0x00 },	// U+E60C ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x7f, 0x43, 0x6b, 0x5f, 0x7e, 0x00, 0x00, 0x00 },	// U+E60D ()
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x22, 0x41, 0x22, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+E60E ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5d, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+E60F ()
	{ 0x00, 0x00, 0x02, 0x04, 0x04, 0x3e, 0x3e, 0x3e, 0x3e, 0x1c, 0x1c, 0x1c, 0x00 },	// U+E610 ()
	{ 0x00, 0x00, 0x6b, 0x3e, 0x3e, 0x3e, 0x7f, 0x3e, 0x5d, 0x7f, 0x1c, 0x00, 0x00 },	// U+E611 ()
	{ 0x00, 0x00, 0x00, 0x3e, 0x00, 0x1e, 0x00, 0x3e, 0x00, 0x0e, 0x00, 0x00, 0x00 },	// U+E612 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+E613 ()
	{ 0x00, 0x00, 0x28, 0x28, 0x7e, 0x14, 0x14, 0x3f, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+E614 ()
	{ 0x00, 0x00, 0x00, 0x14, 0x3e, 0x7f, 0x36, 0x7f, 0x3e, 0x14, 0x00, 0x00, 0x00 },	// U+E615 ()
	{ 0x00, 0x00, 0x00, 0x3f, 0x21, 0x29, 0x29, 0x29, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+E616 ()
	{ 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x77, 0x77, 0x77, 0x41, 0x00, 0x00, 0x00 },	// U+E617 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x14, 0x22, 0x41, 0x22, 0x14, 0x00, 0x00, 0x00, 0x00 },	// U+E618 ()
	{ 0x00, 0x00, 0x00, 0x0f, 0x18, 0x37, 0x2c, 0x2b, 0x2b, 0x00, 0x00, 0x00, 0x00 },	// U+E619 ()
	{ 0x00, 0x00, 0x4e, 0x3f, 0x1b, 0x7f, 0x4f, 0x31, 0x1a, 0x1c, 0x00, 0x00, 0x00 },	// U+E61A ()
	{ 0x00, 0x00, 0x00, 0x3c, 0x42, 0x7e, 0x7f, 0x3d, 0x3f, 0x3c, 0x00, 0x00, 0x00 },	// U+E61B ()
	{ 0x00, 0x00, 0x20, 0x10, 0x10, 0x18, 0x58, 0x3a, 0x3c, 0x1d, 0x19, 0x19, 0x00 },	// U+E61C ()
	{ 0x00, 0x00, 0x00, 0x06, 0x01, 0x29, 0x7d, 0x29, 0x01, 0x06, 0x00, 0x00, 0x00 },	// U+E61D ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x36, 0x6b, 0x7b, 0x6b, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+E61E ()
	{ 0x00, 0x00, 0x00, 0x00, 0x05, 0x75, 0x0a, 0x6a, 0x15, 0x15, 0x00, 0x00, 0x00 },	// U+E61F ()
	{ 0x00, 0x00, 0x00, 0x2e, 0x71, 0x2e, 0x57, 0x5f, 0x5f, 0x2e, 0x00, 0x00, 0x00 },	// U+E620 ()
	{ 0x00, 0x08, 0x08, 0x00, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08 },	// U+E621 ()
	{ 0x00, 0x00, 0x00, 0x67, 0x77, 0x3f, 0x1f, 0x1e, 0x3e, 0x74, 0x64, 0x00, 0x00 },	// U+E622 ()
	{ 0x00, 0x00, 0x08, 0x08, 0x08, 0x7f, 0x1c, 0x1c, 0x36, 0x22, 0x00, 0x00, 0x00 },	// U+E623 ()
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x22, 0x77, 0x22, 0x00, 0x00, 0x00, 0x00 },	// U+E624 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x2a, 0x55, 0x55, 0x2a, 0x36, 0x00, 0x00, 0x00 },	// U+E625 ()
	{ 0x00, 0x10, 0x1c, 0x2f, 0x3a, 0x3e, 0x7c, 0x3c, 0x3c, 0x3e, 0x7e, 0x1c, 0x10 },	// U+E626 ()
	{ 0x00, 0x00, 0x5d, 0x3e, 0x2a, 0x36, 0x3e, 0x7f, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+E627 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x77, 0x0a, 0x32, 0x42, 0x3a, 0x00, 0x00, 0x00, 0x00 },	// U+E628 ()
}; // 47

static const unsigned char cozette_block275[][13] = {
	{ 0x00, 0x00, 0x00, 0xf0, 0xf7, 0xf7, 0x00, 0xf7, 0xf7, 0xf0, 0x00, 0x00, 0x00 },	// U+E62A ()
	{ 0x00, 0x00, 0x00, 0x77, 0x66, 0x36, 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00 },	// U+E62B ()
	{ 0x00, 0x00, 0x00, 0x6e, 0x5d, 0x2b, 0x77, 0x2b, 0x5d, 0x3e, 0x00, 0x00, 0x00 },	// U+E62C ()
	{ 0x00, 0x08, 0x0c, 0x0e, 0x0e, 0x1f, 0x3f, 0x3f, 0x3f, 0x3d, 0x1e, 0x00, 0x00 },	// U+E62D ()
}; // 4

static const unsigned char cozette_block276[][13] = {
	{ 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0x00, 0x00, 0x00 },	// U+E634 ()
}; // 1

static const unsigned char cozette_block277[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+E63A ()
}; // 1

static const unsigned char cozette_block278[][13] = {
	{ 0x00, 0x00, 0x00, 0x32, 0x4a, 0x0a, 0x32, 0x42, 0x4a, 0x31, 0x00, 0x00, 0x00 },	// U+E64E ()
}; // 1

static const unsigned char cozette_block279[][13] = {
	{ 0x00, 0x00, 0x00, 0x32, 0x4a, 0x0a, 0x32, 0x42, 0x4a, 0x31, 0x00, 0x00, 0x00 },	// U+E681 ()
}; // 1

static const unsigned char cozette_block280[][13] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x26, 0x01, 0x19, 0x26, 0x20, 0x19, 0x06, 0x00, 0x00 },	// U+E697 ()
}; // 1

static const unsigned char cozette_block281[][13] = {
	{ 0x00, 0x00, 0x00, 0x40, 0x7b, 0x31, 0x59, 0x4d, 0x46, 0x6f, 0x01, 0x00, 0x00 },	// U+E6A9 ()
}; // 1

static const unsigned char cozette_block282[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x26, 0x57, 0x36, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+E702 ()
	{ 0x00, 0x3e, 0x63, 0x7f, 0x7f, 0x36, 0x2a, 0x36, 0x1c, 0x22, 0x1c, 0x00, 0x00 },	// U+E703 ()
}; // 2

static const unsigned char cozette_block283[][13] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x7f, 0x3e, 0x41, 0x3e, 0x41, 0x3e, 0x00, 0x00, 0x00 },	// U+E706 ()
	{ 0x00, 0x00, 0x00, 0x22, 0x77, 0x22, 0x77, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+E707 ()
}; // 2

static const unsigned char cozette_block284[][13] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x7b, 0x6f, 0x65, 0x6f, 0x7b, 0x30, 0x00, 0x00, 0x00 },	// U+E70C ()
}; // 1

static const unsigned char cozette_block285[][13] = {
	{ 0x00, 0x00, 0x00, 0x41, 0x22, 0x3e, 0x7f, 0x5d, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+E70E ()
	{ 0x00, 0x00, 0x00, 0xf0, 0xf7, 0xf7, 0x00, 0xf7, 0xf7, 0xf0, 0x00, 0x00, 0x00 },	// U+E70F ()
}; // 2

static const unsigned char cozette_block286[][13] = {
	{ 0x00, 0x00, 0x10, 0x08, 0x3e, 0x1f, 0x1f, 0x1f, 0x3e, 0x36, 0x00, 0x00, 0x00 },	// U+E711 ()
	{ 0x00, 0x00, 0x1c, 0x2a, 0x3e, 0x32, 0x3e, 0x63, 0x55, 0x3e, 0x00, 0x00, 0x00 },	// U+E712 ()
}; // 2

static const unsigned char cozette_block287[][13] = {
	{ 0x00, 0x00, 0x08, 0x3e, 0x6b, 0x5d, 0x63, 0x5d, 0x6b, 0x3e, 0x08, 0x00, 0x00 },	// U+E716 ()
}; // 1

static const unsigned char cozette_block288[][13] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x77, 0x63, 0x63, 0x63, 0x41, 0x00, 0x00, 0x00 },	// U+E718 ()
}; // 1

static const unsigned char cozette_block289[][13] = {
	{ 0x00, 0x00, 0x00, 0x7e, 0x42, 0x52, 0x52, 0x52, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+E71E ()
}; // 1

static const unsigned char cozette_block290[][13] = {
	{ 0x00, 0x22, 0x55, 0xa2, 0x22, 0x22, 0xa2, 0x9e, 0x02, 0x05, 0x82, 0x00, 0x00 },	// U+E725 ()
	{ 0x00, 0x0a, 0x3d, 0x2a, 0x22, 0x22, 0xa2, 0xa2, 0x22, 0xd5, 0xa2, 0x00, 0x00 },	// U+E726 ()
	{ 0x00, 0x02, 0x85, 0x02, 0x22, 0x5e, 0xa2, 0x02, 0x82, 0x85, 0x82, 0x00, 0x00 },	// U+E727 ()
	{ 0x00, 0x1a, 0x1d, 0x1a, 0x12, 0x12, 0x12, 0x12, 0x16, 0x2e, 0x16, 0x00, 0x00 },	// U+E728 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x77, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+E729 ()
}; // 5

static const unsigned char cozette_block291[][13] = {
	{ 0x00, 0x00, 0x38, 0x31, 0x2d, 0x79, 0x63, 0x4e, 0x62, 0x0e, 0x00, 0x00, 0x00 },	// U+E72D ()
}; // 1

static const unsigned char cozette_block292[][13] = {
	{ 0x00, 0x00, 0x7f, 0x41, 0x7d, 0x41, 0x5f, 0x41, 0x3e, 0x08, 0x00, 0x00, 0x00 },	// U+E736 ()
	{ 0x00, 0x00, 0x30, 0x3f, 0x0f, 0x30, 0x3f, 0x0f, 0x30, 0x3f, 0x0f, 0x00, 0x00 },	// U+E737 ()
	{ 0x08, 0x08, 0x14, 0x0a, 0x14, 0x61, 0xbf, 0x7e, 0x1e, 0x41, 0x3e, 0x00, 0x00 },	// U+E738 ()
	{ 0x00, 0x00, 0x00, 0x28, 0x0c, 0x2e, 0x37, 0x38, 0x3d, 0x00, 0x00, 0x00, 0x00 },	// U+E739 ()
	{ 0x00, 0x00, 0x00, 0x2e, 0x67, 0x5d, 0x7c, 0x5d, 0x67, 0x2e, 0x00, 0x00, 0x00 },	// U+E73A ()
	{ 0x00, 0x00, 0x20, 0x38, 0x5a, 0x0c, 0x1d, 0x0e, 0x1e, 0x0f, 0x1e, 0x00, 0x00 },	// U+E73B ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x18, 0x5f, 0x63, 0x7d, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+E73C ()
	{ 0x00, 0x00, 0x00, 0x04, 0x04, 0x7f, 0x77, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00 },	// U+E73D ()
	{ 0x00, 0x00, 0x00, 0x00, 0x25, 0x27, 0x27, 0x75, 0x25, 0x00, 0x00, 0x00, 0x00 },	// U+E73E ()
	{ 0x00, 0x00, 0x07, 0x05, 0x05, 0x05, 0x75, 0x55, 0x7f, 0x14, 0x1c, 0x00, 0x00 },	// U+E73F ()
}; // 10

static const unsigned char cozette_block293[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x3c, 0x05, 0x6b, 0x77, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+E743 ()
}; // 1

static const unsigned char cozette_block294[][13] = {
	{ 0x00, 0x00, 0x00, 0x15, 0x37, 0x6f, 0x63, 0x6f, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+E745 ()
	{ 0x00, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x63, 0x63, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+E746 ()
}; // 2

static const unsigned char cozette_block295[][13] = {
	{ 0x00, 0x00, 0x28, 0x28, 0x7e, 0x14, 0x14, 0x3f, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+E749 ()
	{ 0x00, 0x00, 0x28, 0x28, 0x7e, 0x14, 0x14, 0x3f, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+E74A ()
}; // 2

static const unsigned char cozette_block296[][13] = {
	{ 0x00, 0x00, 0x00, 0x32, 0x4a, 0x0a, 0x32, 0x42, 0x4a, 0x31, 0x00, 0x00, 0x00 },	// U+E74E ()
}; // 1

static const unsigned char cozette_block297[][13] = {
	{ 0x00, 0x00, 0x00, 0x12, 0x25, 0x6e, 0x7c, 0x79, 0x3e, 0x5c, 0x00, 0x00, 0x00 },	// U+E755 ()
	{ 0x00, 0x00, 0x30, 0x10, 0x10, 0x56, 0x39, 0x12, 0x14, 0x13, 0x08, 0x00, 0x00 },	// U+E756 ()
	{ 0x00, 0x00, 0x30, 0x10, 0x10, 0x56, 0x39, 0x12, 0x14, 0x13, 0x08, 0x00, 0x00 },	// U+E757 ()
	{ 0x00, 0x00, 0x28, 0x28, 0x7e, 0x14, 0x14, 0x3f, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+E758 ()
	{ 0x40, 0x20, 0x10, 0x10, 0x10, 0x16, 0x14, 0x34, 0x04, 0x04, 0x04, 0x02, 0x01 },	// U+E759 ()
}; // 5

static const unsigned char cozette_block298[][13] = {
	{ 0x00, 0x00, 0x00, 0x73, 0x5d, 0x26, 0x6b, 0x26, 0x5d, 0x73, 0x00, 0x00, 0x00 },	// U+E764 ()
}; // 1

static const unsigned char cozette_block299[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x38, 0x77, 0x77, 0x6b, 0x1e, 0x1c, 0x00, 0x00, 0x00 },	// U+E768 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1b, 0x3a, 0x7e, 0x3c, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+E769 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x38, 0x77, 0x77, 0x6b, 0x1e, 0x1c, 0x00, 0x00, 0x00 },	// U+E76A ()
}; // 3

static const unsigned char cozette_block300[][13] = {
	{ 0x00, 0x00, 0x08, 0x3e, 0x7f, 0x3e, 0x49, 0x36, 0x49, 0x36, 0x08, 0x00, 0x00 },	// U+E76D ()
	{ 0x00, 0x00, 0x00, 0x63, 0x55, 0x55, 0x63, 0x41, 0x31, 0x00, 0x00, 0x00, 0x00 },	// U+E76E ()
}; // 2

static const unsigned char cozette_block301[][13] = {
	{ 0x00, 0x00, 0x00, 0x05, 0x75, 0x0d, 0x6a, 0x1d, 0x15, 0x35, 0x00, 0x00, 0x00 },	// U+E777 ()
}; // 1

static const unsigned char cozette_block302[][13] = {
	{ 0x0c, 0x12, 0x02, 0x1a, 0x0c, 0x00, 0x0e, 0x12, 0x12, 0x00, 0x12, 0x12, 0x1c },	// U+E779 ()
}; // 1

static const unsigned char cozette_block303[][13] = {
	{ 0x00, 0x00, 0x63, 0x33, 0x03, 0x3b, 0x7f, 0x67, 0x60, 0x61, 0x63, 0x61, 0x00 },	// U+E77B ()
}; // 1

static const unsigned char cozette_block304[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x64, 0x6e, 0x3b, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+E77F ()
}; // 1

static const unsigned char cozette_block305[][13] = {
	{ 0x00, 0x00, 0x00, 0x32, 0x4a, 0x0a, 0x32, 0x42, 0x4a, 0x31, 0x00, 0x00, 0x00 },	// U+E781 ()
}; // 1

static const unsigned char cozette_block306[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1f, 0x2a, 0x2a, 0x2a, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+E786 ()
}; // 1

static const unsigned char cozette_block307[][13] = {
	{ 0x00, 0x00, 0x00, 0x28, 0x0c, 0x2e, 0x37, 0x38, 0x3d, 0x00, 0x00, 0x00, 0x00 },	// U+E791 ()
}; // 1

static const unsigned char cozette_block308[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7d, 0x7b, 0x4d, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+E795 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x52, 0x91, 0x4a, 0x2c, 0x00, 0x00, 0x00, 0x00 },	// U+E796 ()
}; // 2

static const unsigned char cozette_block309[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x7e, 0x7c, 0x38, 0x00, 0x00 },	// U+E798 ()
}; // 1

static const unsigned char cozette_block310[][13] = {
	{ 0x00, 0x00, 0x1c, 0x22, 0x41, 0x63, 0x5d, 0x49, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+E79B ()
}; // 1

static const unsigned char cozette_block311[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x02, 0x71, 0x00, 0x00, 0x00, 0x00 },	// U+E7A2 ()
	{ 0x00, 0x0f, 0x11, 0x21, 0x49, 0x45, 0x49, 0x51, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+E7A3 ()
}; // 2

static const unsigned char cozette_block312[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x2a, 0x4d, 0x2a, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+E7A7 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x5d, 0x55, 0x4d, 0x55, 0x22, 0x1c, 0x00, 0x00 },	// U+E7A8 ()
}; // 2

static const unsigned char cozette_block313[][13] = {
	{ 0x08, 0x1c, 0x0e, 0x07, 0x01, 0x1e, 0x30, 0x38, 0x1c, 0x0e, 0x04, 0x00, 0x00 },	// U+E7AA ()
}; // 1

static const unsigned char cozette_block314[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x59, 0x65, 0x65, 0x75, 0x79, 0x7f, 0x00, 0x00, 0x00 },	// U+E7AF ()
	{ 0x00, 0x00, 0x08, 0x0e, 0x1f, 0x40, 0x3f, 0x5d, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+E7B0 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x63, 0x49, 0x41, 0x79, 0x43, 0x00, 0x00, 0x00, 0x00 },	// U+E7B1 ()
}; // 3

static const unsigned char cozette_block315[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x5b, 0x75, 0x51, 0x55, 0x7f, 0x7f, 0x00, 0x00 },	// U+E7B4 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x15, 0x14, 0x13, 0x00, 0x00, 0x00, 0x00 },	// U+E7B5 ()
}; // 2

static const unsigned char cozette_block316[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x49, 0x69, 0x5d, 0x4d, 0x7f, 0x7f, 0x00, 0x00 },	// U+E7B8 ()
}; // 1

static const unsigned char cozette_block317[][13] = {
	{ 0x00, 0x00, 0x00, 0x63, 0x5d, 0x22, 0x6b, 0x22, 0x5d, 0x63, 0x00, 0x00, 0x00 },	// U+E7BA ()
}; // 1

static const unsigned char cozette_block318[][13] = {
	{ 0x38, 0x3c, 0x3c, 0x1e, 0x1a, 0x0a, 0x0d, 0x05, 0x06, 0x02, 0x02, 0x00, 0x00 },	// U+E7C4 ()
	{ 0x00, 0x00, 0x00, 0x77, 0x66, 0x36, 0x1e, 0x0e, 0x66, 0x6a, 0x00, 0x00, 0x00 },	// U+E7C5 ()
}; // 2

static const unsigned char cozette_block319[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+EFFA ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+EFFB ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x22, 0x22, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+EFFC ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00 },	// U+EFFD ()
}; // 4

static const unsigned char cozette_block320[][13] = {
	{ 0x00, 0x00, 0x70, 0x7c, 0x4c, 0x44, 0x44, 0x64, 0x76, 0x27, 0x02, 0x00, 0x00 },	// U+F001 ()
}; // 1

static const unsigned char cozette_block321[][13] = {
	{ 0x00, 0x00, 0x08, 0x08, 0x1c, 0x7f, 0x3e, 0x1c, 0x36, 0x22, 0x00, 0x00, 0x00 },	// U+F005 ()
}; // 1

static const unsigned char cozette_block322[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x22, 0x63, 0x3e, 0x63, 0x22, 0x7f, 0x00, 0x00, 0x00 },	// U+F008 ()
}; // 1

static const unsigned char cozette_block323[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7b, 0x00, 0x7b, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x00 },	// U+F00B ()
	{ 0x00, 0x00, 0x00, 0x20, 0x20, 0x30, 0x12, 0x1e, 0x0c, 0x08, 0x00, 0x00, 0x00 },	// U+F00C ()
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x3e, 0x1c, 0x3e, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+F00D ()
}; // 3

static const unsigned char cozette_block324[][13] = {
	{ 0x00, 0x00, 0x00, 0x14, 0x1c, 0x7f, 0x36, 0x7f, 0x1c, 0x14, 0x00, 0x00, 0x00 },	// U+F013 ()
	{ 0x00, 0x0c, 0x3f, 0x00, 0x35, 0x2b, 0x35, 0x2b, 0x35, 0x3f, 0x00, 0x00, 0x00 },	// U+F014 ()
	{ 0x00, 0x00, 0x00, 0x28, 0x3c, 0x3e, 0x7f, 0x2a, 0x2e, 0x00, 0x00, 0x00, 0x00 },	// U+F015 ()
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+F016 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x49, 0x4d, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+F017 ()
}; // 5

static const unsigned char cozette_block325[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x36, 0x77, 0x55, 0x63, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+F01A ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x36, 0x63, 0x55, 0x77, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+F01B ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+F01C ()
}; // 3

static const unsigned char cozette_block326[][13] = {
	{ 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x00 },	// U+F023 ()
}; // 1

static const unsigned char cozette_block327[][13] = {
	{ 0x00, 0x00, 0x1c, 0x22, 0x41, 0x55, 0x77, 0x77, 0x77, 0x14, 0x00, 0x00, 0x00 },	// U+F025 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x07, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+F026 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x17, 0x17, 0x17, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+F027 ()
	{ 0x00, 0x00, 0x00, 0x20, 0x44, 0x57, 0x57, 0x57, 0x44, 0x20, 0x00, 0x00, 0x00 },	// U+F028 ()
}; // 4

static const unsigned char cozette_block328[][13] = {
	{ 0x00, 0x00, 0x00, 0x07, 0x0d, 0x1f, 0x3e, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00 },	// U+F02B ()
}; // 1

static const unsigned char cozette_block329[][13] = {
	{ 0x00, 0x00, 0x00, 0x7e, 0x52, 0x5e, 0x5f, 0x2f, 0x2f, 0x3f, 0x00, 0x00, 0x00 },	// U+F02D ()
}; // 1

static const unsigned char cozette_block330[][13] = {
	{ 0x00, 0x00, 0x38, 0x38, 0x34, 0x34, 0x3c, 0x32, 0x32, 0x77, 0x00, 0x00, 0x00 },	// U+F031 ()
	{ 0x00, 0x00, 0x1f, 0x36, 0x36, 0x1e, 0x36, 0x36, 0x36, 0x1f, 0x00, 0x00, 0x00 },	// U+F032 ()
	{ 0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x06, 0x06, 0x06, 0x0f, 0x00, 0x00, 0x00 },	// U+F033 ()
	{ 0x00, 0x00, 0xef, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xe4, 0x00, 0x00, 0x00 },	// U+F034 ()
	{ 0x00, 0x00, 0xff, 0x08, 0x08, 0x08, 0x08, 0x81, 0xff, 0x81, 0x00, 0x00, 0x00 },	// U+F035 ()
}; // 5

static const unsigned char cozette_block331[][13] = {
	{ 0x00, 0x00, 0x00, 0x7d, 0x00, 0x7d, 0x00, 0x7d, 0x00, 0x7d, 0x00, 0x00, 0x00 },	// U+F03A ()
}; // 1

static const unsigned char cozette_block332[][13] = {
	{ 0x00, 0x00, 0x00, 0x4e, 0x6f, 0x7f, 0x7f, 0x6f, 0x4e, 0x00, 0x00, 0x00, 0x00 },	// U+F03D ()
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x41, 0x55, 0x71, 0x7f, 0x7f, 0x00, 0x00, 0x00 },	// U+F03E ()
}; // 2

static const unsigned char cozette_block333[][13] = {
	{ 0x00, 0x00, 0x00, 0x10, 0x38, 0x1c, 0x0e, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00 },	// U+F040 ()
}; // 1

static const unsigned char cozette_block334[][13] = {
	{ 0x00, 0x00, 0x00, 0x22, 0x32, 0x3a, 0x3e, 0x3a, 0x32, 0x22, 0x00, 0x00, 0x00 },	// U+F048 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x6d, 0x7f, 0x6d, 0x49, 0x00, 0x00, 0x00, 0x00 },	// U+F049 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x36, 0x3f, 0x36, 0x24, 0x00, 0x00, 0x00, 0x00 },	// U+F04A ()
	{ 0x00, 0x00, 0x00, 0x02, 0x06, 0x0e, 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00 },	// U+F04B ()
	{ 0x00, 0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00 },	// U+F04C ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+F04D ()
	{ 0x00, 0x00, 0x00, 0x00, 0x09, 0x1b, 0x3f, 0x1b, 0x09, 0x00, 0x00, 0x00, 0x00 },	// U+F04E ()
}; // 7

static const unsigned char cozette_block335[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x49, 0x5b, 0x7f, 0x5b, 0x49, 0x00, 0x00, 0x00, 0x00 },	// U+F050 ()
	{ 0x00, 0x00, 0x00, 0x22, 0x26, 0x2e, 0x3e, 0x2e, 0x26, 0x22, 0x00, 0x00, 0x00 },	// U+F051 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+F052 ()
	{ 0x00, 0x00, 0x10, 0x38, 0x1c, 0x0e, 0x07, 0x0e, 0x1c, 0x38, 0x10, 0x00, 0x00 },	// U+F053 ()
	{ 0x00, 0x00, 0x02, 0x07, 0x0e, 0x1c, 0x38, 0x1c, 0x0e, 0x07, 0x02, 0x00, 0x00 },	// U+F054 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x36, 0x77, 0x41, 0x77, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+F055 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x7f, 0x41, 0x7f, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+F056 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x6b, 0x77, 0x6b, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+F057 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x4f, 0x65, 0x71, 0x3a, 0x1c, 0x00, 0x00, 0x00 },	// U+F058 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x6f, 0x77, 0x7f, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+F059 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x36, 0x7f, 0x73, 0x77, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+F05A ()
}; // 11

static const unsigned char cozette_block336[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x7e, 0x31, 0x11, 0x01, 0x00, 0x00, 0x00 },	// U+F064 ()
}; // 1

static const unsigned char cozette_block337[][13] = {
	{ 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x3f, 0x3f, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+F067 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F068 ()
	{ 0x00, 0x00, 0x00, 0x0c, 0x3f, 0x1e, 0x1e, 0x3f, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+F069 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x36, 0x77, 0x77, 0x7f, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+F06A ()
}; // 4

static const unsigned char cozette_block338[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x14, 0x36, 0x3e, 0x77, 0x7f, 0x00, 0x00, 0x00 },	// U+F071 ()
}; // 1

static const unsigned char cozette_block339[][13] = {
	{ 0x00, 0x00, 0x22, 0x5d, 0x7f, 0x55, 0x7f, 0x55, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+F073 ()
}; // 1

static const unsigned char cozette_block340[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x7f, 0x7f, 0x7f, 0x3e, 0x06, 0x03, 0x00, 0x00 },	// U+F075 ()
	{ 0x00, 0x00, 0x00, 0x33, 0x33, 0x00, 0x33, 0x33, 0x33, 0x3f, 0x1e, 0x00, 0x00 },	// U+F076 ()
}; // 2

static const unsigned char cozette_block341[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+F07B ()
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x01, 0x3e, 0x3f, 0x1f, 0x00, 0x00, 0x00, 0x00 },	// U+F07C ()
}; // 2

static const unsigned char cozette_block342[][13] = {
	{ 0x00, 0x00, 0x00, 0x11, 0x51, 0x55, 0x55, 0x55, 0x01, 0x7f, 0x00, 0x00, 0x00 },	// U+F080 ()
}; // 1

static const unsigned char cozette_block343[][13] = {
	{ 0x00, 0x00, 0x00, 0x06, 0x0d, 0x0f, 0x1e, 0x38, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+F084 ()
	{ 0x00, 0x00, 0x20, 0x70, 0x2a, 0x1f, 0x0a, 0x1f, 0x2a, 0x70, 0x20, 0x00, 0x00 },	// U+F085 ()
}; // 2

static const unsigned char cozette_block344[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x67, 0x77, 0x63, 0x36, 0x14, 0x00, 0x00, 0x00 },	// U+F09A ()
}; // 1

static const unsigned char cozette_block345[][13] = {
	{ 0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00 },	// U+F09C ()
}; // 1

static const unsigned char cozette_block346[][13] = {
	{ 0x00, 0x00, 0x0f, 0x10, 0x27, 0x48, 0x53, 0x54, 0x55, 0x00, 0x00, 0x00, 0x00 },	// U+F09E ()
}; // 1

static const unsigned char cozette_block347[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x7f, 0x57, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+F0A0 ()
}; // 1

static const unsigned char cozette_block348[][13] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x22, 0x22, 0x22, 0x41, 0x7f, 0x08, 0x00, 0x00, 0x00 },	// U+F0A2 ()
}; // 1

static const unsigned char cozette_block349[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x2e, 0x5f, 0x4d, 0x49, 0x32, 0x1c, 0x00, 0x00, 0x00 },	// U+F0AC ()
}; // 1

static const unsigned char cozette_block350[][13] = {
	{ 0x00, 0x7f, 0x5f, 0x7f, 0x00, 0x7f, 0x47, 0x7f, 0x00, 0x7f, 0x4f, 0x7f, 0x00 },	// U+F0AE ()
}; // 1

static const unsigned char cozette_block351[][13] = {
	{ 0x00, 0x00, 0x3f, 0x3f, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x08, 0x00, 0x00, 0x00 },	// U+F0B0 ()
}; // 1

static const unsigned char cozette_block352[][13] = {
	{ 0x00, 0x00, 0x00, 0x3e, 0x14, 0x14, 0x14, 0x22, 0x3e, 0x7f, 0x7f, 0x00, 0x00 },	// U+F0C3 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x1b, 0x0c, 0x1b, 0x33, 0x00, 0x00, 0x00, 0x00 },	// U+F0C4 ()
	{ 0x00, 0x00, 0x1e, 0x13, 0x79, 0x4d, 0x45, 0x47, 0x44, 0x7c, 0x00, 0x00, 0x00 },	// U+F0C5 ()
}; // 3

static const unsigned char cozette_block353[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x2a, 0x7f, 0x5d, 0x6f, 0x36, 0x00, 0x00, 0x00 },	// U+F0E4 ()
}; // 1

static const unsigned char cozette_block354[][13] = {
	{ 0x00, 0x00, 0x3c, 0x1c, 0x0e, 0x06, 0x1f, 0x0c, 0x04, 0x02, 0x00, 0x00, 0x00 },	// U+F0E7 ()
}; // 1

static const unsigned char cozette_block355[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x3e, 0x3e, 0x7f, 0x08, 0x00, 0x00, 0x00 },	// U+F0F3 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x7e, 0xbe, 0xbe, 0x7e, 0x3e, 0x00, 0x7f, 0x00, 0x00 },	// U+F0F4 ()
}; // 2

static const unsigned char cozette_block356[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2d, 0x21, 0x2d, 0x3f, 0x00, 0x00, 0x00 },	// U+F0F6 ()
}; // 1

static const unsigned char cozette_block357[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x49, 0x49, 0x41, 0x49, 0x49, 0x7f, 0x00, 0x00, 0x00 },	// U+F0FD ()
}; // 1

static const unsigned char cozette_block358[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x41, 0x41, 0x41, 0x7f, 0x7f, 0x1c, 0x00, 0x00, 0x00 },	// U+F108 ()
}; // 1

static const unsigned char cozette_block359[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+F111 ()
}; // 1

static const unsigned char cozette_block360[][13] = {
	{ 0x00, 0x00, 0x00, 0x41, 0x7f, 0x7f, 0x63, 0x55, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+F113 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x39, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+F114 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x39, 0x21, 0x7d, 0x43, 0x3f, 0x00, 0x00, 0x00 },	// U+F115 ()
}; // 3

static const unsigned char cozette_block361[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x41, 0x7f, 0x51, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+F11C ()
}; // 1

static const unsigned char cozette_block362[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x02, 0x71, 0x00, 0x00, 0x00, 0x00 },	// U+F120 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x52, 0x91, 0x4a, 0x2c, 0x00, 0x00, 0x00, 0x00 },	// U+F121 ()
}; // 2

static const unsigned char cozette_block363[][13] = {
	{ 0x00, 0x02, 0x05, 0x12, 0x2a, 0x12, 0x12, 0x0a, 0x06, 0x02, 0x05, 0x02, 0x00 },	// U+F126 ()
}; // 1

static const unsigned char cozette_block364[][13] = {
	{ 0x00, 0x00, 0x08, 0x1c, 0x1c, 0x5d, 0x5d, 0x2a, 0x1c, 0x08, 0x1c, 0x00, 0x00 },	// U+F130 ()
	{ 0x00, 0x00, 0x08, 0x5c, 0x3c, 0x5d, 0x5d, 0x2e, 0x1e, 0x09, 0x1c, 0x00, 0x00 },	// U+F131 ()
}; // 2

static const unsigned char cozette_block365[][13] = {
	{ 0x00, 0x00, 0x22, 0x5d, 0x7f, 0x41, 0x41, 0x41, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+F133 ()
}; // 1

static const unsigned char cozette_block366[][13] = {
	{ 0x00, 0x00, 0x7f, 0x41, 0x7d, 0x41, 0x5f, 0x41, 0x3e, 0x08, 0x00, 0x00, 0x00 },	// U+F13B ()
}; // 1

static const unsigned char cozette_block367[][13] = {
	{ 0x00, 0x00, 0x0c, 0x12, 0x12, 0x02, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00 },	// U+F13E ()
}; // 1

static const unsigned char cozette_block368[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x13, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+F144 ()
}; // 1

static const unsigned char cozette_block369[][13] = {
	{ 0x0c, 0x0c, 0x1e, 0x3f, 0x33, 0x07, 0x1e, 0x38, 0x33, 0x3f, 0x1e, 0x0c, 0x0c },	// U+F155 ()
}; // 1

static const unsigned char cozette_block370[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+F15B ()
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2d, 0x21, 0x2d, 0x3f, 0x00, 0x00, 0x00 },	// U+F15C ()
	{ 0x00, 0x00, 0x72, 0x52, 0x72, 0x52, 0x02, 0x72, 0x62, 0x37, 0x72, 0x00, 0x00 },	// U+F15D ()
	{ 0x00, 0x00, 0x72, 0x62, 0x32, 0x72, 0x02, 0x72, 0x52, 0x77, 0x52, 0x00, 0x00 },	// U+F15E ()
}; // 4

static const unsigned char cozette_block371[][13] = {
	{ 0x00, 0x00, 0x00, 0x22, 0x77, 0x22, 0x77, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+F16B ()
}; // 1

static const unsigned char cozette_block372[][13] = {
	{ 0x00, 0x10, 0x18, 0x08, 0x1e, 0x3f, 0x1f, 0x1f, 0x3f, 0x16, 0x00, 0x00, 0x00 },	// U+F179 ()
	{ 0x00, 0x00, 0x00, 0xf0, 0xf7, 0xf7, 0x00, 0xf7, 0xf7, 0xf0, 0x00, 0x00, 0x00 },	// U+F17A ()
	{ 0x00, 0x00, 0x00, 0x41, 0x22, 0x3e, 0x7f, 0x5d, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+F17B ()
	{ 0x00, 0x00, 0x1c, 0x2a, 0x3e, 0x32, 0x3e, 0x63, 0x55, 0x3e, 0x00, 0x00, 0x00 },	// U+F17C ()
}; // 4

static const unsigned char cozette_block373[][13] = {
	{ 0x00, 0x00, 0x00, 0x14, 0x5d, 0x36, 0x63, 0x36, 0x5d, 0x14, 0x00, 0x00, 0x00 },	// U+F185 ()
}; // 1

static const unsigned char cozette_block374[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x00, 0x7f, 0x63, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00 },	// U+F187 ()
	{ 0x00, 0x00, 0x1c, 0x5d, 0x2a, 0x1c, 0x77, 0x14, 0x3e, 0x41, 0x00, 0x00, 0x00 },	// U+F188 ()
}; // 2

static const unsigned char cozette_block375[][13] = {
	{ 0x00, 0x00, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x3f, 0x10, 0x08, 0x00, 0x00, 0x00 },	// U+F18D ()
}; // 1

static const unsigned char cozette_block376[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x3a, 0x1e, 0x77, 0x3c, 0x2e, 0x08, 0x00, 0x00, 0x00 },	// U+F198 ()
}; // 1

static const unsigned char cozette_block377[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x19, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+F1B6 ()
	{ 0x00, 0x00, 0x00, 0x7f, 0x6f, 0x57, 0x66, 0x71, 0x7b, 0x7f, 0x00, 0x00, 0x00 },	// U+F1B7 ()
}; // 2

static const unsigned char cozette_block378[][13] = {
	{ 0x00, 0x08, 0x1c, 0x08, 0x1c, 0x3e, 0x1c, 0x3e, 0x7f, 0x08, 0x08, 0x00, 0x00 },	// U+F1BB ()
}; // 1

static const unsigned char cozette_block379[][13] = {
	{ 0x00, 0x30, 0x30, 0x3f, 0x1f, 0x1c, 0x0e, 0x3e, 0x3f, 0x03, 0x03, 0x00, 0x00 },	// U+F1BD ()
}; // 1

static const unsigned char cozette_block380[][13] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x7f, 0x3e, 0x41, 0x3e, 0x41, 0x3e, 0x00, 0x00, 0x00 },	// U+F1C0 ()
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x25, 0x25, 0x3d, 0x23, 0x3f, 0x00, 0x00, 0x00 },	// U+F1C1 ()
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2b, 0x2b, 0x35, 0x3f, 0x00, 0x00, 0x00 },	// U+F1C2 ()
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2b, 0x25, 0x2b, 0x3f, 0x00, 0x00, 0x00 },	// U+F1C3 ()
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2d, 0x2d, 0x25, 0x3f, 0x00, 0x00, 0x00 },	// U+F1C4 ()
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x23, 0x29, 0x3d, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+F1C5 ()
	{ 0x00, 0x00, 0x0f, 0x1d, 0x3b, 0x25, 0x23, 0x25, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+F1C6 ()
}; // 7

static const unsigned char cozette_block381[][13] = {
	{ 0x00, 0x00, 0x20, 0x20, 0x70, 0x20, 0x2a, 0x23, 0x2b, 0x2a, 0x02, 0x01, 0x00 },	// U+F1D3 ()
}; // 1

static const unsigned char cozette_block382[][13] = {
	{ 0x00, 0x00, 0x7e, 0x42, 0x5f, 0x43, 0x6f, 0x43, 0x69, 0x3e, 0x00, 0x00, 0x00 },	// U+F1EA ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x41, 0x1c, 0x22, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+F1EB ()
}; // 2

static const unsigned char cozette_block383[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x5c, 0x2e, 0x36, 0x3a, 0x7d, 0x0a, 0x01, 0x00, 0x00 },	// U+F1F6 ()
	{ 0x00, 0x00, 0x08, 0x5c, 0x22, 0x32, 0x2a, 0x45, 0x7e, 0x09, 0x00, 0x00, 0x00 },	// U+F1F7 ()
	{ 0x00, 0x0c, 0x3f, 0x00, 0x3f, 0x3d, 0x37, 0x3f, 0x2d, 0x3f, 0x00, 0x00, 0x00 },	// U+F1F8 ()
}; // 3

static const unsigned char cozette_block384[][13] = {
	{ 0x00, 0x1c, 0x22, 0x41, 0x5d, 0x55, 0x3d, 0x01, 0x42, 0x3c, 0x00, 0x00, 0x00 },	// U+F1FA ()
}; // 1

static const unsigned char cozette_block385[][13] = {
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x09, 0x55, 0x23, 0x01, 0x7f, 0x00, 0x00, 0x00 },	// U+F1FE ()
}; // 1

static const unsigned char cozette_block386[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x30, 0x76, 0x77, 0x07, 0x67, 0x4f, 0x1e, 0x00, 0x00 },	// U+F200 ()
	{ 0x00, 0x00, 0x00, 0x01, 0x71, 0x61, 0x55, 0x0b, 0x01, 0x7f, 0x00, 0x00, 0x00 },	// U+F201 ()
}; // 2

static const unsigned char cozette_block387[][13] = {
	{ 0x00, 0x00, 0x00, 0x3e, 0x5f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+F219 ()
}; // 1

static const unsigned char cozette_block388[][13] = {
	{ 0x00, 0x7f, 0x51, 0x7f, 0x00, 0x7f, 0x51, 0x7f, 0x00, 0x7f, 0x51, 0x7f, 0x00 },	// U+F233 ()
}; // 1

static const unsigned char cozette_block389[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+F240 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x4f, 0x4f, 0x4f, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+F241 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x47, 0x47, 0x47, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+F242 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x43, 0x43, 0x43, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+F243 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x41, 0x41, 0x41, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+F244 ()
}; // 5

static const unsigned char cozette_block390[][13] = {
	{ 0x00, 0x7f, 0x41, 0x41, 0x22, 0x14, 0x14, 0x22, 0x41, 0x41, 0x7f, 0x00, 0x00 },	// U+F250 ()
	{ 0x00, 0x7f, 0x41, 0x7f, 0x3e, 0x1c, 0x14, 0x22, 0x41, 0x41, 0x7f, 0x00, 0x00 },	// U+F251 ()
	{ 0x00, 0x7f, 0x41, 0x41, 0x3e, 0x1c, 0x14, 0x22, 0x41, 0x7f, 0x7f, 0x00, 0x00 },	// U+F252 ()
	{ 0x00, 0x7f, 0x41, 0x41, 0x22, 0x14, 0x14, 0x22, 0x7f, 0x7f, 0x7f, 0x00, 0x00 },	// U+F253 ()
	{ 0x00, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x1c, 0x3e, 0x7f, 0x7f, 0x7f, 0x00, 0x00 },	// U+F254 ()
}; // 5

static const unsigned char cozette_block391[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x2a, 0x41, 0x2a, 0x14, 0x00, 0x00, 0x00 },	// U+F260 ()
}; // 1

static const unsigned char cozette_block392[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x3c, 0x05, 0x6b, 0x77, 0x36, 0x18, 0x00, 0x00, 0x00 },	// U+F268 ()
	{ 0x00, 0x00, 0x00, 0x15, 0x37, 0x6f, 0x63, 0x6f, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+F269 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x2e, 0x77, 0x63, 0x77, 0x2e, 0x1c, 0x00, 0x00, 0x00 },	// U+F26A ()
}; // 3

static const unsigned char cozette_block393[][13] = {
	{ 0x00, 0x00, 0x00, 0x0c, 0x12, 0x1c, 0x12, 0x12, 0x1c, 0x61, 0x5e, 0x00, 0x00 },	// U+F270 ()
}; // 1

static const unsigned char cozette_block394[][13] = {
	{ 0x00, 0x00, 0x28, 0x28, 0x7e, 0x14, 0x14, 0x3f, 0x0a, 0x0a, 0x00, 0x00, 0x00 },	// U+F292 ()
	{ 0x00, 0x00, 0x3e, 0x77, 0x65, 0x53, 0x67, 0x53, 0x65, 0x77, 0x3e, 0x00, 0x00 },	// U+F293 ()
	{ 0x00, 0x00, 0x00, 0x08, 0x1a, 0x2c, 0x18, 0x2c, 0x1a, 0x08, 0x00, 0x00, 0x00 },	// U+F294 ()
}; // 3

static const unsigned char cozette_block395[][13] = {
	{ 0x00, 0x00, 0x22, 0x22, 0x77, 0x49, 0x6b, 0x2a, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+F296 ()
}; // 1

static const unsigned char cozette_block396[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2d, 0x21, 0x2d, 0x3f, 0x00, 0x00, 0x00 },	// U+F298 ()
}; // 1

static const unsigned char cozette_block397[][13] = {
	{ 0x1c, 0x22, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x5d, 0x5d, 0x5d, 0x22, 0x1c },	// U+F2C7 ()
	{ 0x1c, 0x22, 0x22, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x5d, 0x5d, 0x5d, 0x22, 0x1c },	// U+F2C8 ()
	{ 0x1c, 0x22, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x2a, 0x5d, 0x5d, 0x5d, 0x22, 0x1c },	// U+F2C9 ()
	{ 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2a, 0x5d, 0x5d, 0x5d, 0x22, 0x1c },	// U+F2CA ()
	{ 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x5d, 0x5d, 0x5d, 0x22, 0x1c },	// U+F2CB ()
}; // 5

static const unsigned char cozette_block398[][13] = {
	{ 0x00, 0x00, 0x00, 0x1e, 0x3f, 0x1e, 0x3f, 0x1e, 0x3f, 0x1e, 0x00, 0x00, 0x00 },	// U+F2DB ()
	{ 0x00, 0x00, 0x08, 0x1c, 0x6b, 0x6b, 0x1c, 0x6b, 0x6b, 0x1c, 0x08, 0x00, 0x00 },	// U+F2DC ()
}; // 2

static const unsigned char cozette_block399[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x6b, 0x55, 0x7f, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+F300 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x26, 0x5f, 0x5d, 0x7d, 0x32, 0x1c, 0x00, 0x00, 0x00 },	// U+F301 ()
	{ 0x00, 0x00, 0x10, 0x08, 0x3e, 0x1f, 0x1f, 0x1f, 0x3e, 0x36, 0x00, 0x00, 0x00 },	// U+F302 ()
	{ 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x1c, 0x3e, 0x36, 0x77, 0x00, 0x00, 0x00 },	// U+F303 ()
	{ 0x00, 0x00, 0x00, 0x6b, 0x5d, 0x2a, 0x7f, 0x2a, 0x5d, 0x6b, 0x00, 0x00, 0x00 },	// U+F304 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x26, 0x57, 0x47, 0x7f, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+F305 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x2d, 0x25, 0x19, 0x02, 0x04, 0x08, 0x00, 0x00 },	// U+F306 ()
	{ 0x00, 0x00, 0x06, 0x18, 0x20, 0x40, 0x60, 0x3c, 0x1f, 0x07, 0x00, 0x00, 0x00 },	// U+F307 ()
	{ 0x00, 0x00, 0x08, 0x0e, 0x1f, 0x40, 0x3f, 0x5d, 0x0e, 0x00, 0x00, 0x00, 0x00 },	// U+F308 ()
	{ 0x00, 0x1c, 0x22, 0x49, 0x55, 0x55, 0x4d, 0x65, 0x5b, 0x22, 0x1c, 0x00, 0x00 },	// U+F309 ()
	{ 0x00, 0x00, 0x3e, 0x4f, 0x77, 0x77, 0x63, 0x77, 0x77, 0x79, 0x3f, 0x00, 0x00 },	// U+F30A ()
}; // 11

static const unsigned char cozette_block400[][13] = {
	{ 0x00, 0x00, 0x40, 0x6d, 0x2e, 0x5f, 0x7f, 0x7f, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+F30C ()
	{ 0x00, 0x00, 0x0c, 0x1e, 0x3f, 0x77, 0x7f, 0x7e, 0x7c, 0x3e, 0x1f, 0x07, 0x00 },	// U+F30D ()
	{ 0x00, 0x00, 0x00, 0x3f, 0x41, 0x4b, 0x5a, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00 },	// U+F30E ()
}; // 3

static const unsigned char cozette_block401[][13] = {
	{ 0x00, 0x08, 0x10, 0x04, 0x10, 0x08, 0x22, 0x5d, 0x41, 0x41, 0x22, 0x1c, 0x00 },	// U+F310 ()
}; // 1

static const unsigned char cozette_block402[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x2e, 0x22, 0x2a, 0x2a, 0x2a, 0x00, 0x00, 0x00, 0x00 },	// U+F312 ()
	{ 0x00, 0x08, 0x00, 0x5b, 0x2d, 0x5d, 0x00, 0x46, 0x29, 0x49, 0x26, 0x00, 0x00 },	// U+F313 ()
	{ 0x00, 0x00, 0x00, 0x1e, 0x3e, 0x5f, 0x7b, 0x07, 0x7d, 0x00, 0x00, 0x00, 0x00 },	// U+F314 ()
}; // 3

static const unsigned char cozette_block403[][13] = {
	{ 0x00, 0x00, 0x00, 0x3e, 0x77, 0x7f, 0x55, 0x63, 0x77, 0x3e, 0x00, 0x00, 0x00 },	// U+F317 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x18, 0x20, 0x1c, 0x01, 0x7f, 0x00, 0x00 },	// U+F318 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x18, 0x20, 0x1c, 0x01, 0x7f, 0x00, 0x00 },	// U+F319 ()
}; // 3

static const unsigned char cozette_block404[][13] = {
	{ 0x00, 0x00, 0x00, 0x60, 0x7c, 0x66, 0x43, 0x43, 0x66, 0x7c, 0x60, 0x00, 0x00 },	// U+F31B ()
	{ 0x00, 0x00, 0x00, 0x2e, 0x67, 0x5d, 0x7c, 0x5d, 0x67, 0x2e, 0x00, 0x00, 0x00 },	// U+F31C ()
}; // 2

static const unsigned char cozette_block405[][13] = {
	{ 0x00, 0x7e, 0x43, 0x5b, 0x43, 0x5b, 0x43, 0x43, 0x7f, 0x4d, 0x7e, 0x0c, 0x04 },	// U+F401 ()
}; // 1

static const unsigned char cozette_block406[][13] = {
	{ 0x00, 0x00, 0x00, 0x41, 0x7f, 0x7f, 0x63, 0x55, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+F408 ()
}; // 1

static const unsigned char cozette_block407[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2d, 0x21, 0x2d, 0x3f, 0x00, 0x00, 0x00 },	// U+F40E ()
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x23, 0x29, 0x3d, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+F40F ()
	{ 0x00, 0x00, 0x0f, 0x1d, 0x3b, 0x25, 0x23, 0x25, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+F410 ()
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x25, 0x25, 0x3d, 0x23, 0x3f, 0x00, 0x00, 0x00 },	// U+F411 ()
}; // 4

static const unsigned char cozette_block408[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x0e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00 },	// U+F413 ()
}; // 1

static const unsigned char cozette_block409[][13] = {
	{ 0x1c, 0x22, 0x41, 0x41, 0x41, 0x22, 0x1c, 0x22, 0x41, 0x41, 0x00, 0x00, 0x00 },	// U+F415 ()
}; // 1

static const unsigned char cozette_block410[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x77, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F417 ()
}; // 1

static const unsigned char cozette_block411[][13] = {
	{ 0x00, 0x00, 0x00, 0x14, 0x1c, 0x7f, 0x36, 0x7f, 0x1c, 0x14, 0x00, 0x00, 0x00 },	// U+F423 ()
}; // 1

static const unsigned char cozette_block412[][13] = {
	{ 0x00, 0x00, 0x00, 0x0c, 0x6a, 0x3e, 0x18, 0x3c, 0x62, 0x41, 0x00, 0x00, 0x00 },	// U+F425 ()
}; // 1

static const unsigned char cozette_block413[][13] = {
	{ 0x00, 0x00, 0x00, 0x77, 0x77, 0x77, 0x22, 0x77, 0x77, 0x00, 0x00, 0x00, 0x00 },	// U+F42B ()
}; // 1

static const unsigned char cozette_block414[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F431 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F432 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+F433 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F434 ()
}; // 4

static const unsigned char cozette_block415[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x25, 0x2f, 0x25, 0x3f, 0x00, 0x00, 0x00 },	// U+F440 ()
}; // 1

static const unsigned char cozette_block416[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x4f, 0x6f, 0x7f, 0x7f, 0x6f, 0x4f, 0x00, 0x00, 0x00 },	// U+F447 ()
}; // 1

static const unsigned char cozette_block417[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x49, 0x41, 0x4d, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+F449 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x1c, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+F44A ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F44B ()
}; // 3

static const unsigned char cozette_block418[][13] = {
	{ 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00 },	// U+F460 ()
	{ 0x00, 0x7f, 0x7f, 0x77, 0x41, 0x63, 0x63, 0x5d, 0x7f, 0x77, 0x63, 0x41, 0x00 },	// U+F461 ()
	{ 0x00, 0x00, 0x2a, 0x2a, 0x2e, 0x2a, 0x2a, 0x2b, 0x3a, 0x2a, 0x00, 0x00, 0x00 },	// U+F462 ()
}; // 3

static const unsigned char cozette_block419[][13] = {
	{ 0x00, 0x00, 0x04, 0x1e, 0x24, 0x41, 0x59, 0x49, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+F464 ()
}; // 1

static const unsigned char cozette_block420[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2b, 0x2b, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+F471 ()
}; // 1

static const unsigned char cozette_block421[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x55, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+F475 ()
}; // 1

static const unsigned char cozette_block422[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+F47C ()
}; // 1

static const unsigned char cozette_block423[][13] = {
	{ 0x00, 0x00, 0x0f, 0x11, 0x29, 0x19, 0x3f, 0x19, 0x09, 0x3f, 0x00, 0x00, 0x00 },	// U+F481 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x0f, 0x29, 0x61, 0xfd, 0x61, 0x2f, 0x00, 0x00, 0x00 },	// U+F482 ()
}; // 2

static const unsigned char cozette_block424[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7d, 0x7b, 0x7d, 0x47, 0x7f, 0x00, 0x00, 0x00 },	// U+F489 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x25, 0x27, 0x27, 0x75, 0x25, 0x00, 0x00, 0x00, 0x00 },	// U+F48A ()
}; // 2

static const unsigned char cozette_block425[][13] = {
	{ 0x00, 0x1c, 0x7f, 0x41, 0x3e, 0x55, 0x55, 0x55, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+F48E ()
}; // 1

static const unsigned char cozette_block426[][13] = {
	{ 0x00, 0x08, 0x08, 0x6b, 0x5d, 0x49, 0x41, 0x7f, 0x7f, 0x1c, 0x00, 0x00, 0x00 },	// U+F498 ()
	{ 0x00, 0x00, 0x00, 0x3e, 0x14, 0x14, 0x14, 0x22, 0x3e, 0x7f, 0x7f, 0x00, 0x00 },	// U+F499 ()
}; // 2

static const unsigned char cozette_block427[][13] = {
	{ 0x00, 0x1c, 0x1c, 0x1c, 0x22, 0x49, 0x59, 0x41, 0x22, 0x1c, 0x1c, 0x1c, 0x00 },	// U+F49B ()
}; // 1

static const unsigned char cozette_block428[][13] = {
	{ 0x00, 0x00, 0x00, 0x20, 0x50, 0x50, 0x72, 0x55, 0x57, 0x55, 0x00, 0x00, 0x00 },	// U+F49E ()
}; // 1

static const unsigned char cozette_block429[][13] = {
	{ 0x00, 0x00, 0x10, 0x18, 0x6d, 0x07, 0x7a, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00 },	// U+F4A0 ()
}; // 1

static const unsigned char cozette_block430[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2d, 0x21, 0x2d, 0x3f, 0x00, 0x00, 0x00 },	// U+F4A5 ()
}; // 1

static const unsigned char cozette_block431[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x14, 0x2a, 0x2a, 0x41, 0x49, 0x7f, 0x00, 0x00, 0x00 },	// U+F529 ()
}; // 1

static const unsigned char cozette_block432[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x00, 0x7f, 0x63, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 0x00 },	// U+F53B ()
}; // 1

static const unsigned char cozette_block433[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x20, 0x12, 0x0a, 0x06, 0x1e, 0x00, 0x00, 0x00, 0x00 },	// U+F541 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x02, 0x24, 0x28, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00 },	// U+F542 ()
	{ 0x00, 0x00, 0x00, 0x55, 0x36, 0x77, 0x00, 0x77, 0x36, 0x55, 0x00, 0x00, 0x00 },	// U+F543 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+F544 ()
}; // 4

static const unsigned char cozette_block434[][13] = {
	{ 0x00, 0x00, 0x00, 0x77, 0x63, 0x55, 0x00, 0x55, 0x63, 0x77, 0x00, 0x00, 0x00 },	// U+F54B ()
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x3e, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+F54C ()
}; // 2

static const unsigned char cozette_block435[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x3e, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+F553 ()
}; // 1

static const unsigned char cozette_block436[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x06, 0x0a, 0x12, 0x20, 0x00, 0x00, 0x00, 0x00 },	// U+F55A ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x30, 0x28, 0x24, 0x02, 0x00, 0x00, 0x00, 0x00 },	// U+F55B ()
	{ 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+F55C ()
}; // 3

static const unsigned char cozette_block437[][13] = {
	{ 0x00, 0x00, 0x1c, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F578 ()
	{ 0x00, 0x00, 0x1c, 0x36, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x3e, 0x00, 0x00 },	// U+F579 ()
	{ 0x00, 0x00, 0x1c, 0x36, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x3e, 0x00, 0x00 },	// U+F57A ()
	{ 0x00, 0x00, 0x1c, 0x36, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F57B ()
	{ 0x00, 0x00, 0x1c, 0x36, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F57C ()
	{ 0x00, 0x00, 0x1c, 0x36, 0x22, 0x22, 0x22, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F57D ()
	{ 0x00, 0x00, 0x1c, 0x36, 0x22, 0x22, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F57E ()
	{ 0x00, 0x00, 0x1c, 0x36, 0x22, 0x22, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F57F ()
	{ 0x00, 0x00, 0x1c, 0x36, 0x22, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F580 ()
	{ 0x00, 0x00, 0x1c, 0x36, 0x22, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F581 ()
	{ 0x00, 0x00, 0x1c, 0x3e, 0x36, 0x36, 0x36, 0x3e, 0x36, 0x3e, 0x3e, 0x00, 0x00 },	// U+F582 ()
	{ 0x00, 0x00, 0x1c, 0x3e, 0x36, 0x3a, 0x22, 0x2e, 0x36, 0x3e, 0x3e, 0x00, 0x00 },	// U+F583 ()
	{ 0x00, 0x00, 0x02, 0x07, 0x27, 0x17, 0x77, 0x47, 0x27, 0x07, 0x00, 0x00, 0x00 },	// U+F584 ()
	{ 0x00, 0x00, 0x02, 0x05, 0x25, 0x15, 0x75, 0x45, 0x25, 0x07, 0x00, 0x00, 0x00 },	// U+F585 ()
	{ 0x00, 0x00, 0x02, 0x05, 0x25, 0x15, 0x75, 0x45, 0x27, 0x07, 0x00, 0x00, 0x00 },	// U+F586 ()
	{ 0x00, 0x00, 0x02, 0x05, 0x25, 0x15, 0x75, 0x47, 0x27, 0x07, 0x00, 0x00, 0x00 },	// U+F587 ()
	{ 0x00, 0x00, 0x02, 0x05, 0x25, 0x15, 0x77, 0x47, 0x27, 0x07, 0x00, 0x00, 0x00 },	// U+F588 ()
	{ 0x00, 0x00, 0x02, 0x05, 0x25, 0x17, 0x77, 0x47, 0x27, 0x07, 0x00, 0x00, 0x00 },	// U+F589 ()
	{ 0x00, 0x00, 0x02, 0x05, 0x27, 0x17, 0x77, 0x47, 0x27, 0x07, 0x00, 0x00, 0x00 },	// U+F58A ()
	{ 0x00, 0x00, 0x1c, 0x3e, 0x3e, 0x3e, 0x22, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F58B ()
	{ 0x00, 0x00, 0x02, 0x05, 0x05, 0x05, 0x77, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00 },	// U+F58C ()
	{ 0x00, 0x00, 0x1c, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F58D ()
	{ 0x00, 0x00, 0x1c, 0x3e, 0x3e, 0x36, 0x22, 0x36, 0x3e, 0x3e, 0x3e, 0x00, 0x00 },	// U+F58E ()
	{ 0x00, 0x00, 0x02, 0x05, 0x05, 0x25, 0x77, 0x27, 0x07, 0x07, 0x00, 0x00, 0x00 },	// U+F58F ()
	{ 0x00, 0x00, 0x1c, 0x3e, 0x22, 0x2a, 0x26, 0x36, 0x3e, 0x36, 0x3e, 0x00, 0x00 },	// U+F590 ()
}; // 25

static const unsigned char cozette_block438[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x0d, 0x16, 0x0c, 0x0c, 0x16, 0x0d, 0x04, 0x00, 0x00 },	// U+F5AE ()
	{ 0x00, 0x00, 0x00, 0x24, 0x4d, 0x56, 0x4c, 0x4c, 0x56, 0x4d, 0x24, 0x00, 0x00 },	// U+F5AF ()
}; // 2

static const unsigned char cozette_block439[][13] = {
	{ 0x00, 0x00, 0x00, 0x04, 0x0d, 0x16, 0x0c, 0x0c, 0x16, 0x2d, 0x04, 0x00, 0x00 },	// U+F5B1 ()
	{ 0x00, 0x04, 0x0d, 0x16, 0x0c, 0x0c, 0x16, 0x0d, 0x04, 0x00, 0x15, 0x00, 0x00 },	// U+F5B2 ()
}; // 2

static const unsigned char cozette_block440[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x47, 0x77, 0x47, 0x77, 0x47, 0x7f, 0x00, 0x00, 0x00 },	// U+F5BC ()
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x4f, 0x4f, 0x4f, 0x4f, 0x77, 0x00, 0x00, 0x00 },	// U+F5BD ()
}; // 2

static const unsigned char cozette_block441[][13] = {
	{ 0x00, 0x00, 0x7f, 0x41, 0x41, 0x7f, 0x55, 0x7f, 0x55, 0x7f, 0x55, 0x7f, 0x00 },	// U+F5EB ()
}; // 1

static const unsigned char cozette_block442[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x5f, 0x4f, 0x65, 0x71, 0x7b, 0x7f, 0x00, 0x00, 0x00 },	// U+F631 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x4f, 0x65, 0x71, 0x3a, 0x1c, 0x00, 0x00, 0x00 },	// U+F632 ()
}; // 2

static const unsigned char cozette_block443[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x6b, 0x77, 0x6b, 0x3e, 0x1c, 0x00, 0x00, 0x00 },	// U+F658 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x55, 0x49, 0x55, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+F659 ()
}; // 2

static const unsigned char cozette_block444[][13] = {
	{ 0x00, 0x00, 0x14, 0x22, 0x22, 0x22, 0x41, 0x22, 0x22, 0x22, 0x14, 0x00, 0x00 },	// U+F668 ()
	{ 0x00, 0x00, 0x36, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x36, 0x00, 0x00 },	// U+F669 ()
}; // 2

static const unsigned char cozette_block445[][13] = {
	{ 0x00, 0x00, 0x14, 0x14, 0x22, 0x22, 0x41, 0x22, 0x22, 0x14, 0x14, 0x00, 0x00 },	// U+F673 ()
}; // 1

static const unsigned char cozette_block446[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7d, 0x7b, 0x7d, 0x47, 0x7f, 0x00, 0x00, 0x00 },	// U+F68C ()
}; // 1

static const unsigned char cozette_block447[][13] = {
	{ 0x00, 0x08, 0x14, 0x22, 0x41, 0x63, 0x55, 0x49, 0x2a, 0x1c, 0x08, 0x00, 0x00 },	// U+F6A6 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x28, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F6A7 ()
}; // 2

static const unsigned char cozette_block448[][13] = {
	{ 0x00, 0x00, 0x3e, 0x63, 0x7f, 0x3e, 0x41, 0x3e, 0x41, 0x3e, 0x00, 0x00, 0x00 },	// U+F6B7 ()
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x1f, 0x06, 0x39, 0x06, 0x00, 0x00, 0x00, 0x00 },	// U+F6B8 ()
	{ 0x00, 0x00, 0x00, 0x0e, 0x11, 0x0f, 0x16, 0x39, 0x16, 0x00, 0x00, 0x00, 0x00 },	// U+F6B9 ()
}; // 3

static const unsigned char cozette_block449[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x63, 0x41, 0x41, 0x41, 0x55, 0x7f, 0x00, 0x00, 0x00 },	// U+F6FF ()
}; // 1

static const unsigned char cozette_block450[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+F713 ()
}; // 1

static const unsigned char cozette_block451[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2d, 0x21, 0x2d, 0x3f, 0x00, 0x00, 0x00 },	// U+F718 ()
}; // 1

static const unsigned char cozette_block452[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2b, 0x25, 0x2b, 0x3f, 0x00, 0x00, 0x00 },	// U+F71A ()
}; // 1

static const unsigned char cozette_block453[][13] = {
	{ 0x00, 0x00, 0x0f, 0x17, 0x27, 0x3f, 0x31, 0x33, 0x35, 0x3f, 0x00, 0x00, 0x00 },	// U+F71C ()
}; // 1

static const unsigned char cozette_block454[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x23, 0x29, 0x3d, 0x21, 0x3f, 0x00, 0x00, 0x00 },	// U+F71E ()
}; // 1

static const unsigned char cozette_block455[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x39, 0x29, 0x2d, 0x3f, 0x00, 0x00, 0x00 },	// U+F722 ()
}; // 1

static const unsigned char cozette_block456[][13] = {
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x25, 0x25, 0x3d, 0x23, 0x3f, 0x00, 0x00, 0x00 },	// U+F724 ()
}; // 1

static const unsigned char cozette_block457[][13] = {
	{ 0x00, 0x00, 0x0f, 0x17, 0x27, 0x3f, 0x29, 0x31, 0x29, 0x3f, 0x00, 0x00, 0x00 },	// U+F72A ()
	{ 0x00, 0x00, 0x0f, 0x19, 0x39, 0x21, 0x2b, 0x2b, 0x35, 0x3f, 0x00, 0x00, 0x00 },	// U+F72B ()
}; // 2

static const unsigned char cozette_block458[][13] = {
	{ 0x00, 0x0f, 0x11, 0x21, 0x49, 0x45, 0x49, 0x51, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+F72D ()
}; // 1

static const unsigned char cozette_block459[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x07, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00 },	// U+F74A ()
}; // 1

static const unsigned char cozette_block460[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x2a, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+F783 ()
}; // 1

static const unsigned char cozette_block461[][13] = {
	{ 0x00, 0x10, 0x28, 0x08, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x0a, 0x04, 0x00, 0x00 },	// U+F794 ()
}; // 1

static const unsigned char cozette_block462[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x01, 0x71, 0x41, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+F7B7 ()
}; // 1

static const unsigned char cozette_block463[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+F7CA ()
	{ 0x00, 0x00, 0x00, 0x7f, 0x63, 0x5d, 0x5d, 0x49, 0x49, 0x7f, 0x00, 0x00, 0x00 },	// U+F7CB ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x36, 0x36, 0x00, 0x2a, 0x00, 0x00 },	// U+F7CC ()
	{ 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x36, 0x36, 0x20, 0x18, 0x00, 0x00 },	// U+F7CD ()
}; // 4

static const unsigned char cozette_block464[][13] = {
	{ 0x00, 0x00, 0x00, 0x40, 0x3c, 0x32, 0x2a, 0x36, 0x36, 0x21, 0x18, 0x00, 0x00 },	// U+F7CF ()
}; // 1

static const unsigned char cozette_block465[][13] = {
	{ 0x00, 0x00, 0x04, 0x1e, 0x24, 0x41, 0x59, 0x49, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+F7D9 ()
}; // 1

static const unsigned char cozette_block466[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x36, 0x7f, 0x77, 0x77, 0x36, 0x1c, 0x00, 0x00, 0x00 },	// U+F7FB ()
}; // 1

static const unsigned char cozette_block467[][13] = {
	{ 0x00, 0x00, 0x00, 0x06, 0x0d, 0x0f, 0x1e, 0x38, 0x30, 0x00, 0x00, 0x00, 0x00 },	// U+F80A ()
}; // 1

static const unsigned char cozette_block468[][13] = {
	{ 0x00, 0x00, 0x1c, 0x14, 0x1c, 0x08, 0x7f, 0x22, 0x77, 0x55, 0x77, 0x00, 0x00 },	// U+F816 ()
}; // 1

static const unsigned char cozette_block469[][13] = {
	{ 0x00, 0x06, 0x09, 0x01, 0x29, 0x7d, 0x29, 0x7d, 0x29, 0x01, 0x09, 0x06, 0x00 },	// U+F81A ()
}; // 1

static const unsigned char cozette_block470[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x18, 0x5f, 0x63, 0x7d, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+F81F ()
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x59, 0x59, 0x67, 0x41, 0x31, 0x00, 0x00 },	// U+F820 ()
}; // 2

static const unsigned char cozette_block471[][13] = {
	{ 0x00, 0x00, 0x00, 0x7c, 0x44, 0x7d, 0x65, 0x7d, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+F831 ()
	{ 0x00, 0x00, 0x00, 0x7c, 0x4c, 0x6d, 0x65, 0x7d, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+F832 ()
	{ 0x00, 0x00, 0x00, 0x7c, 0x6c, 0x45, 0x6d, 0x7d, 0x01, 0x1f, 0x00, 0x00, 0x00 },	// U+F833 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x1c, 0x00, 0x1c, 0x00, 0x00 },	// U+F834 ()
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x14, 0x1c, 0x00, 0x1c, 0x00, 0x00 },	// U+F835 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x41, 0x5d, 0x41, 0x36, 0x00, 0x00, 0x00, 0x00 },	// U+F836 ()
	{ 0x00, 0x00, 0x00, 0x01, 0x36, 0x45, 0x5d, 0x51, 0x36, 0x40, 0x00, 0x00, 0x00 },	// U+F837 ()
}; // 7

static const unsigned char cozette_block472[][13] = {
	{ 0x00, 0x00, 0x1c, 0x2a, 0x3e, 0x32, 0x3e, 0x63, 0x55, 0x3e, 0x00, 0x00, 0x00 },	// U+F83C ()
}; // 1

static const unsigned char cozette_block473[][13] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x28, 0x08, 0x08, 0x08, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+F886 ()
}; // 1

static const unsigned char cozette_block474[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x6d, 0x49, 0x6d, 0x45, 0x6d, 0x00, 0x00, 0x00, 0x00 },	// U+F89F ()
}; // 1

static const unsigned char cozette_block475[][13] = {
	{ 0x00, 0x00, 0x1f, 0x2d, 0x5b, 0x7d, 0x45, 0x45, 0x46, 0x7c, 0x00, 0x00, 0x00 },	// U+F8D6 ()
	{ 0x00, 0x00, 0x00, 0x00, 0x3e, 0x6b, 0x7f, 0x5d, 0x3f, 0x06, 0x00, 0x00, 0x00 },	// U+F8D7 ()
}; // 2

static const unsigned char cozette_block476[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x12, 0x12, 0x12, 0x52, 0x22, 0x00, 0x00, 0x00 },	// U+F8FE ()
}; // 1

static const unsigned char cozette_block477[][13] = {
	{ 0x00, 0x00, 0x00, 0x20, 0x44, 0x57, 0x57, 0x57, 0x44, 0x20, 0x00, 0x00, 0x00 },	// U+FA7D (墳)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x07, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+FA7E (奄)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x17, 0x17, 0x17, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+FA7F (奔)
	{ 0x00, 0x01, 0x01, 0x22, 0x46, 0x57, 0x57, 0x5f, 0x4c, 0x30, 0x10, 0x20, 0x20 },	// U+FA80 (婢)
}; // 4

static const unsigned char cozette_block478[][13] = {
	{ 0x00, 0x00, 0x3c, 0x42, 0x18, 0x24, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 },	// U+FAA8 (直)
	{ 0x00, 0x02, 0x3c, 0x46, 0x18, 0x2c, 0x10, 0x18, 0x38, 0x20, 0x40, 0x00, 0x00 },	// U+FAA9 (睊)
}; // 2

static const unsigned char cozette_block479[][13] = {
	{ 0x00, 0x00, 0x24, 0x24, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00 },	// U+FAB6 (襁)
}; // 1

static const unsigned char cozette_block480[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x24, 0x52, 0x91, 0x4a, 0x2c, 0x00, 0x00, 0x00, 0x00 },	// U+FABF (謹)
}; // 1

static const unsigned char cozette_block481[][13] = {
	{ 0x00, 0x18, 0x14, 0x04, 0x1e, 0x14, 0x14, 0x14, 0x14, 0x24, 0x00, 0x00, 0x00 },	// U+FB01 (ﬁ)
}; // 1

static const unsigned char cozette_block482[][13] = {
	{ 0x00, 0x00, 0x00, 0x1f, 0x04, 0x54, 0x04, 0x14, 0x04, 0x10, 0x00, 0x00, 0x00 },	// U+FB68 (ﭨ)
}; // 1

static const unsigned char cozette_block483[][13] = {
	{ 0x00, 0x3e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x3e, 0x08, 0x1c, 0x7f, 0x1c, 0x00 },	// U+FBF1 (ﯱ)
}; // 1

static const unsigned char cozette_block484[][13] = {
	{ 0x00, 0x00, 0x7f, 0x41, 0x49, 0x49, 0x5d, 0x49, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+FC2E (ﰮ)
}; // 1

static const unsigned char cozette_block485[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x27, 0x77, 0x27, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+FC5B (ﱛ)
	{ 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x77, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00 },	// U+FC5C (ﱜ)
	{ 0x00, 0x00, 0x00, 0x02, 0x14, 0x1c, 0x1c, 0x3c, 0x50, 0x00, 0x00, 0x00, 0x00 },	// U+FC5D (ﱝ)
}; // 3

static const unsigned char cozette_block486[][13] = {
	{ 0x00, 0x00, 0x00, 0x40, 0x3c, 0x32, 0x2a, 0x36, 0x36, 0x01, 0x00, 0x00, 0x00 },	// U+FCCC (ﳌ)
}; // 1

static const unsigned char cozette_block487[][13] = {
	{ 0x00, 0x00, 0x00, 0x01, 0x0f, 0x1d, 0x00, 0x5c, 0x78, 0x40, 0x00, 0x00, 0x00 },	// U+FCE4 (ﳤ)
}; // 1

static const unsigned char cozette_block488[][13] = {
	{ 0x00, 0x00, 0x00, 0x0c, 0x16, 0x36, 0x37, 0x73, 0x63, 0x78, 0x00, 0x00, 0x00 },	// U+FD03 (ﴃ)
}; // 1

static const unsigned char cozette_block489[][13] = {
	{ 0x00, 0x00, 0x02, 0x27, 0x47, 0x57, 0x57, 0x57, 0x47, 0x27, 0x00, 0x00, 0x00 },	// U+FD05 (ﴅ)
	{ 0x00, 0x00, 0x02, 0x25, 0x45, 0x55, 0x55, 0x55, 0x45, 0x27, 0x00, 0x00, 0x00 },	// U+FD06 (ﴆ)
	{ 0x00, 0x00, 0x02, 0x25, 0x45, 0x55, 0x55, 0x55, 0x47, 0x27, 0x00, 0x00, 0x00 },	// U+FD07 (ﴇ)
	{ 0x00, 0x00, 0x02, 0x25, 0x45, 0x55, 0x55, 0x57, 0x47, 0x27, 0x00, 0x00, 0x00 },	// U+FD08 (ﴈ)
	{ 0x00, 0x00, 0x02, 0x25, 0x45, 0x55, 0x55, 0x57, 0x47, 0x27, 0x00, 0x00, 0x00 },	// U+FD09 (ﴉ)
	{ 0x00, 0x00, 0x02, 0x25, 0x45, 0x55, 0x57, 0x57, 0x47, 0x27, 0x00, 0x00, 0x00 },	// U+FD0A (ﴊ)
	{ 0x00, 0x00, 0x02, 0x25, 0x45, 0x57, 0x57, 0x57, 0x47, 0x27, 0x00, 0x00, 0x00 },	// U+FD0B (ﴋ)
	{ 0x00, 0x00, 0x02, 0x25, 0x45, 0x57, 0x57, 0x57, 0x47, 0x27, 0x00, 0x00, 0x00 },	// U+FD0C (ﴌ)
	{ 0x00, 0x00, 0x02, 0x25, 0x47, 0x57, 0x57, 0x57, 0x47, 0x27, 0x00, 0x00, 0x00 },	// U+FD0D (ﴍ)
	{ 0x00, 0x00, 0x02, 0x25, 0x47, 0x57, 0x57, 0x57, 0x47, 0x27, 0x00, 0x00, 0x00 },	// U+FD0E (ﴎ)
	{ 0x00, 0x00, 0x02, 0x27, 0x45, 0x55, 0x55, 0x57, 0x45, 0x27, 0x00, 0x00, 0x00 },	// U+FD0F (ﴏ)
	{ 0x00, 0x00, 0x02, 0x25, 0x45, 0x55, 0x55, 0x55, 0x45, 0x27, 0x00, 0x00, 0x00 },	// U+FD10 (ﴐ)
}; // 12

static const unsigned char cozette_block490[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x49, 0x6b, 0x49, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+FD32 (ﴲ)
}; // 1

static const unsigned char cozette_block491[][13] = {
	{ 0x00, 0x00, 0x33, 0x33, 0x12, 0x12, 0x1e, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00 },	// U+FD42 (﵂)
}; // 1

static const unsigned char cozette_block492[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x02 },	// U+FE54 (﹔)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00 },	// U+FE55 (﹕)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x08, 0x04, 0x00, 0x04, 0x00 },	// U+FE56 (﹖)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04, 0x00 },	// U+FE57 (﹗)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00 },	// U+FE58 (﹘)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x04, 0x04, 0x04, 0x08, 0x08 },	// U+FE59 (﹙)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x08, 0x04, 0x04 },	// U+FE5A (﹚)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x04, 0x04, 0x02, 0x04, 0x04, 0x0c },	// U+FE5B (﹛)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x08, 0x04, 0x04, 0x06 },	// U+FE5C (﹜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x06, 0x02, 0x02, 0x02, 0x06, 0x08 },	// U+FE5D (﹝)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x08, 0x08, 0x08, 0x0c, 0x02 },	// U+FE5E (﹞)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x3e, 0x14, 0x3e, 0x14, 0x00 },	// U+FE5F (﹟)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x14, 0x0a, 0x12, 0x2c, 0x00 },	// U+FE60 (﹠)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x2a, 0x1c, 0x14, 0x14, 0x00, 0x00 },	// U+FE61 (﹡)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0e, 0x04, 0x00, 0x00 },	// U+FE62 (﹢)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00 },	// U+FE63 (﹣)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x04, 0x08, 0x00 },	// U+FE64 (﹤)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x04, 0x02, 0x00 },	// U+FE65 (﹥)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x00 },	// U+FE66 (﹦)
}; // 19

static const unsigned char cozette_block493[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x08, 0x08, 0x08, 0x00 },	// U+FE68 (﹨)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1c, 0x02, 0x0c, 0x10, 0x0e, 0x08 },	// U+FE69 (﹩)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x15, 0x0a, 0x28, 0x54, 0x24, 0x00 },	// U+FE6A (﹪)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x3d, 0x25, 0x1d, 0x22, 0x1c, 0x00 },	// U+FE6B (﹫)
}; // 4

static const unsigned char cozette_block494[][13] = {
	{ 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00 },	// U+FF01 (！)
	{ 0x00, 0xa0, 0xa0, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF02 (＂)
	{ 0x00, 0x00, 0xa0, 0xa0, 0xf0, 0xa0, 0xa0, 0xf0, 0xa0, 0xa0, 0x00, 0x00, 0x00 },	// U+FF03 (＃)
	{ 0x00, 0x40, 0xe0, 0x50, 0x50, 0xe0, 0x40, 0x40, 0x50, 0xe0, 0x40, 0x00, 0x00 },	// U+FF04 (＄)
	{ 0x00, 0x20, 0x50, 0x20, 0x80, 0x40, 0x20, 0x90, 0x40, 0x80, 0x00, 0x00, 0x00 },	// U+FF05 (％)
	{ 0x00, 0x40, 0xa0, 0xa0, 0x40, 0x60, 0x90, 0x90, 0x90, 0x60, 0x00, 0x00, 0x00 },	// U+FF06 (＆)
	{ 0x00, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF07 (＇)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF08 (（)
	{ 0x00, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00 },	// U+FF09 (）)
	{ 0x00, 0x00, 0x00, 0x00, 0xa0, 0x40, 0xf0, 0x40, 0xa0, 0x00, 0x00, 0x00, 0x00 },	// U+FF0A (＊)
	{ 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0xf0, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00 },	// U+FF0B (＋)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x80, 0x40, 0x00 },	// U+FF0C (，)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF0D (－)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+FF0E (．)
}; // 14

static const unsigned char cozette_block495[][13] = {
	{ 0x00, 0x00, 0xe0, 0x10, 0x10, 0x50, 0x50, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF10 (０)
	{ 0x00, 0x00, 0x40, 0x60, 0x50, 0x40, 0x40, 0x40, 0x40, 0xf0, 0x00, 0x00, 0x00 },	// U+FF11 (１)
	{ 0x00, 0x00, 0xe0, 0x10, 0x00, 0x80, 0x40, 0x20, 0x10, 0xf0, 0x00, 0x00, 0x00 },	// U+FF12 (２)
	{ 0x00, 0x00, 0xe0, 0x10, 0x00, 0xc0, 0x00, 0x00, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF13 (３)
	{ 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF14 (４)
	{ 0x00, 0x00, 0xf0, 0x10, 0x10, 0xf0, 0x00, 0x00, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF15 (５)
	{ 0x00, 0x00, 0xc0, 0x20, 0x10, 0xf0, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF16 (６)
	{ 0x00, 0x00, 0xf0, 0x00, 0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x00, 0x00, 0x00 },	// U+FF17 (７)
	{ 0x00, 0x00, 0xe0, 0x10, 0x10, 0xe0, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF18 (８)
	{ 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x80, 0x60, 0x00, 0x00, 0x00 },	// U+FF19 (９)
	{ 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00 },	// U+FF1A (：)
	{ 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0xc0, 0xc0, 0x80, 0x40, 0x00 },	// U+FF1B (；)
	{ 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00 },	// U+FF1C (＜)
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF1D (＝)
	{ 0x00, 0x00, 0x10, 0x20, 0x40, 0x80, 0x00, 0x80, 0x40, 0x20, 0x10, 0x00, 0x00 },	// U+FF1E (＞)
	{ 0x00, 0x00, 0xe0, 0x10, 0x00, 0x80, 0x40, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00 },	// U+FF1F (？)
	{ 0x00, 0xf0, 0x08, 0xe4, 0x94, 0x94, 0x94, 0x64, 0x08, 0xf0, 0x00, 0x00, 0x00 },	// U+FF20 (＠)
	{ 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF21 (Ａ)
	{ 0x00, 0x00, 0xf0, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0xf0, 0x00, 0x00, 0x00 },	// U+FF22 (Ｂ)
	{ 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF23 (Ｃ)
	{ 0x00, 0x00, 0x70, 0x90, 0x10, 0x10, 0x10, 0x10, 0x90, 0x70, 0x00, 0x00, 0x00 },	// U+FF24 (Ｄ)
	{ 0x00, 0x00, 0xf0, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0xf0, 0x00, 0x00, 0x00 },	// U+FF25 (Ｅ)
	{ 0x00, 0x00, 0xf0, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF26 (Ｆ)
	{ 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x90, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF27 (Ｇ)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF28 (Ｈ)
	{ 0x00, 0x00, 0xe0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xe0, 0x00, 0x00, 0x00 },	// U+FF29 (Ｉ)
	{ 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF2A (Ｊ)
	{ 0x00, 0x00, 0x10, 0x90, 0x50, 0x70, 0x90, 0x90, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF2B (Ｋ)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x00, 0x00, 0x00 },	// U+FF2C (Ｌ)
	{ 0x00, 0x00, 0x10, 0xb0, 0x50, 0x50, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF2D (Ｍ)
	{ 0x00, 0x00, 0x10, 0x30, 0x30, 0x50, 0x50, 0x90, 0x90, 0x10, 0x00, 0x00, 0x00 },	// U+FF2E (Ｎ)
	{ 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF2F (Ｏ)
	{ 0x00, 0x00, 0xf0, 0x10, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF30 (Ｐ)
	{ 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x90, 0x60, 0x00, 0x00, 0x00 },	// U+FF31 (Ｑ)
	{ 0x00, 0x00, 0xf0, 0x10, 0x10, 0xf0, 0x90, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF32 (Ｒ)
	{ 0x00, 0x00, 0xe0, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF33 (Ｓ)
	{ 0x00, 0x00, 0xf0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+FF34 (Ｔ)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF35 (Ｕ)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0xa0, 0xa0, 0xa0, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+FF36 (Ｖ)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0x50, 0x50, 0xe0, 0xa0, 0xa0, 0x00, 0x00, 0x00 },	// U+FF37 (Ｗ)
	{ 0x00, 0x00, 0x10, 0x10, 0xa0, 0x40, 0x40, 0xa0, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF38 (Ｘ)
	{ 0x00, 0x00, 0x10, 0x10, 0x10, 0xa0, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+FF39 (Ｙ)
	{ 0x00, 0x00, 0xf0, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0xf0, 0x00, 0x00, 0x00 },	// U+FF3A (Ｚ)
	{ 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00 },	// U+FF3B (［)
}; // 44

static const unsigned char cozette_block496[][13] = {
	{ 0x00, 0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c, 0x00 },	// U+FF3D (］)
	{ 0x40, 0xa0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF3E (＾)
}; // 2

static const unsigned char cozette_block497[][13] = {
	{ 0x00, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+FF40 (｀)
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x90, 0x60, 0x00, 0x00, 0x00 },	// U+FF41 (ａ)
	{ 0x00, 0x10, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x00, 0x00, 0x00 },	// U+FF42 (ｂ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF43 (ｃ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF44 (ｄ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0xf0, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF45 (ｅ)
	{ 0x00, 0xe0, 0x10, 0x10, 0x78, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF46 (ｆ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0xe0 },	// U+FF47 (ｇ)
	{ 0x00, 0x10, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF48 (ｈ)
	{ 0x00, 0x00, 0x40, 0x00, 0x60, 0x40, 0x40, 0x40, 0x40, 0x80, 0x00, 0x00, 0x00 },	// U+FF49 (ｉ)
	{ 0x00, 0x00, 0x80, 0x00, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80, 0xa0, 0x40, 0x00 },	// U+FF4A (ｊ)
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x90, 0x50, 0x70, 0x90, 0x10, 0x00, 0x00, 0x00 },	// U+FF4B (ｋ)
	{ 0x00, 0x60, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xc0, 0x00, 0x00, 0x00 },	// U+FF4C (ｌ)
	{ 0x00, 0x00, 0x00, 0x00, 0xb0, 0x50, 0x50, 0x50, 0x50, 0x50, 0x00, 0x00, 0x00 },	// U+FF4D (ｍ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF4E (ｎ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF4F (ｏ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf0, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10 },	// U+FF50 (ｐ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF51 (ｑ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00 },	// U+FF52 (ｒ)
	{ 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0xe0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00 },	// U+FF53 (ｓ)
	{ 0x00, 0x00, 0x20, 0x20, 0xf0, 0x20, 0x20, 0x20, 0x20, 0xc0, 0x00, 0x00, 0x00 },	// U+FF54 (ｔ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0x00 },	// U+FF55 (ｕ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0xa0, 0xa0, 0x40, 0x40, 0x00, 0x00, 0x00 },	// U+FF56 (ｖ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x50, 0x50, 0xa0, 0xa0, 0x00, 0x00, 0x00 },	// U+FF57 (ｗ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0xa0, 0x40, 0x40, 0xa0, 0x10, 0x00, 0x00, 0x00 },	// U+FF58 (ｘ)
	{ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0xe0, 0x00, 0x00, 0xe0 },	// U+FF59 (ｙ)
	{ 0x00, 0x00, 0x00, 0x00, 0xf0, 0x80, 0x40, 0x20, 0x10, 0xf0, 0x00, 0x00, 0x00 },	// U+FF5A (ｚ)
	{ 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x60, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00 },	// U+FF5B (｛)
	{ 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00 },	// U+FF5C (｜)
	{ 0x00, 0x0c, 0x10, 0x10, 0x10, 0x10, 0x60, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00 },	// U+FF5D (｝)
}; // 30

static const unsigned char cozette_block498[][13] = {
	{ 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x80, 0x00, 0x00 },	// U+FF5F (｟)
	{ 0x00, 0x14, 0x28, 0x28, 0x50, 0x50, 0x50, 0x50, 0x50, 0x28, 0x28, 0x14, 0x00 },	// U+FF60 (｠)
}; // 2

static const unsigned char cozette_block499[][13] = {
	{ 0x00, 0x3e, 0x22, 0x22, 0x02, 0x1e, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00 },	// U+1016F (𐅯)
}; // 1

static const unsigned char cozette_block500[][13] = {
	{ 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00 },	// U+102A6 (𐊦)
}; // 1

static const unsigned char cozette_block501[][13] = {
	{ 0x00, 0x18, 0x04, 0x02, 0x02, 0x1a, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+102C9 (𐋉)
}; // 1

static const unsigned char cozette_block502[][13] = {
	{ 0x00, 0x22, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00 },	// U+102CF (𐋏)
}; // 1

static const unsigned char cozette_block503[][13] = {
	{ 0x00, 0x06, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+10315 (𐌕)
}; // 1

static const unsigned char cozette_block504[][13] = {
	{ 0x00, 0x00, 0x1c, 0x22, 0x02, 0x0c, 0x18, 0x20, 0x22, 0x1c, 0x00, 0x00, 0x00 },	// U+10343 (𐍃)
}; // 1

static const unsigned char cozette_block505[][13] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x14, 0x14, 0x1e, 0x3a, 0x12, 0x31, 0x00, 0x00, 0x00 },	// U+1D4D0 (𝓐)
}; // 1

static const unsigned char cozette_block506[][13] = {
	{ 0x00, 0x00, 0x00, 0x38, 0x2c, 0x16, 0x06, 0x06, 0x26, 0x1c, 0x00, 0x00, 0x00 },	// U+1D4D2 (𝓒)
}; // 1

static const unsigned char cozette_block507[][13] = {
	{ 0x00, 0x00, 0x00, 0x18, 0x2c, 0x0c, 0x18, 0x30, 0x32, 0x1c, 0x00, 0x00, 0x00 },	// U+1D4E2 (𝓢)
}; // 1

static const unsigned char cozette_block508[][13] = {
	{ 0x00, 0x00, 0x3e, 0x0a, 0x0a, 0x3a, 0x0a, 0x0a, 0x0a, 0x0e, 0x00, 0x00, 0x00 },	// U+1D53D (𝔽)
	{ 0x00, 0x00, 0x1c, 0x2a, 0x0a, 0x0a, 0x3a, 0x2a, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+1D53E (𝔾)
}; // 2

static const unsigned char cozette_block509[][13] = {
	{ 0x00, 0x00, 0x1c, 0x2a, 0x0a, 0x12, 0x24, 0x28, 0x2a, 0x1c, 0x00, 0x00, 0x00 },	// U+1D54A (𝕊)
}; // 1

static const unsigned char cozette_block510[][13] = {
	{ 0x00, 0x00, 0x22, 0x22, 0x36, 0x2a, 0x2a, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1D54E (𝕎)
	{ 0x00, 0x00, 0x27, 0x35, 0x1a, 0x0a, 0x14, 0x16, 0x2b, 0x39, 0x00, 0x00, 0x00 },	// U+1D54F (𝕏)
}; // 2

static const unsigned char cozette_block511[][13] = {
	{ 0x00, 0x38, 0x14, 0x14, 0x36, 0x14, 0x14, 0x14, 0x14, 0x1c, 0x00, 0x00, 0x00 },	// U+1D557 (𝕗)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x2a, 0x2a, 0x2a, 0x2a, 0x2c, 0x28, 0x28, 0x1e },	// U+1D558 (𝕘)
}; // 2

static const unsigned char cozette_block512[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x1e, 0x2a, 0x0a, 0x0a, 0x0a, 0x0e, 0x00, 0x00, 0x00 },	// U+1D563 (𝕣)
	{ 0x00, 0x00, 0x00, 0x00, 0x3c, 0x0a, 0x12, 0x24, 0x28, 0x1e, 0x00, 0x00, 0x00 },	// U+1D564 (𝕤)
}; // 2

static const unsigned char cozette_block513[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x22, 0x36, 0x2a, 0x2a, 0x14, 0x14, 0x00, 0x00, 0x00 },	// U+1D568 (𝕨)
	{ 0x00, 0x00, 0x00, 0x00, 0x27, 0x15, 0x0a, 0x14, 0x2a, 0x39, 0x00, 0x00, 0x00 },	// U+1D569 (𝕩)
}; // 2

static const unsigned char cozette_block514[][13] = {
	{ 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x18, 0x18, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00 },	// U+1D64F (𝙏)
}; // 1

static const unsigned char cozette_block515[][13] = {
	{ 0x00, 0x00, 0x2a, 0xbc, 0x43, 0xea, 0x43, 0xc2, 0x3d, 0x54, 0x00, 0x00, 0x00 },	// U+1F31E (🌞)
}; // 1

static const unsigned char cozette_block516[][13] = {
	{ 0x00, 0x00, 0x00, 0x07, 0x0e, 0x08, 0x68, 0x38, 0x08, 0x08, 0x00, 0x00, 0x00 },	// U+1F331 (🌱)
}; // 1

static const unsigned char cozette_block517[][13] = {
	{ 0x00, 0x3e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x3e, 0x14, 0x14, 0x1c, 0x00, 0x00 },	// U+1F333 (🌳)
}; // 1

static const unsigned char cozette_block518[][13] = {
	{ 0x00, 0xe0, 0xf8, 0xc4, 0xfc, 0x24, 0x14, 0xd8, 0x20, 0xd8, 0x04, 0xf8, 0x00 },	// U+1F379 (🍹)
}; // 1

static const unsigned char cozette_block519[][13] = {
	{ 0x00, 0x00, 0x0c, 0x3a, 0x7f, 0x7d, 0x7d, 0x7f, 0x3c, 0x24, 0x00, 0x00, 0x00 },	// U+1F40F (🐏)
}; // 1

static const unsigned char cozette_block520[][13] = {
	{ 0x00, 0x00, 0x00, 0x0e, 0x2d, 0x6f, 0x75, 0x3d, 0x24, 0x24, 0x00, 0x00, 0x00 },	// U+1F418 (🐘)
}; // 1

static const unsigned char cozette_block521[][13] = {
	{ 0x00, 0x00, 0x00, 0x1e, 0x21, 0x51, 0x71, 0x16, 0x14, 0x18, 0x00, 0x00, 0x00 },	// U+1F447 (👇)
	{ 0x00, 0x00, 0x18, 0x28, 0x5f, 0x41, 0x46, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00 },	// U+1F448 (👈)
}; // 2

static const unsigned char cozette_block522[][13] = {
	{ 0x00, 0x00, 0x00, 0x3e, 0x5f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00 },	// U+1F48E (💎)
}; // 1

static const unsigned char cozette_block523[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x2a, 0x77, 0x2a, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+1F4A0 (💠)
	{ 0x00, 0xf0, 0x08, 0x04, 0x04, 0x04, 0x08, 0x90, 0x90, 0xf0, 0xf0, 0x60, 0x00 },	// U+1F4A1 (💡)
}; // 2

static const unsigned char cozette_block524[][13] = {
	{ 0x00, 0xfc, 0x44, 0x44, 0xd4, 0x04, 0xf4, 0x04, 0xf4, 0x04, 0xfc, 0x00, 0x00 },	// U+1F4C4 (📄)
}; // 1

static const unsigned char cozette_block525[][13] = {
	{ 0xa0, 0x10, 0x08, 0xf8, 0xe8, 0x08, 0x18, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x00 },	// U+1F4E6 (📦)
}; // 1

static const unsigned char cozette_block526[][13] = {
	{ 0x00, 0x1c, 0x7f, 0x7f, 0x77, 0x63, 0x77, 0x7f, 0x63, 0x7f, 0x7f, 0x00, 0x00 },	// U+1F50B (🔋)
}; // 1

static const unsigned char cozette_block527[][13] = {
	{ 0x00, 0xf0, 0x08, 0x08, 0x08, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x00, 0x00 },	// U+1F512 (🔒)
}; // 1

static const unsigned char cozette_block528[][13] = {
	{ 0x00, 0x00, 0x1c, 0x22, 0x59, 0x41, 0x41, 0x22, 0x3e, 0x7f, 0x00, 0x00, 0x00 },	// U+1F52E (🔮)
}; // 1

static const unsigned char cozette_block529[][13] = {
	{ 0x00, 0x00, 0x00, 0x10, 0x0c, 0x06, 0x1c, 0x30, 0x18, 0x04, 0x00, 0x00, 0x00 },	// U+1F5F2 (🗲)
}; // 1

static const unsigned char cozette_block530[][13] = {
	{ 0x00, 0x41, 0x7f, 0x22, 0x41, 0x65, 0x41, 0x65, 0x59, 0x22, 0x1c, 0x00, 0x00 },	// U+1F608 (😈)
}; // 1

static const unsigned char cozette_block531[][13] = {
	{ 0x00, 0x00, 0x49, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x3e, 0x3e, 0x1c, 0x08, 0x00 },	// U+1F6E1 (🛡)
}; // 1

static const unsigned char cozette_block532[][13] = {
	{ 0x00, 0x22, 0x41, 0x55, 0x5d, 0x55, 0x41, 0x2a, 0x08, 0x7f, 0x1c, 0x00, 0x00 },	// U+F0002 (󰀂)
}; // 1

static const unsigned char cozette_block533[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x22, 0x41, 0x49, 0x43, 0x21, 0x1c, 0x00, 0x00, 0x00 },	// U+F006F (󰁯)
}; // 1

static const unsigned char cozette_block534[][13] = {
	{ 0x00, 0x00, 0x12, 0x12, 0x21, 0x21, 0x21, 0x21, 0x21, 0x12, 0x12, 0x00, 0x00 },	// U+F0172 (󰅲)
}; // 1

static const unsigned char cozette_block535[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x50, 0x8a, 0x50, 0x24, 0x00, 0x00, 0x00 },	// U+F01A8 (󰆨)
}; // 1

static const unsigned char cozette_block536[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x63, 0x55, 0x49, 0x41, 0x7f, 0x00, 0x00, 0x00 },	// U+F01F0 (󰇰)
}; // 1

static const unsigned char cozette_block537[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x3f, 0x1e, 0x0c, 0x0c, 0x0c, 0x08, 0x00, 0x00, 0x00 },	// U+F0232 (󰈲)
}; // 1

static const unsigned char cozette_block538[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00 },	// U+F02D1 (󰋑)
}; // 1

static const unsigned char cozette_block539[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x36, 0x6f, 0x77, 0x3a, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+F02D4 (󰋔)
}; // 1

static const unsigned char cozette_block540[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x7d, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F0306 (󰌆)
}; // 1

static const unsigned char cozette_block541[][13] = {
	{ 0x00, 0x00, 0x0e, 0x01, 0x29, 0x7d, 0x29, 0x7d, 0x29, 0x01, 0x0e, 0x00, 0x00 },	// U+F031B (󰌛)
}; // 1

static const unsigned char cozette_block542[][13] = {
	{ 0x00, 0x00, 0x00, 0x1c, 0x18, 0x5f, 0x63, 0x7d, 0x0c, 0x1c, 0x00, 0x00, 0x00 },	// U+F0320 (󰌠)
}; // 1

static const unsigned char cozette_block543[][13] = {
	{ 0x00, 0x00, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x17, 0x30, 0x77, 0x30, 0x10, 0x00 },	// U+F0411 (󰐑)
}; // 1

static const unsigned char cozette_block544[][13] = {
	{ 0x00, 0x7f, 0x75, 0x7f, 0x00, 0x7f, 0x75, 0x7f, 0x08, 0x7f, 0x1c, 0x00, 0x00 },	// U+F048D (󰒍)
}; // 1

static const unsigned char cozette_block545[][13] = {
	{ 0x30, 0x20, 0x10, 0x30, 0x0c, 0x08, 0x04, 0x0c, 0x03, 0x02, 0x01, 0x03, 0x00 },	// U+F04B2 (󰒲)
}; // 1

static const unsigned char cozette_block546[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x33, 0x3f, 0x12, 0x12, 0x3f, 0x33, 0x00, 0x00, 0x00 },	// U+F05C6 (󰗆)
}; // 1

static const unsigned char cozette_block547[][13] = {
	{ 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x31, 0x37, 0x01, 0x37, 0x30, 0x00, 0x00 },	// U+F0645 (󰙅)
}; // 1

static const unsigned char cozette_block548[][13] = {
	{ 0x00, 0x00, 0x00, 0x08, 0x1c, 0x08, 0x1c, 0x3e, 0x6b, 0x3e, 0x00, 0x00, 0x00 },	// U+F06A9 (󰚩)
}; // 1

static const unsigned char cozette_block549[][13] = {
	{ 0x00, 0x08, 0x1c, 0x3e, 0x5d, 0x6b, 0x77, 0x36, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+F072B (󰜫)
}; // 1

static const unsigned char cozette_block550[][13] = {
	{ 0x00, 0x00, 0x00, 0x1e, 0x23, 0x71, 0x53, 0x3e, 0x50, 0x00, 0x00, 0x00, 0x00 },	// U+F07D4 (󰟔)
}; // 1

static const unsigned char cozette_block551[][13] = {
	{ 0x00, 0x00, 0x00, 0x55, 0x55, 0x2a, 0x2a, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00 },	// U+F0844 (󰡄)
}; // 1

static const unsigned char cozette_block552[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7d, 0x7b, 0x4d, 0x7f, 0x00, 0x00, 0x00, 0x00 },	// U+F0A0A (󰨊)
}; // 1

static const unsigned char cozette_block553[][13] = {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	// U+F1417 (󱐗)
}; // 1

