export class NorthwindMetadata {
    public static value = {
  "structuralTypes": [
    {
      "shortName": "Category",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "Categories",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "CategoryName",
          "validators": [{ "name": "required" }]
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Description",
          "validators": []
        },
        {
          "dataType": "Binary",
          "isNullable": true,
          "nameOnServer": "Picture",
          "validators": []
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "Product:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.Product_Northwind.Category_Category",
          "invForeignKeyNamesOnServer": ["CategoryId"],
          "nameOnServer": "Products",
          "validators": []
        }
      ]
    },
    {
      "shortName": "Customer",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "Customers",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Address",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "City",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "CompanyName",
          "validators": [{ "name": "required" }]
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "ContactName",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "ContactTitle",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Country",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Email",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Fax",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Mobile",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Phone",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "PostalCode",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Region",
          "validators": []
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "CustomerCustomerDemographic:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.CustomerCustomerDemographic_Northwind.Customer_Customer",
          "invForeignKeyNamesOnServer": ["CustomerId"],
          "nameOnServer": "CustomerCustomerDemographics",
          "validators": []
        },
        {
          "entityTypeName": "SalesOrder:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.SalesOrder_Northwind.Customer_Customer",
          "invForeignKeyNamesOnServer": ["CustomerId"],
          "nameOnServer": "SalesOrders",
          "validators": []
        }
      ]
    },
    {
      "shortName": "CustomerCustomerDemographic",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "CustomerCustomerDemographics",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": false,
          "nameOnServer": "CustomerId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": false,
          "nameOnServer": "CustomerTypeId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "Customer:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.CustomerCustomerDemographic_Northwind.Customer_Customer",
          "foreignKeyNamesOnServer": ["CustomerId"],
          "nameOnServer": "Customer",
          "validators": []
        },
        {
          "entityTypeName": "CustomerDemographic:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.CustomerCustomerDemographic_Northwind.CustomerDemographic_CustomerType",
          "foreignKeyNamesOnServer": ["CustomerTypeId"],
          "nameOnServer": "CustomerType",
          "validators": []
        }
      ]
    },
    {
      "shortName": "CustomerDemographic",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "CustomerDemographics",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "CustomerDesc",
          "validators": []
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "CustomerCustomerDemographic:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.CustomerCustomerDemographic_Northwind.CustomerDemographic_CustomerType",
          "invForeignKeyNamesOnServer": ["CustomerTypeId"],
          "nameOnServer": "CustomerCustomerDemographics",
          "validators": []
        }
      ]
    },
    {
      "shortName": "Employee",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "Employees",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Address",
          "validators": []
        },
        {
          "dataType": "Binary",
          "isNullable": true,
          "nameOnServer": "BirthDate",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "City",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Country",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Email",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Extension",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "Firstname",
          "validators": [{ "name": "required" }]
        },
        {
          "dataType": "Binary",
          "isNullable": true,
          "nameOnServer": "HireDate",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "Lastname",
          "validators": [{ "name": "required" }]
        },
        {
          "dataType": "Int64",
          "isNullable": true,
          "nameOnServer": "MgrId",
          "validators": [{ "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Mobile",
          "validators": []
        },
        {
          "dataType": "Binary",
          "isNullable": true,
          "nameOnServer": "Notes",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Phone",
          "validators": []
        },
        {
          "dataType": "Binary",
          "isNullable": true,
          "nameOnServer": "Photo",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "PhotoPath",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "PostalCode",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Region",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Title",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "TitleOfCourtesy",
          "validators": []
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "EmployeeTerritory:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.EmployeeTerritory_Northwind.Employee_Employee",
          "invForeignKeyNamesOnServer": ["EmployeeId"],
          "nameOnServer": "EmployeeTerritories",
          "validators": []
        }
      ]
    },
    {
      "shortName": "EmployeeTerritory",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "EmployeeTerritories",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": false,
          "nameOnServer": "EmployeeId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "TerritoryCode",
          "validators": [{ "name": "required" }]
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "Employee:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.EmployeeTerritory_Northwind.Employee_Employee",
          "foreignKeyNamesOnServer": ["EmployeeId"],
          "nameOnServer": "Employee",
          "validators": []
        },
        {
          "entityTypeName": "Territory:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.EmployeeTerritory_Northwind.Territory_TerritoryCodeNavigation",
          "foreignKeyNamesOnServer": ["TerritoryCode"],
          "nameOnServer": "TerritoryCodeNavigation",
          "validators": []
        }
      ]
    },
    {
      "shortName": "OrderDetail",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "OrderDetails",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Binary",
          "isNullable": false,
          "nameOnServer": "Discount",
          "validators": [{ "name": "required" }]
        },
        {
          "dataType": "Int64",
          "isNullable": false,
          "nameOnServer": "OrderId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": false,
          "nameOnServer": "ProductId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": false,
          "nameOnServer": "Quantity",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Binary",
          "isNullable": false,
          "nameOnServer": "UnitPrice",
          "validators": [{ "name": "required" }]
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "SalesOrder:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.OrderDetail_Northwind.SalesOrder_Order",
          "foreignKeyNamesOnServer": ["OrderId"],
          "nameOnServer": "Order",
          "validators": []
        },
        {
          "entityTypeName": "Product:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.OrderDetail_Northwind.Product_Product",
          "foreignKeyNamesOnServer": ["ProductId"],
          "nameOnServer": "Product",
          "validators": []
        }
      ]
    },
    {
      "shortName": "Product",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "Products",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": true,
          "nameOnServer": "CategoryId",
          "validators": [{ "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "Discontinued",
          "validators": [{ "name": "required" }]
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "ProductName",
          "validators": [{ "name": "required" }]
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "QuantityPerUnit",
          "validators": []
        },
        {
          "dataType": "Int64",
          "isNullable": true,
          "nameOnServer": "ReorderLevel",
          "validators": [{ "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": true,
          "nameOnServer": "SupplierId",
          "validators": [{ "name": "int64" }]
        },
        {
          "dataType": "Binary",
          "isNullable": true,
          "nameOnServer": "UnitPrice",
          "validators": []
        },
        {
          "dataType": "Int64",
          "isNullable": true,
          "nameOnServer": "UnitsInStock",
          "validators": [{ "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": true,
          "nameOnServer": "UnitsOnOrder",
          "validators": [{ "name": "int64" }]
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "Category:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.Product_Northwind.Category_Category",
          "foreignKeyNamesOnServer": ["CategoryId"],
          "nameOnServer": "Category",
          "validators": []
        },
        {
          "entityTypeName": "OrderDetail:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.OrderDetail_Northwind.Product_Product",
          "invForeignKeyNamesOnServer": ["ProductId"],
          "nameOnServer": "OrderDetails",
          "validators": []
        },
        {
          "entityTypeName": "Supplier:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.Product_Northwind.Supplier_Supplier",
          "foreignKeyNamesOnServer": ["SupplierId"],
          "nameOnServer": "Supplier",
          "validators": []
        }
      ]
    },
    {
      "shortName": "Region",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "Regions",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "Regiondescription",
          "validators": [{ "name": "required" }]
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "Territory:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.Territory_Northwind.Region_Region",
          "invForeignKeyNamesOnServer": ["RegionId"],
          "nameOnServer": "Territories",
          "validators": []
        }
      ]
    },
    {
      "shortName": "SalesOrder",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "SalesOrders",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": false,
          "nameOnServer": "CustomerId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": true,
          "nameOnServer": "EmployeeId",
          "validators": [{ "name": "int64" }]
        },
        {
          "dataType": "Binary",
          "isNullable": true,
          "nameOnServer": "Freight",
          "validators": []
        },
        {
          "dataType": "Binary",
          "isNullable": true,
          "nameOnServer": "OrderDate",
          "validators": []
        },
        {
          "dataType": "Binary",
          "isNullable": true,
          "nameOnServer": "RequiredDate",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "ShipAddress",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "ShipCity",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "ShipCountry",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "ShipName",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "ShipPostalCode",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "ShipRegion",
          "validators": []
        },
        {
          "dataType": "Binary",
          "isNullable": true,
          "nameOnServer": "ShippedDate",
          "validators": []
        },
        {
          "dataType": "Int64",
          "isNullable": false,
          "nameOnServer": "ShipperId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "Customer:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.SalesOrder_Northwind.Customer_Customer",
          "foreignKeyNamesOnServer": ["CustomerId"],
          "nameOnServer": "Customer",
          "validators": []
        },
        {
          "entityTypeName": "OrderDetail:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.OrderDetail_Northwind.SalesOrder_Order",
          "invForeignKeyNamesOnServer": ["OrderId"],
          "nameOnServer": "OrderDetails",
          "validators": []
        },
        {
          "entityTypeName": "Shipper:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.SalesOrder_Northwind.Shipper_Shipper",
          "foreignKeyNamesOnServer": ["ShipperId"],
          "nameOnServer": "Shipper",
          "validators": []
        }
      ]
    },
    {
      "shortName": "Shipper",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "Shippers",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "CompanyName",
          "validators": [{ "name": "required" }]
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Phone",
          "validators": []
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "SalesOrder:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.SalesOrder_Northwind.Shipper_Shipper",
          "invForeignKeyNamesOnServer": ["ShipperId"],
          "nameOnServer": "SalesOrders",
          "validators": []
        }
      ]
    },
    {
      "shortName": "Supplier",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "Suppliers",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Address",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "City",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "CompanyName",
          "validators": [{ "name": "required" }]
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "ContactName",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "ContactTitle",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Country",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Email",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Fax",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "HomePage",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Phone",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "PostalCode",
          "validators": []
        },
        {
          "dataType": "String",
          "isNullable": true,
          "nameOnServer": "Region",
          "validators": []
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "Product:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.Product_Northwind.Supplier_Supplier",
          "invForeignKeyNamesOnServer": ["SupplierId"],
          "nameOnServer": "Products",
          "validators": []
        }
      ]
    },
    {
      "shortName": "Territory",
      "namespace": "Northwind",
      "autoGeneratedKeyType": "None",
      "defaultResourceName": "Territories",
      "isComplexType": false,
      "dataProperties": [
        {
          "dataType": "Int64",
          "isPartOfKey": true,
          "isNullable": false,
          "nameOnServer": "EntityId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "Int64",
          "isNullable": false,
          "nameOnServer": "RegionId",
          "validators": [{ "name": "required" }, { "name": "int64" }]
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "TerritoryCode",
          "validators": [{ "name": "required" }]
        },
        {
          "dataType": "String",
          "isNullable": false,
          "nameOnServer": "Territorydescription",
          "validators": [{ "name": "required" }]
        }
      ],
      "navigationProperties": [
        {
          "entityTypeName": "EmployeeTerritory:#Northwind",
          "isScalar": false,
          "associationName": "Northwind.EmployeeTerritory_Northwind.Territory_TerritoryCodeNavigation",
          "invForeignKeyNamesOnServer": ["TerritoryCode"],
          "nameOnServer": "EmployeeTerritories",
          "validators": []
        },
        {
          "entityTypeName": "Region:#Northwind",
          "isScalar": true,
          "associationName": "Northwind.Territory_Northwind.Region_Region",
          "foreignKeyNamesOnServer": ["RegionId"],
          "nameOnServer": "Region",
          "validators": []
        }
      ]
    }
  ]
}
;
}