[![Follow me on Twitter](https://img.shields.io/badge/twitter-grey.svg?style=for-the-badge&logo=twitter)](https://twitter.com/NeverSinkDev) [![FilterBlade Discord](https://img.shields.io/badge/discord-grey.svg?style=for-the-badge&logo=discord)](https://discord.gg/mye6xhF) [![Watch FB Dev on Twitch](https://img.shields.io/badge/twitch-grey.svg?style=for-the-badge&logo=twitch)](https://twitch.tv/neversink) [![Support development on Patreon](https://img.shields.io/badge/patreon-grey.svg?style=for-the-badge&logo=patreon)](https://www.patreon.com/Neversink)

## **QUICK START:**

This is an "ItemFilter" - a script for the game Path of Exile. It highlights valuable items, hide pointless drops and enhances gameplay comfort and experience.

This is *NOT* a hack/mod. It written using the official POE filter domain language. This script (NeverSink's Filter) is shipped on the console versions of the game.

Feature highlights
- Over 500 different rules that highlight and hide items based on usefulness and value.
- Covers both leveling and endgame and dynamically adjusts itself based on your area level
- Highlights valuable and useful leveling equipment.
- Highlights endgame crafting gear and special basetypes.
- Tiers every single unique, currency, divination card, fragment, scarab and 20+ other tierlists types based on the current meta and prices in the league economy
- Marks noteworthy drops on the minimap and gives items beams and sounds.
- Color-codes values and item types. Scroll down on *[filterblade.xyz](https://www.filterblade.xyz)* to learn the colorcoding.
- Has safety checks to not accidently hide new and unknown items from new leagues.
- Detects rare and special item properties such as synthesised items
- Highlights identified items with multiple good or exclusive mods.
- Comes in 7 different strictnesses, each hiding more items. Start with **SEMI-STRICT** if you're new. Increase the strictness as you become faster, stronger and more experienced and feel like the clutter is slowing you down. [STRICTNESSOVERVIEW](https://filterblade.xyz?strictness=1)
- Updated and finetuned every league since over 9 years.
- Comes in many different styles. Pick one based on playstyle, taste or visual impairment: [STYLEOVERVIEW](https://filterblade.xyz?styles=1)

We also developed: *[filterblade.xyz](https://www.filterblade.xyz)* specifically for this filter. A user-friendly and recommended way to download, install and preview (lootsimulator!) the filter. It allows you to finetune the filter as well, without any coding knowledge required.

The filter is and always will be completely free! The only paid feature we offer is the: 3$/month for the [auto-update service](https://www.youtube.com/watch?v=i8RJx0s0zsA) to support the development of NeverSink's filter and help pay for the FilterBlade server costs.

## **IMPORTANT: MUST READ:**

1) The filters in this GitHub project are ALWAYS updated before the start of a new league (4-6 hours before start). Afterwards, usually every few weeks.
2) The filters from this GitHub project do NOT auto-update. At least redownload the latest version once a league - better once a month - to stay up-to-date and not miss out on valuable drops! There is an auto-updater, read about it below.
3) Filters can't distinguish between different variations of one unique base! A unique "Leather Belt" can be an expensive "Headhunter" or a cheap "Wurm's Molt". The same goes for all unique jewels etc. Things that need manual checking usually have a blue icon on the minimap!
4) The filter has a "leveling mode" and an "endgame mode". The switch happens at itemlevel 68.
5) Join our [Discord Server](https://discord.gg/mye6xhF) to get updates and ask questions.

## **HOW TO INSTALL?**

Currently there are multiple sources:

- [FILTER LADDER](https://www.pathofexile.com/item-filter/ladder/follower) - Are you new to the game and don't care about styles and finetuning the filter to your gameplay experience? I recommend subscribing to my filters on the ladder. It's just a click, fast and auto-updates. Just restart the game and select the subscribed filter in the options menu. The downside is that you can't edit these filters or use styles. Once you're more experienced consider:
- *[FILTERBLADE](https://www.filterblade.xyz)* - you can adjust the filter to your preferences here, change the appearance, style and finetune everything to your liking.
    - [FilterBlade Update Guide](https://www.youtube.com/watch?v=RA27aUdWQb8)
    - We also offer a [FilterBlade Auto-Updater](https://www.youtube.com/watch?v=i8RJx0s0zsA), it's super comfy and you don't have to install anything, but heavy on our servers, so it costs a few bucks. Plus you support the project.
- You can also download the latest release from github. Note that it doesn't auto-update though and unlike my filterblade/ladder is not adjusted every 4 hours to match the economy perfectly. 

Manual installation instructions:

0) Get the latest filter file from  *[filterblade.xyz](https://www.filterblade.xyz)* or [GitHub](https://github.com/NeverSinkDev/NeverSink-Filter/releases/latest).
1) Extract the files using 7zip or a similar tool.
2) Paste the .filter files (or just the folder content, if you want to use a specific style, paste the files from one of the (STYLE) folders instead) into the following folder: *%userprofile%/Documents/My Games/Path of Exile*
3) INGAME: Escape -> Options -> Game -> Filters -> Select one of the filters from the dropdown box.
4) Done. Enjoy.

## **SUPPORT:**

The filter itself will always be free, including updates.

Major thanks to all patreon support to help us fund the continious development. [Patreon](https://www.patreon.com/Neversink) supporters also receive a Patreon-exclusive [Filter-Auto-Updater](https://youtu.be/i8RJx0s0zsA). You can also [buy me a beer](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=6J3S7PBNDQGY2). Your support is appreciated. Thank you!

## **PICKING A STRICTNESS:**

The strictness defines what items are shown or hidden. A higher strictness means less items will be shown. I recommend using the **SEMI-STRICT** version if you're just starting. The hidden items are always the the cheapest layer. You don't have to worry about expensive drops, these are always shown.

Path of Exile is a game, where speed matters a lot. Every time you pick up an item - you slow down. You also need to potentially identify, sort, sell and manage the item. As your character becomes more and more optimized, it's a much better strategy to focus on clearing fast and only pick up the best items. This way you get more experience, less stash-sorting and more chances for big drops!

The filter strictness setup is designed to reflect that philosophy. You can start with regular/semi-strict and just increase your strictness as you improve your build. Alternatively if you feel like farming slow content, just go down a strictness.

*[Filterblade.xyz](https://www.filterblade.xyz)* allows finetuning the strictness of the filter. You can also **[[preview all strictnesses to understand what these exactly do](https://filterblade.xyz?strictness=1)]**.
## **STYLE VARIATIONS:**

Different styles have the same filtering pattern, but have altered visual appearance. You can **[[preview all styles on FilterBlade](https://filterblade.xyz?styles=1)]**. As a beginner do not use the following styles: Krangled, WoW, Tabula Rasa.

The **CUSTOMSOUNDS** style is special: Same visuals, but all sounds are different. Designed for streamers or viewers so that they don't get confused when the other side is getting an expensive drop. You can also replace the sound files with your own files (filterblade offers streamer-sound packs and tools to assist you with custom soundpacks)

--------------------------

[![Become a Patreon](https://img.shields.io/badge/patreon-%F0%9F%8E%AF-orange.svg)](https://www.patreon.com/Neversink)
