% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step.R
\name{step}
\alias{step}
\title{Assign a step to the flow}
\usage{
step(
  flow,
  ...,
  step,
  r_function = NULL,
  foreach = NULL,
  join = FALSE,
  next_step = NULL
)
}
\arguments{
\item{flow}{metaflow object}

\item{...}{decorators}

\item{step}{character name for the step. Step names must be valid Python
identifiers; they can contain letters, numbers, and underscores, although
they cannot begin with a number.}

\item{r_function}{R function to execute as part of this step}

\item{foreach}{optional input variable to iterate over as input to next step}

\item{join}{optional logical (defaults to FALSE) denoting whether the step is
a join step}

\item{next_step}{list of step names to execute after this step is executed}
}
\description{
Assign a step to the flow
}
\section{Usage}{

\preformatted{
step(flow, step = "start", r_function = start, next_step = "b")
step(flow, decorator("batch"), step = "start",
   r_function = start, next_step = "a", foreach = "parameters")
step(flow, step = "start", r_function = start, next_step = c("a", "b"))
step(flow, step = "c", r_function = c, next_step = "d", join = TRUE)
}
}

