% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorators-errors.R
\name{retry}
\alias{retry}
\title{Decorator that configures a step to retry upon failure}
\usage{
retry(times = 3L, minutes_between_retries = 2L)
}
\arguments{
\item{times}{Integer number of times to retry this step. Defaults to \code{3}. Set
this to \code{0} to forbid a step from retrying at all. This may be useful
when a step is not idempotent, and could have undesirable side-effects if
retried.}

\item{minutes_between_retries}{Integer Number of minutes between retries.
Defaults to \code{2}.}
}
\value{
A object of class "decorator"
}
\description{
Use this decorator to configure a step to retry if it fails. Alternatively,
retry \emph{any} failing steps in an entire flow with \verb{run(with = c("retry")}.

See \url{https://docs.metaflow.org/v/r/metaflow/failures} for more
information on how to use this decorator.
}
\examples{
\dontrun{
# Set up a step that fails 50\% of the time, and retries it up to 3 times
# until it succeeds
start <- function(self){
  n <- rbinom(n=1, size=1, prob=0.5)
  if (n==0){
    stop("Bad Luck!") 
  } else{
    print("Lucky you!")
  }
}

end <- function(self){
  print("Phew!")
}

metaflow("RetryFlow") \%>\%
  step(step="start", 
       retry(times=3),
       r_function=start, 
       next_step="end") \%>\%
  step(step="end", 
       r_function=end) \%>\% 
  run()
}
}
